"
GsSignalingSocket provides the means for creating and binding TCP sockets through the 
operating system of the machine that is running the session's Gem process, and for 
communicating across those sockets. 

While GsSocket returns nil when a socket operation fails, GsSignalingSocket signals 
Errors, primarily instances of SocketError.

Methods that block GemStone Smalltalk until the socket operation completes are 
interruptable by a hard break.  (You can get a hard break in Topaz by pressing the 
control-C key twice.  You can get a hard break in GemBuilder for C by calling the 
GciHardBreak function, and in GemBuilder for Smalltalk by calling the corresponding 
hard break method.)

Instances of GsSignalingSocket automatically have their C state (including their file 
descriptor) closed when the instance is garbage collected or when a persistent instance 
drops out of memory.

                              Warning:
    Do not retain an instance of GsSignalingSocket from one session to another.
    Instances of GsSocket are intended to exist only within a given GemStone
    session.  GsSockets that are used across sessions always generate an error.

All instVars of GsSignalingSocket are private, for use by the implementation of socket 
methods, and for use by the ProcessorScheduler only.

Constraints:
	fileDescriptor: SmallInteger
	lineNumber: SmallInteger
	readWaiters: Object
	writeWaiters: Object
	readyEvents: SmallInteger
	pollArrayOfs: SmallInteger
	interrupting: Boolean
"
Class {
	#name : 'GsSignalingSocket',
	#superclass : 'GsSocket',
	#classVars : [
		'OOB_SIGNAL_ABORT',
		'OOB_SIGNAL_COMMITTED_OBJS',
		'OOB_SIGNAL_FROM_GEM',
		'OOB_SIGNAL_GC_FINALIZE'
	],
	#gs_reservedoop : '249601',
	#category : nil
}
