"
KeyValueDictionary is a concrete subclass of AbstractDictionary.  In a
 KeyValueDictionary, keys may be of mixed classes.

 A KeyValueDictionary stores key-value pairs under an index that is generated by
 applying a hash function to the key; it does not use Associations.  The hashing
 improves retrieval speed.  However, you must observe an important restriction:
 after a key/value pair has been added to a KeyValueDictionary, you must not
 modify the key.  Doing so renders the value inaccessible.

 A KeyValueDictionary is also an equality-based collection.  That is, two keys
 or two values are considered to be the same if they are equivalent; they need
 not be identical to be the same.  Thus, if you add two key-value pairs to a
 KeyValueDictionary but the keys are equivalent, even if they are not identical,
 then the result is that the second pair overwrites the first one, because the
 keys are the same.

 Some other kinds of dictionaries are identity-based rather than equality-based.
 These other kinds of dictionaries exhibit better performance than
 KeyValueDictionary and are to be preferred where they are appropriate.

 For multiuser applications that involve a lot of concurrent use of
 dictionaries, use RcKeyValueDictionary.

Constraints:
	numElements: SmallInteger
	numCollisions: SmallInteger
	collisionLimit: SmallInteger
	tableSize: SmallInteger

--- instVar collisionLimit
A SmallInteger that represents the number of collisions allowed before
 rebuilding the hash table.

--- instVar numCollisions
A SmallInteger that represents the cumulative number of collisions that have
 occurred during the addition of the elements to the dictionary since the last
 rebuild.

--- instVar numElements
A SmallInteger that represents the number of key/value pairs in the
 dictionary.

--- instVar tableSize
A SmallInteger that represents the size of the primary hash table.

"
Class {
	#name : 'KeyValueDictionary',
	#superclass : 'AbstractDictionary',
	#instVars : [
		'numElements',
		'numCollisions',
		'collisionLimit',
		'tableSize'
	],
	#gs_reservedoop : '79361',
	#category : nil
}
