"

ObjectsCommittedNotification is signaled by the virtual machine when an
object in your notify set has been modified. For example:
	| assoc |
	UserGlobals at: #temp put: (assoc := Association new).
	System commitTransaction; enableSignaledObjectsError; addToNotifySet: assoc.
	ObjectsCommittedNotification addDefaultHandler: [:ex | ex halt].
	assoc key: 42.
	System commitTransaction.
	(Delay forSeconds: 1) wait.

  For notify set management see 
     System class >> addAllToNotifySet:
     System class >> addToNotifySet:
     System class >> clearNotifySet
     System class >> notifySet
     System class >> removeAllFromNotifySet:
     System class >> removeFromNotifySet:

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object

"
Class {
	#name : 'ObjectsCommittedNotification',
	#superclass : 'Notification',
	#gs_reservedoop : '151553',
	#category : nil
}
