"

 ProcessorScheduler implements a green-threads scheduler for instances of
 GsProcess.  The processes all share one native thread in the virtual
 machine.  There is exactly one instance of ProcessorScheduler in a session;
 this instance is initialized by the virtual machine and may not be
 committed to disk .

 InstVars:
   activeProcess - currently active process.
   readyQueue - a SortedCollection of processes ready to run.

   delayQueue - a SortedCollection of objects with signalTime not yet expired,
		  elements are instances of either Delay or GsProcess .
   lastGroup  -  a SmallInteger
   suspendedSet - IdentitySet of suspended processes
   waitingSet  -  IdentitySet of processes waiting for objects to be ready

   socketsPolled - an Array maintained/used by primitives,
		   the list of GsSockets upon which processes are waiting .
   pollResults - an Array used by the polling primitive.
   timeoutThreadActive - a Boolean
   criticalMethods  - used by in-vm debugging support

 A process can be in one of these states:
    active  		- the activeProcess
    ready to run 	  - in the readyQueue
    waiting on a GsSocket - in the waitingSet , and a socket in socketsPolled
    waiting on a Semaphore - in the waitingSet
    waiting on a Delay    - in delayQueue or referenced from a Delay in delayQueue
    suspended		- in the suspendedSet

  Process state               onQueue             waitingOn
    0 active                    nil		     nil
    1 ready to run              readyQueue           nil
    2 waiting on a GsSocket     waitingSet 	    a GsSocket
    3 waiting on a Semaphore    waitingSet 	    a Semaphore
    4 waiting on a Delay    -   waitingSet 	    Delay or nil
    5 ref from a waiting Delay  ??waitingSet 	    a Delay
    6 suspended         -       suspendedSet         any

 If a process waiting on a socket is suspended
 it will be woken up by activity on the socket.

 If a process waiting on a Semaphore is suspended,
 it will be woken up by signaling the semaphore .

 If a process is waiting on a Delay,
 it will be woken up when Delay expires.

 GsProcess>>suspend has no effect unless receiver is running or in the readyQueue .

 GsProcess>>terminate removes receiver from any thing it is waiting on.

 A Delay has one target, a GsProcess or a Semaphore .

 The method compiler omits check interrupt bytecodes that would otherwise be 
 generated when compiling an instance method in ProcessorScheduler.
 Interrupt check on backwards branches are generated in those instance methods.

Constraints:
	readyQueue: SortedCollection
	activeProcess: GsProcess
	pollResults: Array
	delayQueue: SortedCollection
	lastGroup: SmallInteger
	suspendedSet: Object
	waitingSet: Object
	socketsPolled: Array
	timeoutThreadActive: Boolean
	criticalMethods: IdentitySet

"
Class {
	#name : 'ProcessorScheduler',
	#superclass : 'Object',
	#instVars : [
		'readyQueue',
		'activeProcess',
		'pollResults',
		'delayQueue',
		'lastGroup',
		'suspendedSet',
		'waitingSet',
		'socketsPolled',
		'timeoutThreadActive',
		'criticalMethods'
	],
	#gs_options : [
		'disallowGciStore',
		'instancesNonPersistent'
	],
	#gs_reservedoop : '116481',
	#category : nil
}
