"
SmallScaledDecimal is used to represent ScaledDecimals
 that have scale <= 31 and  mantissa in the range -1125899906842624..1125899906842623 .

 The bit format of an instances is
   mmmmmmmm|mmmmmmmm|mmmmmmmm|mmmmmmmm|mmmmmmmm|mmmmmmmm|mmmsssss|00110100
    bits m  51 bit signed integer mantissa
         s   5 bit unsigned scale.

 As scale increases, the maximum value representable by a SmallScaledDecimal decreases.
 The maximum value representable for a given scale is approxmately
 1125899906842623.0 / (10 raisedTo: scale) .
"
Class {
	#name : 'SmallScaledDecimal',
	#superclass : 'ScaledDecimal',
	#type : 'immediate',
	#gs_options : [
		'instancesInvariant',
		'selfCanBeSpecial',
		'subclassesDisallowed'
	],
	#gs_reservedoop : '159233',
	#category : nil
}
