"
Instances of class String are indexed collections of Characters.

 Comparing strings:
 Unless noted otherwise, comparisons between Strings are case-sensitive.

 Some of these methods determine whether one String collates before
 another.  In collation, the ASCII values of the receiver and aString are
 compared Character-by-Character, from left to right, in case-sensitive
 fashion.  If two Strings are of different length, and all Characters in the
 shorter String are equal to their counterparts in the longer String, the
 shorter String collates before the longer.

 Converting Strings:
 Separator Characters in a String are used to define white space that separates
 words or substrings within the String from each other.  These separators are
 used in conversion to break the String into its logical substrings.  Separator
 Characters are defined as those Characters for which the
 Character>>isSeparator method returns true.

 Storing a codePoint > 16rFF into a String will cause that object to
 change class to Unicode16 if  (Unicode16 _unicodeCompareEnabled == true)
 or to change class to DoubleByteString if (Unicode16 _unicodeCompareEnabled == false).
"
Class {
	#name : 'String',
	#superclass : 'CharacterCollection',
	#type : 'byteSubclass',
	#gs_reservedoop : '74753',
	#category : nil
}
