"
A Symbol is an invariant String for which all comparisons are case-sensitive.
 Symbols are used internally to represent variable names and selectors.  Symbols
 are always invariant and cannot be modified at any time after they are created.
 Hence, the new and new: methods are disallowed.

 All Symbols and DoubleByteSymbols are canonical, which means that it is not
 possible to create two of them that have the same value.  If two canonical
 symbols compare as equal, then they are the same (identical) object.  Every
 instance of DoubleByteSymbol will contain at least one Character whose value is
 greater than 255.  A Symbol whose Character values are all less than 256 is
 always an instance of Symbol.

 GemStone places all canonical symbols in the DataCuratorObjectSecurityPolicy.  However,
 GemStone does permit you to commit a canonical Symbol, even if you have no
 explicit write authorization for the DataCuratorObjectSecurityPolicy.  GemStone also gathers
 all canonical symbols into one collection (a CanonicalStringDictionary) called
 AllSymbols, which it also places in the DataCuratorObjectSecurityPolicy.

 Since canonical symbols are universally visible, it is not recommended that
 they be used for names that should remain private or secure.  Such objects
 should be instances of InvariantString instead.

 Since canonical symbols must be universally available, you cannot lock a
 Symbol, DoubleByteSymbol, or QuadByteSymbol..

 Since each canonical symbol has a unique value, you cannot copy a Symbol or
 DoubleByteSymbol.  In addition, to guarantee canonicalization, you cannot send
 the become: or changeClassTo: messages to a Symbol, DoubleByteSymbol, or
 QuadByteSymbol..

 DoubleByteSymbol is in the ClassHistory of Symbol, so instances of
 DoubleByteSymbol may be stored into instance variables that are constrained to
 hold instances of Symbol.  The inverse is not true, so you should always
 express symbol constraints as Symbol.

 EUCSymbols are not canonicalized and cannot be used interchangeably with
 canonical symbols.  They do not satisfy a constraint of Symbol, and are not
 accepted by the virtual machine as message selectors.
"
Class {
	#name : 'Symbol',
	#superclass : 'String',
	#gs_options : [
		'subclassesDisallowed'
	],
	#gs_reservedoop : '110849',
	#category : nil
}
