"
An instance of Unicode16 is a DoubleByteString in which all
Utf16 codePoints are representable using 16 bits.
For every codePoint cp in a Unicode16 the following evaluates to true:
   (cp >= 0 and:[ cp <= 16rD7FF ])
     or:[ cp >= 16rE000 and:[ cp <= 16rFFFF ]]
Storing a code point > 16rFFFF into a Unicode16 will cause that
object to change class to Unicode32.

String comparision controlled by (Globals at:#StringConfiguration)

  Some definitions
    Legacy strings are kinds of String or MultiByteString, but not
    kinds of Unicode7, Unicode16, nor Unicode32 .
    Unicode strings are kinds of Unicode7, Unicode16, or Unicode32

  The default is
     (Globals at: #StringConfiguration) == String
  In this mode String and MultiByteString have legacy comparison behavior.
  Comparison between legacy strings and Unicode strings will signal errors.
  Unicode strings will compare to Unicode strings using specified
  or default instances of IcuCollator.

  If at login the repository has
    (Globals at: #StringConfiguration) == Unicode16
  then legacy and Unicode strings will all compare using Unicode
  semantics using specified or default instances of IcuCollator.
  This is accomplished by installing different comparision methods
  in the transient method dictionaries for the string classes at
  session login.  See classmethods in Unicode16 for details
  of how the transient method dictionaries are initialized.
  You can observe what comparison methods are installed
  buy doing a method lookup.  For example using topaz:
   login
   obj StringConfiguration
   set class String
   look method =
   !observe String>>= implementation using primitive 27

   ! override the default StringConfiguration in this session only
   send Unicode16 _useUnicodeComparePrimitives: true

   look meth =
   !observe String>>_unicodeEqual: implementation
   logout

"
Class {
	#name : 'Unicode16',
	#superclass : 'DoubleByteString',
	#gs_options : [
		'2byteWords'
	],
	#gs_reservedoop : '154625',
	#category : nil
}
