"
The class UserSecurityData implements only GemStone internals.  That is, it
provides only functionality required by GemStone itself.  It is not intended
for customer use, by creating instances or by subclassing.
Constraints:
	password: ByteArray
	lastLoginTime: DateTime
	lastPasswordChange: DateTime
	activeUserIdLimit: SmallInteger
	loginsAllowedBeforeExpiration: SmallInteger
	reasonForDisabledAccount: String
	oldPasswords: Array
	readOnly: Boolean
	authenticationScheme: SmallInteger
	authenticationUserId: String
	ldapSearchFilter: String
	passwordNeverExpires: Boolean
	ldapBaseDn: String
	passwordAgeLimit: SmallInteger
	passwordAgeWarning: SmallInteger
	staleAccountAgeLimit: SmallInteger
	salt: ByteArray
	usedVerifiers: Array
	usedSalts: Array
        onetimePasswordWhitelist: IdentitySet
"
Class {
	#name : 'UserSecurityData',
	#superclass : 'Object',
	#instVars : [
		'password',
		'lastLoginTime',
		'lastPasswordChange',
		'activeUserIdLimit',
		'loginsAllowedBeforeExpiration',
		'reasonForDisabledAccount',
		'oldPasswords',
		'readOnly',
		'authenticationScheme',
		'authenticationUserId',
		'ldapSearchFilter',
		'passwordNeverExpires',
		'ldapBaseDn',
		'passwordAgeLimit',
		'passwordAgeWarning',
		'staleAccountAgeLimit',
		'salt',
		'usedVerifiers',
		'usedSalts',
		'bitFlags',
		'performOnServerWhitelist',
		'onetimePasswordWhitelist'
	],
	#gs_options : [
		'disallowGciStore'
	],
	#gs_reservedoop : '112385',
	#category : nil
}
