Class {
	#name : 'GsUnmanagedClassReport',
	#superclass : 'GsAbstractUnmanagedReport',
	#category : 'GemStone-Rowan-Tools'
}

{ #category : 'enumerating' }
GsUnmanagedClassReport >> unmanagedClassesDo: aBlock [
	| unpackagedName |
	unpackagedName := Rowan unpackagedName.
	(self at: 'classDetails')
		keysAndValuesDo: [ :className :classDetails | 
			(classDetails at: 'packageName') = unpackagedName
				ifTrue: [ aBlock cull: classDetails ] ]
]

{ #category : 'enumerating' }
GsUnmanagedClassReport >> unmanagedMethodsDo: aBlock [
	| unpackagedName |
	unpackagedName := Rowan unpackagedName.
	(self at: 'classDetails')
		keysAndValuesDo: [ :className :classDetails | 
			(classDetails at: 'instanceMethodDetails')
				keysAndValuesDo: [ :methodSelector :methodDetails | 
					(methodDetails at: 'method') isFromTrait
						ifFalse: [ 
							"isFromTrait methods are EXPECTED to be unpackaged"
							(methodDetails at: 'packageName') = unpackagedName
								ifTrue: [ aBlock cull: methodDetails cull: classDetails ] ] ].
			(classDetails at: 'classMethodDetails')
				keysAndValuesDo: [ :methodSelector :methodDetails | 
					(methodDetails at: 'method') isFromTrait
						ifFalse: [ 
							"isFromTrait methods are EXPECTED to be unpackaged"
							(methodDetails at: 'packageName') = unpackagedName
								ifTrue: [ aBlock cull: methodDetails cull: classDetails ] ] ] ]
]
