Class {
	#name : 'GsRowanImageTool',
	#superclass : 'GemStoneRowanTool',
	#category : 'GemStone-Rowan-Tools'
}

{ #category : 'bootstrap' }
GsRowanImageTool >> adoptGemStone64: specUrl diskUrl: diskUrl projectsHome: projectsHome [

	self adoptGemStone64: specUrl diskUrl: diskUrl projectsHome: projectsHome forUpgrade: false

]

{ #category : 'bootstrap' }
GsRowanImageTool >> adoptGemStone64: specUrl diskUrl: diskUrl projectsHome: projectsHome forUpgrade: forUpgrade [
	"
	Create loaded project (if needed), traverse the package definitions and 
		create loaded packages for each.
	"

	| tracer wasTracing |
	tracer := Rowan projectTools trace.
	wasTracing := tracer isTracing.
	tracer startTracing.

	[ 
	Rowan projectTools adopt
		adoptProjectFromUrl: specUrl
		diskUrl: diskUrl
		projectsHome: projectsHome ]
		on: RwAuditMethodErrorNotification
		do: [ :ex | 
			(ex description = 'Missing loaded method' and: [ forUpgrade ])
				ifTrue: [ 
					| theBehavior |
					"missing loaded method during upgrade, means the method is no longer
						part of image, or was added by end user. Remove the method, for now"
					tracer trace: 'Removing method ' , ex methodPrintString.
					theBehavior := Rowan globalNamed: ex className.
					ex isMetaclass
						ifTrue: [ theBehavior := theBehavior class ].
					theBehavior removeSelector: ex selector.
					ex resume: false	"no audit error" ]
				ifFalse: [ 
					"issue audit error"
					ex resume: true ] ].
	System commit
]

{ #category : 'bootstrap' }
GsRowanImageTool >> createAndPopulateUnPackagedPackage: forUpgrade [
	"
	Then package the unpackaged classes an methods into an unpackaged
		package so that the ENTIRE image is packaged. The UnPackaged 
		should be empty at the end of slow filein ... upgradeImage will be
		expected to manage the UnPackaged package differently.
	"

	| project packagePrefix componentName loadedProject unpackagedName adoptTool userName tracer wasTracing symbolList ignoredSymbolDicts |
	tracer := Rowan projectTools trace.
	wasTracing := tracer isTracing.
	tracer startTracing.

	project := Rowan newProjectNamed: Rowan unpackagedProjectName.
	componentName := Rowan unpackagedProjectName.
	project
		packageConvention: 'Rowan';
		addLoadComponentNamed: componentName.
	packagePrefix := Rowan unpackagedPackagePrefix.
	userName := System myUserProfile userId.
	symbolList := Rowan image symbolList.
	ignoredSymbolDicts := (UserGlobals
		at: #'PACKAGE_OBSOLETE_COMPILER_CLASSES'
		ifAbsent: [ false ])
		ifTrue: [ #(#'GemStone_Portable_Streams' #'GemStone_Legacy_Streams') ]
		ifFalse: [ #(#'GemStone_Portable_Streams' #'GemStone_Legacy_Streams' #'ObsoleteClasses' #'GsCompilerClasses') ].
	symbolList
		do: [ :symbolDictionary | 
			(ignoredSymbolDicts includes: symbolDictionary name)
				ifTrue: [ 
					tracer
						trace: '---Ignoring Unpackaged symbol dictionary ' , symbolDictionary name ]
				ifFalse: [ 
					| thePackageName |
					"create unpackaged packages for each symbol dictionary"
					thePackageName := packagePrefix , symbolDictionary name asString.
					tracer
						trace: '---Creating Unpackaged package ' , thePackageName printString.
					project
						packageNamed: thePackageName
						ifAbsent: [ 
							project
								addPackageNamed: thePackageName
								toComponentNamed: componentName
								gemstoneDefaultSymbolDictionaryForUser:
									userName -> symbolDictionary name asString ] ] ].
	System commit.
	loadedProject := project load projectNamed: project projectName.	"load the projec"
	System commit.
	unpackagedName := Rowan unpackagedName.
	adoptTool := Rowan packageTools adopt.
	Rowan image symbolList
		do: [ :symbolDictionary | 
			(ignoredSymbolDicts includes: symbolDictionary name)
				ifFalse: [ 
					| thePackage thePackageName |
					thePackageName := packagePrefix , symbolDictionary name asString.
					thePackage := project packageNamed: thePackageName.
					tracer
						trace:
							'---Adopting Unpackaged classes and methods for package '
								, thePackageName printString.
					self
						_classesIn: symbolDictionary
						do: [ :aClass | 
							aClass rowanProjectName = unpackagedName
								ifTrue: [ 
									tracer trace: '	Unpackaged Class ' , aClass name asString printString.
									adoptTool adoptClass: aClass intoPackageNamed: thePackageName ]
								ifFalse: [ 
									| instanceSelectors classSelectors unpackageMethods |
									instanceSelectors := Set new.
									classSelectors := Set new.
									unpackageMethods := false.
									aClass
										methodsDo: [ :selector :method | 
											(method isFromTrait not and: [ method rowanProjectName = unpackagedName ])
												ifTrue: [ 
													tracer
														trace:
															'	Unpackaged method ' , aClass name asString , ' >> ' , selector printString.
													instanceSelectors add: selector.
													unpackageMethods := true ] ].
									aClass class
										methodsDo: [ :selector :method | 
											(method isFromTrait not and: [ method rowanProjectName = unpackagedName ])
												ifTrue: [ 
													tracer
														trace:
															'	Unpackaged method ' , aClass name asString , ' class >> '
																, selector printString.
													classSelectors add: selector.
													unpackageMethods := true ] ].
									unpackageMethods
										ifTrue: [ 
											adoptTool
												adoptClassExtension: aClass
												instanceSelectors: instanceSelectors
												classSelectors: classSelectors
												intoPackageNamed: thePackageName ] ] ].
					System commit ] ].
	wasTracing
		ifFalse: [ tracer stopTracing ]
]

{ #category : 'packages' }
GsRowanImageTool >> readRewriteGemStone64Packages: archBase [
	"
		Rowan gemstoneTools image readRewriteGemStone64Packages: '/home/dhenrich/work/j_36x/'
	"

	| repositoryRoot platformConditionalAttributes customConditionalAttributes specUrl loadSpec resolvedProject |
	SessionTemps current at: #'ROWAN_TRACE' put: nil.	"#gciLogServer "
	repositoryRoot := archBase , '/image'.

	platformConditionalAttributes := {'common'.
	'gemstone'}.
	customConditionalAttributes := {'bootstraponly'}.

	specUrl := repositoryRoot asFileReference / 'rowan' / 'specs'
		/ 'GemStone64.ston'.
	(loadSpec := RwSpecification fromUrl: 'file:' , specUrl pathString)
		projectsHome: repositoryRoot;
		diskUrl: 'file:' , repositoryRoot;
		yourself.
	resolvedProject := loadSpec resolveProject.

	[ resolvedProject read: customConditionalAttributes platformConditionalAttributes: platformConditionalAttributes ]
		on: CompileWarning
		do: [ :ex | 
			| str |
			((str := ex asString) includesString: 'not optimized')
				ifTrue: [ ex resume ]
				ifFalse: [ 
					GsFile gciLogServer: str.
					ex pass ] ].

	resolvedProject packages
		do: [ :packageDef | 
			| classExtensions |
			"merge class extensions into class definitions and remove class dextension"
			classExtensions := packageDef classExtensions.
			packageDef classDefinitions
				do: [ :classDef | 
					classExtensions
						at: classDef name
						ifPresent: [ :classExtension | 
							classExtension instanceMethodDefinitions
								do: [ :meth | classDef addInstanceMethodDefinition: meth ].
							classExtension classMethodDefinitions
								do: [ :meth | classDef addClassMethodDefinition: meth ].
							packageDef removeClassExtensionDefinition: classExtension ] ] ].

	resolvedProject exportPackages
]
