"
Parses strings conforming to CidrGrammar into instances of Cidr.
"
Class {
	#name : 'CidrParser',
	#superclass : 'CidrGrammar',
	#category : 'X509-Core'
}

{ #category : 'productions' }
CidrParser >> cidr [

	^super cidr map: [:ip :slash :mask | Cidr ip: ip mask: mask]
]

{ #category : 'productions' }
CidrParser >> ipAddress [

	^super ipAddress map: 
			[:byte1 :dot1 :byte2 :dot2 :byte3 :dot3 :byte4 |
			(byte1 bitShift: 24) + (byte2 bitShift: 16) + (byte3 bitShift: 8) + byte4]
]

{ #category : 'productions' }
CidrParser >> maskNumber [

	^self number ==> 
			[:value |
			value <= 32
				ifTrue: [value]
				ifFalse: 
					[PPFailure message: value printString
								, ' is not a valid value for an mask. Legal values are 0 through 32.']]
]

{ #category : 'productions' }
CidrParser >> number [

	^super number flatten ==> [:string | string asNumber]
]

{ #category : 'productions' }
CidrParser >> octetNumber [

	^self number ==> 
			[:value |
			value <= 255
				ifTrue: [value]
				ifFalse: 
					[PPFailure message: value printString
								, ' is not a valid value for an octet. Legal values are 0 through 255.']]
]
