"
No class-specific documentation for LibSsl, hierarchy is: 
Object
  LibSsl

"
Class {
	#name : 'LibSsl',
	#superclass : 'Object',
	#classVars : Array [
          'FunctionSSL_get_fd',
          'FunctionSSL_get_error',
          'FunctionSSL_get1_peer_certificate',
          'FunctionSSL_get_SSL_CTX',
          'FunctionTLS_server_method'
	],
	#category : 'X509-HostAgent'
}

{ #category : 'Initializing - private' }
LibSsl class >> initialize [
	| library |
	library := nil.
	"library := CLibrary named: '/daytank1/users/mmcclure/prefix/lib/libssl.so.1.1'."
	self
                initializeFunction_SSL_get_SSL_CTX_inLibrary: library;
                initializeFunction_SSL_get_error_inLibrary: library;
                initializeFunction_SSL_get_fd_inLibrary: library;
                initializeFunction_SSL_get1_peer_certificate_inLibrary: library;
                initializeFunction_TLS_server_method_inLibrary: library;
		yourself.
]

{ #category : 'Initializing - private' }
LibSsl class >> initializeFunction_SSL_get_SSL_CTX_inLibrary: cLibrary [

        FunctionSSL_get_SSL_CTX := CCallout
                library: cLibrary
                name: 'SSL_get_SSL_CTX'
                result: #'ptr'
                args: #(#'ptr')
                varArgsAfter: -1.

]
{ #category : 'Functions' }
LibSsl >> SSL_get_SSL_CTX_: ssl [
        "/daytank1/users/mmcclure/prefix/include/openssl/ssl.h line 1709
__owur SSL_CTX *SSL_get_SSL_CTX(const SSL *ssl);"

        "Interpreted as #ptr from #( #'ptr' )"

        ^FunctionSSL_get_SSL_CTX callWith: { ssl }

]

{ #category : 'Initializing - private' }
LibSsl class >> initializeFunction_TLS_server_method_inLibrary: cLibrary [

        FunctionTLS_server_method := CCallout
                library: cLibrary
                name: 'TLS_server_method'
                result: #'ptr'
                args: #()
                varArgsAfter: -1.

]
{ #category : 'Functions' }
LibSsl >> TLS_server_method [
        "/daytank1/users/mmcclure/prefix/include/openssl/ssl.h line 1608
__owur const SSL_METHOD *TLS_server_method(void);"

        "Interpreted as #ptr from #( )"

        ^FunctionTLS_server_method callWith: {  }

]

{ #category : 'Initializing - private' }
LibSsl class >> initializeFunction_SSL_get_error_inLibrary: cLibrary [

        FunctionSSL_get_error := CCallout
                library: cLibrary
                name: 'SSL_get_error'
                result: #'int32'
                args: #(#'ptr' #'int32')
                varArgsAfter: -1.

]

{ #category : 'Functions' }
LibSsl >> SSL_get_error_: s _: ret_code [
        "/daytank1/users/mmcclure/prefix/include/openssl/ssl.h line 1590
__owur int SSL_get_error(const SSL *s, int ret_code);"

        "Interpreted as #int32 from #( #'ptr' #'int32' )"

        ^FunctionSSL_get_error callWith: { s. ret_code }

]

{ #category : 'Initializing - private' }
LibSsl class >> initializeFunction_SSL_get1_peer_certificate_inLibrary: cLibrary [

        FunctionSSL_get1_peer_certificate := CCallout
                library: cLibrary
                name: 'SSL_get1_peer_certificate'
                result: #'ptr'
                args: #(#'ptr')
                varArgsAfter: -1.

]
{ #category : 'Functions' }
LibSsl >> SSL_get1_peer_certificate_: s [
        "/daytank1/users/mmcclure/prefix/include/openssl/ssl.h line 1457
__owur X509 *SSL_get1_peer_certificate(const SSL *s);"

        "Interpreted as #ptr from #( #'ptr' )"

        ^FunctionSSL_get1_peer_certificate callWith: { s }

]

{ #category : 'Initializing - private' }
LibSsl class >> initializeFunction_SSL_get_fd_inLibrary: cLibrary [

        FunctionSSL_get_fd := CCallout
                library: cLibrary
                name: 'SSL_get_fd'
                result: #'int32'
                args: #(#'ptr')
                varArgsAfter: -1.

]
{ #category : 'Functions' }
LibSsl >> SSL_get_fd_: s [
        "/daytank1/users/mmcclure/prefix/include/openssl/ssl.h line 1342
__owur int SSL_get_fd(const SSL *s);"

        "Interpreted as #int32 from #( #'ptr' )"

        ^FunctionSSL_get_fd callWith: { s }

]

