!=========================================================================
! Copyright (C) GemTalk Systems 1986-2024.  All Rights Reserved.
!
! file GciLibraryA.gs  
!
! Description - 
!   During slow filein we generate some FFI classes based on C header files
!=========================================================================

! Build the GciLibrary class and related data type classes.
! fixed 45318
expectValue /String
time
doit
  | header libraryClass gsFile |
  (GsFile existsOnServer: '$upgradeDir/GciLibrary.gs') ifTrue:[
    ^'Class definition for GciLibrary found.'
  ].
  header := CHeader path: '$GEMSTONE/include/gci.hf'.
  libraryClass := header
    wrapperNamed: 'GciLibrary'
    libraryPathExpressionString: 'CHeader fetchGciRpcLibraryName'
    select: [:each | each name first = $G ].
  ClassOrganizer new makeInstancesNonPersistent: libraryClass.
  libraryClass comment:
'GciLibrary provides an interface to the GCI library as documented in the 
GemBuilder for C manual. It is an FFI generated class; refer to the CHeader class 
for details on generating classes for FFI.

Please note that GciLibrary includes all functions defined in the GCI header file, including
undocumented internal-only functions. Use only the functions documented in the 
GemBuilder for C manual, unless instructed otherwise by GemStone customer support.

Note also that instances of the GciLibrary cannot be persisted. Additionally, avoid calling
GciInit multiple times, as doing so will obliterate any existing session information from
previous uses. This suggests one should use GciLibrary as a Singleton, for example caching an
instance in SessionTemps.
'.

  Globals 
    at: #'GciLibrary' put: libraryClass;
    at: #'GciErrSType' put: (header wrapperForTypeNamed: 'GciErrSType').
  gsFile := GsFile openWriteOnServer: '$upgradeLogDir/GciLibrary.gs'.
  gsFile ifNil: [nil error: GsFile serverErrorString].
  (Globals at: #'GciLibrary') fileOutClassOn: gsFile.
  gsFile close.
  gsFile := GsFile openWriteOnServer: '$upgradeLogDir/GciErrSType.gs'.
  gsFile ifNil: [nil error: GsFile serverErrorString].
  (Globals at: #'GciErrSType') fileOutClassOn: gsFile.
  gsFile close.
  
  ^'Class definition for GciLibrary and GciErrSType created.'
%
time

! end of GciLibraryA.gs
