!=========================================================================
! Copyright (C) GemTalk Systems 1986-2024.  All Rights Reserved.
!
! File  HostAgentUser1.gs
!
! Description - create HostAgentUser UserProfile 
!=========================================================================

expectvalue /String
run
"remove CodeLibrarianUser if upgradeing from a 3.5.x repository"
AllUsers removeAndCleanupUserWithId:'CodeLibrarianUser' ifAbsent:[ ^ 'not found'].
^ 'removed'
%

expectvalue /String
run
Globals removeKey: #CodeLibrarianUserObjectSecurityPolicy ifAbsent:[ ^ 'not found'].
^ 'removed'
%

expectvalue /String
run
| up res assoc |
up := AllUsers userWithId: 'HostAgentUser' ifAbsent:[ nil ].
up ifNil:[ 
  up := AllUsers addNewUserWithId:'HostAgentUser'
                         password: 'swordfish' 
                         createNewSecurityPolicy: true .
  Globals at: #HostAgentUserObjectSecurityPolicy put: (up defaultObjectSecurityPolicy) .
  res := 'created'.
] ifNotNil:[
  res := 'exists'.
].
up addPrivilege: 'SessionAccess' ; 
   addPrivilege: 'CodeModification' ;
   addPrivilege: 'CompilePrimitives' .
^ res
%

expectvalue /String
run
| up uG assoc |
up := AllUsers userWithId: 'HostAgentUser' .
uG := (up resolveSymbol: #UserGlobals) value .
(uG at: #AcceptTimeoutMs otherwise: nil) ifNil:[
  uG at: #AcceptTimeoutMs put: 5000 .
  (uG associationAt: #AcceptTimeoutMs) objectSecurityPolicy: up defaultObjectSecurityPolicy .
  ^ 'added'
].
'not changed'
%

commit

expectvalue /String
run
 | key |
 key := #ObjectFiltersSecurityPolicy .
 "create ObjectFiltersSecurityPolicy , needed for X509 object filters"
 Globals at: key ifAbsent:[ | p |
   (p := GsObjectSecurityPolicy new)
     owner: (AllUsers userWithId:'DataCurator') ;
     worldAuthorization: #read ;
     ownerAuthorization: #write ;
     group: 'DataCuratorGroup' authorization: #write ;
     name: key asString .
   Globals at: key put: p . 
   ^ 'created ', key asString
 ].
 (Globals at: #ObjectFiltersSecurityPolicy) _validateInstanceOf: GsObjectSecurityPolicy .
 ^  key asString, ' exists'
%
commit
