! Copyright (C) GemTalk Systems 1986-2026.  All Rights Reserved.

FILEFORMAT UTF8
! Class Declarations
! Generated file, do not Edit

doit
(Error
	subclass: 'FsError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Exceptions';
		comment: 'Part of FileSystem

=========

I am an abstract Error class and serve as the base class for most FileSystem-related errors.';
		immediateInvariant.
true.
%

removeallmethods FsError
removeallclassmethods FsError

doit
(FsError
	subclass: 'FileException'
	instVarNames: #(fileName)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Exceptions';
		comment: 'Part of FileSystem

=========

Common superclass for exceptions while using file streams';
		immediateInvariant.
true.
%

removeallmethods FileException
removeallclassmethods FileException

doit
(FileException
	subclass: 'FileDoesNotExistException'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Exceptions';
		comment: 'Part of FileSystem

=========

I am raised when an operation is attempted on a file that does not exist.';
		immediateInvariant.
true.
%

removeallmethods FileDoesNotExistException
removeallclassmethods FileDoesNotExistException

doit
(FileException
	subclass: 'FileRequired'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Exceptions';
		comment: 'Part of FileSystem

=========

Notify that this operation requires a File.';
		immediateInvariant.
true.
%

removeallmethods FileRequired
removeallclassmethods FileRequired

doit
(FsError
	subclass: 'FileSystemError'
	instVarNames: #(reference)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Exceptions';
		comment: 'Part of FileSystem

=========

I am an abstract superclass for errors that may occur during filesystem operations.';
		immediateInvariant.
true.
%

removeallmethods FileSystemError
removeallclassmethods FileSystemError

doit
(FileSystemError
	subclass: 'DirectoryDoesNotExist'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Exceptions';
		comment: 'Part of FileSystem

=========

I am raised when I an operation is attempted inside a directory that does not exist.';
		immediateInvariant.
true.
%

removeallmethods DirectoryDoesNotExist
removeallclassmethods DirectoryDoesNotExist

doit
(FileSystemError
	subclass: 'DirectoryExists'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Exceptions';
		comment: 'Part of FileSystem

=========

I am raised on an attempt to create a directory that already exists.';
		immediateInvariant.
true.
%

removeallmethods DirectoryExists
removeallclassmethods DirectoryExists

doit
(FileSystemError
	subclass: 'DirectoryIsNotEmpty'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Exceptions';
		comment: 'Part of FileSystem

=========

I am raised on an attempt to delete a directory when is not empty.';
		immediateInvariant.
true.
%

removeallmethods DirectoryIsNotEmpty
removeallclassmethods DirectoryIsNotEmpty

doit
(FileSystemError
	subclass: 'DirectoryRequired'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Exceptions';
		comment: 'Part of FileSystem

=========

Notify that this operation requires a Directory';
		immediateInvariant.
true.
%

removeallmethods DirectoryRequired
removeallclassmethods DirectoryRequired

doit
(FileSystemError
	subclass: 'FileAttributeNotSupported'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Exceptions';
		comment: 'Part of FileSystem

=========

This Error is signaled when an attempting to access an attribute which is unsupported by the underlying FileSystem.';
		immediateInvariant.
true.
%

removeallmethods FileAttributeNotSupported
removeallclassmethods FileAttributeNotSupported

doit
(FileSystemError
	subclass: 'FileExists'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Exceptions';
		comment: 'Part of FileSystem

=========

I am raised on an attempt to create a file or directory over top of an existing file.';
		immediateInvariant.
true.
%

removeallmethods FileExists
removeallclassmethods FileExists

doit
(FileSystemError
	subclass: 'FilePermissionDenied'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Exceptions';
		comment: 'Part of FileSystem

=========

I am raised when an action is taken without sufficient permissions.';
		immediateInvariant.
true.
%

removeallmethods FilePermissionDenied
removeallclassmethods FilePermissionDenied

doit
(FsError
	subclass: 'FsFileDescriptorInvalid'
	instVarNames: #(fileDescriptor)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-FileDescriptor';
		comment: 'Part of FileSystem

=========

Error raised when attempting to operate on an invalid FsFileDescriptor';
		immediateInvariant.
true.
%

removeallmethods FsFileDescriptorInvalid
removeallclassmethods FsFileDescriptorInvalid

doit
(Error
	subclass: 'FsUnixError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

Abstract superclass for errno errors';
		immediateInvariant.
true.
%

removeallmethods FsUnixError
removeallclassmethods FsUnixError

doit
(FsUnixError
	subclass: 'FsEACCES'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

Permission was denied';
		immediateInvariant.
true.
%

removeallmethods FsEACCES
removeallclassmethods FsEACCES

doit
(FsUnixError
	subclass: 'FsEBADF'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

Bad file number';
		immediateInvariant.
true.
%

removeallmethods FsEBADF
removeallclassmethods FsEBADF

doit
(FsUnixError
	subclass: 'FsEEXIST'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

File exists';
		immediateInvariant.
true.
%

removeallmethods FsEEXIST
removeallclassmethods FsEEXIST

doit
(FsUnixError
	subclass: 'FsEINTR'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

Interrupted system call';
		immediateInvariant.
true.
%

removeallmethods FsEINTR
removeallclassmethods FsEINTR

doit
(FsUnixError
	subclass: 'FsEINVAL'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

Invalid argument';
		immediateInvariant.
true.
%

removeallmethods FsEINVAL
removeallclassmethods FsEINVAL

doit
(FsUnixError
	subclass: 'FsENOENT'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

No such file or directory';
		immediateInvariant.
true.
%

removeallmethods FsENOENT
removeallclassmethods FsENOENT

doit
(FsUnixError
	subclass: 'FsENOMEM'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

Out of memory';
		immediateInvariant.
true.
%

removeallmethods FsENOMEM
removeallclassmethods FsENOMEM

doit
(FsUnixError
	subclass: 'FsENOSPC'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

No space left on device';
		immediateInvariant.
true.
%

removeallmethods FsENOSPC
removeallclassmethods FsENOSPC

doit
(FsUnixError
	subclass: 'FsENOTDIR'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

Not a directory';
		immediateInvariant.
true.
%

removeallmethods FsENOTDIR
removeallclassmethods FsENOTDIR

doit
(FsUnixError
	subclass: 'FsEROFS'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

Read-only file system';
		immediateInvariant.
true.
%

removeallmethods FsEROFS
removeallclassmethods FsEROFS

doit
(Error
	subclass: 'ZnError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Zinc-Character-Encoding-Core';
		comment: 'Part of FileSystem

=========

I server as a common superclass for all Zinc related Error classes.';
		immediateInvariant.
true.
%

removeallmethods ZnError
removeallclassmethods ZnError

doit
(ZnError
	subclass: 'ZnCharacterEncodingError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Zinc-Character-Encoding-Core';
		comment: 'Part of FileSystem

=========

I am ZnCharacterEncodingError.
I am an Error.

I signal when something goes wrong while encoding or decoding characters.

Part of Zinc HTTP Components';
		immediateInvariant.
true.
%

removeallmethods ZnCharacterEncodingError
removeallclassmethods ZnCharacterEncodingError

doit
(Object
	subclass: 'AbstractFileReference'
	instVarNames: #(path)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Core';
		comment: 'Part of FileSystem

=========

I am an abstract superclass for FileLocator and FileReference. By implementing most of the methods on myself most code duplication between the locator and the reference can be avoided';
		immediateInvariant.
true.
%

removeallmethods AbstractFileReference
removeallclassmethods AbstractFileReference

doit
(AbstractFileReference
	subclass: 'FileLocator'
	instVarNames: #(origin)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Core';
		comment: 'Part of FileSystem

=========

FileLocator is part of FileSystem, providing an entry point for file and directory operations that are environment-independent.  A FileLocator refers to a file or directory in relation to a well-known location on the filesystem, called an origin. When asked to perform concrete operation, it looks up the location of its origin on the environment the code is running on, and resolve its relative path against that origin.

Origins include general ones such as temp, root, and home. To see all origins, execute FileLocator supportedOrigins.

Examples:
To create a temporary file:
    FileLocator temp / ''foo.out''
To resolve a FileLocator in the current environment:
    FileLocator home absolutePath

A FileLocator has two instance variables:
    origin  - A symbolic name for the base reference.
    path  - A RelativePath, that is resolved against the origin to determine the actual path for performing file and directory operations.';
		immediateInvariant.
true.
%

removeallmethods FileLocator
removeallclassmethods FileLocator

doit
(AbstractFileReference
	subclass: 'FileReference'
	instVarNames: #(filesystem)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Core';
		comment: 'Part of FileSystem

=========

FileReference is the primary entry point for file and directory operations using FileSystem. A FileReference represents a file or directory, which may nor may not exist on disk. File references can be created from Strings or using FileReference or FileSystem class methods.
For example:
      FileReference / ''/gshost/test/foo.txt''
      FileSystem disk / ''/gshost/test/foo.txt''
      ''/gshost/test/foo.txt'' asFileReference

FileReference provides access to information about a file and are used to create or delete files and directories. To read from or write to a file, use FileReference methods such as readStream or writeStream to open a read or write stream on the file.';
		immediateInvariant.
true.
%

removeallmethods FileReference
removeallclassmethods FileReference

doit
(Object
	subclass: 'FileSystem'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Core';
		comment: 'Part of FileSystem

=========
The class FileSystem is part of the FileSystem subsystem, providing flexible interaction with filesystems.  FileSystem supports both disk and in-memory file systems.

FileSystem instances are not normally accessed directly. The main entry point for working with files and directories is FileReference.

FileSystem class does provide several methods to access commonly used FileReferences, including:
    FileSystem disk workingDirectory
    FileSystem disk root

FileSystem presents a low-level protocol for interacting with filesystems. It holds a reference to a store (an instance of FileSystemStore) which takes care of the details of performing file and directory operations on the filesystem.

FileSystem is also responsible for resolving all paths that are pass into its store. The store acts as a factory and offers platform specific actions.';
		immediateInvariant.
true.
%

removeallmethods FileSystem
removeallclassmethods FileSystem

doit
(FileSystem
	subclass: 'FsDiskFileSystem'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Disk';
		comment: 'Part of FileSystem

=========

DiskFileSystem is not a standard class in FileSystem. GemStone''s implementation introduces this class to avoid committing platform-specific objects like LinuxStore_aarch64 instances. Instead, DiskFileSystem will lazily recreate its store. This class avoids committing any of its instance variables by marking itself as DbTransient.';
		immediateInvariant.
true.
%

removeallmethods FsDiskFileSystem
removeallclassmethods FsDiskFileSystem

doit
(FileSystem
	subclass: 'FsMemoryFileSystem'
	instVarNames: #(store)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Memory';
		comment: 'Part of FileSystem

=========

MemoryFileSystem is not a standard class in FileSystem. GemStone''s implementation introduces this class as a corallary to DiskFileSystem. There are no special options specified for this class.';
		immediateInvariant.
true.
%

removeallmethods FsMemoryFileSystem
removeallclassmethods FsMemoryFileSystem

doit
(Object
	subclass: 'FileSystemHandle'
	instVarNames: #(reference writable)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Core';
		comment: 'Part of FileSystem

=========

I am an abstract superclass for file handle implementations. I provide a uniform interface that streams can use for read and write operations on a file regardless of the filesystem. I encapsulate the actual IO primitives.';
		immediateInvariant.
true.
%

removeallmethods FileSystemHandle
removeallclassmethods FileSystemHandle

doit
(FileSystemHandle
	subclass: 'MemoryHandle'
	instVarNames: #(entry)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Memory';
		comment: 'Part of FileSystem

=========

I provide "primitives" for doing IO on files in a MemoryFileSystem. I delegate most of my actions to the MemoryFile. This way there is only one place needed where the data is stored.';
		immediateInvariant.
true.
%

removeallmethods MemoryHandle
removeallclassmethods MemoryHandle

doit
(Object
	subclass: 'FileSystemPermission'
	instVarNames: #(posixPermission)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Core';
		comment: 'Part of FileSystem

=========

I''m a set of permissions for a Directory Entry';
		immediateInvariant.
true.
%

removeallmethods FileSystemPermission
removeallclassmethods FileSystemPermission

doit
(Object
	subclass: 'FileSystemResolver'
	instVarNames: #(next)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Core';
		comment: 'Part of FileSystem

=========

I am an abstract superclass for objects that can resolve origins into references. Such objects use the Chain of Responsibility pattern, and when unable to resolve a particular origin, delegate that resolution request to the next resolver in the list.

next
	The next resolver in the list, or nil';
		immediateInvariant.
true.
%

removeallmethods FileSystemResolver
removeallclassmethods FileSystemResolver

doit
(FileSystemResolver
	subclass: 'EnvironmentResolver'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Core';
		comment: 'Part of FileSystem

=========

I resolve origins which are Environment variables. I ensure the environment variable value refers to an actual path in the file system.';
		immediateInvariant.
true.
%

removeallmethods EnvironmentResolver
removeallclassmethods EnvironmentResolver

doit
(FileSystemResolver
	subclass: 'PlatformResolver'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Core';
		comment: 'Part of FileSystem

=========

I am an abstract superclass for platform-specific resolvers.';
		immediateInvariant.
true.
%

removeallmethods PlatformResolver
removeallclassmethods PlatformResolver

doit
(PlatformResolver
	subclass: 'MacOSResolver'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Core';
		comment: 'Part of FileSystem

=========

I am an expert on Mac OS X filesystem conventions. I resolve origins according to these conventions.';
		immediateInvariant.
true.
%

removeallmethods MacOSResolver
removeallclassmethods MacOSResolver

doit
(PlatformResolver
	subclass: 'UnixResolver'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Core';
		comment: 'Part of FileSystem

=========

I am an expert on Unix filesystem conventions. I resolve origins according to these conventions.';
		immediateInvariant.
true.
%

removeallmethods UnixResolver
removeallclassmethods UnixResolver

doit
(FileSystemResolver
	subclass: 'SystemResolver'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Core';
		comment: 'Part of FileSystem

=========

I resolve origins that are related to the currently running Smalltalk system, using primitives provided by the VM.';
		immediateInvariant.
true.
%

removeallmethods SystemResolver
removeallclassmethods SystemResolver

doit
(Object
	subclass: 'FileSystemStore'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Core';
		comment: 'Part of FileSystem

=========

I am an abstract superclass for store implementations. My subclasses provide access to the actual data storage of a particular kind of filesystem. 

The file system can be accessed via
	FileSystem disk 
	FileSystem memory
	
My associated filesystem can be accessed as follows:
      DiskStore currentFileSystem';
		immediateInvariant.
true.
%

removeallmethods FileSystemStore
removeallclassmethods FileSystemStore

doit
(FileSystemStore
	subclass: 'DiskStore'
	instVarNames: #(libcDirent libcFcntl libcUnistd libcStat libcStdio)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesNonPersistent'  #logCreation )
)
		category: 'FileSystem-Disk';
		comment: 'Part of FileSystem

=========

I am an abstract superclass for disk store implementations. My subclasses provide access to the actual data storage of a particular kind of filesystem.';
		immediateInvariant.
true.
%

removeallmethods DiskStore
removeallclassmethods DiskStore

doit
(DiskStore
	subclass: 'UnixStore'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Disk';
		comment: 'Part of FileSystem

=========

I''m a specific store for Unix file systems';
		immediateInvariant.
true.
%

removeallmethods UnixStore
removeallclassmethods UnixStore

doit
(UnixStore
	subclass: 'FsLinuxStore'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Disk';
		comment: 'Part of FileSystem

=========

FsLinuxStore provides an interface to a Linux file system. Any differences from other Unix systems is specified here.';
		immediateInvariant.
true.
%

removeallmethods FsLinuxStore
removeallclassmethods FsLinuxStore

doit
(FsLinuxStore
	subclass: 'FsLinuxStore_aarch64'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Disk';
		comment: 'Part of FileSystem

=========

FsLinuxStore_aarch64 provides architecture-specific functionality for the store.';
		immediateInvariant.
true.
%

removeallmethods FsLinuxStore_aarch64
removeallclassmethods FsLinuxStore_aarch64

doit
(FsLinuxStore
	subclass: 'FsLinuxStore_x64'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Disk';
		comment: 'Part of FileSystem

=========

FsLinuxStore_x6464 provides architecture-specific functionality for the store.';
		immediateInvariant.
true.
%

removeallmethods FsLinuxStore_x64
removeallclassmethods FsLinuxStore_x64

doit
(UnixStore
	subclass: 'FsMacOSStore'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Disk';
		comment: 'Part of FileSystem

=========

I''m a specific store for OSX file systems';
		immediateInvariant.
true.
%

removeallmethods FsMacOSStore
removeallclassmethods FsMacOSStore

doit
(FsMacOSStore
	subclass: 'FsMacOSStore_arm64'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Disk';
		comment: 'Part of FileSystem

=========

FsMacOSStore_arm64 provides architecture-specific functionality for the store.';
		immediateInvariant.
true.
%

removeallmethods FsMacOSStore_arm64
removeallclassmethods FsMacOSStore_arm64

doit
(FsMacOSStore
	subclass: 'FsMacOSStore_x64'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Disk';
		comment: 'Part of FileSystem

=========

FsMacOSStore_x64 provides architecture-specific functionality for the store.';
		immediateInvariant.
true.
%

removeallmethods FsMacOSStore_x64
removeallclassmethods FsMacOSStore_x64

doit
(FileSystemStore
	subclass: 'MemoryStore'
	instVarNames: #(root)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Memory';
		comment: 'Part of FileSystem

=========

I''m a specific store for memory file system';
		immediateInvariant.
true.
%

removeallmethods MemoryStore
removeallclassmethods MemoryStore

doit
(Object
	subclass: 'FsBinaryFileStream'
	instVarNames: #(descriptor)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'dbTransient'  #logCreation )
)
		category: 'FileSystem-FileDescriptor';
		comment: 'Part of FileSystem

=========

FsBinaryFileStream is the base stream used by FileSystem. It interfaces with an FsFileDescriptor and performs the conversion from stream methods to file descriptor methods.';
		immediateInvariant.
true.
%

removeallmethods FsBinaryFileStream
removeallclassmethods FsBinaryFileStream

doit
(Object
	subclass: 'FsCStructure'
	instVarNames: #(bytes pointer)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesNonPersistent'  #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

Abstract superclass for classes representing structures in external memory.
Typically, these are represented in C as struct types. They have named fields of various types.
Subclasses of this class provide the ability to read and write individual fields, and to allocate and free
instances of the structure.

bytes is an instance of CByteArray, and therefore in external memory.';
		immediateInvariant.
true.
%

removeallmethods FsCStructure
removeallclassmethods FsCStructure

doit
(FsCStructure
	subclass: 'FsDirentStruct'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

The libc dirent structure, as returned by the libc call readdir().';
		immediateInvariant.
true.
%

removeallmethods FsDirentStruct
removeallclassmethods FsDirentStruct

doit
(FsDirentStruct
	subclass: 'FsDirentStruct_Linux'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

Linux variant of the struct dirent';
		immediateInvariant.
true.
%

removeallmethods FsDirentStruct_Linux
removeallclassmethods FsDirentStruct_Linux

doit
(FsDirentStruct
	subclass: 'FsDirentStruct_macOS'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

macOS variant of struct dirent';
		immediateInvariant.
true.
%

removeallmethods FsDirentStruct_macOS
removeallclassmethods FsDirentStruct_macOS

doit
(FsCStructure
	subclass: 'FsStatStruct'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

This class represents ''struct stat''.';
		immediateInvariant.
true.
%

removeallmethods FsStatStruct
removeallclassmethods FsStatStruct

doit
(FsStatStruct
	subclass: 'FsStatStruct_Linux'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

Represents common aspects of Linux''s stat struct';
		immediateInvariant.
true.
%

removeallmethods FsStatStruct_Linux
removeallclassmethods FsStatStruct_Linux

doit
(FsStatStruct_Linux
	subclass: 'FsStatStruct_Linux_aarch64'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

Represents aarch64-specific aspects of Linux''s stat struct';
		immediateInvariant.
true.
%

removeallmethods FsStatStruct_Linux_aarch64
removeallclassmethods FsStatStruct_Linux_aarch64

doit
(FsStatStruct_Linux
	subclass: 'FsStatStruct_Linux_x64'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

Represents x64-specific aspects of Linux''s stat struct';
		immediateInvariant.
true.
%

removeallmethods FsStatStruct_Linux_x64
removeallclassmethods FsStatStruct_Linux_x64

doit
(FsStatStruct
	subclass: 'FsStatStruct_macOS'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

Represents macOS''s stat struct';
		immediateInvariant.
true.
%

removeallmethods FsStatStruct_macOS
removeallclassmethods FsStatStruct_macOS

doit
(FsCStructure
	subclass: 'FsTimespecStruct'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

Represents struct timespec';
		immediateInvariant.
true.
%

removeallmethods FsTimespecStruct
removeallclassmethods FsTimespecStruct

doit
(Object
	subclass: 'FsFileDescriptor'
	instVarNames: #(fd ephemeron libcUnistd)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesNonPersistent'  #logCreation )
)
		category: 'FileSystem-FileDescriptor';
		comment: 'Part of FileSystem

=========

FsFileDescriptor serves as a wrapper for an OS file descriptor. It provides a reasonable Smalltalk interface for used functions.

Instances are instancesNonPersistent as they cannot be committed to the database. A closely related class, FsBinaryFileStream is dbTransient. Referenced instances of FsFileDescriptor are kept alive indirectly (via a chain of instancesNonPersistent objects) which start at SessionTemps and terminates with FsFileDescriptorEphemeron.

When the last reference to an FsFileDescriptorInstance is released, the associated Ephemeron will be mourned. Mourning will properly close the file descriptor (if it hasn''t been already) and removed the FsFileDescriptor instance the associated FsFileDescriptorRegistry. Users should ensure they maintain a direct and transient reference a FsFileDescriptor instance to ensure it isn''t garbage collected and closed prematurely.

In many cases, the only reference to the underlying FsFileDescriptor will be the FsBinaryFileStream instance. Avoid committing associated streams unless you hold a transient reference to the FsFileDescriptor instance elsewhere.';
		immediateInvariant.
true.
%

removeallmethods FsFileDescriptor
removeallclassmethods FsFileDescriptor

doit
(Object
	subclass: 'FsFileDescriptorEphemeron'
	instVarNames: #(fileDescriptor registry index)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesNonPersistent'  #logCreation )
)
		category: 'FileSystem-FileDescriptor';
		comment: 'Part of FileSystem

=========

Provide finalization to FileDescriptor. Stored in FileDescriptorRegistry.';
		immediateInvariant.
true.
%

removeallmethods FsFileDescriptorEphemeron
removeallclassmethods FsFileDescriptorEphemeron

doit
(Object
	subclass: 'FsFileDescriptorRegistry'
	instVarNames: #(freeHead list)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesNonPersistent'  #logCreation )
)
		category: 'FileSystem-FileDescriptor';
		comment: 'Part of FileSystem

=========

FsFileDescriptorRegistry holds onto FsFileDescriptor instances indirectly via an Ephemeron. When the Ephemeron is mourned, the OS file descriptor will be closed (if necessary). The Ephemeron will also be removed from the Registry.

The registry is a singleton and the instance is accessible via `FsFileDescriptorRegistry current`.';
		immediateInvariant.
true.
%

removeallmethods FsFileDescriptorRegistry
removeallclassmethods FsFileDescriptorRegistry

doit
(Object
	subclass: 'FsFileOpeningOptions'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-FileDescriptor';
		comment: 'Part of FileSystem

=========

Abstract superclass for platform-/architecture-specific option classes. Subclasses differ due the difference in values and options provided by different environments.';
		immediateInvariant.
true.
%

removeallmethods FsFileOpeningOptions
removeallclassmethods FsFileOpeningOptions

doit
(FsFileOpeningOptions
	subclass: 'FsMemoryFileOpeningOptions'
	instVarNames: #(wasConfigured readable writable)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Memory';
		comment: 'Part of FileSystem

=========

Provides support for In-memory FileSystem implementation.';
		immediateInvariant.
true.
%

removeallmethods FsMemoryFileOpeningOptions
removeallclassmethods FsMemoryFileOpeningOptions

doit
(FsFileOpeningOptions
	subclass: 'FsUnixFileOpeningOptions'
	instVarNames: #(accessModeSet flags mode)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-FileDescriptor';
		comment: 'Part of FileSystem

=========

Provides an abstraction for Unix options.';
		immediateInvariant.
true.
%

removeallmethods FsUnixFileOpeningOptions
removeallclassmethods FsUnixFileOpeningOptions

doit
(FsUnixFileOpeningOptions
	subclass: 'FsFileOpeningOptions_Linux'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-FileDescriptor';
		comment: 'Part of FileSystem

=========

Users of FileOpeningOptions should use the interface as defined in FsFileOpeningOptions, FsMemoryFileOpeningOptions, and FsUnixFileOpeningOptions. All subclasses of these classes are implementation-defined and subject to change at anytime.

Represents the flags and mode arguments to the Unix open() call.
See ''man 2 open'' for documentation of the various options.

flags is an integer, all the O_* options ORed together.

mode is an instance of UnixFileMode. It is ignored on open unless #create or #tmpfile is specified.

Instances are created by sending the class one of the messages 
  #readOnly
  #writeOnly
  #readWrite

Other options are set by sending messages to the resulting instance.

API is provided for setting bits in flags, and setting the mode.
No API is provided for clearing bits in flags -- a new instance starts with them all cleared,
you should set only the ones you want set.';
		immediateInvariant.
true.
%

removeallmethods FsFileOpeningOptions_Linux
removeallclassmethods FsFileOpeningOptions_Linux

doit
(FsFileOpeningOptions_Linux
	subclass: 'FsFileOpeningOptions_Linux_aarch64'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-FileDescriptor';
		comment: 'Part of FileSystem

=========

Users of FileOpeningOptions should use the interface as defined in FsFileOpeningOptions, FsMemoryFileOpeningOptions, and FsUnixFileOpeningOptions. All subclasses of these classes are implementation-defined and subject to change at anytime.

This subclass provides the architecture-specific values for various constants.';
		immediateInvariant.
true.
%

removeallmethods FsFileOpeningOptions_Linux_aarch64
removeallclassmethods FsFileOpeningOptions_Linux_aarch64

doit
(FsFileOpeningOptions_Linux
	subclass: 'FsFileOpeningOptions_Linux_x64'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-FileDescriptor';
		comment: 'Part of FileSystem

=========

Users of FileOpeningOptions should use the interface as defined in FsFileOpeningOptions, FsMemoryFileOpeningOptions, and FsUnixFileOpeningOptions. All subclasses of these classes are implementation-defined and subject to change at anytime.

This subclass provides the architecture-specific values for various constants.';
		immediateInvariant.
true.
%

removeallmethods FsFileOpeningOptions_Linux_x64
removeallclassmethods FsFileOpeningOptions_Linux_x64

doit
(FsUnixFileOpeningOptions
	subclass: 'FsFileOpeningOptions_macOS'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-FileDescriptor';
		comment: 'Part of FileSystem

=========

Users of FileOpeningOptions should use the interface as defined in FsFileOpeningOptions, FsMemoryFileOpeningOptions, and FsUnixFileOpeningOptions. All subclasses of these classes are implementation-defined and subject to change at anytime.

This class provides constant values specific to macOS.';
		immediateInvariant.
true.
%

removeallmethods FsFileOpeningOptions_macOS
removeallclassmethods FsFileOpeningOptions_macOS

doit
(Object
	subclass: 'FsLibcInterface'
	instVarNames: #(library)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesNonPersistent'  #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

Abstract superclass for "Smalltalk-ized" wrappers around auto-generated classes that come from the various header files for functions in libc.
The primary functions of the wrappers are:
* Better keyword selectors than the auto-generated ones
* Convert error returns (in, for instance, errno) to signaled exceptions.

Instvar library should refer to a library class created by LibcFactory';
		immediateInvariant.
true.
%

removeallmethods FsLibcInterface
removeallclassmethods FsLibcInterface

doit
(FsLibcInterface
	subclass: 'FsLibcDirent'
	instVarNames: #(opendir closedir readdir)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

Interface for direct.h';
		immediateInvariant.
true.
%

removeallmethods FsLibcDirent
removeallclassmethods FsLibcDirent

doit
(FsLibcDirent
	subclass: 'FsLibcDirent_Linux'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

Interface for Linux specific aspects of dirent.h';
		immediateInvariant.
true.
%

removeallmethods FsLibcDirent_Linux
removeallclassmethods FsLibcDirent_Linux

doit
(FsLibcDirent
	subclass: 'FsLibcDirent_macOS'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

Abstract macOS interface to dirent.h';
		immediateInvariant.
true.
%

removeallmethods FsLibcDirent_macOS
removeallclassmethods FsLibcDirent_macOS

doit
(FsLibcDirent_macOS
	subclass: 'FsLibcDirent_macOS_arm64'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

arm64-specific dirent.h modifications';
		immediateInvariant.
true.
%

removeallmethods FsLibcDirent_macOS_arm64
removeallclassmethods FsLibcDirent_macOS_arm64

doit
(FsLibcDirent_macOS
	subclass: 'FsLibcDirent_macOS_x64'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

x64-specific direct.h changes';
		immediateInvariant.
true.
%

removeallmethods FsLibcDirent_macOS_x64
removeallclassmethods FsLibcDirent_macOS_x64

doit
(FsLibcInterface
	subclass: 'FsLibcFcntl'
	instVarNames: #(open chmod)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

Interface to fcntl.h';
		immediateInvariant.
true.
%

removeallmethods FsLibcFcntl
removeallclassmethods FsLibcFcntl

doit
(FsLibcFcntl
	subclass: 'FsLibcFcntl_Linux'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

Linux fcntl.h interface';
		immediateInvariant.
true.
%

removeallmethods FsLibcFcntl_Linux
removeallclassmethods FsLibcFcntl_Linux

doit
(FsLibcFcntl
	subclass: 'FsLibcFcntl_macOS'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

macOS fcntl.h interface';
		immediateInvariant.
true.
%

removeallmethods FsLibcFcntl_macOS
removeallclassmethods FsLibcFcntl_macOS

doit
(FsLibcInterface
	subclass: 'FsLibcStat'
	instVarNames: #(fstat stat lstat mkdir)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

Interface to stat.h';
		immediateInvariant.
true.
%

removeallmethods FsLibcStat
removeallclassmethods FsLibcStat

doit
(FsLibcStat
	subclass: 'FsLibcStat_Linux'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

Common Linux interface to stat.h';
		immediateInvariant.
true.
%

removeallmethods FsLibcStat_Linux
removeallclassmethods FsLibcStat_Linux

doit
(FsLibcStat_Linux
	subclass: 'FsLibcStat_Linux_aarch64'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

Linux/aarch64 interface to stat.h';
		immediateInvariant.
true.
%

removeallmethods FsLibcStat_Linux_aarch64
removeallclassmethods FsLibcStat_Linux_aarch64

doit
(FsLibcStat_Linux
	subclass: 'FsLibcStat_Linux_x64'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

Linux/x64 interface to stat.h';
		immediateInvariant.
true.
%

removeallmethods FsLibcStat_Linux_x64
removeallclassmethods FsLibcStat_Linux_x64

doit
(FsLibcStat
	subclass: 'FsLibcStat_macOS'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

Common macOS interface to stat.h';
		immediateInvariant.
true.
%

removeallmethods FsLibcStat_macOS
removeallclassmethods FsLibcStat_macOS

doit
(FsLibcStat_macOS
	subclass: 'FsLibcStat_macOS_arm64'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

macOS/arm64 interface to stat.h';
		immediateInvariant.
true.
%

removeallmethods FsLibcStat_macOS_arm64
removeallclassmethods FsLibcStat_macOS_arm64

doit
(FsLibcStat_macOS
	subclass: 'FsLibcStat_macOS_x64'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

macOS/x64 interface to stat.h';
		immediateInvariant.
true.
%

removeallmethods FsLibcStat_macOS_x64
removeallclassmethods FsLibcStat_macOS_x64

doit
(FsLibcInterface
	subclass: 'FsLibcStdio'
	instVarNames: #(rename)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

Interface to stdio.h';
		immediateInvariant.
true.
%

removeallmethods FsLibcStdio
removeallclassmethods FsLibcStdio

doit
(FsLibcStdio
	subclass: 'FsLibcStdio_Linux'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

Linux interface to stdio.h';
		immediateInvariant.
true.
%

removeallmethods FsLibcStdio_Linux
removeallclassmethods FsLibcStdio_Linux

doit
(FsLibcStdio
	subclass: 'FsLibcStdio_macOS'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

macOS interface to stdio.h';
		immediateInvariant.
true.
%

removeallmethods FsLibcStdio_macOS
removeallclassmethods FsLibcStdio_macOS

doit
(FsLibcInterface
	subclass: 'FsLibcUnistd'
	instVarNames: #(close getcwd lseek read rmdir ftruncate unlink write chown chdir pread symlink)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

Interface to unistd.h';
		immediateInvariant.
true.
%

removeallmethods FsLibcUnistd
removeallclassmethods FsLibcUnistd

doit
(FsLibcUnistd
	subclass: 'FsLibcUnistd_Linux'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

Linux interface to unistd.h';
		immediateInvariant.
true.
%

removeallmethods FsLibcUnistd_Linux
removeallclassmethods FsLibcUnistd_Linux

doit
(FsLibcUnistd
	subclass: 'FsLibcUnistd_macOS'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-LibC';
		comment: 'Part of FileSystem

=========

This class is private and subject to revision or removal. The FileSystem-LibC package is still under active development.

=========

macOS interface to unistd.h';
		immediateInvariant.
true.
%

removeallmethods FsLibcUnistd_macOS
removeallclassmethods FsLibcUnistd_macOS

doit
(Object
	subclass: 'MemoryFileSystemEntry'
	instVarNames: #(creationTime modificationTime basename)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Memory';
		comment: 'Part of FileSystem

=========

I am an abstract file system entry for a memory file system.
My subclasses should specialize on the kind of file they are.';
		immediateInvariant.
true.
%

removeallmethods MemoryFileSystemEntry
removeallclassmethods MemoryFileSystemEntry

doit
(MemoryFileSystemEntry
	subclass: 'MemoryFileSystemDirectory'
	instVarNames: #(entries)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Memory';
		comment: 'Part of FileSystem

=========

I represent a memory file system entry for a directory';
		immediateInvariant.
true.
%

removeallmethods MemoryFileSystemDirectory
removeallclassmethods MemoryFileSystemDirectory

doit
(MemoryFileSystemEntry
	subclass: 'MemoryFileSystemFile'
	instVarNames: #(bytes size closed)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Memory';
		comment: 'Part of FileSystem

=========

I represent a memory file system entry for a regular file';
		immediateInvariant.
true.
%

removeallmethods MemoryFileSystemFile
removeallclassmethods MemoryFileSystemFile

doit
(Object
	subclass: 'MemoryFileWriteStream'
	instVarNames: #(file writeStream stream)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Memory';
		comment: 'Part of FileSystem

=========

A file write stream - but within memory';
		immediateInvariant.
true.
%

removeallmethods MemoryFileWriteStream
removeallclassmethods MemoryFileWriteStream

doit
(Object
	indexableSubclass: 'Path'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Path';
		comment: 'Part of FileSystem

=========

Path is an abstract superclass for the concrete classes AbsolutePath and RelativePath, part of FileSystem. These classes represent paths on the filesystem, independent of the string representation used to describe paths on a specific filesystem. Paths are implemented as an Array of strings which are the names of directories and files. Protocol also allows you to work with file extensions.

Instance creation:
    from: -- parses the supplied string and create an absolute or relative path.
    from:delimiter: -- parses the supplied string using the supplied delimiter.
    / -- creates an absolute path from the supplied string.
    * -- creates a relative path from the supplied string.

For example:
    Path / ''diskname/foo.out''
    Path / ''diskname'' / ''foo.out''
    (Path from: ''/diskname'') / ''foo.out''
    Path / ''diskname'' / ''foo.out''

Path >>/ adds the supplied path or filename to the receiver.';
		immediateInvariant.
true.
%

removeallmethods Path
removeallclassmethods Path

doit
(Path
	subclass: 'AbsolutePath'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Path';
		comment: 'Part of FileSystem

=========

AbsolutePath is part of FileSystem, and represents an absolute path, starting from the root directory (Path root). Instance creation is normally done by sending messages to Path, the superclass. AbsolutePath instance creation is based on the argument, so instance creation methods sent to this class specifying a relative path will return an instance of RelativePath.

See Path class comment for more information on kinds of Path.';
		immediateInvariant.
true.
%

removeallmethods AbsolutePath
removeallclassmethods AbsolutePath

doit
(Path
	subclass: 'RelativePath'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Path';
		comment: 'Part of FileSystem

=========

RelativePath is part of FileSystem, and represents a path relative to the current working directory. Instance creation is normally done by sending messages to Path, the superclass. RelativePath instance creation is based on the argument, so instance creation methods sent to this class specifying an absolute path will return an instance of AbsolutePath.

See Path class comment for more information on kinds of Path.';
		immediateInvariant.
true.
%

removeallmethods RelativePath
removeallclassmethods RelativePath

doit
(Object
	subclass: 'ZnCharacterEncoder'
	instVarNames: #(stringClass)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Zinc-Character-Encoding-Core';
		comment: 'Part of FileSystem

=========

I am ZnCharacterEncoder, I encode and decode Character objects to and from a binary stream.
I am an abstract class with following protocol:

#nextFromStream:
#nextPut:toStream:
#encodedByteCountFor:
#backOnStream:

I add some convenience methods:

#encodeString:
#decodeBytes:
#encodedByteCountForString:

I also implement optimized bulk operations:

#next:putAll:startingAt:toStream:
#readInto:startingAt:count:fromStream:

Additionally, I can encode Integer code points to a binary stream as well as read Integer code points from a binary stream. This is in a sense a more fundamental operation that avoids instantiating Character objects.

#nextCodePointFromStream:
#nextPutCodePoint:toStream:
#encodedByteCountForCodePoint:

#decodeAsCodePoints:
#encodeCodePoints:
#encodedByteCountForCodePoints:

Part of Zinc HTTP Components.';
		immediateInvariant.
true.
%

removeallmethods ZnCharacterEncoder
removeallclassmethods ZnCharacterEncoder

doit
(ZnCharacterEncoder
	subclass: 'Zn8BITEncoder'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Zinc-Character-Encoding-Core';
		comment: 'Part of FileSystem

=========

I implement the encoding and decoding of Extended ASCII (8 bit character encoding) that produces instances of class String.

The encoding is consistent with topaz ''fileformat 8BIT'' (see ''Handling text outside the ASCII range'' in the topaz manual for more details).';
		immediateInvariant.
true.
%

removeallmethods Zn8BITEncoder
removeallclassmethods Zn8BITEncoder

doit
(ZnCharacterEncoder
	subclass: 'ZnUTF8Encoder'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Zinc-Character-Encoding-Core';
		comment: 'Part of FileSystem

=========

I am the GemStone/S implementation of ZnUTF8Encoder.
I implement the variable length UTF-8 encoding and decoding of Unicode according to RFC 3629.

Wikipedia reference http://en.wikipedia.org/wiki/UTF-8

Part of Zinc HTTP Components.

I use the ICU library to encode strings and decode ByteArray and Utf8 instances ...';
		immediateInvariant.
true.
%

removeallmethods ZnUTF8Encoder
removeallclassmethods ZnUTF8Encoder

doit
(Stream
	subclass: 'ZnStream'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Zinc-Character-Encoding-Core';
		comment: 'Part of FileSystem

=========

ZnStream serves as a common superclass for all Zinc stream classes. Direct usage of this class is unlikely.';
		immediateInvariant.
true.
%

removeallmethods ZnStream
removeallclassmethods ZnStream

doit
(ZnStream
	subclass: 'ZnBufferedReadStream'
	instVarNames: #(stream buffer position limit)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Zinc-Character-Encoding-Core';
		comment: 'Part of FileSystem

=========

I am ZnBufferedReadStream.

I wrap another ReadStream and add efficient buffering for the typical access pattern of parsers: sending lots of #next, #peek and #atEnd messages.

By design I do not implement #position and #position: or anything based on that.

I can wrap both binary or character streams and act accordingly.

Part of Zinc HTTP Components.';
		immediateInvariant.
true.
%

removeallmethods ZnBufferedReadStream
removeallclassmethods ZnBufferedReadStream

doit
(ZnStream
	subclass: 'ZnBufferedReadWriteStream'
	instVarNames: #(readStream writeStream lastRead)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Zinc-Character-Encoding-Core';
		comment: 'Part of FileSystem

=========

I am ZnBufferedReadWriteStream.
I wrap a buffered read stream and a buffered write stream on the same file.

I discard my read buffer on writes, and flush my write buffer on reads.
Make sure to always send me #flush or #close when you''re done,
otherwise the last buffer might not yet have been written.
My class side''s #on:do: helps to ensure this.

I can wrap both binary or character streams and act accordingly.

Part of Zinc HTTP Components.';
		immediateInvariant.
true.
%

removeallmethods ZnBufferedReadWriteStream
removeallclassmethods ZnBufferedReadWriteStream

doit
(ZnStream
	subclass: 'ZnBufferedWriteStream'
	instVarNames: #(stream buffer position)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Zinc-Character-Encoding-Core';
		comment: 'Part of FileSystem

=========

I am ZnBufferedWriteStream.
I wrap a write stream and add buffering.

Make sure to always send me #flush or #close when you''re done,
otherwise the last buffer might not yet have been written.
My class side''s #on:do: helps to ensure this.

I can wrap both binary or character streams and act accordingly.

Part of Zinc HTTP Components.';
		immediateInvariant.
true.
%

removeallmethods ZnBufferedWriteStream
removeallclassmethods ZnBufferedWriteStream

doit
(ZnStream
	subclass: 'ZnEncodedStream'
	instVarNames: #(stream encoder)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Zinc-Character-Encoding-Core';
		comment: 'Part of FileSystem

=========

I am ZnEncodedStream, an abstract support class for read and write streams on an encoded binary stream.

Part of Zinc HTTP Components';
		immediateInvariant.
true.
%

removeallmethods ZnEncodedStream
removeallclassmethods ZnEncodedStream

doit
(ZnEncodedStream
	subclass: 'ZnEncodedReadStream'
	instVarNames: #(peeked)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Zinc-Character-Encoding-Core';
		comment: 'Part of FileSystem

=========

I am ZnEncodedReadStream, an abstract support class for read streams on a binary encoded wrapped stream.

Part of Zinc HTTP Components';
		immediateInvariant.
true.
%

removeallmethods ZnEncodedReadStream
removeallclassmethods ZnEncodedReadStream

doit
(ZnEncodedReadStream
	subclass: 'ZnCharacterReadStream'
	instVarNames: #(stringClass)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Zinc-Character-Encoding-Core';
		comment: 'Part of FileSystem

=========

I am ZnCharacterReadStream.
I wrap another binary ReadStream and use a ZnCharacerEncoder to allow Characters to be read.

I am not positionable, but I do allow a one character peek using a one character internal buffer.

Part of Zinc HTTP Components.';
		immediateInvariant.
true.
%

removeallmethods ZnCharacterReadStream
removeallclassmethods ZnCharacterReadStream

doit
(ZnEncodedStream
	subclass: 'ZnEncodedWriteStream'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Zinc-Character-Encoding-Core';
		comment: 'Part of FileSystem

=========

I am ZnEncodedWriteStream, an abstract support class for write streams on a binary encoded wrapped stream.

Part of Zinc HTTP Components';
		immediateInvariant.
true.
%

removeallmethods ZnEncodedWriteStream
removeallclassmethods ZnEncodedWriteStream

doit
(ZnEncodedWriteStream
	subclass: 'ZnCharacterWriteStream'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'FileSystem-Zinc-Character-Encoding-Core';
		comment: 'Part of FileSystem

=========

I am ZnCharacterWriteStream.
I wrap another binary WriteStream and use a ZnCharacerEncoder to allow Characters to be written.

Part of Zinc HTTP Components.';
		immediateInvariant.
true.
%

removeallmethods ZnCharacterWriteStream
removeallclassmethods ZnCharacterWriteStream

! Class implementation for 'FsError'

!		Instance methods for 'FsError'

category: 'Instance initialization'
method: FsError
initialize
  super initialize .
  gsNumber := ERR_FsError .
%

! Class implementation for 'FileException'

!		Class methods for 'FileException'

category: 'exceptioninstantiator'
classmethod: FileException
fileName: aFileName
	^self new fileName: aFileName
%

category: 'instance creation'
classmethod: FileException
signalOnFile: aFile 
	
	(self fileName: aFile basename) signal: aFile name
%

category: 'instance creation'
classmethod: FileException
signalWith: aReference
	"Signal a new instance of the receiver with the supplied reference.
	aReference is something that can be converted to a path, e.g. a String, Path or FileReference"
  | str |
	^(self fileName: (str := aReference asPath pathString)) signal: str
%

!		Instance methods for 'FileException'

category: 'exceptiondescription'
method: FileException
fileName
	^fileName
%

category: 'exceptionbuilder'
method: FileException
fileName: aFileName
	fileName := aFileName
%

category: 'Instance initialization'
method: FileException
initialize
  super initialize .
  gsNumber := ERR_FileException .
%

category: 'exceptiondescription'
method: FileException
isResumable
	"Determine whether an exception is resumable."

	^true
%

category: 'exceptiondescription'
method: FileException
messageText
	"Return an exception's message text."

	^ messageText isNil
		ifTrue: [ fileName printString ]
		ifFalse: [ messageText ]
%

! Class implementation for 'FileDoesNotExistException'

!		Instance methods for 'FileDoesNotExistException'

category: 'Instance initialization'
method: FileDoesNotExistException
initialize
  super initialize .
  gsNumber := ERR_FileDoesNotExistException .
%

! Class implementation for 'FileRequired'

!		Instance methods for 'FileRequired'

category: 'Instance initialization'
method: FileRequired
initialize
  super initialize .
  gsNumber := ERR_FileRequired .
%

! Class implementation for 'FileSystemError'

!		Class methods for 'FileSystemError'

category: 'instance creation'
classmethod: FileSystemError
reference: aReference
	^ self new initializeWithReference: aReference
%

category: 'instance creation'
classmethod: FileSystemError
signalWith: aReference
	^ (self reference: aReference) signal
%

!		Instance methods for 'FileSystemError'

category: 'Instance initialization'
method: FileSystemError
initialize
  super initialize .
  gsNumber := ERR_FileSystemError .
%

category: 'initialize-release'
method: FileSystemError
initializeWithReference: aReference
	reference := aReference.
	messageText := 'a', self class name , ' occurred, ', aReference printString
%

category: 'testing'
method: FileSystemError
isResumable
	^ true
%

category: 'accessing'
method: FileSystemError
reference
	^ reference
%

! Class implementation for 'DirectoryDoesNotExist'

!		Instance methods for 'DirectoryDoesNotExist'

category: 'Instance initialization'
method: DirectoryDoesNotExist
initialize
  super initialize .
  gsNumber := ERR_DirectoryDoesNotExist .
%

! Class implementation for 'DirectoryExists'

!		Instance methods for 'DirectoryExists'

category: 'Instance initialization'
method: DirectoryExists
initialize
  super initialize .
  gsNumber := ERR_DirectoryExists .
%

! Class implementation for 'DirectoryIsNotEmpty'

!		Instance methods for 'DirectoryIsNotEmpty'

category: 'Instance initialization'
method: DirectoryIsNotEmpty
initialize
  super initialize .
  gsNumber := ERR_DirectoryIsNotEmpty .
%

! Class implementation for 'DirectoryRequired'

!		Instance methods for 'DirectoryRequired'

category: 'Instance initialization'
method: DirectoryRequired
initialize
  super initialize .
  gsNumber := ERR_DirectoryRequired .
%

! Class implementation for 'FileAttributeNotSupported'

!		Instance methods for 'FileAttributeNotSupported'

category: 'Instance initialization'
method: FileAttributeNotSupported
initialize
  super initialize .
  gsNumber := ERR_FileAttributeNotSupported .
%

! Class implementation for 'FileExists'

!		Instance methods for 'FileExists'

category: 'Instance initialization'
method: FileExists
initialize
  super initialize .
  gsNumber := ERR_FileExists .
%

! Class implementation for 'FilePermissionDenied'

!		Instance methods for 'FilePermissionDenied'

category: 'Instance initialization'
method: FilePermissionDenied
initialize
  super initialize .
  gsNumber := ERR_FilePermissionDenied .
%

! Class implementation for 'FsFileDescriptorInvalid'

!		Class methods for 'FsFileDescriptorInvalid'

category: 'instance creation'
classmethod: FsFileDescriptorInvalid
fileDescriptor: aFileDescriptor

	^self new
		fileDescriptor: aFileDescriptor;
		yourself
%

!		Instance methods for 'FsFileDescriptorInvalid'

category: 'accessing'
method: FsFileDescriptorInvalid
fileDescriptor
	"Returns the file descriptor associated with this error."

	^fileDescriptor
%

category: 'accessing'
method: FsFileDescriptorInvalid
fileDescriptor: aFileDescriptor
	"Sets the file descriptor associated with this error."

	fileDescriptor := aFileDescriptor
%

category: 'initializing'
method: FsFileDescriptorInvalid
initialize

	super initialize.
	gsNumber := ERR_FsFileDescriptorInvalid
%

category: 'accessing'
method: FsFileDescriptorInvalid
messageText

	^super messageText ifNil: ['Cannot perform operations on invalid file descriptor.']
%

! Class implementation for 'FsUnixError'

!		Class methods for 'FsUnixError'

category: 'class initialization'
classmethod: FsUnixError
classLookupTable

	^SessionTemps current
		at: #'GsCurrentUnixErrorClassLookupTable'
		ifAbsentPut: [self initializeClassLookupTable]
%

category: 'accessing'
classmethod: FsUnixError
errorClassForErrorNumber: errorNumber
	^self classLookupTable at: errorNumber
%

category: 'accessing'
classmethod: FsUnixError
errorNumber
	self subclassResponsibility
%

category: 'class initialization'
classmethod: FsUnixError
initializeClassLookupTable
	"Create a table used to lookup a the UnixError class based on errno."

	| table organizer mySubclasses |
	table := KeyValueDictionary new.
	organizer := ClassOrganizer newWithRoot: self.
	mySubclasses := organizer allSubclassesOf: self.
	mySubclasses
		do: [ :subclass | 
			| errorNumber existing |
			errorNumber := subclass errorNumber.
			existing := table at: errorNumber ifAbsent: [  ].
			existing
				ifNotNil: [ :otherClass | 
					Error
						signal:
							subclass printString , ' and ' , otherClass printString
								, ' both attempting to use error number ' , errorNumber printString ].
			table at: errorNumber put: subclass ].
	^table
%

!		Instance methods for 'FsUnixError'

category: 'initialize'
method: FsUnixError
initialize

	super initialize.
	gsNumber := ERR_FsUnixError
%

! Class implementation for 'FsEACCES'

!		Class methods for 'FsEACCES'

category: 'accessing'
classmethod: FsEACCES
errorNumber
	^13
%

!		Instance methods for 'FsEACCES'

category: 'Instance initialization'
method: FsEACCES
initialize
  super initialize .
  gsNumber := ERR_FsEACCES .
%

! Class implementation for 'FsEBADF'

!		Class methods for 'FsEBADF'

category: 'accessing'
classmethod: FsEBADF
errorNumber
	^ 9
%

!		Instance methods for 'FsEBADF'

category: 'Instance initialization'
method: FsEBADF
initialize
  super initialize .
  gsNumber := ERR_FsEBADF .
%

! Class implementation for 'FsEEXIST'

!		Class methods for 'FsEEXIST'

category: 'accessing'
classmethod: FsEEXIST
errorNumber

	^17
%

!		Instance methods for 'FsEEXIST'

category: 'Instance initialization'
method: FsEEXIST
initialize
  super initialize .
  gsNumber := ERR_FsEEXIST .
%

! Class implementation for 'FsEINTR'

!		Class methods for 'FsEINTR'

category: 'accessing'
classmethod: FsEINTR
errorNumber
	^ 4
%

!		Instance methods for 'FsEINTR'

category: 'Instance initialization'
method: FsEINTR
initialize
  super initialize .
  gsNumber := ERR_FsEINTR .
%

! Class implementation for 'FsEINVAL'

!		Class methods for 'FsEINVAL'

category: 'accessing'
classmethod: FsEINVAL
errorNumber
	^ 22
%

!		Instance methods for 'FsEINVAL'

category: 'Instance initialization'
method: FsEINVAL
initialize
  super initialize .
  gsNumber := ERR_FsEINVAL .
%

! Class implementation for 'FsENOENT'

!		Class methods for 'FsENOENT'

category: 'accessing'
classmethod: FsENOENT
errorNumber
	^ 2
%

!		Instance methods for 'FsENOENT'

category: 'Instance initialization'
method: FsENOENT
initialize
  super initialize .
  gsNumber := ERR_FsENOENT .
%

! Class implementation for 'FsENOMEM'

!		Class methods for 'FsENOMEM'

category: 'accessing'
classmethod: FsENOMEM
errorNumber
	^ 12
%

!		Instance methods for 'FsENOMEM'

category: 'Instance initialization'
method: FsENOMEM
initialize
  super initialize .
  gsNumber := ERR_FsENOMEM .
%

! Class implementation for 'FsENOSPC'

!		Class methods for 'FsENOSPC'

category: 'accessing'
classmethod: FsENOSPC
errorNumber
	^ 28
%

!		Instance methods for 'FsENOSPC'

category: 'Instance initialization'
method: FsENOSPC
initialize
  super initialize .
  gsNumber := ERR_FsENOSPC .
%

! Class implementation for 'FsENOTDIR'

!		Class methods for 'FsENOTDIR'

category: 'accessing'
classmethod: FsENOTDIR
errorNumber

	^20
%

!		Instance methods for 'FsENOTDIR'

category: 'Instance initialization'
method: FsENOTDIR
initialize
  super initialize .
  gsNumber := ERR_FsENOTDIR .
%

! Class implementation for 'FsEROFS'

!		Class methods for 'FsEROFS'

category: 'accessing'
classmethod: FsEROFS
errorNumber
	^ 30
%

!		Instance methods for 'FsEROFS'

category: 'Instance initialization'
method: FsEROFS
initialize
  super initialize .
  gsNumber := ERR_FsEROFS .
%

! Class implementation for 'ZnError'

!		Instance methods for 'ZnError'

category: 'Instance initialization'
method: ZnError
initialize
  super initialize .
  gsNumber := ERR_ZnError .
%

! Class implementation for 'ZnCharacterEncodingError'

!		Instance methods for 'ZnCharacterEncodingError'

category: 'Instance initialization'
method: ZnCharacterEncodingError
initialize
  super initialize .
  gsNumber := ERR_ZnCharacterEncodingError .
%

! Class implementation for 'AbstractFileReference'

!		Instance methods for 'AbstractFileReference'

category: 'copying'
method: AbstractFileReference
, extension
	^ self resolve, extension
%

category: 'navigating'
method: AbstractFileReference
/ aString
	"aString is either a file or path.  If aString is relative, it is appended to the receiver, if it is absolute, an instance of the receiver with the path is answered.
	To mimick the behavior of unix, if aString is empty, ignore it.
	/tmp// is equivalent to /tmp/."

	^aString = ''
		ifTrue: [self copy]
		ifFalse: [self withPath: (self path resolvePath: (self fileSystem pathFromString: aString))]
%

category: 'comparing'
method: AbstractFileReference
<= other
	^ self path <= other path
%

category: 'accessing'
method: AbstractFileReference
absolutePath
	"Returns the absolute path"
	
	^ self subclassResponsibility
%

category: 'accessing'
method: AbstractFileReference
accessTime
	"Returns the access time for the referenced file."

	^self resolve accessTime
%

category: 'enumerating'
method: AbstractFileReference
allChildren
	"Returns all children of the receiver."

	| children |
	children := {}.
	self allChildrenDo: [:each | children add: each].
	^children
%

category: 'enumerating'
method: AbstractFileReference
allChildrenDo: aBlock
	"If the receiver is a file, evaluate aBlock w/ the receiver.
	If the receiver is a directory, evaluate aBlock with the receiver and all children in breadth-first order."

	| toEnumerate |
	toEnumerate := { self resolve }.
	[toEnumerate isEmpty]
		whileFalse:
			[| each |
			each := toEnumerate removeFirst.
			aBlock value: each.
			each isDirectory
				ifTrue: [toEnumerate addAll: each children]]
%

category: 'enumerating'
method: AbstractFileReference
allChildrenSelect: aBlock
	"Return all selected blocks."

	| selected |
	selected := {}.
	self allChildrenDo: [:each | (aBlock value: each) ifTrue: [selected add: each]].
	^selected
%

category: 'enumerating'
method: AbstractFileReference
allDirectories
	"Return all the directories recursively nested in the receiver."

	^self allChildrenSelect: [:each | each isDirectory]
%

category: 'enumerating'
method: AbstractFileReference
allFiles
	"Return all the files (not directories) recursively nested in the receiver."

	^self allChildrenSelect: [:each | each isFile]
%

category: 'streams'
method: AbstractFileReference
appendStream
	"Returns a stream which, if written to, will append any written
	data to the end of the file."

	^self appendStreamEncoded: self defaultEncoding
%

category: 'streams'
method: AbstractFileReference
appendStreamDo: aBlock
	"Pass a write stream to aBlock which appends to the backing file."

	| stream |
	stream := self appendStream.
	^[aBlock value: stream]
		ensure: [stream flush; close]
%

category: 'streams'
method: AbstractFileReference
appendStreamEncoded: encoding
	"Returns a stream which, if written to, will append any written
	data to the end of the file. The specified encoding should be
	used for any data written to the stream.

	Using FileOpeningOptions is likely the better choice but it is not
	supported by memory-based file systems yet"

	^(self writeStreamEncoded: encoding)
		setToEnd;
		yourself
%

category: 'streams'
method: AbstractFileReference
appendStreamEncoded: encoding
do: aBlock
	"Pass a write stream to aBlock which appends to the backing file."

	| stream |
	stream := self appendStreamEncoded: encoding.
	^[aBlock value: stream]
		ensure: [stream flush; close]
%

category: 'converting'
method: AbstractFileReference
asAbsolute 
	self subclassResponsibility
%

category: 'converting'
method: AbstractFileReference
asFileReference 
	self subclassResponsibility 
%

category: 'converting'
method: AbstractFileReference
asPath
	"Answer the receiver's path"

	self subclassResponsibility 
%

category: 'delegated'
method: AbstractFileReference
asPathWith: anObject
	^ self resolve asPathWith: anObject
%

category: 'resolving'
method: AbstractFileReference
asResolvedBy: anObject
	^ anObject resolveReference: self
%

category: 'accessing'
method: AbstractFileReference
base
	"Returns the base of the basename, i.e. /foo/gloops.taz base is 'gloops'"
	^ self fullPath base
%

category: 'accessing'
method: AbstractFileReference
basename
	"Returns the basename, i.e. /foo/gloops.taz basename is 'gloops.taz'"
	^ self fullPath basename
%

category: 'accessing'
method: AbstractFileReference
basenameWithIndicator
	"Returns the basename with the indicator appended, i.e. /foo/gloops.taz basenameWithIndicator is 'gloops.taz', whereras /foo basenameWithIndicator is 'foo/'" 
	^ self basename, self indicator   
%

category: 'accessing'
method: AbstractFileReference
basenameWithoutExtension
	"Returns the basename, i.e. /foo/gloops.taz basenameWithoutExtension is 'gloops'"
	^ self fullPath basenameWithoutExtension
%

category: 'accessing'
method: AbstractFileReference
basenameWithoutExtension: anExtension
	"Returns the basename without specified extension (if any)
	('/foo/gloops.taz' asFileReference basenameWithoutExtension: 'taz') = 'gloops'
	"
	^ self fullPath basenameWithoutExtension: anExtension
%

category: 'streams'
method: AbstractFileReference
binaryReadStream

	^self resolve binaryReadStreamOptions: self defaultOptionsForRead
%

category: 'streams'
method: AbstractFileReference
binaryReadStreamDo: aBlock

	| stream |
	stream := self binaryReadStream.
	^[aBlock value: stream]
		ensure: [stream close]
%

category: 'streams'
method: AbstractFileReference
binaryReadStreamDo: doBlock
ifAbsent: absentBlock

	^self isFile
		ifTrue: [self binaryReadStreamDo: doBlock]
		ifFalse: [absentBlock value]
%

category: 'streams'
method: AbstractFileReference
binaryReadStreamIfAbsent: absentBlock

	^self isFile
		ifTrue: [self binaryReadStream]
		ifFalse: [absentBlock value]
%

category: 'streams'
method: AbstractFileReference
binaryWriteStream
	"Answer a binary write stream on the receiver"

	^ self resolve binaryWriteStreamOptions: self defaultOptionsForWrite.
%

category: 'streams'
method: AbstractFileReference
binaryWriteStreamDo: aBlock
	"Pass a binary write stream on the receiver to the supplied block, and ensure that the stream is closed after evaluation."

	| stream |
	stream := self binaryWriteStream.
	^[aBlock value: stream]
		ensure: [stream close]
%

category: 'streams'
method: AbstractFileReference
binaryWriteStreamDo: doBlock
ifPresent: presentBlock

	^self isFile
		ifTrue: [presentBlock value]
		ifFalse: [self binaryWriteStreamDo: doBlock]
%

category: 'delegated'
method: AbstractFileReference
canonicalize
	"Answer the receiver with references to the current folder (.) and parent folder (..) removed"

	^ self withPath: self resolve path canonicalize
%

category: 'accessing'
method: AbstractFileReference
changeTime
	"Returns the change time for the referenced file."

	^self resolve changeTime
%

category: 'enumerating'
method: AbstractFileReference
childNames
	"Return the names of entries in a directory."

	| reference fileSystem names |
	reference := self resolve.
	fileSystem := reference fileSystem.
	names := {}.
	fileSystem
		childNamesAt: reference path
		ifAbsent: [fileSystem signalDirectoryDoesNotExist: reference path]
		ifNotDirectory: [DirectoryRequired signalWith: reference]
		do: [:name | names add: name].
	^names
%

category: 'enumerating'
method: AbstractFileReference
children
	"Answer an array containing references to the direct children of this reference."

	^self childNames collect: [:name | self / name]
%

category: 'comparing'
method: AbstractFileReference
contains: anObject
	"Return true if anObject is in a subfolder of me"
	^ anObject isContainedBy: self resolve
%

category: 'comparing'
method: AbstractFileReference
containsPath: aPath
	^ self fullPath containsPath: aPath
%

category: 'accessing'
method: AbstractFileReference
contents

	self readStreamDo: [ :stream | ^stream contents ]
%

category: 'operations'
method: AbstractFileReference
copyAllTo: aResolvable
	"Performs a deep copy of the receiver, to a location specified by the argument. If the receiver is a file, the file will be copied; if a directory, the directory and its contents will be copied recursively. The argument must be a reference that doesn't exist; it will be created by the copy."
	
	^self asFileReference copyAllTo: aResolvable
%

category: 'delegated'
method: AbstractFileReference
copyTo: aReference
	^ self resolve copyTo: aReference resolve
%

category: 'copying'
method: AbstractFileReference
copyWithPath: newPath
	self subclassResponsibility
%

category: 'enumerating'
method: AbstractFileReference
createDirectory
	"Verifies that the directory does not exist and only creates if necessary. Do not remove files contained if they exist.If the parents does not exist return an exception"
	self parent exists ifFalse:[DirectoryDoesNotExist signalWith: self parent path].
	^ self resolve ensureCreateDirectory
%

category: 'enumerating'
method: AbstractFileReference
createFile
	"Create if necessary a file for the receiver. If the parent does not exist return an exception"
	self parent exists ifFalse:[DirectoryDoesNotExist signalWith: self parent path].
	self writeStream close.
	
%

category: 'accessing'
method: AbstractFileReference
creationTime
	^ self resolve creationTime 
%

category: 'accessing'
method: AbstractFileReference
defaultEncoding

	^'utf8'
%

category: 'accessing'
method: AbstractFileReference
defaultOptionsForRead
	"Return the default options used when reading a file."

	^self fileOpeningOptionsClass readOnly
%

category: 'accessing'
method: AbstractFileReference
defaultOptionsForWrite
	"Return the default options used when writing a file."

	^self fileOpeningOptionsClass writeOnly
		create;
		yourself
%

category: 'accessing'
method: AbstractFileReference
defaultStringClassForReading

	^String isInUnicodeComparisonMode
		ifTrue: [Unicode7]
		ifFalse: [String]
%

category: 'operations'
method: AbstractFileReference
delete
	"Delete the receiver, does raise an error if it is not present."
	
	^ self resolve delete
%

category: 'operations'
method: AbstractFileReference
deleteAll
	"Delete this directory and all children of it, raise an error if the file does not exist."

	^self asFileReference deleteAll
%

category: 'operations'
method: AbstractFileReference
deleteAllChildren
	"delete all children of the receiver, raise an error if the receiver does not exist"
	
	self children do: [:aReference | aReference deleteAll ]
%

category: 'operations'
method: AbstractFileReference
deleteIfAbsent: aBlock
	"Delete the receiver, when it does not exist evaluate the block"
	self resolve deleteIfAbsent: aBlock
%

category: 'accessing'
method: AbstractFileReference
deviceId
	"Returns the device identifier associated with this reference."

	^self resolve deviceId
%

category: 'enumerating'
method: AbstractFileReference
directories
	"Return all the directories (by opposition to files) contained in the receiver"

	| reference fileSystem parentPath directories |
	reference := self resolve.
	fileSystem := reference fileSystem.
	parentPath := reference path.
	directories := {}.
	fileSystem
		directoryNamesAt: parentPath
		ifAbsent: [fileSystem signalDirectoryDoesNotExist: parentPath]
		ifNotDirectory: [fileSystem signalDirectoryDoesNotExist: parentPath]
		do: [:name | directories add: (self withPath: parentPath / name)].
	^directories
%

category: 'enumerating'
method: AbstractFileReference
directoryNames

	^ self directories collect: [:each | each basename]
%

category: 'operations'
method: AbstractFileReference
ensureCreateDirectory
	"Verifies that the directory does not exist and only creates if necessary. Do not remove files contained if they exist.Creates the parents if needed"
	^ self resolve ensureCreateDirectory
%

category: 'operations'
method: AbstractFileReference
ensureCreateFile
	"Create if necessary a file for the receiver. If the parent does not exist creates it"

	| fileDescriptor |
	(self exists and: [self isFile not])
		ifTrue: [].
	self parent ensureCreateDirectory.
	fileDescriptor := self openOptions: self defaultOptionsForWrite.
	fileDescriptor close
%

category: 'operations'
method: AbstractFileReference
ensureDelete
	"Delete the file and does not raise exception if it does not exist contrary to delete.
	However if it is a directory and it has children an error is signaled. If it is required to 
	delete even with children, use #ensureDeleteAll."
	
	self deleteIfAbsent: [].
%

category: 'operations'
method: AbstractFileReference
ensureDeleteAll
	"Delete this directory and all children of it, and does not raise an error if the file does not exist."
	
	self exists ifFalse: [^self].
	self deleteAll
	
%

category: 'operations'
method: AbstractFileReference
ensureDeleteAllChildren
	"delete all children of the receiver and does not raise an error if the receiver does not exist"
	
	self exists ifFalse: [ ^ self  ].
	self deleteAllChildren
%

category: 'delegated'
method: AbstractFileReference
exists
	"Return true if the file reference exist (e.g., if there is a file on the hard disk pointed by the file reference)
	
	E.g., (if you are on Unix or OSX)
	'/tmp/' asFileReference exists => true
	'/tmp/zorkbar' asFileReference exists => false
	"
	^ self resolve exists
%

category: 'accessing'
method: AbstractFileReference
extension
	
	^ self fullPath extension.
%

category: 'accessing'
method: AbstractFileReference
extensions
	  "#('foo' 'foo.tar' 'foo.tar.gz' 'foo.1.tar' 'foo.1.tar.gz') collect: [:thing| thing extensions] => #(#() #('tar') #('tar' 'gz') #('1' 'tar') #('1' 'tar' 'gz'))"
	
        ^ self fullPath extensions
%

category: 'enumerating'
method: AbstractFileReference
fileNames
	^ self files collect: [:each | each basename]
%

category: 'accessing'
method: AbstractFileReference
fileOpeningOptionsClass

	^self resolve fileOpeningOptionsClass
%

category: 'enumerating'
method: AbstractFileReference
files
	"Return all the files (as opposed to folders) contained in the receiver"
	
	| reference fileSystem parentPath files |
	reference := self resolve.
	fileSystem := reference fileSystem.
	parentPath := reference path.
	files := {}.
	fileSystem
		fileNamesAt: parentPath
		ifAbsent: [fileSystem signalDirectoryDoesNotExist: parentPath]
		ifNotDirectory: [DirectoryRequired signalWith: reference]
		do: [:name | files add: (self withPath: parentPath / name)].
	^files
%

category: 'accessing'
method: AbstractFileReference
fileSystem
	^ self resolve fileSystem
%

category: 'delegated'
method: AbstractFileReference
fullName

	^ self resolve fullName
%

category: 'accessing'
method: AbstractFileReference
fullNameWithIndicator
	"Returns the basename with the indicator appended, i.e. /foo/gloops.taz basenameWithIndicator is '/foo/gloops.taz', whereras /foo basenameWithIndicator is '/foo/'" 
	^ self fullName, self indicator   
%

category: 'accessing'
method: AbstractFileReference
fullPath
	"Returns the absolute path, better use absolutePath"
	
	^self resolve path
%

category: 'accessing'
method: AbstractFileReference
gid
	"Return the group id associated with this file."

	^self resolve gid
%

category: 'testing'
method: AbstractFileReference
hasChildren
	^self resolve hasChildren
%

category: 'testing'
method: AbstractFileReference
hasDirectories
	^self resolve hasDirectories
%

category: 'testing'
method: AbstractFileReference
hasFiles
	^self resolve hasFiles
%

category: 'comparing'
method: AbstractFileReference
hash
	"Hash is reimplemented because #= is reimplemented"
	^ self path  hash
%

category: 'controlling'
method: AbstractFileReference
ifAbsent: aBlock
	"Return self, or evaluate the block if I do not exist"

	^ self exists ifTrue: [ self ] ifFalse: [ aBlock cull: self ]
%

category: 'controlling'
method: AbstractFileReference
ifExists: aBlock
	"Evaluate the block, unless I do not exist. If the receiver exists, pass it as argument to the block."

	^ self exists ifTrue: [ aBlock cull: self ] ifFalse: [ self ]
%

category: 'controlling'
method: AbstractFileReference
ifExists: aBlock ifAbsent: anotherBlock
	"If the receiver exists, pass it as argument to aBlock. Else execute anotherBlock "

	^ self exists ifTrue: [ aBlock cull: self ] ifFalse: [ anotherBlock cull: self ]
%

category: 'controlling'
method: AbstractFileReference
ifFile: fBlock ifDirectory: dBlock ifAbsent: aBlock
	^ self isFile
		ifTrue: fBlock
		ifFalse: [
			self isDirectory
				ifTrue: dBlock
				ifFalse: aBlock ]
%

category: 'printing'
method: AbstractFileReference
indicator
	"Returns a string indicating the type of reference:
	- '?' for a non existing reference',
	- '/' for a directory,
	- the empty string for a file."
	"When this framework gets more complete, it is possible to extend this behavior with the following indicators (taken from unix ls utility):
	- '*' for a regular file that is executable
	- '@' for a symbolic link
	- '|' for FIFOs
	- '=' for sockets
	- '>' for doors"
	^ self exists
		ifTrue: [self isDirectory ifTrue: ['/'] ifFalse: ['']  ]
		ifFalse: ['?']
%

category: 'initialization'
method: AbstractFileReference
initialize
%

category: 'testing'
method: AbstractFileReference
isAbsolute 
	self subclassResponsibility 
%

category: 'testing'
method: AbstractFileReference
isBlock
	"Is this reference to a block device?"

	^self resolve isBlock
%

category: 'testing'
method: AbstractFileReference
isCharacter
	"Is this reference to a character device?"

	^self resolve isCharacter
%

category: 'testing'
method: AbstractFileReference
isChildOf: anObject
	^ self parent = anObject
%

category: 'comparing'
method: AbstractFileReference
isContainedBy: anObject
	"DoubleDispatch helper for #contains:"
	^ anObject containsReference: self resolve
%

category: 'testing'
method: AbstractFileReference
isDirectory
	^ self resolve isDirectory
%

category: 'testing'
method: AbstractFileReference
isExecutable
	"Is this reference to a something that is executable?"
	"This probably needs to take into account whether the 
	file owner is the process owner."

	^self permissions ownerExecute
%

category: 'testing'
method: AbstractFileReference
isFifo
	"Is this reference to a fifo file?"

	^self resolve isFifo
%

category: 'testing'
method: AbstractFileReference
isFile
	^ self resolve isFile
%

category: 'testing'
method: AbstractFileReference
isReadable
	^ self resolve isReadable
%

category: 'testing'
method: AbstractFileReference
isRegular
	"Is this reference to a regular file?"

	^self resolve isRegular
%

category: 'testing'
method: AbstractFileReference
isRelative 
	self subclassResponsibility 
%

category: 'testing'
method: AbstractFileReference
isRoot
	^ self resolve isRoot
%

category: 'testing'
method: AbstractFileReference
isSocket
	"Is this reference to a socket?"

	^self resolve isSocket
%

category: 'testing'
method: AbstractFileReference
isWritable
	^ self resolve isWritable
%

category: 'accessing'
method: AbstractFileReference
item
	^ self
%

category: 'navigating'
method: AbstractFileReference
makeRelative: anObject
	^ anObject relativeToReference: self resolve
%

category: 'accessing'
method: AbstractFileReference
modificationTime
	^ self resolve modificationTime 
%

category: 'operations'
method: AbstractFileReference
moveTo: aReference
	"Move the receiver in the location passed as argument.
	
	(FileSystem disk workingDirectory / 'paf' ) ensureCreateFile.
	(FileSystem disk workingDirectory / 'fooFolder') ensureCreateDirectory. 
	(FileSystem disk workingDirectory / 'paf' ) moveTo: (FileSystem disk workingDirectory / 'fooFolder' / 'paf')
	"
	^ self resolve moveTo: aReference
%

category: 'accessing'
method: AbstractFileReference
numberOfHardLinks
	"Returns the number of hard links to this file."

	^self resolve numberOfHardLinks
%

category: 'streams'
method: AbstractFileReference
openWritable: aBoolean

	^self resolve openWritable: aBoolean
%

category: 'delegated'
method: AbstractFileReference
parent

	^self resolve parent
%

category: 'delegated'
method: AbstractFileReference
parentUpTo: aParentDirName
	^ self withPath: (self path parentUpTo: aParentDirName)
%

category: 'accessing'
method: AbstractFileReference
path
	"Return the path internal representation that denotes the receiver in the context of its filesystem. "
	^ path
%

category: 'accessing'
method: AbstractFileReference
pathSegments
	^ self fullPath segments
%

category: 'delegated'
method: AbstractFileReference
pathString
	^ self resolve pathString
%

category: 'accessing'
method: AbstractFileReference
permissions
	"Return the FileSystemPermission for this node"
	^ self resolve permissions
%

category: 'streams'
method: AbstractFileReference
readStream

	^self readStreamEncoded: self defaultEncoding
%

category: 'streams'
method: AbstractFileReference
readStreamDo: aBlock

	| stream |
	stream := self readStream.
	^[aBlock value: stream]
		ensure: [stream close]
%

category: 'streams'
method: AbstractFileReference
readStreamDo: doBlock ifAbsent: absentBlock

	^self isFile 
		ifTrue: [self readStreamDo: doBlock]
		ifFalse: [absentBlock value]
%

category: 'streams'
method: AbstractFileReference
readStreamEncoded: anEncoding

	^self
		readStreamEncoded: anEncoding
		options: self defaultOptionsForRead
%

category: 'streams'
method: AbstractFileReference
readStreamEncoded: anEncoding
do: aBlock

	| stream |
	stream := self readStreamEncoded: anEncoding.
	^[aBlock value: stream] 
		ensure: [stream close]
%

category: 'streams'
method: AbstractFileReference
readStreamEncoded: anEncoding
options: openingOptions

	| binaryStream stream |
	binaryStream := self binaryReadStreamOptions: openingOptions.
	stream := self fileSystem isDiskFileSystem
		ifTrue: [ZnBufferedReadStream on: binaryStream]
		ifFalse: [binaryStream].
	^ ZnCharacterReadStream
		on: stream
		encoding: anEncoding
		stringClass: self defaultStringClassForReading
%

category: 'streams'
method: AbstractFileReference
readStreamIfAbsent: absentBlock

	^self isFile
		ifTrue: [self readStream]
		ifFalse: [absentBlock value]
%

category: 'navigating'
method: AbstractFileReference
relativeTo: landmark
	"Answer a new path relative to landmark."
	
	"parent/child/grandChild relativeTo: parent returns child/grandChild
	(Filesystem disk / 'griffle' / 'plonk' / 'nurp') relativeTo: (Filesystem disk / 'griffle') 
	returns plonk/nurp"

	^ landmark makeRelative: self resolve
%

category: 'navigating'
method: AbstractFileReference
relativeToPath: landmarkPath 
	
	^ self fullPath relativeTo: landmarkPath
%

category: 'navigating'
method: AbstractFileReference
relativeToReference: landmarkReference
	"Return the path of the receiver relative to landmarkReference."
	
	^ self fullPath relativeTo: landmarkReference path
%

category: 'operations'
method: AbstractFileReference
renameTo: newBasename
	self subclassResponsibility
%

category: 'navigating'
method: AbstractFileReference
resolve
	^ self subclassResponsibility 
%

category: 'navigating'
method: AbstractFileReference
resolve: anObject
	^ anObject asResolvedBy: self
%

category: 'navigating'
method: AbstractFileReference
resolvePath: aPath
	^ self withPath: (self path resolvePath: aPath)
%

category: 'navigating'
method: AbstractFileReference
resolveReference: aReference
	^ aReference isAbsolute
		ifTrue: [ aReference ]
		ifFalse: [ self withPath: aReference path ]
%

category: 'navigating'
method: AbstractFileReference
resolveString: aString 
	self subclassResponsibility
%

category: 'accessing'
method: AbstractFileReference
size
	"Return the size of the file in bytes."
	
	^ self resolve size
%

category: 'streams'
method: AbstractFileReference
streamWritable: writable
do: aBlock

	^writable
		ifTrue: [self writeStreamDo: aBlock]
		ifFalse: [self readStreamDo: aBlock]
%

category: 'accessing'
method: AbstractFileReference
targetPath
	"Return the part for this file. If this file is a symbolic link, return the path of the file being pointed at."

	^self resolve targetPath
%

category: 'accessing'
method: AbstractFileReference
uid
	"Return the user id associated with this file."

	^self resolve uid
%

category: 'navigating'
method: AbstractFileReference
withExtension: aString
	^ self withPath: (self path withExtension: aString)
%

category: 'copying'
method: AbstractFileReference
withoutExtension
  "Returns the new reference based on receiver with fullname without its extension"

  ^  (self parent / self basenameWithoutExtension)
%

category: 'navigating'
method: AbstractFileReference
withPath: newPath
	^ self path == newPath
		ifTrue: [ self ]
		ifFalse: [ self copyWithPath: newPath ]
%

category: 'streams'
method: AbstractFileReference
writeStream
	
	^self writeStreamEncoded: self defaultEncoding
%

category: 'streams'
method: AbstractFileReference
writeStreamDo: aBlock

	| stream |
	stream := self writeStream.
	^[aBlock value: stream]
		ensure: [stream flush; close]
%

category: 'streams'
method: AbstractFileReference
writeStreamDo: doBlock
ifPresent: presentBlock

	^self isFile
		ifTrue: [presentBlock value]
		ifFalse: [self writeStreamDo: doBlock]
%

category: 'streams'
method: AbstractFileReference
writeStreamEncoded: anEncoding

	^self
		writeStreamEncoded: anEncoding
		options: self defaultOptionsForWrite
%

category: 'streams'
method: AbstractFileReference
writeStreamEncoded: anEncoding
do: aBlock

	| stream |
	stream := self writeStreamEncoded: anEncoding.
	^[aBlock value: stream]
		ensure: [stream flush; close]
%

category: 'streams'
method: AbstractFileReference
writeStreamEncoded: anEncoding
options: openingOptions

	| binaryStream |
	binaryStream := self binaryWriteStreamOptions: openingOptions.
	^ZnCharacterWriteStream
		on: binaryStream
		encoding: anEncoding
%

category: 'streams'
method: AbstractFileReference
writeStreamIfPresent: presentBlock

	^self isFile 
		ifTrue: [presentBlock value]
		ifFalse: [self writeStream]
%

category: 'streams'
method: AbstractFileReference
writeStreamOptions: openingOptions
	
	^self
		writeStreamEncoded: self defaultEncoding
		options: openingOptions
%

! Class implementation for 'FileLocator'

!		Class methods for 'FileLocator'

category: 'origins'
classmethod: FileLocator
cache
	^ self origin: #cache
%

category: 'origins'
classmethod: FileLocator
cwd
	^ self workingDirectory
%

category: 'origins'
classmethod: FileLocator
desktop
	^ self origin: #desktop
%

category: 'origins'
classmethod: FileLocator
documents
	^ self origin: #documents
%

category: 'flushing'
classmethod: FileLocator
flushCaches
	self resolver flushCaches
%

category: 'instance creation'
classmethod: FileLocator
fromPath: aPath ifNone: notFoundBlock
	"Returns a file locator if aPath is a reference to a supported origin or is a child of an origin.
	If no locator matches, return the result of the evaluation of notFoundBlock.
	Locators are sorted so that the deepest matching origin path is returned.
	Ex: '/Users/me/Documents/foo.txt' will return a locator 
		with #documents origin (path /Users/me/Documents) and not #home (path /Users/me).
	Should not be called direcly. Prefer the use of Path or String>>#asFileLocatorOrReference. "

	| locators locatorsPaths |
	locators := self supportedOrigins collect: [ :origin | self origin: origin ].
	locatorsPaths := (locators collect: [ :e | e -> e asPath ]) asDictionary.
	(locators sort:	[ :a :b | (locatorsPaths at: b) <= (locatorsPaths at: a) ])
		do: [ :locator | 
			((locatorsPaths at: locator) = aPath or: [ (locatorsPaths at: locator) containsPath: aPath ])
				ifTrue: [ ^ locator resolve: (aPath relativeToPath: (locatorsPaths at: locator)) ] ].
	^ notFoundBlock value
%

category: 'instance creation'
classmethod: FileLocator
fromString: aString ifNone: notFoundBlock
	"Returns a file locator if aString converted as path is a reference to a supported origin or is a child of an origin.
	If no locator matches, return the result of the evaluation of notFoundBlock.
	Should not be called direcly. Prefer the use of Path or String>>#asFileLocatorOrReference "
	
	^self fromPath: aString asPath ifNone: notFoundBlock
%

category: 'gemstone-origins'
classmethod: FileLocator
gemLogDirectory
	"locator for the log directory (parent directory of gemLog)"

	^ self origin: #gemLogDirectory
%

category: 'origins'
classmethod: FileLocator
home
	^ self origin: #home
%

category: 'instance creation'
classmethod: FileLocator
origin: aSymbol 
	^ self origin: aSymbol path: Path workingDirectory
%

category: 'instance creation'
classmethod: FileLocator
origin: aSymbol path: aPath
	^ self basicNew 
			initializeWithOrigin: aSymbol path: aPath
%

category: 'origins'
classmethod: FileLocator
preferences
	^ self origin: #preferences
%

category: 'accessing'
classmethod: FileLocator
resolver

	^SystemResolver new
		addResolver: PlatformResolver forCurrentPlatform;
		addResolver: EnvironmentResolver new;
		yourself
%

category: 'origins'
classmethod: FileLocator
root
	^ FileSystem disk root
%

category: 'accessing'
classmethod: FileLocator
supportedOrigins
	| origins current |
	origins := IdentitySet new.
	current := self resolver.
	[current notNil] whileTrue:
		[origins addAll: current supportedOrigins.
		current := current next].
	^ origins
%

category: 'mac-origins'
classmethod: FileLocator
systemApplicationSupport
	^ self origin: #systemApplicationSupport
%

category: 'mac-origins'
classmethod: FileLocator
systemLibrary
	^ self origin: #systemLibrary
%

category: 'origins'
classmethod: FileLocator
temp
	^ self origin: #temp
%

category: 'mac-origins'
classmethod: FileLocator
userApplicationSupport
	^ self origin: #userApplicationSupport
%

category: 'unix-origins'
classmethod: FileLocator
userData
	^ self origin: #userData
%

category: 'mac-origins'
classmethod: FileLocator
userLibrary
	^ self origin: #userLibrary
%

category: 'origins'
classmethod: FileLocator
workingDirectory

	^self origin: #workingDirectory
%

!		Instance methods for 'FileLocator'

category: 'comparing'
method: FileLocator
= other
	^ self species = other species
		and: [origin = other origin
			and: [path = other path]]
%

category: 'accessing'
method: FileLocator
absolutePath
	"Return the absolute path"
	^ self resolve path
%

category: 'converting'
method: FileLocator
asAbsolute
	^ self 
%

category: 'converting'
method: FileLocator
asFileReference
	^ self resolve
%

category: 'converting'
method: FileLocator
asPath
	"Answer the receiver's path"

	^self resolve asPath
%

category: 'copying'
method: FileLocator
copyWithPath: newPath
	^ self class origin: origin path: newPath
%

category: 'error handling'
method: FileLocator
doesNotUnderstand: aMessage
	"Redirect message to the resolved version of this FileLocator.
	If FileReference won't understand the message send a normal DNU."

	| resolved |
	
	resolved := self resolve.
	(resolved respondsTo: aMessage selector)
		ifTrue: [ ^ resolved perform: aMessage selector withArguments: aMessage arguments ].
	
	^ super doesNotUnderstand: aMessage.
%

category: 'comparing'
method: FileLocator
hash
	^ origin hash bitXor: path hash
%

category: 'initialize-release'
method: FileLocator
initializeWithOrigin: aSymbol path: aPath
	self initialize.
	origin := aSymbol.
	path := aPath.
%

category: 'testing'
method: FileLocator
isAbsolute
	^ true
%

category: 'testing'
method: FileLocator
isRelative
	^ false
%

category: 'accessing'
method: FileLocator
origin
	^ origin
%

category: 'printing'
method: FileLocator
printOn: aStream
	| fs |
	aStream
		nextPut: ${;
		nextPutAll: origin;
		nextPut: $}.
	path isWorkingDirectory
		ifTrue: [ ^ self ].
	fs := self fileSystem.
	aStream nextPut: fs delimiter.
	fs printPath: path on: aStream
%

category: 'operations'
method: FileLocator
renameTo: newBasename
	
	| result |
	result := self resolve renameTo: newBasename.
	path size > 0
		ifTrue: [ path basename: newBasename ]
		ifFalse: [ path := result path ]
%

category: 'navigating'
method: FileLocator
resolve

	^(self class resolver resolve: origin)
		ifNotNil: [:ref | ref resolve: path]
%

category: 'navigating'
method: FileLocator
resolveString: aString
	| filesystem thePath |
	filesystem := (self class resolver resolve: origin) fileSystem.
	thePath := filesystem pathFromString: aString.
	^ self withPath: (path resolvePath: thePath)
%

! Class implementation for 'FileReference'

!		Class methods for 'FileReference'

category: 'cross platform'
classmethod: FileReference
/ aString
	"Answer a reference to the argument resolved against the root of the current disk filesystem."
	
	^ FileSystem disk / aString
%

category: 'accessing'
classmethod: FileReference
disk
	"Returns the disk-based FileSystem instance."

	^FileSystem disk
%

category: 'instance creation'
classmethod: FileReference
fileSystem: aFilesystem path: aPath
	^ self new setFileSystem: aFilesystem path: aPath
%

category: 'accessing'
classmethod: FileReference
memory
	"Returns a memory-based FileSystem instance."

	^FileSystem memory
%

category: 'instance creation'
classmethod: FileReference
newTempFilePrefix: prefix suffix: suffix
	| tmpDir random fileName |
	
	tmpDir := FileLocator temp asFileReference.
	[ 
		random := GsUuidV4 new asInteger asString.
		fileName := prefix , random , suffix.
		(tmpDir / fileName) exists ] whileTrue.
	^ tmpDir / fileName
%

!		Instance methods for 'FileReference'

category: 'navigating'
method: FileReference
, extension
	^ self withPath: self path, extension
%

category: 'comparing'
method: FileReference
= other
	"Two FileReferences are considered equal if they refer to the same file / directory.
	As paths can have multiple relative representations, compare the absolute paths."
	"Perform the path comparison last as conversion to absolute paths is relatively expensive"
	^ self species = other species
		and: [self fileSystem = other fileSystem
			and: [self absolutePath = other absolutePath]]
%

category: 'accessing'
method: FileReference
absolutePath
	"Return the absolute of the receiver"
	^ self path isRelative
		ifFalse: [ self path ]
		ifTrue: [ filesystem resolve: self path ]
%

category: 'accessing'
method: FileReference
accessTime

	^ filesystem accessTimeOf: self path
%

category: 'converting'
method: FileReference
asAbsolute
	"Return the receiver as an absolute file reference."
	
	^ self isAbsolute
		ifTrue: [ self ]
		ifFalse: [ filesystem referenceTo: (filesystem resolve: path) ]
%

category: 'converting'
method: FileReference
asFileReference
	^ self
%

category: 'converting'
method: FileReference
asPath
	"Answer the receivers path"

	^path
%

category: 'printing'
method: FileReference
asString
  "needed for informative topaz stack display"
  ^ path asString 
%

category: 'streams'
method: FileReference
binaryReadStreamOptions: options

	| fileDescriptor |
	self exists
		ifFalse: [^FileDoesNotExistException signalWith: self].
	self isFile
		ifFalse: [^FileRequired signalWith: self pathString].
	fileDescriptor := self openOptions: options.
	^fileDescriptor binaryReadStream
%

category: 'streams'
method: FileReference
binaryWriteStreamOptions: options
	"Answer a binary write stream on the receiver"

	| fileDescriptor |
	(self exists and: [self isFile not])
		ifTrue: [^FileRequired signalWith: self].
	fileDescriptor := self openOptions: options.
	^ZnBufferedWriteStream on: fileDescriptor binaryWriteStream
%

category: 'accessing'
method: FileReference
changeTime
	"Returns the change time of the referenced entity."

	^filesystem changeTimeOf: self path
%

category: 'comparing'
method: FileReference
containsReference: aReference
	^  aReference fileSystem = filesystem and: [path contains: aReference path]
%

category: 'operations'
method: FileReference
copyAllTo: aResolvable
	"Performs a deep copy of the receiver, to a location specified by the argument. If the receiver is a file, the file will be copied; if a directory, the directory and its contents will be copied recursively. The argument must be a reference that doesn't exist; it will be created by the copy."
	
	| source destination |
	source := self.
	destination := aResolvable resolve.
	source
		allChildrenDo:
			[:each | | target |
			target := destination resolve: (each relativeTo: source).
			each copyTo: target]
%

category: 'operations'
method: FileReference
copyTo: aReference
	self isDirectory
		ifTrue: [ aReference ensureCreateDirectory ]
		ifFalse: [ filesystem copy: path toReference: aReference ]
%

category: 'copying'
method: FileReference
copyWithPath: newPath
	^ filesystem referenceTo: newPath
%

category: 'accessing'
method: FileReference
creationTime 
	^ filesystem creationTimeOf: self path
%

category: 'operations'
method: FileReference
delete
	"Deletes the referenced file or directory. If the directory is not empty, 
	raises an error. Use #deleteAll to delete with the children."

	(self isSymlink not and: [self isDirectory and: [self hasChildren]]) 
		ifTrue: [DirectoryIsNotEmpty signalWith: self].
	filesystem delete: path
%

category: 'operations'
method: FileReference
deleteAll
	"Delete this directory and all children of it, raise an error if the file does not exist."

	| toDelete toTraverse |
	toTraverse := { self }.
	toDelete := { }.
	[toTraverse isEmpty]
		whileFalse:
			[| each |
			each := toTraverse removeLast.
			(each isSymlink or: [each isFile])
				ifTrue: [each delete]
				ifFalse: [each isDirectory
								ifTrue:
									[toTraverse addAll: each children.
									toDelete addLast: each]
								ifFalse: [FsError signal: self pathString asString, ' is not a file, symlink, or directory. Deletion is not supported.']]].
	toDelete reverseDo: [:each | each delete]
%

category: 'operations'
method: FileReference
deleteIfAbsent: aBlock
	self exists 
		ifTrue: [ self delete ]
		ifFalse: aBlock
%

category: 'accessing'
method: FileReference
deviceId
	"Returns the device identifier associated with this reference."

	^filesystem deviceIdOf: self path
%

category: 'operations'
method: FileReference
ensureCreateDirectory
	"Create if necessary a directory for the receiver."
	filesystem ensureCreateDirectory: path
	
%

category: 'testing'
method: FileReference
exists

	^ filesystem exists: path
%

category: 'accessing'
method: FileReference
fileOpeningOptionsClass
	"Returns the appropriate subclass of FsFileOpeningOptions for this entity."

	^filesystem fileOpeningOptionsClass
%

category: 'accessing'
method: FileReference
fileSystem
	"Return the filesystem to which the receiver belong."
	^ filesystem
%

category: 'accessing'
method: FileReference
fullName
	"Return the full path name of the receiver."
	^ filesystem stringFromPath: (filesystem resolve: path)
%

category: 'accessing'
method: FileReference
fullPath
	^ self path
%

category: 'accessing'
method: FileReference
gid
	"Return the group id associated with this file."

	^filesystem gidOf: self path
%

category: 'testing'
method: FileReference
hasChildren
	"Return whether the receiver has any children."
	"FileSystem workingDirectory hasChildren"

	filesystem
		childNamesAt: path
		ifAbsent: [^false]
		ifNotDirectory: [^false]
		do: [:each | ^true].
	^false
%

category: 'testing'
method: FileReference
hasDirectories
	"Return whether the receiver has children that are directories."
	"FileSystem workingDirectory hasDirectories"
	
	filesystem
		directoryNamesAt: path
		ifAbsent: [^false]
		ifNotDirectory: [^false]
		do: [:each | ^true].
	^false
%

category: 'testing'
method: FileReference
hasFiles
	"Return whether the receiver has children that are files."
	"FileSystem workingDirectory hasFiles"
	
	filesystem
		fileNamesAt: path
		ifAbsent: [^false]
		ifNotDirectory: [^false]
		do: [:each | ^true].
	^false
%

category: 'comparing'
method: FileReference
hash
	^ path hash bitXor: filesystem hash
%

category: 'accessing'
method: FileReference
inode
	"Returns the inode for this file."

	^filesystem inodeOf: self path
%

category: 'testing'
method: FileReference
isAbsolute
	^ path isAbsolute
%

category: 'testing'
method: FileReference
isBlock
	"Is this reference to a block device?"

	^filesystem isBlock: self path
%

category: 'testing'
method: FileReference
isCharacter
	"Is this reference to a character device?"

	^filesystem isCharacter: self path
%

category: 'testing'
method: FileReference
isDirectory
	^ filesystem isDirectory: path
%

category: 'testing'
method: FileReference
isFifo
	"Is this reference to a fifo file?"

	^filesystem isFifo: self path
%

category: 'testing'
method: FileReference
isFile
	^ filesystem isFile: path
%

category: 'testing'
method: FileReference
isReadable
	"Return true if the file can be read by this user."

	^[self binaryReadStreamDo: [:stream | true]]
		on: FilePermissionDenied
		do: [:ex | ex return: false]
%

category: 'testing'
method: FileReference
isRegular
	"Is this reference to a regular file?"

	^filesystem isRegular: self path
%

category: 'testing'
method: FileReference
isRelative
	^ path isRelative
%

category: 'testing'
method: FileReference
isRoot
	^ path isRoot
%

category: 'testing'
method: FileReference
isSocket
	"Is this reference to a socket?"

	^filesystem isSocket: self path
%

category: 'testing'
method: FileReference
isSymlink 
	^ filesystem isSymlink: path
%

category: 'testing'
method: FileReference
isWritable
	"Return true if the file can be written by this user."

	^[self binaryWriteStreamDo: [:stream | true]]
		on: FilePermissionDenied
		do: [:ex | ex return: false]
%

category: 'accessing'
method: FileReference
modificationTime 
	"Returns the last date of modification of self"
	^ filesystem modificationTimeOf: self path
%

category: 'operations'
method: FileReference
moveTo: aReference
	
	| result |
	result := self fileSystem 
		move: self path
		to: aReference resolve.
	result ifNotNil: [
		self setFileSystem: result fileSystem path: result path ].		
%

category: 'accessing'
method: FileReference
numberOfHardLinks
	"Returns the number of hard links to this file."

	^filesystem numberOfHardLinksOf: self path
%

category: 'operations'
method: FileReference
openOptions: options
	"Open the file using the specified options."

	^filesystem
		open: path
		options: options
%

category: 'streams'
method: FileReference
openWritable: isWritable

	| options |
	options := isWritable
		ifTrue: [self defaultOptionsForWrite]
		ifFalse: [self defaultOptionsForRead].
	^self openOptions: options
%

category: 'delegated'
method: FileReference
parent

	^self withPath: self path parent
%

category: 'printing'
method: FileReference
pathString
	"Return the full path name of the receiver."
	
	^ filesystem stringFromPath: (filesystem resolve: path)
%

category: 'accessing'
method: FileReference
permissions
	^ filesystem permissions: self path
%

category: 'operations'
method: FileReference
permissions: permissions
	"Set file permissions to those specified in the argument"

	^filesystem
		file: self path
		posixPermission: permissions posixPermission
%

category: 'printing'
method: FileReference
printOn: aStream

	filesystem forReferencePrintOn: aStream.
	aStream nextPutAll: ' @ '''.
	filesystem printPath: path on: aStream.
	aStream nextPutAll: ''''
%

category: 'operations'
method: FileReference
renameTo: newBasename
	
	| destinationPath |
	destinationPath := self fileSystem 
		rename: self 
		to: self parent / newBasename.
	
	destinationPath ifNotNil: [
		self 
			setFileSystem: filesystem 
			path: destinationPath ].
	^ self
		
%

category: 'accessing'
method: FileReference
resolve
	^ self
%

category: 'resolving'
method: FileReference
resolvePath: anObject
	^ self withPath: (path resolve: anObject)
%

category: 'resolving'
method: FileReference
resolveReference: aReference
	
	^ (filesystem = aReference fileSystem or: [aReference isRelative])
		ifTrue: [filesystem referenceTo: (path resolvePath: aReference path)]
		ifFalse: [aReference]
%

category: 'resolving'
method: FileReference
resolveString: aString 
	| thePath |
	thePath := filesystem pathFromString: aString.
	^ filesystem referenceTo: (path resolve: thePath)
%

category: 'operations'
method: FileReference
setAsWorkingDirectory
	"Set the current reference as the working directory"

	^filesystem setWorkingDirectory: self path
%

category: 'initialize-release'
method: FileReference
setFileSystem: aFilesystem path: aPath
	filesystem := aFilesystem.
	path := aPath
%

category: 'accessing'
method: FileReference
size
	^ filesystem sizeOf: path
%

category: 'operations'
method: FileReference
symlinkTo: aReference
	"Create a symlink, in the location of the receiver,
	that points to the argument reference."

	filesystem
		symlink: self pathString
		toTarget: aReference pathString
%

category: 'accessing'
method: FileReference
targetPath
	"Return the part for this file. If this file is a symbolic link, return the path of the file being pointed at."

	^filesystem targetPathOf: self path
%

category: 'accessing'
method: FileReference
uid
	"Return the user id associated with this file."

	^filesystem uidOf: self path
%

category: 'operations'
method: FileReference
uid: uid
gid: gid
	"Set the user and group ID for the represented file."
	"A reliable method of testing this has not yet been found.
	For now, no SUnit exists."

	^filesystem
		file: self path
		uid: uid
		gid: gid
%

category: 'private'
method: FileReference
_topazAsString
  "Used by topaz for object and frame display"
  | stream res str isDir |
  stream := PrintStream on: String new .
  filesystem forReferencePrintOn: stream .
  res := stream contents , ' @ '.
  res addAll:((isDir := self isDirectory) ifTrue:[ 'aDir ' ] ifFalse:[ 'aFile ']).
  stream := PrintStream on: (str := String new) .
  filesystem printPath: path on: stream.
  (isDir not and:[ str size > 60 ])
    ifTrue:[ res addAll: ' ... '; addAll: (str copyFrom: str size - 40 to: str size)]
   ifFalse:[ res addAll: str ].
  ^ res
%

! Class implementation for 'FileSystem'

!		Class methods for 'FileSystem'

category: 'instance creation'
classmethod: FileSystem
store: aStore
	"Create an instance of the appropriate FileSystem subclass."

	^aStore fileSystemClass store: aStore
%

!		Instance methods for 'FileSystem'

category: 'navigating'
method: FileSystem
* anObject
	"Return a relative reference."
	
	^ self referenceTo: (Path * anObject)
%

category: 'navigating'
method: FileSystem
/ anObject
	"Return the absolute reference obtained by resolving anObject against the
	root of this filesystem."
	
	^ self root / anObject
%

category: 'comparing'
method: FileSystem
= other

	^self species = other species and: [self store = other store]
%

category: 'navigating'
method: FileSystem
@ aPathString
	"Return a relative reference."
	
	^(aPathString beginsWith: self delimiter asString)
		ifTrue: [self referenceTo: (Path / aPathString)]
		ifFalse: [self referenceTo: (Path * aPathString)]
%

category: 'public'
method: FileSystem
accessTimeOf: aResolvable
	"Returns the access date of aResolvable"

	^self store accessTimeOf: (self resolve: aResolvable)
%

category: 'public'
method: FileSystem
changeTimeOf: aResolvable
	"Returns the change date of aResolvable"

	^self store changeTimeOf: (self resolve: aResolvable)
%

category: 'public'
method: FileSystem
checkName: aString fixErrors: fixErrors

	^self store
		checkName: aString
		fixErrors: fixErrors
%

category: 'public-enumerating'
method: FileSystem
childNamesAt: aResolvable
ifAbsent: absentBlock
ifNotDirectory: notDirectoryBlock
do: aBlock

	| path |
	path := self resolve: aResolvable.
	self store
		directoryAt: path
		ifAbsent: [^absentBlock value]
		ifNotDirectory: [^notDirectoryBlock value]
		entryNamesDo: aBlock
%

category: 'public'
method: FileSystem
close

	self store close
%

category: 'public'
method: FileSystem
copy: sourcePath ifAbsent: absentBlock to: destinationPath ifPresent: presentBlock
	"Copy the file referenced as sourcePath to the destination referred as destPath. Perform associate actions in case of problems."

	self store
		copy: (self resolve: sourcePath)
		ifAbsent: absentBlock
		to: (self resolve: destinationPath)
		ifPresent: presentBlock
		fileSystem: self
%

category: 'public'
method: FileSystem
copy: sourcePath to: destPath
	"Copy the file referenced as sourcePath to the destination referred as destPath.  
	If there is no file at sourcePath, raise FileDoesNotExist.
	If destPath is a file, raise FileExists."
	
	self
		copy: sourcePath
		ifAbsent: [ self store signalFileDoesNotExist: sourcePath ]
		to: destPath
		ifPresent: [ self store signalFileExists: destPath ]
%

category: 'public'
method: FileSystem
copy: aPath toReference: destinationReference

	^self = destinationReference fileSystem
		ifTrue: [ self copy: aPath to: destinationReference resolve path ]
		ifFalse: [ self copy: aPath toRemote: destinationReference ]
%

category: 'public'
method: FileSystem
copy: aPath
toRemote: destRef

	| inputStream path |
	path := self resolve: aPath.
	[inputStream := (self referenceTo: path) binaryReadStream.
	inputStream ifNil: [self store signalFileDoesNotExist: path].
	destRef fileSystem
		copyFrom: inputStream
		to: destRef path]
		ensure: [inputStream ifNotNil: [inputStream close]]
%

category: 'public'
method: FileSystem
copyAndDelete: sourcePath to: destination
	"Copy the file referenced as sourcePath to the destination referred as destPath.  
	If there is no file at sourcePath, raise FileDoesNotExist.
	If destPath is a file, raise FileExists.
	If an error occurs during the operation, try and roll back to the original state."
	
	[
		self copy: sourcePath toReference: destination.
		self delete: sourcePath.
	] on: Error do: [ :error |
		destination delete.
		error pass.
	]
%

category: 'private'
method: FileSystem
copyFrom: inputStream
to: destPath

	| buffer out |
	out := nil.
	(self exists: destPath)
		ifTrue: [self store signalFileExists: destPath].
	[out := (self referenceTo: destPath) binaryWriteStream.
	buffer := ByteArray new: 1024.
	[inputStream atEnd]
		whileFalse:
			[buffer := inputStream nextInto: buffer.
			out nextPutAll: buffer]]
		ensure: [out ifNotNil: [out close]]
%

category: 'public'
method: FileSystem
createDirectory: aResolvable
	"Resolve aResolvable into an absolute path, then as the store to create a directory there. 
	The store is expected to raise an exception if it cannot do so."

	^self store createDirectory: (self resolve: aResolvable)
%

category: 'public'
method: FileSystem
creationTimeOf: aResolvable
	"Returns the creation date of aResolvable"

	^self store creationTimeOf: (self resolve: aResolvable)
%

category: 'public'
method: FileSystem
delete: aResolvable

	self store delete: (self resolve: aResolvable)
%

category: 'public'
method: FileSystem
delimiter
	"Return path delimiter used by this filesystem."

	^self store delimiter
%

category: 'public-accessing'
method: FileSystem
deviceIdOf: aResolvable
	"Return the device id associated with this file."

	^self store deviceIdOf: (self resolve: aResolvable)
%

category: 'public-enumerating'
method: FileSystem
directoryNamesAt: aResolvable
ifAbsent: anAbsentBlock
ifNotDirectory: notDirectoryBlock
do: aBlock
	"Enumerate through the names of directories in aResolvable.
	Evaluate anAbsentBlock if aResolvable does not exist."

	| path |
	path := self resolve: aResolvable.
	self store
		directoryAt: path
		ifAbsent: [^anAbsentBlock value]
		ifNotDirectory: [^notDirectoryBlock value]
		directoryNamesDo: aBlock
%

category: 'public'
method: FileSystem
ensureCreateDirectory: aResolvable
	"Resolve the argument to an absolute path, then ask the store to make
	sure that all the directories contained in the argument path exist or are created."
	
	self store ensureCreateDirectory: (self resolve: aResolvable)
%

category: 'public'
method: FileSystem
exists: aResolvable
	"Resolve the argument, and answer true if the there is
	a file or directory at that path, false if there is not."
	
	^self store exists: (self resolve: aResolvable)
%

category: 'public'
method: FileSystem
extensionDelimiter
	^ $.
%

category: 'public-operations'
method: FileSystem
file: aResolvable
posixPermission: posixPermission
	"Set the permissions for the specified file."

	^self store
		file: (self resolve: aResolvable)
		posixPermission: posixPermission
%

category: 'public-operations'
method: FileSystem
file: aResolvable
uid: uid
gid: gid
	"Set the uid and gid for the specified file."

	^self store
		file: (self resolve: aResolvable)
		uid: uid
		gid: gid
%

category: 'public-enumerating'
method: FileSystem
fileNamesAt: aResolvable
ifAbsent: anAbsentBlock
ifNotDirectory: notDirectoryBlock
do: aBlock
	"Enumerate the files in the provided directory."

	| path |
	path := self resolve: aResolvable.
	self store
		directoryAt: path
		ifAbsent: [^anAbsentBlock value]
		ifNotDirectory: [^notDirectoryBlock value]
		fileNamesDo: aBlock
%

category: 'accessing'
method: FileSystem
fileOpeningOptionsClass
	"Return the proper subclass of FsFileOpeningOptions for this FileSystem."

	^self store fileOpeningOptionsClass
%

category: 'printing'
method: FileSystem
forReferencePrintOn: aStream

	self store forReferencePrintOn: aStream
%

category: 'public-accessing'
method: FileSystem
gidOf: aResolvable
	"Return the group id associated with this file."

	^self store gidOf: (self resolve: aResolvable)
%

category: 'comparing'
method: FileSystem
hash

	^self store hash
%

category: 'public'
method: FileSystem
inodeOf: aResolvable
	"Returns the access date of aResolvable"

	^self store inodeOf: (self resolve: aResolvable)
%

category: 'public-testing'
method: FileSystem
isBlock: aResolvable
	"Return true if the argument refers to a block device."

	^self store isBlock: (self resolve: aResolvable)
%

category: 'public-testing'
method: FileSystem
isCaseSensitive
	"This method doesn't really make a whole lot of sense in this form.
	On macOS and Linux, you could have a case-insensitive root but a
	case-sensitive /mnt directory. This should move to FileReference
	which should determine whether a specific entity is stored on a
	case-sensitive file system."

	^Error signal: 'FileSystem >> #isCaseSensitive requires rework.'
%

category: 'public-testing'
method: FileSystem
isCharacter: aResolvable
	"Return true if the argument refers to a character device."

	^self store isCharacter: (self resolve: aResolvable)
%

category: 'public-testing'
method: FileSystem
isDirectory: aResolvable
	"Resolve the argument, and answer true if the result refers
	to a directory, false if it refers to a file or doesn't exist."

	^self store isDirectory: (self resolve: aResolvable)
%

category: 'public-testing'
method: FileSystem
isFifo: aResolvable
	"Return true if the argument refers to a fifo file."

	^self store isFifo: (self resolve: aResolvable)
%

category: 'public-testing'
method: FileSystem
isFile: aResolvable
	"Resolve the argument, and answer true if the result refers
	to a file, false if it refers to a directory or doesn't exist."

	^self store isFile: (self resolve: aResolvable)
%

category: 'public-testing'
method: FileSystem
isRegular: aResolvable
	"Return true if the argument refers to a regular file."

	^self store isRegular: (self resolve: aResolvable)
%

category: 'public-testing'
method: FileSystem
isSocket: aResolvable
	"Return true if the argument refers to a socket file."

	^self store isSocket: (self resolve: aResolvable)
%

category: 'public-testing'
method: FileSystem
isSymlink: aResolvable
	"Resolve the argument, and answer true if the result refers
	to a directory, false if it refers to a file or doesn't exist."

	^self store isSymlink: (self resolve: aResolvable)
%

category: 'public'
method: FileSystem
modificationTimeOf: aResolvable
	"Returns the last date of modification of aResolvable"

	^self store modificationTimeOf: (self resolve: aResolvable)
%

category: 'public'
method: FileSystem
move: sourcePath to: destination
	"Move the file /directory referenced as sourcePath to the destination referred as destPath.  
	If there is no file at sourcePath, raise FileDoesNotExist.
	If destPath is a file, raise FileExists.
	If destPath is a directory, move the sourcePath in to the directory"

	| fullDestination |

	destination isFile ifTrue: [ FileExists signalWith: destination ].
	destination isDirectory
		ifTrue: [ fullDestination := destination / sourcePath basename ]
		ifFalse: [ fullDestination := destination ].
	self = destination fileSystem ifTrue: 
	[
		"Ideally we would test whether the source and destination are on the same filesystem from the OSs perspective.
		Since we can't do that, just try rename, and if that fails, copy and delete."
		[ self rename: sourcePath to: fullDestination resolve path ]
			on: Error
			do: [ :error | self copyAndDelete: sourcePath to: fullDestination ].
	] ifFalse:
		[ self copyAndDelete: sourcePath to: fullDestination ].
	^fullDestination
%

category: 'public'
method: FileSystem
numberOfHardLinksOf: aResolvable
	"Returns the hard links of aResolvable"

	^self store numberOfHardLinksOf: (self resolve: aResolvable)
%

category: 'public'
method: FileSystem
open
	"Some kinds of filesystems need to open connections to external resources. Does nothing by default."
	
	self store open
%

category: 'public'
method: FileSystem
open: aResolvable
options: openingOptions
	"Resolve aResolvable into an absolute path, then ask the store to open the file at
	that path using the specified access mode."

	| path |
	path := self resolve: aResolvable.
	^self store
		open: (FileReference fileSystem: self path: path) 
		options: openingOptions
%

category: 'converting'
method: FileSystem
pathFromObject: anObject 
	^ anObject asPathWith: self
%

category: 'converting'
method: FileSystem
pathFromString: aString

	^self store pathFromString: aString
%

category: 'public'
method: FileSystem
permissions: aResolvable
	"Resolve the argument and return the Permissions for this file or directory "

	^self store permissions: (self resolve: aResolvable)
%

category: 'printing'
method: FileSystem
printJsonOn: aStream
	"Print a JSON representation on the provided stream.
	For FileSystem this is defined as ""disk"" for disk-based
	instances and ""memory"" for memory-based instances."

	self subclassResponsibility
%

category: 'printing'
method: FileSystem
printPath: aPath on: aStream

	self store printPath: aPath on: aStream
%

category: 'public'
method: FileSystem
readStreamOn: aResolvable
	"Resolve the argument into an absolute path and open a file handle on the file
	at that path. Ask the handle to give us a read stream for reading the file."

	^ (self open: aResolvable options: self defaultOptionsForRead) readStream
%

category: 'public'
method: FileSystem
referenceTo: aResolvable 
	"Answer a reference to the argument from the context of the receiver filesystem.  	
		Example: Filesystem disk referenceTo: 'plonk.taz'"

	^ FileReference 
		fileSystem: self
		path: (self pathFromObject: aResolvable)
%

category: 'public'
method: FileSystem
rename: sourcePath ifAbsent: aBlock to: destPath ifPresent: pBlock
	"Rename the file referenced as sourcePath to the destination referred as destPath. 
	Perform associate actions in case of problems."
	
	| source destination |
	source := self resolve: sourcePath.
	destination := self resolve: destPath.
	self store
		rename: source
		ifAbsent: aBlock
		to: destination
		ifPresent: pBlock
		fileSystem: self.
	^destination
%

category: 'public'
method: FileSystem
rename: sourcePath to: destName
	"Rename the file referenced as sourcePath to destPath.  Raise exceptions 
	FileExists or FileDoesNotExist  if the operation fails"
	
	^self
		rename: sourcePath
		ifAbsent: [self store signalFileDoesNotExist: sourcePath]
		to: destName
		ifPresent: [self store signalFileExists: destName]
%

category: 'public'
method: FileSystem
resolve: aResolvable
	^ aResolvable asResolvedBy: self
%

category: 'navigating'
method: FileSystem
resolvePath: aPath
	"Return a path where the argument is resolved in the context of the
	receiver. The behavior is similar to the one of a command line.
		> cd /a/b/c
		> cd b
		The shell will attempt to make /a/b/c/b the current directory. "

	^ self workingDirectoryPath resolve: aPath
%

category: 'navigating'
method: FileSystem
resolveReference: aReference

	^aReference fileSystem = self
		ifTrue: [self workingDirectoryPath resolvePath: aReference path]
%

category: 'navigating'
method: FileSystem
resolveString: aString
	"Returns the root of the receiver filesystem, i.e. / on unix"
	
	^self workingDirectoryPath resolvePath: (self store pathFromString: aString)
%

category: 'accessing'
method: FileSystem
root
	"Returns the root of the receiver filesystem, i.e. / on unix"

	^self referenceTo: Path root
%

category: 'public-operations'
method: FileSystem
setWorkingDirectory: aResolvable
	"Set the current working directory"

	^self store setWorkingDirectory: (self resolve: aResolvable)
%

category: 'signaling'
method: FileSystem
signalDirectoryDoesNotExist: aPath

	^self store signalDirectoryDoesNotExist: aPath
%

category: 'public'
method: FileSystem
sizeOf: aResolvable
	"Resolve the argument and return the size for this file or directory "

	^self store sizeOf: (self resolve: aResolvable)
%

category: 'accessing'
method: FileSystem
store
	"Subclasses all must have a store but subclasses options differ.
	This accessor allows them to manage their variable lifetimes appropriately."

	^self subclassResponsibility
%

category: 'private-accessing'
method: FileSystem
store: aStore
	"Set the store instance variable taking into account lifetime considerations."

	self subclassResponsibility
%

category: 'converting'
method: FileSystem
stringFromPath: aPath

	^self store stringFromPath: aPath
%

category: 'public-operations'
method: FileSystem
symlink: linkPathString
toTarget: targetPathString
	"Create a symlink to the targetPathString
	at the location specified by linkPathString.
	Note: The caller is expected to provide
	path strings. Other resolvables are not
	supported."

	self subclassResponsibility
%

category: 'public'
method: FileSystem
targetPathOf: aResolvable
	"Return a path of the actual file location.
	For regular files, that is itself.
	For symlinks, that is the file pointed to."

	^self store targetPathOf: (self resolve: aResolvable)
%

category: 'public-accessing'
method: FileSystem
uidOf: aResolvable
	"Return the user id associated with this file."

	^self store uidOf: (self resolve: aResolvable)
%

category: 'accessing'
method: FileSystem
workingDirectory
	"Returns a reference to the current working directory of the VM.
	This may not be the same directory for the entire life of a VM, 
	since it can be set programmatically."

	^self referenceTo: self workingDirectoryPath
%

category: 'accessing'
method: FileSystem
workingDirectoryPath
	"Returns the absolute path string of the current working directory of the VM.
	This may not be the same directory for the entire life of a VM, 
	since it can be set programmatically."

	^self store currentWorkingDirectoryPath
%

category: 'public'
method: FileSystem
writeStreamOn: aResolvable
	"Open a write stream on the file referred by the argument. It can be a string or a path"

	^(self open: aResolvable options: self defaultOptionsForWrite) writeStream
%

! Class implementation for 'FsDiskFileSystem'

!		Class methods for 'FsDiskFileSystem'

category: 'instance creation'
classmethod: FsDiskFileSystem
store: aStore
	"FsDiskFileSystem dynamically obtains the correct store. This ensures committed instances
	do not cause runtime errors due to instance-level caches. Instances created with
	SystemUser may not be alterable in DataCurator for instance.
	Use FsDiskFileSystem class>>#new instead."

	^self shouldNotImplement: #store:
%

!		Instance methods for 'FsDiskFileSystem'

category: 'testing'
method: FsDiskFileSystem
isDiskFileSystem

	^true
%

category: 'printing'
method: FsDiskFileSystem
printJsonOn: aStream
	"Print a JSON representation on the provided stream.
	For FileSystem this is defined as ""disk"" for disk-based
	instances and ""memory"" for memory-based instances."

	aStream nextPutAll: '"disk"'
%

category: 'accessing'
method: FsDiskFileSystem
store
	"Returns the associated store, ensuring it is recreated if necessary."

	^DiskStore current
%

category: 'public-operations'
method: FsDiskFileSystem
symlink: linkPathString
toTarget: targetPathString
	"Create a symlink to the targetPathString
	at the location specified by linkPathString.
	Note: The caller is expected to provide
	path strings. Other resolvables are not
	supported."

	self store
		symlink: linkPathString
		toTarget: targetPathString
%

! Class implementation for 'FsMemoryFileSystem'

!		Class methods for 'FsMemoryFileSystem'

category: 'instance creation'
classmethod: FsMemoryFileSystem
store: aStore

	^self basicNew
		store: aStore;
		yourself
%

!		Instance methods for 'FsMemoryFileSystem'

category: 'testing'
method: FsMemoryFileSystem
isMemoryFileSystem

	^true
%

category: 'printing'
method: FsMemoryFileSystem
printJsonOn: aStream
	"Print a JSON representation on the provided stream.
	For FileSystem this is defined as ""disk"" for disk-based
	instances and ""memory"" for memory-based instances."

	aStream nextPutAll: '"memory"'
%

category: 'accessing'
method: FsMemoryFileSystem
store
	"Subclasses all must have a store but subclasses options differ.
	This accessor allows them to manage their variable lifetimes appropriately."

	^store
%

category: 'private-accessing'
method: FsMemoryFileSystem
store: aStore
	"Set the store instance variable taking into account lifetime considerations."

	store := aStore
%

category: 'public-operations'
method: FsMemoryFileSystem
symlink: linkPathString
toTarget: targetPathString
	"Create a symlink to the targetPathString
	at the location specified by linkPathString.
	Note: The caller is expected to provide
	path strings. Other resolvables are not
	supported."

	self error: 'Symlinks are not supported by memory-based FileSystem instances.'
%

! Class implementation for 'FileSystemHandle'

!		Class methods for 'FileSystemHandle'

category: 'instance creation'
classmethod: FileSystemHandle
on: aReference writable: aBoolean
	^ self new setReference: aReference writable: aBoolean
%

category: 'instance creation'
classmethod: FileSystemHandle
open: aReference writable: aBoolean
	^ (self on: aReference writable: aBoolean) open
%

!		Instance methods for 'FileSystemHandle'

category: 'public'
method: FileSystemHandle
at: index
	| buffer |
	buffer := ByteArray new: 1.
	self at: index read: buffer startingAt: 1 count: 1.
	^ buffer at: 1
%

category: 'public'
method: FileSystemHandle
at: index put: anObject
	| buffer |
	buffer := ByteArray with: (anObject isCharacter
		ifTrue: [ anObject codePoint ]
		ifFalse: [ anObject ]).
	self at: index write: buffer startingAt: 1 count: 1.
	
%

category: 'public'
method: FileSystemHandle
at: offset read: buffer startingAt: start count: count
	self subclassResponsibility
%

category: 'public'
method: FileSystemHandle
at: offset write: buffer startingAt: start count: count
	self subclassResponsibility
%

category: 'public'
method: FileSystemHandle
basicOpen
	"get the raw stream description from the filesystem's store"

	self subclassResponsibility
%

category: 'streams'
method: FileSystemHandle
binaryReadStream
	
	self subclassResponsibility 
%

category: 'streams'
method: FileSystemHandle
binaryWriteStream
	
	self subclassResponsibility 
%

category: 'public'
method: FileSystemHandle
close
	self subclassResponsibility
%

category: 'public'
method: FileSystemHandle
ensureClosed
	reference exists ifTrue: [self close]
%

category: 'accessing'
method: FileSystemHandle
fileSystem
	^ reference fileSystem 
%

category: 'public'
method: FileSystemHandle
flush
	self subclassResponsibility
%

category: 'accessing'
method: FileSystemHandle
fullName
	^ reference fullName
%

category: 'testing'
method: FileSystemHandle
isOpen
	self subclassResponsibility
%

category: 'testing'
method: FileSystemHandle
isWritable
	^ writable
%

category: 'public'
method: FileSystemHandle
open
	self subclassResponsibility
%

category: 'accessing'
method: FileSystemHandle
reference
	^ reference
%

category: 'public'
method: FileSystemHandle
reopen
	self close.
	self open
%

category: 'initialize-release'
method: FileSystemHandle
setReference: aReference writable: aBoolean
	reference := aReference resolve.
	writable := aBoolean
%

category: 'public'
method: FileSystemHandle
sync
	self subclassResponsibility
%

category: 'public'
method: FileSystemHandle
truncateTo: anInteger
	self subclassResponsibility
%

! Class implementation for 'MemoryHandle'

!		Class methods for 'MemoryHandle'

category: 'instance creation'
classmethod: MemoryHandle
reference: aFileReference
entry: anEntry
options: openingOptions

	^self new
		setReference: aFileReference entry: anEntry options: openingOptions;
		yourself
%

!		Instance methods for 'MemoryHandle'

category: 'public'
method: MemoryHandle
at: index
	^ entry at: index
%

category: 'public'
method: MemoryHandle
at: index put: anObject
	^ entry at: index put: anObject
%

category: 'public'
method: MemoryHandle
at: index read: aCollection startingAt: start count: count 
	^ entry at: index read: aCollection startingAt: start count: count 
%

category: 'public'
method: MemoryHandle
at: first write: aCollection startingAt: start count: count 

	writable ifFalse: [ self error: 'Attempted to write to read-only file.' ].
	entry at: first write: aCollection startingAt: start count: count.
%

category: 'public'
method: MemoryHandle
basicOpen
	"No work as entry is set upon creation"
%

category: 'streams'
method: MemoryHandle
binaryReadStream

	^ entry binaryReadStream
%

category: 'streams'
method: MemoryHandle
binaryWriteStream
	
	^ entry binaryWriteStream
%

category: 'public'
method: MemoryHandle
close
	self isOpen ifFalse: [ ^ self ].
	self truncate.
	entry := nil.
%

category: 'stream-protocol'
method: MemoryHandle
copyFrom: from to: position
	^ entry copyFrom: from to: position
%

category: 'public'
method: MemoryHandle
flush
	self truncate
%

category: 'private'
method: MemoryHandle
grow
	entry grow
%

category: 'stream-protocol'
method: MemoryHandle
grownBy: length
	entry grownBy: length
%

category: 'testing'
method: MemoryHandle
isOpen
	^ entry notNil
%

category: 'public'
method: MemoryHandle
open
%

category: 'initalize-release'
method: MemoryHandle
setReference: aReference
entry: anEntry
options: options

	reference := aReference resolve.
	entry := anEntry.
	writable := options isWriteOnly
%

category: 'accessing'
method: MemoryHandle
size
	"return the size for the interna"
	^ entry internalSize
%

category: 'public'
method: MemoryHandle
sync
	self flush
%

category: 'public'
method: MemoryHandle
truncate
	entry truncate
%

category: 'public'
method: MemoryHandle
truncateTo: anInteger
	entry truncateTo: anInteger
%

! Class implementation for 'FileSystemPermission'

!		Class methods for 'FileSystemPermission'

category: 'instance creation'
classmethod: FileSystemPermission
default
	^ self posixPermissions: 8r777
%

category: 'instance creation'
classmethod: FileSystemPermission
new 
	self error: 'Should not be called. Use #posixPermission: instead'
%

category: 'instance creation'
classmethod: FileSystemPermission
posixPermissions: aNumber
	^self basicNew 
		initialize: aNumber;
		yourself
%

!		Instance methods for 'FileSystemPermission'

category: 'comparing'
method: FileSystemPermission
< other
	^ posixPermission < other posixPermission
%

category: 'comparing'
method: FileSystemPermission
<= other
	^ (posixPermission > other posixPermission) not
%

category: 'comparing'
method: FileSystemPermission
= permissions

	^self species = permissions species and: [self posixPermission = permissions posixPermission]
%

category: 'comparing'
method: FileSystemPermission
> other
	^ other posixPermission < posixPermission
%

category: 'comparing'
method: FileSystemPermission
>= other
	^ other posixPermission <= posixPermission
%

category: 'accessing'
method: FileSystemPermission
groupExecute
	^ self permissionBitAt: 4
%

category: 'accessing'
method: FileSystemPermission
groupRead
	^ self permissionBitAt: 6
%

category: 'accessing'
method: FileSystemPermission
groupWrite
	^ self permissionBitAt: 5
%

category: 'comparing'
method: FileSystemPermission
hash

	^self species hash bitXor: self posixPermission hash
%

category: 'initialization'
method: FileSystemPermission
initialize
%

category: 'initialization'
method: FileSystemPermission
initialize: aNumber
	posixPermission := aNumber.
	self initialize.	
%

category: 'testing'
method: FileSystemPermission
isReadable
	^ self ownerRead
%

category: 'testing'
method: FileSystemPermission
isWritable
	^ self ownerWrite
%

category: 'accessing'
method: FileSystemPermission
otherExecute
	^ self permissionBitAt: 1
%

category: 'accessing'
method: FileSystemPermission
otherRead
	^ self permissionBitAt: 3
%

category: 'accessing'
method: FileSystemPermission
otherWrite
	^ self permissionBitAt: 2
%

category: 'accessing'
method: FileSystemPermission
ownerExecute
	^ self permissionBitAt: 7
%

category: 'accessing'
method: FileSystemPermission
ownerRead
	^ self permissionBitAt: 9
%

category: 'accessing'
method: FileSystemPermission
ownerWrite
	^ self permissionBitAt: 8
%

category: 'accessing'
method: FileSystemPermission
permissionBitAt: bitIndex
	^ (posixPermission bitAt: bitIndex) == 1
%

category: 'private'
method: FileSystemPermission
posixPermission
	^ posixPermission
%

category: 'printing'
method: FileSystemPermission
printOn: aStream
	aStream 
		"Owner"
		nextPut: (self ownerRead ifTrue: [ $r ] ifFalse: [ $- ]);
		nextPut: (self ownerWrite ifTrue: [ $w ] ifFalse: [ $- ]);
		nextPut: (self ownerExecute ifTrue: [ $x ] ifFalse: [ $- ]);
		"Group"
		nextPut: (self groupRead ifTrue: [ $r ] ifFalse: [ $- ]);
		nextPut: (self groupWrite ifTrue: [ $w ] ifFalse: [ $- ]);
		nextPut: (self groupExecute ifTrue: [ $x ] ifFalse: [ $- ]);
		"Other"
		nextPut: (self otherRead ifTrue: [ $r ] ifFalse: [ $- ]);
		nextPut: (self otherWrite ifTrue: [ $w ] ifFalse: [ $- ]);
		nextPut: (self otherExecute ifTrue: [ $x ] ifFalse: [ $- ])
		
%

! Class implementation for 'FileSystemResolver'

!		Class methods for 'FileSystemResolver'

category: 'instance creation'
classmethod: FileSystemResolver
new

	^ self basicNew
		initialize;
		yourself
%

!		Instance methods for 'FileSystemResolver'

category: 'accessing'
method: FileSystemResolver
addResolver: aResolver
	next
		ifNil: [next := aResolver]
		ifNotNil: [next addResolver: aResolver]
%

category: 'resolving'
method: FileSystemResolver
canResolve: aSymbol
	^ self supportedOrigins includes: aSymbol
%

category: 'accessing'
method: FileSystemResolver
flushCaches
	self flushLocalCache.
	next ifNotNil: [next flushCaches]
%

category: 'accessing'
method: FileSystemResolver
flushLocalCache
%

category: 'initialization'
method: FileSystemResolver
initialize
%

category: 'accessing'
method: FileSystemResolver
next
	^ next
%

category: 'resolving'
method: FileSystemResolver
resolve: aSymbol
	^ (self canResolve: aSymbol)
		ifTrue: [self perform: aSymbol]
		ifFalse: [self unknownOrigin: aSymbol]
%

category: 'resolving'
method: FileSystemResolver
resolveString: aString
	| decoded fs |
	"The argument string is actually a byte array encoded differently on each platform.
	We are transforming it to an image string.
	We assume for now that the string is utf8 encoded."
	decoded := aString decodeFromUTF8 asString.
	fs := FileSystem disk.
	^ FileReference 
		fileSystem: fs 
		path: (fs pathFromString: decoded)
%

category: 'resolving'
method: FileSystemResolver
supportedOrigins
	^ #()
%

category: 'resolving'
method: FileSystemResolver
unknownOrigin: aSymbol
	^ next ifNotNil: [next resolve: aSymbol]
%

! Class implementation for 'EnvironmentResolver'

!		Instance methods for 'EnvironmentResolver'

category: 'resolving'
method: EnvironmentResolver
canResolve: aSymbol

	self
		resolve: aSymbol
		ifUnknown: [^false].
	^true
%

category: 'resolving'
method: EnvironmentResolver
resolve: aSymbol

	^self
		resolve: aSymbol
		ifUnknown: [self unknownOrigin: aSymbol]
%

category: 'resolving'
method: EnvironmentResolver
resolve: aSymbol
ifUnknown: aBlock

	| envVar ref |
	envVar := System gemEnvironmentVariable: aSymbol.
	envVar == nil
		ifTrue: [^aBlock value].
	ref := self resolveString: envVar.
	ref exists
		ifFalse: [^aBlock value].
	^ref
%

! Class implementation for 'PlatformResolver'

!		Class methods for 'PlatformResolver'

category: 'instance creation'
classmethod: PlatformResolver
forCurrentPlatform

	^(System gemVersionAt: 'osName') = 'Darwin'
		ifTrue: [MacOSResolver new]
		ifFalse: [UnixResolver new]
%

category: 'accessing'
classmethod: PlatformResolver
platformName
	^ nil
%

!		Instance methods for 'PlatformResolver'

category: 'origins'
method: PlatformResolver
cache
	"Operating Systems often define standard locations for a personal cache directory. The cache directory is a user-specific non-essential (cached) place where data should be written."
	self subclassResponsibility
%

category: 'private'
method: PlatformResolver
cantFindOriginError
	^ Error signal: 'Can''t find the requested origin' 
%

category: 'origins'
method: PlatformResolver
desktop

	^self home / 'Desktop'
%

category: 'private'
method: PlatformResolver
directoryFromEnvVariableNamed: aString
	^ self directoryFromEnvVariableNamed: aString or: [ self cantFindOriginError ]
%

category: 'private'
method: PlatformResolver
directoryFromEnvVariableNamed: aString or: aBlock
	| envValue |
	envValue := [ System gemEnvironmentVariable: aString ]
		on: Error
		do: [ ^ aBlock value ].
	^ envValue isEmptyOrNil
		ifTrue: [ aBlock value ]
		ifFalse: [ self resolveString: envValue ]
%

category: 'origins'
method: PlatformResolver
documents

	^self home / 'Documents'
%

category: 'origins'
method: PlatformResolver
downloads

	^self home / 'Downloads'
%

category: 'origins'
method: PlatformResolver
home
	^ self subclassResponsibility
%

category: 'origins'
method: PlatformResolver
preferences
	^ self subclassResponsibility
%

category: 'resolving'
method: PlatformResolver
supportedOrigins
	^ #(home desktop documents preferences cache temp)
%

category: 'origins'
method: PlatformResolver
temp
	"Where to put files that are not supposed to last long"
	^ self subclassResponsibility 
%

! Class implementation for 'MacOSResolver'

!		Class methods for 'MacOSResolver'

category: 'accessing'
classmethod: MacOSResolver
platformName
	^  'Mac OS'
%

!		Instance methods for 'MacOSResolver'

category: 'origins'
method: MacOSResolver
cache
	^ self library / 'Caches'
%

category: 'origins'
method: MacOSResolver
home
	^ self directoryFromEnvVariableNamed: 'HOME'
%

category: 'origins'
method: MacOSResolver
library
	^ self userLibrary
%

category: 'origins'
method: MacOSResolver
preferences 

	^self library / 'Preferences'
%

category: 'resolving'
method: MacOSResolver
supportedOrigins
	^ super supportedOrigins , #(userApplicationSupport systemApplicationSupport systemLibrary userLibrary)
%

category: 'origins'
method: MacOSResolver
systemApplicationSupport
	^ self systemLibrary / 'Application Support'
%

category: 'origins'
method: MacOSResolver
systemLibrary
	^  FileSystem disk root / 'Library'
%

category: 'origins'
method: MacOSResolver
temp

	| tempPath |
	tempPath := System gemEnvironmentVariable: 'TMPDIR'.
	(tempPath beginsWith: '/private')
		ifFalse: [tempPath := '/private', tempPath]. "Avoid using symlink. /tmp, /var are symlinked to /private/tmp and /private/var."
	^FileSystem disk root resolve: tempPath
%

category: 'origins'
method: MacOSResolver
userApplicationSupport
	^self userLibrary / 'Application Support'
%

category: 'origins'
method: MacOSResolver
userLibrary
	^  self home / 'Library'
%

! Class implementation for 'UnixResolver'

!		Class methods for 'UnixResolver'

category: 'accessing'
classmethod: UnixResolver
platformName
	^  'Linux'
%

!		Instance methods for 'UnixResolver'

category: 'origins'
method: UnixResolver
cache
	"http://standards.freedesktop.org/basedir-spec/basedir-spec-latest.html"

	^ self directoryFromEnvVariableNamed: 'XDG_CACHE_HOME' or: [ self home / '.cache' ]
%

category: 'origins'
method: UnixResolver
desktop
	^ (self xdgUserDir: 'DESKTOP') ifNil: [ super desktop ]
%

category: 'origins'
method: UnixResolver
documents
	^ (self xdgUserDir: 'DOCUMENTS') ifNil: [ super documents ]
%

category: 'origins'
method: UnixResolver
home
	^ self directoryFromEnvVariableNamed: 'HOME'
%

category: 'origins'
method: UnixResolver
preferences
	"http://standards.freedesktop.org/basedir-spec/basedir-spec-latest.html"

	^ self directoryFromEnvVariableNamed: 'XDG_CONFIG_HOME' or: [ self home / '.config' ]
%

category: 'resolving'
method: UnixResolver
supportedOrigins
	^ super supportedOrigins , #( userData )
%

category: 'origins'
method: UnixResolver
temp
	^ FileSystem disk referenceTo: '/tmp'
%

category: 'origins'
method: UnixResolver
userData
	^ self directoryFromEnvVariableNamed: 'XDG_DATA_HOME' or: [ self home / '.local' / 'share' ]
%

category: 'helpers'
method: UnixResolver
xdgParseUserDirLine: aStream
	"Format is XDG_xxx_DIR=""$HOME/yyy"", where yyy is a shell-escaped homedir-relative path, or XDG_xxx_DIR=""/yyy"", where /yyy is an absolute path. No other format is supported."
	| path firstChar |
	(aStream next = $") ifFalse: [ ^ nil ].
	firstChar := aStream next.
	(#($$ $/) includes: firstChar) ifFalse: [ ^ nil ].
	path := firstChar = $$
				ifTrue: [ (aStream next: 5) = 'HOME/' ifFalse: [ ^ nil ].
					       self home / (aStream upTo: $") ]
				ifFalse: [ self resolveString: '/', (aStream upTo: $") ].
	^ path
%

category: 'helpers'
method: UnixResolver
xdgUserDir: userDirName
	"Read ~/.config/user-dirs.dirs to find the directory of userDirName (e.g., 'DESKTOP')"
	"http://freedesktop.org/wiki/Software/xdg-user-dirs"
	"This file is written by xdg-user-dirs-update If you want to change or add directories, just edit the line you're interested in. All local changes will be retained on the next run Format is XDG_xxx_DIR=""$HOME/yyy"", where yyy is a shell-escaped homedir-relative path, or XDG_xxx_DIR=""/yyy"", where /yyy is an absolute path. No other format is supported."
	| configFile |
	configFile := self preferences / 'user-dirs.dirs'.
	(configFile isFile and: [ configFile isReadable ]) ifFalse: [ ^ nil ].
	configFile readStreamDo: [ :stream | 
		[ stream atEnd ]
			whileFalse: [ 
				((stream peek ~= $#) and: [ (stream upTo: $=) = ('XDG_', userDirName, '_DIR') ])
							ifTrue: [ ^ self xdgParseUserDirLine: stream ]
							ifFalse: [ stream nextLine ] ] ].
	^ nil
%

! Class implementation for 'SystemResolver'

!		Instance methods for 'SystemResolver'

category: 'origins'
method: SystemResolver
gemLogDirectory
	"Answer the path to the gem log directory"

	| pathString |
	pathString := System gemLogPath.
	^pathString = ''
		ifTrue: [nil]
		ifFalse: [self  resolveString: pathString]
%

category: 'private'
method: SystemResolver
gemLogDirectoryDefined

	^System gemLogPath ~= ''
%

category: 'resolving'
method: SystemResolver
supportedOrigins

	^self gemLogDirectoryDefined
		ifTrue: [#( workingDirectory gemLogDirectory )]
		ifFalse: [#( workingDirectory )]
%

category: 'origins'
method: SystemResolver
workingDirectory
	"Returns the current working directory"

	^FileSystem disk workingDirectory
%

! Class implementation for 'FileSystemStore'

!		Class methods for 'FileSystemStore'

category: 'accessing'
classmethod: FileSystemStore
delimiter

	^ self subclassResponsibility
%

category: 'instance creation'
classmethod: FileSystemStore
new

	^self basicNew
		initialize;
		yourself
%

!		Instance methods for 'FileSystemStore'

category: 'public-attributes'
method: FileSystemStore
accessTimeOf: aPath
	"Return the access time of the File described by aPath"

	self signalUnsupportedAttribute
%

category: 'public-attributes'
method: FileSystemStore
changeTimeOf: aPath
	"Return the change time of the File described by aPath"

	self signalUnsupportedAttribute
%

category: 'public'
method: FileSystemStore
checkName: aString fixErrors: fixErrors
	^ self subclassResponsibility
%

category: 'other'
method: FileSystemStore
childNamesAt: path
ifAbsent: absentBlock
do: enumerator
%

category: 'abstract'
method: FileSystemStore
close
	"Some kinds of filesystems need to open connections to external resources"
%

category: 'private'
method: FileSystemStore
copy: sourcePath ifAbsent: absentBlock to: destinationPath ifPresent: presentBlock fileSystem: aFilesystem

	| buffer out in |
	
	in := nil.
	out := nil.
	buffer := nil.
	[
		in := (aFilesystem referenceTo: sourcePath) binaryReadStream.
		in ifNil: [ ^ absentBlock value ].
		
		(self exists: destinationPath)
			ifTrue: [ "cannot overwrite destination"
				^ presentBlock value ].
			
		out := (aFilesystem referenceTo: destinationPath) binaryWriteStream.
		
		[ in atEnd ]
			whileFalse: [ 
				buffer := in next: 1024.
				out nextPutAll: buffer ]]
	ensure: [ 
		in ifNotNil: [ in close ].
		out ifNotNil: [ out close ]]
%

category: 'abstract'
method: FileSystemStore
createDirectory: aPath
	self subclassResponsibility 
%

category: 'public-attributes'
method: FileSystemStore
creationTimeOf: aPath
	"Return the creation time of the File described by aPath"

	self signalUnsupportedAttribute
%

category: 'accessing'
method: FileSystemStore
currentWorkingDirectoryPath
	"Returns the current working directory as a Path."

	^self subclassResponsibility
%

category: 'abstract'
method: FileSystemStore
delete: aPath
	self subclassResponsibility 
%

category: 'abstract'
method: FileSystemStore
deleteAll: aPath
in: fileSystem

	self subclassResponsibility
%

category: 'accessing'
method: FileSystemStore
delimiter
	^ self class delimiter
%

category: 'public-attributes'
method: FileSystemStore
deviceIdOf: aPath
	"Return the device id associated with this file."

	self signalUnsupportedAttribute
%

category: 'public-enumerating'
method: FileSystemStore
directoryAt: aPath
ifAbsent: absentBlock
directoryNamesDo: aBlock
	"Enumerate through the directory names in the provided directory."

	self subclassResponsibility
%

category: 'private'
method: FileSystemStore
directoryAt: aPath
ifAbsent: absentBlock
entryNamesDo: aBlock
	"Enumerate through the entries in the provided directory."

	self subclassResponsibility
%

category: 'private'
method: FileSystemStore
directoryAt: aPath
ifAbsent: absentBlock
fileNamesDo: aBlock
	"Enumerate through the file names in the provided directory."

	self subclassResponsibility
%

category: 'public'
method: FileSystemStore
ensureCreateDirectory: aPath
	(self isDirectory: aPath) ifTrue: [ ^ self ].
	self ensureCreateDirectory: aPath parent.
	self createDirectory: aPath
%

category: 'public-testing'
method: FileSystemStore
exists: aPath

	self subclassResponsibility
%

category: 'public-operations'
method: FileSystemStore
file: aPath
posixPermission: posixPermission
	"Set the permissions for the specified file."

	self signalUnsupportedAttribute
%

category: 'public-operations'
method: FileSystemStore
file: aPath
uid: uid
gid: gid
	"Set the uid and gid for the specified file."

	self signalUnsupportedAttribute
%

category: 'private'
method: FileSystemStore
filename: aByteString matches: aByteString2
	^ aByteString = aByteString2
%

category: 'accessing'
method: FileSystemStore
fileSystemClass
	"Defines the correct subclass of FileSystem to use with this store."

	^self subclassResponsibility
%

category: 'public-attributes'
method: FileSystemStore
gidOf: aPath
	"Return the group id associated with this file."

	self signalUnsupportedAttribute
%

category: 'initialization'
method: FileSystemStore
initialize
%

category: 'public-attributes'
method: FileSystemStore
inodeOf: aPath
	"Return the size of the File described by aPath"

	self signalUnsupportedAttribute
%

category: 'public-testing'
method: FileSystemStore
isDirectory: aPath

	self subclassResponsibility
%

category: 'public-testing'
method: FileSystemStore
isFile: aPath

	self subclassResponsibility
%

category: 'public-testing'
method: FileSystemStore
isSymlink: aPath

	^self subclassResponsibility
%

category: 'public-testing'
method: FileSystemStore
isWritable: aPath

	self subclassResponsibility
%

category: 'public-attributes'
method: FileSystemStore
modificationTimeOf: aPath
	"Return the modification time of the File described by aPath"

	self signalUnsupportedAttribute
%

category: 'public-attributes'
method: FileSystemStore
numberOfHardLinksOf: aPath
	"Return the number of hard links of the File described by aPath"

	self signalUnsupportedAttribute
%

category: 'abstract'
method: FileSystemStore
open
	"Some kinds of filesystems need to open connections to external resources"
%

category: 'public'
method: FileSystemStore
open: aFileReference
options: options
	"Open the provided FileReference with the specific options provided."

	self subclassResponsibility
%

category: 'converting'
method: FileSystemStore
pathFromString: aString
	"Use the unix convention by default, since many filesystems are based on it."
	
	^ Path from: aString delimiter: self delimiter
%

category: 'public-attributes'
method: FileSystemStore
permissions: aPath
	"Returns the permissions for the entity at <aPath>"

	self signalUnsupportedAttribute
%

category: 'converting'
method: FileSystemStore
printPath: aPath on: out
	"Use the unix convention by default, since it's the most common."
	
	aPath isAbsolute ifTrue: [ out nextPut: self delimiter ].
	^ aPath printOn: out delimiter: self delimiter
%

category: 'private'
method: FileSystemStore
rename: sourcePath ifAbsent: absentBlock to: destinationPath ifPresent: presentBlock fileSystem: anFSFilesystem

	(self exists: destinationPath) ifTrue: [ ^ presentBlock value ].
	(self exists: sourcePath) ifFalse: [ ^ absentBlock value ].
	self rename: sourcePath to: destinationPath
%

category: 'abstract'
method: FileSystemStore
rename: sourcePath to: destinationPath
	self subclassResponsibility 
%

category: 'public-operations'
method: FileSystemStore
setWorkingDirectory: aResolveable
	"Set the working directory to the path provided."

	self signalUnsupportedAttribute
%

category: 'error signalling'
method: FileSystemStore
signalDirectoryDoesNotExist: aPath
	^ DirectoryDoesNotExist signalWith: aPath
%

category: 'error signalling'
method: FileSystemStore
signalDirectoryExists: aPath
	^ DirectoryExists signalWith: aPath
%

category: 'error signalling'
method: FileSystemStore
signalFileDoesNotExist: aPath
	^ FileDoesNotExistException signalWith: aPath
%

category: 'error signalling'
method: FileSystemStore
signalFileExists: aPath
	^ FileExists signalWith: aPath
%

category: 'error signalling'
method: FileSystemStore
signalUnsupportedAttribute

	^FileAttributeNotSupported signalWith: self
%

category: 'error signalling'
method: FileSystemStore
signalUnsupportedAttribute: attributeName

	^FileAttributeNotSupported signalWith: attributeName
%

category: 'public-attributes'
method: FileSystemStore
sizeOf: aPath
	"Return the size of the File described by aPath"

	self signalUnsupportedAttribute
%

category: 'converting'
method: FileSystemStore
stringFromPath: aPath
	^ String streamContents: [ :out | 
		self printPath: aPath on: out ]
%

category: 'public-attributes'
method: FileSystemStore
targetPathOf: aPath
	"Return a path of the actual file location.
	For regular files, that is itself.
	For symlinks, that is the file pointed to."

	self signalUnsupportedAttribute
%

category: 'public-attributes'
method: FileSystemStore
uidOf: aPath
	"Return the user id associated with this file."

	self signalUnsupportedAttribute
%

! Class implementation for 'DiskStore'

!		Class methods for 'DiskStore'

category: 'current'
classmethod: DiskStore
activeClass
	"Returns the DiskStore subclass that should be used."

	^DiskStore allSubclasses
		detect: [:each | each isActiveStore]
		ifNone: [self error: 'DiskStore does not support this Platform/OS']
%

category: 'current'
classmethod: DiskStore
cacheKey
	"The key used to lookup the DiskStore singleton in SessionTemps."

	^#'GsCurrentDiskStore'
%

category: 'current'
classmethod: DiskStore
createDefault

	^self activeClass new
%

category: 'current'
classmethod: DiskStore
current

	^SessionTemps current
		at: self cacheKey
		ifAbsentPut: [self createDefault]
%

category: 'current'
classmethod: DiskStore
currentFileSystem

	^FileSystem disk
%

category: 'public'
classmethod: DiskStore
delimiter
	^ self current delimiter
%

category: 'testing'
classmethod: DiskStore
isActiveStore
	"Returns true if this store is the active store for this platform."

	^false
%

category: 'public'
classmethod: DiskStore
maxFileNameLength
	self subclassResponsibility 
%

category: 'testing'
classmethod: DiskStore
osIs: anOS
on: anArch
	"Determine if the OS and Architecture match this system"

	^(System gemVersionAt: 'osName') = anOS and: [(System gemVersionAt: 'cpuArchitecture') = anArch]
%

category: 'current'
classmethod: DiskStore
resetCurrent

	SessionTemps current
		removeKey: self cacheKey
		ifAbsent: []
%

!		Instance methods for 'DiskStore'

category: 'comparing'
method: DiskStore
= other

	^self species = other species
%

category: 'accessing'
method: DiskStore
accessTimeOf: aPath
	"Return the size of the File described by aPath"

	^(self stat: aPath) accessTime asDateAndTime
%

category: 'accessing'
method: DiskStore
changeTimeOf: aPath
	"Return the size of the File described by aPath"

	^(self stat: aPath) changeTime asDateAndTime
%

category: 'public'
method: DiskStore
checkName: aFileName fixErrors: fixErrors
	"Check a string aFileName for validity as a file name. Answer the original file name if it is valid. If the name is not valid (e.g., it is too long or contains illegal characters) and fixing is false, raise an error. If fixing is true, fix the name (usually by truncating and/or tranforming characters), and answer the corrected name. The default behavior is just to truncate the name to the maximum length for this platform. Subclasses can do any kind of checking and correction appropriate for their platform."
	
	| maxLength |
	aFileName size = 0 ifTrue: [self error: 'zero length file name'].
	maxLength := self maxFileNameLength.
	aFileName size > maxLength
		ifTrue: [self error: 'file name is too long'].
	^aFileName
%

category: 'public'
method: DiskStore
createDirectory: path
	"Create a directory for the argument path. 
	If the path refers to an existing file, raise FileExists.
	If the path refers to an existing directory, raise DirectoryExists.
	If the parent directory of the path does not exist, raise DirectoryDoesNotExist"

	| pathString parent |
	pathString := self stringFromPath: path.
	[self libcStat mkdir: pathString]
		onException: { FsEACCES. FsUnixError }
		do:
			{
			
				[:ex | ex resignalAs: (FilePermissionDenied reference: path asFileReference)].

				[:ex |
				(self exists: path)
					ifTrue:
						[^(self isFile: path)
							ifTrue: [self signalFileExists: path]
							ifFalse: [self signalDirectoryExists: path]].
				parent := path parent.
				(self isDirectory: parent)
					ifFalse: [^self signalDirectoryDoesNotExist: parent].
				ex pass].
			}
%

category: 'accessing'
method: DiskStore
currentWorkingDirectoryPath
	"Answer an absolute Path for the current working directory of the VM."

	| pathString |
	pathString := self libcUnistd getcwd.
	^Path
		from: pathString
		delimiter: self delimiter
%

category: 'public'
method: DiskStore
delete: path

	| pathString |
	(self exists: path)
		ifFalse: [ ^ FileDoesNotExistException signalWith: path ].
	pathString := self stringFromPath: path.
	(self lstat: path) isDirectory
		ifTrue: [self libcUnistd rmdir: pathString]
		ifFalse: [self libcUnistd unlinkPath: pathString]
%

category: 'public-attributes'
method: DiskStore
deviceIdOf: aPath
	"Return the device id associated with this file."

	^(self stat: aPath) deviceId
%

category: 'public'
method: DiskStore
directoryAt: aPath
ifAbsent: absentBlock
ifNotDirectory: notDirectoryBlock
directoryNamesDo: aBlock
	"Enumerate through the directory names in the provided directory."

	^self
		directoryAt: aPath
		ifAbsent: absentBlock
		ifNotDirectory: notDirectoryBlock
		entriesDo:
			[:entry | | name isDirectory |
			name := entry basename.
			isDirectory := entry isDirectory
						or: [(entry isUnknown or: [entry isSymlink])
								and: [(self stat: aPath / entry basename) isDirectory]].
			(isDirectory and: [(name = '.' or: [name = '..']) not]) ifTrue: [aBlock value: name]]
%

category: 'private'
method: DiskStore
directoryAt: aPath
ifAbsent: absentBlock
ifNotDirectory: notDirectoryBlock
entriesDo: aBlock
	"Enumerate through the entries in the provided directory."

	| pathString dir dirent |
	pathString := self stringFromPath: aPath.
	dir := [self libcDirent openDirectoryStreamWithPath: pathString]
		onException:
			{
				FsENOTDIR.
				FsENOENT.
			}
		do:
			{
				[:ex | ^notDirectoryBlock value].
				[:ex | ^absentBlock value].
			}.
	[[dirent := self libcDirent readFromDirectoryStream: dir.
	dirent notNil]
		whileTrue:
			[aBlock value: dirent]]
		ensure: [self libcDirent closeDirectoryStream: dir]
%

category: 'public'
method: DiskStore
directoryAt: aPath
ifAbsent: absentBlock
ifNotDirectory: notDirectoryBlock
entryNamesDo: aBlock
	"Enumerate through the entry names in the provided directory."

	^self
		directoryAt: aPath
		ifAbsent: absentBlock
		ifNotDirectory: notDirectoryBlock
		entriesDo:
			[:entry | | name |
			name := entry basename.
			(name = '.' or: [name = '..'])
				ifFalse: [aBlock value: name]]
%

category: 'public'
method: DiskStore
directoryAt: aPath
ifAbsent: absentBlock
ifNotDirectory: notDirectoryBlock
fileNamesDo: aBlock
	"Enumerate through the file names in the provided directory."

	^self
		directoryAt: aPath
		ifAbsent: absentBlock
		ifNotDirectory: notDirectoryBlock
		entriesDo:
			[:entry | | name isFile |
			name := entry basename.
			isFile := entry isFile
						or: [(entry isUnknown or: [entry isSymlink])
								and: [(self stat: aPath / entry basename) isFile]].
			isFile ifTrue: [aBlock value: name]]
%

category: 'testing'
method: DiskStore
exists: aPath

	| stat |
	stat := [self lstat: aPath]
		on: FileDoesNotExistException
		do: [:ex | ^false].
	^true
%

category: 'public-operations'
method: DiskStore
file: aPath
posixPermission: posixPermission
	"Set the permissions for the specified file."

	| pathString |
	pathString := self stringFromPath: aPath.
	[self libcFcntl
		chmod: pathString
		mode: posixPermission]
		on: FsENOENT
		do: [:ex | FileDoesNotExistException signal: aPath].
	^nil
%

category: 'public-operations'
method: DiskStore
file: aPath
uid: uid
gid: gid
	"Set the uid and gid for the specified file."

	| pathString |
	pathString := self stringFromPath: aPath.
	[self libcUnistd
		chown: pathString
		uid: uid
		gid: gid]
		on: FsENOENT
		do: [:ex | FileDoesNotExistException signal: aPath].
	^nil
%

category: 'accessing'
method: DiskStore
fileOpeningOptionsClass
	"Returns the appropriate class used to represent FileOpeningOptions."

	^self subclassResponsibility
%

category: 'accessing'
method: DiskStore
fileSystemClass
	"Defines the correct subclass of FileSystem to use with this store."

	^FsDiskFileSystem
%

category: 'printing'
method: DiskStore
forReferencePrintOn: aStream
	aStream nextPutAll: 'FileReference disk'
%

category: 'public-attributes'
method: DiskStore
gidOf: aPath
	"Return the group id associated with this file."

	^(self stat: aPath) gid
%

category: 'comparing'
method: DiskStore
hash

	^self species hash
%

category: 'accessing'
method: DiskStore
inodeOf: aPath
	"Returns the path's inode"

	^(self stat: aPath) inode
%

category: 'testing'
method: DiskStore
isBlock: aPath
	"Return true if the argument refers to a block device."

	aPath isRoot ifTrue: [^false].
	^[(self stat: aPath) isBlock]
		on: FileDoesNotExistException
		do: [:ex | ex return: false]
%

category: 'testing'
method: DiskStore
isCharacter: aPath
	"Return true if the argument refers to a character device."

	^(self stat: aPath) isCharacter
%

category: 'testing'
method: DiskStore
isDirectory: aPath

	aPath isRoot ifTrue: [^true].
	^[(self stat: aPath) isDirectory]
		on: FileDoesNotExistException
		do: [:ex | ex return: false]
%

category: 'testing'
method: DiskStore
isDiskFileSystem
	^ true
%

category: 'testing'
method: DiskStore
isFifo: aPath
	"Return true if the argument refers to a fifo file."

	aPath isRoot ifTrue: [^false].
	^[(self stat: aPath) isFifo]
		on: FileDoesNotExistException
		do: [:ex | ex return: false]
%

category: 'testing'
method: DiskStore
isFile: aPath

	aPath isRoot ifTrue: [^false].
	^[(self stat: aPath) isFile]
		on: FileDoesNotExistException
		do: [:ex | ex return: false]
%

category: 'testing'
method: DiskStore
isRegular: aPath
	"Return true if the argument refers to a regular file."

	^self isFile: aPath
%

category: 'testing'
method: DiskStore
isSocket: aPath
	"Return true if the argument refers to a socket file."

	aPath isRoot ifTrue: [^false].
	^[(self stat: aPath) isSocket]
		on: FileDoesNotExistException
		do: [:ex | ex return: false]
%

category: 'testing'
method: DiskStore
isSymlink: aPath

	aPath isRoot ifTrue: [^false].
	^[(self lstat: aPath) isSymlink]
		on: FileDoesNotExistException
		do: [:ex | ex return: false]
%

category: 'accessing'
method: DiskStore
libcDirent

	^libcDirent
%

category: 'accessing'
method: DiskStore
libcFcntl

	^libcFcntl
%

category: 'accessing'
method: DiskStore
libcStat

	^libcStat
%

category: 'accessing'
method: DiskStore
libcStdio

	^libcStdio
%

category: 'accessing'
method: DiskStore
libcUnistd

	^libcUnistd
%

category: 'public'
method: DiskStore
lstat: aPath

	| pathString |
	pathString := self stringFromPath: aPath.
	^[self libcStat lstat: pathString]
		on: FsENOENT
		do: [:ex | self signalFileDoesNotExist: aPath]
%

category: 'public'
method: DiskStore
maxFileNameLength
	"Returns the max file name length for this store."

	self subclassResponsibility
%

category: 'accessing'
method: DiskStore
modificationTimeOf: aPath
	"Return the size of the File described by aPath"

	^(self stat: aPath) modificationTime asDateAndTime
%

category: 'public-attributes'
method: DiskStore
numberOfHardLinksOf: aPath
	"Return the number of hard links of the File described by aPath"

	^(self stat: aPath) numberOfHardLinks
%

category: 'public'
method: DiskStore
open: aFileReference
options: options

	| fd |
	fd := [self libcFcntl
				open: aFileReference pathString
				flags: options flags
				mode: options modeBits]
			onException: {FsENOENT. FsEACCES}
			do:
				{
					[:ex | | parent |
					parent := aFileReference parent.
					parent exists
						ifTrue: [self signalFileDoesNotExist: aFileReference fullPath]
						ifFalse: [self signalDirectoryDoesNotExist: parent]].

					[:ex | ex resignalAs: (FilePermissionDenied reference: aFileReference)]
				}.
	^FsFileDescriptor fd: fd
%

category: 'public'
method: DiskStore
permissions: aPath

	| stat |
	stat := self stat: aPath.
	^FileSystemPermission posixPermissions: stat permission
%

category: 'public'
method: DiskStore
rename: sourcePath to: destinationPath

	| sourcePathString targetPathString |
	sourcePathString := self stringFromPath: sourcePath.
	targetPathString := self stringFromPath: destinationPath.
	self libcStdio
		rename: sourcePathString
		to: targetPathString
%

category: 'private'
method: DiskStore
rootNode
	^ #('' 0 0 true 0 8r555)
%

category: 'public-operations'
method: DiskStore
setWorkingDirectory: aPath
	"Set the working directory to the path provided."

	| pathString |
	pathString := self stringFromPath: aPath.
	[[self libcUnistd
		chdir: pathString]
		on: FsENOENT
		do: [:ex | DirectoryDoesNotExist signal: aPath]]
		on: FsENOTDIR
		do: [:ex | DirectoryRequired signal: aPath].
	^true
%

category: 'accessing'
method: DiskStore
sizeOf: aPath
	"Return the size of the File described by aPath"

	^(self stat: aPath) size
%

category: 'public'
method: DiskStore
stat: aPath

	| pathString |
	pathString := self stringFromPath: aPath.
	^[self libcStat stat: pathString]
		on: FsENOENT
		do: [:ex | self signalFileDoesNotExist: aPath]
%

category: 'public-operations'
method: DiskStore
symlink: linkPathString
toTarget: targetPathString
	"Create a symlink to the targetPathString
	at the location specified by linkPathString."

	[[self libcUnistd
		symlink: linkPathString
		toTarget: targetPathString]
		on: FsEACCES
		do: [:ex | FilePermissionDenied signalWith: linkPathString asFileReference]]
		on: FsEEXIST
		do: [:ex | FileExists signalWith: linkPathString asFileReference].
	^true
%

category: 'public-attributes'
method: DiskStore
uidOf: aPath
	"Return the user id associated with this file."

	^(self stat: aPath) uid
%

! Class implementation for 'UnixStore'

!		Class methods for 'UnixStore'

category: 'public'
classmethod: UnixStore
delimiter
	^ $/
%

category: 'public'
classmethod: UnixStore
maxFileNameLength

	^ 255
%

!		Instance methods for 'UnixStore'

category: 'public'
method: UnixStore
checkName: aFileName fixErrors: fixing
	"Check if the file name contains any invalid characters"
	| fName |
	fName := super checkName: aFileName fixErrors: fixing.
	
	(fName includes: self delimiter) ifFalse:
		[^fName].
	
	fixing ifFalse: [self error:'Invalid file name'].
	
	^ fName copyReplaceAll: self delimiter asString with: '#'
%

! Class implementation for 'FsLinuxStore'

!		Instance methods for 'FsLinuxStore'

category: 'accessing'
method: FsLinuxStore
maxFileNameLength
	"Returns the max file name length"

	^4096
%

! Class implementation for 'FsLinuxStore_aarch64'

!		Class methods for 'FsLinuxStore_aarch64'

category: 'testing'
classmethod: FsLinuxStore_aarch64
isActiveStore
	"Returns true if this store is the active store for this platform."

	^self
		osIs: 'Linux'
		on: 'aarch64'
%

!		Instance methods for 'FsLinuxStore_aarch64'

category: 'accessing'
method: FsLinuxStore_aarch64
fileOpeningOptionsClass
	"Returns the appropriate class used to represent FileOpeningOptions."

	^FsFileOpeningOptions_Linux_aarch64
%

category: 'initializing'
method: FsLinuxStore_aarch64
initialize

	super initialize.
	libcDirent := FsLibcDirent_Linux new.
	libcFcntl := FsLibcFcntl_Linux new.
	libcUnistd := FsLibcUnistd_Linux new.
	libcStat := FsLibcStat_Linux_aarch64 new.
	libcStdio := FsLibcStdio_Linux new
%

! Class implementation for 'FsLinuxStore_x64'

!		Class methods for 'FsLinuxStore_x64'

category: 'testing'
classmethod: FsLinuxStore_x64
isActiveStore
	"Returns true if this store is the active store for this platform."

	^self
		osIs: 'Linux'
		on: 'x86-64'
%

!		Instance methods for 'FsLinuxStore_x64'

category: 'accessing'
method: FsLinuxStore_x64
fileOpeningOptionsClass
	"Returns the appropriate class used to represent FileOpeningOptions."

	^FsFileOpeningOptions_Linux_x64
%

category: 'initializing'
method: FsLinuxStore_x64
initialize

	super initialize.
	libcDirent := FsLibcDirent_Linux new.
	libcFcntl := FsLibcFcntl_Linux new.
	libcUnistd := FsLibcUnistd_Linux new.
	libcStat := FsLibcStat_Linux_x64 new.
	libcStdio := FsLibcStdio_Linux new
%

! Class implementation for 'FsMacOSStore'

!		Instance methods for 'FsMacOSStore'

category: 'accessing'
method: FsMacOSStore
fileOpeningOptionsClass
	"Returns the appropriate class used to represent FileOpeningOptions."

	^FsFileOpeningOptions_macOS
%

category: 'accessing'
method: FsMacOSStore
maxFileNameLength
	"Returns the max file name length"

	^1024
%

! Class implementation for 'FsMacOSStore_arm64'

!		Class methods for 'FsMacOSStore_arm64'

category: 'testing'
classmethod: FsMacOSStore_arm64
isActiveStore
	"Returns true if this store is the active store for this platform."

	^self
		osIs: 'Darwin'
		on: 'arm64'
%

!		Instance methods for 'FsMacOSStore_arm64'

category: 'initializing'
method: FsMacOSStore_arm64
initialize

	super initialize.
	libcDirent := FsLibcDirent_macOS_arm64 new.
	libcFcntl := FsLibcFcntl_macOS new.
	libcUnistd := FsLibcUnistd_macOS new.
	libcStat := FsLibcStat_macOS_arm64 new.
	libcStdio := FsLibcStdio_macOS new
%

! Class implementation for 'FsMacOSStore_x64'

!		Class methods for 'FsMacOSStore_x64'

category: 'testing'
classmethod: FsMacOSStore_x64
isActiveStore
	"Returns true if this store is the active store for this platform."

	^self
		osIs: 'Darwin'
		on: 'x86-64'
%

!		Instance methods for 'FsMacOSStore_x64'

category: 'initializing'
method: FsMacOSStore_x64
initialize

	super initialize.
	libcDirent := FsLibcDirent_macOS_x64 new.
	libcFcntl := FsLibcFcntl_macOS new.
	libcUnistd := FsLibcUnistd_macOS new.
	libcStat := FsLibcStat_macOS_x64 new.
	libcStdio := FsLibcStdio_macOS new
%

! Class implementation for 'MemoryStore'

!		Class methods for 'MemoryStore'

category: 'current'
classmethod: MemoryStore
currentFileSystem

	^SessionTemps current
		at: #MemoryStoreCurrentFS
		ifAbsentPut: [FsMemoryFileSystem store: MemoryStore new]
%

category: 'public'
classmethod: MemoryStore
delimiter
	^ $/
%

category: 'class initialization'
classmethod: MemoryStore
reset

	SessionTemps current removeKey: #MemoryStoreCurrentFS
%

category: 'system startup'
classmethod: MemoryStore
startUp
	self reset
%

!		Instance methods for 'MemoryStore'

category: 'accessing'
method: MemoryStore
changeTimeOf: aPath
	"Return the date of change of the File described by aPath"

	^self
		entryAt: aPath
		ifPresent: [:entry | entry modificationTime]
		ifAbsent: [self signalFileDoesNotExist: aPath]
%

category: 'public'
method: MemoryStore
checkName: aString fixErrors: fixErrors
	aString ifEmpty: [ self error: 'zero length file name' ].
	^ aString
%

category: 'private'
method: MemoryStore
copy: sourcePath ifAbsent: absentBlock to: destinationPath ifPresent: presentBlock fileSystem: aFilesystem
        | sourceNode destinationNode |

        sourceNode := self
                entryAt: sourcePath
                ifPresent: [ :source | source ]
                ifAbsent: [ ^ absentBlock value].

        sourceNode isDirectory
                ifTrue: [ ^ absentBlock value ].

        destinationNode := self
                entryAt: destinationPath parent
                ifPresent: [ :destination |  destination ]
                ifAbsent: [ ^ self signalDirectoryDoesNotExist: destinationPath parent ].

        destinationNode isFile
                ifTrue: [ self signalDirectoryDoesNotExist: destinationPath parent ].

        (destinationNode fileEntriesIncludes: destinationPath basename)
                ifTrue: [ "cannot overwrite existing file"^ presentBlock value ].

        destinationNode
                fileEntryAt: destinationPath basename
                put: (sourceNode copy
                                        basename: destinationPath basename;
                                        yourself)
%

category: 'public'
method: MemoryStore
createDirectory: path
	| parent |
	parent := path parent.
	^ self
		entryAt: parent
		ifPresent: [ :entry | 
			entry
				fileEntryAt: path basename
				ifPresent: [ :node | 
					node isDirectory
						ifTrue: [ self signalDirectoryExists: path ]
						ifFalse: [ self signalFileExists: path ] ].
			entry ensureCreateDirectory: path basename  ]
		ifAbsent: [ self signalDirectoryDoesNotExist: parent ]
%

category: 'public'
method: MemoryStore
createFile: aPath

	^self
		entryAt: aPath parent
		ifPresent: [ :entry | 
			entry isDirectory
				ifTrue: [ entry ensureCreateFile: aPath basename ]]
		ifAbsent: [ self signalDirectoryDoesNotExist: aPath parent ]
%

category: 'accessing'
method: MemoryStore
creationTimeOf: aPath
	"Return the date of creation of the File described by aPath"

	^self
		entryAt: aPath
		ifPresent: [:entry | entry creationTime]
		ifAbsent: [self signalFileDoesNotExist: aPath]
%

category: 'accessing'
method: MemoryStore
currentWorkingDirectoryPath
	"For in-memory file systems, the working directory is the root directory."

	^Path root
%

category: 'public'
method: MemoryStore
delete: path

	self 
		entryAt: path parent
		ifPresent: [ :dict | 
			dict fileEntryRemove: path basename ifAbsent: [ FileDoesNotExistException signalWith: path ]] 
		ifAbsent: [ DirectoryDoesNotExist signalWith: path parent ]
%

category: 'public'
method: MemoryStore
deleteAll: path
in: fileSystem

	self 
		entryAt: path parent
		ifPresent:
			[:dict | 
			dict
				fileEntryRemove: path basename
				ifAbsent: [FileDoesNotExistException signalWith: path]] 
		ifAbsent: [DirectoryDoesNotExist signalWith: path parent]
%

category: 'public'
method: MemoryStore
directoryAt: aPath
ifAbsent: absentBlock
ifNotDirectory: notDirectoryBlock
directoryNamesDo: aBlock
	"Enumerate through the directory names in the provided directory."

	^self
		directoryAt: aPath
		ifAbsent: absentBlock
		ifNotDirectory: notDirectoryBlock
		entriesDo: [:entry | entry isDirectory ifTrue: [aBlock value: entry basename]]
%

category: 'private'
method: MemoryStore
directoryAt: aPath
ifAbsent: absentBlock
ifNotDirectory: notDirectoryBlock
entriesDo: aBlock
	"Enumerate through the entries in the provided directory."

	| parent |
	self
		entryAt: aPath
		ifPresent: [:p | parent := p]
		ifAbsent: [^absentBlock value].
	parent isDirectory
		ifTrue: [parent fileEntriesDo: aBlock]
		ifFalse: [^notDirectoryBlock value]
%

category: 'public'
method: MemoryStore
directoryAt: aPath
ifAbsent: absentBlock
ifNotDirectory: notDirectoryBlock
entryNamesDo: aBlock
	"Enumerate through the entries in the provided directory."

	^self
		directoryAt: aPath
		ifAbsent: absentBlock
		ifNotDirectory: notDirectoryBlock
		entriesDo: [:entry | aBlock value: entry basename]
%

category: 'public'
method: MemoryStore
directoryAt: aPath
ifAbsent: absentBlock
ifNotDirectory: notDirectoryBlock
fileNamesDo: aBlock
	"Enumerate through the file names in the provided directory."

	^self
		directoryAt: aPath
		ifAbsent: absentBlock
		ifNotDirectory: notDirectoryBlock
		entriesDo: [:entry | entry isFile ifTrue: [aBlock value: entry basename]]
%

category: 'private'
method: MemoryStore
entryAt: aPath
ifPresent: presentBlock
ifAbsent: absentBlock

	| current |
	current := self root.
	aPath isRoot
		ifTrue: [^presentBlock value: current].
	aPath
		do:
			[:segment |
			current isDirectory
				ifTrue:
					[current := current
						fileEntryAt: segment
						ifAbsent: [^absentBlock value]]
				ifFalse: [^absentBlock value]].
	^ presentBlock value: current
%

category: 'testing'
method: MemoryStore
exists: aPath

	^self
		entryAt: aPath
		ifPresent: [:entry | true]
		ifAbsent: [false]
%

category: 'accessing'
method: MemoryStore
fileOpeningOptionsClass
	"Returns the associated subclass of FsFileOpeningOptions."

	^FsMemoryFileOpeningOptions
%

category: 'accessing'
method: MemoryStore
fileSystemClass
	"Defines the correct subclass of FileSystem to use with this store."

	^FsMemoryFileSystem
%

category: 'printing'
method: MemoryStore
forReferencePrintOn: aStream
	aStream nextPutAll: 'FileReference memory'
%

category: 'initialization'
method: MemoryStore
initialize 
	root := MemoryFileSystemDirectory new
%

category: 'testing'
method: MemoryStore
isBlock: aPath
	"We do not have block devices in a memory file system."

	^false
%

category: 'testing'
method: MemoryStore
isCharacter: aPath
	"We do not have character devices in a memory file system."

	^false
%

category: 'testing'
method: MemoryStore
isDirectory: aPath

	^self
		entryAt: aPath
		ifPresent: [:entry | entry isDirectory]
		ifAbsent: [false]
%

category: 'testing'
method: MemoryStore
isExecutable: aPath
	"Files are not executable but directories always are in the unix sense."

	^self isDirectory: aPath
%

category: 'testing'
method: MemoryStore
isFifo: aPath
	"We do not have fifo  files in a memory file system."

	^false
%

category: 'testing'
method: MemoryStore
isFile: aPath

	^self
		entryAt: aPath
		ifPresent: [:entry | entry isFile]
		ifAbsent: [false]
%

category: 'testing'
method: MemoryStore
isMemoryFileSystem
	^ true
%

category: 'testing'
method: MemoryStore
isRegular: aPath
	"Return true if the argument refers to a regular file."

	^self isFile: aPath
%

category: 'testing'
method: MemoryStore
isSocket: aPath
	"We do not have socket files in a memory file system."

	^false
%

category: 'testing'
method: MemoryStore
isSymlink: aPath
	"Return true if aPath refers to a symlink"

	aPath isRoot ifTrue: [^true].
	^self
		entryAt: aPath
		ifPresent: [:entry | entry isSymlink]
		ifAbsent: [self signalFileDoesNotExist: aPath]
%

category: 'testing'
method: MemoryStore
isWritable: aPath
	"Return true if aPath is writeable"

	^self
		entryAt: aPath
		ifPresent: [:entry | entry permissions isWritable]
		ifAbsent: [false]
%

category: 'accessing'
method: MemoryStore
modificationTimeOf: aPath
	"Returns the last date of modification of the File described by aPath"

	^self
		entryAt: aPath
		ifPresent: [:stat | stat modificationTime]
		ifAbsent: [self signalFileDoesNotExist: aPath]
%

category: 'public'
method: MemoryStore
open: aFileReference
options: openingOptions

	| path entry |
	path := aFileReference fullPath.
	entry := self
		entryAt: path
		ifPresent: [ :aMemoryFileSystemEntry | 
			aMemoryFileSystemEntry
				basicOpen;
				yourself ]
		ifAbsent: [ openingOptions isWritable
				ifFalse: [ self signalFileDoesNotExist: path ]
				ifTrue: [ self createFile: path ] ].
	^MemoryHandle
		reference: aFileReference
		entry: entry
		options: openingOptions
%

category: 'accessing'
method: MemoryStore
permissions: aPath
	"Returns the permissions of the associated file"

	^self
		entryAt: aPath
		ifPresent: [:stat | stat permissions]
		ifAbsent: [FileSystemPermission default]
%

category: 'public'
method: MemoryStore
rename: sourcePath to: destinationPath
	| sourceEntry destinationParentEntry newName |
	
	sourceEntry := self
		entryAt: sourcePath
		ifPresent: [:e | e]
		ifAbsent: [Error signal: 'Source path does not exist'].
	newName := destinationPath basename.
	
	destinationParentEntry := self
		entryAt: destinationPath parent
		ifPresent: [:p | p]
		ifAbsent: [Error signal: 'Parent of destination does not exist'].
	
	destinationParentEntry isDirectory
		ifFalse: [ Error signal: 'Copy destination has to be a directory' ].
	destinationParentEntry 
		fileEntryAt: newName
		ifPresent: [ Error signal: 'Destination file exists already' ].
		
	destinationParentEntry 
		fileEntryAt: newName
		put: sourceEntry.
	sourceEntry basename: newName.
	
	self
		entryAt: sourcePath parent
		ifPresent: [:parent | parent fileEntryRemove: sourcePath basename]
		ifAbsent: [Error signal: 'Unknown state']
%

category: 'private'
method: MemoryStore
replaceFile: path in: aBlock
	^ self
		entryAt: path parent
		ifPresent: [ :entry | | old new |
			entry isDirectory
				ifFalse: [ self signalFileDoesNotExist: path ].
			old := entry fileEntryAt: path basename ifAbsent: [ self signalFileDoesNotExist: path ].
			new := aBlock value: old.
			entry fileEntryAt: path basename put: new ]
		ifAbsent: [ self signalFileDoesNotExist: path ]
%

category: 'accessing'
method: MemoryStore
root
	^ root
%

category: 'accessing'
method: MemoryStore
sizeOf: aPath

	^self
		entryAt: aPath
		ifPresent: [:entry | entry size]
		ifAbsent: [self signalFileDoesNotExist: aPath]
%

! Class implementation for 'FsBinaryFileStream'

!		Class methods for 'FsBinaryFileStream'

category: 'instance creation'
classmethod: FsBinaryFileStream
on: aFileDescriptor

	^super new initialize
		descriptor: aFileDescriptor;
		yourself
%

!		Instance methods for 'FsBinaryFileStream'

category: 'testing'
method: FsBinaryFileStream
atEnd

	^self size == self position
%

category: 'opening-closing'
method: FsBinaryFileStream
close

	descriptor close
%

category: 'testing'
method: FsBinaryFileStream
closed

	^descriptor closed
%

category: 'accessing'
method: FsBinaryFileStream
contents
	"Return the full contents of the file."

	descriptor position: 0.
	^self upToEnd
%

category: 'accessing'
method: FsBinaryFileStream
descriptor

	^descriptor
%

category: 'accessing'
method: FsBinaryFileStream
descriptor: aFileDescriptor

	descriptor := aFileDescriptor
%

category: 'writing'
method: FsBinaryFileStream
flush
	"NOP"
%

category: 'testing'
method: FsBinaryFileStream
isBinary

	^true
%

category: 'reading'
method: FsBinaryFileStream
next
	"Return the next byte"

	| bytes |
	bytes := self next: 1.
	^bytes size == 0
		ifTrue: [nil]
		ifFalse: [bytes at: 1]
%

category: 'reading'
method: FsBinaryFileStream
next: count

	^descriptor read: count
%

category: 'writing'
method: FsBinaryFileStream
next: anInteger putAll: aCollection startingAt: startIndex
	"Store the next anInteger elements from the given collection."

	(startIndex == 1 and: [ anInteger == aCollection size ])
		ifTrue: [ ^ self nextPutAll: aCollection ].
	^ self
		nextPutAll: (aCollection copyFrom: startIndex to: startIndex + anInteger - 1)
%

category: 'writing'
method: FsBinaryFileStream
nextPut: aByte

	self nextPutAll: (ByteArray with: aByte)
%

category: 'writing'
method: FsBinaryFileStream
nextPutAll: aByteArray

	descriptor write: aByteArray
%

category: 'reading'
method: FsBinaryFileStream
peek
	"Return the byte at the current position."

	^descriptor peek
%

category: 'positioning'
method: FsBinaryFileStream
position

	^descriptor position
%

category: 'positioning'
method: FsBinaryFileStream
position: aPosition 

	^descriptor position: aPosition 
%

category: 'reading'
method: FsBinaryFileStream
readInto: aCollection startingAt: startIndex count: n
	"Read n objects into the given collection. 
	Return number of elements that have been read."

	| max |
	max := (self size - self position) min: n.
	aCollection 
		replaceFrom: startIndex 
		to: startIndex + max - 1
		with: (self next: max)
		startingAt: 1.
	^ max
%

category: 'positioning'
method: FsBinaryFileStream
setToEnd

  ^descriptor setToEnd
%

category: 'accessing'
method: FsBinaryFileStream
size

	^descriptor size
%

category: 'positioning'
method: FsBinaryFileStream
skip: anInteger
	"Adjust my position by <anInteger>."

	descriptor position: descriptor position + anInteger
%

category: 'writing'
method: FsBinaryFileStream
truncate
	"Truncate the file to the current position."

	descriptor truncateTo: 0
%

category: 'writing'
method: FsBinaryFileStream
truncateTo: position
	"Truncate the file to the provided position."

	descriptor truncateTo: position
%

category: 'reading'
method: FsBinaryFileStream
upToEnd
	"Return all bytes from the current position until the end of the file."

	^ByteArray
		new: descriptor size - self position
		streamContents:
			[:stream | | bytes |
			[bytes := descriptor read: 16384.
			stream nextPutAll: bytes.
			bytes size > 0] whileTrue]
%

category: 'accessing'
method: FsBinaryFileStream
wrappedStreamName
  "Note: This should be updated to return the actual file path."

  ^''
%

! Class implementation for 'FsCStructure'

!		Class methods for 'FsCStructure'

category: 'instance creation'
classmethod: FsCStructure
forBytes: aCByteArray
	"aCPointer must point at the kind of struct for the receiving class."

	^super new
		bytes: aCByteArray;
		yourself
%

category: 'accessing'
classmethod: FsCStructure
structSize
	"Returns the size in bytes of the C struct."

	^self subclassResponsibility
%

!		Instance methods for 'FsCStructure'

category: 'private - accessing'
method: FsCStructure
bytes
	"This is necessary for library calls which require passing in a structure."

	^bytes
%

category: 'private - accessing'
method: FsCStructure
bytes: aCByteArray
	"Private"

	bytes := aCByteArray
%

category: 'testing'
method: FsCStructure
isNull
	"Answer true if my CByteArray is a null pointer."

	^ bytes memoryAddress = 0
%

! Class implementation for 'FsDirentStruct'

!		Instance methods for 'FsDirentStruct'

category: 'accessing'
method: FsDirentStruct
basename

	^self d_name decodeFromUTF8ToString
%

category: 'private-masks'
method: FsDirentStruct
dt_blk
	"Block Device"

	^6
%

category: 'private-masks'
method: FsDirentStruct
dt_chr
	"Character device"

	^2
%

category: 'private-masks'
method: FsDirentStruct
dt_dir
	"Directory"

	^4
%

category: 'private-masks'
method: FsDirentStruct
dt_fifo
	"Named pipe"

	^1
%

category: 'private-masks'
method: FsDirentStruct
dt_lnk
	"Symbolic Link"

	^10
%

category: 'private-masks'
method: FsDirentStruct
dt_reg
	"regular file"

	^8
%

category: 'private-masks'
method: FsDirentStruct
dt_sock
	"Unix domain socket"

	^12
%

category: 'private-masks'
method: FsDirentStruct
dt_unknown
	"The file type could not be determined."

	^0
%

category: 'private-masks'
method: FsDirentStruct
dt_what
	"Whiteout entry in a union filesystem."

	^14
%

category: 'private-accessing'
method: FsDirentStruct
d_name

	self subclassResponsibility
%

category: 'private-accessing'
method: FsDirentStruct
d_type

	self subclassResponsibility
%

category: 'testing'
method: FsDirentStruct
isDirectory
	"Does this struct represent a directory?"

	^self d_type == self dt_dir
%

category: 'testing'
method: FsDirentStruct
isFile
	"Does this struct represent a file?"

	^self d_type == self dt_reg
%

category: 'testing'
method: FsDirentStruct
isSymlink
	"Does this struct represent a symlink?"

	^self d_type == self dt_lnk
%

category: 'testing'
method: FsDirentStruct
isUnknown
	"Is the type of this entry unknown?"

	^self d_type == self dt_unknown
%

! Class implementation for 'FsDirentStruct_Linux'

!		Class methods for 'FsDirentStruct_Linux'

category: 'accessing'
classmethod: FsDirentStruct_Linux
structSize
	"Returns the size in bytes of the C struct."

	^275
%

!		Instance methods for 'FsDirentStruct_Linux'

category: 'accessing'
method: FsDirentStruct_Linux
d_ino
	"Inode"

	^ bytes uint64At: 0
%

category: 'accessing'
method: FsDirentStruct_Linux
d_name
	"Retrieve the name of the entry, as a Smalltalk ByteArray.
	This may need to undergo decoding to make sense 
	in a filesystem that uses, for instance, UTF-8 encoding
	for filenames."

	| startIndex recordLength endIndex lastWord firstZeroIndex |
	startIndex := 19.	"Offset of start of name string."
	recordLength := self d_reclen.
	recordLength \\ 8 = 0
		ifFalse: [ self error: 'Record not an integral number of 64-bit words.' ].
	recordLength <= 24
		ifTrue: [ 
			"20 is index of 0 byte for a one-character filename."
			lastWord := bytes byteArrayFrom: 20 to: recordLength - 1.
			firstZeroIndex := lastWord indexOf: 0.
			firstZeroIndex = 0
				ifTrue: [ self error: 'Failed to find zero byte terminating filename.' ].	
			"Subtracting one to not include the zero"
			endIndex := startIndex + firstZeroIndex - 1 ]
		ifFalse: [ 
			lastWord := bytes byteArrayFrom: recordLength - 8 to: recordLength - 1.
			firstZeroIndex := lastWord indexOf: 0.
			firstZeroIndex = 0
				ifTrue: [ self error: 'Failed to find zero byte terminating filename' ].	
	"(recordLength - 10) is the penultimate byte in the penultimate word (if any).
	Adding the index of the first zero in the ultimate word will yield the index of the last
	non-zero byte before the first zero."
			endIndex := recordLength - 10 + firstZeroIndex ].
	^ bytes byteArrayFrom: startIndex to: endIndex
%

category: 'accessing'
method: FsDirentStruct_Linux
d_off
	"Not really an offset. 
     An opaque indicator of the position in the directory stream."

	^ bytes int64At: 8
%

category: 'accessing'
method: FsDirentStruct_Linux
d_reclen
	"Size in bytes of the structure, which will vary based on the size of the name field."

	^ bytes uint16At: 16
%

category: 'accessing'
method: FsDirentStruct_Linux
d_type
	"Integer containing type of the entry. One of:
	0  DT_UNKNOWN  The file type could not be determined. Some filesystem types will always give this value.
	1  DT_FIFO     This is a named pipe (FIFO).
	2  DT_CHR      This is a character device.
	4  DT_DIR      This is a directory.
	6  DT_BLK      This is a block device.
	8  DT_REG      This is a regular file.
	10 DT_LNK      This is a symbolic link.
	12 DT_SOCK     This is a UNIX domain socket.
	14 DT_WHAT     A Whiteout entry in a union filesystem.
"

	^ bytes uint8At: 18
%

! Class implementation for 'FsDirentStruct_macOS'

!		Class methods for 'FsDirentStruct_macOS'

category: 'accessing'
classmethod: FsDirentStruct_macOS
structSize
	"Returns the size in bytes of the C struct."

	^1048
%

!		Instance methods for 'FsDirentStruct_macOS'

category: 'accessing'
method: FsDirentStruct_macOS
d_fileno

	^bytes uint64At: 0
%

category: 'accessing'
method: FsDirentStruct_macOS
d_name
	"Retrieve the name of the entry, as a Smalltalk ByteArray.
	This may need to undergo decoding to make sense 
	in a filesystem that uses, for instance, UTF-8 encoding
	for filenames."

	| startIndex length |
	startIndex := 21.	"Offset of start of name string."
	length := self d_namlen.
	^bytes
		byteArrayFrom: startIndex
		to: startIndex + length - 1
%

category: 'accessing'
method: FsDirentStruct_macOS
d_namlen

	^bytes uint16At: 18
%

category: 'accessing'
method: FsDirentStruct_macOS
d_reclen

	^bytes uint16At: 16
%

category: 'accessing'
method: FsDirentStruct_macOS
d_seekoff

	^bytes uint64At: 8
%

category: 'accessing'
method: FsDirentStruct_macOS
d_type

	^bytes uint8At: 20
%

! Class implementation for 'FsStatStruct'

!		Class methods for 'FsStatStruct'

category: 'instance creation'
classmethod: FsStatStruct
new
	"Create an uninistalized instance of the stat struct"

	^super forBytes: (CByteArray gcMalloc: self structSize)
%

!		Instance methods for 'FsStatStruct'

category: 'accessing'
method: FsStatStruct
accessTime
	"Returns the access time associated with the file when stat was called."

	self subclassResponsibility
%

category: 'accessing'
method: FsStatStruct
deviceId
	"Return the device id associated with this file."

	self subclassResponsibility
%

category: 'accessing'
method: FsStatStruct
gid
	"Return the group id associated with this file."

	self subclassResponsibility
%

category: 'accessing'
method: FsStatStruct
inode
	"Return the inode."

	self subclassResponsibility
%

category: 'testing'
method: FsStatStruct
isBlock
	"true for a block device"

	self subclassResponsibility
%

category: 'testing'
method: FsStatStruct
isCharacter
	"true for a character device"

	self subclassResponsibility
%

category: 'testing'
method: FsStatStruct
isDirectory
	"Returns true if the stat was performed on a directory."

	self subclassResponsibility
%

category: 'testing'
method: FsStatStruct
isFifo
	"true for a fifio"

	self subclassResponsibility
%

category: 'testing'
method: FsStatStruct
isFile
	"Returns true if the stat was performed on a normal file."

	self subclassResponsibility
%

category: 'testing'
method: FsStatStruct
isSocket
	"true for a socket"

	self subclassResponsibility
%

category: 'testing'
method: FsStatStruct
isSymlink
	"Returns true if the stat was performed on a symbolic link."

	self subclassResponsibility
%

category: 'accessing'
method: FsStatStruct
mode
	"Returns the mode of the file."

	self subclassResponsibility
%

category: 'accessing'
method: FsStatStruct
modificationTime
	"Returns the modification time associated with the file when stat was called."

	self subclassResponsibility
%

category: 'accessing'
method: FsStatStruct
numberOfHardLinks
	"Return the number of hard links."

	self subclassResponsibility
%

category: 'accessing'
method: FsStatStruct
permission
	"Returns the permission of the file."

	^self mode bitAnd: 8r777 "This should be a mask"
%

category: 'accessing'
method: FsStatStruct
size
	"Returns the size of the file when stat was called."

	self subclassResponsibility
%

category: 'accessing'
method: FsStatStruct
uid
	"Return the user id associated with this file."

	self subclassResponsibility
%

! Class implementation for 'FsStatStruct_Linux'

!		Instance methods for 'FsStatStruct_Linux'

category: 'accessing'
method: FsStatStruct_Linux
accessTime

	^FsTimespecStruct forBytes: (self st_atim)
%

category: 'accessing'
method: FsStatStruct_Linux
changeTime

	^FsTimespecStruct forBytes: (self st_ctim)
%

category: 'accessing'
method: FsStatStruct_Linux
deviceId
	"Return the device id associated with this file."

	^self st_dev
%

category: 'accessing'
method: FsStatStruct_Linux
gid
	"Return the group id associated with this file."

	^self st_gid
%

category: 'accessing'
method: FsStatStruct_Linux
inode
	"Return the inode."

	^self st_ino
%

category: 'testing'
method: FsStatStruct_Linux
isBlock
	"true for a block device"

	^(self st_mode bitAnd: self s_ifmt) == self s_ifblk
%

category: 'testing'
method: FsStatStruct_Linux
isCharacter
	"true for a character device"

	^(self st_mode bitAnd: self s_ifmt) == self s_ifchr
%

category: 'testing'
method: FsStatStruct_Linux
isDirectory

	^(self st_mode bitAnd: self s_ifmt) == self s_ifdir
%

category: 'testing'
method: FsStatStruct_Linux
isFifo
	"true for a fifio"

	^(self st_mode bitAnd: self s_ifmt) == self s_ififo
%

category: 'testing'
method: FsStatStruct_Linux
isFile

	^(self st_mode bitAnd: self s_ifmt) == self s_ifreg
%

category: 'testing'
method: FsStatStruct_Linux
isSocket
	"true for a socket"

	^(self st_mode bitAnd: self s_ifmt) == self s_ifsock
%

category: 'testing'
method: FsStatStruct_Linux
isSymlink

	^(self st_mode bitAnd: self s_ifmt) == self s_iflnk
%

category: 'accessing'
method: FsStatStruct_Linux
mode
	"Returns the mode of the file."

	^self st_mode
%

category: 'accessing'
method: FsStatStruct_Linux
modificationTime

	^FsTimespecStruct forBytes: (self st_mtim)
%

category: 'accessing'
method: FsStatStruct_Linux
numberOfHardLinks
	"Return the number of hard links."

	^self st_nlink
%

category: 'accessing'
method: FsStatStruct_Linux
size
	"Returns the size of the file when stat was called."

	^self st_size
%

category: 'private-accessing'
method: FsStatStruct_Linux
st_atim

	^bytes CByteArrayFrom: 72 to: 87
%

category: 'private-accessing'
method: FsStatStruct_Linux
st_blksize

	self subclassResponsibility
%

category: 'private-accessing'
method: FsStatStruct_Linux
st_blocks

	^bytes uint64At: 64
%

category: 'private-accessing'
method: FsStatStruct_Linux
st_ctim

	^bytes CByteArrayFrom: 104 to: 119
%

category: 'private-accessing'
method: FsStatStruct_Linux
st_dev

	^bytes uint64At: 0
%

category: 'private-accessing'
method: FsStatStruct_Linux
st_gid

	self subclassResponsibility
%

category: 'private-accessing'
method: FsStatStruct_Linux
st_ino

	^bytes uint64At: 8
%

category: 'private-accessing'
method: FsStatStruct_Linux
st_mode

	self subclassResponsibility
%

category: 'private-accessing'
method: FsStatStruct_Linux
st_mtim

	^bytes CByteArrayFrom: 88 to: 103
%

category: 'private-accessing'
method: FsStatStruct_Linux
st_nlink

	self subclassResponsibility
%

category: 'private-accessing'
method: FsStatStruct_Linux
st_rdev

	self subclassResponsibility
%

category: 'private-accessing'
method: FsStatStruct_Linux
st_size

	^bytes uint64At: 48
%

category: 'private-accessing'
method: FsStatStruct_Linux
st_uid

	self subclassResponsibility
%

category: 'private-masks'
method: FsStatStruct_Linux
s_ifblk
	"block device"

	^8r0060000
%

category: 'private-masks'
method: FsStatStruct_Linux
s_ifchr
	"character device"

	^8r0020000
%

category: 'private-masks'
method: FsStatStruct_Linux
s_ifdir
	"directory"

	^8r0040000
%

category: 'private-masks'
method: FsStatStruct_Linux
s_ififo
	"FIFO"

	^8r0010000
%

category: 'private-masks'
method: FsStatStruct_Linux
s_iflnk
	"symbolic link"

	^8r0120000
%

category: 'private-masks'
method: FsStatStruct_Linux
s_ifmt
	"bit mask for the file type bit field"

	^8r0170000
%

category: 'private-masks'
method: FsStatStruct_Linux
s_ifreg
	"regular file"

	^8r0100000
%

category: 'private-masks'
method: FsStatStruct_Linux
s_ifsock
	"socket"

	^8r0140000
%

category: 'accessing'
method: FsStatStruct_Linux
uid
	"Return the user id associated with this file."

	^self st_uid
%

! Class implementation for 'FsStatStruct_Linux_aarch64'

!		Class methods for 'FsStatStruct_Linux_aarch64'

category: 'accessing'
classmethod: FsStatStruct_Linux_aarch64
structSize
	"Returns the size in bytes of the C struct."

	^128
%

!		Instance methods for 'FsStatStruct_Linux_aarch64'

category: 'private-accessing'
method: FsStatStruct_Linux_aarch64
st_blksize

	^bytes uint32At: 56
%

category: 'private-accessing'
method: FsStatStruct_Linux_aarch64
st_gid

	^bytes uint32At: 28
%

category: 'private-accessing'
method: FsStatStruct_Linux_aarch64
st_mode

	^bytes uint32At: 16
%

category: 'private-accessing'
method: FsStatStruct_Linux_aarch64
st_nlink

	^bytes uint32At: 20
%

category: 'private-accessing'
method: FsStatStruct_Linux_aarch64
st_rdev

	^bytes uint64At: 32
%

category: 'private-accessing'
method: FsStatStruct_Linux_aarch64
st_uid

	^bytes uint32At: 24
%

! Class implementation for 'FsStatStruct_Linux_x64'

!		Class methods for 'FsStatStruct_Linux_x64'

category: 'accessing'
classmethod: FsStatStruct_Linux_x64
structSize
	"Returns the size in bytes of the C struct."

	^144
%

!		Instance methods for 'FsStatStruct_Linux_x64'

category: 'private-accessing'
method: FsStatStruct_Linux_x64
st_blksize

	^bytes uint64At: 56
%

category: 'private-accessing'
method: FsStatStruct_Linux_x64
st_gid

	^bytes uint32At: 32
%

category: 'private-accessing'
method: FsStatStruct_Linux_x64
st_mode

	^bytes uint32At: 24
%

category: 'private-accessing'
method: FsStatStruct_Linux_x64
st_nlink

	^bytes uint64At: 16
%

category: 'private-accessing'
method: FsStatStruct_Linux_x64
st_rdev

	^bytes uint64At: 40
%

category: 'private-accessing'
method: FsStatStruct_Linux_x64
st_uid

	^bytes uint32At: 28
%

! Class implementation for 'FsStatStruct_macOS'

!		Class methods for 'FsStatStruct_macOS'

category: 'accessing'
classmethod: FsStatStruct_macOS
structSize
	"Returns the size in bytes of the C struct."

	^144
%

!		Instance methods for 'FsStatStruct_macOS'

category: 'accessing'
method: FsStatStruct_macOS
accessTime

	^FsTimespecStruct forBytes: (self st_atimespec)
%

category: 'accessing'
method: FsStatStruct_macOS
changeTime

	^FsTimespecStruct forBytes: (self st_ctimespec)
%

category: 'accessing'
method: FsStatStruct_macOS
deviceId
	"Return the device id associated with this file."

	^self st_dev
%

category: 'accessing'
method: FsStatStruct_macOS
gid
	"Return the group id associated with this file."

	^self st_gid
%

category: 'accessing'
method: FsStatStruct_macOS
inode
	"Return the inode."

	^self st_ino
%

category: 'testing'
method: FsStatStruct_macOS
isBlock
	"true for a block device"

	^(self st_mode bitAnd: self s_ifmt) == self s_ifblk
%

category: 'testing'
method: FsStatStruct_macOS
isCharacter
	"true for a character device"

	^(self st_mode bitAnd: self s_ifmt) == self s_ifchr
%

category: 'testing'
method: FsStatStruct_macOS
isDirectory

	^(self st_mode bitAnd: self s_ifmt) == self s_ifdir
%

category: 'testing'
method: FsStatStruct_macOS
isFifo
	"true for a fifio"

	^(self st_mode bitAnd: self s_ifmt) == self s_ififo
%

category: 'testing'
method: FsStatStruct_macOS
isFile

	^(self st_mode bitAnd: self s_ifmt) == self s_ifreg
%

category: 'testing'
method: FsStatStruct_macOS
isSocket
	"true for a socket"

	^(self st_mode bitAnd: self s_ifmt) == self s_ifsock
%

category: 'testing'
method: FsStatStruct_macOS
isSymlink

	^(self st_mode bitAnd: self s_ifmt) == self s_iflnk
%

category: 'accessing'
method: FsStatStruct_macOS
mode
	"Returns the mode of the file."

	^self st_mode
%

category: 'accessing'
method: FsStatStruct_macOS
modificationTime

	^FsTimespecStruct forBytes: (self st_mtimespec)
%

category: 'accessing'
method: FsStatStruct_macOS
numberOfHardLinks
	"Return the number of hard links."

	^self st_nlink
%

category: 'accessing'
method: FsStatStruct_macOS
size
	"Returns the size of the file when stat was called."

	^self st_size
%

category: 'private-accessing'
method: FsStatStruct_macOS
st_atimespec

	^bytes CByteArrayFrom: 32 to: 47
%

category: 'private-accessing'
method: FsStatStruct_macOS
st_blksize

	^bytes uint32At: 112
%

category: 'private-accessing'
method: FsStatStruct_macOS
st_blocks

	^bytes uint64At: 104
%

category: 'private-accessing'
method: FsStatStruct_macOS
st_ctimespec

	^bytes CByteArrayFrom: 64 to: 79
%

category: 'private-accessing'
method: FsStatStruct_macOS
st_dev

	^bytes uint32At: 0
%

category: 'private-accessing'
method: FsStatStruct_macOS
st_gid

	^bytes uint32At: 20
%

category: 'private-accessing'
method: FsStatStruct_macOS
st_ino

	^bytes uint64At: 8
%

category: 'private-accessing'
method: FsStatStruct_macOS
st_mode

	^bytes uint16At: 4
%

category: 'private-accessing'
method: FsStatStruct_macOS
st_mtimespec

	^bytes CByteArrayFrom: 48 to: 63
%

category: 'private-accessing'
method: FsStatStruct_macOS
st_nlink

	^bytes uint16At: 6
%

category: 'private-accessing'
method: FsStatStruct_macOS
st_rdev

	^bytes uint32At: 24
%

category: 'private-accessing'
method: FsStatStruct_macOS
st_size

	^bytes uint64At: 96
%

category: 'private-accessing'
method: FsStatStruct_macOS
st_uid

	^bytes uint32At: 16
%

category: 'private-masks'
method: FsStatStruct_macOS
s_ifblk
	"block device"

	^8r0060000
%

category: 'private-masks'
method: FsStatStruct_macOS
s_ifchr
	"character device"

	^8r0020000
%

category: 'private-masks'
method: FsStatStruct_macOS
s_ifdir
	"directory"

	^8r0040000
%

category: 'private-masks'
method: FsStatStruct_macOS
s_ififo
	"FIFO"

	^8r0010000
%

category: 'private-masks'
method: FsStatStruct_macOS
s_iflnk
	"symbolic link"

	^8r0120000
%

category: 'private-masks'
method: FsStatStruct_macOS
s_ifmt
	"bit mask for the file type bit field"

	^8r0170000
%

category: 'private-masks'
method: FsStatStruct_macOS
s_ifreg
	"regular file"

	^8r0100000
%

category: 'private-masks'
method: FsStatStruct_macOS
s_ifsock
	"socket"

	^8r0140000
%

category: 'accessing'
method: FsStatStruct_macOS
uid
	"Return the user id associated with this file."

	^self st_uid
%

! Class implementation for 'FsTimespecStruct'

!		Class methods for 'FsTimespecStruct'

category: 'accessing'
classmethod: FsTimespecStruct
structSize

	^16
%

!		Instance methods for 'FsTimespecStruct'

category: 'accessing'
method: FsTimespecStruct
asDateAndTime

	^DateAndTime
		posixSeconds: self seconds
		offset: Duration zero
%

category: 'accessing'
method: FsTimespecStruct
seconds

	| nanosPerSecond nanos |
	nanosPerSecond := 1000000000.
	nanos := self tv_sec * nanosPerSecond + self tv_nsec.
	^ScaledDecimal
		numerator: nanos
		denominator: nanosPerSecond
		scale: 6
%

category: 'accessing'
method: FsTimespecStruct
tv_nsec

	^bytes int64At: 8
%

category: 'accessing'
method: FsTimespecStruct
tv_sec

	^bytes int64At: 0
%

! Class implementation for 'FsFileDescriptor'

!		Class methods for 'FsFileDescriptor'

category: 'Instance Creation'
classmethod: FsFileDescriptor
fd: fileDescriptorInteger

	^super new initialize
		fd: fileDescriptorInteger;
		yourself
%

category: 'Instance non-creation'
classmethod: FsFileDescriptor
new
	self shouldNotImplement: #new
%

category: 'Instance Creation'
classmethod: FsFileDescriptor
stderr
	"_fd: bypassess the Registry and ensures we don't close stderr unexpectedly."

	^super new initialize
		_fd: 2;
		yourself
%

category: 'Instance Creation'
classmethod: FsFileDescriptor
stdin
	"_fd: bypassess the Registry and ensures we don't close stdin unexpectedly."

	^super new initialize
		_fd: 0;
		yourself
%

category: 'Instance Creation'
classmethod: FsFileDescriptor
stdout
	"_fd: bypassess the Registry and ensures we don't close stdout unexpectedly."

	^super new initialize
		_fd: 1;
		yourself
%

!		Instance methods for 'FsFileDescriptor'

category: 'accessing'
method: FsFileDescriptor
binaryReadStream

	^FsBinaryFileStream on: self
%

category: 'accessing'
method: FsFileDescriptor
binaryWriteStream

	^FsBinaryFileStream on: self
%

category: 'public'
method: FsFileDescriptor
close
	"Esure the receiver is closed.
	This selector can be repeatedly sent."

	self _close.
	ephemeron ifNotNil:
			[:eph |
			ephemeron := nil.
			eph deregister]
%

category: 'testing'
method: FsFileDescriptor
closed
	"Returns true if the receiver has been closed."

	^self isOpen not
%

category: 'public'
method: FsFileDescriptor
ensureClosed
	"Closing should silently succeed even if I'm invalid,
	since I don't represent anything open."

	self close
%

category: 'private'
method: FsFileDescriptor
fd: aFileDescriptorInteger
	
	self _fd: aFileDescriptorInteger.
	FsFileDescriptorRegistry current register: self
%

category: 'initialization'
method: FsFileDescriptor
initialize

	libcUnistd := DiskStore current libcUnistd
%

category: 'accessing'
method: FsFileDescriptor
invalidException
	"Returns a FsFileDescriptorInvalid exception"

	^FsFileDescriptorInvalid fileDescriptor: self
%

category: 'testing'
method: FsFileDescriptor
isOpen
	"Returns true if the receiver is open."

	^fd notNil
%

category: 'private'
method: FsFileDescriptor
peek
	"Return the byte at the current position without advancing position."

	| buffer numBytesRead |
	buffer := CByteArray gcMalloc: 1.
	numBytesRead := [libcUnistd
		pread: self _fd
		into: buffer
		count: 1
		startingAt: self position]
		onException: {FsEBADF. FsEINTR}
		do: {[:ex | ex resignalAs: self invalidException]. [:ex | ex retry]}.
	numBytesRead == 0
		ifTrue: [^nil].
	^buffer uint8At: 0
%

category: 'positioning'
method: FsFileDescriptor
position
	"Returns the current position in the file."

	^[libcUnistd
		lseek: self _fd
		offset: 0
		whence: 8r1. "SEEK_CUR"]
		on: FsEBADF
		do: [:ex | ex resignalAs: self invalidException]
%

category: 'positioning'
method: FsFileDescriptor
position: newPosition
	"Returns the current position in the file."

	^[libcUnistd
		lseek: self _fd
		offset: newPosition
		whence: 8r0. "SEEK_SET"]
		onException: {FsEBADF. FsEINVAL}
		do: {[:ex | ex resignalAs: self invalidException]. [:ex | ex resignalAs: (OutOfRange new name: 'position' min: 0 max: (self size - 2) actual: newPosition; yourself)]}
%

category: 'private'
method: FsFileDescriptor
read: count
	"Read up to <count> number of bytes from
	the backing file descriptor."

	| buffer numBytesRead |
	buffer := CByteArray gcMalloc: count.
	numBytesRead := [libcUnistd
		read: self _fd
		into: buffer
		count: buffer size]
		onException: {FsEBADF. FsEINTR}
		do: {[:ex | ex resignalAs: self invalidException]. [:ex | ex retry]}.
	numBytesRead == 0
		ifTrue: [^#[]].
	^buffer
		byteArrayFrom: 0
		to: numBytesRead - 1
%

category: 'positioning'
method: FsFileDescriptor
setToEnd

	^[libcUnistd
		lseek: self _fd
		offset: 0
		whence: 8r2. "SEEK_END"]
		on: FsEBADF
		do: [:ex | ex resignalAs: self invalidException]
%

category: 'accessing'
method: FsFileDescriptor
size

	^self stat size
%

category: 'private'
method: FsFileDescriptor
stat

	^[DiskStore current libcStat fstat: self _fd]
		on: FsEBADF
		do: [:ex | ex resignalAs: self invalidException]
%

category: 'public'
method: FsFileDescriptor
truncateTo: length
	"Truncate the open file to the specified length."

	^[libcUnistd
		ftruncate: self _fd
		to: length]
		on: FsEBADF
		do: [:ex | ex resignalAs: self invalidException]
%

category: 'private'
method: FsFileDescriptor
write: aByteArray
	"Write the provided bytes to the file descriptor.
	Returns the number of bytes actually written to
	the file descriptor."

	| buffer |
	aByteArray _validateInstanceOf: ByteArray.
	buffer := CByteArray withAll: aByteArray nullTerminate: false.
	^[libcUnistd
		write: self _fd
		from: buffer
		count: buffer size]
		onException: {FsEBADF. FsEINTR}
		do: {[:ex | ex resignalAs: self invalidException]. [:ex | ex retry]}
%

category: 'private'
method: FsFileDescriptor
_close
	"Close the file. Fsync it first so we are notified of any errors during the flush.
	Report some errors when flushing (I/O error, out-of-space, quota exceeded)
	Ignore FsEBADF, which indicates that my descriptor is already somehow closed,
	so we silently succeed.
	Other errors on fsync must be ignored (EROFS, EINVAL) since they just say 
	that fsync isn't supported on this kind of fd.
	FsEINTR is, according to some references, never returned on Linux. But if it is, 
	it should be ignored, since the file descriptor has already been freed."

	| fdToClose |
	fd ifNil: [ ^ self ].
	fdToClose := fd.
	fd := nil.
	[ libcUnistd close: fdToClose ]
		onException: { FsEBADF. FsEINTR}
		do: {[ :ex | ex return ]. [:ex | ex retry]}
%

category: 'private'
method: FsFileDescriptor
_ephemeron: anEphemeron

	ephemeron := anEphemeron
%

category: 'private'
method: FsFileDescriptor
_fd
	"This is provided purely for testing purposes. You should never use this."

	^fd ifNil: [self invalidException signal]
%

category: 'private'
method: FsFileDescriptor
_fd: aFileDescriptorInteger

	fd := aFileDescriptorInteger
%

! Class implementation for 'FsFileDescriptorEphemeron'

!		Class methods for 'FsFileDescriptorEphemeron'

category: 'Instance creation'
classmethod: FsFileDescriptorEphemeron
fileDescriptor: aFileDescriptor
registry: aRegistry
index: anIndex

	^self new
		fileDescriptor: aFileDescriptor;
		registry: aRegistry;
		index: anIndex;
		yourself
%

!		Instance methods for 'FsFileDescriptorEphemeron'

category: 'public'
method: FsFileDescriptorEphemeron
deregister
	"When a FileDescriptor is closed, it is expected to send this message."

	| tReg tIndex |
	tReg := registry.
	tIndex := index.
	registry := index := fileDescriptor := nil.
	(tReg notNil & tIndex notNil)
		ifTrue: [tReg deregisterAt: tIndex]
%

category: 'accessing'
method: FsFileDescriptorEphemeron
fileDescriptor: aFileDescriptor

	fileDescriptor := aFileDescriptor.
	self beEphemeron: true.
	fileDescriptor _ephemeron: self
%

category: 'accessing'
method: FsFileDescriptorEphemeron
index: anInteger

	index := anInteger
%

category: 'mourning'
method: FsFileDescriptorEphemeron
mourn
	"Close the fileDescriptor. When closed, the FileDescriptor
	if requried to send #deregister to its ephemeron. This
	ensures the Ephemeron is cleaned up."

	fileDescriptor ifNotNil: [:fs | fs close]
%

category: 'accessing'
method: FsFileDescriptorEphemeron
registry: aFileDescriptorRegistry

	registry := aFileDescriptorRegistry
%

category: 'private-testing'
method: FsFileDescriptorEphemeron
_private_test_only_fileDescriptor

	^fileDescriptor
%

category: 'private-testing'
method: FsFileDescriptorEphemeron
_private_test_only_index

	^index
%

! Class implementation for 'FsFileDescriptorRegistry'

!		Class methods for 'FsFileDescriptorRegistry'

category: 'private'
classmethod: FsFileDescriptorRegistry
cacheKey
	"Return the key defined for the FsFileDescriptorRegistry singleton in SessionTemps"

	^#'GsFsFileDescriptorRegistrySingleton'
%

category: 'accessing'
classmethod: FsFileDescriptorRegistry
current
	"The Singleton is lazily initialized. There is an unlikely scenario where
	a Process swap occurs during this initialization causing it to happen
	multiple times. This could cause N-1 file descriptor leaks where N
	is the number of concurrent initializations. At this time it isn't worth
	preventing this very unlikely potential. A leak would also require that
	a user of the file dscriptor does not close it as part of its usage."

	^SessionTemps current
		at: self cacheKey
		ifAbsentPut: [super new initialize]
%

category: 'instance creation'
classmethod: FsFileDescriptorRegistry
new
	"Not allowed. Use #current."

	self shouldNotImplement: #new
%

category: 'instance creation'
classmethod: FsFileDescriptorRegistry
resetCurrent
	"Destroy the current registry allowing another to be created.
	This should not be used outside of debugging and development
	purposes."

	SessionTemps current
		removeKey: self cacheKey
		ifAbsent: []
%

!		Instance methods for 'FsFileDescriptorRegistry'

category: 'mourning'
method: FsFileDescriptorRegistry
deregisterAt: index
	"Removing an Ephemeron from the Registry requires the same
	consideration at registering an element. This method is written
	in a manner that avoids interrupt windows. This is a requirement
	as the Registry is a lock-free datastructure.
	SPECIAL NOTE ABOUT DEBUGGERS:
		Stepping through the designated critical section in a debugger could cause
		leaked file descriptors. The problem is unlikely to happen but remains 
		possible in the context of a debugger.
		DO NOT step through this method without considering the risk."

	"CRITICAL SECTION"
	list
		at: index
		put: freeHead.
	freeHead := index
	"END CRITICAL SECTION"
%

category: 'initialization'
method: FsFileDescriptorRegistry
initialize
	"Initialize the list of Ephemerons"

	list := NonPersistentArray new.
	freeHead := 0
%

category: 'registration'
method: FsFileDescriptorRegistry
register: aFileDescriptor
	"Adding a FileDescriptor to the Registry is a seemingly easy process but it
	requires considerable care. The Registry is written in a lock-free manner
	to avoid the overhead and problems using a lock would entail. Ephemeron
	mourning happens in the current active Process. A lock-free datastructure
	avoids any concern about deadlocks while maintaining correctness (outside
	of the unlikely debugger case.)
	SPECIAL NOTE ABOUT DEBUGGERS:
		Stepping through the designated critical section in a debugger could cause
		leaked file descriptors. The problem is unlikely to happen but remains 
		possible in the context of a debugger.
		Stepping outside the critical sections does not carry risk.
		DO NOT step through this method without considering the risk."

	| ephemeron index |
	"CRITICIAL SECTION"
	freeHead == 0
		ifTrue:
			[index := list size + 1.
			list at: index put: 0 "We need to grow the Array within the critical section and we don't yet have the element."]
		ifFalse:
			[index := freeHead.
			freeHead := list at: index].
	"END CRITICAL SECTION"
	ephemeron := FsFileDescriptorEphemeron
		fileDescriptor: aFileDescriptor
		registry: self
		index: index.
	list
		at: index
		put: ephemeron.
	^ephemeron
%

category: 'private-testing'
method: FsFileDescriptorRegistry
_list

	^list
%

category: 'private-testing'
method: FsFileDescriptorRegistry
_private_test_only_list

	^list
%

! Class implementation for 'FsFileOpeningOptions'

!		Class methods for 'FsFileOpeningOptions'

category: 'private'
classmethod: FsFileOpeningOptions
new
	"Private -- use one of the access mode messages to create instances."

	^ super new initialize
%

category: 'instance creation'
classmethod: FsFileOpeningOptions
readOnly
	^ self new readOnly
%

category: 'instance creation'
classmethod: FsFileOpeningOptions
readWrite
	^ self new readWrite
%

category: 'instance creation'
classmethod: FsFileOpeningOptions
writeOnly
	^ self new writeOnly
%

!		Instance methods for 'FsFileOpeningOptions'

category: 'options'
method: FsFileOpeningOptions
append
	"Append to the file being opened."

	self signalImproperOperation: 'Opening a file in append mode is not supported.'
%

category: 'private'
method: FsFileOpeningOptions
improperOperationExceptionClass
	"GemStone-specific; will need factoring to platform-specific package upon first port."

	^ImproperOperation
%

category: 'signaling'
method: FsFileOpeningOptions
signalImproperOperation: messageText

	^self improperOperationExceptionClass signal: messageText
%

category: 'private'
method: FsFileOpeningOptions
signalLateAccessChange

	self signalImproperOperation: 'Access mode must be set before adding any other options.'
%

category: 'options'
method: FsFileOpeningOptions
truncate
	"Truncate the file being opened."

	self signalImproperOperation: 'Truncating a file on open is not supported.'
%

! Class implementation for 'FsMemoryFileOpeningOptions'

!		Instance methods for 'FsMemoryFileOpeningOptions'

category: 'asserting'
method: FsMemoryFileOpeningOptions
assertUnconfigured
	"Assert that the access mode has not yet been configured."

	wasConfigured
		ifTrue: [self signalImproperOperation: 'Access mode must be set before adding any other options.']
%

category: 'private access modes'
method: FsMemoryFileOpeningOptions
create
	"NOP. Files are automatically created in a In-Memory FileSystem when writting.
	This method enables default options to be specified in FileReference rather than in
	the FileSystem Store."
%

category: 'initializing'
method: FsMemoryFileOpeningOptions
initialize

	super initialize.
	wasConfigured := readable := writable := false
%

category: 'testing'
method: FsMemoryFileOpeningOptions
isReadable
	"Returns true is reading should be supported."

	^readable
%

category: 'testing'
method: FsMemoryFileOpeningOptions
isReadOnly
	"Returns true if only reading should be supported."

	^self isReadable and: [self isWritable not]
%

category: 'testing'
method: FsMemoryFileOpeningOptions
isReadWrite
	"Returns true if reading and writing should be supported."

	^self isReadable and: [self isWritable]
%

category: 'testing'
method: FsMemoryFileOpeningOptions
isWritable
	"Returns true is writing should be supported."

	^writable
%

category: 'testing'
method: FsMemoryFileOpeningOptions
isWriteOnly
	"Returns true if only writing should be supported."

	^self isReadable not and: [self isWritable]
%

category: 'private access modes'
method: FsMemoryFileOpeningOptions
readOnly
	"Allow reading only"

	self assertUnconfigured.
	readable := true.
	wasConfigured := true
%

category: 'private access modes'
method: FsMemoryFileOpeningOptions
readWrite
	"Allow both reading and writing"

	self assertUnconfigured.
	writable := true.
	readable := true.
	wasConfigured := true
%

category: 'private access modes'
method: FsMemoryFileOpeningOptions
writeOnly
	"Allow writing only"

	self assertUnconfigured.
	writable := true.
	wasConfigured := true
%

! Class implementation for 'FsUnixFileOpeningOptions'

!		Instance methods for 'FsUnixFileOpeningOptions'

category: 'testing'
method: FsUnixFileOpeningOptions
allowsRead
	"Returns whether these options allow reading."

	^self isReadable
%

category: 'testing'
method: FsUnixFileOpeningOptions
allowsWrite
	"Returns whether these options allow reading."

	^self isWritable
%

category: 'options'
method: FsUnixFileOpeningOptions
append

	flags := flags bitOr: self O_APPEND
%

category: 'options'
method: FsUnixFileOpeningOptions
closeOnExec

	flags := flags bitOr: self O_CLOEXEC
%

category: 'options'
method: FsUnixFileOpeningOptions
create

	flags := flags bitOr: self O_CREAT
%

category: 'options'
method: FsUnixFileOpeningOptions
dataSync

	flags := flags bitOr: self O_DSYNC
%

category: 'options'
method: FsUnixFileOpeningOptions
directory

	flags := flags bitOr: self O_DIRECTORY
%

category: 'options'
method: FsUnixFileOpeningOptions
exclusive

	flags := flags bitOr: self O_EXCL
%

category: 'accessing'
method: FsUnixFileOpeningOptions
flags

	^flags
%

category: 'initialization'
method: FsUnixFileOpeningOptions
initialize

	flags := 0.
	accessModeSet := false
%

category: 'testing'
method: FsUnixFileOpeningOptions
isAppend
	^ (flags bitAnd: self O_APPEND) = self O_APPEND
%

category: 'testing'
method: FsUnixFileOpeningOptions
isCloseOnExec
	^ (flags bitAnd: self O_CLOEXEC) = self O_CLOEXEC
%

category: 'testing'
method: FsUnixFileOpeningOptions
isCreate
	^ (flags bitAnd: self O_CREAT) = self O_CREAT
%

category: 'testing'
method: FsUnixFileOpeningOptions
isDataSync
	^ (flags bitAnd: self O_DSYNC) = self O_DSYNC
%

category: 'testing'
method: FsUnixFileOpeningOptions
isDirectory
	^ (flags bitAnd: self O_DIRECTORY) = self O_DIRECTORY
%

category: 'testing'
method: FsUnixFileOpeningOptions
isExclusive
	^ (flags bitAnd: self O_EXCL) = self O_EXCL
%

category: 'testing'
method: FsUnixFileOpeningOptions
isNoFollow
	^ (flags bitAnd: self O_NOFOLLOW) = self O_NOFOLLOW
%

category: 'testing'
method: FsUnixFileOpeningOptions
isReadable

	^self isReadOnly or: [self isReadWrite]
%

category: 'testing'
method: FsUnixFileOpeningOptions
isReadOnly
	^ (flags bitAnd: self O_ACCMODE) = self O_RDONLY
%

category: 'testing'
method: FsUnixFileOpeningOptions
isReadWrite
	^ (flags bitAnd: self O_ACCMODE) = self O_RDWR
%

category: 'testing'
method: FsUnixFileOpeningOptions
isSync
	^ (flags bitAnd: self O_SYNC) = self O_SYNC
%

category: 'testing'
method: FsUnixFileOpeningOptions
isTruncate
	^ (flags bitAnd: self O_TRUNC) = self O_TRUNC
%

category: 'testing'
method: FsUnixFileOpeningOptions
isWritable

	^self isWriteOnly or: [self isReadWrite]
%

category: 'testing'
method: FsUnixFileOpeningOptions
isWriteOnly
	^ (flags bitAnd: self O_ACCMODE) = self O_WRONLY
%

category: 'accessing'
method: FsUnixFileOpeningOptions
mode

	^mode
%

category: 'accessing'
method: FsUnixFileOpeningOptions
modeBits
	"If mode has not been explicitly set, answer all read and write. 
	This will be modified by the user's umask when creating a file."

	^mode ifNotNil: [mode modeBits] ifNil: [8r666]
%

category: 'options'
method: FsUnixFileOpeningOptions
noFollow

	flags := flags bitOr: self O_NOFOLLOW
%

category: 'options'
method: FsUnixFileOpeningOptions
nonBlocking
	"We do not current support the O_NONBLOCK option.
	Support may be added in the future."

	self signalImproperOperation: 'Non-blocking file opening is not supported.'
%

category: 'private-constants'
method: FsUnixFileOpeningOptions
O_ACCMODE
	"Access mode"

	self subclassResponsibility
%

category: 'private-constants'
method: FsUnixFileOpeningOptions
O_APPEND
	"Append to the file"

	self subclassResponsibility
%

category: 'private-constants'
method: FsUnixFileOpeningOptions
O_CLOEXEC
	"Close file descriptor when calling any exec family function"

	self subclassResponsibility
%

category: 'private-constants'
method: FsUnixFileOpeningOptions
O_CREAT
	"Create file if it does not exist"

	self subclassResponsibility
%

category: 'private-constants'
method: FsUnixFileOpeningOptions
O_DIRECTORY
	"Fail opening a non-directory file."

	self subclassResponsibility
%

category: 'private-constants'
method: FsUnixFileOpeningOptions
O_DSYNC
	"Synchronized writes"

	self subclassResponsibility
%

category: 'private-constants'
method: FsUnixFileOpeningOptions
O_EXCL
	"Exclusive use flag"

	self subclassResponsibility
%

category: 'private-constants'
method: FsUnixFileOpeningOptions
O_NOCTTY
	"Don't assign a controlling terminal"

	self subclassResponsibility
%

category: 'private-constants'
method: FsUnixFileOpeningOptions
O_NOFOLLOW
	"Don't follow symlinks"

	self subclassResponsibility
%

category: 'private-constants'
method: FsUnixFileOpeningOptions
O_NONBLOCK
	"Non-blocking mode"

	self subclassResponsibility
%

category: 'private-constants'
method: FsUnixFileOpeningOptions
O_RDONLY
	"Read-only mode"

	self subclassResponsibility
%

category: 'private-constants'
method: FsUnixFileOpeningOptions
O_RDWR
	"Read-write mode"

	self subclassResponsibility
%

category: 'private-constants'
method: FsUnixFileOpeningOptions
O_SYNC
	"Synchronized writes"

	self subclassResponsibility
%

category: 'private-constants'
method: FsUnixFileOpeningOptions
O_TRUNC
	"Truncate the file"

	self subclassResponsibility
%

category: 'private-constants'
method: FsUnixFileOpeningOptions
O_WRONLY
	"Write-only mode"

	self subclassResponsibility
%

category: 'access modes'
method: FsUnixFileOpeningOptions
readOnly
	"Set the access mode to read-only"

	self _accessMode: self O_RDONLY
%

category: 'access modes'
method: FsUnixFileOpeningOptions
readWrite
	"Set the access mode to read-write mode"

	self _accessMode: self O_RDWR
%

category: 'options'
method: FsUnixFileOpeningOptions
sync

	flags := flags bitOr: self O_SYNC
%

category: 'options'
method: FsUnixFileOpeningOptions
truncate

	self isReadOnly
		ifTrue: [self signalImproperOperation: 'Specifying truncate and readOnly is undefined behavior'].
	flags := flags bitOr: self O_TRUNC
%

category: 'access modes'
method: FsUnixFileOpeningOptions
writeOnly
	"Set the access mode to write-only mode"

	self _accessMode: self O_WRONLY
%

category: 'private-accessing'
method: FsUnixFileOpeningOptions
_accessMode: accessMode

	accessModeSet
		ifTrue: [self signalImproperOperation: 'Access mode must be set before adding any other options.'].
	accessModeSet := true.
	flags := flags bitOr: accessMode
%

! Class implementation for 'FsFileOpeningOptions_Linux'

!		Instance methods for 'FsFileOpeningOptions_Linux'

category: 'private-constants'
method: FsFileOpeningOptions_Linux
O_ACCMODE
	"Access mode"

	^8r000000003
%

category: 'private-constants'
method: FsFileOpeningOptions_Linux
O_APPEND
	"Append to the file"

	^8r000002000
%

category: 'private-constants'
method: FsFileOpeningOptions_Linux
O_CLOEXEC
	"Close file descriptor when calling any exec family function"

	^8r002000000
%

category: 'private-constants'
method: FsFileOpeningOptions_Linux
O_CREAT
	"Create file if it does not exist"

	^8r000000100
%

category: 'private-constants'
method: FsFileOpeningOptions_Linux
O_DIRECTORY
	"Fail opening a non-directory file."

	self subclassResponsibility
%

category: 'private-constants'
method: FsFileOpeningOptions_Linux
O_DSYNC
	"Synchronized writes"

	^8r000010000
%

category: 'private-constants'
method: FsFileOpeningOptions_Linux
O_EXCL
	"Exclusive use flag"

	^8r000000200
%

category: 'private-constants'
method: FsFileOpeningOptions_Linux
O_NOCTTY
	"Don't assign a controlling terminal"

	^8r000000400
%

category: 'private-constants'
method: FsFileOpeningOptions_Linux
O_NOFOLLOW
	"Don't follow symlinks"

	self subclassResponsibility
%

category: 'private-constants'
method: FsFileOpeningOptions_Linux
O_NONBLOCK
	"Non-blocking mode"

	^8r000004000
%

category: 'private-constants'
method: FsFileOpeningOptions_Linux
O_RDONLY
	"Read-only mode"

	^8r000000000
%

category: 'private-constants'
method: FsFileOpeningOptions_Linux
O_RDWR
	"Read-write mode"

	^8r000000002
%

category: 'private-constants'
method: FsFileOpeningOptions_Linux
O_SYNC
	"Synchronized writes"

	^8r004010000
%

category: 'private-constants'
method: FsFileOpeningOptions_Linux
O_TRUNC
	"Truncate the file"

	^8r000001000
%

category: 'private-constants'
method: FsFileOpeningOptions_Linux
O_WRONLY
	"Write-only mode"

	^8r000000001
%

! Class implementation for 'FsFileOpeningOptions_Linux_aarch64'

!		Instance methods for 'FsFileOpeningOptions_Linux_aarch64'

category: 'private-constants'
method: FsFileOpeningOptions_Linux_aarch64
O_DIRECTORY
	"Fail opening a non-directory file."

	^8r000040000
%

category: 'private-constants'
method: FsFileOpeningOptions_Linux_aarch64
O_NOFOLLOW
	"Don't follow symlinks"

	^8r000100000
%

! Class implementation for 'FsFileOpeningOptions_Linux_x64'

!		Instance methods for 'FsFileOpeningOptions_Linux_x64'

category: 'private-constants'
method: FsFileOpeningOptions_Linux_x64
O_DIRECTORY
	"Fail opening a non-directory file."

	^8r000200000
%

category: 'private-constants'
method: FsFileOpeningOptions_Linux_x64
O_NOFOLLOW
	"Don't follow symlinks"

	^8r000400000
%

! Class implementation for 'FsFileOpeningOptions_macOS'

!		Instance methods for 'FsFileOpeningOptions_macOS'

category: 'private-constants'
method: FsFileOpeningOptions_macOS
O_ACCMODE

	^8r000000003
%

category: 'private-constants'
method: FsFileOpeningOptions_macOS
O_APPEND

	^8r000000010
%

category: 'private-constants'
method: FsFileOpeningOptions_macOS
O_CLOEXEC

	^8r100000000
%

category: 'private-constants'
method: FsFileOpeningOptions_macOS
O_CREAT

	^8r000001000
%

category: 'private-constants'
method: FsFileOpeningOptions_macOS
O_DIRECTORY

	^8r004000000
%

category: 'private-constants'
method: FsFileOpeningOptions_macOS
O_DSYNC

	^8r020000000
%

category: 'private-constants'
method: FsFileOpeningOptions_macOS
O_EXCL

	^8r4000
%

category: 'private-constants'
method: FsFileOpeningOptions_macOS
O_NOCTTY

	^8r400000
%

category: 'private-constants'
method: FsFileOpeningOptions_macOS
O_NOFOLLOW

	^8r400
%

category: 'private-constants'
method: FsFileOpeningOptions_macOS
O_NONBLOCK

	^8r000000004
%

category: 'private-constants'
method: FsFileOpeningOptions_macOS
O_RDONLY

	^8r000000000
%

category: 'private-constants'
method: FsFileOpeningOptions_macOS
O_RDWR

	^8r000000002
%

category: 'private-constants'
method: FsFileOpeningOptions_macOS
O_SYNC

	^8r000000200
%

category: 'private-constants'
method: FsFileOpeningOptions_macOS
O_TRUNC

	^8r000002000
%

category: 'private-constants'
method: FsFileOpeningOptions_macOS
O_WRONLY

	^8r000000001
%

! Class implementation for 'FsLibcInterface'

!		Class methods for 'FsLibcInterface'

category: 'instance creation'
classmethod: FsLibcInterface
new
	^ super new
		initialize;
		yourself
%

!		Instance methods for 'FsLibcInterface'

category: 'error handling'
method: FsLibcInterface
handleErrno: errorNumber
	" Default handling of system errors: just signal the default exception class for the error.
	Subclasses may override this method for specific errors that need other handling."

	| errorClass |
	errorClass := FsUnixError errorClassForErrorNumber: errorNumber.
	^ errorClass signal
%

category: 'initialization'
method: FsLibcInterface
initialize

	library := CLibrary named: self libraryName
%

category: 'accessing'
method: FsLibcInterface
libraryName
	"Returns the name or path to the library that should be loaded."

	^self subclassResponsibility
%

! Class implementation for 'FsLibcDirent'

!		Instance methods for 'FsLibcDirent'

category: 'functions'
method: FsLibcDirent
closeDirectoryStream: dirPtr

	| errnoHolder result |
	closedir == nil
		ifTrue:
			[closedir := CCallout
				library: library
				name: 'closedir'
				result: #'int32'
				args: #(#'ptr')
				varArgsAfter: -1].
	errnoHolder := { 0 }.
	result := closedir
		callWith: { dirPtr }
		errno: errnoHolder.
	result == -1
		ifTrue: [self handleErrno: errnoHolder first].
	^result
%

category: 'functions'
method: FsLibcDirent
openDirectoryStreamWithPath: pathString
	"See warnings in subclasses"

	self subclassResponsibility
%

category: 'functions'
method: FsLibcDirent
readFromDirectoryStream: dirPointer

	self subclassResponsibility
%

! Class implementation for 'FsLibcDirent_Linux'

!		Instance methods for 'FsLibcDirent_Linux'

category: 'accessing'
method: FsLibcDirent_Linux
libraryName
	"Returns the name of the C library that should be used."

	^'libc.so.6'
%

category: 'functions'
method: FsLibcDirent_Linux
openDirectoryStreamWithPath: pathString
	"This result is not automatically freed.
	The caller is expected to ensure
	#closeDirectoryStream: is always called."

	| result errnoHolder |
	opendir == nil
		ifTrue:
			[opendir := CCallout
				library: library
				name: 'opendir'
				result: #'ptr'
				args: #(#'const char*')
				varArgsAfter: -1].
	errnoHolder := { 0 }.
	result := opendir
		callWith: { pathString encodeAsUTF8 }
		errno: errnoHolder.
	result isNull
		ifTrue: [self handleErrno: errnoHolder first].
	^result
%

category: 'functions'
method: FsLibcDirent_Linux
readFromDirectoryStream: dirPointer
	"Answers a DirentStruct. It will answer true to #isNull if we've reached
	the end of the directory stream. Should probably raise an end of stream
	at this point instead."

	| errnoHolder direntPtr isNull errno |
	readdir == nil
		ifTrue:
			[readdir := CCallout
				library: library
				name: 'readdir'
				result: #'ptr'
				args: #(#'ptr')
				varArgsAfter: -1].
	errnoHolder := { 0 }.
	direntPtr := readdir
		callWith: { dirPointer }
		errno: errnoHolder.
	isNull := direntPtr isNull.
	errno := errnoHolder first.
	isNull & (errno ~~ 0)
		ifTrue: [self handleErrno: errno].
	^isNull
		ifTrue: [nil]
		ifFalse: [FsDirentStruct_Linux forBytes: (CByteArray fromCPointer: direntPtr numBytes: FsDirentStruct_Linux structSize)]
%

! Class implementation for 'FsLibcDirent_macOS'

!		Instance methods for 'FsLibcDirent_macOS'

category: 'accessing'
method: FsLibcDirent_macOS
libraryName
	"Returns the name of the C library that should be used."

	^'/usr/lib/libSystem.dylib'
%

category: 'functions'
method: FsLibcDirent_macOS
openDirectoryStreamWithPath: pathString
	"This result is not automatically freed.
	The caller is expected to ensure
	#closeDirectoryStream: is always called."

	| result errnoHolder |
	opendir == nil
		ifTrue:
			[opendir := CCallout
				library: library
				name: self opendirName
				result: #'ptr'
				args: #(#'const char*' )
				varArgsAfter: -1].
	errnoHolder := { 0 }.
	result := opendir
		callWith: { pathString encodeAsUTF8 }
		errno: errnoHolder.
	result isNull
		ifTrue: [self handleErrno: errnoHolder first].
	^result
%

category: 'accessing'
method: FsLibcDirent_macOS
opendirName
	"Returns the name of the opendir function"

	self subclassResponsibility
%

category: 'accessing'
method: FsLibcDirent_macOS
readdirName
	"Returns the name of the readdir function"

	self subclassResponsibility
%

category: 'functions'
method: FsLibcDirent_macOS
readFromDirectoryStream: dirPointer
	"Answers a DirentStruct. It will answer true to #isNull if we've reached
	the end of the directory stream. Should probably raise an end of stream
	at this point instead."

	| errnoHolder direntPtr isNull errno |
	readdir == nil
		ifTrue:
			[readdir := CCallout
				library: library
				name: self readdirName
				result: #'ptr'
				args: #(#'ptr')
				varArgsAfter: -1].
	errnoHolder := { 0 }.
	direntPtr := readdir
		callWith: { dirPointer }
		errno: errnoHolder.
	isNull := direntPtr isNull.
	errno := errnoHolder first.
	isNull & (errno ~~ 0)
		ifTrue: [self handleErrno: errno].
	^isNull
		ifTrue: [nil]
		ifFalse: [FsDirentStruct_macOS forBytes: (CByteArray fromCPointer: direntPtr numBytes: FsDirentStruct_macOS structSize)]
%

! Class implementation for 'FsLibcDirent_macOS_arm64'

!		Instance methods for 'FsLibcDirent_macOS_arm64'

category: 'accessing'
method: FsLibcDirent_macOS_arm64
opendirName
	"Returns the name of the opendir function"

	^'opendir'
%

category: 'accessing'
method: FsLibcDirent_macOS_arm64
readdirName
	"Returns the name of the readdir function"

	^'readdir'
%

! Class implementation for 'FsLibcDirent_macOS_x64'

!		Instance methods for 'FsLibcDirent_macOS_x64'

category: 'accessing'
method: FsLibcDirent_macOS_x64
opendirName
	"Returns the name of the opendir function"

	^'opendir$INODE64'
%

category: 'accessing'
method: FsLibcDirent_macOS_x64
readdirName
	"Returns the name of the readdir function"

	^'readdir$INODE64'
%

! Class implementation for 'FsLibcFcntl'

!		Instance methods for 'FsLibcFcntl'

category: 'functions'
method: FsLibcFcntl
chmod: pathString
posixPermission: posixPermission

	self subclassResponsibility
%

category: 'functions'
method: FsLibcFcntl
open: pathString flags: flagsInteger mode: modeInteger

	| errnoHolder result |
	open == nil
		ifTrue: [open := CCallout
			library: library
			name: 'open'
			result: #'int32'
			args: #(#'const char*' #'int32')
			varArgsAfter: 2].
	errnoHolder := { 0 }.
	result := open
		callWith: { pathString encodeAsUTF8. flagsInteger. #'int32'. modeInteger. }
		errno: errnoHolder.
	result == -1
		ifTrue: [self handleErrno: errnoHolder first].
	^result
%

! Class implementation for 'FsLibcFcntl_Linux'

!		Instance methods for 'FsLibcFcntl_Linux'

category: 'functions'
method: FsLibcFcntl_Linux
chmod: pathString
mode: mode

	| errnoHolder result |
	chmod == nil
		ifTrue: [chmod := CCallout
			library: library
			name: 'chmod'
			result: #'int32'
			args: #(#'const char*' #'uint32')
			varArgsAfter: 2].
	errnoHolder := { 0 }.
	result := chmod
		callWith: { pathString encodeAsUTF8. mode }
		errno: errnoHolder.
	result == -1
		ifTrue: [self handleErrno: errnoHolder first].
	^result
%

category: 'accessing'
method: FsLibcFcntl_Linux
libraryName
	"Returns the name of the C library that should be used."

	^'libc.so.6'
%

! Class implementation for 'FsLibcFcntl_macOS'

!		Instance methods for 'FsLibcFcntl_macOS'

category: 'functions'
method: FsLibcFcntl_macOS
chmod: pathString
mode: mode

	| errnoHolder result |
	chmod == nil
		ifTrue: [chmod := CCallout
			library: library
			name: 'chmod'
			result: #'int32'
			args: #(#'const char*' #'uint16')
			varArgsAfter: 2].
	errnoHolder := { 0 }.
	result := chmod
		callWith: { pathString encodeAsUTF8. mode }
		errno: errnoHolder.
	result == -1
		ifTrue: [self handleErrno: errnoHolder first].
	^result
%

category: 'accessing'
method: FsLibcFcntl_macOS
libraryName
	"Returns the name of the C library that should be used."

	^'/usr/lib/libSystem.dylib'
%

! Class implementation for 'FsLibcStat'

!		Instance methods for 'FsLibcStat'

category: 'functions'
method: FsLibcStat
fstat: fd

	self subclassResponsibility
%

category: 'functions'
method: FsLibcStat
lstat: pathString

	self subclassResponsibility
%

category: 'functions'
method: FsLibcStat
mkdir: pathString

	self subclassResponsibility
%

category: 'functions'
method: FsLibcStat
stat: pathString

	self subclassResponsibility
%

! Class implementation for 'FsLibcStat_Linux'

!		Instance methods for 'FsLibcStat_Linux'

category: 'functions'
method: FsLibcStat_Linux
fstat: fd

	| statStruct errnoHolder status |
	fstat == nil
		ifTrue:
			[fstat := CCallout
				library: library
				name: '__fxstat'
				result: #'int32'
				args: #(#'int32' #'int32' #'ptr')
				varArgsAfter: -1].
	statStruct := self statStructClass new.
	errnoHolder := { 0 }.
	status := fstat
		callWith: { 0 "_STAT_VER". fd. statStruct bytes. }
		errno: errnoHolder.
	status == -1
		ifTrue: [self handleErrno: errnoHolder first].
	^statStruct
%

category: 'accessing'
method: FsLibcStat_Linux
libraryName
	"Returns the name of the C library that should be used."

	^'libc.so.6'
%

category: 'functions'
method: FsLibcStat_Linux
lstat: pathString

	| statStruct errnoHolder status |
	lstat == nil
		ifTrue:
			[lstat := CCallout
				library: library
				name: '__lxstat'
				result: #'int32'
				args: #(#'int32' #'const char*' #'ptr')
				varArgsAfter: -1].
	statStruct := self statStructClass new.
	errnoHolder := { 0 }.
	status := lstat
		callWith: { 0 "_STAT_VER". pathString encodeAsUTF8. statStruct bytes. }
		errno: errnoHolder.
	status == -1
		ifTrue: [self handleErrno: errnoHolder first].
	^statStruct
%

category: 'functions'
method: FsLibcStat_Linux
mkdir: pathString

	| errnoHolder status |
	mkdir == nil
		ifTrue:
			[mkdir := CCallout
				library: library
				name: 'mkdir'
				result: #'int32'
				args: #(#'const char*' #'uint32')
				varArgsAfter: -1].
	errnoHolder := { 0 }.
	status := mkdir
		callWith: { pathString encodeAsUTF8. 8r0777. }
		errno: errnoHolder.
	status == -1
		ifTrue: [self handleErrno: errnoHolder first].
	^true
%

category: 'functions'
method: FsLibcStat_Linux
stat: pathString

	| statStruct errnoHolder status |
	stat == nil
		ifTrue:
			[stat := CCallout
				library: library
				name: '__xstat'
				result: #'int32'
				args: #(#'int32' #'const char*' #'ptr')
				varArgsAfter: -1].
	statStruct := self statStructClass new.
	errnoHolder := { 0 }.
	status := stat
		callWith: { 0 "_STAT_VER". pathString encodeAsUTF8. statStruct bytes. }
		errno: errnoHolder.
	status == -1
		ifTrue: [self handleErrno: errnoHolder first].
	^statStruct
%

category: 'accessing'
method: FsLibcStat_Linux
statStructClass
	"Returns the class that should be used as StatStruct."

	self subclassResponsibility
%

! Class implementation for 'FsLibcStat_Linux_aarch64'

!		Instance methods for 'FsLibcStat_Linux_aarch64'

category: 'accessing'
method: FsLibcStat_Linux_aarch64
statStructClass
	"Returns the class that should be used as StatStruct."

	^FsStatStruct_Linux_aarch64
%

! Class implementation for 'FsLibcStat_Linux_x64'

!		Instance methods for 'FsLibcStat_Linux_x64'

category: 'accessing'
method: FsLibcStat_Linux_x64
statStructClass
	"Returns the class that should be used as StatStruct."

	^FsStatStruct_Linux_x64
%

! Class implementation for 'FsLibcStat_macOS'

!		Instance methods for 'FsLibcStat_macOS'

category: 'functions'
method: FsLibcStat_macOS
fstat: fd

	| statStruct errnoHolder status |
	fstat == nil
		ifTrue:
			[fstat := CCallout
				library: library
				name: self fstatName
				result: #'int32'
				args: #(#'int32' #'ptr')
				varArgsAfter: -1].
	statStruct := FsStatStruct_macOS new.
	errnoHolder := { 0 }.
	status := fstat
		callWith: { fd. statStruct bytes. }
		errno: errnoHolder.
	status == -1
		ifTrue: [self handleErrno: errnoHolder first].
	^statStruct
%

category: 'accessing'
method: FsLibcStat_macOS
fstatName
	"Returns the name of the fstat function"

	self subclassResponsibility
%

category: 'accessing'
method: FsLibcStat_macOS
libraryName
	"Returns the name of the C library that should be used."

	^'/usr/lib/libSystem.dylib'
%

category: 'functions'
method: FsLibcStat_macOS
lstat: pathString

	| statStruct errnoHolder status |
	lstat == nil
		ifTrue:
			[lstat := CCallout
				library: library
				name: self lstatName
				result: #'int32'
				args: #(#'const char*' #'ptr')
				varArgsAfter: -1].
	statStruct := FsStatStruct_macOS new.
	errnoHolder := { 0 }.
	status := lstat
		callWith: { pathString encodeAsUTF8. statStruct bytes. }
		errno: errnoHolder.
	status == -1
		ifTrue: [self handleErrno: errnoHolder first].
	^statStruct
%

category: 'accessing'
method: FsLibcStat_macOS
lstatName
	"Returns the name of the lstat function"

	self subclassResponsibility
%

category: 'functions'
method: FsLibcStat_macOS
mkdir: pathString

	| errnoHolder status |
	mkdir == nil
		ifTrue:
			[mkdir := CCallout
				library: library
				name: 'mkdir'
				result: #'int32'
				args: #(#'const char*' #'uint16') "Should this be unint32?"
				varArgsAfter: -1].
	errnoHolder := { 0 }.
	status := mkdir
		callWith: { pathString encodeAsUTF8. 8r0777. }
		errno: errnoHolder.
	status == -1
		ifTrue: [self handleErrno: errnoHolder first].
	^true
%

category: 'functions'
method: FsLibcStat_macOS
stat: pathString

	| statStruct errnoHolder status |
	stat == nil
		ifTrue:
			[stat := CCallout
				library: library
				name: self statName
				result: #'int32'
				args: #(#'const char*' #'ptr')
				varArgsAfter: -1].
	statStruct := FsStatStruct_macOS new.
	errnoHolder := { 0 }.
	status := stat
		callWith: { pathString encodeAsUTF8. statStruct bytes. }
		errno: errnoHolder.
	status == -1
		ifTrue: [self handleErrno: errnoHolder first].
	^statStruct
%

category: 'accessing'
method: FsLibcStat_macOS
statName
	"Returns the name of the stat function"

	self subclassResponsibility
%

! Class implementation for 'FsLibcStat_macOS_arm64'

!		Instance methods for 'FsLibcStat_macOS_arm64'

category: 'accessing'
method: FsLibcStat_macOS_arm64
fstatName
	"Returns the name of the fstat function"

	^'fstat'
%

category: 'accessing'
method: FsLibcStat_macOS_arm64
lstatName
	"Returns the name of the lstat function"

	^'lstat'
%

category: 'accessing'
method: FsLibcStat_macOS_arm64
statName
	"Returns the name of the stat function"

	^'stat'
%

! Class implementation for 'FsLibcStat_macOS_x64'

!		Instance methods for 'FsLibcStat_macOS_x64'

category: 'accessing'
method: FsLibcStat_macOS_x64
fstatName
	"Returns the name of the fstat function"

	^'fstat$INODE64'
%

category: 'accessing'
method: FsLibcStat_macOS_x64
lstatName
	"Returns the name of the lstat function"

	^'lstat$INODE64'
%

category: 'accessing'
method: FsLibcStat_macOS_x64
statName
	"Returns the name of the stat function"

	^'stat$INODE64'
%

! Class implementation for 'FsLibcStdio'

!		Instance methods for 'FsLibcStdio'

category: 'functions'
method: FsLibcStdio
rename: srcPathString
to: dstPathString

	| errnoHolder status |
	rename == nil
		ifTrue:
			[rename := CCallout
				library: library
				name: 'rename'
				result: #'int32'
				args: #(#'const char*' #'const char*')
				varArgsAfter: -1].
	errnoHolder := { 0 }.
	status := rename
		callWith: { srcPathString encodeAsUTF8. dstPathString encodeAsUTF8. }
		errno: errnoHolder.
	status == -1
		ifTrue: [self handleErrno: errnoHolder first].
	^true
%

! Class implementation for 'FsLibcStdio_Linux'

!		Instance methods for 'FsLibcStdio_Linux'

category: 'accessing'
method: FsLibcStdio_Linux
libraryName
	"Returns the name of the C library that should be used."

	^'libc.so.6'
%

! Class implementation for 'FsLibcStdio_macOS'

!		Instance methods for 'FsLibcStdio_macOS'

category: 'accessing'
method: FsLibcStdio_macOS
libraryName
	"Returns the name of the C library that should be used."

	^'/usr/lib/libSystem.dylib'
%

! Class implementation for 'FsLibcUnistd'

!		Instance methods for 'FsLibcUnistd'

category: 'functions'
method: FsLibcUnistd
chdir: pathString

	| errnoHolder result |
	chdir == nil
		ifTrue:
			[chdir := CCallout
				library: library
				name: 'chdir'
				result: #'int32'
				args: #(#'const char*')
				varArgsAfter: -1].
	errnoHolder := { 0 }.
	result := chdir
		callWith: { pathString }
		errno: errnoHolder.
	result == -1
		ifTrue: [self handleErrno: errnoHolder first].
	^result
%

category: 'functions'
method: FsLibcUnistd
chown: pathString
uid: uidInteger
gid: gidInteger

	| errnoHolder result |
	chown == nil
		ifTrue:
			[chown := CCallout
				library: library
				name: 'chown'
				result: #'int32'
				args: #(#'const char*' #'uint32' #'uint32')
				varArgsAfter: -1].
	errnoHolder := { 0 }.
	result := chown
		callWith: { pathString. uidInteger. gidInteger }
		errno: errnoHolder.
	result == -1
		ifTrue: [self handleErrno: errnoHolder first].
	^result
%

category: 'functions'
method: FsLibcUnistd
close: fdInteger

	| errnoHolder result |
	close == nil
		ifTrue:
			[close := CCallout
				library: library
				name: 'close'
				result: #'int32'
				args: #(#'int32')
				varArgsAfter: -1].
	errnoHolder := { 0 }.
	result := close
		callWith: { fdInteger }
		errno: errnoHolder.
	result == -1
		ifTrue: [self handleErrno: errnoHolder first].
	^result
%

category: 'functions'
method: FsLibcUnistd
ftruncate: fileDescriptor
to: length

	self subclassResponsibility
%

category: 'functions'
method: FsLibcUnistd
getcwd
	"Possible exceptions:
	EACCESS  if the user doesn't have read or search permission on a component of the path
	ENOENT if the current working directory has been unlinked
	ENOMEM if the attempt to malloc the string fails"

	| errnoHolder result |
	getcwd == nil
		ifTrue:
			[getcwd := CCallout
				library: library
				name: 'getcwd'
				result: #'char*'
				args: #(#'ptr' #'uint64')
				varArgsAfter: -1].
	errnoHolder := { 0 }.
	result := getcwd
		callWith: { nil. 0 } "Dynamically allocate a buffer for the full path."
		errno: errnoHolder.
	result == nil "The FFI will return nil for NULL char* return values."
		ifTrue: [self handleErrno: errnoHolder first].
	^result
%

category: 'functions'
method: FsLibcUnistd
lseek: descriptor
offset: offset
whence: whence

	| errnoHolder result |
	lseek == nil
		ifTrue:
			[lseek := CCallout
				library: library
				name: 'lseek'
				result: #'int64'
				args: #(#'int32' #'int64' #'int32')
				varArgsAfter: -1].
	errnoHolder := { 0 }.
	result := lseek
		callWith: { descriptor. offset. whence. }
		errno: errnoHolder.
	result == -1
		ifTrue: [self handleErrno: errnoHolder first].
	^result
%

category: 'functions'
method: FsLibcUnistd
pread: fd
into: buf
count: bytes
startingAt: offset

	| errnoHolder result |
	pread == nil
		ifTrue:
			[pread := CCallout
				library: library
				name: 'pread'
				result: #'int64'
				args: #(#'int32' #'ptr' #'uint64' #'uint64')
				varArgsAfter: -1].
	errnoHolder := { 0 }.
	result := pread
		callWith: { fd. buf. bytes. offset. }
		errno: errnoHolder.
	result == -1
		ifTrue: [self handleErrno: errnoHolder first].
	^result
%

category: 'functions'
method: FsLibcUnistd
read: fd into: buf count: bytes

	| errnoHolder result |
	read == nil
		ifTrue:
			[read := CCallout
				library: library
				name: 'read'
				result: #'int64'
				args: #(#'int32' #'ptr' #'uint64')
				varArgsAfter: -1].
	errnoHolder := { 0 }.
	result := read
		callWith: { fd. buf. bytes. }
		errno: errnoHolder.
	result == -1
		ifTrue: [self handleErrno: errnoHolder first].
	^result
%

category: 'functions'
method: FsLibcUnistd
rmdir: pathString

	| errnoHolder result |
	rmdir == nil
		ifTrue:
			[rmdir := CCallout
				library: library
				name: 'rmdir'
				result: #'int32'
				args: #(#'const char*')
				varArgsAfter: -1].
	errnoHolder := { 0 }.
	result := rmdir
		callWith: { pathString encodeAsUTF8 }
		errno: errnoHolder.
	result == -1
		ifTrue: [self handleErrno: errnoHolder first].
	^result
%

category: 'functions'
method: FsLibcUnistd
symlink: linkPathString
toTarget: targetPathString
	"Create a symlink from linkPathString to targetPathString."

	| errnoHolder result |
	symlink == nil
		ifTrue:
			[symlink := CCallout
				library: library
				name: 'symlink'
				result: #'int32'
				args: #(#'const char*' #'const char*')
				varArgsAfter: -1].
	errnoHolder := { 0 }.
	result := symlink
		callWith: { targetPathString encodeAsUTF8. linkPathString encodeAsUTF8. }
		errno: errnoHolder.
	result == -1
		ifTrue: [self handleErrno: errnoHolder first].
	^result
%

category: 'functions'
method: FsLibcUnistd
unlinkPath: pathString

	| errnoHolder result |
	unlink == nil
		ifTrue:
			[unlink := CCallout
				library: library
				name: 'unlink'
				result: #'int32'
				args: #(#'const char*')
				varArgsAfter: -1].
	errnoHolder := { 0 }.
	result := unlink
		callWith: { pathString encodeAsUTF8 }
		errno: errnoHolder.
	result == -1
		ifTrue: [self handleErrno: errnoHolder first].
	^result
%

category: 'functions'
method: FsLibcUnistd
write: fd from: buf count: bytes

	| errnoHolder result |
	write == nil
		ifTrue:
			[write := CCallout
				library: library
				name: 'write'
				result: #'int64'
				args: #(#'int32' #'ptr' #'uint64')
				varArgsAfter: -1].
	errnoHolder := { 0 }.
	result := write
		callWith: { fd. buf. bytes. }
		errno: errnoHolder.
	result == -1
		ifTrue: [self handleErrno: errnoHolder first].
	^result
%

! Class implementation for 'FsLibcUnistd_Linux'

!		Instance methods for 'FsLibcUnistd_Linux'

category: 'functions'
method: FsLibcUnistd_Linux
ftruncate: fileDescriptor
to: length

	| errnoHolder result |
	ftruncate == nil
		ifTrue:
			[ftruncate := CCallout
				library: library
				name: 'ftruncate'
				result: #'int32' "Should this be int64?"
				args: #(#'int32' #'int64')
				varArgsAfter: -1].
	errnoHolder := { 0 }.
	result := ftruncate
		callWith: { fileDescriptor. length }
		errno: errnoHolder.
	result == -1
		ifTrue: [self handleErrno: errnoHolder first].
	^result
%

category: 'accessing'
method: FsLibcUnistd_Linux
libraryName
	"Returns the name of the C library that should be used."

	^'libc.so.6'
%

! Class implementation for 'FsLibcUnistd_macOS'

!		Instance methods for 'FsLibcUnistd_macOS'

category: 'functions'
method: FsLibcUnistd_macOS
ftruncate: fileDescriptor
to: length

	| errnoHolder result |
	ftruncate == nil
		ifTrue:
			[ftruncate := CCallout
				library: library
				name: 'ftruncate'
				result: #'int64'
				args: #(#'int32' #'int64')
				varArgsAfter: -1].
	errnoHolder := { 0 }.
	result := ftruncate
		callWith: { fileDescriptor. length }
		errno: errnoHolder.
	result == -1
		ifTrue: [self handleErrno: errnoHolder first].
	^result
%

category: 'accessing'
method: FsLibcUnistd_macOS
libraryName
	"Returns the name of the C library that should be used."

	^'/usr/lib/libSystem.dylib'
%

! Class implementation for 'MemoryFileSystemEntry'

!		Class methods for 'MemoryFileSystemEntry'

category: 'instance creation'
classmethod: MemoryFileSystemEntry
named: aFileName
	^ self new
		basename: aFileName;
		yourself
%

category: 'instance creation'
classmethod: MemoryFileSystemEntry
new

	^ self basicNew
		initialize;
		yourself
%

!		Instance methods for 'MemoryFileSystemEntry'

category: 'accessing'
method: MemoryFileSystemEntry
basename
	^ basename
%

category: 'accessing'
method: MemoryFileSystemEntry
basename: aString
	basename := aString
%

category: 'accessing'
method: MemoryFileSystemEntry
creationTime
	
	^ creationTime
%

category: 'accessing'
method: MemoryFileSystemEntry
fileSize
	self subclassResponsibility 
%

category: 'initialization'
method: MemoryFileSystemEntry
initialize 
	creationTime := modificationTime := DateAndTime now.
%

category: 'testing'
method: MemoryFileSystemEntry
isDirectory
	self subclassResponsibility
%

category: 'testing'
method: MemoryFileSystemEntry
isFile
	^ self isDirectory not
%

category: 'testing'
method: MemoryFileSystemEntry
isSymlink
	"Does this entry represent a symlink?"

	^false
%

category: 'accessing'
method: MemoryFileSystemEntry
modificationTime
	^ modificationTime
%

category: 'accessing'
method: MemoryFileSystemEntry
modificationTime: anObject
	
	modificationTime := anObject
%

category: 'private'
method: MemoryFileSystemEntry
modified
	modificationTime := DateAndTime now.
%

category: 'accessing'
method: MemoryFileSystemEntry
permissions
	"Return the closest posix permissions for this entity."

	self subclassResponsibility
%

! Class implementation for 'MemoryFileSystemDirectory'

!		Instance methods for 'MemoryFileSystemDirectory'

category: 'creation'
method: MemoryFileSystemDirectory
ensureCreateDirectory: aDirectoryName
	^ self 
		fileEntryAt: aDirectoryName
		put: (self class named: aDirectoryName)
%

category: 'creation'
method: MemoryFileSystemDirectory
ensureCreateFile: aFileName
	^ self 
		fileEntryAt: aFileName 
		put: (MemoryFileSystemFile named: aFileName)
%

category: 'enumeration'
method: MemoryFileSystemDirectory
fileEntriesDo: aBlock
	
	entries do: aBlock
%

category: 'accessing'
method: MemoryFileSystemDirectory
fileEntriesIncludes: aFileName
	^ entries includesKey: aFileName
%

category: 'accessing'
method: MemoryFileSystemDirectory
fileEntryAt: aFileName
	^ entries at: aFileName
%

category: 'accessing'
method: MemoryFileSystemDirectory
fileEntryAt: aFileName ifAbsent: aBlock
	^ entries at: aFileName ifAbsent: aBlock
%

category: 'accessing'
method: MemoryFileSystemDirectory
fileEntryAt: aFileName ifPresent: aBlock
	^ (entries at: aFileName ifAbsent: [])
			ifNotNil: [:entry | aBlock value: entry ]
%

category: 'accessing'
method: MemoryFileSystemDirectory
fileEntryAt: aFileName put: anEntry
	^ entries 
		at: aFileName 
		ifAbsentPut: [
			self modified.
			anEntry ]
%

category: 'accessing'
method: MemoryFileSystemDirectory
fileEntryRemove: aFileName
	^ self fileEntryRemove: aFileName ifAbsent: [ FileDoesNotExistException signalWith: aFileName ]
%

category: 'accessing'
method: MemoryFileSystemDirectory
fileEntryRemove: aFileName ifAbsent: absentBlock
	| deletedEntry |
	deletedEntry := entries removeKey: aFileName ifAbsent: [ ^ absentBlock value ].
	modificationTime := DateAndTime now.
	^ deletedEntry
%

category: 'accessing'
method: MemoryFileSystemDirectory
fileSize
	^ 0
%

category: 'initialization'
method: MemoryFileSystemDirectory
initialize
	super initialize.
	entries := Dictionary new.
%

category: 'testing'
method: MemoryFileSystemDirectory
isDirectory
	^ true
%

category: 'accessing'
method: MemoryFileSystemDirectory
permissions
	"Return the closest posix permissions for this entity."

	^FileSystemPermission posixPermissions: 8r777
%

! Class implementation for 'MemoryFileSystemFile'

!		Instance methods for 'MemoryFileSystemFile'

category: 'stream-protocol'
method: MemoryFileSystemFile
at: index
	^ bytes at: index
%

category: 'stream-protocol'
method: MemoryFileSystemFile
at: index put: anObject
	index > bytes size
		ifTrue: [ self grow ].
	bytes
		at: index
		put:
			(anObject isCharacter
				ifTrue: [ anObject codePoint ]
				ifFalse: [ anObject ]).
	size := size max: index.
	self modified
%

category: 'stream-protocol'
method: MemoryFileSystemFile
at: index read: aCollection startingAt: start count: count 
	| max stop |
	max := size - index + 1 min: count.
	stop := start + max - 1.
	aCollection 
		replaceFrom: start
		to: stop
		with: bytes
		startingAt: index.
	^ stop - start + 1
%

category: 'stream-protocol'
method: MemoryFileSystemFile
at: first write: aCollection startingAt: start count: count
	| last |
	last := first + count - 1.
	last > bytes size
		ifTrue: [ self grownBy: last - size ].
	bytes
		replaceFrom: first
		to: last
		with: aCollection
		startingAt: start.
	size := last.
	self modified
%

category: 'open/close'
method: MemoryFileSystemFile
basicOpen
	closed := false
%

category: 'streams-compatibility'
method: MemoryFileSystemFile
binaryReadStream
	^ ReadStreamPortable on: self bytes from: 1 to: size
%

category: 'streams'
method: MemoryFileSystemFile
binaryWriteStream
	^ MemoryFileWriteStream on: self
%

category: 'accessing'
method: MemoryFileSystemFile
bytes
	^ bytes
%

category: 'open/close'
method: MemoryFileSystemFile
close
	 closed := true
%

category: 'testing'
method: MemoryFileSystemFile
closed
	^ closed
%

category: 'stream-protocol'
method: MemoryFileSystemFile
copyFrom: from to: position
	^ bytes copyFrom: from to: position
%

category: 'accessing'
method: MemoryFileSystemFile
fileSize
	^ size
%

category: 'stream-protocol'
method: MemoryFileSystemFile
grow
	self grownBy: self sizeIncrement
%

category: 'accessing'
method: MemoryFileSystemFile
grownBy: length
	bytes := bytes grownBy: length.
	self modified
%

category: 'initialization'
method: MemoryFileSystemFile
initialize
	super initialize.
	bytes := ByteArray new.
	size := 0.
	closed := false
%

category: 'accessing'
method: MemoryFileSystemFile
internalSize
	^ bytes size
%

category: 'testing'
method: MemoryFileSystemFile
isDirectory
	^ false
%

category: 'accessing'
method: MemoryFileSystemFile
permissions
	"Return the closest posix permissions for this entity."

	^FileSystemPermission posixPermissions: 8r666
%

category: 'stream-protocol'
method: MemoryFileSystemFile
readStream
	^ ReadStream on: self bytes asString from: 1 to: size
%

category: 'accessing'
method: MemoryFileSystemFile
size

	^ size
%

category: 'accessing'
method: MemoryFileSystemFile
sizeIncrement
	^ (bytes size min: 20) max: 1024
%

category: 'accessing'
method: MemoryFileSystemFile
truncate
	self truncateTo: 0
%

category: 'accessing'
method: MemoryFileSystemFile
truncateTo: aSize
	bytes size = aSize
		ifFalse: [ bytes := bytes size < aSize
				ifTrue: [ (ByteArray new: aSize)
						replaceFrom: 1
						to: bytes size
						with: bytes
						startingAt: 1 ]
				ifFalse: [ bytes copyFrom: 1 to: aSize ] ].
	size := bytes size.
	self modified
%

category: 'private'
method: MemoryFileSystemFile
updateContents: aCollection
	bytes := aCollection.
	self updateSize: aCollection size
%

category: 'private'
method: MemoryFileSystemFile
updateSize: newSize
	size := newSize.
	self modified
%

category: 'stream-protocol'
method: MemoryFileSystemFile
writeStreamDo: aBlock

	self updateContents: (ByteArray streamContents: aBlock)
%

! Class implementation for 'MemoryFileWriteStream'

!		Class methods for 'MemoryFileWriteStream'

category: 'instance creation'
classmethod: MemoryFileWriteStream
on: aFile

	^ self new
		file: aFile;
		yourself
%

!		Instance methods for 'MemoryFileWriteStream'

category: 'opening-closing'
method: MemoryFileWriteStream
close
	self stream close.
	file close
%

category: 'opening-closing'
method: MemoryFileWriteStream
closed
	^ file closed
%

category: 'accessing'
method: MemoryFileWriteStream
file: aMemoryFileSystemFile 
	file := aMemoryFileSystemFile
%

category: 'writing'
method: MemoryFileWriteStream
flush
	file updateContents: self stream contents
%

category: 'testing'
method: MemoryFileWriteStream
isBinary
	^ self stream isBinary
%

category: 'writing'
method: MemoryFileWriteStream
nextPut: aCollection
	^ self stream nextPut: aCollection
%

category: 'writing'
method: MemoryFileWriteStream
nextPutAll: aCollection
	^ self stream nextPutAll: aCollection
%

category: 'positioning'
method: MemoryFileWriteStream
position
	^ self stream position
%

category: 'positioning'
method: MemoryFileWriteStream
setToEnd
	^ self stream setToEnd
%

category: 'accessing'
method: MemoryFileWriteStream
size
	^ file size
%

category: 'accessing'
method: MemoryFileWriteStream
stream
	^ stream ifNil: [ stream := WriteStreamPortable on: file bytes from: 1 to: file size ]
%

category: 'accessing'
method: MemoryFileWriteStream
truncate

	file truncateTo: 0.
	stream := nil.
	self stream
%

! Class implementation for 'Path'

!		Class methods for 'Path'

category: 'instance creation'
classmethod: Path
* aString
	"Answer a relative path with aString as its sole segment. For example,
	Path * 'griffle' will produce the same result as ./griffle in a unix shell.
	The selector #* was chosen for its visual similarity to $."
	
	"Note: aString is not parsed, so supplying a string like '/griffle/plonk'
	will not create an absolute path."
	
	^ RelativePath with: aString
%

category: 'instance creation'
classmethod: Path
/ aString
	"Answer an absolute path with aString as its sole segment. The selector
	was chosen to allow path construction with Smalltalk syntax, which 
	neverthelesss resembles paths as they appear in a unix shell. Eg.
	Path / 'griffle' / 'plonk'."
	
	aString isEmptyOrNil 
		ifTrue: [Error signal: 'Path element cannot be empty or nil'].
	^ AbsolutePath with: aString
%

category: 'private'
classmethod: Path
addElement: element to: result
	element = '..'
		ifTrue: [ ^ self addParentElementTo: result ].
	element = ''
		ifTrue: [ ^ self addEmptyElementTo: result ].
	element = '.'
		ifFalse: [ result add: element ]
%

category: 'private'
classmethod: Path
addEmptyElementTo: result
	result isEmpty ifTrue: [result add: '']
		
%

category: 'private'
classmethod: Path
addParentElementTo: result
	(result isEmpty or: [ result last = '..' ])
		ifTrue: [ result add: '..' ]
		ifFalse: [ result removeLast ]
		
%

category: 'private'
classmethod: Path
canonicalizeElements: aCollection
	| result |
	result := OrderedCollection new.
	aCollection do: [ :element |
		self addElement: element to: result].
	^ result
%

category: 'encodings'
classmethod: Path
delimeter
	"Internal path delimeter"
	
	^$/
%

category: 'encodings'
classmethod: Path
extensionDelimiter
	"Return the extension delimiter character."
	^ $.
%

category: 'instance creation'
classmethod: Path
from: aString
	"Answer an instance of the receiver with the supplied path using the default delimiter"

	^ self from: aString delimiter: self delimeter
%

category: 'instance creation'
classmethod: Path
from: aString delimiter: aDelimiterCharacter 
	"Answer a path composed of several elements delimited by aCharacter"
	| pathClass splitPathElements |
	aString isEmpty
		ifTrue: [ ^ self root ].

	aString first = $$
		ifTrue: [
			| pathElements envVarString envVarElement envVarName |
			"GemStone paths are allowed to start with an environment variable"
			pathElements := aDelimiterCharacter split: aString.
			envVarElement := (pathElements at: 1) .
			envVarName := envVarElement copyFrom: 2 to: envVarElement size.
			envVarName size == 0
				ifTrue: [^Error signal: 'Environment variable unspecified in ', aString].
			envVarString := System gemEnvironmentVariable: envVarName.
			envVarString ifNil: [^Error signal: 'Environment variable undefined in ', aString].
			pathClass :=  ((self isAbsolutePath: envVarString delimiter: aDelimiterCharacter) or: 
									[self isAbsoluteWindowsPath: envVarString]) 
				ifTrue: [ AbsolutePath ]
				ifFalse:[ RelativePath ].
			splitPathElements :=  (aDelimiterCharacter split: envVarString) , (pathElements copyFrom: 2 to: pathElements size) ]
		ifFalse: [ 	
			pathClass :=  ((self isAbsolutePath: aString delimiter: aDelimiterCharacter) or: 
									[self isAbsoluteWindowsPath: aString]) 
				ifTrue: [ AbsolutePath ]
				ifFalse:[ RelativePath ] .
			splitPathElements := aDelimiterCharacter split: aString. ].
	
	^ pathClass withAll: splitPathElements
%

category: 'private'
classmethod: Path
isAbsolutePath: aString delimiter: aCharacter
	"Answer a boolean indicating whether the supplied path is considered absolute"

	^aString first = aCharacter
%

category: 'private'
classmethod: Path
isAbsoluteUnixPath: aString
	^aString first = $/ 
%

category: 'private'
classmethod: Path
isAbsoluteWindowsPath: aString
	aString ifEmpty: [ ^ false ].
	(aString first = $\) ifTrue: [ ^ true ]. "e.g. \file"
	^ ((aString size > 2) and: [ aString first isLetter ])
		ifTrue: [ (aString second = $:) and: [aString third = $\] ] "e.g. C:\..."
		ifFalse: [ false ]
%

category: 'instance creation'
classmethod: Path
parent
	"Answer a path that resolves to the parent of the current
	working directory. This is similar to .. in unix, but doesn't
	rely on actual hardlinks being present in the filesystem."

	^ RelativePath with: '..'
%

category: 'instance creation'
classmethod: Path
parents: anInteger
	| path |
	path := RelativePath new: anInteger.
	1 to: anInteger do: [:i | path at: i put: '..'].
	^ path
%

category: 'private'
classmethod: Path
removeRedundantSegments: segments
	"Remove redundant elements ('.' and '') from the supplied segments"

	^segments select:
		[ :segment | segment notEmpty and: [ segment ~= '.' ] ]
%

category: 'instance creation'
classmethod: Path
root
	"Answer the root path - ie, / on unix"
	
	^ AbsolutePath new
%

category: 'private'
classmethod: Path
with: aString
	"Answer an instance of the receiver representing the supplied string.
	This should only be sent to one of the concrete subclasses, e.g. AbsolutePath and RelativePath"

	| inst parsedCollection |
	self == Path
		ifTrue: [self error: '#with: should only be sent to a concrete subclass of Path'].
	parsedCollection := self delimeter split: aString.
	parsedCollection := self removeRedundantSegments: parsedCollection.
	inst := self new: parsedCollection size.
	parsedCollection withIndexDo: [:segment :index |
		inst at: index put: segment].
	^ inst
%

category: 'private'
classmethod: Path
withAll: aCollection
	"Answer an instance of the receiver representing the supplied collection of strings.
	This should only be sent to one of the concrete subclasses, e.g. AbsolutePath and RelativePath.
	If sent to the abstract Path class, a RelativePath is instantiated."

	| inst parsedCollection |
	self == Path
		ifTrue: [self error: '#with: should only be sent to a concrete subclass of Path'].
	parsedCollection := OrderedCollection new: (aCollection size max: 10).
	aCollection do: [ :each |
		parsedCollection addAll: (self delimeter split: each) ].
	parsedCollection := self removeRedundantSegments: parsedCollection.
	inst := self new: parsedCollection size.
	parsedCollection withIndexDo: [:segment :index |
		inst at: index put: segment].
	^ inst
%

category: 'instance creation'
classmethod: Path
workingDirectory
	"Answer a path that will always resolve to the current working directory."
	
	^ RelativePath new
%

!		Instance methods for 'Path'

category: 'navigating'
method: Path
, extension 
	^ self withName: self basename extension: extension
%

category: 'navigating'
method: Path
/ aString
	"aString is either a file or path.  If aString is relative, it is appended to the receiver, if it is absolute, an instance of the receiver with the path is answered"

	aString isEmptyOrNil 
		ifTrue: [ Error signal: 'Path element cannot be empty or nil'].

	^self resolvePath: (self class from: aString)
%

category: 'comparing'
method: Path
<= other
	^ self fullName <= other fullName
%

category: 'comparing'
method: Path
= other
	^ self species = other species
		and: [self size = other size
			and: [(1 to: self size) allSatisfy: [:i | (self at: i) = (other at: i)]]]
%

category: 'converting'
method: Path
asPath
	^ self
%

category: 'converting'
method: Path
asPathWith: anObject
	^ self
%

category: 'navigating'
method: Path
asResolvedBy: anObject
	^ anObject resolvePath: self
%

category: 'converting'
method: Path
asString

	^self printString
%

category: 'accessing'
method: Path
base
	^self basenameWithoutExtension 
%

category: 'accessing'
method: Path
basename
	"Returns the base of the basename, 
		i.e. 
		/foo/gloops.taz basename is 'gloops.taz'
		If empty, it is the emptyPathString"

	self isEmpty ifTrue: 
		[ ^ self emptyPathString ].
	^ self at: self size
%

category: 'accessing'
method: Path
basename: newBasename
	"change the basename"
	self size == 0
		"the root node"
		ifTrue: [ ^ Error signal: '0 length Path, cannot change basename'].
	self at: self size put: newBasename
%

category: 'accessing'
method: Path
basenameWithoutExtension
	"Returns the base of the basename but without its extension, 
		i.e. 
		/foo/gloops.taz basenameWithoutExtension is 'gloops'
		/ basenameWithoutExtension is '/'"
	
	^ self basename copyUpToLast: self extensionDelimiter
%

category: 'accessing'
method: Path
basenameWithoutExtension: anExtension
	"Returns the basename without specified extension (if any)
	('/foo/gloops.taz' asPath basenameWithoutExtension: 'taz') = 'gloops'
	"
	| extensionWithDelimiter |

	extensionWithDelimiter := anExtension copyWithFirst: self extensionDelimiter.
	(self basename endsWith: extensionWithDelimiter)
		ifTrue: [^ self basename allButLast: extensionWithDelimiter size]
		ifFalse: [ ^ self basename ]
%

category: 'navigating'
method: Path
canonicalize
	"Answer the receiver with references to the current folder (.) and parent folder (..) removed"
	
	^self class withAll: (self class canonicalizeElements: self segments).
%

category: 'comparing'
method: Path
contains: anObject
	"Return true if anObject is in a subfolder of me"
	^ anObject isContainedBy: self
%

category: 'comparing'
method: Path
containsPath: aPath
	self size < aPath size ifFalse: [^ false].
	1	to: self size 
		do: [:i | (self at: i) = (aPath at: i) ifFalse: [^ false]].
	^ true
%

category: 'comparing'
method: Path
containsReference: aReference
	^ false
%

category: 'private'
method: Path
copyFrom: aPath
	| size |
	size := aPath size min: self size.
	1 to: size do: [:i | self at: i put: (aPath at: i)].
	
%

category: 'accessing'
method: Path
delimiter
	^ $/
%

category: 'enumerating'
method: Path
do: aBlock 
	1 
		to: self size
		do: 
			[ :index || segment |
			segment := self at: index.
			segment isEmpty ifFalse: [ aBlock value: segment ] ]
%

category: 'accessing'
method: Path
emptyPathString
	"Answer the string representing an empty (size = 0) instance of the receiver"

	^self delimiter asString
%

category: 'accessing'
method: Path
extension
	"Return the extension of path basename i.e., /foo/gloops.taz extension is 'taz'"
	
	^ self basename copyAfterLast: self extensionDelimiter
%

category: 'accessing'
method: Path
extensionDelimiter
	^ self class extensionDelimiter
%

category: 'accessing'
method: Path
extensions
	"Return the extensions of the receiver in order of appearance"
	"(Path from: '/foo/bar.tar.gz') extensions"
	^ (self extensionDelimiter split: self basename) allButFirst
%

category: 'accessing'
method: Path
fullName
	"Return the fullName of the receiver."
	
	^ self pathString
%

category: 'comparing'
method: Path
hash

"Returns a numeric hash key for the receiver."

| mySize interval hashValue |

(mySize := self size) == 0
  ifTrue: [ ^15243 ].

"Choose an interval so that we sample at most 5 elements of the receiver"
interval := ((mySize - 1) // 4) max: 1.

hashValue := 4459.
1 to: mySize by: interval do: [ :i | | anElement |
  anElement := self at: i.
  hashValue := (hashValue bitShift: -1) bitXor: anElement hash.
  ].

^ hashValue abs
%

category: 'testing'
method: Path
isAbsolute
	self subclassResponsibility 
%

category: 'private'
method: Path
isAllParents
	1 to: self size do: [:i | (self at: i) = '..' ifFalse: [^ false]].
	^ true
%

category: 'comparing'
method: Path
isChildOf: anObject
	^ self parent = anObject
%

category: 'comparing'
method: Path
isContainedBy: anObject
	"DoubleDispatch helper for #contains:"
	^ anObject containsPath: self
%

category: 'testing'
method: Path
isEmpty
	^ self size = 0
%

category: 'testing'
method: Path
isRelative
	^ self isAbsolute not
%

category: 'testing'
method: Path
isRoot
	self subclassResponsibility 
%

category: 'testing'
method: Path
isWorkingDirectory
	^ self size = 0
%

category: 'private'
method: Path
lengthOfStemWith: aPath
	| limit index |
	limit := self size min: aPath size.
	index := 1.
	[index <= limit and: [(self at: index) = (aPath at: index)]] 
		whileTrue: [index := index + 1].
	^ index - 1
%

category: 'navigating'
method: Path
makeRelative: anObject
	^ anObject relativeToPath: self
%

category: 'navigating'
method: Path
parent
	| size parent |
	self isRoot ifTrue: [^ self].
	self isAllParents ifTrue: [^ self / '..'].
	
	size := self size - 1.
	parent := self class new: size.
	1 to: size do: [:i | parent at: i put: (self at: i)].
	^ parent
%

category: 'navigating'
method: Path
parentUpTo: aParentDirName
	"Answers the path of the parent dir with name aParentDirName or root if not found."

	self withParents
		reverseDo: [ :dir | 
			dir basename = aParentDirName
				ifTrue: [ ^ dir ] ].
	^ Path root
%

category: 'printing'
method: Path
pathString
	"Return a string containing the path elements of the receiver, without the 'Path *' part"

	"((FileSystem workingDirectory / 'book-result' / 'W01-Welcome')
		relativeToReference: FileSystem workingDirectory) pathString
	>>> 'book-result/W01-Welcome'"

	^String streamContents: [ :stream | 
		self printPathOn: stream delimiter: self delimiter ]
%

category: 'printing'
method: Path
printJsonOn: aStream
	"Print the receiving instance in JSON format.
	For Path, this is defined as the #pathString
	surrounded by double quotes."

	aStream
		nextPut: $";
		nextPutAll: self pathString;
		nextPut: $"
%

category: 'printing'
method: Path
printOn: aStream 
	self printOn: aStream delimiter: self delimiter.
%

category: 'printing'
method: Path
printOn: aStream delimiter: aCharacter
	(1 to: self size)
		do: [:index | aStream nextPutAll: (self at: index)]
		separatedBy: [aStream nextPut: aCharacter]
%

category: 'printing'
method: Path
printPathOn: aStream
	"Print the receiver's path on aStream (without 'Path' prepended) using the default delimiter"
	"String streamContents: [ :str| 
		((FileSystem workingDirectory / 'book-result' / 'W01-Welcome') 
			relativeToReference: FileSystem workingDirectory) printPathOn: str]
	>>> 'book-result/W01-Welcome'"

	self printPathOn: aStream delimiter: self delimiter.
%

category: 'printing'
method: Path
printPathOn: aStream delimiter: aCharacter
	"Print the receiver's path on aStream (without 'Path' prepended)"
	"String streamContents: [ :str| 
		((FileSystem workingDirectory / 'book-result' / 'W01-Welcome')
			relativeToReference: FileSystem workingDirectory) printPathOn: str delimiter: $|]
	>>> 'book-result|W01-Welcome'"

	(1 to: self size)
		do: [:index | aStream nextPutAll: (self at: index)]
		separatedBy: [aStream nextPut: aCharacter]
%

category: 'printing'
method: Path
printWithDelimiter: aCharacter
	^ String streamContents: [:out | self printOn: out delimiter: aCharacter]
%

category: 'navigating'
method: Path
relativeTo: anObject
	^ anObject makeRelative: self
%

category: 'navigating'
method: Path
relativeToPath: aPath
	"Return the receiver as relative to the argument aPath"

	"(Path / 'griffle' / 'plonk' / 'nurp') 
		relativeToPath: (Path / 'griffle') 
			returns  plonk/nurp"

	| prefix relative |
	prefix := self lengthOfStemWith: aPath.
	relative := RelativePath parents: aPath size - prefix.
	prefix + 1 to: self size do: [ :i | relative := relative / (self at: i) ].
	^ relative
%

category: 'navigating'
method: Path
resolve
	^ self
%

category: 'navigating'
method: Path
resolve: anObject
	"Return a path in which the argument has been interpreted in the context of the receiver. Different 
	argument types have different resolution semantics, so we use double dispatch to resolve them correctly."
	
	^ anObject asResolvedBy: self
%

category: 'navigating'
method: Path
resolvePath: aPath
	"Answers a path created by resolving the argument against the receiver.
	If the argument is abolute answer the argument itself. Otherwise, concatenate the
	two paths."

	| elements |

	aPath isAbsolute ifTrue: [^ aPath].
	elements := Array new: self size + aPath size.

	1 to: self size do: [:i | elements at: i put: (self at: i)].
	1 to: aPath size do: [:i | elements at: self size + i put: (aPath at: i)].
	
	^ self class withAll: elements
%

category: 'navigating'
method: Path
resolveReference: aReference
	^ aReference
%

category: 'navigating'
method: Path
resolveString: aString
	"Treat strings as relative paths with a single element."
	
	^ self / aString
%

category: 'accessing'
method: Path
segments
	"return an array with all the path segements separated"
	| segments |
	
	segments := OrderedCollection new.
	
	self do: [ :part|
		segments add: part
	].
	
	^ segments asArray 
%

category: 'navigating'
method: Path
withExtension: extension 
	| basename name |
	basename := self basename.
	^ (basename endsWith: extension) 
		ifTrue: [ self ]
		ifFalse: 
			[name := basename copyUpToLast: self extensionDelimiter.
			self withName: name extension: extension]
%

category: 'private'
method: Path
withName: name extension: extension
	| basename |
	basename :=String streamContents:
		[:out |
		out nextPutAll: name.
		out nextPut: self extensionDelimiter.
		out nextPutAll: extension].
	^ self copy 
		at: self size put: basename;
		yourself
%

category: 'enumerating'
method: Path
withParents
	| paths |
	paths := OrderedCollection new.
	1 to: self size -1 do: [ :index | paths add: ((self class new: index) copyFrom: self) ].
	paths add: self.
	
	^ paths
%

! Class implementation for 'AbsolutePath'

!		Class methods for 'AbsolutePath'

category: 'utilities'
classmethod: AbsolutePath
addEmptyElementTo: result
%

category: 'instance creation'
classmethod: AbsolutePath
from: aString delimiter: aDelimiterCharater
	aString = '/'
		ifTrue: [ ^ self root ].
		
	^ super from: aString delimiter: aDelimiterCharater
%

!		Instance methods for 'AbsolutePath'

category: 'testing'
method: AbsolutePath
isAbsolute
	^ true
%

category: 'testing'
method: AbsolutePath
isRoot
	^ self size = 0
%

category: 'printing'
method: AbsolutePath
printOn: aStream
	aStream nextPutAll: 'Path'.
	self isRoot
		ifTrue: [aStream nextPutAll: ' root']
		ifFalse:
			[1 to: self size do:
				[:i |
				aStream 
					nextPutAll: ' / ''';
				 	nextPutAll: (self at: i);
					nextPut: $']]
%

category: 'printing'
method: AbsolutePath
printPathOn: aStream delimiter: aCharacter
	"Print the path elements of the receiver, without the 'Path *' part"

	aStream nextPut: aCharacter.
	super printPathOn: aStream delimiter: aCharacter
%

category: 'enumerating'
method: AbsolutePath
withParents
	^ super withParents addFirst: (Path root); yourself
%

! Class implementation for 'RelativePath'

!		Instance methods for 'RelativePath'

category: 'accessing'
method: RelativePath
emptyPathString
	"Answer the string representing an empty (size = 0) instance of the receiver.
	For a relative path, this is the current directory"

	^'.'
%

category: 'testing'
method: RelativePath
isAbsolute
	^ false
%

category: 'testing'
method: RelativePath
isRoot
	^ false
%

category: 'printing'
method: RelativePath
printOn: aStream
	aStream nextPutAll: 'Path '.
	self isWorkingDirectory
		ifTrue: [aStream nextPutAll: 'workingDirectory']
		ifFalse: 
			[aStream 
				nextPutAll: '* ''';
				nextPutAll: (self at: 1) asString;
				nextPut: $'.
			2 to: self size do:
				[:i |
				aStream
					nextPutAll: ' / ''';
					nextPutAll: (self at: i);
					nextPut: $']]
					
			
%

category: 'printing'
method: RelativePath
printOn: aStream delimiter: aCharacter
	self isWorkingDirectory ifTrue: [aStream nextPut: $.. ^ self].
	super printOn: aStream delimiter: aCharacter
%

! Class implementation for 'ZnCharacterEncoder'

!		Class methods for 'ZnCharacterEncoder'

category: 'accessing'
classmethod: ZnCharacterEncoder
canonicalEncodingIdentifier: string
	^ (string select: [ :each | each isAlphaNumeric ]) asLowercase
%

category: 'accessing'
classmethod: ZnCharacterEncoder
handlesEncoding: string
	"Return true when my instances handle the encoding described by string"
	
	self subclassResponsibility: #handlesEncoding:
%

category: 'accessing'
classmethod: ZnCharacterEncoder
knownEncodingIdentifiers
	"Return a collection of all known encoding identifiers in the system"
	
	self = ZnCharacterEncoder ifFalse: [ ^ #() ].
	^ Array streamContents: [ :all |
		self allSubclasses do: [ :subClass |
			all nextPutAll: subClass knownEncodingIdentifiers ] ]
%

category: 'instance creation'
classmethod: ZnCharacterEncoder
newForEncoding: string
	"Return a new character encoder object for an encoding described by string.
	Search for a subclass that handles it and delegate (subclassResponsibility)."

	^ self
		newForEncoding: string
		stringClass:
			(String isInUnicodeComparisonMode
				ifTrue: [ Unicode7 ]
				ifFalse: [ String ])
%

category: 'instance creation'
classmethod: ZnCharacterEncoder
newForEncoding: string stringClass: stringClass
	"Return a new character encoder object for an encoding described by string.
	Search for a subclass that handles it and delegate (subclassResponsibility)."
	
	| concreteSubclass |
	concreteSubclass := self allSubclasses 
		detect: [ :each | each handlesEncoding: string ] 
		ifNone: [ ^ self error: 'The ', string printString, ' is not currently supported.' ].
	^ concreteSubclass newForEncoding: string stringClass: stringClass
%

!		Instance methods for 'ZnCharacterEncoder'

category: 'comparing'
method: ZnCharacterEncoder
= anEncoder

	^self class == anEncoder class and: [self stringClass == anEncoder stringClass]
%

category: 'converting'
method: ZnCharacterEncoder
asZnCharacterEncoder
	^ self
%

category: 'converting'
method: ZnCharacterEncoder
backOnStream: stream
	"Move back one character on stream, assuming stream understands #back"
	
	self subclassResponsibility: #backOnStream:
%

category: 'convenience'
method: ZnCharacterEncoder
decodeAsCodePoints: bytes
	"Decode bytes and return the resulting code points"
	
	self subclassResponsibility: #decodeAsCodePoints:
%

category: 'convenience'
method: ZnCharacterEncoder
decodeBytes: bytes
	"Decode bytes and return the resulting string"

	| byteStream |
	byteStream := bytes readStream.
	^ String
		streamContents: [ :stream | 
			[ byteStream atEnd ]
				whileFalse: [ stream nextPut: (self nextFromStream: byteStream) ] ]
%

category: 'convenience'
method: ZnCharacterEncoder
encodeCodePoints: codePoints
	"Encode codePoints and return the resulting byte array"
	
	^ self subclassResponsibility: #encodeCodePoints:
%

category: 'converting'
method: ZnCharacterEncoder
encodedByteCountFor: character
	"Return how many bytes are needed to encode character"
	
	"We should use #codePoint but #asInteger is faster"
	
	^ self encodedByteCountForCodePoint: character asInteger
%

category: 'convenience'
method: ZnCharacterEncoder
encodedByteCountForCodePoint: codePoint
	"Return the exact number of bytes it would take to encode codePoint as a byte array"

	self subclassResponsibility
%

category: 'convenience'
method: ZnCharacterEncoder
encodedByteCountForCodePoints: codePoints
	"Return the exact number of bytes it would take to encode codePoints as a byte array"

	^ codePoints 
		inject: 0 
		into: [ :sum :each |
			sum + (self encodedByteCountForCodePoint: each) ]
%

category: 'convenience'
method: ZnCharacterEncoder
encodedByteCountForString: string
	"Return the exact number of bytes it would take to encode string as a byte array"

	^self subclassResponsibility: #encodedByteCountForCodePoints:
%

category: 'handling errors'
method: ZnCharacterEncoder
error: messageString
	"Raises an error.  This method is intended for use in raising
 application-defined or user-defined errors. Returns the receiver."

	^ ZnCharacterEncodingError signal: messageString
%

category: 'handling errors'
method: ZnCharacterEncoder
errorOutsideRange

	^ self error: 'Character code point outside encoder range'
%

category: 'hashing'
method: ZnCharacterEncoder
hash

	^self class hash bitXor: stringClass hash
%

category: 'accessing'
method: ZnCharacterEncoder
maximumUTFCode
	^ 16r10FFFF
%

category: 'convenience'
method: ZnCharacterEncoder
next: count putAll: string startingAt: offset toStream: stream
	"Write count characters from string starting at offset to stream."
	
	offset to: offset + count - 1 do: [ :index | 
		self nextPut: (string at: index) toStream: stream ]
%

category: 'converting'
method: ZnCharacterEncoder
nextCodePointFromStream: stream
	"Read and return the next integer code point from stream"
	
	self subclassResponsibility: #nextCodePointFromStream:
%

category: 'converting'
method: ZnCharacterEncoder
nextFromStream: stream
	"Read and return the next character from stream"
	
	^ Character codePoint: (self nextCodePointFromStream: stream)
%

category: 'converting'
method: ZnCharacterEncoder
nextPut: character toStream: stream
	"Write the encoding for character to stream"
	
	"We should use #codePoint but #asInteger is faster"
	
	self nextPutCodePoint: character asInteger toStream: stream
%

category: 'accessing'
method: ZnCharacterEncoder
stringClass
	^ stringClass
		ifNil: [ 
			stringClass := String isInUnicodeComparisonMode
				ifTrue: [ Unicode7 ]
				ifFalse: [ String ] ]
%

category: 'accessing'
method: ZnCharacterEncoder
stringClass: object
	stringClass := object
%

! Class implementation for 'Zn8BITEncoder'

!		Class methods for 'Zn8BITEncoder'

category: 'accessing'
classmethod: Zn8BITEncoder
default
	
	^self new
%

category: 'accessing'
classmethod: Zn8BITEncoder
handlesEncoding: string
	"Return true when my instances handle the encoding described by string"
	
	^ (self canonicalEncodingIdentifier: string) = '8bit'
%

category: 'accessing'
classmethod: Zn8BITEncoder
knownEncodingIdentifiers
	^ #( #'8bit' )
%

category: 'instance creation'
classmethod: Zn8BITEncoder
newForEncoding: string stringClass: stringClass
	"Return a new character encoder object for an encoding described by string.
	Search for a subclass that handles it and delegate (subclassResponsibility)."

	^ self new stringClass: stringClass
%

!		Instance methods for 'Zn8BITEncoder'

category: 'converting'
method: Zn8BITEncoder
backOnStream: stream
	"Move back one character on stream"

	stream position = 0
		ifTrue: [Error signal: 'Cannot move backward past the start of the stream.'].
	stream skip: -1
%

category: 'convenience'
method: Zn8BITEncoder
decodeAsCodePoints: bytes
	"Decode bytes and return the resulting code points"

	^ String withBytes: bytes
%

category: 'convenience'
method: Zn8BITEncoder
decodeBytes: bytes
	"Decode bytes and return the resulting string"

	^ self stringClass withBytes: bytes
%

category: 'convenience'
method: Zn8BITEncoder
encodedByteCountForCodePoint: codePoint
	"Return the exact number of bytes it would take to encode codePoint as a byte array"

	^codePoint < 256
		ifTrue: [1]
		ifFalse: [self errorOutsideRange]
%

category: 'convenience'
method: Zn8BITEncoder
encodeString: string
	"Encode string and return an array of bytes instance"

	({String.
	Unicode7} includes: string class)
		ifFalse: [ 
			self
				error:
					'Can only encode instances of String or Unicode7 ... single byte characters' ].
	^ string asByteArray
%

category: 'accessing'
method: Zn8BITEncoder
identifier
	^ #'8bit'
%

category: 'converting'
method: Zn8BITEncoder
nextCodePointFromStream: stream
	"Read and return the next integer code point from stream"

	^ stream next
%

category: 'converting'
method: Zn8BITEncoder
nextFromStream: stream
	"Read and return the next character from stream"
	
	^ Character codePoint: stream next
%

category: 'converting'
method: Zn8BITEncoder
nextPutCodePoint: codePoint toStream: stream
	"Write the encoding for Integer code point to stream"

	^ stream nextPut: (Character codePoint: codePoint)
%

category: 'convenience'
method: Zn8BITEncoder
readInto: string startingAt: offset count: requestedCount fromStream: stream
	"Read requestedCount characters into string starting at offset,
	returning the number read, there could be less available when stream is atEnd."

	| stringBuffer |
	stringBuffer := string.
	offset to: offset + requestedCount - 1 do: [ :index | 
		stream atEnd ifTrue: [ ^ index - offset ].  
		stringBuffer codePointAt: index put: (self nextCodePointFromStream: stream)].
	^ requestedCount
%

! Class implementation for 'ZnUTF8Encoder'

!		Class methods for 'ZnUTF8Encoder'

category: 'accessing'
classmethod: ZnUTF8Encoder
default
	
	^self new
%

category: 'accessing'
classmethod: ZnUTF8Encoder
handlesEncoding: string
	"Return true when my instances handle the encoding described by string"
	
	^ (self canonicalEncodingIdentifier: string) = 'utf8'
%

category: 'accessing'
classmethod: ZnUTF8Encoder
knownEncodingIdentifiers
	^ #( utf8 )
%

category: 'instance creation'
classmethod: ZnUTF8Encoder
newForEncoding: string stringClass: stringClass
	"Return a new character encoder object for an encoding described by string.
	Search for a subclass that handles it and delegate (subclassResponsibility)."

	^ self new stringClass: stringClass
%

!		Instance methods for 'ZnUTF8Encoder'

category: 'converting'
method: ZnUTF8Encoder
backOnStream: stream
	"Move back one character on stream"

	[stream position = 0
		ifTrue: [Error signal: 'Cannot move backward past the start of the stream.'].
	stream skip: -1.
	(stream peek bitAnd: 2r11000000) == 2r10000000 ] whileTrue
%

category: 'convenience'
method: ZnUTF8Encoder
decodeAsCodePoints: bytes
	"Decode bytes and return the resulting code points"

	| ar |
	ar := {}.
	bytes decodeFromUTF8 do: [:char | ar add: char codePoint ].
	^ ar
%

category: 'convenience'
method: ZnUTF8Encoder
decodeBytes: bytes
	"Decode bytes and return the resulting string"

	^ bytes decodeFromUTF8
%

category: 'convenience'
method: ZnUTF8Encoder
encodeCodePoints: codePoints
	"Encode codePoints and return the resulting byte array"
	
	^ codePoints asByteArray asUnicodeString encodeAsUTF8
%

category: 'converting'
method: ZnUTF8Encoder
encodedByteCountFor: character
	"Return how many bytes are needed to encode character"
		
	^ character asString encodeAsUTF8 size
%

category: 'convenience'
method: ZnUTF8Encoder
encodedByteCountForCodePoint: codePoint
	"Return the exact number of bytes it would take to encode codePoint as a byte array"

	codePoint < 128 ifTrue: [ ^ 1 ].
	codePoint < 2048 ifTrue: [ ^ 2 ].
	codePoint < 65535 ifTrue: [ ^ 3 ].
	codePoint <= self maximumUTFCode ifTrue: [ ^ 4 ].
	self errorOutsideRange
%

category: 'convenience'
method: ZnUTF8Encoder
encodedByteCountForCodePoints: codePoints
	"Return the exact number of bytes it would take to encode codePoints as a byte array"

	^ (self encodeCodePoints: codePoints) size
%

category: 'convenience'
method: ZnUTF8Encoder
encodedByteCountForString: string
	"Return the exact number of bytes it would take to encode string as a byte array"

	^ (self encodeString: string) size
%

category: 'convenience'
method: ZnUTF8Encoder
encodeString: string
	"Encode string and return the resulting Utf8 instance"
	
	^ string encodeAsUTF8 asByteArray
%

category: 'error handling'
method: ZnUTF8Encoder
errorIllegalContinuationByte
	^ self error: 'Illegal continuation byte for utf-8 encoding'
%

category: 'error handling'
method: ZnUTF8Encoder
errorIllegalLeadingByte
	^ self error: 'Illegal leading byte for utf-8 encoding'
%

category: 'error handling'
method: ZnUTF8Encoder
errorIncomplete
	^self error: 'Incomplete input for character decoding'
%

category: 'error handling'
method: ZnUTF8Encoder
errorOverlong
	^ self error: 'Overlong utf-8 encoding (non-shortest form)'
%

category: 'accessing'
method: ZnUTF8Encoder
identifier
	^ #utf8
%

category: 'testing'
method: ZnUTF8Encoder
isSurrogateCodePoint: codePoint
	"Surrogate Code Points should not be encoded or decoded because they are not Unicode scalar values"
	
	^ codePoint between: 16rD800 and: 16rDFFF
%

category: 'convenience'
method: ZnUTF8Encoder
next: count putAll: string startingAt: offset toStream: stream
	"Write count characters from string starting at offset to stream."
	
	stream nextPutAll: (string copyFrom: offset to: offset + count - 1) encodeAsUTF8 asByteArray
%

category: 'converting'
method: ZnUTF8Encoder
nextCodePointFromStream: stream
	"Read and return the next integer code point from stream"

	| code byte next |
	(byte := stream next ifNil: [ ^ self errorIncomplete ]) < 128
		ifTrue: [ ^ byte ].
	(byte bitAnd: 2r11100000) == 2r11000000
		ifTrue: [ 
			code := byte bitAnd: 2r00011111.
			((next := stream next ifNil: [ ^ self errorIncomplete ]) bitAnd: 2r11000000) == 2r10000000
				ifTrue: [ code := (code bitShift: 6) + (next bitAnd: 2r00111111) ]
				ifFalse: [ ^ self errorIllegalContinuationByte ].
			code < 128 ifTrue: [ ^ self errorOverlong ].
			^ code ].
	(byte bitAnd: 2r11110000) == 2r11100000
		ifTrue: [ 
			code := byte bitAnd: 2r00001111.
			2 timesRepeat: [ 
				((next := stream next ifNil: [ ^ self errorIncomplete ]) bitAnd: 2r11000000) == 2r10000000
					ifTrue: [ code := (code bitShift: 6) + (next bitAnd: 2r00111111) ]
					ifFalse: [ ^ self errorIllegalContinuationByte ] ].
			code < 2048 ifTrue: [ ^ self errorOverlong ].
			(self isSurrogateCodePoint: code) ifTrue: [ ^ self errorOutsideRange ].
			code = 65279 "Unicode Byte Order Mark" ifTrue: [ 
				stream atEnd ifTrue: [ ^ self errorIncomplete ].
				^ self nextCodePointFromStream: stream ].
			^ code ].
	(byte bitAnd: 2r11111000) == 2r11110000
		ifTrue: [ 
			code := byte bitAnd: 2r00000111.
			3 timesRepeat: [ 
				((next := stream next ifNil: [ ^ self errorIncomplete ]) bitAnd: 2r11000000) == 2r10000000
					ifTrue: [ code := (code bitShift: 6) + (next bitAnd: 2r00111111) ]
					ifFalse: [ ^ self errorIllegalContinuationByte ] ].
			code < 65535 ifTrue: [ ^ self errorOverlong ].
			^ code ].
	^ self errorIllegalLeadingByte
%

category: 'converting'
method: ZnUTF8Encoder
nextPutCodePoint: codePoint toStream: stream
	"Write the encoding for Integer code point to stream"

	^ stream nextPutAll: (Character codePoint: codePoint) asString encodeAsUTF8
%

category: 'convenience'
method: ZnUTF8Encoder
readInto: string startingAt: offset count: requestedCount fromStream: stream
	"Read requestedCount characters into string starting at offset,
	returning the number read, there could be less available when stream is atEnd."

	| stringBuffer |
	stringBuffer := string.
	offset to: offset + requestedCount - 1 do: [ :index | 
		stream atEnd ifTrue: [ ^ index - offset ].  
		stringBuffer codePointAt: index put: (self nextCodePointFromStream: stream)].
	^ requestedCount
%

! Class implementation for 'ZnBufferedReadStream'

!		Class methods for 'ZnBufferedReadStream'

category: 'instance creation'
classmethod: ZnBufferedReadStream
new

	^ self basicNew
		initialize;
		yourself
%

category: 'instance creation'
classmethod: ZnBufferedReadStream
on: readStream
	^ self new
		on: readStream;
		yourself
%

category: 'convenience'
classmethod: ZnBufferedReadStream
on: readStream do: block
	"Execute block with as argument a ZnBufferedReadStream on readStream.
	Return the value of block."

	^ block value: (self on: readStream)
%

!		Instance methods for 'ZnBufferedReadStream'

category: 'testing'
method: ZnBufferedReadStream
atEnd
	^ position > limit and: [ stream atEnd ]
	
%

category: 'accessing'
method: ZnBufferedReadStream
buffer

	^ buffer
%

category: 'initialize-release'
method: ZnBufferedReadStream
close
	stream close
%

category: 'testing'
method: ZnBufferedReadStream
closed
	^ stream closed
%

category: 'accessing'
method: ZnBufferedReadStream
collectionSpecies
	^ stream isBinary
		ifTrue: [ ByteArray ]
		ifFalse: [ 
			(stream respondsTo: #'stringClass')
				ifTrue: [ stream stringClass ]
				ifFalse: [ 
					String isInUnicodeComparisonMode
						ifTrue: [ Unicode7 ]
						ifFalse: [ String ] ] ]
%

category: 'accessing'
method: ZnBufferedReadStream
contents
	
	^ self upToEnd
%

category: 'accessing'
method: ZnBufferedReadStream
defaultBufferSize
	^ 2 raisedToInteger: 16
%

category: 'private'
method: ZnBufferedReadStream
discardBuffer
	limit := 0.
	position := 1
%

category: 'initialization'
method: ZnBufferedReadStream
initialize

	position := 1.
	limit := 0
%

category: 'accessing-bytes'
method: ZnBufferedReadStream
int16
	^ self nextIntegerOfSize: 2 signed: true bigEndian: true 
%

category: 'accessing-bytes'
method: ZnBufferedReadStream
int32
	^ self nextIntegerOfSize: 4 signed: true bigEndian: true
%

category: 'accessing-bytes'
method: ZnBufferedReadStream
int8
	^ self nextIntegerOfSize: 1 signed: true bigEndian: true 
%

category: 'accessing'
method: ZnBufferedReadStream
isBinary
	^ stream isBinary
%

category: 'testing'
method: ZnBufferedReadStream
isEmpty
	"Return true if the stream has no available data."

	^self atEnd
%

category: 'testing'
method: ZnBufferedReadStream
isStream
	^ true
%

category: 'accessing'
method: ZnBufferedReadStream
next
	"Return the next element and move over it"
	
	position > limit
		ifTrue: [ self nextBuffer ].
	^ position <= limit
		ifTrue: [ 
			| char |
			char := buffer at: position.
			position := position + 1.
			char ]
		ifFalse: [ nil ]
%

category: 'accessing'
method: ZnBufferedReadStream
next: requestedCount 
	"Read requestedCount elements and return them as a collection.
	If less are available, a smaller collection will be returned."

	^ self 
		next: requestedCount 
		into: (self collectionSpecies new: requestedCount)
%

category: 'accessing'
method: ZnBufferedReadStream
next: requestedCount into: collection
	"Read requestedCount elements into collection,
	returning a copy if less elements are available"
	
	^ self 
		next: requestedCount 
		into: collection 
		startingAt: 1   
%

category: 'accessing'
method: ZnBufferedReadStream
next: requestedCount into: collection startingAt: offset
	"Read requestedCount elements into collection starting at offset,
	returning a copy if less elements are available"
	
	| read |
	read := self 
		readInto: collection 
		startingAt: offset 
		count: requestedCount.
	^ read = requestedCount 
		ifTrue: [ collection ]
		ifFalse: [ collection copyFrom: 1 to: offset + read - 1 ]     
%

category: 'private'
method: ZnBufferedReadStream
nextBuffer
	stream atEnd ifTrue: [ ^ self ].
	limit := stream readInto: buffer startingAt: 1 count: buffer size.
	position := 1
%

category: 'accessing-bytes'
method: ZnBufferedReadStream
nextInt32
	^ self nextIntegerOfSize: 4 signed: true bigEndian: true
%

category: 'accessing-bytes'
method: ZnBufferedReadStream
nextIntegerOfSize: numberOfBytes signed: signed bigEndian: bigEndian
	"Assuming the receiver is a stream of bytes, read the next integer of size numberOfBytes.
	If bigEndian is true, use network byte order, most significant byte first, 
	else use little endian order, least significant byte first.
	If signed is true, interpret as a two-complement signed value, 
	else interpret as a plain unsigned value."
	
	| value |
	value := 0.
	bigEndian
		ifTrue: [ 
			(numberOfBytes - 1) * 8 to: 0 by: -8 do: [ :shift |
				value := value + (self next bitShift: shift) ] ]
		ifFalse: [ 
			0 to: (numberOfBytes - 1) * 8 by: 8 do: [ :shift |
				value := value + (self next bitShift: shift) ] ].
	^ (signed and: [ (value bitAt: numberOfBytes * 8) = 1 ])
		ifTrue: [ value - (1 << (numberOfBytes * 8)) ]
		ifFalse: [ value ]
%

category: 'accessing'
method: ZnBufferedReadStream
nextInto: collection
	"Read the next elements of the receiver into collection,
	returning a copy if less elements are available"
	
	^ self
		next: collection size
		into: collection
%

category: 'accessing'
method: ZnBufferedReadStream
nextLine
"Answer next line (may be empty) without line end delimiters, or nil if at end.
Leave the stream positioned after the line delimiter(s).
Handle a zoo of line delimiters CR, LF, or CR-LF pair"

| cr lf chrcls result ch |
self atEnd ifTrue: [^nil].
cr := (chrcls:= Character) cr.
lf := chrcls  lf.
result := self collectionSpecies new.
[ ch := self next .
  (ch == cr or:[ ch == lf ]) ifTrue:[ 
    ch == cr ifTrue:[ self peekFor: lf ].
    ^ result 
  ].
  result add: ch .
  self atEnd 
] whileFalse .
^ result
%

category: 'accessing-bytes'
method: ZnBufferedReadStream
nextLittleEndianNumber: numberOfBytes
	^ self nextIntegerOfSize: numberOfBytes signed: false bigEndian: false
%

category: 'accessing-bytes'
method: ZnBufferedReadStream
nextNumber: numberOfBytes
	^ self nextIntegerOfSize: numberOfBytes signed: false bigEndian: true
%

category: 'accessing-bytes'
method: ZnBufferedReadStream
nextWord
	^ self nextIntegerOfSize: 2 signed: false bigEndian: true
%

category: 'initialize-release'
method: ZnBufferedReadStream
on: readStream
	stream := readStream.
	self sizeBuffer: self defaultBufferSize
%

category: 'accessing'
method: ZnBufferedReadStream
peek
	"Return the next element but do not move over it"
	
	position > limit
		ifTrue: [ self nextBuffer ].
	^ position <= limit
		ifTrue: [ buffer at: position ]
		ifFalse: [ nil ]
%

category: 'accessing'
method: ZnBufferedReadStream
peek: count
  self peek .
  ^ buffer copyFrom: position to: (position + count min: limit)
%

category: 'accessing'
method: ZnBufferedReadStream
peekFor: object
	"Answer false and do not move over the next element if it is not equal to object, or if the receiver is at the end. 
	Answer true and move over the next element when it is equal to object."

	^ self peek = object
		ifTrue: [ 
			self next.
			true ]
		ifFalse: [ false ]
%

category: 'accessing'
method: ZnBufferedReadStream
position
	
	"If the buffer advanced, we need to check the original stream position, minus what we have read.
	The -1 is because the buffer is base 1"
	^ stream position - limit + position - 1
%

category: 'accessing'
method: ZnBufferedReadStream
position: anInteger 
	
	| bufferEnd bufferStart |
	bufferEnd := stream position.
	bufferStart := bufferEnd - limit.
	(anInteger between: bufferStart and: bufferEnd)
		ifTrue: [ position := anInteger - bufferStart + 1 ]
		ifFalse: [ 
			"We reset the buffer and update the position in the underlying stream"
			limit := 0.
			position := 1.
			stream position: anInteger ]
%

category: 'private'
method: ZnBufferedReadStream
readFromBufferInto: collection startingAt: offset count: requestedCount
	"Read up to requestedCount elements into collection starting at offset,
	from my buffer, answering the number of elements read.
	There could be fewer elements buffered."

	| read |
	read := 0.
	position <= limit
		ifTrue: [ read := limit - position + 1 min: requestedCount.
			collection
				replaceFrom: offset
				to: offset + read - 1
				with: buffer
				startingAt: position.
			position := position + read ].
	^ read
%

category: 'accessing'
method: ZnBufferedReadStream
readInto: collection startingAt: offset count: requestedCount
	"Read requestedCount elements into collection starting at offset,
	answering the number of elements read, there could be fewer elements available."

	| countRead countYetToRead |
	"First, read from elements already in my buffer."
	countRead := self readFromBufferInto: collection startingAt: offset count: requestedCount.
	countYetToRead := requestedCount - countRead.
	countYetToRead > 0
		ifTrue: [ "See if there are more elements to be read from the underlying stream"
			| newOffset |
			newOffset := offset + countRead.
			(self shouldBufferReadOfCount: countYetToRead)
				ifTrue: [ self nextBuffer.
					position > limit ifTrue: [ ^ countRead ].
					limit > 0
						ifTrue:
							[ countRead := countRead + (self readInto: collection startingAt: newOffset count: countYetToRead) ] ]
				ifFalse:
					[ countRead := countRead + (stream readInto: collection startingAt: newOffset count: countYetToRead) ] ].
	^ countRead
%

category: 'accessing'
method: ZnBufferedReadStream
setToEnd
	
	stream setToEnd
%

category: 'private'
method: ZnBufferedReadStream
shouldBufferReadOfCount: elementCount
	"For larger read requests, buffering fails to give an advantage."

	^ elementCount < (buffer size / 2)
%

category: 'accessing'
method: ZnBufferedReadStream
size

	^ stream size
%

category: 'initialize-release'
method: ZnBufferedReadStream
sizeBuffer: size
	buffer := self collectionSpecies new: size
%

category: 'accessing'
method: ZnBufferedReadStream
skip: count
	"Skip over count elements.
	This could be further optimzed."
	
	count timesRepeat: [ self next ]
%

category: 'accessing-bytes'
method: ZnBufferedReadStream
uint16
	^ self nextIntegerOfSize: 2 signed: false bigEndian: true 
%

category: 'accessing-bytes'
method: ZnBufferedReadStream
uint32
	^ self nextIntegerOfSize: 4 signed: false bigEndian: true 
%

category: 'accessing-bytes'
method: ZnBufferedReadStream
uint8
	^ self nextIntegerOfSize: 1 signed: false bigEndian: true
%

category: 'accessing'
method: ZnBufferedReadStream
upTo: value 
	"Read upto but not including value and return them as a collection.
	If value is not found, return the entire contents of the stream."
	
	^ self collectionSpecies 
		streamContents: [ :writeStream | | ch |
			[ self atEnd or: [ (ch := self next) = value ] ] whileFalse: [ 
				writeStream nextPut: ch ] ]
%

category: 'accessing'
method: ZnBufferedReadStream
upToAll: aCollection
	"Answer a subcollection from the current access position to the occurrence (if any, but not inclusive) of aCollection. If aCollection is not in the stream, answer the entire rest of the stream."
	
	^self collectionSpecies
		streamContents:
			[ :out |
			| partialMatch pattern matched |
			partialMatch := self collectionSpecies new.
			pattern := aCollection readStream.
			matched := false.
			([ matched or: [ self atEnd or: [ pattern atEnd ] ] ]) whileFalse: [
				| ch |
				(ch := self next) = pattern next
					ifTrue:
						[pattern atEnd
							ifTrue: [ matched := true ]
							ifFalse: [partialMatch add: ch]]
					ifFalse: [
						pattern reset.
						out nextPutAll: partialMatch.
						partialMatch := self collectionSpecies new.
						out nextPut: ch ] ].
			matched ifFalse: [ out nextPutAll: partialMatch ] ]
%

category: 'accessing'
method: ZnBufferedReadStream
upToEnd
	"Read elements until the stream is atEnd and return them as a collection."

	^ self collectionSpecies
		streamContents: [ :out | 
			[ self atEnd ] whileFalse: [ 
				position > limit
					ifTrue: [ self nextBuffer ].	
				out next: limit - position + 1 putAll: buffer startingAt: position.
				position := limit + 1 ] ]
%

category: 'accessing'
method: ZnBufferedReadStream
wrappedStream
	^ stream
%

category: 'accessing'
method: ZnBufferedReadStream
wrappedStreamName
	^ stream wrappedStreamName
%

! Class implementation for 'ZnBufferedReadWriteStream'

!		Class methods for 'ZnBufferedReadWriteStream'

category: 'instance creation'
classmethod: ZnBufferedReadWriteStream
on: writeStream
	^ self basicNew
		on: writeStream;
		yourself
%

category: 'convenience'
classmethod: ZnBufferedReadWriteStream
on: readStream do: block
	"Execute block with as argument a ZnBufferedReadStream on readStream.
	Return the value of block."

	^ block value: (self on: readStream)
%

!		Instance methods for 'ZnBufferedReadWriteStream'

category: 'testing'
method: ZnBufferedReadWriteStream
atEnd
	
	^ self readingActionDo: [ readStream atEnd ]
%

category: 'accessing'
method: ZnBufferedReadWriteStream
close
	
	writeStream flush.
	writeStream close.
%

category: 'testing'
method: ZnBufferedReadWriteStream
closed
	^ readStream closed
%

category: 'accessing'
method: ZnBufferedReadWriteStream
flush
	
	self writingActionDo: [ writeStream flush ]
%

category: 'testing'
method: ZnBufferedReadWriteStream
isBinary
	
	^ readStream isBinary
%

category: 'testing'
method: ZnBufferedReadWriteStream
isReadOnly
	
	^ false
%

category: 'testing'
method: ZnBufferedReadWriteStream
isStream

	^ true
%

category: 'accessing'
method: ZnBufferedReadWriteStream
next
	
	^ self readingActionDo: [ 
		readStream next ]
%

category: 'accessing'
method: ZnBufferedReadWriteStream
next: anInteger 
	
	^ self readingActionDo: [ 
		readStream next: anInteger ]
%

category: 'accessing'
method: ZnBufferedReadWriteStream
next: count putAll: collection

	self writingActionDo: [ 
		writeStream next: count putAll: collection ]
%

category: 'accessing'
method: ZnBufferedReadWriteStream
next: count putAll: collection startingAt: offset
	
	self writingActionDo: [
		writeStream next: count putAll: collection startingAt: offset ]
%

category: 'accessing'
method: ZnBufferedReadWriteStream
nextPut: aCharacter 
	
	self writingActionDo: [ writeStream nextPut: aCharacter ]
%

category: 'accessing'
method: ZnBufferedReadWriteStream
nextPutAll: aString 
	
	^ self writingActionDo: [ writeStream nextPutAll: aString ]
%

category: 'instance creation'
method: ZnBufferedReadWriteStream
on: aStream

	lastRead := true.
	readStream := ZnBufferedReadStream on: aStream.
	writeStream := ZnBufferedWriteStream on: aStream.
%

category: 'accessing'
method: ZnBufferedReadWriteStream
peek
	
	^ self readingActionDo: [ 
		readStream peek ]
%

category: 'accessing'
method: ZnBufferedReadWriteStream
position
	
	^ lastRead
		ifTrue: [ readStream position ]
		ifFalse: [ writeStream position ]
%

category: 'accessing'
method: ZnBufferedReadWriteStream
position: anInteger 
	
	self writingActionDo: [ 
		writeStream position: anInteger ]
	
%

category: 'private'
method: ZnBufferedReadWriteStream
readingActionDo: aBlock

	"Reading from the read stream.
	We should 
	 - flush the write stream
	 - discard the read buffer (which may contain incorrect data).
	 - and then perform the read."
	
	lastRead ifFalse: [ 
		writeStream flush.
		readStream discardBuffer ].
	^ aBlock ensure: [ lastRead := true ]
%

category: 'accessing'
method: ZnBufferedReadWriteStream
readInto: collection startingAt: offset count: requestedCount
	
	^ self readingActionDo: [ 
		readStream readInto: collection startingAt: offset count: requestedCount ]
%

category: 'accessing'
method: ZnBufferedReadWriteStream
setToEnd
	
	^ self writingActionDo: [ 
		writeStream setToEnd ]
%

category: 'accessing'
method: ZnBufferedReadWriteStream
size
	^ readStream size
%

category: 'initialize-release'
method: ZnBufferedReadWriteStream
sizeBuffer: anInteger 
	
	readStream sizeBuffer: anInteger.
	writeStream sizeBuffer: anInteger.
%

category: 'accessing'
method: ZnBufferedReadWriteStream
skip: anInteger 
	
	self readingActionDo: [ 
		readStream skip: anInteger ]
%

category: 'accessing'
method: ZnBufferedReadWriteStream
truncate
	
	self writingActionDo: [ writeStream truncate ]
%

category: 'accessing'
method: ZnBufferedReadWriteStream
truncate: anInteger 
	
	self writingActionDo: [ writeStream truncate: anInteger ]
%

category: 'accessing'
method: ZnBufferedReadWriteStream
upTo: aCharacter 
	
	^ self readingActionDo: [ readStream upTo: aCharacter ]
%

category: 'accessing'
method: ZnBufferedReadWriteStream
upToEnd
	
	^ self readingActionDo: [ readStream upToEnd ]
%

category: 'accessing'
method: ZnBufferedReadWriteStream
wrappedStream

	^ readStream wrappedStream
%

category: 'accessing'
method: ZnBufferedReadWriteStream
writingActionDo: aBlock
	
	"Writing to the write stream.
	We should 
	 - write the write stream
	 - discard the read buffer (which may contain incorrect data)"
	lastRead ifTrue: [ 
		writeStream discardBuffer ].
	readStream discardBuffer.
	^ aBlock ensure: [ lastRead := false ]
%

! Class implementation for 'ZnBufferedWriteStream'

!		Class methods for 'ZnBufferedWriteStream'

category: 'instance creation'
classmethod: ZnBufferedWriteStream
on: writeStream
	^ self basicNew
		on: writeStream;
		yourself
%

category: 'convenience'
classmethod: ZnBufferedWriteStream
on: writeStream do: block
	"Execute block with as argument a ZnBufferedWriteStream on writeStream,
	making sure #flush is called at the end. Return the value of block."
	
	| bufferedWriteStream result |
	bufferedWriteStream := self on: writeStream.
	result := block value: bufferedWriteStream.
	bufferedWriteStream flush.
	^ result
%

!		Instance methods for 'ZnBufferedWriteStream'

category: 'private'
method: ZnBufferedWriteStream
buffer
	buffer isNil 
		ifTrue: [ self sizeBuffer: self defaultBufferSize ].
	^ buffer
%

category: 'accessing'
method: ZnBufferedWriteStream
bufferFreeSize
	^ self bufferSize - position
%

category: 'accessing'
method: ZnBufferedWriteStream
bufferSize
	^ buffer isNil 
		ifTrue: [ self defaultBufferSize ]
		ifFalse: [ buffer size ]
%

category: 'initialize-release'
method: ZnBufferedWriteStream
close
	self flush.
	stream close
%

category: 'accessing'
method: ZnBufferedWriteStream
cr
	self nextPut: Character cr
%

category: 'accessing'
method: ZnBufferedWriteStream
crlf
	self cr; lf
%

category: 'accessing'
method: ZnBufferedWriteStream
defaultBufferSize
	^ 2 raisedToInteger: 16
%

category: 'private'
method: ZnBufferedWriteStream
discardBuffer

	position := 0
%

category: 'accessing'
method: ZnBufferedWriteStream
flush
	self flushBuffer.
	stream flush
%

category: 'private'
method: ZnBufferedWriteStream
flushBuffer
	position = 0 ifTrue: [ ^ self ].
	position = self bufferSize
		ifTrue: [ stream nextPutAll: buffer ]
		ifFalse: [ stream nextPutAll: (buffer copyFrom: 1 to: position) ].
	position := 0
%

category: 'private'
method: ZnBufferedWriteStream
flushBufferIfFull
	position = self bufferSize 
		ifTrue: [ self flushBuffer ]
%

category: 'accessing-bytes'
method: ZnBufferedWriteStream
int16: integer
	^ self nextIntegerOfSize: 2 signed: true bigEndian: true put: integer
%

category: 'accessing-bytes'
method: ZnBufferedWriteStream
int32: integer
	^ self nextIntegerOfSize: 4 signed: true bigEndian: true put: integer
%

category: 'accessing-bytes'
method: ZnBufferedWriteStream
int8: integer
	^ self nextIntegerOfSize: 1 signed: true bigEndian: true put: integer
%

category: 'testing'
method: ZnBufferedWriteStream
isBinary

	^ stream isBinary
%

category: 'testing'
method: ZnBufferedWriteStream
isEmpty
	"Return true if no data is present."

	^self position = 0
%

category: 'testing'
method: ZnBufferedWriteStream
isStream

	^ true
%

category: 'accessing'
method: ZnBufferedWriteStream
lf
	self nextPut: Character lf
%

category: 'accessing'
method: ZnBufferedWriteStream
next: count putAll: collection
	"Write count elements from collection"
	
	self 
		next: count 
		putAll: collection 
		startingAt: 1
%

category: 'accessing'
method: ZnBufferedWriteStream
next: count putAll: collection startingAt: offset
	"Write count elements from collection starting at offset."
	
	self flushBufferIfFull.
	count <= self bufferFreeSize
		ifTrue: [
			self buffer replaceFrom: position + 1 to: position + count with: collection startingAt: offset.
			position := position + count ]
		ifFalse: [
			self flushBuffer.
			count > (self bufferSize / 2)
				ifTrue: [ stream next: count putAll: collection startingAt: offset ]
				ifFalse: [ self next: count putAll: collection startingAt: offset ] ]
%

category: 'accessing-bytes'
method: ZnBufferedWriteStream
nextInt32Put: integer
	^ self nextIntegerOfSize: 4 signed: true bigEndian: true put: integer
%

category: 'accessing-bytes'
method: ZnBufferedWriteStream
nextIntegerOfSize: numberOfBytes signed: signed bigEndian: bigEndian put: value
	"Assuming the receiver is a stream of bytes, write value as the next integer of size numberOfBytes.
	If bigEndian is true, use network byte order, most significant byte first, 
	else use little endian order, least significant byte first.
	If signed is true, encode as a two-complement signed value, 
	else encode as a plain unsigned value."
	
	| unsignedValue |
	unsignedValue := (signed and: [ value negative ])
		ifTrue: [ (1 << (numberOfBytes * 8)) + value ] 
		ifFalse: [ value ].
	(unsignedValue between: 0 and: (2 raisedTo: (numberOfBytes * 8)) - 1)
		ifFalse: [ self error: 'Domain Error ', unsignedValue printString, ' outside of expected range' ].
	bigEndian
		ifTrue: [ 
			numberOfBytes to: 1 by: -1 do: [ :index |
				self nextPut: (unsignedValue digitAt: index) ] ]
		ifFalse: [ 
			1 to: numberOfBytes do: [ :index |
				self nextPut: (unsignedValue digitAt: index) ] ].
	^ value
%

category: 'accessing-bytes'
method: ZnBufferedWriteStream
nextLittleEndianNumber: numberOfBytes put: integer
	^ self nextIntegerOfSize: numberOfBytes signed: false bigEndian: false put: integer
%

category: 'accessing-bytes'
method: ZnBufferedWriteStream
nextNumber: numberOfBytes put: integer
	^ self nextIntegerOfSize: numberOfBytes signed: false bigEndian: true put: integer
%

category: 'accessing'
method: ZnBufferedWriteStream
nextPut: object
	self flushBufferIfFull.
	position := position + 1.
	self buffer at: position put: object
%

category: 'accessing'
method: ZnBufferedWriteStream
nextPutAll: collection
	"Write a collection"
	
	self 
		next: collection size 
		putAll: collection 
		startingAt: 1
%

category: 'accessing-bytes'
method: ZnBufferedWriteStream
nextWordPut: integer
	^ self nextIntegerOfSize: 2 signed: false bigEndian: true put: integer
%

category: 'initialize-release'
method: ZnBufferedWriteStream
on: writeStream
	stream := writeStream.
	position := 0
%

category: 'accessing'
method: ZnBufferedWriteStream
position

	^ stream position + position
%

category: 'accessing'
method: ZnBufferedWriteStream
position: anInteger 
	self flush.
	stream position: anInteger
%

category: 'accessing'
method: ZnBufferedWriteStream
print: object
	object printOn: self
%

category: 'printing'
method: ZnBufferedWriteStream
printOn: aStream
	aStream 
		nextPutAll: 'a '; 
		nextPutAll: self class name
%

category: 'accessing'
method: ZnBufferedWriteStream
setToEnd
	
	self flush.
	stream setToEnd
%

category: 'accessing'
method: ZnBufferedWriteStream
sizeBuffer: size
	buffer := (stream isBinary ifTrue: [ ByteArray ] ifFalse: [ String ]) new: size
%

category: 'accessing'
method: ZnBufferedWriteStream
space
	self nextPut: Character space
%

category: 'accessing'
method: ZnBufferedWriteStream
tab
	self nextPut: Character tab
%

category: 'accessing'
method: ZnBufferedWriteStream
truncate
	
	stream truncate
%

category: 'accessing'
method: ZnBufferedWriteStream
truncate: anInteger 
	
	self flush.
	stream truncate: anInteger
%

category: 'accessing-bytes'
method: ZnBufferedWriteStream
uint16: integer
	^ self nextIntegerOfSize: 2 signed: false bigEndian: true put: integer
%

category: 'accessing-bytes'
method: ZnBufferedWriteStream
uint32: integer
	^ self nextIntegerOfSize: 4 signed: false bigEndian: true put: integer
%

category: 'accessing-bytes'
method: ZnBufferedWriteStream
uint8: integer
	^ self nextIntegerOfSize: 1 signed: false bigEndian: true put: integer
%

! Class implementation for 'ZnEncodedStream'

!		Class methods for 'ZnEncodedStream'

category: 'accessing'
classmethod: ZnEncodedStream
defaultEncoder
	^ ZnUTF8Encoder default
%

category: 'instance creation'
classmethod: ZnEncodedStream
on: wrappedStream
	^ self new
		on: wrappedStream;
		yourself
%

category: 'instance creation'
classmethod: ZnEncodedStream
on: wrappedStream
encoder: anEncoder

	^self new
		on: wrappedStream;
		encoder: anEncoder;
		yourself
%

category: 'instance creation'
classmethod: ZnEncodedStream
on: wrappedStream encoding: encoding
	^ self new
		on: wrappedStream;
		encoding: encoding;
		yourself
%

!		Instance methods for 'ZnEncodedStream'

category: 'initialize-release'
method: ZnEncodedStream
close
	stream close
%

category: 'testing'
method: ZnEncodedStream
closed
	^ stream closed
%

category: 'accessing'
method: ZnEncodedStream
encoder
	^ encoder ifNil: [ encoder := self class defaultEncoder ]
%

category: 'initialize-release'
method: ZnEncodedStream
encoder: characterEncoder
	encoder := characterEncoder
%

category: 'initialize-release'
method: ZnEncodedStream
encoding: encoding
	encoder := encoding asZnCharacterEncoder
%

category: 'testing'
method: ZnEncodedStream
isEmpty
	"Return true if no data is present."

	^stream isEmpty
%

category: 'testing'
method: ZnEncodedStream
isStream
  ^ true
%

category: 'initialize-release'
method: ZnEncodedStream
on: wrappedStream
	stream := wrappedStream
%

category: 'accessing'
method: ZnEncodedStream
position
	^ stream position
%

category: 'accessing'
method: ZnEncodedStream
position: aPosition
	stream position: aPosition
%

category: 'accessing'
method: ZnEncodedStream
setToEnd
	stream setToEnd
%

category: 'accessing'
method: ZnEncodedStream
size
	^ stream size
%

category: 'accessing'
method: ZnEncodedStream
truncate
	stream truncate
%

category: 'accessing'
method: ZnEncodedStream
truncate: anInteger 
	stream truncate: anInteger
%

category: 'accessing'
method: ZnEncodedStream
wrappedStream
	^ stream
%

category: 'accessing'
method: ZnEncodedStream
wrappedStreamName
	^ stream wrappedStreamName
%

! Class implementation for 'ZnEncodedReadStream'

!		Instance methods for 'ZnEncodedReadStream'

category: 'testing'
method: ZnEncodedReadStream
atEnd
	^ peeked isNil and: [ stream atEnd ]
%

category: 'accessing'
method: ZnEncodedReadStream
contents
	
	^ self collectionSpecies
		streamContents: [ :collectionStream | 
			collectionStream nextPutAll: (self encoder decodeBytes: stream  contents) ]
%

category: 'testing'
method: ZnEncodedReadStream
isBinary
	^ false
%

category: 'testing'
method: ZnEncodedReadStream
isReadOnly

	^ true
%

category: 'accessing'
method: ZnEncodedReadStream
next
	^ peeked
		ifNil: [ 
			stream atEnd ifFalse: [ self nextElement ] ]
		ifNotNil: [ | character |
			character := peeked.
			peeked := nil.
			character ]
%

category: 'accessing'
method: ZnEncodedReadStream
next: requestedCount 
	"Read requestedCount elements into new collection and return it,
	 it could be that less elements were available"

	^ self 
		next: requestedCount 
		into: (self collectionSpecies new: requestedCount)
%

category: 'accessing'
method: ZnEncodedReadStream
next: requestedCount into: collection
	"Read requestedCount elements into collection,
	returning a copy if less elements are available"
	
	^ self
		next: requestedCount
		into: collection
		startingAt: 1
%

category: 'accessing'
method: ZnEncodedReadStream
next: requestedCount into: collection startingAt: offset
	"Read requestedCount elements into collection starting at offset,
	returning a copy if less elements are available"
	
	| readCount |
	readCount := self 
		readInto: collection 
		startingAt: offset 
		count: requestedCount.
	^ requestedCount = readCount
		ifTrue: [ collection ]
		ifFalse: [ collection copyFrom: 1 to: offset + readCount - 1 ]
%

category: 'private'
method: ZnEncodedReadStream
nextElement
	self subclassResponsibility 
%

category: 'accessing'
method: ZnEncodedReadStream
nextInto: collection
	"Read the next elements of the receiver into collection,
	returning a copy if less elements are available"
	
	^ self
		next: collection size
		into: collection
%

category: 'accessing'
method: ZnEncodedReadStream
peek
	^ peeked
		ifNil: [
			stream atEnd ifFalse: [ peeked := self nextElement ] ]
%

category: 'accessing'
method: ZnEncodedReadStream
peekFor: object
	^ self peek = object
		ifTrue: [ 
			self next.
			true ]
		ifFalse: [ false ]
%

category: 'accessing'
method: ZnEncodedReadStream
position

	^ super position - (peeked ifNil: [ 0 ] ifNotNil: [ 1 ])
%

category: 'accessing'
method: ZnEncodedReadStream
position: anInteger
	super position: anInteger.
	peeked := nil
%

category: 'accessing'
method: ZnEncodedReadStream
readInto: collection startingAt: offset count: requestedCount
	"Read requestedCount elements into collection starting at offset,
	returning the number of elements read, there could be less elements available.
	This is an inefficient abstract implementation, reading one by one."
	
	0 to: requestedCount - 1 do: [ :count | | object |
		(object := self next) ifNil: [ ^ count ].  
		collection at: offset + count put: object ].
	^ requestedCount
%

category: 'accessing'
method: ZnEncodedReadStream
skip: count
	count timesRepeat: [ self next ]
%

category: 'accessing'
method: ZnEncodedReadStream
upTo: anObject 	
	^ self collectionSpecies 
		streamContents: [ :out | | element |
			[ self atEnd or: [ (element := self next) = anObject ] ] whileFalse: [ 
				out nextPut: element ] ]
%

category: 'accessing'
method: ZnEncodedReadStream
upToEnd
	^ self collectionSpecies
		streamContents: [ :collectionStream | 
			[ self atEnd ] whileFalse: [ collectionStream nextPut: self next ] ]
%

! Class implementation for 'ZnCharacterReadStream'

!		Class methods for 'ZnCharacterReadStream'

category: 'instance creation'
classmethod: ZnCharacterReadStream
on: wrappedStream encoding: encoding stringClass: stringClass
	^ self new
		on: wrappedStream;
		encoding: encoding;
		stringClass: stringClass;
		yourself
%

!		Instance methods for 'ZnCharacterReadStream'

category: 'accessing'
method: ZnCharacterReadStream
collectionSpecies
	^ self stringClass
%

category: 'accessing'
method: ZnCharacterReadStream
encoder
	^ encoder ifNil: [ encoder := super encoder stringClass: self stringClass ]
%

category: 'accessing'
method: ZnCharacterReadStream
match: subCollection 
	"Set the access position of the receiver to be past the next occurrence of the subCollection. Answer whether subCollection is found.  No wildcards, and case does matter."
	| pattern startMatch |
	pattern := subCollection readStream.
	startMatch := nil.
	[ pattern atEnd ] whileFalse: 
		[ self atEnd ifTrue: [ ^ false ].
		self next = pattern next 
			ifTrue: [ pattern position = 1 ifTrue: [ startMatch := self position ] ]
			ifFalse: 
				[ pattern position: 0.
				startMatch ifNotNil: 
					[ self position: startMatch.
					startMatch := nil ] ] ].
	^ true
%

category: 'private'
method: ZnCharacterReadStream
nextElement
	^ self encoder nextFromStream: stream
%

category: 'accessing'
method: ZnCharacterReadStream
nextLine
	"Answer next line (may be empty) without line end delimiters, or nil if at end.
		Leave the stream positioned after the line delimiter(s).
		Handle a zoo of line delimiters CR, LF, or CR-LF pair"

	| cr lf chrcls result ch |
	self atEnd
		ifTrue: [ ^ nil ].
	cr := (chrcls := Character) cr.
	lf := chrcls lf.
	result := self collectionSpecies new.
	[ 
	ch := self next.
	(ch == cr or: [ ch == lf ])
		ifTrue: [ 
			ch == cr
				ifTrue: [ self peekFor: lf ].
			^ result ].
	result add: ch.
	self atEnd ] whileFalse.
	^ result
%

category: 'accessing'
method: ZnCharacterReadStream
readInto: collection startingAt: offset count: requestedCount 
	"Read count elements and place them in collection starting at offset.
	Return the number of elements actually read."
	
	^ peeked 
		ifNil: [ | readCount |
			readCount := self encoder 
					readInto: collection 
					startingAt: offset 
					count: requestedCount 
					fromStream: stream.
			readCount ]
		ifNotNil: [ 
			collection at: offset put: peeked.
			peeked := nil.
			(self 
				readInto: collection 
				startingAt: offset + 1
				count: requestedCount - 1) + 1 ]
%

category: 'accessing'
method: ZnCharacterReadStream
stringClass
	^ stringClass ifNil: [ stringClass := String ]
%

category: 'accessing'
method: ZnCharacterReadStream
stringClass: object
	stringClass := object
%

category: 'accessing'
method: ZnCharacterReadStream
upToAll: aCollection
	"Answer a subcollection from the current access position to the occurrence (if any, but not inclusive) of aCollection. If aCollection is not in the stream, answer the entire rest of the stream."
	
	^ self collectionSpecies streamContents: [ :out |
		| partialMatch pattern matched |
		partialMatch := (self collectionSpecies new: aCollection size) writeStreamPortable.
		pattern := aCollection readStreamPortable.
		matched := false.
		([ matched or: [ self atEnd or: [ pattern atEnd ] ] ]) whileFalse: [
			| ch |
			(ch := self next) = pattern next
				ifTrue: [
					pattern atEnd
						ifTrue: [ matched := true ]
						ifFalse: [ partialMatch nextPut: ch ] ]
				ifFalse: [
					pattern reset.
					out nextPutAll: partialMatch contents.
					partialMatch reset.
					out nextPut: ch ] ].
		matched ifFalse: [ out nextPutAll: partialMatch contents ] ]
%

! Class implementation for 'ZnEncodedWriteStream'

!		Instance methods for 'ZnEncodedWriteStream'

category: 'writing'
method: ZnEncodedWriteStream
<< collection
	^ self nextPutAll: collection
%

category: 'closing'
method: ZnEncodedWriteStream
close

	self flush.
	^super close
%

category: 'writing'
method: ZnEncodedWriteStream
flush
	stream flush
%

category: 'testing'
method: ZnEncodedWriteStream
isBinary
	^ false
%

category: 'writing'
method: ZnEncodedWriteStream
next: count putAll: collection	
	self 
		next: count 
		putAll: collection 
		startingAt: 1
%

category: 'writing'
method: ZnEncodedWriteStream
next: count putAll: collection startingAt: offset
	"Write count items from collection starting at offset.
	This is an inefficient abstract implementation writing one by one."
	
	0 to: count - 1 do: [ :each | 
		self nextPut: (collection at: offset + each) ]
%

category: 'writing'
method: ZnEncodedWriteStream
nextPut: anObject
	self subclassResponsibility
%

category: 'writing'
method: ZnEncodedWriteStream
nextPutAll: collection

	stream nextPutAll: (self encoder encodeString: collection)
%

category: 'writing'
method: ZnEncodedWriteStream
nextPutAllBytes: aCharacterCollection

	"See Stream>>#nextPutAllBytes: comment.
	Alias for #nextPutAll:"

	^self nextPutAll: aCharacterCollection
%

! Class implementation for 'ZnCharacterWriteStream'

!		Instance methods for 'ZnCharacterWriteStream'

category: 'accessing'
method: ZnCharacterWriteStream
cr
	self nextPut: Character cr
%

category: 'accessing'
method: ZnCharacterWriteStream
crlf
	self cr; lf
%

category: 'accessing'
method: ZnCharacterWriteStream
lf
	self nextPut: Character lf
%

category: 'accessing'
method: ZnCharacterWriteStream
next: count putAll: collection startingAt: offset
	"Write count characters from collection starting at offset."
	
	self encoder 
		next: count 
		putAll: collection 
		startingAt: offset 
		toStream: stream 
%

category: 'accessing'
method: ZnCharacterWriteStream
nextPut: object
	self encoder 
		nextPut: object 
		toStream: stream.
	^ object
%

category: 'accessing'
method: ZnCharacterWriteStream
print: object
	object printOn: self
%

category: 'accessing'
method: ZnCharacterWriteStream
space
	self nextPut: Character space
%

category: 'accessing'
method: ZnCharacterWriteStream
tab
	self nextPut: Character tab
%

! Class extensions for 'ByteArray'

!		Class methods for 'ByteArray'

category: '*filesystem-gemstone-kernel'
classmethod: ByteArray
readHexFrom: aString
	"Create a byte array from a hexadecimal representation"

	^(self new: aString size // 2) readHexFrom: aString readStream
%

!		Instance methods for 'ByteArray'

category: '*filesystem-gemstone-kernel'
method: ByteArray
decodeWith: encoding
	"Produce a String that decodes the receiver, using a specified encoding.
	Encoding is either a ZnCharacterEncoder instance or an identifier for one."
	
	"#[76 101 115 32 195 169 108 195 168 118 101 115 32 102 114 97 110 195 167 97 105 115] decodeWith: #utf8"
	
	^ encoding asZnCharacterEncoder decodeBytes: self
%

category: '*filesystem-gemstone-kernel'
method: ByteArray
utf8Decoded
	"Produce a String decoding the receiver using UTF-8,
	the recommended encoding for Strings, unless you know what you are doing."

	"#[76 101 115 32 195 169 108 195 168 118 101 115 32 102 114 97 110 195 167 97 105 115] utf8Decoded"
	
	^ self decodeFromUTF8
%

! Class extensions for 'Character'

!		Class methods for 'Character'

category: '*filesystem-gemstone-kernel'
classmethod: Character
digitValue: x
	"Answer the Character whose digit value is x. For example,
	 answer $9 for x=9, $0 for x=0, $A for x=10, $Z for x=35."

	| n |
	n := x asInteger.
	^self withValue: (n < 10 ifTrue: [n + 48] ifFalse: [n + 55])
%

! Class extensions for 'CharacterCollection'

!		Instance methods for 'CharacterCollection'

category: '*filesystem-gemstone-kernel'
method: CharacterCollection
asFileReference

	^ FileSystem disk referenceTo: self
%

category: '*filesystem-gemstone-kernel'
method: CharacterCollection
asPath
	"convert myself to a path"
	"Examples:
		'.' asPath
		'~/Desktop' asPath
		'/home/foo' asPath
		'../../foo.bar' asPath"

	^ FileSystem disk resolve: self
%

category: '*filesystem-gemstone-kernel'
method: CharacterCollection
asPathWith: anObject 
	^ anObject pathFromString: self
%

category: '*filesystem-gemstone-kernel'
method: CharacterCollection
asResolvedBy: aFileSystem

	^aFileSystem resolveString: self
%

category: '*filesystem-gemstone-kernel'
method: CharacterCollection
asZnCharacterEncoder
	"Return a ZnCharacterEncoder instance using the receiver as identifier"

	" 'UTF-8' asZnCharacterEncoder "

	(self select: [ :each | each isAlphaNumeric ]) asLowercase = 'utf8'
		ifTrue: [ ^ ZnUTF8Encoder new ]
		ifFalse: [ 
			(self select: [ :each | each isAlphaNumeric ]) asLowercase = '8bit'
				ifFalse: [ self error: 'only 8bit or  utf8 encoding supported' ] ].
	^ Zn8BITEncoder new
%

category: '*filesystem-gemstone-kernel'
method: CharacterCollection
encodeWith: encoding
	"Produce a ByteArray that encodes the receiver, using a specified encoding.
	Encoding is either a ZnCharacterEncoder instance or an identifier for one."
	
	" 'Les ÃÂ©lÃÂ¨ves franÃÂ§ais' encodeWith: #utf8 "
	
	^ encoding asZnCharacterEncoder encodeString: self
%

! Class extensions for 'Collection'

!		Instance methods for 'Collection'

category: '*filesystem-gemstone-kernel'
method: Collection
difference: aCollection
  "Answer the set theoretic difference of two collections."

  ^ self reject: [ :each | aCollection includes: each ]
%

category: '*filesystem-gemstone-kernel'
method: Collection
ifEmpty: aBlock
  self size == 0
    ifTrue: [ ^ aBlock value ]
%

category: '*filesystem-gemstone-kernel'
method: Collection
isEmptyOrNil
  "Answer whether the receiver contains any elements, or is nil.  Useful in numerous situations where one wishes the same reaction to an empty collection or to nil"

  ^ self size == 0
%

! Class extensions for 'FileSystem'

!		Class methods for 'FileSystem'

category: '*filesystem-disk'
classmethod: FileSystem
* aFileOrDirectoryName

	^self disk * aFileOrDirectoryName
%

category: '*filesystem-disk'
classmethod: FileSystem
/ aFileOrDirectoryName

	^self disk / aFileOrDirectoryName
%

category: '*FileSystem-Memory'
classmethod: FileSystem
currentMemoryFileSystem

	^MemoryStore currentFileSystem
%

category: '*filesystem-disk'
classmethod: FileSystem
disk
	"Answer a filesystem that represents the 'on-disk' filesystem used by the host operating system.
	Note, we do not ensure there is a singleton within the repository.
	We only ensure there is a single new instance per session. If associated FileReference instances
	are committed, multiple instances of FsDiskFileSystem may exist. They are equivalent so this
	is not problematic."

	^SessionTemps current
		at: self diskCacheKey
		ifAbsentPut: [FsDiskFileSystem new]
%

category: '*filesystem-disk'
classmethod: FileSystem
diskCacheKey
	"This key is used to cache the current FsDiskFileSystem instance."

	^#'GsCurrentDiskFileSystem'
%

category: '*FileSystem-Memory'
classmethod: FileSystem
memory

	^FsMemoryFileSystem store: MemoryStore new
%

category: '*filesystem-disk'
classmethod: FileSystem
resetCurrent

	SessionTemps current
		removeKey: self diskCacheKey
		ifAbsent: []
%

category: '*filesystem-disk'
classmethod: FileSystem
root

	^self disk root
%

category: '*filesystem-disk'
classmethod: FileSystem
workingDirectory

	^self disk workingDirectory
%

!		Instance methods for 'FileSystem'

category: '*FileSystem-Disk'
method: FileSystem
isDiskFileSystem

	^false
%

category: '*FileSystem-Memory'
method: FileSystem
isMemoryFileSystem

	^false
%

! Class extensions for 'FileSystemStore'

!		Instance methods for 'FileSystemStore'

category: '*FileSystem-Disk'
method: FileSystemStore
isDiskFileSystem
	^ false
%

category: '*FileSystem-Memory'
method: FileSystemStore
isMemoryFileSystem
	^ false
%

! Class extensions for 'Integer'

!		Instance methods for 'Integer'

category: '*filesystem-gemstone-kernel'
method: Integer
<< shiftAmount
	"left shift"
	
	shiftAmount < 0 ifTrue: [self error: 'negative arg'].
	^ self bitShift: shiftAmount
%

category: '*filesystem-gemstone-kernel'
method: Integer
>> shiftAmount
	"right shift"

	shiftAmount < 0 ifTrue: [self error: 'negative arg'].
	^ self bitShift: 0 - shiftAmount
%

category: '*filesystem-gemstone-kernel'
method: Integer
digitAt: n
	"Answer the value of an apparent byte-indexable field in the receiver,
	 analogous to the large integers, which are organized as bytes."

	n = 1
		ifTrue: [ 
			"Negate carefully in case the receiver is SmallInteger minVal"
			^ self < 0
				ifTrue: [ -256 - self bitAnd: 255 ]
				ifFalse: [ self bitAnd: 255 ] ].
	^ self < 0
		ifTrue: [ (-256 - self bitShift: -8) + 1 digitAt: n - 1 ]
		ifFalse: [ (self bitShift: 8 - (n bitShift: 3)) bitAnd: 255 ]
%

! Class extensions for 'Object'

!		Instance methods for 'Object'

category: '*filesystem-gemstone-kernel'
method: Object
split: aSequenceableCollection
	"Split the argument using the receiver as a separator."
	"optimized version for single delimiters"
	"($/ split: '/foo/bar')>>>#('' 'foo' 'bar') asOrderedCollection"
	"([:c| c isSeparator] split: 'aa bb cc dd')>>> #('aa' 'bb' 'cc' 'dd') asOrderedCollection"
		
	| result |
	result := OrderedCollection new: (aSequenceableCollection size / 2) asInteger.
	self split: aSequenceableCollection do: [ :item |
		result add: item ].
	^ result
%

category: '*filesystem-gemstone-kernel'
method: Object
split: aSequenceableCollection do: aBlock
	"optimized version for single delimiters:
	Example:
		$/ split: '/foo/bar' indicesDo: [ :item | ]"
	self split: aSequenceableCollection indicesDo: [ :start :end | 
		aBlock value: (aSequenceableCollection copyFrom: start to: end) ]
%

category: '*filesystem-gemstone-kernel'
method: Object
split: aSequenceableCollection indicesDo: aBlock
	"Perform an action specified as aBlock (with a start and end argument) to each of the indices of the receiver element that have been identified by splitting the receiver using the splitter argument. optimized version for single delimiters."
	
	"(String streamContents: [:s | Character space split: 'Pharo is cool'  indicesDo: [ :start :end | s << 's:' << start asString << ' ' << 'e:' << end asString << ' ' ]]) >>> 's:1 e:5 s:7 e:8 s:10 e:13 '"
		
		
		
	|  position oldPosition |
	
	position := 1.
	oldPosition := position.
	
	position := aSequenceableCollection indexOf: self startingAt: position.
	[ position > 0 ] whileTrue: [
		aBlock value: oldPosition value: position - 1.
		position := position + 1.
		oldPosition := position.
		position := aSequenceableCollection indexOf: self startingAt: position.
	].

	aBlock value: oldPosition value: aSequenceableCollection size.
%

! Class extensions for 'Path'

!		Instance methods for 'Path'

category: '*FileSystem-Core'
method: Path
asFileLocatorOrReference

	^ FileLocator fromPath: self ifNone: [ self asFileReference ]
%

category: '*FileSystem-Core'
method: Path
asFileReference
	^ FileSystem disk referenceTo: self
%

category: '*FileSystem-Core'
method: Path
relativeToReference: aReference 
	^ self relativeToPath: aReference path
%

! Class extensions for 'PositionableStreamPortable'

!		Instance methods for 'PositionableStreamPortable'

category: '*filesystem-gemstone-kernel'
method: PositionableStreamPortable
isBinary

	^collection class == ByteArray
%

category: '*filesystem-gemstone-kernel'
method: PositionableStreamPortable
nextInto: aCollection
	"Read the next elements of the receiver into aCollection.
	Return aCollection or a partial copy if less than aCollection
	size elements have been read."
	^self next: aCollection size into: aCollection startingAt: 1.
%

! Class extensions for 'ReadByteStreamPortable'

!		Instance methods for 'ReadByteStreamPortable'

category: '*filesystem-gemstone-kernel'
method: ReadByteStreamPortable
readInto: aCollection startingAt: startIndex count: n
  "Read n objects into the given collection. 
	Return number of elements that have been read."

  | max |
  max := collection size - position min: n.
  aCollection
    replaceFrom: startIndex
    to: startIndex + max - 1
    with: collection
    startingAt: position + 1.
  position := position + max.
  ^ max
%

! Class extensions for 'ReadStreamPortable'

!		Instance methods for 'ReadStreamPortable'

category: '*filesystem-gemstone-kernel'
method: ReadStreamPortable
readInto: aCollection startingAt: startIndex count: n
	"Read n objects into the given collection. 
	Return number of elements that have been read."
	
	| max |
	max := (readLimit - position) min: n.
	aCollection 
		replaceFrom: startIndex 
		to: startIndex + max - 1
		with: collection
		startingAt: position + 1.
	position := position + max.
	^ max
%

! Class extensions for 'ReadWriteStreamPortable'

!		Instance methods for 'ReadWriteStreamPortable'

category: '*filesystem-gemstone-kernel'
method: ReadWriteStreamPortable
readInto: aCollection startingAt: startIndex count: n
	"Read n objects into the given collection. 
	Return number of elements that have been read."
	
	| max |
	max := (readLimit - position) min: n.
	aCollection 
		replaceFrom: startIndex 
		to: startIndex + max - 1
		with: collection
		startingAt: position + 1.
	position := position + max.
	^ max
%

! Class extensions for 'SequenceableCollection'

!		Instance methods for 'SequenceableCollection'

category: '*filesystem-gemstone-kernel'
method: SequenceableCollection
allButFirst
  "Answer a copy of the receiver containing all but the first
	element. Raise an error if there are not enough elements."

  ^ self allButFirst: 1
%

category: '*filesystem-gemstone-kernel'
method: SequenceableCollection
allButFirst: n
	"Answer a copy of the receiver containing all but the first n
	elements. Raise an error if there are not enough elements."

	^ self copyFrom: n + 1 to: self size
%

category: '*filesystem-gemstone-kernel'
method: SequenceableCollection
copyAfterLast: anElement
	"Answer a copy of the receiver from after the last occurence
	of anElement up to the end. If no such element exists, answer 
	an empty copy."

	^ self allButFirst: (self lastIndexOf: anElement ifAbsent: [^ self copyEmpty])
%

category: '*filesystem-gemstone-kernel'
method: SequenceableCollection
copyLast: n
	"Answer the last n elements of the receiver.  
	Raise an error if there are not enough elements."

	| size |
	size := self size.
	^ self copyFrom: size - n + 1 to: size
%

category: '*filesystem-gemstone-kernel'
method: SequenceableCollection
copyUpToLast: anElement
  "Answer a copy of the receiver from index 1 to the last occurrence of 
	anElement, not including anElement."

	| n |
	n :=  (self lastIndexOf: anElement ifAbsent: [ ^ self copy ]) - 1.
  ^ self copyFrom: 1 to: n
%

category: '*filesystem-gemstone-kernel'
method: SequenceableCollection
copyWithFirst: newElement 
	"Answer a copy of the receiver that is 1 bigger than the receiver with newElement as the first element."

	| newIC |
	newIC := self species new: self size + 1.
	newIC 
		replaceFrom: 2
		to: self size + 1
		with: self
		startingAt: 1.
	newIC at: 1 put: newElement.
	^ newIC
%

category: '*filesystem-gemstone-kernel'
method: SequenceableCollection
grownBy: length
	"Answer a copy of receiver collection with size grown by length"

	| newCollection size |
	size := self size.
	newCollection := self species new: size + length.
	newCollection replaceFrom: 1 to: size with: self startingAt: 1.
	^ newCollection
%

category: '*filesystem-gemstone-kernel'
method: SequenceableCollection
lastIndexOf: anElement ifAbsent: exceptionBlock
  "Answer the index of the last occurence of anElement within the  
	receiver. If the receiver does not contain anElement, answer the
	result of evaluating the argument, exceptionBlock."

  ^ self lastIndexOf: anElement startingAt: self size ifAbsent: exceptionBlock
%

category: '*filesystem-gemstone-kernel'
method: SequenceableCollection
lastIndexOf: anElement startingAt: lastIndex ifAbsent: exceptionBlock
  "Answer the index of the last occurence of anElement within the  
	receiver. If the receiver does not contain anElement, answer the
	result of evaluating the argument, exceptionBlock."

  lastIndex to: 1 by: -1 do: [ :index | 
    (self at: index) = anElement
      ifTrue: [ ^ index ] ].
  ^ exceptionBlock ~~ nil
    ifTrue: [ exceptionBlock value ]
    ifFalse: [ 0 ]
%

category: '*filesystem-gemstone-kernel'
method: SequenceableCollection
readStreamPortable

	^ReadStreamPortable on: self
%

category: '*filesystem-gemstone-kernel'
method: SequenceableCollection
reversed
	"Answer a copy of the receiver with element order reversed."
	"Example: 'frog' reversed"

	| n result src |
	n := self size.
	result := self species new: n.
	src := n + 1.
	1 to: n do: [:i | result at: i put: (self at: (src := src - 1))].
	^ result
%

! Class extensions for 'Stream'

!		Instance methods for 'Stream'

category: '*filesystem-gemstone-kernel'
method: Stream
isBinary

	^false
%

! Class extensions for 'TestAsserter'

!		Instance methods for 'TestAsserter'

category: '*filesystem-gemstone-kernel'
method: TestAsserter
assertCollection: actual equals: expected
	"Specialized test method that generates a proper error message for collection"

	^self
		assert: expected = actual
		description: [ self comparingCollectionBetween: actual and: expected ]
%

category: '*filesystem-gemstone-kernel'
method: TestAsserter
comparingCollectionBetween: left and: right

	| additionalLeft additionalRight sortBlock|	
	"use a very slow sort block"
	sortBlock := [ :a :b | a asString <= b asString ].
	additionalLeft := (left difference: right) sort: sortBlock.
	additionalRight := (right difference: left) sort: sortBlock. 
	
	^ String streamContents: [:stream |
		stream
			nextPutAll: 'Given Collections do not match. Got '; lf;
			tab; nextPutAll: 'left := '; print: left; nextPut: $.; lf;
			nextPutAll: ' instead of ';
			tab; nextPutAll: ' right :='; print: right; nextPut: $.; lf.
		left size = right size
			ifFalse: [ 
				stream 
					nextPutAll: 'Collection size does not match: left='; 
					print: left size;
					nextPutAll: ' vs. right=';
					print: right size; lf ].
		additionalLeft isEmpty
			ifFalse: [ 
				stream 
					nextPutAll: 'Got ';
					print: additionalLeft size;
					nextPutAll: ' additional element(s) in the left collection: ';
					tab; print: additionalLeft  ].
		additionalRight isEmpty
			ifFalse: [ 
				stream 
					nextPutAll: 'Got ';
					print: additionalRight size;
					nextPutAll: ' additional element(s) in the right collection: ';
					tab; print: additionalRight  ]]
%

! Class extensions for 'UndefinedObject'

!		Instance methods for 'UndefinedObject'

category: '*filesystem-gemstone-kernel'
method: UndefinedObject
isEmptyOrNil
	"Answer whether the receiver contains any elements, or is nil.  Useful in numerous situations where one wishes the same reaction to an empty collection or to nil"

	^true
%

