! Copyright (C) GemTalk Systems 1986-2026.  All Rights Reserved.
! Class extensions for 'CompileError'

!		Instance methods for 'CompileError'

category: 'Formatting'
method: CompileError
errorDetails
  "Final implementation in AbstractException2.gs .
   Return nil or the array of compiler error details"
| arr |
arr := gsArgs ifNotNil:[:gsa | gsa atOrNil: 1 ] .
^ arr ifNil:[ { { 1075 . 1 . 'malformed CompilerError' } } ]. "STDB_MALFORMED_COMPILER_ERROR"
%

! Class extensions for 'DependencyList'

!		Class methods for 'DependencyList'

category: 'Accessing'
classmethod: DependencyList
for: anObject
  "real implementation later in filein, make rebuildTable: methods happy"
  ^ nil
%

! Class extensions for 'GsPackagePolicy'

!		Class methods for 'GsPackagePolicy'

category: 'Accessing'
classmethod: GsPackagePolicy
current
  ^ nil
%

category: 'Accessing'
classmethod: GsPackagePolicy
currentOrNil

 ^ nil
%

category: 'Initialize'
classmethod: GsPackagePolicy
deinitialize

  (GsSession currentSession objectNamed: #UserGlobals) removeKey: self globalName
       ifAbsent: [ nil ].
%

category: 'Accessing'
classmethod: GsPackagePolicy
enabled
  ^ false
%

category: 'Accessing'
classmethod: GsPackagePolicy
globalName

  ^#GsPackagePolicy_Current
%

category: 'Initialize'
classmethod: GsPackagePolicy
initialize
  ^ self deinitialize
%

! Class Initialization Excluded by export visitor
!  GsPackagePolicy initialize.
