! Copyright (C) GemTalk Systems 1986-2026.  All Rights Reserved.
! Class Declarations
! Generated file, do not Edit

doit
(Array
	_newKernelSubclass:'GsCommitList'
	instVarNames: #(localCoordinator voteResults commitResults)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 112641
)
		category: nil;
		comment: 'The class GsCommitList implements GemStone internals. It is not intended for 
customer use, by creating instances or by subclassing.
';
		immediateInvariant.
true.
%

removeallmethods GsCommitList
removeallclassmethods GsCommitList

doit
(Array
	subclass: 'InstVarMappingArray'
	instVarNames: #(oldCl newCl dynamicIvsToNamed namedIvsToDynamic preserveDynamic)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: ' InstVarMappingArray is used in instance migration to control migration of named and dynamic 
 instance variables.  

 It identifies the instance variables by using the integer offset of the name of the instance 
 variable in the old and new classes; 
 the offset in the new class is the index into the InstVarMappingArray, and the offset in the 
 old class is the value at that index.
 A value of 0 means no corresponding value from the old instance will be migrated to the new 
 class; the migrated instance will have nil at that instance variable offset. 

 For example, the mapping of OrigClass (instvars aa bb cc) to NewClass (instcars aa cc dd), using 
   InstVarMappingArray mappingFrom: OldClass to: NewClass.
 would be 1, 3, 0.  

 In most cases for migration you do not need to be concerned about the InstVarMappingArray.  
 By implementing migrateFrom:instVarMap: on your new instance''s class (and invoking super 
 migrateFrom:instVarMap:) you can write code to perform the appropriate migrate changes.  

 This class is used directly for multi-threaded migration using Repository>>mtMigrate:.  

 instance variables
   oldCl              - the old Class
   newCl              - the new Class  
   dynamicIvsToNamed  - behavior not yet implemented
   namedIvsToDynamic  - behavior not yet implemented
   preserveDynamic    aBoolean

 varying instanceVariables 
   offset N: a SmallInteger, offset of instVar in old object that will correspond to instVarAt: N in new object';
		immediateInvariant.
true.
%

removeallmethods InstVarMappingArray
removeallclassmethods InstVarMappingArray

doit
(Array
	_newKernelSubclass:'NscBuilder'
	instVarNames: #(nsc counter finalResult)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'subclassesDisallowed'  #logCreation )
	reservedOop: 107777
)
		category: nil;
		comment: 'NscBuilder should only be used for transient objects.  They are not
completely logged by the transaction logging subsystem!

This class implements GemStone internals. It is not intended for customer use, 
by creating instances or by subclassing.

Constraints:
	nsc: IdentityBag
	counter: SmallInteger
	finalResult: UnorderedCollection';
		immediateInvariant.
true.
%

removeallmethods NscBuilder
removeallclassmethods NscBuilder

doit
(Array
	subclass: 'RcArray'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'An RcArray is an implementation of an array that can automatically resolve
concurrency conflicts for certain operations on the RcArray.  All of the 
public methods implemented in this class support some form of reduced conflict
behavior.  If a conflict with other update operations on the RcArray occurs, 
the Rc operation is replayed.  In most cases these can succeed, but there are 
some, for example, at:put:, that can fail in the retry during the commmit. 
See the individual method descriptions for details.

One use case for the RcArray is in the implementation of an event logger where it 
is expected that there could be concurrent adds.  These can be safely resolved
by retrying the add on a new view of the object.

Because implementation relies on the replay of the operations when there are conflicts,
it should probably not be used in applications that require high levels of concurrency
since the replay can cause a convoy of sessions all trying to commit their changes
to the RcArray.  For applications with expected high rates of concurrency you should 
consider using an RcQueue to accumulate the additions and have a single gem process
remove them from the RcQueue and put them in an RcArray. 

The commit order determines the order and values of the elements in the RcArray.
';
		immediateInvariant.
true.
%

removeallmethods RcArray
removeallclassmethods RcArray

doit
(Array
	_newKernelSubclass:'RcQueueRemovalSeqNumbers'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 108801
)
		category: nil;
		comment: 'This class implements only GemStone internals.  That is, it  provides only 
 functionality required by GemStone itself.  It is not intended for customer use, 
 by creating instances or by subclassing.

 RcQueueRemovalSeqNumbers describes an Array that is constrained to contain only
 SmallIntegers.  It has no added protocol or instance variables and is used only
 to ensure the consistency of the objects used to represent RcQueues.

Constraints:
	[elements]: SmallInteger';
		immediateInvariant.
true.
%

removeallmethods RcQueueRemovalSeqNumbers
removeallclassmethods RcQueueRemovalSeqNumbers

doit
(Array
	_newKernelSubclass:'RcQueueSessionComponent'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 109057
)
		category: nil;
		comment: 'An RcQueueSessionComponent is the unit within a reduced-conflict queue that
holds all of the queue entries submitted by a given session.  A new RcQueue
allows the same number of sessions as the GemStone system''s maximum number of
sessions.  You can modify this number using the changeMaxSessionId: method.

This class implements GemStone internals. It is not intended for customer use, 
by creating instances or by subclassing.

Constraints:
	[elements]: RcQueueElement';
		immediateInvariant.
true.
%

removeallmethods RcQueueSessionComponent
removeallclassmethods RcQueueSessionComponent

doit
(Association
	_newKernelSubclass:'StringPair'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 94209
)
		category: nil;
		comment: 'A StringPair is an Association whose key and value are both intended 
 to be Strings. ';
		immediateInvariant.
true.
%

removeallmethods StringPair
removeallclassmethods StringPair

doit
(Collection
	subclass: 'GsPipe'
	instVarNames: #(head tail)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'A GsPipe is an implementation of a FIFO queue that has no concurrency
conflicts when used in an environment with a single producer (a user who 
adds elements to the pipe) and a single consumer (a user who may remove 
items from the pipe).  In this environment, the producer and the consumer 
are guaranteed not to conflict with each other.

This implemementation is based on US Patent Number 6,360,219 
         "Object queues with concurrent updating".

The "head" and "tail" objects described in the patent are implemented as a
GsPipeElement where the next field references another GsPipeElement and the 
value is a SmallInteger.  For the head GsPipe element, the value indicates 
the number of removes performed and in the tail the number of additions 
performed.  

When the GsPipe is empty the head and tail next fields both refer to the same 
GsPipeElement.  A removal, if the GsPipe is not empty only modifies the head
GsPipeElement.  An add creates a new GsPipeElement object with the value specified
and links it into the list by storing the new GsPipeElement into the next field
of the GsPipeElement referenced by the tail and then updates the 
tail to reference the new element.  Since adds and removes never update the
same objects, there can be NO concurrency conflicts with these operations.

Multiple concurrent producers (sessions adding to the GsPipe) will experience
concurrency conflicts.  Users needing to have concurrent producers run without
conflict should consider using an RcPipe or an RcQueue.

Values in the GsPipe are always removed in the order that they were committed.
';
		immediateInvariant.
true.
%

removeallmethods GsPipe
removeallclassmethods GsPipe

doit
(GsPipe
	subclass: 'RcPipe'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'An RcPipe is similar to an GsPipe except that it has been extended to allow
concurrent additions to the pipe without generating a concurrency conflict.

The RcPipe is a very efficient for situations in which concurrent additions 
occur, but are not likely for every commit.  If it is known that almost every
addition is concurrent with some other additions, the RcQueue is likely 
a more efficient implementation.

Multiple concurrent producers (sessions adding to the RcPipe) will NOT experience
concurrency conflicts because as part of every add operation, they record the add
in a redo log in the session state.  If a transation containing a RcPipe object 
detects a conflict in its commit, it breaks serialization and then replays the 
addition before competing the commit.  The replays are serialized so that if 
there are multiple sessions performing additions, they will all complete 
sucessfully in the order in which they are serialized.  Because the RcPipe must 
perform the logging and replay operations, when there are lots of concurrent updaters, 
it may be more effient to use an RcQueue.  If the probability of concurrent updates
is relatively small, it can be much more efficient because it does not use as
much space and does not require cleanup like the RcQueue does.

Values in the RcPipe are always removed in the order that they were committed.
';
		immediateInvariant.
true.
%

removeallmethods RcPipe
removeallclassmethods RcPipe

doit
(Error
	subclass: 'ChildError'
	instVarNames: #(status stderr)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: ' ChildError is used by GsHostProcess when the child process returns a non-zero
 exit status.';
		immediateInvariant.
true.
%

removeallmethods ChildError
removeallclassmethods ChildError

doit
(IdentityBag
	subclass: 'RcLowMaintenanceIdentityBag'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'RcLowMaintenanceIdentityBag is a special kind of IdentityBag that provides 
IdentityBag functionality, but with no transaction conflicts between multiple 
sessions that add objects to the bag, and a single session that removes objects. 

When concurrent sessions update an RcLowMantenanceIdentityBag and a conflict
is detected during commit, the conflict is resolved by replaying the operation.  

RcLowMaintenanceIdentityBag provides the same collection and conflict handling 
behavior as RcIdentityBag, but the internal implemention is different. 
Unlike RcIdentityBag, an RcLowMaintenanceIdentityBag does not require cleanup.  
RcLowMaintenanceIdentityBag is expected to have better performance since
fewer objects must be faulted into memory, and should require less disk space.

GemStone recommends migrating instances of RcIdentityBag to 
RcLowMaintenanceIdentityBag. The components-based implementation of RcIdentityBag 
may be deprecated and replaced by the replay-based (renamed) 
RcLowMaintenanceIdentityBag in a future release.  
';
		immediateInvariant.
true.
%

removeallmethods RcLowMaintenanceIdentityBag
removeallclassmethods RcLowMaintenanceIdentityBag

doit
(IdentitySet
	_newKernelSubclass:'ClassSet'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 93697
)
		category: nil;
		comment: 'A ClassSet is an IdentitySet that holds only Class objects.

Constraints:
	_varyingSize: Object
	_numEntries: Object
	_indexedPaths: Object
	_levels: Object
	[elements]: Class';
		immediateInvariant.
true.
%

removeallmethods ClassSet
removeallclassmethods ClassSet

doit
(IdentitySet
	subclass: 'RcIdentitySet'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'An RcIdentitySet is a special kind of IdentitySet that provides for handling
 modifications to an individual instance by multiple concurrent sessions.  
 When concurrent sessions update an RcIdentitySet and an rc conflict is 
 detected during commit the conflict is resolved by replaying the operation.

 There is no commit conflict with multiple sessions adding and a single session 
 removing objects from the RcIdentitySet.

 In an application with high rates of concurrency, the conflict resolution must
 be serialized, which may create delays.  In this case an RcQueue may be more 
 efficient.
';
		immediateInvariant.
true.
%

removeallmethods RcIdentitySet
removeallclassmethods RcIdentitySet

doit
(IdentitySet
	_newKernelSubclass:'StringPairSet'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 94465
)
		category: nil;
		comment: 'A StringPairSet is an IdentitySet that contains only StringPair objects.';
		immediateInvariant.
true.
%

removeallmethods StringPairSet
removeallclassmethods StringPairSet

doit
(nil
	_newKernelSubclass:'ClientForwarder'
	instVarNames: #(clientObject)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 109569
)
		category: nil;
		comment: 'A client forwarder is an instance of the new class ClientForwarder in GemStone.
 When a client forwarder is sent a message during GemStone Smalltalk execution,
 GemBuilder for Smalltalk directs that message to the client object that
 corresponds to the ClientForwarder.  Arguments to the message are replicated as
 necessary, and when client execution completes, the result is replicated back
 into GemStone as the result of the message send to the ClientForwarder.

 This class is considered private and for use by GemStone implementors only.
 Design of an error-handling mechanism that integrates the exception mechanisms
 of the client and GemStone can is deferred until a later release.

 If the execution stack containing the forwarded send includes client
 stack frames down the stack from the GemStone method that invoked the send
 to the client, the exception handler environment in the context of the
 forwarded method execution will include exceptions in the previous client
 stack, but will not include exceptions in GemStone.  That is, exception
 handlers installed in the GemStone part of the stack will be ignored, and
 an exception handler in a previous client invocation may be invoked.

 If an exception handler executing in a previous client stack section above
 the GemStone Activation that sent the forwarded message proceeds in a
 manner which discards stack above the frame where the exception is
 handled, the entire section of GemStone stack will be discarded.

Constraints:
	clientObject: Integer';
		immediateInvariant.
true.
%

removeallmethods ClientForwarder
removeallclassmethods ClientForwarder

doit
(Object
	_newKernelSubclass:'AutoComplete'
	instVarNames: #(realStrings lookupStrings)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 93953
)
		category: nil;
		comment: 'The AutoComplete class is a name completer.  Given a collection of names it
 can find a prefix of one fairly quickly.
-- instVar lookupStrings
The upper case versions of all the strings in the search domain.
--- instVar realStrings
A SortedCollection of the StringPairs holding the original strings and a
 mapping to lookupStrings.
';
		immediateInvariant.
true.
%

removeallmethods AutoComplete
removeallclassmethods AutoComplete

doit
(Object
	_newKernelSubclass:'ClassOrganizer'
	instVarNames: #(classes classNames user hierarchy categories rootClass)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 93185
)
		category: nil;
		comment: 'A ClassOrganizer can answer queries about classes in the image, provides
 tools and reports on information on classes and methods and can perform
 cross-referencing and fileout.

 Instance variables:

 categories - A Dictionary of category->classes associations.
 classes - A ClassSet of all the classes found by an instance.
 classNames - Class name information for auto completion.
 hierarchy - An IdentityDictionary of class->subclasses associations.
 rootClass - The root class of the instance. The instance includes
    all classes in the specified symbolList which are subclasses of 
    rootClass, plus all superClasses of rootClass up to Object.
    Instance creation methods take a SymbolList or UserProfile as
    an argument.
 user - holds the SymbolList used by the instance
 
 dynamic instance variables  
    #envId     
    #optimizedSelectors
    #methodOops
    #restrictedSymbolList
		#traits';
		immediateInvariant.
true.
%

removeallmethods ClassOrganizer
removeallclassmethods ClassOrganizer

doit
(Object
	_newKernelSubclass:'GsBitmap'
	instVarNames: #(hiddenSetId)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesNonPersistent'  #logCreation )
	reservedOop: 249345
)
		category: nil;
		comment: 'GsBitmap is a class that implements an in memory bitmap, i.e. a transient
 bitmap that cannot be made persistent. A bitmap is a sparse data structure
 that logically implements a bit array. Each bit in the bitmap represents
 a committed non-special object.  

 Objects that are added to a GsBitmap are stored as a bit number which is a 
 numeric conversion of the oop of the object. This is done transparently;
 GsBitmap methods add and retrieve objects without manually converting to oops. 

 When working with the raw GsBitmap data, conversions between objects and oops 
 is via: 
   GsBitmap class >> bitToOop:
   GsBitmap class >> oopToBit:
   Object >> asOop
   Object class >> objectForOop:

 Access to the hiddenSets in the system is implemented by creating 
 a GsBitmap that references a particular hiddenSet (see newForHiddenSet:).  

 Most of the hiddenSets in the system are read only and generate an error
 if the operation is not allowed.  See the code for the hiddenSetSpecifiers 
 method and note the last mutable hiddenSet.  HiddenSets after this point in 
 the  array generate errors if an attempt is made to modify them and the user 
 is not SystemUser.  The NotifySet and PureExportSet
 have interfaces defined in System class (categories are NotifySet and
 GcISets) and these interfaces should be used to guarantee correct behavior.
 Updates to these 3 sets generate errors when attempted from GsBitmap.

 An instance of GsBitmap uses C Heap memory to store the bit array. 
 The C Heap memory use is minium of 16KBytes per instance of GsBitmap,
 For an instance with more than 2K elements, worst case memory usage is 
 approximately 8 bytes per element up to 1/64th of the objects in the repository. 
 An instance containing all of the objects in the
 repository will use approximately (System _oopHighWaterMark // 8) bytes of 
 C heap memory.
 The C Heap memory associated with an instance of GsBitmap is automatically 
 freed when the instance is garbage collected.
 Extensive use of large GsBitmaps in a session may require use
 of  ( System _vmMarkSweep )  to force garbage collection of the
 instances sooner than memory pressure on temporary object memory 
 would cause them to be garbage collected, to prevent running out of C heap
 memory.

 Do not retain an instance of GsBitmap from one session to another.
 Instances of GsBitmap are intended to exist only within a given GemStone
 session. 

 Instances may not be committed.

 The objects referenced in a GsBitmap are not protected from garbage collection.
';
		immediateInvariant.
true.
%

removeallmethods GsBitmap
removeallclassmethods GsBitmap

doit
(Object
	_newKernelSubclass:'GsClassDocumentation'
	instVarNames: #(itsClass gsObsolete gsPrivate classDoc instVarDoc classVarDoc classInstVarDoc poolVarDoc categoryDoc classCategoryDoc)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 95233
)
		category: nil;
		comment: 'GsClassDocumentation is deprecated in GemStone/S 64 Bit v3.1 and later.

This class implements GemStone internals. It is not intended for customer use,
by creating instances or by subclassing.

An instance of GsClassDocumentation retains and organizes textual information
that documents the purpose, operation, and implementation of a class.

Constraints:
	itsClass: Class
	gsObsolete: String
	gsPrivate: Boolean
	classDoc: GsDocText
	instVarDoc: SymbolDictionary
	classVarDoc: SymbolDictionary
	classInstVarDoc: SymbolDictionary
	poolVarDoc: SymbolDictionary
	categoryDoc: SymbolDictionary
	classCategoryDoc: SymbolDictionary';
		immediateInvariant.
true.
%

removeallmethods GsClassDocumentation
removeallclassmethods GsClassDocumentation

doit
(Object
	_newKernelSubclass:'GsDocText'
	instVarNames: #(sketch details)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 95489
)
		category: nil;
		comment: 'GsDocText is deprecated in GemStone/S 64 Bit v3.1 and later.

This class implements GemStone internals. It is not intended for customer use, 
by creating instances or by subclassing.

A GsDocText is a unit of textual documentation.  It retains information
about only one thing.  That thing may, however, be a single item of any kind,
or it may be a group of items considered as an aggregate.

Constraints:
	sketch: CharacterCollection
	details: CharacterCollection';
		immediateInvariant.
true.
%

removeallmethods GsDocText
removeallclassmethods GsDocText

doit
(Object
	_newKernelSubclass:'GsHostProcess'
	instVarNames: #(cmd in out err childPid childStatus appendToFiles errSocket)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesNonPersistent'  #logCreation )
	reservedOop: 160769
)
		category: nil;
		comment: 'GsHostProcess represents a forked child process whose stdin, stdout, and
stderr may be accessable via instances of GsSocket.

Lookup in the PATH environment variable is not performed. The argument
to fork:  must specify a complete path to an executable or script.
Instances may not be committed.
The argument to execute: or fork:  does not undergo any shell 
expansion of characters such as ''*'' or ''?'' .  

The GsSocket instance variables in, out, and err either hold GsSockets
representing  the parent process''s ends of the pipes, or those
instance variables specify paths of files to be opened.
If a child process should not access one of those files,  it should
be given a path of ''/dev/null'' .  For example a child process that should
not read anything from stdin should be sent   stdinPath: ''/dev/null'' 
before forking or executing it.  If child stdout should be ignored , then
stdoutPath: ''/dev/zero''  may be appropriate.  
See detailed comments in GsHostProcess >> fork.

The instance variable errSocket represents parent end of a pipe
receiving stderr data in the event a stderr file or stdout file cannot be opened.

For pipes, the forked child process has the other end of the pipe.  
The child accepts input on the stdin and puts output on  stdout and stderr.  
For the parent end, stdin is write-only and  stdout and stderr are read only.

When an instance is garbage collected, and the child has not yet been
reaped,  the child process represented by that instance is killed with
kill -TERM, and waitpid is called to reap the child.

For stdout or stderr pipes of a GsHostProcess, if the child writes data while
it is running then the corresponding GsSocket can read that data. Use
GsSocket>>readWillNotBlock or GsSocket>>readWillNotBlockWithin:
to determine whether data is ready to read.

GsSocket>>read:into:startingAt: will yield to other GsProcess(s) as for
reading from a GsSocket represending an AF_INET or AF_INET6 socket .
If the child has exited and there is no more data to read, this read
method will wait forever.

When GsHostProcess>>status returns non-nil, then any data not yet read
from stdout/stderr pipe is still available to read. The parent end of the
pipe is not closed until the corresponding GsSocket is garbage collected
or explicitly sent GsSocket>>close

If the child tries to read from a stdin pipe it will block until data is
written by the parent to the stdin of the GsHostProcess. If the child 
tries to write a lot of data to stdout or stderr pipe, the child may block
until the parent reads enough data from the respective GsSocket to 
unblock the pipe. 

For example,
  GsHostProcess fork: ''$GEMSTONE/bin/topaz -r''
will fork a topaz process which will do blocking reads on stdin and
execute each command that is written to the stdin of the GsHostProcess 
instance.

Dynamic instVars
  args   -  Array of argument strings, if non-nil they are appended to
            any space separated args within cmd .
';
		immediateInvariant.
true.
%

removeallmethods GsHostProcess
removeallclassmethods GsHostProcess

doit
(Object
	_newKernelSubclass:'GsInterSessionSignal'
	instVarNames: #(sessionSerialNum signal message)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 104961
)
		category: nil;
		comment: 'GsInterSessionSignal is Deprecated.  See InterSessionSignal .

A GsInterSessionSignal represents a signal from one session to another within
 a single GemStone system.

Constraints:
	sessionSerialNum: SmallInteger
	signal: SmallInteger
	message: String

--- instVar message
A String representing application-defined information from the sending
 session.

--- instVar sessionSerialNum
A SmallInteger identifier of the session from which the instance was received.
 To obtain the corresponding session, use the method
 GsSession >> sessionWithSerialNumber:.

--- instVar signal
A SmallInteger representing application-defined information from the sending
 session.
';
		immediateInvariant.
true.
%

removeallmethods GsInterSessionSignal
removeallclassmethods GsInterSessionSignal

doit
(Object
	subclass: 'GsPackage'
	instVarNames: #(sessionMethods prereqs symbolDict)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		immediateInvariant.
true.
%

removeallmethods GsPackage
removeallclassmethods GsPackage

doit
(Object
	subclass: 'GsPipeElement'
	instVarNames: #(next value)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'GsPipeElement describes an individual entry in a GsPipe.

--- instVars
  next    - references the next element in the list for this pipe
  value   - references the value of this element
';
		immediateInvariant.
true.
%

removeallmethods GsPipeElement
removeallclassmethods GsPipeElement

doit
(Object
	_newKernelSubclass:'Locale'
	instVarNames: #(decimalPoint thousandsSep grouping intCurrSymbol currencySymbol monDecimalPoint monThousandsSep monGrouping positiveSign negativeSign intFracDigits fracDigits pCsPrecedes pSepBySpace nCsPrecedes nSepBySpace pSignPosn nSignPosn)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 124161
)
		category: nil;
		comment: ' The Locale class provides access to the host operating system Locale 
 environment (see "man -s 5 locale" for details).

 The current Locale is setup in System sessionState field 16, using the
 internal method System(class)>>_locale.  Applications should access this
 object using the method Locale(class)>>current, rather than calling
 System(class)>>_locale directly.

 The various fields in the Locale object match those available in the
 C structure lconv after a localeconv() call (see "man localeconv" for 
 details).

 As a convenience, class-side methods allow access to the various fields
 of the current Locale object.  For example:

      Locale decimalPoint

 is the same as:

      Locale current decimalPoint
';
		immediateInvariant.
true.
%

removeallmethods Locale
removeallclassmethods Locale

doit
(Object
	_newKernelSubclass:'LogEntry'
	instVarNames: #(receiver selector argArray)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 92161
)
		category: nil;
		comment: 'The class LogEntry implements GemStone internals. It is not intended for 
customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

removeallmethods LogEntry
removeallclassmethods LogEntry

doit
(Object
	_newKernelSubclass:'RcCounterElement'
	instVarNames: #(value)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 108289
)
		category: nil;
		comment: 'RcCounterElement implements GemStone internals. It is not intended for customer use, 
by creating instances or by subclassing.
';
		immediateInvariant.
true.
%

removeallmethods RcCounterElement
removeallclassmethods RcCounterElement

doit
(Object
	_newKernelSubclass:'RcQueueElement'
	instVarNames: #(value sequenceNumber createTime)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 108545
)
		category: nil;
		comment: 'RcQueueElement describes an individual entry in a reduced-conflict queue.

This class implements GemStone internals. It is not intended for customer use, 
by creating instances or by subclassing.

Constraints:
	value: Object
	sequenceNumber: SmallInteger
	createTime: SmallInteger
--- instVar createTime
A SmallInteger that represents a time stamp, indicating the time at which the
 RcQueue >> add: method was invoked to add this element to the queue.
--- instVar sequenceNumber
A SmallInteger that indicates this element''s retrieval position.
--- instVar value
The object (any kind) stored in the queue.
';
		immediateInvariant.
true.
%

removeallmethods RcQueueElement
removeallclassmethods RcQueueElement

doit
(RcQueueElement
	_newKernelSubclass:'RcQueueEntry'
	instVarNames: #(createTimeUs)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 124673
)
		category: nil;
		comment: 'RcQueueEntry describes an individual entry in a reduced-conflict queue.

This class implements GemStone internals. It is not intended for customer use, 
by creating instances or by subclassing.
Constraints:
	value: Object
	sequenceNumber: SmallInteger
	createTime: SmallInteger
	createTimeUs: SmallInteger
--- instVar createTime
A SmallInteger that represents a timestamp in gmt2005 format, indicating the time at which the
 RcQueue >> add: method was invoked to add this entry to the queue.
--- instVar createTimeUs
A SmallInteger that represents a microsecond timestamp, indicating the time at which the
 RcQueue >> add: method was invoked to add this entry to the queue.
--- instVar sequenceNumber
A SmallInteger that indicates this entry''s retrieval position.
--- instVar value
The object (any kind) stored in the queue.
';
		immediateInvariant.
true.
%

removeallmethods RcQueueEntry
removeallclassmethods RcQueueEntry

doit
(Object
	_newKernelSubclass:'RedoLog'
	instVarNames: #(conflictObjects redoObjects)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 94977
)
		category: nil;
		comment: 'The class RedoLog implements only GemStone internals.  That is, it provides 
only functionality required by GemStone itself.  It is not intended for 
customer use, by creating instances or by subclassing.
';
		immediateInvariant.
true.
%

removeallmethods RedoLog
removeallclassmethods RedoLog

doit
(Object
	subclass: 'SystemLoginNotification'
	instVarNames: #()
	classVars: #(Subscriptions)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		immediateInvariant.
true.
%

removeallmethods SystemLoginNotification
removeallclassmethods SystemLoginNotification

doit
(Object
	subclass: 'TransactionBoundaryDefaultPolicy'
	instVarNames: #()
	classVars: #(Current)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		immediateInvariant.
true.
%

removeallmethods TransactionBoundaryDefaultPolicy
removeallclassmethods TransactionBoundaryDefaultPolicy

doit
(PrivateObject
	subclass: 'Upgrade2A'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'Upgrade2A is a class used during image upgrade.  
Methods should only be executed via the image upgrade scripts.';
		immediateInvariant.
true.
%

removeallmethods Upgrade2A
removeallclassmethods Upgrade2A

doit
(Stream
	_newKernelSubclass:'PrintStream'
	instVarNames: #(itsCollection maxSize approxPosition)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 108033
)
		category: nil;
		comment: 'PrintStream is designed for use in place of WriteStream to handle printing
of mixed string types. The default size of the stream is limited
to 100000 bytes.

Constraints:
	itsCollection: SequenceableCollection
	maxSize: Object
	approxPosition: Object';
		immediateInvariant.
true.
%

removeallmethods PrintStream
removeallclassmethods PrintStream

doit
(SymbolDictionary
	subclass: 'SessionTemps'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesNonPersistent'  #logCreation )
)
		category: nil;
		comment: 'Instances of SessionTemps may not be committed. The primary use of this class
 is via the class method #current, which returns an instance of SessionTemps
 that is stored in Transient Session State.

Partial list of keys in  SessionTemps current   used in the base GemStone image:
  #GsClass_logCreation
  #GsNMethod_AllIrs
  #ClassVariablesAssociationClass
  #Gemstone_GciTsLibrary_default
  #GsHostRandomFile
  #GsPackagePolicy_AuthorInitials
  #GsPackagePolicy_SessionMethodDictionary
  #GsRecompileValuesToKeys
  #GsTestCase_Random
  #gciLibrary
  #INDEX_MANAGER_AUTO_COMMIT
  #IcuCollator_AVAILABLE_COLLATORS
  #Module_pinnedClasses
  #OldLitVars
  #PPPredicateObjectParser_cache
  #TranscriptStream_SessionMutex
  #TranscriptStream_SessionStream
  #TransientSessionMethod_Behaviors
  #WaitForDebug

Constraints:
	numElements: SmallInteger
	numCollisions: SmallInteger
	collisionLimit: SmallInteger
	tableSize: SmallInteger';
		immediateInvariant.
true.
%

removeallmethods SessionTemps
removeallclassmethods SessionTemps

doit
(UnorderedCollection
	_newKernelSubclass:'Bag'
	instVarNames: #(dict size)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'disallowGciStore'  #logCreation )
	reservedOop: 102657
)
		category: nil;
		comment: 'A Bag is an UnorderedCollection in which any distinct object can occur any
 number of times.  Adding the same (identical) object to a Bag multiple times
 simply causes it to occur multiple times in the Bag.

 Since a Bag is an equality-based collection, different (non-identical) but
 equivalent (equal) objects are not treated as distinct from each other.  In
 IdentityBags, they are distinct.  Adding multiple equivalent objects to a Bag
 yields a Bag with multiple occurrences of the object that was added last.

Constraints:
	_varyingSize: Object
	_numEntries: Object
	_indexedPaths: Object
	_levels: Object
	dict: KeyValueDictionary
	size: Integer
--- instVar dict
A KeyValueDictionary that organizes the elements and element counts for the
 Bag.
--- instVar size
For GemStone internal use.
';
		immediateInvariant.
true.
%

removeallmethods Bag
removeallclassmethods Bag

doit
(UnorderedCollection
	_newKernelSubclass:'Set'
	instVarNames: #(dict)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'disallowGciStore'  #logCreation )
	reservedOop: 102401
)
		category: nil;
		comment: 'A Set is an UnorderedCollection in which any distinct object can occur only
 once.  Adding the same (identical) object to a Set multiple times is redundant.
 The result is the same as adding it once.

 Since a Set is an equality-based collection, different (non-identical) but
 equivalent (equal) objects are not treated as distinct from each other.  In
 IdentitySets, they are distinct.  Adding multiple equivalent objects to a Set
 yields a Set with the object that was added last.  In short, two different
 elements of a Set are neither identical nor equivalent.

 You can create subclasses of Set to restrict the kind of elements it contains.
 When creating a subclass of Set, you must specify a class as the aConstraint
 argument.  This class is called the element kind of the new subclass.  For each
 instance of the new subclass, the class of each element must be of the element
 kind.

Constraints:
	_varyingSize: Object
	_numEntries: Object
	_indexedPaths: Object
	_levels: Object
	dict: KeyValueDictionary

--- instVar dict
A KeyValueDictionary that organizes the elements and element counts for the
 Set.
';
		immediateInvariant.
true.
%

removeallmethods Set
removeallclassmethods Set

! Class implementation for 'GsCommitList'

!		Instance methods for 'GsCommitList'

category: 'Commit'
method: GsCommitList
abort

"Aborts all sessions in the receiver."

| sessions |

self isEmpty
  ifTrue: [
    ^ localCoordinator == nil
      ifTrue: [ System _localAbort ]
      ifFalse: [ localCoordinator _abort ]
  ].

sessions := Array withAll: self.
" tell each remote session to abort "
1 to: self size do: [ :i |
  (sessions at: i) _abort
].

^ localCoordinator == nil
  ifTrue: [ System _localAbort ]
  ifFalse: [ localCoordinator _abort ]
%

category: 'Commit'
method: GsCommitList
beginTransaction

"Starts a new transaction for the local session, and any remote
sessions."

| sessions |

self isEmpty
  ifTrue: [
    ^ localCoordinator == nil
      ifTrue: [ System _localBeginTransaction ]
      ifFalse: [ localCoordinator _beginTransaction ]
  ].

sessions := Array withAll: self.
" tell each remote session to change "
1 to: self size do: [ :i |
  (sessions at: i) _beginTransaction
].

^ localCoordinator == nil
  ifTrue: [ System _localBeginTransaction ]
  ifFalse: [ localCoordinator _beginTransaction ]
%

category: 'Commit'
method: GsCommitList
commit: commitMode

"Commits the current transaction similar to two-phase commit.  Returns true if
 this transaction and all spawned sessions committed successfully."

^ self useNonBlocking
  ifTrue: [ self nbCommit: commitMode ]
  ifFalse: [ self _commit: commitMode ]
%

category: 'Accessing'
method: GsCommitList
commitResults

"Returns the value of the instance variable 'commitResults'."

^ commitResults
%

category: 'Accessing'
method: GsCommitList
localCoordinator

"Returns the value of the instance variable 'localCoordinator'."

^ localCoordinator
%

category: 'Updating'
method: GsCommitList
localCoordinator: newValue

"Modifies the value of the instance variable 'localCoordinator'."

localCoordinator := newValue
%

category: 'Commit'
method: GsCommitList
nbCommit: commitMode

"Commits the current transaction similar to two-phase commit.  Returns true if
 this transaction and all spawned sessions committed successfully.  Uses
 non-blocking operations."

| sz sessions sess writingSessions localCommitResult localVoteResult
startTime endTimes availSessions unAvailSessions timedOut systm |

sz := self size.
voteResults := Array new: sz.
commitResults := Array new: sz.

self isEmpty
  ifTrue: [
    ^ localCoordinator == nil
      ifTrue: [ System _localCommit: commitMode ]
      ifFalse: [ localCoordinator _commit: commitMode ]
  ].

" quick check to see if can commit locally "
systm := System .
localVoteResult := systm _validateTransaction.
( localVoteResult == 0 or: [ localVoteResult == 1 ])
  ifFalse: [ ^ false ].

" broadcast the request for each remote session to vote "
1 to: sz do: [ :i | (self at: i) _nbVoteToCommit ].

" calculate end times for each session "
startTime := systm timeGmt95.
endTimes := Array new: sz.
availSessions := Array new: sz .
1 to: sz do: [ :i |
  endTimes at: i put: startTime + (self at: i) _nbTimeout.
  availSessions at: i put: i.
].

" see if the local session can commit "
localVoteResult := localCoordinator == nil
  ifTrue: [ systm _prepareToCommit ]
  ifFalse: [ localCoordinator _voteToCommit ~~ 2 ].

localVoteResult
  ifFalse: [ " cancel sessions requests to vote "
    1 to: sz do: [ :i | (self at: i) _nbCancel ].
    ^ false
  ].

unAvailSessions := { }  .
writingSessions := Array new: sz.
[ availSessions isEmpty ] whileFalse: [ | voteResult sessIndex |
  unAvailSessions size: 0.
  1 to: availSessions size do: [ :i |
    sessIndex := availSessions at: i.
    sess := self at: sessIndex.
    sess _nbEnd == 1
      ifTrue: [ " done "
        unAvailSessions add: sessIndex.
        voteResult := sess _nbVoteResult.
        voteResults at: sessIndex put: voteResult.
        " record whether session wrote anything "
        writingSessions at: sessIndex put: (voteResult ~~ 0).
      ]
      ifFalse: [
        " check for timeout "
        systm timeGmt95 > (endTimes at: sessIndex)
          ifTrue: [
            sess _nbCancel.
            unAvailSessions add: sessIndex.
            voteResults at: sessIndex put: 2.
            timedOut := sess.
          ]
      ]
  ].
  availSessions removeAll: unAvailSessions.

  " if any voted no, stop checking for results "
  (voteResults includesIdentical: 2)
    ifTrue: [
      1 to: availSessions size do: [ :i |
        (self at: (availSessions at: i)) _nbCancel
      ].
      availSessions size: 0
    ].
].

timedOut ~~ nil
  ifTrue: [
    self _errorSessionTimedOut: timedOut.
    ^ false
  ].

" see if any voted negative "
(voteResults includesIdentical: 2)
  ifTrue: [
    self _sessionVotedCouldNotCommit: (self at: (voteResults indexOf: 2)).
    ^ false
  ].

" at this point, all sessions voted 'yes' (or were read-only) "

" write log record that we plan to commit "
self _writeIntentToCommitRecord: writingSessions.

sessions := Array withAll: self.

" broadcast the commit to each remote session that wrote something "
1 to: sz do: [ :i |
  sess := sessions at: i.
  (writingSessions at: i)
    ifTrue: [ sess _nbCommit: commitMode ]
    ifFalse: [ sess _nbAbort ]
].

" calculate end times for each session "
startTime := systm timeGmt95.
availSessions size: sz .
1 to: sz do: [ :i |
  endTimes at: i put: startTime + (sessions at: i) _nbTimeout.
  availSessions at: i put: i.
].

localCommitResult := localCoordinator == nil
  ifTrue: [ systm _localCommit: commitMode ]
  ifFalse: [ localCoordinator _commit: commitMode ].

localCommitResult
  ifFalse: [ " raising this error is not necessary when 2PC works "
    " cancel non-blocking commit "
    1 to: sz do: [ :i |
      (writingSessions at: i)
        ifTrue: [ (sessions at: i) _nbCancel ]
    ].
    self _errorFailedCommitAfterRemoteCommits.
    ^ false
  ].

[ availSessions isEmpty ] whileFalse: [ | commitResult sessIndex |
  unAvailSessions size: 0.
  1 to: availSessions size do: [ :i |
    sessIndex := availSessions at: i.
    sess := sessions at: sessIndex.
    sess _nbEnd == 1
      ifTrue: [ " done "
        unAvailSessions add: sessIndex.
        commitResult := sess _nbCommitResult.
        commitResults at: sessIndex put: commitResult.
      ]
      ifFalse: [
        " check for timeout "
        systm timeGmt95 > (endTimes at: sessIndex)
          ifTrue: [
            sess _nbCancel.
            unAvailSessions add: sessIndex.
            commitResults at: sessIndex put: false.
            timedOut := sess.
          ]
      ]
  ].
  availSessions removeAll: unAvailSessions.

  " if any failed to commit, stop checking for results "
  (commitResults includesIdentical: false)
    ifTrue: [
      1 to: availSessions size do: [ :i |
        (self at: (availSessions at: i)) _nbCancel
      ].
      availSessions size: 0
    ]
].

timedOut ~~ nil
  ifTrue: [
    self _errorSessionTimedOut: timedOut.
    self _errorSessionCouldNotCommit: timedOut.
    ^ false
  ].

" see if any failed to commit "
(commitResults includesIdentical: false)
  ifTrue: [
    self _errorSessionCouldNotCommit:
      (self at: (commitResults indexOf: false)).
    ^ false
  ].

self _writeCommitDoneRecord.

^ true
%

category: 'Commit'
method: GsCommitList
transactionMode: newMode

"Sets a new transaction mode for the local session and any remote sessions,
and exits the previous mode by aborting the current transaction.
Valid arguments are #autoBegin, #manualBegin and #transactionless."

| sessions |

self isEmpty
  ifTrue: [
    ^ localCoordinator == nil
      ifTrue: [ System _localTransactionMode: newMode ]
      ifFalse: [ localCoordinator _transactionMode: newMode ]
  ].

sessions := Array withAll: self.
" tell each remote session to change "
1 to: self size do: [ :i |
  (sessions at: i) _transactionMode: newMode
].

^ localCoordinator == nil
  ifTrue: [ System _localTransactionMode: newMode ]
  ifFalse: [ localCoordinator _transactionMode: newMode ]
%

category: 'Commit'
method: GsCommitList
useNonBlocking

"Return whether the receiver can use the non-blocking operations to perform
synchronized commits."

1 to: self size do: [ :i |
  (self at: i) _isNonBlocking
    ifFalse: [ ^ false ]
].
^ true
%

category: 'Accessing'
method: GsCommitList
voteResults

"Returns the value of the instance variable 'voteResults'."

^ voteResults
%

category: 'Commit'
method: GsCommitList
_commit: commitMode

"Commits the current transaction similar to two-phase commit.  Returns true if
 this transaction and all spawned sessions committed successfully.  Uses
 blocking operations."

| sz sessions sess writingSessions localCommitResult localVoteResult |

sz := self size.
voteResults := Array new: sz.
commitResults := Array new: sz.

self isEmpty
  ifTrue: [
    ^ localCoordinator == nil
      ifTrue: [ System _localCommit: commitMode ]
      ifFalse: [ localCoordinator _commit: commitMode ]
  ].

" first see if the localCoordinator can commit "
localVoteResult := localCoordinator == nil
  ifTrue: [ System _prepareToCommit ]
  ifFalse: [ localCoordinator _voteToCommit ~~ 2 ].

localVoteResult
  ifFalse: [ ^ false ].

writingSessions := Array new: sz.
" ask each remote session to vote "
1 to: sz do: [ :i | | voteResult |
  sess := self at: i.
  voteResults at: i put: (voteResult := sess _voteToCommit).
  voteResult == 0
    ifTrue: [ " remote session was read-only "
      writingSessions at: i put: false.
    ]
    ifFalse: [
      writingSessions at: i put: true.
      voteResult == 2
        ifTrue: [
          self _sessionVotedCouldNotCommit: sess.
          ^ false
        ]
    ].
].

" at this point, all sessions voted 'yes' (or were read-only) "

" write log record that we plan to commit "
self _writeIntentToCommitRecord: writingSessions.

localCommitResult := localCoordinator == nil
  ifTrue: [ System _localCommit: commitMode ]
  ifFalse: [ localCoordinator _commit: commitMode ].

localCommitResult
  ifTrue: [
    sessions := Array withAll: self.

    " tell each writing remote session to commit "
    1 to: sz do: [ :i | | commitResult |
      sess := sessions at: i.
      (writingSessions at: i)
        ifTrue: [
          commitResult := sess _commit: commitMode.
          commitResults at: i put: commitResult.
          commitResult
            ifFalse: [ " raising this error is not necessary when 2PC works "
              " xxx : when 2PC is implemented, continue to commit others, then raise error "
              self _errorSessionCouldNotCommit: sess.
              ^ false
            ]
        ]
        " tell read-only sessions to abort "
        ifFalse: [ sess _abort ]
    ]
  ]
  ifFalse: [ " raising this error is not necessary when 2PC works "
    self _errorFailedCommitAfterRemoteCommits.
    ^ false
  ].

self _writeCommitDoneRecord.

^ true
%

category: 'Commit'
method: GsCommitList
_errorFailedCommitAfterRemoteCommits

"During commit, this transaction failed to commit after all remote sessions had
 been told to commit and done so successfully."

self _error: #rtErrLocalSessionFailedCommit args: #()
%

category: 'Commit'
method: GsCommitList
_errorSessionCouldNotCommit: session

"During commit, a session could not commit after it had voted that it could
 (and all others had voted positively)."

self _error: #rtErrRemoteSessionFailedCommit args: { session _publicName }
%

category: 'Commit'
method: GsCommitList
_errorSessionTimedOut: session

"During commit, a non-blocking call timed out for the given session."

System rcValueCacheAt: #'Synchronized-Commit'
  put: (session _publicName , ' non-blocking operation timed out')
  for: System.
"
self _error: #rtErrGsCommitListNBTimeout args: { session _publicName }
"
%

category: 'Commit'
method: GsCommitList
_sessionVotedCouldNotCommit: session

"During commit, a session voted that it could not commit.  Writes an entry in
 temporary session state so that transactionConflicts will show this failure."

System rcValueCacheAt: #'Synchronized-Commit'
  put: (session _publicName , ' voted negative')
  for: System
%

category: 'Logging'
method: GsCommitList
_writeCommitDoneRecord

"Writes a record to the transaction log indicating that the transaction has been
 committed."

%

category: 'Logging'
method: GsCommitList
_writeIntentToCommitRecord: sessions

"Writes a record to the transaction log indicating that the transaction is
 considered committed."

%

! Class implementation for 'InstVarMappingArray'

!		Class methods for 'InstVarMappingArray'

category: 'Instance Creation'
classmethod: InstVarMappingArray
mappingFrom: oldClass to: newClass
 "Create a default instance. This default preserves dynamic instVars on instances of oldClass.
  Named instVars in oldClass that do not exist in newClass are not preserved.

  Instances of InstVarMappingArray are not explicitly created for ordinary migration. 
  Multi-threaded migrate (Repository mtMigrate: does require creating and optionally 
  customizing an instance of InstVarMappingArray, using preserveDynamic:, mapInstVarNamed:to:, and 
  mapInstVarToNil:."

^ self new initializeFrom: oldClass to: newClass
%

!		Instance methods for 'InstVarMappingArray'

category: 'Other'
method: InstVarMappingArray
convertForMigrateMt
" Generates an array containing the information in the InstVarMappingArray for passing to migrateMt:"

  | arr |
  (oldCl isSubclassOf: IdentitySet) ifTrue: [
       ArgumentError signal: 'multithreaded migration not supported for IdentitySets'
    ].
  (oldCl isSubclassOf: Collection) ifTrue: [ 
       ArgumentError signal: 'multithreaded migration not supported for Collections'
    ].
  arr := Array with: oldCl with: newCl with: preserveDynamic with: (oldCl instSize) with: (newCl instSize).
  arr addAll: self.
  ^arr
%

category: 'Initialization'
method: InstVarMappingArray
initializeFrom: oldClass to: newClass

^ self initializeFrom: oldClass to: newClass preserveDynamic: true
%

category: 'Initialization'
method: InstVarMappingArray
initializeFrom: oldClass to: newClass preserveDynamic: aBoolean
  "Initializes the receiver. 
   If aBoolean==true, dynamic instance variables are preserved in the
   new instance, if false, dynamic instance variables are not preserved. "

  oldCl := oldClass .
  newCl := newClass .
  preserveDynamic := aBoolean .
  self addAll: (newClass instVarMappingTo: oldClass) .
%

category: 'Updating'
method: InstVarMappingArray
mapInstVarNamed: oldName to: newName
  "The value at the instance variable named <oldName> in the old class should be migrated
  to the instance variable named <newName> in the new class."

  | o n |
  o := oldCl allInstVarNames indexOfIdentical: oldName.
  n := newCl allInstVarNames indexOfIdentical: newName.
  self at: n put: o.
%

category: 'Updating'
method: InstVarMappingArray
mapInstVarToNil: newName
  "The migration should not retain the value of any instance variable <newName> present 
  in the instance of the old class. After migration; the object will have a nil value 
  at this instance variable."

  | i |
  i := newCl allInstVarNames indexOfIdentical: newName.
  self at: i put: 0.
%

category: 'Accessing'
method: InstVarMappingArray
newClass
  ^ newCl
%

category: 'Accessing'
method: InstVarMappingArray
oldClass
  ^ oldCl
%

category: 'Accessing'
method: InstVarMappingArray
preserveDynamic
  ^ preserveDynamic
%

category: 'Updating'
method: InstVarMappingArray
preserveDynamic: aBoolean
  preserveDynamic := aBoolean
%

! Class implementation for 'NscBuilder'

!		Class methods for 'NscBuilder'

category: 'Instance Creation'
classmethod: NscBuilder
for: aBag max: aSize

"Create an initialized instance of the receiver."

| res |
res := super new: (self maxSize min: aSize).
res counter: 0 ; finalResult: aBag .
(aBag isKindOf: IdentityBag)
  ifTrue:[ res nsc: aBag ]
  ifFalse:[ res nsc: IdentityBag new "handle equality Bag, Set" ].
^ res
%

category: 'Constants'
classmethod: NscBuilder
maxSize

"Returns the maximum size of the root object for efficient implementation."

^ 2000
%

category: 'Instance Creation'
classmethod: NscBuilder
new

"Create a NscBuilder with the 'for:' message."

self shouldNotImplement: #new
%

category: 'Indexing Support'
classmethod: NscBuilder
_canCreateQueryOnInstances
  "Cannot create a GsQuery on the receiver"

  ^ false
%

!		Instance methods for 'NscBuilder'

category: 'Adding'
method: NscBuilder
add: anObject

"Add the object to the receiver.  If the receiver is full, add all of
 its contents to the NSC and reset the counter."

<primitive: 326>
self _primitiveFailed: #add: args: { anObject } .
self _uncontinuableError
%

category: 'Adding'
method: NscBuilder
addAll: aCollection

"Adds all of the elements of aCollection to the receiver and returns the
 receiver."

(self == aCollection)
    ifTrue: [ ^ self addAll: aCollection copy ].
self _addAll: aCollection.
^ self
%

category: 'Adding'
method: NscBuilder
addLast: newObject

""

self shouldNotImplement: #addLast:
%

category: 'Updating'
method: NscBuilder
at: anIndex put: aValue

""

self shouldNotImplement: #at:put:
%

category: 'Accessing'
method: NscBuilder
completeBag

"Returns the complete result object."

| nscRes finalRes |
nscRes := self _completeNsc .
nscRes == finalResult ifFalse:[
  "handle equality Bag, Set"
  finalRes := finalResult .
  1 to: nscRes size do:[ :j | finalRes add: (nscRes _at: j) ] .
				"deleted   'reduce garbage' code"
  ^ finalRes .
  ].
^ nscRes
%

category: 'Updating'
method: NscBuilder
counter: newValue

"Modify the value of the instance variable 'counter'."

counter := newValue
%

category: 'Updating'
method: NscBuilder
finalResult: newValue

"Modify the value of the instance variable 'finalResult'."

finalResult := newValue
%

category: 'Updating'
method: NscBuilder
first: obj

""

self shouldNotImplement: #first:
%

category: 'Adding'
method: NscBuilder
insertAll: aSequenceableCollection at: anIndex

""

self shouldNotImplement: #insertAll:at:
%

category: 'Updating'
method: NscBuilder
last: obj

""

self shouldNotImplement: #last:
%

category: 'Updating'
method: NscBuilder
nsc: newValue

"Modify the value of the instance variable 'nsc'."

nsc := newValue
%

category: 'Removing'
method: NscBuilder
removeFrom: startIndex to: stopIndex

""

self shouldNotImplement: #removeFrom:to:
%

category: 'Updating'
method: NscBuilder
size: anInteger

""

self shouldNotImplement: #size:
%

category: 'Adding'
method: NscBuilder
_addAll: aCollection

"Adds all of the elements of aCollection to the receiver.  If aCollection is
 an Array or a subclass of IdentityBag, then the elements of the collection are
 added without faulting them in, otherwise the elements are added individually."

<primitive: 58>
(self == aCollection) ifTrue: [ ^ self addAll: (aCollection copy) ].
aCollection _validateClass: Collection.
aCollection accompaniedBy: self do: [:me :each | me add: each].
^ aCollection
%

category: 'Adding'
method: NscBuilder
_addAllNsc: aBag

"Adds all of the elements of aBag to the receiver and returns the receiver."

^ self _addAll: aBag
%

category: 'Accessing'
method: NscBuilder
_completeNsc

"Returns the NSC with all elements of the receiver added to it."

<primitive: 163>
self _primitiveFailed: #completeNsc .
self _uncontinuableError
%

category: 'Updating'
method: NscBuilder
_resetForAudit

self counter: 0.
nsc removeAll: nsc.
(nsc ~~ finalResult)
  ifTrue: [ finalResult removeAll: finalResult ].
%

! Class implementation for 'RcArray'

!		Instance methods for 'RcArray'

category: 'Adding'
method: RcArray
add: anObject

"Adds anObject to the RcArray and returns anObject.  The replay always succeeds by
 adding anObject to the end of the RcArray."

self __rcAt: self size . "add path to leaf node to rcReadSet"
self addRedoLogEntryFor: #_redoAdd:  withArgs: { anObject } .
^ super add: anObject
%

category: 'Adding'
method: RcArray
addAll: aCollection

"Adds all of the elements of aCollection to the receiver and returns
 aCollection.  The replay always succeeds by adding the elements of aCollection
 to the end of the RcArray."

self __rcAt: self size . "add path to leaf node to rcReadSet"
self addRedoLogEntryFor: #_redoAddAll:  withArgs: { aCollection copy } .

^ super addAll: aCollection
%

category: 'Private'
method: RcArray
addRedoLogEntryFor: aSelector withArgs: args

"Creates a redo log entry for the selector with the specified argument array,
 adds it to the redolog for this session .
 Sender responsible for adding objects to the rcReadSet."

| logEntry |
(logEntry := LogEntry new)
    receiver: self selector: aSelector argArray: args .
System redoLog addLogEntry: logEntry ;
       addConflictObject: self for: self.
%

category: 'Updating'
method: RcArray
at: anIndex put: aValue

"Stores the argument aValue in the indexed variable of the
 receiver indicated by anIndex.  The argument anIndex must not be
 larger than 1 + the size of the receiver, and must not be less than 1.

 Returns aValue.

 Generates an error if anIndex is not a SmallInteger or is out of
 bounds.

 Can cause an Rc-write-write concurrency conflict if another concurrent transaction
 commits an update to the same index in the RcArray and the value stored by the
 other transaction is different than aValue.
"
| oldValue sz |
"add path to leaf node to rcReadSet and get previous value, if any "
(sz := self size) >= anIndex  ifTrue:[ oldValue := self _rcAt: anIndex ]
                             ifFalse:[  self __rcAt: sz   ] .

self addRedoLogEntryFor: #_redoAtPut:  withArgs: { { anIndex . oldValue . aValue } }.

^ super at: anIndex put: aValue.
%

category: 'Updating'
method: RcArray
size: anInteger

"Changes the size of the receiver to anInteger and returns the receiver.

 If anInteger is less than the current size of the receiver, the
 receiver is shrunk accordingly.  If anInteger is greater than the
 current size of the receiver, the receiver is extended and new
 elements are initialized to nil.

 Can cause an Rc-write-write concurrency conflict if another concurrent transaction
 commits an update that changes the size of the RcArray to a value that is
 greater than it was at the start of this transaction and anInteger is less
 than what the other transaction changed it to.

 Generates an error if anInteger is not a SmallInteger."
| sz |
anInteger >= (sz := self size) ifTrue:[
  self __rcAt: sz  "add path to last node to rcReadSet"
] ifFalse:[
  System _addToRcReadSet: self includingAllNodes: true.
].
self addRedoLogEntryFor: #_redoSize:  withArgs: { { sz . anInteger } }.
^ super size: anInteger
%

category: 'Private'
method: RcArray
_redoAdd: anObject

"Performs the replay of adding anObject to the RcArray and returns true."

self __rcAt: self size .
super add: anObject.
self _rcAt: self size .
^ true
%

category: 'Private'
method: RcArray
_redoAddAll: aCollection

"Performs the replay of adding aCollection to the RcArray and returns true."
| oldSize newSize |
self __rcAt: ( oldSize := self size ).
super addAll: aCollection.
newSize := self size .
(newSize - oldSize) < 2000 ifTrue:[
  self _rcAt: newSize .
] ifFalse:[
  System _addToRcReadSet: self includingAllNodes: true.
].
^ true
%

category: 'Private'
method: RcArray
_redoAtPut: args

"Performs the replay of the at:put to the RcArray and returns false if the
 value change conflicts with another concurrent transaction change."

| idx oldVal newVal |

idx := args at: 1.
oldVal := args at: 2.
newVal := args at: 3.

(self size >= idx) ifTrue: [ | currentVal |
  currentVal := self at: idx. "value after selective abort"
  (( currentVal ~= newVal ) and: [currentVal ~= oldVal ]) ifTrue: [
     ^ false "disallow this commit, another transaction changed this value"
  ]
].

super at: idx put: newVal.
self _rcAt: idx .
^ true
%

category: 'Private'
method: RcArray
_redoSize: args

"Performs the replay of the size: to the RcArray and returns false if the
 size change conflicts with another concurrent transaction change."

| oldSize newSize currentSize |

oldSize := args at: 1.
newSize := args at: 2.
currentSize := self size.

((oldSize < currentSize) and: [newSize < currentSize]) ifTrue: [
  ^ false. "disallow commit, size was made larger by a concurrent transaction"
].

super size: newSize.
System _addToRcReadSet: self includingAllNodes: true.
^ true
%

category: 'Private'
method: RcArray
__rcAt: anOffset
anOffset == 0 ifTrue:[
  System _addRootObjectToRcReadSet: self .
] ifFalse:[
  self _rcAt: anOffset. "add path to leaf node to rcReadSet"
].
%

! Class implementation for 'RcQueueRemovalSeqNumbers'

!		Instance methods for 'RcQueueRemovalSeqNumbers'

category: 'Private'
method: RcQueueRemovalSeqNumbers
_refreshAfterCommitFailure

"Returns whether the receiver should be selectively aborted when there is a
 failed attempt to commit.  Only special Reduced Objects should answer true."

^ true
%

! Class implementation for 'RcQueueSessionComponent'

!		Instance methods for 'RcQueueSessionComponent'

category: 'Copying'
method: RcQueueSessionComponent
postCopy

super postCopy.
1 to: self _basicSize do:[:n| self _at: n put: (self _at: n) copy ].
%

! Class implementation for 'GsPipe'

!		Class methods for 'GsPipe'

category: 'Instance Creation'
classmethod: GsPipe
new

"Returns a new GsPipe."

^super new _initialize
%

!		Instance methods for 'GsPipe'

category: 'Adding'
method: GsPipe
add: aValue

"Adds aValue to the GsPipe and returns aValue."

| element |
element := GsPipeElement newWithNext: nil value: aValue.

tail next next: element.
tail next: element.
tail value: (tail value + 1).
^ aValue
%

category: 'Converting'
method: GsPipe
asArray

"Returns an Array with the contents of the receiver."

| result element |

result := Array new.
element := head next next.
[element == nil] whileFalse: [
  result add: (element value).
  element := element next
].
^ result
%

category: 'Copying'
method: GsPipe
copy

"Returns a new instance of GsPipe with the elements that are in the receiver."

| contents |

contents := self asArray.
^ (GsPipe withAll: contents)
%

category: 'Enumerating'
method: GsPipe
do: aBlock

"Evaluates aBlock with each of the current elements of the GsPipe as
 the argument. The argument aBlock must be a one-argument block.  This
 method traverses the pipe elements in order.  Returns the receiver."

| element |

element := head next next.
[element == nil] whileFalse: [
  aBlock value: (element value).
  element := element next
].
^ self
%

category: 'Accessing'
method: GsPipe
head

^head
%

category: 'Testing'
method: GsPipe
isEmpty

"Returns true if the queue is empty, and false otherwise."

^self size == 0
%

category: 'Updating'
method: GsPipe
objectSecurityPolicy: anObjectSecurityPolicy

"Assigns the receiver and subcomponents to the given security policy."

| element |
super objectSecurityPolicy: anObjectSecurityPolicy.
head objectSecurityPolicy: anObjectSecurityPolicy.
tail objectSecurityPolicy: anObjectSecurityPolicy.

element := head next.
[element == nil] whileFalse: [
  element objectSecurityPolicy: anObjectSecurityPolicy.
  element := element next
].
^ self
%

category: 'Removing'
method: GsPipe
peek

"Returns the leading element from the receiver without removing it.
 If the receiver is empty, returns nil."

| element |
self size == 0 ifTrue: [ ^ nil ].

element := head next next.
^ element value
%

category: 'Removing'
method: GsPipe
remove

"Removes the first element from the receiver and returns that element.
 If the receiver is empty, returns nil."

| element aValue |
self size == 0 ifTrue: [ ^ nil ].

element := head next next.
aValue := element value.
head next: element.
head value: (head value + 1).
^aValue
%

category: 'Removing'
method: GsPipe
remove: oldObject ifAbsent: anExceptionBlock
  ^ self shouldNotImplement: #remove:ifAbsent: 
%

category: 'Removing'
method: GsPipe
removeAll

"Removes all entries from the GsPipe, and returns an Array that contains
 those entries, in order."

| anArray |

anArray := self asArray.
head next: (tail next).
head value: (tail value).
^ anArray
%

category: 'Removing'
method: GsPipe
removeIdentical: oldObject ifAbsent: anExceptionBlock
  ^ self shouldNotImplement: #removeIdentical:ifAbsent: 
%

category: 'Accessing'
method: GsPipe
size

"Returns the number of valid entries in the GsPipe."

^(tail value) - (head value)
%

category: 'Accessing'
method: GsPipe
tail

^tail
%

category: 'Private'
method: GsPipe
_initialize

"initialize the sub-components"
| element |

element := GsPipeElement newWithNext: nil value: nil.
head := GsPipeElement newWithNext: element value: 0.
tail := GsPipeElement newWithNext: element value: 0.
%

! Class implementation for 'RcPipe'

!		Class methods for 'RcPipe'

category: 'Instance Creation'
classmethod: RcPipe
new

"Returns a new RcPipe."

^super new
%

!		Instance methods for 'RcPipe'

category: 'Adding'
method: RcPipe
add: aValue

"Adds aValue to the RcPipe and returns aValue."

| redo logEntry systm |
redo := (systm := System) redoLog.
logEntry := LogEntry new.
logEntry receiver: self selector: #_redoAdd: argArray: { aValue }.
redo addLogEntry: logEntry.
redo addConflictObject: tail for: self.
systm _addToRcReadSet: self includingAllNodes: false.
systm _addToRcReadSet: head includingAllNodes: false.
systm _addToRcReadSet: tail includingAllNodes: false.
systm _addToRcReadSet: tail next  includingAllNodes: false.
^ super add: aValue
%

category: 'Reduced Conflict Support'
method: RcPipe
_abortAndReplay: conflictObjects

"Abort the receiver and replay operations on the receiver from the redo log."

| redoLog logEntries |
redoLog := System _redoLog.

" if no log entries to replay, then we're done "
redoLog == nil ifTrue: [ ^ false ].
logEntries := redoLog getLogEntriesFor: self .
logEntries == nil ifTrue:[ ^ false ].

" cannot perform selective abort if receiver has a dependency tag "
self _hasDependencyList ifTrue: [ ^ false ].

" refresh the state of the receiver and the tail.
  these should only be done once!"
self _selectiveAbort.
self tail _selectiveAbort.


" tell the redo log to replay any operations on the receiver "
^ redoLog _redoOperationsForEntries: logEntries
%

category: 'Private'
method: RcPipe
_redoAdd: anObject

"Performs the replay of adding anObject to the RcPipe and returns true."
self add: anObject.
^ true
%

! Class implementation for 'ChildError'

!		Instance methods for 'ChildError'

category: 'Private'
method: ChildError
buildMessageText
  self details: 'status ', status asString,', ', stderr asString .
  super buildMessageText
%

category: 'Instance initialization'
method: ChildError
initialize
  super initialize .
  gsResumable := true.
%

category: 'Accessing'
method: ChildError
status
  ^ status
%

category: 'Accessing'
method: ChildError
status: anInteger
  status := anInteger
%

category: 'Accessing'
method: ChildError
stderr
  ^ stderr
%

category: 'Accessing'
method: ChildError
stderr: aString
  stderr := aString
%

! Class implementation for 'RcLowMaintenanceIdentityBag'

!		Class methods for 'RcLowMaintenanceIdentityBag'

category: 'Instance Creation'
classmethod: RcLowMaintenanceIdentityBag
new

"Returns a new RcLowMaintenanceIdentityBag."

^super new
%

!		Instance methods for 'RcLowMaintenanceIdentityBag'

category: 'Adding'
method: RcLowMaintenanceIdentityBag
add: anObject

"Adds anObject to the RcLowMaintenanceIdentityBag and returns anObject.
 Nils are ignored, i.e., not added to the bag."

  anObject ifNil:[ ^ anObject "ignore nils" ].
  self addRedoLogEntryFor: #_redoAdd:  withArgs: { anObject } .
  self _rcAdd: anObject withOccurrences: 1 .
  ^ anObject .
%

category: 'Adding'
method: RcLowMaintenanceIdentityBag
add: anObject withOccurrences: aSmallInteger

"Includes anObject as an element of the receiver aSmallInteger number of times."

  anObject ifNil:[ ^ anObject "ignore nils" ].
  self addRedoLogEntryFor: #_redoAddWithOccurrences:  withArgs: { { anObject . aSmallInteger } }.
  self _rcAdd: anObject withOccurrences: aSmallInteger .
  ^ self
%

category: 'Adding'
method: RcLowMaintenanceIdentityBag
addAll: aCollection

"Adds all of the elements of aCollection to the receiver and returns
 aCollection."

System _addToRcReadSet: self includingAllNodes: true.
self addRedoLogEntryFor: #_redoAddAll:  withArgs: { aCollection } .

^ super addAll: aCollection
%

category: 'Private'
method: RcLowMaintenanceIdentityBag
addRedoLogEntryFor: aSelector withArgs: args

"Creates a redo log entry for the selector with the specified argument array,
 adds it to the redolog for this session.
 Sender responsible for rcReadSet additions.
"

| redo logEntry |

redo := System redoLog.
logEntry := LogEntry new.
logEntry receiver: self selector: aSelector argArray: args.
redo addLogEntry: logEntry.
redo addConflictObject: self for: self.
%

category: 'Converting'
method: RcLowMaintenanceIdentityBag
asIdentityBag

^ IdentityBag withAll: self
%

category: 'Removing'
method: RcLowMaintenanceIdentityBag
remove: anObject

"Removes anObject if present from the receiver.
 Generates an error if anObject is not in the receiver.  Returns anObject.
"

anObject ifNil:[ ^ anObject "ignore nils" ].
(self includesIdentical: anObject)  ifTrue:[
  self addRedoLogEntryFor: #_redoRemove:  withArgs: { anObject } .
  ^ self _rcRemove: anObject
] ifFalse:[
  ^ self _errorNotFound: anObject
]
%

category: 'Removing'
method: RcLowMaintenanceIdentityBag
remove: anObject ifAbsent: aBlock

"Removes from the receiver an object that is identical to anObject and
 returns anObject.  If anObject is not present in the receiver,
 evaluates aBlock and returns the result of the evaluation."

(self includesIdentical: anObject) ifTrue: [
  self addRedoLogEntryFor: #_redoRemove: withArgs: { anObject } .
  ^ self _rcRemove: anObject
]
ifFalse: [ ^ aBlock value ]
%

category: 'Removing'
method: RcLowMaintenanceIdentityBag
remove: anObject otherwise: notFoundValue

"Removes from the receiver an object that is identical to anObject and returns
 anObject.  If anObject is not present in the receiver, returns notFoundValue."

(self includesIdentical: anObject) ifTrue: [
   self addRedoLogEntryFor: #_redoRemove: withArgs: { anObject } .
   ^ self _rcRemove: anObject
]
ifFalse: [ ^ notFoundValue ]
%

category: 'Removing'
method: RcLowMaintenanceIdentityBag
removeAll: aCollection

"Removes all of the elements of aCollection from the receiver and returns aCollection.
 Generates an error if any object in the collection is not in the receiver.
"

System _addToRcReadSet: self includingAllNodes: true.
self addRedoLogEntryFor: #_redoRemoveAll: withArgs: { aCollection copy } .

^ super removeAll: aCollection
%

category: 'Removing'
method: RcLowMaintenanceIdentityBag
removeAllPresent: aCollection

"Removes from the receiver each element of aCollection that is also an
 element of the receiver.  Differs from removeAll: in that, if some
 elements of aCollection are not present in the receiver, no error is generated.
 Returns aCollection."

System _addToRcReadSet: self includingAllNodes: true.
self addRedoLogEntryFor: #_redoRemoveAllPresent: withArgs: { aCollection } .

^super removeAllPresent: aCollection
%

category: 'Removing'
method: RcLowMaintenanceIdentityBag
removeIdentical: anObject

"Same as remove:."

^self remove: anObject
%

category: 'Removing'
method: RcLowMaintenanceIdentityBag
removeIdentical: anObject ifAbsent: aBlock

"Same as remove:ifAbsent:."

^self remove: anObject ifAbsent: aBlock
%

category: 'Removing'
method: RcLowMaintenanceIdentityBag
removeIdentical: anObject otherwise: notFoundValue

"Same as remove:otherwise:."

^ self remove: anObject otherwise: notFoundValue
%

category: 'Removing'
method: RcLowMaintenanceIdentityBag
removeIfPresent: anObject

"Removes from the receiver an object that is identical to anObject and
 returns anObject.  Returns nil if anObject is not present in the receiver."

(self includesIdentical: anObject) ifTrue: [
  self addRedoLogEntryFor: #_redoRemove: withArgs: { anObject } .
  ^ self _rcRemove: anObject
] ifFalse: [ ^ nil ]
%

category: 'Class Membership'
method: RcLowMaintenanceIdentityBag
species

"Returns the class to use to select and reject queries."

^ IdentityBag
%

category: 'Reduced Conflict Support'
method: RcLowMaintenanceIdentityBag
_abortAndReplay: conflictObjects

"Abort the receiver and replay operations on the receiver from the redo log."

| redoLog logEntries |
_indexedPaths
  ifNotNil: [
    _indexedPaths _anyIndexIsLegacy
      ifTrue: [
        "abort and replay not supported when legacy index is involved"
        ^false ] ].

redoLog := System _redoLog.

" if no log entries to replay, then we're done "
redoLog ifNil: [ ^ false ].
logEntries := redoLog getLogEntriesFor: self .
logEntries ifNil:[ ^ false ].

" cannot perform selective abort if receiver has a dependency tag "
self _hasDependencyList ifTrue: [ ^ false ].

" Refresh the state of the receiver."

self _selectiveAbort.

" tell the redo log to replay any operations on the receiver "
^ redoLog _redoOperationsForEntries: logEntries
%

category: 'Private'
method: RcLowMaintenanceIdentityBag
_redoAdd: anObject

"Performs the replay of adding anObject to the RcLowMaintenanceIdentityBag and returns true."

self _addForReplay: anObject.
^ true
%

category: 'Private'
method: RcLowMaintenanceIdentityBag
_redoAdd: anObject withOccurrences: aSmallInteger

"Performs the replay of adding aCollection to the receiver and returns true."

self _add: anObject withOccurrences: aSmallInteger forReplay: true.
^ true
%

category: 'Private'
method: RcLowMaintenanceIdentityBag
_redoAddAll: aCollection
  "Performs the replay of adding aCollection to the receiver and returns true."
 | coll |
 coll := aCollection _isRcIdentityBag ifTrue:[ aCollection _asIdentityBag ] ifFalse:[ aCollection ].
 self _addAll: coll _asIdentityBag forReplay: true .
 ^ true
%

category: 'Private'
method: RcLowMaintenanceIdentityBag
_redoAddWithOccurrences: args
  "Performs the replay of adding arg1 to the receiver arg2 times and returns true."
  self _rcAdd: (args at: 1)  withOccurrences: (args at: 2) .
  ^ true
%

category: 'Private'
method: RcLowMaintenanceIdentityBag
_redoRemove: anObject

"Performs the replay of removing anObject from the receiver and returns true."

^ self _removeForReplay: anObject.
%

category: 'Private'
method: RcLowMaintenanceIdentityBag
_redoRemoveAll: aCollection

"Performs the replay of removing aCollection elements from the receiver and returns true."
 | coll |
 coll := aCollection _isRcIdentityBag ifTrue:[ aCollection _asIdentityBag ] ifFalse:[ aCollection ].
 ^ self _removeAll: aCollection _asIdentityBag errIfAbsent: true forReplay: true 
      rc: true"handle leaf nodes created by another session"
%

category: 'Private'
method: RcLowMaintenanceIdentityBag
_redoRemoveAllPresent: aCollection

 "Performs the replay of removing the elements in aCollection from the receiver and returns true."
 | coll |
 coll := aCollection _isRcIdentityBag ifTrue:[ aCollection _asIdentityBag ] ifFalse:[ aCollection ].
 ^ self _removeAll: coll _asIdentityBag errIfAbsent: false forReplay: true 
      rc: true"handle leaf nodes created by another session"
%

category: 'Reduced Conflict Support'
method: RcLowMaintenanceIdentityBag
_validateLegacyRcIndexSupport
  "legacy indexes are not supported on RcIndentitySet or RcLowMaintenanceIdentityBag (bug47179)"

  self error: 'Creating a legacy index on an RcIdentitySet or RcLowMaintenanceBag is not supported.'
%

! Class implementation for 'ClassSet'

!		Instance methods for 'ClassSet'

category: 'Sorting'
method: ClassSet
sortAscending

"Returns an Array with the same (Class) elements as the receiver,
 in ascending order by class name."

^ self _sortPaths: #(#name) directions: #(true).
%

! Class implementation for 'RcIdentitySet'

!		Class methods for 'RcIdentitySet'

category: 'Instance Creation'
classmethod: RcIdentitySet
new

"Returns a new RcIdentitySet."

^super new
%

!		Instance methods for 'RcIdentitySet'

category: 'Adding'
method: RcIdentitySet
add: anObject

"Adds anObject to the RcIdentitySet and returns anObject.
 Nils are ignored, i.e., not added to the set."

anObject == nil ifTrue:[ ^ anObject "ignore nils" ].
(self includes: anObject) ifFalse:[
  self addRedoLogEntryFor: #_redoAdd:  withArgs: { anObject } .
  self _rcAdd: anObject withOccurrences: 1 .
].
^ anObject
%

category: 'Adding'
method: RcIdentitySet
addAll: aCollection

"Adds all of the elements of aCollection to the receiver and returns
 aCollection."

self addRedoLogEntryFor: #_redoAddAll:  withArgs: { aCollection copy } .
System _addToRcReadSet: self includingAllNodes: true.

^ super addAll: aCollection
%

category: 'Private'
method: RcIdentitySet
addRedoLogEntryFor: aSelector withArgs: args

"Creates a redo log entry for the selector with the specified argument array,
 adds it to the redolog for this session.
 Sender responsible for adding to rcReadSet .  "

| redo logEntry |

redo := System redoLog.
logEntry := LogEntry new.
logEntry receiver: self selector: aSelector argArray: args.
redo addLogEntry: logEntry.
redo addConflictObject: self for: self.
%

category: 'Converting'
method: RcIdentitySet
asIdentitySet

^ IdentitySet withAll: self
%

category: 'Removing'
method: RcIdentitySet
remove: anObject

"Removes anObject if present from the receiver.
 Generates an error if anObject is not in the receiver.  Returns anObject.
"

anObject ifNotNil:[
  (self includes: anObject) ifTrue:[
    self addRedoLogEntryFor: #_redoRemove:  withArgs: { anObject } .
    ^ self _rcRemove: anObject .
  ] ifFalse:[
    ^ self _errorNotFound: anObject
  ]
].
^ anObject
%

category: 'Removing'
method: RcIdentitySet
remove: anObject ifAbsent: aBlock

"Removes from the receiver an object that is identical to anObject and
 returns anObject.  If anObject is not present in the receiver,
 evaluates aBlock and returns the result of the evaluation."

(self includes: anObject) ifTrue:[
  self addRedoLogEntryFor: #_redoRemove: withArgs: { anObject } .
  ^ self _rcRemove: anObject
]
ifFalse: [ ^ aBlock value ]
%

category: 'Removing'
method: RcIdentitySet
remove: anObject otherwise: notFoundValue

"Removes from the receiver an object that is identical to anObject and returns
 anObject.  If anObject is not present in the receiver, returns notFoundValue."

(self includes: anObject) ifTrue:[
  self addRedoLogEntryFor: #_redoRemove: withArgs: { anObject } .
  ^ self _rcRemove: anObject
]
ifFalse: [ ^ notFoundValue ]
%

category: 'Removing'
method: RcIdentitySet
removeAll: aCollection
  "Removes all of the elements of aCollection from the receiver and returns aCollection.
 Generates an error if any object in the collection is not in the receiver.
"

  self addRedoLogEntryFor: #_redoRemoveAll: withArgs: {aCollection copy}.
  System _addToRcReadSet: self includingAllNodes: true.
  ^ super removeAll: aCollection
%

category: 'Removing'
method: RcIdentitySet
removeAllPresent: aCollection

"Removes from the receiver each element of aCollection that is also an
 element of the receiver.  Differs from removeAll: in that, if some
 elements of aCollection are not present in the receiver, no error is generated.
 Returns aCollection."

self addRedoLogEntryFor: #_redoRemoveAllPresent: withArgs: { aCollection } .
System _addToRcReadSet: self includingAllNodes: true.

^super removeAllPresent: aCollection
%

category: 'Removing'
method: RcIdentitySet
removeIdentical: anObject

"Same as remove:."

^self remove: anObject
%

category: 'Removing'
method: RcIdentitySet
removeIdentical: anObject ifAbsent: aBlock

"Same as remove:ifAbsent:."

^self remove: anObject ifAbsent: aBlock
%

category: 'Removing'
method: RcIdentitySet
removeIdentical: anObject otherwise: notFoundValue

"Same as remove:otherwise:."

^ self remove: anObject otherwise: notFoundValue
%

category: 'Removing'
method: RcIdentitySet
removeIfPresent: anObject

"Removes from the receiver an object that is identical to anObject and
 returns anObject.  Returns nil if anObject is not present in the receiver."

(self includes: anObject) ifTrue:[
  self addRedoLogEntryFor: #_redoRemove: withArgs: { anObject } .
  ^ self _rcRemove: anObject
]
ifFalse: [ ^ nil ]
%

category: 'Class Membership'
method: RcIdentitySet
species

"Returns the class to use to select and reject queries."

^ IdentitySet
%

category: 'Reduced Conflict Support'
method: RcIdentitySet
_abortAndReplay: conflictObjects

"Abort the receiver and replay operations on the receiver from the redo log."

| redoLog logEntries |
_indexedPaths
  ifNotNil: [
    _indexedPaths _anyIndexIsLegacy
      ifTrue: [
        "abort and replay not supported when legacy index is involved"
        ^false ] ].

redoLog := System _redoLog.

" if no log entries to replay, then we're done "
redoLog == nil ifTrue: [ ^ false ].
logEntries := redoLog getLogEntriesFor: self .
logEntries == nil ifTrue:[ ^ false ].

" cannot perform selective abort if receiver has a dependency tag "
self _hasDependencyList ifTrue: [ ^ false ].

" Refresh the state of the receiver."

self _selectiveAbort.

" tell the redo log to replay any operations on the receiver "
^ redoLog _redoOperationsForEntries: logEntries
%

category: 'Private'
method: RcIdentitySet
_redoAdd: anObject

"Performs the replay of adding anObject to the RcIdentitySet and returns true."

self _addForReplay: anObject.
^ true
%

category: 'Private'
method: RcIdentitySet
_redoAddAll: aCollection
  "Performs the replay of adding aCollection to the receiver and returns true."
 | coll |
 System _addToRcReadSet: self includingAllNodes: true.
 coll := aCollection _isRcIdentityBag ifTrue:[ aCollection _asIdentityBag ] ifFalse:[ aCollection ].
 self _addAll: coll _asIdentityBag forReplay: true .
 ^ true
%

category: 'Private'
method: RcIdentitySet
_redoRemove: anObject

"Performs the replay of removing anObject from the receiver and returns true."

^ self _removeForReplay: anObject.
%

category: 'Private'
method: RcIdentitySet
_redoRemoveAll: aCollection

 "Performs the replay of removing aCollection elements from the receiver and returns true."
 | coll |
 System _addToRcReadSet: self includingAllNodes: true.
 coll := aCollection _isRcIdentityBag ifTrue:[ aCollection _asIdentityBag ] ifFalse:[ aCollection ].
 ^ self _removeAll: coll _asIdentityBag errIfAbsent: true forReplay: true 
      rc: true"handle leaf nodes created by another session"
%

category: 'Private'
method: RcIdentitySet
_redoRemoveAllPresent: aCollection

 "Performs the replay of removing the elements in aCollection from the receiver and returns true."
 | coll |
 System _addToRcReadSet: self includingAllNodes: true.
 coll := aCollection _isRcIdentityBag ifTrue:[ aCollection _asIdentityBag ] ifFalse:[ aCollection ].
 ^ self _removeAll: aCollection _asIdentityBag errIfAbsent: false forReplay: true 
      rc: true"handle leaf nodes created by another session"
%

category: 'Reduced Conflict Support'
method: RcIdentitySet
_validateLegacyRcIndexSupport
  "legacy indexes are not supported on RcIndentitySet or RcLowMaintenanceIdentityBag (bug47179)"

  self error: 'Creating a legacy index on an RcIdentitySet or RcLowMaintenanceBag is not supported.'
%

! Class implementation for 'StringPairSet'

!		Instance methods for 'StringPairSet'

category: 'Sorting'
method: StringPairSet
sortAscending

"Returns an Array of the contents of the receiver sorted
 by key in ascending order."

^ self _sortPaths: #(#key) directions: #(true).
%

! Class implementation for 'ClientForwarder'

!		Instance methods for 'ClientForwarder'

category: 'Accessing'
method: ClientForwarder
clientObject

"Returns the OOP (in the form of some kind of Integer) in the client object
 space of the object to which messages are to be forwarded."

^ clientObject
%

category: 'Updating'
method: ClientForwarder
clientObject: anInteger

""

clientObject := anInteger
%

category: 'Compatibility'
method: ClientForwarder
doesNotUnderstand: aMessageDescriptor

"Sends the message described by aMessageDescriptor to the client object
 represented by the value of the receivers' instance variable clientObject.
 Returns the result from executing the forwarded message in the client."

  | res |
  res := ClientForwarderSend new
      receiver: self
           clientObj: clientObject
           selector: (aMessageDescriptor at: 1)
           args: (aMessageDescriptor at: 2) "arguments to selector" ;
      defaultAction  "return error direct to GCI" .
  1 timesRepeat:[ self _class ]. "loop to detect/handle termination interrupt"
  ^ res
%

category: 'Forwarding'
method: ClientForwarder
doesNotUnderstand: aSymbol args: anArray envId: envId

"Sends the message described by aSymbol and anArray to the client object
 represented by the value of the receivers' instance variable clientObject.
 Returns the result from executing the forwarded message in the client."

"Implemented by raising the error #clientForwarderSend to the client.
 This error will be returned to the client as the result of the GemBuilder for C
 call which caused the GemStone Smalltalk execution containing the forwarded
 message send.

 Upon completion of the method invoked by the forwarded message, the
 client should call GciContinueWith(anOop), where anOop is the GemStone
 replicate of the result of the client message send."
| res |
envId == 0 ifFalse:[
  ImproperOperation new details:
       'ClientForwarder not implemented for environmentId > 0' ;
    signalNotTrappable . "avoid infinite DNU"
].
res := ClientForwarderSend new
      receiver: self
           clientObj: clientObject
           selector: aSymbol
           args: anArray ;
    defaultAction  "return error direct to GCI" .
1 timesRepeat:[ self _class ]. "loop to detect/handle termination interrupt"
^ res
%

category: 'Testing'
method: ClientForwarder
isBehavior

"Although a ClientForwarder may indeed represent a client behavior
 object, the GemStone system should not consider it as a GemStone
 behavior."
^false
%

category: 'Class Membership'
method: ClientForwarder
_class
"Returns the object that is the receiver's Smalltalk class."

<primitive: 610 >
^ self _primitiveFailed: #_class .
%

! Class implementation for 'AutoComplete'

!		Instance methods for 'AutoComplete'

category: 'Initializing'
method: AutoComplete
addString: str

"Adds the given string to the search domain of the receiver."

| alist idx newpair |

alist := realStrings.
newpair := StringPair new key: (str asUppercase) value: str.
alist add: newpair.
idx := alist indexOf: newpair.  "find the new item's location for insertion"
lookupStrings insertObject: newpair key at: idx.
%

category: 'Completing'
method: AutoComplete
commonChars: s1 with: s2

"Returns a count of the number of Characters common between two Strings."

| sz |
sz := s1 size min: s2 size.
1 to: sz do: [ :i |
  ((s1 at: i) isEquivalent: (s2 at: i)) ifFalse: [
    ^i - 1
  ].
].
^sz.
%

category: 'Completing'
method: AutoComplete
complete: string

"Attempts to complete the given string from our current set.  Returns either
 the original string, or a replacement for it that is either the same length or
 longer."

| ch sz i name curstr initlen matchlen len found |

lookupStrings == nil ifTrue: [
  ^string
].

(curstr := String new) add: string .
curstr size == 0 ifTrue: [
  ^string
].

"Do a fast search for the first Character"
ch := curstr at: 1.
sz := lookupStrings size.
i := 1.
[ (i > sz) or: [ch isEquivalent: ((lookupStrings at: i) at: 1)] ] whileFalse: [
  i := i + 1
].

i > sz ifTrue: [
  ^string
].

initlen := curstr size.
matchlen := initlen.
found := 0.

i to: sz do: [ :j |
  name := lookupStrings at: j.
  len := self commonChars: curstr with: name.
  len < initlen ifTrue: [
    "A shorter match in a sorted list means we can quit now"
    found > 0 ifTrue: [
      ^(realStrings at: found) value copyFrom: 1 to: matchlen
    ].
  ]
  ifFalse: [
    "First match - copy the real string"
    found > 0 ifFalse: [
      (curstr := String new) add: name.
      matchlen := curstr size.
      found := j.
    ]
    ifTrue: [
      "Trim the current string back to the matched length"
      curstr size: len.
      matchlen := len.

      "The entered name is as complete as possible - quit now"
      len = initlen ifTrue: [
	^(realStrings at: found) value copyFrom: 1 to: matchlen
      ].
    ].
  ].
].

found > 0 ifTrue: [
  ^(realStrings at: found) value copyFrom: 1 to: matchlen
].

^string.
%

category: 'Initializing'
method: AutoComplete
stringPairSet: alist

"Sets up information needed to do string completion on the given set of
 strings.  The strings are already in our desired StringPairSet form."

| list assn |

list := alist sortWithBlock: [:x:y | x key < y key].

lookupStrings := Array new: list size.
1 to: list size do: [ :i |
  assn := list at: i.
  lookupStrings at: i put: assn key.
].

"keep the StringPairs around as a sorted collection instead of a know-
  nothing Array.  This will make incremental additions much faster"
realStrings := SortedCollection sortBlock: [:x:y | x key < y key]
                  fromSortResult: list.
%

category: 'Accessing'
method: AutoComplete
strings

"Returns the list of real strings."

^realStrings.
%

category: 'Initializing'
method: AutoComplete
strings: strings

"Sets up information needed to do string completion on the given set of
 strings."

| alist str assn |

alist := StringPairSet new.
1 to: strings size do: [ :i |
  str := strings _at: i.
  alist add: (StringPair new key: (str asUppercase) value: str).
].

alist := alist sortWithBlock: [:x:y | x key < y key].

lookupStrings := Array new: alist size.
1 to: alist size do: [ :i |
  assn := alist at: i.
  lookupStrings at: i put: assn key.
].

"Keep the StringPairs around as a sorted collection instead of a know-
  nothing Array.  This will make incremental additions much faster"
realStrings := SortedCollection sortBlock: [:x:y | x key < y key]
                  fromSortResult: alist.
%

category: 'Initializing'
method: AutoComplete
strings: strings cluster: clusterBoolean

"Sets up information needed to do string completion on the given set of
 strings.  clusterBoolean is ignored."

self deprecated: 'AutoComplete>>strings:cluster is deprecated, use AutoComplete>>strings:'.

self strings: strings.
%

! Class implementation for 'ClassOrganizer'

!		Class methods for 'ClassOrganizer'

category: 'Updating'
classmethod: ClassOrganizer
clearCachedOrganizer
  "do nothing in base image"
  ^ self
%

category: 'Instance Creation'
classmethod: ClassOrganizer
new

"Creates and returns a new instance of ClassOrganizer with a root of Object,
 and using the symbolList of the current UserProfile."

^ self _newWithRoot: Object symbolList: GsCurrentSession currentSession symbolList
	env: 0
%

category: 'Instance Creation'
classmethod: ClassOrganizer
newExcludingGlobals
  "Example
     topaz 1> send ClassOrganizer newExcludingGlobals
     topaz 1> define CurrentClassOrganizer **
   Then subsequent organizer commands in topaz (such as  senders, implementors) 
   will exclude methods in classes in Globals .
  " 
  ^ self _newWithRoot: Object 
    restrictedSymbolList: (SymbolList withAll:
          (GsCurrentSession currentSession symbolList reject:[:x |x == Globals]))
     env: 0
%

category: 'Instance Creation'
classmethod: ClassOrganizer
newForEnvironment: envId

"Creates and returns a new instance of ClassOrganizer with a root of Object,
 and using the symbolList of the current UserProfile.
 Uses the environment envId ( a SmallInteger >= 0) for superclass and method
 dictionary lookups."

^ self _newWithRoot: Object symbolList: GsCurrentSession currentSession symbolList
	env: envId
%

category: 'Instance Creation'
classmethod: ClassOrganizer
newWithRoot: aClass

^ self _newWithRoot: aClass symbolList: GsCurrentSession currentSession symbolList
      env: 0
%

category: 'Instance Creation'
classmethod: ClassOrganizer
newWithRoot: aClass forEnvironment: envId

" Uses the environment envId ( a SmallInteger >= 0) for superclass and method
 dictionary lookups."

^ self _newWithRoot: aClass symbolList: GsCurrentSession currentSession symbolList
      env: envId
%

category: 'Instance Creation'
classmethod: ClassOrganizer
newWithRoot: aClass forUserId: aUserId

"Creates a new ClassOrganizer that is limited to the given subtree of objects using
 the SymbolList from aUserId.  Caller must have read access to given user's SymbolList."

^ self _newWithRoot: aClass symbolList: (AllUsers userWithId: aUserId) symbolList
	env: 0
%

category: 'Instance Creation'
classmethod: ClassOrganizer
newWithRoot: aClass forUserId: aUserId forEnvironment: envId

"Creates a new ClassOrganizer that is limited to the given subtree of objects using
 the SymbolList from aUserId.  Caller must have read access to given user's SymbolList.
 Uses the environment envId ( a SmallInteger >= 0) for superclass and method
 dictionary lookups."

^ self _newWithRoot: aClass symbolList: (AllUsers userWithId: aUserId) symbolList
	env: envId
%

category: 'Instance Creation'
classmethod: ClassOrganizer
newWithRoot: aClass from: anotherOrganizer

"Creates a new ClassOrganizer that uses the specified rootClass."

| inst |
inst := super new.
inst dynamicInstVarAt: #envId put: anotherOrganizer environmentId .
inst rootClass: aClass.
inst classes: ClassSet new.
inst classes add: aClass.
inst classes addAll: (anotherOrganizer allSubclassesOf: aClass).
inst traits: anotherOrganizer traits.
inst rebuildHierarchy .
^inst
%

category: 'Private'
classmethod: ClassOrganizer
_newWithRoot: aClass restrictedSymbolList: symList env: envId
  | inst |
  inst := super new .
  inst _symbolList: symList .
  inst dynamicInstVarAt: #envId put: envId .
  inst rootClass: aClass.
  inst classes: (ClassSet new add: aClass ; yourself).
  inst dynamicInstVarAt: #restrictedSymbolList put: true .
  ^ inst _build 
%

category: 'Private'
classmethod: ClassOrganizer
_newWithRoot: aClass symbolList: symList env: envId
  | inst |
  inst := super new .
  inst _symbolList: symList .
  inst dynamicInstVarAt: #envId put: envId .
  inst rootClass: aClass.
  inst classes: (ClassSet new add: aClass ; yourself).
  ^ inst _build .
%

!		Instance methods for 'ClassOrganizer'

category: 'Queries'
method: ClassOrganizer
accessorsOf: ivName inClass: aClass
"Return an array of GsNMethods that directly access the instance
 variable with the given name in the given class"

  | allSubs arr nam |
  arr := { } .
  (nam := Symbol _existingWithAll: ivName) ifNil:[ ^ arr ].
  allSubs := self allSubclassesOf: aClass .
  allSubs add: aClass .
  allSubs do:[:cls |
    cls selectors do:[:sel | | meth |
      meth := cls compiledMethodAt: sel .
      (meth instVarsAccessed includes: nam) ifTrue:[ arr add: meth ].
    ].
  ].
  ^ arr
%

category: 'Reports'
method: ClassOrganizer
accessorsReport: ivName inClass: aClass
"Return a String describing the methods that directly access the instance
 variable with the given name in the given class"

  ^ self _asReportString:( self accessorsOf: ivName inClass: aClass)
%

category: 'Private'
method: ClassOrganizer
addCachedClassNames

"Adds new class names to the auto-complete set.  New class names are cached
 until the auto-completer is needed, then they are all merged in to the
 completer in one shot.  Users that don't make use of auto-completion features
 never have to pay the price of updating the completer's structures."

| completer cache |
completer := classNames at: 1.
cache := classNames at: 2.
1 to: cache size do: [:i |
  completer addString: (cache at: i).
].
classNames at: 2 put: nil
%

category: 'Updating'
method: ClassOrganizer
addClass: cls

"Adds the class cls, replacing any existing class with the same superclass."

| nm superCls cat old matching cset |

hierarchy ifNil: [^self].
nm := cls name.
superCls := self _superClass: cls .

cset := hierarchy at: superCls otherwise: nil .
cset ifNotNil:[  | newCset |
  hierarchy at: superCls put: ( newCset := cset select: [:e | e name ~= nm]).
  newCset add: cls.
] ifNil: [
  (cset := ClassSet new) add: cls .
  hierarchy at: superCls put: cset .
].

matching := classes select:[ :each | each name = nm ].
matching size > 0 ifTrue: [
  classes := classes - matching
].
classes add: cls.

cat := categories at: cls category otherwise: nil.
cat ifNil: [
  categories at: cls category put: { cls }.
] ifNotNil: [
  nm := cls name.
  [old := cat findFirst: [:x | x name = nm].
    old > 0] whileTrue: [
    cat removeFrom: old to: old
  ].
  cat add: cls
].

self addedClassName: nm
%

category: 'Private'
method: ClassOrganizer
addedClassName: name

"Adds the new class name to the auto-complete set."

classNames ifNotNil:[ :cn |
  (cn at: 2) ifNil: [
    cn at: 2 put: { name } .
  ] ifNotNil:[ :arr |
    arr add: name.
  ]
].
%

category: 'Queries'
method: ClassOrganizer
allReferencesTo: selector

"Returns an Array of two Arrays.  The first contains GsNMethods that
 implement, send, or refer to the given selector.  The second contains the
 indexes into sourceStrings where the first reference takes place."

^self allReferencesTo: selector in: classes
%

category: 'Queries'
method: ClassOrganizer
allReferencesTo: aSelector in: classSet

"Returns an Array of two Arrays.  The first contains GsNMethods that
 implement, send, or refer to the given selector.  The second contains the
 indexes into sourceStrings where the first reference takes place."

| methods indices cset selectorSym methsSet |

methsSet := IdentitySet new .
methods := { } .
indices := { } .
selectorSym := Symbol _existingWithAll: aSelector .
selectorSym ifNotNil:[
  "Sort the class set by name, then search"
  cset := self sortClasses: classSet  .
  1 to: cset size do: [ :i |
    1 to: 2 do: [ :n | | cls mDict |
      cls := (n == 1 ifTrue: [cset at: i] ifFalse: [cls class]).
      mDict := cls _fullMethodDictEnv: self environmentId .
      mDict valuesDo: [ :method | | srcOffset |
	  "Check for implementors first"
	  method selector == selectorSym ifTrue: [
	    (methsSet _addIfAbsent: method) ifTrue:[
	      methods add: method.
	      indices add: 1.
	    ].
	  ] ifFalse: [
	    "Check for senders"
	    srcOffset := method _sourceOffsetOfFirstSendOf: selectorSym .
	    srcOffset ifNotNil:[
	      (methsSet _addIfAbsent: method) ifTrue:[
		methods add: method .
		indices add: srcOffset.
	      ].
	    ] ifNil: [
	      (method _literalsIncludesSymbol: selectorSym value: nil) ifTrue:[
		(methsSet _addIfAbsent: method) ifTrue:[
		  methods add: method.
		  indices add: (method sourceString findString: selectorSym startingAt: 1).
		].
	      ].
	    ].
	  ].
      ].
    ].
  ].
].
^{ methods . indices }
%

category: 'Queries'
method: ClassOrganizer
allSubclassesOf: aClass

"Returns a collection of all the subclasses of the given class: an Array that
 holds a depth-first traversal of the class hierarchy subtree rooted at
 aClass."

| result subs |

classes ifNil: [
  self updateClassInfo
].
(classes includesIdentical: aClass) ifFalse: [
  self addClass: aClass.
  ^self allSubclassesOf: aClass
].

result := { } .
subs := hierarchy at: aClass otherwise: nil.
subs size > 0 ifTrue: [
  subs := self sortClasses: subs  .
  subs do: [:each |
    result add: each; addAll: (self allSubclassesOf: each)
  ].
].
^result
%

category: 'Queries'
method: ClassOrganizer
allSuperclassesOf: aClass
	"Returns a collection of all the superclasses of the given class: an Array that
	 holds the inheritence path of aClass."

	| result current |
	classes ifNil: [self updateClassInfo].
	(classes includesIdentical: aClass) ifFalse:[
    self addClass: aClass.
		^self allSuperclassesOf: aClass
  ].
	result := {}.
	current := aClass.
	[ current := self _superClass: current .
    current ~~ nil and:[ current ~~ #nil] ] whileTrue: [result add: current].
	^result reverse
%

category: 'Accessing'
method: ClassOrganizer
categories

"Returns the value of the instance variable 'categories', which are the
 class categories."

^categories
%

category: 'Queries'
method: ClassOrganizer
categoryCrossReference

"Returns a dictionary of all method categories and the classes with methods
 in each category."

| resultDict cls |

resultDict := SymbolDictionary new.
1 to: classes size do: [ :i |
  1 to: 2 do: [ :which |
    cls := classes _at: i.
    which == 2 ifTrue: [ cls := cls class ].
    cls categorysDo:[ :aCateg :selectorSet | | clsset |
        clsset := resultDict at: aCateg otherwise: nil.
        clsset ifNil: [
	  clsset := { }.
	  resultDict at: aCateg put: clsset.
        ].
        clsset add: cls.
    ].
  ].
].
^resultDict
%

category: 'Reports'
method: ClassOrganizer
categoryCrossReferenceByName

"Returns a String containing a report from a cross-reference of method
 categories. For each method category, the report contains a list of
 names of classes which have methods in that category."

^self categoryCrossReferenceReportByName: nil
%

category: 'Reports'
method: ClassOrganizer
categoryCrossReferenceReportByName: catsDict

"Returns a String containing a report from a cross-reference of categories.
 For each method category, the report contains a list of
 names of classes which have methods in that category.

 The argument may be nil or a dictionary similar to the one that
 categoryCrossReference returns."

  | dict report cats |
(dict := catsDict) ifNil: [
  dict := self categoryCrossReference
].
report := String new.
cats := SortedCollection withAll: dict keys.
1 to: cats size do: [ :i | | cat clsset |
  cat := cats at: i.
  report add: cat; add: Character tab.
  clsset := dict at: cat.
  1 to: clsset size do: [ :j |
    report add: (clsset at: j) name.
    j < clsset size ifTrue: [ report add: $, ].
  ].
  report lf .
].
^report .
%

category: 'Accessing'
method: ClassOrganizer
classCompletion

"Returns the AutoComplete holding the class names."

| cn |
cn := classNames ifNil:[ self collectClassNames ].
(cn at: 2) ifNotNil: [
  self addCachedClassNames
].
^(cn at: 1).
%

category: 'Accessing'
method: ClassOrganizer
classes

"Returns the ClassSet of classes held by the receiver."

^classes
%

category: 'Updating'
method: ClassOrganizer
classes: aClassSet

"Updates the set of classes held by the receiver.  The receiver's
 hierarchy should be rebuilt after this (see rebuildHierarchy)."

classes := aClassSet
%

category: 'Accessing'
method: ClassOrganizer
classNames

"Returns the Array of class names held by the receiver."

| cn |
cn := classNames ifNil:[ self collectClassNames ].
(cn at: 2) ifNotNil: [
  self addCachedClassNames
].
^(cn at: 1) strings.
%

category: 'Private'
method: ClassOrganizer
collectClasses

"Rebuilds the class hierarchy structure.  This message should be sent whenever
 new classes have been created or imported from other users."

^ self collectClassesFromSymbolList: self symbolList
%

category: 'Accessing'
method: ClassOrganizer
collectClassesFromSymbolList: aSymbolList
  "Rebuilds the class hierarchy structure from the given SymbolList."

  | allClasses symlist dict rootIsObj done rootHist allTraits |
  allClasses := ClassSet new.   " make a list of all the named classes and trait instances "
  allTraits := IdentitySet new.
  symlist := Array withAll: aSymbolList.
  rootIsObj := rootClass superclass isNil.
  rootIsObj
    ifTrue: [ rootHist := IdentitySet new ]
    ifFalse: [
      rootHist := IdentitySet withAll: rootClass classHistory.
      rootHist remove: rootClass ].
  done := IdentitySet new.
  [ symlist size > 0 ]
    whileTrue: [
      dict := symlist at: 1.
      (done includesIdentical: dict)
        ifFalse: [
          dict
            valuesDo: [ :aValue |
              | anObj |
              anObj := aValue.
              anObj isBehavior
                ifTrue: [
                  anObj isMeta
                    ifTrue: [ anObj := anObj thisClass ].
                  (rootIsObj
                    or: [ (anObj _subclassOf: rootClass) or: [ rootHist includes: anObj ] ])
                    ifTrue: [ allClasses add: anObj ] ]
                ifFalse: [
                  anObj isTrait
                    ifTrue: [ allTraits add: anObj ] ] ].
            done add: dict ].
      symlist removeFrom: 1 to: 1 ].
  rootIsObj
    ifFalse: [
      | cls |
      "now add superclasses up to object"
      cls := rootClass superclass.
      [ cls ~~ nil ]
        whileTrue: [
          allClasses add: cls.
          cls := cls superclass ] ].
  classes := allClasses.
  self traits: allTraits
%

category: 'Private'
method: ClassOrganizer
collectClassNames

"Causes the receiver to collect all of the names of classes from the
 current collection of classes and form an auto-completer for the names."

| arr sz |

sz := classes size .
arr := Array new: sz .
1 to: classes size do: [:i | arr at: i put:((classes _at: i) name)  ].

classNames := { AutoComplete new strings: arr . nil }.
^ classNames
%

category: 'Fileout Aids'
method: ClassOrganizer
determineClassFileoutOrder: classdict

"Returns an ordered collection of the values that are classes in classdict,
 specifying the order of fileout.  The argument should be a SymbolDictionary."

| org result classSet block |

( classdict isEmpty or:
[ nil == (classdict associationsDetect: [ :assoc | assoc value isBehavior ] ifNone: [ nil ]) ])
  ifTrue: [ ^ { } ].

"form a hierarchy for the set of classes"
org := Dictionary new.
org at: #nil put: ClassSet new.

classSet := ClassSet new.
classdict associationsDo: [:assn | | sub |
  sub := assn value.
  sub isBehavior ifTrue: [ | superCls |
    classSet add: sub.
    [ superCls := self _superClass: sub .
      superCls ~~ nil and:[ superCls ~~ #nil] ] whileTrue: [ | assoc |
      assoc := org associationAt: superCls otherwise: nil.
      assoc ifNil: [
        assoc := Association newWithKey: superCls value: ClassSet new.
          org add: assoc
      ].
      assoc value add: sub.
      sub := superCls
    ].
    (org at: #nil) add: sub.
  ].
].

"make a recursive block to order the subclass sets and weed out unwanted
 classes"
result := { } .
block := [:order: subs |
  1 to: subs size do: [:i | | assoc class |
    class := subs at: i.
    (classSet includesIdentical: class) ifTrue: [
      order add: class
    ].
    assoc := org associationAt: class otherwise: nil.
    (assoc ~~ nil and: [assoc value size > 0]) ifTrue: [
      block value: order value: (self sortClasses: assoc value )
    ]
  ]
].

block value: result value: (self sortClasses:(org at: #nil) ).
^ result
%

category: 'Fileout Aids'
method: ClassOrganizer
determineTraitFileoutOrder: traitdict

"Returns an ordered collection of the values that are traits in traitdict,
 specifying the order of fileout.  The argument should be a SymbolDictionary."

| traitSet |

traitSet :=  traitdict select: [ :aValue | aValue isTrait ].
traitSet isEmpty
  ifTrue: [ ^ { } ].

^ traitSet sort: [:a :b | a name < b name ]
%

category: 'EnvironmentId'
method: ClassOrganizer
environmentId
  "Return the environmentId"

  ^ (self dynamicInstVarAt: #envId) ifNil:[ 0 ]
%

category: 'EnvironmentId'
method: ClassOrganizer
environmentId: envId
  "Set the environmentId for subsequent loading of classes
   and reporting results.
   Normally done only just after instance creation."

  self dynamicInstVarAt: #envId put: envId
%

category: 'Fileout Aids'
method: ClassOrganizer
fileOutClasses: order on: stream

"Writes out code in topaz filein format on the given stream, that creates the
 given classes.  order arg is an array of classes."

	1 to: order size
		do:
			[:j | | cls |
			cls := order at: j.
			cls fileOutClassDefinitionOn: stream.
            ].
%

category: 'Fileout Aids'
method: ClassOrganizer
fileOutClasses: order on: stream inDictionary: dict named: dictName
	"Writes out code on the given stream that creates the given classes in the
	 dictionary with the given name.  The dict argument should be a SymbolDictionary
	 of classes."

	| class lf head term nm |

self deprecated: 'ClassOrganizer >> fileOutClasses:on:inDictionary:named: deprecated v3.2.  Use fileOutClasses:on: instead'.

	order size == 0 ifTrue: [^self].
	head := 'doit
'.
	term := '
' , '%
'.
	lf := Character lf.

	"Determine the dictionary name to use"
	nm := dictName.
	1 to: order size
		do:
			[:j |
			class := order at: j.
			class fileOutPreClassOn: stream.
			stream
				nextPutAll: head;
				nextPutAll: (class _modifiableDefinitionInDictionary: dict named: nm);
				nextPut: $.;
				nextPutAll: term.
			class fileOutCommentOn: stream].

	"now make non-modifiable classes non-modifiable "
	1 to: order size
		do:
			[:k |
			class := order at: k.
			class isModifiable
				ifFalse:
					[stream
						nextPutAll: head;
						nextPutAll: (dict keyAtValue: class);
						nextPutAll: ' immediateInvariant.';
						nextPutAll: term]].
%

category: 'Fileout Aids'
method: ClassOrganizer
fileOutClassesAndMethodsInDictionary: aSymbolDictionary on: aStream

"Files out all source code for classes in aSymbolDictionary in Topaz filein
 format on aStream."

| order |
order := self determineClassFileoutOrder: aSymbolDictionary.
self fileOutClasses: order on: aStream.
self fileOutMethods: aSymbolDictionary order: order on: aStream.
self fileOutTraits: aSymbolDictionary order: order on: aStream
%

category: 'Fileout Aids'
method: ClassOrganizer
fileOutMethods: classdict order: order on: stream

"File out each class's code and embedded classes."

| class |
classdict size == 0 ifTrue: [ ^self ].
"put the class dictionary in the temporary symbol list so it will be used for
  name resolution during method fileout"
1 to: order size do: [:l |
  class := order at: l.
  class fileOutCategoriesOn: stream.
].
%

category: 'Fileout Aids'
method: ClassOrganizer
fileOutOtherMethods: methodInfo on: stream

"Files out a set of methods on the given stream/file.  methodInfo must be an
 Array of pairs: #(class selector)."

| pair sz |
(sz := methodInfo size) > 0 ifTrue:[
  stream nextPutAll:'set compile_env: 0'; lf .
  1 to: sz do: [:i |
    pair := methodInfo at: i.
    "use the fileOutMethod: version here so the category will be included"
    (pair at: 1) fileOutMethod: (pair at: 2) on: stream .
  ].
].
%

category: 'Fileout Aids'
method: ClassOrganizer
fileOutTraitDefinitions: order on: stream

"Writes out code in topaz filein format on the given stream, that creates the
 given traits.  order arg is an array of traits."

	1 to: order size
		do:
			[:j | | trait |
			trait := order at: j.
			trait fileOutTraitOn: stream.
            ].
%

category: 'Fileout Aids'
method: ClassOrganizer
fileOutTraits: classdict order: order on: stream

"File out each class's trait registrations."

| class |
classdict size == 0 ifTrue: [ ^self ].
"put the class dictionary in the temporary symbol list so it will be used for
  name resolution during method fileout"
1 to: order size do: [:l |
  class := order at: l.
  class fileOutTraitsOn: stream.
].
%

category: 'Fileout Aids'
method: ClassOrganizer
fileOutTraitsClassesAndMethodsInDictionary: aSymbolDictionary on: aStream

"Files out all source code for classes in aSymbolDictionary in Topaz filein
 format on aStream."

| traitsOrder order |
traitsOrder := self determineTraitFileoutOrder: aSymbolDictionary.
self fileOutTraitDefinitions: traitsOrder on: aStream.
order := self determineClassFileoutOrder: aSymbolDictionary.
self fileOutClasses: order on: aStream.
self fileOutMethods: aSymbolDictionary order: order on: aStream.
self fileOutTraits: aSymbolDictionary order: order on: aStream
%

category: 'Accessing'
method: ClassOrganizer
hierarchy

"Returns an IdentityDictionary which is the value of the instance variable 'hierarchy'.
 In this dictionary the value for key #nil is the list of classes whose superclass is nil.
 Otherwise all keys in the dictionary are classes. "

^hierarchy
%

category: 'Reports'
method: ClassOrganizer
hierarchyReport

"Returns a String that is a class hierarchy report for all classes
 known to the receiver."

| report |
report := String new .
self _hierarchyReportForClass: Object indent: '' report: report withOops: false.
rootClass == Object ifTrue:[ | cset |
  cset := self subclassesOf: #nil .
  cset remove: Object .
  cset do:[: aCls |
    self _hierarchyReportForClass: aCls indent: '' report: report withOops: false .
  ].
].
^ report
%

category: 'Queries'
method: ClassOrganizer
implementorsOf: aSelector

"Returns a collection of GsNMethods that implement the given selector."

^self implementorsOf: aSelector in: classes
%

category: 'Queries'
method: ClassOrganizer
implementorsOf: aSelector in: aclassSet

"Returns a collection of GsNMethods that implement the given selector, limited to
 classes in aclassSet. Does not distinguish between class and instance methods; the
 elements in aclassSet are expected to be classes, not metaclasses ."

| result cset methsSet env |

methsSet := IdentitySet new .
result := { } .
cset := self sortClasses: aclassSet .
env := self environmentId .
1 to: cset size do: [ :j | | cls mDict meth |
  2 timesRepeat:[
    cls ifNil:[ cls := cset at: j ] ifNotNil:[ cls := cls class].
    mDict := cls _fullMethodDictEnv: env . "only env 0 includes GsPackagePolicy"
    meth := mDict at: aSelector otherwise: nil .
    meth ifNotNil: [ (methsSet _addIfAbsent: meth) ifTrue:[ result add: meth ]].
  ].
].
^result
%

category: 'Reports'
method: ClassOrganizer
implementorsOfByCategoryReport: aSelector
 "Returns a String describing the methods that are implementors of the specified
  selector, sorted into method categories"

  ^ self _asCategoriesReportString: (self implementorsOf: aSelector)
%

category: 'Reports'
method: ClassOrganizer
implementorsOfReport: aSelector

"Returns a String describing the methods that are implementors of the specified
 selector."

^ self _asReportString: (self implementorsOf: aSelector) indent: ''
%

category: 'Report Shortcuts'
method: ClassOrganizer
impls: aSelector
  "a variant of implementorsOfReport: easier to type when using topaz ."
  ^ self implementorsOfReport: aSelector
%

category: 'Report Shortcuts'
method: ClassOrganizer
implsC: aSelector
  "shortcut method for implementorsOfByCategoryReport:"
  ^ self _asCategoriesReportString: (self implementorsOf: aSelector)
%

category: 'Accessing'
method: ClassOrganizer
includeDeprecatedMethodsInReports

  ^ (self dynamicInstVarAt: #includeDeprecated) ~~ false
%

category: 'Updating'
method: ClassOrganizer
includeDeprecatedMethodsInReports: aBoolean

  "Controls output from the various Report methods which use
   _asReportString:  ,  such as sendersOfReport: .
  An argument of false will cause the reports to omit deprecated methods."

  self dynamicInstVarAt: #includeDeprecated put: aBoolean .
%

category: 'Accessing'
method: ClassOrganizer
includeMethodOops
  ^ (self dynamicInstVarAt: #methodOops) == true
%

category: 'Updating'
method: ClassOrganizer
includeMethodOops: aBoolean
  ^ self dynamicInstVarAt: #methodOops put: aBoolean .
%

category: 'Reports'
method: ClassOrganizer
literalsReport: aLiteral

"Returns a String describing the methods whose source contains
 a literal reference to the specified literal.
 The argument may be any object that is legal as a literal,
 including a String, Symbol, Number, Array, Boolean, nil.
 If aLiteral is a SymbolAssociation,
 references to either aLiteral or (aLiteral value) will be returned.
 "

^ self _asReportString:
      ((self _referencesToLiteral: aLiteral in: classes withOffsets:false ) at: 1)
%

category: 'Modifying Classes'
method: ClassOrganizer
makeInstancesNonPersistent: aClass

"Recursively make aClass and all subclasses non-persistent.

 If an error occurs, the session will be unable to commit and
 must logout/login before commits are allowed again."

<primitive: 2001>
| prot |
prot := System _protectedMode .
[
  aClass instancesNonPersistent ifFalse:[ | success |
    [ | subCs |
      success := false .
      aClass _makeInstancesNonPersistent .
      subCs := self subclassesOf: aClass .
      subCs do:[ :aSubcls |
	self makeInstancesNonPersistent: aSubcls .
      ].
      success := true .
    ] ensure:[
      success ifFalse:[ System _disallowCommitClassModFailure ].
    ]
  ].
] ensure:[
  prot _leaveProtectedMode
]
%

category: 'Modifying Classes'
method: ClassOrganizer
makeInstancesPersistent: aClass

"Recursively make aClass and all subclasses persistable.

 If an error occurs, the session will be unable to commit and
 must logout/login before commits are allowed again."

<primitive: 2001>
| prot |
prot := System _protectedMode .
[
  aClass instancesNonPersistent ifTrue:[ | success |
    [ | subCs |
      success := false .
      aClass _makeInstancesPersistent .
      subCs := self subclassesOf: aClass .
      subCs do:[ :aSubcls |
	self makeInstancesPersistent: aSubcls .
      ].
      success := true .
    ] ensure:[
      success ifFalse:[ System _disallowCommitClassModFailure ].
    ]
  ].
] ensure:[
  prot _leaveProtectedMode
]
%

category: 'Reports'
method: ClassOrganizer
methodCategories
  "Returns a String containing a report of all the method categories"
| report cats |
cats := SortedCollection withAll: self _methodCategories .
report := String new.
cats do:[ :aCateg| report add: aCateg ; lf ].
^ report
%

category: 'Reports'
method: ClassOrganizer
methodsInCategory: aString
  "Return a String containing a report of all methods in the specified category"
| sym |
sym := Symbol _existingWithAll: aString .
sym ifNil:[ ^ '' ].
^ self _asReportString:( self _methodsInCategory: [:categ| sym == categ])
%

category: 'Private'
method: ClassOrganizer
methodsInCategoryMatching: aSubString
  "Return a String containing a report of all methods whose category
   includes aSubString (case-insenitive)"
  | ucStr |
  ucStr := aSubString asUppercase .
^ self _asReportString:(
    self _methodsInCategory: [:categ | categ asUppercase includesString: ucStr ])
%

category: 'Report Shortcuts'
method: ClassOrganizer
methsInCat: aString
  "Convenience method to access methodsInCategory:, returning a String containing
  a report of all methods in the specified category"

^ self methodsInCategory: aString
%

category: 'Queries'
method: ClassOrganizer
nonOptimizedSendersOf: aSelector

^ self _sendersOf: aSelector in: classes includeOptimized: false
%

category: 'Reports'
method: ClassOrganizer
nonOptimizedSendersOfReport: aSelector

"Returns a String describing the methods that are senders of the specified
 selector."

^ self _asReportString: ((self nonOptimizedSendersOf: aSelector) at:1 )
%

category: 'Reports'
method: ClassOrganizer
packageSendersOfReport: aSelector
  "Returns a String describing the methods that are senders of the
   specified selector, and for which the methods' category begins with '*' "

^ self _asReportString:(
  ((self sendersOf: aSelector) at:1 ) select:[ :meth |
       ((meth inClass categoryOfSelector: meth selector ) at: 1) == $*  ])
%

category: 'Report Shortcuts'
method: ClassOrganizer
pkgsends: aSelector
"Convenience shortcut to access packageSendersOfReport:"

  ^ self packageSendersOfReport: aSelector
%

category: 'Private'
method: ClassOrganizer
rebuildCategories

| cls arr cat catd theClasses |

   "gemstone64,  changed categories from a SymbolDictionary
    to a StringKeyValueDictionary to avoid unnecessary symbol creation"

catd := StringKeyValueDictionary new.
categories := catd .
theClasses := classes .
1 to: theClasses size do: [:i |
  cls := theClasses _at: i.
  cat := cls category.
  arr := catd at: cat otherwise: nil.
  arr ifNil: [
    arr := { }.
    catd at: cat put: arr
  ].
  arr add: cls
].
%

category: 'Private'
method: ClassOrganizer
rebuildHierarchy

"Builds an IdentityDictionary containing all classes as keys and ClassSets of
 their subclasses as values.  As a side-effect, the classes collection is
 expanded to include any superclasses that aren't in the user's name space."

| hier supers each sup c symList |

hier := IdentityDictionary new.
hier at: #nil put: ClassSet new .
supers := ClassSet new.
symList := (self dynamicInstVarAt: #restrictedSymbolList) ifNotNil:[ user ].

"add each class to its superclass's subclass set"
1 to: classes size do: [:i |
  each := classes _at: i.
  sup := self _superClass: each .
	"if not using a restricted symbolList, keep track of superclasses that aren't in the class set"
  (sup ~~ #nil and:[ symList ~~ nil ]) ifTrue:[ 
    (symList resolveSymbol: sup name) ifNil:[ sup := #nil ].
  ].
  sup ~~ #nil ifTrue:[ | aCls |
    aCls := sup .
    [aCls == #nil or:[ classes includesIdentical: aCls]] whileFalse:[
      supers add: aCls .
      aCls := self _superClass: aCls .
      aCls ifNil:[ aCls := #nil ].
    ].
    (c := hier at: sup otherwise: nil) ifNil: [
      c := ClassSet new.
      hier at: sup put: c.
    ].
    c add: each
  ] ifFalse:[
    (hier at: #nil) add: each
  ].
].

"get rid of superclasses that have already been processed"
supers := supers - classes.

"complete the class hierarchies for superclasses that weren't in the
  initial set of classes"
1 to: supers size do: [:i |
  each := supers _at: i.
  sup := self _superClass: each .
  (c := hier at: sup otherwise: nil) ifNil: [
    c := ClassSet new.
    hier at: sup put: c.
  ].
  c add: each
].

classes := classes + supers.
hierarchy := hier
%

category: 'Updating'
method: ClassOrganizer
recategorize: class to: newCategory

"Move the class from its present category to the given category."

| oldcat oldlist newlist idx |
oldcat := class category.
class category: newCategory.
oldlist := categories at: oldcat otherwise: nil.
oldlist ifNotNil: [
  idx := oldlist indexOf: class.
  idx > 0 ifTrue: [
    oldlist removeFrom: idx to: idx
  ]
].
newlist := categories at: newCategory otherwise: nil.
newlist ifNil: [
  categories at: newCategory put: { class }
] ifNotNil: [
  newlist add: class
]
%

category: 'Queries'
method: ClassOrganizer
referencesTo: aSymbol

"Returns an Array of two sequenceable collections.  The first contains
 GsNMethods that refer to the given symbol, and the second contains
 corresponding indexes into sourceStrings where the first reference takes
 place."

^self referencesTo: aSymbol in: classes
%

category: 'Queries'
method: ClassOrganizer
referencesTo: aSymbol in: aclassSet

"Returns an Array of two sequenceable collections.  The first contains
 GsNMethods that reference the given symbol as a literal,
 and the second contains corresponding indexes into sourceStrings where
 the first such reference takes place."

| result resulti cset cls methsSet sym val env |

methsSet := IdentitySet new .
result := { } .
resulti := { } .
sym := Symbol _existingWithAll: aSymbol .
sym ifNotNil:[
  env := self environmentId .
  (GsCurrentSession currentSession resolveSymbol: sym) ifNotNil:[:assoc|
    assoc isInvariant ifTrue:[
      val := assoc _value "pick up optimized literals when searching"
    ] .
  ].
  cset := self sortClasses: aclassSet .
  1 to: cset size do: [ :i |
    cls := cset at: i.
    2 timesRepeat:[ | mDict |
      mDict := cls _fullMethodDictEnv: env .
      mDict valuesDo:[ :method |
	(method _literalsIncludesSymbol: sym value: val ) ifTrue:[
	   (methsSet _addIfAbsent: method) ifTrue:[
	     result add: method.
	     resulti add: (method sourceString findString: sym  startingAt: 1)
	   ].
	 ].
      ].
      cls := cls class .
    ].
  ].
].
^{ result . resulti }
%

category: 'Queries'
method: ClassOrganizer
referencesToLiteral: aLiteral
  "Returns an Array of two Arrays.  The first subarray contains GsNMethods
 that reference given literal.  The second subarray contains indexes where the
 first reference to the literal occurs within the sourceString of the method."

  ^ self referencesToLiteral: aLiteral in: classes
%

category: 'Queries'
method: ClassOrganizer
referencesToLiteral: aLiteral in: aclassSet
  "Returns an Array of two Arrays.  The first subarray contains GsNMethods
 that reference given literal.  The second subarray contains indexes where the
 first reference to the literal occurs within the sourceString of the method.
 Results are limited to classes in aclassSet. The elements in aclassSet are
 expected to be classes, not metaclasses .
 If aLiteral is an invariant SymbolAssociation,
 references to either aLiteral or (aLiteral value) will be returned."

 ^ self _referencesToLiteral: aLiteral in: aclassSet withOffsets: true
%

category: 'Queries'
method: ClassOrganizer
referencesToObject: anObject

"Returns an Array of GsNMethods that reference the given object
 (through a variable binding)"

^self referencesToObject: anObject in: classes
%

category: 'Queries'
method: ClassOrganizer
referencesToObject: anObject in: aclassSet

"Returns an Array of GsNMethods that reference the given object
 (through a variable binding). Results are limited to classes in aclassSet.
 The elements in aclassSet are expected to be classes, not metaclasses."

| result cset cls env |

result := { } .
env := self environmentId .
cset := self sortClasses: aclassSet .
1 to: cset size do: [ :i |
  cls := cset at: i.
  2 timesRepeat:[ | mDict |
    mDict := cls _fullMethodDictEnv: env .
    mDict valuesDo:[ :method |
        (method _literalsIncludesValue: anObject) ifTrue:[
           result add: method
        ].
    ].
    cls := cls class .
  ].
].
^result
%

category: 'Accessing'
method: ClassOrganizer
rootClass

"Returns the root class for this organizer."

^rootClass
%

category: 'Updating'
method: ClassOrganizer
rootClass: aClass

"Sets the root class of the receiver's hierarchy.  Not generally a useful
 thing to do."

rootClass := aClass
%

category: 'Queries'
method: ClassOrganizer
searchForCategory: catname in: classSet

  "Returns a collection of GsNMethods in the given category."
| result cset catSym envId |
result := { } .
envId := 0 .
catname _validateByteClass: CharacterCollection.
catSym := Symbol _existingWithAll: catname .
catSym ifNil:[ ^ result ].
cset := self sortClasses: classSet .
1 to: cset size do: [ :j |
  { cset at: j . (cset at: j) class } do: [ :cls | | mdict |
    cls categorysDo:[ :cat :selectors |
      cat == catSym ifTrue:[
	mdict := cls methodDictForEnv: envId .
	selectors do: [ :selector | | method |
	  (method := mdict at: selector otherwise: nil) ifNil:[ |emsg|
            emsg := 'Missing method ' , selector quoted ,
			 ' in category ' , catSym , ' in class ' , cls name.
            [
	      self notify: emsg   "notify: only available with Seaside/Ruby"
            ] onSynchronous: MessageNotUnderstood do:[:ex |
              self error: emsg
            ].
	  ] ifNotNil: [
	    result add: method
	  ].
	].
      ].
    ].
  ].
].
^result
%

category: 'Queries'
method: ClassOrganizer
sendersOf: aSelector

"Returns an Array of two Arrays.  The first subarray contains GsNMethods
 that send the given selector.  For non-optimized selectors,
 the second subarray contains indexes where the first use of the
 selector occurs within the sourceString of the method."

^self sendersOf: aSelector in: classes
%

category: 'Report Shortcuts'
method: ClassOrganizer
sendersOf: aSelector in: aclassSet

"Returns an Array of two Arrays.  The first subarray contains GsNMethods
 that send the given selector.

 For non-optimized selectors, the second subarray contains indexes where
 the first use of the selector occurs within the sourceString of the method.

 Results are limited to classes in aclassSet. The elements in aclassSet are
 expected to be classes, not metaclasses ."

^ self _sendersOf: aSelector in: aclassSet includeOptimized: true
%

category: 'Reports'
method: ClassOrganizer
sendersOfByCategoryReport: aSelector
  "Return a String describing the methods that send the given selector,
   sorted into method categories."

  ^ self _asCategoriesReportString: ((self sendersOf: aSelector) at:1 )
%

category: 'Reports'
method: ClassOrganizer
sendersOfReport: aSelector

"Returns a String describing the methods that are senders of the specified
 selector."

^ self _asReportString: ((self sendersOf: aSelector) at:1 )
%

category: 'Report Shortcuts'
method: ClassOrganizer
sends: aSelector
  "a variant of sendersOfReport: easier to type when using topaz ."
  ^ self sendersOfReport: aSelector
%

category: 'Report Shortcuts'
method: ClassOrganizer
sendsC: aSelector
  "convenience method for sendersOfByCategoryReport, returning a string
   with methods that send the argument, sorted by method categories"
  ^ self sendersOfByCategoryReport: aSelector
%

category: 'Report Shortcuts'
method: ClassOrganizer
sendsNotImpl
"A convenience shortcut for sentButNotImplementedReport "

 ^ self sentButNotImplementedReport
%

category: 'Queries'
method: ClassOrganizer
sentButNotImplemented
 "Returns an Array of selectors which are sent but not implemented"

  | sent implemented env |
  sent := IdentitySet new.
  implemented := IdentitySet new .
  env := self environmentId .
  classes do:[ :aClass | | cls |
    cls := aClass .
    2 timesRepeat:[ | mDict |
      mDict := cls _fullMethodDictEnv: env .
      mDict valuesDo:[ :method |
        implemented add:  method selector .
        sent addAll:  method _selectorPool
      ].
      cls := cls class .
    ].
  ].
  ^ Array withAll:( SortedCollection withAll: (sent - implemented))
%

category: 'Reports'
method: ClassOrganizer
sentButNotImplementedReport
  "Returns a report of selectors sent but not implemented."
  | report LF |
  report := String new .
  LF := Character lf .
  self sentButNotImplemented do:[:sel | | methsRpt |
    report addAll: sel ; add: LF  .
    methsRpt := self _asReportString:((self sendersOf: sel) at:1) indent: '   '.
    methsRpt size > 0
      ifTrue:[  report addAll: methsRpt ]
      ifFalse:[ report addAll: '   <no sender methods found>'; add: LF ].
  ].
  ^ report
%

category: 'Private'
method: ClassOrganizer
sortClasses: aCollection

 ^ SortedCollection withAll: aCollection
    sortBlock:[:x :y | x name <= y name ]
%

category: 'Report Shortcuts'
method: ClassOrganizer
strings: aString

"A variant of substringReport:  . Used by topaz <= v3.5 " 

^ self substringReport: aString
%

category: 'Report Shortcuts'
method: ClassOrganizer
stringsC: aString

"Shortcut method for substringByCategoryReport:"

^self substringByCategoryReport: aString
%

category: 'Report Shortcuts'
method: ClassOrganizer
stringsIc: aString

"Used by topaz <= v3.5"

^ self substringIgnoreCaseReport: aString
%

category: 'Report Shortcuts'
method: ClassOrganizer
stringsIcC: aString

"Shortcut method for substringIgnoreCaseByCategoryReport:"

^ self substringIgnoreCaseByCategoryReport: aString
%

category: 'Reports'
method: ClassOrganizer
stringsReport: aString ignoreCase: icBool includeClassComments: commentsBool
 "used by topaz"

  | arr rpt |
  arr := self _substringSearch: aString in: classes ignoreCase: icBool . 
  rpt := self _asReportString: (arr at: 1 ).
  commentsBool ifTrue:[
    (arr at: 3) do:[:cls |  rpt add: cls name ; add:' comment' ; lf ].
  ].
  ^ rpt 
%

category: 'Queries'
method: ClassOrganizer
subclassesOf: aClass

"Returns a copy of the set of subclasses for the given class.
 Generates an error if the receiver does not hold the given class."

| s |
classes ifNil: [
  self updateClassInfo
].
aClass ifNil:[
  ^ (hierarchy at: #nil otherwise: nil)
      ifNotNil:[ :aSet | aSet copy ] ifNil:[ ClassSet new ]
].
(s := hierarchy at: aClass otherwise: nil) ifNil:[
  (rootClass == Object or: [aClass isSubclassOf: rootClass]) ifTrue: [
    self addClass: aClass .
    (classes includesIdentical: aClass) ifFalse:[
      Error signal:'add class failed'.
    ].
    s := hierarchy at: aClass otherwise: nil .
  ].
].
^ s ifNotNil:[ s copy ] ifNil:[ ClassSet new ]
%

category: 'Reports'
method: ClassOrganizer
subclassesReport: aClass

 "Return a String listing all subclasses of aClass, sorted by name, each class
  on a line."

  ^ self subclassesReport: aClass includeOops: false
%

category: 'Reports'
method: ClassOrganizer
subclassesReport: aClass includeOops: withOopsBool

 "Return a String listing all subclasses of aClass, sorted by name, each class
  on a line.  If withOopsBool is true, include the oop of the class"

 | sorted str |
 sorted := self sortClasses: (self subclassesOf: aClass) .
 str := String new .
 sorted do:[ :cls |
   str add: cls name .
   withOopsBool ifTrue:[ str add: '   '; add: cls asOop asString ].
   str lf .
 ].
 ^ str
%

category: 'Reports'
method: ClassOrganizer
subhierarchyReport: aClass includeOops: withOopsBool
| r |
r := String new .
self _hierarchyReportForClass: aClass indent: '' report: r withOops: withOopsBool
	withInstvars: true .
^ r
%

category: 'Reports'
method: ClassOrganizer
substringByCategoryReport: aString

"Return a string containing the methods that include the given string, case
  senstitive, sorted into method categories."

^ self _asCategoriesReportString:
      ((self _substringSearch: aString in: classes ignoreCase: false) at: 1)
%

category: 'Reports'
method: ClassOrganizer
substringIgnoreCaseByCategoryReport: aString

"Returns a String describing the methods whose source contains
 the specified string, ignoring case. The methods are sorted into
 method categories"

^ self _asCategoriesReportString:
      ((self _substringSearch: aString in: classes ignoreCase: true) at: 1)
%

category: 'Reports'
method: ClassOrganizer
substringIgnoreCaseReport: aString

"Returns a String describing the methods whose source contains
 the specified string, ignoring case."

^ self _asReportString:
      ((self _substringSearch: aString in: classes ignoreCase: true) at: 1)
%

category: 'Reports'
method: ClassOrganizer
substringReport: aString

"Returns a String describing the methods whose source contains
 the specified string ."

^ self _asReportString:
      ((self _substringSearch: aString in: classes ignoreCase: false) at: 1)
%

category: 'Queries'
method: ClassOrganizer
substringSearch: aString

 "Search for methods and class comments that include the given substring. 
  Search is case senstive.  

  Returns an Array of three Arrays.  The first subarray contains GsNMethods
  whose sources include the given substring.  The second subarray contains
  indexes where the first occurrence of the substring was found. The third
  array includes classes, for which the result of executing aClass comment
  contains the specified string."

^self substringSearch: aString in: classes
%

category: 'Queries'
method: ClassOrganizer
substringSearch: aString ignoreCase: ignoreCase

 "Search for methods and class comments that include the given substring.  
  Search is case insensitive or case sensitive, depending on ignoreCase. 

  Returns an Array of three Arrays.  The first subarray contains GsNMethods
  whose sources include the given substring.  The second subarray contains
  indexes where the first occurrence of the substring was found. The third
  array includes classes, for which the result of executing aClass comment 
  contains the specified string."

^ self _substringSearch: aString in: classes ignoreCase: ignoreCase
%

category: 'Queries'
method: ClassOrganizer
substringSearch: aString in: aclassSet

 "Search for methods and class comments within the given set of classes that 
  include the given substring. Search is case senstive.  

  Returns an Array of three Arrays.  The first subarray contains GsNMethods
  whose sources include the given substring.  The second subarray contains
  indexes where the first occurrence of the substring was found. The third
  array includes classes, for which the result of executing aClass comment
  contains the specified string.

  Results are limited to classes in <aclassSet>. The elements in <aclassSet>
  are expected to be classes, not metaclasses."

^ self substringSearch: aString in: aclassSet ignoreCase: false
%

category: 'Queries'
method: ClassOrganizer
substringSearch: aString in: aclassSet ignoreCase: ignoreCase

 "Search for methods and class Comments within the given set of classes that 
  include the given substring. Search is case insensitive or case sensitive, 
  depending on ignoreCase. 

  Returns an Array of three Arrays.  The first subarray contains GsNMethods
  whose sources include the given substring.  The second subarray contains
  indexes where the first occurrence of the substring was found. The third
  array includes classes, for which the result of executing aClass comment
  contains the specified string.

  Results are limited to classes in <aclassSet>. The elements in <aclassSet> 
  are expected to be classes, not metaclasses."

^ self _substringSearch: aString in: aclassSet ignoreCase: ignoreCase
%

category: 'Accessing'
method: ClassOrganizer
symbolList
  "Returns the symbolList used by the receiver"
  ^ user ifNil: [ GsCurrentSession currentSession symbolList ]
%

category: 'Reports'
method: ClassOrganizer
traitImplementorsOfReport: aSelector
	"Returns a String describing the methods that are implementors of the specified
 selector in Traits."

	| result LF arr selector |
	selector := aSelector asSymbol.
	LF := Character lf.
	arr := SortedCollection new.
	self traits
		do: [ :aTrait | 
			| str name |
			name := aTrait name.
			(aTrait localSelectors includes: selector)
				ifTrue: [ 
					str := String withAll: name.
					str
						addAll: ' >> ';
						addAll: selector.
					arr add: str ].
			(aTrait classTrait localSelectors includes: selector)
				ifTrue: [ 
					str := String withAll: name , ' classTrait'.
					str
						addAll: ' >> ';
						addAll: selector.
					arr add: str ] ].
	result := String new.
	1 to: arr size do: [ :j | 
		result
			add: (arr at: j);
			add: LF ].
	^ result
%

category: 'Accessing'
method: ClassOrganizer
traits
  "Returns the list of Traits found by the receiver during the class scan "
  ^ self dynamicInstVarAt: #traits
%

category: 'Accessing'
method: ClassOrganizer
traits: aSet
  "Sets the list of Traits found by the receiver during the class scan "
  ^ self dynamicInstVarAt: #traits put: aSet
%

category: 'Reports'
method: ClassOrganizer
traitStringsReport: aString ignoreCase: icBool includeTraitComments: commentsBool
	"used by topaz"

	| arr rpt sorted |
	arr := self _traitSubstringSearch: aString in: self traits ignoreCase: icBool.
	sorted := SortedCollection withAll: (arr at: 1).
	rpt := String new.
	1 to: sorted size do: [ :j | 
		rpt
			add: (sorted at: j);
			lf ].
	commentsBool
		ifTrue: [ 
			(arr at: 3)
				do: [ :cls | 
					rpt
						add: cls name;
						add: ' comment';
						lf ] ].
	^ rpt
%

category: 'Class Collection'
method: ClassOrganizer
update

"Causes the receiver to rescan for classes and rebuild internal
 structures.  Synonymous with updateClassInfo."

self updateClassInfo
%

category: 'Class Collection'
method: ClassOrganizer
updateClassInfo

"Causes the receiver to rescan for classes and rebuild internal structures."

self collectClasses; "find all visible classes"
    rebuildHierarchy; "build the hierarchy, fleshing out class set too"
    collectClassNames; "pull out the names of the classes and form auto-complete set"
    rebuildCategories "build the class categories"
%

category: 'Private'
method: ClassOrganizer
_asCategoriesReportString: anArray
"Returns a String. The result is sorted by method categories"
| lf dict cats rpt |
lf := Character lf .
dict := Dictionary new .
1 to: anArray size do:[:j | | aMeth str cls sel cat arr |
  aMeth := anArray at: j .
  cls := aMeth inClass .
  sel := aMeth selector .
  str := String withAll: cls name .
  str addAll: ' >> ' ; addAll: sel .
  cat := cls categoryOfSelector: sel environmentId: aMeth environmentId .
  arr := (dict at: cat otherwise: nil ) ifNil:[ dict at: cat put: { } ].
  arr add: str .
].
cats := SortedCollection sortBlock:[ :x :y | x key <= y key ].
dict associationsDo:[:assoc | cats add: assoc ].
rpt := String new .
cats do:[:assoc | | arr |
  rpt add: assoc key ; add: lf .
  arr := SortedCollection withAll: assoc value .
  1 to: arr size do:[:j |
    rpt add: '   '; add:(arr at:j) ; add: lf
  ].
].
^ rpt
%

category: 'Private'
method: ClassOrganizer
_asReportString: anArray
  ^ self _asReportString: anArray indent: ''
%

category: 'Private'
method: ClassOrganizer
_asReportString: anArray indent: indentString
"Returns a String, one line per method in anArray."
| result LF arr deprecSet numDeprecated includeOops |
numDeprecated := 0 .
self includeDeprecatedMethodsInReports ifFalse:[
  deprecSet := Object _selectorsInBaseCategory:#'Deprecated Notification' .
].
arr := SortedCollection new .
LF := Character lf .
includeOops := self includeMethodOops .
1 to: anArray size do:[:j | | aMeth str |
  aMeth := anArray at: j .
  (deprecSet ~~ nil and:[ (aMeth _selectorPool * deprecSet) size ~~ 0]) ifTrue:[
    "the method sends a variant of #deprecated... "
    numDeprecated := numDeprecated + 1 .
  ] ifFalse:[ | cls |
    str := String withAll: (cls := aMeth inClass) name .
    includeOops ifTrue:[
      cls isMeta ifTrue:[ cls := cls thisClass ].
      str add:'  '; add: cls asOop asString
    ].
    str addAll: ' >> ' ; addAll: aMeth selector .
    includeOops ifTrue:[ str add:'   '; add: aMeth asOop asString ].
    arr add: str .
  ].
].
result := String new .
1 to: arr size do:[:j |
  result add: indentString; add:(arr at:j) ; add: LF
].
numDeprecated > 0 ifTrue:[
  result add:'(Omitted ' , numDeprecated asString, ' deprecated methods)'; lf
].
^ result
%

category: 'Private'
method: ClassOrganizer
_build
  self collectClassesFromSymbolList: user"the symbolList" .
  self rebuildHierarchy .
  "self collectClassNames . " "AutoCompleter is built only on demand"
  self rebuildCategories .
%

category: 'Private'
method: ClassOrganizer
_hierarchyIvReport: aClass
| str |
str := String new .
self _hierarchyIvReportForClass: aClass indent: '' report: str .
^ str
%

category: 'Private'
method: ClassOrganizer
_hierarchyIvReportForClass: aClass indent: indent report: report
| subClsArray nextIndent ivNames |
report addAll: indent; add: aClass name .
ivNames := aClass _instVarNamesWithSeparator:  ''   .
ivNames size ~~ 0 ifTrue: [ report add: $(; add: ivNames ; add: $) ].
report lf .
subClsArray := SortedCollection withAll:
  ((hierarchy at: aClass otherwise: nil) ifNil:[ #( ) ]) .
nextIndent := indent , '  ' .
subClsArray do:[ :aSubCls |
  self _hierarchyIvReportForClass: aSubCls indent: nextIndent report: report
  ].
%

category: 'Private'
method: ClassOrganizer
_hierarchyReportForClass: aClass indent: indent report: report
  "used by GBS"

^ self _hierarchyReportForClass: aClass indent: indent report: report withOops: false
	withInstvars: false

%

category: 'Private'
method: ClassOrganizer
_hierarchyReportForClass: aClass indent: indent report: report withOops: aBool

^ self _hierarchyReportForClass: aClass indent: indent report: report withOops: aBool
        withInstvars: false
%

category: 'Private'
method: ClassOrganizer
_hierarchyReportForClass: aClass indent: indent report: report
withOops: oopsBool withInstvars: ivsBool

| subClsArray nextIndent |
report addAll: indent; add: (aClass name ifNil:[ '(nil name)' ]).
oopsBool ifTrue:[ report add: '   '; add: aClass asOop asString ].
ivsBool ifTrue:[ | ivNames |
  ivNames := aClass _instVarNamesWithSeparator:  ''.
  ivNames size ~~ 0 ifTrue:[ report add: ' ('; add: ivNames; add: $) ].
].
report add: Character lf .
subClsArray := self sortClasses:
  ((hierarchy at: aClass otherwise: nil) ifNil:[ #( ) ]) .
nextIndent := indent , '  ' .
subClsArray do:[ :aSubCls |
  self _hierarchyReportForClass: aSubCls indent: nextIndent
        report: report withOops: oopsBool withInstvars: ivsBool
  ].
%

category: 'Private'
method: ClassOrganizer
_methodCategories
 "Returns an IdentitySet of all method categories"
| set |
set := IdentitySet new .
1 to: classes size do: [ :i |
  1 to: 2 do: [ :which | | cls |
    cls := classes _at: i.
    which == 2 ifTrue: [ cls := cls class ].
    cls categorysDo:[ :aCateg :selectors |  set add: aCateg ].
  ].
].
^ set
%

category: 'Private'
method: ClassOrganizer
_methodsInCategory: aBlock
  "aBlock is a one argument block taking a category as an argument"
| sortedClasses methsSet methsArr cls |
methsSet := IdentitySet new .
methsArr := { } .
sortedClasses := self sortClasses: classes  .
1 to: sortedClasses size do: [ :i |
  1 to: 2 do: [ :which |
    cls := sortedClasses _at: i.
    which == 2 ifTrue: [ cls := cls class ].
    cls  env: 0 categorysDo:[ :categName :sels |
      (aBlock value: categName) ifTrue:[  | mDict |
        mDict := cls _fullMethodDictEnv: self environmentId .
        sels do:[ :aSel | | meth |
          (meth := mDict at: aSel otherwise: nil) ifNotNil:[
             (methsSet _addIfAbsent: meth) ifTrue:[ methsArr add: meth ]
          ].
        ].
      ].
    ].
  ].
].
^ methsArr
%

category: 'Queries'
method: ClassOrganizer
_referencesToLiteral: aLiteral in: aclassSet withOffsets: withOfsBool
 "Returns an Array of two Arrays.  The first subarray contains GsNMethods
 that reference given literal.

 If aLiteral is an invariant SymbolAssociation,
 references to either aLiteral or (aLiteral value) will be returned.

 If withOfsBool==true, The second subarray contains indexes where the
 first reference to the literal occurs within the sourceString of the method."

  | result resulti cset cls methsSet env litString |
  methsSet := IdentitySet new.
  result := {}.
  resulti := {}.
  cset := self sortClasses: aclassSet.
  env := self environmentId .
  litString := aLiteral _isSymbol ifTrue:[ aLiteral ]
           ifFalse:[ (aLiteral isKindOf: Association) ifTrue:[ aLiteral key ]
                             ifFalse:[ aLiteral asString ]].
  1 to: cset size do: [ :i |
    cls := cset at: i.
    2 timesRepeat: [ | mDict |
      mDict := cls _fullMethodDictEnv: env .
      mDict valuesDo: [ :method |
	| found |
	found := false.
	(aLiteral _isSymbol and:[ method _literalsIncludesSymbol: aLiteral value: nil])
	  ifTrue: [ found := true ]
	  ifFalse: [
	    (aLiteral _isSymbol not and:[ method literals _refersToNonSymbolLiteral: aLiteral])
	      ifTrue: [ found := true ]
	      ifFalse: [
		(method pragmas _refersToLiteral: aLiteral)
		  ifTrue: [ found := true ] ] ].
	found
	  ifTrue:[
	    (methsSet _addIfAbsent: method)
	      ifTrue: [
		result add: method.
		withOfsBool ifTrue:[ resulti add:
		    (method sourceString findString: litString startingAt: 1) ] ] ]].
      cls := cls class ] ].
  ^ {result .  resulti}
%

category: 'Queries'
method: ClassOrganizer
_sendersOf: aSelector in: aclassSet includeOptimized: aBoolean

"Returns an Array of two Arrays.  The first subarray contains GsNMethods
 that send the given selector.

 If aBoolean == false, inlined sends of optimized selectors are excluded.

 For non-optimized selectors, the second subarray contains indexes where
 the first use of the selector occurs within the sourceString of the method.

 Results are limited to classes in aclassSet. The elements in aclassSet are
 expected to be classes, not metaclasses ."

| result resulti cset cls aSymbol methsSet optimSels env |

methsSet := IdentitySet new .
result := { } .
resulti := { } .
aSymbol := Symbol _existingWithAll: aSelector .
aSymbol ifNil:[ ^{ result . resulti } ].

(aclassSet isKindOf: ClassSet) ifFalse: [
  cset := ClassSet withAll: aclassSet
] ifTrue: [
  cset := aclassSet
].
aBoolean ifTrue:[
  (optimSels := self dynamicInstVarAt: #optimizedSelectors) ifNil:[
    optimSels := IdentitySet withAll: GsNMethod optimizedSelectors .
    self dynamicInstVarAt: #optimizedSelectors put: optimSels .
  ].
  (optimSels includes: aSymbol) ifTrue:[
    ^ self _referencesToLiteral: aSymbol in: classes withOffsets:false
  ].
].
cset := self sortClasses: cset .
env := self environmentId .
1 to: cset size do: [ :i |
  cls := cset at: i.
  2 timesRepeat:[ | mDict |
    mDict := cls _fullMethodDictEnv: env .
    mDict valuesDo:[ :gsMethod | | srcOffset |
      srcOffset := gsMethod _sourceOffsetOfFirstSendOf: aSymbol .
      srcOffset ifNotNil:[
        (methsSet _addIfAbsent: gsMethod) ifTrue:[
          result add: gsMethod .
          resulti add: srcOffset.
        ].
      ].
    ].
    cls := cls class .
  ].
].
^{ result . resulti }
%

category: 'Private'
method: ClassOrganizer
_substringSearch: aString in: aclassSet ignoreCase: icBoolean
"Returns an Array of three Arrays.  The first subarray contains GsNMethods
 whose sources include the given substring.  The second subarray contains
 indexes where the first occurrence of the substring was found.
 The third subarray contains classes for which the result of   aClass comment 
 contains the specified string "

| meths offsets comments list cls methsSet env |
methsSet := IdentitySet new .
meths := { } .
offsets := { } .
comments := { } .
list := self sortClasses: aclassSet .
env := self environmentId .
1 to: list size do: [ :i |
  cls := list at: i.
  2 timesRepeat:[ | mDict |
    mDict := cls _fullMethodDictEnv: env .
    mDict valuesDo:[ :gsMethod | | index |
        index := gsMethod sourceString _findString: aString startingAt: 1
				      ignoreCase: icBoolean .
        index > 0 ifTrue: [
          (methsSet _addIfAbsent: gsMethod) ifTrue:[
            meths add: gsMethod .
            offsets add: index
          ].
             ].
    ].
    cls := cls class .
  ].
  cls := list at: i .
  (cls _extraDictAt: #comment ) ifNotNil:[:str | | ofs |
     ofs := str _findString: aString startingAt: 1 ignoreCase: icBoolean .
     ofs > 0 ifTrue:[ comments add: cls ].
  ].
].
^{ meths . offsets . comments }
%

category: 'Private'
method: ClassOrganizer
_superClass: aClass

  ^ (aClass superclassForEnv: self environmentId) ifNil:[ #nil ]
%

category: 'Private'
method: ClassOrganizer
_symbolList: aSymbolList
  user := aSymbolList
%

category: 'Private'
method: ClassOrganizer
_traitSubstringSearch: aString in: atraitSet ignoreCase: icBoolean
"Returns an Array of three Arrays.  The first subarray contains method signatures
 whose sources include the given substring.  The second subarray contains
 indexes where the first occurrence of the substring was found.
 The third subarray contains traits for which the result of   aTrait comment 
 contains the specified string "

| methSigs offsets comments list trait methSigsSet qualifier |
methSigsSet := IdentitySet new .
methSigs := { } .
offsets := { } .
comments := { } .
list := self sortClasses: atraitSet .
1 to: list size do: [ :i |
  trait := list at: i.
  qualifier := ''.
  2 timesRepeat: [
     trait localSelectors do:[ :selector | | index |
        index := (trait sourceCodeAt: selector) _findString: aString startingAt: 1
				      ignoreCase: icBoolean .
        index > 0 ifTrue: [
          | methodSignature |
          methodSignature  := String withAll: trait name , qualifier, ' >> ', selector.
          (methSigsSet _addIfAbsent: methodSignature) ifTrue:[
            methSigs add: methodSignature .
            offsets add: index
          ].
             ].
    ].
    trait := trait classTrait .
    qualifier := ' classTrait'.
  ].
  trait := list at: i .
  (trait _extraDictAt: #comment ) ifNotNil:[:str | | ofs |
     ofs := str _findString: aString startingAt: 1 ignoreCase: icBoolean .
     ofs > 0 ifTrue:[ comments add: trait ].
  ].
].
^{ methSigs . offsets . comments }
%

! Class implementation for 'GsBitmap'

!		Class methods for 'GsBitmap'

category: 'Enumerating'
classmethod: GsBitmap
allObjectsExcept: aCollection

"Returns an instance of GsBitmap that contains all objects that exist which are not contained in the objects transitively referenced from <aCollection>. The objects in the result may or may not be live objects (reachable from the repository roots)."

| found |

found := GsBitmap withAll: aCollection.
found := GsBitmap allTransitiveReferences: found.
^ (GsBitmap allValidOops) - found
%

category: 'Enumerating'
classmethod: GsBitmap
allTransitiveReferences: aCollection

"Similar to transitiveReferences:, however the result includes all of the normally hidden interior nodes for large objects. "

| newFound allFound diff |

newFound := GsBitmap withAll: aCollection.
allFound := newFound copy.

[true] whileTrue: [ 
  newFound := newFound allReferencedObjects.
  diff := newFound - allFound.
  allFound addAll: diff.
  newFound := diff.
  diff isEmpty ifTrue: [ ^ allFound ]
  ] 
%

category: 'Enumerating'
classmethod: GsBitmap
allValidOops

"Returns an instance of GsBitmap containing the oops of all valid objects in the repository.  This bitmap only reflects currently committed objects that are not in the process of being garbage collected, i.e, not in the possible dead or deadNotReclaimed sets."

^(GsBitmap new) _1ArgPrim: 11
%

category: 'File Operations'
classmethod: GsBitmap
auditFile: fileName
"Reads the file and counts the number of objects in the file which 
 are no longer valid.  Objects are considered invalid if they no 
 longer exist (i.e., are not present in the shared object table) 
 or present in the dead objects set maintained by stone.

 The session must be in a transaction when this method is invoked.  If the
 session is not in a transaction, an #rtErrPrimOutsideTrans error is raised.

 Returns an Array containing 2 elements 
    1 - a SmallInteger, total number of oops in the file.
    2 - a SmallInteger, number of invalid oops in the file.

 Raises an error if the file could not be opened for reading, the file
 is corrupt, fileName is not an instance of String.
"

 | arr fileInfo |
 fileInfo := GsBitmap fileInfo: fileName.
 arr := Array new.
 arr add: (fileInfo at: 1).
 arr add: (fileInfo at: 4).
 ^ arr
%

category: 'File Operations'
classmethod: GsBitmap
auditPageOrderOopFile: fileName

"Reads the page order oop file and counts the number of
 objects in the file which are no longer valid.  Objects are
 considered invalid if they no longer exist (i.e., are not
 present in the shared object table) or present in the dead objects
 set maintained by stone.

 The session must be in a transaction when this method is invoked.  If the
 session is not in a transaction, an #rtErrPrimOutsideTrans error is raised.

 Returns an Array containing 2 elements 
    1 - a SmallInteger, total number of oops in the file.
    2 - a SmallInteger, number of invalid oops in the file.

 Raises an error if the file could not be opened for reading, the file
 is corrupt, fileName is not an instance of String, or the file is
 not written in page order.
"

 | arr fileInfo |
 fileInfo := GsBitmap fileInfo: fileName.
 (fileInfo at: 2) ifFalse: [
   ArgumentTypeError signal: 'The bitmap file is not written in page order'
   ].
 arr := Array new.
 arr add: (fileInfo at: 1).
 arr add: (fileInfo at: 4).
 ^ arr
 
%

category: 'Instance Creation'
classmethod: GsBitmap
basicNew

"disallowed"

self shouldNotImplement: #basicNew
%

category: 'Debugging'
classmethod: GsBitmap
bitToOop: aSmallInteger
  "For argument that is bit number for a committed non-special object, return
   the oop as a SmallInteger ."
  ^ (aSmallInteger bitShift:  8 ) bitOr: 1 
%

category: 'File Operations'
classmethod: GsBitmap
fileInfo: bitmapFilePath

" Returns an array which contains the following values:
  1.  The number of oops in the file
  2.  True if the file was written in page order.
  3.  The number of valid oops.
  4.  The number of invalid oops (oops that are not allocated or in the
      process of being garbage collected).

  Raises an error if the file could not be opened for reading, the file
  is corrupt, or bitmapFilePath is not an instance of String.
"

^(GsBitmap new) _2ArgPrim: 20 with: bitmapFilePath
%

category: 'Hidden Set Support'
classmethod: GsBitmap
hiddenSetIdAsSymbol: oldHiddenSetId

"Returns the symbol corresponding to the old hiddenSet specifier" 

^ GsBitmap new _2ArgPrim: 19 with: oldHiddenSetId
%

category: 'Hidden Set Support'
classmethod: GsBitmap
hiddenSetSpecifiers

"Returns a list of the hidden set specifiers.

**************************************************************************************************
***** DO NOT CHANGE THE ORDER OF THE ELEMENTS IN THE LIST WITHOUT EDITING CODE IN gsbitmap.c *****
**************************************************************************************************
"

^#(
 #ListInstances
 #SaveNewPomObjs "See method #_enableTraceNewPomObjs"
 #ObjectsRead    "See method #_enableTraceObjectsRead"
 #SaveWriteSetUnion
 #CommitReleaseLocksSet
 #CommitOrAbortReleaseLocksSet
 #StrongReadSet
 #GcCandidates
 #Indexing
 #Conversion
 #WeakReferences
 #ObjInventory
 #Customer1
 #Customer2
 #Customer3
 #Customer4
 #Customer5 "last mutable hiddenSet"

 #RcReadSet
 #DepMapWriteSet
 #PomWriteSet    "Empty except after flush for commit, so only useful
		       after a transaction conflict."
 #RemovedDepMapEntries
 #SaveDepMapChangedUnion
 #ReadWriteConflicts  "StrongRead-Write conflicts "
 #WriteWriteConflicts
 #WriteDependencyConflicts
 #WriteReadLockConflicts
 #WriteWriteLockConflicts
 #AllocatedGciOops
 #ExportedDirtyObjs
 #TrackedDirtyObjs_NotImplemented
 #ReferencedSet
 #WriteLockWriteSubset
 #NewDataPages
 #PreviousWsUnion
 #PureExportSet
 #GciTrackedObjs_NotImplemented
 #NotifySet
)
%

category: 'Instance Creation'
classmethod: GsBitmap
new

"Returns a new empty GsBitmap"

^ self _basicNew _1ArgPrim: 1
%

category: 'Instance Creation'
classmethod: GsBitmap
newForHiddenSet: hiddenSetSpecifier

"Returns a GsBitmap that references the specified hiddenSet."

| gsBitmap idx |
gsBitmap := GsBitmap new.
idx := GsBitmap hiddenSetSpecifiers indexOfIdentical: hiddenSetSpecifier.
idx < 1 ifTrue: [ ^ hiddenSetSpecifier _error: #rtErrInvalidArgument
                              args:{ 'not a valid hiddenSetSpecifier' }] .
gsBitmap _hiddenSetId: idx.
^gsBitmap
%

category: 'File Operations'
classmethod: GsBitmap
numberOfObjectsInPageOrderFile: fileName

"Answer the number of objects in a page order oop file.

 The session must be in a transaction when this method is invoked.  If the
 session is not in a transaction, an #rtErrPrimOutsideTrans error is raised.

 Raises an error if the file could not be opened for reading, the file
 is corrupt, fileName is not an instance of String, or the file is
 not written in page order.
"

| fileInfo |

fileInfo := GsBitmap fileInfo: fileName.
(fileInfo at: 2) ifFalse: [
   ArgumentTypeError signal: 'The bitmap file is not written in page order'
   ].
^ fileInfo at: 1
%

category: 'Debugging'
classmethod: GsBitmap
oopToBit: aSmallInteger
  "For argument that is the oop of a committed non-special object, return
   the bit number."
  (aSmallInteger bitAnd: 16rFF) == 1 ifFalse:[ 
     ArgumentError signal:'argument is oop of a special object'].
  ^ aSmallInteger bitShift: - 8 .
%

category: 'File Operations'
classmethod: GsBitmap
readObjectsFromPageOrderFile: fileName startingAt: startIdx upTo: endIdx

"Reads, validates and returns objects from a page-ordered file.

 startIndex is the index of the first object in the file to be returned.  The first
 object in the file has an index of 1.  It is an error if startIndex is less than 1
 or greater than endIndex.

 endIndex is the index of the last object to return from the file.  endIndex
 must be greater than or equal to startIndex.  endIndex may exceed the index of
 the last object in the file.  In that case, all valid objects from startIndex to the
 end of the file are returned.

 Returns an array containing the valid oops in page order.
 
 Raises an error if the file could not be opened for reading, the file
 is corrupt, fileName is not an instance of String, or the file is
 not written in page order.

 It is possible that one or more object identifiers contained in the file
 are no longer valid due to garbage collection.  Objects which are no longer
 valid have nil stored in their place in the returned array.  Objects that have been
 garbage collected and are in the free oop list or the dead not reclaimed set
 are considered to be invalid.

 The session must be in a transaction when this method is invoked.  If the
 session is not in a transaction, an #rtErrPrimOutsideTrans error is raised.
"

^(GsBitmap new) _readObjectsFromPageOrderFilePrim: fileName startingAt: startIdx upto: endIdx
%

category: 'Enumerating'
classmethod: GsBitmap
transitiveReferences: aCollection

"Returns an instance of GsBitmap that contains all the objects which are transitively referenced from the objects in <aCollection>."

| newFound allFound diff |

newFound := GsBitmap withAll: aCollection.
allFound := newFound copy.

[true] whileTrue: [ 
  newFound := newFound referencedObjects.
  diff := newFound - allFound.
  allFound addAll: diff.
  newFound := diff.
  diff isEmpty ifTrue: [ ^ allFound ]
  ] 
%

category: 'Instance Creation'
classmethod: GsBitmap
with: aValue

"Returns an instance of the receiver containing the argument"

| inst |
inst := self new.
inst add: aValue.
^inst
%

category: 'Instance Creation'
classmethod: GsBitmap
with: aValue with: val2

"Returns an instance of the receiver containing the arguments"

| inst |
inst := self new.
inst add: aValue; add: val2.
^inst
%

category: 'Instance Creation'
classmethod: GsBitmap
with: aValue with: val2 with: val3

"Returns an instance of the receiver containing the arguments"
| inst |
inst := self new.
inst add: aValue; add: val2; add: val3.
^inst
%

category: 'Instance Creation'
classmethod: GsBitmap
with: aValue with: val2 with: val3 with: val4

"Returns an instance of the receiver containing the arguments"
| inst |
inst := self new.
inst add: aValue; add: val2; add: val3; add: val4.
^inst
%

category: 'Instance Creation'
classmethod: GsBitmap
withAll: aCollection

"Returns an instance of the receiver containing the elements of the argument."

| inst |
inst := self new.
aCollection _isArray 
  ifTrue:[ inst addAll: aCollection ]
  ifFalse:[ aCollection do: [ :each | inst add: each ]].
^ inst
%

category: 'Private'
classmethod: GsBitmap
_2ArgPrim: opCode with: arg2
  "opcode  action
   26      clearAllBits  arg2 is hiddenSetId 
  "
  <primitive: 1027>
  opCode _validateClass: SmallInteger.
  self _primitiveFailed: #_2ArgPrim:with: args: { opCode . arg2 }
%

category: 'Private'
classmethod: GsBitmap
_3ArgPrim: opCode with: arg2 with: arg3
 " Functions with the receiver readOnly should be first
  opCode     function
    3         arg2 is hiddenSetId arg3 is oop to add
  "
 <primitive: 1028>
 opCode _validateClass: SmallInteger.
 self _primitiveFailed: #_3ArgPrim:with:with: args: { opCode . arg2 . arg3}
%

category: 'Private'
classmethod: GsBitmap
_basicNew

"creates an instance registered with VM for finalization of cData"

<primitive: 674>
self _primitiveFailed: #_basicNew
%

category: 'Private'
classmethod: GsBitmap
_clearHiddenSetId: hiddenSetId
  self _2ArgPrim: 26 with: hiddenSetId
%

category: 'Private'
classmethod: GsBitmap
_deadNotReclaimed
 "Answer a new GsBitmap that contains the objects identified as dead
  by the last epochGc or markForCollection, and which have not been reclaimed.
  You must disable the reclaim gem before executing this. 
  If no error is signalled may include  System class >> continueTransaction. "

  System reclaimGemSessionCount > 0 ifTrue:[
    Error signal:'reclaimGem must be stopped before using #_deadNotReclaimed'.
  ].
  ^ (GsBitmap new) _1ArgPrim: 14 
%

category: 'Private'
classmethod: GsBitmap
_hiddenSetId: hiddenSetId add: anObject
  "Returns a Boolean, previous state of bit for anObject.
   Does nothing and returns false if anObject is special."
  ^ self _3ArgPrim: 3 with: hiddenSetId with: anObject 
%

category: 'Private'
classmethod: GsBitmap
_initializeSystemHiddenSetIds
  | ary cvName |
  ary := self hiddenSetSpecifiers .
  1 to: ary size  do:[:j | | sym |
    sym := ary at: j .
    cvName := (sym , '_id' ) asSymbol .
    System _addInvariantClassVar: cvName value: j .
    GsFile gciLogServer:'_initializeSystemHiddenSetIds: created ', cvName, ' value ', j asString .
  ].
%

category: 'Instance Creation'
classmethod: GsBitmap
_newForHiddenSetId: hiddenSetId
 "Returns a GsBitmap that references the specified hiddenSet."
  ^ GsBitmap new _hiddenSetId: hiddenSetId; yourself
%

!		Instance methods for 'GsBitmap'

category: 'Set Arithmetic'
method: GsBitmap
* aGsBitmap

"Returns a new GsBitmap with the elements that are in both the receiver and in aGsBitmap.
 Same as inersect:."

^self _2ArgPrim: 16 with: aGsBitmap
%

category: 'Set Arithmetic'
method: GsBitmap
+ aGsBitmap

"Returns a new GsBitmap with the elements that are in the receiver or aGsBitmap.
 Same as union:."

^self _2ArgPrim: 14 with: aGsBitmap
%

category: 'Set Arithmetic'
method: GsBitmap
- aGsBitmap

"Returns a new GsBitmap with the elements in the receiver that are not in aGsBitmap.
 Same as difference:."

^self _2ArgPrim: 15 with: aGsBitmap
%

category: 'Adding'
method: GsBitmap
add: anObject

"Adds a non special object to the GsBitmap.
 Returns anObject."

self _2ArgPrim: 10 with: anObject.
^anObject
%

category: 'Adding'
method: GsBitmap
addAll: anArrayOrGsBitmap

"Adds each element of the Array of non special objects or the contents of a GsBitmap
 to the receiver. Returns an Integer, the number of bits added to the receiver."

(anArrayOrGsBitmap == nil) ifTrue: [ ^anArrayOrGsBitmap ].
^self _2ArgPrim: 11 with: anArrayOrGsBitmap
%

category: 'Enumerating'
method: GsBitmap
allReferencedObjects

"Similar to referencedObjects, returning a new instance of GsBitmap containing the objects directly referenced by the objects in the receiver; but in addition, the result includes all of the normally hidden interior nodes for large objects."

^self _1ArgPrim: 10
%

category: 'Converting'
method: GsBitmap
asArray

"Returns the bits that are set in the GsBitmap as an Array of objects.
 The results is an object in temporary object memory."

^self _1ArgPrim: 4
%

category: 'Converting'
method: GsBitmap
asGsBitmap

^ self
%

category: 'Accessing'
method: GsBitmap
copy

"Returns a new GsBitmap that is a copy of the receiver."

^self _1ArgPrim: 6
%

category: 'Set Arithmetic'
method: GsBitmap
difference: aGsBitmap

"Returns a new GsBitmap with the elements in the receiver that are not in aGsBitmap.
 Same as -."

^self _2ArgPrim: 15 with: aGsBitmap
%

category: 'Enumerating'
method: GsBitmap
do: aBlock

"Executes the one argument block aBlock for each object in
 in the receiver.  Does a non destructive enumerate of the GsBitmap.
 Returns the number of objects enumerated."

 | count arr |
 count := 0.
 arr := Array new.
 arr add: 0.
 [ | n |
   arr := self enumerateWithLimit: 2000 startingAfter: (arr last).
   n := arr size .
   count := count + n .
   1 to: n do:[:j | aBlock value: (arr at: j) ] .
   n ~~ 0 .
 ] whileTrue.
 ^ count
%

category: 'Enumerating'
method: GsBitmap
enumerateAsOopsWithLimit: maxResultSize startingAfter: anOop

"Returns an array containing the first maxResultSize bits as oops
 starting with the first one after the specified oop.
 To start the enumeration use the SmallInteger zero as anOop.
 To get the next batch use the last element of the array returned.

 This enumeration is non destructive, so no values are cleared.

 If the GsBitmap contains fewer than maxResultSize elements after the
 specified object or the maxResultSize has the value 0, then it returns
 all of the elements after the specified object.
"

^self _3ArgPrim: 2 with: maxResultSize with: anOop
%

category: 'Enumerating'
method: GsBitmap
enumerateWithLimit: maxResultSize startingAfter: anObject

"Returns an array containing the first maxResultSize bits as objects
 starting with the first one after the specified object.
 To start the enumeration use the SmallInteger zero as anObject.
 To get the next batch use the last element of the array returned.

 This enumeration is non destructive, so no values are cleared.

 If the GsBitmap contains fewer than maxResultSize elements after the
 specified object or the maxResultSize has the value 0, then it returns
 all of the elements after the specified object.
"

^self _3ArgPrim: 1 with: maxResultSize with: anObject
%

category: 'Testing'
method: GsBitmap
equals: aGsBitmap

"Returns true if the receiver and argument contain exactly the same elements."

^self _2ArgPrim: 4 with: aGsBitmap
%

category: 'Searching'
method: GsBitmap
firstObjectThatReferences: anObject
"Search the receiver to find and return the first object which references anObject.
 Returns nil if no such object was found."

^self _2ArgPrim: 5 with: anObject
%

category: 'Accessing'
method: GsBitmap
hiddenSetName

"Returns the name as a symbol that corresponds to this instance.
 If there is no hidden set reference then it returns the symbol #NotAHiddenSet."

 hiddenSetId == 0 ifTrue: [ ^ #NotAHiddenSet ]
                  ifFalse: [ ^ (GsBitmap hiddenSetSpecifiers) at: hiddenSetId ]
%

category: 'Testing'
method: GsBitmap
includes: anObject

"Returns true if anObject is in the GsBitmap."

^self _2ArgPrim: 1 with: anObject
%

category: 'Set Arithmetic'
method: GsBitmap
intersect: aGsBitmap

"Returns a new GsBitmap with the elements that are in both the receiver and in aGsBitmap.
 Same as *."

^self _2ArgPrim: 16 with: aGsBitmap
%

category: 'Set Arithmetic'
method: GsBitmap
intersectSize: aGsBitmap

"Returns a SmallInteger which is the number of elements present in both the receiver and aGsBitmap."

| result newBm |
newBm := self * aGsBitmap .
result := newBm size.
newBm removeAll .
^ result
%

category: 'Testing'
method: GsBitmap
isEmpty

"Returns true there are no entries in the GsBitmap."

^self size == 0
%

category: 'Peeking'
method: GsBitmap
peek

"Answer the first element in the receiver without removing it, or nil if the receiver is empty."
^ self isEmpty ifTrue:[nil] ifFalse:[ (self peekCount: 1) at: 1]
%

category: 'Peeking'
method: GsBitmap
peekCount: aCount

"Fetches elements from the receiver without removing them.  Returns an Array that contains
 the minimum of aCount or the receiver's size entries."

^self enumerateWithLimit: aCount startingAfter: 0
%

category: 'Peeking'
method: GsBitmap
peekLast

"Answer the last in the receiver without removing it, or nil if the receiver is empty."
^ self isEmpty ifTrue:[nil] ifFalse:[ self _1ArgPrim: 8 ]
%

category: 'Private'
method: GsBitmap
primFirstObjectThatReferences: anObject

"Search the receiver to find and return the first object which references anObject. 
 Returns nil if no such object was found. Similar to the firstObjectThatReferences:
 method except this method may return an internal object as the result"

^self _2ArgPrim: 25 with: anObject
%

category: 'Private'
method: GsBitmap
primReferencedObjects

"Answer a new GsBitmap that contains the committed, non-special objects
referenced by the objects contained in the receiver. Similar to the 
referencedObjects method except this method includes internal objects
in the result, and does not include the entire collection contents
when traversing large objects or NSCs."

^self _1ArgPrim: 12
%

category: 'Formatting'
method: GsBitmap
printOn: aStream

"Puts a displayable representation of the receiver on aStream."

aStream nextPutAll: (self printStringWithMaxSize: 8).
%

category: 'Formatting'
method: GsBitmap
printString

"Returns a String with a displayable representation of the receiver."

^ self printStringWithMaxSize: 1000
%

category: 'Formatting'
method: GsBitmap
printStringWithMaxSize: n

"Returns the contents of the GsBitmap as a string with oops of the
 objects in the bitmap arranged 8 per line.
"
| count result bmSize |

count := 0.
result := String new.
bmSize := self size.
result add: ('GsBitmap contains ' , bmSize asString , ' objects. ' , Character lf).
(bmSize == 0) ifTrue: [ ^ result ].
result add: ('1. ').
self _doAsOops: [ :oop |
  count := count + 1.
  result add: (' ' , oop asString , ' ').
  ((count rem: 8) = 0 and: [count < bmSize]) ifTrue: [
     result add: (' ' , Character lf , (count + 1) asString , '. ').
     (result size > n and: [n ~= 0]) ifTrue: [
       result add: (' ........' , Character lf).
       result add: ( bmSize asString , '. ' , self peekLast asString, Character lf).
       ^ result
     ]
  ]
].
^result
%

category: 'File Operations'
method: GsBitmap
readFromFile: fileName

"Reads the contents of the file and adds the oops in the file to the
 receiver.  If the file doesn't exist or is not in the GsBitmap format,
 then this method returns an error.

 Subsets of the file can be read into a GsBitmap with
         readFromFile:withLimit:startingAt:.

 ObjectIds that are in the freelist or in the deadObjs or possibleDead sets
 are not included.

 Returns the number of objects that were not included.
"

^self _2ArgPrim: 21 with: fileName
%

category: 'File Operations'
method: GsBitmap
readFromFile: aString withLimit: maxResultSize startingAt: startIndex

"Adds the contents of the specified file indexed by the subrange:
 (startingAt, startingAt + maxResultSize).  The resulting GsBitmap
 may contain fewer than maxResultSize elements if the value of
 startingAt + maxResultSize is an index that is larger than the number of
 oops in the file or if some of the ObjectIds represented are no longer
 live objects, i.e., they were found to be in the freeList or the
 deadNotReclaimed or possible dead sets.

 If the file doesn't exist or is not in the GsBitmap format,
 then this method returns an error.

 The first object in the file has an index of 1.  It is an error if
 startIndex is less than 1.

 Returns the number of objects read.
"

<primitive: 1029>
aString _validateClass: String.
maxResultSize _validateClass: SmallInteger.
startIndex _validateClass: SmallInteger.
self _primitiveFailed: #readFromFile:withLimit:startingAt: args: { aString . maxResultSize . startIndex }
%

category: 'Enumerating'
method: GsBitmap
referencedObjects

"Answer a new GsBitmap that contains the committed, non-special objects
referenced by the objects contained in the receiver.  For each object for
which the current user has read authorization, the objects that are directly
referenced structurally by that object (from named instance variables, indexed
or NSC contents, and dynamic instance variables) are included."

^self _1ArgPrim: 9
%

category: 'Removing'
method: GsBitmap
remove: anObject

"Removes anObject from the GsBitmap.
 If the object is not present in the GsBitmap it issues #objErrNotInColl,
 otherwise it returns anObject.
"
(self _2ArgPrim: 12 with: anObject)
    ifFalse: [ self _error: #objErrNotInColl args: { anObject } ].
^anObject
%

category: 'Removing'
method: GsBitmap
remove: anObject ifAbsent: aBlock

"Removes anObject from the receiver.  If anObject is not in the
 receiver, this method evaluates aBlock and returns its value.
 The argument aBlock must be a zero-argument block.
"

(self _2ArgPrim: 12 with: anObject)
    ifFalse: [ ^ aBlock value ].
^anObject
%

category: 'Removing'
method: GsBitmap
removeAll

"Clears all of the bits in the receiver."

^self _1ArgPrim: 2
%

category: 'Removing'
method: GsBitmap
removeAll: anArrayOrGsBitmap

"Removes each element of the Array of non special objects or the contents of a GsBitmap
 from the receiver.  Returns anArrayOrGsBitmap."

^self _2ArgPrim: 13 with: anArrayOrGsBitmap
%

category: 'Removing'
method: GsBitmap
removeCount: maxToRemove
"Removes entries from the receiver, and returns an Array that contains the
 minimum of maxToRemove or the receiver's size entries."

|result|
result := self peekCount: maxToRemove .
self removeAll: result .
^result
%

category: 'Removing'
method: GsBitmap
removeFirst: count

"Remove the first count objects from the receiver and return them in a new GsBitmap.
 Objects are removed from the beginning, going from lowest to highest object ID.
"

| copy |
copy := self copy.
self _removeFirst: count.
^copy removeAll: self
%

category: 'Removing'
method: GsBitmap
removeIfPresent: anObject

"Remove anObject from the receiver.  Returns nil if anObject is
 missing from the receiver, otherwise returns the argument.
"

(self _2ArgPrim: 12 with: anObject)
    ifFalse: [ ^ nil ].
^anObject
%

category: 'Removing'
method: GsBitmap
removeLast: count

"Remove the last count objects from the receiver and return them in a new GsBitmap.
 Objects are removed from the end, going from higest to the lowest object ID.
"

| copy |
copy := self copy.
self _truncateToSize: (self size - count).
^copy removeAll: self
%

category: 'Removing'
method: GsBitmap
removeNext
"Removes the first element from the receiver and returns it.  Returns nil if the receiver is empty."

^ self isEmpty ifTrue:[nil] ifFalse:[ (self removeCount: 1) at: 1]
%

category: 'Testing'
method: GsBitmap
size

"Returns the number of bits that are set in the GsBitmap."

^self _1ArgPrim: 3
%

category: 'Accessing'
method: GsBitmap
sizeInPages

"Returns the number of 16 K pages used to implement the receiver."

^self _1ArgPrim: 7
%

category: 'Set Arithmetic'
method: GsBitmap
union: aGsBitmap

"Returns a new GsBitmap with the elements that are in the receiver or aGsBitmap.
 Same as +."

^self _2ArgPrim: 14 with: aGsBitmap
%

category: 'File Operations'
method: GsBitmap
writeToFile: aString

"Writes the contents of the receiver to the specified file.
 The file created is approximately 5 bytes for each object plus 24 bytes for
 the file header.

 If the file exists an error is returned.

 Returns the number of objectIds written to the file.
"

^self _2ArgPrim: 2 with: aString
%

category: 'File Operations'
method: GsBitmap
writeToFileInPageOrder: aString

"Writes the contents of the receiver to the specified file in pageOrder.

 Operations like instance migration which process a large volume of objects
 often run significantly faster if the objects are processed in batches that
 are in page order rather than in object ID order.

 The file created is approximately 5 bytes for each object plus 24 bytes for
 the file header.

 If the file exists an error is returned.

 Returns the number of objectIds written to the file.
"

^self _2ArgPrim: 3 with: aString
%

category: 'Private'
method: GsBitmap
_1ArgPrim: opCode

"opCode     function
   1        _basicNew
   2        removeAll
   3        size
   4        asArray
   5        asArrayOfOops
   6        copy
   7        sizeInPages
   8        peekLast
   9        referencedObjects
   10       allReferencedObjects
   11       allValidOops
   12       primReferencedObjects
   13       _asArrayOfBits
   14       _deadNotReclaimed
"

<primitive: 1026>
opCode _validateClass: SmallInteger.
self _primitiveFailed: #_1ArgPrim: args: { opCode }
%

category: 'Private'
method: GsBitmap
_2ArgPrim: opCode with: arg2

" Functions with the receiver readOnly should be first
 opCode     function
   1        includes:
   2        writeToFile:
   3        writeToFileInPageOrder:
   4        equals:
   5        firstObjectThatReferences:
   6        _includesBit:

     First mutable opcode
  10        add:         primitive returns the previous state
  11        addAll:
  12        remove:      primitive returns the previous state
  13        removeAll:
  14        union:
  15        difference:
  16        intersect:
  17        truncateToSize:
  18        _removeFirst:
  19        hiddenSetIdAsSymbol:

  20        fileInfo:
  21        readFromFile:
  22        (was auditFile)
  23        _setBits:
  24        _clearBits:
  25        primFirstObjectThatReferences:
"

<primitive: 1027>
opCode _validateClass: SmallInteger.
self _primitiveFailed: #_2ArgPrim:with: args: { opCode . arg2 }
%

category: 'Private'
method: GsBitmap
_3ArgPrim: opCode with: arg2 with: arg3

" Functions with the receiver readOnly should be first
 opCode     function
   1        enumerateWithLimit:startingAfter:
   2        enumerateAsOopsWithLimit:startingAfter:
 "

<primitive: 1028>
opCode _validateClass: SmallInteger.
self _primitiveFailed: #_3ArgPrim:with:with: args: { opCode . arg2 . arg3}
%

category: 'Private'
method: GsBitmap
_asArrayOfBits

"Returns the bits that are set in the GsBitmap as an Array of Integers
 which correspoind to the raw bit numbers in the receiver.
 See also GsBitmap class >> bitToOop: "

^ self _1ArgPrim: 13
%

category: 'Private'
method: GsBitmap
_asArrayOfOops

"Returns the bits that are set in the GsBitmap as an Array of SmallIntegers
 which correspoind to the oops of the persistent objects.
 This method can be used to return the results of a large GsBitmap in 
 an array without faulting all of the objects into memory like asArray does.
 The oops can be used as arguments to   Object class >> objectForOop: ."

^self _1ArgPrim: 5
%

category: 'Private'
method: GsBitmap
_clearBits: anArray

"Clears the bits specified by the Integers in anArray from the receiver.
 Returns the number of bits cleared."

^self _2ArgPrim: 24 with: anArray
%

category: 'Private'
method: GsBitmap
_doAsOops: aBlock

"Executes the one argument block aBlock for each oop in
 in the receiver.  Does a non destructive enumerate of the GsBitmap
 with the argument to the block being anOop.
 Returns the number of objects enumerated."

 | count arr |
 count := 0.
 arr := Array new.
 arr add: 0.
 [ | n |
   arr := self enumerateAsOopsWithLimit: 2000 startingAfter: (arr last).
   n := arr size .
   count := count + n .
   1 to: n do:[:j | aBlock value: (arr at: j) ] .
   n ~~ 0 .
 ] whileTrue.
 ^ count
%

category: 'Private'
method: GsBitmap
_hiddenSetId

^hiddenSetId
%

category: 'Private'
method: GsBitmap
_hiddenSetId: aSmallInt

hiddenSetId := aSmallInt
%

category: 'Private'
method: GsBitmap
_includesBit: aBit

"Returns true if the bit is in the GsBitmap."

^self _2ArgPrim: 6 with: aBit
%

category: 'Private'
method: GsBitmap
_readObjectsFromPageOrderFilePrim: fileName startingAt: startIdx upto: endIdx

<primitive: 170>
fileName _validateClass: String.
startIdx _validateClass: SmallInteger.
endIdx _validateClass: SmallInteger.
self _primitiveFailed: #_readObjectsFromPageOrderFile:startingAt:upTo: args: { fileName . startIdx . endIdx }
%

category: 'Removing'
method: GsBitmap
_remove: anObject
 "Removes anObject from the GsBitmap.
  Returns true if anObject was present in the GsBitmap"

  ^ self _2ArgPrim: 12 with: anObject
%

category: 'Private'
method: GsBitmap
_removeFirst: count

"Remove the first count objects from the receiver.  Objects are removed from
 the beginning, going from lowest to highest object ID.

 Returns the number of objects removed from the hidden set."

^self _2ArgPrim: 18 with: count
%

category: 'Private'
method: GsBitmap
_setBits: anArray

"Add the bits specified by the Integers in anArray to the receiver.
 Returns the number of bits added."

^self _2ArgPrim: 23 with: anArray
%

category: 'Private'
method: GsBitmap
_truncateToSize: newSize

"Truncate receiver by removing objects from the end of the set until it reaches a size
 of newSize.  Objects are removed in order, going from highest to lowest object ID.

 Returns the number of objects removed."

^self _2ArgPrim: 17 with: newSize
%

! Class implementation for 'GsClassDocumentation'

!		Class methods for 'GsClassDocumentation'

category: 'Instance Creation'
classmethod: GsClassDocumentation
new

"Disallowed.  All instances of this class must initialize the
 itsClass instance variable.  Use newForClass: instead."

self shouldNotImplement: #new .
%

category: 'Instance Creation'
classmethod: GsClassDocumentation
newForClass: aClass

"Creates an object that documents a class."

| result |

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
result := super new.
result _initialize: aClass.

^ result
%

category: 'Private'
classmethod: GsClassDocumentation
_newForObsoleteGsClass: aClass asOfGsVersion: aString

"Private.  Only for use by GemStone."

"Creates an object that documents a GemStone class that is obsolete."

| result |

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
result := self newForClass: aClass.
result _markAsObsoleteGsClass: aString.

^ result
%

category: 'Private'
classmethod: GsClassDocumentation
_newForObsoletePrivateGsClass: aClass asOfGsVersion: aString

"Private.  Only for use by GemStone."

"Creates an object that documents a GemStone private class that is obsolete."

| result |

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
result := self newForClass: aClass.
result _markAsPrivateGsClass.
result _markAsObsoleteGsClass: aString.

^ result
%

category: 'Private'
classmethod: GsClassDocumentation
_newForPrivateGsClass: aClass

"Private.  Only for use by GemStone."

"Creates an object that documents a GemStone class that is private."

| result |

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
result := self newForClass: aClass.
result _markAsPrivateGsClass.

^ result
%

!		Instance methods for 'GsClassDocumentation'

category: 'Printing'
method: GsClassDocumentation
asString

  | str d lf |
  self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
  str := String new .
  lf := Character lf .
  (d := self detailsAboutClass) ifNotNil:[ str add: d; add: lf ].
  { { #instVarList . #detailsAboutInstVar: . 'instVar' } .
     { #classVarList . #detailsAboutClassVar: . 'classVar' } .
     { #poolVarList . #detailsAboutPoolVar: . 'poolVar' } .
     { #classInstVarList . #detailsAboutClassInstVar: . 'classInstVar' } .
     { #classCategoryList . #detailsAboutClassCategory: . 'class Category: ' } .
     { #categoryList . #detailsAboutCategory: . 'Category: ' }
   } do:[ :arr |
    (self perform: (arr at: 1) ) do:[:sym | | s |
      (s := self perform: (arr at: 2) with: sym ) ifNotNil:[
        str add: '--- '; add: (arr at: 3); add:' ' ; add: sym; add: lf ;
	    add: s ; add: lf .
      ].
    ].
  ].
  ^ str
%

category: 'Accessing'
method: GsClassDocumentation
categoryList

"Returns an Array of Symbols.  The Array contains an alphabetical list of the
 documented instance method categories of the class that is associated with the
 receiver."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
^ (self _sortKeysFrom: categoryDoc)
%

category: 'Accessing'
method: GsClassDocumentation
classCategoryList

"Returns an Array of Symbols.  The Array contains an alphabetical list of the
 documented class method categories of the class that is associated with the
 receiver."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
^ (self _sortKeysFrom: classCategoryDoc)
%

category: 'Accessing'
method: GsClassDocumentation
classInstVarList

"Returns an Array of Symbols.  The Array contains an alphabetical list of the
 documented class instance variable names of the class that is associated with
 the receiver."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
^ (self _sortKeysFrom: classInstVarDoc)
%

category: 'Accessing'
method: GsClassDocumentation
classVarList

"Returns an Array of Symbols.  The Array contains an alphabetical list of the
 documented class variable names of the class that is associated with the
 receiver."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
^ (self _sortKeysFrom: classVarDoc)
%

category: 'Accessing'
method: GsClassDocumentation
detailsAboutCategory: aSymbol

"Returns the CharacterCollection that contains detailed documentation about the
 instance method category named aSymbol."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
^ (self _getDetailsAbout: aSymbol in: categoryDoc)
%

category: 'Accessing'
method: GsClassDocumentation
detailsAboutClass

"Returns the CharacterCollection that contains detailed documentation about the
 class as a whole."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
(classDoc == nil) ifTrue: [ ^ nil ].
^ (classDoc details)
%

category: 'Accessing'
method: GsClassDocumentation
detailsAboutClassCategory: aSymbol

"Returns the CharacterCollection that contains detailed documentation about the
 class method category named aSymbol."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
^ (self _getDetailsAbout: aSymbol in: classCategoryDoc)
%

category: 'Accessing'
method: GsClassDocumentation
detailsAboutClassInstVar: aSymbol

"Returns the CharacterCollection that contains detailed documentation about the
 class instance variable named aSymbol."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
^ (self _getDetailsAbout: aSymbol in: classInstVarDoc)
%

category: 'Accessing'
method: GsClassDocumentation
detailsAboutClassVar: aSymbol

"Returns the CharacterCollection that contains detailed documentation about the
 class variable named aSymbol."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
^ (self _getDetailsAbout: aSymbol in: classVarDoc)
%

category: 'Accessing'
method: GsClassDocumentation
detailsAboutInstVar: aSymbol

"Returns the CharacterCollection that contains detailed documentation about the
 instance variable named aSymbol."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
^ (self _getDetailsAbout: aSymbol in: instVarDoc)
%

category: 'Accessing'
method: GsClassDocumentation
detailsAboutPoolVar: aSymbol

"Returns the CharacterCollection that contains detailed documentation about the
 pool variable named aSymbol."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
^ (self _getDetailsAbout: aSymbol in: poolVarDoc)
%

category: 'Updating'
method: GsClassDocumentation
documentCategory: aSymbol with: aGsDocText

"Documents an instance method category named aSymbol."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
(categoryDoc == nil) ifTrue: [ categoryDoc := SymbolDictionary new. ].
self _document: aSymbol in: categoryDoc with: aGsDocText.
%

category: 'Updating'
method: GsClassDocumentation
documentClassCategory: aSymbol with: aGsDocText

"Documents a class method category named aSymbol."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
(classCategoryDoc == nil)
  ifTrue: [ classCategoryDoc := SymbolDictionary new. ].
self _document: aSymbol in: classCategoryDoc with: aGsDocText.
%

category: 'Updating'
method: GsClassDocumentation
documentClassInstVar: aSymbol with: aGsDocText

"Documents a class instance variable named aSymbol."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
(classInstVarDoc == nil) ifTrue: [
  classInstVarDoc := SymbolDictionary new.
  ].
self _document: aSymbol in: classInstVarDoc with: aGsDocText.
%

category: 'Updating'
method: GsClassDocumentation
documentClassVar: aSymbol with: aGsDocText

"Documents a class variable named aSymbol."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
(classVarDoc == nil) ifTrue: [ classVarDoc := SymbolDictionary new. ].
self _document: aSymbol in: classVarDoc with: aGsDocText.
%

category: 'Updating'
method: GsClassDocumentation
documentClassWith: aGsDocText

"Documents the class that is associated with the receiver."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
self _prependToGsClassDoc: aGsDocText.
classDoc := aGsDocText.
%

category: 'Updating'
method: GsClassDocumentation
documentInstVar: aSymbol with: aGsDocText

"Documents an instance variable named aSymbol."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
(instVarDoc == nil) ifTrue: [ instVarDoc := SymbolDictionary new. ].
self _document: aSymbol in: instVarDoc with: aGsDocText.
%

category: 'Updating'
method: GsClassDocumentation
documentPoolVar: aSymbol with: aGsDocText

"Documents a pool variable named aSymbol."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
(poolVarDoc == nil) ifTrue: [ poolVarDoc := SymbolDictionary new. ].
self _document: aSymbol in: poolVarDoc with: aGsDocText.
%

category: 'Accessing'
method: GsClassDocumentation
instVarList

"Returns an Array of Symbols.  The Array contains an alphabetical list of the
 documented instance variable names of the class that is associated with the
 receiver."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
^ (self _sortKeysFrom: instVarDoc)
%

category: 'Accessing'
method: GsClassDocumentation
isGsObsolete

"Returns true when the class that the receiver documents is obsolete."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
(gsObsolete == nil) ifTrue: [ ^ false ].

^ true
%

category: 'Accessing'
method: GsClassDocumentation
isGsPrivate

"Returns true when the class that the receiver documents implements only
 GemStone internals, and false otherwise.  Private means that the class is not
 intended for customer use, by creating instances or by subclassing.  It
 provides only functionality required by GemStone itself."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
^ gsPrivate
%

category: 'Accessing'
method: GsClassDocumentation
itsClass

"Returns the class that the receiver documents.
 This method needed by image upgrade."

^ itsClass
%

category: 'Private'
method: GsClassDocumentation
itsClass: aClass

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
itsClass := aClass .
^ self
%

category: 'Accessing'
method: GsClassDocumentation
poolVarList

"Returns an Array of Symbols.  The Array contains an alphabetical list of the
 documented pool variable names of the class that is associated with the
 receiver."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
^ (self _sortKeysFrom: poolVarDoc)
%

category: 'Private'
method: GsClassDocumentation
_classDocDetailsDelimiter

| res |
self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
(res := String new) lf; lf; add: ' ' .
^ res
%

category: 'Private'
method: GsClassDocumentation
_classDocDetailsObsolete

| res |
self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
(res := String withAll: 'The class ')
      add: (itsClass name);
      add: ' is obsolete as of GemStone version ';
      add: gsObsolete;
      add: ' and will be removed in a future release.  GemStone recommends';
      add: ' that you retire or migrate your instances in this release.'.
^ res
%

category: 'Private'
method: GsClassDocumentation
_classDocDetailsPrivate

| res |
self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
(res := String withAll: 'The class ')
      add: (itsClass name);
      add: ' implements only GemStone internals.  That is, it provides only';
      add: ' functionality required by GemStone itself.  It is not intended';
      add: ' for customer use, by creating instances or by subclassing.'.
^ res
%

category: 'Private'
method: GsClassDocumentation
_document: aSymbol in: aSymbolDict with: aGsDocText

""

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
(aGsDocText isKindOf: GsDocText)
  ifTrue: [ aSymbolDict at: aSymbol put: aGsDocText. ].
%

category: 'Private'
method: GsClassDocumentation
_getDetailsAbout: aSymbol in: aSymbolDict

""

| txt |

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
aSymbolDict ifNil:[ ^ nil  ].
txt := aSymbolDict at: aSymbol otherwise: nil .
txt ifNil:[ ^ nil ].

^ (txt details)
%

category: 'Private'
method: GsClassDocumentation
_initialize: aClass

""

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
itsClass ifNil:[
  itsClass := aClass.
  gsPrivate := false.
  ].
%

category: 'Private'
method: GsClassDocumentation
_markAsObsoleteGsClass: theGsVersion

"Private.  Only for use by GemStone."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
gsObsolete := theGsVersion.
%

category: 'Private'
method: GsClassDocumentation
_markAsPrivateGsClass

"Private.  Only for use by GemStone."

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
gsPrivate := true.
%

category: 'Private'
method: GsClassDocumentation
_prependToGsClassDoc: aGsDocText

"Prepends appropriate text to the class documentation if the class is
 obsolete or private.  Only GemStone classes can be obsolete or private."

| detls str |

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
(self isGsObsolete)
  ifTrue:  [ str := self _classDocDetailsObsolete. ]
  ifFalse: [
    (self isGsPrivate)
      ifTrue:  [ str := self _classDocDetailsPrivate. ]
      ifFalse: [ ^ self ].
    ].

detls := aGsDocText details.
(detls == nil) ifFalse: [
  str add: (self _classDocDetailsDelimiter).
  str add: detls.
  ].
aGsDocText details: str.
%

category: 'Private'
method: GsClassDocumentation
_sortKeysFrom: aSymbolDict

""

self deprecated: 'GsClassDocumentation Deprecated as of GS/64 3.1'.
aSymbolDict ifNil: [ ^ { }  ].

^ Array withAll:( SortedCollection withAll: aSymbolDict keys )
%

! Class implementation for 'GsDocText'

!		Instance methods for 'GsDocText'

category: 'Accessing'
method: GsDocText
details

"Returns the instance variable `details'."

self deprecated: 'GsDocText Deprecated as of GS/64 3.1'.
^details
%

category: 'Updating'
method: GsDocText
details: aCharColl

"Update the instance variable 'details'."

self deprecated: 'GsDocText Deprecated as of GS/64 3.1'.
details := aCharColl.
%

category: 'Accessing'
method: GsDocText
sketch

"Returns the instance variable `sketch'."

self deprecated: 'GsDocText Deprecated as of GS/64 3.1'.
^sketch
%

category: 'Updating'
method: GsDocText
sketch: aCharColl

"Update the instance variable 'sketch'."

self deprecated: 'GsDocText Deprecated as of GS/64 3.1'.
sketch := aCharColl.
%

! Class implementation for 'GsHostProcess'

!		Class methods for 'GsHostProcess'

category: 'Instance creation'
classmethod: GsHostProcess
basicNew

"disallowed"

self shouldNotImplement: #basicNew
%

category: 'Instance creation'
classmethod: GsHostProcess
execute: commandLineString
  "Execute the command in a child process. For details, see comments in the 
  method execute:input:args:"

 ^ self execute: commandLineString input: nil args: nil 
%

category: 'Instance creation'
classmethod: GsHostProcess
execute: commandLineString args: anArray
  "Execute the command in a child process, passing in the arguments in anArray. 
  For details, see comments in the method execute:input:args:"

 ^ self execute: commandLineString input: nil args: anArray 
%

category: 'Instance creation'
classmethod: GsHostProcess
execute: commandLineString input: stdinString
  "Execute the command in a child process, writing stdinString to the child's
  stdin. For details, see comments in the method execute:input:args:"

 ^ self execute: commandLineString input: stdinString args: nil 
%

category: 'Instance creation'
classmethod: GsHostProcess
execute: commandLineString input: stdinString args: anArray
 "Executes commandLineString in a child process,
  writing stdinString to the stdin of the child.
  stdinString may be nil, in which case nothing is written to stdin of child
  If child returns non-zero exit status, signals an Error using
  contents of stderr from the child.  Otherwise returns a String
  containing stdout from the child.
  If child produces exit status
  zero and non-empty stderr the result is prefixed with
  'WARNING: <contents of stderr>' .
  Lookup in the PATH environment variable is not performed,
  the commandLineString must specify a complete path to an executable
  or script.

  commandLineString is parsed for space separated arguments.
  anArray may be nil or an Array. 
  commandLineString and elements of anArray must each be an instance of String , Unicode7 or Utf8.
  Elements of anArray are appended to the arguments contained in commandLineString, to
  form the total argv array of the child, any quoting or whitespace within an element
  of anArray is passed directly to the child in the corresponding element of child's argv.
  If any argument has complicated quoting or whitespace, 
  commandLineString should contain only the full path to the executable, 
  and arguments should be passed as elements of anArray.

  Signals an error if the privilege NoPerformOnServer is true and
  commandLineString is not present in the allowlist of allowed commands
  for the session's UserProfile. See the methods in UserProfile under
  category PerformOnServer for more information."

  | inst |
  (inst := self new) commandLine: commandLineString ;
                     args: anArray .
  ^ inst executeWithInput: stdinString .
%

category: 'Instance creation'
classmethod: GsHostProcess
fork: commandLineString
  "Create a new instance, fork it, and exex the command in the child procss.
  For details, see comments in the method fork:args:"

  ^ self fork: commandLineString args: nil .
%

category: 'Instance creation'
classmethod: GsHostProcess
fork: commandLineString args: anArray
" Create a new instance of the receiver, fork a child process,
 and exec the commandLineString in the child.
 Utf16 command lines are not yet supported by the fork primitive.
 Lookup in the PATH environment variable is not performed,
 the commandLineString must specify a complete path to an executable
 or script to be exec'ed .

 WARNING, if you are not using a variant of GsHostProcess>>execute ,
 it is recommended to use one or more of GsHostProcess>>stderrPath: ,
  GsHostProcess>>stdinPath: , GsHostProcess>>stdoutPath:  to
 specify where the child should go for its standard files.  Otherwise the
 child may hang when trying to read or write to a pipe connected to
 the parent process , if the parent is not executing the data read and writes
 implemented in  GsHostProcess>>_executeWithInput:  .

 commandLineString is parsed for space separated arguments.
 anArray may be nil or an Array. 
 commandLineString and elements of anArray must each be an instance of String , Unicode7 or Utf8.
 Elements of anArray are appended to the arguments contained in commandLineString, to
 form the total argv array of the child, any quoting or whitespace within an element
 of anArray is passed directly to the child in the corresponding element of child's argv.
 If any argument has complicated quoting or whitespace, 
 commandLineString should contain only the full path to the executable, 
 and arguments should be passed as elements of anArray.

 If running in a topaz -l process and (GsFile stdin isTerminal == true)
 The child process will ignore SIGINT.

 Signals an error if the privilege NoPerformOnServer is true and
 commandLineString is not present in the allowlist of allowed commands
 for the session's UserProfile. See the methods in UserProfile under
 category PerformOnServer for more information."

  | inst |
  (inst := self _basicNew) commandLine: commandLineString ;
     args: anArray;
     fork .
  ^ inst
%

category: 'Instance creation'
classmethod: GsHostProcess
new
  ^ self _basicNew
%

category: 'Private'
classmethod: GsHostProcess
_basicNew

"creates an instance registered with VM for finalization of cData"

<primitive: 674>
^ self _primitiveFailed: #_basicNew
%

category: 'Instance creation'
classmethod: GsHostProcess
_execute: commandLineString input: stdinString
  "Returns an array of the form { stdout . stderr }
  containing stdout and stderr from the child.

  Otherwise see GsHostProcess class >> execute:input:"

  | inst |
  (inst := self new) commandLine: commandLineString .
  ^ inst _executeWithInput: stdinString .
%

!		Instance methods for 'GsHostProcess'

category: 'Accessing'
method: GsHostProcess
appendToFiles: aBoolean
  "If aBoolean == true and out or err are paths for files to be opened, 
   causes already existing files to be opened for append. "
  aBoolean _validateClass: Boolean .
  appendToFiles := aBoolean .
%

category: 'Accessing'
method: GsHostProcess
args: anArray
  self dynamicInstVarAt: #args put: anArray
%

category: 'Status'
method: GsHostProcess
childHasExited
| s |
 s := self childStatus .
 s ifNil:[ ^ false "still running"].
 ^ (s  bitAnd: 16r200) == 0   "if not stopped with a signal it has exited"
%

category: 'Status'
method: GsHostProcess
childStatus
  "Returns nil if the child has not been reaped,
   or returns a SmallInteger as follows

  result == 0 means child exited with exit code of 0 .

  ((result bitAnd: 16r100) ~~ 0)  means child exited due to a signal
     and  (result bitAnd: 16rFF) is the number of the signal .

  ((result bitAnd: 16r200) ~~ 0) means child was stopped by a signal
     and  (result bitAnd: 16rFF) is the number of the signal .

  otherwize non-zero result means child exited with that error status."

  | s |
  (s := childStatus) ifNil:[
    s := self _waitChild: false  .
    s ifNotNil:[
      (s bitAnd: 16r200) == 0 ifTrue:[  "child exited"
        childStatus := s .
      ]
    ].
  ].
  ^ s
%

category: 'Accessing'
method: GsHostProcess
commandLine
  "After fork: , returns the command line that was used to
   exec the child process."
  ^ cmd
%

category: 'Accessing'
method: GsHostProcess
commandLine: aString
  cmd := aString .
%

category: 'Execution'
method: GsHostProcess
execute
  ^ self executeWithInput: nil .  
%

category: 'Execution'
method: GsHostProcess
executeWithInput: stdinString
  | arr outStr errStr result |
  arr := self _executeWithInput: stdinString .
  outStr := arr at: 1 .
  errStr := arr at: 2 .
  errStr size > 0 ifTrue:[
    (result := 'WARNING: <' copy) addAll: errStr asString; add: '> ' ; lf;
      addAll: outStr .
  ] ifFalse:[
    result := outStr
  ].
  ^ result
%

category: 'Execution'
method: GsHostProcess
fork
  "Fork a child process. See comments in the method _fork:"
  ^ self _fork: (self dynamicInstVarAt: #args)
%

category: 'Status'
method: GsHostProcess
killChild
  "Attempts to kill the child. Waits one second for child to go way.
   Returns child status. Reading from childs stdout or sterr after
   a kill may block due to no data available. (use GsSocket>>readWillNotBlock)"

^ self  _killChild: 1
%

category: 'Status'
method: GsHostProcess
killChild: timeoutSeconds
  "Attempts to kill the child. Waits specified time for child to go way.
   Returns child status. Reading from childs stdout or sterr after
   a kill may block due to no data available. (use GsSocket>>readWillNotBlock)"

  ^ self  _killChild: timeoutSeconds
%

category: 'Accessing'
method: GsHostProcess
processId
  "After fork: , returns a SmallInteger , the operating system
   process id of the child."
  ^ childPid
%

category: 'Accessing'
method: GsHostProcess
readOutErr
  "assumming both out and err are sockets, attempt to read from both
   and return combined result."
  | outStr |
  outStr := String new .
  self _readFromSocket: out into: outStr timeout: 5000 .
  self _readFromSocket: self _stderr into: outStr timeout: 5000 .
  ^ outStr
%

category: 'Accessing'
method: GsHostProcess
redirectStderrToStdout
  "This should be used rather than stderrPath:  if you want both stdout and stderr
   redirected to the same file."
  out ifNil:[ Error signal:'redirectStderrToStdout must be preceeded by stdoutPath:'].
  err := out 
%

category: 'Accessing'
method: GsHostProcess
stderr
  "After fork: , returns a non-blocking read-only GsSocket
  representing the parent's end of a pipe (see   man 2 pipe )
  connected to stderr of the child.  If the GsSocket is not read
  from sufficiently to consume data, the child process may block
  waiting to write more data to its stderr .

  If child's stderr was opened as a file, returns nil"

  ^ self _asSocket: err
%

category: 'Accessing'
method: GsHostProcess
stderrPath
  ^ self _asPath: err
%

category: 'Accessing'
method: GsHostProcess
stderrPath: aStringOrUtf8
  err ifNotNil:[ Error signal:'path for stderr has already been specified.' ].
  (self _asPath: aStringOrUtf8) ifNotNil:[
     err := aStringOrUtf8 .
     ^ self .
  ].
  Error signal:'expected a String or Utf8'.
%

category: 'Accessing'
method: GsHostProcess
stdin
  "After fork: , returns a non-blocking write-only GsSocket
   representing the parent's end of a pipe (see   man 2 pipe )
   connected to stdin of the child.  The child's end of the pipe
   is blocking and a read by the child on stdin will block until
   Smalltalk code writes sufficient data to this GsSocket
   to satisfy the read.  
   If stdin was opened as a file, returns nil"
  ^ self _asSocket: in 
%

category: 'Accessing'
method: GsHostProcess
stdinPath
  ^ self _asPath: in
%

category: 'Accessing'
method: GsHostProcess
stdinPath: aStringOrUtf8
  "If a child process is not expected to read from stdin,  
   the recommended usage is      stdinPath: '/dev/null'  
   so that the child gets an EOF error if it does try to read from stdin."
  (self _asPath: aStringOrUtf8) ifNotNil:[
     in := aStringOrUtf8 .
     ^ self .
  ].
  Error signal:'expected a String or Utf8'.
%

category: 'Accessing'
method: GsHostProcess
stdout
  "After fork: , returns a non-blocking read-only GsSocket
  representing the parent's end of a pipe (see   man 2 pipe )
  connected to stdout of the child.  If the GsSocket is not read
  from sufficiently to consume data, the child process may block
  waiting to write more data to its stdout . 

  If stdout was opened as a file, returns nil"

  ^ self _asSocket: out 
%

category: 'Accessing'
method: GsHostProcess
stdoutPath
  ^ self _asPath: out
%

category: 'Accessing'
method: GsHostProcess
stdoutPath: aStringOrUtf8
  out ifNotNil:[ Error signal:'path for stdout has already been specified'].
  (self _asPath: aStringOrUtf8) ifNotNil:[
     out := aStringOrUtf8 .
     ^ self .
  ].
  Error signal:'expected a String or Utf8'.
%

category: 'Private'
method: GsHostProcess
_asPath: sockOrPath
  sockOrPath ifNil:[ ^ nil ].
  (sockOrPath _isOneByteString or:[ sockOrPath isKindOfClass: Utf8 ])
     ifTrue:[ ^ sockOrPath ].
  ^ nil
%

category: 'Private'
method: GsHostProcess
_asSocket: sockOrPath
  sockOrPath ifNil:[ ^ nil ].
  (sockOrPath _isOneByteString or:[ sockOrPath isKindOfClass: Utf8 ])
     ifTrue:[ ^ nil ].
  ^ sockOrPath
%

category: 'Execution'
method: GsHostProcess
_executeWithInput: stdinString
 "Executes the command line specified by instVar  cmd   in a child process .
  If stdinString ~~ nil, writes stdinString to the child's stdin.
  If child returns non-zero exit status, signals a ChildError using
  status and contents of stderr from the child.  
  Returns an Array of the form { stdout . stderr } .
  containing stdout and stderr from the child.

  If either of stdout, stderr are specified to be files via
  GsHostProcess>>stdoutrPath:, GsHostProcess>>stderrPath: prior to  invoking
  this method, those respective output strings will be empty.

  Lookup in the PATH environment variable is not performed,
  the commandLineString must specify a complete path to an executable
  or script.

  Signals an error if the privilege NoPerformOnServer is true and
  commandLineString is not present in the allowlist of allowed commands
  for the session's UserProfile. See the methods in UserProfile under
  category PerformOnServer for more information."

  | outStr errStr status readDataBlk writeOfs nToWrite 
    stdoutIsSocket stderrSock |
  writeOfs := 1 .
  stdinString ifNil:[
    nToWrite := 0 .
    in ifNil:[ in := '/dev/null' ].
  ] ifNotNil:[
    nToWrite := stdinString size .
    (nToWrite > 0 and:[ in ~~ nil ]) ifTrue:[
       Error signal: 'stdinString should be nil or empty after GsHostProcess>>stdinPath: sent'.
    ]
  ].
  stdoutIsSocket := out == nil .
  self fork.  "creates the GsSockets for pipes"
  stderrSock := self _stderr .
  outStr := String new .
  errStr := String new .
  readDataBlk := [ :timeOutMs | 
    stdoutIsSocket ifTrue:[
      self _readFromSocket: out into: outStr timeout: timeOutMs .
    ].
    self _readFromSocket: stderrSock into: errStr timeout: timeOutMs .
  ].
  [ status := self childStatus .
    status == nil
  ] whileTrue:[
    (nToWrite > 0 and:[ in writeWillNotBlock]) ifTrue:[ | nWrote |
      nWrote := in write: nToWrite from: stdinString startingAt: writeOfs .
      nWrote ifNil:[ Error signal:'lost stdin' , in lastErrorString ].
      writeOfs := writeOfs + nWrote .
      nToWrite := nToWrite - nWrote .
      nToWrite == 0 ifTrue:[ in close ].
    ].
    readDataBlk value: nil .  "read while waiting for child exit, so pipes don't block"
    Delay waitForMilliseconds: 10 .
  ].
  readDataBlk value: 5000 .  "final read allows 5 secs for data to arrive"
  status ~~ 0 ifTrue:[ 
    ChildError new status: status ; stderr: errStr ; signal
  ].
  ^ { outStr . errStr } .
%

category: 'Execution'
method: GsHostProcess
_fork: argsArray

"Forks the child process specified by the instVars. 
 The instVar cmd must be a valid String or Utf8 containing full path of command
 to execute.
 The instVars in , out , err of the receiver , if nil , specify that each is to
 be opened as a pipe , with a GsSocket connected to the pipe.
 The instVars in , out , err of the receiver , if not nil , must each be a String 
 or a Utf8 specifying a valid path to redirect the corresponding standard file . 
 A path may be '/dev/null' for no-access semantics or '/dev/zero'  
 for output ignored semantics.

 For  out and err , file will be created using the specified path .  
 If both are to be redirected to the same file,  values of out and err should be equal;
 they may be identical.

 For in, if not nil, the file must exist for opening as stdin .

 If instVar appendToFiles == true,  then out and/or err specifing a file will be opened
 for append , otherwise out and/or err to a file will create a new file.

 commandLineString is parsed for space separated arguments.
 anArray may be nil or an Array. 
 commandLineString and elements of anArray must each be an instance of String , Unicode7 or Utf8.
 Elements of anArray are appended to the arguments contained in commandLineString, to
 form the total argv array of the child, any quoting or whitespace within an element
 of anArray is passed directly to the child in the corresponding element of child's argv.
 If any argument has complicated quoting or whitespace, 
 commandLineString should contain only the full path to the executable, 
 and arguments should be passed as elements of anArray.


 WARNING, if standard files have not been redirected to the filesystem 
 by use of one or more of GsHostProcess>>stderrPath: ,
  GsHostProcess>>stdinPath: , GsHostProcess>>stdoutPath: ,
 the child may hang when trying to read or write to a pipe connected to
 the parent process , if the parent is not executing the data read and writes
 equivalent to those implemented in  GsHostProcess>>_executeWithInput:  .

 If running in a topaz -l process and (GsFile stdin isTerminal == true)
 The child process will ignore SIGINT.

 Signals an error if the privilege NoPerformOnServer is true and
 commandLineString is not present in the allowlist of allowed commands
 for the session's UserProfile. See the methods in UserProfile under
 category PerformOnServer for more information."

 <primitive: 956>
 (cmd _isOneByteString or:[ cmd isKindOfClass: Utf8 ]) ifFalse:[
   ArgumentTypeError signal:'cmd must be a String or Utf8'.
 ].
 argsArray ifNotNil:[
   argsArray _validateInstanceOf: Array .
   1 to: argsArray size do:[:n | | elem |
     elem := argsArray at: n .
     (elem _isOneByteString or:[ elem isKindOfClass: Utf8 ]) ifFalse:[
       ArgumentTypeError signal:'argument must be a String or Utf8'.
     ].
   ].
 ].
 self _primitiveFailed: #_fork: args: { argsArray }
%

category: 'Status'
method: GsHostProcess
_killChild: timeoutSeconds
  "Attempts to kill the child. Waits specified time for child to go way.
   Returns child status."
  | s endMs |
  endMs := DateTime now asMillisecondsGmt + (1000 * timeoutSeconds).
  (s := childStatus) ifNil:[
     self _waitChild: true . "kill with SIGTERM"
     [
       Delay waitForMilliseconds:10.
       (s := self childStatus) ifNotNil:[ ^ s ].
       DateTime now asMillisecondsGmt < endMs
     ] whileTrue .
  ].
  ^ s
%

category: 'Private'
method: GsHostProcess
_readFromSocket: aSocket into: aString timeout: timeoutMs
  "If timeoutMs not nil, waits for up to that time for data.  
   If socket not ready and timeoutMs==nil , returns number of bytes read,
   otherwise waits for timeoutMs .
   Returns total number of bytes read in this call."
  | total |
  total := 0 .
  [ true ] whileTrue:[ | nRead |
    nRead := aSocket _readInto: aString startingAt: aString size + 1  maxBytes: 16272 .
    nRead _isSmallInteger ifTrue:[
      nRead == 0 ifTrue:[ ^ total ] .
      total := total + nRead . 
    ] ifFalse:[
      nRead == true ifTrue:[ 
        "got EINTR, retry"
      ] ifFalse:[
        nRead == false "EWOULDBLOCK" ifTrue:[  | status |
          timeoutMs ifNil:[ ^ total "caller will try again"].
          status := aSocket readWillNotBlockWithin: timeoutMs .
          status ifNil:[ ^ aSocket signalError ].
          status ifFalse:[ ^ Error signal:'timeout reading from pipe to child'].
        ] ifFalse:[
          "aSocket is a GsSignalingSocket, _readInto: prim should signal socket errors directly" 
          Error signal:'Unexpected nRead ', nRead asString .
        ].
      ].
    ]
  ]
%

category: 'Private'
method: GsHostProcess
_stderr
  "After fork: , returns a non-blocking read-only GsSocket
  representing the parent's end of a pipe (see   man 2 pipe )
  connected to stderr of the child.  If the GsSocket is not read
  from sufficiently to consume data, the child process may block
  waiting to write more data to its stderr .

  The instVar errSocket is parent's end of a pipe used to read 
  data for details of failure to open a stdin,stdout or stderr file
  during the fork.  Once the child has successfully opened all files,
  no more data will be written to this socket.  "

  ^ (self _asSocket: err) ifNil:[ errSocket ].
%

category: 'Private'
method: GsHostProcess
_waitChild: killBoolean

"calls waitpid() .
 If child is still running and killBoolean == true, attempts to kill
 the child with a SIGTERM.
 The return status is computed before attempting any kill of the child.

 Returns nil if child still running, otherwise returns a SmallInteger
 representing child status from waitpid() .

  result == 0 means child exited with exit code of 0 .

  ((result bitAnd: 16r100) ~~ 0)  means child exited due to a signal
     and  (result bitAnd: 16rFF) is the number of the signal .

  ((result bitAnd: 16r200) ~~ 0) means child was stopped by a signal
     and  (result bitAnd: 16rFF) is the number of the signal .

  otherwize non-zero result means child exited with that error status.
"
<primitive: 957>
killBoolean _validateClass: Boolean .
self _primitiveFailed: #_waitChild: args: { killBoolean }
%

! Class implementation for 'GsInterSessionSignal'

!		Class methods for 'GsInterSessionSignal'

category: 'Instance Creation'
classmethod: GsInterSessionSignal
signal: aSignal message: aString

"Returns a new instance with the given information installed.
 The originating GsSession is set to nil."

| result |
result := super new.
result signal: aSignal; message: aString.
^ result
%

!		Instance methods for 'GsInterSessionSignal'

category: 'Accessing'
method: GsInterSessionSignal
message

"Returns the String sent as a message."

^ message
%

category: 'Accessing'
method: GsInterSessionSignal
message: aString

"Sets the String to be sent as a message."

message := aString asString

%

category: 'Signalling'
method: GsInterSessionSignal
replyToSenderWithSignal: aSmallInteger withString: aString

"Sends a signal containing the arguments to the originating session of the
 receiver.  If the session instance variable of the receiver is nil, raises an
 error."

System _sendSignal: aSmallInteger toSess: sessionSerialNum
	withMessage: aString
%

category: 'Signalling'
method: GsInterSessionSignal
sendToSession: aGsSession

"Sends a signal to the session represented by aGsSession.  The signal contains
 the signal and message instance variables of the receiver.  Ignores the session
 instance variable of the receiver."

aGsSession sendSignalObject: self
%

category: 'Accessing'
method: GsInterSessionSignal
session

"Returns a transient GsSession object representing the session that sent the
 signal, or nil if there was no signal.  This object can be used as target of
 signals sent in response."

^ GsSession sessionWithSerialNumber: sessionSerialNum
%

category: 'Accessing'
method: GsInterSessionSignal
session: aGsSession

"Sets the session instance variable so that it represents the session that sent
 the signal."

sessionSerialNum := aGsSession sessionSerialNum
%

category: 'Accessing'
method: GsInterSessionSignal
signal

"Returns the SmallInteger sent as a signal."

^ signal
%

category: 'Accessing'
method: GsInterSessionSignal
signal: aSmallInteger

"Sets the SmallInteger to be sent as a signal."

signal := aSmallInteger
%

! Class implementation for 'GsPackage'

!		Class methods for 'GsPackage'

category: 'Accessing'
classmethod: GsPackage
globalName

  ^#GsPackage_Current
%

category: 'Instance Creation'
classmethod: GsPackage
installIn: aSymbolDictionary

  | package |
  package := self new.
  aSymbolDictionary at: self globalName put: package.
    package symbolDict: aSymbolDictionary.
  ^package
%

category: 'Instance Creation'
classmethod: GsPackage
new

  ^self basicNew initialize
%

!		Instance methods for 'GsPackage'

category: 'Categories'
method: GsPackage
addCategory: aSymbol for: aBehavior
  "returns the newly added category (a SymbolSet) or nil if not newly added"
  | ar catDict |
  ar := self sessionInfoFor: aBehavior.
  catDict := (ar at: 2).
  (catDict includesKey: aSymbol)
    ifFalse: [ | aSet |
      aSet := SymbolSet new .
      catDict add: (SymbolAssociation newWithKey: aSymbol value: aSet ).
      ^aSet].
  ^ nil
%

category: 'Accessing'
method: GsPackage
addPrereq: aSymbolDict

    prereqs add: aSymbolDict
%

category: 'Categories'
method: GsPackage
addSelector: aSelector method: aGsNMethod toCategory: categoryName for: aBehavior
  "Adds an already compiled method to specified class and category"
  | arr catSet mDict catDict |
  arr := self sessionInfoFor: aBehavior .
  mDict := arr at: 1 .
  mDict at: aSelector put: aGsNMethod .
  catDict := arr at: 2 .
  catSet := catDict at: categoryName ifAbsent:[ self addCategory: categoryName for: aBehavior ].
  catSet add: aSelector .
%

category: 'Categories'
method: GsPackage
addSelector: aSelector toCategory: categoryName for: aBehavior
    "new category is expected to exist"
  | ar catDict |
  ar := self sessionMethods at: aBehavior otherwise: nil .
  ar ifNil:[ ^ self ].
  catDict := (ar at: 2).
    (catDict at: categoryName) add: aSelector.
%

category: 'Enumerating'
method: GsPackage
behaviorAndMethodDictDo: aBlock
  self enabled ifTrue:[
    self sessionMethods keysAndValuesDo: [:beh :ar |
        aBlock value: beh value: (ar at: 1)
    ].
  ].
%

category: 'Categories'
method: GsPackage
categoryNamesFor: aBehavior into: anArray

    | ar catDict |
    ar := self sessionMethods at: aBehavior otherwise: nil .
    ar ifNil:[ ^ self ].
    catDict := (ar at: 2).
    catDict keysAndValuesDo: [:aKey :aValue |
      anArray add: aKey
    ].
%

category: 'Methods'
method: GsPackage
categoryOfSelector: aSymbol for: aBehavior

    | ar catDict |
    ar := self sessionMethods at: aBehavior otherwise: nil .
    ar ifNil:[ ^ nil ].
    catDict := (ar at: 2).
    catDict keysAndValuesDo: [:aKey :aValue |
      (aValue includesIdentical: aSymbol ) ifTrue:[ ^ aKey ].
    ].
    ^ nil
%

category: 'Categories'
method: GsPackage
categorysDo: aBlock for: aBehavior
  "evaluates aBlock for each method category of receiver
   in specified environment. Returns the receiver.

   aBlock should be a two argument block
   expecting the args  categoryNameSymbol ,   selectorsSet.
   aBlock may be invoked more than once for each category name.
   The iteration is done directly over the receiver's categories."

    | ar |
  ar := self sessionMethods at: aBehavior otherwise: nil .
  ar ifNil:[ ^ self ].
  (ar at: 2) keysAndValuesDo: aBlock
%

category: 'Methods'
method: GsPackage
compiledMethodAt: aSymbol for: aBehavior

    | ar methDict |
    ar := self sessionMethods at: aBehavior otherwise: nil .
    ar ifNil:[ ^ nil ].
    methDict := (ar at: 1).
    ^methDict at: aSymbol otherwise: nil
%

category: 'Methods'
method: GsPackage
copyCategoryDictFor: aBehavior into: aGsMethodDictionary

    | ar catDict |
    ar := self sessionMethods at: aBehavior otherwise: nil .
    ar ifNil:[ ^ self ].
    catDict := (ar at: 2).
    catDict keysAndValuesDo: [:key :values | | coll |
        coll := aGsMethodDictionary at: key otherwise: nil.
        coll ifNil:[
            coll := SymbolSet new.
            aGsMethodDictionary at: key put: coll
        ].
        coll canBeWritten ifFalse: [
            coll := coll copy.
            aGsMethodDictionary at: key put: coll
        ].
        coll addAll: values.
    ].
%

category: 'Methods'
method: GsPackage
copyMethodDictFor: aBehavior into: aGsMethodDictionary

    | ar methDict |
    ar := self sessionMethods at: aBehavior otherwise: nil .
    ar ifNil:[ ^ self ].
    methDict := (ar at: 1).
    methDict keysAndValuesDo: [:key :value |
        aGsMethodDictionary at: key put: value
    ].
%

category: 'Control'
method: GsPackage
disable
  ^ self dynamicInstVarAt: #enabled put: false
%

category: 'Control'
method: GsPackage
enable
  ^ self dynamicInstVarAt: #enabled put: true
%

category: 'Control'
method: GsPackage
enabled
  "enabled by default, i.e. if never previously disabled"
  ^ (self dynamicInstVarAt: #enabled) ifNil:[ true ]
%

category: 'Methods'
method: GsPackage
includesSelector: aSymbol for: aBehavior

    | ar methDict |
    ar := self sessionMethods at: aBehavior otherwise: nil .
    ar ifNil:[ ^ false ].
    methDict := (ar at: 1).
    ^methDict includesKey: aSymbol
%

category: 'Initialize-Release'
method: GsPackage
initialize
  sessionMethods := IdentityKeyValueDictionary new.
  prereqs := { } .
%

category: 'Compiling'
method: GsPackage
methodAndCategoryDictionaryFor: aBehavior

  "Returns a 2 element array { methodDict . categoryDict }"
  | arr |
  arr := self sessionInfoFor: aBehavior.
  ^ { arr at: 1 . arr at: 2 }
%

category: 'Compiling'
method: GsPackage
methodPragmaDictFor: aBehavior

    | ar |
    ar := self sessionMethods at: aBehavior otherwise: nil .
    ar ifNil:[ ^ nil ].
    ar size < 4 ifTrue: [ar at: 4 put: IdentityKeyValueDictionary new].
   ^(ar at: 4) at: aBehavior otherwise: nil
%

category: 'Reporting'
method: GsPackage
methodsReport
  | coll str |
  str := String new .
  coll := SortedCollection sortBlock:[:a :b | a key name <= b key name ].
  sessionMethods associationsDo:[:assoc | coll add: assoc ].
  coll do:[:assoc | | sels |
    str add: '--- '; add: assoc key name ; lf.
    sels := assoc value ifNotNil:[:arr | (arr at: 1) keys ] ifNil:[ #() ].
    (SortedCollection withAll: sels ) do:[:aSelector |
      str add: aSelector ; lf .
    ].
  ].
  ^ str .
%

category: 'Compiling'
method: GsPackage
methodStampDictFor: aBehavior

    | ar |
    ar := self sessionMethods at: aBehavior otherwise: nil .
    ar ifNil:[ ^ nil ].
   ^(ar at: 3) at: aBehavior otherwise: nil
%

category: 'Categories'
method: GsPackage
moveSelector: aSelector toCategory: newCat for: aBehavior
  "Okay if new category not already present"

  self removeSelector: aSelector fromCategoriesFor: aBehavior.
  self
    addCategory: newCat for: aBehavior;
    addSelector: aSelector toCategory: newCat for: aBehavior
%

category: 'Printing'
method: GsPackage
name
^  symbolDict name
%

category: 'Accessing'
method: GsPackage
prereqs

    ^prereqs
%

category: 'Printing'
method: GsPackage
printOn: aStream
| str |
str := 'a', self class name.
symbolDict name ifNotNil:[:nam |  str addAll:' for ' ; addAll: nam].
aStream nextPutAll: str .
%

category: 'Methods'
method: GsPackage
recompileFor: aBehavior
    | ar methDict sels cats |
    ar := self sessionMethods at: aBehavior otherwise: nil .
    ar ifNil:[ ^ nil ].
    methDict := ar at: 1. cats := ar at: 2 .
    sels := methDict keys .
    sels do:[:aSel | | meth nm |
      meth := methDict at: aSel .
      nm := meth recompileIntoMethodDict: methDict intoCategories: cats .
      false ifTrue:[ GsFile gciLogServer:' recompiled ', nm printString ,' oop ', nm asOop asString].
    ].
%

category: 'Methods'
method: GsPackage
removeAllMethods
  | clss |
  clss := self sessionMethods keys .
  clss do:[:aClass |
    self sessionMethods removeKey: aClass otherwise: nil .
  ].
%

category: 'Methods'
method: GsPackage
removeAllMethodsFor: aBehavior
    self sessionMethods removeKey: aBehavior otherwise: nil .
%

category: 'Methods'
method: GsPackage
removeAllSubclassCodeFor: aBehavior
    | ar methDict |
  "GsFile gciLogServer: self printString ."
  "self pause."
    ar := self sessionMethods at: aBehavior otherwise: nil .
    ar ifNil:[ ^ self ].
    methDict := (ar at: 1).
    methDict keysAndValuesDo: [ :aKey :aMethod |
      methDict at: aKey put: ((methDict at: aKey) _copyToForceRecompilation).
    ].
%

category: 'Categories'
method: GsPackage
removeCategory: aSymbol for: aBehavior

    | ar catDict |
  ar := self sessionMethods at: aBehavior otherwise: nil .
  ar ifNil:[ ^ self ].
  catDict := (ar at: 2).
  catDict removeKey: aSymbol otherwise: nil
%

category: 'Methods'
method: GsPackage
removeMethodAt: aSymbol for: aBehavior

  | ar methDict meth catDict stampDict pragmaDict sel |
  ar := self sessionMethods at: aBehavior otherwise: nil .
  ar ifNil: [ ^nil ].
  methDict := (ar at: 1).
  meth := methDict removeKey: aSymbol otherwise: nil .
  meth ifNil: [ ^nil ].
  stampDict := (ar at: 3).
  stampDict removeKey: aSymbol otherwise: nil .
  ar size == 4 ifTrue: [
      pragmaDict := (ar at: 4).
      pragmaDict removeKey: aSymbol otherwise: nil .
  ].
  catDict := (ar at: 2).
  sel := meth selector .
  catDict keysAndValuesDo: [:aKey :aValue |
    (aValue remove: sel otherwise: nil ) ifNotNil:[ ^ meth ].
  ].
  ^meth
%

category: 'Categories'
method: GsPackage
removeSelector: aSelector fromCategoriesFor: aBehavior
  | ar catDict removed |
  ar := self sessionMethods at: aBehavior otherwise: nil .
  ar ifNil:[ ^ false ].
  catDict := (ar at: 2).
  removed := false .
  catDict keysAndValuesDo: [:aKey :aValue |
    (aValue remove: aSelector otherwise: nil ) ifNotNil:[ removed := true ].
  ].
  ^ removed
%

category: 'Methods'
method: GsPackage
selectorsFor: aBehavior into: anArray

    | ar methDict |
    ar := self sessionMethods at: aBehavior otherwise: nil .
    ar ifNil:[ ^ self ].
    methDict := (ar at: 1).
    anArray addAll: methDict keys.
%

category: 'Categories'
method: GsPackage
selectorsIn: categoryName for: aBehavior into: anArray

    | ar catDict |
    ar := self sessionMethods at: aBehavior otherwise: nil .
    ar ifNil:[ ^ self ].
    catDict := (ar at: 2).
    (Symbol _existingWithAll: categoryName) ifNotNil:[ :sym |
      anArray addAll: (catDict at: sym otherwise: #() ).
    ]
%

category: 'Methods'
method: GsPackage
sessionInfoFor: aBehavior
	^ self
		sessionInfoFor: aBehavior
		ifAbsent: [ 
			| ar methodDict categoryDict stampDict pragmaDict |
			methodDict := GsMethodDictionary new.
			categoryDict := GsMethodDictionary new.
			stampDict := IdentityKeyValueDictionary new.
			pragmaDict := IdentityKeyValueDictionary new.
			ar := {methodDict.
			categoryDict.
			stampDict.
			pragmaDict}.
			self sessionMethods at: aBehavior put: ar.
			ar ]
%

category: 'Methods'
method: GsPackage
sessionInfoFor: aBehavior ifAbsent: absentBlock
	^ self sessionMethods at: aBehavior ifAbsent: absentBlock
%

category: 'Accessing'
method: GsPackage
sessionMethods

  ^ sessionMethods
%

category: 'Compiling'
method: GsPackage
setPragmas: pragmaArrayOrNil
forBehavior: aBehavior
forMethod: selector

  | ar methodPragmaDict |
  ar := self sessionMethods at: aBehavior otherwise: nil .
  ar ifNil:[ ^ nil ].
  ar size < 4 ifTrue: [ar at: 4 put: IdentityKeyValueDictionary new].
  methodPragmaDict := (ar at: 4) at: aBehavior otherwise: nil.
  methodPragmaDict ifNil:[
		methodPragmaDict := IdentityKeyValueDictionary new.
		(ar at: 4) at: aBehavior put: methodPragmaDict.
	].
  ^ pragmaArrayOrNil
         ifNil:[ methodPragmaDict removeKey: selector asSymbol otherwise: nil ]
         ifNotNil:[ methodPragmaDict at: selector asSymbol put: pragmaArrayOrNil ]
%

category: 'Compiling'
method: GsPackage
setStamp: aStampOrNil forBehavior: aBehavior forMethod: selector
	| ar methodStampDict |
	ar := aStampOrNil
		ifNil: [ 
			"nil means we will remove session data for selector"
			self
				sessionInfoFor: aBehavior
				ifAbsent: [ 
					"no session info present for aBehavior ... we're done (see 49169)"
					^ nil ] ]
		ifNotNil: [ ar := self sessionInfoFor: aBehavior ].
	methodStampDict := (ar at: 3) at: aBehavior otherwise: nil.
	methodStampDict
		ifNil: [ 
			methodStampDict := IdentityKeyValueDictionary new.
			(ar at: 3) at: aBehavior put: methodStampDict ].
	^ aStampOrNil
		ifNil: [ methodStampDict removeKey: selector asSymbol otherwise: nil ]
		ifNotNil: [ methodStampDict at: selector asSymbol put: aStampOrNil ]
%

category: 'Accessing'
method: GsPackage
symbolDict

    ^symbolDict
%

category: 'Accessing'
method: GsPackage
symbolDict: aSymDict

    symbolDict := aSymDict
%

! Class implementation for 'GsPipeElement'

!		Class methods for 'GsPipeElement'

category: 'Instance Creation'
classmethod: GsPipeElement
newWithNext: nextElement value: aValue

"Returns a new GsPipeElement instance with the nextElement and aValue"

| element |
element := super new next: nextElement.
element value: aValue.
^element
%

!		Instance methods for 'GsPipeElement'

category: 'Accessing'
method: GsPipeElement
next

"Returns the current value of the next instance variable"
^ next
%

category: 'Updating'
method: GsPipeElement
next: anElement

next := anElement
%

category: 'Accessing'
method: GsPipeElement
value

"Returns the current value of the GsPipeElement"
^ value
%

category: 'Updating'
method: GsPipeElement
value: anObj

value := anObj
%

category: 'Reduced Conflict Support'
method: GsPipeElement
_abortAndReplay: conflictObjects

"Abort the receiver, no replay necessary."

" refresh the state of the receiver "
self _selectiveAbort.

^ true
%

! Class implementation for 'Locale'

!		Class methods for 'Locale'

category: 'Accessing'
classmethod: Locale
currencySymbol

   "Return appropriate instvar from the current Locale instance"
   ^self current currencySymbol
%

category: 'Accessing'
classmethod: Locale
current

"Get the current Locale instance from session transient state.
  If we dont have one, go ahead and initialize one "

| locale systm |
systm := System .
( locale := systm __sessionStateAt: 16 ) == nil ifTrue: [
    locale := systm _locale.
    systm __sessionStateAt: 16 put: locale ].
^ locale
%

category: 'Accessing'
classmethod: Locale
decimalPoint

   "Return appropriate instvar from the current Locale instance"
   ^self current decimalPoint
%

category: 'Accessing'
classmethod: Locale
fracDigits

   "Return appropriate instvar from the current Locale instance"
   ^self current fracDigits
%

category: 'Accessing'
classmethod: Locale
grouping

   "Return appropriate instvar from the current Locale instance"
   ^self current grouping
%

category: 'Accessing'
classmethod: Locale
intCurrSymbol

   "Return appropriate instvar from the current Locale instance"
   ^self current intCurrSymbol
%

category: 'Accessing'
classmethod: Locale
intFracDigits

   "Return appropriate instvar from the current Locale instance"
   ^self current intFracDigits
%

category: 'Accessing'
classmethod: Locale
monDecimalPoint

   "Return appropriate instvar from the current Locale instance"
   ^self current monDecimalPoint
%

category: 'Accessing'
classmethod: Locale
monGrouping

   "Return appropriate instvar from the current Locale instance"
   ^self current monGrouping
%

category: 'Accessing'
classmethod: Locale
monThousandsSep

   "Return appropriate instvar from the current Locale instance"
   ^self current monThousandsSep
%

category: 'Accessing'
classmethod: Locale
nCsPrecedes

   "Return appropriate instvar from the current Locale instance"
   ^self current nCsPrecedes
%

category: 'Accessing'
classmethod: Locale
negativeSign

   "Return appropriate instvar from the current Locale instance"
   ^self current negativeSign
%

category: 'Instance Creation'
classmethod: Locale
new

" Use Locale>>current instead "

self shouldNotImplement: #new
%

category: 'Accessing'
classmethod: Locale
nSepBySpace

   "Return appropriate instvar from the current Locale instance"
   ^self current nSepBySpace
%

category: 'Accessing'
classmethod: Locale
nSignPosn

   "Return appropriate instvar from the current Locale instance"
   ^self current nSignPosn
%

category: 'Accessing'
classmethod: Locale
pCsPrecedes

   "Return appropriate instvar from the current Locale instance"
   ^self current pCsPrecedes
%

category: 'Accessing'
classmethod: Locale
positiveSign

   "Return appropriate instvar from the current Locale instance"
   ^self current positiveSign
%

category: 'Accessing'
classmethod: Locale
pSepBySpace

   "Return appropriate instvar from the current Locale instance"
   ^self current pSepBySpace
%

category: 'Accessing'
classmethod: Locale
pSignPosn

   "Return appropriate instvar from the current Locale instance"
   ^self current pSignPosn
%

category: 'Updating'
classmethod: Locale
setCategory: categorySymbol locale: LocaleString

   " Modify OS locale setting.

   See man page for setlocale( ) for more details.

   Valid categories:

      #LC_CTYPE        locale's character type handling
      #LC_NUMERIC      locale's decimal handling
      #LC_TIME         locale's time handling
      #LC_COLLATE      locale's collation data
      #LC_MONETARY     locale's monetary handling
      #LC_MESSAGES     locale's messages handling
      #LC_ALL          all locale categories
   "

   | locale |
   " call the setLocale primitive "
   ( System _setCategory: categorySymbol locale: LocaleString )
      ifFalse: [ ^ nil ].
   " Now reset the transient locale info "
    locale := System _locale.
    System __sessionStateAt: 16 put: locale.
   ^ locale
%

category: 'Accessing'
classmethod: Locale
thousandsSep

   "Return appropriate instvar from the current Locale instance"
   ^self current thousandsSep
%

!		Instance methods for 'Locale'

category: 'Accessing'
method: Locale
currencySymbol

   "Return the value of the instance variable 'currencySymbol'."
   ^currencySymbol
%

category: 'Accessing'
method: Locale
decimalPoint

   "Return the value of the instance variable 'decimalPoint'."
   ^decimalPoint
%

category: 'Accessing'
method: Locale
fracDigits

   "Return the value of the instance variable 'fracDigits'."
   ^fracDigits
%

category: 'Accessing'
method: Locale
grouping

   "Return the value of the instance variable 'grouping'."
   ^grouping
%

category: 'Accessing'
method: Locale
intCurrSymbol

   "Return the value of the instance variable 'intCurrSymbol'."
   ^intCurrSymbol
%

category: 'Accessing'
method: Locale
intFracDigits

   "Return the value of the instance variable 'intFracDigits'."
   ^intFracDigits
%

category: 'Accessing'
method: Locale
monDecimalPoint

   "Return the value of the instance variable 'monDecimalPoint'."
   ^monDecimalPoint
%

category: 'Accessing'
method: Locale
monGrouping

   "Return the value of the instance variable 'monGrouping'."
   ^monGrouping
%

category: 'Accessing'
method: Locale
monThousandsSep

   "Return the value of the instance variable 'monThousandsSep'."
   ^monThousandsSep
%

category: 'Accessing'
method: Locale
nCsPrecedes

   "Return the value of the instance variable 'nCsPrecedes'."
   ^nCsPrecedes
%

category: 'Accessing'
method: Locale
negativeSign

   "Return the value of the instance variable 'negativeSign'."
   ^negativeSign
%

category: 'Accessing'
method: Locale
nSepBySpace

   "Return the value of the instance variable 'nSepBySpace'."
   ^nSepBySpace
%

category: 'Accessing'
method: Locale
nSignPosn

   "Return the value of the instance variable 'nSignPosn'."
   ^nSignPosn
%

category: 'Accessing'
method: Locale
pCsPrecedes

   "Return the value of the instance variable 'pCsPrecedes'."
   ^pCsPrecedes
%

category: 'Accessing'
method: Locale
positiveSign

   "Return the value of the instance variable 'positiveSign'."
   ^positiveSign
%

category: 'Accessing'
method: Locale
pSepBySpace

   "Return the value of the instance variable 'pSepBySpace'."
   ^pSepBySpace
%

category: 'Accessing'
method: Locale
pSignPosn

   "Return the value of the instance variable 'pSignPosn'."
   ^pSignPosn
%

category: 'Accessing'
method: Locale
thousandsSep

   "Return the value of the instance variable 'thousandsSep'."
   ^thousandsSep
%

! Class implementation for 'LogEntry'

!		Instance methods for 'LogEntry'

category: 'Accessing'
method: LogEntry
argArray

"Returns the value of the instance variable 'argArray'."

^argArray
%

category: 'Replaying'
method: LogEntry
printObj: obj
  obj isSpecial ifTrue:[ ^ obj printString ,' ' ].
  obj _isSymbol ifTrue:[ ^ obj printString ,' ' ].
  ^ ' ', obj asOop asString,'(a ', obj class name,') '
%

category: 'Formatting'
method: LogEntry
printOn: aStream

"Puts a displayable representation of the receiver on the given stream."

aStream tab; nextPutAll: '(', selector printString, ' withArgs: '; cr.
argArray do: [:obj |
    aStream tab; tab; nextPutAll: ' [', obj class printString, ', ', obj asOop printString, '] '; cr.
].
aStream tab; nextPutAll: ')'; cr.
%

category: 'Accessing'
method: LogEntry
receiver

"Returns the value of the instance variable 'receiver'."

^receiver
%

category: 'Updating'
method: LogEntry
receiver: anObj selector: aSymbol argArray: newValue
  receiver := anObj .
  selector := aSymbol .
  argArray := newValue
%

category: 'Replaying'
method: LogEntry
redo

"Replays the message send for the receiver log entry."
| details|
(details := System _gemCommitConflictDetails) > 1 ifTrue: [ 
  (details > 2 or:[ (SessionTemps current increment: #LogEntry_redoCount) < 20 ]) ifTrue:[
    | str sz |
    str :=  '--- LogEntry redo( ' , (self printObj: receiver), selector printString, ' args:(' .
    1 to: (sz := argArray size) do:[:n | | elem |
      elem := argArray at: n .
      str addAll: ( self printObj: elem) .
      n < sz ifTrue:[ str add: $, ].
    ].
    str add: '))' .
    GsFile gciLogServer:str 
  ] .
].
^ receiver perform: selector withArguments: argArray
%

category: 'Accessing'
method: LogEntry
selector

"Returns the value of the instance variable 'selector'."

^selector
%

! Class implementation for 'RcCounterElement'

!		Class methods for 'RcCounterElement'

category: 'Instance Creation'
classmethod: RcCounterElement
new

"Creates and returns a new instance of the receiver."

^ self basicNew initialize
%

!		Instance methods for 'RcCounterElement'

category: 'Updating'
method: RcCounterElement
decrementValueBy: aNumber

"Decrement the current value by the given amount."

value := value - aNumber
%

category: 'Updating'
method: RcCounterElement
incrementValueBy: aNumber

"Increments the current value by the given amount."

value := value + aNumber
%

category: 'Initialization'
method: RcCounterElement
initialize

"Initializes the value to be zero."

self value: 0
%

category: 'Accessing'
method: RcCounterElement
value

"Returns the value of the instance variable 'value'."

^ value
%

category: 'Updating'
method: RcCounterElement
value: newValue

"Modifies the value of the instance variable 'value'."

value := newValue
%

! Class implementation for 'RcQueueElement'

!		Instance methods for 'RcQueueElement'

category: 'Accessing'
method: RcQueueElement
createTime

"Returns the value of the element's time stamp, the createTime instance
 variable."

^createTime
%

category: 'Updating'
method: RcQueueElement
createTime: newValue

"Modifies the value of the time stamp, the createTime instance variable."

createTime := newValue
%

category: 'Comparing'
method: RcQueueElement
createTimeAsGmt2005

"Convert our create time, which is always in gmt95 format,
 to a timestamp with gmt2005 format."
^createTime - 315619200
%

category: 'Comparing'
method: RcQueueElement
createTimeAsGmt95

"createTime is always gmt95 for RcQueueElement"
^createTime
%

category: 'Accessing'
method: RcQueueElement
createTimeUs

"There is no microsecond timestamp in RcQueueElement, so answer zero."

^0
%

category: 'Comparing'
method: RcQueueElement
isOlderThan: anotherElementOrEntry

"Compare the creation time of this object to that of anotherElementOrEntry,
 which must be an instance of RcQueueElement or RcQueueEntry object.
 Answers true if this object is older than anotherElementOrEntry or
 if anotherElementOrEntry is nil.   Answers false otherwise."

(anotherElementOrEntry == nil)
  ifTrue:[^true].

^self createTimeAsGmt2005 < anotherElementOrEntry createTimeAsGmt2005
%

category: 'Storing and Loading'
method: RcQueueElement
loadNamedIVsFrom: passiveObj

"Reads named instance variables from the given passive object.  The
 first instance variable should already have been parsed and be
 available in the passiveObj argument."

| name offset nameSym aValue |

passiveObj version >= 500 ifTrue:[ ^ super loadNamedIVsFrom: passiveObj ].

[ name := passiveObj ivName.
  name ifNotNil: [
    nameSym := Symbol _existingWithAll: name .
    nameSym ifNotNil:[
      offset := self class _ivOffsetOf: nameSym.
      offset ifNotNil:[
        aValue := passiveObj ivValue .
        (offset == 3"createTime" and:[ aValue ~~ nil]) ifTrue:[
          aValue := aValue - 788922768 "convert timeGmt to timeGmt95" .
          ].
        self instVarAt: offset put: aValue .
      ] ifNil:[
         self dynamicInstVarAt: nameSym put: passiveObj ivValue
      ].
    ] ifNil:[
      self dynamicInstVarAt: name asSymbol put: passiveObj ivValue
    ].
    passiveObj readNamedIV
  ] ifNil: [
    false
  ]
] untilFalse.

passiveObj skipNamedInstVars.
%

category: 'Accessing'
method: RcQueueElement
sequenceNumber

"Returns the value of this element's retrieval sequence indicator,
 the sequenceNumber instance variable."

^sequenceNumber
%

category: 'Updating'
method: RcQueueElement
sequenceNumber: newValue

"Modifies the value of the sequenceNumber instance variable."

sequenceNumber := newValue
%

category: 'Updating'
method: RcQueueElement
setTimestamp

"Sets the timestamp for this entry."
 createTime := System timeGmt2005.
%

category: 'Accessing'
method: RcQueueElement
value

"Returns the object stored in this queue element, the value instance variable."

^value
%

category: 'Updating'
method: RcQueueElement
value: newValue

"Assigns a new object to this queue element."

value := newValue
%

! Class implementation for 'RcQueueEntry'

!		Class methods for 'RcQueueEntry'

category: 'Instance Creation'
classmethod: RcQueueEntry
newWithValue: anObject
sequenceNumber: aSmallInt
inObjectSecurityPolicyOf: parentObj
"Return a new instance of the receiver containing anObject as the value and
 aSmallInt as the sequence number.  This method also fills in the createTime
 and createTimeUs instance variables with the current time."

<primitive: 616>
aSmallInt _validateClass: SmallInteger .
^self _primitiveFailed: #newWithValue:sequenceNumber:inObjectSecurityPolicy:
      args: { anObject . aSmallInt . parentObj } .
%

category: 'Deprecated'
classmethod: RcQueueEntry
newWithValue: anObject
sequenceNumber: aSmallInt
inSegmentOf: parentObj

self deprecated: 'newWithValue:sequenceNumber:inSegmentOf: Deprecated before v3.2, use newWithValue:sequenceNumber:inObjectSecurityPolicyOf:'.
	^self
		newWithValue: anObject
		sequenceNumber: aSmallInt
		inObjectSecurityPolicyOf: parentObj
%

!		Instance methods for 'RcQueueEntry'

category: 'Comparing'
method: RcQueueEntry
createTimeAsGmt2005

"Return the create time in gmt2005 format,
 which we always use for createTime."
^createTime
%

category: 'Comparing'
method: RcQueueEntry
createTimeAsGmt95

"Return the create time in gmt95 format.  We add a constant to our
 create time, which is always in gmt2005 format."
^createTime + 315619200.
%

category: 'Accessing'
method: RcQueueEntry
createTimeUs

"Returns the value of the entry's microsecond timestamp, the createTimeUs instance
 variable."

^createTimeUs
%

category: 'Updating'
method: RcQueueEntry
createTimeUs: newValue

"Modifies the value of the microsecond timestamp, the createTimeUs instance variable."

createTimeUs := newValue
%

category: 'Comparing'
method: RcQueueEntry
isOlderThan: anotherElementOrEntry

"Compare the creation time of this object to that of anotherElementOrEntry,
 which must be an instance of RcQueueElement or RcQueueEntry object.
 Answers true if this object is older than anotherElementOrEntry or
 if anotherElementOrEntry is nil.   Answers false otherwise."

anotherElementOrEntry == nil
  ifTrue:[^true].

^(createTime == anotherElementOrEntry createTimeAsGmt2005)
  ifTrue:[createTimeUs < anotherElementOrEntry createTimeUs]
  ifFalse:[createTime < anotherElementOrEntry createTimeAsGmt2005].
%

! Class implementation for 'RedoLog'

!		Class methods for 'RedoLog'

category: 'Instance Creation'
classmethod: RedoLog
new

"Create a new initialized instance."

^ self basicNew initialize
%

!		Instance methods for 'RedoLog'

category: 'Logging'
method: RedoLog
addConflictObject: aConflictObject for: aRedoObject

"Add an entry in the conflictObjects dictionary, mapping the given
 conflictObject to the given redo object."
| conflicts |
((conflicts := conflictObjects) at: aConflictObject otherwise: nil) == nil
    ifTrue: [ conflicts at: aConflictObject put: aRedoObject ].
%

category: 'Logging'
method: RedoLog
addFirstLogEntry: aLogEntry for: redoObj forConflictObject: aConflictObject
  "Make the given log entry the first entry for redoObj.  
   Update the conflict objects and redo object dictionary."
  | conflicts redos |
  ((conflicts := conflictObjects) at: aConflictObject otherwise: nil) ifNil:[
    conflicts at: aConflictObject put: redoObj 
  ].
  ((redos := redoObjects) at: redoObj otherwise: nil) 
    ifNotNil:[ :logArray | logArray insertAll: { aLogEntry } at: 1 ]
       ifNil:[ redos at: redoObj put: { aLogEntry } ].
%

category: 'Logging'
method: RedoLog
addLargeConflictObject: aConflictObject for: aRedoObject

"Add an entry in the conflictObjects dictionary, mapping the given
 conflictObject (and all internal nodes for large objects) to the given redo object."

| ar conflicts |
aConflictObject _isLarge
  ifFalse: [ ^ self addConflictObject: aConflictObject for: aRedoObject ].

"Get all internal nodes for aConflictObject (including aConflictObject) and add aRedoObject for each of them"
ar := aConflictObject _getInternalNodes.
conflicts := conflictObjects .
1 to: ar size do: [:j | | each |
  each := ar at: j .
  (conflicts at: each otherwise: nil)
    ifNil: [ conflicts at: each put: aRedoObject ].
].
%

category: 'Logging'
method: RedoLog
addLogEntry: aLogEntry

  "Add the given log entry to the log.  Update the redo object dictionary."
  | redoObj redos |
  redoObj := aLogEntry receiver.
  ((redos := redoObjects) at: redoObj otherwise: nil) 
    ifNotNil:[ :logArray | logArray add: aLogEntry ]
       ifNil:[  redos at: redoObj put: { aLogEntry } ].
%

category: 'Logging'
method: RedoLog
addLogEntry: aLogEntry for: redoObj conflictObject: obj1 conflictObject: obj2
  "Add the given log entry to the log.  Update the conflict objects and redo
   object dictionary."
  | conflicts redos |
  ((conflicts := conflictObjects) at: obj1 otherwise: nil) ifNil:[
    conflicts at: obj1 put: redoObj 
  ].
  (conflicts at: obj2 otherwise: nil) ifNil:[
    conflicts at: obj2 put: redoObj 
  ].
  ((redos := redoObjects) at: redoObj otherwise: nil) 
    ifNotNil:[ :logArray | logArray add: aLogEntry ]
       ifNil:[ redos at: redoObj put: { aLogEntry } ].
%

category: 'Logging'
method: RedoLog
addLogEntry: aLogEntry for: redoObj forConflictObject: aConflictObject
  "Add the given log entry to the log.  Update the conflict objects and redo
   object dictionary."
  | conflicts redos |
  ((conflicts := conflictObjects) at: aConflictObject otherwise: nil) ifNil:[
    conflicts at: aConflictObject put: redoObj 
  ].
  ((redos := redoObjects) at: redoObj otherwise: nil) 
    ifNotNil:[ :logArray | logArray add: aLogEntry ]
       ifNil:[ redos at: redoObj put: { aLogEntry } ].
%

category: 'Logging'
method: RedoLog
addLogEntry: aLogEntry for: redoObj forLargeConflictObject: aLargeConflictObject

"Add the given log entry to the log.  Update the conflict objects and redo
 object dictionary."

| ar conflicts redos |
aLargeConflictObject _isLarge
  ifFalse: [ ^ self addLogEntry: aLogEntry for: redoObj forConflictObject: aLargeConflictObject ].

"Get all internal nodes for aLargeConflictObject (including aConflictObject) and add aRedoObject for each of them"
ar := aLargeConflictObject _getInternalNodes.
conflicts := conflictObjects .
1 to: ar size do: [:j | | aConflictObject |
  aConflictObject := ar at: j .
  (conflicts at: aConflictObject otherwise: nil)
    ifNil: [ conflicts at: aConflictObject put: redoObj ] 
].

((redos := redoObjects) at: redoObj otherwise: nil) 
  ifNotNil:[ :logArray | logArray add: aLogEntry ]
     ifNil:[ redos at: redoObj put: { aLogEntry } ].
%

category: 'Accessing'
method: RedoLog
conflictObjects

"Returns the value of the instance variable 'conflictObjects'."

^conflictObjects
%

category: 'Updating'
method: RedoLog
conflictObjects: newValue

"Modify the value of the instance variable 'conflictObjects'."

conflictObjects := newValue
%

category: 'Accessing'
method: RedoLog
conflictObjectsSet

"Returns a set of all conflict objects that were written.  These are the
 objects of possible conflict with other sessions."

^ conflictObjects keys
%

category: 'Testing'
method: RedoLog
getLogEntriesFor: aRedoObject

"Returns the Array of log entries for the give redo object.  If there
 are none, returns nil."

^ redoObjects at: aRedoObject otherwise: nil.
%

category: 'Commit Processing'
method: RedoLog
getRedoObjectForConflictingObject: aConflictObject

"Returns the redo object that contains the given conflict object that
 conflicted on a commit operation."

| obj |
" first see if a mapping is located in the conflictObjects dictionary "
obj := conflictObjects at: aConflictObject otherwise: nil.
obj ifNil: [
  "if there is a mapping in the redoObjects dictionary,
   returns the argument "
   (redoObjects at: aConflictObject otherwise: nil) ifNotNil: [ ^ aConflictObject ]
].
^ obj
%

category: 'Initializing'
method: RedoLog
initialize

"Initialize the conflictObjects and redoObjects instance variables to new
 Dictionaries."

conflictObjects := IdentityKeyValueDictionary new: 53.
conflictObjects collisionLimit: 1152921504606846975 "SmallInteger maximumValue".
redoObjects := IdentityKeyValueDictionary new: 53.
redoObjects collisionLimit: 1152921504606846975 .
%

category: 'Formatting'
method: RedoLog
printConflictObjects
  | str |
  str := String new .
  conflictObjects keysDo:[:aKey |
    str add: aKey asOop asString ;
       add: '(a'; add: aKey class name ; add: ') '.
  ].
  ^ str
%

category: 'Formatting'
method: RedoLog
printOn: aStream

"Puts a displayable representation of the receiver on the given stream."

aStream nextPutAll: 'Conflicts ('.
aStream cr.
conflictObjects keysAndValuesDo: [:conflictObj :redoObj |
    aStream nextPutAll: '[', conflictObj class printString, ', ', conflictObj asOop printString, ']'.
    aStream nextPutAll: '->'.
    aStream nextPutAll: '[', redoObj class printString, ', ', redoObj asOop printString, ']'.
  ].
aStream nextPutAll: ')'; cr.
aStream nextPutAll: 'Redo ('.
aStream cr.
redoObjects keysAndValuesDo: [:redoObj :logEntries|
    aStream nextPutAll: '[', redoObj class printString, ', ', redoObj asOop printString, ']'.
    aStream cr.
    logEntries do: [:logEntry |
      aStream nextPutAll: logEntry printString
    ].
  ].
aStream nextPutAll: ')'.
%

category: 'Accessing'
method: RedoLog
redoObjects

"Returns the value of the instance variable 'redoObjects'."

^redoObjects
%

category: 'Updating'
method: RedoLog
redoObjects: newValue

"Modify the value of the instance variable 'redoObjects'."

redoObjects := newValue
%

category: 'Private'
method: RedoLog
_commitNested: aRedoLog
  "Used during System class >> _commitNestedTransaction .
  self is the redo log for the parent transaction level.
  aRedoLog is the redo log for the nested transaction being committed.
  Merge contents of aRedoLog into self ."

  aRedoLog conflictObjects keysAndValuesDo:[:argKey :argVal |
    (conflictObjects at: argKey otherwise:nil) ifNotNil:[:aVal |
      argVal == aVal ifFalse:[
        System disableCommitsUntilAbortWithReason:'commitNested RedoLog merge failure'.
        Error signal: 'RedoLog conflict objects merge failure, key oop ',
           argKey asOop asString,' value oop ', aVal asOop asString,
           ' != nested value oop ', argVal asOop asString .
      ]
    ] ifNil:[ conflictObjects at: argKey put: argVal ].
  ].
  aRedoLog redoObjects keysAndValuesDo:[:argKey :argVal |
    (redoObjects at: argKey otherwise:nil) ifNotNil:[:arr |
      arr addAll: argVal .
    ] ifNil:[
      redoObjects at: argKey put: argVal
    ]
  ].
%

category: 'Commit Processing'
method: RedoLog
_redoOperationsForEntries: logEntries
" caller must ensure logEntries is non-nil "
1 to: logEntries size do: [ :i |
    (logEntries at: i) redo ifFalse: [ ^ false ]
].
^ true
%

! Class implementation for 'SystemLoginNotification'

!		Class methods for 'SystemLoginNotification'

category: 'Notification'
classmethod: SystemLoginNotification
sessionStart
    "Nothing by default"
%

! Class implementation for 'TransactionBoundaryDefaultPolicy'

!		Class methods for 'TransactionBoundaryDefaultPolicy'

category: 'accessing'
classmethod: TransactionBoundaryDefaultPolicy
current

	Current == nil ifTrue: [ Current := self basicNew initialize ].
	^Current
%

category: 'installation'
classmethod: TransactionBoundaryDefaultPolicy
install

    Current := nil.
    ^self installCurrent
%

category: 'installation'
classmethod: TransactionBoundaryDefaultPolicy
installCurrent

    System _commitCoordinator: self current.
    ^self current
%

category: 'testing'
classmethod: TransactionBoundaryDefaultPolicy
isActive

    ^(Current ~~ nil) and: [Current isActive]
%

category: 'installation'
classmethod: TransactionBoundaryDefaultPolicy
uninstall

    Current := nil.
%

!		Instance methods for 'TransactionBoundaryDefaultPolicy'

category: 'commit coordinator'
method: TransactionBoundaryDefaultPolicy
abort
    | res |
    res := System _localAbort.
    self transactionBoundary: #abort.
    ^res
%

category: 'commit coordinator'
method: TransactionBoundaryDefaultPolicy
beginTransaction
    | res |
    res := System _localBeginTransaction.
    self transactionBoundary: #beginTransaction.
    ^res
%

category: 'updating'
method: TransactionBoundaryDefaultPolicy
classChanged
	"by default do nothing"
%

category: 'commit coordinator'
method: TransactionBoundaryDefaultPolicy
commit: commitMode
    | res |
    (res := System _localCommit: commitMode)
        ifTrue: [ self transactionBoundary: #commit ].
    ^res
%

category: 'initialization'
method: TransactionBoundaryDefaultPolicy
initialize
	"by default do nothing"
%

category: 'testing'
method: TransactionBoundaryDefaultPolicy
isActive

    ^true
%

category: 'updating'
method: TransactionBoundaryDefaultPolicy
sessionMethodChanged
	"by default do nothing"
%

category: 'private-actions'
method: TransactionBoundaryDefaultPolicy
transactionBoundary: transactionSymbol
	"by default do nothing"
%

category: 'commit coordinator'
method: TransactionBoundaryDefaultPolicy
transactionMode: newMode
    | res |
    res := System _localTransactionMode: newMode.
    self transactionBoundary: #transactionMode.
    ^res
%

! Class implementation for 'Upgrade2A'

!		Class methods for 'Upgrade2A'

category: 'Image Upgrade'
classmethod: Upgrade2A
initialize
  "Create classes in GemStone_Portable_Streams.
   Note the classes in GemStone_Legacy_Streams were created in bom.c"
  | blk |
blk := [:aClass |
 GsFile gciLogServer: 'created ', aClass name,'  oop ', aClass asOop asString ,
   ' superclass ' , aClass superclass asOop asString 
  ].
blk value:(
Stream
  subclass: 'PositionableStream'
  instVarNames: #( collection position readLimit )
  inDictionary: GemStone_Portable_Streams  ).
blk value:(
(GemStone_Portable_Streams at: #PositionableStream)
  subclass: 'ReadStream'
  instVarNames: #(  )
  inDictionary: GemStone_Portable_Streams ).
blk value:(
(GemStone_Portable_Streams at: #PositionableStream)
  subclass: 'WriteStream'
  instVarNames: #( writeLimit )
  classVars: #( Cr CrLf CrTab )
  classInstVars: #(  )
  poolDictionaries: #()
  inDictionary: GemStone_Portable_Streams
  options: #() ) .
blk value:(
(GemStone_Portable_Streams at: #WriteStream)
  subclass: 'ReadWriteStream'
  instVarNames: #(  )
  inDictionary: GemStone_Portable_Streams ).
blk value:(
(GemStone_Portable_Streams at: #ReadWriteStream)
  subclass: 'FileStream'
  instVarNames: #( gsfile streamType )
  inDictionary: GemStone_Portable_Streams ).

blk value:(
(GemStone_Portable_Streams at: #ReadStream)
  subclass: 'ReadByteStream'
  instVarNames: #(  )
  inDictionary: GemStone_Portable_Streams ).
blk value:(
(GemStone_Legacy_Streams at: #ReadStream)
  subclass: 'ReadByteStream'
  instVarNames: #(  )
  inDictionary: GemStone_Legacy_Streams ).

(Globals associationAt:#GsFileIn otherwise:nil) ifNotNil:[:assoc |
   assoc value instSize < 17 ifTrue:[
     | cls |
     cls := assoc value.
     cls _unsafeAt: 11 put: #ObsoleteGsFileIn.
     GsFile gciLogServer:'GsFileIn renamed to ObsoleteGsFileIn'.
     Globals removeAssociation: assoc .
     assoc key: cls name.
     ObsoleteClasses addAssociation: assoc .
     GsFile gciLogServer:'ObsoleteGsFileIn moved to ObsoleteClasses'.
     ].
  ].
^ true
%

! Class implementation for 'PrintStream'

!		Class methods for 'PrintStream'

category: 'Instance Creation'
classmethod: PrintStream
on: aCollection

"Returns an instance of the receiver that can stream over the elements of
 aCollection.  The maximum size of the receiver is set to 536870911."

| newStream |

newStream := self _basicNew.
newStream _initStreamWith: aCollection maxSize: 536870911 .
^ newStream
%

category: 'Instance Creation'
classmethod: PrintStream
printingOn: aCollection

"Returns an instance of the receiver that can stream over the elements of
 aCollection. The maximum size of the receiver is set to 100000."

^ self printingOn: aCollection maxSize: 100000
%

category: 'Instance Creation'
classmethod: PrintStream
printingOn: aCollection maxSize: n


| newStream |

newStream := self _basicNew.
newStream _initStreamWith: aCollection maxSize: n .
^ newStream
%

!		Instance methods for 'PrintStream'

category: 'Testing'
method: PrintStream
atEnd
  ^ self shouldNotImplement: #atEnd 
%

category: 'Accessing'
method: PrintStream
contents

"Returns the Collection associated with the receiver (that is,
 the sequence of objects that the receiver may access)."

^ itsCollection
%

category: 'Testing'
method: PrintStream
isEmpty

"Returns true if the collection that the receiver accesses contains
 no elements; otherwise returns false."

^ itsCollection size == 0
%

category: 'Testing'
method: PrintStream
isFull

"Returns true if the size of the collection that the receiver accesses
 is equal or greater than maxSize."

^ approxPosition >= maxSize
%

category: 'Accessing'
method: PrintStream
maxSize

"Returns the maxSize of the receiver."

^ maxSize
%

category: 'Accessing'
method: PrintStream
next
  ^ self shouldNotImplement: #next
%

category: 'Adding'
method: PrintStream
nextPut: anObject

"If there's room, add anObject to the stream.
 If adding anObject would exceed maxSize, trigger overflow behavior.

 Returns anObject.
"

(self isFull) ifFalse: [
  approxPosition := approxPosition + 1.
  (approxPosition < maxSize)
  ifTrue: [  itsCollection addLast: anObject ]
  ifFalse: [ self overflow ]].
^ anObject
%

category: 'Adding'
method: PrintStream
nextPutAll: aCollection

"If there's room, add the elements of aCollection to the stream.
 If adding aCollection would exceed maxSize, add part of aCollection
 to stream up to maxSize and then trigger overflow behavior.
 Use #_basicSize to estimate size of aCollection, since #size can be
 expensive for certain classes.

 Returns aCollection.  "
| ap |
ap := approxPosition + aCollection size .
ap < maxSize ifTrue:[
  itsCollection addAll: aCollection  .
  approxPosition := ap .
] ifFalse:[
  self isFull ifFalse:[
     itsCollection replaceFrom: itsCollection size + 1 to: maxSize
			with: aCollection startingAt: 1 .
     approxPosition := maxSize .
     self overflow
  ]
].
^ aCollection
%

category: 'Adding'
method: PrintStream
nextPutAllBytes: aCharacterCollection
  ^ self shouldNotImplement: #nextPutAllBytes: 
%

category: 'Positioning'
method: PrintStream
overflow

"Do whatever is appropriate when we try to exceed maxSize.
 For a CharacterCollection, add ellipses.
 For anything else, trigger #rtErrBadStreamPosition.
"

(itsCollection isKindOf: CharacterCollection)
  ifTrue: [ itsCollection addAll: '. . .' ]
  ifFalse: [self _error: #rtErrBadStreamPosition args: { approxPosition }]
%

category: 'Positioning'
method: PrintStream
position

"Returns the receiver's approximate position reference for accessing the
 sequence of objects. "

^ itsCollection _basicSize
%

category: 'Adding'
method: PrintStream
print: anObject

	anObject printOn: self.
%

category: 'Accessing'
method: PrintStream
_collection

"Returns the collection of the receiver."

^itsCollection
%

category: 'Converting'
method: PrintStream
_convertToISOLatin

"Converts the receiver's collection from String to ISOLatin.
 Has no effect if the receiver's collection is already an ISOLatin, or
 if the receiver's collection is something other than a String, such as
 a GsFile or a JISString."

| oldStr |

itsCollection class == String ifTrue:[
  oldStr := itsCollection .
  itsCollection := ISOLatin withAll: oldStr  .
  ]
%

category: 'Positioning'
method: PrintStream
_initStreamWith: aCollection maxSize: aMaxSize

"Initializes the receiver's 'itsCollection' instance variable to be
 aCollection."

itsCollection := aCollection.
maxSize := aMaxSize .
approxPosition := 0 .
%

category: 'Adding'
method: PrintStream
_nextPut: anObject

"Add anObject to the stream, regardless of maxSize."

approxPosition := approxPosition + 1.
itsCollection addLast: anObject.
^ anObject
%

! Class implementation for 'SessionTemps'

!		Class methods for 'SessionTemps'

category: 'Session Temporaries'
classmethod: SessionTemps
current
^ (System __sessionStateAt: 1) ifNil:[
  System __sessionStateAt: 1 put: SessionTemps new .
  System __sessionStateAt: 1
].
%

!		Instance methods for 'SessionTemps'

category: 'Updating'
method: SessionTemps
at: aSymbol put: aValue
  ^ super _at: aSymbol putNoStub: aValue .
%

category: 'Updating'
method: SessionTemps
increment: aSymbol
  "Increment the value at the given symbol by 1. 
   If aSymbol not found as a key assume previous value was zero .
   Returns the SmallInteger value after increment."
  | assoc val |
  assoc := self associationAt: aSymbol otherwise: nil .
  assoc ifNil:[ ^ self at: aSymbol put: 1 ].
  val := assoc _value + 1 .
  assoc _value: val .
  ^ val
%

! Class implementation for 'Bag'

!		Class methods for 'Bag'

category: 'Instance Creation'
classmethod: Bag
new

"Returns an instance of the receiver whose contents are empty."

^ (self basicNew) initialize: 0
%

category: 'Instance Creation'
classmethod: Bag
new: initialSize

"Returns an instance of the receiver whose contents are empty."

^ (self basicNew) initialize: initialSize.
%

!		Instance methods for 'Bag'

category: 'Set Arithmetic'
method: Bag
* aBagOrSet

"Intersection.  The result containing only the elements that
 are present in both the receiver and the argument aBagOrSet.

 If aBagOrSet is a kind of IdentityBag, the result is an IdentityBag,
 otherwise the result is a Bag ."

| res |
(aBagOrSet isKindOf: IdentityBag ) ifTrue:[ | s |
  s := IdentityBag new .
  dict keysAndValuesDo:[ :each :count | s add: each withOccurrences: count ]  .
  ^ s * aBagOrSet
].
res := self class new .
aBagOrSet _keysAndValuesDo:[ :each :count | | oldCnt newCnt |
  oldCnt := dict at: each otherwise: 0 .
  newCnt := oldCnt min: count .
  newCnt > 0 ifTrue:[ res add: each withOccurrences: newCnt ].
].
^ res
%

category: 'Set Arithmetic'
method: Bag
+ aBagOrSet

"Union.  The result contains exactly the elements that are
 present in either the receiver or the argument aBagOrSet.
 If aBagOrSet is a kind of IdentityBag, the result is an IdentityBag,
 otherwise result is an instance of the class of the receiver."

| res |
(aBagOrSet isKindOf: IdentityBag ) ifTrue:[
  res := IdentityBag new .
  res addAll: aBagOrSet .
  dict keysAndValuesDo:[ :each :count | res add: each withOccurrences: count ]  .
  ^ res
].
((aBagOrSet isKindOf: Bag) or:[ aBagOrSet isKindOf: Set ]) ifFalse:[
  aBagOrSet _validateKindOfClasses: { Bag . Set } .
].
res := self copy .
aBagOrSet _keysAndValuesDo:[ :each :count | res add: each withOccurrences: count ].
^ res
%

category: 'Set Arithmetic'
method: Bag
- aBagOrSet

"Difference. The result containing exactly those elements of
 the receiver that have a greater number of occurrences in the receiver than in
 the argument.
 If argument is a kind of IdentityBag, result will be an IdentityBag ,
 otherwise result is an instance of the class of the receiver."

| res |
(aBagOrSet isKindOf: IdentityBag ) ifTrue:[ | s |
  res := IdentityBag new .
  res addAll: aBagOrSet .
  s := IdentityBag new .
  dict keysAndValuesDo:[ :each :count | s add: each withOccurrences: count ]  .
  ^ res - s .
].
((aBagOrSet isKindOf: Bag) or:[ aBagOrSet isKindOf: Set ]) ifFalse:[
  aBagOrSet _validateKindOfClasses: { Bag . Set } .
].
res := self copy .
aBagOrSet _keysAndValuesDo:[ :each :count | | oldCnt |
  oldCnt := dict at: each otherwise: 0 .
  oldCnt > count ifTrue:[ res remove: each withOccurrences: count ]
                ifFalse:[ oldCnt ~~ 0 ifTrue:[ res remove: each withOccurrences: oldCnt ]].
  ] .
^ res
%

category: 'Comparing'
method: Bag
= aCollection

"Returns true if all of the following conditions are true:

 1.  The receiver and aCollection are of the same class.
 2.  The two collections are of the same size.
 3.  The corresponding elements of the receiver and aCollection are equal
     and have the same count in both."

(self == aCollection)
  ifTrue: [ ^ true ].

(self class == aCollection class)
  ifFalse: [ ^ false ].

(self size == aCollection size)
  ifFalse: [ ^ false ].

dict keysAndValuesDo: [:key :value |
  (aCollection occurrencesOf: key) = value
     ifFalse: [ ^ false ].
  ].

^ true.
%

category: 'Adding'
method: Bag
add: newObject
	"Makes newObject one of the receiver's elements and returns newObject."

	^self add: newObject withOccurrences: 1
%

category: 'Adding'
method: Bag
add: anObject withOccurrences: anInteger
	"Adds anObject anInteger number of times to the receiver and returns anObject."
	"assign _levels  so that authorization and concurrency conflicts on the
 root object can be detected."

	| originalObject numOccurrences |
	anObject == nil ifTrue: [^nil].
	(anInteger _isInteger and: [anInteger >= 0])
		ifFalse:
			[^anInteger _error: #rtErrInvalidArgument
				args: {'must be a non-negative Integer'}].

	"v3.0.1 varyingConstraints no longer enforced."
	_levels := _levels.

	"Because a Bag is equality based but the indexing objects are
    identity based, ensure the original object is used for index
    maintenance when an equal object is added more than once."

	originalObject := dict keyAt: anObject otherwise: anObject.
	_indexedPaths ~~ nil
		ifTrue: [
			anInteger timesRepeat: [
         self _updateIndexesForAdditionOf: originalObject logging: true.
      ]].
	numOccurrences := dict at: originalObject otherwise: 0.
	dict at: originalObject put: numOccurrences + anInteger.
	size := size + anInteger.
	^anObject
%

category: 'Adding'
method: Bag
addAll: aCollection

"assign _levels so that authorization and concurrency
 conflicts on the root object can be detected."
_levels := _levels .

(aCollection isKindOf: Bag)
ifFalse: [ super addAll: aCollection ]
ifTrue: [
    aCollection __dict keysAndValuesDo: [ :each :count |
        self add: each withOccurrences: count
    ]
].
^ aCollection
%

category: 'Converting'
method: Bag
asBag

"Returns a Bag with the contents of the receiver."

^ Bag withAll: self
%

category: 'Converting'
method: Bag
asIdentitySet

"Returns a Set"

^ IdentitySet withAll: dict keys
%

category: 'Converting'
method: Bag
asSet

"Returns a Set"

^ Set withAll: dict keys
%

category: 'Accessing'
method: Bag
at: anIndex

"Disallowed."

^ self shouldNotImplement: #at:
%

category: 'Updating'
method: Bag
at: anIndex put: anObject

"Disallowed."

^ self shouldNotImplement: #at:put:
%

category: 'Enumerating'
method: Bag
do: aBlock

"Evaluates the one-argument block aBlock using each element of the
 receiver. Returns the receiver."

| tmp |
"read _levels so that authorization and concurrency conflicts on the
 root object can be detected."
tmp := _levels.

dict keysAndValuesDo: [ :aKey :aValue |
  aValue timesRepeat: [ aBlock value: aKey ]
  ].

^ self.
%

category: 'Searching'
method: Bag
includes: anObject

"Returns true if anObject is equal to one of the elements of the receiver.
 Returns false otherwise."

| tmp |
"read _levels so that authorization and concurrency conflicts on the
 root object can be detected."
tmp := _levels.

^ dict includesKey: anObject
%

category: 'Searching'
method: Bag
includesIdentical: anObject

"Returns true if anObject is identical to one of the elements of the receiver.
 Returns false otherwise."

| tmp |
"read _levels so that authorization and concurrency conflicts on the
 root object can be detected."
tmp := _levels.

anObject == nil ifTrue:[ ^ false ].
^ anObject == (dict keyAt: anObject otherwise: nil)
%

category: 'Searching'
method: Bag
includesValue: anObject

"Returns true if anObject is equal to one of the elements of the receiver.
 Returns false otherwise."

| tmp |
"read _levels so that authorization and concurrency conflicts on the
 root object can be detected."
tmp := _levels.

^ dict includesKey: anObject
%

category: 'Instance Initialization'
method: Bag
initialize: initialSize

"Initializes the receiver immediately after creation. Returns the receiver."

_indexedPaths ~~ nil ifTrue:[
   dict keysAndValuesDo:[:anObj :numOcc |
      numOcc timesRepeat: [
        self _updateIndexesForRemovalOf: anObj.
        ]
      ]
   ].
dict := KeyValueDictionary new: initialSize.
size := 0.
%

category: 'Updating'
method: Bag
objectSecurityPolicy: anObjectSecurityPolicy

"Assigns the receiver and its private objects to the given security policy."

super objectSecurityPolicy: anObjectSecurityPolicy .
dict objectSecurityPolicy: anObjectSecurityPolicy  .
%

category: 'Searching'
method: Bag
occurrencesOf: anObject

"Returns the number of the receiver's elements that are equal to anObject."

| tmp |
"read _levels so that authorization and concurrency conflicts on the
 root object can be detected."
tmp := _levels.

^ dict at: anObject otherwise: 0 .
%

category: 'Copying'
method: Bag
postCopy

 super postCopy .
 dict := dict copy .
%

category: 'Hashing'
method: Bag
rehash

"Rebuilds the receiver to ensure its consistency. Returns the receiver."

"assign _levels  so that authorization and concurrency conflicts on the
 root object can be detected."
_levels := _levels .

dict _rebuild.
^self.
%

category: 'Removing'
method: Bag
remove: anObject ifAbsent: anExceptionBlock

"Removes an object that is equivalent to anObject from the receiver and
 returns anObject.  If several elements of the receiver are equivalent to
 anObject, only one instance is removed.  If anObject has no equivalent
 elements in the receiver, this method evaluates anExceptionBlock and returns
 the result."

"assign _levels  so that authorization and concurrency conflicts on the
 root object can be detected."

| count |
count := dict at: anObject otherwise: 0.
count == 0 ifTrue: [^anExceptionBlock value].
_levels := _levels .
_indexedPaths == nil ifFalse:[
   | originalObject |
     "Since a Bag is equality based, use the originally added object
     for index maintenance. Index objects have identity based
     methods."

     originalObject := dict keyAt: anObject otherwise: nil.
     originalObject == nil ifTrue:
         [self error: 'Internal Gemstone error, a Bag''s contents are suspect.'].
      self _updateIndexesForRemovalOf: originalObject.
    ].
count > 1
    ifTrue: [dict at: anObject put: count - 1]
    ifFalse: [dict removeKey: anObject].
size := size - 1.
^anObject
%

category: 'Removing'
method: Bag
remove: anObject withOccurrences: anInteger
	"Remove anObject anInteger number of times to the receiver and returns anObject."
	"assign _levels  so that authorization and concurrency conflicts on the
 root object can be detected."

	| originalObject numOccurrences finalCount |
	anObject == nil ifTrue: [^nil].
	(anInteger _isInteger and: [anInteger >= 0])
		ifFalse:
			[^anInteger _error: #rtErrInvalidArgument
				args: {'must be a non-negative Integer'}].

	"Because a Bag is equality based but the indexing objects are
    identity based, ensure the original object is used for index
    maintenance when an equal object is removed more than once."

	originalObject := dict keyAt: anObject otherwise: nil.
	originalObject == nil ifTrue: [^self _errorNotFound: anObject].
	numOccurrences := dict at: originalObject otherwise: 0.
	anInteger > numOccurrences ifTrue: [^self _errorNotFound: anObject].
	_levels := _levels.
	_indexedPaths ~~ nil
		ifTrue: [
			anInteger timesRepeat:[
         self _updateIndexesForRemovalOf: originalObject.
    ]].
	(finalCount := numOccurrences - anInteger) > 0
		ifTrue: [dict at: originalObject put: finalCount]
		ifFalse: [dict removeKey: originalObject].
	size := size - anInteger.
	^anObject
%

category: 'Removing'
method: Bag
removeAll: aCollection

"Removes one occurrence of each element of aCollection from the
 receiver and returns the argument.  Generates an error if any
 element of aCollection is not present in the receiver."

"assign _levels  so that authorization and concurrency conflicts on the
 root object can be detected."
_levels := _levels.

aCollection == self
ifTrue:[
  self initialize: 0
] ifFalse:[
  (aCollection isKindOf: Bag)
  ifFalse: [ aCollection accompaniedBy: self do: [:me :anObject | me remove: anObject ] ]
  ifTrue: [
      aCollection __dict accompaniedBy: self keysAndValuesDo: [:me :each :count |
	  me remove: each withOccurrences: count
      ]
  ]
].
^aCollection
%

category: 'Removing'
method: Bag
removeAllPresent: aCollection

"Removes one occurrence of each element of aCollection from the
 receiver and returns the receiver.  Does not generate an error
 if any element of aCollection is not present in the receiver.
 Returns aCollection."

"assign _levels  so that authorization and concurrency conflicts on the
 root object can be detected."
_levels := _levels.

aCollection == self
ifTrue:[
    self initialize: 0
] ifFalse:[
    (aCollection isKindOf: Bag)
    ifFalse: [ super removeAllPresent: aCollection ]
    ifTrue: [
        aCollection __dict accompaniedBy: self keysAndValuesDo: [:me :each :count |
            me removeIfPresent: each withOccurrences: count
            ]
    ]
].
^aCollection
%

category: 'Removing'
method: Bag
removeIdentical: anObject ifAbsent: anExceptionBlock

"Removes an object that is Identical to anObject from the receiver and
 returns anObject.  If several elements of the receiver are identical to
 anObject, only one instance is removed.  If anObject has no equivalent
 elements in the receiver, this method evaluates anExceptionBlock and returns
 the result."

"assign _levels  so that authorization and concurrency conflicts on the
 root object can be detected."

(self includesIdentical: anObject) ifFalse: [^anExceptionBlock value].
_levels := _levels .
^self remove: anObject
%

category: 'Removing'
method: Bag
removeIfPresent: anObject withOccurrences: anInteger
	"Remove anObject anInteger number of times to the receiver and returns anObject.
 Does not generate an error if anObject is not present (or there are not
 enough occurrences)."
	"assign _levels  so that authorization and concurrency conflicts on the
 root object can be detected."

	| originalObject numOccurrences countToRemove finalCount |
	anObject == nil ifTrue: [^nil].
	(anInteger _isInteger and: [anInteger >= 0])
		ifFalse:
			[^anInteger _error: #rtErrInvalidArgument
				args: {'must be a non-negative Integer'}].

	"v3.0.1 varyingConstraints no longer enforced."

	"Because a Bag is equality based but the indexing objects are
    identity based, ensure the original object is used for index
    maintenance when an equal object is removed more than once."

	originalObject := dict keyAt: anObject otherwise: nil.
	originalObject == nil ifTrue: [^nil].
	numOccurrences := dict at: originalObject otherwise: 0.
	anInteger > numOccurrences
		ifTrue: [countToRemove := numOccurrences]
		ifFalse: [countToRemove := anInteger].
	countToRemove > 0
		ifTrue:
			[_levels := _levels.
			_indexedPaths ~~ nil
				ifTrue: [
					countToRemove timesRepeat:[
            self _updateIndexesForRemovalOf: originalObject.
        ]].
			(finalCount := numOccurrences - countToRemove) > 0
				ifTrue: [dict at: originalObject put: finalCount]
				ifFalse: [dict removeKey: originalObject].
			size := size - countToRemove].
	^anObject
%

category: 'Accessing'
method: Bag
size

"Returns the number of elements contained in the receiver."

^ size .
%

category: 'Converting'
method: Bag
_asIdentityBag

"Returns an IdentityBag that contains all of the elements of the receiver."

"Used by index creation."

| result tmp |

"read _levels so that authorization and concurrency conflicts on the
 root object can be detected."
tmp := _levels.

result := IdentityBag new .
dict keysAndValuesDo:[:aKey :numOcc|
  numOcc timesRepeat:[ result add: aKey ].
  ].
^ result
%

category: 'Private'
method: Bag
_deepCopyWith: copiedObjDict

| copy |
copy := copiedObjDict at: self otherwise: nil.
copy ~~ nil ifTrue: [ ^ copy ].

copy := self class  new: (self size).
copiedObjDict at: self put: copy.

self _deepCopyNamedIvsWith: copiedObjDict to: copy .

dict keysAndValuesDo: [ :aKey :aValue |
  aValue timesRepeat: [copy add: (aKey _deepCopyWith: copiedObjDict)]
  ].

^ copy.
%

category: 'Private'
method: Bag
_deferredGciUpdateWith: valueArray

"Private."

1 to: valueArray size do:[:j |
  self add: (valueArray at: j)
  ].
%

category: 'Searching'
method: Bag
_detect: aBlock

dict keysDo: [:each |
    (aBlock value: each)
        ifTrue:[ ^ each ].
].
^ self _error: #assocErrNoElementsDetected args: { aBlock } .
%

category: 'Searching'
method: Bag
_detect: aBlock ifNone: exceptionBlock

dict keysDo: [:each |
    (aBlock value: each)
        ifTrue:[ ^ each ].
].
^ exceptionBlock value
%

category: 'Instance Initialization'
method: Bag
_gciInitialize

"Private."

self initialize: 0 .
^ true
%

category: 'Testing'
method: Bag
_isLarge

"Returns true if the object is implemented as a tree of private smaller objects"

^ true
%

category: 'Private'
method: Bag
_keysAndValuesDo: aBlock
  "aBlock should be a 2 argument block with arguments  element, count "

  dict keysAndValuesDo:[ :each :count | aBlock value: each value: count ]
%

category: 'Searching'
method: Bag
_reject: aBlock

| result |
result:= self species new.
dict keysAndValuesDo: [:each :count |
    (aBlock value: each)
        ifFalse: [ result add: each withOccurrences: count ]
].
^ result
%

category: 'Searching'
method: Bag
_select: aBlock

| result |
result:= self species new.
dict keysAndValuesDo: [:each :count |
    (aBlock value: each)
        ifTrue: [ result add: each withOccurrences: count ]
].
^ result
%

category: 'Set Arithmetic'
method: Bag
_union: aBagOrSet

"Union with minimal result.
 An object must be present in either the receiver or the argument in order
 to appear in the result.
 For each object in the result the number of occurrances in the result
 is the maximum of the number of occurrances in the receiver or argument. "

| res |
(aBagOrSet isKindOf: IdentityBag ) ifTrue:[
  res := IdentityBag new .
  res addAll: aBagOrSet .
  dict keysAndValuesDo:[ :each :count | | occurrences resOccurrences |
    resOccurrences := res occurrencesOf: each.
    occurrences := (count max: resOccurrences) - resOccurrences.
    res add: each withOccurrences: occurrences ]  .
  ^ res
].
((aBagOrSet isKindOf: Bag) or:[ aBagOrSet isKindOf: Set ]) ifFalse:[
  aBagOrSet _validateKindOfClasses: { Bag . Set } .
].
res := self copy .
aBagOrSet _keysAndValuesDo:[ :each :count | | occurrences resOccurrences |
    resOccurrences := res occurrencesOf: each.
    occurrences := (count max: resOccurrences) - resOccurrences.
    res add: each withOccurrences: occurrences ].
^ res
%

category: 'Private'
method: Bag
__dict

^ dict
%

! Class implementation for 'Set'

!		Class methods for 'Set'

category: 'Instance Creation'
classmethod: Set
new

"Returns an instance of the receiver whose contents are empty."

^ (self basicNew) initialize: 0
%

category: 'Instance Creation'
classmethod: Set
new: initialSize

"Returns an instance of the receiver whose contents are empty."

^ (self basicNew) initialize: initialSize.
%

!		Instance methods for 'Set'

category: 'Set Arithmetic'
method: Set
* aBagOrSet

"Intersection.  The result containing only the elements that
 are present in both the receiver and the argument aBagOrSet.

 If aBagOrSet is a kind of IdentityBag, the result is an IdentityBag,
 otherwise the result is a Bag ."

 | res argIsBag |
 (aBagOrSet isKindOf: IdentityBag ) ifTrue:[ | s |
   s := IdentitySet new .
   dict keysAndValuesDo:[ :each :aVal | s add: each ]  .
   ^ s * aBagOrSet
 ].
 ((argIsBag := aBagOrSet isKindOf: Bag) or:[ aBagOrSet isKindOf: Set ]) ifFalse:[
   aBagOrSet _validateKindOfClasses: { Bag . Set } .
 ].
 res := argIsBag ifTrue:[ Bag new ] ifFalse:[ self class new ].
 aBagOrSet _keysAndValuesDo:[ :each :count | | oldVal |
   oldVal := dict at: each otherwise: nil .
   oldVal ifNotNil:[ res add: each ].
 ].
 ^ res
%

category: 'Set Arithmetic'
method: Set
+ aBagOrSet

"Union.  The result contains exactly the elements that are
 present in either the receiver or the argument aBagOrSet.
 If aBagOrSet is a kind of IdentityBag, the result is an IdentityBag.
 If aBagOrSet is a kind of IdentitySet, the result is an IdentitySet.
 If aBagOrSet is a kind of Bag, the result is a Bag ,
 otherwise result is an instance of the class of the receiver."

| res argIsBag |
(aBagOrSet isKindOf: IdentityBag ) ifTrue:[
  res := (aBagOrSet isKindOf: IdentitySet) ifTrue:[ IdentitySet new] ifFalse:[ IdentityBag new].
  res addAll: aBagOrSet .
  dict keysAndValuesDo:[ :each :count | res add: each ]  .
  ^ res
].
((argIsBag := aBagOrSet isKindOf: Bag) or:[ aBagOrSet isKindOf: Set ]) ifFalse:[
  aBagOrSet _validateKindOfClasses: { Bag . Set } .
].
argIsBag
  ifTrue:[  res := Bag new .
            self _keysAndValuesDo:[ :each :count | res add: each withOccurrences: count ]]
  ifFalse:[ res := self copy ].
aBagOrSet _keysAndValuesDo:[ :each :count | res add: each withOccurrences: count ].
^ res
%

category: 'Set Arithmetic'
method: Set
- aBagOrSet

"Difference. The result containing exactly those elements of
 the receiver that have a greater number of occurrences in the receiver than in
 the argument.
 If argument is a kind of IdentityBag, result will be an IdentitySet ,
 otherwise result is an instance of the class of the receiver."

 | res |
 (aBagOrSet isKindOf: IdentityBag ) ifTrue:[ | s |
   s := IdentitySet new .
   dict keysAndValuesDo:[ :each :aVal | s add: each ] .
   ^ s - aBagOrSet
 ].
 ((aBagOrSet isKindOf: Bag) or:[ aBagOrSet isKindOf: Set ]) ifFalse:[
   aBagOrSet _validateKindOfClasses: { Bag . Set } .
 ].
 res := self copy .
 aBagOrSet _keysAndValuesDo:[ :each :count | | oldVal |
   oldVal := dict at: each otherwise: nil .
   oldVal ifNotNil:[ res remove: each ifAbsent: nil ].
 ] .
 ^ res
%

category: 'Adding'
method: Set
add: newObject

"Makes newObject one of the receiver's elements and returns newObject.
 If an equivalent element is already present in the receiver, the
 receiver is not modified.  A set can have only one occurrence of
 equivalent objects."

"assign _levels  so that authorization and concurrency conflicts on the
 root object can be detected."
newObject == nil ifTrue: [ ^newObject ].

"v3.0.1 varyingConstraints no longer enforced."

(dict includesKey: newObject) ifFalse:[
  _levels := _levels .
  _indexedPaths ~~ nil ifTrue:[
    self _updateIndexesForAdditionOf: newObject logging: true.
    ].
  dict at: newObject put: newObject .
  ].
^ newObject.
%

category: 'Adding'
method: Set
add: anObject withOccurrences: anInteger

  anInteger == 1 ifTrue:[
    ^ self add: anObject
  ].
 "Disallowed.  Each element of a Set must be unique."
  self shouldNotImplement: #add:withOccurrences:
%

category: 'Converting'
method: Set
asSet

"Returns a Set with the contents of the receiver."

^ self
%

category: 'Accessing'
method: Set
at: anIndex

"Disallowed."

^ self shouldNotImplement: #at:
%

category: 'Updating'
method: Set
at: anIndex put: anObject

"Disallowed."

^ self shouldNotImplement: #at:put:
%

category: 'Enumerating'
method: Set
do: aBlock

"Evaluates the one-argument block aBlock using each element of the
 receiver.  Returns the receiver."

| tmp |
"read _levels so that authorization and concurrency conflicts on the
 root object can be detected."
tmp := _levels.

dict keysDo: [ :aKey | aBlock value: aKey ].
^ self.
%

category: 'Searching'
method: Set
includes: anObject

"Returns true if anObject is equal to one of the elements of the receiver.
 Returns false otherwise."

| tmp |
"read _levels so that authorization and concurrency conflicts on the
 root object can be detected."
tmp := _levels.

^ dict includesKey: anObject.
%

category: 'Searching'
method: Set
includesIdentical: anObject

"Returns true if anObject is identical to one of the elements of the receiver.
 Returns false otherwise."

| tmp |
"read _levels so that authorization and concurrency conflicts on the
 root object can be detected."
tmp := _levels.

anObject == nil ifTrue:[ ^ false ].
^ anObject == (dict keyAt: anObject otherwise: nil)
%

category: 'Searching'
method: Set
includesValue: anObject

"Returns true if anObject is equal to one of the elements of the receiver.
 Returns false otherwise."

| tmp |
"read _levels so that authorization and concurrency conflicts on the
 root object can be detected."
tmp := _levels.

^ dict includesKey: anObject

%

category: 'Private'
method: Set
initialize: initialSize

"Initializes the receiver immediately after creation.  Returns the receiver."

_indexedPaths ~~ nil ifTrue:[
   dict keysDo:[:anObj |  self _updateIndexesForRemovalOf: anObj  ]
   ].
dict := KeyValueDictionary new: initialSize.
%

category: 'Updating'
method: Set
objectSecurityPolicy: anObjectSecurityPolicy

"Assigns the receiver and its private objects to the given security policy."

super objectSecurityPolicy: anObjectSecurityPolicy.
dict ifNotNil:[ dict objectSecurityPolicy: anObjectSecurityPolicy ]
%

category: 'Searching'
method: Set
occurrencesOf: anObject

"Returns the number of the receiver's elements that are equal to anObject."

| tmp |
"read _levels so that authorization and concurrency conflicts on the
 root object can be detected."
tmp := _levels.

(dict includesKey: anObject)
  ifTrue: [ ^ 1 ].

^ 0.
%

category: 'Copying'
method: Set
postCopy

"Cleanup new copy."

 super postCopy .
 dict := dict copy .
%

category: 'Hashing'
method: Set
rehash

"Rebuilds the receiver to ensure its consistency.  Returns the receiver."

"assign _levels  so that authorization and concurrency conflicts on the
 root object can be detected."
_levels := _levels .

dict _rebuild.
^self
%

category: 'Removing'
method: Set
remove: anObject

"Removes from the receiver one object that is equivalent to anObject and
 returns anObject.  Generates an error if anObject has no equivalent element
 in the receiver."

^ self remove: anObject ifAbsent:[ self _errorNotFound: anObject ]
%

category: 'Removing'
method: Set
remove: anObject ifAbsent: anExceptionBlock

"Removes from the receiver one object that is equivalent to anObject and
 returns anObject. If anObject has no equivalent elements in the receiver,
 evaluates anExceptionBlock and returns the result."

| removedObj |

"assign _levels  so that authorization and concurrency conflicts on the
 root object can be detected."

anObject ifNil:[ ^ anExceptionBlock value ].
_levels := _levels .
_indexedPaths ~~ nil ifTrue:[
  removedObj := dict at: anObject otherwise: nil .
  removedObj ~~ nil ifTrue:[
    _levels := _levels .
    self _updateIndexesForRemovalOf: removedObj.
    dict removeKey: removedObj ifAbsent:[ self _halt:'Set remove failed' ].
  ] ifFalse:[ ^ anExceptionBlock value ].
 ] ifFalse:[
  dict removeKey: anObject ifAbsent:[ ^ anExceptionBlock value].
  _levels := _levels .
 ].
 ^ anObject.
%

category: 'Removing'
method: Set
removeAll: aCollection

"Removes each element of aCollection from the receiver and returns the receiver.
 Generates an error if any element of aCollection is not present in the
 receiver."

"assign _levels  so that authorization and concurrency conflicts on the
 root object can be detected."
_levels := _levels .

aCollection == self ifTrue:[
   self initialize: 0 .
   ]
ifFalse:[
  aCollection accompaniedBy: self do: [:me :anObject | me remove: anObject ].
  ].
^aCollection
%

category: 'Removing'
method: Set
removeIdentical: anObject ifAbsent: anExceptionBlock

"Removes from the receiver an object that is identical to anObject.
 Returns anObject.  If several elements of the receiver are identical to
 anObject, only one instance is removed.  If anObject has no equivalent
 elements in the receiver, evaluates anExceptionBlock and returns the result."

"assign _levels  so that authorization and concurrency conflicts on the
 root object can be detected."

(self includesIdentical: anObject) ifFalse: [^anExceptionBlock value].
_levels := _levels .
^self remove: anObject
%

category: 'Accessing'
method: Set
size

"Returns the number of elements contained in the receiver."

| tmp |
"read _levels so that authorization and concurrency conflicts on the
 root object can be detected."
tmp := _levels.

^ dict size
%

category: 'Private'
method: Set
_asIdentityBag

"Private.  Returns an IdentitySet containing all of the elements of the
 receiver."

"Used by index creation."

| result  tmp |
"read _levels so that authorization and concurrency conflicts on the
 root object can be detected."
tmp := _levels.

result := IdentitySet new .
dict accompaniedBy: result keysAndValuesDo:[:res :aKey :aValue| res add: aKey ].
^ result
%

category: 'Private'
method: Set
_deepCopyWith: copiedObjDict

| copy |
copy := copiedObjDict at: self otherwise: nil.
copy ~~ nil ifTrue: [ ^ copy ].

copy := self class new: (self size).
copiedObjDict at: self put: copy.

self _deepCopyNamedIvsWith: copiedObjDict to: copy .

dict keysDo: [ :aKey |
   copy add: (aKey _deepCopyWith: copiedObjDict)
  ].

^ copy.
%

category: 'Private'
method: Set
_deferredGciUpdateWith: valueArray

"Private."

1 to: valueArray size do:[:j |
  self add: (valueArray at: j)
  ].
%

category: 'Instance Initialization'
method: Set
_gciInitialize

"Private."

self initialize: 0 .
^ true
%

category: 'Testing'
method: Set
_isLarge

"Returns true if the object is implemented as a tree of private smaller objects"

^ true
%

category: 'Private'
method: Set
_keysAndValuesDo: aBlock
  "aBlock should be a 2 argument block with arguments  element, count "

  dict keysAndValuesDo:[ :each :aVal | aBlock value: each value: 1 ]
%

category: 'Set Arithmetic'
method: Set
_union: aBagOrSet

^ self + aBagOrSet
%

! Class extensions for 'AbstractException'

!		Class methods for 'AbstractException'

category: 'Private'
classmethod: AbstractException
legacyNumberToClass: aSmallInt
  "returns a Class"
  |arr|
  arr := LegacyErrNumMap atOrNil: aSmallInt .
  "arr is { aClass . aReasonString . legacyTemplateStringOrNil }
      or { firstClass . aReasonString . legacyTemplateStringOrNil.
                { list of split classes...} }
      per code in errordict.gs "

  arr ifNotNil:[
    ^ (arr atOrNil:1 ) ifNil:[ Error ].
  ].
  ^ Error
%

category: 'Private'
classmethod: AbstractException
legacyNumberToClasses: aSmallInt
  "returns nil , a Class or an Array of Classes"
  |arr|
  arr := LegacyErrNumMap atOrNil: aSmallInt .
  "arr is { aClass . aReasonString . legacyTemplateStringOrNil }
      or { firstClass . aReasonString . legacyTemplateStringOrNil.
                { list of split classes...} }
      per code in errordict.gs "

  arr ifNotNil:[
    (arr atOrNil: 4) ifNotNil:[ :arrayOfClasses | ^ arrayOfClasses] .
    ^ arr atOrNil:1  "a single class"
  ].
  ^ nil
%

category: 'Private'
classmethod: AbstractException
legacyNumberToText: aSmallInt
  "Returns a string describing the exception that would be created
   for the specified error number.  For use when a GciError does
   not include error text. Returns nil if the argument is not a valid error number"
  | str |
  (LegacyErrNumMap atOrNil: aSmallInt) ifNotNil:[ :arr | 
     arr _isArray ifTrue:[
       (arr atOrNil: 1) ifNotNil:[:cls | cls isBehavior ifTrue:[ str := 'a ', cls name asString ]]. 
       str ifNil:[ str := String new ].
       (arr atOrNil: 2) ifNotNil:[:x| str add: $  ; add: x asString "error symbol" ].
       (arr atOrNil: 3) ifNotNil:[:textArr |
         textArr do:[:elem |
           elem ifNotNil:[:x | x isString ifTrue:[ str add: $ ; add: x ]].
         ].
       ].
    ] ifFalse:[
      aSmallInt <= 1999 ifTrue:[
        str := 'a CompileError ', aSmallInt asString, ', ', arr asString .
      ]
    ]
  ].
  ^ str
%

!		Instance methods for 'AbstractException'

category: 'Accessing'
method: AbstractException
asString
  ^ messageText ifNil:[ self buildMessageText  .
        messageText ifNil:[ super asString , ' errorA during buildMessageText' ] .
    ]
%

category: 'Instance initialization'
method: AbstractException
buildMessageText
  "Reimplement in subclasses , passing details to buildMessageText: "
  
  ^ self buildMessageText: nil 
%

category: 'Instance initialization'
method: AbstractException
buildMessageText: subclassDetails

  "Create the full GemStone message text if needed,
   save it in messageText instVar , and return it.
   Should be invoked by #description in a subclass. "

  messageText ifNil:[
    [ | str num |
      (str := String withAll:'a ') add: self class name ; add: ' occurred ' .
      str add: self _errNumPrefix , (num := gsNumber) asString ; add: $) .
      gsReason ifNotNil:[ :r| str add:', reason:' ; add: r asString ].
      subclassDetails ifNotNil:[
        "details instVar already included in subclassDetails if desired"
         str add:', '; add: subclassDetails .
      ] ifNil:[ | d |
        (d := gsDetails) ifNil:[
          d := (LegacyErrNumMap atOrNil: num) ifNotNil:[:m | m atOrNil: 3].
        ].
        d ifNotNil:[
          d _isArray ifTrue:[ | dStr | "details is a legacy message template"
            dStr := self _legacyDetails: d.
            dStr size > 0 ifTrue:[ str add:', ' ; add: dStr ].
          ] ifFalse:[
            str add:', ' ; add: d asString "ANSI details" .
          ]
        ].
      ].
      messageText := str .
    ] onException: Error do:[ :ex | 
      [
        messageText := self class name , ', errorC during buildMessageText' .
      ] onSynchronous: AbstractException do:[ :exB |
        exB return "ignore errors during assignment"
      ].
    ].
  ].
  ^ messageText ifNil:[ self class name , ', errorD during buildMessageText']
%

category: 'Accessing'
method: AbstractException
messageText
  "return ANSI messageText, if installed, else build the default text"
  ^ gsDetails ifNil:[ messageText 
      ifNil:[ self buildMessageText .
        messageText ifNil:[ super asString , ' errorB during buildMessageText' ] .
      ]
    ]
%

category: 'Private'
method: AbstractException
_description: subclassDetails
  "for compatibility with previous releases."
  ^ self buildMessageText: subclassDetails
%

category: 'Private'
method: AbstractException
_errNumPrefix
  ^ '(error '
%

category: 'Private'
method: AbstractException
_matchesExpectedLegacyNumber: aSmallInt
  "used by topaz EXPECTERROR command, returns true if
   receiver is one of the classes produced by specified error number,
   false otherwise. "
^ [ | arr |
    (arr := LegacyErrNumMap atOrNil: aSmallInt) ifNil:[ ^ false ].
    (arr atOrNil: 4) ifNotNil:[ :inner |
      (arr atOrNil: 1) ifNotNil:[ :c | (self isKindOf: c) ifTrue:[ ^ true ]].
      inner do:[:aClass | (self isKindOf: aClass) ifTrue:[ ^ true ]]
    ].
    (arr atOrNil: 1) ifNotNil:[ :c |
       ^ (self isKindOf: c) and: [ self gsNumber == aSmallInt ]
    ].
    false
  ] onException: Error do:[:ex | ex return: false ]
%

! Class extensions for 'BinaryFloat'

!		Class methods for 'BinaryFloat'

removeallmethods BinaryFloat
removeallclassmethods BinaryFloat

category: 'Exception Handling'
classmethod: BinaryFloat
clearAllExceptions

  "Deprecated, has no effect"

  self deprecated: 'BinaryFloat class>>clearAllExceptions obsolete in v3.4; see FloatingPointError class >> enableExceptions:'.
%

category: 'Exception Handling'
classmethod: BinaryFloat
clearException: aString

  "Deprecated, has no effect"

  self deprecated: 'BinaryFloat class>>clearException obsolete in v3.4; see FloatingPointError class >> enableExceptions:'.
%

category: 'Exception Handling'
classmethod: BinaryFloat
enabledExceptions

"Deprecated, returns an empty Array."

  self deprecated: 'BinaryFloat class>>enabledExceptions obsolete in v3.4; see FloatingPointError class >> enabledExceptions'.
 ^ #()
%

category: 'Instance Creation'
classmethod: BinaryFloat
fromStream: aStream

"Generates a BinaryFloat from aStream.  Generates an error if an attempt is
 made to read beyond the end of the stream.

 The Stream must contain a legal BinaryFloat, as defined by the following BNF
 construction:

 BinaryFloat = ( Integer '.' Digit {Digit} [ E Integer ] ) |
         ( Integer E Integer )
 Integer = [ ('+' | '-') ] Digit {Digit}
 Point = ( '.' | ',' ) depending on Locale
 E = ( 'E' | 'e' | 'q' | 'd')

 Note that the syntax does not allow certain valid BinaryFloats (such as
 PlusInfinity and MinusInfinity) to be read."

| ch s getDigits getChar getSign |

self _checkReadStream: aStream forClass: CharacterCollection.

ch := aStream next.
[ ch == $  ] whileTrue: [ ch := aStream next ].
aStream skip: -1.
s := aStream contents class new.

getDigits := [ | c cnt | 
               cnt := 0 .
               [ (c := aStream peek) ~~ nil and: [ c isDigit ] ]
               whileTrue:
                 [ s add: aStream next . cnt := cnt + 1 ].
               cnt == 0 ifTrue:
                 [ self _errIncorrectFormat: aStream ].
             ].

getChar := [ :c |
             (aStream peek isEquivalent: c)
             ifTrue:
               [ s add: aStream next ]
           ].

getSign := [ (getChar value: $-) == nil
              ifTrue:
                [ getChar value: $+ ].
           ].

getSign value.
getDigits value.

(getChar value: (Locale decimalPoint at: 1))
ifNotNil:
  [ getDigits value ].

((getChar value: $e)
	ifNil: [(getChar value: $d)
		ifNil: [(getChar value: $q)]]
) ifNotNil:[
		getSign value.
		getDigits value.
].

^ self fromString: s
%

category: 'Instance Creation'
classmethod: BinaryFloat
fromString: aString

"Returns an instance of Float, constructed from aString.  The String must
 contain only Characters representing the object to be created, although
 leading and trailing blanks are permitted."

^ Float fromString: aString
%

category: 'Storing and Loading'
classmethod: BinaryFloat
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object.  Converts the object to
 its active form by loading the information into a new instance of the receiver.
 Returns the new instance."

BinaryFloat subclassResponsibility: #loadFrom:
%

category: 'Exception Handling'
classmethod: BinaryFloat
on: aSymbol do: aBlock

  "Deprecated, has no effect"

  self deprecated: 'BinaryFloat class>>on:do: obsolete in v3.4; see FloatingPointError'.
%

category: 'Exception Handling'
classmethod: BinaryFloat
operationException: aSymbol

  "Deprecated, always returns false"

  self deprecated: 'BinaryFloat class>>operationExceptions: obsolete in v3.4; see FloatingPointError'.
 ^ false
%

category: 'Exception Handling'
classmethod: BinaryFloat
operationExceptions

  "Deprecated, returns an empty Array."

  self deprecated: 'BinaryFloat class>>operationExceptions obsolete in v3.4; see FloatingPointError class >> enabledExceptions'.
 ^ #()
%

category: 'Arithmetic'
classmethod: BinaryFloat
pi

"Returns the value of pi, accurate to twenty decimal places."

^ 3.14159265358979323846
%

category: 'Exception Handling'
classmethod: BinaryFloat
raisedException: aString

  "Deprecated, always returns false."

  self deprecated: 'BinaryFloat class>>raisedException: obsolete in v3.4; see FloatingPointError'.
 ^ false
%

category: 'Exception Handling'
classmethod: BinaryFloat
raisedExceptions

  "Deprecated, returns an empty Array."

  self deprecated: 'BinaryFloat class>>raisedExecptions obsolete in v3.4; see FloatingPointError class >> enabledExceptions'.
  ^ #()
%

category: 'Truncation and Rounding'
classmethod: BinaryFloat
roundingMode

"Returns the current rounding mode , one of
  #nearestEven #towardMinusInfinity, #towardPlusInfinity  #towardZero.

 Returns  #unknown  if access to rounding mode is not implemented,
 in which case the operating system or hardware default is always used."

 self deprecated:'BinaryFloat class>>roundingMode has no effect in 3.4 and previous releases'.
^ #unknown
%

category: 'Truncation and Rounding'
classmethod: BinaryFloat
roundingMode: aSymbol

 "Not implemented, has no effect."

 "Future support for rounding will include
  #nearestEven #towardMinusInfinity #towardPlusInfinity #towardZero"

 self deprecated:'BinaryFloat class>>roundingMode: has had no effect in 3.4 and previous releases.'.
 ^ self
%

category: 'Exception Handling'
classmethod: BinaryFloat
status

 "Deprecated, Returns an empty Array"

  self deprecated: 'BinaryFloat class>>status obsolete in v3.4.  See FloatingPointError'.
 ^ #()
%

category: 'Exception Handling'
classmethod: BinaryFloat
status: aString

 "Deprecated, Has no effect in this release."

  self deprecated: 'BinaryFloat class>>status: obsolete in v3.4; see FloatingPointError'.
%

category: 'Exception Handling'
classmethod: BinaryFloat
trapEnabled: aString

 "Deprecated, returns false."

  self deprecated: 'BinaryFloat class>>trapEnabled: obsolete in v3.4; see FloatingPointError'.
 ^ false
%

category: 'Exception Handling'
classmethod: BinaryFloat
_exceptionList

"Returns the list of available exceptions. See FloatingPointError."

^ (Globals at: #FloatingPointError) _exceptionList
%

category: 'Private'
classmethod: BinaryFloat
_finishFromStream: aStream sign: signChar integerPart: integerPart
  "parse this subset of the BNF
   Number = [ '-' ] NumericLiteral                      (excluding RadixLiteral* )
   BinaryExponent = ( 'e' | 'E' | 'd' | 'D' | 'q' ) ['-' | '+'] Digits
   DecimalExponent = ( 'f' | 'F' ) ['-' | '+'] Digits
   Digit = '0' | '1' | '2' | ... | '9'
   Digits = Digit {Digit}
   Exponent = BinaryExponent | DecimalExponent | ScaledDecimalExponent | FixedPointExponent
   FractionalPart = '.' Digits [Exponent]
   FixedPointExponent = 'p' [ ['-' | '+'] Digits ]
   Numeric = Digit | 'A' | 'B' | ... | 'Z'
   NumericLiteral = Digits ( [FractionalPart] | [Exponent] )
   Numerics = Numeric { Numeric }
   ScaledDecimalExponent = 's' [ ['-' | '+'] Digits ]
"
  | fractionalPart ch  expon exponChar |
  fractionalPart := String new.
  [ (ch := aStream peek) ~~ nil and: [ ch isDigit ] ] whileTrue: [
    aStream next.
    fractionalPart add: ch.
  ].
  expon := String new .
  exponChar := $e .
  (#( $e $E $f $F $s $q $p $d $D ) includesIdentical: ch) ifTrue:[
     "parse Digits for Exponent"
     exponChar := ch .
     aStream next.
     (aStream peek == $- ) 
       ifTrue:[ aStream next . expon add:  $-  ]
       ifFalse:[ (aStream peek == $+ ) ifTrue: [ aStream next ] ].
     [ (ch := aStream peek) ~~ nil and: [ ch isDigit ] ] whileTrue: [
        aStream next.
        expon add: ch .
     ].
  ].
  ^ Number _finishFromStream: aStream sign: signChar integerPart: integerPart
        fractionalPart: fractionalPart expChar: exponChar expPart: expon 
%

category: 'Exception Handling'
classmethod: BinaryFloat
_raiseInvalidOperationException

"This method sets the invalid operation exception of the floating point
 processor.  If FloatingPointError is enabled for #invalidOperation,
 signals a FloatingPointError."

MinusSignalingNaN + 3.0E0 .
^self
%

!		Instance methods for 'BinaryFloat'

category: 'Comparing'
method: BinaryFloat
>= aMagnitude

"Returns true if the receiver is greater than or equal to aMagnitude;
 returns false otherwise."

"Reimplemented from Magnitude to handle NaNs correctly."

^ aMagnitude <= self
%

category: 'Arithmetic'
method: BinaryFloat
abs

"Returns a Number that is the absolute value of the receiver."

"reimplemented for efficiency"

(self < 0.0) ifTrue: [ ^ 0.0 - self ].
^ self
%

category: 'Converting'
method: BinaryFloat
asFixedPoint: scale

"Returns a ScaledDecimal that represents the receiver.  If the receiver is
 a NaN or Infinity, returns the receiver.  The argument scale should be a
 non-negative SmallInteger."

| myKind |

myKind := self kind.
myKind == #normal ifFalse:[
  ((myKind == #infinity or:[ myKind == #signalingNaN ])
    or:[ myKind == #quietNaN])  ifTrue:[
      BinaryFloat _raiseInvalidOperationException .
      ^ self.
    ].
  ].
^ self asFraction asFixedPoint: scale.
%

category: 'Converting'
method: BinaryFloat
asFraction

"Returns a Fraction that represents the receiver.  If the receiver is a NaN,
 or Infinity, returns the receiver."

| knd |

"If an infinite or quiet NaN, returns self"
knd := self _getKind .
knd > 2 ifTrue:[ | myKind |
  myKind := self kind .
  myKind == #zero ifTrue:[ ^ 0 ].
  ((myKind == #infinity) or: [ myKind == #quietNaN ]) ifTrue: [ ^self ].

     "If a signaling NaN, raises a floating point exception & returns self"
  (myKind == #signalingNaN) ifTrue: [
    BinaryFloat _raiseInvalidOperationException.
    ^self _makeQuietNaN
  ].
  self error:'logic error'. "should not reach here"
].
" we have either normal or subnormal "
^ self _mathPrim: 12  "_asFraction" .
%

category: 'Converting'
method: BinaryFloat
asScaledDecimal: scale

"Returns a ScaledDecimal that represents the receiver.  If the receiver is
 a NaN or Infinity, returns the receiver.  The argument scale should be a
 non-negative SmallInteger."

| myKind |

myKind := self kind.
myKind == #normal ifFalse:[
  ((myKind == #infinity or:[ myKind == #signalingNaN ])
    or:[ myKind == #quietNaN])  ifTrue:[
      BinaryFloat _raiseInvalidOperationException .
      ^ self.
    ].
  ].
^ self asFraction asScaledDecimal: scale.
%

category: 'Formatting'
method: BinaryFloat
asString

"(Subclass responsibility.)  Returns a String corresponding to the value of the
 receiver.  Where applicable, returns one of the following Strings:
 'PlusInfinity', 'MinusInfinity', 'PlusQuietNaN', 'MinusQuietNaN',
 'PlusSignalingNaN', or 'MinusSignalingNaN'."

BinaryFloat subclassResponsibility: #asString
%

category: 'Storing and Loading'
method: BinaryFloat
asStringLocaleC

"Return the receiver as a String, but using the . decimal point,
 rather than any localized decimal point."

^self asFloat asStringLocaleC
%

category: 'Formatting'
method: BinaryFloat
asStringUsingFormat: anArray

"(Subclass responsibility.)  Returns a String corresponding to the receiver,
 using the format specified by anArray."

BinaryFloat subclassResponsibility: #asStringUsingFormat:
%

category: 'Accessing'
method: BinaryFloat
at: anIndex put: aValue

"Disallowed.  You may not change the value of a Float."

self shouldNotImplement: #at:put:
%

category: 'Accessing'
method: BinaryFloat
denominator

"Returns the denominator of a Fraction representing the receiver."

| myKind |
myKind := self kind .
myKind == #normal ifFalse:[
     "If an infinite or quiet NaN, returns self"
  ((myKind == #infinity) or: [ myKind == #quietNaN ])
     ifTrue: [ ^self ].

     "If a signaling NaN, raise a floating point exception & returns self"
  (myKind == #signalingNaN)
     ifTrue: [ self class _raiseInvalidOperationException.
               ^self _makeQuietNaN ].
  ].

^ (self asFraction) denominator
%

category: 'Testing'
method: BinaryFloat
even

"Returns true if the receiver is an even integer, false otherwise."
 ^ Float noInexactResultDo:[ (self \\ 2.0) == 0.0 ]
%

category: 'Arithmetic'
method: BinaryFloat
factorial

"Returns the factorial of the integer part of the receiver.  Returns 1 if the
 receiver is less than or equal to 1."

| x result |
result := 1.0E0  .
x := result .
self asInteger timesRepeat:[ result := result * x.  x := x + 1.0E0 ] .
^ result .
%

category: 'Truncation and Rounding'
method: BinaryFloat
integerPart

"Returns an integer representing the receiver truncated toward zero."

^ self truncated asFloat
%

category: 'Testing'
method: BinaryFloat
isZero
  ^ self = 0.0
%

category: 'Arithmetic'
method: BinaryFloat
negated

"Returns a Number that is the negation of the receiver."

"reimplemented for efficiency"

^ (-0.0 - self)
%

category: 'Testing'
method: BinaryFloat
negative

"Returns true if the receiver is less than zero, false if the receiver is zero
 or greater."

^ self < 0.0
%

category: 'Accessing'
method: BinaryFloat
numerator

"Returns the numerator of a Fraction representing the receiver."

| myKind |

   "If an infinite or quiet NaN, returns self"
myKind := self kind.
myKind == #normal ifFalse:[
  ((myKind == #infinity) or: [ myKind == #quietNaN ])
     ifTrue: [ ^self ].

     "If a signaling NaN, raise a floating point exception & returns self"
  (myKind == #signalingNaN)
     ifTrue: [ self class _raiseInvalidOperationException.
               ^self _makeQuietNaN ].
  ].

^ (self asFraction) numerator
%

category: 'Testing'
method: BinaryFloat
odd

"Returns true if the receiver is an odd integer, false otherwise.
 Compare to self truncated to reject values that are not quite integers,
 such as -9.9999999999999989E-01, which due to rounding would answer true below."

 self = (self _truncated: false) ifFalse: [ ^ false ].
 ^ Float noInexactResultDo:[ (self \\ 2.0) == 1.0 ]
%

category: 'Testing'
method: BinaryFloat
positive

"Returns true if the receiver is greater than or equal to zero, false if the
 receiver is less than zero."

^ self >= 0.0
%

category: 'Arithmetic'
method: BinaryFloat
rem: aNumber

"Returns the integer remainder defined in terms of quo: (division of the
 receiver by aNumber, with truncation toward zero)."

  "x rem: y | x=infinity or y=0 are invalid floating point
   operations and returns quiet NaNs"

(aNumber = 0.0) "0.0/0.0 is also invalid"
   ifTrue: [ ^ (aNumber asFloat) / (aNumber asFloat)].

(self _getKind == 3 "infinity" ) "infinity/infinity is also invalid"
   ifTrue: [ ^ self / self ].
^ super rem: aNumber
%

category: 'Accessing'
method: BinaryFloat
size: anInteger

"Disallowed.  You may not change the size of a Float."

self shouldNotImplement: #size:
%

category: 'Testing'
method: BinaryFloat
strictlyPositive

"Returns true if the receiver is greater than zero and false if it is less than
 or equal to zero."

^ self > 0.0
%

category: 'Storing and Loading'
method: BinaryFloat
writeTo: passiveObj

"Converts the receiver to its passive form and writes that information on
 passiveObj."

passiveObj writeClass: self class;
      nextPutAll: self asStringLocaleC ;
      space
%

category: 'Indexing Support'
method: BinaryFloat
_isNaN

"(Subclass responsibility.)  Returns whether the receiver is quiet NaN or
 a signaling NaN.  This method is only to be used by the indexing subsystem."

BinaryFloat subclassResponsibility: #_isNaN
%

! Class extensions for 'ByteArray'

!		Class methods for 'ByteArray'

removeallmethods ByteArray
removeallclassmethods ByteArray

category: 'Encoded OOPs'
classmethod: ByteArray
bytesPerOop
"Number of bytes consumed by OopType in C."
^ 8
%

category: 'instance creation'
classmethod: ByteArray
fromBase64String: aString
"Creates an instance of the receiver by decoding aString, which must be an
 instance of String or another single-byte character collection class. The
 argument must be in valid base64 format. The argument may contain newline
 and other whitespace charcaters, which are ignored.

 Raises an exception if aString is not a valid base64 string."

<primitive: 1063>
aString _validateClass: String .
self _primitiveFailed: #fromBase64String: args: { aString }
%

category: 'instance creation'
classmethod: ByteArray
fromHexString: aHexString
"Create a new instance of the receiver containing the byte values contained
 in aHexString. aHexString must be single-byte character collection (i.e,
 it must answer 1 to the message #charSize) and contain characters in the
 range of 0 - 9 and/or of a-f/A-F. Alphabetic hex characters may be in upper
 or lower case. A C hex prefix of 0x or 0X present in the first two characters
 of aHexString is permitted. A Smalltalk hex prefix of 16r in the first three
 characters is also permitted.

 If aHexString contains an odd number of hex digits, then the result object
 is left-padded, meaning the first four bits of the first byte in the result
 object will be zero.

 Example:
   (ByteArray fromHexString: 'abc') => 0a,bc

 Returns a new instance of the receiver on success or raises an exception
 on error."

^ self fromHexString: aHexString leftPadded: true
%

category: 'instance creation'
classmethod: ByteArray
fromHexString: aHexString leftPadded: padLeft

"Create a new instance of the receiver containing the byte values contained
 in aHexString. aHexString must be single-byte character collection (i.e,
 it must answer 1 to the message #charSize) and contain characters in the
 range of 0 - 9 and/or of a-f/A-F. Alphabetic hex characters may be in upper
 or lower case. A C hex prefix of 0x or 0X present in the first two characters
 of aHexString is permitted. A Smalltalk hex prefix of 16r in the first three
 characters is also permitted.

 If aHexString contains an odd number of hex digits, then the result object
 must be padded. The Boolean argument padLeft determines if left or right
 padding is used. If padLeft is true, the result is left-padded, meaning
 the first four bits of the first byte in the result object will be zero. If
 padLeft is false, the result is right-padded, meaning the last four bits of
 the last byte in the result object will be zero.

 Examples:
   (ByteArray fromHexString: 'abc' leftPadded: true)  => 0a,bc
   (ByteArray fromHexString: 'abc' leftPadded: false) => ab,c0

 Returns a new instance of the receiver on success or raises an exception
 on error."

<primitive: 1061>
aHexString _validateClasses: { String }.
padLeft   _validateClass: Boolean .
self _primitiveFailed: #fromHexString:leftPadded: args: { aHexString . padLeft }
%

category: 'instance creation'
classmethod: ByteArray
fromString: aString

"aString must be a kind of String or MultiByteString.  For MultiByteString
 arguments, the result will be in big-endian byte order."

<primitive: 653>
aString _validateClasses:{ String }.
self _primitiveFailed: #fromString: args: { aString }
%

category: 'Encoded OOPs'
classmethod: ByteArray
oldBytesPerOop
"Number of bytes consumed by Gs64 v1.1 OopType in C."
^ 4
%

category: 'instance creation'
classmethod: ByteArray
withRandomBytes: howMany

"Returns a new instance of the receiver of size howMany containing
 randomly generated data."

^ self new addRandomBytes: howMany startingAt: 1
%

!		Instance methods for 'ByteArray'

category: 'Comparing'
method: ByteArray
= aByteArray

"Returns true if all of the following conditions are true, otherwise
  returns false.

 1.  The receiver and aByteArray are of the same class.
 2.  The two Arrays are the same size.
 3.  The corresponding elements of the receiver and aByteArray
     are equal."

<primitive: 613>

^ super = aByteArray.
%

category: 'Adding'
method: ByteArray
addAll: aCollection

"Adds all of the elements of aCollection to the receiver and returns
 aCollection."

| collectionSize |

(self == aCollection) ifTrue: [ ^ self addAll: (aCollection copy) ].

(aCollection isKindOf: ByteArray) ifTrue:[
  collectionSize := aCollection size.
  (collectionSize ~~ 0) ifTrue:[
    self insertAll: aCollection at: (self size + 1)
    ].
  ^ aCollection.
  ].
aCollection accompaniedBy: self do: [ :me :each | me add: each ].
^ aCollection
%

category: 'Random Value Generation'
method: ByteArray
addRandomBytes: howMany startingAt: offset

"Adds howMany random bytes to the receiver starting at offset.
 This method grows the receiver to accomodate the random data
 if necessary.   Any existing data in the range of offset to
 (offset + howMany - 1) is overwritten by this method.

 Both arguments are expected to be positive SmallIntegers.

 Returns the receiver."

^ self _primAddRandomBytes: howMany startingAt: offset
%

category: 'Decrypting'
method: ByteArray
aesDecryptWith128BitKey: aKey salt: aSalt
"Decrypts the receiver using 128 bit AES decryption and places the result into
 a new instance of the class of the receiver.

 See the comments in method:
   #_primEncryptDecryptWithKey: aKey salt: aSalt opCode: opCode
         into: destObjOrNil tag: nil extraData: nil
 for more information on encryption and decryption."

^ self aesDecryptWith128BitKey: aKey salt: aSalt into: nil
%

category: 'Decrypting'
method: ByteArray
aesDecryptWith128BitKey: aKey salt: aSalt into: destObjOrNil
"Decrypts the receiver using 128 bit AES decryption and places the result into
 destObjOrNil.

 See the comments in method:
   #_primEncryptDecryptWithKey: aKey salt: aSalt opCode: opCode
         into: destObjOrNil tag: nil extraData: nil
 for more information on encryption and decryption."

^ self _primEncryptDecryptWithKey: aKey salt: aSalt opCode: -1 into: destObjOrNil
%

category: 'Decrypting'
method: ByteArray
aesDecryptWith192BitKey: aKey salt: aSalt
"Decrypts the receiver using 192 bit AES decryption and places the result into
 a new instance of the class of the receiver.

 See the comments in method:
   #_primEncryptDecryptWithKey: aKey salt: aSalt opCode: opCode
         into: destObjOrNil tag: nil extraData: nil
 for more information on encryption and decryption."

^ self aesDecryptWith192BitKey: aKey salt: aSalt into: nil
%

category: 'Decrypting'
method: ByteArray
aesDecryptWith192BitKey: aKey salt: aSalt into: destObjOrNil
"Decrypts the receiver using 192 bit AES decryption and places the result into
 destObjOrNil.

 See the comments in method:
   #_primEncryptDecryptWithKey: aKey salt: aSalt opCode: opCode
         into: destObjOrNil tag: nil extraData: nil
 for more information on encryption and decryption."

^ self _primEncryptDecryptWithKey: aKey salt: aSalt opCode: -2 into: destObjOrNil
%

category: 'Decrypting'
method: ByteArray
aesDecryptWith256BitKey: aKey salt: aSalt
"Decrypts the receiver using 256 bit AES decryption and places the result into
 a new instance of the class of the receiver.

 See the comments in method:
   #_primEncryptDecryptWithKey: aKey salt: aSalt opCode: opCode
         into: destObjOrNil tag: nil extraData: nil
 for more information on encryption and decryption."

^ self aesDecryptWith256BitKey: aKey salt: aSalt into: nil
%

category: 'Decrypting'
method: ByteArray
aesDecryptWith256BitKey: aKey salt: aSalt into: destObjOrNil
"Decrypts the receiver using 256 bit AES decryption and places the result into
 destObjOrNil.

 See the comments in method:
   #_primEncryptDecryptWithKey: aKey salt: aSalt opCode: opCode
         into: destObjOrNil tag: nil extraData: nil
 for more information on encryption and decryption."

^ self _primEncryptDecryptWithKey: aKey salt: aSalt opCode: -3 into: destObjOrNil
%

category: 'Encrypting'
method: ByteArray
aesEncryptWith128BitKey: aKey salt: aSalt
"Encrypts the receiver using 128 bit AES encryption and places the result into
 a new instance of the class of the receiver.

 See the comments in method:
   #_primEncryptDecryptWithKey: aKey salt: aSalt opCode: opCode
         into: destObjOrNil tag: nil extraData: nil
 for more information on encryption and decryption."

^ self aesEncryptWith128BitKey: aKey salt: aSalt into: nil
%

category: 'Encrypting'
method: ByteArray
aesEncryptWith128BitKey: aKey salt: aSalt into: destObjOrNil
"Encrypts the receiver using 128 bit AES encryption and places the result into
 destObjOrNil.

 See the comments in method:
   #_primEncryptDecryptWithKey: aKey salt: aSalt opCode: opCode
         into: destObjOrNil tag: nil extraData: nil
 for more information on encryption and decryption."

^ self _primEncryptDecryptWithKey: aKey salt: aSalt opCode: 1  into: destObjOrNil
%

category: 'Encrypting'
method: ByteArray
aesEncryptWith192BitKey: aKey salt: aSalt
"Encrypts the receiver using 192 bit AES encryption and places the result into
 a new instance of the class of the receiver.

 See the comments in method:
   #_primEncryptDecryptWithKey: aKey salt: aSalt opCode: opCode
         into: destObjOrNil tag: nil extraData: nil
 for more information on encryption and decryption."

^ self aesEncryptWith192BitKey: aKey salt: aSalt into: nil
%

category: 'Encrypting'
method: ByteArray
aesEncryptWith192BitKey: aKey salt: aSalt into: destObjOrNil
"Encrypts the receiver using 192 bit AES encryption and places the result into
 destObjOrNil.

 See the comments in method:
   #_primEncryptDecryptWithKey: aKey salt: aSalt opCode: opCode
         into: destObjOrNil tag: nil extraData: nil
 for more information on encryption and decryption."

^ self _primEncryptDecryptWithKey: aKey salt: aSalt opCode: 2 into: destObjOrNil
%

category: 'Encrypting'
method: ByteArray
aesEncryptWith256BitKey: aKey salt: aSalt
"Encrypts the receiver using 256 bit AES encryption and places the result into
 a new instance of the class of the receiver.

 See the comments in method:
   #_primEncryptDecryptWithKey: aKey salt: aSalt opCode: opCode
         into: destObjOrNil tag: nil extraData: nil
 for more information on encryption and decryption."

^ self aesEncryptWith256BitKey: aKey salt: aSalt into: nil
%

category: 'Encrypting'
method: ByteArray
aesEncryptWith256BitKey: aKey salt: aSalt into: destObjOrNil
"Encrypts the receiver using 256 bit AES encryption and places the result into
 destObjOrNil.

 See the comments in method:
   #_primEncryptDecryptWithKey: aKey salt: aSalt opCode: opCode
         into: destObjOrNil tag: nil extraData: nil
 for more information on encryption and decryption."

^ self _primEncryptDecryptWithKey: aKey salt: aSalt opCode: 3 into: destObjOrNil
%

category: 'Authenticated Decrypting'
method: ByteArray
aesGcmDecryptWith128BitKey: aKey salt: aSalt into: destObjOrNil tag: tag extraData: eData
"Decrypts the receiver using 128 bit AES-GCM decryption and places the result into
 destObjOrNil.

 See the comments in method:
   #_primEncryptDecryptWithKey: aKey salt: aSalt opCode: opCode
         into: destObjOrNil tag: nil extraData: nil
 for more information on encryption and decryption."

^ self _primEncryptDecryptWithKey: aKey
       salt: aSalt
       opCode: -7
       into: destObjOrNil
       tag: tag
       extraData: eData
%

category: 'Authenticated Decrypting'
method: ByteArray
aesGcmDecryptWith192BitKey: aKey salt: aSalt into: destObjOrNil tag: tag extraData: eData
"Decrypts the receiver using 192 bit AES-GCM decryption and places the result into
 destObjOrNil.

 See the comments in method:
   #_primEncryptDecryptWithKey: aKey salt: aSalt opCode: opCode
         into: destObjOrNil tag: nil extraData: nil
 for more information on encryption and decryption."

^ self _primEncryptDecryptWithKey: aKey
       salt: aSalt
       opCode: -8
       into: destObjOrNil
       tag: tag
       extraData: eData
%

category: 'Authenticated Decrypting'
method: ByteArray
aesGcmDecryptWith256BitKey: aKey salt: aSalt into: destObjOrNil tag: tag extraData: eData
"Decrypts the receiver using 256 bit AES-GCM decryption and places the result into
 destObjOrNil.

 See the comments in method:
   #_primEncryptDecryptWithKey: aKey salt: aSalt opCode: opCode
         into: destObjOrNil tag: nil extraData: nil
 for more information on encryption and decryption."

^ self _primEncryptDecryptWithKey: aKey
       salt: aSalt
       opCode: -9
       into: destObjOrNil
       tag: tag
       extraData: eData
%

category: 'Authenticated Encrypting'
method: ByteArray
aesGcmEncryptWith128BitKey: aKey salt: aSalt into: destObjOrNil tag: tag extraData: eData
"Encrypts the receiver using 128 bit AES-GCM encryption and places the result into
 destObjOrNil.

 See the comments in method:
   #_primEncryptDecryptWithKey: aKey salt: aSalt opCode: opCode
         into: destObjOrNil tag: nil extraData: nil
 for more information on encryption and decryption."

^ self _primEncryptDecryptWithKey: aKey salt: aSalt opCode: 7 into: destObjOrNil tag: tag extraData: eData
%

category: 'Authenticated Encrypting'
method: ByteArray
aesGcmEncryptWith192BitKey: aKey salt: aSalt into: destObjOrNil tag: tag extraData: eData
"Encrypts the receiver using 192 bit AES-GCM encryption and places the result into
 destObjOrNil.

 See the comments in method:
   #_primEncryptDecryptWithKey: aKey salt: aSalt opCode: opCode
         into: destObjOrNil tag: nil extraData: nil
 for more information on encryption and decryption."

^ self _primEncryptDecryptWithKey: aKey
       salt: aSalt
       opCode: 8
       into: destObjOrNil
       tag: tag
       extraData: eData
%

category: 'Authenticated Encrypting'
method: ByteArray
aesGcmEncryptWith256BitKey: aKey salt: aSalt into: destObjOrNil tag: tag extraData: eData
"Encrypts the receiver using 256 bit AES-GCM encryption and places the result into
 destObjOrNil.

 See the comments in method:
   #_primEncryptDecryptWithKey: aKey salt: aSalt opCode: opCode
         into: destObjOrNil tag: nil extraData: nil
 for more information on encryption and decryption."

^ self _primEncryptDecryptWithKey: aKey
       salt: aSalt
       opCode: 9
       into: destObjOrNil
       tag: tag
       extraData: eData
%

category: 'Decrypting'
method: ByteArray
aesOcbDecryptWith128BitKey: aKey salt: aSalt into: destObjOrNil tag: tag extraData: eData
"Decrypts the receiver using 128 bit AES-OCB decryption and places the result into
 destObjOrNil.

 See the comments in method:
   #_primEncryptDecryptWithKey: aKey salt: aSalt opCode: opCode
         into: destObjOrNil tag: nil extraData: nil
 for more information on encryption and decryption."

^ self _primEncryptDecryptWithKey: aKey
       salt: aSalt
       opCode: -4
       into: destObjOrNil
       tag: tag
       extraData: eData
%

category: 'Authenticated Decrypting'
method: ByteArray
aesOcbDecryptWith192BitKey: aKey salt: aSalt into: destObjOrNil tag: tag extraData: eData
"Decrypts the receiver using 192 bit AES-OCB decryption and places the result into
 destObjOrNil.

 See the comments in method:
   #_primEncryptDecryptWithKey: aKey salt: aSalt opCode: opCode
         into: destObjOrNil tag: nil extraData: nil
 for more information on encryption and decryption."

^ self _primEncryptDecryptWithKey: aKey
       salt: aSalt
       opCode: -5
       into: destObjOrNil
       tag: tag
       extraData: eData
%

category: 'Authenticated Decrypting'
method: ByteArray
aesOcbDecryptWith256BitKey: aKey salt: aSalt into: destObjOrNil tag: tag extraData: eData
"Decrypts the receiver using 256 bit AES-OCB decryption and places the result into
 destObjOrNil.

 See the comments in method:
   #_primEncryptDecryptWithKey: aKey salt: aSalt opCode: opCode
         into: destObjOrNil tag: nil extraData: nil
 for more information on encryption and decryption."

^ self _primEncryptDecryptWithKey: aKey
       salt: aSalt
       opCode: -6
       into: destObjOrNil
       tag: tag
       extraData: eData
%

category: 'Authenticated Encrypting'
method: ByteArray
aesOcbEncryptWith128BitKey: aKey salt: aSalt into: destObjOrNil tag: tag extraData: eData
"Encrypts the receiver using 128 bit AES-OCB encryption and places the result into
 destObjOrNil.

 See the comments in method:
   #_primEncryptDecryptWithKey: aKey salt: aSalt opCode: opCode
         into: destObjOrNil tag: nil extraData: nil
 for more information on encryption and decryption."

^ self _primEncryptDecryptWithKey: aKey
       salt: aSalt
       opCode: 4
       into: destObjOrNil
       tag: tag
       extraData: eData
%

category: 'Authenticated Encrypting'
method: ByteArray
aesOcbEncryptWith192BitKey: aKey salt: aSalt into: destObjOrNil tag: tag extraData: eData
"Encrypts the receiver using 192 bit AES-OCB encryption and places the result into
 destObjOrNil.

 See the comments in method:
   #_primEncryptDecryptWithKey: aKey salt: aSalt opCode: opCode
         into: destObjOrNil tag: nil extraData: nil
 for more information on encryption and decryption."

^ self _primEncryptDecryptWithKey: aKey
       salt: aSalt
       opCode: 5
       into: destObjOrNil
       tag: tag
       extraData: eData
%

category: 'Authenticated Encrypting'
method: ByteArray
aesOcbEncryptWith256BitKey: aKey salt: aSalt into: destObjOrNil tag: tag extraData: eData
"Encrypts the receiver using 256 bit AES-OCB encryption and places the result into
 destObjOrNil.

 See the comments in method:
   #_primEncryptDecryptWithKey: aKey salt: aSalt opCode: opCode
         into: destObjOrNil tag: nil extraData: nil
 for more information on encryption and decryption."

^ self _primEncryptDecryptWithKey: aKey
       salt: aSalt
       opCode: 6
       into: destObjOrNil
       tag: tag
       extraData: eData
%

category: 'Converting'
method: ByteArray
asBase64String
"Return a String which represents the receiver represented in base64 format."

^ self asBase64StringOnOneLine: true
%

category: 'Converting'
method: ByteArray
asBase64StringOnOneLine: aBoolean
"Return a String which represents the receiver represented in base64 format.
 If aBoolean is true, the resulting is one long line which does not contain
 newline characters.  If aBoolean is false, newline characters are inserted
 such that each line does not exceed 64 characters."

<primitive: 1062>
aBoolean _validateClass: Boolean .
self _primitiveFailed: #asBase64StringOnOneLine:
%

category: 'Converting'
method: ByteArray
asByteArray
  ^ self 
%

category: 'Converting'
method: ByteArray
asHexString

"Returns a String containing a hexadecimal printed representation of the
 contents of the receiver.  For example, the message 'abc' asHexString
 returns the String '616263'.

 The receiver must be a byte format object."

<primitive: 467>
self _validateByteClass: ByteArray .
self _primitiveFailed: #asHexString .
%

category: 'Message Authentication Codes'
method: ByteArray
asHmacSumWithDigestKind: opCode key: keyString

"Computes the keyed-hash message authentication code (HMAC) of the receiver using
 the message digest algorithm indicated by opCode and secret key keyString.

 opCode must be one of the following:

 opCode   Digest Algorithm
 =========================
  1          md5
  2          sha1
  3          sha2-256
  4          sha2-512
  5          sha3-224
  6          sha3-256
  7          sha3-384
  8          sha3-256
 =========================

 secretKey must be an instance or subclass of a ByteArray or String and must
 have a character size of one, i.e.: its class must answer 1 when sent the
 message #_bytesPerWord. secretKey must have a size between 1 and 64 bytes.

 Answers the HMAC of the receiver as a LargeInteger."

<primitive: 1060>
opCode _validateClass: SmallInteger .
((opCode < 1) or:[ opCode > 8]) ifTrue:[ opCode _error: #rtErrArgOutOfRange args:{ 1 . 8 } ].
keyString _validateClasses: { String . ByteArray } .
((keyString _basicSize > 64) or:[keyString _basicSize < 1])
  ifTrue:[ keyString _error: #rtErrBadSize args: { 64 . keyString _basicSize } ] .
self _primitiveFailed: #asHmacSumWithDigestKind:key: args: { opCode . keyString } .
%

category: 'Message Authentication Codes'
method: ByteArray
asMd5HmacStringWithKey: keyString
"Computes the keyed-hash message authentication code (HMAC) of the receiver
 using the MD5 message digest algorithm and secret key keyString. Answers
 the resulting HMAC of the receiver as a String of hexadecimal characters."

^ (self asMd5HmacWithKey: keyString) asHexStringWithLength: 32
%

category: 'Message Authentication Codes'
method: ByteArray
asMd5HmacWithKey: keyString
"Computes the keyed-hash message authentication code (HMAC) of the receiver
 using the MD5 message digest algorithm and secret key keyString. Answers
 the resulting HMAC of the receiver as a LargeInteger."

^ self asHmacSumWithDigestKind: 1 key: keyString
%

category: 'Message Digests'
method: ByteArray
asMd5String

"Compute the 128 bit MD5 message digest for the receiver and return it as
 a 32 character string of hexadecimal characters."

^ self md5sum asHexStringWithLength: 32
%

category: 'Message Authentication Codes'
method: ByteArray
asSha1HmacStringWithKey: keyString
"Computes the keyed-hash message authentication code (HMAC) of the receiver
 using the sha1 message digest algorithm and secret key keyString. Answers
 the resulting HMAC of the receiver as a String of hexadecimal characters."

^ (self asSha1HmacWithKey: keyString) asHexStringWithLength: 40
%

category: 'Message Authentication Codes'
method: ByteArray
asSha1HmacWithKey: keyString
"Computes the keyed-hash message authentication code (HMAC) of the receiver
 using the sha1 message digest algorithm and secret key keyString. Answers
 the resulting HMAC of the receiver as a LargeInteger."

^ self asHmacSumWithDigestKind: 2 key: keyString
%

category: 'Message Digests'
method: ByteArray
asSha1String

"Compute the 160 bit SHA1 message digest for the receiver and return it as
 a 40 character string of hexadecimal characters."

^ self sha1Sum asHexStringWithLength: 40
%

category: 'Message Authentication Codes'
method: ByteArray
asSha256HmacStringWithKey: keyString
"Computes the keyed-hash message authentication code (HMAC) of the receiver
 using the sha256 message digest algorithm and secret key keyString. Answers
 the resulting HMAC of the receiver as a String of hexadecimal characters."

^ (self asSha256HmacWithKey: keyString) asHexStringWithLength: 64
%

category: 'Message Authentication Codes'
method: ByteArray
asSha256HmacWithKey: keyString
"Computes the keyed-hash message authentication code (HMAC) of the receiver
 using the sha256 message digest algorithm and secret key keyString. Answers
 the resulting HMAC of the receiver as a LargeInteger."

^ self asHmacSumWithDigestKind: 3 key: keyString
%

category: 'Message Digests'
method: ByteArray
asSha256String

"Compute the 256 bit SHA-2 message digest for the receiver and return it as
 a 64 character string of hexadecimal characters."

^ self sha256Sum asHexStringWithLength: 64
%

category: 'Message Authentication Codes'
method: ByteArray
asSha3_224HmacStringWithKey: keyString
"Computes the keyed-hash message authentication code (HMAC) of the receiver
 using the SHA3 224 message digest algorithm and secret key keyString. Answers
 the resulting HMAC of the receiver as a String of hexadecimal characters."

^ (self asSha3_224HmacWithKey: keyString) asHexStringWithLength: 56
%

category: 'Message Authentication Codes'
method: ByteArray
asSha3_224HmacWithKey: keyString
"Computes the keyed-hash message authentication code (HMAC) of the receiver
 using the SHA3 224 message digest algorithm and secret key keyString. Answers
 the resulting HMAC of the receiver as a LargeInteger."

^ self asHmacSumWithDigestKind: 5 key: keyString
%

category: 'Message Digests'
method: ByteArray
asSha3_224String

"Compute the SHA3 224 bit message digest for the receiver and return it as
 a 56 character string of hexadecimal characters."

^ self sha3_224Sum asHexStringWithLength: 56
%

category: 'Message Authentication Codes'
method: ByteArray
asSha3_256HmacStringWithKey: keyString
"Computes the keyed-hash message authentication code (HMAC) of the receiver
 using the SHA3 256 message digest algorithm and secret key keyString. Answers
 the resulting HMAC of the receiver as a String of hexadecimal characters."

^ (self asSha3_256HmacWithKey: keyString) asHexStringWithLength: 64
%

category: 'Message Authentication Codes'
method: ByteArray
asSha3_256HmacWithKey: keyString
"Computes the keyed-hash message authentication code (HMAC) of the receiver
 using the SHA3 256 message digest algorithm and secret key keyString. Answers
 the resulting HMAC of the receiver as a LargeInteger."

^ self asHmacSumWithDigestKind: 6 key: keyString
%

category: 'Message Digests'
method: ByteArray
asSha3_256String

"Compute the SHA3 256 bit message digest for the receiver and return it as
 a 64 character string of hexadecimal characters."

^ self sha3_256Sum asHexStringWithLength: 64
%

category: 'Message Authentication Codes'
method: ByteArray
asSha3_384HmacStringWithKey: keyString
"Computes the keyed-hash message authentication code (HMAC) of the receiver
 using the SHA3 384 message digest algorithm and secret key keyString. Answers
 the resulting HMAC of the receiver as a String of hexadecimal characters."

^ (self asSha3_384HmacWithKey: keyString) asHexStringWithLength: 96
%

category: 'Message Authentication Codes'
method: ByteArray
asSha3_384HmacWithKey: keyString
"Computes the keyed-hash message authentication code (HMAC) of the receiver
 using the SHA3 384 message digest algorithm and secret key keyString. Answers
 the resulting HMAC of the receiver as a LargeInteger."

^ self asHmacSumWithDigestKind: 7 key: keyString
%

category: 'Message Digests'
method: ByteArray
asSha3_384String

"Compute the SHA3 384 bit message digest for the receiver and return it as
 a 96 character string of hexadecimal characters."

^ self sha3_384Sum asHexStringWithLength: 96
%

category: 'Message Authentication Codes'
method: ByteArray
asSha3_512HmacStringWithKey: keyString
"Computes the keyed-hash message authentication code (HMAC) of the receiver
 using the SHA3 512 message digest algorithm and secret key keyString. Answers
 the resulting HMAC of the receiver as a String of hexadecimal characters."

^ (self asSha3_512HmacWithKey: keyString) asHexStringWithLength: 128
%

category: 'Message Authentication Codes'
method: ByteArray
asSha3_512HmacWithKey: keyString
"Computes the keyed-hash message authentication code (HMAC) of the receiver
 using the SHA3 512 message digest algorithm and secret key keyString. Answers
 the resulting HMAC of the receiver as a LargeInteger."

^ self asHmacSumWithDigestKind: 8 key: keyString
%

category: 'Message Digests'
method: ByteArray
asSha3_512String

"Compute the SHA3 512 bit message digest for the receiver and return it as
 a 128 character string of hexadecimal characters."

^ self sha3_512Sum asHexStringWithLength: 128
%

category: 'Message Authentication Codes'
method: ByteArray
asSha512HmacStringWithKey: keyString
"Computes the keyed-hash message authentication code (HMAC) of the receiver
 using the sha512 message digest algorithm and secret key keyString. Answers
 the resulting HMAC of the receiver as a String of hexadecimal characters."

^ (self asSha512HmacWithKey: keyString) asHexStringWithLength: 128
%

category: 'Message Authentication Codes'
method: ByteArray
asSha512HmacWithKey: keyString
"Computes the keyed-hash message authentication code (HMAC) of the receiver
 using the sha512 message digest algorithm and secret key keyString. Answers
 the resulting HMAC of the receiver as a LargeInteger."

^ self asHmacSumWithDigestKind: 4 key: keyString
%

category: 'Message Digests'
method: ByteArray
asSha512String

"Compute the 512 bit SHA-2 message digest for the receiver and return it as
 a 128 character string of hexadecimal characters."

^ self sha512Sum asHexStringWithLength: 128
%

category: 'Converting'
method: ByteArray
asUnicodeString

"This will eventually be Deprecated.
 New code should use bytesIntoUnicode.
 Return an instance of Unicode7 or Unicode16
 using the class with smallest character size needed to
 represent a copy of the receiver.
 The receiver is interpreted as an array of 8 bit codePoints."

<primitive: 927>

self _primitiveFailed:#asUnicodeString
%

category: 'Accessing'
method: ByteArray
at: anIndex

"Returns the value of an indexed variable in the receiver.
 The argument anIndex must not be larger than the size of the
 receiver, and must not be less than 1.

 Generates an error if anIndex is not a SmallInteger or is out of
 bounds, or if the receiver is not indexable."

<primitive: 974>

(anIndex _isInteger)
  ifTrue: [^ self _errorIndexOutOfRange: anIndex]
  ifFalse: [^ self _errorNonIntegerIndex: anIndex].
self _primitiveFailed: #at: args: { anIndex } .
self _uncontinuableError
%

category: 'Private-Comparing'
method: ByteArray
at: anIndex equals: aString

^self compareStringAt: anIndex to: aString startingAt: 1 sizeBytes: 0 useCase: true
   "size is not encoded, compare entire <aString>"
%

category: 'Private-Comparing'
method: ByteArray
at: anIndex equals: aString useCase: aBool

^self compareStringAt: anIndex to: aString startingAt: 1 sizeBytes: 0 useCase: aBool
   "size is not encoded, compare entire <aString>"
%

category: 'Updating'
method: ByteArray
at: anIndex put: aValue

"Store aValue in the receiver at anIndex .
 aValue should be a SmallInteger >= 0 and <= 255 . "
<primitive: 1002>

(anIndex _isInteger)
  ifFalse: [ ^ self _errorNonIntegerIndex: anIndex].
((anIndex < 1) | (anIndex > (self size + 1))) "out of bounds"
  ifTrue: [ ^ self _errorIndexOutOfRange: anIndex].
(aValue _isSmallInteger not or: [ (aValue < 0) | (aValue > 255) ])
  ifTrue: [^ aValue _error: #rtErrExpectedByteValue].

self _primitiveFailed: #at:put: args: { anIndex . aValue } .
self _uncontinuableError
%

category: 'Private'
method: ByteArray
at: index put: aString fromOffset: stringOffset sizeBytes: numBytes
 "Write a string into the receiver, which must be a byte object (usually
  a ByteArray).  The offset to start writing the receiver is given by the
  at: argument, the object to write (must also be a byte object, usually
  a string) is given by the put: argument.  The fromOffset: argument
  specifies the offset from within the given string to start copying.
  The sizeBytes argument specifies the width it takes to store the size
  of the string.  The size of the string is stored in the first offset
  of the byte array.  The sizeBytes must one of the following values:

  sizeBytes   max string size      Notes
     0        255                  Do not store the size in the byte array
     1        255
     2        65535
     4        4 GB - 1
     8        max legal object size - 8.
  Returns the receiver."

<primitive: 622>
self _primitiveFailed: #at:put:fromOffset:sizeBytes:
     args: { index . aString . stringOffset . numBytes }
%

category: 'Private'
method: ByteArray
at: index put: aNumber signed: aBool width: aWidthInBytes

"Store the big-endian or the native represention of an aNumber into
 the specified position in the receiver.
 aWidthInBytes is allowed to be 1,2,3,4,8, 512, 1024, or 2048 if
 aNumber is an Integer . Values larger than 8 indicate the value should
 be stored in native integer format rather than big-endian format.
 512 means store 2 bytes in native format, 1024 means 4 bytes and 
 2048 means 8 bytes.

 aWidthInBytes is allowed to be 4, 8, 1024 or 2048 if aNumber is
 a BinaryFloat. 1024 and 2048 indicate the 4 or 8 bytes of the 
 float should be stored in native format respectively.
 If representation of an Integer requires more than aWidthInBytes ,
 the primitive will fail.
 If coercion of a BinaryFloat to a 4 byte C float would produce
 loss of exponent bits, the primitive will fail.
 If coercion of a BinaryFloat to a 4 byte C float would cause loss
 of precision that would convert a non-zero value to zero ,
 the primitive will fail .
 "

<primitive: 618>
index _validateClass: SmallInteger.
aNumber _validateClass: Number.
aBool _validateClass: Boolean.
aWidthInBytes _validateClass: SmallInteger.
(aWidthInBytes < 1) ifTrue: [ self error: 'aWidthInBytes negative or zero'].
( #( 1 2 3 4 8 512 1024 2048 ) includesIdentical: aWidthInBytes)
  ifFalse: [ self error: 'illegal value for aWidthInBytes'].
self _primitiveFailed: #at:put:signed:width:
     args: { index . aNumber . aBool . aWidthInBytes }
%

category: 'Encoded OOPs'
method: ByteArray
at: startIndex putAllOldOopsOfObjects: anArray
"Store the OOP of each object contained in anArray into 4 bytes of the receiver
 starting at startIndex.  The receiver is grown as necessary."
| idx |
idx := startIndex .
1 to: anArray size do:[:j |
  self at: idx putOldOopValueOfObject: (anArray at: j ).
  idx := idx + 4 .
  ].
^ self
%

category: 'Encoded OOPs'
method: ByteArray
at: startIndex putAllOopsOfObjects: anArray
"Store the OOP of each object contained in anArray into 8 bytes of the receiver
 starting at startIndex.  The receiver is grown as necessary."
| idx |
idx := startIndex .
1 to: anArray size do:[:j |
  self at: idx putOopValueOfObject: (anArray at: j ).
  idx := idx + 8 .
  ].
^ self
%

category: 'Updating'
method: ByteArray
at: index putChar: char

"Stores the codepoint of char in the receiver at index. Stores one byte if
 char is a single byte character, two bytes if it is a double byte
 character. , 4 bytes if it is a quad byte character. Returns char."

<primitive: 502>

(index _isInteger)
  ifFalse: [^ self _errorNonIntegerIndex: index].

((index <= 0) or: [ (index > (self size + 1)) ])
  ifTrue: [^ self _errorIndexOutOfRange: index].

char _validateClass: Character .
self _validateByteClass: ByteArray .
self _primitiveFailed: #at:putChar: args: { index . char }
%

category: 'Encoded OOPs'
method: ByteArray
at: aSmallInt putOldOopValueOfObject: anObject
"Store the 4 byte Gs64 v1.1 OOP of anObject in the receiver.
 aSmallInt is an offset in the receiver where the bytes are to be stored.
 The bytes are stored in big-endian order.
 The receiver is grown if needed (use aSmallInt one past end to append)
 anObject cannot be a special object, and its oopNumber must be < 2 billion."

<primitive: 634>
aSmallInt _validateClass: SmallInteger .
aSmallInt < 1 ifTrue:[self _errorIndexOutOfRange: aSmallInt].
aSmallInt > (self size + 1) ifTrue:[self _errorIndexOutOfRange: aSmallInt].
self _primitiveFailed: #at:putOldOopValueOfObject:
     args: { aSmallInt . anObject }
%

category: 'Encoded OOPs'
method: ByteArray
at: aSmallInt putOopValueOfObject: anObject
"Store the 8 byte OOP of anObject in the receiver.
 aSmallInt is an offset in the receiver where the bytes are to be stored.
 The bytes are stored in big-endian order.
 The receiver is grown if needed (use aSmallInt one past end to append)"
<primitive: 633>
aSmallInt _validateClass: SmallInteger .
aSmallInt < 1 ifTrue:[self _errorIndexOutOfRange: aSmallInt].
aSmallInt > (self size + 1) ifTrue:[self _errorIndexOutOfRange: aSmallInt].
self _primitiveFailed: #at:putOopValueOfObject: args: { aSmallInt . anObject }
%

category: 'Private'
method: ByteArray
at: index signed: aBool width: aWidthInBytes

"Retrieve a Number stored in big-endian or native represention,
 from the specified position and width in the receiver.
 aWidthInBytes of 1,2,3,4 or 8 retrieves an Integer in big-endian
 format.
 aWidthInBytes of 512, 1024 or 2048 retrieves an Integer in native
 format.
 aWidthInBytes of -4 or -8 retrieves a SmallDouble or Float,
 in big-endian format and aBool is ignored.
 aWidthInBytes of 4096 or 8192 retrieves a SmallDouble or Float in
 native format and aBool is ignored.  " 

<primitive: 619>
self _primitiveFailed: #at:signed:width:
     args: { index . aBool . aWidthInBytes }
%

category: 'Private'
method: ByteArray
at: index sizeBytes: anInt stringSize: anIntOrNil
 "Read a string from the receiver into a new string and return the new
  string.  The offset to start writing the receiver is given by the
  at: argument. The sizeBytes argument specifies the width (in bytes) it takes to
  store the size of the string.  In this case, it is assumed the size
  of the string is stored in the first sizeBytes of the receiver. The
  stringSize: argument should be nil in this case, which means read the
  string size from the byte array.  If the stringSize: argument is not nil,
  it means the size is not encoded in the string and the caller is
  passing in the string size.
  Returns the new string object created from reading"

<primitive: 623>
self _primitiveFailed: #at:sizeBytes:stringSize:
     args: { index . anInt . anIntOrNil }
%

category: 'Accessing'
method: ByteArray
atOrNil: anIndex

"Returns the value of an indexed variable in the receiver,
 or nil if anIndex is out of range .

 Generates an error if anIndex is not a SmallInteger,
 or if the receiver is not indexable."

<primitive: 974>

(anIndex _isInteger)
  ifTrue: [ ^ nil ]
  ifFalse: [^ self _errorNonIntegerIndex: anIndex].
self _primitiveFailed: #at: args: { anIndex } .
self _uncontinuableError
%

category: 'Authenticated Encrypting'
method: ByteArray
authenticatedEncryptionExample

| key salt enc dec hamlet extraData tag|
key  := ByteArray withRandomBytes: 32 .
salt := ByteArray withRandomBytes: 12 .

hamlet :=
'Alas, poor Yorick! I knew him, Horatio: a fellow
of infinite jest, of most excellent fancy: he hath
borne me on his back a thousand times; and now, how
abhorred in my imagination it is! my gorge rims at
it. Here hung those lips that I have kissed I know
not how oft. Where be your gibes now? your
gambols? your songs? your flashes of merriment,
that were wont to set the table on a roar? Not one
now, to mock your own grinning? quite chap-fallen?
Now get you to my ladys chamber, and tell her, let
her paint an inch thick, to this favour she must
come; make her laugh at that. Prithee, Horatio, tell
me one thing.' .

extraData := 'Hamlet: Act V, Scene i'.

tag := ByteArray new.
enc := hamlet aesOcbEncryptWith256BitKey: key salt: salt
       into: ByteArray new tag: tag extraData: extraData .
dec := enc aesOcbDecryptWith256BitKey: key salt: salt
       into: String new tag: tag extraData: extraData .
^ dec = hamlet
%

category: 'Accessing'
method: ByteArray
bitAtZ: zeroBasedOffset
  "Returns a bit of the receiver, as if receiver is an Array of bytes .
   ((zeroBasedOffset bitShift: -3)+1)  defines the byte addressed in the receiver
    Within that byte,  bitAt:((zeroBasedOffset bitAnd: 7) + 1) is modified.
    Returns 0 or 1 ."
  | byte ofs  mask |
  ofs  := (zeroBasedOffset bitShift: -3) + 1 .
  byte := self at: ofs  .
  mask := 1 bitShift:( zeroBasedOffset bitAnd: 7 ).
  ^ (byte bitAnd: mask) == 0 ifTrue:[ 0 ] ifFalse:[ 1]
%

category: 'Updating'
method: ByteArray
bitAtZ: zeroBasedOffset put: anInteger
  "Stores a bit into the receiver, as if receiver is an Array of bytes .
   ((zeroBasedOffset bitShift: -3)+1)  defines the byte addressed in the receiver.
    Within that byte,  bitAt:((zeroBasedOffset bitAnd: 7) + 1) is modified.
    anInteger must be one of  0, 1, true, false ."
  | byte ofs  mask |
  ofs  := (zeroBasedOffset bitShift: -3) + 1 .
  byte := self at: ofs  .
  mask := 1 bitShift:( zeroBasedOffset bitAnd: 7 ).
  (anInteger == 0 or:[ anInteger == false]) ifTrue:[
    mask := 16rFF bitXor: mask .
    byte := byte bitAnd: mask .
    self at: ofs put: byte .
    ^ self .
  ].
  (anInteger == 1 or:[ anInteger == true]) ifTrue:[
    byte := byte bitOr: mask .
    self at: ofs put: byte .
    ^ self .
  ].
  ArgumentError signal: anInteger asString , '  is not one of  0, 1, true, false'
%

category: 'Accessing'
method: ByteArray
byteAt: anIndex

"Returns the value of an indexed variable in the receiver.
 The argument anIndex must not be larger than the size of the
 receiver, and must not be less than 1.

 Generates an error if anIndex is not a SmallInteger or is out of
 bounds, or if the receiver is not indexable."

<primitive: 974>

(anIndex _isInteger)
  ifTrue: [^ self _errorIndexOutOfRange: anIndex]
  ifFalse: [^ self _errorNonIntegerIndex: anIndex].
self _primitiveFailed: #at: args: { anIndex } .
self _uncontinuableError
%

category: 'Updating'
method: ByteArray
byteAt: anIndex put: aValue

"Store aValue in the receiver at anIndex .
 aValue should be a SmallInteger >= 0 and <= 255 . "
<primitive: 1002>

(anIndex _isInteger)
  ifFalse: [ ^ self _errorNonIntegerIndex: anIndex].
((anIndex < 1) | (anIndex > (self size + 1))) "out of bounds"
  ifTrue: [ ^ self _errorIndexOutOfRange: anIndex].
(aValue _isSmallInteger not or: [ (aValue < 0) | (aValue > 255) ])
  ifTrue: [^ aValue _error: #rtErrExpectedByteValue].

self _primitiveFailed: #at:put: args: { anIndex . aValue } .
self _uncontinuableError
%

category: 'Converting'
method: ByteArray
bytesIntoString

"Returns an instance of String containing the bytes of the receiver
 without doing any decoding."

 ^ String withBytes: self
%

category: 'Converting'
method: ByteArray
bytesIntoUnicode
"Return an instance of Unicode7 or Unicode16
 using the class with smallest character size needed to
 represent a copy of the receiver.
 The receiver is interpreted as an array of 8 bit codePoints."

<primitive: 927>

self _primitiveFailed: #bytesIntoUnicode
%

category: 'Authenticated Decrypting'
method: ByteArray
chacha20Poly1305DecryptWithKey: aKey salt: aSalt into: destObjOrNil tag: tag extraData: eData
"Decrypts the receiver using CHACHA20-Poly1305 decryption and places the result into
 destObjOrNil.

 See the comments in method:
   #_primEncryptDecryptWithKey: aKey salt: aSalt opCode: opCode
         into: destObjOrNil tag: nil extraData: nil
 for more information on encryption and decryption."

^ self _primEncryptDecryptWithKey: aKey
       salt: aSalt
       opCode: -10
       into: destObjOrNil
       tag: tag
       extraData: eData
%

category: 'Authenticated Encrypting'
method: ByteArray
chacha20Poly1305EncryptWithKey: aKey salt: aSalt into: destObjOrNil tag: tag extraData: eData
"Encrypts the receiver using CHACHA20-Poly1305 encryption and places the result into
 destObjOrNil.

 See the comments in method:
   #_primEncryptDecryptWithKey: aKey salt: aSalt opCode: opCode
         into: destObjOrNil tag: nil extraData: nil
 for more information on encryption and decryption."

^ self _primEncryptDecryptWithKey: aKey
       salt: aSalt
       opCode: 10
       into: destObjOrNil
       tag: tag
       extraData: eData
%

category: 'Accessing'
method: ByteArray
charAt: index

"Returns a (single byte) Character located at index in the receiver."

<primitive: 500>

(index _isInteger)
  ifFalse: [^ self _errorNonIntegerIndex: index].

((index <= 0) or: [ (index > self size) ])
  ifTrue: [^ self _errorIndexOutOfRange: index].

self _validateByteClass: ByteArray .
self _primitiveFailed: #charAt: args: { index }
%

category: 'Private-Comparing'
method: ByteArray
compareCaseInsensitiveShortStringAt: startIndex to: aString startingAt: stringIndex
"  Compare a string encoded in the receiver (aByteArray) to the given string
  starting at the offset specified in the given string.  The byte array is assumed
  to have the size of the encoded string encoded in the first 1 byte.
  Returns true if the strings are case insensitive match, false otherwise."

^self compareStringAt: startIndex to: aString startingAt: stringIndex sizeBytes: 1 useCase: false
    "size is encoded in first byte of receiver"
%

category: 'Private-Comparing'
method: ByteArray
compareShortStringAt: startIndex to: aString startingAt: stringIndex

^self compareStringAt: startIndex to: aString startingAt: stringIndex sizeBytes: 1 useCase: true
   "size is encoded in first byte of receiver"
%

category: 'Private-Comparing'
method: ByteArray
compareShortStringAt: startIndex to: aString startingAt: stringIndex useCase: aBool

^self compareStringAt: startIndex to: aString startingAt: stringIndex sizeBytes: 1 useCase: aBool
   "size is encoded in first byte of receiver"
%

category: 'Private-Comparing'
method: ByteArray
compareString4gAt: startIndex to: aString startingAt: stringIndex

^self compareStringAt: startIndex to: aString startingAt: stringIndex sizeBytes: 4
  "size is encoded in first byte of receiver"
%

category: 'Private-Comparing'
method: ByteArray
compareString64kAt: startIndex to: aString startingAt: stringIndex

^self compareStringAt: startIndex to: aString startingAt: stringIndex sizeBytes: 2
   "size is encoded in first byte of receiver"
%

category: 'Private-Comparing'
method: ByteArray
compareStringAt: startIndex to: aString startingAt: stringIndex sizeBytes: numSizeBytes

"  Compare a string encoded in the receiver (aByteArray) to the given string
  starting at the offset specified in the given string.  If sizeBytes not
  zero, the byte array is assumed to have the size of the encoded string
  encoded in the first numSizeBytes bytes at the startIndex.  If sizeBytes
  is zero, the size   has not been encoded in the byteArray and the entire
  length of the second string is compared.  numSizeBytes must be 0, 1, 2, 4,
  or 8.
  Returns true if the strings match, false otherwise."
        ^self compareStringAt: startIndex to: aString startingAt: stringIndex sizeBytes: numSizeBytes useCase: true
%

category: 'Private-Comparing'
method: ByteArray
compareStringAt: startIndex to: aString startingAt: stringIndex sizeBytes: numSizeBytes useCase: aBool

"  Compare a string encoded in the receiver (aByteArray) to the given string
  starting at the offset specified in the given string.  If sizeBytes not
  zero, the byte array is assumed to have the size of the encoded string
  encoded in the first numSizeBytes bytes at the startIndex.  If sizeBytes
  is zero, the size has not been encoded in the byteArray and the entire
  length of the second string is compared.  numSizeBytes must be 0, 1, 2, 4,
  or 8.  <aBool> determines if the comparision is case sensitive.
  Returns true if the strings match, false otherwise."
<primitive: 624>
self _primitiveFailed: #compareStringAt:to:startingAt:sizeBytes:useCase:
     args: { startIndex . aString . stringIndex . numSizeBytes . aBool }
%

category: 'Compression'
method: ByteArray
compressWithLz4: opCode

"Compress the receiver with lz4 compression and answer a ByteArray.
 There are 2 lz4 compression modes available:
   opCode 0 - frame mode
   opCode 1 - block mode

 Frame mode should almost always be used. Block mode requires the
 receiver to be completely faulted into memory which can cause out of 
 memory errors for large objects. Frame mode has no such limitation
 as the complete contents of the receiver need not be in memory
 during compression. Also the lz4 command line program compresses
 data using frame mode.

 Symbols, DoubleByteSymbols and QuadByteSymbols may not be compressed.
 Attempting to do so raises an exception.

 Returns a ByteArray on success or raises an exception on error."

<primitive: 241>
opCode _validateClass: SmallInteger .
((opCode < 0) or:[ opCode > 1])
  ifTrue:[ opCode _error: #rtErrArgOutOfRange ] .
^ self _primitiveFailed: #compressWithLz4: .
%

category: 'Copying'
method: ByteArray
copyFrom: startIndex to: stopIndex

"Returns a new Array containing the elements of the receiver
 between startIndex and stopIndex, inclusive.  The result is of the same class
 as the receiver.

 If startIndex > stopIndex then an empty collection is returned.
 Otherwise both startIndex and stopIndex must be positive integers not larger than the
 size of the receiver, with startIndex <= stopIndex.
"

<primitive: 818>
(startIndex < 1) ifTrue: [ ^ self _errorIndexOutOfRange: startIndex].

((stopIndex > self size) or: [(stopIndex < 0)])
   ifTrue: [ ^ self _errorIndexOutOfRange: stopIndex].

self _primitiveFailed: #copyFrom:to: args: { startIndex . stopIndex }
%

category: 'Copying'
method: ByteArray
copyReplaceAll: oldSubCollection with: newSubCollection

"See SequenceableCollection>>copyReplaceAll:with: for details"

| old new |
old := oldSubCollection.
new := newSubCollection.
(old isKindOf: ByteArray) ifFalse: [ old := old asByteArray ].
(new isKindOf: ByteArray) ifFalse: [ new := new asByteArray ].
^ super copyReplaceAll: old with: new
%

category: 'Copying'
method: ByteArray
copyReplaceFrom: startIndex to: stopIndex with: aSequenceableCollection

"See SequenceableCollection>>copyReplaceFrom:to:with: for details"

| col |
col := aSequenceableCollection.
(col isKindOf: ByteArray) ifFalse: [ col := col asByteArray ].
^ super copyReplaceFrom: startIndex to: stopIndex with: col
%

category: 'Copying'
method: ByteArray
copyReplacing: oldObject withObject: newObject

"Returns a String comprising a copy of the receiver in which all occurrences
 of objects equal to oldObject have been replaced by newObject."

^ super copyReplacing: oldObject asInteger withObject: newObject asInteger
%

category: 'Copying'
method: ByteArray
copyWith: anObject

"See SequenceableCollection>>copyWith: for details"

^ super copyWith: anObject asInteger
%

category: 'Copying'
method: ByteArray
copyWithout: anObject

"See SequenceableCollection>>copyWithout: for details"

^ super copyWithout: anObject asInteger
%

category: 'Private-Accessing'
method: ByteArray
dateTime32At: startIndex

"retrieves a DateTime that was stored with seconds resolution
 in big-endian byte order."

^ self dateTimeAt: startIndex width: 4
%

category: 'Private-Updating'
method: ByteArray
dateTime32At: startIndex put: aDateTime

"Stores the DateTime with seconds resolution in big-endian byte order
 WARNING, this truncates the DateTime to seconds resolution,
 throwing away the milliseconds.
 "

^ self dateTimeAt: startIndex put: aDateTime width: 4
%

category: 'Private-Accessing'
method: ByteArray
dateTime32NativeAt: startIndex

"retrieves a DateTime that was stored with seconds resolution
 in the gem process's native byte order.
 Provided for compatiblity and renamed from dateTimeAsUnsigned32At: "

^ self dateTimeAt: startIndex width: -4
%

category: 'Private-Updating'
method: ByteArray
dateTime32NativeAt: startIndex put: aDateTime

"Stores the DateTime with seconds resolution and gem process native
 byte order.
 WARNING, this truncates the DateTime to seconds resolution,
 throwing away the milliseconds.  Provided for compatibility and
 renamed from dateTimeAsUnsigned32At:put:  "

^ self dateTimeAt: startIndex put: aDateTime width: -4
%

category: 'Private-Accessing'
method: ByteArray
dateTime64At: startIndex

"retrieves a DateTime that was stored with millisecond resolution.
 in big-endian byte order"

^ self dateTimeAt: startIndex width: 8
%

category: 'Private-Updating'
method: ByteArray
dateTime64At: startIndex put: aDateTime

"Stores the DateTime with full millisecond resolution in big-endian
 byte order."

^ self dateTimeAt: startIndex put: aDateTime width: 8
%

category: 'Private-Updating'
method: ByteArray
dateTimeAt: startIndex put: aDateTime width: anInt

"values for anInt:
   -4   second resolution (4 bytes) in gem process native byte order
    4   second resolution (4 bytes) in big-endian byte order
    8   millisecond resolution (8 bytes) in big-endian byte order"
<primitive: 620>
| yr |
aDateTime _validateClass: DateTime .
(yr := aDateTime yearGmt) < 1970 ifTrue:[
  OutOfRange new name: 'yearGmt' min: 1970 actual: yr ;
      details: 'year is less than 1970' ; signal
].
self _primitiveFailed: #dateTimeAt:put:width:
     args: { startIndex . aDateTime . anInt }
%

category: 'Private-Accessing'
method: ByteArray
dateTimeAt: startIndex width: anInt

"values for anInt:
   -4   second resolution (4 bytes) in gem process native byte order
    4   second resolution (4 bytes) in big-endian byte order
    8   millisecond resolution (8 bytes) in big-endian byte order"

<primitive: 621>
self _primitiveFailed: #dateTimeAt:width: args: { startIndex . anInt }
%

category: 'Encoding'
method: ByteArray
decodeFromUTF16BeToUTF8
  "Decode UTF16-BE contents of the receiver.
   Returns an instance of Utf8 ."

 ^ self _decodeFromUTF16toUTF8: true
%

category: 'Encoding'
method: ByteArray
decodeFromUTF16LeToUTF8
  "Decode UTF16-LE contents of the receiver.
   Returns an instance of Utf8 ."

 ^ self _decodeFromUTF16toUTF8: false
%

category: 'Encoding'
method: ByteArray
decodeFromUTF8
"Decode receiver from UTF8 format.
 Returns either a Unicode7 , Unicode16 or Unicode32 ,
 using the minimum character size needed to represent decoded result."

^ self _decodeUtf8StartingAt: 1 unicodeResult: true maxSize: nil bytesConsumed: nil
%

category: 'Encoding'
method: ByteArray
decodeFromUTF8ToString
"Decode UTF8 contents of the receiver returning a String, DoubleByteString or
  QuadByteString."

^ self _decodeUtf8StartingAt: 1 unicodeResult: false maxSize: nil bytesConsumed: nil
%

category: 'Encoding'
method: ByteArray
decodeFromUTF8ToUnicode
"Decode receiver from UTF8 format.
 Returns either a Unicode7 , Unicode16 or Unicode32 ,
 using the minimum character size needed to represent decoded result."

^ self _decodeUtf8StartingAt: 1 unicodeResult: true maxSize: nil bytesConsumed: nil
%

category: 'Compression'
method: ByteArray
decompressWithLz4IntoNewInstanceOf: aClass decompressedSize: dSize

"Decompresses the receiver using lz4 and stores the resulting  bytes into a new
 instance of aClass. aClass must be a byte format Class. The lz4 compression 
 mode (block or frame) used to compress the data is automatically detected by
 this method.

 dSize is a SmallInteger which indicates the size (in characters, not bytes) 
 of the data when decompressed. If the contents were compressed using lz4 frame
 mode, dSize may be set to 0 indicating the decompressed size is not known.
 However the decompressed size should always be provided whenever possible 
 to enable faster decompression performance.

 If the contents were compressed using lz4 block mode then dSize must be set
 correctly to the decompressed size otherwise an error may be raised.

 aClass may not be Symbol, DoubleByteSymbol nor QuadByteSymbol otherwise the
 operation fails and an error is raised.

 On success, returns a new instance of aClass containing the decompressed data.
 Raises an exception on error."

<primitive: 242>
dSize _validateClass: SmallInteger .
dSize < 0 ifTrue:[ dSize _error: #rtErrArgOutOfRange ] .
aClass validateIsClass .
aClass isBytes ifFalse:[ aClass _error: #objErrNotByteKind ] .  
^ self _primitiveFailed: #decompressWithLz4IntoNewInstanceOf:decompressedSize: .
%

category: 'Private-Updating'
method: ByteArray
deleteIndexKeyAt: anIndex

<primitive: 630>
self _primitiveFailed: #deleteIndexKeyAt: args: { anIndex }

%

category: 'Accessing (Native)'
method: ByteArray
doubleAsNativeAt: startIndex

"Answer the 8 byte double at offset startIndex.
 Double is assumed to be in native format."
 
^ self at: startIndex signed: true width: 8192
%

category: 'Private-Accessing'
method: ByteArray
doubleAt: startIndex

"extract an 8 byte float from the receiver, the result will
 be either a SmallDouble or a Float. "

^self at: startIndex signed: false width: -8
%

category: 'Private-Updating'
method: ByteArray
doubleAt: startIndex put: aBinaryFloat

"aBinaryFloat must be a kind of BinaryFloat."

^self at: startIndex put: aBinaryFloat signed: false width: 8
%

category: 'Updating (Native)'
method: ByteArray
doubleAt: startIndex putAsNative: aDouble

"Store aDouble at startIndex as a native 8 byte double."

^self at: startIndex put: aDouble signed: false width: 2048
%

category: 'Accessing'
method: ByteArray
doubleByteCharAt: index

"Returns a double-byte Character located at index in the receiver. The most
 significant byte would be the one located at index, the least significant
 one located at index + 1."

<primitive: 501>

(index _isInteger)
  ifFalse: [^ self _errorNonIntegerIndex: index].

((index <= 0) or: [ (index >= self size) ])
  ifTrue: [^ self _errorIndexOutOfRange: index].

self _validateByteClass: ByteArray .
self _primitiveFailed: #doubleByteCharAt: args: { index }
%

category: 'Encrypting'
method: ByteArray
encryptionExample

| key salt enc dec hamlet |
key  := ByteArray withRandomBytes: 32 .
salt := ByteArray withRandomBytes: 16 .

hamlet :=
'Alas, poor Yorick! I knew him, Horatio: a fellow
of infinite jest, of most excellent fancy: he hath
borne me on his back a thousand times; and now, how
abhorred in my imagination it is! my gorge rims at
it. Here hung those lips that I have kissed I know
not how oft. Where be your gibes now? your
gambols? your songs? your flashes of merriment,
that were wont to set the table on a roar? Not one
now, to mock your own grinning? quite chap-fallen?
Now get you to my ladys chamber, and tell her, let
her paint an inch thick, to this favour she must
come; make her laugh at that. Prithee, Horatio, tell
me one thing.' .


enc := hamlet aesEncryptWith256BitKey: key salt: salt .
dec := enc aesDecryptWith256BitKey: key salt: salt into: String new.
^ dec = hamlet
%

category: 'Accessing (Native)'
method: ByteArray
floatAsNativeAt: startIndex

"Answer the 4 byte float at offset startIndex.
 Float is assumed to be in native format."
 
^ self at: startIndex signed: true width: 4096
%

category: 'Private-Accessing'
method: ByteArray
floatAt: startIndex

"extract a 4 byte float from the receiver, the result will
 be a SmallDouble."

^self at: startIndex signed: false width: -4
%

category: 'Private-Updating'
method: ByteArray
floatAt: startIndex put: aBinaryFloat

"aBinaryFloat must be a kind of BinaryFloat, representable as
 a 4 byte IEEE float without loss of exponent bits.
 If coercion of a BinaryFloat to a 4 byte float would produce
 loss of exponent bits, the primitive will fail.
 If coercion of a BinaryFloat to a 4 byte float would cause loss
 of precision that would convert a non-zero value to zero ,
 the primitive will fail ."

^self at: startIndex put: aBinaryFloat signed: false width: 4
%

category: 'Updating (Native)'
method: ByteArray
floatAt: startIndex putAsNative: aFloat

"Store aFloat at startIndex as a native 4 byte float."

^self at: startIndex put: aFloat signed: false width: 1024
%

category: 'Encoded OOPs'
method: ByteArray
getObjectWithOldOopValueAt: anOffset
"Answer the object with the OOP stored in 4 bytes of the receiver
 at the given offset.
 The bytes are expected to have been stored in big-endian order.
 Returns nil if the object does not exist or is an invalid object identifier."
<primitive: 636>
anOffset _validateClass: SmallInteger.
(anOffset < 1) ifTrue:[self _errorIndexOutOfRange: anOffset].
(anOffset > (self _basicSize - (self class bytesPerOop - 1)))
  ifTrue:[self _errorIndexOutOfRange: anOffset].
self _primitiveFailed: #getObjectWithOldOopValueAt: args: { anOffset }
%

category: 'Encoded OOPs'
method: ByteArray
getObjectWithOopValueAt: anOffset
"Answer the object with the OOP stored in 8 bytes of the receiver
 at the given offset.
 The bytes are expected to have been stored in big-endian order.
 Returns nil if the object identifier
 encoded at anOffset does not exist or is an invalid object identifier."

<primitive: 635>
anOffset _validateClass: SmallInteger.
(anOffset < 1) ifTrue:[self _errorIndexOutOfRange: anOffset].
(anOffset > (self _basicSize - (self class bytesPerOop - 1)))
  ifTrue:[self _errorIndexOutOfRange: anOffset].
self _primitiveFailed: #getObjectWithOopValueAt: args: { anOffset }
%

category: 'Comparing'
method: ByteArray
hash

"Returns a positive SmallInteger based on the contents of the receiver."

"Uses a case-sensitive string hash algorithm.
 The algorithm implemented is described in:

 [Pearson 90]
 Pearson, Peter K., Fast Hashing of Variable-Length Text Strings,
 Communications of the ACM 33, 6, (June 1990), 677-680."

<primitive: 31>
self _primitiveFailed: #hash .
self _uncontinuableError
%

category: 'Searching'
method: ByteArray
indexOf: searchByte
  ^ self indexOf: searchByte startingAt: 1 stoppingAt: self size
%

category: 'Searching'
method: ByteArray
indexOf: searchByte startingAt: startIndex
  ^ self indexOf: searchByte startingAt: startIndex stoppingAt: self size
%

category: 'Searching'
method: ByteArray
indexOf: searchByte startingAt: startIndex stoppingAt: stopIndex

"Receiver is searched for a byte that has the same value
as the low-order byte (searchByte bitAnd: 16rFF) of SmallInteger
searchByte. The search starts at 1-based startIndex within the receiver
and stops when a matching byte is found or 1-based stopIndex is reached.
The index of the first matching byte is answered, or 0 is answered if no
matching byte is found.

Errors:
  * ArgumentTypeError if any of the arguments is not a SmallInteger.
  * OutOfRange if startIndex or stopIndex is outside the bounds of
    of the receiver."

<primitive: 947>
searchByte _validateClass: SmallInteger .
startIndex _validateClass: SmallInteger .
stopIndex _validateClass: SmallInteger .
(startIndex < 1 or:[ startIndex > self size]) ifTrue:[
  OutOfRange new
   name:'startIndex' min: 1 max: self size actual: startIndex  ;
   signal
].
(stopIndex < 1 or:[ stopIndex > self size]) ifTrue:[
  OutOfRange new
   name:'stopIndex' min: 1 max: self size actual: stopIndex  ;
   signal
].
self _primitiveFailed: #indexOf:startingAt:stoppingAt:
	args: { searchByte . startIndex . stopIndex}
%

category: 'Copying'
method: ByteArray
insertAll: aByteArray at: anIndex

"Inserts aByteArray into the receiver beginning at anIndex.  The receiver's
 size is modified to become its old size plus the size of aByteArray.

 The argument anIndex must be greater than or equal to 1.  If anIndex is 1
 greater than the size of the receiver, appends aByteArray to the receiver.  If
 anIndex is more than 1 greater than the size of the receiver, generates an
 error."

<primitive: 230>

aByteArray _validateClass: ByteArray.
(anIndex _isSmallInteger)
  ifFalse: [ ^ self _errorNonIntegerIndex: anIndex].
(anIndex < 1 or: [ anIndex > (self size + 1)]) "out of bounds"
  ifTrue: [ ^ self _errorIndexOutOfRange: anIndex].

^ super insertAll: aByteArray at: anIndex
%

category: 'Private-Accessing'
method: ByteArray
int32LittleEndianAt: startIndex
  "Receiver can be any byte format object.
   Answer a SmallInteger resulting from interpreting the bytes in the
   receiver from offset to offset+3 as a little-endian signed integer.
  Offset is 1-based and need not be aligned.
  Variant of signed32At:, for little endian data.
  * The given offset is not a SmallInteger (ArgumentTypeError)
  * offset+3 is outside the size of the receiver (OutOfRange)"
<primitive: 945>
startIndex _validateClass: SmallInteger .
(startIndex < 1 or:[ startIndex + 3 > self size]) ifTrue:[
  OutOfRange new
    name:'startIndex' min: 1 max: self size - 3 actual: startIndex ;
    signal
].
self _primitiveFailed: #int32LittleEndianAt: args: { startIndex }
%

category: 'Message Digests'
method: ByteArray
md5sum

"Return the 128 bit MD5 checksum of the receiver as a LargeInteger.

 Computation is per RFC 1321 , http://www.ietf.org/rfc/rfc1321.txt,
 using L. Peter Deutsch's C implementation from
 http://sourceforge.net/projects/libmd5-rfc/

 For DoubleByteString and QuadByteString, the computation is based
 on viewing the string as a ByteArray holding big-endian characters.
"

^ self _asMessageDigestKind: 1
%

category: 'Message Digests'
method: ByteArray
md5sumBytes

"Return the 128 bit MD5 checksum of the receiver as a ByteArray.

 Computation is per RFC 1321 , http://www.ietf.org/rfc/rfc1321.txt,
 using L. Peter Deutsch's C implementation from
 http://sourceforge.net/projects/libmd5-rfc/

 For DoubleByteString and QuadByteString, the computation is based
 on viewing the string as a ByteArray holding big-endian characters.
"

^ self _asMessageDigestKind: -1
%

category: 'Encoded OOPs'
method: ByteArray
nextPutAllOldOopsOfObjects: anArray
"For each object in anArray, append the 4 byte OOP to the receiver.
 The receiver is grown by 4 bytes for every object contained in
 anArray."

^ self at: self size + 1 putAllOldOopsOfObjects: anArray
%

category: 'Encoded OOPs'
method: ByteArray
nextPutAllOopsOfObjects: anArray
"For each object in anArray, append the 8 byte OOP to the receiver.
 The receiver is grown by 8 bytes for every object contained in
 anArray."

^ self at: self size + 1 putAllOopsOfObjects: anArray
%

category: 'Encoded OOPs'
method: ByteArray
nextPutOldOopOfObject: anObject
"Extend the receiver by 4 bytes and add the 4 byte OOP of anObject.
 anObject cannot be a special object, and its oopNumber must be < 2 billion."

^self at: self size + 1 putOldOopValueOfObject: anObject
%

category: 'Encoded OOPs'
method: ByteArray
nextPutOopOfObject: anObject
"Extend the receiver by 8 bytes and add the 8 byte OOP of anObject."

^self at: self size + 1 putOopValueOfObject: anObject
%

category: 'Encoded OOPs'
method: ByteArray
put: anInt objectsWithOldOopValueAt: anOffset into: anArray
"Extract a given number of objects from the OOPs stored in the receiver
 starting at the given offset. Each OOP extracted occupies 4 bytes
 in the receiver. Store the objects into the specified Array object.
 A nil is stored in the array for each object which does not exist.
 The specified Array is set to size 0 at the start of the operation."

1 to: anInt do:[:j | | obj |
  obj := self getObjectWithOldOopValueAt: j .
  anArray at: j put: obj .
  ].
anArray size: anInt .
^ self
%

category: 'Encoded OOPs'
method: ByteArray
put: anInt objectsWithOopValueAt: anOffset into: anArray
"Extract a given number of objects from the OOPs stored in the receiver
 starting at the given offset. Each OOP extracted occupies 8 bytes
 in the receiver. Store the objects into the specified Array object.
 A nil is stored in the array for each object which does not exist.
 The specified Array is set to size 0 at the start of the operation."

1 to: anInt do:[:j | | obj |
  obj := self getObjectWithOopValueAt: j .
  anArray at: j put: obj .
  ].
anArray size: anInt .
^ self
%

category: 'Encoded OOPs'
method: ByteArray
putObjectsWithOldOopValuesAtIndices: anArrayOfOffsets into: anArray
"For each offset stored in anArrayOfOffsets, extract the OOP from the
 receiver stored at that offset.  Then store the object with that OOP in
 anArray.  A nil is stored in anArray for each object which does not exist.
 Each OOP extracted occupies 4 bytes in the receiver.
 The specified Array is set to size 0 at the start of the operation."

| limit |
limit := anArrayOfOffsets size .
1 to: limit do:[:j | | obj |
   obj := self getObjectWithOldOopValueAt: (anArrayOfOffsets at: j) .
   anArray at: j put: obj .
  ].
anArray size: limit .
^ self
%

category: 'Encoded OOPs'
method: ByteArray
putObjectsWithOopValuesAtIndices: anArrayOfOffsets into: anArray
"For each offset stored in anArrayOfOffsets, extract the OOP from the
 receiver stored at that offset.  Then store the object with that OOP in
 anArray.  A nil is stored in anArray for each object which does not exist.
 Each OOP extracted occupies 8 bytes in the receiver.
 The specified Array is set to size 0 at the start of the operation."

| limit |
limit := anArrayOfOffsets size .
1 to: limit do:[:j | | obj |
   obj := self getObjectWithOopValueAt: (anArrayOfOffsets at: j) .
   anArray at: j put: obj .
  ].
anArray size: limit .
^ self
%

category: 'Accessing'
method: ByteArray
quadByteCharAt: index

"Returns a quad-byte Character located at index in the receiver. The most
 significant byte would be the one located at index, the least significant
 one located at index + 3."

<primitive: 703>

(index _isInteger)
  ifFalse: [^ self _errorNonIntegerIndex: index].

((index <= 0) or: [ (index >= self size) ])
  ifTrue: [^ self _errorIndexOutOfRange: index].

self _validateByteClass: ByteArray .
self _primitiveFailed: #quadByteCharAt: args: { index }
%

category: 'Removing'
method: ByteArray
removeFrom: startIndex to: stopIndex

"Deletes the elements of the receiver from startIndex to stopIndex.  The
 size of the receiver is decreased by stopIndex - startIndex + 1.

 Both startIndex and stopIndex must be positive integers not larger than the
 size of the receiver, with startIndex <= stopIndex."

<primitive: 386>

(stopIndex < startIndex)
ifTrue:
   [ ^ startIndex _error: #rtErrBadCopyFromTo args: { stopIndex }].
((stopIndex > self size) or: [(stopIndex < 1)])
   ifTrue: [ ^ self _errorIndexOutOfRange: stopIndex].
(startIndex < 1)
   ifTrue: [ ^ self _errorIndexOutOfRange: startIndex].
^ self _primitiveFailed: #removeFrom:to: args: { startIndex . stopIndex }
%

category: 'Copying'
method: ByteArray
replaceFrom: startIndex to: stopIndex with: aSeqCollection startingAt: repIndex

"Replaces the elements of the receiver between the indexes startIndex and
 stopIndex inclusive with the elements of aSeqCollection starting at repIndex.
 If aSeqCollection is identical to the receiver, the source and
 destination blocks may overlap.

 The primitive supports directly the case where
    (aSeqCollection isKindOfClass: CByteArray) == true ,
 with repIndex being one-based .

 Returns the receiver."

<primitive: 297>
startIndex _isSmallInteger ifFalse:[ startIndex _validateClass: SmallInteger ].
stopIndex _isSmallInteger ifFalse:[ stopIndex _validateClass: SmallInteger ].
repIndex _isSmallInteger ifFalse:[ repIndex _validateClass: SmallInteger ].
(aSeqCollection stringCharSize >= 2) ifTrue:[
  "aSeqCollection is a DoubleByteString or QuadByteString"
  aSeqCollection _error: #rtErrInvalidArgClass args: { String . ByteArray }
].
^ super replaceFrom: startIndex to: stopIndex with: aSeqCollection startingAt: repIndex
%

category: 'Message Digests'
method: ByteArray
sha1Sum

"Return the 160 bit SHA1 checksum of the receiver as a LargeInteger.

 Computation is per FIPS PUB 180-3:
   http://csrc.nist.gov/publications/fips/fips180-3/fips180-3_final.pdf

 For DoubleByteString and QuadByteString, the computation is based
 on viewing the string as a ByteArray holding big-endian characters.
"

^ self _asMessageDigestKind: 2
%

category: 'Message Digests'
method: ByteArray
sha1SumBytes

"Return the 160 bit SHA1 checksum of the receiver as a ByteArray.

 Computation is per FIPS PUB 180-3:
   http://csrc.nist.gov/publications/fips/fips180-3/fips180-3_final.pdf

 For DoubleByteString and QuadByteString, the computation is based
 on viewing the string as a ByteArray holding big-endian characters.
"

^ self _asMessageDigestKind: -2
%

category: 'Message Digests'
method: ByteArray
sha256Sum

"Return the 256 bit SHA256 checksum of the receiver as a LargeInteger.

 Computation is per FIPS PUB 180-3:
   http://csrc.nist.gov/publications/fips/fips180-3/fips180-3_final.pdf

 For DoubleByteString and QuadByteString, the computation is based
 on viewing the string as a ByteArray holding big-endian characters.
"

^ self _asMessageDigestKind: 3
%

category: 'Message Digests'
method: ByteArray
sha256SumBytes

"Return the 256 bit SHA256 checksum of the receiver as a ByteArray.

 Computation is per FIPS PUB 180-3:
   http://csrc.nist.gov/publications/fips/fips180-3/fips180-3_final.pdf

 For DoubleByteString and QuadByteString, the computation is based
 on viewing the string as a ByteArray holding big-endian characters.
"

^ self _asMessageDigestKind: -3
%

category: 'Message Digests'
method: ByteArray
sha3_224Sum

"Return the SHA3 224 bit checksum of the receiver as a LargeInteger.

 Computation is per FIPS PUB 202
   https://nvlpubs.nist.gov/nistpubs/fips/nist.fips.202.pdf

 For DoubleByteString and QuadByteString, the computation is based
 on viewing the string as a ByteArray holding big-endian characters.
"

^ self _asMessageDigestKind: 5
%

category: 'Message Digests'
method: ByteArray
sha3_224SumBytes

"Return the SHA3 224 bit checksum of the receiver as a ByteArray.

 Computation is per FIPS PUB 202
   https://nvlpubs.nist.gov/nistpubs/fips/nist.fips.202.pdf

 For DoubleByteString and QuadByteString, the computation is based
 on viewing the string as a ByteArray holding big-endian characters.
"

^ self _asMessageDigestKind: -5
%

category: 'Message Digests'
method: ByteArray
sha3_256Sum

"Return the SHA3 256 bit checksum of the receiver as a LargeInteger.

 Computation is per FIPS PUB 202
   https://nvlpubs.nist.gov/nistpubs/fips/nist.fips.202.pdf

 For DoubleByteString and QuadByteString, the computation is based
 on viewing the string as a ByteArray holding big-endian characters.
"

^ self _asMessageDigestKind: 6
%

category: 'Message Digests'
method: ByteArray
sha3_256SumBytes

"Return the SHA3 256 bit checksum of the receiver as a ByteArray.

 Computation is per FIPS PUB 202
   https://nvlpubs.nist.gov/nistpubs/fips/nist.fips.202.pdf

 For DoubleByteString and QuadByteString, the computation is based
 on viewing the string as a ByteArray holding big-endian characters.
"

^ self _asMessageDigestKind: -6
%

category: 'Message Digests'
method: ByteArray
sha3_384Sum

"Return the SHA3 384 bit checksum of the receiver as a LargeInteger.

 Computation is per FIPS PUB 202
   https://nvlpubs.nist.gov/nistpubs/fips/nist.fips.202.pdf

 For DoubleByteString and QuadByteString, the computation is based
 on viewing the string as a ByteArray holding big-endian characters.
"

^ self _asMessageDigestKind: 7
%

category: 'Message Digests'
method: ByteArray
sha3_384SumBytes

"Return the SHA3 384 bit checksum of the receiver as a ByteArray.

 Computation is per FIPS PUB 202
   https://nvlpubs.nist.gov/nistpubs/fips/nist.fips.202.pdf

 For DoubleByteString and QuadByteString, the computation is based
 on viewing the string as a ByteArray holding big-endian characters.
"

^ self _asMessageDigestKind: -7
%

category: 'Message Digests'
method: ByteArray
sha3_512Sum

"Return the SHA3 512 bit checksum of the receiver as a LargeInteger.

 Computation is per FIPS PUB 202
   https://nvlpubs.nist.gov/nistpubs/fips/nist.fips.202.pdf

 For DoubleByteString and QuadByteString, the computation is based
 on viewing the string as a ByteArray holding big-endian characters.
"

^ self _asMessageDigestKind: 8
%

category: 'Message Digests'
method: ByteArray
sha3_512SumBytes

"Return the SHA3 512 bit checksum of the receiver as a ByteArray.

 Computation is per FIPS PUB 202
   https://nvlpubs.nist.gov/nistpubs/fips/nist.fips.202.pdf

 For DoubleByteString and QuadByteString, the computation is based
 on viewing the string as a ByteArray holding big-endian characters.
"

^ self _asMessageDigestKind: -8
%

category: 'Message Digests'
method: ByteArray
sha512Sum

"Return the 512 bit SHA512 checksum of the receiver as a LargeInteger.

 Computation is per FIPS PUB 180-3:
   http://csrc.nist.gov/publications/fips/fips180-3/fips180-3_final.pdf

 For DoubleByteString and QuadByteString, the computation is based
 on viewing the string as a ByteArray holding big-endian characters.
"

^ self _asMessageDigestKind: 4
%

category: 'Message Digests'
method: ByteArray
sha512SumBytes

"Return the 512 bit SHA512 checksum of the receiver as a ByteArray.

 Computation is per FIPS PUB 180-3:
   http://csrc.nist.gov/publications/fips/fips180-3/fips180-3_final.pdf

 For DoubleByteString and QuadByteString, the computation is based
 on viewing the string as a ByteArray holding big-endian characters.
"

^ self _asMessageDigestKind: -4
%

category: 'Private-Accessing'
method: ByteArray
shortStringAt: startIndex

^self at: startIndex sizeBytes:  1 stringSize: nil
%

category: 'Private-Comparing'
method: ByteArray
shortStringAt: anIndex compareWith: aByteObject startingAt: stringOffset opCode: anOpCode
 "Compares, in order starting at anIndex, if the contents of the receiver
  are less than/greater than the contents of aByteObject, starting at stringOffset.
  The first byte of the receiver is assumed to be the size of the string
  held in the receiver.  GemStone character precedence is adhered to.
  The argument string must be a small object.
op code == 0 means less than
op code == 1 means greater than"

<primitive: 625>
self _primitiveFailed: #shortStringAt:compareWith:startingAt:opCode:
     args: { anIndex . aByteObject . stringOffset . anOpCode }
%

category: 'Private-Comparing'
method: ByteArray
shortStringAt: anIndex greaterThan: aByteObject startingAt: stringOffset

 " Checks, in order starting at anIndex, if the contents of the receiver
  are greater than the contents of aByteObject, starting at stringOffset.
  The first byte of the receiver is assumed to be the size of the string
  held in the receiver.
 GemStone character precedence is adhered to.
  The argument string must be a small object."

^self shortStringAt: anIndex compareWith: aByteObject startingAt: stringOffset opCode: 1
%

category: 'Private-Comparing'
method: ByteArray
shortStringAt: anIndex lessThan: aByteObject startingAt: stringOffset

 " Checks, in order starting at anIndex, if the contents of the receiver
  are less than the contents of aByteObject, starting at stringOffset.
  The first byte of the receiver is assumed to be the size of the string
  held in the receiver.
 GemStone character precedence is adhered to.
  The argument string must be a small object."

^self shortStringAt: anIndex compareWith: aByteObject startingAt: stringOffset opCode: 0
%

category: 'Private-Updating'
method: ByteArray
shortStringAt: startIndex put: aString fromOffset: stringOffset
	^self at: startIndex put: aString fromOffset: stringOffset sizeBytes: 1
%

category: 'Accessing (Native)'
method: ByteArray
signed16AsNativeAt: startIndex

"Answer the signed 2 byte integer at offset startIndex.
 Integer is assumed to be in native format."
 
^ self at: startIndex signed: true width: 512
%

category: 'Private-Accessing'
method: ByteArray
signed16At: startIndex

^self at: startIndex signed: true width: 2
%

category: 'Private-Updating'
method: ByteArray
signed16At: startIndex put: anInteger

^self at: startIndex put: anInteger signed: true width: 2
%

category: 'Updating (Native)'
method: ByteArray
signed16At: startIndex putAsNative: anInteger

"Store anInteger at startIndex as a native 2 byte signed integer."

^self at: startIndex put: anInteger signed: true width: 512
%

category: 'Private-Accessing'
method: ByteArray
signed24At: startIndex

^self at: startIndex signed: true width: 3
%

category: 'Private-Updating'
method: ByteArray
signed24At: startIndex put: anInteger

^self at: startIndex put: anInteger signed: true width: 3
%

category: 'Accessing (Native)'
method: ByteArray
signed32AsNativeAt: startIndex

"Answer the signed 4 byte integer at offset startIndex.
 Integer is assumed to be in native format."
 
^ self at: startIndex signed: true width: 1024
%

category: 'Private-Accessing'
method: ByteArray
signed32At: startIndex

^self at: startIndex signed: true width: 4
%

category: 'Private-Updating'
method: ByteArray
signed32At: startIndex put: anInteger

^self at: startIndex put: anInteger signed: true width: 4
%

category: 'Updating (Native)'
method: ByteArray
signed32At: startIndex putAsNative: anInteger

"Store anInteger at startIndex as a native 4 byte signed integer."

^self at: startIndex put: anInteger signed: true width: 1024
%

category: 'Accessing (Native)'
method: ByteArray
signed64AsNativeAt: startIndex

"Answer the signed 8 byte integer at offset startIndex.
 Integer is assumed to be in native format."
 
^ self at: startIndex signed: true width: 2048
%

category: 'Private-Accessing'
method: ByteArray
signed64At: startIndex

^self at: startIndex signed: true width: 8
%

category: 'Private-Updating'
method: ByteArray
signed64At: startIndex put: anInteger

^self at: startIndex put: anInteger signed: true width: 8
%

category: 'Updating (Native)'
method: ByteArray
signed64At: startIndex putAsNative: anInteger

"Store anInteger at startIndex as a native 8 byte signed integer."

^self at: startIndex put: anInteger signed: true width: 2048
%

category: 'Private-Accessing'
method: ByteArray
signed8At: startIndex

^self at: startIndex signed: true width: 1
%

category: 'Private-Updating'
method: ByteArray
signed8At: startIndex put: anInteger

^self at: startIndex put: anInteger signed: true width: 1
%

category: 'Digital Signature Creation - EC'
method: ByteArray
signWithEcPrivateKey: aGsTlsPrivateKey into: aByteArrayOrNil
"Signs the receiver with the given elliptic curve private key. Returns a ByteArray containing the resulting
 signature.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPrivateKey _validateAlgorithm: #EC ; _validateIsPrivateKey .
^ self _primAsymSignVerifyWithKey: aGsTlsPrivateKey digestKind: 0 signature: aByteArrayOrNil
%

category: 'Digital Signature Creation - DSA'
method: ByteArray
signWithSha1AndDsaPrivateKey: aGsTlsPrivateKey into: aByteArrayOrNil
"Hashes the receiver using SHA1 and signs the resulting hash with the given
 DSA private key. Returns a ByteArray containing the resulting signature.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPrivateKey _validateAlgorithm: #DSA ; _validateIsPrivateKey .
^ self _primAsymSignVerifyWithKey: aGsTlsPrivateKey digestKind: 2 signature: aByteArrayOrNil
%

category: 'Digital Signature Creation - RSA'
method: ByteArray
signWithSha1AndRsaPrivateKey: aGsTlsPrivateKey into: aByteArrayOrNil
"Hashes the receiver using SHA1 and signs the resulting hash with the given
 RSA private key using #PKCS1 padding. Returns a ByteArray containing the
 resulting signature.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPrivateKey _validateAlgorithm: #RSA ; _validateIsPrivateKey ; _validateIsNotRsaPss .
^ self _primAsymSignVerifyWithKey: aGsTlsPrivateKey digestKind: 2 signature: aByteArrayOrNil
%

category: 'Digital Signature Creation - RSA'
method: ByteArray
signWithSha1AndRsaPssPrivateKey: aGsTlsPrivateKey into: aByteArrayOrNil
"Hashes the receiver using SHA1 and signs the resulting hash with the given
 RSA private key and PSS padding. Returns a ByteArray containing the resulting
 signature.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPrivateKey _validateAlgorithm: #RSA ; _validateIsPrivateKey .
^ self _primAsymSignVerifyWithKey: aGsTlsPrivateKey digestKind: -2 signature: aByteArrayOrNil
%

category: 'Digital Signature Creation - DSA'
method: ByteArray
signWithSha256AndDsaPrivateKey: aGsTlsPrivateKey into: aByteArrayOrNil
"Hashes the receiver using SHA2 256 and signs the resulting hash with the given
 DSA private key. Returns a ByteArray containing the resulting signature.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPrivateKey _validateAlgorithm: #DSA ; _validateIsPrivateKey .
^ self _primAsymSignVerifyWithKey: aGsTlsPrivateKey digestKind: 3 signature: aByteArrayOrNil
%

category: 'Digital Signature Creation - RSA'
method: ByteArray
signWithSha256AndRsaPrivateKey: aGsTlsPrivateKey into: aByteArrayOrNil
"Hashes the receiver using SHA 256 and signs the resulting hash with the given
 RSA private key using #PKCS1 padding. Returns a ByteArray containing the resulting
 signature.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPrivateKey _validateAlgorithm: #RSA ; _validateIsPrivateKey ; _validateIsNotRsaPss .
^ self _primAsymSignVerifyWithKey: aGsTlsPrivateKey digestKind: 3 signature: aByteArrayOrNil
%

category: 'Digital Signature Creation - RSA'
method: ByteArray
signWithSha256AndRsaPssPrivateKey: aGsTlsPrivateKey into: aByteArrayOrNil
"Hashes the receiver using SHA2 256 and signs the resulting hash with the given
 RSA private key and PSS padding. Returns a ByteArray containing the resulting
 signature.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPrivateKey _validateAlgorithm: #RSA ; _validateIsPrivateKey .
^ self _primAsymSignVerifyWithKey: aGsTlsPrivateKey digestKind: -3 signature: aByteArrayOrNil
%

category: 'Digital Signature Creation - RSA'
method: ByteArray
signWithSha3_224AndRsaPrivateKey: aGsTlsPrivateKey into: aByteArrayOrNil
"Hashes the receiver using SHA3 224 and signs the resulting hash with the given
 RSA private key using #PKCS1 padding. Returns a ByteArray containing the resulting
 signature.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPrivateKey _validateAlgorithm: #RSA ; _validateIsPrivateKey ; _validateIsNotRsaPss .
^ self _primAsymSignVerifyWithKey: aGsTlsPrivateKey digestKind: 5 signature: aByteArrayOrNil
%

category: 'Digital Signature Creation - RSA'
method: ByteArray
signWithSha3_224AndRsaPssPrivateKey: aGsTlsPrivateKey into: aByteArrayOrNil
"Hashes the receiver using SHA3 224 and signs the resulting hash with the given
 RSA private key and PSS padding. Returns a ByteArray containing the resulting
 signature.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPrivateKey _validateAlgorithm: #RSA ; _validateIsPrivateKey .
^ self _primAsymSignVerifyWithKey: aGsTlsPrivateKey digestKind: -5 signature: aByteArrayOrNil
%

category: 'Digital Signature Creation - RSA'
method: ByteArray
signWithSha3_256AndRsaPrivateKey: aGsTlsPrivateKey into: aByteArrayOrNil
"Hashes the receiver using SHA3 256 and signs the resulting hash with the given
 RSA private key using #PKCS1 padding. Returns a ByteArray containing the resulting
 signature.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPrivateKey _validateAlgorithm: #RSA ; _validateIsPrivateKey ; _validateIsNotRsaPss .
^ self _primAsymSignVerifyWithKey: aGsTlsPrivateKey digestKind: 6 signature: aByteArrayOrNil
%

category: 'Digital Signature Creation - RSA'
method: ByteArray
signWithSha3_256AndRsaPssPrivateKey: aGsTlsPrivateKey into: aByteArrayOrNil
"Hashes the receiver using SHA3 256 and signs the resulting hash with the given
 RSA private key and PSS padding. Returns a ByteArray containing the resulting
 signature.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPrivateKey _validateAlgorithm: #RSA ; _validateIsPrivateKey .
^ self _primAsymSignVerifyWithKey: aGsTlsPrivateKey digestKind: -6 signature: aByteArrayOrNil
%

category: 'Digital Signature Creation - RSA'
method: ByteArray
signWithSha3_384AndRsaPrivateKey: aGsTlsPrivateKey into: aByteArrayOrNil
"Hashes the receiver using SHA3 384 and signs the resulting hash with the given
 RSA private key using #PKCS1 padding. Returns a ByteArray containing the resulting
 signature.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPrivateKey _validateAlgorithm: #RSA ; _validateIsPrivateKey ; _validateIsNotRsaPss .
^ self _primAsymSignVerifyWithKey: aGsTlsPrivateKey digestKind: 7 signature: aByteArrayOrNil
%

category: 'Digital Signature Creation - RSA'
method: ByteArray
signWithSha3_384AndRsaPssPrivateKey: aGsTlsPrivateKey into: aByteArrayOrNil
"Hashes the receiver using SHA3 384 and signs the resulting hash with the given
 RSA private key and PSS padding. Returns a ByteArray containing the resulting
 signature.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPrivateKey _validateAlgorithm: #RSA ; _validateIsPrivateKey .
^ self _primAsymSignVerifyWithKey: aGsTlsPrivateKey digestKind: -7 signature: aByteArrayOrNil
%

category: 'Digital Signature Creation - RSA'
method: ByteArray
signWithSha3_512AndRsaPrivateKey: aGsTlsPrivateKey into: aByteArrayOrNil
"Hashes the receiver using SHA3 512 and signs the resulting hash with the given
 RSA private key using #PKCS1 padding. Returns a ByteArray containing the resulting
 signature.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPrivateKey _validateAlgorithm: #RSA ; _validateIsPrivateKey ; _validateIsNotRsaPss .
^ self _primAsymSignVerifyWithKey: aGsTlsPrivateKey digestKind: 8 signature: aByteArrayOrNil
%

category: 'Digital Signature Creation - RSA'
method: ByteArray
signWithSha3_512AndRsaPssPrivateKey: aGsTlsPrivateKey into: aByteArrayOrNil
"Hashes the receiver using SHA3 512 and signs the resulting hash with the given
 RSA private key and PSS padding. Returns a ByteArray containing the resulting
 signature.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPrivateKey _validateAlgorithm: #RSA ; _validateIsPrivateKey .
^ self _primAsymSignVerifyWithKey: aGsTlsPrivateKey digestKind: -8 signature: aByteArrayOrNil
%

category: 'Digital Signature Creation - DSA'
method: ByteArray
signWithSha512AndDsaPrivateKey: aGsTlsPrivateKey into: aByteArrayOrNil
"Hashes the receiver using SHA2 512 and signs the resulting hash with the given
 DSA private key. Returns a ByteArray containing the resulting signature.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPrivateKey _validateAlgorithm: #DSA ; _validateIsPrivateKey .
^ self _primAsymSignVerifyWithKey: aGsTlsPrivateKey digestKind: 4 signature: aByteArrayOrNil
%

category: 'Digital Signature Creation - RSA'
method: ByteArray
signWithSha512AndRsaPrivateKey: aGsTlsPrivateKey into: aByteArrayOrNil
"Hashes the receiver using SHA2 512 and signs the resulting hash with the given
 RSA private key using #PKCS1 padding. Returns a ByteArray containing the resulting
 signature.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPrivateKey _validateAlgorithm: #RSA ; _validateIsPrivateKey ; _validateIsNotRsaPss .
^ self _primAsymSignVerifyWithKey: aGsTlsPrivateKey digestKind: 4 signature: aByteArrayOrNil
%

category: 'Digital Signature Creation - RSA'
method: ByteArray
signWithSha512AndRsaPssPrivateKey: aGsTlsPrivateKey into: aByteArrayOrNil
"Hashes the receiver using SHA2 512 and signs the resulting hash with the given
 RSA private key and PSS padding. Returns a ByteArray containing the resulting
 signature.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPrivateKey _validateAlgorithm: #RSA ; _validateIsPrivateKey .
^ self _primAsymSignVerifyWithKey: aGsTlsPrivateKey digestKind: -4 signature: aByteArrayOrNil
%

category: 'Private-Accessing'
method: ByteArray
string4gAt: startIndex

^self at: startIndex sizeBytes: 4 stringSize: nil
%

category: 'Private-Updating'
method: ByteArray
string4gAt: startIndex put: aString fromOffset: stringOffset
	^self at: startIndex put: aString fromOffset: stringOffset sizeBytes: 4
%

category: 'Private-Accessing'
method: ByteArray
string64kAt: startIndex

^self at: startIndex sizeBytes: 2 stringSize: nil
%

category: 'Private-Updating'
method: ByteArray
string64kAt: startIndex put: aString fromOffset: stringOffset
	^self at: startIndex put: aString fromOffset: stringOffset sizeBytes: 2
%

category: 'Private-Updating'
method: ByteArray
stringAt: startIndex put: aString fromOffset: stringOffset
	^self at: startIndex put: aString fromOffset: stringOffset sizeBytes: 0
%

category: 'Private-Accessing'
method: ByteArray
stringOfSize: anInt at: startIndex

^self at: startIndex sizeBytes:  0 stringSize: anInt
%

category: 'Accessing (Native)'
method: ByteArray
unsigned16AsNativeAt: startIndex

"Answer the unsigned 2 byte integer at offset startIndex.
 Integer is assumed to be in native format."
 
^ self at: startIndex signed: false width: 512
%

category: 'Private-Accessing'
method: ByteArray
unsigned16At: startIndex

^self at: startIndex signed: false width: 2
%

category: 'Private-Updating'
method: ByteArray
unsigned16At: startIndex put: anUnsignedInt

^self at: startIndex put: anUnsignedInt signed: false width: 2
%

category: 'Updating (Native)'
method: ByteArray
unsigned16At: startIndex putAsNative: anInteger

"Store anInteger at startIndex as a native 2 byte unsigned integer."

^self at: startIndex put: anInteger signed: false width: 512
%

category: 'Private-Accessing'
method: ByteArray
unsigned24At: startIndex

^self at: startIndex signed: false width: 3
%

category: 'Private-Updating'
method: ByteArray
unsigned24At: startIndex put: anUnsignedInt

^self at: startIndex put: anUnsignedInt signed: false width: 3
%

category: 'Accessing (Native)'
method: ByteArray
unsigned32AsNativeAt: startIndex

"Answer the unsigned 4 byte integer at offset startIndex.
 Integer is assumed to be in native format."
 
^ self at: startIndex signed: false width: 1024
%

category: 'Private-Accessing'
method: ByteArray
unsigned32At: startIndex

^self at: startIndex signed: false width: 4
%

category: 'Private-Updating'
method: ByteArray
unsigned32At: startIndex put: anUnsignedInt

^self at: startIndex put: anUnsignedInt signed: false width: 4
%

category: 'Updating (Native)'
method: ByteArray
unsigned32At: startIndex putAsNative: anInteger

"Store anInteger at startIndex as a native 4 byte unsigned integer."

^self at: startIndex put: anInteger signed: false width: 1024
%

category: 'Accessing (Native)'
method: ByteArray
unsigned64AsNativeAt: startIndex

"Answer the unsigned 8 byte integer at offset startIndex.
 Integer is assumed to be in native format."
 
^ self at: startIndex signed: false width: 2048
%

category: 'Private-Accessing'
method: ByteArray
unsigned64At: startIndex

^self at: startIndex signed: false width: 8
%

category: 'Private-Updating'
method: ByteArray
unsigned64At: startIndex put: anUnsignedInt

^self at: startIndex put: anUnsignedInt signed: false width: 8
%

category: 'Updating (Native)'
method: ByteArray
unsigned64At: startIndex putAsNative: anInteger

"Store anInteger at startIndex as a native 8 byte unsigned integer."

^self at: startIndex put: anInteger signed: false width: 2048
%

category: 'Private-Accessing'
method: ByteArray
unsigned8At: startIndex

^self at: startIndex signed: false width: 1
%

category: 'Private-Updating'
method: ByteArray
unsigned8At: startIndex put: anUnsignedInt

^self at: startIndex put: anUnsignedInt signed: false width: 1
%

category: 'Digital Signature Creation - EC'
method: ByteArray
verifyWithEcPublicKey: aGsTlsPublicKey signature: aByteArray
"Verifies the receiver using the given elliptic curve key and signature.  Returns true
 if the signature is correct. Otherwise raises an exception.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPublicKey _validateAlgorithm: #EC ; _validateIsPublicKey .
^ self _primAsymSignVerifyWithKey: aGsTlsPublicKey digestKind: 0 signature: aByteArray
%

category: 'Digital Signature Verification - DSA'
method: ByteArray
verifyWithSha1AndDsaPublicKey: aGsTlsPublicKey signature: aByteArray
"Hashes the receiver using SHA1 and verifies the resulting hash using the
 given DSA public key and signature. Returns true if the signature is correct.
 Otherwise raises an exception.

 See the method:
  # _primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPublicKey _validateAlgorithm: #DSA ; _validateIsPublicKey .
^ self _primAsymSignVerifyWithKey: aGsTlsPublicKey digestKind: 2 signature: aByteArray
%

category: 'Digital Signature Verification - RSA'
method: ByteArray
verifyWithSha1AndRsaPssPublicKey: aGsTlsPublicKey signature: aByteArray
"Hashes the receiver using SHA1 and verifies the resulting hash using the given
 RSA public key and signature with PSS padding. Returns true if the signature
 is correct. Otherwise raises an exception.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPublicKey _validateAlgorithm: #RSA ; _validateIsPublicKey .
^ self _primAsymSignVerifyWithKey: aGsTlsPublicKey digestKind: -2 signature: aByteArray
%

category: 'Digital Signature Verification - RSA'
method: ByteArray
verifyWithSha1AndRsaPublicKey: aGsTlsPublicKey signature: aByteArray
"Hashes the receiver using SHA1 and verifies the resulting hash using the given
 RSA public key and signature with #PKCS1 padding. Returns true if the signature
 is correct. Otherwise raises an exception.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPublicKey _validateAlgorithm: #RSA ; _validateIsPublicKey ; _validateIsNotRsaPss .
^ self _primAsymSignVerifyWithKey: aGsTlsPublicKey digestKind: 2 signature: aByteArray
%

category: 'Digital Signature Verification - DSA'
method: ByteArray
verifyWithSha256AndDsaPublicKey: aGsTlsPublicKey signature: aByteArray
"Hashes the receiver using SHA256 and verifies the resulting hash using the
 given DSA public key and signature. Returns true if the signature is correct.
 Otherwise raises an exception.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPublicKey _validateAlgorithm: #DSA ; _validateIsPublicKey .
^ self _primAsymSignVerifyWithKey: aGsTlsPublicKey digestKind: 3 signature: aByteArray
%

category: 'Digital Signature Verification - RSA'
method: ByteArray
verifyWithSha256AndRsaPssPublicKey: aGsTlsPublicKey signature: aByteArray
"Hashes the receiver using SHA2 256 and verifies the resulting hash using the given
 RSA public key and signature with PSS padding. Returns true if the signature
 is correct. Otherwise raises an exception.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPublicKey _validateAlgorithm: #RSA ; _validateIsPublicKey .
^ self _primAsymSignVerifyWithKey: aGsTlsPublicKey digestKind: -3 signature: aByteArray
%

category: 'Digital Signature Verification - RSA'
method: ByteArray
verifyWithSha256AndRsaPublicKey: aGsTlsPublicKey signature: aByteArray
"Hashes the receiver using SHA2 256 and verifies the resulting hash using the given
 RSA public key and signature with #PKCS1 padding. Returns true if the signature
 is correct. Otherwise raises an exception.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPublicKey _validateAlgorithm: #RSA ; _validateIsPublicKey ; _validateIsNotRsaPss .
^ self _primAsymSignVerifyWithKey: aGsTlsPublicKey digestKind: 3 signature: aByteArray
%

category: 'Digital Signature Verification - RSA'
method: ByteArray
verifyWithSha3_224AndRsaPssPublicKey: aGsTlsPublicKey signature: aByteArray
"Hashes the receiver using SHA3 224 and verifies the resulting hash using the given
 RSA public key and signature with PSS padding. Returns true if the signature
 is correct. Otherwise raises an exception.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPublicKey _validateAlgorithm: #RSA ; _validateIsPublicKey .
^ self _primAsymSignVerifyWithKey: aGsTlsPublicKey digestKind: -5 signature: aByteArray
%

category: 'Digital Signature Verification - RSA'
method: ByteArray
verifyWithSha3_224AndRsaPublicKey: aGsTlsPublicKey signature: aByteArray
"Hashes the receiver using SHA3 224 and verifies the resulting hash using the given
 RSA public key and signature with #PKCS1 padding. Returns true if the signature
 is correct. Otherwise raises an exception.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPublicKey _validateAlgorithm: #RSA ; _validateIsPublicKey ; _validateIsNotRsaPss .
^ self _primAsymSignVerifyWithKey: aGsTlsPublicKey digestKind: 5 signature: aByteArray
%

category: 'Digital Signature Verification - RSA'
method: ByteArray
verifyWithSha3_256AndRsaPssPublicKey: aGsTlsPublicKey signature: aByteArray
"Hashes the receiver using SHA3 256 and verifies the resulting hash using the given
 RSA public key and signature with PSS padding. Returns true if the signature
 is correct. Otherwise raises an exception.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPublicKey _validateAlgorithm: #RSA ; _validateIsPublicKey .
^ self _primAsymSignVerifyWithKey: aGsTlsPublicKey digestKind: -6 signature: aByteArray
%

category: 'Digital Signature Verification - RSA'
method: ByteArray
verifyWithSha3_256AndRsaPublicKey: aGsTlsPublicKey signature: aByteArray
"Hashes the receiver using SHA3 256 and verifies the resulting hash using the given
 RSA public key and signature with #PKCS1 padding. Returns true if the signature
 is correct. Otherwise raises an exception.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPublicKey _validateAlgorithm: #RSA ; _validateIsPublicKey ; _validateIsNotRsaPss .
^ self _primAsymSignVerifyWithKey: aGsTlsPublicKey digestKind: 6 signature: aByteArray
%

category: 'Digital Signature Verification - RSA'
method: ByteArray
verifyWithSha3_384AndRsaPssPublicKey: aGsTlsPublicKey signature: aByteArray
"Hashes the receiver using SHA3 384 and verifies the resulting hash using the given
 RSA public key and signature with PSS padding. Returns true if the signature
 is correct. Otherwise raises an exception.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPublicKey _validateAlgorithm: #RSA ; _validateIsPublicKey .
^ self _primAsymSignVerifyWithKey: aGsTlsPublicKey digestKind: -7 signature: aByteArray
%

category: 'Digital Signature Verification - RSA'
method: ByteArray
verifyWithSha3_384AndRsaPublicKey: aGsTlsPublicKey signature: aByteArray
"Hashes the receiver using SHA3 384 and verifies the resulting hash using the given
 RSA public key and signature with #PKCS1 padding. Returns true if the signature
 is correct. Otherwise raises an exception.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPublicKey _validateAlgorithm: #RSA ; _validateIsPublicKey ; _validateIsNotRsaPss .
^ self _primAsymSignVerifyWithKey: aGsTlsPublicKey digestKind: 7 signature: aByteArray
%

category: 'Digital Signature Verification - RSA'
method: ByteArray
verifyWithSha3_512AndRsaPssPublicKey: aGsTlsPublicKey signature: aByteArray
"Hashes the receiver using SHA3 512 and verifies the resulting hash using the given
 RSA public key and signature with PSS padding. Returns true if the signature
 is correct. Otherwise raises an exception.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPublicKey _validateAlgorithm: #RSA ; _validateIsPublicKey .
^ self _primAsymSignVerifyWithKey: aGsTlsPublicKey digestKind: -8 signature: aByteArray
%

category: 'Digital Signature Verification - RSA'
method: ByteArray
verifyWithSha3_512AndRsaPublicKey: aGsTlsPublicKey signature: aByteArray
"Hashes the receiver using SHA3 512 and verifies the resulting hash using the given
 RSA public key and signature with #PKCS1 padding. Returns true if the signature
 is correct. Otherwise raises an exception.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPublicKey _validateAlgorithm: #RSA ; _validateIsPublicKey ; _validateIsNotRsaPss .
^ self _primAsymSignVerifyWithKey: aGsTlsPublicKey digestKind: 8 signature: aByteArray
%

category: 'Digital Signature Verification - DSA'
method: ByteArray
verifyWithSha512AndDsaPublicKey: aGsTlsPublicKey signature: aByteArray
"Hashes the receiver using SHA512 and verifies the resulting hash using the
 given DSA public key and signature. Returns true if the signature is correct.
 Otherwise raises an exception.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPublicKey _validateAlgorithm: #DSA ; _validateIsPublicKey .
^ self _primAsymSignVerifyWithKey: aGsTlsPublicKey digestKind: 4 signature: aByteArray
%

category: 'Digital Signature Verification - RSA'
method: ByteArray
verifyWithSha512AndRsaPssPublicKey: aGsTlsPublicKey signature: aByteArray
"Hashes the receiver using SHA2 512 and verifies the resulting hash using the given
 RSA public key and signature with PSS padding. Returns true if the signature
 is correct. Otherwise raises an exception.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPublicKey _validateAlgorithm: #RSA ; _validateIsPublicKey .
^ self _primAsymSignVerifyWithKey: aGsTlsPublicKey digestKind: -4 signature: aByteArray
%

category: 'Digital Signature Verification - RSA'
method: ByteArray
verifyWithSha512AndRsaPublicKey: aGsTlsPublicKey signature: aByteArray
"Hashes the receiver using SHA2 512 and verifies the resulting hash using the given
 RSA public key and signature with #PKCS1 padding. Returns true if the signature
 is correct. Otherwise raises an exception.

 See the method:
   #_primAsymSignVerifyWithKey:digestKind:signature:
 for more information."

aGsTlsPublicKey _validateAlgorithm: #RSA ; _validateIsPublicKey ; _validateIsNotRsaPss .
^ self _primAsymSignVerifyWithKey: aGsTlsPublicKey digestKind: 4 signature: aByteArray
%

category: 'Message Digests'
method: ByteArray
_asMessageDigestKind: opCode

"
opCode   Digest Algorithm   Digest Bits
=======================================
  1          md5              128
  2          sha1             160
  3          sha2-256         256
  4          sha2-512         512
  5          sha3-224         224
  6          sha3-256         256
  7          sha3-384         384
  8          sha3-256         512
=======================================

Postive opCode means return result as a LargeInteger.
Negative opCode means return result as a ByteArray.

"
<primitive: 666>
opCode _validateClass: SmallInteger .
(opCode == 0 or:[(opCode < -8) or:[ opCode > 8]])
  ifTrue:[ opCode _error: #rtErrArgOutOfRange args:{ -8 . 8 } ].
^ self _primitiveFailed: #_asMessageDigestKind:
%

category: 'Converting'
method: ByteArray
_asUnicode16

<primitive: 926>

"Return an instance of Unicode7 or Unicode16 using the
minimum bytes per character required to represent the receiver.
Return nil if the receiver is not representable as Unicode7 nor Unicode16."

self _primitiveFailed:#_asUnicode16
%

category: 'Converting'
method: ByteArray
_asUnicode7

<primitive: 925>
"Return an instance of Unicode7 if receiver can be represented
 as a Unicode7 string, else return nil."

self _primitiveFailed:#_asUnicode7
%

category: 'Updating'
method: ByteArray
_basicAt: anIndex put: aValue

"Store aValue in the receiver at anIndex .
 aValue should be a SmallInteger >= 0 and <= 255 . "
<primitive: 1002>

(anIndex _isInteger)
  ifFalse: [ ^ self _errorNonIntegerIndex: anIndex].
((anIndex < 1) | (anIndex > (self size + 1))) "out of bounds"
  ifTrue: [ ^ self _errorIndexOutOfRange: anIndex].
(aValue _isSmallInteger not or: [ (aValue < 0) | (aValue > 255) ])
  ifTrue: [^ aValue _error: #rtErrExpectedByteValue].

self _primitiveFailed: #at:put: args: { anIndex . aValue } .
self _uncontinuableError
%

category: 'Compression'
method: ByteArray
_compressBytes

^ self _compress
%

category: 'Compression'
method: ByteArray
_computeCRC32: crc
"Compute the crc32 value for the receiver, given the starting value.
 The crc32 value for a given receiver should be the same both before
 and after compression.
 The argument and result are 32bit unsigned values."

<primitive: 649>
crc _validateInstanceOf: SmallInteger .
(crc < 0 or:[ crc > 16rFFFFFFFF ]) ifTrue:[
  OutOfRange new name: 'initialCrc32' min: 0 max: 16rFFFFFFFF actual: crc; signal
].
self _primitiveFailed: #_computeCRC32: args: { crc }
%

category: 'Encoding'
method: ByteArray
_decodeFromUTF16toUTF8: bigEndianBoolean
  "Decode UTF16 contents of the receiver.
   bigEndianBoolean==true specifies decode from UTF16-BE , false from UTF16-LE .
   If the first code point is 16rFEFF in the byte order specified, it is passed
   through and the first 3 bytes of the result will be 16rEF 16rBB 16rBF ,
   i.e. the ZWNBSP  code point.
   If the first code point is 16rFFFE in the byte order specified, an error is
   signalled, since 16rFFFE is not a legal Unicode code point, and the byte order
   of the data is probably not as specified.
   Returns an instance of Utf8 .
   "

  <primitive: 212>
  bigEndianBoolean _validateInstanceOf: Boolean .
  self _primitiveFailed: #_decodeFromUTF16toUTF8: args: { bigEndianBoolean } .
%

category: 'Private'
method: ByteArray
_decodeFromUtf8: unicodeResultBool

"Decode UTF8 contents of the receiver.
 If unicodeResultBool == true, result is a Unicode7 , Unicode16 or Unicode32.
 If unicodeResultBool == false, result is a String, DoubleByteString or
  QuadByteString."

^ self _decodeFromUtf8: unicodeResultBool maxSize: nil
%

category: 'Private'
method: ByteArray
_decodeFromUtf8: unicodeResultBool maxSize: aSize
"Decode UTF8 contents of the receiver.
 If unicodeResultBool == true, result is a Unicode7 , Unicode16 or Unicode32.
 If unicodeResultBool == false, result is a String, DoubleByteString or
  QuadByteString.

 aSize should be nil for no limit on result size, or
 a SmallInteger specifying approximate maximum size of the result."

^ self _decodeUtf8StartingAt: 1 unicodeResult: unicodeResultBool maxSize: aSize bytesConsumed: nil
%

category: 'Converting'
method: ByteArray
_decodeUtf8At: anOffset bytesConsumed: anArray

"Attempt to decode one Utf8 codePoint starting at anOffset in the receiver.
 anArray should be a temporary Array of size 1 .
 If successful, returns a Character and (anArray at: 1) is a SmallInteger,
 the number of bytes consumed by the decode.
 If  (self size - anOffset ) are not enough bytes for a decode returns nil.
 Signals an Error if the bytes starting at anOffset are not legal UTF8 data .
 Receiver must be a small ByteArray ( self size <= 16272), otherwise an Error is signalled."

<primitive: 1086>
anOffset _validateClass: SmallInteger .
anArray _validateClass: Array .
^ self _primitiveFailed: #_decodeUtf8At:bytesConsumed: args: { anOffset . anArray }
%

category: 'Converting'
method: ByteArray
_decodeUtf8StartingAt: anOffset unicodeResult: unicodeResultBool
                 maxSize: aSize bytesConsumed: anArray

"Attempt to decode Utf8 data starting at anOffset in the receiver.
 If unicodeResultBool == true, result is a Unicode7 , Unicode16 or Unicode32.
 If unicodeResultBool == false, result is a String, DoubleByteString or
  QuadByteString.
 If there are insufficient bytes in the receiver and anArray ~~ nil,
 returns nil .
  If there are insufficient bytes in the receiver and anArray == nil, signals an Error.
 Signals an Error if the bytes starting at anOffset are not legal UTF8 data .
 If anArray ~~ nil, returns in (anArray at: 1) the number of bytes consumed by the decode."

<primitive: 493>
unicodeResultBool _validateClass: Boolean .
aSize _validateClass: SmallInteger .
anArray ifNotNil:[ anArray _validateClass: Array  ].
anOffset _validateClass: SmallInteger .

^ self _primitiveFailed: #_decodeUtf8StartingAt:unicodeResult:maxSize:bytesConsumed:
          args: { anOffset . unicodeResultBool . aSize . anArray }
%

category: 'Compression'
method: ByteArray
_decompress

"Decompress receiver using zlib.so .
 If receiver contains a dynamic instVar #sourceClass ,
 then the value of that instVar is used as the class of the result.
 otherwise the result is an instance of receiver's class."

  ^self _decompress: 0
%

category: 'Compression'
method: ByteArray
_decompressBytes

^ self _decompress
%

category: 'Private-Updating'
method: ByteArray
_deleteNoShrinkFrom: startIndex to: endIndex anchorTailSize: aSize

"Deletes bytes from startIndex to endIndex by sliding bytes
 from endIndex+1 to aSize-1 to the left and filling with zeros.
 The bytes from  (self size - aSize) to (self size) are not altered.
 The size of the receiver is not changed.
 The size of the receiver must be <= 65536 ."

<primitive: 626>

(startIndex _isInteger)
  ifFalse: [ ^ self _errorNonIntegerIndex: startIndex].
(endIndex _isInteger)
  ifFalse: [ ^ self _errorNonIntegerIndex: endIndex].
(aSize _isInteger)
  ifFalse: [ ^ self _errorNonIntegerIndex: aSize].
self size > 65536 ifTrue:[ self error:'receiver size > 65536' ].
startIndex < 1 ifTrue:[ self _errorIndexOutOfRange:startIndex  ] .
(endIndex < startIndex or:[ endIndex > self size] ) ifTrue:[ self _errorIndexOutOfRange: endIndex].
(aSize < 0 or:[ endIndex > (self size - aSize)]) ifTrue:[ aSize _error: #rtErrArgOutOfRange ].
self _primitiveFailed: #_deleteNoShrinkFrom:to:anchorTailSize:
     args: { startIndex . endIndex . aSize }
%

category: 'Private-Updating'
method: ByteArray
_int32LittleEndianAt: startIndex put: anInteger

"Receiver can be any byte format object.
Does not update any indexed dependent on receiver.
Overwrite the four bytes of the receiver from offset to offset+3 with the low-order four bytes of the given SmallInteger value, in little-endian signed format.
Offset is 1-based and need not be aligned.
Note that if the given value is a SmallInteger outside the range that can be represented in four bytes, the low-order four bytes will silently be stored.
  Returns anInteger
Errors:
  * The given offset is not a SmallInteger (ArgumentTypeError)
  * Some index from offset to offset+3 is outside the size of the receiver (OutOfRange)
  * The given value is not a SmallInteger (ArgumentTypeError)"


<primitive: 946>
startIndex _validateClass: SmallInteger .
anInteger _validateClass: SmallInteger .
(startIndex < 1 or:[ startIndex + 3 > self size]) ifTrue:[
  OutOfRange new
   name:'startIndex' min: 1 max: self size - 3 actual: startIndex  ;
   signal
].
self _primitiveFailed: #int32LittleEndianAt:put: args: { startIndex . anInteger}
%

category: 'Private'
method: ByteArray
_keySizeInBytesForOpCode: opCode

| code codes128Bit codes192Bit codes256Bit |
code := opCode abs .
codes128Bit := { 1 . 4 . 7 } .
codes192Bit := { 2 . 5 . 8 } .
codes256Bit := { 3 . 6 . 9 . 10 } .

(codes128Bit includesIdentical: code)
  ifTrue:[ ^ 16 ].
(codes192Bit includesIdentical: code)
  ifTrue:[ ^ 24 ].
(codes256Bit includesIdentical: code)
  ifTrue:[ ^ 32 ].
%

category: 'Private'
method: ByteArray
_primAddRandomBytes: anIntHowMany startingAt: anIntOffset

<primitive: 954>
anIntHowMany _validateClass: SmallInteger .
anIntOffset  _validateClass: SmallInteger .
anIntHowMany < 1
  ifTrue:[ anIntHowMany _error: #rtErrArgOutOfRange ] .
anIntOffset < 1
  ifTrue:[ anIntOffset _error: #rtErrArgOutOfRange ] .
self _primitiveFailed: #_primAddRandomBytes:startingAt: .
%

category: 'Private'
method: ByteArray
_primAsymSignVerifyWithKey: aKey digestKind: opCode signature: aByteArray

"Signs or verifies the message contained in the receiver using public key
 encryption. aKey must be an instance of GsTlsPrivateKey (which indicates a
 signing operation) or GsTlsPublicKey (which indicates a verify operation).
 For signing keys that require a message digest, anInt indicates one of the
 supported message digests for the specified key type. For signing keys
 that do not require a message digest, anInt must be zero.  See the tables
 below. The same message digest must be used for both signing and
 verifying.

 For signing operations, aByteArray must be a variant instance of ByteArray
 or nil, in which case a new instance of ByteArray will be created to
 contain the signature. For verifying operations, aByteArray must be a
 non-empty instance of ByteArray containing the signature from the signing.

 For secure signing and verifying with RSA keys only, a padding scheme must
 be used. The default RSA padding scheme is RSA_PKCS1_PADDING
 (PKCS #1 v1.5 padding), which is the most common type. However the newer
 PSS (Probabilistic Signature Scheme) is more secure and is recommended
 whenever possible. See RFC 3447 for additional information on PSS padding.
 Other RSA padding schemes, including no padding, are not supported due
 to known security vulnerabilities. The padding scheme selected must be the
 same for the signature and verification else the verification will fail.

 To sign or verify with RSA_PKCS1_PSS_PADDING, negate the digest opCode.
 For example, a message signed with an RSA private key using opCode 2 uses
 SHA1 message digest and (the default) RSA_PKCS1_PADDING. Signing a message
 with an RSA private key using opCode -2 uses SHA1 message digest and
 RSA_PKCS1_PSS_PADDING padding.

 RSA keys of type RSA-PSS may only use RSA_PKCS1_PSS_PADDING. PSS padding
 will be used for such keys in all cases, even if RSA_PKCS1_PADDING is
 requested. RSA-PSS private keys will answer #EVP_PKEY_RSA_PSS when sent
 the #sslAlgorithm message.

 Signing operations return aByteArray containing the signature on success
 and raise a CryptoError exception on error. Verify operations return true
 if the verification succeeds and raise a CryptoError exception if
 verification fails or an error occurs.

 Note that not all private/public key pairs support digital signatures.

 Key Type  Supported Digest Types
 ================================
 DSA       SHA1,SHA2
 ECDSA	   SHA1,SHA2
 RSA	   SHA1,SHA2,SHA3
 EC        None
 Ed25519   None
 Ed448     None
 ==============================


 Digest Type	OpCode
 =====================
 None           0
 SHA1		2
 SHA2-256	3
 SHA2-512	4
 SHA3-224	5
 SHA3-256	6
 SHA3-384	7
 SHA3-512	8
 =====================
"

<primitive: 1089>
opCode _validateClass: SmallInteger .
aKey _validateClasses: { GsTlsPrivateKey . GsTlsPublicKey } .
(aKey isKindOf: GsTlsPrivateKey)
  ifTrue:[ "signing, arg may be nil"
    aByteArray ifNotNil:[ aByteArray _validateClass: ByteArray ].
  ]
  ifFalse:[
     "verifying, arg must be a ByteArray"
    aByteArray _validateClass: ByteArray
].
self _validateKey: aKey withDigestKind: opCode .
^ self _primitiveFailed: #_primAsymSignVerifyWithKey:digestKind:signature:
%

category: 'Private'
method: ByteArray
_primEncryptDecryptWithKey: aKey salt: aSalt opCode: opCode into: destObjOrNil
"Private method for invoking non-AEAD encrypt/decrypt modes. See the method:
    #_primEncryptDecryptWithKey: aKey salt: aSalt opCode: opCode
    into: destObjOrNil tag: tag extraData: eData
 for more information."

^ self _primEncryptDecryptWithKey: aKey
       salt: aSalt
       opCode: opCode
       into: destObjOrNil
       tag: nil
       extraData: nil
%

category: 'Private'
method: ByteArray
_primEncryptDecryptWithKey: aKey salt: aSalt opCode: opCode
into: destObjOrNil tag: tag extraData: eData

"Private method for encrypting or decrypting the receiver.
 The following encryption schemes are currently supported:

 ==================================================
                          Key     Salt    Tag
 opCode Cipher   Mode  bits/Bytes Size   Bytes
 ==================================================
   1     AES     CBC     128/16    16     N/A
   2     AES     CBC     192/24    16     N/A
   3     AES     CBC     256/32    16     N/A
   4     AES     OCB     128/16    12     16
   5     AES     OCB     192/24    12     16
   6     AES     OCB     256/32    12     16
   7     AES     GCM     128/16    12     16
   8     AES     GCM     192/24    12     16
   9     AES     GCM     256/32    12     16
  10   CHACHA20 Poly1305 256/32    12     16
 ==================================================

 AES encryption/decryption (Advanced Encryption Standard) is performed
 using the OpenSSL open source package and the AES specification,
 available at:
   http://csrc.nist.gov/publications/fips/fips197/fips-197.pdf

 CBC is an acronym for cipher block chaining. See the referenced AES
 specification document for further details.

 OCB is an acronym for Offset Cookbook Mode. See RFC 7253 for further
 details.

 GCM is an acronym for Galois Counter Mode. See RFC 5288 for further
 details.

 OCB, GCM and Poly1305 are AEAD modes. AEAD is an acronym for
 Authenticated Encryption with Associated Data. AEAD provides data
 authenticity, confidentiality, and integrity. It also supports
 Additional Authenticated Data (AAD). AAD is not encrypted and therefore
 not kept confidential, however AAD authenticity and integrity are
 guaranteed. AAD is not included in the encrypted payload but must be
 provided in order to decrypt the data. AAD is optional and the eData
 argument may be nil if AAD is not required.

 AEAD encryption/decryption is performed using the OpenSSL open source
 package and is implemented to conform to ISO/IEC standard 19772:2009.
 See https://www.iso.org/standard/46345.html for further information.

 opCode must be an instance of SmallInteger and be one of the values from
 the first column of the above table. A positive value indicates the data
 is to be encrypted and a negative value indicates decryption.

 aKey and aSalt must be instances of ByteArray of the correct size
 per the above table, otherwise an error is raised.

 destObjOrNil must be nil or an instance of a non-invariant byte object.
 If destObjOrNil is nil, the result of the operation will be placed into a
 new instance of ByteArray (encryption) or String (decryption). Otherwise
 the result will be placed into the given byte object starting at offset 1.
 The size of destObjOrNil will be modified to correctly contain all
 encrypted or decrypted data, and may differ from the size of the receiver
 due to the automatic addition or removal of padding by the cipher
 algorithm.

 When encrypting a receiver that has a character size greater than one, data
 is placed into big-endian byte order before encryption.

 When decrypting into a destObjOrNil object that a character size greater
 than one, data is converted to big-endian byte order after decryption.

 During AEAD encryption, a tag is generated which is used during decryption
 to ensure data integrity. The tag data will be stored into the tag
 argument, which must an instance of a variant byte object. During AEAD
 decryption, tag must be a byte object containing the tag bytes returned
 during encryption. For non-AEAD modes, tag must be nil.

 During AEAD encryption, eData must be nil or a byte object with a character
 size of one containing additional data to be used in generating the tag
 value. eData is NOT added to the encrypted payload. During decryption,
 eData must be a byte object with a character size of one containing the
 same bytes provided during encryption or nil if no byte object was
 provided. For non-AEAD modes, eData must be nil.

 Successful encryption or decryption returns encrypted or decrypted data,
 which is stored into destObjOrNil if it was provided or a new byte object
 if it was not. An exception is raised if encryption or decryption fails.
"

<primitive: 953>
self _validateEncryptionOpCode: opCode ;
     _validateEncryptionKey: aKey forOpCode: opCode ;
     _validateEncryptionSalt: aSalt forOpCode: opCode ;
     _validateEncryptionExtraData: eData forOpCode: opCode .
destObjOrNil ifNotNil:[ destObjOrNil _validateIsBytes ; validateIsVariant ] .
self _validateEncryptionTag: tag forOpCode: opCode .
^ self _primitiveFailed: #_primEncryptDecryptWithKey:salt:opCode:into:tag:extraData:
%

category: 'Private-Updating'
method: ByteArray
_reverseDeleteNoShrinkFrom: startIndex to: endIndex anchorHeadSize: aSize

"Deletes bytes from startIndex to endIndex.  startIndex must be > aSize,
 and the bytes from 1 to aSize  are not altered.
 The bytes from aSize + 1 to startIndex - are shifted to the right by
 the distance (endIndex - startIndex + 1), and the bytes from (aSize + 1)
 to (endIndex - (startIndex - aSize) +1) are zeroed.
 The size of the receiver is not changed.
 The size of the receiver must be <= 65536 ."

<primitive: 627>

(startIndex _isInteger)
  ifFalse: [ ^ self _errorNonIntegerIndex: startIndex].
(endIndex _isInteger)
  ifFalse: [ ^ self _errorNonIntegerIndex: endIndex].
(aSize _isInteger)
  ifFalse: [ ^ self _errorNonIntegerIndex: aSize].
self size > 65536 ifTrue:[ self error:'receiver size > 65536' ].
startIndex < 1 ifTrue:[ self _errorIndexOutOfRange:startIndex  ] .
(endIndex < 1 or:[ endIndex > self size]) ifTrue:[ self _errorIndexOutOfRange:endIndex ].
startIndex < aSize ifTrue:[ self error:'startIndex < aSize' ].
(self size - aSize) < endIndex ifTrue:[ aSize _error: #rtErrArgOutOfRange ].
(endIndex - startIndex + 1) < 0 ifTrue:[ self error: 'numToDelete less than 0' ].
((endIndex - startIndex + 1) > ((self size) - startIndex)) ifTrue:[ self error: 'numToDelete > numDeletable' ].
self _primitiveFailed: #_reverseDeleteNoShrinkFrom:to:anchorHeadSize:
     args: { startIndex . endIndex . aSize }
%

category: 'Private'
method: ByteArray
_saltSizeForOpCode: opCode

^ opCode abs >= 4
    ifTrue:[ 12 ]
   ifFalse:[ 16 ]
%

category: 'Private'
method: ByteArray
_validate: anObj isSize: expectedSize

anObj _basicSize == expectedSize
  ifFalse:[ anObj _error: #rtErrBadSize args: { expectedSize . anObj _basicSize } ] .
%

category: 'Private'
method: ByteArray
_validateEncryptionExtraData: eData forOpCode: opCode
opCode abs > 3  "AEAD encrypt/decrypt"
  ifTrue:[ eData ifNotNil:[ eData _validateIsBytes ]]
 ifFalse:[ eData _validateClass: UndefinedObject ]
%

category: 'Private'
method: ByteArray
_validateEncryptionKey: aKey forOpCode: opCode
aKey _validateClass: ByteArray .
self _validate: aKey isSize: (self _keySizeInBytesForOpCode: opCode)
%

category: 'Private'
method: ByteArray
_validateEncryptionOpCode: opCode
opCode _validateClass: SmallInteger .
(((opCode < -10) or:[opCode > 10]) or:[opCode == 0])
  ifTrue:[opCode _error: #rtErrArgOutOfRange args:{ -10 . 10 } ] .
^ true
%

category: 'Private'
method: ByteArray
_validateEncryptionSalt: salt forOpCode: opCode
salt _validateClass: ByteArray .
self _validate: salt isSize: (self _saltSizeForOpCode: opCode)
%

category: 'Private'
method: ByteArray
_validateEncryptionTag: tag forOpCode: opCode
| absCode |
absCode := opCode abs .
absCode > 3 "AEAD encrypt/decrypt"
  ifTrue:[
    tag _validateClass: ByteArray .
    opCode < 3 ifTrue:[ tag validateIsVariant ]			"AEAD Encrypting"
              ifFalse:[ self _validate: tag isSize: 16 ] . 	"AEAD Decrypting"
  ] ifFalse:[ tag _validateClass: UndefinedObject ] "Not AEAD"
%

category: 'Private'
method: ByteArray
_validateInteger: anInt inRangeFrom: lowest to: highest
anInt _validateClass: SmallInteger .
((anInt < lowest) or:[anInt > highest])
  ifTrue:[ anInt _error: #rtErrArgOutOfRange args:{ lowest . highest } ] .
^ true
%

category: 'Private'
method: ByteArray
_validateKey: aKey withDigestKind: opCode
|alg|
alg := aKey algorithm . "#RSA, #DSA, #DH, #EC, etc"
alg == #RSA "SHA1,2,3 allowed"
  ifTrue:[ ^ self _validateInteger: opCode abs inRangeFrom: 2 to: 8 ].
alg == #DSA "SHA1 and SHA2 only"
  ifTrue:[ ^ self _validateInteger: opCode inRangeFrom: 2 to: 4 ].
alg == #EC "No digest required/allowed"
  ifTrue:[ ^ self _validateInteger: opCode inRangeFrom: 0 to: 0 ].

^ CryptoError signal: 'Invalid key kind for signing or verifying'
%

! Class extensions for 'CompileError'

!		Instance methods for 'CompileError'

category: 'Accessing'
method: CompileError
buildMessageText
  | str |
  self errorDetails: (str := String new ).
  ^ self buildMessageText: str .
%

category: 'Accessing'
method: CompileError
errorDetails
  ^ self errorDetails: nil
%

category: 'Accessing'
method: CompileError
errorDetails: resStr
  "Returns an Array of error details.
   Fill in the error message for each element of the error details,
   as a side effect of returning the error details.
   Append the text of each element to a non-nil resStr ."
  gsArgs ifNotNil:[ :arr |
    (arr atOrNil: 1) ifNotNil:[ :errorArrays | | numErrs n |
       numErrs := errorArrays size .
       n := 1 .
       [ n <= numErrs ] whileTrue:[ | anErr msg |
         anErr := errorArrays at: n .
         (msg := anErr atOrNil: 3) ifNil:[ "message not yet filled in" | errNum |
            (errNum := anErr atOrNil: 1 ) _isSmallInteger ifTrue:[
              msg := LegacyErrNumMap atOrNil: errNum .
              msg _isOneByteString ifFalse:[ msg := 'unknown compiler error'].
              anErr at: 3 put: msg .
            ]
          ] ifNotNil:[ "messages already filled in"
            resStr ifNil:[ n := numErrs "early exit" ]
          ].
          resStr ifNotNil:[
            n > 1 ifTrue:[ resStr add:'; ' ].
            resStr add: msg ; add: $  .
            (anErr atOrNil: 4) ifNotNil:[:v | resStr add: $  ; add: v ].
            (anErr atOrNil: 5) ifNotNil:[:v | resStr add: $  ; add: v ].
          ].
          n := n + 1 .
       ].
       ^ errorArrays
    ].
  ].
  ^ { { 1075"STDB_MALFORMED_COMPILER_ERROR" . 1 . 'malformed CompilerError'  } }
%

category: 'Private'
method: CompileError
gsArguments
  | ed |
  ed := self errorDetails "ensure error details are populated" .
  ^ gsArgs ifNil:[ { ed . nil"no source string" } ].
%

! Class extensions for 'DecimalFloat'

!		Class methods for 'DecimalFloat'

removeallmethods DecimalFloat
removeallclassmethods DecimalFloat

category: 'Instance Creation'
classmethod: DecimalFloat
basicNew

^ self fromString:'0'
%

category: 'Instance Creation'
classmethod: DecimalFloat
basicNew: aSize

aSize == 13 ifFalse:[ ArgumentError signal: 'expected 13, arg is ', aSize asString ].
^ self fromString:'0'
%

category: 'Deprecated Exception Handling'
classmethod: DecimalFloat
clearAllExceptions

"Clears all raised exceptions."
| list |
list := self _exceptionList .
1 to: list size do:[:j ||each | each := list at: j .
  self clearException: each
]
%

category: 'Deprecated Exception Handling'
classmethod: DecimalFloat
clearException: aString

"Clears the raised exception type defined by aSymbol
 (#divideByZero, #inexactResult, #invalidOperation, #overflow, #underflow).
 If aSymbol is
 not one of these exception types, an error is generated.  Raised exceptions
 are set by GemStone during floating point operations, and must be explicitly
 cleared with this method."

| state kind |
kind := self _exceptionKind: aString .
state := self status.
state at: self _exceptionList size + kind put: $0.
self status: state.
%

category: 'Deprecated Exception Handling'
classmethod: DecimalFloat
enabledExceptions

"Returns a list of all raised exceptions."

|result list|

result := { } .
list := self _exceptionList .
1 to: list size do:[:j ||each | each := list at: j .
  (self trapEnabled: each) ifTrue: [
    result add: each
  ]
].
^result
%

category: 'Instance Creation'
classmethod: DecimalFloat
fromStream: aStream

"Generates a DecimalFloat from aStream.  Generates an error if an attempt is
 made to read beyond the end of the stream.

 The Stream must contain a legal DecimalFloat, as defined by the following BNF
 construction:

 DecimalFloat = ( Integer '.' Digit {Digit} [ E Integer ] ) |
         ( Integer E Integer )
 Integer = [ ('+' | '-') ] Digit {Digit}
 Point = ( '.' | ',' ) depending on Locale
 E = ( 'F' | 'f')

 Note that the syntax does not allow certain valid DecimalFloats (such as
 DecimalPlusInfinity and MinusInfinity) to be read."

| ch s getDigits getChar getSign getExp |

self _checkReadStream: aStream forClass: CharacterCollection.
ch := aStream next.
[ ch isEquivalent: $ ] whileTrue: [ ch := aStream next ].
aStream skip: -1.
s := aStream contents class new.

getDigits := [ | c cnt |
               cnt := 0 .
               [ (c := aStream peek) ~~ nil and: [ c isDigit ] ]
               whileTrue:
                 [ s add: aStream next . cnt := cnt + 1 ].
               cnt == 0 ifTrue:
                 [ self _errIncorrectFormat: aStream ].
             ].

getChar := [ :c |
             (aStream peek isEquivalent: c) ifTrue: [ s add: aStream next ] ].
getSign := [ (getChar value: $-) ifNil:[ getChar value: $+ ] ].
getExp := [ | c |
            c := aStream peek .
            ((c isEquivalent: $e) or:[ c isEquivalent: $f]) ifTrue:[
               s add: aStream next ] ].
getSign value.
getDigits value.
(getChar value: (Locale decimalPoint at: 1))  ifNotNil:[ getDigits value ].
(getExp value) ifNotNil:[ getSign value.  getDigits value.  ].
^ self fromString: s
%

category: 'Converting'
classmethod: DecimalFloat
fromString: aString

"Returns an instance of DecimalFloat, constructed from aString.  The String
 must contain only Characters representing the object to be created, although
 leading and trailing blanks are permitted.

 The exponent notation, if present may start with any one of $e, $E, $f, or $F."

^ self _oneArgPrim: 2 arg: aString
%

category: 'Converting'
classmethod: DecimalFloat
fromStringLocaleC: aString

"Same as fromString: except that  $.  is always used as the decimal point."

^ self _oneArgPrim: 3 arg: aString
%

category: 'Storing and Loading'
classmethod: DecimalFloat
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object.  Converts the object to
 its active form by loading the information into a new instance of the receiver.
 Returns the new instance."

| inst |

inst := self fromStringLocaleC:  passiveObj upToSeparator .
passiveObj hasRead: inst.
^inst
%

category: 'Instance Creation'
classmethod: DecimalFloat
new

"Returns a PlusSignalingNaN.  You can use this method to
 define a DecimalFloat without specifying its value."

^ self _oneArgPrim: 0 arg: nil
%

category: 'Deprecated Exception Handling'
classmethod: DecimalFloat
operationException: aString

"Returns true if the specified exception has occurred in the current operation.
 Otherwise, returns false.  The argument aString defines the exception type
 (#divideByZero, #inexactResult, #invalidOperation, #overflow,
 #underflow).
 If aSymbol is not one of these, an error is generated."

| status kind |
status := DecimalFloat status.
kind := DecimalFloat _exceptionKind: aString .
^(status at: kind) == $1
%

category: 'Deprecated Exception Handling'
classmethod: DecimalFloat
operationExceptions

"Returns a list of all exceptions raised by the last floating point operation."

|result list|

result := { } .
list := self _exceptionList .
1 to: list size do:[:j ||each | each := list at: j .
  (self operationException: each) ifTrue: [
    result add: each
  ]
].
^result
%

category: 'Arithmetic'
classmethod: DecimalFloat
pi

"Returns the value of pi, accurate to twenty decimal places."

^ 3.14159265358979323846F0
%

category: 'Deprecated Exception Handling'
classmethod: DecimalFloat
raisedException: aString

"Returns true if the specified exception has occurred since the last
 clearException: operation.  Otherwise, returns false.  The argument aSymbol
 defines the exception type
 (#divideByZero, #inexactResult, #invalidOperation, #overflow, #underflow).
 If aSymbol is not one of these, an error is generated. "

| status kind |
status := DecimalFloat status.
kind := DecimalFloat _exceptionKind: aString .
^(status at: self _exceptionList size + kind) == $1
%

category: 'Deprecated Exception Handling'
classmethod: DecimalFloat
raisedExceptions

"Returns a list of all raised exceptions."

|result list |

result := { } .
list := self _exceptionList .
1 to: list size do:[:j ||each | each := list at: j .
  (self raisedException: each) ifTrue: [
    result add: each
  ]
].
^result
%

category: 'Truncation and Rounding'
classmethod: DecimalFloat
roundingMode

"Returns the current rounding mode ('nearestEven', 'towardMinusInfinity',
 'towardPlusInfinity', 'towardZero')."

|state mode|

state := DecimalFloat status.
mode := state at: 16.
mode == $E ifTrue: [ ^ #nearestEven].
mode == $N ifTrue: [ ^ #towardMinusInfinity].
mode == $P ifTrue: [ ^ #towardPlusInfinity].
mode == $Z ifTrue: [ ^ #towardZero].
^ #unknown "should never occur!"
%

category: 'Truncation and Rounding'
classmethod: DecimalFloat
roundingMode: aString

"The argument aString defines the rounding mode ('nearestEven',
 'towardMinusInfinity', 'towardPlusInfinity', 'towardZero').  If aString is not
 one of these, an error is generated."

|status newChar |
(Symbol _existingWithAll: aString) ifNotNil:[ :aSymbol |
  newChar := nil.
  aSymbol == #nearestEven
    ifTrue: [newChar := $E]
    ifFalse: [
      aSymbol == #towardMinusInfinity
	ifTrue: [newChar := $N]
	ifFalse: [
	  aSymbol == #towardPlusInfinity
	    ifTrue: [newChar := $P]
	    ifFalse: [
	      aSymbol == #towardZero
		ifTrue: [newChar := $Z]
	      ]
	  ]
      ].
  ].
newChar ifNil: [^ aString _error: #numErrArgNotRoundingMode].
status := DecimalFloat status.
status at: 16 put: newChar.
DecimalFloat status: status.
%

category: 'Deprecated Exception Handling'
classmethod: DecimalFloat
status

"Returns a six-element Array.  The first element of the Array is a String
 representing the status of the floating point processor, including the
 operation exceptions, raised exceptions, rounding mode, and the enabled traps.
 The next five elements of the Array are the blocks associated with each of the
 enabled traps, in this order: divideByZero, inexactResult, invalidOperation,
 overflow, underflow.

 Any method that modifies the trap handlers should first save the status
 using this method.  After the method has modified the trap handlers, it
 should use status: to restore the status."

<primitive: 134>
^ self _primitiveFailed: #floatStatus
%

category: 'Deprecated Exception Handling'
classmethod: DecimalFloat
status: aString

"Restores the status of the floating point processor to the previously saved
 status represented by aSymbol.  The argument aSymbol is the first element of
 the Array that DecimalFloat | status returns."

^ self _oneArgPrim:1 arg: aString

%

category: 'Deprecated Exception Handling'
classmethod: DecimalFloat
trapEnabled: aString

"Returns true if a trap handler has been defined for the specified exception
 Otherwise, returns false."

|status kind|

status := DecimalFloat status.
kind := DecimalFloat _exceptionKind: aString .
^(status at: self _exceptionList size * 2 + kind) == $1
%

category: 'Deprecated Exception Handling'
classmethod: DecimalFloat
_exceptionFor: aString

"Returns exception installed on given symbol, else nil."

| this desired |
(Symbol _existingWithAll: aString) ifNotNil:[ :sym |
  this := AbstractException _staticExceptions.
  desired := ErrorSymbols at: #numErrFltException.

  [this == nil] whileFalse: [
    (this category == GemStoneError and: [
        this number == desired and: [
        this subtype == sym ]]) ifTrue: [ ^this ].
    this := this next].
].
^nil
%

category: 'Deprecated Exception Handling'
classmethod: DecimalFloat
_exceptionKind: aString

"Arg is a String indicating a type of exception
 (#divideByZero, #inexactResult, #invalidOperation, #overflow,
 #underflow).
 Returns an offset to be used analyzing a DecimalFloat status string."

  | list  |
  (Symbol _existingWithAll: aString) ifNotNil:[ :sym |
    list := self _exceptionList.
    1 to: list size do: [:i | (list at: i) == sym ifTrue:[ ^ i ]].
  ].
  ^ aString _error: #numErrArgNotFltException
%

category: 'Deprecated Exception Handling'
classmethod: DecimalFloat
_exceptionList

"Returns the list of available exceptions, in order."

^ #(#divideByZero #invalidOperation #overflow #underflow #inexactResult ).
%

category: 'Deprecated Exception Handling'
classmethod: DecimalFloat
_installException: aBlock on: aSymbol

"Install given block as a static exception."

AbstractException installStaticException:
      [:theException :cat :num :args |
            (args at: 1) = theException subtype ifFalse: [
              theException resignal: cat number: num args: args].
            aBlock value: cat value: num value: args]
        category: GemStoneError
        number: (ErrorSymbols at: #numErrFltException)
        subtype: aSymbol
%

category: 'Private'
classmethod: DecimalFloat
_oneArgPrim: opcode arg: anArg

"Private."

"opcode function
      0 new
      1 status:
      2 fromString:
      3 fromStringLocaleC:
"

<primitive: 135>
anArg _validateClass: String .
opcode == 0 ifTrue:[ anArg _error: #numErrArgNotFltStatus ] .
self _primitiveFailed: #_oneArgPrim:arg: args: { opcode . anArg }
%

category: 'Deprecated Exception Handling'
classmethod: DecimalFloat
_raiseInvalidOperationException

"This method sets the invalid operation exception of the floating point
 processor."

DecimalPlusSignalingNaN + 3.0F0 .
^self
%

category: 'Deprecated Exception Handling'
classmethod: DecimalFloat
_setException: anException to: aBool

"Turns on (or off) a floating point exception.  Returns the previous state."

|state kind|
kind := self _exceptionKind: anException.
state := self status.
state at: self _exceptionList size * 2 + kind
     put: (aBool ifTrue: [$1] ifFalse: [$0]).
self status: state
%

!		Instance methods for 'DecimalFloat'

category: 'Arithmetic'
method: DecimalFloat
* aNumber

"Returns the result of multiplying the receiver by aNumber."

<primitive: 126>
^ self _retry: #* coercing: aNumber
%

category: 'Arithmetic'
method: DecimalFloat
+ aNumber

"Returns the sum of the receiver and aNumber."

<primitive: 124>
^ self _retry: #+ coercing: aNumber
%

category: 'Arithmetic'
method: DecimalFloat
- aNumber

"Returns the difference between the receiver and aNumber."

<primitive: 125>
^ self _retry: #- coercing: aNumber
%

category: 'Arithmetic'
method: DecimalFloat
/ aNumber

"Returns the result of dividing the receiver by aNumber."

^ self _divide: aNumber round: nil selector: #/
%

category: 'Arithmetic'
method: DecimalFloat
// aNumber

"Divides the receiver by aNumber.  Returns the integer quotient, with
 truncation toward negative infinity.  For example,

 9//4 = 2
 -9//4 = -3
 -0.9//0.4 = -3

 The selector \\ returns the remainder from this division."

   "If a signaling NaN, raise a floating point exception"
(self kind = #signalingNaN)
   ifTrue: [ DecimalFloat _raiseInvalidOperationException ].

   "If a NaN, returns correct sign of self"
((self kind = #signalingNaN) or: [ self kind = #quietNaN ])
   ifTrue: [ ^self _makeQuietNaN ].

^ (self _divide: aNumber round: $N selector: #// ) floor
%

category: 'Comparing'
method: DecimalFloat
< aNumber

"Returns true if the receiver is less than aNumber, and false otherwise."

^ self _compare: aNumber opcode: 2 selector: #<
%

category: 'Comparing'
method: DecimalFloat
<= aNumber

"Returns true if the receiver is less than or equal to a aNumber,
 and false otherwise."

^ self _compare: aNumber opcode: 3 selector: #<=
%

category: 'Comparing'
method: DecimalFloat
= aNumber

"Returns true if the receiver is equal to aNumber, and false otherwise."

^ self _compare: aNumber opcode: 0 selector: #=
%

category: 'Comparing'
method: DecimalFloat
>= aNumber

"Returns true if the receiver is greater than or equal to aNumber,
 and false otherwise."

"Reimplemented from Magnitude to handle NaNs correctly."

^ aNumber <= self
%

category: 'Arithmetic'
method: DecimalFloat
abs

"Returns a Number that is the absolute value of the receiver."

   "If a NaN, raises invalid operation exception and returns quiet NaN"
((self kind = #signalingNaN) or: [ self kind = #quietNaN ])
   ifTrue: [ DecimalFloat _raiseInvalidOperationException.
             ^self _makeQuietNaN ].

(self sign == -1)
   ifTrue: [^self negated].
^self
%

category: 'Converting'
method: DecimalFloat
asDecimalFloat

"Returns the receiver."

^ self
%

category: 'Converting'
method: DecimalFloat
asFloat

"Returns a SmallDouble or Float whose value is represented by the receiver."

 | aString kind |

 kind := self _getKind .
 kind > 2 ifTrue:[
   kind == 4 ifTrue:[ ^ 0.0e0 ] .
   kind == 3 ifTrue:[
     self sign < 0 ifTrue:[ ^ MinusInfinity ]
                  ifFalse:[ ^ PlusInfinity ].
     ].
   kind == 5 ifTrue:[ ^ PlusQuietNaN ].
   ^ PlusSignalingNaN
   ].

 aString := self _asString: $E .
 ^ Float fromString: aString
%

category: 'Converting'
method: DecimalFloat
asFraction

"Returns a Fraction that represents the receiver.  If the receiver is a NaN,
 or Infinity, returns the receiver."

| num numerator denominator |

   "If an infinite or quiet NaN, returns self"
((self kind = #infinity) or: [ self kind = #quietNaN ])
   ifTrue: [ ^self ].

   "If a signaling NaN, raises a floating point exception & returns self"
(self kind = #signalingNaN)
   ifTrue: [ DecimalFloat _raiseInvalidOperationException.
             ^self _makeQuietNaN ].

num := self.
denominator := 1.

[ num fractionPart = 0.0F0 ]
whileFalse:
  [ denominator := denominator * 10.
    num := num * 10.0F0 .
  ].

numerator := num truncated.

^ Fraction numerator: numerator denominator: denominator
%

category: 'Formatting'
method: DecimalFloat
asString

"Returns a String corresponding to the receiver.  Where applicable, returns one
 of the following Strings: 'PlusInfinity', 'MinusInfinity', 'PlusQuietNaN',
 'MinusQuietNaN', 'PlusSignalingNaN', or 'MinusSignalingNaN'.

                                    Note:
 GemStone currently formats DecimalFloats independently.  Specifically, it does
 not adjust the style of representation according to locale (decimal notation
 is not internationalized).  Under some circumstances, string representation of
 DecimalFloats may be inconsistent with those of Floats (which do
 internationalize by adjusting to locale)."

^ self _zeroArgPrim: 2
%

category: 'Formatting'
method: DecimalFloat
asStringLocaleC

"Same as asString, but result always uses  $.  for decimal point."

^ self _zeroArgPrim: 4
%

category: 'Formatting'
method: DecimalFloat
asStringUsingFormat: anArray

"Returns a String corresponding to the receiver, using the format specified by
 anArray.  The Array contains three elements: two Integers and a Boolean.
 Generates an error if any element of the Array is missing or is of the wrong
 class.

 The first element of the Array (an Integer) specifies a minimum number of
 Characters in the result String (that is, the 'width' of the string).  If this
 element is positive, the resulting String is padded with blanks to the right
 of the receiver.  If this element is negative, the blanks are added to the
 left of the receiver.  If the value of this element is not large enough to
 completely represent the DecimalFloat, a longer String will be generated.

 The second element of the Array (a positive Integer less than or equal to 
 1000) specifies the number of digits to display to the right of the decimal 
 point.  If the value of this element exceeds the number of digits required to 
 specify the DecimalFloat, the result is right-padded with 0 to the required 
 width.  If the value of this element is insufficient to completely specify 
 the DecimalFloat, the value of the DecimalFloat is rounded (see #rounded).

 The third element of the Array (a Boolean) indicates whether or not to display
 the magnitude using exponential notation.  (The value true indicates
 exponential notation and false indicates decimal notation.)

 For example, the number 12.3456 displayed with two different format Arrays
 would appear as follows:

 Format          Output
 #(10 5 true)    ' 1.23456E1'
 #(10 2 false)   '12.34'

                                    Note:
 GemStone currently formats DecimalFloats independently.  Specifically, it does
 not adjust the style of representation according to locale (decimal notation
 is not internationalized).  Under some circumstances, string representation of
 DecimalFloats may be inconsistent with those of Floats (which do
 internationalize by adjusting to locale)."

| value tempString count result width decimalWidth scientific
  decimalIndex expIndex intVal fractVal expVal fractString |

anArray _isArray ifFalse:[ anArray _validateClass: Array ].
(anArray size == 3) ifFalse: [ ^ self _error: #rtErrBadFormatSpec args: { anArray } ].
(width := anArray at: 1) _isInteger ifFalse:[ width _validateClass: Integer ].

( #( #infinity #signalingNaN #quietNaN) includesIdentical: self kind) ifTrue:[
   result := self asString 
] ifFalse: [ 
    decimalWidth := anArray at: 2.
    decimalWidth _isInteger ifFalse:[ decimalWidth _validateClass: Integer ].
    scientific := anArray at: 3.
    scientific class == Boolean ifFalse:[ scientific _validateClass: Boolean ].
    value := self abs.
    result := String new.
    self negative ifTrue: [ result add: $- ].
    scientific ifTrue:[
        tempString := value asString.
        decimalIndex := tempString indexOf: $.  startingAt: 1.
        expIndex := tempString indexOf: $F startingAt: decimalIndex.
        intVal := Integer fromString:
                (tempString copyFrom: 1 to: decimalIndex - 1).
        fractVal := DecimalFloat fromString:
                '1.' , (tempString copyFrom: decimalIndex + 1 to: expIndex - 1).
        expVal := Integer fromString:
                (tempString copyFrom: expIndex + 1 to: tempString size).
    ] ifFalse: [
        intVal := value truncated .
        fractVal := 1.0F0 + value fractionPart.
        expVal := 0.
    ].
    count := 0.
    [ (count < decimalWidth) and:[fractVal fractionPart ~= 0.0F0 ] ] whileTrue:[ 
       fractVal := fractVal * 10.0F0 .
        count := count + 1.
    ].
    fractVal := fractVal + 0.5F0 .
    fractString := fractVal truncated asString.
    ((fractString at: 1) == $1 ) ifFalse:[ intVal := intVal + 1 ].
    (scientific and: [ intVal = 10 ]) ifTrue: [ intVal := 1.  expVal := expVal + 1.  ].

    fractString removeFrom: 1 to: 1.
    [ fractString size < decimalWidth ] whileTrue:[ fractString add: $0 ].
    result addAll: intVal asString;
           add: Locale decimalPoint;
           addAll: fractString.
    scientific ifTrue:[ result add: $F; addAll: expVal asString ].
  ].
  ^ result width: width
%

category: 'Accessing'
method: DecimalFloat
at: anIndex put: aValue

"Disallowed.  You may not change the value of a DecimalFloat."

self shouldNotImplement: #at:put:
%

category: 'Truncation and Rounding'
method: DecimalFloat
ceiling

"Returns the integer that is closest to the receiver, on the same side
 of the receiver as positive infinity."

   "If a signaling NaN, raise a floating point exception"
(self kind = #signalingNaN)
   ifTrue: [ DecimalFloat _raiseInvalidOperationException ].

   "If a NaN, returns correct sign of self"
((self kind = #signalingNaN) or: [ self kind = #quietNaN ])
   ifTrue: [ ^self _makeQuietNaN ].

(self <= 0.0F0)
   ifTrue: [^self truncated]
   ifFalse: [^self negated floor negated truncated]
%

category: 'Accessing'
method: DecimalFloat
denominator

"Returns the denominator of a Fraction representing the receiver."

   "If an infinite or quiet NaN, returns self"
((self kind = #infinity) or: [ self kind = #quietNaN ])
   ifTrue: [ ^self ].

   "If a signaling NaN, raises a floating point exception & returns self"
(self kind = #signalingNaN)
   ifTrue: [ DecimalFloat _raiseInvalidOperationException.
             ^self _makeQuietNaN ].

^ (self asFraction) denominator
%

category: 'Testing'
method: DecimalFloat
even

"Returns true if the receiver is an even integer, false otherwise."

 ^ (self \\ 2.0F0 ) = 0.0F0
"Unlike for #odd, rounding does not result in incorrect answers for even,
 so no additional test is necessary."
%

category: 'Arithmetic'
method: DecimalFloat
factorial

"Returns the factorial of the integer part of the receiver.
 Returns 1 if the receiver is less than or equal to 1."

| x result |
result := 1.0F0  .
x := result .
self asInteger timesRepeat:[ result := result * x .  x := x + 1.0F0 ] .
^ result .
%

category: 'Truncation and Rounding'
method: DecimalFloat
floor

"Returns the integer that is closest to the receiver, on the same side
 of the receiver as negative infinity."

|result|

   "If a signaling NaN, raise a floating point exception"
(self kind = #signalingNaN)
   ifTrue: [ DecimalFloat _raiseInvalidOperationException ].

   "If a NaN, returns correct sign of self"
((self kind = #signalingNaN) or: [ self kind = #quietNaN ])
   ifTrue: [ ^self _makeQuietNaN ].

result := self truncated.
(self >= 0)
   ifTrue: [^result].
(self = result)
   ifTrue: [^result]
   ifFalse: [^ (result - 1) truncated]
%

category: 'Truncation and Rounding'
method: DecimalFloat
integerPart

"Returns an integer representing the receiver truncated toward zero."

^ self truncated asDecimalFloat
%

category: 'Testing'
method: DecimalFloat
isZero
  ^ self = 0.0F0
%

category: 'Arithmetic'
method: DecimalFloat
negated

"Returns a Number that is the negation of the receiver."

^ (-0.0F0 - self)
%

category: 'Accessing'
method: DecimalFloat
numerator

"Returns the numerator of a Fraction representing the receiver."

   "If an infinite or quiet NaN, returns self"
((self kind = #infinity) or: [ self kind = #quietNaN ])
   ifTrue: [ ^self ].

   "If a signaling NaN, raises a floating point exception & returns self"
(self kind = #signalingNaN)
   ifTrue: [ DecimalFloat _raiseInvalidOperationException.
             ^self _makeQuietNaN ].

^ (self asFraction) numerator
%

category: 'Testing'
method: DecimalFloat
odd

"Returns true if the receiver is an odd integer, false otherwise."

self = self truncated ifFalse: [^false].
"Compare to self truncated to reject values that are not quite integers,
 such as 9.99999999999999f-1, which due to rounding would answer true below."
 ^ (self \\ 2.0F0 ) = 1.0F0
%

category: 'Arithmetic'
method: DecimalFloat
quo: aNumber

"Divides the receiver by aNumber.  Returns the integer quotient, with
 truncation toward zero.  For example,

 -9 quo: 4 = -2
 -0.9 quo: 0.4 = -2

 The selector rem: returns the remainder from this division."

^ (self _divide: aNumber round: $Z selector: #quo: ) truncated
%

category: 'Arithmetic'
method: DecimalFloat
rem: aNumber

"Returns the integer remainder defined in terms of quo: (division of the
 receiver by aNumber, with truncation toward zero)."

  "x rem: y | x=infinity or y=0 are invalid floating point
   operations and returns quiet NaNs"

(aNumber sign = 0) "0.0/0.0 is also invalid"
   ifTrue: [ ^ (aNumber asDecimalFloat) / (aNumber asDecimalFloat)].
(self kind = #infinity) "infinity/infinity is also invalid"
   ifTrue: [ ^ self / self ].
^ super rem: aNumber
%

category: 'Truncation and Rounding'
method: DecimalFloat
rounded

"Returns the integer nearest in value to the receiver."

   "If a signaling NaN, raise a floating point exception"
(self kind = #signalingNaN)
   ifTrue: [ DecimalFloat _raiseInvalidOperationException ].

   "If a NaN, returns correct sign of self"
((self kind = #signalingNaN) or: [ self kind = #quietNaN ])
   ifTrue: [ ^self _makeQuietNaN ].

self >= 0.0F0 ifTrue: [^(self + 0.5F0) truncated]
            ifFalse:[^(self - 0.5F0) truncated]
%

category: 'Truncation and Rounding'
method: DecimalFloat
roundTo: aNumber

"Returns the multiple of aNumber that is nearest in value to the receiver."

   "If a signaling NaN, raise a floating point exception"
(self kind = #signalingNaN)
   ifTrue: [ DecimalFloat _raiseInvalidOperationException ].

   "If a NaN, returns correct sign of self"
((self kind = #signalingNaN) or: [ self kind = #quietNaN ])
   ifTrue: [ ^self _makeQuietNaN ].

aNumber = 0
  ifTrue: [^0]
  ifFalse: [^(self / aNumber) rounded * aNumber]
%

category: 'Accessing'
method: DecimalFloat
sign

"Returns 1 if the receiver is greater than zero, -1 if the receiver is
 less than zero, and zero if the receiver is zero."

^ self _zeroArgPrim: 1
%

category: 'Accessing'
method: DecimalFloat
size: anInteger

"Disallowed.  You may not change the size of a DecimalFloat."

self shouldNotImplement: #size:
%

category: 'Arithmetic'
method: DecimalFloat
sqrt

"Returns the square root of the receiver."

"Reimplemented from Number"

^ self _zeroArgPrim: 3
%

category: 'Truncation and Rounding'
method: DecimalFloat
truncated

"Returns the integer that is closest to the receiver, on the same side
 of the receiver as zero is located.  In particular, returns the receiver
 if the receiver is an integer."

^ self _zeroArgPrim: 0
%

category: 'Truncation and Rounding'
method: DecimalFloat
truncateTo: aNumber

"Returns the multiple of aNumber that is closest to the receiver, on the
 same side of the receiver as zero is located.  In particular, returns
 the receiver if the receiver is a multiple of aNumber."

   "If a signaling NaN, raise a floating point exception"
(self kind = #signalingNaN)
   ifTrue: [ DecimalFloat _raiseInvalidOperationException ].

   "If a NaN, returns correct sign of self"
((self kind = #signalingNaN) or: [ self kind = #quietNaN ])
   ifTrue: [ ^self _makeQuietNaN ].

aNumber = 0
  ifTrue: [^0]
  ifFalse: [^(self quo: aNumber) * aNumber]
%

category: 'Storing and Loading'
method: DecimalFloat
writeTo: passiveObj

"Converts the receiver to its passive form and writes that information on
 passiveObj."

passiveObj writeClass: self class;
      nextPutAll: self asStringLocaleC;
      space
%

category: 'Decompiling without Sources'
method: DecimalFloat
_asSource

^ self asString
%

category: 'Private'
method: DecimalFloat
_asString: exponentChar

"Same as asString, but prints specified exponent letter"

<primitive: 1018>
exponentChar _validateClass: Character .
exponentChar codePoint <= 127 ifFalse:[ Error signal:'unsupported code point'].
^ self _primitiveFailed: #_asString: args: { exponentChar }
%

category: 'Converting'
method: DecimalFloat
_coerce: aNumber

"Returns an instance of DecimalFloat with the same value as 'aNumber'."

"This method must be defined by all subclasses of Number."

^aNumber asDecimalFloat
%

category: 'Comparing'
method: DecimalFloat
_compare: aNumber opcode: opcode selector: aSymbol
	"Private."

	"opcode 0 means = , 1 means ~=, 2 means < , 3 means <= "

	<primitive: 117>
	| sk |
	(aNumber _isNumber or: [ aNumber isNumber ])
		ifFalse: [ 
			opcode > 1
				ifTrue: [ ^ ArgumentTypeError signal: 'Expected a Number' ].
			^ opcode == 1 ].
	sk := self _getKind.
	sk > 4
		ifTrue: [ ^ opcode == 1 ].	"NaN"
	sk == 3
		ifTrue: [ ^ self _compareInfinityFor: aSymbol with: aNumber ].
	^ (AbstractFraction _coerce: self) perform: aSymbol with: aNumber
%

category: 'Arithmetic'
method: DecimalFloat
_divide: aNumber round: roundingCharacter selector: aSymbol

"Returns the result of dividing the receiver by aNumber,
 using specified rounding mode.

roundingCharacter is one of  nil , $E, $N, $P, $Z
specifying respectively
   (current DecimalFloat roundingMode),
   nearestEven, towardMinusInfinity, towardPlusInfinity, towardZero."

<primitive: 127>
roundingCharacter ifNotNil:[
  roundingCharacter class == Character ifFalse:[
    roundingCharacter _validateClass: Character
]].
^ self _retry: aSymbol coercing: aNumber
%

category: 'Converting'
method: DecimalFloat
_generality

"Returns the integer that represents the ordering of the receiver in the
 generality hierarchy."

"Reimplemented from Number"

^ 100
%

category: 'Accessing'
method: DecimalFloat
_getKind

"Returns an integer, 1...6, for the kind of the receiver."

<primitive: 133>

^ self _primitiveFailed: #_getKind
%

category: 'Indexing Support'
method: DecimalFloat
_isNaN

"Returns whether the receiver is quiet NaN or a signaling NaN.
 This method is only to be used by the indexing subsystem."

^ self _getKind > 4
%

category: 'Converting'
method: DecimalFloat
_makeQuietNaN

"This method returns a quiet NaN with the same sign as the input NaN.  If the
 input is not a NaN, this method returns the receiver."

   "Is the receiver a NaN?"
((self kind = #quietNaN) or: [self kind = #signalingNaN])
   ifFalse: [ ^self ]
   ifTrue: [ ^ PlusQuietNaN ]
%

category: 'Private'
method: DecimalFloat
_zeroArgPrim: opcode

"Private."

"opcode
  0 = truncated
  1 = sign
  2 = asString
  3 = sqrt
  4 = asStringLocaleC
"

<primitive: 128>
^ self _primitiveFailed: #_zeroArgPrim: args: { opcode }
%

category: 'Comparing'
method: DecimalFloat
~= aNumber

"Returns true if the receiver is not equal to aNumber, and false otherwise."

^ self _compare: aNumber opcode: 1 selector: #~=
%

! Class extensions for 'Error'

!		Instance methods for 'Error'

category: 'Formatting'
method: Error
buildMessageText
^ self buildMessageText:(
  [ | str nArgs d |
    d := (LegacyErrNumMap atOrNil: gsNumber) ifNotNil:[:m | m atOrNil: 3].
    d ifNil:[  "no legacy error formatting, get generic details"
      1 to: (nArgs := gsArgs size)  do:[:n | | elem |
        str ifNil:[ str := String new ].
        elem := gsArgs atOrNil: n .
        (elem _isSymbol or:[ elem _isOneByteString]) ifTrue:[ str add: elem ]
           ifFalse:[  elem _isSmallInteger ifTrue:[ str add: elem asString ]
              ifFalse:[ str add: 'a ' ; add: elem class name ]].
        n < nArgs ifTrue:[ str add: ', ' ]
      ].
      gsDetails ifNotNil:[ :x |
        str ifNil:[ str := String new ]
            ifNotNil:[ str add:', ' ].
        str add: x  asString
      ].
    ].
    str
  ] onException: Error do:[:ex |
    ex return: nil
  ]
)
%

! Class extensions for 'FastIdentityKeyValueDictionary'

!		Instance methods for 'FastIdentityKeyValueDictionary'

removeallmethods FastIdentityKeyValueDictionary
removeallclassmethods FastIdentityKeyValueDictionary

category: 'Enumerating'
method: FastIdentityKeyValueDictionary
associationsDo: aBlock

"Evaluates aBlock with each of the receiver's key/value pairs as the argument by
 creating an Association for each key/value pair.  The argument aBlock must
 be a one-argument block.  Returns the receiver."

self keysAndValuesDo: [:aKey :aValue |
  aBlock value: (Association newWithKey: aKey value: aValue)
  ].
%

category: 'Private'
method: FastIdentityKeyValueDictionary
_validatePrivilege
  ^ true
%

! Class extensions for 'FixedPoint'

!		Class methods for 'FixedPoint'

removeallmethods FixedPoint
removeallclassmethods FixedPoint

category: 'Instance Creation'
classmethod: FixedPoint
fromString: aString

"Given aString such as '34.23', returns an instance of FixedPoint with
 appropriate numerator and denominator, and with scale equal to the number
 of digits to the right of the decimal point.
 If a String includes the literal indicator $p, then an sequence of digits
 immediately following $p are used for the scale. Characters other than this
 after the $p are ignored.
 The session's locale state determines the expected decimal point character.
"

^ ( self _fromString: aString decimalPoint: nil ) _reduce immediateInvariant
%

category: 'Instance Creation'
classmethod: FixedPoint
fromStringLocaleC: aString

"Given aString such as '34.23', returns an instance of FixedPoint with
 appropriate numerator and denominator, and with scale equal to the number
 of digits to the right of the decimal point.
 If a String includes the literal indicator $p, then an sequence of digits
 immediately following $p are used for the scale. Characters other than this
 after the $p are ignored.
 The expected decimal point character is $.  "

^ ( self _fromString: aString decimalPoint: $. ) _reduce immediateInvariant
%

category: 'Storing and Loading'
classmethod: FixedPoint
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object.  Converts the object to
 its active form by loading the information into a new instance of the receiver.
 Returns the new instance."

| inst num den scale |
inst := self basicNew .
passiveObj hasRead: inst .
passiveObj readNamedIV.
num := passiveObj ivValue.
passiveObj readNamedIV.
den := passiveObj ivValue.
passiveObj readNamedIV.
scale := passiveObj ivValue.

passiveObj skipNamedInstVars.

(den = 0) ifTrue: [ ^ num _errorDivideByZero ].
inst _numerator: num denominator: den scale: scale .
^inst.
%

category: 'Instance Creation'
classmethod: FixedPoint
numerator: numerator denominator: denominator scale: scale

"Returns an instance of FixedPoint with the given numerator and denominator.

 The arguments numerator and denominator must be Integers.
 The argument  scale  must be a SmallInteger . "

(denominator = 0) ifTrue: [ ^ numerator _errorDivideByZero ].
^ self basicNew _numerator: numerator denominator: denominator scale: scale
%

category: 'Private'
classmethod: FixedPoint
_fromString: aString decimalPoint: dp

"Private.  Given aString such as '34.23', returns a non-reduced FixedPoint.
 Using the specified decimal point character .
 If dp == nil , the session's locale state is used.
 Returns nil if there is a format error in aString"

<primitive: 465>
aString _validateClass: String.
dp ifNotNil:[ dp _validateClass: Character ].
self _errIncorrectFormat: aString.
self _primitiveFailed: #_fromString:decimalPoint: args: { aString . dp } .
%

!		Instance methods for 'FixedPoint'

category: 'Arithmetic'
method: FixedPoint
* aFixedPoint

"Returns the result of multiplying the receiver by aFixedPoint."

aFixedPoint class == FixedPoint ifTrue:[
  ^ FixedPoint numerator: numerator * aFixedPoint numerator
           denominator: denominator * aFixedPoint denominator
           scale: scale
].
^ self _retry: #* coercing: aFixedPoint
%

category: 'Arithmetic'
method: FixedPoint
+ aFixedPoint

"Returns the sum of the receiver and aFixedPoint."

aFixedPoint class == FixedPoint ifTrue:[
   | denom argDenom commonDenominator newNumerator |
   (denom := denominator) = (argDenom := aFixedPoint denominator) ifTrue:[
     ^ FixedPoint numerator: numerator + aFixedPoint numerator
                  denominator: denom
                  scale: scale
   ].
   commonDenominator := denom lcm: argDenom .
   newNumerator := numerator
                     * (commonDenominator quo: denom)
                     + (aFixedPoint numerator * (commonDenominator quo: argDenom )).
   ^ FixedPoint numerator: newNumerator
         denominator: commonDenominator scale: scale
].
^ self _retry: #+ coercing: aFixedPoint
%

category: 'Arithmetic'
method: FixedPoint
- aFixedPoint

"Returns the difference between the receiver and aFixedPoint."

(aFixedPoint class == FixedPoint) ifTrue:[
  ^ self + aFixedPoint negated
].
^ self _retry: #- coercing: aFixedPoint
%

category: 'Arithmetic'
method: FixedPoint
/ aFixedPoint

"Returns the result of dividing the receiver by aFixedPoint ."

aFixedPoint class == FixedPoint ifTrue:[
  ^ self * aFixedPoint  reciprocal
].
^ self _retry: #/ coercing: aFixedPoint
%

category: 'Comparing'
method: FixedPoint
< aNumber
	"Returns true if the receiver is less than aNumber; returns false
 otherwise."

	| sk ak |
	(aNumber _isNumber or: [ aNumber isNumber ])
		ifFalse: [ ^ ArgumentTypeError signal: 'Expected a Number' ].
	sk := self _getKind.
	sk > 4
		ifTrue: [ ^ false ].
	sk == 3
		ifTrue: [ ^ self _compareInfinityFor: #'<' with: aNumber ].
	ak := aNumber _getKind.
	ak > 4
		ifTrue: [ ^ false ].
	ak == 3
		ifTrue: [ ^ aNumber sign == 1 ].	"If we get here, self and arg are both finite."
	aNumber class == FixedPoint
		ifTrue: [ 
			aNumber numerator = 0
				ifTrue: [ ^ numerator < 0 ]
				ifFalse: [ ^ self - aNumber < 0 ] ].
	^ (AbstractFraction _coerce: self) < aNumber
%

category: 'Comparing'
method: FixedPoint
<= aNumber
	"Returns true if the receiver is less than or equal to aNumber;
	returns false otherwise.
	Cannot use '> not' or NaN comparisons would answer true."

	^ self < aNumber or: [ self = aNumber ]
%

category: 'Comparing'
method: FixedPoint
= aNumber
	| sk ak |
	(aNumber _isNumber or: [ aNumber isNumber ])
		ifFalse: [ ^ false ].
	sk := self _getKind.
	sk > 4
		ifTrue: [ ^ false ].
	sk == 3
		ifTrue: [ ^ self _compareInfinityFor: #'=' with: aNumber ].
	ak := aNumber _getKind.
	ak > 4
		ifTrue: [ ^ false ].
	ak == 3
		ifTrue: [ ^ false ].	"If we get here, self and arg are both finite."
	aNumber class == FixedPoint
		ifTrue: [ 
			aNumber numerator = 0
				ifTrue: [ ^ numerator = 0 ]
				ifFalse: [ ^ aNumber numerator = numerator and: [ aNumber denominator = denominator ] ] ].
	^ (AbstractFraction _coerce: self) = aNumber
%

category: 'Comparing'
method: FixedPoint
>= aNumber

^ aNumber <= self
%

category: 'Converting'
method: FixedPoint
asDecimalFloat

"Returns an instance of DecimalFloat that has the value of the receiver."

^ numerator asDecimalFloat / denominator asDecimalFloat
%

category: 'Converting'
method: FixedPoint
asFloat

"Returns an instance of SmallDouble or Float that has the value of the receiver."

^ numerator asFloat / denominator asFloat
%

category: 'Converting'
method: FixedPoint
asFraction

"Returns a Fraction that represents the receiver."

^ Fraction numerator: numerator denominator: denominator.
%

category: 'Formatting'
method: FixedPoint
asString

 "Returns a String of the form '123.56 for a number with scale = 2 ,
  where the decimal point character in the result is per the current Locale."

  ^ self _asString: Locale decimalPoint . "fix 36666"
%

category: 'Formatting'
method: FixedPoint
asStringLocaleC

 "Returns a String of the form '123.56 for a number with scale = 2.
  Does not use Locale , decimal point character is always $.  "

  ^ self _asString: $.
%

category: 'Accessing'
method: FixedPoint
denominator

"Returns the denominator of the receiver."

^denominator
%

category: 'Testing'
method: FixedPoint
even

"Returns true if the receiver is an even integer, false otherwise."

 denominator = 1 ifFalse: [ ^ false ].
 ^ numerator even
%

category: 'Comparing'
method: FixedPoint
hash

^ self asFloat hash
%

category: 'Accessing'
method: FixedPoint
instVarAt: anIndex put: aValue

"Disallowed.  You may not change the value of a FixedPoint."

self shouldNotImplement: #instVarAt:put:
%

category: 'Testing'
method: FixedPoint
isZero

"Returns true if the receiver is zero."

^ numerator = 0 .
%

category: 'Arithmetic'
method: FixedPoint
negated

"Returns a Number that is the negation of the receiver."

^ FixedPoint numerator: numerator negated denominator: denominator
                scale: scale
%

category: 'Accessing'
method: FixedPoint
numerator

"Returns the numerator of the receiver."

^ numerator
%

category: 'Testing'
method: FixedPoint
odd

"Returns true if the receiver is an odd integer, false otherwise."

 denominator = 1 ifFalse: [ ^ false ].
 ^ numerator odd
%

category: 'Copying'
method: FixedPoint
postCopy
  ^ self immediateInvariant
%

category: 'Arithmetic'
method: FixedPoint
reciprocal

(numerator = 0) ifTrue: [ ^ self _errorDivideByZero].
^ FixedPoint numerator: denominator denominator: numerator scale: scale
%

category: 'Updating'
method: FixedPoint
reduced

"Returns a FixedPoint determined by finding the greatest common
 divisor of the numerator and denominator of the receiver."

"Reduce a fraction to its smallest terms."

| gcd numer denom |

(numerator = 0) ifTrue:[
  denominator == 1 ifFalse:[
    denominator := 1 .
  ].
  ^ self
].
gcd := numerator gcd: denominator.
numer := numerator // gcd.
denom := denominator // gcd.
(numer = numerator and:[ denom = denominator]) ifTrue:[ ^ self ].

^ FixedPoint numerator: numer denominator: denom scale: scale.
%

category: 'Accessing'
method: FixedPoint
scale

"Returns the scale of the receiver."

^scale
%

category: 'Accessing'
method: FixedPoint
size: anInteger

"Disallowed.  You may not change the size of a FixedPoint."

self shouldNotImplement: #size:
%

category: 'Truncation and Rounding'
method: FixedPoint
truncated

"Returns the integer that is closest to the receiver, on the same side
 of the receiver as zero is located."

^ numerator quo: denominator
%

category: 'Formatting'
method: FixedPoint
withScale: newScale

"Returns the receiver with the new scale."

scale == newScale ifTrue:[ ^ self ].
^ (self shallowCopy _scale: newScale) immediateInvariant
%

category: 'Storing and Loading'
method: FixedPoint
writeTo: passiveObj

"Converts the receiver to its passive form and writes that information on
 passiveObj."

"Reimplemented from Number since the receiver has a non-literal representation."

^super basicWriteTo: passiveObj
%

category: 'Formatting'
method: FixedPoint
_asString: dpChar

| x num numer denom aString wholePart fraction |

aString := String new.
scale ifNil:[ ^ '(uninitialized FixedPoint)' "fix bug 13190"].
x := 10 raisedToInteger: scale .
numer := numerator .
denom := denominator .
num := (( numer * x) + (denom quo: 2)) // denom .
(numer < 0) ifTrue:[
    aString add: $- .
    num := num negated .
].
wholePart := num // x .
fraction := num \\ x .

aString add: wholePart asString .
aString add: dpChar .
scale timesRepeat: [
  fraction := fraction * 10 .
  aString add: (fraction // x) asString .
  fraction := fraction \\ x .
].
^ aString .
%

category: 'Converting'
method: FixedPoint
_coerce: aNumber

"Reimplemented from Number."

^ aNumber asFixedPoint: scale
%

category: 'Private'
method: FixedPoint
_generality

"Returns an Integer representing the ordering of the receiver in
 the generality hierarchy."

^ 65
%

category: 'Private'
method: FixedPoint
_getKind
	| num denom |
	(num := self numerator) ifNil: [ ^ 5	"nan" ].
	(denom := self denominator) ifNil: [ ^ 5 ].
	denom == 0
		ifTrue: [ 
			num == 0
				ifTrue: [ ^ 5	"NaN" ]
				ifFalse: [ ^ 3	"infinity" ] ].
	num == 0
		ifTrue: [ ^ 4	"zero" ].
	^ 1	"normal"
%

category: 'Private'
method: FixedPoint
_numerator: num denominator: den scale: sc

"Private.  Assigns the receiver's instance variables, reduces it, and makes it
 invariant."

num _isInteger ifTrue:[   "gemstone64, explicit constraint enforcement"
  den _isInteger ifTrue:[
    sc _isSmallInteger ifTrue:[
      numerator := num.
      denominator := den.
      sc < 0 ifTrue:[ scale := 0 ]
      	    ifFalse:[ scale := sc ].
      ^ self _reduce immediateInvariant
    ] ifFalse:[
      ArgumentTypeError new constrainedIv: 'FixedPoint.scale'
	     expectedClass: SmallInteger actualArg: sc ;
	 signal
    ].
  ] ifFalse: [
    ArgumentTypeError new constrainedIv: 'FixedPoint.denominator'
	expectedClass: Integer actualArg: den ;
      signal
  ].
] ifFalse:[
  ArgumentTypeError new constrainedIv: 'FixedPoint.numerator'
	expectedClass: Integer actualArg: num ;
      signal
].
self _uncontinuableError .
%

category: 'Private'
method: FixedPoint
_reduce

"Private.  Reduces the receiver."

| gcd |
"now reduce it"
numerator = 0 ifTrue:[
  denominator := 1.
  ^ self
  ].
denominator < 0 ifTrue:[  "denominator is always positive "
  numerator := numerator negated .
  denominator := denominator negated
  ].
gcd := numerator gcd: denominator.
numerator := numerator // gcd.
denominator := denominator // gcd.
^ self
%

category: 'Private'
method: FixedPoint
_scale: aScale

"Private."

scale := aScale
%

! Class extensions for 'GsFileStat'

!		Class methods for 'GsFileStat'

removeallmethods GsFileStat
removeallclassmethods GsFileStat

category: 'Instance Creation'
classmethod: GsFileStat
new

"Disallowed.
  see instance methods in GsFile for methods returning instances of GsFileStat"

  self shouldNotImplement: #new
%

!		Instance methods for 'GsFileStat'

category: 'Accessing'
method: GsFileStat
atimeUtcSeconds
^  atime
%

category: 'Accessing'
method: GsFileStat
blksize
^ blksize
%

category: 'Accessing'
method: GsFileStat
blocks
^  blocks
%

category: 'Accessing'
method: GsFileStat
ctimeUtcSeconds
^  ctime
%

category: 'Accessing'
method: GsFileStat
dev
^  dev
%

category: 'Accessing'
method: GsFileStat
gid
^  gid
%

category: 'Accessing'
method: GsFileStat
ino
^  ino
%

category: 'Accessing'
method: GsFileStat
isDirectory
 "Returns true if the receiver describes a directory."
  ^ ( mode bitAnd: 8r170000 "posix S_IFMT") == 8r40000 "posix S_IFDIR"
%

category: 'Accessing'
method: GsFileStat
mode
^  mode
%

category: 'Accessing'
method: GsFileStat
mtimeUtcSeconds
^  mtime
%

category: 'Accessing'
method: GsFileStat
nlink
^  nlink
%

category: 'Accessing'
method: GsFileStat
rdev
^  rdev
%

category: 'Accessing'
method: GsFileStat
size
^  size
%

category: 'Accessing'
method: GsFileStat
uid
^  uid
%

! Class extensions for 'GsObjectSecurityPolicy'

!		Class methods for 'GsObjectSecurityPolicy'

category: 'Instance Creation'
classmethod: GsObjectSecurityPolicy
new

"Returns a new GsObjectSecurityPolicy in the Repository aRepository.  If the
 maximum number of ObjectSecurityPolicies has already been created for aRepository,
 this generates an error.
 The new GsObjectSecurityPolicy is owned by the UserProfile of the current session,
 and has the default authorization of W----- (owner can read and write).

 After execution of this method, the current transaction must be committed
 before objects can be created in the GsObjectSecurityPolicy, object assigned to
 the objectSecurityPolicy, or the GsObjectSecurityPolicy used as argument to a
 defaultObjectSecurityPolicy: keyword in
 creation of UserProfiles.

 Requires the ObjectSecurityPolicyCreation privilege
 and WriteAccess to DataCuratorObjectSecurityPolicy.
 "

^ self newInRepository: SystemRepository
%

!		Instance methods for 'GsObjectSecurityPolicy'

category: 'Storing and Loading'
method: GsObjectSecurityPolicy
basicLoadFrom: passiveObj
"Disallowed."
self shouldNotImplement: #basicLoadFrom:
%

category: 'Storing and Loading'
method: GsObjectSecurityPolicy
basicLoadFrom: passiveObj size: aSize
"Disallowed"
self shouldNotImplement: #basicLoadFrom:size:
%

category: 'Storing and Loading'
method: GsObjectSecurityPolicy
basicLoadFromNoRead: passiveObj size: aSize
"Disallowed"
self shouldNotImplement: #basicLoadFromNoRead:size:
%

category: 'Storing and Loading'
method: GsObjectSecurityPolicy
basicLoadFromOld: passiveObj
"Disallowed"
self shouldNotImplement: #basicLoadFromOld:
%

category: 'Instance migration'
method: GsObjectSecurityPolicy
become: anObj
"Disallowed"
self shouldNotImplement: #become:
%

category: 'Instance migration'
method: GsObjectSecurityPolicy
changeClassTo: aCls
"Disallowed"
self shouldNotImplement: #changeClassTo:
%

category: 'Copying'
method: GsObjectSecurityPolicy
copy

"Disallowed."

self shouldNotImplement: #copy
%

category: 'Updating'
method: GsObjectSecurityPolicy
instVarAt: offset put: aValue
"Disallowed"
self shouldNotImplement: #instVarAt:put:
%

category: 'Storing and Loading'
method: GsObjectSecurityPolicy
loadFrom: passiveObj
"Disallowed"
self shouldNotImplement: #loadFrom:
%

category: 'Storing and Loading'
method: GsObjectSecurityPolicy
loadNamedIVsFrom: passiveObj
"Disallowed"
self shouldNotImplement: #loadNamedIVsFrom:
%

category: 'Storing and Loading'
method: GsObjectSecurityPolicy
loadVaryingFrom: passiveObj
"Disallowed"
self shouldNotImplement: #loadVaryingFrom:
%

category: 'Storing and Loading'
method: GsObjectSecurityPolicy
loadVaryingFrom: passiveObj size: aSize
"Disallowed"
self shouldNotImplement: #loadVaryingFrom:size:
%

category: 'Instance migration'
method: GsObjectSecurityPolicy
migrate
"Disallowed"
self shouldNotImplement: #migrate
%

category: 'Instance migration'
method: GsObjectSecurityPolicy
migrateFrom: anObj
"Disallowed"
self shouldNotImplement: #migrateFrom:
%

category: 'Instance migration'
method: GsObjectSecurityPolicy
migrateFrom: anObj instVarMap: aDict
"Disallowed"
self shouldNotImplement: #migrateFrom:instVarMap:
%

category: 'Instance migration'
method: GsObjectSecurityPolicy
migrateIndexable: anObj myClass: aCls otherClass: secondCls
"Disallowed"
self shouldNotImplement: #migrateIndexable:myClass:otherClass:
%

category: 'Updating'
method: GsObjectSecurityPolicy
nilFields
"Disallowed"
self shouldNotImplement: #nilFields
%

category: 'Updating'
method: GsObjectSecurityPolicy
_objectSecurityPolicy: anObjectSecurityPolicy

"Disallowed"

self shouldNotImplement: #_objectSecurityPolicy:
%

category: 'Updating'
method: GsObjectSecurityPolicy
_primitiveAt: offset put: aValue
"Disallowed"
self shouldNotImplement: #_primitiveAt:put:
%

category: 'Instance migration'
method: GsObjectSecurityPolicy
_primitiveBecome: anObject forDict: aBoolean
"Disallowed"
self shouldNotImplement: #_primitiveBecome:forDict:
%

category: 'Conversion'
method: GsObjectSecurityPolicy
_setObjectSecurityPolicyId: anInt

self _unsafeAt: 7 put: anInt
%

! Class extensions for 'GsPackagePolicy'

!		Class methods for 'GsPackagePolicy'

category: 'Accessing'
classmethod: GsPackagePolicy
authorInitials
    "authorInitials stored in SessionTemps _not_ the IV. Don't want 
     authorInitials persisted"

  | ai key tmps |
  ai := (tmps := SessionTemps current) at: (key := self authorInitialsGlobalName) otherwise:nil.
  ai == nil 
    ifTrue:[
      ai := GsSession currentSession userProfile userId asString.
      tmps at: key put: ai.
    ].
  ^ai
%

category: 'Accessing'
classmethod: GsPackagePolicy
authorInitials: aString
    "authorInitials stored in SessionTemps _not_ the IV. Don't want 
     authorInitials persisted"

  SessionTemps current at: self authorInitialsGlobalName put: aString.
%

category: 'Private'
classmethod: GsPackagePolicy
authorInitialsGlobalName

  ^#GsPackagePolicy_AuthorInitials "In SessionTemps"
%

category: 'Accessing'
classmethod: GsPackagePolicy
current
  "note that with the fix for bug 41433, the logic for initializing the sessionMethodPolicy 
   has been moved to bom.gs and userpro.gs ... lazy initialization left to handle upgraded repos."

  | userGlobals sessionMethodPolicy |
  userGlobals := GsSession currentSession objectNamed: #UserGlobals.
  sessionMethodPolicy := userGlobals at: self globalName otherwise: nil.
  sessionMethodPolicy == nil
    ifTrue: [
      "self pause ."
      sessionMethodPolicy := self new.
      userGlobals at: self globalName put: sessionMethodPolicy
    ].
  ^sessionMethodPolicy
%

category: 'Accessing'
classmethod: GsPackagePolicy
currentOrNil

 "Returns nil or the previously installed and enabled GsPackagePolicy."
  | pp |
  pp := (( GsSession currentSession objectNamed: #UserGlobals ) ifNil: [^nil]) at: self globalName otherwise: nil.
  pp ifNotNil:[ pp enabled ifTrue:[ ^ pp ]].
  ^ nil 
%

category: 'Initialize'
classmethod: GsPackagePolicy
deinitialize

  (GsSession currentSession objectNamed: #UserGlobals) removeKey: self globalName 
       ifAbsent: [ nil ].
%

category: 'Accessing'
classmethod: GsPackagePolicy
enabled
  "As an extended fix to bug 41433, it is necessary to avoid lazy initialization
   of GsPackagePolicy class>>current, until after the initial login, thus the
   necessity of in-lining GsPackagePolicy class>>current"

  | userGlobals sessionMethodPolicy |
  userGlobals := GsSession currentSession objectNamed: #'UserGlobals'.
  userGlobals ifNil: [^false].
  sessionMethodPolicy := userGlobals at: self globalName otherwise: nil.
  sessionMethodPolicy == nil
    ifTrue: [ ^ false ].
  ^ sessionMethodPolicy enabled
%

category: 'Accessing'
classmethod: GsPackagePolicy
globalName

  ^#GsPackagePolicy_Current
%

category: 'Initialize'
classmethod: GsPackagePolicy
initialize
  ^ self deinitialize
%

category: 'Method lookup control'
classmethod: GsPackagePolicy
loadSessionMethodDictionary
  "Install a SessionMethodDictionary,should only be called at session login"

  | statusArray policy |
  (statusArray := Globals at: #ConversionStatus otherwise: nil ) 
    ifNotNil: [
      statusArray size > 3
        ifTrue: [ 
          (statusArray at: 4) ifTrue: [
            "in sessionMethod conversion don't install sessionMethods" 
            ^self ]]].
  policy := (GsSession currentSession objectNamed: #UserGlobals) at: self globalName otherwise: nil.
  "Avoid installing anything if the policy is not enabled or does not exist"
  (policy ~~ nil and: [ policy enabled ]) ifTrue: [ policy refreshSessionMethodDictionary ].

    "install a policy for handling TransactionBoundary notification"
    TransactionBoundaryDefaultPolicy isActive
        ifTrue: [ TransactionBoundaryDefaultPolicy installCurrent ].

    "login notification"
    SystemLoginNotification sessionStart.
%

category: 'Instance Creation'
classmethod: GsPackagePolicy
new

  ^self basicNew initialize
%

category: 'Accessing'
classmethod: GsPackagePolicy
restrictedClasses
  " restrictedClasses is an IdentitySet of class names"

  ^ restrictedClasses ifNil:[
      restrictedClasses := IdentitySet withAll: #( BasicSortNode
        BtreeBasicInteriorNode
        BtreeBasicLeafNode
        BtreeComparisonForCompare
        BtreeComparisonForSort
        BtreeComparisonQuerySpec
        BtreeInteriorNode
        BtreeLeafNode
        BtreeNode
        BtreeReadStream
        BucketValueBag
        DependencyList
        DepListBucket
        DepListTable
        GciInterface
        GsCurrentSession
        GsNMethod
        GsMethodDictionary
        GsSession
        GsSessionMethodDictionary
        GsPackagePolicy
        GsPackage
        IdentityIndex
        IndexList
        IndexManager
        MappingInfo
        NscBuilder
        RangeEqualityIndex
        RcBtreeBasicInteriorNode
        RcBtreeBasicLeafNode
        RcBtreeInteriorNode
        RcBtreeLeafNode
        RcCollisionBucket
        RcIndexBucket
        RcIndexBucketWithCache
        RcIndexDictionary
        RcRangeEqualityIndex
        Repository
        ObjectSecurityPolicy
        GsObjectSecurityPolicySet
        SymbolAssociation
        SymbolDictionary
        SymbolKeyValueDictionary
        SymbolList
        SymbolSet
        System
        UserProfile
        UserProfileSet
        UserSecurityData
      ).
      restrictedClasses
    ].
%

category: 'Private'
classmethod: GsPackagePolicy
_originVersion

"For use in repository upgrade code, before upgradeimage completes, returns a 2 digit
 SmallInteger."
(Globals at:#DbfHistory otherwise: nil) ifNotNil:[:hist |
  self _supportedVersionList do:[:ver | | num vStr |
    num := ScaledDecimal numerator: ver denominator: 10 scale: 1 .
    vStr := 'v', num asStringLocaleC, '.' .
    (hist matchPattern: { $* . vStr .  $? . ' kernel classes filein' . $* }) ifTrue:[
      ^ ver 
    ]
  ].
].
^ 0
%

category: 'Private'
classmethod: GsPackagePolicy
_previousVersion
"For use in repository upgrade code, before upgradeimage completes, returns a 2 digit
 SmallInteger."
| prevVer hist |
prevVer := 0 .
(Globals at:#DbfHistory otherwise: nil) ifNotNil:[:h | | ofs |
  hist := h .
  ofs := hist _findLastString: 'upgrade to GemStone' startingAt: hist size
               ignoreCase: true .
  ofs == 0 ifTrue:[ 
     (ImageVersion at: #gsVersion otherwise: nil ) ifNotNil:[:iVer |
        ofs := 1 .
        hist := '  v' , iVer, '  ' .
     ].
  ].
  ofs ~~ 0 ifTrue:[ 
    self _supportedVersionList do:[:ver | | num vStr |
      num := ScaledDecimal numerator: ver denominator: 10 scale: 1 .
      vStr := 'v', num asStringLocaleC, '.' .
      (hist matchPattern: { $* . vStr . $* }) ifTrue:[ ^ ver ].
      vStr := ' ', num asStringLocaleC, '.' .
      (hist matchPattern: { $* . vStr . $* }) ifTrue:[ ^ ver ].
    ].
  ].
].
prevVer == 0 ifTrue:[ prevVer := self _originVersion ].
^ prevVer
%

category: 'Private'
classmethod: GsPackagePolicy
_supportedVersionList
	"answer list of version prefixes for which upgrades are supported - should include current release"

	^ #(37 36 35 34 33 32)
%

category: 'Private'
classmethod: GsPackagePolicy
_upgradedFrom
"Similar to GsPackagePolicy class >> _previousVersion. For use in repository AFTER upgradeimage 
 completes, returns a 2 digit SmallInteger."
| prevVer ofs1 ofs match |
prevVer := 0.
(Globals at: #'DbfHistory' otherwise: nil)
	ifNotNil: [ :hist | 
		match := 'upgrade to GemStone'.
		ofs1 := hist _findLastString: match startingAt: hist size ignoreCase: true.
		ofs1 ~~ 0
			ifTrue: [ 
				ofs := hist
					_findLastString: match
					startingAt: ofs1 - match size
					ignoreCase: true.
				ofs ~~ 0
					ifTrue: [ 
						| pat |
						pat := hist copyFrom: ofs to: ofs1.
						GsPackagePolicy _supportedVersionList
							do: [ :ver | 
								| num vStr |
								num := ScaledDecimal numerator: ver denominator: 10 scale: 1.
								vStr := 'v' , num asStringLocaleC , '.'.
								(pat matchPattern: {$*.  vStr.  $*})
									ifTrue: [ ^ ver ].
								vStr := ' ' , num asStringLocaleC , '.'.
								(pat matchPattern: {$*.  vStr.  $*})
									ifTrue: [ ^ ver ] ] ] ] ].
prevVer == 0 ifTrue:[ prevVer := self _originVersion ].
^ prevVer
%

!		Instance methods for 'GsPackagePolicy'

category: 'Categories'
method: GsPackagePolicy
addCategory: aSymbol for: aBehavior

  ^ self homeSessionMethods addCategory: aSymbol for: aBehavior
%

category: 'Categories'
method: GsPackagePolicy
addSelector: aSelector toCategory: categoryName for: aBehavior
   self homeSessionMethods 
      addSelector: aSelector toCategory: categoryName for: aBehavior .
%

category: 'Accessing'
method: GsPackagePolicy
authorInitials
  ^ self class authorInitials
%

category: 'Accessing'
method: GsPackagePolicy
authorInitials: aString
  self class authorInitials: aString
%

category: 'Private'
method: GsPackagePolicy
buildSessionMethodDictionary
 "returns receiver"
 <primitive: 2001>  "enter protected mode"
 | prot |
 prot := System _protectedMode .
 [ | smSet clsDict oldSet oldList envId reenableAlmostOfMemoryThreshold |
    (AlmostOutOfMemory enabled and: [ TransactionBoundaryDefaultPolicy isActive ])
      ifTrue: [
        "If SessionMethodTransactionBoundaryPolicy, then we are running in GLASS 
          environment and that means that AlmostOutMemory handling needs to be
          suspended for the duration of this method. AlmostOfMemory handling 
          always involves a commit and a commit while session methods are in flux
          can lead to MNU or other errors in code that expects the session methods 
          to be installed correctly"
		(GsCurrentSession currentSession objectNamed: 'SessionMethodTransactionBoundaryPolicy')
          ifNotNil: [ reenableAlmostOfMemoryThreshold := AlmostOutOfMemory threshold ] ].
    envId := 0 .
    (smSet := IdentitySet _basicNew) _setNoStubbing .
    "transientMethodDictForEnv:put: will  keep classes in memory"
    clsDict := IdentityDictionary new .
    (Unicode16 _unicodeCompareEnabled) ifTrue:[
      | mapping |
      mapping := Unicode16 _unicodeCompareMapping .
      1 to: mapping size by: 2 do:[:index | 
        | cls |
        cls := mapping at: index .
        clsDict at: cls put: (Unicode16 _unicodeCompareTmdForClass: cls selectors: (mapping at: index + 1)) .
        smSet add: cls .
      ].
    ].
    self enabled ifTrue:[ | rejected |
      rejected := { } .
      self _packageReverse_Do: [:package |
        package behaviorAndMethodDictDo: [:behavior :methodDict | | tmd |
	  (tmd := clsDict at: behavior otherwise: nil ) ifNil:[
             tmd := GsSessionMethodDictionary new .
             clsDict at: behavior put: tmd .
             smSet add: behavior.
          ].
	  methodDict keysAndValuesDo: [:k :v | 
            v class == GsNMethod ifTrue:[ tmd at: k put: v ]
                    ifFalse:[ rejected add: { package . behavior . k . v } ].
          ].
        ].
      ].
      rejected size ~~ 0 ifTrue:[ 
        "rejected is of the form { { package . behavior . key . value } .  ... }"
        ImproperOperation new object: rejected ; reason: 'buildSessionMethodDictionaryFail';
          signal: 'one or more values in package method dictionaries is not a GsNMethod'.
      ].
      oldSet := self _sessionMethodsSet: smSet .  
      "following 2 loops must not use any methods implemented in session methods"
      oldSet 
        ifNotNil:[ 
          "remove or replace transient method dictionaries for each class in list"
          oldList := oldSet asArray .
          1 to: oldList size do:[:n |  | cls |
            cls := oldList at: n .
            (clsDict includesKey: cls)
              ifTrue: [ 
                "replace the method dict with the new one"
                cls transientMethodDictForEnv: envId put: (clsDict removeKey: cls)  ]
              ifFalse: [ 
                "remove the method dictionary"
                cls transientMethodDictForEnv: envId put: nil ] ] ].
       "add the remaining tranisent method dictionaries"
       clsDict keysAndValuesDo:[ :cls :dict |
         cls transientMethodDictForEnv: envId put: dict ]. 
      GsCurrentSession currentSession enableSessionMethods: true env: envId. "clears lookup caches"
    ] ifFalse:[
      oldSet := self _sessionMethodsSet: nil .
      oldSet ifNotNil:[ 
        oldList := oldSet asArray .
        "following loop must not use any methods implemented in session methods"
        1 to: oldList size do:[:n | | cls tmd |
          cls := oldList at: n .
          tmd := (smSet includes: cls) ifTrue:[ clsDict at: cls ]
                                      ifFalse:[ nil ].
          cls transientMethodDictForEnv: envId put: tmd .
        ].
      ].
      GsCurrentSession currentSession enableSessionMethods: false env: envId . "clears lookup caches"
    ].
    Unicode16 _cacheUsingUnicodeCompares .
    reenableAlmostOfMemoryThreshold
		ifNotNil: [:threshold | AlmostOutOfMemory enableAtThreshold: threshold ] .
 ] ensure:[
   prot _leaveProtectedMode
 ]
%

category: 'Categories'
method: GsPackagePolicy
categoryNamesFor: aBehavior into: anArray

  self packages_Do: [ :package |
    package categoryNamesFor: aBehavior into: anArray.
  ].
%

category: 'Methods'
method: GsPackagePolicy
categoryOfSelector: aSymbol for: aBehavior
  self packages_Do: [ :package |  | aKey |
    aKey := package categoryOfSelector: aSymbol for: aBehavior.
    aKey ifNotNil: [ ^aKey ].
  ].
  ^ nil
%

category: 'Categories'
method: GsPackagePolicy
categorysDo: aBlock for: aBehavior
  "evaluates aBlock for each method category of receiver
   in specified environment. Returns the receiver.

   aBlock should be a two argument block
   expecting the args  categoryNameSymbol ,   selectorsSet.
   aBlock may be invoked more than once for each category name.
   The iteration is done directly over the categories in each
   of the receiver's packages."

  self packages_Do:[ :package | package categorysDo: aBlock for: aBehavior ].
%

category: 'Methods'
method: GsPackagePolicy
compiledMethodAt: aSymbol for: aBehavior
  self packages_Do: [ :package | |meth|
    meth := package compiledMethodAt: aSymbol for: aBehavior.
    meth ifNotNil: [ ^meth ].
  ].
  ^ nil
%

category: 'Methods'
method: GsPackagePolicy
copyCategoryDictFor: aBehavior into: aGsMethodDictionary

  self packages_Do: [ :package |
    package copyCategoryDictFor: aBehavior into: aGsMethodDictionary.
  ].
%

category: 'Methods'
method: GsPackagePolicy
copyMethodDictFor: aBehavior into: aGsMethodDictionary

  self packageReverse_Do: [ :package |
    package copyMethodDictFor: aBehavior into: aGsMethodDictionary.
  ].
%

category: 'Accessing'
method: GsPackagePolicy
disable

  enabled := false.
  self refreshSessionMethodDictionary .

%

category: 'Accessing'
method: GsPackagePolicy
enable

  enabled := true.
  self refreshSessionMethodDictionary .
%

category: 'Accessing'
method: GsPackagePolicy
enabled

  ^ enabled
%

category: 'Accessing'
method: GsPackagePolicy
externalSymbolList

  ^externalSymbolList
%

category: 'Accessing'
method: GsPackagePolicy
externalSymbolList: anArray

  externalSymbolList := anArray
%

category: 'Private'
method: GsPackagePolicy
extractSelectorFor: aBehavior source: sourceString 

  "Returns a selector or signals a CompileError"
  ^ aBehavior extractSelector: sourceString 
%

category: 'Private'
method: GsPackagePolicy
extractSelectorFor: aBehavior 
source: sourceString 
dictionaries: aSymbolList 
category: categorySymbol 

  ^ self extractSelectorFor: aBehavior source: sourceString
%

category: 'Methods'
method: GsPackagePolicy
findMethods: aSymbol for: aBehavior
  "Return array of package description , package, methods triples"
  | arr |
  arr := { } .
  self packages_Do: [ :package | | meth |
    meth := package compiledMethodAt: aSymbol for: aBehavior.
    meth ifNotNil: [ arr add: package printString; add: package; add: meth ].
  ].
  ^ arr
%

category: 'Accessing'
method: GsPackagePolicy
homeSessionMethods

  | package |
  package := self homeSymbolDict  at: GsPackage globalName otherwise: nil.
  package ifNil: [ package := GsPackage installIn: self homeSymbolDict ].
  ^package
%

category: 'Accessing'
method: GsPackagePolicy
homeSymbolDict

  ^homeSymbolDict
%

category: 'Accessing'
method: GsPackagePolicy
homeSymbolDict: aSymDict

  homeSymbolDict := aSymDict
%

category: 'Methods'
method: GsPackagePolicy
includesSelector: aSymbol for: aBehavior

  <primitive: 2001>  "enter protected mode"
  | ans prot |
  prot := System _protectedMode .
  ans := false .
  [
    | mDict |
    mDict := aBehavior transientMethodDictForEnv: 0 .
    mDict ifNotNil:[
      ans := mDict includesKey: aSymbol.
    ].
  ] ensure:[
    prot _leaveProtectedMode
  ].
  ^ans
%

category: 'Initialize-Release'
method: GsPackagePolicy
initialize

      | currentSession |
  enabled := false.
  currentSession := GsSession currentSession.
  homeSymbolDict := currentSession objectNamed: #UserGlobals.
  externalSymbolList := { } .
%

category: 'Compiling'
method: GsPackagePolicy
methodAndCategoryDictionaryFor: aBehavior 
source: sourceString 
dictionaries: aSymbolList 
category: categorySymbol 
  "Returns a 2 element Array, or signals a CompileError"

  self enabled ifTrue: [ | selector |
      selector := self
        extractSelectorFor: aBehavior source: sourceString  .
      (self permitSessionMethodFor: aBehavior selector: selector)
        ifTrue: [ 
           ^self homeSessionMethods methodAndCategoryDictionaryFor: aBehavior 
        ].
    ].
  ^ { nil . nil }
%

category: 'Reporting'
method: GsPackagePolicy
methodsReport
 "Reports without regard to whether enabled is true"
 ^ self _report: true
%

category: 'Categories'
method: GsPackagePolicy
moveSelector: aSelector toCategory: categoryName for: aBehavior

   self packages_Do: [ :package |
      package removeSelector: aSelector fromCategoriesFor: aBehavior ].
   self homeSessionMethods 
      moveSelector: aSelector toCategory: categoryName for: aBehavior.
%

category: 'Enumerating'
method: GsPackagePolicy
packageReverse_Do: aBlock
  "aBlock must be a one argument block which returns true if iteration
   should be terminated early and false if iteration is to continue .
   This is to avoid return-from-home which in Gs64 v3.0 would
   reset the protected mode to zero."
   
  self enabled ifFalse: [ ^self ].
  self _packageReverse_Do: aBlock .
%

category: 'Reporting'
method: GsPackagePolicy
packagesReport
 "Reports without regard to whether enabled is true"
 ^ self _report: false
%

category: 'Enumerating'
method: GsPackagePolicy
packages_Do: aBlock
  "aBlock must be a one argument block which returns true if iteration
   should be terminated early and false if iteration is to continue .
   This is to avoid return-from-home which in Gs64 v3.0 would
   reset the protected mode to zero."
   
  | symList |
  self enabled ifFalse: [ ^self ].
  symList := self symbolList .
  1 to: symList size do:[ :j| | symDict package |
     symDict := symList at: j .
     package := symDict at: GsPackage globalName otherwise: nil.
     package ifNotNil:[  aBlock value: package  ].
  ].
%

category: 'Private'
method: GsPackagePolicy
permitSessionMethodFor: aBehavior selector: selector

  | cl thisName |
  cl := aBehavior whichClassIncludesSelector: selector.
  cl ifNotNil: [ (cl compiledMethodAt: selector) _isProtected ifTrue: [ ^false ].  ].
  thisName := aBehavior thisClass name asSymbol .
  (self class restrictedClasses includes: thisName ) ifTrue: [ ^false ].
  externalSymbolList do: [:symDict | 
		| possible |
		possible := symDict at: thisName otherwise: nil.
		(possible isBehavior and: [aBehavior theNonMetaClass isVersionOf: possible theNonMetaClass]) 
			ifTrue: [ ^true ].
  ].
  ^ (aBehavior canWriteMethodsEnv: 0) not
%

category: 'Compiling'
method: GsPackagePolicy
pragmasForMethod: selector in: aBehavior

  | pragmas |
  self packages_Do: [ :package | | pragmaDict |
    pragmaDict := package methodPragmaDictFor: aBehavior.
    pragmaDict ifNotNil: [ 
      (Symbol _existingWithAll: selector) ifNotNil:[ :sel |
        pragmas := pragmaDict at: sel otherwise: nil .
      ].
      pragmas ifNotNil: [ ^pragmas ].
    ].
  ].
  ^ nil
%

category: 'Methods'
method: GsPackagePolicy
recompileFor: aBehavior
  self packages_Do:[:aPackage |
    aPackage recompileFor: aBehavior .
    false "continue iteration"
  ].
%

category: 'Method lookup control'
method: GsPackagePolicy
refreshSessionMethodDictionary

  self buildSessionMethodDictionary 
%

category: 'Methods'
method: GsPackagePolicy
removeAllMethodsFor: aBehavior
  "self pause ."
  self packages_Do: [ :package |
    package removeAllMethodsFor: aBehavior.
  ].
  "fix up the session method dictionary"
  self sessionMethodRemoveAllMethodsFor: aBehavior.
  ^nil
%

category: 'Methods'
method: GsPackagePolicy
removeAllSubclassCodeFor: aBehavior

"Dereference the code objects of all GsMethods for aBehavior,
 to force recompilation of those methods."
  "self pause."
  self packages_Do: [:package |
    package removeAllSubclassCodeFor: aBehavior.
  ].
  self sessionMethodRemoveAllSubclassCodeFor: aBehavior.
%

category: 'Categories'
method: GsPackagePolicy
removeCategory: aSymbol for: aBehavior
  self packages_Do: [ :package |
    package removeCategory: aSymbol for: aBehavior.
  ].
%

category: 'Methods'
method: GsPackagePolicy
removeMethodAt: aSymbol for: aBehavior
  | meth |
  self packages_Do: [ :package |
    meth := package removeMethodAt: aSymbol for: aBehavior.
    meth ifNotNil:[
      self sessionMethodRemoveMethodAt: aSymbol for: aBehavior.
      ^ meth 
    ].
  ].
  self sessionMethodRemoveMethodAt: aSymbol for: aBehavior.
  ^ nil
%

category: 'Categories'
method: GsPackagePolicy
removeSelector: aSelector fromCategoriesFor: aBehavior
    self packages_Do: [ :package |
      package removeSelector: aSelector fromCategoriesFor: aBehavior.
    ].
%

category: 'Methods'
method: GsPackagePolicy
selectorsFor: aBehavior into: anArray

  <primitive: 2001>  "enter protected mode"
  | prot |
  prot := System _protectedMode .
  [
    | mDict  |
    mDict := aBehavior transientMethodDictForEnv: 0 .
    mDict ifNotNil:[
      anArray addAll: mDict keys.
    ].
  ] ensure:[
    prot _leaveProtectedMode
  ].
  ^self
%

category: 'Categories'
method: GsPackagePolicy
selectorsIn: categoryName for: aBehavior into: anArray

  self packages_Do: [ :package |
    package selectorsIn: categoryName for: aBehavior into: anArray.
  ].
%

category: 'Transaction Boundaries'
method: GsPackagePolicy
sessionMethodChanged

    TransactionBoundaryDefaultPolicy isActive
        ifTrue: [ TransactionBoundaryDefaultPolicy current sessionMethodChanged].
%

category: 'Private'
method: GsPackagePolicy
sessionMethodDictionaryGlobalName

  ^#GsPackagePolicy_SessionMethodDictionary "In SessionTemps"
%

category: 'Private'
method: GsPackagePolicy
sessionMethodRemoveAllMethodsFor: aBehavior

  <primitive: 2001>  "enter protected mode"
  | prot |
  prot := System _protectedMode .
  [
    | oldDict smSet envId |
    envId := 0 .
    oldDict := aBehavior transientMethodDictForEnv: envId .
    oldDict ifNotNil:[
      aBehavior transientMethodDictForEnv: envId put: nil .
      aBehavior _clearLookupCaches: envId .
      self sessionMethodChanged .
      (smSet := self sessionMethodsSet) ifNotNil:[ smSet remove: aBehavior] .
    ].
  ] ensure:[
    prot _leaveProtectedMode
  ]
%

category: 'Private'
method: GsPackagePolicy
sessionMethodRemoveAllSubclassCodeFor: aBehavior

  <primitive: 2001>  "enter protected mode"
  | aDict prot |
  prot := System _protectedMode .
  [
    aDict := aBehavior transientMethodDictForEnv: 0 .
    aDict ifNotNil:[
      "All methods in aBehavior have been marked for recompilation, 
       and we have entries in the sessionMethodDictionary for Behavior, 
       so refresh sessionMethodDictionary."
  
      self refreshSessionMethodDictionary .
    ].
  ] ensure:[
    prot _leaveProtectedMode
  ].
%

category: 'Private'
method: GsPackagePolicy
sessionMethodRemoveMethodAt: aSymbol for: aBehavior

  <primitive: 2001>  "enter protected mode"
  | prot |
  prot := System _protectedMode .
  [
    | mDict oldMeth |
    mDict := aBehavior transientMethodDictForEnv: 0 .
    mDict ifNotNil: [
      oldMeth := mDict removeKey: aSymbol otherwise:  nil .
      oldMeth ifNotNil:[
	aBehavior _refreshLookupCache: aSymbol oldMethod: oldMeth env: 0 .
	self sessionMethodChanged
      ].
    ].
  ] ensure:[
    prot _leaveProtectedMode
  ]
%

category: 'Private'
method: GsPackagePolicy
sessionMethodsSet
  ^ SessionTemps current at: self sessionMethodDictionaryGlobalName otherwise: nil 
%

category: 'Compiling'
method: GsPackagePolicy
setPragmas: pragmaArrayOrNil
forBehavior: aBehavior
forMethod: selector

  | aSym |
  aSym := selector asSymbol.
  self packages_Do: [ :package | 
    (package
      setPragmas: pragmaArrayOrNil
          forBehavior: aBehavior
          forMethod: aSym ) ifNotNil:[ ^ self ].
  ].
  ^ nil

%

category: 'Compiling'
method: GsPackagePolicy
setStamp: aStampOrNil
forBehavior: aBehavior
forMethod: selector
  | aSym |
  aSym := selector asSymbol.
  self packages_Do: [ :package |
    (package
      setStamp: aStampOrNil
            forBehavior: aBehavior
            forMethod: aSym) ifNotNil: [ ^ self ].
  ].
  ^ nil
%

category: 'Compiling'
method: GsPackagePolicy
stampForMethod: selector in: aBehavior

  self packages_Do: [ :package | |stampDict |
    stampDict := package methodStampDictFor: aBehavior.
    stampDict ifNotNil: [  | stamp |
      (Symbol _existingWithAll: selector) ifNotNil:[ :sel |
        stamp := stampDict at: sel otherwise: nil 
      ].
      stamp ifNotNil: [ ^stamp ].
    ].
  ].
  ^ nil
%

category: 'Accessing'
method: GsPackagePolicy
symbolList

  ^ GsSession currentSession symbolList      "fix 49328"
%

category: 'Compiling'
method: GsPackagePolicy
updateMethodLookupCacheFor: aGsMethod in: aBehavior

  self updateMethodLookupCacheForSelector: aGsMethod selector 
				method: aGsMethod in: aBehavior
%

category: 'Compiling'
method: GsPackagePolicy
updateMethodLookupCacheForSelector: selector method: aGsMethod in: aBehavior

  <primitive: 2001>  "enter protected mode"
  | prot |
  prot := System _protectedMode .
  [
    | mDict oldMeth |
    mDict := aBehavior transientMethodDictForEnv: 0 .
    mDict ifNil: [
      mDict := GsSessionMethodDictionary new.
      self sessionMethodsSet add: aBehavior .
      aBehavior transientMethodDictForEnv:0 put: mDict .
    ] ifNotNil:[
       oldMeth := mDict at: selector otherwise: nil .
    ].
    oldMeth ifNil:[
       "need to find oldMeth if possible to be sure breakpoints are cleared"
       oldMeth := aBehavior compiledMethodAt: selector environmentId: 0 otherwise: nil
    ].
    mDict at: selector put: aGsMethod.
    aBehavior _refreshLookupCache: selector oldMethod: oldMeth env: 0.
    self sessionMethodChanged .
  ] ensure:[
    prot _leaveProtectedMode
  ].
%

category: 'Private'
method: GsPackagePolicy
_disableNoRefresh
  "For use only by SystemUser during image upgrade."
  enabled := false.
%

category: 'Private'
method: GsPackagePolicy
_packageReverse_Do: aBlock
  | symList |
  symList := self symbolList . 
  symList size _downTo: 1 do:[ :j| | symDict package |
     symDict := symList at: j .
     package := symDict at: GsPackage globalName otherwise: nil.
     package ifNotNil:[  aBlock value: package ].
  ].
%

category: 'Reporting'
method: GsPackagePolicy
_report: includeMethsBool
 "Reports on the methods without regard to whether enabled is true"
 | str symList |
  str := String new .
  symList := self symbolList .
  1 to: symList size do:[ :j| | symDict package |
     symDict := symList at: j .
     package := symDict at: GsPackage globalName otherwise: nil.
     package ifNotNil:[  
       includeMethsBool ifTrue:[ str add:'===== ' ].
       str add: 'GsPackage oop:' ; add: package asOop asString ;
         add: ' name:' ; add: package name asString ;
         add: ' enabled:' ; add: package enabled asString ; lf .
       includeMethsBool ifTrue:[ str add: package methodsReport ].
     ].
  ].
 ^ str
%

category: 'Private'
method: GsPackagePolicy
_sessionMethodsSet: aValue
    "aValue is an IdentitySet of classes having session methods installed, or nil
     returns previous value"
  <protected>
  | tmps old key |
  aValue ifNotNil:[ aValue _validateClass: IdentitySet ].
  tmps := SessionTemps current .
  key := self sessionMethodDictionaryGlobalName .
  old := tmps at: key otherwise: nil .
  tmps at: key put: aValue .
  ^ old
%

! Class extensions for 'GsSessionMethodDictionary'

!		Instance methods for 'GsSessionMethodDictionary'

removeallmethods GsSessionMethodDictionary
removeallclassmethods GsSessionMethodDictionary

category: 'Updating'
method: GsSessionMethodDictionary
at: anIndex put: aValue

	<protected>
	^super at: anIndex put: aValue
%

category: 'Hashing'
method: GsSessionMethodDictionary
hashFunction: aKey

	<protected>
	^super hashFunction: aKey
%

category: 'Initializing'
method: GsSessionMethodDictionary
initialize: itsSize

	<protected>
	^super initialize: itsSize
%

category: 'Updating'
method: GsSessionMethodDictionary
instVarAt: anIndex put: aValue

	<protected>
	^super instVarAt: anIndex put: aValue
%

category: 'Updating'
method: GsSessionMethodDictionary
keyConstraint: aClass

	<protected>
	^super keyConstraint: aClass
%

category: 'Hashing'
method: GsSessionMethodDictionary
rebuildTable: newSize

	<protected>
	^super rebuildTable: newSize
%

category: 'Updating'
method: GsSessionMethodDictionary
size: anInteger

	<protected>
	^super size: anInteger
%

category: 'Updating'
method: GsSessionMethodDictionary
squeakBasicAt: anIndex put: aValue

  ^ self _basicAt: anIndex put: aValue
%

category: 'Updating'
method: GsSessionMethodDictionary
valueConstraint: aClass

	<protected>
	^super valueConstraint: aClass
%

category: 'Updating'
method: GsSessionMethodDictionary
_at: anIndex put: aValue

	<protected>
	^super _at: anIndex put: aValue
%

category: 'Updating'
method: GsSessionMethodDictionary
_atKey: aKey put: aValue

	<protected>
	^ super _atKey: aKey put: aValue
%

category: 'Updating'
method: GsSessionMethodDictionary
_basicAt: anIndex put: aValue

	<protected>
	^super _basicAt: anIndex put: aValue
%

category: 'Updating'
method: GsSessionMethodDictionary
_basicSize: anInteger

	<protected>
	^super _basicSize: anInteger
%

category: 'Updating'
method: GsSessionMethodDictionary
_primitiveAt: anIndex put: aValue

	<protected>
	^super _primitiveAt: anIndex put: aValue
%

category: 'Instance Migration'
method: GsSessionMethodDictionary
_unsafeAt: anIndex put: aValue

	<protected>
	^super _unsafeAt: anIndex put: aValue
%

! Class extensions for 'GsSocket'

!		Class methods for 'GsSocket'

removeallmethods GsSocket
removeallclassmethods GsSocket

category: 'Queries'
classmethod: GsSocket
addressIsIpv6: aString

"Returns true if aString is of a form acceptable to
 inet_pton(AF_INET6, aString, ...)  and is not an IPv4-mapped IPv6 address
 Returns false otherwise."

^ self _twoArgClassPrim: 27 with: aString with: nil
%

category: 'Instance Creation'
classmethod: GsSocket
basicNew

"disallowed"

self shouldNotImplement: #basicNew
%

category: 'Examples'
classmethod: GsSocket
clientExample

^ self clientExample: true usingPort: 57785
%

category: 'Examples'
classmethod: GsSocket
clientExample: logToGciClient usingPort: portNum

^ self clientExample: logToGciClient usingPort: portNum address: 'localhost'
%

category: 'Examples'
classmethod: GsSocket
clientExample: logToGciClient usingPort: portNum address: serverAddress

"logToGciClient is a Boolean, true if GsFile-based logging is to be done to
  the RPC Gci client, false if to the server process's log file .
  Use false if executing via topaz 'nbrun'  .

 This client will connect to a server created with serverExample, and read
 the string object that the server sends.

 Creates a socket, connect it to port portNum, read a string, close the
 socket, and check the resulting object.  Returns true if successful.

 The server should already be listening for connections when this method is
 invoked."

| socket dataString dataObj chunk firstChunk sleepTime lastStr |

socket := GsSocket new.
(socket connectTo: portNum on: serverAddress) ifFalse:[
  socket close .
  Error signal: 'Unable to connect to port ' , portNum asString , '. Wait 30 seconds or so, then ensure serverExample is started first.'
  ].
dataString := String new .

firstChunk := true .
sleepTime := 0 .
[ socket readWillNotBlockWithin: 5000] whileFalse: [
  GsFile gciLog: 'Waiting for server to write...' onClient: logToGciClient .
  sleepTime := sleepTime + 5 .
  sleepTime > 20 ifTrue:[
    GsFile gciLog: 'Not ready to read after 20sec' onClient: logToGciClient.
    Error signal: 'Not ready to read after 20sec' .
  ].
].
GsFile gciLog: 'Got something from the server to read.' onClient: logToGciClient .
[
  chunk := socket readString: 4000 "max bytes".
  firstChunk ifTrue:[
    firstChunk := false .
    chunk size <= 0 ifTrue:[ Error signal: 'readWillNotBlock disagrees with read'].
    ] .
  chunk ifNil:[ Error signal: 'Error in reading from socket' ].
  dataString addAll: chunk .
  (chunk at: chunk size) == (Character withValue: 0)  "until null terminator"
] untilTrue .
lastStr := socket readString: 100 .
lastStr size == 0 ifFalse:[ Error signal:'did not get EOF as expected'].
socket close.
dataString size: (dataString size - 1) "strip null terminator" .
dataObj := (PassiveObject newWithContents: dataString) activate.
dataObj size == 5000 ifFalse:[ Error signal: 'bad size of dataObj' ].
1 to: 5000 do:[:j |
  (dataObj at:j) == j ifFalse:[ Error signal: 'invalid contents in dataObj' ].
  ] .
^ true.
%

category: 'Drastic Measures'
classmethod: GsSocket
closeAll

"Close all instances of GsSocket that are open , except
 instance created by  GsSocket class >>fromFileHandle:  
 and instances which were sent   setCloseOnGc:false  ."

self _zeroArgClassPrim: 6 .
^ self
%

category: 'Deprecated'
classmethod: GsSocket
finalizeAll

"Returns the number of instances of kinds of GsSocket that are alive
 and not closed."

self deprecated: 'GsSocket class>>finalizeAll deprecated in v3.2; finalization is automatic as of this release.
 Use closeAll to close all instances.'.
^ self _zeroArgClassPrim: 16
%

category: 'Instance Creation'
classmethod: GsSocket
fromFileHandle: aSmallInteger

"Create an instance of the receiver which will use the specified file handle.  
 The fileHandle must be the file descriptor of
 an open socket that was inherited from the parent when the gem
 or  topaz -l  process was forked, or a socket created by non-Gemstone C code.
 in this gem or  topaz -l  process.  The non-Gemstone C code may be C application
 code that calls the GCI or C code called from a user action or through FFI .
 The address family of the socket is determined by the process doing the
 fork when it accepts a connection, or by the non-Gemstone C code.
 The blocking / non-blocking state of the underlying socket will not be changed.
 The socket will be set to close-on-exec by this method.

 aSmallInteger must be > 0 and < 16r7fffffff .
 If aSmallInteger is not a valid file handle for a socket, a SocketError
 is signalled.

 The instance of GsSocket produced by fromFileHandle: will not automatically
 close its file descriptor when the instance is garbage collected by in-memory
 GC .

 If the argument is from an instance of GsSocket created with a connect or accept
 method, then be aware that the file descriptor will be closed when the
 instance of GsSocket from connect or accept is garbage collected by in-memory
 GC .
"
  ^ self _basicNew _twoArgPrim: 28 with: aSmallInteger with: nil
%

category: 'Queries'
classmethod: GsSocket
getHostAddressByName: aHostName

"aHostName must be a String .
 Returns the ip address for aHostName .

 Signals an ArgumentError if aHostName cannot be resolved.

 The resulting ip address is a String in a form acceptable to
 inet_pton(AF_INET6, aString, ...)

 If getaddrinfo() returns more than one address for aHostName,
 the first element of the list from getaddrinfo() is returned.
"

| list |
list := self getHostAddressesByName: aHostName .
list ifNotNil:[ ^ list atOrNil: 1].
^ nil
%

category: 'Queries'
classmethod: GsSocket
getHostAddressesByName: aHostName

"aHostName must be a String.

 Signals an ArgumentError if aHostName cannot be resolved.

 Returns an Array of Strings. Each element of the array
 is a String containing an ip address in a form acceptable to
 inet_pton(AF_INET6, aString, ...) .
 The array contains the results from getaddrinfo()"

| canonName sz list |
list := self _twoArgClassPrim: 12 with: aHostName with: nil .
(sz := list size) < 2 ifTrue:[ ^ nil ].
canonName := list at: 1 . "for debugging"
^ list copyFrom: 2 to: sz
%

category: 'Queries'
classmethod: GsSocket
getHostNameByAddress: address

"Returns the host name for the given ip address.
 Returns nil if the host is undefined or an error occurs.

 The address needs to be a String in a form acceptable to
 either inet_pton(AF_INET6, address, ...)
 or    inet_pton(AF_INET, address, ...) in the host operating
 system."

^ self _twoArgClassPrim: 7 with: address with: nil
%

category: 'Queries'
classmethod: GsSocket
getLocalHostName

"Returns the name of the local host or nil if an error occurs."

^ self _zeroArgClassPrim: 5
%

category: 'Deprecated'
classmethod: GsSocket
getServByName: serviceName
	"Returns the port number for the given service.  Returns nil if the service
	is undefined or an error occurs."

self deprecated: 'GsSocket class >> getServByName: deprecated long before v3.0. Use getServicePortByName: instead.'.
^ self getServicePortByName: serviceName
%

category: 'Queries'
classmethod: GsSocket
getServiceNameByPort: servicePort

"Returns the service name for the given port number.
 Returns nil if the service is undefined or an error occurs."

^ self getServiceNameByPort: servicePort withProtocol: nil "tcp"
%

category: 'Queries'
classmethod: GsSocket
getServiceNameByPort: servicePort withProtocol: protocol

"Returns the service name for the given port number and protocol.
 Protocol may be nil (interpreted as tcp), 'tcp', or 'udp' .
 Returns nil if the service is undefined or an error occurs."

 | p |
 p := self _protocolToInt: protocol .
  ^ self _twoArgClassPrim: 8 with: servicePort with: p
%

category: 'Queries'
classmethod: GsSocket
getServicePortByName: serviceName

"Returns the port number for the given service.
 Returns nil if the service is undefined or an error occurs."

^ self _twoArgClassPrim: 1  with: serviceName with: nil"tcp"
%

category: 'Queries'
classmethod: GsSocket
getServicePortByName: serviceName withProtocol: protocol

"Returns the port number for the given service and protocol.
 Protocol may be nil (interpreted as tcp), 'tcp', or 'udp' .
 Returns nil if the service is undefined or an error occurs."

 | p |
 p := self _protocolToInt: protocol .
 ^ self _twoArgClassPrim: 1  with: serviceName with: p
%

category: 'Low Level Access'
classmethod: GsSocket
getStandardId: index inband: bool
"Returns the socket id for the given index. Index must be >= 0.
 If bool is true then gets the inband socket id. Otherwise gets
 the outband socket id.

 If index is 0 then the socket id to the stone is returned. Starting with Gs64 v2.2,
 the socket id to the stone will be -1 if the session is using shared memory
 communication to the stone.

 If index is 1 then the socket id to the rpc application is returned.

 Otherwise index represents the GCI session id (see GciGetSessionId) and
 the socket id to that session is returned.
 If a socket id does not exist for the given index then -1 is returned."

^ self _twoArgClassPrim: 15 with: index with: bool
%

category: 'Queries'
classmethod: GsSocket
hostIsLocalhost: aString

"aString must be a hostname or ip address. Returns true
if that host is equivalent to localhost."

^ self _twoArgClassPrim: 30 with: aString with: nil
%

category: 'Queries'
classmethod: GsSocket
isAvailable

"Returns whether the supporting socket actions are available in the
 user's session."

^ true
%

category: 'Error Reporting'
classmethod: GsSocket
lastErrorCode

"Returns an integer representing that last operating system error
 for GsSocket class methods. Returns zero if there is no error.
 Does not clear the error information for the receiver."

^ self _zeroArgClassPrim: 8
%

category: 'Error Reporting'
classmethod: GsSocket
lastErrorString

"Returns a String containing information about the last error for
 GsSocket class methods, or nil if there is no error.
 Clears the error information for the receiver."

^ self _zeroArgClassPrim: 7
%

category: 'Error Reporting'
classmethod: GsSocket
lastErrorSymbol

"Returns a Symbol representing that last operating system error
 for GsSocket class methods. Returns nil if there is no error.
 Does not clear the error information for the receiver."

^ self _getErrorSymbol: (self _zeroArgClassPrim: 19)
%

category: 'Instance Creation'
classmethod: GsSocket
new

"Returns a new non-blocking TCP socket or nil if unable to create a new socket.

 On Solaris this creates a socket with family AF_INET6.

 On other platforms this creates a socket with family AF_INET.
 which may be bound or connected to IPv4 addresses or to IPv4-mapped IPv6 addresses."

^ self _basicNew _zeroArgPrim: 1
%

category: 'Instance Creation'
classmethod: GsSocket
newIpv6

"Returns a new non-blocking TCP socket or nil if unable to create a new socket.

 This creates a socket with family AF_INET6
 which may be bound or connected to IPv6 addresses.
 On Linux and solaris the result socket may also
 be bound or connected to IPv4-mapped IPv6 addresses."

^ self _basicNew _zeroArgPrim: 34
%

category: 'Instance Creation'
classmethod: GsSocket
newUdp

"Returns a new non-blocking UDP socket or nil if unable to create a new socket.

 On Solaris this creates a socket with family AF_INET6.

 On other platforms this creates a socket with family AF_INET
 which may be bound or connected to IPv4 addresses or to IPv4-mapped IPv6 addresses."

^ self _basicNew _zeroArgPrim: 26
%

category: 'Instance Creation'
classmethod: GsSocket
newUdpIpv6

"Returns a new non-blocking UDP socket or nil if unable to create a new socket.

 This creates a socket with family AF_INET6
 which may be bound or connected to IPv6 addresses.
 On Linux and solaris the result socket may also
 be bound or connected to IPv4-mapped IPv6 addresses."

^ self _basicNew _zeroArgPrim: 35
%

category: 'RPC GCI Socket - Accessing'
classmethod: GsSocket
receiveBufferSizeForClient

"Returns the current size of the socket receive buffer in bytes used by
 the RPC GCI client of the current session.  This is the size of the socket
 buffer used by the client to receive data from the gem.

 Raises an exception if the buffer size could not be determined or if the
 session is linked (and therefore does not have socket connection to its client).

 Note: on Linux systems only, the value returned by getsockopt() is larger
 by a factor of 2 than the amount usable memory in the buffer due to overhead.
 This method accounts for this overhead and divides by 2 the result returned
 by getsockopt().  See the man page (socket(7)) for details."

 | result |
result := GsFile classUserAction: #GsfGciGetSocketBufSize
                 onClient: true with: 'RCVBUF'.
result _isSmallInteger
  ifFalse:[ SocketError signal: result ] .
^ result
%

category: 'RPC GCI Socket - Updating'
classmethod: GsSocket
receiveBufferSizeForClient: newSize

"Set the size of the socket receive buffer used by the RPC GCI
 client of the current session to a new size.  This is the size of the
 socket buffer used by the client to receive data from its gem.

 newSize must be an even, positive SmallInteger, larger than the current size.

 Note: on Linux systems only, the implementation of setsockopt() doubles the
 requested buffer size to account for overhead.  See the man page (socket(7))
 for details. It is not recommended to manually set socket buffer sizes on
 Linux, since this disables auto-tuning.

 Returns true if the change in size was successful. Raises an exception if
 the size change could not be perfomed or if the session is linked (and
 therefore does not have socket connection to its client)."

| result |
result := GsFile classUserAction: #GsfGciSetSocketBufSize
                 onClient: true with: 'RCVBUF' with: newSize .
result == true
  ifFalse:[ SocketError signal: result ].
^  true
%

category: 'RPC GCI Socket - Accessing'
classmethod: GsSocket
receiveBufferSizeForServer

"Returns the current size of the socket receive buffer in bytes used by
 the current session to receive data from its client.  This is the size
 of the socket buffer used by the gem to receive data from its client.

 Raises an exception if the buffer size could not be determined or if the
 session is linked (and therefore does not have socket connection to its client).

 Note: on Linux systems only, the value returned by getsockopt() is larger
 by a factor of 2 than the amount usable memory in the buffer due to overhead.
 This method accounts for this overhead and divides by 2 the result returned
 by getsockopt().  See the man page (socket(7)) for details."

 | result |
result := GsFile classUserAction: #GsfGciGetSocketBufSize
                 onClient: false with: 'RCVBUF' .
result _isSmallInteger
  ifFalse:[ SocketError signal: result ] .
^ result
%

category: 'RPC GCI Socket - Updating'
classmethod: GsSocket
receiveBufferSizeForServer: newSize

"Set the size of the socket receive buffer used by the current session
 gem to receive data from its client.

 newSize must be an even, positive SmallInteger, larger than the current size.

 Note: on Linux systems only, the implementation of setsockopt() doubles the
 requested buffer size to account for overhead.  See the man page (socket(7))
 for details. It is not recommended to manually set socket buffer sizes on
 Linux, since this disables auto-tuning.

 Returns true if the change in size was successful. Raises an exception if
 the size change could not be perfomed or if the session is linked (and
 therefore does not have socket connection to its client)."

| result |
result := GsFile classUserAction: #GsfGciSetSocketBufSize
                 onClient: false with: 'RCVBUF' with: newSize .
result == true
  ifFalse:[ SocketError signal: result ].
^  true
%

category: 'RPC GCI Socket - Accessing'
classmethod: GsSocket
sendBufferSizeForClient

"Returns the current size in bytes of the socket send buffer used by
 the RPC GCI client of the current session.  This is the size of the socket
 buffer used by the client to send data to its gem.

 Raises an exception if the buffer size could not be determined or if the
 session is linked (and therefore does not have socket connection to its client).

 Note: on Linux systems only, the value returned by getsockopt() is larger
 by a factor of 2 than the amount usable memory in the buffer due to overhead.
 This method accounts for this overhead and divides by 2 the result returned
 by getsockopt().  See the man page (socket(7)) for details."

 | result |
result := GsFile classUserAction: #GsfGciGetSocketBufSize
                 onClient: true with: 'SNDBUF' .
result _isSmallInteger
  ifFalse:[ SocketError signal: result ] .
^ result
%

category: 'RPC GCI Socket - Updating'
classmethod: GsSocket
sendBufferSizeForClient: newSize

"Set the size of the socket send buffer used by the RPC GCI client of
 the current session to a new size.  This is the size of the socket buffer
 used by the client to send data to its gem.

 newSize must be an even, positive SmallInteger, larger than the current size.

 Note: on Linux systems only, the implementation of setsockopt() doubles the
 requested buffer size to account for overhead.  See the man page (socket(7))
 for details. It is not recommended to manually set socket buffer sizes on
 Linux, since this disables auto-tuning.

 Returns true if the change in size was successful. Raises an exception if
 the size change could not be perfomed or if the session is linked (and
 therefore does not have socket connection to its client)."

| result |
result := GsFile classUserAction: #GsfGciSetSocketBufSize
                 onClient: true with: 'SNDBUF' with: newSize .
result == true
  ifFalse:[ SocketError signal: result ].
^  true
%

category: 'RPC GCI Socket - Accessing'
classmethod: GsSocket
sendBufferSizeForServer

"Returns the current size of the socket send buffer in bytes used by
 the current session to send data to its client.  This is the size of the socket
 buffer used by this process to send data to the client.

 Raises an exception if the buffer size could not be determined or if the
 session is linked (and therefore does not have socket connection to its client).

 Note: on Linux systems only, the value returned by getsockopt() is larger
 by a factor of 2 than the amount usable memory in the buffer due to overhead.
 This method accounts for this overhead and divides by 2 the result returned
 by getsockopt().  See the man page (socket(7)) for details."

 | result |
result := GsFile classUserAction: #GsfGciGetSocketBufSize
                 onClient: false with: 'SNDBUF' .
result _isSmallInteger
  ifFalse:[ SocketError signal: result ] .
^ result
%

category: 'RPC GCI Socket - Updating'
classmethod: GsSocket
sendBufferSizeForServer: newSize

"Set the size of the socket send buffer used by the current session
 gem to send data to its client.

 newSize must be an even, positive SmallInteger, larger than the current size.

 Note: on Linux systems only, the implementation of setsockopt() doubles the
 requested buffer size to account for overhead.  See the man page (socket(7))
 for details. It is not recommended to manually set socket buffer sizes on
 Linux, since this disables auto-tuning.

 Returns true if the change in size was successful. Raises an exception if
 the size change could not be perfomed or if the session is linked (and
 therefore does not have socket connection to its client)."

| result |
result := GsFile classUserAction: #GsfGciSetSocketBufSize
                 onClient: false with: 'SNDBUF' with: newSize .
result == true
  ifFalse:[ SocketError signal: result ].
^  true
%

category: 'Examples'
classmethod: GsSocket
serverExample

^ self serverExample: true usingPort: 57785
%

category: 'Examples'
classmethod: GsSocket
serverExample: logToGciClient usingPort: portNum

^ self serverExample: logToGciClient usingPort: portNum address: nil
%

category: 'Examples'
classmethod: GsSocket
serverExample: logToGciClient usingPort: portNum address: listeningAddress

"logToGciClient is a Boolean, true if GsFile-based logging is to be done to
  the RPC Gci client, false if to the server process's log file .
  Use false if executing via topaz 'nbrun'  .

 Creates a socket, binds it to port portNum, and waits for a connection.
 When a connection is established, sends some data to the client, and
 closes the connection.  Returns true if successful.

 You will need two GemStone sessions running from two independent
 interface processes to run both this and the clientExample.  The Gem
 processes for the two sessions must be on the same machine. (For
 example two Topaz sessions.)

 Warning: This method will cause your current session to hang until a
 connection is established."

| server client dataObj dataString numWritten dataStream errStr
  sleepTime |

server := GsSocket new.

(server makeServer: 5 atPort: portNum atAddress: listeningAddress) ifNil: [
  errStr := server lastErrorString.
  server close.
  Error signal: errStr.
  ].

server port == portNum ifFalse:[ Error signal: 'bad port number' ] .

GsFile gciLog: 'Waiting for GsSocket clientExample to connect...'
	onClient: logToGciClient .
[server readWillNotBlockWithin: 5000] whileFalse: [
  GsFile gciLog: 'waiting...'
	onClient: logToGciClient
  ].
GsFile gciLog: 'Client connected, starting accept.' onClient: logToGciClient .

client := server accept .
GsFile gciLog: 'accept finished. client = ', client asString  onClient: logToGciClient .
client ifNil: [
  errStr := server lastErrorString.
  server close.
  GsFile gciLog: 'error from accept, ', errStr onClient: logToGciClient .
  Error signal: errStr.
].
client linger: true length: 10.  "wait after closing until data is processed"

dataObj := Array new:5000 .
1 to: 5000 do:[:j | dataObj at:j put: j ].
dataString := String new .
dataStream := WriteStream on: dataString .
PassiveObject passivate: dataObj toStream: dataStream .
dataString add: (Character withValue: 0). "null terminate so client knows
                                           when to stop reading"
sleepTime := 0 .
[ client writeWillNotBlock ] whileFalse:[
  sleepTime == 0 ifTrue:[
     GsFile gciLog: 'waiting because write to client would block' onClient: logToGciClient.
  ].
  sleepTime > 5000 ifTrue:[
    GsFile gciLog: 'ERROR, client would block' onClient: logToGciClient .
    Error signal: 'socket write will block'
  ].
  System _sleepMs: 20 .
  sleepTime := sleepTime + 20 .
].
GsFile gciLog: 'waited ' , sleepTime asString, 'ms ' onClient: logToGciClient.
GsFile gciLog: 'about to write ', dataString size asString, ' bytes'  onClient: logToGciClient .
numWritten := client write: dataString .
GsFile gciLog: 'wrote ', numWritten asString, ' bytes'  onClient: logToGciClient .
numWritten == dataString size ifFalse:[ Error signal: 'error writing to socket'].
client close.
server close .
				"deleted   'reduce garbage' code"
^ true
%

category: 'Private'
classmethod: GsSocket
_basicNew

"creates an instance registered with VM for finalization of cData"

<primitive: 674>
^ self _primitiveFailed: #_basicNew
%

category: 'Private'
classmethod: GsSocket
_getErrorSymbol: code

"Returns a symbol from SocketErrorSymbols for the given code.
 Returns nil if no error."

"Note: socketprim.c:raiseError does a recur from om to this method."

(code == 0) ifTrue: [^nil].
(code > (SocketErrorSymbols size)) ifTrue: [^SocketErrorSymbols at: 1].

^SocketErrorSymbols at: code
%

category: 'Private'
classmethod: GsSocket
_initSocketErrorSymbols

"Initializes the array of socket error symbols."

SocketErrorSymbols := #(
  "SYSERR_UNKNOWN" #UnknownSystemError
  "SYSERR_HOST_NOT_FOUND" #HostNotFound
  "SYSERR_TRY_AGAIN" #TryAgain
  "SYSERR_NO_RECOVERY" #NoRecovery
  "SYSERR_NO_DATA" #NoData
  "SYSERR_NO_ADDRESS" #NoAddress
  "SYSERR_NETDOWN" #NetworkDown
  "SYSERR_NETUNREACH" #NetworkUnreachable
  "SYSERR_NETRESET" #NetworkReset
  "SYSERR_CONNABORTED" #ConnAborted
  "SYSERR_CONNRESET" #ConnReset
  "SYSERR_NOBUFS" #NoBuffers
  "SYSERR_ISCONN" #AlreadyConnected
  "SYSERR_NOTCONN" #NotConnected
  "SYSERR_SHUTDOWN" #Shutdown
  "SYSERR_TIMEDOUT" #TimedOut
  "SYSERR_CONNREFUSED" #ConnectionRefused
  "SYSERR_NAMETOOLONG" #NameTooLong
  "SYSERR_INTR" #Interrupted
  "SYSERR_INPROGRESS" #InProgress
  "SYSERR_INVAL" #InvalidInput
  "SYSERR_ALREADY" #AlreadyDone
  "SYSERR_NOTSOCK" #NotSocket
  "SYSERR_DESTADDRREQ" #DestinationAddressRequired
  "SYSERR_MSGSIZE" #MsgSize
  "SYSERR_PROTOTYPE" #WrongProtocol
  "SYSERR_NOPROTOOPT" #OptionNotSupported
  "SYSERR_PROTONOSUPPORT" #ProtocolNotSupported
  "SYSERR_SOCKTNOSUPPORT" #TypeNotSupported
  "SYSERR_OPNOTSUPP" #OperationNotSupported
  "SYSERR_NOTSUP" #OperationNotSupported
  "SYSERR_PFNOSUPPORT" #ProtocolFamilyNotSupported
  "SYSERR_AFNOSUPPORT" #FamilyNotSupported
  "SYSERR_ADDRINUSE" #AddressInUse
  "SYSERR_ADDRNOTAVAIL" #AddressNotAvailable
  "SYSERR_WOULDBLOCK" #WouldBlock
  "SYSERR_BADF" #NotSocket
  "SYSERR_AGAIN"  #WouldBlock
  "SYSERR_NOMEM" #NoMemory
  "SYSERR_ACCES" #AccessDenied
  "SYSERR_FAULT" #Fault
  "SYSERR_PIPE" #BrokenPipe
  "SYSERR_HOSTDOWN" #HostDown
  "SYSERR_HOSTUNREACH" #HostUnreachable
  "SYSERR_NONET" #NoNetwork
  "SYSERR_WSANOTINITIALISED" #NotInitialized
  "SYSERR_NOSR" #NoStreams
  "SYSERR_PROTO" #ProtocolError
  "SYSERR_NXIO" #ServerExited
  "SYSERR_WSAEINTR" #BlockingCallCanceled
  "SYSERR_MFILE"    #ProcessOutOfDescriptors
  "SYSERR_NFILE"    #SystemOutOfDescriptors
  "GSSOCKETERR_NOHOSTNAME" #GsSocketNoHostName
).
%

category: 'Private'
classmethod: GsSocket
_protocolToInt: protocol
  | p |
 protocol ifNil:[
   p := 0 "tcp"
 ] ifNotNil:[
   protocol _isOneByteString ifFalse:[ protocol _validateClass: String ].
   p := protocol asLowercase .
   p = 'tcp' ifTrue:[ p := 0 ] ifFalse:[
   p = 'udp' ifTrue:[ p := 1 ]
         ifFalse:[ ArgumentError signal:'protocol neither udp nor tcp' ]].
 ].
 ^ p
%

category: 'Private'
classmethod: GsSocket
_twoArgClassPrim: opcode with: arg1 with: arg2

"See GsSocket>>_twoArgPrim:with:with: for a description of legal opcodes"
<primitive: 322>

^ self _primitiveFailed: #_twoArgClassPrim:with:with:
       args: { opcode . arg1 . arg2 }
%

category: 'Private'
classmethod: GsSocket
_zeroArgClassPrim: opcode

"See GsSocket>>_zeroArgPrim: for a description of the opcode."

<primitive: 323>
^ self _primitiveFailed: #_zeroArgClassPrim: args: { opcode }
%

!		Instance methods for 'GsSocket'

category: 'Comparing'
method: GsSocket
= aSocket

"Returns true if the receiver and aSocket represent the same operating system
 socket.  Returns false otherwise."

| idSelf |
(self == aSocket) ifTrue: [^true].
aSocket ifNil: [^false].
(aSocket isKindOf: self class) ifFalse: [^false].
idSelf := self id.
(idSelf == -1) ifTrue: [^false].
^idSelf == (aSocket id)
%

category: 'Server Operations'
method: GsSocket
accept

"Accept a client request for a connection on the receiver.
 Returns a socket created for a new connection,
 or nil if there was some problem.
 The result is an instance of speciesForAccept , and has non-blocking state
 equal to non-blocking state of the receiver.

 For example, the following code does not return until there is a connection:

 sock := GsSocket new.
 sock makeServer.
 newsock := sock accept.
 msg := newsock read: 512."

| res aSocket cnt |

aSocket := self speciesForAccept _basicNew .
res := true.
cnt := 1 .
[ res == true or:[ res == false ]] whileTrue: [
  "primitive will wait until data available if C socket is blocking."
  res := self _twoArgPrim: 4 with: aSocket with: nil .
  (res == false) ifTrue: [
    "socket is non-blocking and would have blocked, process scheduler will wait"
    res := self _waitForReadReady .
  ].
  cnt := cnt + 1 "for debugging"
].
(res == nil) ifFalse: [
  res := aSocket.
].
^res
%

category: 'Server Operations'
method: GsSocket
acceptTimeoutMs: timeoutMs

"Returns a socket created for a new connection,
 or nil if there was an error or a timeout.
 The result is an instance of speciesForAccept , and has non-blocking state
 equal to non-blocking state of the receiver."

| res aSocket cnt |

aSocket := self speciesForAccept _basicNew .
res := true.
cnt := 1 .
[ res == true or:[ res == false ]] whileTrue: [
  "primitive will wait until data available if C socket is blocking."
  res := self _twoArgPrim: 4 with: aSocket with: nil .
  (res == false) ifTrue: [ | status |
    "socket is non-blocking and would have blocked, process scheduler will wait"
    status := self readWillNotBlockWithin: timeoutMs .
    status == true ifFalse:[ ^ nil ].
  ].
  cnt := cnt + 1 "for debugging"
].
(res == nil) ifFalse: [
  res := aSocket.
].
^res
%

category: 'Accessing'
method: GsSocket
address

"Returns the local ip address of a socket, or nil if an error occurs.
 On some platforms an error is raised if the receiver is not bound.
 On others the address '::' is returned and no error is raised."

^ self _zeroArgPrim: 15
%

category: 'Deprecated'
method: GsSocket
bind

self deprecated: 'GsSocket>>bind deprecated long before v3.0. Use bindTo: instead.'.
^self bindTo: nil
%

category: 'Client Operations'
method: GsSocket
bindTo: portNumber

"Binds the receiver to the specified port number.  Use the makeServer
 methods to do the bind when creating a server socket.
 If portNumber is nil then a random port is selected.
 This method is provided to bind a client socket to a specific port
 before it is connected.  Returns the port number actually
 bound to (should be the same as the argument unless argument is nil),
 or nil if not successful."

^ self _twoArgPrim: 6 with: portNumber with: nil
%

category: 'Client Operations'
method: GsSocket
bindTo: portNumber toAddress: address

"Binds the receiver to the specified port number and address.
 Use the makeServer methods to do the bind when creating a server socket.
 This method is provided to bind a client socket to a specific port
 and/or address before doing a listen or connect on the socket.
 If portNumber is nil then a random port is selected.
 If address is nil then any network interface(IN6ADDR_ANY_INIT) is used.
 Returns the port number actually bound to (should be the same as
 the argument unless argument is nil), or nil if not successful.

 address is a String containing a numeric IP address in one of these forms
   IPv4  dotted-decimal format  d.d.d.d
   IPv6  hex format   x:x:x:x:x:x:x:x ,
   IPv4-mapped IPv6  ::FFFF:d.d.d.d,
   where d is an 8 bit decimal number and x is a 16 bit hexadecimal number.
   An IPv6 format may contain at most one :: which is a contigous
   group of zeros.

 Gs64 v3.1:  address = -1, denoting IPv4 INADDR_BROADCAST, no longer supported.

"

^ self _twoArgPrim: 6 with: portNumber with: address
%

category: 'Accessing'
method: GsSocket
changeable

"Returns true if methods that would change the state of the receiver
 are allowed. Returns false if the state of the receiver can not be
 changed."

^ true
%

category: 'Accessing'
method: GsSocket
changeable: aFlag
  "Has no effect in this release "
  ^ self
%

category: 'Socket Operations'
method: GsSocket
close

"Release any temporary system resources used by the receiver.  This includes
 closing the low level socket.  Returns self if the socket is closes
 successfully or the socket is already closed.  Returns nil if socket cannot
 be closed."

^ self _zeroArgPrim: 2
%

category: 'Client Operations'
method: GsSocket
connectTo: portNumber

"Connect the receiver to the server socket on the local machine
 identified by portNumber.
 portNumber maybe either a SmallInteger, or the String name of a service.
 Returns true if the connection succeeded and false if not.

 If the underlying connect() returns EISCONN(already connected)
 this method will return true.  (Gs64 v3.0 document preexisting behavior)
 "

^ self connectTo: portNumber on: 'localhost'
%

category: 'Client Operations'
method: GsSocket
connectTo: portNumber on: aHost

"Connect the receiver to the server socket identified by portNumber and aHost.
 aHost may be the name of the host or its address,
 or aHost == -1 for <broadcase> , or aHost == nil for IN6ADDR_ANY_INIT .
 portNumber maybe either a SmallInteger, or the String name of a service.
 Returns true if the connection succeeded and false if not."

^ self connectTo: portNumber on: aHost timeoutMs: -1
%

category: 'Client Operations'
method: GsSocket
connectTo: portNumber on: aHost timeoutMs: timeoutMs

"Connect the receiver to the server socket identified by portNumber and aHost.
aHost may be the name of the host or its numeric address,
or aHost == -1 for <broadcase> , or aHost == nil for IN6ADDR_ANY_INIT .
portNumber maybe either a SmallInteger, or the String name of a service.
timeoutMs is a SmallInteger specifying maximum time to wait for the
connection to complete, or -1 to wait indefinitely.
If aHost is the name of a host, connect is attempted on IPv4 first
if getaddrinfo returns any IPv4 addresses for aHost, then attempted
on IPv6.
Returns true if the connection succeeded and false if not."

| addrList canonName |
(portNumber _isSmallInteger and:[ portNumber < 0]) ifTrue:[
  OutOfRange new name:'portNumber' min: 0 actual: portNumber ; signal
].
addrList := self _twoArgPrim: 25 with: aHost with: portNumber . "calls getaddrinfo"
addrList ifNotNil:[
  "addrList is Array of Strings representing list returned by getaddrinfo
  first element is the entry->ai_canonname if first address .
  subequent elements are addresses, each a struct sockaddr
  "
  canonName := addrList atOrNil: 1 . "for debugging"
  2 to: addrList size do:[:j | | status |
    status := self _twoArgPrim: 2 with: (addrList at: j) with: nil. "non-blocking connect"
    status == self ifTrue:[
      self peerAddress ifNotNil:[ ^ true ] ifNil:[ ^ false ].
    ].
    (status == false) ifTrue: [
      "connect call has blocked, wait for it to complete"
      self writeWillNotBlockWithin: timeoutMs .
      self peerAddress ifNotNil:[ ^ true ] .
    ].
  ].
].
^ false
%

category: 'Copying'
method: GsSocket
copy

"Returns an instance with no associated C state.
 There are no instVars to copy"

^ self class _basicNew
%

category: 'Comparing'
method: GsSocket
hash

"Returns a SmallInteger related to the value of the receiver.  If two instances
 of GsSocket are equal (as compared by the = method), then they must have the
 same hash value."

^ self id hash
%

category: 'Accessing'
method: GsSocket
hasReadWaiter: anObject
  | wtrs |
  (wtrs := readWaiters) ifNotNil:[
    wtrs _isArray ifTrue:[
      ^ wtrs includesIdentical: anObject
    ] ifFalse:[
      ^ wtrs == anObject
    ].
  ].
  ^ false
%

category: 'Accessing'
method: GsSocket
hasWaiters

  ^ readWaiters ~~ nil or:[ writeWaiters ~~ nil ]
%

category: 'Accessing'
method: GsSocket
hasWriteWaiter: anObject
  | wtrs |
  (wtrs := writeWaiters) ifNotNil:[
    wtrs _isArray ifTrue:[
      ^ wtrs includesIdentical: anObject
    ] ifFalse:[
      ^ wtrs == anObject
    ].
  ].
  ^ false
%

category: 'Accessing'
method: GsSocket
id

"Returns the value of the low level socket.  If no low level socket exists,
 returns -1."

^ fileDescriptor ifNil:[ -1 ] ifNotNil:[ fileDescriptor ]
%

category: 'Accessing'
method: GsSocket
interrupting
  "Returns true if polling of this socket is done asynchronously while
   the VM is executing bytecodes.  
   Polling has to be initiated via ProcessorScheduler>>_waitForSocket:  "

  ^ interrupting == true
%

category: 'Accessing'
method: GsSocket
interrupting: aBoolean
  "if aBoolean==true , causes polling of this socket to be done asynchronously while
   the VM is executing bytecodes.  
   Polling has to be initiated via ProcessorScheduler>>_waitForSocket:  

   The default value of the interrupting instVar is nil which is equivalent to false. "

  aBoolean _validateClass: Boolean .
  interrupting := aBoolean
%

category: 'Testing'
method: GsSocket
isActive
"Returns true if the receiver's socket is in a usable state.
 Returns false if the receiver's socket is not usable.
 Sockets become unusable when they are closed."

((self id) == -1) ifTrue: [^false].
^ true
%

category: 'Accessing'
method: GsSocket
isBlocking

^ self isNonBlocking == false
%

category: 'Testing'
method: GsSocket
isConnected
"Returns true if the socket is connected to a peer.
 Returns false if the socket never was connected or has lost its connection
 to the peer."

^ self _zeroArgPrim: 13.
%

category: 'Accessing'
method: GsSocket
isNonBlocking

^ self _zeroArgPrim: 36
%

category: 'Socket Operations'
method: GsSocket
keepAlive: bool

"Sets the receiver to periodically broadcast messages to clients.  If
 a client does not respond to a broadcast, its connection is severed.
 If bool is false, keepAlive is turned off.
 Returns the receiver or nil if an error occurred."

^ self option: 'KEEPALIVE' put: bool
%

category: 'Error Reporting'
method: GsSocket
lastErrorCode

"Returns an integer representing the last operating system error on the
 receiver. Returns zero if there is no error.
 Does not clear the error information for the receiver."

 ^ self _zeroArgPrim: 11
%

category: 'Error Reporting'
method: GsSocket
lastErrorString

"Returns the string of the last error on the receiver, or nil if no error has
 occurred.  Clears the error information for the receiver."

^ self _zeroArgPrim: 10
%

category: 'Error Reporting'
method: GsSocket
lastErrorSymbol

"Returns a Symbol representing the last operating system error on the
 receiver. Returns nil if there is no error.
 Does not clear the error information for the receiver."

^ self class _getErrorSymbol: (self _zeroArgPrim: 20)
%

category: 'Socket Operations'
method: GsSocket
linger: bool length: timeOut

"Sets up the receiver so that if unsent data is waiting to be transmitted
 at the time the receiver is closed, the current process will block until
 either the data is transmitted, or the given timeOut expires.  timeOut is
 in units of seconds.

 Returns the receiver or nil if an error occurred."

^ self _twoArgPrim: 3 with: bool with: timeOut
%

category: 'Updating'
method: GsSocket
makeBlocking
self isBlocking ifFalse:[ self option: 'NONBLOCKING' put: false ].
^ self
%

category: 'Server Operations'
method: GsSocket
makeListener: queueLength

"Turns the receiver into a listening socket.
 The queueLength argument specifies the size of the listen backlog queue for
 incoming connections.
 Returns the receiver or nil if an error occurred."

^ self _twoArgPrim: 11 with: queueLength with: nil
%

category: 'Updating'
method: GsSocket
makeNonBlocking
self isNonBlocking ifFalse:[ self option: 'NONBLOCKING' put: true ].
^ self
%

category: 'Server Operations'
method: GsSocket
makeServer

"Turns the receiver into a server socket. Binds the receiver to a port and
 makes it a listening socket.  Returns the receiver or nil if an error
 occurred."

^ self makeServer: 5 atPort: nil atAddress: nil
%

category: 'Server Operations'
method: GsSocket
makeServer: queueLength

"Turns the receiver into a server socket.  The queueLength argument specifies
 the size of the listen backlog queue for incoming connections.  Binds the
 receiver to a random port.  Returns the receiver or nil if an error occurred."

^ self makeServer: queueLength atPort: nil atAddress: nil
%

category: 'Server Operations'
method: GsSocket
makeServer: queueLength atPort: portNum

"Turns the receiver into a server socket.  The queueLength argument specifies
 the size of the listen backlog queue for incoming connections.  Binds the
 receiver to portNum.  If portNum is nil then a random port is selected.
 Returns the receiver, or nil if an error occurred."

^ self makeServer: queueLength atPort: portNum atAddress: nil
%

category: 'Server Operations'
method: GsSocket
makeServer: queueLength atPort: portNum atAddress: address

"Turns the receiver into a server socket.  The queueLength argument specifies
 the size of the listen backlog queue for incoming connections.  Binds the
 receiver to portNum and address.
 If portNum is nil then a random port is selected.
 If address is nil then any appropriate network interface is used.
 Returns the receiver, or nil if an error occurred."

((self bindTo: portNum toAddress: address) == nil) ifTrue: [^nil].
^ self makeListener: queueLength
%

category: 'Server Operations'
method: GsSocket
makeServerAtPort: portNum

"Turns the receiver into a server socket.  Binds the receiver to portNum and
 makes it a listening socket.  Returns the receiver or nil if an error
 occurred."

^ self makeServer: 5 atPort: portNum atAddress: nil
%

category: 'Writing'
method: GsSocket
nbwrite: amount from: byteObj startingAt: index

"If receiver is a non-blocking socket,
 write at most amount bytes from byteObj to the receiver without blocking.

 If receiver is a blocking socket,
 write at most amount bytes from byteObj to the receiver blocking until
 the socket accepts data, or until the gem process receives SIGTERM.

 The first byte written will be from the position indicated by index.
 The maximum number of bytes to write is specified by amount.
 It is an error if amount bytes are not available.
 Returns the number of bytes written, or nil if an error occurs.
 Returns 0 if non-blocking socket would have blocked."

 | res |
 [
   res := self _write: byteObj startingAt: index ofSize: amount.
   (res == false) ifTrue: [
     "would have blocked"
     ^ 0
   ].
   res == true  "if res==true, socket got EINTR and we retry"
 ] whileTrue .
 ^res
%

category: 'Accessing'
method: GsSocket
option: optionName

"Returns the current value of the specified option.
 Returns nil if an error occurred.
 optionName can be any of the following:
   'BROADCAST': value is Boolean; permission to transmit broadcast messages.
   'DEBUG': value is Boolean; records debugging information.
   'DONTROUTE': value is Boolean; routing bypass for outgoing messages.
   'ERROR': value is SmallInt; error code of the socket.
   'KEEPALIVE': value is Boolean; detect broken connections.
   'NODELAY': value is Boolean; disables nagle algorithm for send coalescing.
   'NONBLOCKING': value is Boolean , non-blocking state of socket.
   'OOBINLINE': value is Boolean; reception of out-of-band data inband.
   'REUSEADDR': value is Boolean; allows local address reuse.
   'RCVBUF': value is SmallInt; buffer size for input.
   'SNDBUF': value is SmallInt; buffer size for output.
   'TYPE': value is SmallInt; type of the socket (tcp or udp).
   'USELOOPBACK': value is Boolean; bypass network card if possible.
   'REUSEPORT': value is Boolean, multiple binds to same address, see SO_REUSEPORT in OS man pages .

  If an option name is not supported on a particular platform the
  error string will be 'The requested socket option does not exist'."

^ self _twoArgPrim: 5 with: optionName with: nil
%

category: 'Socket Operations'
method: GsSocket
option: optionName put: value

"Sets the value of the specified option.
 Returns the receiver or nil if an error occurred.
 optionName can be any of the following:
   'BROADCAST': value is Boolean; permission to transmit broadcast messages.
   'CLOSEONEXEC': value is Boolean; close when system exec() is done.
   'DEBUG': value is Boolean; records debugging information.
   'DONTROUTE': value is Boolean; routing bypass for outgoing messages.
   'KEEPALIVE': value is Boolean; detect broken connections.
   'NODELAY': value is Boolean; disables nagle algorithm for send coalescing.
   'NONBLOCKING': value is Boolean , set state of non-blocking for socket.
   'OOBINLINE': value is Boolean; reception of out-of-band data inband.
   'REUSEADDR': value is Boolean; allows local address reuse.
   'RCVBUF': value is SmallInt; buffer size for input.
   'SNDBUF': value is SmallInt; buffer size for output.
   'USELOOPBACK': value is Boolean; bypass network card if possible.
   'REUSEPORT': value is Boolean, multiple binds to same address, see SO_REUSEPORT in OS man pages .

  If an option name is not supported on a particular platform the
  error string will be 'The requested socket option does not exist'."

^ self _twoArgPrim: 5 with: optionName with: value
%

category: 'Accessing'
method: GsSocket
peerAddress

"For a bound socket, returns the address of the machine on which the
 process at the other end of the connection is running.

 If the socket is not bound, or an error occurs, returns nil."

^ self _zeroArgPrim: 9
%

category: 'Accessing'
method: GsSocket
peerName

"For a bound socket, returns the hostname of the machine on which the
 process at the other end of the connection is running.

 If the socket is not bound, or an error occurs, returns nil."

| addr |

addr := self peerAddress.
(addr == nil) ifTrue: [^nil].
^ self class getHostNameByAddress: addr
%

category: 'Accessing'
method: GsSocket
peerPort

"For a bound socket, returns the port being used by the
 the other end of the connection.

 If the socket is not bound, or an error occurs, returns nil."

^ self _zeroArgPrim: 14
%

category: 'Accessing'
method: GsSocket
port

"Returns the local port number of a socket, or nil if an error occurs.
 On some platforms an error is raised if the receiver is not bound.
 On others the port 0 is returned and no error is raised."

^ self _zeroArgPrim: 3
%

category: 'Queries'
method: GsSocket
raiseExceptionOnError

"Returns true if a socket error on the receiver will raise an exception.
 Returns false if not. The initial value is false."

^ self _twoArgPrim: 10 with: nil with: nil
%

category: 'Configuration'
method: GsSocket
raiseExceptionOnError: bool

"Sets the value of raiseExceptionOnError to the Boolean bool for the receiver.
 Returns the receiver."

^ self _twoArgPrim: 10 with: bool with: nil
%

category: 'Reading'
method: GsSocket
read: maxBytes

"This method is equivalent to readString: .
 maxBytes must be a SmallInteger > 0 . "

 | bytes amount |
 bytes := String new.
 amount := self read: maxBytes into: bytes startingAt: 1.
 amount ifNil: [ ^nil ].
 ^ bytes
%

category: 'Reading'
method: GsSocket
read: maxBytes into: byteObj

"Reads up to the given number of bytes into the given byte object (for
 example, a String) starting at index 1.
 Returns the number of bytes read, or nil if an error occurs,
 or 0 if EOF on the receiver.
 byteObj is grown as needed but is not shrunk.
 maxBytes must be a SmallInteger > 0 .

 If no data is available for reading,
 the current GsProcess is suspended until data arrives.
 The readWillNotBlock or readWillNotBlockWithin: methods may be used to
 determine whether or not data is ready for reading before calling this method."

^ self read: maxBytes into: byteObj startingAt: 1
%

category: 'Reading'
method: GsSocket
read: maxBytes into: byteObj startingAt: index

"Reads up to the given number of bytes into the given byte object (for
 example, a String).  The first byte read will go into the position
 indicated by index.
 Returns the number of bytes read, or nil if an error,
 or 0 if EOF on the receiver.

 maxBytes must be a SmallInteger > 0 and <= 500000000 .

 An error will be raised if index is greater than the size of byteObj.
 Note that index can be equal to the size of byteObj plus 1 in which
 case any bytes read will be appended to byteObj.

 If no data is available for reading
 the current GsProcess is suspended until data arrives.
 The readWillNotBlock or readWillNotBlockWithin: methods may be used to
 determine whether or not data is ready for reading before calling this method."

| status waitCnt waitLimit |
[
  "primitive will wait until data available if C socket is blocking."
  status := self _readInto: byteObj startingAt: index maxBytes: maxBytes.
  "status==true from _readInto means got EINTR and must retry"
  (status == false) ifTrue: [
    "socket is non-blocking and would have blocked, process scheduler will wait"
    waitCnt ifNotNil:[
      waitCnt < (waitLimit ifNil:[ waitLimit := self _maxReadWaits])  ifTrue:[
        waitCnt := waitCnt + 1 .
        Delay waitForMilliseconds: 1.
      ] ifFalse:[
        "System _printSocketTrace ."
        SocketError signal:'EWOULDBLOCK from socket read after poll said read-ready'.
      ].
    ] ifNil:[
      waitCnt := 0 .
    ].
    status := self _waitForReadReady . "status true means ready to read"
  ] .
  status == true
] whileTrue .
^ status
%

category: 'Reading'
method: GsSocket
read: maxBytes into: byteObj startingAt: index maxWait: timeMs

"Reads up to the given number of bytes into the given byte object (for
 example, a String).  The first byte read will go into the position
 indicated by index.
 Returns the number of bytes read, nil if an error,
 0 if EOF on the receiver,
 false if receiver is not ready to read within timeMs milliseconds.

 maxBytes must be a SmallInteger > 0 and <= 500000000 .

 An error will be raised if index is greater than the size of byteObj.
 Note that index can be equal to the size of byteObj plus 1 in which
 case any bytes read will be appended to byteObj.

 If no data is available for reading
 the current GsProcess is suspended for up to timeMs until data arrives."

| status waitCnt waitLimit |
[
  "primitive will wait until data available if C socket is blocking."
  status := self _readInto: byteObj startingAt: index maxBytes: maxBytes.
  "status==true from _readInto means got EINTR and must retry"
  (status == false) ifTrue: [
    "socket is non-blocking and would have blocked, process scheduler will wait"
    waitCnt ifNotNil:[
      waitCnt < (waitLimit ifNil:[ waitLimit := self _maxReadWaits])  ifTrue:[
        waitCnt := waitCnt + 1 .
        Delay waitForMilliseconds: 1.
      ] ifFalse:[
        "System _printSocketTrace ."
        SocketError signal:'EWOULDBLOCK from socket read after poll said read-ready'.
      ].
    ] ifNil:[
      waitCnt := 0 .
    ].
    status := self readWillNotBlockWithin: timeMs . "status true means ready to read"
  ] .
  status == true
] whileTrue .
^ status
%

category: 'Reading'
method: GsSocket
read: amount into: byteObj startingAt: index untilFalse: aBlock

"Reads at most amount bytes from the receiver into byteObj.
 The first byte read is put in byteObj at position specified by index.
 Returns when amount bytes have been read, an error occurs, or
 the one argument Block   aBlock   evaluates to false.

 An error will be raised if index is greater than the size of byteObj.
 Note that index can be equal to the size of byteObj plus 1 in which
 case any bytes read will be appended to byteObj.

 Repeatedly does a read followed by an evaluation of aBlock if the
 read returned without amount bytes having been read.

 If the receiver is not ready for reading
 the current GsProcess is suspended until data arrives.
 The readWillNotBlock or readWillNotBlockWithin: methods may be used to
 determine whether or not data is ready for reading before calling this method.
 They can also be used in aBlock to determine when it should return true
 so that another read will be done without blocking.

 If aBlock is evaluated its argument is the total number of bytes read
 so far. Returns the number of bytes read, or nil if an error occurs."

| total result offset numToRead |

total := 0.
offset := index.
numToRead := amount.

[result := self read: numToRead into: byteObj startingAt: offset.
 (result == nil) ifTrue: [^nil]. "Quit due to error"
 total := total + result.
 (total == amount) ifTrue: [^total]. "All done"
 numToRead := numToRead - result.
 offset := offset + result.
 aBlock value: total
] untilFalse.

^total
%

category: 'Reading'
method: GsSocket
read: amount into: byteObj untilFalse: aBlock

"Reads at most amount bytes from the receiver into the given byte object
 starting at index 1.
 Returns when amount bytes have been read, an error occurs, or
 the one argument Block  aBlock   evaluates to false.

 See read:into:startingAt:untilFalse: for details.

 If aBlock is evaluated its argument is the total number of bytes read
 so far. Returns the number of bytes read, or nil if an error occurs."

^ self read: amount into: byteObj startingAt: 1 untilFalse: aBlock.
%

category: 'Reading'
method: GsSocket
read: amount untilFalse: aBlock

"Same as readString:untilFalse:."

^ self readString: amount untilFalse: aBlock.
%

category: 'Deprecated'
method: GsSocket
readReady

self deprecated: 'GsSocket>>readReady deprecated long before v3.0. Use readWillNotBlock or readWillNotBlockWithin: instead.'.
^ self _zeroArgPrim: 17
%

category: 'Reading'
method: GsSocket
readString: maxBytes

"Reads up to the given number of bytes, returning them in a String whose size is
 between 0 and maxBytes inclusive.  If an error occurs, nil is returned instead.
 If EOF occurs on the receiver before any bytes are read,
 a String of size zero is returned.

 maxBytes must be a SmallInteger > 0 .
 If maxBytes is greater than the size of the operating system's buffer for
 the socket, the size of the result string may be a function of this
 buffer size, even if more data is available from the sender.  Repeated
 invocation of this method may be necessary to obtain all of the data.

 If no data is available for reading
 the current GsProcess is suspended until data arrives.
 The readWillNotBlock or readWillNotBlockWithin: methods may be used to
 determine whether or not data is ready for reading before calling this method."

  | bytes amount |
  bytes := String new.
  amount := self read: maxBytes into: bytes startingAt: 1.
  amount ifNil: [ ^nil ].
  ^ bytes
%

category: 'Reading'
method: GsSocket
readString: maxBytes untilFalse: aBlock

"Reads bytes from the receiver into a String which it creates and returns.
 Will keep reading until maxBytes bytes are read or
 the one argument Block  aBlock  returns false.
 Each time aBlock is evaluated it is given the number of bytes read so far.
 aBlock is only evaluated after a partial read.
 maxBytes must be a SmallInteger > 0 .
 Returns the String or nil if an error occurs."

| bytes |

bytes := String new.
((self read: maxBytes into: bytes untilFalse: aBlock) == nil) ifTrue: [
  ^nil
].

^bytes
%

category: 'Accessing'
method: GsSocket
readWaiters
  "Return an Array containing the objects waiting on the receiver to be ready
   for reading."

^ self _getWaiters: readWaiters
%

category: 'Testing'
method: GsSocket
readWillNotBlock

"Returns true if the socket is currently ready to receive input without
 blocking.  Returns false if it is not currently ready.  Returns nil if an error
 occurs.

 The receiver must already be connected for this method to work properly.  If it
 is not connected, then the value that this method returns is indeterminate.
 Use the peerName method to determine if the receiver is connected.

 Call this method to prevent subsequent read or accept operations from hanging.
 If it returns true for a connected socket, then the input operation will not
 hang.  However, a return value of true is no guarantee that the operation
 itself will succeed."

^ self _zeroArgPrim: 17
%

category: 'Testing'
method: GsSocket
readWillNotBlockWithin: msToWait

"Returns true if the socket is ready to receive input without blocking within
 msToWait milliseconds from the time that this method is called.
 Returns false if it is not ready after msToWait milliseconds.
 Returns nil if an error occurs.

 If msToWait ~~ 0 and the socket is not ready to read, the current
 GsProcess is suspended.  Semantics of suspend are the same as
 for Delay >> wait ; other GsProcess may execute while this GsProcess
 is suspended.

 If msToWait is 0, then this method reports the current readiness of the
 receiver.  If msToWait is -1, then this method never returns false,
 but suspends the current GsProcess until the receiver is ready to receive
 input without blocking, and then returns true.

 The receiver must already be connected for this method to work properly.  If it
 is not connected, then the value that this method returns is indeterminate.
 Use the peerName method to determine if the receiver is connected.

 Call this method to prevent subsequent read or accept operations from hanging.
 If it returns true for a connected socket, then the input operation will not
 hang.  However, a return value of true is no guarantee that the operation
 itself will succeed."

 | sched proc status |
 "Avoid sending readWillNotBlock to self in case self is a GsSecureSocket in accept."
 (status := self _zeroArgPrim: 17 "inline readWillNotBlock") ifNil:[ ^ nil ].  "fix 49678,50504"
 status ifTrue:[ ^ true ]
       ifFalse:[ msToWait == 0  ifTrue:[ ^ false ]].
 self _enableRead .
 (sched := self _scheduler) _enterCritical .
 proc := sched activeProcess .
 readWaiters ifNil:[
   readWaiters := proc
 ] ifNotNil:[
   self _addReadWaiter: proc
 ].
 msToWait == -1 ifTrue:[
   sched _waitForSocket: self .  "exits critical"
   ^ true
 ] ifFalse:[
   sched _waitForSocket: self timeout: msToWait forWrite: nil .  "exits critical"
   ^ self _isReadableOrException
 ]
%

category: 'UDP Support'
method: GsSocket
recvfrom: maxBytes

 "Returns an Array of the form [ aString , senderInfoArray ] .
  May be used to receive data from a socket was created by
    GsSocket newUdp
  and which has been bound using  bindTo:  or bindTo:toAddress: .
  aString in the result array is the data received from the socket.
  The senderInfoArray represents the struct sockaddr filled in by
  recvfrom() , and is of the form
    { af_string . portNum . nil . ipAddrString } .
  af_string will be one of 'AF_INET' , 'AF_INET6', 'AF_UNIX' .
  Signals an Error if a socket error occurs "

 maxBytes _isSmallInteger ifFalse:[ ArgumentTypeError signal:'argument must be a Fixnum'].
 maxBytes > 0 ifFalse:[ ArgumentError signal:'argument must be > 0'].
 [ true ] whileTrue:[ | result |
   [ result := self _recvfrom: maxBytes .
     result == true
   ] whileTrue . "loop to handle EINTR"
   result _isOneByteString ifTrue:[  SocketError signal:'recvfrom failed, ', result ].
   result == false ifTrue:[  "non-blocking socket would have blocked."
     self _waitForReadReady .
   ] ifFalse:[
     ^ result  "an Array"
   ]
 ].
%

category: 'UDP Support'
method: GsSocket
sendUdp: aString flags: flagsInt toHost: hostName port: aPort

" Sends aString using sendto().  Intended for use with receiver being
  a socket obtained from
     GsSocket newUdp
  aPort must be a SmallInteger or a String specifying a port number or
  service name.
  Uses getaddrinfo() with hints.ai_socktype == SOCK_DGRAM to translate
  hostName and portArray to a struct sockaddr for use by sendto().
  Signals a SocketError if an error occurs."

  | idx strSize portStr isReady |
  aPort _isSmallInteger ifTrue:[
    portStr := aPort asString .
  ] ifFalse:[
    aPort _isOneByteString ifFalse:[ ArgumentTypeError signal:'port must be a String or SmallInteger'].
    portStr := aPort .
  ].
  hostName _isOneByteString ifFalse:[ ArgumentTypeError signal:'hostname must be a String'].
  flagsInt == 0 ifFalse:[ ArgumentError signal:'non-zero flags arg not supported yet'].
  aString _isOneByteString ifFalse:[ ArgumentTypeError signal:'first arg(data to send) must be a String'].
  strSize := aString size .
  idx := 1 .
  [ true ] whileTrue:[ | result |
    [ result := self _sendUdp: aString startingAt: idx to: hostName port: portStr .
      result == true
    ] whileTrue . "loop to handle EINTR"
    result _isSmallInteger ifTrue:[
      idx := idx + result .
      idx > strSize ifTrue:[ ^ strSize "done" ]
          ifFalse:[ result == 0 ifTrue:[ SocketError signal:'sendto infinite loop']].
      isReady := nil .
    ] ifFalse:[
      isReady ifNotNil:[
        System _printSocketTrace .
        SocketError signal:'EAGAIN from socket write after poll said write-ready'
      ].
      result == false ifTrue:[  "non-blocking socket would have blocked."
        self _waitForWriteReady .
        isReady := true .
      ] ifFalse:[
        SocketError signal:'sendto failed, ', result asString
      ].
   ]
 ]
%

category: 'Low Level Access'
method: GsSocket
setCloseOnGc: aBoolean

  "If aBoolean is true the receiver's underlying socket will be
   closed when the in-memory state of the receiver is garbage collected.
   aBoolean must be a Boolean .  A newly created instance has 
   setCloseOnGc:true  done by the instance initialization primitive. "

^ self _twoArgPrim: 29 with: aBoolean with: nil
%

category: 'Socket Operations'
method: GsSocket
shutdownReading

"Partially shutdown the socket such that further reads are disallowed.
 The socket is not closed.

 Returns true if successful, false if the method failed, and nil if
 the receiver is not a valid GsSocket."

^ self _zeroArgPrim: 23
%

category: 'Socket Operations'
method: GsSocket
shutdownReadingAndWriting

"Shutdown the socket such that further reads and writes are disallowed.
 The socket is not closed.

 Returns true if successful, false if the method failed, and nil if
 the receiver is not a valid GsSocket."

^ self _zeroArgPrim: 25
%

category: 'Socket Operations'
method: GsSocket
shutdownWriting

"Partially shutdown the socket such that further writes are disallowed.
 The socket is not closed.

 Returns true if successful, false if the method failed, and nil if
 the receiver is not a valid GsSocket."

^ self _zeroArgPrim: 24
%

category: 'Server Operations'
method: GsSocket
speciesForAccept
"Returns a class, an instance of which should be used as the result
 of the accept method."

^self class
%

category: 'Writing'
method: GsSocket
write: byteObj

"Write out the given byte object.  Returns the number of bytes written,
 or nil if an error occurs.

 If the receiver is not ready for writing
 the current GsProcess is suspended until data arrives.
 The writeWillNotBlock or writeWillNotBlockWithin: methods may be used to
 determine whether or not data is ready for writing before calling this method."

^ self write: (byteObj size) from: byteObj startingAt: 1
%

category: 'Writing'
method: GsSocket
write: amount from: byteObj

"Write the given number of bytes from the given byte object.  Returns the
 number of bytes written, or nil if an error occurs.

 If the receiver is not ready for writing
 the current GsProcess is suspended until data arrives.
 The writeWillNotBlock or writeWillNotBlockWithin: methods may be used to
 determine whether or not data is ready for writing before calling this method."

^ self write: amount from: byteObj startingAt: 1
%

category: 'Writing'
method: GsSocket
write: amount from: byteObj startingAt: index

"Write bytes from byteObj to the receiver.
 The first byte written will be from the position indicated by index.
 The number of bytes written is specified by amount.
 It is in an error if amount bytes are not available.
 Returns the number of bytes written, or nil if an error occurs.

 If the receiver is not ready for writing
 the current GsProcess is suspended until data arrives.
 The writeWillNotBlock or writeWillNotBlockWithin: methods may be used to
 determine whether or not data is ready for writing before calling this method."

 | offset numToWrite waitCnt |
 offset := index.
 numToWrite := amount.
 [ true ] whileTrue:[ | result |
   [
     result := self _write: byteObj startingAt: offset ofSize: numToWrite .
     result == true
   ] whileTrue . "loop to handle EINTR "

   result _isSmallInteger ifTrue:[
     numToWrite  := numToWrite - result .
     (numToWrite <= 0) ifTrue: [ ^ amount ]. "All done"
     waitCnt := nil .
     offset := offset + result .
   ] ifFalse: [
     result ifNil:[ ^ nil "socket error"].
     waitCnt ifNotNil:[
       waitCnt < 3 ifTrue:[
         waitCnt := waitCnt + 1 .
         Delay waitForMilliseconds: 1.
       ] ifFalse:[
         GsFile gciLogServer:'socket EAGAIN fd ', fileDescriptor asString .
         System _printSocketTrace .
         SocketError signal:'EAGAIN from socket write after poll said write-ready'.
       ].
     ] ifNil:[
       waitCnt := 0 .
     ].
     self _waitForWriteReady .
   ].
 ].
%

category: 'Writing'
method: GsSocket
write: amount from: byteObj startingAt: index untilFalse: aBlock

"Write bytes from byteObj to the receiver until amount bytes have
 been written, an error occurs, or aBlock's value is false.
 The first byte written will be from the position indicated by index.
 The number of bytes written is specified by amount.
 It is in an error if amount bytes are not available.
 Returns the number of bytes written, or nil if an error occurs.
 This method repeatedly tries to write as many bytes as it can
 and then, if more bytes still need to be written, evaluates aBlock.

 If the receiver is not ready for writing the one argument Block
 aBlock is called.
 The writeWillNotBlock or writeWillNotBlockWithin: methods may be used
 in aBlock to determine when it should return true so that another write
 will be done without blocking.
 Every time aBlock is evaluated its argument is the total number of bytes
 written so far.

 Implementation uses nbwrite, so unless aBlock uses
 writeWillNotBlockWithin:-1 or other logic based on writeWillNotBlock ,
 to wait for the socket to be ready before returning false from
 aBlock, this method will run hot.

 If the receiver is a GsSecureSocket, aBlock will not be executed,
 since the wait for ready for writing is performed at a lower layer.
"

| total offset numToWrite |

total := 0.
offset := index.
numToWrite := amount.

[ | result |
 result := self nbwrite: numToWrite from: byteObj startingAt: offset.
 (result == nil) ifTrue: [^nil]. "Quit due to error"
 total := total + result.
 (total == amount) ifTrue: [^total]. "All done"
 numToWrite := numToWrite - result.
 offset := offset + result.
 aBlock value: total
] untilFalse.

^total
%

category: 'Writing'
method: GsSocket
write: byteObj startingAt: index

"Write bytes from byteObj to the receiver.
 The first byte written will be from the position indicated by index.
 All of the bytes after it in byteObj will be written.
 Returns the number of bytes written, or nil if an error occurs.

 If the receiver is not ready for writing
 the current GsProcess is suspended until data arrives.
 The writeWillNotBlock or writeWillNotBlockWithin: methods may be used to
 determine whether or not data is ready for writing before calling this method."

^ self write: ((byteObj size) - (index - 1)) from: byteObj startingAt: index
%

category: 'Writing'
method: GsSocket
write: byteObj startingAt: index untilFalse: aBlock

"Writes the contents of byteObj to the receiver unless
 an error occurs or aBlock returns false.
 The first byte written from byteObj is at the position specified by index.
 All of the bytes after it in byteObj will be written.
 See write:from:startingAt:untilFalse: for details.
 Returns the number of bytes actually written."

^ self write: ((byteObj size) - (index -1)) from: byteObj startingAt: index
       untilFalse: aBlock.
%

category: 'Writing'
method: GsSocket
write: byteObj untilFalse: aBlock

"Writes the entire contents of byteObj to the receiver unless
 an error occurs or aBlock returns false.
 See write:from:startingAt:untilFalse: for details.
 Returns the number of bytes actually written."

^ self write: (byteObj size) from: byteObj startingAt: 1 untilFalse: aBlock.
%

category: 'Deprecated'
method: GsSocket
writeReady

self deprecated: 'GsSocket>>writeReady deprecated long before v3.0. Use writeWillNotBlock or writeWillNotBlockWithin: instead.'.
^ self _zeroArgPrim: 18
%

category: 'Writing'
method: GsSocket
writev: numBuffers specs: specArray

"Use the writev system call to write the specified number
 of buffers.  Each buffer is a byte format object described by
 3 elements of specArray in this order:
  * Buffer: A byte object containing bytes to be written
  * StartIndex: The 1-based index within the buffer of the first byte to be written
  * NumBytes: The number of bytes to be written.

 This method will block until the write completes, or until a socket error
 occurs.
 Returns receiver if write completes successfully, or signals an Error .
 Signals an ArgumentError if an element of specArray is invalid .
 Signals a SocketError if the underlying writev() fails .
"
| ofs |
ofs := 1 .
 [ true ] whileTrue:[ | result |
   [
     result := self _writev: numBuffers specs: specArray byteOffset: ofs .
     result == true
   ] whileTrue . "loop to handle EINTR "
   result == 0 ifTrue:[ ^ self  "all buffers sent" ].
   result > 0 ifTrue:[
     ofs := result .
     self _waitForWriteReady
   ] ifFalse:[
     SocketError signal:'errno = ', (0 - result) asString
   ]
 ]
%

category: 'Accessing'
method: GsSocket
writeWaiters
  "Return an Array containing the objects waiting on the receiver to be ready
   for writing."

^ self _getWaiters: writeWaiters
%

category: 'Testing'
method: GsSocket
writeWillNotBlock

"Returns true if the socket is currently ready to take output without blocking.
 Returns false if it is not currently ready.  Returns nil if an error occurs.

 The receiver must already be connected for this method to work properly.  If it
 is not connected, then the value that this method returns is indeterminate.
 Use the peerName method to determine if the receiver is connected.

 Call this method to prevent subsequent write operations from hanging.  If it
 returns true for a connected socket, then a subsequent write will not hang.
 However, a return value of true is no guarantee that the write operation itself
 will succeed."

^ self _zeroArgPrim: 18
%

category: 'Testing'
method: GsSocket
writeWillNotBlockWithin: msToWait

"Returns true if the socket is ready to take output without blocking within
 msToWait milliseconds from the time that this method is called.
 Returns false if it is not ready after msToWait milliseconds.
 Returns nil if an error occurs.

 If msToWait is 0, then this method reports the current readiness of the receiver.
 If msToWait is -1, then this method never returns false, but suspends the
 current GsProcess until the receiver is ready to take output without blocking,
 and then returns true.

 If msToWait ~~ 0 and the socket is not ready to read, the current
 GsProcess is suspended.  Semantics of suspend are the same as
 for Delay >> wait ; other GsProcess may execute while this GsProcess
 is suspended.

 The receiver must already be connected for this method to work properly.  If it
 is not connected, then the value that this method returns is indeterminate.
 Use the peerName method to determine if the receiver is connected.

 Call this method to prevent subsequent write operations from hanging.  If it
 returns true for a connected socket, then a subsequent write will not hang.
 However, a return value of true is no guarantee that the write operation itself
 will succeed."

 | sched proc |
 self writeWillNotBlock 
    ifNil:[ ^ nil ]  "fix 50775"
 ifNotNil:[:status | status ifTrue:[ ^ true ]
                           ifFalse:[ msToWait == 0 ifTrue:[ ^ false ]]].
 self _enableWrite .
 (sched := self _scheduler) _enterCritical .
 proc := sched activeProcess .
 writeWaiters ifNil:[
   writeWaiters := proc
 ] ifNotNil:[
   self _addWriteWaiter: proc
 ].
 msToWait == -1 ifTrue:[
   sched _waitForSocket: self .  "exits critical"
   ^ true
 ] ifFalse:[
   sched _waitForSocket: self timeout: msToWait forWrite: true .  "exits critical"
   ^ self _isWritableOrException
 ]
%

category: 'Private'
method: GsSocket
_add: anObject toArray: aProcessArray

"Implements IdentitySet add: semantics for aProcessArray
 Returns true if anObject was already in aProcessArray, false otherwise"

<primitive: 725>
aProcessArray size > 100 ifTrue:[
  self error:'too many processes waiting on socket'.
].
self _primitiveFailed: #_add:toSet: args: { anObject . aProcessArray }
%

category: 'Private'
method: GsSocket
_addReadWaiter: aProcess
   "assumes that readWaiters is not nil, and aProcess will be second or
    subsequent waiter."

   | waiters arr |
   (waiters := readWaiters) _isArray ifFalse:[
     arr := { waiters } .
     readWaiters := arr .
     waiters := arr .
   ].
   self _add: aProcess toArray: waiters .
%

category: 'Private'
method: GsSocket
_addWriteWaiter: aProcess
   "assumes that writeWaiters is not nil, and aProcess will be second or
    subsequent waiter."

   | waiters arr |
   (waiters := writeWaiters) _isArray ifFalse:[
     arr := { waiters } .
     writeWaiters := arr .
     waiters := arr .
   ].
   self _add: aProcess toArray: waiters .
%

category: 'Private Scheduling'
method: GsSocket
_cancelReadEventFor: objToNotify
  "Returns true if event has already been cancelled or reaped.
   Returns false if event is cancelled by this invocation."
  | wtrs |
  wtrs := readWaiters .
  wtrs == objToNotify ifTrue:[
    readWaiters := nil.  self _disableEvent: false . 
    ^ false
  ]. 
  wtrs _isArray ifTrue:[
    (wtrs removeIdentical: objToNotify otherwise:nil) ifNil:[ ^ true ].
    wtrs size == 0 ifTrue:[ readWaiters := nil. self _disableEvent: false ].
    ^ false .
  ].
  ^ true
%

category: 'Private Scheduling'
method: GsSocket
_cancelWriteEventFor: objToNotify
  "Returns true if event has already been cancelled or reaped.
   Returns false if event is cancelled by this invocation."
  | wtrs |
  wtrs := writeWaiters .
  wtrs == objToNotify ifTrue:[
    writeWaiters := nil. self _disableEvent: true .
    ^ false .
  ].
  wtrs _isArray ifTrue:[
    (wtrs removeIdentical: objToNotify otherwise: nil) ifNil:[ ^ true ].
    wtrs size == 0 ifTrue:[ writeWaiters := nil. self _disableEvent: true ].
    ^ false
  ].
  ^ true
%

category: 'Private Scheduling'
method: GsSocket
_changePriority: aGsProcess from: oldPriority
  ^ self  "do nothing"
%

category: 'Private'
method: GsSocket
_disableEvent: aKind

"Disables the read or write detection specified by aKind.
 Used to cancel a previous  _enableRead or _enableWrite.
  aKind == true   cancels previous _enableWrite
  aKind == false  cancels previous _enableRead
  aKind == nil    cancels any previous _enableRead or _enableWrite
"

<primitive: 729>
self _primitiveFailed: #_disableEvent: args: { aKind }
%

category: 'Private'
method: GsSocket
_enableRead

"Enables read detection by ProcessorScheduler>>_doPoll: .
 Returns receiver if successful, nil if socket not open."

<primitive: 731>
self _primitiveFailed: #_enableRead  "socket maybe set to blocking mode"
%

category: 'Private'
method: GsSocket
_enableWrite

"Enables write detection by ProcessorScheduler>>_doPoll: .
 Returns receiver if successful, nil if socket not open."

<primitive: 732>
self _primitiveFailed: #_enableWrite  "socket maybe set to blocking mode"
%

category: 'Private'
method: GsSocket
_getWaiters: waiters
  waiters ifNotNil:[
    waiters _isArray ifTrue:[
      ^ waiters copy
    ] ifFalse:[
      ^ { waiters }
    ]
  ] ifNil:[
    ^ { }
  ].
%

category: 'Private'
method: GsSocket
_hadException

"Returns true if the receiver is marked as having had an exception.
 For use only after control returns from the scheduler. "

^ (readyEvents bitAnd: 16r38) ~~ 0
%

category: 'Private'
method: GsSocket
_isAsyncExceptionReader
 "Return true if receiver was created by GsSignalingSocket class >> newForAsyncExceptions: "
 ^ self _zeroArgPrim: 21
%

category: 'Private'
method: GsSocket
_isReadable

"Returns true if the receiver is marked as being ready to read.
 For use only after control returns from the scheduler. "

^ (readyEvents bitAnd: 3) ~~ 0
%

category: 'Private'
method: GsSocket
_isReadableOrException

"Returns true if the receiver is marked as being ready to read
 or has an exception.
 For use only after control returns from the scheduler. "

^ (readyEvents bitAnd:16r3B) ~~ 0
%

category: 'Private'
method: GsSocket
_isWritable

"Returns true if the receiver is marked as being ready to write.
 For use only after control returns from the scheduler. "

^ (readyEvents bitAnd: 4) ~~ 0
%

category: 'Private'
method: GsSocket
_isWritableOrException

"Returns true if the receiver is marked as being ready to write
 or has an exception."

^ (readyEvents bitAnd: 16r3c) ~~ 0
%

category: 'Private'
method: GsSocket
_maxReadWaits
  ^ 3
%

category: 'Private'
method: GsSocket
_readInto: aString startingAt: anOffset maxBytes: numBytes

"Returns nil if an error occurred,
   false if non-blocking receiver would block,
   true if EINTR occurred,
   a SmallInteger number of bytes read.

 numBytes specifies maximum number of bytes to read, they
 are stored starting at (aString at: anOffset).

 Clears bits 16r3 from self.readyEvents if no error generated.
"

<primitive: 489>
self _primitiveFailed: #_readInto:startingAt:maxBytes:
     args: { aString . anOffset . numBytes }
%

category: 'Private Scheduling'
method: GsSocket
_reapEvents
  "returns true if receiver has no more waiters after reaping events"

  | rwtrs wwtrs res revents |
  rwtrs := readWaiters .
  ((revents := readyEvents) bitAnd:16r3B) ~~ 0 ifTrue:[ "inline _isReadableOrException"
    rwtrs ifNotNil:[
      rwtrs _isArray ifTrue:[
        1 to: rwtrs size do:[:k |
          (rwtrs at: k) _reapSignal: self  .
        ].
      ] ifFalse:[
        rwtrs _reapSignal: self
      ].
      "GsFile gciLogServer:' reaped readable' .  "
      readWaiters := nil .
      rwtrs := nil .
    ].
  ].
  wwtrs := writeWaiters .
  (revents bitAnd: 16r3c) ~~ 0 ifTrue:[ "inline _isWritableOrException"
    wwtrs ifNotNil:[
      wwtrs _isArray ifTrue:[
        1 to: wwtrs size do:[:k |
          (wwtrs at: k) _reapSignal: self
        ].
      ] ifFalse:[
        wwtrs _reapSignal: self
      ].
      " GsFile gciLogServer:' reaped writable' . "
      writeWaiters := nil .
      wwtrs := nil .
    ].
    res := rwtrs == nil .
  ] ifFalse:[
    res := rwtrs == nil and:[ wwtrs == nil] .
  ].
  " GsFile gciLogServer:'  returning ' , res asString .   "
  ^ res
%

category: 'Private'
method: GsSocket
_recvfrom: maxBytes

"calls recvfrom().
 Returns an Array of the form [ aString , senderInfoArray ],
 or false to indicate EWOULDBLOCK, or true to indicate EINTR,
 or a String error message.
 aString in the result array is the data received from the socket.
 The senderInfoArray represents the struct sockaddr filled in by
  recvfrom() , and is of the form
    { af_string . portNum . nil . ipAddrString } .
  af_string will be one of 'AF_INET' , 'AF_INET6', 'AF_UNIX' . "

<primitive: 884>
self _primitiveFailed: #_recvfrom: args: { maxBytes }
%

category: 'Private'
method: GsSocket
_scheduler

"Returns   ProcessorScheduler scheduler "
<primitive: 457>

self _primitiveFailed: #_scheduler
%

category: 'Private'
method: GsSocket
_sendUdp: aString startingAt: anOffset to: hostName port: portNum

"Returns a SmallInteger number of bytes written,
  or false to indicate EWOULDBLOCK,
  or true to indicate EINTR,
  or a String error message.
  Uses getaddrinfo() with hints.ai_socktype == SOCK_DGRAM to translate
  hostName and portNum to a struct sockaddr for use by sendto() ."

<primitive: 883>
self _primitiveFailed: #_sendUdp:to:port:
     args: { aString . anOffset . hostName . portNum }
%

category: 'Private'
method: GsSocket
_setError: str

^self _twoArgPrim: 9 with: str with: nil
%

category: 'Private'
method: GsSocket
_twoArgPrim: opcode with: arg1 with: arg2

"opcode  function
   1     class method:    getServicePortByName
   2     instance method: SocketConnect, arg is a String, struct sockaddr_in6 (see below)
   3     instance method: SocketLinger
   4     instance method: SocketAccept
   5     instance method: SocketKeepAlive
   6     instance method: SocketBind
   7     class method:    GetHostNameByAddress
   8     class method:    GetServiceNameByPort
   9     instance method: GsSocketSetError
  10     instance method: GsSocketRaiseException
  11     instance method: SocketMakeListener
  12     class method:    GetHostAddressByName
  13     instance method  UNIXServer>>bind: aPath
  14     instance method used by GsSignalingSocket class >> newForAsyncExceptions:
  15     class method:    GetStandardId
  16     instance method  UNIXServer>>connect: aPath
  17     class method     _existingSocketForFd:
  18     class method     _gethostbyaddr:   (using getnameinfo)
  19     class method     _getsockaddr:host:  (getaddrinfo with hints.ai_family=AF_UNSPEC)
  20     class method     _unpackSockAddr:flags:
  21     class method     _getsockaddrUnix:
  22     class method     _unpackSockAddrUnix:
  24     instance method  _bindAddr:
  25     instance method _ addrInfo: aHost port: aPort
	  result is { ai_canonname . struct_sockaddr ... struct_sockaddr }
	   aHost == -1 means <broadcase>
           aHost == nil means IN6ADDR_ANY_INIT
          IPv4 addresses preceed IPv6 addresses in returned list.
  27     class method     addressIsIpv6:
  28     instance method: _setFileDescriptor:
  29     instance method: setCloseOnGc

  For opcode 2, SocketConnect the return values from this primitive are
    self  - connect succeeded
    false -  the connect() call returned EINPROGRESS, and
           a subsequent  poll()  waiting for write-ready with timeout of 500ms
           timedout , thus socket is still in EINPROGRESS state .
           The image then uses writeWillNotBlockWithin:  to wait longer for
           the  connect to complete .
    nil -    connect()  returned EINPROGRESS and the subsequent poll for write-ready
           failed with an error, indicating connect() failed rather than completing.
    aSmallInteger - errno value of a failed connect() , other than EINPROGRESS.
"

<primitive: 322>

^ self _primitiveFailed: #_twoArgPrim:with:with: args: { opcode . arg1 . arg2 }
%

category: 'Private'
method: GsSocket
_unscheduleProcess: aProcess
  | wtrs rCount wCount found |  "part of fix 50476"
  wtrs := readWaiters .
  rCount := 0 . wCount := 0 .
  wtrs ifNotNil:[
    found := true .
    wtrs == aProcess ifTrue:[ 
      readWaiters := nil 
    ] ifFalse:[ 
      wtrs _isArray ifTrue:[ wtrs removeIdentical: aProcess otherwise: nil ].
      (rCount := wtrs size) == 0 ifTrue:[ readWaiters := nil].
    ].
  ]. 
  wtrs := writeWaiters.
  wtrs ifNotNil:[
    found := true .
    wtrs == aProcess ifTrue:[ 
      writeWaiters := nil 
    ] ifFalse:[ 
      wtrs _isArray ifTrue:[ wtrs removeIdentical: aProcess otherwise: nil ].
      (wCount := wtrs size) == 0 ifTrue:[ writeWaiters := nil]. 
    ].
  ]. 
  found ifNotNil:[ 
    wCount + rCount == 0 ifTrue:[
      self _disableEvent: nil . "remove from scheduler's polledSockets completely"
      ^ self.
    ].
    wCount == 0 ifTrue:[ self _disableEvent: true ]
               ifFalse:[ self _disableEvent: false ].
  ]
%

category: 'Testing'
method: GsSocket
_waitForReadReady

"Returns true when socket is ready to receive input without blocking.
 Caller should have already attempted a read that failed because it would block,
 or checked status from _isReadableOrException.
 "
 | sched proc |
 self _enableRead .
 (sched := self _scheduler) _enterCritical .
 proc := sched activeProcess .
 readWaiters ifNil:[
   readWaiters := proc
 ] ifNotNil:[
   self _addReadWaiter: proc
 ].
 sched _waitForSocket: self . "exits critical"
 ^ true
%

category: 'Testing'
method: GsSocket
_waitForWriteReady

"Waits until socket is ready to take output without blocking
 and then returns true. Caller should have already done a write or connect
 which failed because it would have blocked, or checked status with _isWritableOrException."

 | sched proc |
 self _enableWrite .
 (sched := self _scheduler) _enterCritical .
 proc := sched activeProcess .
 writeWaiters ifNil:[
   writeWaiters := proc
 ] ifNotNil:[
   self _addWriteWaiter: proc
 ].
 sched _waitForSocket: self .  "exits critical"
 ^ true
%

category: 'Private Scheduling'
method: GsSocket
_whenReadableNotify: objToNotify

 objToNotify _canWaitOnSocket .  "DNU if waiting not supported on objToNotify"
 self _enableRead .
 readWaiters ifNil:[
   readWaiters := objToNotify
 ] ifNotNil:[
   self _addReadWaiter: objToNotify
 ]
%

category: 'Private Scheduling'
method: GsSocket
_whenWritableNotify: objToNotify

 objToNotify _canWaitOnSocket .  "DNU if waiting not supported on objToNotify"
 self _enableWrite .
 writeWaiters ifNil:[
   writeWaiters := objToNotify
 ] ifNotNil:[
   self _addWriteWaiter: objToNotify
 ].
%

category: 'Private'
method: GsSocket
_write: aByteObject startingAt: anOffset ofSize: numBytes

"returns nil if an error occurred,
   false if non-blocking receiver would block,
   true if EINTR occurred,
   a SmallInteger number of bytes written.
 Generates an error if aByteObject is not a String or ByteArray.
 Clears bits 16r4 from self.readyEvents if no error generated."

<primitive: 882>
self _primitiveFailed: #_write:startingAt:ofSize:
     args: { aByteObject . anOffset . numBytes }
%

category: 'Private'
method: GsSocket
_writev: numBuffers specs: specArray byteOffset: startOffset

"Use the writev system call to write buffers per  GsSocket>>writev:specs:
with startOffset being a one based byte offset into the concatenated
data specified by the first numBuffers*3 elements of specArray .

numBuffers must be <= 20 .

Returns
  0 if all writes completed,
  a positive offset if EWOULDBLOCK or EAGAIN was returned by the
    underlying socket,
  true if EINTR was returned by the underlying socket (repeat
    call with same startOffset to resume writing),
  a negated errno value in case of other error.
The positive offset should be used as the next
startOffset value to resume the write .
"

<primitive: 948>
numBuffers _validateClass: SmallInteger .
startOffset _validateClass: SmallInteger .
specArray _validateClass: Array .
numBuffers > 20 ifTrue:[ ArgumentError signal:'numBuffers must be <= 20' ].
(numBuffers * 3) > specArray size ifTrue:[
  ArgumentError signal:'numBuffers larger than specArray'].
startOffset < 1 ifTrue:[ ArgumentError signal:'startOffset must be >= 1'].
self _primitiveFailed:#_writev:specs:byteOffset:
	args: { numBuffers . specArray . startOffset }
%

category: 'Private'
method: GsSocket
_zeroArgPrim: opcode

"opcode  function
   1     instance method: SocketCreate
   2     instance method: SocketClose
   3     instance method: SocketPort
   4     reserved
   5     class method:    GetLocalHostName
   6     class method:    SocketCloseAll
   7     class method:    SocketErrorString
   8     class method:    SocketErrno
   9     instance method: SocketPeerAddress AF_INET
  10     instance method: SocketErrorString
  11     instance method: SocketErrno
  12     instance method: _fileDescriptor   returns dataPtr->socket  from C state
  13     instance method: SocketIsConnected
  14     instance method: SocketPeerPort
  15     instance method: SocketAddress
  16     class method:    GsSocketFinalizeAll
  17     instance method: SocketReadWillNotBlock
  18     instance method: SocketWriteWillNotBlock
  19     class method:    _lastErrorSymbolOffset
  20     instance method: _lastErrorSymbolOffset
  21     instance method: _isAsyncExceptionReader
  23     instance method: shutdownReading
  24     instance method: shutdownWriting
  25     instance method: shutdownReadingAndWriting
  26     instance method: SocketCreate UDP
  27     instance method: SocketCreate UNIX Stream
  28     instance method: SocketCreate UNIX Dgram
  29     class method:    SocketPair UNIX Stream (returns array of fds)
  30     instance method: SocketAddress AF_UNIX
  31     instance method: SocketPeerAddress AF_UNIX
  32     instance method: _peerSockAddr (returning a Ruby sockaddr String)
  33     instance method: _socketLocation (returning a Ruby sockaddr String)
  34     instance method: called by class method newIpv6
  35     instance method: called by class method newUdpIpv6
  36     instance method: isNonBlocking
  37     classmethod  disableAsyncExceptions
"

<primitive: 323>

^ self _primitiveFailed: #_zeroArgPrim: args: { opcode }
%

category: 'Comparing'
method: GsSocket
~= aSocket

"Returns false if the receiver and aSocket represent the same operating system
 socket.  Returns true otherwise."

^ (self = aSocket) == false
%

! Class extensions for 'IcuCollator'

!		Class methods for 'IcuCollator'

removeallmethods IcuCollator
removeallclassmethods IcuCollator

category: 'Private'
classmethod: IcuCollator
_initializeConstants
  | args names vals |
  args := { PRIMARY . SECONDARY . TERTIARY . QUATERNARY . IDENTICAL }.
  names := #( #PRIMARY #SECONDARY #TERTIARY #QUATERNARY #IDENTICAL ) .
  self _addInvariantClassVar: #StrengthArgs value: args immediateInvariant .
  self _addInvariantClassVar: #StrengthNames value: names .
  vals := Array new: IDENTICAL + 1.
  1 to: args size do:[:j | vals at: (args at: j) + 1  put: (names at: j)  ].
  self _addInvariantClassVar: #StrengthVals value: vals immediateInvariant .
%

! Class extensions for 'LargeInteger'

!		Class methods for 'LargeInteger'

removeallmethods LargeInteger
removeallclassmethods LargeInteger

category: 'Instance Creation'
classmethod: LargeInteger
basicNew
  "Returns a instance of LargeInteger with specified size and value = 0"
  ^ self basicNew: 0
%

category: 'Instance Creation'
classmethod: LargeInteger
basicNew: aSize
  "Returns a instance of LargeInteger with specified size and value = 0"

^ self _new: aSize
%

category: 'Storing and Loading'
classmethod: LargeInteger
loadFrom: passiveObject

"Reads from passiveObject and convert to active. This method creates
 subnormal (LargeIntegers in the SmallInteger range) if necessary."

| value instance |
value := passiveObject readInt.
instance := value _isSmallInteger
   ifTrue: [self _newWithValue: value]
   ifFalse: [value].
passiveObject hasRead: instance.
^instance
%

category: 'Queries'
classmethod: LargeInteger
maximumDecimalFloat
 ^ MaximumDecimalFloat .
%

category: 'Queries'
classmethod: LargeInteger
maximumFloat
 ^ MaximumFloat .
%

category: 'Queries'
classmethod: LargeInteger
maximumValue
"Returns the maximum allowable LargeInteger value."

^ MaximumValue "computed during filein"
%

category: 'Private'
classmethod: LargeInteger
_initializeMaximumValues
"Returns the maximum allowable LargeInteger value."
| nd v f df |
nd := MaximumDigits"classVar installed by bom.c" .
v := 1 bitShift: (nd * 32) - 1 .
v := (v - 1) bitOr: v .
v _digitLength = nd  ifFalse:[ self error:'incorrect size'].
(v bitXor: v) = 0 ifFalse:[ self error:'incorrect value'].
f := Float fmax asInteger. "largest Float < PlusInfinity"
df := 9.9999999999999999999f15000 asInteger. "largest DecimalFloat < Infinity"
LargeInteger _addInvariantClassVar: #MaximumValue value: v immediateInvariant .
LargeInteger _addInvariantClassVar: #MaximumFloat value: f asInteger immediateInvariant .
LargeInteger _addInvariantClassVar: #MaximumDecimalFloat value: df asInteger immediateInvariant .

Float _addInvariantClassVar: #MaximumFloat value: f immediateInvariant .
DecimalFloat _addInvariantClassVar: #MaximumFloat value: df immediateInvariant .
^ v
%

!		Instance methods for 'LargeInteger'

category: 'Arithmetic'
method: LargeInteger
abs

"Returns a LargeInteger that is the absolute value of the receiver."

| sign |
sign := self _digitAt:0 .
sign == 0 ifTrue:[ ^ self ].
^ 0 - self
%

category: 'Converting'
method: LargeInteger
asCanonicalForm
	"Answer self, or, if I am a LargeInteger with an equivalent
	SmallInteger, answer that SmallInteger."

	| res |
	res := self + 0.
	res class == SmallInteger
		ifTrue: [ ^ res ].
	^ self
%

category: 'Converting'
method: LargeInteger
asInteger

"Returns the receiver, truncated to a SmallInteger if possible."

<primitive: 599>
self _primitiveFailed: #asInteger .
self _uncontinuableError
%

category: 'Accessing'
method: LargeInteger
at: anIndex

"Disallowed."

self shouldNotImplement: #at:
%

category: 'Accessing'
method: LargeInteger
at: anIndex put: aNumber

"Disallowed.  You may not change the value of a LargeInteger."

self shouldNotImplement: #at:put:
%

category: 'Truncation and Rounding'
method: LargeInteger
ceiling

"Returns the receiver, truncated to a SmallInteger if possible."

<primitive: 599>
self _primitiveFailed: #ceiling .
self _uncontinuableError
%

category: 'Truncation and Rounding'
method: LargeInteger
floor

"Returns the receiver, truncated to a SmallInteger if possible."

<primitive: 599>
self _primitiveFailed: #floor .
self _uncontinuableError
%

category: 'Bit Manipulation'
method: LargeInteger
highBit

"Returns the index of the high-order bit that is set
 in the binary representation of the receiver.  (If the receiver is a negative
 integer, takes its absolute value first.)
 As of v3.7, if the receiver is zero, this returns zero; in previous releases 
 this returned nil.
 As of Gs64 v3.2  the least significant bit has index 1 ,
 in previous versions the least significant bit had index 0 .

 Example:   4 highBit == 3  "

| len |
len := self _digitLength .
^ (self _digitAt: len) highBit + (32 * (len - 1))
%

category: 'Testing'
method: LargeInteger
negative

^ (self _digitAt:0) ~~ 0
%

category: 'Testing'
method: LargeInteger
positive

^ (self _digitAt:0) == 0
%

category: 'Copying'
method: LargeInteger
postCopy
  ^ self immediateInvariant
%

category: 'Truncation and Rounding'
method: LargeInteger
rounded

"Returns the receiver, truncated to a SmallInteger if possible."

<primitive: 599>
self _primitiveFailed: #rounded .
self _uncontinuableError
%

category: 'Accessing'
method: LargeInteger
sign
  self = 0 ifTrue:[ ^ 0 ].
  ^ (self _digitAt: 0) ~~ 0 ifTrue:[ -1 ] ifFalse:[ 1]
%

category: 'Truncation and Rounding'
method: LargeInteger
truncated

"Returns the receiver, truncated to a SmallInteger if possible."

<primitive: 599>
self _primitiveFailed: #truncated .
self _uncontinuableError
%

category: 'Updating'
method: LargeInteger
_digitAt: anIndex put: aValue

"Store aValue into the receiver's base 4294967296 digit specified by anIndex .
 indicated by index.  Fail if the value is negative or is larger than 4294967295.
 Fail if the index is not an Integer or is out of bounds.  Returns the value
 that was stored."

<primitive: 257>

anIndex _validateClass: SmallInteger.
aValue _validateClass: SmallInteger.
self _primitiveFailed: #_digitAt:Put: args: { anIndex . aValue } .
self _uncontinuableError
%

category: 'Private'
method: LargeInteger
__recursiveSize: arr 
  ^ self . "do not iterate over the digits"
  
%

! Class extensions for 'Object'

!		Class methods for 'Object'

category: 'Indexing Support'
classmethod: Object
_canCreateQueryOnInstances
  "Cannot create a GsQuery on the receiver"

  ^ false
%

category: 'Updating'
classmethod: Object
_checkKindForBecome: anObj

"determine reason for primitive failure of become"
| arr gsCompDict |
(gsCompDict := Globals at: #GsCompilerClasses otherwise: nil) ifNil:[
  Error signal: 'GsCompilerClasses missing from Globals'.
].


anObj isSpecial ifTrue: [ ^ anObj _error: #rtErrCantBecomeSpecial ].

anObj _isExecBlock ifTrue: [
   ^ ArgumentTypeError new reason: #rtErrCantBecomeClassKind ; _number: 2121; object: anObj ;
	details: 'become not allowed on ExecBlocks  '; signal
].
(anObj _isSymbol ) ifTrue: [
   ^ ArgumentTypeError new reason: #rtErrCantBecomeClassKind ; _number: 2121; object: anObj ;
	details: 'become not allowed on Symbols  '; signal
].

arr := { Behavior . GsNMethod .   " to avoid breaking VM"
   GsMethodDictionary . SymbolDictionary . SymbolList .  "for code security"
   "following have CData" GsSocket . GsFile . 
     (gsCompDict at: #GsCompilerIRNode) . CBuffer . CByteArray . CFunction . CLibrary . CPointer .
     CZstream }.
1 to: arr size do:[:n || cls |
  cls := arr at: n .
  (anObj isKindOf: cls) ifTrue:[
    ^ ArgumentTypeError new reason: #rtErrCantBecomeClassKind; _number: 2121 ; object: anObj;
       details: 'become not allowed on instances of ' , cls name ; signal .
  ]
].
%

category: 'Indexing Support'
classmethod: Object
_idxBasicCanCompareWithCharacterCollectionInstance: aCharacterCollection
  "Returns true if <aCharacterCollection> may be inserted into a basic BtreeNode
   whose #lastElementClass is the receiver (see RangeEqualityIndex
   class>>isBasicClass:)."

  ^ false
%

category: 'Indexing Support'
classmethod: Object
_idxBasicCanCompareWithUnicodeInstance: aUnicodeString
  "Returns true if <aUnicodeString> may be inserted into a basic BtreeNode whose
   #lastElementClass is the receiver (see RangeEqualityIndex class>>isBasicClass:)."

  ^ false
%

category: 'Indexing Support'
classmethod: Object
_idxCanOptimizeComparison
  "Answer true if it is possible to optimize index-related comparisons by replacing
   _idxForCompare* calles with a primitive comparison call instead.

     _idxForCompareEqualTo:              #=
     _idxForCompareGreaterThan:          #>
     _idxForCompareGreaterThanOrEqualTo: #>=
     _idxForCompareLessThan:             #<
     _idxForCompareLessThanOrEqualTo:    #<=
     _idxForCompareNotEqualTo:           #~=
   "

  ^ false
%

category: 'Repository Conversion'
classmethod: Object
_loadBitmap: bm fromFilesIn: directoryPath
  ^ self
    _loadBitmap: bm
    fromFilesIn: directoryPath
    withPattern: (Array with: '.bm')
%

category: 'Repository Conversion'
classmethod: Object
_loadBitmap: bm fromFilesIn: directoryPath withPattern: pattern
  | sys files |
  sys := System.
  bm removeAll.
  files := GsFile contentsOfDirectory: directoryPath onClient: false.
  files := files select: [ :e | (e findPattern: pattern startingAt: 1) ~~ 0 ].
  1 to: files size do: [ :n |
    | fn |
    fn := files at: n.
    bm readFromFile: fn ].
  ^ bm size
%

!		Instance methods for 'Object'

category: 'Modification Tracking'
method: Object
aboutToModifyObject: anObject atOffset: anOffset to: newValue
  "Notification that the tracked object anObject is about to modified at instance
   variable offset anOffset with value newValue.
   The receiver is registered as a modification tracker for anObject."

  "Default implementation for backward compatibility with pre-3.2 API"

  self modifyingObject: anObject atOffset: anOffset to: newValue.
  ^ #()
%

category: 'Json'
method: Object
asJson

	| stream gotError |
	stream := AppendStream on: String new.
	gotError := false.
	[
		self printJsonOn: stream.
	] on: (AlmostOutOfStack , AlmostOutOfStackError)  do: [:ex |
		gotError := true.
		ex return.
	].
	gotError ifTrue: [self error: 'Ran out of stack space (probably due to a recursive reference, which is not supported by Json).'].
	^stream contents.
%

category: 'PetitParser converting'
method: Object
asParser
	"Answer a parser accepting the receiving object."

	^ PPPredicateObjectParser expect: self
%

category: 'Error Handling'
method: Object
cantPerform: aSelectorSymbol withArguments: anArray
	"This method implements the default response when a message can't be performed
 with _perform:withArguments:.  It raises the rtErrCantPerform exception."
  | ex |
	aSelectorSymbol numArgs == anArray size ifTrue:[
     ^ self doesNotUnderstand: (Message selector: aSelectorSymbol arguments: anArray)
  ].
  (ex := ArgumentError new) _number: 2263; args: { aSelectorSymbol . self . anArray };
         details: 'wrong number of args for selector' .
  ^ ex signal .
%

category: 'Error Handling'
method: Object
cantPerform: aSelectorSymbol withArguments: anArray env: envId
  | ex |
  envId == 0 ifTrue:[
    ^ self cantPerform: aSelectorSymbol withArguments: anArray
  ].
  aSelectorSymbol numArgs == anArray size ifTrue:[
    (ex := MessageNotUnderstood _basicNew)
       receiver: self selector: aSelectorSymbol args: anArray envId: envId .
    ^ex signal .  "fix for #40871"
  ].
  (ex := ArgumentError new) _number: 2263;
         args: { aSelectorSymbol . self . anArray . envId };
         details: 'wrong number of args for selector' .
  ^ ex signal .
%

category: 'Indexing Support'
method: Object
getDepListAndAddLastElementPathTerm: pathTerm logging: aBoolean
  "Private."

  | depList depListClass dl |
  self isInvariant
    ifTrue: [ ^ self ].
  depListClass := DependencyList.
  dl := depListClass for: self.
  dl
    ifNil: [
      "reference counts are negative numbers"
      depList := depListClass new: 2.
      depList _basicAt: 1 put: pathTerm.
      depList _basicAt: 2 put: -1 ]
    ifNotNil: [ depList := dl copyAndAddLastElementPathTerm: pathTerm for: self ].
  depListClass set: (SharedDependencyLists at: depList logging: true) for: self
%

category: 'Indexing Support'
method: Object
getDepListAndAddPathTerm: pathTerm withIVOffset: ivOffset logging: aBoolean
  "Private."

  | depList depListClass dl |
  self isInvariant
    ifTrue: [ ^ self ].
  depListClass := DependencyList.
  dl := depListClass for: self.
  dl
    ifNil: [
      depList := depListClass new: 2.
      depList _basicAt: 1 put: pathTerm.
      depList _basicAt: 2 put: ivOffset ]
    ifNotNil: [ depList := dl copyAndAddPathTerm: pathTerm withIVOffset: ivOffset for: self ].
  depListClass set: (SharedDependencyLists at: depList logging: true) for: self
%

category: 'PetitParser testing'
method: Object
isPetitFailure
	^ false
%

category: 'PetitParser testing'
method: Object
isPetitParser
	^ false
%

category: 'Json'
method: Object
jsonKeys
	"Override this method to specify which instance variables to include.
	Note that calling super is probably not appropriate!"

	^self class allInstVarNames.
%

category: 'Instance Migration'
method: Object
migrateFrom: anotherObject

"Takes information from the given object and puts it in the receiver.
 This message is sent to an object when its class is being migrated to
 another class using migrate, but not when using migrateInstances:to:.
 To customize migration, the method migrateFrom:instVarMap: should be
 reimplemented in subclasses.

 Dynamic instVars in anotherObject preserved by default.

 Note: If the receiver is a kind of Bag or IdentityBag, then the receiver may
 have objects from anotherObject added to it."

^self migrateFrom: anotherObject
      instVarMap: (InstVarMappingArray mappingFrom: anotherObject class to: self class)
%

category: 'Json'
method: Object
printJsonOn: aStream

	| allInstVarNames keys delimiter |
	allInstVarNames := self class allInstVarNames.
	keys := self jsonKeys.
	delimiter := ''.
	aStream nextPut: ${.
	1 to: allInstVarNames size do: [:i |
		| ivarName |
		ivarName := allInstVarNames at: i.
		(keys includes: ivarName) ifTrue: [
			aStream nextPutAll: delimiter.
			ivarName printJsonOn: aStream.
			aStream nextPut: $:.
			(self instVarAt: i) printJsonOn: aStream.
			delimiter := ','.
		].
	].
	aStream nextPut: $}.
%

category: 'Storing and Loading'
method: Object
storeString

"Returns a string that, when evaluated, will recreate a copy of the
 receiver.  The default is to use storeOn: to create the description."

| stream |
stream := AppendStream on: String new .
self storeOn: stream.
^ stream contents
%

category: 'Indexing Support'
method: Object
_addObjectToBtreesWithValues: anArray
  "Adds the receiver to the B-trees of any equality indexes that it participates
   in, using the given Array of index object/value pairs."
  <primitive: 2001>
  | prot |
  prot := System _protectedMode.
  [
    [
      | indexObj vals |
      System _bypassReadAuth.
      1 to: anArray size by: 2 do: [ :i |
        indexObj := anArray at: i.
        vals := anArray at: i + 1.
        1 to: vals size do: [ :j |
          " add an entry to the B-tree "
          indexObj modifiedObject: self userData: (vals at: j) 
        ] 
      ] 
    ] onSynchronous: Error do: [ :ex |
      System disableCommitsWithReason:'error during _addObjectToBtreesWithValues' .
      ex pass 
    ]
  ] ensure: [
    System _exitBypassReadAuth.
    prot _leaveProtectedMode 
  ]
%

category: 'Indexing Support'
method: Object
_addToReferences: anObject offset: offset occurrences: num into: refsToRcvr

"Add anObject and the offset into the Array of references (refsToRcvr)
 if it is not already present."

1 to: refsToRcvr size by: 2 do: [ :i |
  anObject == (refsToRcvr at: i)
    ifTrue: [
      (refsToRcvr at: i + 1) == offset
        ifTrue: [ ^ self ]
    ]
].
num timesRepeat: [
  refsToRcvr add: anObject.
  refsToRcvr add: offset
]
%

category: 'Indexing Support'
method: Object
_changingSizeTo: newSize

"Notifies any modification tracking objects that the receiver (an indexable
 object) is having its size changed. Returns self"
 [ | depList |
   depList := DependencyList for: self.
   1 to: depList size by: 2 do: [ :i |
     (depList at: i + 1) == 0
       ifTrue: [ (depList at: i) changingSizeOfObject: self to: newSize ]
   ].
 ] onSynchronous: Error do: [ :ex |
   System disableCommitsWithReason:'error during _changingSizeTo' .
   ex pass 
 ]
%

category: 'Indexing Support'
method: Object
_deletingAt: offset count: count

"Notifies any modification tracking objects that the receiver (an indexable
 object) is having portions deleted. Returns self"
 [ | depList |
   depList := DependencyList for: self.
   1 to: depList size by: 2 do: [ :i |
     (depList at: i + 1) == 0
       ifTrue: [ (depList at: i) deletingIn: self startingAt: offset count: count ]
   ].
 ] onSynchronous: Error do: [ :ex |
   System disableCommitsWithReason:'error during _deletingAt:count:' .
   ex pass 
 ]
%

category: 'Indexing Support'
method: Object
_doModifyingInstVarAtOffset: anInteger to: newValue depList: depList btreeRemovals: btreeRemovals
  "The instance variable at the given offset is being modified.  Update any
   indexes that depend upon that instance variable.  Collect list of indexes which
   depend directly on the receiver (btreeRemovals). The caller is expected to call
   _addObjectToBtreesWithValues: with the list. Returns an Array.  If the index
   objects were modified correctly, the first slot in array is nil and the
   second slot is the list of btreeRemovals; otherwise the first slot is a boolean
   and the second slot is an exception."

  | i  |
  i := 1.
  [ i <= depList size ]
    whileTrue: [
      | ivOffsetOrReferenceCount |
      ivOffsetOrReferenceCount := depList at: i + 1.
      ivOffsetOrReferenceCount < 0
        ifTrue: [
          | pathTerm indexObj |
          "remove object from the btrees associated with the last element of
           an index path... caller will add receiver back after instance variable is
           updated"
          "bug 42640 ... upgraded reference counts are not an issue"
          pathTerm := depList at: i.
          indexObj := pathTerm at: pathTerm size.
          btreeRemovals add: indexObj.
          btreeRemovals add: (indexObj _removeBtreeEntriesForKey: self) ]
        ifFalse: [
          (ivOffsetOrReferenceCount == anInteger or: [ (depList at: i) coversIvOffset: anInteger for: self ])
            ifTrue: [
              | resultOrErrorArray |
              resultOrErrorArray := (depList at: i)
                update: self
                at: anInteger
                to: newValue.
              resultOrErrorArray == true
                ifFalse: [
                  "error array"
                  btreeRemovals isEmpty
                    ifFalse: [
                      "ensure that error includes information that indexing objects were modified"
                      resultOrErrorArray at: 1 put: true ].
                  ^ resultOrErrorArray ] ] ].
      i := i + 2 ].
  ^ {nil.
  btreeRemovals}
%

category: 'Error Handling'
method: Object
_error: errorSymbol
  "Will be deprecated."
  | errNum cls |
  errNum := ErrorSymbols at: errorSymbol otherwise: 2063 .
  cls := ( (LegacyErrNumMap atOrNil: errNum)
             ifNotNil:[ :mv | mv atOrNil: 1 ] ) ifNil:[ InternalError ].
  ^ cls new _number: errNum; reason: errorSymbol ; args: { self } ; signal
%

category: 'Error Handling'
method: Object
_error: errorSymbol args: argList
  "Will be deprecated."

  | newArgList cls errNum |
  newArgList := { self } .
  newArgList addAll: argList .
  errNum := ErrorSymbols at: errorSymbol otherwise: 2063 .
  cls := ( (LegacyErrNumMap atOrNil: errNum)
             ifNotNil:[ :mv | mv atOrNil: 1 ] ) ifNil:[ InternalError ].
  ^ cls new _number: errNum; reason: errorSymbol ;
                args: newArgList ;  signal
%

category: 'Error Handling'
method: Object
_error: errorSymbol with: argOne
  "Will be deprecated."
  | errNum cls |
  errNum := ErrorSymbols at: errorSymbol otherwise: 2063 .
  cls := ( (LegacyErrNumMap atOrNil: errNum)
             ifNotNil:[ :mv | mv atOrNil: 1 ] ) ifNil:[ InternalError ].
  ^ cls new _number: errNum; reason: errorSymbol ;
		args: { self . argOne } ; signal
%

category: 'Indexing Support'
method: Object
_findIVOffsetForPathTerm: pathTerm
  "Returns the instance variable offset stored in the dependency list that
 corresponds to the given path term.  Returns nil if the path term is not found
 in the dependency list."

  | depList offset |
  (depList := DependencyList for: self)
    ifNil: [
      self isInvariant
        ifTrue: [
          "Bug 42643 - brute force lookup"
          offset := pathTerm _ivOffsetFor: self.
          offset == 0
            ifTrue: [ ^ nil ].
          ^ offset ]
        ifFalse: [ ^ nil ] ].
  offset := depList getInstVarOffsetWithPathTerm: pathTerm.
  offset <= 0
    ifTrue: [ ^ nil ].
  ^ offset
%

category: 'Indexing Support'
method: Object
_getIndexReferencesInto: refsToRcvr
  "Place information about references to the receiver due to the receiver's
 participation in an index into the given Array.  The Array consists of pairs:

 1) An object that references the receiver.  If the object is directly
    contained in an indexed NSC, then this object is the NSC.  If the object
    in the dependency list is a tracking object (for object modification
    tracking), then this object is the tracking object.
 2) The offset of the instance variable in that object that references the
    receiver.
 3) If the object is the last path term, this number is < 0 and is a reference
    count for the number of times .
 3) If the object in the dependency list is a tracking
    object, this number is 0.

 This is used only in support of the 'become:' method."

  | depList pathTerm |
  depList := DependencyList for: self.
  depList ifNil: [ ^ refsToRcvr ].
  1 to: depList size by: 2 do: [ :i |
    (depList at: i + 1) ~~ 0
      ifTrue: [
        pathTerm := depList at: i.
        pathTerm _getPathTermIndexReferencesInto: refsToRcvr for: self ]
      ifFalse: [
        " it is a tracking object "
        refsToRcvr add: (depList at: i).
        refsToRcvr add: -1 ] ].
  ^ refsToRcvr
%

category: 'Indexing Support'
method: Object
_hasDependencyList

"Returns true if the receiver participates in an index, and false otherwise."

| result |
result := (DependencyList for: self) ~~ nil.
^ result
%

category: 'Indexing Support'
method: Object
_idxBasicPlusCanCompareWithClass: aClass
  "Returns true if the receiver may be inserted into a basic BtreePlusNode whose
   #lastElementClass is <aClass> (see GsRangeEqualityIndex class>>isBasicClass:)."

  "For now the rules are the same for BtreePlusNode and BtreeNode"

 ^ self _idxBasicCanCompareWithClass: aClass
%

category: 'New Indexing Comparison - for Compare'
method: Object
_idxForCompareEqualToCharacterCollection: aCharacterCollection
  "second half of a double dispatch call from CharacterCollection>>_idxForCompareEqualTo:."

  ^ false
%

category: 'New Indexing Comparison'
method: Object
_idxForCompareEqualToUnicode: aUnicodeString collator: anIcuCollator

"second half of a double dispatch call from CharacterCollection>>_idxForCompareEqualTo:collator:."

  ^ false
%

category: 'New Indexing Comparison'
method: Object
_idxForCompareGreaterThanOrEqualToUnicode: aUnicodeString collator: anIcuCollator

"second half of a double dispatch call from CharacterCollection>>_idxForCompareGreaterThanOrEqualTo:collator:. Note that aUnicodeString should be the receiver in any >= comparison"

  ^ false
%

category: 'New Indexing Comparison'
method: Object
_idxForCompareGreaterThanUnicode: aUnicodeString collator: anIcuCollator

"second half of a double dispatch call from CharacterCollection>>_idxForCompareGreaterThan:collator:. Note that aUnicodeString should be the receiver in any > comparison"

  ^ false
%

category: 'New Indexing Comparison'
method: Object
_idxForCompareLessThanOrEqualToUnicode: aUnicodeString collator: anIcuCollator

"second half of a double dispatch call from CharacterCollection>>_idxForCompareLessThanOrEqualTo:collator:. Note that aUnicodeString should be the receiver in any <= comparison"

  ^ false
%

category: 'New Indexing Comparison'
method: Object
_idxForCompareLessThanUnicode: aUnicodeString collator: anIcuCollator

"second half of a double dispatch call from CharacterCollection>>_idxForCompareLessThan:collator:. Note that aUnicodeString should be the receiver in any < comparison"

  ^ false
%

category: 'New Indexing Comparison'
method: Object
_idxForSortEqualToCharacterCollection: aCharacterCollection collator: anIcuCollator
  "second half of a double dispatch call from CharacterCollection>>_idxForSortEqualTo:collator:."

  ^ false
%

category: 'New Indexing Comparison - for Compare'
method: Object
_idxForSortEqualToSymbol: aSymbol
  "second half of a double dispatch call from Symbol>>_idxForSortEqualTo:."

  ^ false
%

category: 'New Indexing Comparison'
method: Object
_idxForSortGreaterThanCharacterCollection: aCharacterCollection collator: anIcuCollator
  "second half of a double dispatch call from CharacterCollection>>_idxForSortGreaterThan:collator:. Note that aCharacterCollection should be the receiver in any > comparison"

  ^ aCharacterCollection _classSortsGreaterThan: self
%

category: 'New Indexing Comparison'
method: Object
_idxForSortGreaterThanOrEqualToCharacterCollection: aCharacterCollection collator: anIcuCollator
  "second half of a double dispatch call from CharacterCollection>>_idxForSortGreaterThanOrEqualTo:collator:. Note that aCharacterCollection should be the receiver in any >= comparison"

  ^ aCharacterCollection _classSortsGreaterThan: self
%

category: 'New Indexing Comparison'
method: Object
_idxForSortLessThanCharacterCollection: aCharacterCollection collator: anIcuCollator
  "second half of a double dispatch call from CharacterCollection>>_idxForSortLessThan:collator:. Note that aCharacterCollection should be the receiver in any < comparison"

  ^ aCharacterCollection _classSortsLessThan: self
%

category: 'New Indexing Comparison'
method: Object
_idxForSortLessThanOrEqualToCharacterCollection: aCharacterCollection collator: anIcuCollator
  "second half of a double dispatch call from CharacterCollection>>_idxForSortLessThanOrEqualTo:collator:. Note that aCharacterCollection should be the receiver in any <= comparison"

  ^ aCharacterCollection _classSortsLessThan: self
%

category: 'Indexing Support'
method: Object
_idxOptimizedCompareWithClass: aClass
  "Returns true if the receiver may be inserted into a BtreePlusNode whose
   #lastElementClass is <aClass> and whose comparisons are optimized."

  "Sent when index option optimizeComparison is true and aClass responds trut to #_idxCanOptimizeComparison"

  ^ false
%

category: 'Indexing Support'
method: Object
_idxValue

	^self
%

category: 'Indexing Support'
method: Object
_indexParticipationInfo

"Returns an Array of pairs: the root NSC and the path String that describes
 the path traversed from the root to reach the receiver."

^ self _indexParticipationInfoInto: { } .
%

category: 'Indexing Support'
method: Object
_indexParticipationInfoInto: array
  "Returns an Array of pairs: the root NSC and the path String that describes
 the path traversed from the root to reach the receiver."

  | depList pathTerm indexObj pathString included |
  depList := DependencyList for: self.
  1 to: depList size by: 2 do: [ :i |
    (depList at: i + 1) ~~ 0
      ifTrue: [
        pathTerm := depList at: i.
        1 to: pathTerm size do: [ :j |
          indexObj := pathTerm at: j.
          pathString := indexObj
            _partialPathComponentsStringUpTo: pathTerm offset.
          included := false.
          1 to: array size by: 2 do: [ :k |
            ((array at: k) == indexObj nscRoot and: [ (array at: k + 1) = pathString ])
              ifTrue: [ included := true ] ].
          included
            ifFalse: [
              array add: indexObj nscRoot.
              array add: pathString ] ] ] ].
  ^ array
%

category: 'Indexing Support'
method: Object
_inserting: indexableObj at: offset insertSize: aSize

"Notifies any modification tracking objects that the receiver (an indexable
 object) is having portions inserted. Returns self"
 [ | depList |
   depList := DependencyList for: self.
   1 to: depList size by: 2 do: [ :i |
     (depList at: i + 1) == 0
       ifTrue: [ (depList at: i) inserting: indexableObj into: self at: offset
				   insertSize: aSize
         ].
   ].
 ] onSynchronous: Error do: [ :ex |
   System disableCommitsWithReason:'error during _inserting:at:insertSize:' .
   ex pass 
 ]
%

category: 'Testing'
method: Object
_literalEqual: anotherLiteral
  "For two literals to be _literalEqual, their class must be identical and
   otherwise equal"

  ^ self class == anotherLiteral class and: [ self = anotherLiteral ]
%

category: 'Indexing Support'
method: Object
_modifyingByteObjectStartingAt: startPt withNewValue: newValue
  "The byte object is being changed.  Update any indexes that depend upon the byte object.
   Returns nil or an Array of btree removals or signals an error.
   Called from C code in VM ; 
   that C code then calls Object >> _addObjectToBtreesWithValues: with removals as arg.
 "
 ^ [
  | depList inIndex removals |
   self class isBytes ifTrue:[
     depList := DependencyList for: self.
     depList ifNotNil:[
       inIndex := false.
       1 to: depList size by: 2 do: [ :i |
         (depList at: i + 1) ~~ 0
           ifTrue: [ inIndex := true ]
           ifFalse: [
             " modification tracker "
             (depList at: i)
               modifyingByteObject: self
               startingAt: startPt
               withNewValue: newValue ] 
       ].
       inIndex ifTrue:[
         removals := self _removeObjectFromBtrees	
       ].
     ].
   ].
   removals
 ] onSynchronous: Error do: [ :ex |
   System disableCommitsWithReason:'error during _modifyingByteObject' .
   ex pass 
 ]
%

category: 'Indexing Support'
method: Object
_modifyingInstVarAtOffset: anInteger to: newValue
  "The instance variable at the given offset is being modified.  Update any
   indexes that depend upon that instance variable.  Collect list of indexes which
   depend directly on the receiver (btreeRemovals). The caller is expected to call
   _addObjectToBtreesWithValues: with the list. 
   Returns nil or an Array of btree removals or signals an Error.
   Called from C code in VM ;
   that C code then calls Object >> _addObjectToBtreesWithValues: with removals as arg.
 "
 <primitive: 2001>
 | prot |
 prot := System _protectedMode.
 ^ [
    [ | depList inIndex btreeRemovals |
     inIndex := false.
     depList := DependencyList for: self.	" first handle modification tracking "
     depList ifNotNil:[
       btreeRemovals := { } . 
       1 to: depList size by: 2 do: [ :i |
        (depList at: i + 1) ~~ 0
          ifTrue: [ inIndex := true ]
          ifFalse: [
            anInteger >= self class firstPublicInstVar
              ifTrue: [
                btreeRemovals add: (depList at: i).
                btreeRemovals add:
                    ((depList at: i) aboutToModifyObject: self atOffset: anInteger to: newValue) 
              ]
          ]
       ].
       inIndex ifTrue:[
         System _bypassReadAuth.
          self _doModifyingInstVarAtOffset: anInteger to: newValue depList: depList 
                 btreeRemovals: btreeRemovals 
       ] .
     ].
     btreeRemovals
    ] onSynchronous: Error do: [ :ex |
      System disableCommitsWithReason:'error during _modifyingInstVar' .
      ex pass 
    ]
  ] ensure: [
    System _exitBypassReadAuth.
    prot _leaveProtectedMode .
  ]
%

category: 'Testing'
method: Object
_refersToLiteral: literal
  "Answer true if literal is identical to any literal in receiver, even if imbedded
   in further structures.
   Object is the end of the imbedded structure path so return false."

  ^ false
%

category: 'Indexing Support'
method: Object
_removeIndexParticipation: refs for: oldObject

"Private."
[
  | obj offset |
  1 to: refs size by: 2 do: [ :i |
	obj := refs at: i.
	offset := refs at: i + 1.
	offset == 0
	  ifTrue: [ " remove self from the NSC with indexes "
		obj remove: self
	  ]
	  ifFalse: [
		offset > 0
		  ifTrue: [ " it is not a tracking object "
			" set the instance variable reference to nil "
			obj instVarAt: offset put: nil
		  ]
		  ifFalse: [ " it is a tracking object "
			" send tracking msg first so if error is raise, we haven't
			cleared mod tracking yet "
			obj invokingBecomeOn: self to: oldObject.
			self _clearModificationTrackingTo: obj.
		  ]
	  ]
  ].
] onSynchronous: Error do:[: ex |
  System disableCommitsWithReason:'error during Object>>_removeIndexParticipation:for:'.
  ex pass .
]
%

category: 'Indexing Support'
method: Object
_removeObjectFromBtrees

"Removes the receiver from the B-trees of any equality indexes that it
 participates in.  
 Returns nil or an Array of index object/value pairs, or signals an Error."
  <primitive: 2001>
  | prot |
  prot := System _protectedMode .
 ^ [
    [ | depList removals |
    depList := DependencyList for: self.
    depList ifNotNil:[
      System _bypassReadAuth .
      removals := { } .
      " iterate through each path term dependent upon this object "
      1 to: depList size by: 2 do: [ :i |
        (depList at: i + 1) ~~ 0 ifTrue: [ | pathTerm |
		      pathTerm := depList at: i.
		      " for each index utilizing this path term "
		      1 to: pathTerm size do: [ :j | | indexObj |
	          indexObj := pathTerm at: j.
	          " add the equality index to the answer "
	          removals add: indexObj.
	          " remove the B-tree entries and get the corresponding values "
	          removals add: (indexObj _removeBtreeEntriesForKey: self)
		      ]
	      ]
      ].
    ].
    removals
   ] onSynchronous: Error do: [ :ex |
     System disableCommitsWithReason:'error during _removeObjectFromBtrees' .
    ex pass 
   ]
  ] ensure: [
    System _exitBypassReadAuth .
    prot _leaveProtectedMode
  ].
%

category: 'Indexing Support'
method: Object
_restoreIndexParticipation: refs

"Private."
[ | obj offset |
  1 to: refs size by: 2 do: [ :i |
	obj := refs at: i.
	offset := refs at: i + 1.
	offset == 0
	  ifTrue: [ " add self back to the NSC " obj add: self.  ] 
    ifFalse: [
		  offset == -1 ifTrue: [ " it is a tracking object "
			   self _setModificationTrackingTo: obj.
		    ] ifFalse: [ " add self back to the NSC "
			    obj instVarAt: offset put: self
		    ]
	   ]
  ].
] onSynchronous: Error do:[: ex |
  System disableCommitsWithReason:'error during _restoreIndexParticipation' .
  ex pass 
]
%

! Class extensions for 'RcCollisionBucket'

!		Instance methods for 'RcCollisionBucket'

category: 'Updating'
method: RcCollisionBucket
at: aKey put: aValue

"Stores the aKey/aValue pair in the RcCollisionBucket.  If the key already
 exists, returns the old value, otherwise, returns nil.

 If the key already exists and the old value is identically aValue,
 does not write the receiver."

| emptySlotIndex startTableSize thisKey oldVal |
startTableSize := self tableSize .
aKey ifNil:[ ^ self _error: #rtErrNilKey ].

" search for aKey, or for the first empty slot "
1 to: startTableSize do: [ :index | | valIdx |
  valIdx := index + index .
  thisKey := self _at: (valIdx - 1) . "inline keyAt:"
  ( nil == emptySlotIndex and: [ nil == thisKey ] ) ifTrue:[
     emptySlotIndex := index
  ] ifFalse: [
    (self compareKey: aKey with: thisKey) ifTrue:[
       "Key found.  Store given value"
	oldVal := self _at: valIdx .  "inline valueAt:"
	oldVal == aValue ifFalse:[
	  self _rcAt: valIdx  .  "put path to value slot in rcReadSet"
	  self at: index putValue: aValue.
	].
	^ oldVal
     ]
  ]
] .

" key not found so add key and value"
emptySlotIndex ifNil:[
   " bucket is full so grow it "
   self size: (self _basicSize + 8 ) . "accommodate 4 more key,value pairs"
   emptySlotIndex := startTableSize + 1 .
] .
self _rcAt:( emptySlotIndex * 2) .  "put path to emptySlot in rcReadSet"
self _addNamedIvsToRcRead .  "for update of numElements"
numElements := numElements + 1.
self at: emptySlotIndex putKey: aKey.
self at: emptySlotIndex putValue: aValue.
^ nil
%

category: 'Accessing'
method: RcCollisionBucket
keyAt: index

"Returns the key at the specified index."

^ self _at: (index + index - 1)
%

category: 'Updating'
method: RcCollisionBucket
removeKey: aKey ifAbsent: aBlock
  "Removes the key/value pair with key aKey from the receiver and returns the
   value.  If no key/value pair is present with key aKey, evaluates the
   zero-argument block aBlock and returns the result of that evaluation."

| startTableSize |
startTableSize := self tableSize .
aKey ifNil:[ ^ self _error: #rtErrNilKey ].

1 to: startTableSize do: [ :index | | valIdx thisKey |
  valIdx := index + index .
  thisKey := self _at: (valIdx - 1) . "inline keyAt:"
  thisKey ifNotNil:[
    (self compareKey: aKey with: thisKey) ifTrue:[ "Key found"  | aValue |
       aValue := self _rcAt: valIdx . "add path to value to rcReadSet"
       self _at: valIdx - 1  put: nil.
       self _at: valIdx put: nil.
       self _addNamedIvsToRcRead .  "for update of numElements"
       numElements := numElements - 1.
       ^ aValue
     ]
  ]
] .
aBlock ifNil:[ ^ self _errorKeyNotFound: aKey ] .
^ aBlock value
%

category: 'Updating'
method: RcCollisionBucket
reset

  "Reset all entries to nil and the number of elements to zero.
   called from RcKeyValueDictionary >> _gciInitialize, not RC "
  self _deleteNoShrinkFrom: 1 to: self _basicSize.
  numElements := 0.
%

category: 'Accessing'
method: RcCollisionBucket
valueAt: index

"Returns the value at the specified index."

^ self _at: (index + index)
%

category: 'Private'
method: RcCollisionBucket
_addToWriteSet

"Make a benign modification to the receiver so that it is placed in
 the write set."

numElements := numElements
%

category: 'Updating'
method: RcCollisionBucket
_replayRemoveKey: aKey
"Removes the aKey/someValue pair from receiver.  
 returns nil if aKey found, false otherwise. "

| startTableSize thisKey |
startTableSize := self tableSize .
aKey ifNil:[ ^ self _error: #rtErrNilKey ].

" search for aKey, or for the first empty slot "
1 to: startTableSize do: [ :index | | valIdx |
  valIdx := index + index .
  thisKey := self _at: (valIdx - 1) . "inline keyAt:"
  thisKey ifNotNil:[
    (self compareKey: aKey with: thisKey) ifTrue:[ "Key found"
       self _at: valIdx - 1  put: nil.
       self _at: valIdx put: nil.
       numElements := numElements - 1.
       ^ true
     ]
  ]
] .
^ false
%

! Class extensions for 'ScaledDecimal'

!		Class methods for 'ScaledDecimal'

removeallmethods ScaledDecimal
removeallclassmethods ScaledDecimal

category: 'Instance Creation'
classmethod: ScaledDecimal
for: aNumber scale: s
	"Returns an instance of the receiver, having the specified scale
 and value as close to aNumber as that scale allows."

	| m |
	s _isSmallInteger ifFalse: [s _validateClass: SmallInteger].
	s > MaxScale
		ifTrue:
			[(OutOfRange new)
				name: '' max: MaxScale actual: s;
				details: 'invalid scale';
				signal].
	m := (aNumber * (10 raisedToInteger: s)) roundedHalfToEven.
	^ self mantissa: m scale: s 
%

category: 'Instance Creation'
classmethod: ScaledDecimal
fromString: aString

"Given aString such as '34.23', returns an instance of the receiver with
 appropriate numerator and denominator, and with scale equal to the number
 of digits to the right of the decimal point.  Characters in aString after
 the first character which is neither a digit or decimal point are ignored.
 Signals an OutOfRange if the scale of the result would exceed 30000.
 The session's locale state is used for the expected decimal point."

^ self _fromString: aString decimalPoint: nil
%

category: 'Instance Creation'
classmethod: ScaledDecimal
fromStringLocaleC: aString
"Given aString such as '34.23', returns an instance of the receiver with
 appropriate numerator and denominator, and with scale equal to the number
 of digits to the right of the decimal point.  Characters in aString after
 the first character which is neither a digit or decimal point are ignored.
 Signals an OutOfRange if the scale of the result would exceed 30000.
 The expected decimal point character is $.  "

^ self _fromString: aString decimalPoint: $.
%

category: 'Storing and Loading'
classmethod: ScaledDecimal
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object.  Converts the object to
 its active form by loading the information into a new instance of the receiver.
 Returns the new instance."

| inst m sc |
inst := self _basicNew .
passiveObj hasRead: inst .
passiveObj readNamedIV.
m := passiveObj ivValue.
passiveObj readNamedIV.
sc := passiveObj ivValue.
passiveObj skipNamedInstVars.
inst  _mantissa: m scale: sc ; immediateInvariant .
^ inst
%

category: 'Instance Creation'
classmethod: ScaledDecimal
mantissa: m scale: s
 "if primitive succeeds, returns a SmallScaledDecimal"
 <primitive: 1116>
 "primitive failed, return a ScaledDecimal"
 ^ (self basicNew _mantissa: m scale: s) immediateInvariant
%

category: 'Private'
classmethod: ScaledDecimal
new

self shouldNotImplement: #new .
^ nil
%

category: 'Compatibility'
classmethod: ScaledDecimal
numerator: numer denominator: denom scale: scale

"Returns an instance of ScaledDecimal.
 Signals an OutOfRange if the argument scale > 30000.  "
 | n d m |
 denom = 0 ifTrue: [ ^ numer   _errorDivideByZero ].
 scale _isSmallInteger ifFalse: [ scale _validateClass: SmallInteger ].
(scale < 0 or: [scale > MaxScale])
	ifTrue:
		[(OutOfRange new)
			name: 'scale' min: 0 max: MaxScale actual: scale;
      details: 'invalid scale';
			signal].
 n := numer .
 d := denom .
 d < 0 ifTrue:[  d := 0 - d . n := 0 - n ] .
 m := ( (n * (10 raisedToInteger: scale )) / d ) roundedHalfToEven .
 ^ self mantissa: m scale: scale 
%

category: 'Instance Creation'
classmethod: ScaledDecimal
_fromString: aString decimalPoint: dp

"Given aString such as '34.23', returns an instance of the receiver with
 appropriate numerator and denominator, and with scale equal to the number
 of digits to the right of the decimal point.  Characters in aString after
 the first character which is neither a digit or decimal point are ignored.
 Signals an OutOfRange if the scale of the result would exceed 30000.
 The specified specified decimal point character is used ,
 if dp == nil, the session's locale state is used."

<primitive: 1115>
aString _validateClasses:{ String }.
dp ifNotNil:[ dp _validateClass: Character ].
self _errIncorrectFormat: aString .
self _primitiveFailed: #_fromString:decimalPoint: args: { aString . dp } .
%

category: 'Private'
classmethod: ScaledDecimal
__mantissa: m scale: s
 "for testing of passivate/activate, returns a ScaledDecimal."
 ^ (self _basicNew _mantissa: m scale: s) immediateInvariant
%

!		Instance methods for 'ScaledDecimal'

category: 'Arithmetic'
method: ScaledDecimal
* aNumber
  "Returns the result of multiplying the receiver by aNumber.
   If aNumber is an Integer or a ScaledDecimal, the result will be
   an instance of the receiver's class with a scale equal to
   the greater of the receiver's scale and aNumber's scale.
   The scale of an Integer is considered to be zero."

| osc om |
aNumber _isScaledDecimal
	ifTrue:
		[om := aNumber mantissa.
		osc := aNumber scale]
	ifFalse:
		[aNumber _isInteger
			ifTrue:
				[om := aNumber.
				osc := 0]].
om
	ifNotNil:
		[| m pten resultScale excessScale myScale |
		m := self mantissa * om.
		resultScale := (myScale := self scale) max: osc.
		excessScale := myScale + osc - resultScale.
		excessScale > 0
			ifTrue:
				["reduce mantissa to match result scale"
				pten := 10 raisedTo: excessScale.
				m := (m / pten) roundedHalfToEven].
		^self class mantissa: m scale: resultScale].
^self _retry: #* coercing: aNumber
%

category: 'Arithmetic'
method: ScaledDecimal
+ aNumber
  "Returns the sum of the receiver and aNumber.
   If aNumber is an Integer or a ScaledDecimal, the result will be
   an instance of the receiver's class with a scale equal to
   the greater of the receiver's scale and aNumber's scale.
   The scale of an Integer is considered to be zero."

| m sc |
aNumber _isScaledDecimal
	ifTrue:
		[| osc pten myScale |
		osc := aNumber scale.
		(myScale := self scale) == osc
			ifTrue:
				[sc := myScale.
				 m := self mantissa + aNumber mantissa]
			ifFalse:
				[sc := myScale max: osc.
				sc > myScale
					ifTrue:
						[pten := 10 raisedToInteger: sc - myScale.
						m := self mantissa * pten + aNumber mantissa]
					ifFalse:
						[pten := 10 raisedToInteger: sc - osc.
						m := self mantissa + (pten * aNumber mantissa)]].
		^self class mantissa: m scale: sc].
aNumber _isInteger
	ifTrue:
		[ | myScale |
      m := self mantissa + (aNumber * (10 raisedToInteger: (myScale := self scale))).
		  ^ self class mantissa: m scale: myScale].
^self _retry: #+ coercing: aNumber
%

category: 'Arithmetic'
method: ScaledDecimal
- aNumber
  "Returns the difference between the receiver and aNumber.
   If aNumber is an Integer or a ScaledDecimal, the result will be
   an instance of the receiver's class with a scale equal to
   the greater of the receiver's scale and aNumber's scale.
   The scale of an Integer is considered to be zero."

aNumber _isScaledDecimal
	ifTrue:
		[^self
			+ (ScaledDecimal mantissa: 0 - aNumber mantissa scale: aNumber scale)].
^self + (0 - aNumber)
%

category: 'Arithmetic'
method: ScaledDecimal
/ aNumber
  "Returns the result of dividing the receiver by aNumber.
   If aNumber is an Integer or a ScaledDecimal, the result will be
   an instance of the receiver's class with a scale equal to
   the greater of the receiver's scale and aNumber's scale.
   The scale of an Integer is considered to be zero."

| divisorScale om |
aNumber _isScaledDecimal
	ifTrue:
		[om := aNumber mantissa.
		divisorScale := aNumber scale]
	ifFalse:
		[aNumber _isInteger
			ifTrue:
				[om := aNumber.
				divisorScale := 0]].
om
	ifNotNil:
		[| resultScale adjustFactor m myScale |
		om == 0 ifTrue: [^self _errorDivideByZero].
		resultScale := (myScale := self scale) max: divisorScale.
		adjustFactor := 10 raisedToInteger: divisorScale - myScale + resultScale.
		m := (self mantissa / om * adjustFactor) roundedHalfToEven.
		^self class mantissa: m scale: resultScale].
^self _retry: #/ coercing: aNumber
%

category: 'Arithmetic'
method: ScaledDecimal
// aNumber
  "Returns an integer that is the result of dividing the receiver by aNumber,
   then rounding towards negative infinity."

| divisorScale om |
aNumber _isScaledDecimal
	ifTrue:
		[om := aNumber mantissa.
		divisorScale := aNumber scale]
	ifFalse:
		[aNumber _isInteger
			ifTrue:
				[om := aNumber.
				divisorScale := 0]].
om
	ifNotNil:
		[| exactResult |
		om == 0 ifTrue: [^self _errorDivideByZero].
		exactResult := self mantissa / om * (10 raisedToInteger: divisorScale - self scale).
		^ exactResult floor].
^self _retry: #// coercing: aNumber
%

category: 'Comparing'
method: ScaledDecimal
< aNumber
	| sk osc om m |
	(aNumber _isNumber or: [ aNumber isNumber ])
		ifFalse: [ ^ ArgumentTypeError signal: 'Expected a Number' ].
	sk := self _getKind.
	sk > 4
		ifTrue: [ ^ false ].	"NaN"
	m := self mantissa.
	aNumber _isScaledDecimal
		ifTrue: [ 
			osc := aNumber scale.
			om := aNumber mantissa.
			om ifNil: [ ^ false ] ]
		ifFalse: [ 
			aNumber _isInteger
				ifTrue: [ 
					osc := 0.
					om := aNumber ] ].
	om
		ifNotNil: [ 
			| sc |
			sc := self scale.
			sc == osc
				ifFalse: [ 
					sc > osc
						ifTrue: [ om := om * (10 raisedTo: sc - osc) ]
						ifFalse: [ m := m * (10 raisedTo: osc - sc) ] ].
			^ m < om ].
	^ (AbstractFraction _coerce: self) < aNumber
%

category: 'Comparing'
method: ScaledDecimal
<= aNumber
	| sk osc om m |
	(aNumber _isNumber or: [ aNumber isNumber ])
		ifFalse: [ ^ ArgumentTypeError signal: 'Expected a Number' ].
	sk := self _getKind.
	sk > 4
		ifTrue: [ ^ false ].	"NaN"
	m := self mantissa.
	aNumber _isScaledDecimal
		ifTrue: [ 
			osc := aNumber scale.
			om := aNumber mantissa.
			om ifNil: [ ^ false ] ]
		ifFalse: [ 
			aNumber _isInteger
				ifTrue: [ 
					osc := 0.
					om := aNumber ] ].
	om
		ifNotNil: [ 
			| sc |
			sc := self scale.
			sc == osc
				ifFalse: [ 
					sc > osc
						ifTrue: [ om := om * (10 raisedTo: sc - osc) ]
						ifFalse: [ m := m * (10 raisedTo: osc - sc) ] ].
			^ m <= om ].
	^ (AbstractFraction _coerce: self) <= aNumber
%

category: 'Comparing'
method: ScaledDecimal
= aNumber
	| osc om m |
	self == aNumber
		ifTrue: [ ^ true ].
	(aNumber _isNumber or: [ aNumber isNumber ])
		ifFalse: [ ^ false ].
	(m := self mantissa) ifNil: [ ^ false	"self is a NaN" ].
	aNumber _isScaledDecimal
		ifTrue: [ 
			osc := aNumber scale.
			om := aNumber mantissa.
			om ifNil: [ ^ false ] ]
		ifFalse: [ 
			aNumber _isInteger
				ifTrue: [ 
					osc := 0.
					om := aNumber ] ].
	om
		ifNotNil: [ 
			| sc |
			sc := self scale.
			sc == osc
				ifFalse: [ 
					sc > osc
						ifTrue: [ om := om * (10 raisedTo: sc - osc) ]
						ifFalse: [ m := m * (10 raisedTo: osc - sc) ] ].
			^ m = om ].
	^ (AbstractFraction _coerce: self) = aNumber
%

category: 'Comparing'
method: ScaledDecimal
> aNumber
	| sk osc om m |
	(aNumber _isNumber or: [ aNumber isNumber ])
		ifFalse: [ ^ ArgumentTypeError signal: 'Expected a Number' ].
	sk := self _getKind.
	sk > 4
		ifTrue: [ ^ false ].	"NaN"
	m := self mantissa.
	aNumber _isScaledDecimal
		ifTrue: [ 
			osc := aNumber scale.
			om := aNumber mantissa.
			om ifNil: [ ^ false ] ]
		ifFalse: [ 
			aNumber _isInteger
				ifTrue: [ 
					osc := 0.
					om := aNumber ] ].
	om
		ifNotNil: [ 
			| sc |
			sc := self scale.
			sc == osc
				ifFalse: [ 
					sc > osc
						ifTrue: [ om := om * (10 raisedTo: sc - osc) ]
						ifFalse: [ m := m * (10 raisedTo: osc - sc) ] ].
			^ m > om ].
	^ (AbstractFraction _coerce: self) > aNumber
%

category: 'Comparing'
method: ScaledDecimal
>= aNumber
	| sk osc om m |
	(aNumber _isNumber or: [ aNumber isNumber ])
		ifFalse: [ ^ ArgumentTypeError signal: 'Expected a Number' ].
	sk := self _getKind.
	sk > 4
		ifTrue: [ ^ false ].	"NaN"
	m := self mantissa.
	aNumber _isScaledDecimal
		ifTrue: [ 
			osc := aNumber scale.
			om := aNumber mantissa.
			om ifNil: [ ^ false ] ]
		ifFalse: [ 
			aNumber _isInteger
				ifTrue: [ 
					osc := 0.
					om := aNumber ] ].
	om
		ifNotNil: [ 
			| sc |
			sc := self scale.
			sc == osc
				ifFalse: [ 
					sc > osc
						ifTrue: [ om := om * (10 raisedTo: sc - osc) ]
						ifFalse: [ m := m * (10 raisedTo: osc - sc) ] ].
			^ m >= om ].
	^ (AbstractFraction _coerce: self) >= aNumber
%

category: 'Converting'
method: ScaledDecimal
asCanonicalForm
	"Answer self, or, if I am a ScaledDecimal with an equivalent
	SmallScaledDecimal, answer that SmallScaledDecimal."

	| cls res |
	(cls := self class) ~~ SmallScaledDecimal
		ifTrue: [ 
			cls == ScaledDecimal
				ifTrue: [ 
					res := cls mantissa: self mantissa scale: self scale.
					res class == SmallScaledDecimal
						ifTrue: [ ^ res ] ] ].
	^ self
%

category: 'Converting'
method: ScaledDecimal
asDecimalFloat
	"Answer an instance of DecimalFloat that has a numeric value as close
	as possible to the value of the receiver, rounding if necessary"
	"DecimalFloats have a 20-decimal-digit precision, so the basic approach is to round the mantissa to 20 digits and then scale. In cases where the result should be a subnormal float, however, the 20-digit precision includes the leading zeroes, so we must round the mantissa to fewer than 20 digits. "

	| m mantissaDigits roundedMantissaDigits excessMantissaDigits roundedMantissa adjustmentPower 
    myScale |
	mantissaDigits := (m := self mantissa) _decimalDigitsLength: false.
	roundedMantissaDigits := mantissaDigits - (myScale := self scale) + 15019 min: 20.
	excessMantissaDigits := mantissaDigits - roundedMantissaDigits max: 0.
	roundedMantissa := (m / (10 raisedToInteger: excessMantissaDigits)) roundedHalfToEven.
	adjustmentPower := excessMantissaDigits - myScale.
	"DecimalFloats with very small magnitude must be computed a bit more indirectly to avoid underflow to 0."
	^adjustmentPower < -15000
		ifFalse: [roundedMantissa asDecimalFloat * (10.0f0 raisedToInteger: adjustmentPower)]
		ifTrue: [roundedMantissa asDecimalFloat / 1.0f20 * (10.0f0 raisedToInteger: adjustmentPower + 20)]
%

category: 'Converting'
method: ScaledDecimal
asFloat
	"Answer a Float that closely approximates the value of the receiver.
	This implementation will answer the closest floating point number to the receiver.
	In case of a tie, it will use the IEEE 754 round to nearest even mode.
	In case of overflow, it will answer +/- Float infinity."

	^ self asFraction asFloat
%

category: 'Converting'
method: ScaledDecimal
asFraction

"Returns a Fraction that represents the receiver."

^ Fraction numerator: self mantissa denominator: (10 raisedTo: self scale)
%

category: 'Converting'
method: ScaledDecimal
asScaledDecimal: newScale
"Returns a new instance with the new scale, and a numeric value
 as close to that of the receiver as possible."

| pten m myScale |
(myScale := self scale) == newScale ifTrue: [^self].
newScale _isSmallInteger ifFalse: [newScale _validateClass: SmallInteger].
(newScale < 0 or: [newScale > MaxScale])
	ifTrue:
		[(OutOfRange new)
			name: 'scale' min: 0 max: MaxScale actual: newScale;
      details: 'invalid scale';
			signal].
pten := 10 raisedToInteger: (myScale - newScale) abs.
myScale < newScale
	ifTrue: [m := self mantissa * pten]
	ifFalse: [m := (self mantissa / pten) roundedHalfToEven].
^self class mantissa: m scale: newScale
%

category: 'Formatting'
method: ScaledDecimal
asString
  "Returns a String of the form '123.56 for a number with scale = 2  ,
   where the decimal point character in the result is per the current Locale."

  ^ self _asString: Locale decimalPoint
%

category: 'Formatting'
method: ScaledDecimal
asStringLocaleC

  "Returns a String of the form '123.56 for a number with scale = 2.
   Does not use Locale , decimal point character is always $.  "

  ^ self _asString: $.
%

category: 'Truncation and Rounding'
method: ScaledDecimal
ceiling

"Returns the integer that is closest to the receiver, on the same side
 of the receiver as positive infinity."

 | f |
 f := self floor.
^ self = f
	ifTrue: [f]
	ifFalse: [f + 1]
%

category: 'Compatibility'
method: ScaledDecimal
denominator
  ^ self asFraction denominator
%

category: 'Testing'
method: ScaledDecimal
even

"Returns true if the receiver is an even integer, false otherwise."
| frac intPart m sc |
m := self mantissa .
(sc := self scale) == 0 ifTrue:[ ^ m even ].
sc := 10 raisedTo: sc .
intPart := m // sc .
frac := m - (intPart * sc) .
frac ~~ 0 ifTrue:[ ^ false ] .
^ intPart even
%

category: 'Truncation and Rounding'
method: ScaledDecimal
floor
"Returns the integer that is closest to the receiver, on the same side
 of the receiver as negative infinity."

^ self mantissa // (10 raisedTo: self scale)
%

category: 'Comparing'
method: ScaledDecimal
hash

^ self asFloat hash
%

category: 'Truncation and Rounding'
method: ScaledDecimal
integerPart
  ^ self class for: self truncated scale:  self scale
%

category: 'Testing'
method: ScaledDecimal
isZero

"Returns true if the receiver is zero."

^ self mantissa == 0 .
%

category: 'Accessing'
method: ScaledDecimal
mantissa

^ mantissa
%

category: 'Arithmetic'
method: ScaledDecimal
negated
  "Returns 0 minus self. Result has same scale as receiver. "
^ self class mantissa: 0 - self mantissa scale: self scale
%

category: 'Compatibility'
method: ScaledDecimal
numerator
  ^ self asFraction numerator
%

category: 'Testing'
method: ScaledDecimal
odd

"Returns true if the receiver is an odd integer, false otherwise."

| frac intPart m sc |
m := self mantissa .
(sc := self scale) == 0 ifTrue:[ ^ m odd ].
sc := 10 raisedTo: sc .
intPart := m // sc .
frac := m - (intPart * sc) .
frac ~~ 0 ifTrue:[ ^ false ] .
^ intPart odd
%

category: 'Copying'
method: ScaledDecimal
postCopy
  ^ self immediateInvariant
%

category: 'Compatibility'
method: ScaledDecimal
reduced

 ^ self
%

category: 'Truncation and Rounding'
method: ScaledDecimal
roundAndCoerceTo: aNumber

"Returns the multiple of aNumber that is nearest in value to the receiver.
  If the receiver is exactly between two multiples of aNumber,
  answer the one that is even number times aNumber. Example:
    4.125s roundTo: 0.75s --> 4.500s
    4.875s roundTo: 0.75s --> 4.500s
  because 4.5 = 6 * 0.75

 If aNumber is a kind of Integer, or AbstractFraction,
 the result will be an instance of the class of aNumber .
"
aNumber = 0 ifTrue:[ ^ 0 ].
^  (self / aNumber) roundedHalfToEven * aNumber  .
%

category: 'Truncation and Rounding'
method: ScaledDecimal
rounded
 "Returns the integer nearest in value to the receiver."
  | r myScale |
  r := self + (self class numerator: self sign denominator: 2 scale: (myScale :=self scale)) .
  ^ r mantissa quo: (10 raisedTo: myScale) .
%

category: 'Truncation and Rounding'
method: ScaledDecimal
roundTo: aNumber

"Returns the multiple of aNumber that is nearest in value to the receiver.
  If the receiver is exactly between two multiples of aNumber,
  answer the one that is even number times aNumber. Example:
    4.125s roundTo: 0.75s --> 4.500s
    4.875s roundTo: 0.75s --> 4.500s
  because 4.5 = 6 * 0.75 "

| r |
aNumber = 0 ifTrue:[ ^ 0 ].
r := (self / aNumber) roundedHalfToEven * aNumber  .
r _isInteger ifTrue:[ ^ self class numerator: r denominator: 1 scale: self scale].
^ r
%

category: 'Accessing'
method: ScaledDecimal
scale

^ scale
%

category: 'Accessing'
method: ScaledDecimal
sign
  | m |
  ((m := self mantissa) > 0) ifTrue:[ ^ 1 ].
  (m < 0) ifTrue:[ ^ -1 ].
  ^0
%

category: 'Converting'
method: ScaledDecimal
truncateAndCoerceTo: aNumber

 "Returns the multiple of aNumber that is closest to the receiver, on
 the same side of the receiver as zero is located.  In particular,
 returns the receiver if the receiver is a multiple of aNumber."

  aNumber = 0 ifTrue:[ ^ 0 ].

  ^ (self quo: aNumber) * aNumber
%

category: 'Truncation and Rounding'
method: ScaledDecimal
truncated

"Returns the integer that is closest to the receiver, on the same side
 of the receiver as zero is located."

  | f |
  f := self floor.
  (self mantissa < 0 and: [f ~= self])
      ifTrue:[ f := f + 1 ].
  ^ f
%

category: 'Converting'
method: ScaledDecimal
truncateTo: aNumber
  | arg |
  (arg := aNumber) _isInteger ifTrue:[
    arg := self class for: aNumber scale: self scale.
  ].
  ^super truncateTo: arg
%

category: 'Compatibility'
method: ScaledDecimal
withScale: newScale
"Returns a new instance with the new scale, and a numeric value
 as close to that of the receiver as possible."

	^self asScaledDecimal: newScale
%

category: 'Storing and Loading'
method: ScaledDecimal
writeTo: passiveObj

"Converts the receiver to its passive form and writes that information on
 passiveObj."

"Reimplemented from Number since the receiver has a non-literal representation."

^super basicWriteTo: passiveObj
%

category: 'Private'
method: ScaledDecimal
_asString: dpChar

| str mstr sc sz len isNeg m nDigits |
(m := self mantissa) ifNil:[ ^ 'ScaledDecimalNaN' ].
mstr := m asString .
len := mstr size .
sz := len .
sc := self scale.
nDigits := sz .
(isNeg := (mstr at: 1) == $-) ifTrue:[ nDigits := nDigits - 1 ].
str := String new .
nDigits <= sc  ifTrue:[ | zeros zerosLen zcount idx srcIdx |
  isNeg ifTrue:[ str add: $- ] .
  str add: $0 ; add: dpChar .
  zeros := '00000000000000000000000000000000000000000000000000000000000000000' .
  zerosLen := zeros size .
  zcount := sc - nDigits .
  [ zcount >= zerosLen ] whileTrue:[
    str add: zeros .
    zcount := zcount - zerosLen .
  ].
  zcount > 0 ifTrue:[
    "zeros copyFrom: 1 to: zcount into: str startingAt: str size + 1"
    idx := str size .
    str replaceFrom: idx + 1 to: idx + zcount with: zeros startingAt: 1 .
  ].
  "mstr copyFrom: len - nDigits + 1 to: len into: str startingAt: str size + 1"
  idx := str size + 1 .
  srcIdx := len - nDigits + 1 .
  str replaceFrom: idx  to: idx + nDigits - 1  with: mstr startingAt: srcIdx
] ifFalse:[
  str := mstr .
  str insertAll: dpChar at: (sz + 1 - sc ) .
].
^ str
%

category: 'Converting'
method: ScaledDecimal
_coerce: aNumber

"Reimplemented from Number."

^ aNumber asScaledDecimal: self scale
%

category: 'Private'
method: ScaledDecimal
_generality

"Returns an Integer representing the ordering of the receiver in
 the generality hierarchy."

^ 60
%

category: 'Testing'
method: ScaledDecimal
_getKind
 | m |
 (m := self mantissa) ifNil:[ ^ 5 ]. "nan, should never occur"
 m == 0 ifTrue:[ ^ 4 ]. "zero"
 ^ 1 "normal"
%

category: 'Private'
method: ScaledDecimal
_mantissa: m scale: s
  m _isInteger ifFalse:[ m _validateClass: Integer ].
  s _isSmallInteger ifFalse:[ s _validateClass: SmallInteger ].
  s > MaxScale ifTrue:[
    OutOfRange new name: '' max: MaxScale actual: s ;
	details: 'invalid scale' ; signal
  ].
  s < 0 ifTrue:[ OutOfRange new name: 'scale' min: 0 actual: s ;
                    details: 'scale must be >= 0' ; signal ].
  mantissa := m .
  scale := s
%

! Class extensions for 'SmallDouble'

!		Class methods for 'SmallDouble'

removeallmethods SmallDouble
removeallclassmethods SmallDouble

category: 'Storing and Loading'
classmethod: SmallDouble
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object.  Converts the object to
 its active form by loading the information into a new instance of the receiver.
 Returns the new instance."

| inst |

inst := self fromStringLocaleC:  passiveObj upToSeparator .
"no hasRead: here, since SmallDouble is a special"
^inst
%

!		Instance methods for 'SmallDouble'

category: 'Storing and Loading'
method: SmallDouble
containsIdentity

"Private."

^true
%

category: 'Copying'
method: SmallDouble
copy
  ^ self
%

category: 'Testing'
method: SmallDouble
isSpecial

"Returns true if the receiver is a special object."

^ true
%

category: 'Repository Conversion'
method: SmallDouble
needsFixingAfterConversion
 ^ false
%

category: 'Private'
method: SmallDouble
_asFloat

"Returns an instance of Float equal to the receiver.
 For use in activation of a PassiveObject and for testing the image.
 It is a performance and space degradation to use this in applications."

^ self _mathPrim: 10
%

category: 'Converting'
method: SmallDouble
_generality

"Returns the integer that represents the ordering of the receiver in the
 generality hierarchy."

"Reimplemented from Number"

^ 85
%

! Class extensions for 'SmallFloat'

!		Class methods for 'SmallFloat'

removeallmethods SmallFloat
removeallclassmethods SmallFloat

category: 'Instance Creation'
classmethod: SmallFloat
fromString: aString

"Returns an instance of Float or SmallDouble, constructed from aString.  The String
 must contain only Characters representing the object to be created, although
 leading and trailing blanks are permitted.

 If the string represents an exceptional float, it must contain one of the
 following strings, with leading and trailing blanks permitted: 'PlusInfinity',
 'MinusInfinity', 'PlusQuietNaN', 'MinusQuietNaN', 'PlusSignalingNaN', or
 'MinusSignalingNaN'.

 If the string does not conform to the above rules, this method generates an
 error or returns a signaling NaN.

 If the string is larger than 8191 bytes, an error is generated."

^ (Float fromString: aString) asSmallFloat
%

category: 'Instance Creation'
classmethod: SmallFloat
fromStringLocaleC: aString

"Same as fromString:  except that decimal point in aString must use  $.  "

^ (Float fromStringLocaleC: aString) asSmallFloat
%

category: 'Storing and Loading'
classmethod: SmallFloat
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object.  Converts the object to
 its active form by loading the information into a new instance of the receiver.
 Returns the new instance."

 | inst |
 inst := (self fromStringLocaleC:  passiveObj upToSeparator) .
 passiveObj hasRead: inst .
 ^ inst
%

!		Instance methods for 'SmallFloat'

category: 'Arithmetic'
method: SmallFloat
* aNumber

"Multiply the receiver by aNumber and returns the result."

^ self asFloat * aNumber
%

category: 'Arithmetic'
method: SmallFloat
+ aNumber

"Returns the sum of the receiver and aNumber."

^ self asFloat + aNumber
%

category: 'Arithmetic'
method: SmallFloat
- aNumber

"Returns the difference between the receiver and aNumber."

^ self asFloat - aNumber
%

category: 'Arithmetic'
method: SmallFloat
/ aNumber

"Divide the receiver by aNumber and returns the result."

^ self asFloat / aNumber
%

category: 'Comparing'
method: SmallFloat
< aNumber

"Returns true if the receiver is less than aNumber; returns false otherwise."

^ self _compare: aNumber opcode: 2 selector: #<
%

category: 'Comparing'
method: SmallFloat
<= aNumber

"Returns true if the receiver is less than or equal to a aNumber;
 returns false otherwise."

^ self _compare: aNumber opcode: 3 selector: #<=
%

category: 'Comparing'
method: SmallFloat
= aNumber

"Returns true if the receiver is equal to aNumber; returns false otherwise."

^ self _compare: aNumber opcode: 0 selector: #=
%

category: 'Converting'
method: SmallFloat
asDecimalFloat

"Returns a DecimalFloat representing the receiver."

^ self asFloat asDecimalFloat
%

category: 'Converting'
method: SmallFloat
asFloat

"Returns a SmallDouble or Float with the same value as the receiver."

<primitive: 154>
^ self _primitiveFailed: #asFloat
%

category: 'Accessing'
method: SmallFloat
asFraction

"Returns a Fraction that represents the receiver.  If the receiver is a NaN,
 or Infinity, returns the receiver."

^ self asFloat asFraction
%

category: 'Converting'
method: SmallFloat
asSmallFloat

"Returns the receiver."

^ self
%

category: 'Formatting'
method: SmallFloat
asString

"Returns a String corresponding to the value of the receiver.  Where applicable,
 returns one of the following Strings: 'PlusInfinity', 'MinusInfinity',
 'PlusQuietNaN', 'MinusQuietNaN', 'PlusSignalingNaN', or 'MinusSignalingNaN'.

  The receiver is printed with the fewest significant digits needed to uniquely
 identify it. It is printed in exponential format unless the exponent would be
 between -4 and 6, in which case it is printed in decimal (nnn.nnnn) format."

^ self _primAsStringShouldUseLocale: true
%

category: 'Formatting'
method: SmallFloat
asStringLegacy

"Returns a String corresponding to the value of the receiver.  Where applicable,
 returns one of the following Strings: 'PlusInfinity', 'MinusInfinity',
 'PlusQuietNaN', 'MinusQuietNaN', 'PlusSignalingNaN', or 'MinusSignalingNaN'."

^ self asFloat asStringUsingFormat: #(1 8 true)
%

category: 'Formatting'
method: SmallFloat
asStringLocaleC

"Result is same as for asString, except that decimal point is always
 using  $.   For use in passivation/activation "

^ self _primAsStringShouldUseLocale: false
%

category: 'Formatting'
method: SmallFloat
asStringUsingFormat: anArray

"Returns a String corresponding to the receiver, using the format specified by
 anArray.  The Array contains three elements: two Integers and a Boolean.
 Generates an error if any element of the Array is missing or is of the wrong
 class.

 The first element of the Array (an Integer between -1000 and 1000)
 specifies a minimum number of Characters in the result String (that is,
 the 'width' of the string).  If this element is positive, the resulting
 String is padded with blanks to the right of the receiver.  If this element
 is negative, the blanks are added to the left of the receiver.  If the
 value of this element is not large enough to completely represent the Float,
 a longer String will be generated.


 The second element of the Array (a positive Integer less than or equal to
 1000) specifies the number of digits to display to the right of the decimal
 point.  If the value of this element exceeds the number of digits required to
 specify the Float, the result is right-padded with 0 to the required width.
 If the value of this element is insufficient to completely specify the Float,
 the value of the Float is rounded (see #rounded).

 The third element of the Array (a Boolean) indicates whether or not to display
 the magnitude using exponential notation.  (The value true indicates
 exponential notation and false indicates decimal notation.)

 For example, the number 12.3456 displayed with two different format Arrays
 would appear as follows:

 Format          Output
 #(10 5 true)    '1.23456E01'
 #(10 2 false)   '12.35     '"

^ self asFloat asStringUsingFormat: anArray
%

category: 'Accessing'
method: SmallFloat
denominator

"Returns the denominator of a Fraction representing the receiver."

^ self asFloat denominator
%

category: 'Accessing'
method: SmallFloat
numerator

"Returns the numerator of a Fraction representing the receiver."

^ self asFloat numerator
%

category: 'Accessing'
method: SmallFloat
sign

"Returns 1 if the receiver is greater than zero, -1 if the receiver is
 less than zero, and zero if the receiver is zero."

^ self asFloat sign
%

category: 'Accessing'
method: SmallFloat
signBit

  "Returns  1 for a negative receiver and 0 for a positive receiver"

^ self asFloat signBit
%

category: 'Truncation and Rounding'
method: SmallFloat
truncated

"Returns the integer that is closest to the receiver, on the same side
 of the receiver as zero is located.  In particular, returns the receiver
 if the receiver is an integer."

^ self asFloat truncated
%

category: 'Converting'
method: SmallFloat
_coerce: aNumber

"Returns an instance of SmallFloat with the same value as 'aNumber'.
 Since SmallFloat is deprecated, use asFloat which may return a
 SmallDouble or a Float."

"This method must be defined by all subclasses of Number."

^ aNumber asFloat
%

category: 'Comparing'
method: SmallFloat
_compare: aNumber opcode: opcode selector: aSymbol
	"Private."

	"opcode function
   0     =
   1     ~=
   2     <
   3     <=

 The primitive returns nil if the receiver and argument are not
 comparable, and the sender must then retry the compare."

	<primitive: 176>
	| sk |
	(aNumber _isNumber or: [ aNumber isNumber ])
		ifFalse: [ 
			opcode > 1
				ifTrue: [ ^ ArgumentTypeError signal: 'Expected a Number' ].
			^ opcode == 1 ].
	sk := self _getKind.
	sk > 4
		ifTrue: [ ^ opcode == 1 ].	"NaN"
	sk == 3
		ifTrue: [ ^ self _compareInfinityFor: aSymbol with: aNumber ].
	^ (AbstractFraction _coerce: self) perform: aSymbol with: aNumber
%

category: 'Converting'
method: SmallFloat
_generality

"Returns the integer that represents the ordering of the receiver in the
 generality hierarchy."

"Reimplemented from Number"

^ 80
%

category: 'Accessing'
method: SmallFloat
_getKind

"Returns an integer, 1...6, for the kind of the receiver."

^ self asFloat _getKind
%

category: 'Indexing Support'
method: SmallFloat
_isNaN

"Returns whether the receiver is quiet NaN or signaling NaN.
 This method is only to be used by the indexing subsystem."

^ self _getKind > 4
%

category: 'private'
method: SmallFloat
_primAsStringShouldUseLocale: localeBoolean
	<primitive: 81>
	^ self _primitiveFailed: #'_primAsStringShouldUseLocale:' args: {localeBoolean}
%

category: 'Comparing'
method: SmallFloat
~= aNumber

"Returns true if the receiver is not equal to aNumber; returns false
 otherwise."

^ self _compare: aNumber opcode: 1 selector: #~=
%

! Class extensions for 'Time'

!		Class methods for 'Time'

removeallmethods Time
removeallclassmethods Time

category: 'Private'
classmethod: Time
dateTimeClass

"Returns the DateTime class used internally in this class."

^ DateTime.
%

category: 'Instance Creation'
classmethod: Time
fromMicroseconds: anInteger
  self == Time ifTrue:[ ^ SmallTime fromMicroseconds: anInteger ]
              ifFalse:[ ^ super new _setMilliseconds: anInteger // 1000 ] 
%

category: 'Instance Creation'
classmethod: Time
fromMilliseconds: anInteger

"Creates and returns a kind of the receiver from the specified value,
 which expresses local time."

self == Time ifTrue:[ ^ SmallTime fromMilliseconds: anInteger ]
            ifFalse:[ ^ super new _setMilliseconds: anInteger ] 
%

category: 'Instance Creation'
classmethod: Time
fromSeconds: anInteger

"Creates and returns a kind of the receiver from the specified value,
 which expresses local time."

^ self fromMilliseconds: (anInteger * 1000).
%

category: 'Instance Creation'
classmethod: Time
fromSecondsGmt: anInteger

"Creates and returns an instance of the receiver from the specified value,
 which expresses Greenwich Mean Time."

^ self fromMicroseconds: ((anInteger - self gmtOffsetSeconds) * 1000000).
%

category: 'Instance Creation'
classmethod: Time
fromStream: aStream

"Creates and returns an instance of the receiver by reading a String from
 aStream.  The String expresses local time in the default format (HH:MM:SS).
 Generates an error if the String does not conform to the format."

^ self fromStream: aStream usingFormat: #($: true false).
%

category: 'Instance Creation'
classmethod: Time
fromStream: aStream usingFormat: anArray

"Creates and returns an instance of the receiver by reading a String from
 aStream.  The String expresses Greenwich Mean Time in the format specified by
 anArray.  The expression is terminated either by a space Character or by the
 end of the Stream.  Generates an error if the String does not conform to the
 format, or if anArray contains an incorrect formatting specification.

 See the class documentation of Time for a complete description of the
 String-formatting specification Array."

| hourInt minInt secInt timeDelim ampm ampmPresent secondsPresent parseField
  totalSeconds |

"This block returns a string up from the input stream up to the specified
 delimiter.  If also allows an end-of-file if that parameter is set true.
 It then skips over the delimiter if it is found.
"
parseField := [ :delim :allowEof | | str |
                str := aStream contents class new.
                [ ((aStream peek isEquivalent: delim) not) and:[aStream atEnd not] ]
                whileTrue:
                  [ str add: aStream next ].
                (aStream atEnd)
                ifTrue:
                  [ allowEof
                    ifFalse:
                      [ self _error: #rtErrBadFormat args: { aStream } ]
                  ]
                ifFalse:
                  [ aStream next "skip over delimiter" ].
                str
             ].

self _checkReadStream: aStream forClass: CharacterCollection.

timeDelim := anArray at: 1.
secondsPresent := anArray at: 2.
ampmPresent := anArray at: 3.
hourInt := Integer fromCompleteString: (parseField value: timeDelim value: false).
minInt := Integer fromCompleteString:
                  (parseField value: (secondsPresent ifTrue: [timeDelim] ifFalse: [$ ])
			      value: (secondsPresent not and:[ ampmPresent not])).
secondsPresent
  ifTrue: [
    secInt := Integer fromCompleteString: (parseField value: $  value: ampmPresent not)]
  ifFalse:
    [ secInt := 0 ].

ampmPresent
  ifTrue: [
    hourInt < 0 ifTrue: [ self _error: #rtErrBadFormat args: { aStream }].
    hourInt > 12 ifTrue: [ self _error: #rtErrBadFormat args: { aStream }].
    ampm := String new.
    ampm add: (aStream next); add: aStream next.
    (ampm isEquivalent: 'PM')
      ifTrue: [
        hourInt := hourInt + 12.
        hourInt == 24 ifTrue: [ hourInt := 12].
        ]
      ifFalse: [
        (ampm isEquivalent: 'AM') ifFalse: [
        self _error: #rtErrBadFormat args: { aStream } ].
        hourInt == 12 ifTrue: [ hourInt := 0].
        ].
    ].

totalSeconds := (hourInt * 3600) + (minInt * 60) + secInt.
^ self fromSeconds: totalSeconds .
%

category: 'Instance Creation'
classmethod: Time
fromStreamGmt: aStream

"Creates and returns an instance of the receiver by reading a String from
 aStream.  The String expresses Greenwich Mean Time in the default format
 (HH:MM:SS).  Generates an error if the String does not conform to the format."

^ self fromStreamGmt: aStream usingFormat: #($: true false).
%

category: 'Instance Creation'
classmethod: Time
fromStreamGmt: aStream usingFormat: anArray

"Creates and returns an instance of the receiver by reading a String from
 aStream.  The String expresses local time in the format specified by
 anArray.  The expression is terminated either by a space Character or by the
 end of the Stream.  Generates an error if the String does not conform to the
 format, or if anArray contains an incorrect formatting specification.

 See the class documentation of Time for a complete description of the
 String-formatting specification Array."

^ (self fromStream: aStream usingFormat: anArray )
        subtractSeconds: self gmtOffsetSeconds.
%

category: 'Instance Creation'
classmethod: Time
fromString: aString

"Creates and returns an instance of the receiver from the String aString.
 The String expresses local time in the default format (HH:MM:SS).
 Generates an error if the String does not conform to the format."

^ self fromString: aString usingFormat: #($: true false).
%

category: 'Instance Creation'
classmethod: Time
fromString: aString usingFormat: anArray

"Creates and returns an instance of the receiver from the String aString.
 The String expresses local time in the format specified by anArray.
 The expression is terminated either by a space Character or by the end of the
 String.  Generates an error if the String does not conform to the format,
 or if anArray contains an incorrect formatting specification.

 See the class documentation of Time for a complete description of the
 String-formatting specification Array."

| s result |

s := ReadStreamPortable on: aString.
result := self fromStream: s usingFormat: anArray.
[ s atEnd ]
whileFalse:
  [ (s next == $  )
    ifFalse:
      [ self _errIncorrectFormat: aString ]
  ].
^ result
%

category: 'Instance Creation'
classmethod: Time
fromStringGmt: aString

"Creates and returns an instance of the receiver from the String aString.
 The String expresses Greenwich Mean Time in the default format (HH:MM:SS).
 Generates an error if the String does not conform to the format."

^ self fromStringGmt: aString usingFormat: #($: true false).
%

category: 'Instance Creation'
classmethod: Time
fromStringGmt: aString usingFormat: anArray

"Creates and returns an instance of the receiver from the String aString.
 The String expresses Greenwich Mean Time in the format specified by anArray.
 The expression is terminated either by a space Character or by the end of the
 String.  Generates an error if the String does not conform to the format,
 or if anArray contains an incorrect formatting specification.

 See the class documentation of Time for a complete description of the
 String-formatting specification Array."

| s result |

s := ReadStreamPortable on: aString.
result := self fromStreamGmt: s usingFormat: anArray.
[ s atEnd ]
whileFalse:
  [ (s next == $  )
    ifFalse:
      [ self _errIncorrectFormat: aString ]
  ].
^ result
%

category: 'Adjusting'
classmethod: Time
gmtOffsetSeconds

"Returns a SmallInteger that gives the offset in seconds of the local time zone,
 its difference with respect to Greenwich Mean Time.

 A positive number corresponds to west of Greenwich, a negative number to east
 of Greenwich.  For example, the offset for the Pacific Standard Time zone is
 28800."

^ self dateTimeClass now _localOffset negated.
%

category: 'Storing and Loading'
classmethod: Time
loadFrom: passiveObj

"Creates and returns an active instance of the receiver from the passive form
 of the object, which expresses itself in Greenwich Mean Time."
| inst val |
val := passiveObj readObject .
val _isSmallInteger ifFalse:[ Error signal:'unexpected ', val class name ].
passiveObj version >= 620 ifTrue:[
  inst := self fromMicroseconds: val .
] ifFalse:[
 passiveObj version >= 510
  ifTrue: [ inst := self fromMilliseconds: val ]
  ifFalse: [ inst := self fromSecondsGmt: val ].
].
self == SmallTime ifTrue:[
  inst isSpecial ifFalse:[ Error signal:'a SmallTime should be special' ].
] ifFalse:[ | ms |
  ms := inst asMilliseconds .
  inst := self _basicNew _setMilliseconds: ms  .
  passiveObj hasRead: inst .
].
^inst.
%

category: 'Instance Creation'
classmethod: Time
migrateNew

"Override default migrateNew behavior with #_basicNew."

^ self _basicNew
%

category: 'Measuring'
classmethod: Time
millisecondClockValue

"Returns a SmallInteger representing the current time in milliseconds.
 The result is a SmallInteger equivalent to

    (System _timeGmtFloat * 1000) asInteger

 The result is computed locally in the session process, using the offset
 from the Gem's time that was cached in the session at login.

 Gs64 v2.2, changed to no longer rollover to zero after 524287999 "

<primitive: 651>
^ self _primitiveFailed: #millisecondClockValue
%

category: 'Measuring'
classmethod: Time
millisecondsElapsedTime: aBlock

"Returns the elapsed time in milliseconds aBlock takes to return its value.
 The argument aBlock must be a zero-argument block."

^ ((self secondsElapsedTime: aBlock) * 1000) asInteger
%

category: 'Instance Creation'
classmethod: Time
new

"Disallowed.  To create a new Time, use another instance creation method."

self shouldNotImplement: #new
%

category: 'Instance Creation'
classmethod: Time
new: anInteger

"Disallowed.  To create a new Time, use another instance creation method."

self shouldNotImplement: #new:
%

category: 'Instance Creation'
classmethod: Time
now
  "Beginning with Gs64 v3.0, returns an instance of the receiver representing
   the current time, taking into consideration the current smalltalk TimeZone ,
   per class DateAndTime .

   See Time(C)>>_now for previous implementation that gets time directly from the OS."

   | parts secondsSinceMidnight |
   parts := DateAndTime now asFloatParts.
     "parts is { year. dayOfYear. monthIndex. dayOfMonth. hour. minute. second } "
   secondsSinceMidnight := (parts at: 5) * 60 + (parts at: 6) * 60 + (parts at: 7).
   ^self fromMicroseconds: (secondsSinceMidnight * 1000000) roundedNoFpe .
%

category: 'Measuring'
classmethod: Time
secondsElapsedTime: aBlock

"Returns the elapsed time in seconds aBlock takes to return its value.
 The argument aBlock must be a zero-argument block.
 The result is a Float with microsecond resolution "

| startTime endTime systm |

systm := System .
startTime :=  systm _timeGmtFloat.
aBlock value.
endTime := systm _timeGmtFloat.

^ endTime - startTime
%

category: 'Instance Creation'
classmethod: Time
_now
  | t |
  t := self __now .
  self == Time
    ifTrue:[ ^ t ]
    ifFalse:[ ^ self basicNew _setMilliseconds: t asMilliseconds]  
%

category: 'Instance Creation'
classmethod: Time
__now

"Creates and returns an instance of SmallTime from the system clock on the
 machine that is running the Gem process, which is assumed to represent the
 current time of day."

<primitive: 317>
^ self _primitiveFailed: #_now
%

!		Instance methods for 'Time'

category: 'Comparing'
method: Time
< aTime

"Returns true if the receiver represents a time of day before that of the
 argument, and false if it doesn't.  Generates an error if the argument is not
 a Time."

^ self asMicroseconds < aTime asMicroseconds.
%

category: 'Comparing'
method: Time
= aTime
	"Returns true if the receiver represents the same time of day as that of the
	argument, and false if it doesn't."

	self == aTime
		ifTrue: [ ^ true ].
	(aTime isKindOf: Time)
		ifFalse: [ ^ false ].
	^ self asMicroseconds == aTime asMicroseconds
%

category: 'Comparing'
method: Time
> aTime

"Returns true if the receiver represents a time of day after that of the
 argument, and false if it doesn't.  Generates an error if the argument is not
 a Time."

^ self asMicroseconds > aTime asMicroseconds
%

category: 'Arithmetic'
method: Time
addMicroseconds: anInteger

"Returns a Time that describes a time of day anInteger microseconds
 later than that of the receiver."

^ self class fromMicroseconds: (self asMicroseconds + anInteger ).
%

category: 'Arithmetic'
method: Time
addMilliseconds: anInteger

"Returns a Time that describes a time of day anInteger milliseconds
 later than that of the receiver."

^ self class fromMicroseconds: (self asMicroseconds + (anInteger * 1000) ).
%

category: 'Arithmetic'
method: Time
addSeconds: anInteger

"Returns a Time that describes a time of day anInteger seconds
 later than that of the receiver."

^ self class fromMicroseconds: (self asMicroseconds + (anInteger * 1000000)).
%

category: 'Arithmetic'
method: Time
addTime: aTime

"Returns a Time that describes a time of day that is aTime
 later than that of the receiver. aTime represents the duration since
 midnight local time."

^ self class fromMicroseconds: (self asMicroseconds + aTime asMicroseconds).
%

category: 'Converting'
method: Time
asCanonicalForm
	"Answer self, or, if I am a Time with an equivalent
	SmallTime, answer that SmallTime."

	| cls res |
	(cls := self class) ~~ SmallTime
		ifTrue: [ 
			cls == Time
				ifTrue: [ 
					res := SmallTime fromMicroseconds: self asMicroseconds.
					res class == SmallTime
						ifTrue: [ ^ res ] ] ].
	^ self
%

category: 'Converting'
method: Time
asMicroseconds
  ^ milliseconds * 1000 
%

category: 'Converting'
method: Time
asMilliseconds

"Returns a SmallInteger that represents the receiver in units of milliseconds since
 midnight, local time."

^ milliseconds.
%

category: 'Converting'
method: Time
asMillisecondsGmt

"Returns an SmallInteger that represents the receiver in units of milliseconds since
 midnight, Greenwich Mean Time."

^ (self asMilliseconds + ((self class gmtOffsetSeconds) * 1000)) \\ 86400000 .
%

category: 'Converting'
method: Time
asSeconds

"Returns an SmallInteger that represents the receiver in units of seconds since
 midnight, local time."

^ self asMilliseconds // 1000.
%

category: 'Converting'
method: Time
asSecondsGmt

"Returns an SmallInteger that represents the receiver in units of seconds since
 midnight, Greenwich Mean Time."

^ ((self asMilliseconds // 1000) + self class gmtOffsetSeconds) \\ 86400
%

category: 'Formatting'
method: Time
asString

"Returns a String that expresses the receiver in local time
 in the default format (HH:MM:SS)."

| result ms |

"Check for seconds being nil, for graceful printing during error handling."
ms := self asMilliseconds .
ms ifNil:[ ^ '(nil):(nil):(nil)' ].
result := (ms // 3600000) _digitsAsString.
result addAll: $:; addAll: ((ms \\ 3600000) // 60000) _digitsAsString.
result addAll: $:; addAll: (ms // 1000 \\ 60) truncated _digitsAsString.
^ result.
%

category: 'Formatting'
method: Time
asStringGmt

"Returns a String that expresses the receiver in Greenwich Mean Time
 in the default format (HH:MM:SS)."

^ (self addSeconds: self class gmtOffsetSeconds) asString
%

category: 'Formatting'
method: Time
asStringGmtUsingFormat: anArray

"Returns a String that expresses the receiver in Greenwich Mean Time
 in the format defined by anArray.  Generates an error if anArray
 contains an incorrect formatting specification.

 See the class documentation of Time for a complete description of the
 String-formatting specification Array."

^ (self addSeconds: self class gmtOffsetSeconds) asStringUsingFormat: anArray.
%

category: 'Formatting'
method: Time
asStringMs

"Returns a String that expresses the receiver in local time
 in the format  HH:MM:SS.sss   where  sss are milliseconds."

| msStr result ms |
"Check for seconds being nil, for graceful printing during error handling."
ms := self asMilliseconds .
ms ifNil:[ ^ '(nil):(nil):(nil)' ].
result := (ms // 3600000) _digitsAsString.
result add: $: ; addAll: ((ms \\ 3600000) // 60000) _digitsAsString.
result add: $: ; addAll: (ms // 1000 \\ 60) _digitsAsString.
msStr := (ms \\ 1000) _digitsAsString.
result add: $. .
msStr size < 3 ifTrue:[ result add: $0 ].
result addAll: msStr .
^ result.
%

category: 'Formatting'
method: Time
asStringUs

"Returns a String that expresses the receiver in local time
 in the format  HH:MM:SS.ssssss  where ssssss are microseconds."

| usStr result ms us |
"Check for seconds being nil, for graceful printing during error handling."
us := self asMicroseconds .
us ifNil:[ ^ '(nil):(nil):(nil)' ].
ms := us // 1000 .
result := (ms // 3600000) _digitsAsString.
result add: $: ; addAll: ((ms \\ 3600000) // 60000) _digitsAsString.
result add: $: ; addAll: (ms // 1000 \\ 60) _digitsAsString.
result add: $. .
usStr := (us \\ 1000000) asString .
6 - usStr size timesRepeat:[ result add: $0 ].
result addAll: usStr .
^ result.
%

category: 'Formatting'
method: Time
asStringUsingFormat: anArray

"Returns a String that expresses the receiver in Greenwich Mean Time
 in the format defined by anArray.  Generates an error if anArray
 contains an incorrect formatting specification.

 See the class documentation of Time for a complete description of the
 String-formatting specification Array."

| timeSeparator  hourInt hour min sec aString ms |
ms := self asMilliseconds .
timeSeparator := anArray at: 1.
hourInt := ms // 3600000.
hour := hourInt  _digitsAsString.
min := (ms \\ 3600000 // 60000) _digitsAsString.
sec := (ms // 1000 \\ 60) _digitsAsString.

aString := String new.
(anArray at: 3)
  ifTrue: [ "12-hour format"
    (hourInt > 12)
      ifTrue: [
        aString addAll: (hourInt - 12) _digitsAsString;
        addAll: timeSeparator;
        addAll: min.

        (anArray at: 2)
          ifTrue: [ aString addAll: timeSeparator; addAll: sec ].
        ]
      ifFalse: [
        aString addAll: (hourInt == 0 ifTrue: ['12'] ifFalse: [hour]);
        addAll: timeSeparator;
        addAll: min.

        (anArray at: 2)
          ifTrue: [ aString addAll: timeSeparator; addAll: sec].
        ].

    aString addAll: (hourInt >= 12 ifTrue: [' PM'] ifFalse: [' AM']).
    ]
  ifFalse: [
    aString addAll: hour;
            addAll: timeSeparator;
            addAll: min.

    (anArray at: 2)
      ifTrue: [ aString addAll: timeSeparator; addAll: sec].
    ].

^ aString
%

category: 'Accessing'
method: Time
at: anIndex put: aValue

"Disallowed.  You may not change the value of a Time."

self shouldNotImplement: #at:put:
%

category: 'Comparing'
method: Time
hash

"Returns an Integer hash code for the receiver."

^ self asSeconds hash.
%

category: 'Accessing'
method: Time
hours

"Returns a SmallInteger (between zero and 23 inclusive) that gives the number of
 hours represented by the receiver since midnight, local time."

^ self asMilliseconds // 3600000
%

category: 'Accessing'
method: Time
hoursGmt

"Returns a SmallInteger (between zero and 23 inclusive) that gives the number of
 hours represented by the receiver since midnight, Greenwich Mean Time."

^ (self asMilliseconds // 1000 + self class gmtOffsetSeconds \\ 86400) // 3600
%

category: 'Accessing'
method: Time
minutes

"Returns a SmallInteger (between zero and 59 inclusive) that gives the number of
 minutes represented by the receiver since the previous hour, local time."

^ (self asMilliseconds \\ 3600000) // 60000
%

category: 'Accessing'
method: Time
minutesGmt

"Returns a SmallInteger (between zero and 59 inclusive) that gives the number of
 minutes represented by the receiver since the previous hour, Greenwich Mean
 Time."

^ ((self asMilliseconds // 1000 + self class gmtOffsetSeconds) \\ 3600) // 60
%

category: 'Formatting'
method: Time
printJsonOn: aStream
  (self asStringUsingFormat: #( $: true false )) printJsonOn: aStream
%

category: 'Formatting'
method: Time
printOn: aStream

"Puts a displayable representation of the receiver, expressed in
 local time, on aStream."

aStream nextPutAll: self asString .
%

category: 'Accessing'
method: Time
seconds

"Returns a SmallInteger (between zero and 59 inclusive) that gives the number of
 seconds represented by the receiver since the previous hour, local time."

^ self asMilliseconds // 1000 \\ 60
%

category: 'Accessing'
method: Time
secondsGmt

"Returns a SmallInteger (between zero and 59 inclusive) that gives the number of
 seconds represented by the receiver since the previous hour,  Greenwich Mean
 Time."

^ (self asMilliseconds // 1000 + self class gmtOffsetSeconds) \\ 60
%

category: 'Arithmetic'
method: Time
subtractMicroseconds: anInteger

"Returns a Time that describes a time of day anInteger milliseconds
 earlier than that of the receiver."

^ self addMicroseconds: (0 - anInteger).
%

category: 'Arithmetic'
method: Time
subtractMilliseconds: anInteger

"Returns a Time that describes a time of day anInteger milliseconds
 earlier than that of the receiver."

^ self addMilliseconds: (0 - anInteger).
%

category: 'Arithmetic'
method: Time
subtractSeconds: anInteger

"Returns a Time that describes a time of day anInteger seconds
 earlier than that of the receiver."

^ self addSeconds: (0 - anInteger).
%

category: 'Arithmetic'
method: Time
subtractTime: aTime

"Returns a Time that describes a time of day that is aTime
 earlier than that of the receiver. aTime represents the duration
 since midnight local time."

^ self class fromMicroseconds: (self asMicroseconds - aTime asMicroseconds).
%

category: 'Deprecated'
method: Time
timeAsSeconds

"Returns a SmallInteger (between zero and 86399 inclusive) that gives
 the number of seconds represented by the receiver since midnight, local time."

self deprecated: 'Time>>timeAsSeconds deprecated before v3.0, use #asSeconds'.
^ self asMilliseconds // 1000.
%

category: 'Deprecated'
method: Time
timeAsSecondsGmt

"Returns a SmallInteger (between zero and 86399 inclusive) that gives
 the number of seconds represented by the receiver since midnight, Greenwich
 Mean Time."

self deprecated: 'Time>>timeAsSecondsGmt deprecated before v3.0, use #asSecondsGmt'.
^ self asSecondsGmt.
%

category: 'Storing and Loading'
method: Time
writeTo: passiveObj

"Writes the passive form of the receiver into passiveObj, expressed in
 Greenwich Mean Time."

passiveObj writeClass: self class.
self asMicroseconds writeTo: passiveObj.
passiveObj space
%

category: 'New Indexing Comparison'
method: Time
_classSortOrdinal

^ 40
%

category: 'Private'
method: Time
_setMilliseconds: anInteger

"Private. Initialize and make the receiver invariant. Returns the receiver."

milliseconds := anInteger \\ 86400000.
self immediateInvariant
%

category: 'Private'
method: Time
_topazAsString
 ^ self asStringMs
%

! Class extensions for 'TransientShortArray'

!		Class methods for 'TransientShortArray'

removeallmethods TransientShortArray
removeallclassmethods TransientShortArray

category: 'Instance creation'
classmethod: TransientShortArray
_basicNew: numElements

"Create a new instance of the specified size. The maximum
 allowed size is 32752 elements . "

<primitive: 814>
self _primitiveFailed: #_basicNew: args: { numElements }
%

!		Instance methods for 'TransientShortArray'

category: 'Converting'
method: TransientShortArray
asByteArray
 ^ self shouldNotImplement: #asByteArray
%

category: 'Copying'
method: TransientShortArray
replaceFrom: startIndex to: stopIndex with: aSeqCollection

"Disallowed."
^ self shouldNotImplement: #replaceFrom:to:with:
%

category: 'Copying'
method: TransientShortArray
replaceFrom: startIndex to: stopIndex with: aSeqCollection startingAt: repIndex

"Disallowed."
^ self shouldNotImplement: #replaceFrom:to:with:startingAt:
%

category: 'Copying'
method: TransientShortArray
replaceFrom: startIndex to: stopIndex withObject: anObject

"Disallowed."
^ self shouldNotImplement: #replaceFrom:to:withObject:
%

! Class Initialization Excluded by export visitor
!  GsPackagePolicy initialize.
!  Upgrade2A initialize.
