! Copyright (C) GemTalk Systems 1986-2026.  All Rights Reserved.
! Class Declarations
! Generated file, do not Edit

doit
(Notification
	_newKernelSubclass:'Deprecated'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 151041
)
		category: nil;
		comment: 'Deprecated is used to signal methods that are deprecated.
See Object>>#deprecated: for suggested use.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object';
		immediateInvariant.
true.
%

doit
(PrivateObject
	subclass: 'UpgradeStreams'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'UpgradeStreams is a class used during image upgrade.  
Methods should only be executed via the image upgrade scripts.';
		immediateInvariant.
true.
%

removeallmethods UpgradeStreams
removeallclassmethods UpgradeStreams

! Class implementation for 'Deprecated'

!		Class methods for 'Deprecated'

category: 'signaledException'
classmethod: Deprecated
deprecatedAction

  "returns one of #ignore, #log, #logstack #error"

  ^ DeprecationEnabled ifNil:[ #ignore ]
%

category: 'signaledException'
classmethod: Deprecated
doErrorOnDeprecated
  "signal an error to the application when deprecated: is sent."

  DeprecationEnabled := #error
%

category: 'signaledException'
classmethod: Deprecated
doLogOnDeprecated
  "When deprecated: is sent, log the argument to a file."

  DeprecationEnabled := #log
%

category: 'signaledException'
classmethod: Deprecated
doLogStackOnDeprecated
  "When deprecated: is sent, log the argument and the call stack to a file."

  DeprecationEnabled := #logstack
%

category: 'signaledException'
classmethod: Deprecated
doNothingOnDeprecated
  "Sends of deprecated: will do nothing"

  DeprecationEnabled := nil
%

category: 'signaledException'
classmethod: Deprecated
logFile
  | key tmps |
  ((tmps := SessionTemps current) at: (key := #Deprecated_logFile) otherwise: nil) ifNotNil:[:f |
     f == #nil ifTrue:[ ^ nil ] ifFalse:[ ^ f ]
  ].
  self logFilePath ifNotNil:[:path|
    (GsFile openAppendOnServer: path) ifNotNil:[:f |
      tmps at: key put: f .
      ^ f
    ].
  ].
  tmps at: key put: #nil .
  ^ nil
%

category: 'signaledException'
classmethod: Deprecated
logFilePath
  | path key tmps |
  (path := (tmps := SessionTemps current) at: (key := #Deprecated_logFilePath) otherwise: nil) ifNotNil:[
    ^ path
  ].
 ^ [
    path := System gemLogPath .
    path size > 0 ifTrue:[ path add: $/ . ] .
    path add: 'Deprecated';  add: System gemProcessId asString; add: '.log' .
    tmps at: key put: path . "cache the path "
    path.
  ] onException: Error do:[:ex |
    ex return: nil
  ]
%

!		Instance methods for 'Deprecated'

category: 'signaledException'
method: Deprecated
defaultAction

  DeprecationEnabled ifNil:[ "ignore" ]
    ifNotNil:[ :action |
       action == #'error' ifTrue: [ self _signalToDebugger ]
                    ifFalse:[ self recordStackToLog: action ]
    ]
%

category: 'signaledException'
method: Deprecated
recordStackToLog: action

 [ | eol string |
   action == #logstack ifTrue:[
     eol := '
    ' .
     (string := 'Deprecated method call at ' , DateAndTime now printStringWithRoundedSeconds)
       add: eol;
       add: self description ; add: eol .
       string add: (GsProcess stackReportToLevel: 20) ; lf .
   ] ifFalse:[
     string := self description . string lf
   ].
   self class logFile ifNotNil:[ :f|
     f nextPutAll: string; flush .
   ] ifNil:[
     GsFile gciLogServer: string
   ]
 ] onSynchronous: AbstractException do:[:ex |
    ex return: nil  "ignore the exception"
 ]
%

! Class implementation for 'UpgradeStreams'

!		Class methods for 'UpgradeStreams'

category: 'Image Upgrade'
classmethod: UpgradeStreams
initializeForInstall

  (Globals at: #PositionableStream_position otherwise: nil) ifNotNil:[:v |
    v == #ANSI ifFalse:[ Error signal:'about to overwrite Legacy Streams with ANSI'].
  ] ifNil:[
    self _checkLegacyStreams . "should still be in Globals"
  ].
  ^ self _initializeForInstall
%

category: 'Image Upgrade'
classmethod: UpgradeStreams
initializeForUpgrade
	"called during upgradeImage only ...records which flavor of Stream is currently installed (Legacy or Portable); 
    upgrades Stream classes using initialize; and then ensures that original flavof of Stream is installed"

	| installedStreamImageStatus positionableStream_position |
	installedStreamImageStatus := {false.	"was GemStone_Legacy_Streams present at start of install?"
	false	"If GemStone_Legacy_Streams present (i.e. upgrade from 3.x), was the 
					Portable Stream implementation installed at start of install?
					If not present (build or upgrade from .x), is this an upgrade?"}.
	positionableStream_position := Globals
		at: #'PositionableStream_position'
		ifAbsent: [ 
			(Globals includesKey: #'DbfHistory')
				ifTrue: [ 
					"this is a database upgrade so keep old behavior"
					#'Legacy' ]
				ifFalse: [ 
					"this is a new database; switch to #'ANSI' in 3.0"
					#'ANSI' ] ].
	(installedStreamImageStatus
		at: 1
		put: (Globals includesKey: #'GemStone_Legacy_Streams'))
		ifTrue: [ 
			"True means Portable installed, false means Legacy installed (Bug45450)"
			(installedStreamImageStatus
				at: 2
				put:
					((Globals at: #'PositionableStream') instVarNames includes: #'collection'))
				ifTrue: [ self _installLegacyStreams: positionableStream_position ] ]
		ifFalse: [ 
			"True means upgrade, false means build --- only called during upgrade"
			installedStreamImageStatus at: 2 put: true ].
	self _initializeForInstall.	"install streams - Portable streams will be installed when completed"
	PositionableStream isPortableStreamImplementation
		ifFalse: [ 
			"we always install portable stream during upgrade - at this point portable streams should be installed"
			Error signal: 'Expected PortableStreams to be installed' ].
	(installedStreamImageStatus at: 1)
		ifTrue: [ 
			"install stream implementation based on original status of the image"
			(installedStreamImageStatus at: 2)
				ifTrue: [ 
					self _installPortableStreams.
					GsFile gciLogServer: 'installPortableStreamImplementation ' ]
				ifFalse: [ 
					self _installLegacyStreams: positionableStream_position.
					GsFile
						gciLogServer:
							'installLegacyStreamImplementation position: '
								, positionableStream_position printString ] ]
		ifFalse: [ 
			"Conversion or upgrade from 2.x install legacy stream implementation"
			(installedStreamImageStatus at: 2)
				ifTrue: [ 
					"true means upgrade from 2.x"
					self _installLegacyStreams: positionableStream_position.
					GsFile
						gciLogServer:
							'installLegacyStreamImplementation position: '
								, positionableStream_position printString ]
				ifFalse: [ 
					"false means build ... should never get here, but if we do, Portable streams should be already installed"
					((Globals at: #'PositionableStream') instVarNames includes: #'collection')
						ifFalse: [ Error signal: 'Legacy Stream implementation is unexpectedly installed' ] ] ].
	^ true
%

category: 'Image Upgrade'
classmethod: UpgradeStreams
_checkLegacyStreams
GemStone_Legacy_Streams valuesDo:[:v |
 v isBehavior ifTrue:[ | key lgAssoc assoc |
   key := v name .
   lgAssoc := GemStone_Legacy_Streams associationAt: key otherwise: nil .
   assoc := Globals associationAt: key otherwise: nil .
   lgAssoc == assoc ifTrue:[
     Error signal: key , ' has identical association in Globals and GemStone_Legacy_Streams'.
   ].
   lgAssoc ifNil:[ Error signal: key , ' not found in GemStone_Legacy_Streams'].
   "may not be in Globals at this point during slowfilein"
 ].
].
%

category: 'Image Upgrade'
classmethod: UpgradeStreams
_copyMethodsTo_legacyStreams
"copy methods to classes in GemStone_Legacy_Streams"
| suffixSize report |
report := String new .
suffixSize := 'Legacy' size .
{ WriteStreamLegacy . ReadStreamLegacy . PositionableStreamLegacy . 
  ReadByteStreamLegacy } do:[:cls| | nam destNam dest |
   nam := cls name  .
   destNam := (nam copyFrom: 1 to: (nam size - suffixSize)) asSymbol  .
   dest := GemStone_Legacy_Streams at: destNam .
   report addAll: (cls _copyMethodsTo: dest ) ; lf .
].
GsFile gciLogServer: report .
%

category: 'Image Upgrade'
classmethod: UpgradeStreams
_copyMethodsTo_Portable_Streams
"copy methods to classes in GemStone_Portable_Streams"
| suffixSize report |
report := String new .
suffixSize := 'Portable' size .
{ PositionableStreamPortable . ReadStreamPortable . WriteStreamPortable .
  ReadWriteStreamPortable . FileStreamPortable . ReadByteStreamPortable } do:[:cls| | nam destNam dest |
   nam := cls name  .
   destNam := (nam copyFrom: 1 to: (nam size - suffixSize)) asSymbol  .
   dest := GemStone_Portable_Streams at: destNam .
   report addAll: (cls _copyMethodsTo: dest ) ; lf .
].
GsFile gciLogServer: report .
%

category: 'Image Upgrade'
classmethod: UpgradeStreams
_initializeForInstall
  self _initStreamLiterals .

  Globals at: #PositionableStream_position  put: #ANSI .
  self _copyMethodsTo_Portable_Streams ;
   _copyMethodsTo_legacyStreams ;
   _installPortableStreams ;
   _initTranscriptStreamPortable ;
   _testStreamLiterals ;
   _initRandoms .
  ^ true
%

category: 'Image Upgrade'
classmethod: UpgradeStreams
_initRandoms
  (Globals at: #HostRandom) initialize .
  #( Random HostRandom SeededRandom Lag1MwcRandom Lag25000CmwcRandom )
  do:[:sym | (Globals at: sym) immediateInvariant ]
%

category: 'Image Upgrade'
classmethod: UpgradeStreams
_initStreamLiterals
  Stream _initializeWriteStreamClassVars: (GemStone_Portable_Streams at: #WriteStream) .
  Stream _initializeWriteStreamClassVars:(GemStone_Legacy_Streams at: #WriteStream) .
  Stream _initializeStreamClassVars .

  Stream _initializeWriteStreamClassVars: (Globals at: #WriteStreamLegacy).
  Stream _initializeWriteStreamClassVars: (Globals at: #WriteStreamPortable).
%

category: 'Image Upgrade'
classmethod: UpgradeStreams
_initTranscriptStreamPortable
  (Globals at: #TranscriptStreamPortable) initialize.
%

category: 'Image Upgrade'
classmethod: UpgradeStreams
_installLegacyStreams: positionableStream_position
	"Install legacy classes without 'Legacy' in name into Globals

	positionableStream_position dictates which position methods implementation to use, based on original value"

	self _installStreamImplementationFrom: GemStone_Legacy_Streams.
	Globals at: #'PositionableStream_position' put: positionableStream_position.
	PositionableStream compilePositionMethods
%

category: 'Image Upgrade'
classmethod: UpgradeStreams
_installPortableStreams
"Install portable classes without 'Portable' in name into Globals"

self _installStreamImplementationFrom: GemStone_Portable_Streams
%

category: 'Image Upgrade'
classmethod: UpgradeStreams
_installStreamImplementationFrom: aSymbolDictionary
  | streamClass installBlock |
  GsFile gciLogServer:'_installStreamImplementation from ', aSymbolDictionary name printString.

  installBlock := [:className |
    streamClass := aSymbolDictionary at: className.
    Globals at: className  put: streamClass.
    GsFile gciLogServer:'   -- Globals at: ', className printString, ' put: ', streamClass asOop asString].

  installBlock value: #PositionableStream.
  installBlock value: #ReadStream.
  installBlock value: #WriteStream.
  installBlock value: #ReadByteStream.

"ReadWriteStream and FileStream defined in Portable implementation, but not in
 Legacy implementation"
(aSymbolDictionary at: #ReadWriteStream otherwise: nil) ifNil: [ 
   (Globals removeKey: #ReadWriteStream otherwise:  nil )
     ifNotNil:[:removedClass | GsFile gciLogServer: '  -- Globals removeKey: #ReadWriteStream (', removedClass asOop asString, ')' ] 
   ] ifNotNil: [:readWriteStreamClass | 
     installBlock value: #ReadWriteStream 
   ].
(aSymbolDictionary at: #FileStream otherwise: nil ) ifNil: [ 
   (Globals removeKey: #FileStream otherwise: nil)
      ifNotNil:[:removedClass | GsFile gciLogServer: '  -- Globals removeKey: #FileStream (', removedClass asOop asString, ')' ] 
   ] ifNotNil: [:fileStreamClass | 
      installBlock value: #FileStream 
   ].
%

category: 'Image Upgrade'
classmethod: UpgradeStreams
_testStreamLiterals
  | strm ary rpt exp |
  rpt := String new .
  strm := PrintStream on: String new .
  strm cr; lf ; space ; tab . "note cr same as lf for PrintStream"
  ary := { } .
  strm contents do:[:c | ary add: c  codePoint ] .
  ary = #( 10 10 32 9 ) ifFalse:[
    rpt add: 'PrintStream; ', ary printString; lf
  ].
  strm := AppendStream on: String new .
  strm cr ; crlf; crtab ; crtab: 2 ; lf ; space ; tab ; space: 2 ; tab: 2 .
  ary := { } .
  strm contents do:[:c | ary add: c  codePoint ] .
  ary = (exp := #( 13 13 10 13 9 13 9 9 10 32 9 32 32 9 9 ))
     ifFalse:[ rpt add: 'AppendStream; ', ary printString ; lf;
                   add: 'expected ', exp printString; lf ].

  "Assume portable streams are installed in virgin dbf"
  "Note WriteStreamLegacy inherits Stream>>cr which appends codepoint 10"
  { WriteStreamLegacy . (GemStone_Legacy_Streams at: #WriteStream) } do:[:cls |
    strm := cls on: String new .
    strm cr ; crlf; crtab ; crtab: 2 ; lf ; space ; tab ; space: 2; tab: 2 .
    ary := { } .
    strm contents do:[:c | ary add: c  codePoint ] .
    ary = (exp := #( 10 13 10 13 9 13 9 9 10 32 9 32 32 9 9 ))
     ifFalse:[ rpt add: cls name ,' oop ', cls asOop asString, ' ', ary printString ; lf;
                   add: 'expected ', exp printString; lf ].
  ].
  { WriteStreamPortable . (Globals at: #WriteStream) .
    (GemStone_Portable_Streams at: #WriteStream)  } do:[:cls |
    strm := cls on: String new .
    strm cr ; crlf ; crtab ; crtab: 2 ; lf ; space ; tab ; space: 2 ; tab: 2 .
    ary := { } .
    strm contents do:[:c | ary add: c  codePoint ] .
    ary = (exp := #( 13 13 10 13 9 13 9 9 10 32 9 32 32 9 9 ))
     ifFalse:[ rpt add: cls name ,' oop ', cls asOop asString, ' ', ary printString; lf;
                   add: 'expected ', exp printString; lf ].
  ].
  ary := { Character backspace .
    Character lf .
    Character cr .
    Character esc .
    Character newPage .
    Character tab } collect:[:c | c codePoint ] .
  ary = (exp := #( 8 10 13 27 12 9 )) ifFalse:[ rpt add: 'Character; ', ary printString; lf;
                   add: 'expected ', exp printString; lf ].
  rpt size == 0 ifFalse:[
     GsFile gciLogServer:rpt .
     Error signal:'Bad results(s)'.
  ].
  ^ true
%

! Class extensions for 'AppendStream'

!		Class methods for 'AppendStream'

category: 'Instance Creation'
classmethod: AppendStream
new
   "Disallowed.  To create a new AppendStream, use the class method on: instead."
   self shouldNotImplement: #new
%

category: 'Instance Creation'
classmethod: AppendStream
on: aCollection
 ^ self basicNew on: aCollection.
%

!		Instance methods for 'AppendStream'

category: 'Testing'
method: AppendStream
atEnd
  ^ self shouldNotImplement: #atEnd
%

category: 'Accessing'
method: AppendStream
collection
  ^ collection 
%

category: 'Accessing'
method: AppendStream
contents
  "Returns the contents without making a copy, for efficency."
  | res |
  res := collection .
  collection := res class new .
  ^ res
%

category: 'Character writing'
method: AppendStream
cr
"Append a return character to the receiver."
  collection addCodePoint: 13 .
%

category: 'Character writing'
method: AppendStream
crlf
"Append a carriage return character followed by a line feed character to the receiver."

  collection addAll: CrLf .
%

category: 'Character writing'
method: AppendStream
crtab
  "Append a return character, followed by a single tab character, to the
  receiver."

  collection addAll: CrTab
%

category: 'Character writing'
method: AppendStream
crtab: anInteger
  "Append a return character, followed by anInteger tab characters, to the
  receiver."

  collection addCodePoint: 13 .
  anInteger timesRepeat: [ collection addCodePoint: 9 ]
%

category: 'Positioning'
method: AppendStream
isEmpty
  ^ collection size == 0
%

category: 'Character writing'
method: AppendStream
lf
  "Append a line feed character to the receiver."
  collection addCodePoint: 10

%

category: 'Accessing'
method: AppendStream
next
  ^ self shouldNotImplement: #next
%

category: 'Adding'
method: AppendStream
nextPut: aCharacter
  ^ collection add: aCharacter .
%

category: 'Adding'
method: AppendStream
nextPutAll: aString
  ^ collection addAll: aString
%

category: 'Adding'
method: AppendStream
nextPutAllBytes: aCharacterCollection

"Adds the byte contents of aCharacterCollection to the receiver ,
 using big-endian byte ordering of aCharacterCollection .
 Returns aCharacterCollection.

 The aCharacterCollection argument must be a kind of String or
 MultiByteString."

"Used in implementation of methods to support PassiveObject."

  ^ collection addAllBytes: aCharacterCollection
%

category: 'Encoding'
method: AppendStream
nextPutAllUtf8: aCharacterOrString
 "Appends the UTF8 encoding of the argument to receiver.

  The receiver's  collection must be a String or Utf8.
  This method will signal an MessageNotUnderstood  (#addAllUtf8: not understood)
  if collection has been promoted to a MultiByteString as a side effect
  of appending code points above 255. "

 ^ collection addAllUtf8: aCharacterOrString
%

category: 'Adding'
method: AppendStream
nextPutCodePoint: aSmallInteger

  ^ collection addCodePoint: aSmallInteger
%

category: 'Private'
method: AppendStream
on: aCollection
  collection := aCollection .
%

category: 'Positioning'
method: AppendStream
position
  ^ collection size .
%

category: 'Adding'
method: AppendStream
print: anObject
  anObject printOn: self
%

category: 'Positioning'
method: AppendStream
reset
  "If collection has been set to nil by a send of #contents ,
   you need to install a new collection with #on:  ."
  collection ifNotNil:[:coll | coll  size: 0 ].
%

category: 'Positioning'
method: AppendStream
size
  ^ collection size
%

category: 'Character writing'
method: AppendStream
space
  "Append a space character to the receiver."
  collection addCodePoint: 32 .
%

category: 'Character writing'
method: AppendStream
space: anInteger
  "Append anInteger space characters to the receiver."

  anInteger timesRepeat: [  collection addCodePoint: 32 ]
%

category: 'Character writing'
method: AppendStream
tab
  "Append a tab character to the receiver."
  collection addCodePoint: 9  .
%

category: 'Character writing'
method: AppendStream
tab: anInteger
"Append anInteger tab characters to the receiver."

anInteger timesRepeat: [ collection addCodePoint: 9  ]
%

! Class extensions for 'Behavior'

!		Instance methods for 'Behavior'

category: 'SUnit'
method: Behavior
sunitAllSelectors
"This method is part of the community-maintained SUnit framework
documented at http://sunit.sourceforge.net. The current version is
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

self deprecated: 'Behavior>>sunitAllSelectors is deprecated v3.0. This method has no
senders in current SUnit.  Use allTestSelectors (and in rare cases, testSelectors).
Any dialect-specific use that might exist in some SUnit extensions should inline
their dialect-specific implementation.'.
	^self allSelectors asSortedCollection asOrderedCollection
%

category: 'SUnit'
method: Behavior
sunitSelectors
"This method is part of the community-maintained SUnit framework
documented at http://sunit.sourceforge.net. The current version is
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

        ^self selectors asSortedCollection asOrderedCollection
%

! Class extensions for 'BlockClosure'

!		Instance methods for 'BlockClosure'

category: 'SUnit'
method: BlockClosure
sunitEnsure: aBlock
"This method is part of the community-maintained SUnit framework
documented at http://sunit.sourceforge.net. The current version is
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

	^self ensure: aBlock
%

category: 'SUnit'
method: BlockClosure
sunitOn: aSignal do: anExceptionBlock
"This method is part of the community-maintained SUnit framework
documented at http://sunit.sourceforge.net. The current version is
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

	^self on: aSignal do: anExceptionBlock
%

! Class extensions for 'Character'

!		Class methods for 'Character'

category: 'Non-Printable Characters'
classmethod: Character
backspace
  "Returns the ASCII back-space Character."
  ^ Backspace
%

category: 'Non-Printable Characters'
classmethod: Character
cr
  "Returns the ASCII carriage-return Character."
  ^ Cr
%

category: 'Non-Printable Characters'
classmethod: Character
esc
  "Returns the ASCII escape Character."
  ^ Esc
%

category: 'Non-Printable Characters'
classmethod: Character
lf
  "Returns the ASCII line-feed Character."
  ^ Lf
%

category: 'Non-Printable Characters'
classmethod: Character
newPage
  "Returns the ASCII new-page (form feed) Character."
  ^ NewPage
%

category: 'Non-Printable Characters'
classmethod: Character
tab
  "Returns the ASCII tab Character."
  ^ Tab
%

! Class extensions for 'CircularTestResourceTestCase'

!		Class methods for 'CircularTestResourceTestCase'

category: 'accessing'
classmethod: CircularTestResourceTestCase
resources
	^super resources, { SimpleTestResourceCircular }
%

!		Instance methods for 'CircularTestResourceTestCase'

category: 'utility'
method: CircularTestResourceTestCase
clearOuterResourceStateDuring: aBlock
	"To let the test run at all, we only make it circular when the preventAvailability instvar is set."

	^super clearOuterResourceStateDuring:
		[SimpleTestResourceCircular reset.
		self deny: SimpleTestResourceCircular1 isAlreadyAvailable
			description: 'SimpleTestResourceCircular1 should never be available'.
		SimpleTestResourceCircular preventAvailabilityDuring:
			[self should: aBlock raise: TestResult failure].
		self deny: SimpleTestResourceCircular isAlreadyAvailable
			description: 'SimpleTestResourceCircular was set up despite having circularity set'].
%

category: 'running'
method: CircularTestResourceTestCase
testTearDownOrder
	SimpleTestResourceCircular preventAvailabilityDuring:
		[self should: [SimpleTestResourceCircular reset; isAvailable] raise: TestResult failure.
		self assert: SimpleTestResourceCircular rawCurrentForTest == false
			description: 'Circular resource not in failed setUp state'.
		self assert: SimpleTestResourceCircular1 rawCurrentForTest == false
			description: 'Circular resource not in failed setUp state'.
		super testTearDownOrder.
		self assert: SimpleTestResourceCircular1 rawCurrentForTest == nil
			description: 'Circular resource not in failed setUp state'.
		self assert: SimpleTestResourceCircular rawCurrentForTest == nil
			description: 'Circular resource not reset after pre-tearDown iteration'].
%

! Class extensions for 'Class'

!		Instance methods for 'Class'

category: 'SUnit'
method: Class
sunitName
"This method is part of the community-maintained SUnit framework
documented at http://sunit.sourceforge.net. The current version is
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

        ^self name
%

! Class extensions for 'DoubleByteSymbol'

!		Instance methods for 'DoubleByteSymbol'

category: 'SUnit'
method: DoubleByteSymbol
sunitAsClass
 "This method is part of the community-maintained SUnit framework
documented at http://sunit.sourceforge.net. The current version is
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

	^SUnitNameResolver classNamed: self
%

! Class extensions for 'Error'

!		Instance methods for 'Error'

category: 'SUnit-Preload'
method: Error
sunitAnnounce: aTestCase toResult: aTestResult
"This method is part of the community-maintained SUnit framework
documented at http://sunit.sourceforge.net. The current version is
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

	aTestResult addError: aTestCase.
	self sunitExitWith: false.
%

! Class extensions for 'ExampleSetTest'

!		Instance methods for 'ExampleSetTest'

category: 'running'
method: ExampleSetTest
setUp
	empty := Set new.
	full := Set with: 5 with: #abc
%

category: 'testing'
method: ExampleSetTest
testAdd
	empty add: 5.
	self assert: (empty includes: 5)
%

category: 'testing'
method: ExampleSetTest
testGrow
	empty addAll: (1 to: 100).
	self assert: empty size = 100
%

category: 'testing'
method: ExampleSetTest
testIllegal
	self
		should: [empty at: 5]
		raise: TestResult error.
	self
		should: [empty at: 5 put: #abc]
		raise: TestResult error
%

category: 'testing'
method: ExampleSetTest
testIncludes
	self assert: (full includes: 5).
	self assert: (full includes: #abc)
%

category: 'testing'
method: ExampleSetTest
testOccurrences
	self assert: (empty occurrencesOf: 0) = 0.
	self assert: (full occurrencesOf: 5) = 1.
	full add: 5.
	self assert: (full occurrencesOf: 5) = 1
%

category: 'testing'
method: ExampleSetTest
testRemove
	full remove: 5.
	self assert: (full includes: #abc).
	self deny: (full includes: 5)
%

! Class extensions for 'Exception'

!		Instance methods for 'Exception'

category: 'SUnit'
method: Exception
sunitExitWith: aValue
"This method is part of the community-maintained SUnit framework
documented at http://sunit.sourceforge.net. The current version is
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

	^self return: aValue
%

category: 'SUnit'
method: Exception
sunitSignalWith: aString
"This method is part of the community-maintained SUnit framework
documented at http://sunit.sourceforge.net. The current version is
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

	^self signal: aString
%

! Class extensions for 'FailingTestResourceTestCase'

!		Instance methods for 'FailingTestResourceTestCase'

category: 'utility'
method: FailingTestResourceTestCase
clearOuterResourceStateDuring: aBlock
	"Make the resource impossible to make available, then ensure that every test raises a failure but not an error (which its setUp would do if it reached it and the resource were nil)."

	^super clearOuterResourceStateDuring:
		[SimpleTestResource preventAvailabilityDuring:
			[self should: aBlock raise: TestResult failure]]
%

! Class extensions for 'FileStreamPortable'

!		Class methods for 'FileStreamPortable'

category: 'compatability'
classmethod: FileStreamPortable
fileNamed: fileName
	^ self read: fileName
%

category: 'instance creation'
classmethod: FileStreamPortable
on: aCollection

	self shouldNotImplement: #on:
%

category: 'instance creation'
classmethod: FileStreamPortable
on: aCollection from: firstIndex to: lastIndex

	self shouldNotImplement: #on:from:to:
%

category: 'instance creation'
classmethod: FileStreamPortable
read: path

	^self read: path type: #text
%

category: 'instance creation'
classmethod: FileStreamPortable
read: path type: type
	 " type: #binary, #text, #serverBinary, #serverText, #clientBinary, #clientText"

	^(self basicNew) openForRead: path type: type
%

category: 'instance creation'
classmethod: FileStreamPortable
with: aCollection

	self shouldNotImplement: #with:
%

category: 'instance creation'
classmethod: FileStreamPortable
write: path

	^self write: path mode: #create check: false type: #text
%

category: 'instance creation'
classmethod: FileStreamPortable
write: path mode: mode

	^self write: path mode: mode check: false type: #text
%

category: 'instance creation'
classmethod: FileStreamPortable
write: path mode: mode check: checkBool type: type
	"mode: #create, #append, #truncate
	 check:
	  mode == #create and check == false and the file exists, then the file is used
	  mode == #create and check == true and the file exists, an error is thrown
	  mode == #append and check == false and the file does not exist then it is created
	  mode == #append and check == true and the file does not exist an error is thrown
	  mode == #truncate and check == false and file does not exist then it is created
	  mode == #truncate and check == true and the file does not exist an error is thrown
	 type: #binary, #text, #serverBinary, #serverText, #clientBinary, #clientText
	"

	^(self basicNew) openForWrite: path mode: mode check: checkBool type: type
%

!		Instance methods for 'FileStreamPortable'

category: 'Accessing'
method: FileStreamPortable
atBeginning
"Answer true if the stream is positioned at the beginning"

^self position == 0
%

category: 'Accessing'
method: FileStreamPortable
atEnd

"Returns true if the receiver cannot access any more objects, false if it can."

	^self gsfile atEnd ifNil: [true].
%

category: 'Accessing'
method: FileStreamPortable
binary
	streamType := #binary
%

category: 'Accessing'
method: FileStreamPortable
close

	self gsfile close
%

category: 'Accessing'
method: FileStreamPortable
collectionSpecies
	"Answer the species of collection into which the receiver can stream"

	^streamType == #binary
		ifTrue: [ ByteArray ]
		ifFalse: [ String ]
%

category: 'Accessing'
method: FileStreamPortable
contents
	"Return the contents of the receiver. Do not close or otherwise touch the receiver. Return data in whatever mode the receiver is in (e.g., binary or text)."
	| s savePos |
	savePos := self position.
	self position: 0.
	s := self next: self size.
	self position: savePos.
	^s
%

category: 'Adding'
method: FileStreamPortable
cr
"Adds a newline to the output stream."

| cr |
cr := self isBinary
	ifTrue: [ Character cr codePoint ]
	ifFalse: [ Character cr ].
self nextPut: cr.
%

category: 'Accessing'
method: FileStreamPortable
externalType
	"Return a symbol that identifies the external stream type of the receiver."

	^self gsfile _isBinary
		ifTrue: [ #binary ]
		ifFalse: [ #text ]
%

category: 'Accessing'
method: FileStreamPortable
flush
	"Update a stream's backing store."

	self gsfile flush
%

category: 'Accessing'
method: FileStreamPortable
gsfile

	^gsfile
%

category: 'Testing'
method: FileStreamPortable
isBinary

	^streamType == #binary
%

category: 'Testing'
method: FileStreamPortable
isEmpty
"Returns true if the collection that the receiver accesses contains
 no elements; otherwise returns false."

^ self size = 0
%

category: 'Testing'
method: FileStreamPortable
isText

	^self isBinary not
%

category: 'Adding'
method: FileStreamPortable
lf
"Adds a linefeed to the output stream."

| lf |
lf := self isBinary
	ifTrue: [ Character lf codePoint ]
	ifFalse: [ Character lf ].
self nextPut: lf.
%

category: 'Accessing'
method: FileStreamPortable
next

	| res |
	(res := self next: 1) ifNil: [ ^nil ].
	^res at: 1
%

category: 'Accessing'
method: FileStreamPortable
next: n
	"Return a the appropriate collection species with the next n characters/bytes of the filestream in it."

	| result charSize |
	result := self collectionSpecies new.
	n = 0 ifTrue: [ ^result ]. "avoid 0 size check in #next:ofSize:into:"
	charSize := self isBinary
		ifTrue: [ 1 ]
		ifFalse: [ result charSize ].
        charSize == 1 ifTrue:[
	  (self gsfile next: n into: result ) ifNil:[ ^ nil ].
	  ^ result
        ].
	(self gsfile next: n ofSize: charSize into: result ) ifNil:[ ^ nil ].
	^ result
%

category: 'Accessing'
method: FileStreamPortable
next: anInteger putAll: aCollection startingAt: startIndex
"Store the next anInteger elements from the given collection."
(startIndex == 1 and:[ aCollection size == anInteger ])
	ifTrue:[^self nextPutAll: aCollection].
^self nextPutAll: (aCollection copyFrom: startIndex to: startIndex+anInteger-1)
%

category: 'Accessing'
method: FileStreamPortable
nextLine
"Answer next line (may be empty) without line end delimiters, or nil if at end.
Let the stream positioned after the line delimiter(s).
Handle a zoo of line delimiters CR, LF, or CR-LF pair"

self atEnd ifTrue: [ ^self collectionSpecies new ].
self isBinary
	ifTrue: [self error: '#nextLine not appropriate for a binary stream' ].
^super nextLine
%

category: 'Adding'
method: FileStreamPortable
nextPut: anObject
  "Inserts anObject as the next element that the receiver can access for writing.
 Returns anObject."

  | status |
  self isBinary
    ifTrue:
      [(anObject _isInteger) ifFalse: [^self error: 'Expected an Integer']]
    ifFalse:
      [(anObject class == Character)
        ifFalse: [^self error: 'Expected a Character']].
  status := self gsfile nextPut: anObject.
  "Status should be either true or nil."
  status == true ifFalse: [^self error: 'Unknown error writing to file'].
  ^anObject
%

category: 'Accessing'
method: FileStreamPortable
nextPutAll: aCollection

"Inserts the elements of aCollection as the next elements that the receiver can
 access.  Returns aCollection."

	aCollection do: [:each | self nextPut: each ]
%

category: 'initialization'
method: FileStreamPortable
openForRead: path type: type
	 " type: #binary, #text, #serverBinary, #serverText, #clientBinary, #clientText"

	| mode onClient |
	streamType := #text.
	(type == #binary or: [ type == #serverBinary ])
		ifTrue: [ mode := 'rb'. onClient := false. streamType := #binary ].
	(type == #text or: [ type == #serverText ] )
		ifTrue: [ mode := 'r'. onClient := false ].
	type == #clientBinary
		ifTrue: [ mode := 'rb'. onClient := true. streamType := #binary ].
	type == #clientText
		ifTrue: [ mode := 'r'. onClient := true ].
	gsfile := GsFile open: path mode: mode onClient: onClient.
	gsfile == nil ifTrue: [ ^self error: 'Error opening file: ', (GsFile classUserAction: #GsfClassError onClient: onClient with: nil) ].
%

category: 'initialization'
method: FileStreamPortable
openForWrite: path mode: modeSymbol check: check type: type
	"mode: #create, #append, #truncate
	 check:
	  mode == #create and check == false and the file exists, then the file is used
	  mode == #create and check == true and the file exists, an error is thrown
	  mode == #append and check == false and the file does not exist then it is created
	  mode == #append and check == true and the file does not exist an error is thrown
	  mode == #truncate and check == false and file does not exist then it is created
	  mode == #truncate and check == true and the file does not exist an error is thrown
	 type: #binary, #text, #serverBinary, #serverText, #clientBinary, #clientText
	"

	| prefix mode onClient |
	prefix := 'w+'.
	streamType := #text.
	modeSymbol == #append
		ifTrue: [ prefix := 'a+' ].
	(type == #binary or: [ type == #serverBinary ])
		ifTrue: [ mode := prefix, 'b'. onClient := false. streamType := #binary ].
	(type == #text or: [ type == #serverText ] )
		ifTrue: [ mode := prefix. onClient := false ].
	type == #clientBinary
		ifTrue: [ mode := prefix, 'b'. onClient := true. streamType := #binary ].
	type == #clientText
		ifTrue: [ mode := prefix. onClient := true ].
	(modeSymbol == #create and: [ check and: [ GsFile _exists: path onClient: onClient ]])
		ifTrue: [ ^self error: 'The file already exists.' ].
	((modeSymbol == #truncate or: [ modeSymbol == #append]) and: [ check and: [ (GsFile _exists: path onClient: onClient) not ]])
		ifTrue: [ ^self error: 'The file does not exist.' ].
	gsfile := GsFile open: path mode: mode onClient: onClient.
	gsfile == nil ifTrue: [ ^self error: 'Error opening file: ', (GsFile classUserAction: #GsfClassError onClient: onClient with: nil) ].
	modeSymbol == #truncate
		ifTrue: [ self truncate: 0 ].
	modeSymbol == #append
		ifTrue: [ gsfile seekFromEnd: 0 ].
%

category: 'Accessing'
method: FileStreamPortable
peek
"Returns the next element in the collection, but does not alter the current
 position reference.  If the receiver is at the end of the collection, returns
 nil."
	| pos result |

	pos := self position.
	result := self next.
	self position: pos.
	^result
%

category: 'Accessing'
method: FileStreamPortable
peek2
"Peeks at the second incoming object."

^self gsfile peek2
%

category: 'Accessing'
method: FileStreamPortable
peekFor: anObject
"Answer false and do not move over the next element if it is not equal to
the argument, anObject, or if the receiver is at the end. Answer true
and increment the position for accessing elements, if the next element is
equal to anObject."

| nextObject |
self atEnd ifTrue: [^false].
nextObject := self next.
"peek for matching element"
anObject = nextObject ifTrue: [^true].
"gobble it if found"
self position: self position - 1.
^false
%

category: 'Accessing'
method: FileStreamPortable
peekTwice

  "Returns an array containing the two elements that would would be returned
  if the message #next were sent to the receiver twice. If the receiver is at
  or reaches the end, the array will include one or two nils."

 ^ { self peek . self peek2 }
%

category: 'Accessing'
method: FileStreamPortable
position
	"Return the receiver's current file position."

	^self gsfile position
%

category: 'Accessing'
method: FileStreamPortable
position: pos
	"Set the receiver's position as indicated."

	(pos > self size or: [ pos < 0 ]) ifTrue: [ ^self error: 'Attempt to position file beyond bounds of file' ].
	self gsfile position: pos
%

category: 'Accessing'
method: FileStreamPortable
reset
"Sets the receiver's position to the beginning of the sequence of objects."

	self position: 0
%

category: 'Accessing'
method: FileStreamPortable
setToEnd
	"Set the position of the receiver to the end of the sequence of objects."

	self position: self size
%

category: 'Accessing'
method: FileStreamPortable
size

	^self gsfile fileSize
%

category: 'Accessing'
method: FileStreamPortable
skip: amount
	"Sets the receiver's position to position+amount."

	self gsfile skip: amount
%

category: 'Adding'
method: FileStreamPortable
space
"Adds a space to the output stream."

| space |
space := self isBinary
	ifTrue: [ Character space codePoint ]
	ifFalse: [ Character space ].
self nextPut: space.
%

category: 'Adding'
method: FileStreamPortable
tab
"Adds a tab to the output stream."

| tab |
tab := self isBinary
	ifTrue: [ Character tab codePoint ]
	ifFalse: [ Character tab ].
self nextPut: tab.
%

category: 'Accessing'
method: FileStreamPortable
throughAll: matchCollection

"Returns a collection of objects from the receiver up to and including the
sequence of objects in the argument 'matchCollection', leaving the stream
positioned after the sequence.  If the sequence of objects is not found, this
returns the remaining contents of the receiver and leaves me positioned
at my end."

| numMatched numToMatch result  |

numMatched := 0.
result := self collectionSpecies new.
numToMatch := matchCollection size.
[self atEnd _or: [numMatched = numToMatch]]
     whileFalse:
           [self next = (matchCollection at: numMatched + 1)
                ifTrue: [numMatched := numMatched + 1]
          ifFalse: [self position: self position - numMatched - 1.
                        result add: self next.
                        numMatched := 0]
].

"add matched or partially matched chars"
self position: self position - numMatched.
numMatched timesRepeat: [result add: self next].

^ result.
%

category: 'Accessing'
method: FileStreamPortable
truncate: pos
	"Truncate to this position"

	self position: pos.
	self gsfile flush.
	self close.
	self gsfile open.
	self position: pos
%

category: 'Accessing'
method: FileStreamPortable
upTo: anObject
"Answer a subcollection from the current access position to the
occurrence (if any, but not inclusive) of anObject in the receiver. If
anObject is not in the collection, answer the entire rest of the receiver."
| newStream element |
newStream := AppendStream on: self collectionSpecies new.
[self atEnd or: [(element := self next) = anObject]]
	whileFalse: [newStream nextPut: element].
^newStream contents
%

category: 'Accessing'
method: FileStreamPortable
upToAny: aCollection
"Answer a subcollection from the current access position to the
occurrence (if any, but not inclusive) of any objects in the given collection in the receiver. If
any of these is not in the collection, answer the entire rest of the receiver."

| newStream element |
newStream := AppendStream on: self collectionSpecies new.
[self atEnd or: [aCollection includes: (element := self next)]]
	whileFalse: [newStream nextPut: element].
^newStream contents
%

category: 'Accessing'
method: FileStreamPortable
upToAnyOf: subcollection do: aBlock
"Answer a subcollection from the current access position to the occurrence (if any, but not inclusive) of any object in the collection.
Evaluate aBlock with this occurence as argument.
If no matching object is found, don't evaluate aBlock and answer the entire rest of the receiver."

| stream ch |
stream := AppendStream on: self collectionSpecies new.
[ self atEnd or: [ (subcollection includes: (ch := self next)) and: [aBlock value: ch. true] ] ]
	whileFalse: [ stream nextPut: ch ].
^ stream contents  "private stream, no need to copy"
%

category: 'Accessing'
method: FileStreamPortable
upToEnd
	"Answer a subcollection from the current access position through the last element of the receiver."

	| stream next |
	stream := AppendStream on: self collectionSpecies new .
	[ (next := self next) == nil ] whileFalse: [
			stream nextPut: next ].
	^stream contents
%

! Class extensions for 'HostRandom'

!		Class methods for 'HostRandom'

category: 'initialize-release'
classmethod: HostRandom
initialize
	singleton := self basicNew
%

category: 'instance creation'
classmethod: HostRandom
new
	"Answer the singleton instance, opening /dev/urandom if not already open."

	singleton open.
	^singleton
%

category: 'instance creation'
classmethod: HostRandom
seed: anInteger
	"Answer a seeded random number generator seeded from the given SmallInteger"

	ImproperOperation
		signal: 'HostRandom uses the random number generator of the host random number generator, and cannot be seeded.'
%

!		Instance methods for 'HostRandom'

category: 'public'
method: HostRandom
close
	"Close /dev/urandom if open."

	self file ifNotNil:[:file |
		file close
					ifNil: [IOError signal: GsFile serverErrorString]
					ifNotNil: [SessionTemps current removeKey: #GsHostRandomFile ]]

%

category: 'private'
method: HostRandom
file
	"Answer my file (/dev/urandom), if I have one, otherwise nil"

	^ SessionTemps current at: #GsHostRandomFile otherwise: nil
%

category: 'public'
method: HostRandom
integer
	"Answer a random nonnegative 32-bit integer."

	| int file |
	file := self file.
	(file ~~ nil and: [file isOpen])
		ifFalse: [ImproperOperation signal: 'This HostRandom is closed'].
	int := 0.
	4 timesRepeat: [int := (int bitShift: 8) + file nextByte].
	^int

%

category: 'public'
method: HostRandom
isOpen
	"Answer whether /dev/urandom is open"

	^ self file ifNil:[ false ] ifNotNil:[:f | f isOpen]
%

category: 'public'
method: HostRandom
open
	"Open /dev/urandom if not already open."

	| temps key file |
	file := (temps := SessionTemps current)  at:(key := #GsHostRandomFile)  otherwise: nil .
     file ifNil: [
       file := temps at: key put: (GsFile openOnServer: '/dev/urandom' mode: 'r').
	     file ifNil:[ IOError signal: GsFile serverErrorString ]
     ]
%

! Class extensions for 'Lag1MwcRandom'

!		Instance methods for 'Lag1MwcRandom'

category: 'initialization'
method: Lag1MwcRandom
initialize

"The exact choice of these constants is crucial to obtaining the desired result.
Refer to literature on the multiply-with-carry algorithm for the relationship between the constants.
Note that the implementation of this class also implies the constant b := 2**32."

	multiplier := 698769069.
	lag := 1.
%

category: 'public'
method: Lag1MwcRandom
integer
	"Answer a random nonnegative 32-bit integer."

	| newCarryAndSeed newSeed |
	index == nil ifTrue: [self setSeedFromHost].
	newCarryAndSeed := (seeds at: index) * multiplier + carry.
	newSeed := newCarryAndSeed bitAnd: 16rFFFFFFFF.
	carry := newCarryAndSeed bitShift: -32.
	index == lag ifTrue: [index := 0].
	index := index + 1.
	seeds at: index put: newSeed.
	^newSeed

%

category: 'public'
method: Lag1MwcRandom
seed: newSeed

	"Sets the seed from the given SmallInteger."

	| upperBits lowerBits |
	newSeed _isSmallInteger ifFalse: [ArgumentError signal: 'The seed must be a SmallInteger'].

	"A SmallInteger has 61 significant bits, including the sign bit. We will use the lower 32 bits
  for the initial seed and the upper 29, including the sign, to generate the initial carry.
  The legal range for carry is [0, multiplier), which in this class is more than 2**29 but
  less than 2**30. Carry and seed cannot both be zero, so we ensure that the initial carry
  is non-zero by inverting it within its range."

	upperBits := (newSeed bitAnd: 16r1FFFFFFFFFFFFFFF) bitShift: -32.
	lowerBits := newSeed bitAnd: 16rFFFFFFFF.
	seeds := {lowerBits} .
	carry := multiplier - 1 - upperBits.
	index := 1
%

category: 'private'
method: Lag1MwcRandom
setSeedFromHost

	| random |
	random := HostRandom new.
	seeds := {random integer}.
	carry := random integer \\ multiplier.
	index := 1
%

category: 'private'
method: Lag1MwcRandom
validateFullState: fullState

	| newIndex newCarry seedArray haveNonZero haveNonMaximal |
	fullState size = 3 ifFalse: [ArgumentError signal: 'expected an Array of size 3'].
	newIndex := fullState at: 1.
	newCarry := fullState at: 2.
	seedArray := fullState at: 3.
	haveNonZero := newCarry ~= 0.
	haveNonMaximal := newCarry ~= (multiplier - 1).
	newIndex _isSmallInteger ifFalse: [ArgumentError signal: 'Index must be a SmallInteger'].
	(newIndex between: 1 and: lag) ifFalse:  [OutOfRange new
												name: 'index' min: 1 max: lag actual: newIndex;
															signal: 'out of range'].
	newCarry _isSmallInteger ifFalse: [ArgumentError signal: 'Carry must be a SmallInteger'].
	(newCarry between: 0 and: multiplier - 1) ifFalse: [OutOfRange new
															name: 'carry' min: 0 max: multiplier - 1 actual: newCarry;
															signal: 'out of range'].
	seedArray size = lag ifFalse: [ArgumentError signal: 'Expected seed array of size ' , lag printString].
	seedArray do: [:seed |
					seed _isSmallInteger ifFalse: [ArgumentError signal: 'Each seed must be a SmallInteger'].
					seed = 0 ifFalse: [haveNonZero := true].
					seed = 16rFFFFFFFF ifFalse: [haveNonMaximal := true].
					(seed between: 0 and: 16rFFFFFFFF) ifFalse: [OutOfRange new
																		name: 'seed' min: 0 max: 16rFFFFFFFF actual: seed;
																		signal: 'out of range']].
	haveNonZero ifFalse: [ArgumentError signal: 'Carry and seeds should not all be zero.'].
	haveNonMaximal ifFalse: [ArgumentError signal: 'Carry and seeds should not all be their maximal legal value.']
%

! Class extensions for 'Lag25000CmwcRandom'

!		Instance methods for 'Lag25000CmwcRandom'

category: 'initialization'
method: Lag25000CmwcRandom
initialize

    "The exact choice of these constants is crucial to obtaining the desired result.
  Refer to literature on the complementary multiply-with-carry algorithm for the
  relationship between the constants.
  Note that the implementation of this class also implies the constant b := 2**32, and none of
  the constants can be changed without changing the others."

	multiplier := 2169967.
	lag := 25000.
%

category: 'public'
method: Lag25000CmwcRandom
integer
	"Answer a random nonnegative 32-bit integer."

	| newCarryAndSeed newSeed |
	index == nil ifTrue: [self setSeedFromHost].
	newCarryAndSeed := (seeds at: index) * multiplier + carry.
	newSeed := 16rFFFFFFFF - (newCarryAndSeed bitAnd: 16rFFFFFFFF).
	carry := newCarryAndSeed bitShift: -32.
	index == lag ifTrue: [index := 0].
	index := index + 1.
	seeds at: index put: newSeed.
	^newSeed
%

category: 'public'
method: Lag25000CmwcRandom
seed: newSeed

"Sets the seed from the given SmallInteger.
 Since the seed of this class is much larger than a SmallInteger, we
 use this seed to seed a lag 1 generator, then generate our seeds with that generator."

	self setSeedFromGenerator: (Lag1MwcRandom seed: newSeed).
%

category: 'private'
method: Lag25000CmwcRandom
setSeedFromGenerator: random

	seeds := Array new: lag.
	1 to: lag do: [:i | seeds at: i put: random integer].
	carry := random integer \\ multiplier.
	index := 1
%

category: 'private'
method: Lag25000CmwcRandom
setSeedFromHost

	self setSeedFromGenerator: HostRandom new.
%

category: 'private'
method: Lag25000CmwcRandom
validateFullState: fullState

	| newIndex newCarry seedArray |
	fullState size = 3 ifFalse: [ArgumentError signal: 'expected an Array of size 3'].
	newIndex := fullState at: 1.
	newCarry := fullState at: 2.
	seedArray := fullState at: 3.
	newIndex _isSmallInteger ifFalse: [ArgumentError signal: 'Index must be a SmallInteger'].
	(newIndex between: 1 and: lag) ifFalse:  [OutOfRange new
												name: 'index' min: 1 max: lag actual: newIndex;
															signal: 'out of range'].
	newCarry _isSmallInteger ifFalse: [ArgumentError signal: 'Carry must be a SmallInteger'].
	(newCarry between: 0 and: multiplier - 1) ifFalse: [OutOfRange new
															name: 'carry' min: 0 max: multiplier - 1 actual: newCarry;
															signal: 'out of range'].
	seedArray size = lag ifFalse: [ArgumentError signal: 'Expected seed array of size ' , lag printString].
	seedArray do: [:seed |
					seed _isSmallInteger ifFalse: [ArgumentError signal: 'Each seed must be a SmallInteger'].
					(seed between: 0 and: 16rFFFFFFFF) ifFalse: [OutOfRange new
																		name: 'seed' min: 0 max: 16rFFFFFFFF actual: seed;
																		signal: 'out of range']].
%

! Class extensions for 'ManyTestResourceTestCase'

!		Class methods for 'ManyTestResourceTestCase'

category: 'accessing'
classmethod: ManyTestResourceTestCase
resources
	^super resources, { SimpleTestResourceA . SimpleTestResourceB }
%

category: 'testing'
classmethod: ManyTestResourceTestCase
shouldInheritSelectors
	^true
%

!		Instance methods for 'ManyTestResourceTestCase'

category: 'utility'
method: ManyTestResourceTestCase
clearOuterResourceStateDuring: aBlock
	"This self-testing test must clear the outer state of its resources before starting and after finishing, so that it can construct test cases and suites of itself and test them."

	self assert: SimpleTestResourceA1 isAlreadyAvailable
		description: 'The resource was not set up for the test'.
	SimpleTestResourceA reset.
	SimpleTestResourceB reset.
	SimpleTestResourceA1 reset.
	self deny: SimpleTestResourceA1 isAlreadyAvailable
		description: 'The resource was still set up before we began the run'.
	^[super clearOuterResourceStateDuring: aBlock] sunitEnsure:
		[self deny: SimpleTestResourceA1 isAlreadyAvailable
			description: 'The resource was still set up after we finished the run'.
		self deny: SimpleTestResourceB1 isAlreadyAvailable
			description: 'The resource was still set up after we finished the run'.
		SimpleTestResourceA isAvailable.
		self assert: SimpleTestResourceA1 isAlreadyAvailable
			description: 'The resource was not set up again after the test'.
		SimpleTestResourceB isAvailable.
		self assert: SimpleTestResourceB1 isAlreadyAvailable
			description: 'The resource was not set up again after the test'.].
%

category: 'running'
method: ManyTestResourceTestCase
testTearDownOrder
	| myResourceSetUpOrder myResourceReverseTearDownOrder |
	myResourceReverseTearDownOrder := OrderedCollection new: 7.
	myResourceSetUpOrder := (OrderedCollection new: 7)
		add: SimpleTestResource;
		add: SimpleTestResourceA1;
		add: SimpleTestResourceA2;
		add: SimpleTestResourceA;
		add: SimpleTestResourceB1;
		add: SimpleTestResourceB;
		yourself.
	self assert: (myResourceSetUpOrder allSatisfy: [:each | each isAvailable])
		description: 'At test start, not all my resources were set up'.
	self class resources do:
		[:each | each resetOrAddResourcesTo: myResourceReverseTearDownOrder].
	self assert: myResourceReverseTearDownOrder = myResourceSetUpOrder
		description: 'Wrong order for tearDown'.
	self assert: (myResourceSetUpOrder allSatisfy: [:each | each isAvailable])
		description: 'At test start, not all my resources were set up'.
%

! Class extensions for 'Object'

!		Instance methods for 'Object'

category: 'SUnit'
method: Object
sunitAddDependent: anObject
"This method is part of the community-maintained SUnit framework
documented at http://sunit.sourceforge.net. The current version is
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

	"GemStone does nothing!"
%

category: 'SUnit'
method: Object
sunitChanged: anAspect
"This method is part of the community-maintained SUnit framework
documented at http://sunit.sourceforge.net. The current version is
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

	"GemStone does nothing!"
%

category: 'SUnit'
method: Object
sunitRemoveDependent: anObject
"This method is part of the community-maintained SUnit framework
documented at http://sunit.sourceforge.net. The current version is
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

	"GemStone does nothing!"
%

! Class extensions for 'PositionableStreamLegacy'

!		Class methods for 'PositionableStreamLegacy'

category: 'ANSI Methods'
classmethod: PositionableStreamLegacy
compilePositionMethods

"Compile ANSI, Legacy or Warning as default methods (see bug #39503)"

| flag selector string |
flag := Globals at: #'PositionableStream_position' ifAbsent: [#'Legacy'].
selector :=
	flag == #'ANSI'		ifTrue:  [#'positionA'] ifFalse: [
	flag == #'Legacy'	ifTrue:  [#'positionL'] ifFalse: [
	flag == #'Warning'	ifTrue:  [#'positionW'] ifFalse: [
	self error: 'Invalid value for flag!']]].
string := (self compiledMethodAt: selector) sourceString.
string := (string copyFrom: 1 to: 8) , (string copyFrom: 10 to: string size).
self
	compileMethod: string
	dictionaries: GsCurrentSession currentSession symbolList
	category: 'Positioning' environmentId: 0 .
selector := (selector , ':') asSymbol.
string := (self compiledMethodAt: selector) sourceString.
string := (string copyFrom: 1 to: 8) , (string copyFrom: 10 to: string size).
self
	compileMethod: string
	dictionaries: GsCurrentSession currentSession symbolList
	category: 'Positioning' environmentId: 0 .
^true.
%

category: 'Portable Methods'
classmethod: PositionableStreamLegacy
isLegacyStreamImplementation

^true
%

category: 'Portable Methods'
classmethod: PositionableStreamLegacy
isPortableStreamImplementation

^false
%

category: 'Instance Creation'
classmethod: PositionableStreamLegacy
on: aCollection

"Returns an instance of the receiver that can stream over the elements of
 aCollection."

| newStream |

newStream := self _basicNew.
newStream _initStreamWith: aCollection.
^ newStream
%

!		Instance methods for 'PositionableStreamLegacy'

category: 'Testing'
method: PositionableStreamLegacy
atBeginning
"Answer true if the stream is positioned at the beginning"

^position == 1
%

category: 'Testing'
method: PositionableStreamLegacy
atEnd

"Returns true if the receiver cannot access any more objects, false if it can."

^ position > itsCollection size
%

category: 'Accessing'
method: PositionableStreamLegacy
backup

"Backs up the receiver one position."

self skip: -1
%

category: 'Accessing'
method: PositionableStreamLegacy
collection

"Returns the collection of the receiver."

^itsCollection
%

category: 'Accessing'
method: PositionableStreamLegacy
contents

"Returns the Collection associated with the receiver (that is,
 the sequence of objects that the receiver may access)."

^itsCollection
%

category: 'Testing'
method: PositionableStreamLegacy
isEmpty

"Returns true if the collection that the receiver accesses contains
 no elements; otherwise returns false."

^ itsCollection size == 0
%

category: 'Accessing'
method: PositionableStreamLegacy
next: count

"Returns the next count elements in the receiver's collection."

| result |
result := itsCollection species new.
count timesRepeat: [ result add: self next ].
^result
%

category: 'Accessing'
method: PositionableStreamLegacy
next: count into: anObject

"Stores the next count elements in the receiver's collection into the
 given object.  Returns the argument anObject."

| idx |
idx := 1.
count timesRepeat: [ anObject at: idx put: self next. idx := idx + 1 ].
^anObject
%

category: 'Accessing'
method: PositionableStreamLegacy
nextLine

| result cr lf char chrcls |
result := itsCollection species new.
cr := (chrcls:= Character) cr.
lf := chrcls  lf.
[(char := self peek) ~~ nil and:[ char ~~ cr and: [char ~~ lf]]] whileTrue: [
  result add: self next
].
self atEnd ifFalse: [
  self next.
  (self atEnd == false and: [char == cr and: [self peek == lf]]) ifTrue: [
    self next.
  ].
].
^result
%

category: 'Accessing'
method: PositionableStreamLegacy
nextWord

 "Assume that the receiver's collection is a kind of String.  Returns the
  next word in the string or nil if there is no next word."

 | result ch |
 result := itsCollection species new.
 self skipSeparators.
 [ (ch := self peek) ~~ nil and: [ch isSeparator == false]] whileTrue: [
   result add: self next
 ].
 result size == 0
    ifTrue: [^nil]
    ifFalse: [^result]
%

category: 'Accessing'
method: PositionableStreamLegacy
peek

"Returns the next element in the collection, but does not alter the current
 position reference.  If the receiver is at the end of the collection, returns
 nil."

| pos coll |
pos := position .
pos <= (coll := itsCollection) size ifFalse:[ ^ nil ]. "inline atEnd"
^ coll at: pos
%

category: 'Accessing'
method: PositionableStreamLegacy
peek2

"Peeks at the second incoming object."

| pos coll |
pos := position.
pos < (coll := itsCollection) size ifFalse:[ ^ nil ]. "inline atEnd"
^ coll at: pos + 1
%

category: 'Accessing'
method: PositionableStreamLegacy
peekFor: anObject

self peek = anObject ifTrue: [
  self next.
  ^true.
].
^false.
%

category: 'Accessing'
method: PositionableStreamLegacy
peekWord

"Assume that the receiver's collection is a kind of String.  Returns the
 next word in the string without moving the receiver's position."

| result pos |
pos := self position.
result := self nextWord .
self position: pos.
^result
%

category: 'Positioning'
method: PositionableStreamLegacy
position

"Returns the receiver's current position reference for accessing the sequence
 of objects.  The position is actually the next element of the collection to be
 read or written; the position is incremented by each read or write.  In
 general, to start reading or writing at the nth element of a collection, the
 position must be set to n.

 This is the ANSI method. See Bug #39503."

^position - 1.
%

category: 'Positioning'
method: PositionableStreamLegacy
position: anInteger

"Sets the receiver's current position reference for accessing the collection to
 be anInteger.  If anInteger is not within the bounds of the collection,
 generates an error.

 This is the ANSI method. See Bug #39503."

  self positionL: anInteger + 1.
%

category: 'Positioning'
method: PositionableStreamLegacy
positionA

"Returns the receiver's current position reference for accessing the sequence
 of objects.  The position is actually the next element of the collection to be
 read or written; the position is incremented by each read or write.  In
 general, to start reading or writing at the nth element of a collection, the
 position must be set to n.

 This is the ANSI method. See Bug #39503."

^position - 1.
%

category: 'Positioning'
method: PositionableStreamLegacy
positionA: anInteger

"Sets the receiver's current position reference for accessing the collection to
 be anInteger.  If anInteger is not within the bounds of the collection,
 generates an error.

 This is the ANSI method. See Bug #39503."

	self positionL: anInteger + 1.
%

category: 'Positioning'
method: PositionableStreamLegacy
positionL

"Returns the receiver's current position reference for accessing the sequence
 of objects.  The position is actually the next element of the collection to be
 read or written; the position is incremented by each read or write.  In
 general, to start reading or writing at the nth element of a collection, the
 position must be set to n.

 This is the 'Legacy' (non-ANSI) method. See Bug #39503."

^position
%

category: 'Positioning'
method: PositionableStreamLegacy
positionL: anInteger

"Sets the receiver's current position reference for accessing the collection to
 be anInteger.  If anInteger is not within the bounds of the collection,
 generates an error.

 This is the 'Legacy' (non-ANSI) method. See Bug #39503."

 (anInteger > 0 and:[ anInteger <= (itsCollection size + 1) ])
   ifTrue: [position := anInteger]
   ifFalse: [self _positionError: anInteger]
%

category: 'Positioning'
method: PositionableStreamLegacy
positionW

"This is the 'Warning' behavior to be called when you think you have replaced
 all references to #'position' with #'positionL' or #'positionA'.
 Replace #'position' with this when you think there are no senders."

Warning signal:'In PositionableStreamLegacy >> positionW'.
^self positionL.
%

category: 'Positioning'
method: PositionableStreamLegacy
positionW: anInteger

"This is the 'Warning' behavior to be called when you think you have replaced
 all references to #'position:' with #'positionL:' or #'positionA:'.
 Replace #'position:' with this when you think there are no senders."

Warning signal:'In PositionableStreamLegacy >> positionW'.
^self positionL: anInteger.
%

category: 'Positioning'
method: PositionableStreamLegacy
reset

"Sets the receiver's position to the beginning of the sequence of objects."

position := 1
%

category: 'Positioning'
method: PositionableStreamLegacy
setToEnd

"Sets the receiver's position to the end of the sequence of objects."

self positionL: itsCollection size + 1
%

category: 'Accessing'
method: PositionableStreamLegacy
skip: amount

"Sets the receiver's position to position+amount."

self position: self position + amount
%

category: 'Accessing'
method: PositionableStreamLegacy
skipAny: chars

"Skip past all Characters in chars.  Returns the number of Characters skipped."

| skipped ch |
skipped := 0.
[ (ch := self peek) ~~ nil and: [(chars includesIdentical: ch )]] whileTrue: [
  self next.
  skipped := skipped + 1.
].
^skipped
%

category: 'Accessing'
method: PositionableStreamLegacy
skipSeparators

"Skip any objects immediately next in the stream that respond true to
 isSeparator."
| ch |
[ (ch := self peek) ~~ nil and:[ ch isSeparator ]] whileTrue: [ self next ]
%

category: 'Accessing'
method: PositionableStreamLegacy
throughAll: matchCollection

"Returns a collection of objects from the receiver up to and including the
sequence of objects in the argument 'matchCollection', leaving the stream
positioned after the sequence.  If the sequence of objects is not found, this
returns the remaining contents of the receiver and leaves me positioned
at my end."

| numMatched numToMatch result  |

numMatched := 0.
result := itsCollection species new.
numToMatch := matchCollection size.
[self atEnd or: [numMatched == numToMatch]]
     whileFalse:
           [self next = (matchCollection at: numMatched + 1)
                ifTrue: [numMatched := numMatched + 1]
          ifFalse: [position := position - numMatched - 1.
                        result add: self next.
                        numMatched := 0]
].

"add matched or partially matched chars"
position := position - numMatched.
numMatched timesRepeat: [result add: self next].

^ result.
%

category: 'Accessing'
method: PositionableStreamLegacy
upTo: anObject

"Returns all objects up to the given value or the end of the stream."

| result obj |
result := itsCollection species new.
[ true ] whileTrue:[
  self atEnd ifTrue:[ ^ result ].
  obj := self next .
  anObject = obj ifTrue:[ ^ result ].
  result add: obj
]
%

category: 'Accessing'
method: PositionableStreamLegacy
upTo: anObject do: aBlock

"Sends each object encountered to the given block until the end of stream
 or the given value is encountered.  Returns the receiver."

| obj |
[ true ] whileTrue:[
  self atEnd ifTrue:[ ^ self ].
  obj := self next .
  anObject = obj ifTrue:[ ^ self ].
  aBlock value: obj
]
%

category: 'Accessing'
method: PositionableStreamLegacy
upToAll: matchCollection

"Returns a collection of objects from the receiver up to, but not including,
 the sequence of objects in the argument 'matchCollection', leaving the stream
 positioned to read the sequence.  If the sequence of objects is not found,
 this returns the remaining contents of the receiver and leaves the stream
 positioned at the end."

| numMatched numToMatch result |

numMatched := 0.
result := itsCollection species new.
numToMatch := matchCollection size.
[self atEnd or: [numMatched == numToMatch]] whileFalse: [
  self next = (matchCollection at: numMatched + 1)
      ifTrue: [numMatched := numMatched + 1]
      ifFalse: [position := position - numMatched - 1.
    		result add: self next.
                numMatched := 0]
].
"Position before any partial or complete match we might have found."
position := position - numMatched.

"If the match was not complete, must add any partially matched chars."
numMatched ~~ numToMatch
  ifTrue: [numMatched timesRepeat: [result add: self next]].

^ result.
%

category: 'Accessing'
method: PositionableStreamLegacy
upToAny: objects

"Returns all objects up to one of the given collection of objects or the end
 of the stream."

| result obj |
result := itsCollection species new.
[ (obj := self peek) ~~ nil and: [(objects includesIdentical: obj) == false]] whileTrue: [
  result add: self next
].
self atEnd ifFalse: [
  self next
].
^result
%

category: 'Accessing'
method: PositionableStreamLegacy
upToAny: objects do: aBlock

"Send each Character encountered to aBlock until the end of stream
 or one of the given Characters is encountered."
| obj |
[(obj := self peek) ~~ nil and: [(objects includesIdentical: obj) == false]] whileTrue: [
  aBlock value: self next
].
self atEnd ifFalse: [ self next ].
%

category: 'Accessing'
method: PositionableStreamLegacy
upToEnd

"Returns all Characters from the current position to the end of the stream."

| result end coll |
end := (coll := itsCollection) size .
result := coll copyFrom: position to: end .
position :=  end + 1 .
^ result
%

category: 'Accessing'
method: PositionableStreamLegacy
_collection

"Returns the collection of the receiver."

^itsCollection
%

category: 'Positioning'
method: PositionableStreamLegacy
_initStreamWith: aCollection

"Initialize the receiver's 'itsCollection' instance variable to be
 aCollection."

itsCollection := aCollection.
position := 1.
%

category: 'Positioning'
method: PositionableStreamLegacy
_positionError: anInteger

"Returns an error message that anInteger is out of bounds of the Collection."

^ self _error: #rtErrBadStreamPosition args: { anInteger }
%

! Class extensions for 'PositionableStreamPortable'

!		Class methods for 'PositionableStreamPortable'

category: 'Portable Methods'
classmethod: PositionableStreamPortable
isLegacyStreamImplementation

^false
%

category: 'Portable Methods'
classmethod: PositionableStreamPortable
isPortableStreamImplementation

^true
%

category: 'Instance Creation'
classmethod: PositionableStreamPortable
on: aCollection
"Answer an instance of me, streaming over the elements of aCollection."

^self basicNew on: aCollection.
%

category: 'Instance Creation'
classmethod: PositionableStreamPortable
on: aCollection from: firstIndex to: lastIndex
"Answer an instance of me, streaming over the elements of aCollection
starting with the element at firstIndex and ending with the one at
lastIndex."

	^self basicNew on: (aCollection copyFrom: firstIndex to: lastIndex)
%

!		Instance methods for 'PositionableStreamPortable'

category: 'Converting'
method: PositionableStreamPortable
asPetitStream
	"Some of my subclasses do not use the instance-variables collection, position and readLimit but instead have a completely different internal representation. In these cases just use the super implementation that is inefficient but should work in all cases."

"
	Disabled until we agree on some way how to optimize this

	^ (collection isNil or: [ position isNil or: [ readLimit isNil ] ])
		ifFalse: [ PPStream on: collection from: ( position + 1 ) to: readLimit ]
      ifTrue: [ super asPetitStream ]
"
	^ super asPetitStream
%

category: 'Testing'
method: PositionableStreamPortable
atBeginning
"Answer true if the stream is positioned at the beginning"

^position == 0
%

category: 'Testing'
method: PositionableStreamPortable
atEnd
"Returns true if the receiver cannot access any more objects, false if it can."

^position >= readLimit
%

category: 'Testing'
method: PositionableStreamPortable
beforeEnd
"Returns true if the receiver can access more objects, false if not .
 GemStone extension. "

^position < readLimit
%

category: 'Accessing'
method: PositionableStreamPortable
collection
	^ collection
%

category: 'Accessing'
method: PositionableStreamPortable
collectionSpecies

  ^ collection species
%

category: 'Accessing'
method: PositionableStreamPortable
contents
"Answer with a copy of my collection from 1 to readLimit."

^collection copyFrom: 1 to: (readLimit ifNil:[ collection size])
%

category: 'Testing'
method: PositionableStreamPortable
isEmpty
"Answer whether the receiver's contents has no elements."

"Returns true if both the set of past and future sequence values of
the receiver are empty. Otherwise returns false"

 ^ (position ifNotNil:[:p | p >= readLimit] ifNil:[ self atEnd]) and:[ position == 0 ]
%

category: 'Comparing'
method: PositionableStreamPortable
match: subCollection
"Set the access position of the receiver to be past the next occurrence of the subCollection. Answer whether subCollection is found.  No wildcards, and case does matter."
| pattern startMatch |
pattern := ReadStreamPortable on: subCollection.
startMatch := nil.
[ pattern atEnd ] whileFalse:
	[ 
   (position ifNotNil:[:p | p >= readLimit] ifNil:[ self atEnd]) ifTrue:[ ^ false ].
	  self next = pattern next
		  ifTrue: [ pattern position = 1 ifTrue: [ startMatch := self position ] ]
		  ifFalse:
			  [ pattern position: 0.
			  startMatch ifNotNil:
				  [ self position: startMatch.
				  startMatch := nil ] ] ].
^ true
%

category: 'Accessing'
method: PositionableStreamPortable
next: amount
"Answer the next amount elements of my collection. Must override
because default uses self contents species, which might involve a large
collection."

| newArray |
amount < 0 ifTrue: [ ^self error: 'amount may not be less than 0' ].
newArray := collection species new: amount.
1 to: amount do: [:index | newArray at: index put: self next].
^newArray
%

category: 'Accessing'
method: PositionableStreamPortable
next: n into: aCollection
"Read n objects into the given collection.
Return aCollection or a partial copy if less than
n elements have been read."
^self next: n into: aCollection startingAt: 1
%

category: 'Accessing'
method: PositionableStreamPortable
next: n into: aCollection startingAt: startIndex
"Read n objects into the given collection.
Return aCollection or a partial copy if less than
n elements have been read."
| obj |
0 to: n-1 do:[:i|
	(obj := self next) == nil ifTrue:[^aCollection copyFrom: 1 to: startIndex+i-1].
	aCollection at: startIndex+i put: obj].
^aCollection
%

category: 'Adding'
method: PositionableStreamPortable
next: anInteger putAll: aCollection startingAt: startIndex
"Store the next anInteger elements from the given collection."
(startIndex == 1 and:[anInteger == aCollection size])
	ifTrue:[^self nextPutAll: aCollection].
^self nextPutAll: (aCollection copyFrom: startIndex to: startIndex+anInteger-1)
%

category: 'Accessing'
method: PositionableStreamPortable
nextLine
"Answer next line (may be empty) without line end delimiters, or nil if at end.
Leave the stream positioned after the line delimiter(s).
Handle a zoo of line delimiters CR, LF, or CR-LF pair"

| cr lf result ch |
(position ifNotNil:[:p | p >= readLimit] ifNil:[ self atEnd]) ifTrue:[ ^ nil ].
cr := Character cr.
lf := Character lf.
result := self collectionSpecies new.
[ ch := self next .
  (ch == cr or:[ ch == lf ]) ifTrue:[
    ch == cr ifTrue:[ self peekFor: lf ].
    ^ result
  ].
  result add: ch .
  self atEnd 
] whileFalse .
^ result
%

category: 'Positioning'
method: PositionableStreamPortable
on: aCollection

collection := aCollection.
readLimit := aCollection size.
position := 0.
self reset
%

category: 'Accessing'
method: PositionableStreamPortable
peek
"Answer what would be returned if the message next were sent to the
receiver. If the receiver is at the end, answer nil."

| nextObject |
(position ifNotNil:[:p | p >= readLimit] ifNil:[ self atEnd]) ifTrue:[ ^ nil ].
nextObject := self next.
position := position - 1.
^nextObject
%

category: 'Accessing'
method: PositionableStreamPortable
peek2
"Peeks at the second incoming object."

| nextObject |
position + 1 >= readLimit ifTrue: [^nil].
nextObject := self next; next.
position := position - 2.
^nextObject
%

category: 'Accessing'
method: PositionableStreamPortable
peekFor: anObject
"Answer false and do not move over the next element if it is not equal to
the argument, anObject, or if the receiver is at the end. Answer true
and increment the position for accessing elements, if the next element is
equal to anObject."

| nextObject |
(position ifNotNil:[:p | p >= readLimit] ifNil:[ self atEnd]) ifTrue:[ ^ false ].
nextObject := self next.
"peek for matching element"
anObject = nextObject ifTrue: [^true].
"gobble it if found"
position := position - 1.
^false
%

category: 'Accessing'
method: PositionableStreamPortable
peekTwice
  "Answer an array containing the two elements that would would be returned
  if the message #next were sent to the receiver twice. If the receiver is at
  or reaches the end, the array will include one or two nils."

	| array |
  (position ifNotNil:[:p | p >= readLimit] ifNil:[ self atEnd]) 
		ifTrue: [^ {  nil . nil } ].
	array := { self next .  self peek } .
	position := position - 1.
	^array
%

category: 'Positioning'
method: PositionableStreamPortable
position
"Answer the current position of accessing the sequence of objects."

^position
%

category: 'Positioning'
method: PositionableStreamPortable
position: anInteger
"Set the current position for accessing the objects to be anInteger, as long
as anInteger is within the bounds of the receiver's contents. If it is not,
create an error notification."

(anInteger >= 0 and: [anInteger <= readLimit])
	ifTrue: [position := anInteger]
	ifFalse: [self positionError: anInteger]
%

category: 'Positioning'
method: PositionableStreamPortable
positionError: anInteger
"Returns an error message that anInteger is out of bounds of the Collection."

^ self _error: #rtErrBadStreamPosition args: { anInteger }
%

category: 'Positioning'
method: PositionableStreamPortable
reset
"Set the receiver's position to the beginning of the sequence of objects."

position := 0
%

category: 'Positioning'
method: PositionableStreamPortable
setToEnd
"Set the position of the receiver to the end of the sequence of objects."

position := readLimit
%

category: 'Accessing'
method: PositionableStreamPortable
skip: anInteger
"Set the receiver's position to be the current position+anInteger. A
subclass might choose to be more helpful and select the minimum of the
receiver's size and position+anInteger, or the maximum of 0 and
position+anInteger for the repositioning."

self position: position + anInteger
%

category: 'Accessing'
method: PositionableStreamPortable
skipSeparators
[self atEnd]
	whileFalse:
	[self next isSeparator ifFalse: [^ self position: self position-1]]
%

category: 'Accessing'
method: PositionableStreamPortable
skipTo: anObject
"Set the access position of the receiver to be past the next occurrence of
anObject. Answer whether anObject is found."

[self atEnd]
	whileFalse: [self next = anObject ifTrue: [^true]].
^false
%

category: 'Accessing'
method: PositionableStreamPortable
upTo: anObject
"Answer a subcollection from the current access position to the
occurrence (if any, but not inclusive) of anObject in the receiver. If
anObject is not in the collection, answer the entire rest of the receiver."
| newStream element |
newStream := AppendStream on: collection species new.
[self atEnd or: [(element := self next) = anObject]]
	whileFalse: [newStream nextPut: element].
^newStream contents
%

category: 'Accessing'
method: PositionableStreamPortable
upToAll: aCollection
"Answer a subcollection from the current access position to the occurrence (if any, but not inclusive) of aCollection. If aCollection is not in the stream, answer the entire rest of the stream."

| startPos endMatch result |
startPos := self position.
(self match: aCollection)
	ifTrue: [endMatch := self position.
		self position: startPos.
		result := self next: endMatch - startPos - aCollection size.
		self position: endMatch.
		^ result]
	ifFalse: [self position: startPos.
		^ self upToEnd]
%

category: 'Accessing'
method: PositionableStreamPortable
upToAny: aCollection
"Answer a subcollection from the current access position to the
occurrence (if any, but not inclusive) of any objects in the given collection in the receiver. If
any of these is not in the collection, answer the entire rest of the receiver."

| newStream element |
newStream := AppendStream on: collection species new.
[self atEnd or: [aCollection includes: (element := self next)]]
	whileFalse: [newStream nextPut: element].
^newStream contents
%

category: 'Accessing'
method: PositionableStreamPortable
upToAnyOf: subcollection do: aBlock
"Answer a subcollection from the current access position to the occurrence (if any, but not inclusive) of any object in the collection.
Evaluate aBlock with this occurence as argument.
If no matching object is found, don't evaluate aBlock and answer the entire rest of the receiver."

| stream ch |
stream := AppendStream on: collection species new.
[ self atEnd or: [ (subcollection includes: (ch := self next)) and: [aBlock value: ch. true] ] ]
	whileFalse: [ stream nextPut: ch ].
^ stream contents
%

category: 'Accessing'
method: PositionableStreamPortable
upToEnd
"Answer a subcollection from the current access position through the last element of the receiver."

| newStream |
newStream := AppendStream on: collection species new.
[self atEnd] whileFalse: [ newStream nextPut: self next ].
^ newStream contents
%

category: 'Accessing'
method: PositionableStreamPortable
_collection

"Returns the collection of the receiver."

^collection
%

! Class extensions for 'QuadByteSymbol'

!		Instance methods for 'QuadByteSymbol'

category: 'SUnit'
method: QuadByteSymbol
sunitAsClass
 "This method is part of the community-maintained SUnit framework
documented at http://sunit.sourceforge.net. The current version is
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

	^SUnitNameResolver classNamed: self
%

! Class extensions for 'Random'

!		Class methods for 'Random'

category: 'instance creation'
classmethod: Random
new
	"Answer the host random singleton"

	^HostRandom new
%

category: 'instance creation'
classmethod: Random
seed: aSmallInteger
	"Answer a seeded random number generator seeded from the given SmallInteger"

	^Lag1MwcRandom seed: aSmallInteger
%

!		Instance methods for 'Random'

category: 'public'
method: Random
float
	"Answer a random Float in the range [0,1); or equivalently [0, 1[
	There are 2**53 possible results, equally spaced in the interval and
	generated with equal probability.

	To compute a float in this range, we need 53 random bits. Since bits come in chunks of 32,
	we grab 64 bits from the raw generator and discard the excess. More than 53 bits would result
	in floating point rounding which could improperly push the result to 1.0."

	^ (self integer bitAnd: 16rfffff800) * 2.3283064365386963E-10 + self integer * 2.3283064365386963E-10

	"2.3283064365386963E-10, expressed as a binary float, is exactly 2.0 raisedToInteger: -32, so
	multiplying by it is equivalent to a 32-bit right shift."
%

category: 'public'
method: Random
floats: n
	"Answer a collection of n random floats. N must be a positive integer."

	| result |
	result := Array new: n.
	1 to: n do: [:i | result at: i put: self float].
	^result
%

category: 'public'
method: Random
integer
	"Answer a random nonnegative 32-bit integer."

	^self subclassResponsibility: #integer
%

category: 'public'
method: Random
integerBetween: l and: h
	"Answer a random integer in the given interval. Both l and h must be numbers,
	h must be greater than or equal to l, and there must be at least one integer
  in the range from l to h.
	Examples:
		| random x y z |
		random := Random new.
		x := random integerBetween: 1 and: 20.
		y := random integerBetween: -5 and: 5.
		z := random integerBetween: 2.4 and: 257/3
  "
	|  low high modulus bitValues randomBits maxBits |
	low := l ceiling.
	high := h floor.
	modulus := high - low + 1.
	modulus > 0 ifFalse: [ArgumentError signal: 'range includes no integers'].
	bitValues := 16r100000000. "How many possible values of randomBits"
	modulus > bitValues ifTrue: [ArgumentError signal: 'Intervals > 2**32 not yet supported'].
	maxBits := bitValues - (bitValues \\ modulus).
	[randomBits := self integer. "[0, 16rFFFFFFFF]"
	randomBits > maxBits] whileTrue.
	^randomBits \\ modulus + low.
%

category: 'public'
method: Random
integers: n
	"Answer a collection of n random nonnegative 32-bit integers. N must be a positive integer."

	| result |
	result := Array new: n.
	1 to: n do: [:i | result at: i put: self integer].
	^result
%

category: 'public'
method: Random
integers: n between: l and: h
	"Answer a collection of n random integers between l and h.  N must be a positive integer."

	| result |
	result := Array new: n.
	1 to: n do: [:i | result at: i put: (self integerBetween: l and: h)].
	^result
%

category: 'compatibility'
method: Random
next
	"A synonym for #float, provided for compatibility with other Smalltalk implementations."

	^ self float.
%

category: 'public'
method: Random
smallInteger
	"Answer a random SmallInteger, [-2**60..2**60).
	This requires 61 bits including the sign bit.  We get 64 bits from the underlying generator,
  use 60 bits to compute a full-range positive SmallInteger, then conditionally negate
  it based on one of the extra bits."

	| highOrder lowOrder result |
	highOrder := self integer.
	lowOrder := self integer.
	result := ((highOrder bitAnd: 16rFFFFFFF) bitShift: 32) + lowOrder.
	^(highOrder bitAnd: 16r80000000) = 0
		ifTrue: [result]
		ifFalse: [result negated - 1]
%

category: 'public'
method: Random
smallIntegers: n
	"Answer a collection of n random SmallIntegers. N must be a positive integer."

	| result |
	result := Array new: n.
	1 to: n do: [:i | result at: i put: self smallInteger].
	^result
%

! Class extensions for 'ReadByteStreamLegacy'

!		Class methods for 'ReadByteStreamLegacy'

category: 'Instance Creation'
classmethod: ReadByteStreamLegacy
on: aCollection
  (aCollection _stringCharSize == 0) ifTrue:[
     ArgumentError signal:'expected a String, MultiByteString, or ByteArray'.
  ].
  ^ super on: aCollection
%

!		Instance methods for 'ReadByteStreamLegacy'

category: 'Accessing'
method: ReadByteStreamLegacy
next
  | pos |
  (itsCollection atOrNil: (pos := position)) ifNotNil:[:res |
     position := pos + 1 .
     ^ res
  ].
  ^ EndOfStream signal
%

category: 'Accessing'
method: ReadByteStreamLegacy
nextOrNil
 "Returns the next object that the receiver can access for reading.
  Returns nil if an attempt is made to read beyond the end of the stream.
  For use with Streams whose collections do not contain nil .
 "
  | pos |
  (itsCollection atOrNil: (pos := position)) ifNotNil:[:res |
     position := pos + 1 .
     ^ res
  ].
  ^ nil
%

category: 'Accessing'
method: ReadByteStreamLegacy
peek
"Returns the next element in the collection, but does not alter the current
 position reference.  If the receiver is at the end of the collection, returns
 nil."

 ^ itsCollection atOrNil: position
%

category: 'Accessing'
method: ReadByteStreamLegacy
peek2
 "Peeks at the second incoming object."
  ^ itsCollection atOrNil: position + 1 .
%

! Class extensions for 'ReadByteStreamPortable'

!		Class methods for 'ReadByteStreamPortable'

category: 'Instance Creation'
classmethod: ReadByteStreamPortable
on: aCollection
  (aCollection _stringCharSize == 0) ifTrue:[
     ArgumentError signal:'expected a String, MultiByteString, or ByteArray'.
  ].
  ^ super on: aCollection
%

category: 'Instance Creation'
classmethod: ReadByteStreamPortable
on: aCollection from: firstIndex to: lastIndex
  "disallowed"
  self shouldNotImplement: #on:from:to:
%

!		Instance methods for 'ReadByteStreamPortable'

category: 'Accessing'
method: ReadByteStreamPortable
atEnd
  ^ (collection atOrNil: position + 1) == nil 
%

category: 'Accessing'
method: ReadByteStreamPortable
beforeEnd
  ^ (collection atOrNil: position + 1) ~~ nil 
%

category: 'Accessing'
method: ReadByteStreamPortable
contents
"Answer with a copy of my collection from 1 to readLimit."

^collection copyFrom: 1 to: collection size
%

category: 'Testing'
method: ReadByteStreamPortable
isEmpty
"Answer whether the receiver's contents has no elements."

"Returns true if both the set of past and future sequence values of
the receiver are empty. Otherwise returns false"

 ^ position ifNotNil:[:p | position == 0 ] ifNil: [ ^ true ]
%

category: 'Comparing'
method: ReadByteStreamPortable
match: subCollection
"Set the access position of the receiver to be past the next occurrence of the subCollection. Answer whether subCollection is found.  No wildcards, and case does matter."
| pattern startMatch |
pattern := ReadStreamPortable on: subCollection.
startMatch := nil.
[ pattern atEnd ] whileFalse:
  [
    self atEnd ifTrue:[ ^ false ].
    self next = pattern next
      ifTrue: [ pattern position = 1 ifTrue: [ startMatch := self position ] ]
      ifFalse:
        [ pattern position: 0.
        startMatch ifNotNil:
          [ self position: startMatch.
          startMatch := nil ] ] ].
^ true
%

category: 'Accessing'
method: ReadByteStreamPortable
next
 "Returns the next object that the receiver can access for reading.
  Returns nil if an attempt is made to read beyond the end of the stream."
  | pos |
  (collection atOrNil: (pos := position + 1)) ifNotNil:[:res | 
     position := pos  .
     ^ res
  ].
  ^ nil
%

category: 'Accessing'
method: ReadByteStreamPortable
next: amount
 "Answer the next amount elements of my collection."

 | ans endPosition pos |
 amount < 0 ifTrue: [ ^self error: 'amount may not be less than 0' ].
 
 endPosition := (pos := position) + amount  min:  collection size .
 ans := collection copyFrom: pos+1 to: endPosition.
 position := endPosition.
 ^ans
%

category: 'Accessing'
method: ReadByteStreamPortable
next: n into: aCollection startingAt: startIndex
 "Read n objects into the given collection.
  Return aCollection or a partial copy if less than
  n elements have been read."
  | max pos |
  max := (collection size  - (pos := position)) min: n.
  aCollection
    replaceFrom: startIndex
    to: startIndex+max-1
    with: collection
    startingAt: pos +1.
  position := pos + max.
  max = n
    ifTrue:[^aCollection]
    ifFalse:[^aCollection copyFrom: 1 to: startIndex+max-1]
%

category: 'Accessing'
method: ReadByteStreamPortable
nextLine
"Answer next line (may be empty) without line end delimiters, or nil if at end.
Leave the stream positioned after the line delimiter(s).
Handle a zoo of line delimiters CR, LF, or CR-LF pair"

| cr lf result ch |
self atEnd ifTrue: [ ^nil ].
cr := Character cr.
lf := Character lf.
result := self collectionSpecies new.
[ ch := self next .
  (ch == cr or:[ ch == lf ]) ifTrue:[
    ch == cr ifTrue:[ self peekFor: lf ].
    ^ result
  ].
  result add: ch .
  self atEnd
] whileFalse .
^ result
%

category: 'Accessing'
method: ReadByteStreamPortable
nextOrNil
 "Returns the next object that the receiver can access for reading.
  Returns nil if an attempt is made to read beyond the end of the stream."
  | pos |
  (collection atOrNil: (pos := position + 1)) ifNotNil:[:res | 
     position := pos  .
     ^ res
  ].
  ^ nil
%

category: 'Positioning'
method: ReadByteStreamPortable
on: aCollection
  collection := aCollection.
  readLimit := nil .
  position := 0.
%

category: 'Private'
method: ReadByteStreamPortable
on: aCollection from: firstIndex to: lastIndex
  "disallowed"
  self shouldNotImplement: #on:from:to:
%

category: 'Accessing'
method: ReadByteStreamPortable
peek
  "Answer what would be returned if the message next were sent to the
  receiver. If the receiver is at the end, answer nil. 
  Reimplemented as an optimization"
  ^ collection atOrNil: position + 1 .
%

category: 'Accessing'
method: ReadByteStreamPortable
peek2
 "Peeks at the second incoming object.   
  Returns nil if there are not 2 more elements in the receiver."

  ^ collection atOrNil: position + 2 
%

category: 'Accessing'
method: ReadByteStreamPortable
peekFor: anObject
 "Answer false and do not move over the next element if it is not equal to
 the argument, anObject, or if the receiver is at the end. Answer true
 and increment the position for accessing elements, if the next element is
 equal to anObject."

  | nextObject pos |
  nextObject := collection atOrNil: (pos:= position + 1) .
  nextObject ifNil:[ ^ false ].
  anObject = nextObject ifTrue:[ 
    position := pos .
    ^true
  ].
  ^ false
%

category: 'Accessing'
method: ReadByteStreamPortable
peekN: anInteger
  "Peek returning the next N characters of collection."
  | end start lim |
  position >= (lim := collection size) ifTrue:[ ^ collection class new ].
  start := position + 1 .
  end := start + anInteger - 1.
  end >= lim ifTrue:[ end := lim - 1 ].
  ^ collection copyFrom: start to: end
%

category: 'Accessing'
method: ReadByteStreamPortable
peekTwice
  "Answer an array containing the two elements that would would be returned
  if the message #next were sent to the receiver twice. If the receiver is at
  or reaches the end, the array will include one or two nils."

	| array |
  self atEnd
		ifTrue: [^ {  nil . nil } ].
	array := { self next .  self peek } .
	position := position - 1.
	^array
%

category: 'Positioning'
method: ReadByteStreamPortable
position: anInteger
   "Set the current position for accessing the objects to be anInteger, as long
   as anInteger is within the bounds of the receiver's contents. If it is not,
   create an error notification."
   
   (anInteger >= 0 and: [anInteger <= collection size ])
     ifTrue: [position := anInteger]
     ifFalse: [self positionError: anInteger]
%

category: 'Accessing'
method: ReadByteStreamPortable
size
  ^ collection size
%

category: 'Accessing'
method: ReadByteStreamPortable
skip: anInteger
 "Set the receiver's position to be the current position+anInteger. Do not
  throw error if skipAmount would exceed collection bounds - ANSI compliance. "

 self position: ((position + anInteger max: 0) min: collection size )
%

category: 'Accessing'
method: ReadByteStreamPortable
upTo: anObject
 "fast version using indexOf:"
  | start end |
  start := position+1.
  end := collection indexOf: anObject startingAt: start .
  "not present--return rest of the collection"
  end == 0 ifTrue: [ ^self upToEnd ].

  "skip to the end and return the data passed over"
  position := end.
  ^ collection copyFrom: start to: (end-1)
%

category: 'Accessing'
method: ReadByteStreamPortable
upToEnd
  | start pos |
  start := 1 + position .
  position := (pos := collection size ) .
  ^ collection copyFrom: start to: pos
%

! Class extensions for 'ReadStreamLegacy'

!		Class methods for 'ReadStreamLegacy'

category: 'Instance Creation'
classmethod: ReadStreamLegacy
new

"Disallowed.  To create a new ReadStream, use the class method on: instead."

self shouldNotImplement: #new
%

!		Instance methods for 'ReadStreamLegacy'

category: 'Accessing'
method: ReadStreamLegacy
next

"Returns the next object that the receiver can access for reading.  Generates
 an error if an attempt is made to read beyond the end of the stream."
| pos coll |
pos := position .
pos > (coll := itsCollection) size ifTrue:[ ^ EndOfStream signal ]. "inline atEnd check"
position := pos + 1 .
^ itsCollection at: pos
%

category: 'Private'
method: ReadStreamLegacy
nextBytes: count addTo: anObject
"Used by PassiveObject, avoid use of replaceFrom primitives to avoid
  promotion of a String to Unicode16 for codepoints above 127 
  when (Globals at: #StringConfiguration) == Unicode16."
count <= 0 ifTrue:[ ^ 0 ].
(self atEnd)
   ifTrue: [ ^ EndOfStream signal ].
anObject addAllBytes: (itsCollection copyFrom: position to: position + count - 1).
position := position + count.
^ count

%

category: 'Accessing'
method: ReadStreamLegacy
nextElements: count into: anObject

"Stores the next count elements that the receiver can access for reading
 into anObject.  The receiver's collection and anObject must be compatible
 SequenceableCollections.  Returns the count of elements read.

 Generates an error if an attempt is made to read beyond the end of the stream."

"Used by PassiveObject."

count <= 0 ifTrue:[ ^ 0 ].
(self atEnd)
   ifTrue: [ ^ EndOfStream signal ].

anObject replaceFrom: 1 to: 1 + count - 1 with: itsCollection startingAt: position .
position := position + count.
^ count
%

category: 'Testing'
method: ReadStreamLegacy
nextMatchFor: anObject

	"The first object is removed from the receiver's future sequence value and appended to the end of
	the receiver's past sequence values. The value that would result from sending #= to the object with
	anObject as the argument is returned.
	The results are undefined if there are no future sequence values in the receiver.

	ANSI 5.9.2.6"

	^self next = anObject.
%

category: 'Accessing'
method: ReadStreamLegacy
nextOrNil
 "Returns the next object that the receiver can access for reading.
  Returns nil if an attempt is made to read beyond the end of the stream.
  For use with Streams whose collections do not contain nil .
"
 | pos coll res |
 pos := position .
 pos > (coll := itsCollection) size ifTrue:[ ^ nil ]. "inline atEnd check"
 res := coll at: pos .
 position := pos + 1 .
 ^ res
%

category: 'Adding'
method: ReadStreamLegacy
nextPut: anObject

"Disallowed.  You cannot write to a ReadStream."

self shouldNotImplement: #nextPut:
%

category: 'Adding'
method: ReadStreamLegacy
upTo: anObject
| start end |

start := position.
end := itsCollection indexOf: anObject startingAt: start .
end == 0 ifTrue:[ ^self upToEnd ].

"skip to the end and return the data passed over"
position := end + 1.
^itsCollection copyFrom: start to: (end - 1)
%

category: 'Passivation - Support'
method: ReadStreamLegacy
_fastNext
  "Returns the next item on the input stream without end of stream checks.
 This may result in a bad access error instead of an end of stream error."

  | res |
  res := itsCollection at: position.
  position := position + 1.
  ^ res
%

category: 'Passivation - Support'
method: ReadStreamLegacy
_fastPosition
  "Returns the receiver's current position reference for accessing the sequence
 of objects.  The position is actually the next element of the collection to be
 read or written; the position is incremented by each read or write.  In
 general, to start reading or writing at the nth element of a collection, the
 position must be set to n."

  "See bug 42596: Compatible with Legacy Stream positioning"

  ^ position
%

category: 'Passivation - Support'
method: ReadStreamLegacy
_fastPosition: pos
  "Sets the position of the receiver without checking the validity of the
 argument 'pos'.  This may result in bad index errors instead of end
 of stream errors in subsequent access of the stream."

  "See bug 42596: Compatible with Legacy Stream positioning"

  position := pos
%

! Class extensions for 'ReadStreamPortable'

!		Class methods for 'ReadStreamPortable'

category: 'Instance Creation'
classmethod: ReadStreamPortable
new

"Disallowed.  To create a new ReadStream, use the class method on: instead."

self shouldNotImplement: #new
%

category: 'Instance Creation'
classmethod: ReadStreamPortable
on: aCollection from: firstIndex to: lastIndex
"Answer with a new instance streaming over a copy of aCollection from
firstIndex to lastIndex."

^self basicNew
	on: aCollection
	from: firstIndex
	to: lastIndex
%

!		Instance methods for 'ReadStreamPortable'

category: 'Accessing'
method: ReadStreamPortable
next

"Returns the next object that the receiver can access for reading.
 Returns nil if an attempt is made to read beyond the end of the stream."
| pos |
(pos := position) >= readLimit
       ifTrue: [^nil]
       ifFalse: [^collection at: (position := pos + 1)]
%

category: 'Accessing'
method: ReadStreamPortable
next: amount
"Answer the next amount elements of my collection.  overriden for efficiency"

| ans endPosition pos |
amount < 0 ifTrue: [ ^self error: 'amount may not be less than 0' ].

endPosition := (pos := position) + amount  min:  readLimit.
ans := collection copyFrom: pos+1 to: endPosition.
position := endPosition.
^ans
%

category: 'Accessing'
method: ReadStreamPortable
next: n into: aCollection startingAt: startIndex
"Read n objects into the given collection.
Return aCollection or a partial copy if less than
n elements have been read."
| max pos |
max := (readLimit - (pos := position)) min: n.
aCollection
	replaceFrom: startIndex
	to: startIndex+max-1
	with: collection
	startingAt: pos +1.
position := pos + max.
max = n
	ifTrue:[^aCollection]
	ifFalse:[^aCollection copyFrom: 1 to: startIndex+max-1]
%

category: 'Passivation - Support'
method: ReadStreamPortable
nextBytes: count addTo: anObject
  | pos |
  count <= 0 ifTrue:[ ^ anObject ].
  (self atEnd)
   ifTrue: [ ^ EndOfStream signal ].
  anObject addAllBytes: (collection copyFrom: (pos := position) + 1 to: pos + count ).
  position := pos + count .
  ^ anObject .
%

category: 'Passivation - Support'
method: ReadStreamPortable
nextElements: count into: aCollection
  "Stores the next count elements that the receiver can access for reading
 into aCollection.  The receiver's collection and aCollection must be compatible
 SequenceableCollections.  Returns the count of elements read.

 Generates an error if an attempt is made to read beyond the end of the stream."

  "Used by PassiveObject."

  ^ self next: count into: aCollection startingAt: 1
%

category: 'Testing'
method: ReadStreamPortable
nextMatchFor: anObject

	"The first object is removed from the receiver's future sequence value and appended to the end of
	the receiver's past sequence values. The value that would result from sending #= to the object with
	anObject as the argument is returned.
	The results are undefined if there are no future sequence values in the receiver.

	ANSI 5.9.2.6"

	^self next = anObject.
%

category: 'Accessing'
method: ReadStreamPortable
nextOrNil

"Returns the next object that the receiver can access for reading.
 Returns nil if an attempt is made to read beyond the end of the stream."
| pos |
(pos := position) >= readLimit
	ifTrue: [^nil]
	ifFalse: [^collection at: (position := pos + 1)]
%

category: 'Adding'
method: ReadStreamPortable
nextPut: anObject

"Disallowed.  You cannot write to a ReadStream."

self shouldNotImplement: #nextPut:
%

category: 'Private'
method: ReadStreamPortable
on: aCollection from: firstIndex to: lastIndex

| len |
collection := aCollection .
readLimit :=  lastIndex > (len := aCollection size)
	ifTrue: [len]
	ifFalse: [lastIndex].
position := firstIndex <= 1
	ifTrue: [0]
	ifFalse: [firstIndex - 1]
%

category: 'Accessing'
method: ReadStreamPortable
peek
  "Answer what would be returned if the message next were sent to the
  receiver. If the receiver is at the end, answer nil. 
  Reimplemented as an optimization"

  position >= readLimit"self atEnd" ifTrue: [^nil].
  "nextObject :=self next.  position := position - 1. ^nextObject"
  ^ collection at: position + 1 
%

category: 'Accessing'
method: ReadStreamPortable
peekN: anInteger
  "Peek returning the next N characters of collection."
  | end start |
  position >= readLimit ifTrue:[ ^ collection class new ].
  start := position + 1 .
  end := start + anInteger - 1.
  end >= readLimit ifTrue:[ end := readLimit - 1 ].
  ^ collection copyFrom: start to: end
%

category: 'Accessing'
method: ReadStreamPortable
size
"Compatibility with other streams"
^readLimit
%

category: 'Accessing'
method: ReadStreamPortable
skip: anInteger
"Set the receiver's position to be the current position+anInteger. Do not
 throw error if skipAmount would exceed collection bounds - ANSI compliance. "

self position: ((position + anInteger max: 0) min: readLimit)
%

category: 'Accessing'
method: ReadStreamPortable
upTo: anObject
"fast version using indexOf:"
| start end |

start := position+1.
end := collection indexOf: anObject startingAt: start .

"not present--return rest of the collection"
(end == 0 or: [end > readLimit]) ifTrue: [ ^self upToEnd ].

"skip to the end and return the data passed over"
position := end.
^collection copyFrom: start to: (end-1)
%

category: 'Accessing'
method: ReadStreamPortable
upToEnd
| start pos |
start := 1 + position .
position := (pos := readLimit) .
^collection copyFrom: start to: pos
%

category: 'Passivation - Support'
method: ReadStreamPortable
_fastNext
  "Returns the next item on the input stream without end of stream checks.
 This may result in a bad access error instead of an end of stream error."

  ^ collection at: (position := position + 1)
%

category: 'Passivation - Support'
method: ReadStreamPortable
_fastPosition
  "Returns the receiver's current position reference for accessing the sequence
 of objects.  The position is actually the next element of the collection to be
 read or written; the position is incremented by each read or write.  In
 general, to start reading or writing at the nth element of a collection, the
 position must be set to n."

  "See bug 42596: Compatible with Legacy Stream positioning"

  ^ position + 1
%

category: 'Passivation - Support'
method: ReadStreamPortable
_fastPosition: pos
  "Sets the position of the receiver without checking the validity of the
 argument 'pos'.  This may result in bad index errors instead of end
 of stream errors in subsequent access of the stream."

  "See bug 42596: Compatible with Legacy Stream positioning"

  position := pos - 1
%

! Class extensions for 'ReadWriteStreamPortable'

!		Instance methods for 'ReadWriteStreamPortable'

category: 'Accessing'
method: ReadWriteStreamPortable
contents
"Answer with a copy of my collection from 1 to readLimit."

readLimit := readLimit max: position.
^collection copyFrom: 1 to: readLimit
%

category: 'Accessing'
method: ReadWriteStreamPortable
next
"Returns the next object that the receiver can access for reading.
 Returns nil if an attempt is made to read beyond the end of the stream."

position >= readLimit
	ifTrue: [^nil]
	ifFalse: [^collection at: (position := position + 1)]
%

category: 'Accessing'
method: ReadWriteStreamPortable
next: amount
"Answer the next amount elements of my collection.  overriden for efficiency"

| ans endPosition |
amount < 0 ifTrue: [ ^self error: 'amount may not be less than 0' ].
readLimit := readLimit max: position.

endPosition := position + amount  min:  readLimit.
ans := collection copyFrom: position + 1 to: endPosition.
position := endPosition.
^ans
%

category: 'Passivation - Support'
method: ReadWriteStreamPortable
nextBytes: count addTo: anObject
  | pos |
  count <= 0 ifTrue:[ ^ anObject ].
  (self atEnd)
   ifTrue: [ ^ EndOfStream signal ].
  anObject addAllBytes: (collection copyFrom: (pos := position) + 1 to: pos + count ).
  position := pos + count .
  ^ anObject .
%

category: 'Passivation - Support'
method: ReadWriteStreamPortable
nextElements: count into: aCollection
  "Stores the next count elements that the receiver can access for reading
 into aCollection.  The receiver's collection and aCollection must be compatible
 SequenceableCollections.  Returns the count of elements read.

 Generates an error if an attempt is made to read beyond the end of the stream."

  "Used by PassiveObject."

  ^ self next: count into: aCollection startingAt: 1
%

category: 'Testing'
method: ReadWriteStreamPortable
nextMatchFor: anObject

	"The first object is removed from the receiver's future sequence value and appended to the end of
	the receiver's past sequence values. The value that would result from sending #= to the object with
	anObject as the argument is returned.
	The results are undefined if there are no future sequence values in the receiver.

	ANSI 5.9.2.6"

	^self next = anObject.
%

category: 'Passivation - Support'
method: ReadWriteStreamPortable
_fastNext
  "Returns the next item on the input stream without end of stream checks.
 This may result in a bad access error instead of an end of stream error."

  ^ collection at: (position := position + 1)
%

category: 'Passivation - Support'
method: ReadWriteStreamPortable
_fastPosition
  "Returns the receiver's current position reference for accessing the sequence
 of objects.  The position is actually the next element of the collection to be
 read or written; the position is incremented by each read or write.  In
 general, to start reading or writing at the nth element of a collection, the
 position must be set to n."

  "See bug 42596: Compatible with Legacy Stream positioning"

  ^ position + 1
%

category: 'Passivation - Support'
method: ReadWriteStreamPortable
_fastPosition: pos
  "Sets the position of the receiver without checking the validity of the
 argument 'pos'.  This may result in bad index errors instead of end
 of stream errors in subsequent access of the stream."

  "See bug 42596: Compatible with Legacy Stream positioning"

  position := pos - 1
%

! Class extensions for 'ResumableTestFailure'

!		Instance methods for 'ResumableTestFailure'

category: 'Instance initialization'
method: ResumableTestFailure
initialize
  gsNumber := ERR_ResumableTestFailure .
  gsResumable := true .
  gsTrappable := true .
%

category: 'SUnit'
method: ResumableTestFailure
isResumable
	"Of course a ResumableTestFailure is resumable ;-)"

	^true
%

category: 'SUnit'
method: ResumableTestFailure
sunitExitWith: aValue
	self resume: aValue
%

! Class extensions for 'ResumableTestFailureTestCase'

!		Instance methods for 'ResumableTestFailureTestCase'

category: 'test data'
method: ResumableTestFailureTestCase
errorTest
	1 zork
%

category: 'test data'
method: ResumableTestFailureTestCase
failureTest
	self
		assert: false description: 'You should see me' resumable: true;
		assert: false description: 'You should see me too' resumable: true;
		assert: false description: 'You should see me last' resumable: false;
		assert: false description: 'You should not see me' resumable: true
%

category: 'logging'
method: ResumableTestFailureTestCase
logFailure: aString
	duplicateFailureLog add: aString.
	super logFailure: aString.
%

category: 'test data'
method: ResumableTestFailureTestCase
okTest
	self assert: true
%

category: 'test data'
method: ResumableTestFailureTestCase
regularTestFailureTest
	self assert: false description: 'You should see me'
%

category: 'running'
method: ResumableTestFailureTestCase
resumableTestFailureTest
	self
		assert: false description: 'You should see more than me' resumable: true;
		assert: false description: 'You should see more than me' resumable: true;
		assert: false description: 'You should see me last' resumable: false;
		assert: false description: 'You should not see me' resumable: true
%

category: 'running'
method: ResumableTestFailureTestCase
setUp
	duplicateFailureLog := OrderedCollection with: 'In set up'.
%

category: 'running'
method: ResumableTestFailureTestCase
tearDown
	self deny: 'You should not see me' = duplicateFailureLog last
			description: 'We saw the ''You should not see me'' failure'.
	self deny: 'You should see more than me' = duplicateFailureLog last
			description: 'We did not see more than a ''You should see more than me'' failure'.
%

category: 'running'
method: ResumableTestFailureTestCase
testResumable
	| result suite |
	suite := TestSuite new.
	suite addTest: (self class selector: #errorTest).
	suite addTest: (self class selector: #regularTestFailureTest).
	suite addTest: (self class selector: #resumableTestFailureTest).
	suite addTest: (self class selector: #okTest).
	result := suite run.
	self assert: result failures size = 2;
		assert: result errors size = 1
%

! Class extensions for 'SeededRandom'

!		Class methods for 'SeededRandom'

category: 'instance creation'
classmethod: SeededRandom
new
	^ self basicNew initialize
%

category: 'instance creation'
classmethod: SeededRandom
seed: anInteger

	^ self new seed: anInteger
%

!		Instance methods for 'SeededRandom'

category: 'public'
method: SeededRandom
fullState

	"Answers the current state of the generator. The state represents in what sequence random
  numbers will be generated, and where in that sequence the generator is. This generator, or
  another generator of the same class, may be later set to this state by giving this state
  as an argument to the fullState: method, after which it will generate random numbers in
  the same sequence as the receiver will after receiving #fullState."

	"If I have no state yet, initialize myself from HostRandom"
	index == nil ifTrue: [self setSeedFromHost].
	^{index.
	carry.
	seeds copy}
%

category: 'public'
method: SeededRandom
fullState: fullState

	"Resets the state of the generator to some point in its sequence; the point at which fullState was
	obtained by sending #fullState to the generator or another generator of the same class.
	After receiving this message, the sequence of random numbers generated will match the
	ones generated after #fullState was received.

	The given fullState must be an Array of size 3. The first element is an integer, the index,
	which must be in the range [1..lag].
	The second element is the carry, which must be an integer in the range [0..multiplier-1].
	The third element is the seedArray. The size of seedArray mut be lag. Each seed in the
	array must be a 32-bit nonnegative integer.
	Depending on the subclass, it may be an error if *all* of the seeds and the carry to be zero,
	or for all of them to be their maximum legal value; MWC requires that at least one must be of
	another value. CMWC does not have this requirement."

	self validateFullState: fullState.
	index := fullState at: 1.
	carry := fullState at: 2.
	seeds := (fullState at: 3) copy
%

! Class extensions for 'SimpleTestResource'

!		Class methods for 'SimpleTestResource'

category: 'accessing'
classmethod: SimpleTestResource
allowAvailability
	^self _preventAvailability == nil
%

category: 'utility'
classmethod: SimpleTestResource
preventAvailabilityDuring: aBlock

	self _preventAvailability: false.
	^aBlock ensure: [self _preventAvailability: nil]
%

category: 'Private'
classmethod: SimpleTestResource
preventAvailabilityName

	^(self thisClass name , '_preventAvailability') asSymbol "in SessionTemps"
%

category: 'accessing'
classmethod: SimpleTestResource
rawCurrentForTest
	^self _current
%

category: 'Private'
classmethod: SimpleTestResource
_preventAvailability
		"Because we can run multiple sessions, we can get conflicts on a class instance variable.
		Use SessionTemps instead"

	^SessionTemps current
		at: self preventAvailabilityName
		otherwise: nil.
%

category: 'Private'
classmethod: SimpleTestResource
_preventAvailability: anObject

	SessionTemps current at: self preventAvailabilityName put: anObject
%

!		Instance methods for 'SimpleTestResource'

category: 'testing'
method: SimpleTestResource
hasRun
	^hasRun
%

category: 'testing'
method: SimpleTestResource
hasSetup
	^hasSetup
%

category: 'testing'
method: SimpleTestResource
isAvailable
	^self class allowAvailability and:
		[self runningState == self startedStateSymbol]
%

category: 'accessing'
method: SimpleTestResource
runningState

	^runningState
%

category: 'accessing'
method: SimpleTestResource
runningState: aSymbol

	runningState := aSymbol
%

category: 'running'
method: SimpleTestResource
setRun
	hasRun := true
%

category: 'running'
method: SimpleTestResource
setUp

	self runningState: self startedStateSymbol.
	hasSetup := true
%

category: 'running'
method: SimpleTestResource
startedStateSymbol

	^#started
%

category: 'running'
method: SimpleTestResource
stoppedStateSymbol

	^#stopped
%

category: 'running'
method: SimpleTestResource
tearDown

	self runningState: self stoppedStateSymbol
%

! Class extensions for 'SimpleTestResourceA'

!		Class methods for 'SimpleTestResourceA'

category: 'accessing'
classmethod: SimpleTestResourceA
resources
	^ { SimpleTestResourceA1 . SimpleTestResourceA2 }
%

! Class extensions for 'SimpleTestResourceB'

!		Class methods for 'SimpleTestResourceB'

category: 'accessing'
classmethod: SimpleTestResourceB
resources
	^ { SimpleTestResourceA1 . SimpleTestResourceB1 }
%

! Class extensions for 'SimpleTestResourceCircular'

!		Class methods for 'SimpleTestResourceCircular'

category: 'accessing'
classmethod: SimpleTestResourceCircular
resources
	^self _preventAvailability == nil
		ifTrue: [super resources, { SimpleTestResourceA1 } ]
		ifFalse: [super resources, { SimpleTestResourceA1 . SimpleTestResourceCircular1 } ]
%

! Class extensions for 'SimpleTestResourceCircular1'

!		Class methods for 'SimpleTestResourceCircular1'

category: 'accessing'
classmethod: SimpleTestResourceCircular1
resources
	"Circular prereq:  C wants C1 which wants C."

	^ { SimpleTestResourceCircular }
%

! Class extensions for 'SimpleTestResourceTestCase'

!		Class methods for 'SimpleTestResourceTestCase'

category: 'accessing'
classmethod: SimpleTestResourceTestCase
resources
	^ { SimpleTestResource }
%

!		Instance methods for 'SimpleTestResourceTestCase'

category: 'utility'
method: SimpleTestResourceTestCase
clearOuterResourceStateDuring: aBlock
	"This self-testing test must clear the outer state of its resources before starting and after finishing, so that it can construct test cases and suites of itself and test them."

	self assert: SimpleTestResource isAlreadyAvailable
		description: 'The resource was not set up for the test'.
	SimpleTestResource reset.
	self deny: SimpleTestResource isAlreadyAvailable
		description: 'The resource was still set up before we began the run'.
	^aBlock sunitEnsure:
		[self deny: SimpleTestResource isAlreadyAvailable
			description: 'The resource was still set up after we finished the run'.
		SimpleTestResource isAvailable.
		self assert: SimpleTestResource isAlreadyAvailable
			description: 'The resource was not set up again after the test'].
%

category: 'private'
method: SimpleTestResourceTestCase
dummy
	self assert: resource hasSetup
		description: 'This test uses a resource but it was not set up'.
	self setRun.
	self assert: resource hasRun
		description: 'This test uses a resource but we could not interact with it'.
%

category: 'private'
method: SimpleTestResourceTestCase
error
	'foo' odd
%

category: 'private'
method: SimpleTestResourceTestCase
fail
	self assert: false
%

category: 'private'
method: SimpleTestResourceTestCase
setRun
	resource setRun
%

category: 'running'
method: SimpleTestResourceTestCase
setUp
	"Ensure that we error, not just fail, if resource is nil so that #should:raise: checks cannot mistake such an error for what they are trapping."

	resource := SimpleTestResource rawCurrentForTest.
	self deny: resource == nil
		description: 'SimpleTestResource has no current value in test'.
	self assert: resource class == SimpleTestResource
		description: 'SimpleTestResource current is not an instance of itself'.
	self assert: resource hasSetup
		description: 'This test uses a resource but it was not set up'.
%

category: 'running'
method: SimpleTestResourceTestCase
testDebugTestWithResource
	"The debug will raise an error if the resource is not set up properly."

	self clearOuterResourceStateDuring:
		[(self class selector: #setRun) debug].
%

category: 'running'
method: SimpleTestResourceTestCase
testResourceCollection
	self assert: self class buildSuiteFromSelectors resources size = self resources size
		description: 'The suite should have the same number of resources as its test'.
	self class buildSuiteFromSelectors resources do:
		[:each |
		self assert: (self resources includes: each)
			description: each name, ':  I have this resource but my suite does not'].
%

category: 'running'
method: SimpleTestResourceTestCase
testRunSuiteWithResource
	| suite |
	suite := TestSuite new.
	suite addTest: (SimpleTestResourceTestCase selector: #error).
	suite addTest: (SimpleTestResourceTestCase selector: #fail).
	suite addTest: (self class selector: #dummy).
	self clearOuterResourceStateDuring:
		[self assert: suite run printString = '3 run, 1 passed, 1 failed, 1 error'
			description: 'A suite of tests needing SimpleTestResource did not run as expected'].
%

category: 'running'
method: SimpleTestResourceTestCase
testRunTestWithResource
	self clearOuterResourceStateDuring:
		[self assert: (self class selector: #dummy) run printString
					= '1 run, 1 passed, 0 failed, 0 errors'
			description: 'A dummy test that needed a resource did not pass'].
%

! Class extensions for 'Stream'

!		Class methods for 'Stream'

removeallmethods Stream
removeallclassmethods Stream

category: 'Portable Methods'
classmethod: Stream
installLegacyStreamImplementation

(Globals at: #PositionableStream) isLegacyStreamImplementation
  ifTrue: [ ^ false ].
self installStreamImplementationFrom: (Globals at: #GemStone_Legacy_Streams).
^true
%

category: 'Portable Methods'
classmethod: Stream
installPortableStreamImplementation

(Globals at: #PositionableStream) isPortableStreamImplementation
  ifTrue: [ ^false ].
self installStreamImplementationFrom: (Globals at: #GemStone_Portable_Streams).
^true
%

category: 'Portable Methods'
classmethod: Stream
installStreamImplementationFrom: aSymbolDictionary
  "not used by filein nor image upgrade." 
  #( #PositionableStream #ReadStream #WriteStream #ReadByteStream ) do:[:key |
     Globals at: key put: (aSymbolDictionary at: key )
  ].
  "ReadWriteStream and FileStream defined in Portable implementation, but not in
   Legacy implementation"
  #( #ReadWriteStream #FileStream ) do:[:key |
     (aSymbolDictionary at: key otherwise: nil)
       ifNil: [ Globals removeKey: key otherwise:nil  ]
       ifNotNil: [:aClass | Globals at: key put: aClass  ].
  ].
  "recompile implementations of #readStream that reference ReadByteStream "
  { ByteArray . String . MultiByteString } do:[:cls |
    cls recompileMethodAt: #readStream  
  ].
%

category: 'Portable Methods'
classmethod: Stream
isLegacyStreamImplementation

self subclassResponsibility: #isLegacyStreamImplementation
%

category: 'Portable Methods'
classmethod: Stream
isPortableStreamImplementation

self subclassResponsibility: #isPortableStreamImplementation
%

category: 'Private'
classmethod: Stream
_copyMethodsTo: destinationClass

"copy instance methods, class methods , and class comment to the destination class"

"Copy class and instance methods"
 | status |
 status := String new .
 1 to: 2 do: [ :i | | srccls targcls cats |
   i == 1 ifTrue: [
     srccls := self.  targcls := destinationClass .
     status add:' source ' , self name,' ', self asOop asString,
            '  dest ', self asOop asString, ' ', destinationClass name.
   ] ifFalse: [
     srccls := self class.  targcls := destinationClass class
   ].
   srccls == targcls ifTrue:[Error signal:'sourceClass identical to targetClass'].
   targcls removeAllMethods .
   cats := srccls _unifiedCategorys: 0.
   cats keysAndValuesDo: [ :cat :sels |
     sels do: [ :sel |
        targcls compileMethod: (srccls sourceCodeAt: sel)
                dictionaries: GsCurrentSession currentSession symbolList
                category: cat
                environmentId: 0
     ]
   ]
 ].
 destinationClass comment: self commentForFileout.
 ^ status
%

category: 'Private'
classmethod: Stream
_initializeStreamClassVars
"set up classVars for methods in stream2.gs"
(self classVarAt: #Cr otherwise: nil) ifNil:[ | arr |
  arr := {
    #Lf . Character codePoint: 10 .
    #Tab . Character codePoint: 9 . }.
  1 to: arr size by: 2 do:[:j |
    self _addInvariantClassVar: (arr at: j) value: (arr at: j + 1)
  ].
  ^ 'added'
].
^ 'no change'
%

category: 'Private'
classmethod: Stream
_initializeWriteStreamClassVars: aClass
  "method used in filein of various WriteStream classes.
   Those classes inherit Lf and Tab classVars from Stream.
  "
  (aClass classVarAt: #Cr otherwise: nil) ifNil:[ | arr |
    arr := {
      #Cr . Character codePoint: 13 .
      #CrLf .  (String new add:(Character codePoint: 13);
                   add: (Character codePoint: 10); immediateInvariant
                  ; yourself ) .
      #CrTab .  (String new add:(Character codePoint: 13);
                   add: (Character codePoint: 9); immediateInvariant
                  ; yourself )   } .
    1 to: arr size by: 2 do:[:j |
      aClass _addInvariantClassVar: (arr at: j) value: (arr at: j + 1)
    ].
    ^ 'added'
  ].
  ^ 'no change'
%

!		Instance methods for 'Stream'

category: 'PetitParser-Core-Converting'
method: Stream
asPetitStream
	^ self contents asPetitStream
%

category: 'Testing'
method: Stream
atEnd

"(Subclass responsibility.)  Returns true if the receiver cannot access any more
 objects, false if it can."

Stream subclassResponsibility: #atEnd
%

category: 'ANSI'
method: Stream
close
	"5.9.1.1

	If the receiver is a write-back stream update its stream backing store as if the message #flush was
	sent to the receiver. Then eliminate any association between the receiver and its stream backing
	store. Any system resources associated with the association should be released. The effect of
	sending any message to the receiver subsequent to this message is undefined."
%

category: 'Adding'
method: Stream
cr
"Adds a newline to the output stream. (NOT a carriage return)"
  self nextPut: Lf
%

category: 'Enumerating'
method: Stream
do: aBlock

"Evaluates the one-argument block aBlock for each of the remaining objects that
 the receiver can access."

[self atEnd]
  whileFalse: [aBlock value: self next]
%

category: 'Testing'
method: Stream
isExternal

"Returns true if the source of the receiver's information
 is external to the image, and false otherwise."

^false
%

category: 'Testing'
method: Stream
isFull

"Returns true if there is no more room in this stream.

 By default, always return false. "

^ false
%

category: 'Adding'
method: Stream
lf
  "Adds a newline to the output stream."
  self nextPut: Lf
%

category: 'Accessing'
method: Stream
maxSize

"Returns the maximum number of objects/bytes
 that this stream can hold.

 By default, return a large value."

^ 1000000000000
%

category: 'Accessing'
method: Stream
next

"(Subclass responsibility, ReadStream only.)  Returns the next object that the
 receiver can access for reading.  Generates an error if an attempt is made to
 read beyond the end of the stream."

Stream subclassResponsibility: #next
%

category: 'Adding'
method: Stream
nextPut: anObject

"(Subclass responsibility, WriteStream only.)  Inserts anObject as the next
 element that the receiver can access for writing.  Returns anObject."

Stream subclassResponsibility: #nextPut
%

category: 'Adding'
method: Stream
nextPutAll: aCollection

"Inserts the elements of aCollection as the next elements that the receiver can
 access.  Returns aCollection.  (WriteStream only.)"

aCollection accompaniedBy: self do: [:me :each | me nextPut: each].
^ aCollection
%

category: 'Adding'
method: Stream
nextPutAllBytes: aCharacterCollection

"(Subclass responsibility, WriteStream only.)  Inserts the byte contents of
 aCharacterCollection as the next elements that the receiver can
 access.  Returns aCharacterCollection."

Stream subclassResponsibility: #nextPutAllBytes:
%

category: 'Adding'
method: Stream
space

"Adds a space to the output stream."

self nextPut:  $    .

%

category: 'Adding'
method: Stream
tab
  "Adds a tab to the output stream."
  self nextPut: Tab
%

category: 'Fileout'
method: Stream
_fileOutAll: aString

  ^ self nextPutAll: aString
%

category: 'Private'
method: Stream
_nextPutAllBytes: aCharacterCollection

^ self nextPutAllBytes: aCharacterCollection
%

! Class extensions for 'String'

!		Instance methods for 'String'

category: 'SUnit'
method: String
sunitAsSymbol
"This method is part of the community-maintained SUnit framework
documented at http://sunit.sourceforge.net. The current version is
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

        ^self asSymbol
%

category: 'SUnit'
method: String
sunitMatch: aString
"This method is part of the community-maintained SUnit framework
documented at http://sunit.sourceforge.net. "
	| pattern sz |
	pattern := { } .
	((sz := self size) ~~ 0 and: [ (self at: 1) == $* ]) ifTrue: [
		pattern add: $*.
	].
	(self subStrings: $*) do: [:each |
		pattern
			add: each;
			add: $*.
	].
	(sz ~~ 0 and: [ (self at: sz) ~~ $* ]) ifTrue: [
		pattern removeLast.
	].
	^aString matchPattern: pattern .
%

category: 'SUnit'
method: String
sunitSubStrings
"This method is part of the community-maintained SUnit framework
documented at http://sunit.sourceforge.net. The current version is
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

	self deprecated: 'Behavior>>sunitSubStrings is deprecated v3.0. This method has
no senders in current SUnit. Any dialect-specific use that might exist in some SUnit
extensions should inline their dialect-specific implementation.'.
	^self subStrings
%

! Class extensions for 'SUnitNameResolver'

!		Class methods for 'SUnitNameResolver'

category: 'SUnit'
classmethod: SUnitNameResolver
classNamed: aSymbol

	| assoc |
	(assoc := System myUserProfile resolveSymbol: aSymbol) == nil ifTrue: [^nil].
	^assoc value.
%

category: 'SUnit'
classmethod: SUnitNameResolver
defaultLogDevice

	^WriteStream on: String new.
%

category: 'SUnit'
classmethod: SUnitNameResolver
errorObject
	^Error
%

category: 'SUnit'
classmethod: SUnitNameResolver
mnuExceptionObject
	^MessageNotUnderstood new
%

category: 'SUnit'
classmethod: SUnitNameResolver
notificationObject
	^Notification new
%

! Class extensions for 'SUnitTest'

!		Instance methods for 'SUnitTest'

category: 'private'
method: SUnitTest
assertForTestResult: aResult runCount: aRunCount passed: aPassedCount failed: aFailureCount errors: anErrorCount

	self
		assert: aResult runCount = aRunCount;
		assert: aResult passedCount = aPassedCount;
		assert: aResult failureCount = aFailureCount;
		assert: aResult errorCount = anErrorCount
%

category: 'private'
method: SUnitTest
error
	3 zork
%

category: 'testing'
method: SUnitTest
errorShouldntRaise
	self
		shouldnt: [self someMessageThatIsntUnderstood]
		raise: SUnitNameResolver notificationObject
%

category: 'private'
method: SUnitTest
fail
	self assert: false
%

category: 'accessing'
method: SUnitTest
hasRun
	^hasRun
%

category: 'accessing'
method: SUnitTest
hasSetup
	^hasSetup
%

category: 'private'
method: SUnitTest
noop
%

category: 'private'
method: SUnitTest
setRun
	hasRun := true
%

category: 'running'
method: SUnitTest
setUp
	hasSetup := true
%

category: 'testing'
method: SUnitTest
testAssert
	self assert: true.
	self deny: false
%

category: 'testing'
method: SUnitTest
testDefects
	| result suite error failure |
	suite := TestSuite new.
	suite addTest: (error := self class selector: #error).
	suite addTest: (failure := self class selector: #fail).
	result := suite run.
	self assert: result defects asArray = { error . failure } .
	self
		assertForTestResult: result
		runCount: 2
		passed: 0
		failed: 1
		errors: 1
%

category: 'testing'
method: SUnitTest
testDialectLocalizedException

	self
		should: [TestResult signalFailureWith: 'Foo']
		raise: TestResult failure.
	self
		should: [TestResult signalErrorWith: 'Foo']
		raise: TestResult error.
%

category: 'testing'
method: SUnitTest
testError

	| case result |

	case := self class selector: #error.
	result := case run.
	self
		assertForTestResult: result
		runCount: 1
		passed: 0
		failed: 0
		errors: 1.

	case := self class selector: #errorShouldntRaise.
	result := case run.
	self
		assertForTestResult: result
		runCount: 1
		passed: 0
		failed: 0
		errors: 1
%

category: 'testing'
method: SUnitTest
testException

	self
		should: [self error: 'foo']
		raise: TestResult error
%

category: 'testing'
method: SUnitTest
testFail

	| case result |

	case := self class selector: #fail.
	result := case run.

	self
		assertForTestResult: result
		runCount: 1
		passed: 0
		failed: 1
		errors: 0
%

category: 'testing'
method: SUnitTest
testIsNotRerunOnDebug

	| case |

	case := self class selector: #testRanOnlyOnce.
	case run.
	case debug
%

category: 'testing'
method: SUnitTest
testRan

	| case |

	case := self class selector: #setRun.
	case run.
	self assert: case hasSetup.
	self assert: case hasRun
%

category: 'testing'
method: SUnitTest
testRanOnlyOnce

	self assert: hasRanOnce ~= true.
	hasRanOnce := true
%

category: 'testing'
method: SUnitTest
testResult

	| case result |

	case := self class selector: #noop.
	result := case run.

	self
		assertForTestResult: result
		runCount: 1
		passed: 1
		failed: 0
		errors: 0
%

category: 'testing'
method: SUnitTest
testRunning

	(SUnitDelay forSeconds: 2) wait
%

category: 'testing'
method: SUnitTest
testShould

	self
		should: [true];
		shouldnt: [false]
%

category: 'testing'
method: SUnitTest
testSuite

	| suite result |

	suite := TestSuite new.
	suite
		addTest: (self class selector: #noop);
		addTest: (self class selector: #fail);
		addTest: (self class selector: #error).

	result := suite run.

	self
		assertForTestResult: result
		runCount: 3
		passed: 1
		failed: 1
		errors: 1
%

! Class extensions for 'Symbol'

!		Instance methods for 'Symbol'

category: 'SUnit'
method: Symbol
sunitAsClass
 "This method is part of the community-maintained SUnit framework
documented at http://sunit.sourceforge.net. The current version is
based on http://www.squeaksource.com/SUnit/SUnit-NiallRoss.40.mcz"

	^SUnitNameResolver classNamed: self
%

! Class extensions for 'TestAsserter'

!		Class methods for 'TestAsserter'

category: 'other'
classmethod: TestAsserter
assert: aBoolean description: aString
	aBoolean ifFalse:
		[self logFailure: aString.
		TestResult failure signal: aString].
%

category: 'other'
classmethod: TestAsserter
failureLog
	^SUnitNameResolver defaultLogDevice
%

category: 'other'
classmethod: TestAsserter
isLogging
	"By default, we're not logging failures. Override in subclasses as desired."

	^false
%

category: 'other'
classmethod: TestAsserter
logFailure: aString
	self isLogging ifTrue:
		[self failureLog cr; nextPutAll: aString; flush].
%

!		Instance methods for 'TestAsserter'

category: 'asserting'
method: TestAsserter
assert: aBoolean
	aBoolean ifFalse:
		[self logFailure: 'Assertion failed'.
		TestResult failure signal: 'Assertion failed'].
%

category: 'asserting'
method: TestAsserter
assert: aBoolean description: aString
	aBoolean ifFalse:
		[self logFailure: aString.
		TestResult failure signal: aString].
%

category: 'asserting'
method: TestAsserter
assert: aBoolean description: aString resumable: resumableBoolean
	| exception |
	aBoolean ifFalse:
		[self logFailure: aString.
		exception := resumableBoolean
			ifTrue: [TestResult resumableFailure]
			ifFalse: [TestResult failure].
		exception signal: aString].
%

category: 'asserting'
method: TestAsserter
assert: anObject equals: otherObj
  anObject = otherObj ifFalse:[ | a b |
    a := anObject printString .
    b := otherObj printString .
    a size > 100 ifTrue:[ a size: 100; addAll:'... ' ].
    b size > 100 ifTrue:[ b size: 100; addAll:'... ' ].
	  self
		 assert: false
		 description: a, ' is not equal to ' , b .
  ].
%

category: 'asserting'
method: TestAsserter
assert: anObject identical: otherObj
  anObject == otherObj ifFalse:[ | a b |
    a := 'oop ', anObject asOop asString,' ', anObject printString .
    b := 'oop ', otherObj asOop asString,' ', otherObj printString .
    a size > 100 ifTrue:[ a size: 100; addAll:'... ' ].
    b size > 100 ifTrue:[ b size: 100; addAll:'... ' ].
	  self
		 assert: false
		 description: a, ' is not identical to ' , b .
  ].
%

category: 'asserting'
method: TestAsserter
deny: aBoolean
	self assert: aBoolean not.
%

category: 'asserting'
method: TestAsserter
deny: aBoolean description: aString
	self assert: aBoolean not description: aString.
%

category: 'asserting'
method: TestAsserter
deny: aBoolean description: aString resumable: resumableBoolean
	self assert: aBoolean not description: aString resumable: resumableBoolean.
%

category: 'asserting'
method: TestAsserter
deny: anObject equals: anotherObject
	self
		deny: anObject = anotherObject
		description: anObject printString , ' is equal to ' , anotherObject printString.
%

category: 'asserting'
method: TestAsserter
executeShould: aBlock inScopeOf: anObject

	| expectedErrorNumber |
	(anObject isKindOf: Integer)
		ifTrue: [expectedErrorNumber := anObject]
		ifFalse:
			[(anObject isKindOf: Symbol)
				ifTrue: [expectedErrorNumber := ErrorSymbols at: anObject]
				ifFalse:
					[^
					[aBlock value.
					false] sunitOn: anObject do: [:ex | ^true]]].
	^
	[aBlock value.
	false] sunitOn: Error
			do: [:ex | expectedErrorNumber = ex number ifTrue: [^true] ifFalse: [ex pass]]
%

category: 'asserting'
method: TestAsserter
fail
	self assert: false
%

category: 'asserting'
method: TestAsserter
fail: descriptionString
	self assert: false description: descriptionString
%

category: 'asserting'
method: TestAsserter
logFailure: aString
	self class logFailure: aString.
%

category: 'asserting'
method: TestAsserter
should: aBlock raise: anObject

	| expectedErrorNumber actualErrorNumber |
	(anObject isKindOf: Integer) ifTrue: [
		expectedErrorNumber := anObject.
	] ifFalse: [(anObject isKindOf: Symbol) ifTrue: [
		expectedErrorNumber := ErrorSymbols at: anObject.
	] ifFalse: [
		^self assert: (self executeShould: aBlock inScopeOf: anObject).
	]].
	aBlock on: Error do: [:ex |
	   actualErrorNumber := ex number.
	].
	self should: [actualErrorNumber = expectedErrorNumber].
%

category: 'asserting'
method: TestAsserter
should: aBlock raise: anExceptionalEvent description: aString
	self
		assert: (self executeShould: aBlock inScopeOf: anExceptionalEvent)
		description: aString
%

category: 'asserting'
method: TestAsserter
shouldnt: aBlock raise: anExceptionalEvent
	self assert: (self executeShould: aBlock inScopeOf: anExceptionalEvent) not.
%

category: 'asserting'
method: TestAsserter
shouldnt: aBlock raise: anExceptionalEvent description: aString
	self
		assert: (self executeShould: aBlock inScopeOf: anExceptionalEvent) not
 		description: aString.
%

! Class extensions for 'TestCase'

!		Class methods for 'TestCase'

category: 'Accessing'
classmethod: TestCase
allTestSelectors
	| answer pivotClass lookupRoot |
	answer := Set withAll: self testSelectors.
	self shouldInheritSelectors
		ifTrue:
			[pivotClass := self.
			lookupRoot := self lookupHierarchyRoot.
			[pivotClass == lookupRoot]
				whileFalse:
					[pivotClass := pivotClass superclass.
					answer addAll: pivotClass testSelectors]].
	^answer asSortedCollection asOrderedCollection
%

category: 'Building Suites'
classmethod: TestCase
buildSuite
	| suite |
	^self isAbstract
		ifTrue:
			[suite := self suiteClass named: self name asString.
			self allSubclasses
				do: [:each | each isAbstract ifFalse: [suite addTest: each buildSuiteFromSelectors]].
			suite]
		ifFalse: [self buildSuiteFromSelectors]
%

category: 'Building Suites'
classmethod: TestCase
buildSuiteFromMethods: testMethods

	^testMethods
		inject: (self suiteClass named: self name asString)
		into: [:suite :selector |
			suite
				addTest: (self selector: selector);
				yourself]
%

category: 'Building Suites'
classmethod: TestCase
buildSuiteFromSelectors
	^self buildSuiteFromMethods: self allTestSelectors
%

category: 'Running'
classmethod: TestCase
debug

	^self suite debug
%

category: 'Instance Creation'
classmethod: TestCase
debug: aSymbol

	^(self selector: aSymbol) debug
%

category: 'Testing'
classmethod: TestCase
isAbstract
	"Override to true if a TestCase subclass is Abstract and should not have
	TestCase instances built from it"

	^self sunitName = #TestCase
%

category: 'Accessing'
classmethod: TestCase
lookupHierarchyRoot
	^TestCase
%

category: 'Accessing'
classmethod: TestCase
resources

	^#()
%

category: 'Running'
classmethod: TestCase
run

	^self suite run
%

category: 'Instance Creation'
classmethod: TestCase
run: aSymbol

	^(self selector: aSymbol) run
%

category: 'Instance Creation'
classmethod: TestCase
selector: aSymbol

	^self new setTestSelector: aSymbol
%

category: 'Testing'
classmethod: TestCase
shouldInheritSelectors
	"I should inherit from an Abstract superclass but not from a concrete one by default, unless I have no testSelectors in which case I must be expecting to inherit them from my superclass.  If a test case with selectors wants to inherit selectors from a concrete superclass, override this to true in that subclass."

	^self ~~ self lookupHierarchyRoot
		and: [self superclass isAbstract
			or: [self testSelectors isEmpty]]
%

category: 'Instance Creation'
classmethod: TestCase
suite

	^self buildSuite
%

category: 'Building Suites'
classmethod: TestCase
suiteClass
	^TestSuite
%

category: 'Accessing'
classmethod: TestCase
sunitVersion
	^'4.0'
%

category: 'Accessing'
classmethod: TestCase
testSelectors

	^self sunitSelectors select: [:each | 'test*' sunitMatch: each]
%

!		Instance methods for 'TestCase'

category: 'Dependencies'
method: TestCase
addDependentToHierachy: anObject
	"an empty method. for Composite compability with TestSuite"
%

category: 'Running'
method: TestCase
debug
	[(self class selector: testSelector) runCase]
		ensure: [TestResource resetResources: self resources]
%

category: 'Running'
method: TestCase
debugAsFailure
	| semaphore |
	semaphore := Semaphore new.
	[semaphore wait.
	TestResource resetResources: self resources] fork.
	(self class selector: testSelector) runCaseAsFailure: semaphore
%

category: 'Running'
method: TestCase
openDebuggerOnFailingTestMethod
	"SUnit has halted one step in front of the failing test method. Step over the 'self halt' and
	 send into 'self perform: testSelector' to see the failure from the beginning"

	self
		halt;
		performTest
%

category: 'Private'
method: TestCase
performTest
	self perform: testSelector asSymbol
%

category: 'Printing'
method: TestCase
printOn: aStream

	aStream
		nextPutAll: self class printString;
		nextPutAll: ' debug: #';
		nextPutAll: (testSelector isNil ifTrue: ['??'] ifFalse: [testSelector])
%

category: 'Dependencies'
method: TestCase
removeDependentFromHierachy: anObject
	"an empty method. for Composite compability with TestSuite"
%

category: 'Accessing'
method: TestCase
resources
	"We give TestCase this instance-side method so that methods polymorphic with TestSuite can be code-identical.  Having this instance-side method also helps when writing tests of resource behaviour. Except for such tests, it is rare to override this method and should not be done without thought.  If there were a good reason why a single test case needed to share tests requiring different resources, it might be legitimate."

	^self class resources
%

category: 'Running'
method: TestCase
run
	| result |
	result := TestResult new.
	[self run: result]
		ensure: [TestResource resetResources: self resources].
	^result
%

category: 'Running'
method: TestCase
run: aResult
	aResult runCase: self
%

category: 'Running'
method: TestCase
runCase
	| tornDown |
	self resources do: [:each | each availableFor: self].
	[ self setUp.
	  self performTest
        ] ensure: [
	  tornDown ifNil:[
		tornDown := true .
		self tearDown
	  ]
        ]
%

category: 'Running'
method: TestCase
runCaseAsFailure: aSemaphore
	[self resources do: [:each | each availableFor: self].
	[self setUp.
	self openDebuggerOnFailingTestMethod] ensure: [self tearDown]]
		ensure: [aSemaphore signal]
%

category: 'Accessing'
method: TestCase
selector
	^testSelector
%

category: 'Private'
method: TestCase
setTestSelector: aSymbol
	testSelector := aSymbol
%

category: 'Private'
method: TestCase
setUp
%

category: 'Testing'
method: TestCase
should: aBlock
	self assert: aBlock value
%

category: 'Testing'
method: TestCase
should: aBlock description: aString
	self assert: aBlock value description: aString
%

category: 'Testing'
method: TestCase
shouldnt: aBlock
	self deny: aBlock value
%

category: 'Testing'
method: TestCase
shouldnt: aBlock description: aString
	self deny: aBlock value description: aString
%

category: 'Testing'
method: TestCase
signalFailure: aString
	TestResult failure sunitSignalWith: aString
%

category: 'Running'
method: TestCase
tearDown
%

! Class extensions for 'TestFailure'

!		Instance methods for 'TestFailure'

category: 'other'
method: TestFailure
sunitAnnounce: aTestCase toResult: aTestResult
	aTestResult addFailure: aTestCase.
	self sunitExitWith: false.
%

! Class extensions for 'TestResource'

!		Class methods for 'TestResource'

category: 'Running'
classmethod: TestResource
availableFor: aTestAsserter
	aTestAsserter
		assert: self isAvailable
		description:
			'Unavailable resource ' , self name , ' requested by '
				, aTestAsserter printString
%

category: 'Accessing'
classmethod: TestResource
current
	"This is a lazy accessor:  the assert of self isAvailable does no work unless current isNil.  However this method should normally be sent only to a resource that should already have been made available, e.g. in a test whose test case class has the resource class in its #resources, so should never be able to fail the assert.
	If the intent is indeed to access a possibly-unprepared or reset-in-earlier-test resource lazily, then preface the call of 'MyResource current' with 'MyResource availableFor: self'."

	self
		assert: self isAvailable
		description:
			'Sent #current to unavailable resource ' , self name ,
					'.  Add it to test case'' class-side #resources (recommended) or send #availableFor: beforehand'.
	^self _current
%

category: 'Accessing'
classmethod: TestResource
current: aTestResource

	self _current: aTestResource.
%

category: 'Private'
classmethod: TestResource
currentName

	^(self thisClass name , '_current') asSymbol "In SessionTemps"
%

category: 'Testing'
classmethod: TestResource
isAbstract
	"Override to true if a TestResource subclass is Abstract and should not have
	TestCase instances built from it"

	^self name = #TestResource
%

category: 'Testing'
classmethod: TestResource
isAlreadyAvailable
	^self _current class == self
%

category: 'Testing'
classmethod: TestResource
isAvailable
	"This is (and must be) a lazy method.  If my current has a value, an attempt to make me available has already been made:  trust its result.  If not, try to make me available."

	self _current == nil  ifTrue: [self makeAvailable].
	^self isAlreadyAvailable
%

category: 'Creation'
classmethod: TestResource
makeAvailable
	"This method must be the _only_ way to set a notNil value for the unique instance (current).  First, obtain a candidate instance and set current to a notNil placeholder (any notNil object not an instance of me would do;  this version uses false).  Next, check any subordinate resources needed by this resource.  Lastly, setUp the candidate and put it in current if it is available, ensuring that it is torn down otherwise."

	| candidate |
	self _current: false.
	candidate := self new.
	self resources do: [:each | each availableFor: candidate].
	[candidate setUp.
	candidate isAvailable ifTrue: [self _current: candidate]]
		ensure: [self _current == candidate ifFalse: [candidate tearDown]]
%

category: 'Creation'
classmethod: TestResource
new
	"Use #current to get the valid current instance.  Use of #new to get an instance (that should never be the current one) could be done in bizarre circumstances, so is not blocked, but will usually be inappropriate."

	^super new initialize.
%

category: 'Creation'
classmethod: TestResource
reset
	[self isAlreadyAvailable ifTrue: [self _current tearDown]]
		ensure: [self _current: nil]
%

category: 'Private'
classmethod: TestResource
resetOrAddResourcesTo: aCollection
	"Add correctly set-up resources to the collection unless already there. Reset any imperfectly-set-up resources, so current isNil will return true if they are re-encountered via an indirectly self-prerequing resource;  circular references cannot be set up so will never reply true to isAlreadyAvailable, but may have correctly-set-up prereqs to add and/or imperfectly-set-up ones to reset, so do not abort the loop first time round."

	self _current == nil  ifTrue: [^self].
	self isAlreadyAvailable
		ifFalse:
			[self reset.
			self resources do: [:each | each resetOrAddResourcesTo: aCollection]]
		ifTrue:
			[(aCollection includes: self)
				ifFalse:
					[self resources do: [:each | each resetOrAddResourcesTo: aCollection].
					aCollection add: self]]

"The cloned 'self resources do: ...' line in both blocks is, I think, the best way to write this method so that its logic is clear.  The first loop resets this resource immediately, before traversing its resources;  the second traverses before adding"
%

category: 'Running'
classmethod: TestResource
resetResources: topLevelResources
	"Reset all imperfectly-set-up resources while gathering the rest for ordered resetting."

	| availableResources |
	availableResources := OrderedCollection new: topLevelResources size.
	topLevelResources
		do: [:each | each resetOrAddResourcesTo: availableResources].
	availableResources reverseDo: [:each | each reset]
%

category: 'Accessing'
classmethod: TestResource
resources
	^#()
%

category: 'Private'
classmethod: TestResource
_current
		"Because we can run multiple sessions, we can get conflicts on a class instance variable.
		Use SessionTemps instead"

	^SessionTemps current
		at: self currentName
		otherwise: nil.
%

category: 'Private'
classmethod: TestResource
_current: aTestResource

	SessionTemps current at: self currentName put: aTestResource
%

!		Instance methods for 'TestResource'

category: 'Accessing'
method: TestResource
description

	description == nil
		ifTrue: [^''].

	^description
%

category: 'Accessing'
method: TestResource
description: aString

	description := aString
%

category: 'Init / Release'
method: TestResource
initialize
	"This method used to call setUp but now does nothing;  setUp is called by the framework at the appropriate point.  Subclasses may override to set the object to its default state."
%

category: 'Testing'
method: TestResource
isAvailable
	"Override to provide information on the readiness of the resource.  Put state-changing behaviour in setUp and keep this a state-preserving check as far as possible.  Where setUp is guaranteed to provide a valid resource if it completes, there is no need to override this."

	^true
%

category: 'Accessing'
method: TestResource
name

	name == nil
		ifTrue: [^self printString].

	^name
%

category: 'Accessing'
method: TestResource
name: aString

	name := aString
%

category: 'Printing'
method: TestResource
printOn: aStream

	aStream nextPutAll: self class printString
%

category: 'Accessing'
method: TestResource
resources
	^self class resources
%

category: 'Running'
method: TestResource
setUp
	"Does nothing. Subclasses should override this to initialize their resource"
%

category: 'Running'
method: TestResource
tearDown
	"Does nothing. Subclasses should override this to tear down their resource"
%

! Class extensions for 'TestResult'

!		Class methods for 'TestResult'

category: 'Exceptions'
classmethod: TestResult
error
	^self exError
%

category: 'Exceptions'
classmethod: TestResult
exError
	^SUnitNameResolver errorObject
%

category: 'Exceptions'
classmethod: TestResult
failure
	^TestFailure
%

category: 'Init / Release'
classmethod: TestResult
new
	^super new initialize
%

category: 'Exceptions'
classmethod: TestResult
resumableFailure
	^ResumableTestFailure
%

category: 'Exceptions'
classmethod: TestResult
signalErrorWith: aString
	self error sunitSignalWith: aString
%

category: 'Exceptions'
classmethod: TestResult
signalFailureWith: aString
	self failure sunitSignalWith: aString
%

!		Instance methods for 'TestResult'

category: 'Adding'
method: TestResult
addError: aTestCase
	"We cannot use self errors as that incorporates test expectations and so does not return the stored collection."

	^self errors add: aTestCase
%

category: 'Adding'
method: TestResult
addFailure: aTestCase

	^self failures add: aTestCase
%

category: 'Adding'
method: TestResult
addPass: aTestCase
	"We cannot use self passed as that incorporates test expectations and so does not return the stored collection."

	^self passed add: aTestCase
%

category: 'Deprecated'
method: TestResult
correctCount
	"deprecated - use #passedCount"

	self deprecated: 'TestResult>>correctCount deprecated v3.2, use passedCount instead'.
	^self passedCount
%

category: 'Accessing'
method: TestResult
defects
	^OrderedCollection new
		addAll: self errors;
		addAll: self failures; yourself
%

category: 'Accessing'
method: TestResult
errorCount

	^self errors size
%

category: 'Accessing'
method: TestResult
errors

	errors == nil
		ifTrue: [errors := OrderedCollection new].
	^errors
%

category: 'Accessing'
method: TestResult
failureCount

	^self failures size
%

category: 'Accessing'
method: TestResult
failures
	"We use a Set, not an OrderedCollection as #errors and #passed do, because a resumable test failure in a loop can raise many failures against the same test. In current SUnit UIs, this could result in bizarre test count reporting (-27 tests run, and suchlike). This will be reviewed."

	failures ifNil: [failures := Set new].
	^failures
%

category: 'Testing'
method: TestResult
hasErrors

	^self errors size > 0
%

category: 'Testing'
method: TestResult
hasFailures

	^self failures size > 0
%

category: 'Testing'
method: TestResult
hasPassed

	^self hasErrors not and: [self hasFailures not]
%

category: 'Init / Release'
method: TestResult
initialize
%

category: 'Testing'
method: TestResult
isError: aTestCase

	^self errors includes: aTestCase
%

category: 'Testing'
method: TestResult
isFailure: aTestCase
	^self failures includes: aTestCase
%

category: 'Testing'
method: TestResult
isPassed: aTestCase

	^self passed includes: aTestCase
%

category: 'Accessing'
method: TestResult
passed

	passed == nil
		ifTrue: [passed := OrderedCollection new].

	^passed
%

category: 'Accessing'
method: TestResult
passedCount

	^self passed size
%

category: 'Printing'
method: TestResult
printOn: aStream

	aStream
		nextPutAll: self runCount printString;
		nextPutAll: ' run, ';
		nextPutAll: self passedCount printString;
		nextPutAll: ' passed, ';
		nextPutAll: self failureCount printString;
		nextPutAll: ' failed, ';
		nextPutAll: self errorCount printString;
		nextPutAll: ' error'.

	self errorCount ~= 1
		ifTrue: [aStream nextPut: $s]
%

category: 'Running'
method: TestResult
runCase: aTestCase
	[aTestCase runCase.
	self addPass: aTestCase]
		on: self class failure , self class error
		do: [:ex | ex sunitAnnounce: aTestCase toResult: self]
%

category: 'Accessing'
method: TestResult
runCount

	^self passedCount + self failureCount + self errorCount
%

category: 'Accessing'
method: TestResult
tests
	^(OrderedCollection new: self runCount)
		addAll: passed;
		addAll: failures;
		addAll: errors;
		yourself
%

! Class extensions for 'TestSuite'

!		Class methods for 'TestSuite'

category: 'Creation'
classmethod: TestSuite
named: aString

	^self new
		name: aString;
		yourself
%

!		Instance methods for 'TestSuite'

category: 'Dependencies'
method: TestSuite
addDependentToHierachy: anObject
	self sunitAddDependent: anObject.
	self tests do: [ :each | each addDependentToHierachy: anObject]
%

category: 'Accessing'
method: TestSuite
addTest: aTest
	self tests add: aTest
%

category: 'Accessing'
method: TestSuite
addTests: aCollection
	aCollection do: [:eachTest | self addTest: eachTest]
%

category: 'Running'
method: TestSuite
debug

	self tests do: [:each | each debug]
%

category: 'Accessing'
method: TestSuite
defaultResources
	^self tests
		inject: OrderedCollection new
		into:
			[:coll :testCase |
			testCase resources do:
				[:each |
				(coll includes: each) ifFalse: [coll add: each]].
			coll]
%

category: 'Accessing'
method: TestSuite
name

	^name
%

category: 'Accessing'
method: TestSuite
name: aString

	name := aString
%

category: 'Dependencies'
method: TestSuite
removeDependentFromHierachy: anObject
	self sunitRemoveDependent: anObject.
	self tests do: [ :each | each removeDependentFromHierachy: anObject]
%

category: 'Accessing'
method: TestSuite
resources
	resources == nil  ifTrue: [resources := self defaultResources].
	^resources
%

category: 'Accessing'
method: TestSuite
resources: someOrderedTestResourceClasses
	"The parameter should understand reverseDo: and should not contain duplicates."

	resources := someOrderedTestResourceClasses
%

category: 'Running'
method: TestSuite
run
	| result |
	result := TestResult new.
	[self run: result]
		ensure: [TestResource resetResources: self resources].
	^result
%

category: 'Running'
method: TestSuite
run: aResult
	self tests do: [:each |
		self sunitChanged: each.
		each run: aResult]
%

category: 'Accessing'
method: TestSuite
tests
	tests == nil  ifTrue: [tests := OrderedCollection new].
	^tests
%

! Class extensions for 'TranscriptStreamPortable'

!		Class methods for 'TranscriptStreamPortable'

category: 'initialization'
classmethod: TranscriptStreamPortable
initialize
	"self initialize"

	Globals at: #Transcript put: self new.
	 "world write permission"
	(Globals associationAt: #Transcript) objectSecurityPolicy: nil
%

!		Instance methods for 'TranscriptStreamPortable'

category: 'Testing'
method: TranscriptStreamPortable
atEnd
  ^ self shouldNotImplement: #atEnd
%

category: 'Character writing'
method: TranscriptStreamPortable
crlf
"Append a carriage return character followed by a line feed character to the receiver."

self nextPut: Character cr; nextPut: Character lf
%

category: 'Character writing'
method: TranscriptStreamPortable
crtab
"Append a return character, followed by a single tab character, to the
receiver."

| str chr |
(str := String new:2) at: 1 put: (chr := Character) cr;
  at: 2 put: chr tab .
^ self nextPutAll: str
%

category: 'Character writing'
method: TranscriptStreamPortable
crtab: anInteger
"Append a return character, followed by anInteger tab characters, to the
receiver."

| str chr tab |
(str := String new: 1) at: 1 put: (chr := Character) cr.
tab := chr tab .
anInteger timesRepeat: [ str add: tab] .
self nextPutAll: str 
%

category: 'private'
method: TranscriptStreamPortable
endEntry

	self mutex critical: [ | strm contents |
		contents := (strm := self stream) contents.
		strm reset.
		(contents size > 1 and: [ (contents at: 1) = Character lf])
			ifTrue: [
				"gciLogServer tacks a lf on end of previous contents"
				contents := contents copyFrom: 2 to: contents size].
		GsFile gciLogServer: contents ].
%

category: 'ANSI'
method: TranscriptStreamPortable
flush

	self endEntry
%

category: 'private'
method: TranscriptStreamPortable
mutex
	| tmps |
  ^ ((tmps := SessionTemps current)at: #TranscriptStream_SessionMutex otherwise: nil)
	     ifNil:[ tmps at: #TranscriptStream_SessionMutex
			put: Semaphore forMutualExclusion ]
%

category: 'Accessing'
method: TranscriptStreamPortable
next
  ^ self shouldNotImplement: #next
%

category: 'Adding'
method: TranscriptStreamPortable
nextPut: anObject

	self mutex critical: [ ^ self stream nextPut: anObject ]
%

category: 'Adding'
method: TranscriptStreamPortable
nextPutAll: aCollection

	self mutex critical: [ ^self stream nextPutAll: aCollection ]
%

category: 'Adding'
method: TranscriptStreamPortable
nextPutAllBytes: aCharacterCollection
  ^ self shouldNotImplement: #nextPutAllBytes: 
%

category: 'Adding'
method: TranscriptStreamPortable
show: anObject

	self nextPutAll: anObject printString.
	self endEntry
%

category: 'Character writing'
method: TranscriptStreamPortable
space: anInteger
"Append anInteger space characters to the receiver."

| str | 
str := String new: anInteger .
1 to: anInteger do:[:n |str at: n put: $   ].
self nextPutAll: str .
%

category: 'private'
method: TranscriptStreamPortable
stream
	| tmps |
	^ ((tmps := SessionTemps current) at: #'TranscriptStream_SessionStream' otherwise: nil)
		ifNil:[ tmps at: #'TranscriptStream_SessionStream'
				put: (AppendStream on: String new) ]

%

category: 'Character writing'
method: TranscriptStreamPortable
tab: anInteger
"Append anInteger tab characters to the receiver."

anInteger timesRepeat: [self tab]
%

category: 'Adding'
method: TranscriptStreamPortable
_nextPut: anObject
"see PrintStream>>_nextPut:"

self nextPut: anObject
%

! Class extensions for 'WriteStreamLegacy'

!		Class methods for 'WriteStreamLegacy'

category: 'Instance Creation'
classmethod: WriteStreamLegacy
new

"Disallowed.  To create a new stream, use the class method on: instead."

self shouldNotImplement: #new
%

category: 'Instance Creation'
classmethod: WriteStreamLegacy
with: aCollection

"Returns an instance of the receiver open for writing. that is positioned at the end of
 aCollection."
   | res |
   (res := self on: aCollection) setToEnd .
   ^ res
%

!		Instance methods for 'WriteStreamLegacy'

category: 'Accessing'
method: WriteStreamLegacy
contents

"WriteStreams return the portion of their collection that has been written:
 the collection up to the next write-position."

position < 2 ifTrue: [ ^itsCollection species new ].
^itsCollection copyFrom: 1 to: position-1
%

category: 'Character writing'
method: WriteStreamLegacy
crlf
"Append a carriage return character followed by a line feed character to the receiver."

self nextPutAll: CrLf .
%

category: 'Character writing'
method: WriteStreamLegacy
crtab
"Append a return character, followed by a single tab character, to the
receiver."

self nextPutAll: CrTab .
%

category: 'Character writing'
method: WriteStreamLegacy
crtab: anInteger
"Append a return character, followed by anInteger tab characters, to the
receiver."

self nextPut: Cr     .
anInteger timesRepeat: [self nextPut: Tab ]
%

category: 'ANSI'
method: WriteStreamLegacy
flush
	"Update a stream's backing store.
	Upon return, if the receiver is a write-back stream, the state of the
	stream backing store must be consistent with the current state of the
	receiver.
	If the receiver is not a write-back stream, the effect of this
	message is unspecified."

	"We do nothing; this method is provided for ANSI compatibility"
%

category: 'Accessing'
method: WriteStreamLegacy
next

"Disallowed.  You cannot read an instance."

self shouldNotImplement: #next
%

category: 'Adding'
method: WriteStreamLegacy
nextPut: anObject

"Inserts anObject as the next element that the receiver can access for writing.
 Returns anObject."

^ self _nextPut: anObject
%

category: 'Adding'
method: WriteStreamLegacy
nextPutAll: aCollection

"Inserts the elements of aCollection as the next elements that the receiver can
 access.  Returns aCollection."

position == (itsCollection size + 1)
ifFalse:
  [ ^ super nextPutAll: aCollection ].
itsCollection addAll: aCollection.
position := position + (aCollection size).
^ aCollection
%

category: 'Adding'
method: WriteStreamLegacy
nextPutAllBytes: aCharacterCollection

"Inserts the byte contents of aCharacterCollection as the next elements
 that the receiver can access.  Returns aCollection.  The receiver's collection
 must be a type of String."

"Used in the implementation of PassiveObject."

position == (itsCollection size + 1)
ifFalse:
  [ ^ super nextPutAllBytes: aCharacterCollection ].
itsCollection addAllBytes: aCharacterCollection.
position := position + (aCharacterCollection _basicSize).
^ aCharacterCollection
%

category: 'Adding'
method: WriteStreamLegacy
print: anObject

	anObject printOn: self.
%

category: 'Character writing'
method: WriteStreamLegacy
space: anInteger
"Append anInteger space characters to the receiver."

anInteger timesRepeat: [ self nextPut: $   ]
%

category: 'Character writing'
method: WriteStreamLegacy
tab: anInteger
"Append anInteger tab characters to the receiver."

anInteger timesRepeat: [self nextPut: Tab ]
%

category: 'Adding'
method: WriteStreamLegacy
_nextPut: anObject
"see PrintStream>>_nextPut:"

itsCollection at: position put: anObject.
position := position + 1.
^ anObject
%

! Class extensions for 'WriteStreamPortable'

!		Class methods for 'WriteStreamPortable'

category: 'Instance Creation'
classmethod: WriteStreamPortable
new

"Disallowed.  To create a new WriteStream, use the class method on: instead."

self shouldNotImplement: #new
%

category: 'Instance Creation'
classmethod: WriteStreamPortable
on: aCollection from: firstIndex to: lastIndex
"Answer an instance of me on a copy of the argument, aCollection,
determined by the indices firstIndex and lastIndex. Position the instance
at the beginning of the collection."

^self basicNew
	on: aCollection
	from: firstIndex
	to: lastIndex
%

category: 'Instance Creation'
classmethod: WriteStreamPortable
with: aCollection
"Answer an instance of me on the argument, aCollection, positioned to
store objects at the end of aCollection."

^self basicNew with: aCollection
%

category: 'Instance Creation'
classmethod: WriteStreamPortable
with: aCollection from: firstIndex to: lastIndex
"Answer an instance of me on the subcollection of the argument,
aCollection, determined by the indices firstIndex and lastIndex. Position
the instance to store at the end of the subcollection."

^self basicNew with: (aCollection copyFrom: firstIndex to: lastIndex)
%

!		Instance methods for 'WriteStreamPortable'

category: 'Accessing'
method: WriteStreamPortable
contents
"WriteStreams return the portion of their collection that has been written:
 the collection up to the next write-position."

readLimit := readLimit max: position.
^collection copyFrom: 1 to: position
%

category: 'Character writing'
method: WriteStreamPortable
cr
"Append a return character to the receiver."

self nextPut:  Cr   .
%

category: 'Character writing'
method: WriteStreamPortable
crlf
"Append a carriage return character followed by a line feed character to the receiver."

self nextPutAll: CrLf .
%

category: 'Character writing'
method: WriteStreamPortable
crtab
"Append a return character, followed by a single tab character, to the
receiver."

self nextPutAll: CrTab .
%

category: 'Character writing'
method: WriteStreamPortable
crtab: anInteger
"Append a return character, followed by anInteger tab characters, to the
receiver."

self nextPut: Cr .
anInteger timesRepeat: [self nextPut: Tab  ]
%

category: 'ANSI'
method: WriteStreamPortable
flush
	"Update a stream's backing store.
	Upon return, if the receiver is a write-back stream, the state of the
	stream backing store must be consistent with the current state of the
	receiver.
	If the receiver is not a write-back stream, the effect of this
	message is unspecified."

	"We do nothing; this method is provided for ANSI compatibility"
%

category: 'Accessing'
method: WriteStreamPortable
next

"Disallowed.  You cannot read a WriteStream."

self shouldNotImplement: #next
%

category: 'Adding'
method: WriteStreamPortable
next: anInteger putAll: aCollection startingAt: startIndex
"Store the next anInteger elements from the given collection."

| newEnd numPut |
collection class == aCollection class ifFalse:
	[^ super next: anInteger putAll: aCollection startingAt: startIndex ].

numPut := anInteger min: (aCollection size - startIndex + 1).
newEnd := position + numPut.
newEnd > writeLimit ifTrue:
	[^ super next: anInteger putAll: aCollection startingAt: startIndex "Trigger normal pastEndPut: logic"].

collection replaceFrom: position+1 to: newEnd with: aCollection startingAt: startIndex.
position := newEnd.
%

category: 'Adding'
method: WriteStreamPortable
nextPut: anObject

"Inserts anObject as the next element that the receiver can access for writing.
 Returns anObject."

 | pos coll |
 (pos := position) == (coll := collection) size ifTrue: [
   coll add: anObject .
   writeLimit := position :=  pos + 1 .
 ] ifFalse:[
   collection at: position + 1 put: anObject.
   position := position + 1.
 ].
 ^ anObject
%

category: 'Adding'
method: WriteStreamPortable
nextPutAll: aCollection

"Inserts the elements of aCollection as the next elements that the receiver can
 access.  Returns aCollection."
 | coll pos |
 (pos := position) == (coll := collection) size ifTrue:[
   coll addAll: aCollection .
   position := writeLimit := coll size .
 ] ifFalse:[ | newEnd |
   newEnd := pos + aCollection size. 
   collection replaceFrom: pos+1 to: newEnd  with: aCollection startingAt: 1.
   newEnd > writeLimit ifTrue: [
      collection size: newEnd.
      writeLimit := newEnd
   ].
   position := newEnd.
 ].
 ^ aCollection
%

category: 'Adding'
method: WriteStreamPortable
nextPutAllBytes: aCharacterCollection
  "Inserts the byte contents of aCharacterCollection as the next elements
 that the receiver can access.  Returns aCollection.  The receiver's collection
 must be a type of String."

  "Used in the implementation of PassiveObject."

  position == collection size
    ifFalse: [ ^ super nextPutAllBytes: aCharacterCollection ].
  collection addAllBytes: aCharacterCollection.
  position := position + aCharacterCollection _basicSize.
  ^ aCharacterCollection
%

category: 'Private'
method: WriteStreamPortable
on: aCollection

super on: aCollection.
readLimit := 0.
writeLimit := aCollection size
%

category: 'Private'
method: WriteStreamPortable
on: aCollection from: firstIndex to: lastIndex

| len |
collection := aCollection.
readLimit := writeLimit := lastIndex > (len := collection size)
	ifTrue: [len]
	ifFalse: [lastIndex].
position := firstIndex <= 1
	ifTrue: [0]
	ifFalse: [firstIndex - 1]
%

category: 'Private'
method: WriteStreamPortable
pastEndPut: anObject
"Grow the collection by adding anObject one past end.
Then put <anObject> at the current write position."

collection at: position + 1 put: anObject.
position := position + 1.
writeLimit := collection size.
^ anObject
%

category: 'Positioning'
method: WriteStreamPortable
position: anInteger
"Refer to the comment in PositionableStream|position:."

readLimit := readLimit max: position.
super position: anInteger
%

category: 'Adding'
method: WriteStreamPortable
print: anObject

	anObject printOn: self.
%

category: 'Positioning'
method: WriteStreamPortable
reset
"Refer to the comment in PositionableStream|reset."

readLimit := readLimit max: position.
position := 0
%

category: 'Positioning'
method: WriteStreamPortable
setToEnd
"Refer to the comment in PositionableStream|setToEnd."

readLimit := readLimit max: position.
super setToEnd.
%

category: 'Positioning'
method: WriteStreamPortable
size

^readLimit := readLimit max: position
%

category: 'Accessing'
method: WriteStreamPortable
skip: anInteger
"Set the receiver's position to be the current position+anInteger. Do not
 throw error if skipAmount would exceed collection bounds - ANSI compliance. "

self position: ((position + anInteger max: 0) min: writeLimit)
%

category: 'Character writing'
method: WriteStreamPortable
space: anInteger
"Append anInteger space characters to the receiver."

anInteger timesRepeat: [self nextPut: $    ]
%

category: 'Character writing'
method: WriteStreamPortable
tab: anInteger
"Append anInteger tab characters to the receiver."

anInteger timesRepeat: [ self nextPut: Tab ]
%

category: 'Private'
method: WriteStreamPortable
with: aCollection

super on: aCollection.
position := readLimit := writeLimit := aCollection size
%

category: 'Adding'
method: WriteStreamPortable
_nextPut: anObject
"see PrintStream>>_nextPut:"

self nextPut: anObject
%

! Class Initialization Excluded by export visitor
!  HostRandom initialize.
!  TranscriptStreamPortable initialize.
