! Copyright (C) GemTalk Systems 1986-2026.  All Rights Reserved.
! Class Declarations
! Generated file, do not Edit

doit
(Object
	subclass: 'AbstractTrait'
	instVarNames: #(traitImpl)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'AbstractTrait is an abstract superclass to support Traits, which allow sets of 
methods to be shared between classes. ';
		immediateInvariant.
true.
%

removeallmethods AbstractTrait
removeallclassmethods AbstractTrait

doit
(AbstractTrait
	subclass: 'ClassTrait'
	instVarNames: #(instanceTrait)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'A ClassTrait provides the class-side trait behavior of a Trait. Once a Trait is 
created, you can get the associated ClassTrait using Trait >> classTrait.

See the class comment for Trait for more information.';
		immediateInvariant.
true.
%

removeallmethods ClassTrait
removeallclassmethods ClassTrait

doit
(AbstractTrait
	subclass: 'Trait'
	instVarNames: #(classTrait)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'Traits provide a way to share sets of behavior (instance and class methods) between 
classes, other than using inheritance from a shared superclass. Traits allow you to abstract
a set of shared behavior that can be applies to unrelated classes. 

Create a Trait using Trait class >> name:instVars:classVars:classInstVars:inDictionary:, and 
add it to a class using Class >> addTrait: to add the instance method, Class >> addClassTrait: 
to add class methods, or addClassAndInstanceTrait: to add both.  Only one instance side and 
one class side trait can be added to a Class, but they do not need to be from the same Trait.

If the class directly implements a method for the given selector, this overrides that method 
in the Trait.

Adding, modifying, or removing a method on a Trait automatically recompiles the method for 
each class using that Trait.';
		immediateInvariant.
true.
%

removeallmethods Trait
removeallclassmethods Trait

doit
(Object
	subclass: 'GsTraitImpl'
	instVarNames: #(name instanceSourceStrings classSourceStrings instanceCategories classCategories instanceDependents classDependents classForCompiles instanceTrait classTrait traitCategory extraDict)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'Kernel';
		comment: 'GsTraitImpl is an internal class that implements Traits, which allow sets of 
methods to be shared between classes. This class is not meant to be used 
directly. See the Trait class for more information.';
		immediateInvariant.
true.
%

removeallmethods GsTraitImpl
removeallclassmethods GsTraitImpl

! Class implementation for 'AbstractTrait'

!		Instance methods for 'AbstractTrait'

category: 'accessing'
method: AbstractTrait
addDependent: aClass
	self subclassResponsibility: #'addDependent:'
%

category: 'formatting'
method: AbstractTrait
asString

^ self name asString
%

category: 'browser methods'
method: AbstractTrait
categoriesDo: aBlock
	^ self subclassResponsibility: #'categoriesDo:'
%

category: 'browser methods'
method: AbstractTrait
categoryOfSelector: selector
	"Returns the category of the given selector, or nil if it isn't found."

	^ self subclassResponsibility: #'categoryOfSelector: '
%

category: 'accessing'
method: AbstractTrait
classTrait
	"answer the class trait ... by default the receiver .. override in subclass to provide correct answer"

	^ self
%

category: 'compiling'
method: AbstractTrait
compile: sourceString
	self subclassResponsibility: #'compile:'
%

category: 'compiling'
method: AbstractTrait
compile: sourceString category: aCategoryString
	self subclassResponsibility: #'compile:category:'
%

category: 'fileout'
method: AbstractTrait
fileOutTraitOn: stream
	^ self traitImpl fileOutTraitOn: stream
%

category: 'browser methods'
method: AbstractTrait
includesSelector: aString
	^ self subclassResponsibility: #'includesSelector:'
%

category: 'accessing'
method: AbstractTrait
instanceTrait
	"answer the instance trait ... by default the receiver .. override in subclass to provide correct answer"

	^ self
%

category: 'testing'
method: AbstractTrait
isTrait
	"Answer true if the receiver is a Trait"
	^ true
%

category: 'accessing'
method: AbstractTrait
localSelectors
	^ self subclassResponsibility: #'localSelectors'
%

category: 'accessing'
method: AbstractTrait
name
	^ self traitImpl name
%

category: 'updating'
method: AbstractTrait
objectSecurityPolicy: anObjectSecurityPolicy
	"Assigns the receiver and subcomponents to the given security policy."

	super objectSecurityPolicy: anObjectSecurityPolicy.
	traitImpl objectSecurityPolicy: anObjectSecurityPolicy
%

category: 'updating'
method: AbstractTrait
removeAllMethods
	self subclassResponsibility: #'removeAllMethods'
%

category: 'updating'
method: AbstractTrait
removeSelector: aString
	self subclassResponsibility: #'removeSelector:'
%

category: 'accessing'
method: AbstractTrait
sourceCodeAt: selectorSymbol
	^ self subclassResponsibility: #'sourceCodeAt:'
%

category: 'accessing'
method: AbstractTrait
traitImpl
	^traitImpl
%

category: 'accessing'
method: AbstractTrait
traitImpl: object
	traitImpl := object
%

category: 'browser methods'
method: AbstractTrait
_categoriesReport

"Returns an Array containing key-value pairs from the receiver's categories
 for specified environment.
 The key in each key-value pair is the name of a category; the value in each
 key-value pair is a sorted Array of selectors.

 Used by the Topaz 'trlist categories' command."

| result k sz sortedCats catMap |
sortedCats := SortedCollection new:[ :a :b | a key <= b key ].
catMap := SymbolDictionary new.
self categoriesDo:[ :selector :categName|
  (catMap at: categName asSymbol ifAbsentPut: [ SymbolSet new ]) add: selector
].

catMap keysAndValuesDo:[ :categName :selectors|
  sortedCats add: ( Association newWithKey: categName value: selectors)
].
result := Array new: (sz := sortedCats size) * 2  .
k := 1 .
1 to: sz do:[:j | | anAssoc |
   anAssoc := sortedCats at: j .
   result at: k put: anAssoc key .
   result at: k + 1 put: (Array withAll:(SortedCollection withAll: anAssoc _value)).
   k := k + 2 .
].
^ result .
%

category: 'browser methods'
method: AbstractTrait
_categoryOfSelector: selector
	"Returns the category of the given selector, or 'unknown' if it isn't found."

	^ self subclassResponsibility: #'_categoryOfSelector: '
%

category: 'private'
method: AbstractTrait
_extraDictAt: key
	"Return value for key in extraDict.
   Return nil if extraDict or the key are not present. "

	^ self traitImpl _extraDictAt: key
%

category: 'private'
method: AbstractTrait
_extraDictAt: key put: value
	"Add value for key to extraDict.  Create extraDict if not present. "

	^ self traitImpl _extraDictAt: key put: value
%

category: 'private'
method: AbstractTrait
_extraDictRemoveKey: key
 " Remove key/value from extraDict.
    Dont care if extraDict or the key itself are not present. "

	^ self traitImpl _extraDictRemoveKey: key
%

category: 'private'
method: AbstractTrait
_instVarsEqual: anArrayOfInstvarNames
	"Return true if the argument matches the instVarNames
   defined by the receiver , false otherwise."

  | ary |
	ary := self instVarNames .
  ary _isArray ifFalse:[ Error signal:'bad instVarNames']. "TODO delete assert"
	^ ary	= (anArrayOfInstvarNames collect: [ :n | n asSymbol ])
%

category: 'browser methods'
method: AbstractTrait
_selectorsReport: envId matching: aString primitivesOnly: primsBoolean includeDeprecated: inclDeprecBool
	"Used by topaz (and GBS?).
  Result is a sorted SequenceableCollection  of Symbols, plus an optional string 'Omitted .. deprecated methods'.
  aString if not nil restricts the result to only include those selectors containing
  the case-insensitive substring aString .
  primsBoolean if true further restricts the result to only include only
  selectors of methods which are primitives."

	^ self
		subclassResponsibility:
			#'_selectorsReport:matching:primitivesOnly:includeDeprecated:'
%

category: 'browser methods'
method: AbstractTrait
_topazMethodAt: aString
	"Returns a GsNMethod, or signals an Error."

	^ self subclassResponsibility: #'_topazMethodAt:'
%

! Class implementation for 'ClassTrait'

!		Class methods for 'ClassTrait'

category: 'instance creation'
classmethod: ClassTrait
trait: aTraitImpl instance: instanceTrait
	^ self new
		traitImpl: aTraitImpl;
		instanceTrait: instanceTrait;
		yourself
%

!		Instance methods for 'ClassTrait'

category: 'accessing'
method: ClassTrait
addDependent: aClass
	self traitImpl addClassDependent: aClass
%

category: 'Formatting'
method: ClassTrait
asString

^ self name asString, ' classTrait'
%

category: 'browser methods'
method: ClassTrait
categoriesDo: aBlock
	self traitImpl _classCategoriesDo: aBlock
%

category: 'browser methods'
method: ClassTrait
categoryOfSelector: selector
	"Returns the category of the given selector, or nil if it isn't found."

	^ self traitImpl categoryOfSelectorForClassTrait: selector
%

category: 'compiling'
method: ClassTrait
compile: sourceString
	^self traitImpl compileClassMethod: sourceString
%

category: 'compiling'
method: ClassTrait
compile: sourceString category: aCategoryString
	^ self traitImpl compileClassMethod: sourceString category: aCategoryString
%

category: 'browser methods'
method: ClassTrait
includesSelector: aString
	^ self traitImpl _includesSelectorForClassTrait: aString
%

category: 'accessing'
method: ClassTrait
instanceTrait
	^instanceTrait
%

category: 'accessing'
method: ClassTrait
instanceTrait: object
	instanceTrait := object
%

category: 'accessing'
method: ClassTrait
instVarNames
	^ self traitImpl classInstVarNames
%

category: 'testing'
method: ClassTrait
isClassTrait
	"Answer true if the receiver is a Class Trait instance"
	^ true
%

category: 'testing'
method: ClassTrait
isInstanceTrait
	"Answer true if the receiver is an instance side Trait"
	^ false
%

category: 'accessing'
method: ClassTrait
localSelectors
	^ self traitImpl classSelectors
%

category: 'updating'
method: ClassTrait
objectSecurityPolicy: anObjectSecurityPolicy
	"Assigns the receiver and subcomponents to the given security policy."

	super objectSecurityPolicy: anObjectSecurityPolicy.
%

category: 'updating'
method: ClassTrait
removeAllMethods
	self traitImpl removeAllClassSelectors
%

category: 'updating'
method: ClassTrait
removeDependent: aClass

	self traitImpl removeClassDependent: aClass
%

category: 'updating'
method: ClassTrait
removeDependentOnly: aClass
	"remove the dependent, but leave the trait methods in aClass"

	self traitImpl removeClassDependentOnly: aClass
%

category: 'updating'
method: ClassTrait
removeSelector: aString
	self traitImpl removeClassSelector: aString
%

category: 'accessing'
method: ClassTrait
sourceCodeAt: selectorSymbol
	^ self traitImpl classSourceCodeAt: selectorSymbol
%

category: 'browser methods'
method: ClassTrait
_categoryOfSelector: selector
	"Returns the category of the given selector, or 'unknown' if it isn't found."

	^ self traitImpl _categoryOfSelectorForClassTrait: selector
%

category: 'browser methods'
method: ClassTrait
_selectorsReport: envId matching: aString primitivesOnly: primsBoolean includeDeprecated: inclDeprecBool
	"Used by topaz (and GBS?).
  Result is a sorted SequenceableCollection  of Symbols, plus an optional string 'Omitted .. deprecated methods'.
  aString if not nil restricts the result to only include those selectors containing
  the case-insensitive substring aString .
  primsBoolean if true further restricts the result to only include only
  selectors of methods which are primitives."

	^ self traitImpl
		_selectorsReportForClassSide: true
		selectors: self localSelectors
		matching: aString
		primitivesOnly: primsBoolean
		includeDeprecated: inclDeprecBool
%

category: 'browser methods'
method: ClassTrait
_topazMethodAt: aString
	"Returns a GsNMethod, or signals an Error."

	^ self traitImpl _classTopazMethodAt: aString
%

! Class implementation for 'Trait'

!		Class methods for 'Trait'

category: 'instance creation'
classmethod: Trait
name: aString instVars: ivNamesArray classVars: cvNamesArray classInstVars: civNamesArray
	| tr |
	tr := self new.
	tr
		name: aString
		instVars: ivNamesArray
		classVars: cvNamesArray
		classInstVars: civNamesArray.
	^ tr
%

category: 'instance creation'
classmethod: Trait
name: aString instVars: ivNamesArray classVars: cvNamesArray classInstVars: civNamesArray inDictionary: aSymbolDictionary
	"if there is an existing trait with equivalent attributes, preserve the identity of the trait, otherwise "

	| newTrait sym |
	sym := aString asSymbol.
	newTrait := self
		name: aString
		instVars: ivNamesArray
		classVars: cvNamesArray
		classInstVars: civNamesArray.
	(aSymbolDictionary at: sym ifAbsent: [  ])
		ifNil: [ 
			"brand new instance"
			aSymbolDictionary at: sym asSymbol put: newTrait.
			^ newTrait ]
		ifNotNil: [ :oldTrait | 
			"if oldTrait equivalent to newTrait leave things as the are"
			(newTrait
				_equivalentToTrait: oldTrait
				name: aString
				newInstVars: ivNamesArray
				newClassInstVars: civNamesArray
				newClassVars: cvNamesArray)
				ifTrue: [ ^ oldTrait ]
				ifFalse: [ 
					"Note that the user is responsible to manage the classes that are dependent upon the old traits 
             ... that is best done after the new trait has been added to system."
 " more work needed, bug 51234"
          aSymbolDictionary  name == #Globals ifTrue:[ Error signal:'attempt to create new version of a Trait'].
					aSymbolDictionary at: sym asSymbol put: newTrait.
					^ newTrait ] ]
%

!		Instance methods for 'Trait'

category: 'accessing'
method: Trait
addDependent: aClass
	self traitImpl addInstanceDependent: aClass
%

category: 'browser methods'
method: Trait
categoriesDo: aBlock
	self traitImpl _instanceCategoriesDo: aBlock
%

category: 'accessing'
method: Trait
category
	^ self traitImpl _category
%

category: 'accessing'
method: Trait
category: newCategory
	"Sets the traitCategory variable of the receiver.
 The argument should be a kind of CharacterCollection or nil."

	"category/packageName used in Trait tonel file"

	^ self traitImpl _category: newCategory
%

category: 'browser methods'
method: Trait
categoryOfSelector: selector
	"Returns the category of the given selector, or nil if it isn't found."

	^ self traitImpl categoryOfSelectorForInstanceTrait: selector
%

category: 'accessing'
method: Trait
classInstVarNames
	^ self traitImpl classInstVarNames
%

category: 'accessing'
method: Trait
classTrait
	^classTrait
%

category: 'accessing'
method: Trait
classTrait: object
	classTrait := object
%

category: 'accessing'
method: Trait
classVarNames
	^ self traitImpl classVarNames
%

category: 'accessing'
method: Trait
comment
	^ self traitImpl comment
%

category: 'accessing'
method: Trait
comment: aString
	^ self traitImpl comment: aString
%

category: 'compiling'
method: Trait
compile: sourceString
	^self traitImpl compileMethod: sourceString
%

category: 'compiling'
method: Trait
compile: sourceString category: aCategoryString
	^ self traitImpl compileMethod: sourceString category: aCategoryString
%

category: 'fileout'
method: Trait
fileOutTraitDefinitionOn: stream

	self traitImpl fileOutTraitDefinitionOn: stream
%

category: 'browser methods'
method: Trait
includesSelector: aString
	^ self traitImpl _includesSelectorForInstanceTrait: aString
%

category: 'accessing'
method: Trait
instanceTrait
	^ self
%

category: 'accessing'
method: Trait
instVarNames
	^ self traitImpl instVarNames
%

category: 'updating'
method: Trait
instVars: ivNamesArray classVars: cvNamesArray classInstVars: civNamesArray
	self traitImpl
		instVars: ivNamesArray
		classVars: cvNamesArray
		classInstVars: civNamesArray
%

category: 'testing'
method: Trait
isClassTrait
	"Answer true if the receiver is a Class Trait instance"
	^ false
%

category: 'testing'
method: Trait
isInstanceTrait
	"Answer true if the receiver is an instance side Trait"
	^ true
%

category: 'accessing'
method: Trait
localSelectors
	^ self traitImpl instanceSelectors
%

category: 'accessing'
method: Trait
name
	^ self traitImpl name
%

category: 'initialization'
method: Trait
name: aSymbol instVars: ivNamesArray classVars: cvNamesArray classInstVars: civNamesArray
	traitImpl := GsTraitImpl
		name: aSymbol
		instVars: ivNamesArray
		classVars: cvNamesArray
		classInstVars: civNamesArray.
	classTrait := ClassTrait trait: traitImpl instance: self.
	traitImpl
		instanceTrait: self;
		classTrait: classTrait
%

category: 'updating'
method: Trait
objectSecurityPolicy: anObjectSecurityPolicy
	"Assigns the receiver and subcomponents to the given security policy."

	super objectSecurityPolicy: anObjectSecurityPolicy.
%

category: 'updating'
method: Trait
removeAllMethods
	self traitImpl removeAllInstanceSelectors
%

category: 'updating'
method: Trait
removeDependent: aClass

	self traitImpl removeInstanceDependent: aClass
%

category: 'updating'
method: Trait
removeDependentOnly: aClass
	"remove the dependent, but leave the trait methods in aClass"

	self traitImpl removeInstanceDependentOnly: aClass
%

category: 'updating'
method: Trait
removeFromSystem
	"When a trait is removed from the system it should:

	- Remove it self from its users.
	- Remove its classTrait from its users.
	- Remove itself from it's Symbol Dictionary"

	| arr |
	self traitImpl removeFromSystem.
	arr := GsCurrentSession currentSession symbolList
		dictionariesAndSymbolsOf: self.
	arr
		do: [ :ar | 
			| symDict traitKey |
			symDict := ar at: 1.
			traitKey := ar at: 2.
			symDict removeKey: traitKey ]
%

category: 'updating'
method: Trait
removeSelector: aString
	self traitImpl removeSelector: aString
%

category: 'accessing'
method: Trait
sourceCodeAt: selectorSymbol
	^ self traitImpl instanceSourceCodeAt: selectorSymbol
%

category: 'accessing'
method: Trait
traitImpl
	^traitImpl
%

category: 'accessing'
method: Trait
traitImpl: object
	traitImpl := object
%

category: 'browser methods'
method: Trait
_categoryOfSelector: selector
	"Returns the category of the given selector, or 'unknown' if it isn't found."

	^ self traitImpl _categoryOfSelectorForInstanceTrait: selector
%

category: 'private'
method: Trait
_classVarsEqual: anArrayOfClassvarNames
	"Return true if the argument matches the classVarNames
   defined by the receiver , false otherwise."

	^ (SortedCollection withAll: self classVarNames)
		= (SortedCollection withAll: (anArrayOfClassvarNames collect: [ :n | n asSymbol ]))
%

category: 'private'
method: Trait
_comment
	"answer comment or nil if no comment defined"

	^ self traitImpl _comment
%

category: 'private'
method: Trait
_equivalentToTrait: oldTrait name: aString newInstVars: ivNamesArray newClassInstVars: civNamesArray newClassVars: cvNamesArray
	"answer true if the attributes of the oldTrait match those being passed in as arguments ... traits don't have 
		versions, but equivalent creation methods should not create new instances of a trait .. required for upgradeImage"

	| ivs civs cvars ok |
	ivs := oldTrait _instVarsEqual: ivNamesArray.
	civs := oldTrait classTrait _instVarsEqual: civNamesArray.
	cvars := oldTrait _classVarsEqual: cvNamesArray.
	ok := ivs and: [ civs and: [ cvars ] ] .
  "  ok ifFalse:[ self pause ]. "
  ^ ok .
%

category: 'browser methods'
method: Trait
_selectorsReport: envId matching: aString primitivesOnly: primsBoolean includeDeprecated: inclDeprecBool
	"Used by topaz (and GBS?).
  Result is a sorted SequenceableCollection  of Symbols, plus an optional string 'Omitted .. deprecated methods'.
  aString if not nil restricts the result to only include those selectors containing
  the case-insensitive substring aString .
  primsBoolean if true further restricts the result to only include only
  selectors of methods which are primitives."

	^ self traitImpl
		_selectorsReportForClassSide: false
		selectors: self localSelectors
		matching: aString
		primitivesOnly: primsBoolean
		includeDeprecated: inclDeprecBool
%

category: 'browser methods'
method: Trait
_topazFileoutClass: headerStr asUtf8: utf8Bool env: envId
	"method sent from topaz common code ..."

	^ self traitImpl _topazFileoutTrait: headerStr asUtf8: utf8Bool
%

category: 'browser methods'
method: Trait
_topazMethodAt: aString
	"Returns a GsNMethod, or signals an Error."

	^ self traitImpl _instanceTopazMethodAt: aString
%

! Class implementation for 'GsTraitImpl'

!		Class methods for 'GsTraitImpl'

category: 'instance creation'
classmethod: GsTraitImpl
name: aString instVars: ivNamesArray classVars: cvNamesArray classInstVars: civNamesArray
  | tr sym |
  tr := self new .
  tr name: (sym := aString asSymbol)  instVars: ivNamesArray  classVars: cvNamesArray classInstVars: civNamesArray.
  ^ tr
%

!		Instance methods for 'GsTraitImpl'

category: 'updating'
method: GsTraitImpl
addClassDependent: aClass
	classDependents ifNil: [ classDependents := IdentitySet new ].
	(classDependents includes: aClass)
		ifTrue: [ ^ self ].
	classDependents add: aClass.
	classSourceStrings
		keysAndValuesDo: [ :selector :sourceString | 
			self
				_basicCompile: selector
				source: sourceString
				category: (classCategories at: selector)
				in: aClass class
				origin: self classTrait ]
%

category: 'updating'
method: GsTraitImpl
addInstanceDependent: aClass
	instanceDependents ifNil: [ instanceDependents := IdentitySet new ].
	(instanceDependents includes: aClass)
		ifTrue: [ ^ self ].
	instanceDependents add: aClass.
	instanceSourceStrings
		keysAndValuesDo: [ :selector :sourceString | 
			self
				_basicCompile: selector
				source: sourceString
				category: (instanceCategories at: selector)
				in: aClass
				origin: self instanceTrait ]
%

category: 'formatting'
method: GsTraitImpl
asString

^ self name asString
%

category: 'browser methods'
method: GsTraitImpl
categoryOfSelectorForClassTrait: aString
	"Returns the category of the given selector, or nil if it isn't found."

	| sel |
	sel := aString asSymbol.
	^ self classCategories at: sel ifAbsent: [  ]
%

category: 'browser methods'
method: GsTraitImpl
categoryOfSelectorForInstanceTrait: aString
	"Returns the category of the given selector, or nil if it isn't found."

	| sel |
	sel := aString asSymbol.
	^ self instanceCategories at: sel ifAbsent: [  ]
%

category: 'accessing'
method: GsTraitImpl
classCategories
	^classCategories
%

category: 'accessing'
method: GsTraitImpl
classCategories: object
	classCategories := object
%

category: 'accessing'
method: GsTraitImpl
classForCompiles
  ^ classForCompiles
%

category: 'accessing'
method: GsTraitImpl
classInstVarNames
	^ classForCompiles class instVarNames
%

category: 'accessing'
method: GsTraitImpl
classSelectors
	^ self classSourceStrings keys
%

category: 'accessing'
method: GsTraitImpl
classSourceCodeAt: selectorSymbol
  ^ classSourceStrings at: selectorSymbol otherwise: nil
%

category: 'accessing'
method: GsTraitImpl
classSourceStrings
  ^ classSourceStrings
%

category: 'accessing'
method: GsTraitImpl
classTrait
	^classTrait
%

category: 'accessing'
method: GsTraitImpl
classTrait: object
	classTrait := object
%

category: 'accessing'
method: GsTraitImpl
classVarNames
	^ classForCompiles classVarNames
%

category: 'accessing'
method: GsTraitImpl
comment
	| str |
	self _comment ifNotNil: [ :cmt | ^ cmt ].
	str := 'No Trait-specific documentation for ' , self name.
	^ str
%

category: 'accessing'
method: GsTraitImpl
comment: aString

  (aString isKindOf: CharacterCollection) ifFalse: [
    ArgumentTypeError signal: 'Comment must be a String' ].
  self _extraDictAt: #comment put: aString
%

category: 'fileout'
method: GsTraitImpl
commentForFileout
	"Returns a non-empty class comment or nil."

	| str |
	str := self _extraDictAt: #'comment'.
	str size = 0
		ifTrue: [ ^ nil ].
	^ str
%

category: 'compiling'
method: GsTraitImpl
compileClassMethod: sourceString
	^ self compileClassMethod: sourceString category: #'(as yet unclassified)'
%

category: 'compiling'
method: GsTraitImpl
compileClassMethod: sourceString category: aCategoryString
	| sel cat |
	self classForCompiles class
		_compileMethod: sourceString
		symbolList: System myUserProfile symbolList.
	sel := self class extractSelector: sourceString.
	cat := aCategoryString
		ifNil: [ #'(as yet unclassified)' ]
		ifNotNil: [ :str | str asSymbol ].
	self classSourceStrings at: sel put: sourceString.
	self classCategories at: sel put: cat.
	classDependents
		do: [ :aCls | 
			self
				_basicCompile: sel
				source: sourceString
				category: cat
				in: aCls class
				origin: self classTrait ]
%

category: 'compiling'
method: GsTraitImpl
compileMethod: sourceString
	^ self compileMethod: sourceString category: #'(as yet unclassified)'
%

category: 'compiling'
method: GsTraitImpl
compileMethod: sourceString category: aCategoryString
	| sel cat |
	self classForCompiles
		_compileMethod: sourceString
		symbolList: System myUserProfile symbolList.
	sel := self class extractSelector: sourceString.
	cat := aCategoryString
		ifNil: [ #'(as yet unclassified)' ]
		ifNotNil: [ :str | str asSymbol ].
	self instanceSourceStrings at: sel put: sourceString.
	self instanceCategories at: sel put: cat.
	instanceDependents
		do: [ :aCls | 
			self
				_basicCompile: sel
				source: sourceString
				category: cat
				in: aCls
				origin: self instanceTrait ]
%

category: 'browser methods'
method: GsTraitImpl
definition
	"Returns a String containing a GemStone Smalltalk definition for the receiver
 (that is, a trait creation message).  This method uses the UserProfile
 of the owner of the current session as the correct context."
	"For use with the Topaz run command."

	^self _definitionInContext: System myUserProfile
%

category: 'fileout'
method: GsTraitImpl
fileOutClassMethod: selector on: stream
	"Writes the given method's source to the given stream in Topaz Filein format."

	self fileOutMethod: selector forClassTrait: true on: stream
%

category: 'fileout'
method: GsTraitImpl
fileOutCommentOn: stream
	"Writes code to create trait comment onto the given stream in
 filein format."

	self _fileoutHeaderOn: stream.
	self commentForFileout
		ifNotNil: [ :cmt | 
			stream
				nextPutAll: 'expectvalue /Trait';
				lf;
				nextPutAll: 'doit';
				lf;
				_fileOutAll: self name;
				nextPutAll: ' comment: ';
				lf;
				_fileOutAll: cmt printString;
				lf;
				nextPut: $%;
				lf ]
%

category: 'fileout'
method: GsTraitImpl
fileOutInstanceMethod: selector on: stream
	"Writes the given method's source to the given stream in Topaz Filein format."

	self fileOutMethod: selector forClassTrait: false on: stream
%

category: 'fileout'
method: GsTraitImpl
fileOutMethod: selector forClassTrait: forClassTrait on: stream
	"Writes the given method's source to the given stream in Topaz Filein format."

	| lf cat src |
	self _fileoutHeaderOn: stream.
	src := forClassTrait
		ifTrue: [ self classSourceCodeAt: selector ]
		ifFalse: [ self instanceSourceCodeAt: selector ].
	src class ~~ Unicode7
		ifTrue: [ 
			(stream dynamicInstVarAt: #'utf8Bool') == false
				ifTrue: [ 
					(Unicode7 _withAll: src)
						ifNotNil: [ :s | 
							"source ok"
							 ]
						ifNil: [ 
							Error
								signal:
									'source for ' , selector printString
										, ' contains codePoint > 127  when non-Utf8 fileout requested' ] ] ].
	lf := Character lf.
	cat := forClassTrait
		ifTrue: [ self _categoryOfSelectorForClassTrait: selector ]
		ifFalse: [ self _categoryOfSelectorForInstanceTrait: selector ].
	cat ifNil: [ ^ self _error: #'rtErrKeyNotFound' args: {selector} ].
	stream
		nextPutAll: 'category: ''';
		_fileOutAll: cat;
		nextPut: $';
		nextPut: lf.
	forClassTrait
		ifTrue: [ stream nextPutAll: 'trclassmethod: ' ]
		ifFalse: [ stream nextPutAll: 'trmethod: ' ].
	stream
		_fileOutAll: self name;
		nextPut: lf.
	stream _fileOutAll: src.
	src last == lf
		ifFalse: [ stream nextPut: lf ].
	stream
		nextPut: $%;
		nextPut: lf
%

category: 'fileout'
method: GsTraitImpl
fileOutMethodRemovalOn: stream name: traitname
	"Writes code to remove all the receiver's methods onto the given stream
  in filein format."

	self _fileoutHeaderOn: stream.
	stream
		nextPutAll: '! ------------------- Remove existing behavior from ';
		_fileOutAll: traitname;
		lf;
		nextPutAll: 'trremoveallmethods ';
		_fileOutAll: traitname;
		lf;
		nextPutAll: 'trremoveallclassmethods ';
		_fileOutAll: traitname;
		lf
%

category: 'fileout'
method: GsTraitImpl
fileOutMethodsOn: stream
	"File out this trait's methods, but sort the selectors alphabetically."

	| sels nm |
	nm := self name.
	self fileOutMethodRemovalOn: stream name: nm.

	stream
		nextPutAll: '! ------------------- Class methods for ';
		_fileOutAll: nm;
		lf.
	sels := SortedCollection withAll: self classSelectors.
	1 to: sels size do: [ :i | self fileOutClassMethod: (sels at: i) on: stream ].
	stream
		nextPutAll: '! ------------------- Instance methods for ';
		_fileOutAll: nm;
		lf.
	sels := SortedCollection withAll: self instanceSelectors.
	1 to: sels size do: [ :i | self fileOutInstanceMethod: (sels at: i) on: stream ].
	^ stream
%

category: 'fileout'
method: GsTraitImpl
fileOutTraitCategoryOn: stream
	"Writes out trait category, if there is one for this trait."

	self _fileoutHeaderOn: stream.
	self _traitCategory
		ifNotNil: [ :cat | 
			stream
				nextPutAll: 'expectvalue /Trait';
				lf;
				nextPutAll: 'doit';
				lf;
				_fileOutAll: self name asString;
				nextPutAll: ' category: ';
				_fileOutAll: cat quoted;
				lf;
				nextPut: $%;
				lf ]
%

category: 'fileout'
method: GsTraitImpl
fileOutTraitDefinitionOn: stream
	"Writes the receiver's preclass, trait definition, and comment onto
 the given stream in filein format."

	self _fileoutHeaderOn: stream.
	stream
		nextPutAll: '! ------------------- Trait definition for ';
		_fileOutAll: self name;
		lf.
	stream
		nextPutAll: 'expectvalue /Trait';
		lf;
		nextPutAll: 'doit';
		lf;
		_fileOutAll: self definition;
		lf;
		nextPut: $%;
		lf.
	self fileOutCommentOn: stream.
	self fileOutTraitCategoryOn: stream
%

category: 'fileout'
method: GsTraitImpl
fileOutTraitOn: stream
"Writes the receiver's definition and methods onto the given stream in
 filein format."

self _fileoutHeaderOn: stream  .
self fileOutTraitDefinitionOn: stream .
self fileOutMethodsOn: stream .
%

category: 'accessing'
method: GsTraitImpl
instanceCategories
	^instanceCategories
%

category: 'accessing'
method: GsTraitImpl
instanceCategories: object
	instanceCategories := object
%

category: 'accessing'
method: GsTraitImpl
instanceSelectors
	^ self instanceSourceStrings keys
%

category: 'accessing'
method: GsTraitImpl
instanceSourceCodeAt: selectorSymbol
  ^ instanceSourceStrings at: selectorSymbol otherwise: nil
%

category: 'accessing'
method: GsTraitImpl
instanceSourceStrings
  ^ instanceSourceStrings
%

category: 'accessing'
method: GsTraitImpl
instanceTrait
	^instanceTrait
%

category: 'accessing'
method: GsTraitImpl
instanceTrait: object
	instanceTrait := object
%

category: 'accessing'
method: GsTraitImpl
instVarNames
	^ classForCompiles instVarNames
%

category: 'updating'
method: GsTraitImpl
instVars: ivNamesArray classVars: cvNamesArray classInstVars: civNamesArray
	classForCompiles := Object
		subclass: name , '_traitClass'
		instVarNames: ivNamesArray
		classVars: cvNamesArray
		classInstVars: civNamesArray
		poolDictionaries: #()
		inDictionary: nil
		options: #(#'subclassesDisallowed' #'instancesNonPersistent')
%

category: 'accessing'
method: GsTraitImpl
name
	^ name
%

category: 'initialization'
method: GsTraitImpl
name: aSymbol instVars: ivNamesArray classVars: cvNamesArray classInstVars: civNamesArray
	name := aSymbol.
	instanceSourceStrings := SymbolDictionary new.
	classSourceStrings := SymbolDictionary new.
	instanceCategories := SymbolDictionary new.
	classCategories := SymbolDictionary new.
	instanceDependents := IdentitySet new.
	classDependents := IdentitySet new.
	extraDict := SymbolDictionary new.
	extraDict objectSecurityPolicy: self objectSecurityPolicy.
	self
		instVars: ivNamesArray
		classVars: cvNamesArray
		classInstVars: civNamesArray
%

category: 'updating'
method: GsTraitImpl
objectSecurityPolicy: anObjectSecurityPolicy
	"Assigns the receiver and subcomponents to the given security policy."

	super objectSecurityPolicy: anObjectSecurityPolicy.
	instanceSourceStrings objectSecurityPolicy: anObjectSecurityPolicy.
	classSourceStrings objectSecurityPolicy: anObjectSecurityPolicy.
	instanceCategories objectSecurityPolicy: anObjectSecurityPolicy.
	classCategories objectSecurityPolicy: anObjectSecurityPolicy.
	instanceDependents objectSecurityPolicy: anObjectSecurityPolicy.
	classDependents objectSecurityPolicy: anObjectSecurityPolicy.
	classForCompiles objectSecurityPolicy: anObjectSecurityPolicy.
	extraDict objectSecurityPolicy: anObjectSecurityPolicy
%

category: 'updating'
method: GsTraitImpl
removeAllClassSelectors
	self classSourceStrings keys do: [ :sel | self removeClassSelector: sel ]
%

category: 'updating'
method: GsTraitImpl
removeAllInstanceSelectors
	self instanceSourceStrings keys do: [ :sel | self removeSelector: sel ]
%

category: 'updating'
method: GsTraitImpl
removeClassDependent: aClass
	"remove dependent AND remove the methods from aClass"

	classDependents ifNil: [ ^ self ].
	self removeClassDependentOnly: aClass.
	classSourceStrings
		keysAndValuesDo: [ :selector :sourceString | self _basicRemove: selector from: aClass class origin: self classTrait ]
%

category: 'updating'
method: GsTraitImpl
removeClassDependentOnly: aClass
	"remove the dependent, but leave the trait methods in aClass"

	classDependents ifNil: [ ^ self ].
	classDependents remove: aClass
%

category: 'updating'
method: GsTraitImpl
removeClassSelector: aString
	| sel |
	classDependents do: [ :aCls | aCls class removeSelector: aString ].
	sel := aString asSymbol.
	self classSourceStrings removeKey: sel.
	self classCategories removeKey: sel
%

category: 'updating'
method: GsTraitImpl
removeFromSystem
	"When a trait is removed from the system it should remove instanceTrait and classTrait 
		from dependents -- trait methods will be removed from dependents as well."

	| trait |
	trait := self classTrait.
	classDependents copy
		do: [ :dependentClass | dependentClass removeClassTrait: trait ].
	trait := self instanceTrait.
	instanceDependents copy
		do: [ :dependentClass | dependentClass removeTrait: trait ]
%

category: 'updating'
method: GsTraitImpl
removeInstanceDependent: aClass
	"remove the dependent, but leave the trait methods in aClass"

	instanceDependents ifNil: [ ^ self ].
	self removeInstanceDependentOnly: aClass.
	instanceSourceStrings
		keysAndValuesDo: [ :selector :sourceString | self _basicRemove: selector from: aClass origin: self instanceTrait ]
%

category: 'updating'
method: GsTraitImpl
removeInstanceDependentOnly: aClass
	"remove the dependent, but leave the trait methods in aClass"

	instanceDependents ifNil: [ ^ self ].
	instanceDependents remove: aClass.
%

category: 'updating'
method: GsTraitImpl
removeSelector: aString
	| sel |
	sel := aString asSymbol.
	self instanceSourceStrings removeKey: sel.
	self instanceCategories removeKey: sel.
	instanceDependents do: [ :aCls | aCls removeSelector: aString ].
%

category: 'private'
method: GsTraitImpl
_basicCompile: selector source: sourceString category: categoryString in: classOrMetaclass origin: aClassOrInstanceTrait
	"Compile trait method in classOrMetaclass, 
  if the method is not present in the class or the receiver IS the origin of the method"
	| existingMethod compiledMethod |
	existingMethod := classOrMetaclass compiledMethodAt: selector otherwise: nil.
	(existingMethod isNil or: [ existingMethod origin = aClassOrInstanceTrait ])
		ifTrue: [ 
			"compile method unconditionally as a non-Rowan method ... since we are a trait method override"
			GsObjectSecurityPolicy
				setCurrent: self objectSecurityPolicy
				while: [ 
					compiledMethod := classOrMetaclass
						compileMethod: sourceString
						dictionaries: GsCurrentSession currentSession symbolList
						category: categoryString asSymbol
						intoMethodDict: nil
						intoCategories: nil
						environmentId: 0 ].
			compiledMethod _origin: aClassOrInstanceTrait ]
%

category: 'private'
method: GsTraitImpl
_basicRemove: selector from: classOrMetaclass
	"remove trait method from aCls, if the method is not present in the class or the receiver IS the origin of the method"

	| existingMethod |
	existingMethod := classOrMetaclass compiledMethodAt: selector otherwise: nil.
	(existingMethod notNil and: [ existingMethod origin == self ])
		ifTrue: [ 
			classOrMetaclass removeSelector: selector.
			existingMethod _origin: nil ]
%

category: 'private'
method: GsTraitImpl
_basicRemove: selector from: classOrMetaclass origin: aClassOrInstanceTrait
	"remove trait method from aCls, if the method is not present in the class or the receiver IS the origin of the method"

	| existingMethod |
	existingMethod := classOrMetaclass compiledMethodAt: selector otherwise: nil.
	(existingMethod notNil and: [ existingMethod origin = aClassOrInstanceTrait ])
		ifTrue: [ 
			classOrMetaclass removeSelector: selector.
			existingMethod _origin: nil ]
%

category: 'private'
method: GsTraitImpl
_category
	"Returns the receiver's traitCategoyr or nil."

	^ traitCategory
%

category: 'private'
method: GsTraitImpl
_category: newCategory
"Sets the traitCategory variable of the receiver.
 The argument should be a kind of CharacterCollection or nil."
"category/packageName used in Trait tonel file"

newCategory ifNil:[
	traitCategory := nil.
	^ self ].

(newCategory _validateClass: CharacterCollection ) ifFalse:[ ^ nil ].

traitCategory := newCategory asString
%

category: 'browser methods'
method: GsTraitImpl
_categoryOfSelectorForClassTrait: aString
	"Returns the category of the given selector, or 'unknown' if it isn't found."

	^ (self categoryOfSelectorForClassTrait: aString) ifNil: [ 'unknown' ]
%

category: 'browser methods'
method: GsTraitImpl
_categoryOfSelectorForInstanceTrait: aString
	"Returns the category of the given selector, or 'unknown' if it isn't found."

	^ (self categoryOfSelectorForInstanceTrait: aString) ifNil: [ 'unknown' ]
%

category: 'browser methods'
method: GsTraitImpl
_classCategoriesDo: aBlock
	classCategories keysAndValuesDo: aBlock
%

category: 'private'
method: GsTraitImpl
_classDependents
	^ classDependents
%

category: 'browser methods'
method: GsTraitImpl
_classTopazMethodAt: aString
	"Returns a GsNMethod, or signals an Error."

	| sel sourceString |
	sel := aString asSymbol.
	sourceString := (self classSourceCodeAt: sel) ifNil: [ ^ nil ].
	^ self classForCompiles class
		_compileMethod: sourceString
		symbolList: System myUserProfile symbolList
%

category: 'private'
method: GsTraitImpl
_classVars
	^ classForCompiles _classVars
%

category: 'private'
method: GsTraitImpl
_comment
	"answer nil if no comment defined"

	^ self _extraDictAt: #'comment'
%

category: 'browser methods'
method: GsTraitImpl
_definitionInContext: aUserProfile
	"Returns a description of the receiver using object names taken from the given
 UserProfile."

	| result lfsp civs iVs |
	result := String new.
	result addAll: 'Trait'.
	(lfsp := Character lf asString) addAll: '  '.

	result
		addAll: ' name: ''';
		addAll: name;
		addLast: $'.	
	iVs := self instVarNames.
	result
		addAll: lfsp;
		addAll: 'instVars: #(';
		addAll: (self _instVarNamesWithSeparator: lfsp , '                 ');
		add: $).	" instVars: #( <list of strings> ) "
	result
		addAll: lfsp;
		addLast: 'classVars: #('.
	self _sortedClassVarNames
		accompaniedBy: result
		do: [ :res :aKey | 
			res addLast: $ .
			(aKey includesValue: $')
				ifTrue: [ res addAll: aKey _asSource ]
				ifFalse: [ res addAll: aKey ] ].
	result addLast: $).	" classVars: #( <list of strings> ) "
	result
		addAll: lfsp;
		addLast: 'classInstVars: #('.
	civs := self classForCompiles class allInstVarNames.
	civs removeFrom: 1 to: self classForCompiles class superClass instSize.
	civs
		accompaniedBy: result
		do: [ :res :civName | 
			res addLast: $ .
			(civName includesValue: $')
				ifTrue: [ res addAll: civName _asSource ]
				ifFalse: [ res addAll: civName ] ].
	result addLast: $).	" classInstVars: #( <list of strings> ) "
	result
		addAll: lfsp;
		addAll: 'inDictionary: ';
		addAll: (self _dictionaryNameForFileout: aUserProfile). " inDictionary: <name of containing dictionary> "
	result
		add: lfsp;
		add: Character lf.
	^ result
%

category: 'browser methods'
method: GsTraitImpl
_dictionaryNameForFileout: aUserProfile
	| anArray |
	anArray := aUserProfile dictionariesAndSymbolsOf: self instanceTrait.
	anArray size ~~ 0
		ifTrue: [ 
			anArray := aUserProfile dictionariesAndSymbolsOf: ((anArray at: 1) at: 1).
			anArray size == 0
				ifTrue: [ ^ '(dictionary not in your dictionaries)' ]
				ifFalse: [ 
					| dName |
					(dName := (anArray at: 1) at: 2) isValidIdentifier
						ifTrue: [ ^ dName ] ] ].
	^ 'UserGlobals'
%

category: 'private'
method: GsTraitImpl
_extraDictAt: key
	"Return value for key in extraDict.
   Return nil if the key is not present. "

	^ extraDict at: key otherwise: nil
%

category: 'private'
method: GsTraitImpl
_extraDictAt: key put: value
	"Add value for key to extraDict. "

	^ extraDict at: key put: value
%

category: 'private'
method: GsTraitImpl
_extraDictRemoveKey: key
	" Remove key/value from extraDict. "

	extraDict removeKey: key ifAbsent: [  ]
%

category: 'fileout'
method: GsTraitImpl
_fileoutHeaderOn: stream
  | prevEnv |
  stream isEmpty ifTrue:[
    (stream isKindOf: GsFile) ifTrue:[
      stream nextPutAll: 'fileformat utf8' ; lf .
    ].
    "Gs64 v3.3, no SET SOURCESTRINGCLASS directives in fileouts."
  ].
  prevEnv := stream dynamicInstVarAt: #environmentId .
  prevEnv ~~ 0 ifTrue:[ 
    stream nextPutAll:'set compile_env: ' ; nextPutAll: '0' ; lf .
    stream dynamicInstVarAt: #environmentId put: 0 .
  ]
%

category: 'browser methods'
method: GsTraitImpl
_includesSelectorForClassTrait: aString
	| sel |
	sel := aString asSymbol.
	^ self classCategories includesKey: sel
%

category: 'browser methods'
method: GsTraitImpl
_includesSelectorForInstanceTrait: aString
	| sel |
	sel := aString asSymbol.
	^ self instanceCategories includesKey: sel
%

category: 'browser methods'
method: GsTraitImpl
_instanceCategoriesDo: aBlock
	instanceCategories keysAndValuesDo: aBlock
%

category: 'private'
method: GsTraitImpl
_instanceDependents
	^ instanceDependents
%

category: 'browser methods'
method: GsTraitImpl
_instanceTopazMethodAt: aString
	"Returns a GsNMethod, or signals an Error.  Returns nil if method not found."

	| sel sourceString |
	sel := aString asSymbol.
	sourceString := (self instanceSourceCodeAt: sel) ifNil: [ ^ nil ].
	^ self classForCompiles
		_compileMethod: sourceString
		symbolList: System myUserProfile symbolList
%

category: 'browser methods'
method: GsTraitImpl
_instVarNamesWithSeparator: sep
	"Returns a string showing my instance variables, with the given
 separator string inserted after every three names."

	^ self classForCompiles _instVarNamesWithSeparator: sep
%

category: 'browser methods'
method: GsTraitImpl
_selectorsReportForClassSide: forClassSide selectors: list matching: aString primitivesOnly: primsBoolean includeDeprecated: inclDeprecBool
	"Used by topaz (and GBS?).
  Result is a sorted SequenceableCollection  of Symbols, plus an optional string 'Omitted .. deprecated methods'.
  aString if not nil restricts the result to only include those selectors containing
  the case-insensitive substring aString .
  primsBoolean if true further restricts the result to only include only
  selectors of methods which are primitives."

	| res deprecSet numDeprecated selectors symList |
	numDeprecated := 0.
	symList := System myUserProfile symbolList.
	inclDeprecBool
		ifFalse: [ deprecSet := Object _selectorsInBaseCategory: #'Deprecated Notification' ].
	res := SortedCollection new.
	selectors := forClassSide
		ifTrue: [ self classSelectors ]
		ifFalse: [ self instanceSelectors ].
	selectors
		do: [ :sym | 
			| sel |
			(aString == nil or: [ sym includesString: aString ])
				ifTrue: [ 
					sel := sym.
					(primsBoolean or: [ deprecSet ~~ nil ])
						ifTrue: [ 
							| sourceString |
							(forClassSide
								ifTrue: [ 
									sourceString := self classSourceCodeAt: sel.
									self classForCompiles class
										_compileMethod: sourceString
										symbolList: symList ]
								ifFalse: [ 
									sourceString := self instanceSourceCodeAt: sel.
									self classForCompiles _compileMethod: sourceString symbolList: symList ])
								ifNotNil: [ :meth | 
									primsBoolean
										ifTrue: [ 
											meth _isPrimitive
												ifFalse: [ sel := nil ] ].
									sel
										ifNotNil: [ 
											deprecSet
												ifNotNil: [ 
													(meth _selectorPool * deprecSet) size ~~ 0
														ifTrue: [ 
															sel := nil.
															numDeprecated := numDeprecated + 1 ] ] ] ] ].
					sel ifNotNil: [ res add: sel ] ] ].
	numDeprecated > 0
		ifTrue: [ 
			res := Array withAll: res.
			res add: '(Omitted ' , numDeprecated asString , ' deprecated methods)' ].
	^ res
%

category: 'browser methods'
method: GsTraitImpl
_sortedClassVarNames
	^ self classForCompiles _sortedClassVarNames
%

category: 'browser methods'
method: GsTraitImpl
_topazFileoutTrait: headerStr asUtf8: utf8Bool
	| strm |
	strm := AppendStream on: String new.
	strm dynamicInstVarAt: #'utf8Bool' put: utf8Bool.
	strm nextPutAll: headerStr.
	self fileOutTraitOn: strm.
	^ utf8Bool
		ifTrue: [ strm contents encodeAsUTF8 ]
		ifFalse: [ strm contents ]
%

category: 'private'
method: GsTraitImpl
_traitCategory
	^ traitCategory
%

! Class extensions for 'Class'

!		Instance methods for 'Class'

category: 'Traits'
method: Class
addClassTrait: aClassSideTrait
	| traits |
	aClassSideTrait isClassTrait
		ifFalse: [ self error: 'addClassTrait: requires a class side trait argument'  ].
	traits := self _extraDictAt: #'classTraits'.
	traits
		ifNil: [ self _extraDictAt: #'classTraits' put: (traits := IdentitySet new) ].
	(traits includes: aClassSideTrait)
		ifFalse: [ 
			traits size = 1
				ifTrue: [ self error: 'Only one class side trait allowed per class' ].
			aClassSideTrait addDependent: self.
			traits add: aClassSideTrait ]
%

category: 'Traits'
method: Class
addInstanceAndClassTrait: anInstanceSideTrait
	"Convenience for adding both instance-side and class-side of a Trait to a Class"
	self addTrait: anInstanceSideTrait.
	self addClassTrait: anInstanceSideTrait classTrait. 
%

category: 'Traits'
method: Class
addTrait: anInstanceSideTrait
	| traits |
	anInstanceSideTrait isInstanceTrait
		ifFalse: [ self error: 'addTrait: requires an instance side trait argument'  ].
	traits := self _extraDictAt: #'traits'.
	traits ifNil: [ self _extraDictAt: #'traits' put: (traits := IdentitySet new) ].
	(traits includes: anInstanceSideTrait)
		ifFalse: [ 
			traits size = 1
				ifTrue: [ self error: 'Only one instance side trait allowed per class' ].
			anInstanceSideTrait addDependent: self.
			traits add: anInstanceSideTrait ]
%

category: 'Traits'
method: Class
classTraits
	^ (self _extraDictAt: #'classTraits') ifNil: [ #() ]
%

category: 'Traits'
method: Class
classTraits: aString
	| trait |
	trait := aString asString evaluate.
	trait isClassTrait
		ifFalse: [ 
			self
				error:
					'The expression ' , aString printString , ' must evaluate to a single class side Trait' ].
	self addClassTrait: trait
%

category: 'Traits'
method: Class
removeClassTrait: aClassSideTrait
	| traits |
	traits := self _extraDictAt: #'classTraits'.
	(traits isNil or: [ (traits includes: aClassSideTrait) not ])
		ifTrue: [ 
			self
				error:
					'The trait ' , aClassSideTrait printString , ' is not used by the receiver.' ].
	aClassSideTrait removeDependent: self.
	traits remove: aClassSideTrait
%

category: 'Traits'
method: Class
removeTrait: anInstanceSideTrait
	| traits |
	traits := self _extraDictAt: #'traits'.
	(traits isNil or: [ (traits includes: anInstanceSideTrait) not ])
		ifTrue: [ 
			self
				error:
					'The trait ' , anInstanceSideTrait printString , ' is not used by the receiver.' ].
	anInstanceSideTrait removeDependent: self.
	traits remove: anInstanceSideTrait
%

category: 'Traits'
method: Class
traits
	^ (self _extraDictAt: #'traits') ifNil: [ #() ]
%

category: 'Traits'
method: Class
traits: aString
	|  trait |
	trait := aString asString evaluate.
	trait isInstanceTrait
		ifFalse: [ 
			self
				error:
					'The expression ' , aString printString , ' must evaluate to a single instance side Trait' ].
	self addTrait: trait
%

! Class extensions for 'GsNMethod'

!		Instance methods for 'GsNMethod'

category: 'Traits'
method: GsNMethod
isFromTrait

	^self origin isTrait
%

category: 'Traits'
method: GsNMethod
origin
	"If the receiver is a trait method, answer the Trait instance that created the method.
		If the method is a loaded method, answer the Rowan loaded method instance.
		Otherwise answer the class of the method"

	^ self _origin ifNil: [ ^ self inClass ]
%

category: 'Accessing'
method: GsNMethod
_sourceStringWithLineNumbersWithOrigin
 "Return source string with lines prefixed with line numbers, followed by source origin string (Class, Trait, or Rowan).
  Used by topaz."
 | sStr  |
 sStr := self _sourceStringWithLineNumbers .
^[
	| res originString |
	res := sStr.
	(originString := self _sourceOriginString) size > 0 ifTrue:[ | lf |
		lf := Character lf .
		res := res copy .
		(res at: res size) == lf ifFalse:[ res add: lf ].
		res add: originString .
	      ].
	res ] onException: Error do: [:ex |  sStr ].
%

category: 'Accessing'
method: GsNMethod
_sourceStringWithOrigin
 "Return source string with method origin appended ... A method origin may be a Class (no display), a Trait, or a Rowan loaded method."

  | sStr |
  sStr := self sourceString .
  ^ [ | res flStr |
      res := sStr .
      (flStr := self _sourceOriginString) size > 0 ifTrue:[ | lf |
	lf := Character lf .
	res := res copy .
	(res at: res size) == lf ifFalse:[ res add: lf ].
	res add: flStr .
      ].
      res
    ] onException: Error do:[:ex | sStr ]
%

! Class extensions for 'Object'

!		Instance methods for 'Object'

category: 'Testing'
method: Object
isTrait
 "Returns true if the receiver is a Trait.."

  ^ false
%

! Class extensions for 'SymbolDictionary'

!		Class methods for 'SymbolDictionary'

category: 'Browser Methods'
classmethod: SymbolDictionary
_listTraitsIn: dictArg matching: aString

"Returns a String containing names of traits, one per line; or false.
 If dictArg == nil, list the whole symbolList .
 If aString ~~ nil, limit result to those traits for which
    (aTrait name includesString: aString)==true .
 If aDict is not a kind of SymbolDictionary, returns false.
 Used by Topaz."
| list result |
dictArg  ifNil:[ list := GsSession currentSession symbolList ]
      ifNotNil:[ (dictArg isKindOf: self ) ifFalse:[ ^ false ].
                 list := { dictArg } ].
result := String new .
list do:[:aDict | | aSet sortedNames |
  aSet := SymbolSet new .
  aDict associationsDo:[:assoc |
    (assoc _value isTrait) ifTrue:[ aSet add: assoc key ].
  ].
  aString ifNil:[
    aSet size > 0 ifTrue:[
      result size > 0 ifTrue:[ result lf ].
      result addAll: 'dictionary ' ;
             addAll: (aDict name ifNil:[ '(unnamed)' ]); lf .
    ].
  ] ifNotNil:[
    aSet := aSet select:[:n | n includesString: aString]
  ].
  sortedNames := SortedCollection withAll: aSet .
  1 to: sortedNames size do:[:j |
    result add:'  '; addAll: (sortedNames at: j); lf .
  ].
].
^ result
%

