! Copyright (C) GemTalk Systems 1986-2026.  All Rights Reserved.
! Class Declarations
! Generated file, do not Edit

doit
(DateAndTime
	_newKernelSubclass:'SmallDateAndTime'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesInvariant' #'selfCanBeSpecial' #'subclassesDisallowed'  #logCreation )
	reservedOop: 159489
)
		category: nil;
		comment: 'A SmallDateAndTime is a DateAndTime whose offset in hours is in the range -16..15
 and whose time is in the range 2001 to 2072 .
 The resolution is 1 microsecond.

The bit format of an instance is
   tttttttt|tttttttt|tttttttt|tttttttt|tttttttt|tttttttt|tttooooo|00111100
     bits o   5 bits signed  offset  from UTC in hours
     bits t  51 bits unsigned time since 2001 in units of microseconds

SmallDateAndTime has special implementation this it has no instance variables.
It does not inherit the instance variable definitions of DateAndTime .
';
		immediateInvariant.
true.
%

doit
(GsTsExternalSession
	subclass: 'GsTsX509ExternalSession'
	instVarNames: #(username)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'X509';
		comment: 'GsTsX509ExternalSession is a variant of GsTsExternalSession which uses an 
X509 certificate as login credentials rather than a user id and password.

Example:

| p s |
p := GemStoneX509Parameters
      newFromPemFilesWithNetldiPort: ''54321''
      netldiHost: ''localhost''
      certificate: ''DataCurator.chain.pem''
      caCertificate: ''stoneCA-gs64stone.cert.pem''
      privateKey: ''DataCurator.privkey.pem'' .
s := GsTsX509ExternalSession newWithX509Parameters: p.
s login .

';
		immediateInvariant.
true.
%

removeallmethods GsTsX509ExternalSession
removeallclassmethods GsTsX509ExternalSession

doit
(nil
	_newKernelSubclass:'Object'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'selfCanBeSpecial'  #logCreation )
	reservedOop: 72193
)
		category: nil;
		comment: 'Object defines the basic protocol for all objects.  Every object is an
instance of Object or of some subclass of Object.';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelIndexableSubclass:'AbstractException'
	instVarNames: #(gsResumable gsTrappable gsNumber currGsHandler gsStack gsReason gsDetails tag messageText gsArgs)
	classVars: #(ErrnoTables ERR_AbstractException ERR_Admonition ERR_AlmostOutOfMemory ERR_AlmostOutOfStack ERR_ArgumentError ERR_ArgumentTypeError ERR_AwsError ERR_AzureError ERR_Break ERR_Breakpoint ERR_CannotReturn ERR_ClientForwarderSend ERR_CompileError ERR_CompileWarning ERR_ControlInterrupt ERR_CryptoError ERR_Deprecated ERR_DirectoryDoesNotExist ERR_DirectoryExists ERR_DirectoryIsNotEmpty ERR_DirectoryRequired ERR_EndOfStream ERR_Error ERR_Exception ERR_ExitClientError ERR_ExternalError ERR_FileAlreadyExistsException ERR_FileAttributeNotSupported ERR_FileDoesNotExistException ERR_FileException ERR_FileExists ERR_FilePermissionDenied ERR_FileRequired ERR_FileSystemError ERR_FloatingPointError ERR_FloatingPointException ERR_FsEACCES ERR_FsEBADF ERR_FsEEXIST ERR_FsEINTR ERR_FsEINVAL ERR_FsENOENT ERR_FsENOMEM ERR_FsENOSPC ERR_FsENOTDIR ERR_FsEROFS ERR_FsError ERR_FsFileDescriptorInvalid ERR_FsUnixError ERR_GciTransportError ERR_GsUnsatisfiableQueryNotification ERR_Halt ERR_ImproperOperation ERR_IndexingErrorPreventingCommit ERR_InternalError ERR_InterSessionSignal ERR_IOError ERR_LargeIntegerOverflow ERR_LockError ERR_LookupError ERR_MessageNotUnderstood ERR_MigrationError ERR_NameError ERR_Notification ERR_NumericError ERR_ObjectsCommittedNotification ERR_OffsetError ERR_OutOfRange ERR_PostgresError ERR_RegexpError ERR_RepositoryError ERR_RepositoryViewLost ERR_ResumableTestFailure ERR_RubyBreakException ERR_RubyThrowException ERR_SecureSocketError ERR_SecurityError ERR_SignalBufferFull ERR_SocketError ERR_SshSocketError ERR_SystemCallError ERR_TerminateProcess ERR_TestFailure ERR_ThreadError ERR_TIMEOUT_INTERRUPT ERR_TransactionBacklog ERR_TransactionError ERR_UncontinuableError ERR_UserDefinedError ERR_Warning ERR_ZeroDivide ERR_ZnCharacterEncodingError ERR_ZnError)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'disallowGciStore'  #logCreation )
	reservedOop: 130305
)
		category: nil;
		comment: '
 AbstractException describes the behavior of class objects that are used to
 create, signal, and select exceptions that exist within a specialization
 hierarchy.

 Beginning with Gemstone64 v3.0,  ANSI and legacy Gemstone
 exception behavior are unified.  The class ExceptionA no longer exists.

 The instance protocol describes the behavior of instances of class AbstractException.
 Typically, actual exceptions used by an application will be either
 direct or indirect subclasses of this class.

 New trappable exception classes should be created as subclasses of Error,
 not of AbstractException.

 Note that instances created within the VM are initialized by VM code, and
 do not execute the initialize methods in the image.  Initializer methods
 in the image are only executed for those instances created by sending
 some sort of signal: or error: message within Smalltalk code.

 The instVar   gsTrappable   has these values
    0 - not trappable by any form of on:do: in Smalltalk code, signalled direct to GCI
    false - signalled via direct send of #defaultAction  .
    true  - trappable
    1       trappable except by onSynchronous:do:  ; exception was
            generated asynchrously (usually a ControlInterrupt)

 The instVar gsDetails holds the ANSI message text, if any.
 The instVar messageText holds the full GemStone error text .

 The exception class hierarchy follows, inst var names in parentheses.
 Unless noted, the default for all classes is
   gsResumable==true, gsTrappable==true .
 If an exception was signaled from within C code of a primtive,
 the instance will have gsResumable==false.

  AbstractException (gsResumable gsTrappable gsNumber
                  currGsHandler gsStack gsReason gsDetails tag messageText args)
    Exception     --Highest class that customer Smalltalk code
                                should ever handle, ANSI Global--
      ControlInterrupt
        Break     -- from GciSoftBreak, ctl-C, etc
        Breakpoint (context stepPoint)
        ClientForwarderSend ([args=arguments] receiver clientObj selector)
        Halt    [gsTrappable==false]
      Error
        CompileError
        EndOfStream
        ExternalError         -- Error from OS
          AwsError
          AzureError
          IOError
            SocketError
              SecureSocketError
              SshSocketError
          SystemCallError  (errno)
	  CryptoError -- Error from OpenSSL crypto library
          PostgresError -- Error from Postgres
        ImproperOperation [ args = object ]  -- Disallowed under the circumstances
          ArgumentError   -- Arg never appropriate for this message
          ArgumentTypeError ( expectedClass actualArg)  -- Class of arg
                                        never acceptable here
          CannotReturn        -- Non-local return attempt
          LookupError  (key) -- A lookup failed (or succeeded) improperly
          OffsetError (maximum actual) -- Array or String at:, at:put: out of bounds
          OutOfRange (minimum maximum actual) -- Numeric range error, or wrong num args
            FloatingPointError
          RegexpError
        IndexingErrorPreventingCommit
        InternalError         -- something that should never happen
          GciTransportError   -- Protocol or other error specific to GCI RPC link
        LockError [ args = object ]
        MigrationError
        NameError (selector)  -- used in Ruby
          MessageNotUnderstood ([args=arguments] envId receiver )  --ANSI Global
        NumericError [ args = object ]
          ZeroDivide  (dividend)       --ANSI Global
        RepositoryError
        SecurityError
        SignalBufferFull
	ThreadError
        TransactionError
        UncontinuableError
        UserDefinedError
      Notification     --ANSI Global
        Admonition
          AlmostOutOfStack [gsTrappable, gsResumable both false if in red zone]
          AlmostOutOfMemory
          RepositoryViewLost
        Deprecated
        FloatingPointException
        InterSessionSignal (sendingSession signal [args = message] )
        ObjectsCommittedNotification
        TerminateProcess
        TransactionBacklog (inTransaction)
        Warning      --ANSI Global
          CompileWarning
      TestFailure
    RubyBreakException  -- used in implementation of Ruby
    RubyThrowException ([args=name] value signalNum) -- used in implementation of Ruby

  See comments for primitive 33 , AbstractException >> defaultAction for
  how instVars of an exception are enumerated in to a GciErrSType.args.

Trappability of errors signaled from with VM

  OBJ_ERR_DOES_NOT_EXIST, OBJ_ERR_CORRUPT_OBJ not trappable in a slow-build vm
  RT_ERR_OBJ_IS_NP  not trappable if TrapAddToClosure enabled

  following signaled from C as not trappable
    RT_ERR_STACK_LIMIT_RED
    GCI_ERR_EXEC_CLIENT_USERACT
    RT_ERR_HARD_BREAK
    RT_ERR_STEP
    RT_ERR_CODE_BREAKPOINT
    RT_ERR_STACK_BREAKPOINT
    RT_ERR_SOFT_BREAK
    RT_ERR_PAUSE

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(AbstractException
	_newKernelSubclass:'Exception'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 137729
)
		category: nil;
		comment: '
Exception is the top-level ANSI class in the exception framework. It is
an abstract class that includes Error and Notification as its subclasses.
It would generally not be appropriate to signal or catch an Exception.
In GemStone/S, Exception is a subclass of AbstractException so that some
common code can be shared with the Ruby implementation.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(Exception
	_newKernelSubclass:'ControlInterrupt'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 132865
)
		category: nil;
		comment: '
ControlInterrupt is the abstract superclass for various exceptions that
generally pass control from the server to the GCI client.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(ControlInterrupt
	_newKernelSubclass:'Break'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 147713
)
		category: nil;
		comment: '
Break is a ControlInterrupt that is generated by the virtual machine based on
a Gci*Break() from the client. In Topaz, this will be generated by <Ctrl>+<C>

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object';
		immediateInvariant.
true.
%

doit
(ControlInterrupt
	_newKernelSubclass:'Breakpoint'
	instVarNames: #(context stepPoint)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 147969
)
		category: nil;
		comment: '
Breakpoint is a ControlInterrupt generated by the virtual machine based on
a debugging event, such as GsNMethod>>#setBreakAtStepPoint: or a
GsProcess>>#_step* call.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
	context: GsProcess
	stepPoint: SmallInteger
';
		immediateInvariant.
true.
%

doit
(ControlInterrupt
	_newKernelSubclass:'ClientForwarderSend'
	instVarNames: #(receiver clientObj selector)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 148225
)
		category: nil;
		comment: '
ClientForwarderSend is ControlInterrupt generated by the implementation of
#doesNotUnderstand:* in ClientForwarder. Generally this Exception would not
be signaled or caught explicitly in GemStone Smalltalk code but would be
caught in the GCI client (typically GBS) and after being handled appropriately
the GCI client would resume with some return value. This effectively allows
message sends from the server to the client.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
	receiver: Object
	clientObj: Symbol
	selector: Symbol
';
		immediateInvariant.
true.
%

doit
(ControlInterrupt
	_newKernelSubclass:'Halt'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 133121
)
		category: nil;
		comment: '
Halt is a ControlInterrupt signaled in Object>>#halt, #halt:, and #pause.
It is typically not caught on the server and is sent to the GCI client
to be handled by a debugger (typically GBS or Topaz).

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(ControlInterrupt
	_newKernelSubclass:'TerminateProcess'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 151809
)
		category: nil;
		comment: '
If a non-forked process is terminated, then after the process
termination is completed a TerminateProcess error will be
signaled and sent to the GCI. This Error is not-trappable.
You can see the error by evaluating the following expression:
	Processor activeProcess terminate.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(Exception
	_newKernelSubclass:'Error'
	instVarNames: #()
	classVars: #(GS_ERR_SIGTERM)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 130817
)
		category: nil;
		comment: '
Error is an Exception that is the superclass for a variety of errors.
It is typically used as the selector for the Exec*Block>>#on:do: method.
While an Error can be signaled directly, it is more common to see
UserDefinedError signaled from the Object>>#error: method.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(Error
	_newKernelSubclass:'AlmostOutOfMemoryError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 160513
)
		category: nil;
		comment: 'AlmostOutOfMemoryError means the virtual machine''s
temporary object space is nearly exhausted. 
It is similar in semantics to AlmostOutOfMemory (which is a Notification).

Signalling of AlmostOutOfMemoryError is disabled by default.
To enable it, you must execute
   AlmostOutOfMemoryError enable .
After it is signalled, it  must be explicitly reenabled before another
instance will be signalled.  Reenabling should usually be done after
taking action to allow in-memory garbage collection to free some objects,
or after raising the threshold.

Primtives which may consume a lot of temp obj memory such as 
  String >> copy 
  String >> addAll: 
  String >> , 
will signal a non-resumable AlmostOutOfMemoryError if the operation 
cannot be completed without causing a fatal out of memory error 4067.
This signalling will occur without regard to the states of 
  AlmostOutOfMemoryError class >> enabled 
  AlmostOutOfMemoryError class >> threshold 
';
		immediateInvariant.
true.
%

doit
(Error
	_newKernelSubclass:'AlmostOutOfStackError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 160257
)
		category: nil;
		comment: ' 
AlmostOutOfStackError is signalled when the current GsProcess is about
to run out of stack space.  
It is an Error in contrast to AlmostOutOfStack which is a Notification.
AlmostOutOfStackError must be explicitly enabled ; if enabled then
AlmostOutOfStackError will be signalled instead of a AlmostOutOfStack.
';
		immediateInvariant.
true.
%

doit
(Error
	_newKernelSubclass:'CompileError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 132097
)
		category: nil;
		comment: '
CompileError is an Error generated by the virtual machine when a
syntax error is found during a method compile. The method #errorDetails
will return an Array of Array instances, one for each compile error.
Each compile error has the following details:
	(1) an Integer error number;
	(2) an Integer offset into the source string; and
	(3) a String describing the error.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(Error
	_newKernelSubclass:'EndOfStream'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 148481
)
		category: nil;
		comment: '
The EndOfStream Error is generated when an attempt is made to read
beyond the end of a legacy stream. For example:
	(ReadStreamLegacy on: String new) next.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(Error
	_newKernelSubclass:'ExternalError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 148737
)
		category: nil;
		comment: '
ExternalError is an abstract superclass for errors that happen during
a call to some non-Smalltalk code, such as the file system or a socket.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(ExternalError
	_newKernelSubclass:'CryptoError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 158721
)
		category: nil;
		comment: '
An exception signaled when certain encrypt/decrypt methods fail.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(ExternalError
	_newKernelSubclass:'IOError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 139265
)
		category: nil;
		comment: '
IOError is an ExternalError signaled by the virtual machine when certain
operating system calls fail. Typically, it represents a problem with some
file operation.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(IOError
	_newKernelSubclass:'SocketError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 142337
)
		category: nil;
		comment: '
Most GsSocket methods that fail will return nil (or false; see #connectTo:)
and the caller is then expected to call one of the #lastError* methods.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(SocketError
	_newKernelSubclass:'SecureSocketError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 158209
)
		category: nil;
		comment: '
An exception signaled when certain GsSecureSocket methods fail.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(SocketError
	subclass: 'SshSocketError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: '
An exception signaled when certain GsSshSocket methods fail.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

removeallmethods SshSocketError
removeallclassmethods SshSocketError

doit
(ExternalError
	subclass: 'PostgresError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: '
An exception signaled when Postgres operations fail.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(ExternalError
	_newKernelSubclass:'SystemCallError'
	instVarNames: #(errno)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 141057
)
		category: nil;
		comment: '
SystemCallError is signaled when an external system call fails.
At present, it is primarily used by Ruby.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
	errno: SmallInteger
';
		immediateInvariant.
true.
%

doit
(Error
	_newKernelSubclass:'ImproperOperation'
	instVarNames: #(object)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 142593
)
		category: nil;
		comment: '
ImproperOperation is a superclass for a variety of Smalltalk coding
errors, such as passing an invalid or out of range argument to a method.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
	object: Object
';
		immediateInvariant.
true.
%

doit
(ImproperOperation
	_newKernelSubclass:'ArgumentError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 139009
)
		category: nil;
		comment: '
ArgumentError identifies a situation in which an argument to a method is invalid.
The type of the argument may be valid (else it would be an ArgumentTypeError)
but there is something else incorrect about an argument.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
	object: Object
';
		immediateInvariant.
true.
%

doit
(ImproperOperation
	_newKernelSubclass:'ArgumentTypeError'
	instVarNames: #(expectedClass actualArg)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 141569
)
		category: nil;
		comment: '
ArgumentTypeError identifies a situation in which an argument to a method
is the wrong type (or class). For example, an Interval must be initialize
to have instances of Number as the start, stop, and step.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
	object: Object
	expectedClass: Behavior
	actualArg: Behavior
';
		immediateInvariant.
true.
%

doit
(ImproperOperation
	_newKernelSubclass:'CannotReturn'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 142081
)
		category: nil;
		comment: '
CannotReturn is an ImproperOperation generated by the virtual machine
when a return is attempted from a block that is no longer on the stack.
If a method returns a block, then that block should not have an explicit
return in it.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
	object: Object
';
		immediateInvariant.
true.
%

doit
(ImproperOperation
	_newKernelSubclass:'LookupError'
	instVarNames: #(key)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 132353
)
		category: nil;
		comment: '
LookupError is an ImproperOperation that is signaled when a lookup is
made and not found. The key instance variable holds the missing key.
For example, evaluate the following code:
	[Dictionary new at: 42] on: LookupError do: [:ex | ex halt].

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
	object: Object
	key: Object
';
		immediateInvariant.
true.
%

doit
(ImproperOperation
	_newKernelSubclass:'OffsetError'
	instVarNames: #(maximum actual)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 139777
)
		category: nil;
		comment: '
OffsetError is an ImproperOperation signaled when an invalid offset
is used to attempt a lookup. For example:
	[Array new at: 2] on: OffsetError do: [:ex | ex halt].

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
	object: Object
	maximum: SmallInteger
	actual: SmallInteger
';
		immediateInvariant.
true.
%

doit
(ImproperOperation
	_newKernelSubclass:'OutOfRange'
	instVarNames: #(minimum maximum actual)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 140033
)
		category: nil;
		comment: '
OutOfRange is signaled for various conditions when an invalid argument
is passed to a method. For example:
	[ScaledDecimal with: 42 scale: -2] on: OutOfRange do: [:ex | ex halt].

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
	object: Object
	minimum: Object
	maximum: Object
	actual: Object
';
		immediateInvariant.
true.
%

doit
(OutOfRange
	_newKernelSubclass:'FloatingPointError'
	instVarNames: #()
	classVars: #(divideByZero inexactResult invalidOperation overflow underflow)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 140289
)
		category: nil;
		comment: '
FloatingPointError is signaled for various error conditions during
numerical operations.  By default floating point operations are silent
and return a NaN or Infinity in some cases.

After
  FloatingPointError enableExceptions: #divideByZero
a floating point divide by zero will signal an instance of FloatingPointError.
Note that a divide by integer zero will always signal an instance of ZeroDivide.

FloatingPointError enableAllExceptions
will cause a FloatingPointError to be signaled whenever a floating point
arithmetic operation would produce a NaN an Infinity as the result.

See documentation in FloatingPointError class >> enabledExceptions
for the list of floating point exception conditions which can
signal a FloatingPointError .

Some operations that do not involve floating point numbers can
signal a FloatingPointError, such as LargeInteger overflow.
For example, evaluate the following expression:
	[10 raisedTo: 100000] on: FloatingPointError do: [:ex | ex halt].
Since there is no appropriate exceptional number to return, these exceptions
are not managed by exception enabling and are always signaled.
';
		immediateInvariant.
true.
%

doit
(ImproperOperation
	_newKernelSubclass:'RegexpError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #'noInheritOptions'  #logCreation )
	reservedOop: 140545
)
		category: nil;
		immediateInvariant.
true.
%

removeallmethods RegexpError
removeallclassmethods RegexpError

doit
(Error
	_newKernelSubclass:'IndexingErrorPreventingCommit'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 148993
)
		category: nil;
		comment: '
IndexingErrorPreventingCommit is signaled when an error occurs during
an indexing operation and the internal indexing structures are in an
inconsistent state. The virtual machine will prevent a commit so as to
preserve the correctness of the indexing structures.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(Error
	_newKernelSubclass:'InternalError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 131841
)
		category: nil;
		comment: '
An InternalError indicates that an error was detected in the core
GemStone/S code. Typically this does not represent an application
error and the appropriate action is probably to file a help request
with support.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(InternalError
	_newKernelSubclass:'GciTransportError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 149249
)
		category: nil;
		comment: '
GciTransportError is an InternalError generated by the virtual machine
when it receives invalid data from the GCI client. The most likely cause
of this error is some sort of network problem between the client and the
server. Otherwise, it suggests that there is a problem with GemStone/S
and opening a help request with support may be appropriate.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(Error
	_newKernelSubclass:'LockError'
	instVarNames: #(object)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 149505
)
		category: nil;
		comment: '
A LockError is signaled when an attempt to get a read lock or a write lock
on an object fails. Calls to System class>>#readLock: or #writeLock: should
be coded to handle this Error.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
	object: Object
';
		immediateInvariant.
true.
%

doit
(Error
	_newKernelSubclass:'MigrationError'
	instVarNames: #(object)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 158977
)
		category: nil;
		comment: '
An exception signaled when an object cannot be migrated from
being an instance of a class to an instance of some other class.
  Instance variables
     object - the object for which migration failed
';
		immediateInvariant.
true.
%

doit
(Error
	_newKernelSubclass:'NameError'
	instVarNames: #(selector)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 131585
)
		category: nil;
		comment: '
NameError is the superclass for MessageNotUnderstood. It is signaled in Ruby
when code attempts to reference an instance variable by name but the name
does not exist. NameError is not used in Smalltalk.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
	selector: String
';
		immediateInvariant.
true.
%

doit
(NameError
	_newKernelSubclass:'MessageNotUnderstood'
	instVarNames: #(envId receiver)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 131073
)
		category: nil;
		comment: 'The class protocol describe the behavior of the value of the global
named MessageNotUnderstood.

This object is used to as an exception selector to catch failed message
sends. Message not understood exceptions are resumable so any message
in this protocol that signal such an exception may ultimately return
to their sender.

This object is not specified as an <exceptionSignaler> or an
<exceptionInstantiator>. It as assumed that message not understood
exceptions are signaled by the implemention dependent implementaton
of the message <Object> #doesNotUnderstand:.

The instance protocol describes the behavior of exceptions that are
signalled if the receiver of a message does not have a method with a
matching selector.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
	selector: String
	envId: SmallInteger
	receiver: Object';
		immediateInvariant.
true.
%

doit
(Error
	_newKernelSubclass:'NumericError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 149761
)
		category: nil;
		comment: '
NumericError is an abstract superclass for ZeroDivide.
It is not used in Smalltalk.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(NumericError
	_newKernelSubclass:'ZeroDivide'
	instVarNames: #(dividend)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 131329
)
		category: nil;
		comment: 'An instances of ZeroDivide is signalled when a division by zero
occurs,  and the division is not a floating point division.
See FloatingPointError for floating point divide by zero semantics.
Zero divide exceptions are resumable so any message in this
protocol that signal such an exception may ultimately return to their
sender. ';
		immediateInvariant.
true.
%

doit
(Error
	_newKernelSubclass:'RepositoryError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 150017
)
		category: nil;
		comment: '
RepositoryError is signaled by the virtual machine for various
repository-related problems. Some of these are programming errors
(such as an attempt to create more than the allowed number of
extents) and some are I/O errors (such as disk full or disk error).

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(Error
	_newKernelSubclass:'SecurityError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 140801
)
		category: nil;
		comment: '
SecurityError is signaled by the system for various errors where an
action is attempted without proper security. For example:
	[System myUserProfile oldPassword: ''foo'' newPassword: ''bar'']
		on: SecurityError
		do: [:ex | ex halt].

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(Error
	_newKernelSubclass:'SignalBufferFull'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 152833
)
		category: nil;
		comment: '
SignalBufferFull is sent by the virtual machine when a sessions signal
buffer is full. For example:
	1 to: 1000 do: [:i |
		System sendSignal: i to: System session withMessage: String new.
	].

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(Error
	_newKernelSubclass:'ThreadError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 141313
)
		category: nil;
		comment: '
ThreadError is signaled when certain scheduling errors occur, including
not having a process to run. For example:
	[Semaphore new wait] on: ThreadError do: [:ex | ex halt].

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(Error
	_newKernelSubclass:'TransactionError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 150273
)
		category: nil;
		comment: '
TransactionError is signaled in a variety of situations where the session
is in an invalid transaction state for the operation attempted. For example,
Repository>>#listInstances: will fail if there are modification to persistent
objects in the current view. To see a TransactionError, evaluate the following:
	UserGlobals at: #foo put: 42.
	[SystemRepository listInstances: (Array with: Array)]
		on: TransactionError
		do: [:ex | ex halt].

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(Error
	_newKernelSubclass:'UncontinuableError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 150529
)
		category: nil;
		comment: '
UncontinuableError is signaled when an attempt is made to continue
execution after a handler from which continuing execution is not allowed.
For example, it is generally fine to return from a dynamic (stack-based)
handler:
	[2 / 0] on: ZeroDivide do: [:ex | ex return: 3].
On the other hand, it is not permitted to return from a default (static)
handler:
	ZeroDivide addDefaultHandler: [:ex | ex return: 3].
	[2 / 0] on: UncontinuableError do: [:ex | ex halt].

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(Error
	_newKernelSubclass:'UserDefinedError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 132609
)
		category: nil;
		comment: '
UserDefinedError is signaled by Object>>#error: and related methods.
It would be better for applications to create an explicit subclass
of Error that describes the actual error.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(Exception
	_newKernelSubclass:'Notification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 133377
)
		category: nil;
		comment: '
According to ANSI Smalltalk, Notification is "used to represent exceptional
conditions that may occur but which are not considered errors. Actual notification
exceptions used by an application may be subclasses of this class."

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(Notification
	_newKernelSubclass:'Admonition'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 150785
)
		category: nil;
		comment: '
An Admonition is a type of Notification that it would be best not to ignore.
While not strictly an Error, it generally indicate that an error is imminent.
For example, AlmostOutOfMemory is an Admonition.

If one has established a generic Error handler, it might be appropriate to
add Admonition to it since the result of an ignored Admonition might make it
impossible to handle the resulting Error. For example:

	[self doSomething] on: Error, Admonition do: [:ex | self recordError: ex].

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(Admonition
	_newKernelSubclass:'AlmostOutOfMemory'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 138753
)
		category: nil;
		comment: '
AlmostOutOfMemory is an Admonition (Notification) that the virtual machine''s
temporary object space is nearly exhausted. Because this can happen in any
process, it may be useful to set up a default handler for this situation.

It is enabled by default at login, with threshold 90% .
However you must install a handler for AlmostOutOfMemory to take action
or execute
    Notification enableSignalling
to have AlmostOutOfMemory and other Notifications signalled to the
application to avoid having AlmostOutOfMemory silently ignored.

After it is signalled, it  must be explicitly reenabled before another
notification will be delivered.  Reenabling should usually be done after
taking action to allow in-memory garbage collection to free some objects,
or after raising the threshold.
See AbstractException class>>#addDefaultHandler:.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(Admonition
	_newKernelSubclass:'AlmostOutOfStack'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 141825
)
		category: nil;
		comment: '
AlmostOutOfStack is an Admonition (Notification) that the current GsProcess is about
to run out of stack space. The typical handler will log a copy of the stack
(see GsProcess class>>#stackReportToLevel:) and then unwind the stack.

AlmostOutOfStack is signalled from the VM via AbstractException >> _signalFromPrimitive,
thus if Notification >> defaultAction  silently returns,
the AlmostOutOfStack  will still be signalled to the debugger or the GCI client.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(Admonition
	_newKernelSubclass:'RepositoryViewLost'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 139521
)
		category: nil;
		comment: '
RepositoryViewLost is an Admonition signaled by the virtual machine if
the session is not in an transaction and fails to respond to a
TransactionBacklog notification within a specified time. The appropriate
action to take is to abort or begin a transaction to get a new view.

TransactionBacklog represents a ''sigAbort'' which was sent to the session
by stone.

RepositoryViewLost represents a ''lostOt'' sent to the session by stone.
When the ''lostOt'' is received, the VM executes the equivalent of
System abortTransaction, and then signals the RepositoryViewLost .

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(Notification
	_newKernelSubclass:'FloatingPointException'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 151297
)
		category: nil;
		comment: '
FloatingPointException might be used some time in the future
with hardware floating point operations.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(Notification
	subclass: 'GcFinalizeNotification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: nil;
		comment: 'GcFinalizeNotification is private to the VM and 
is used to implement finalization of ephemonons .

To have finalization execute in a specific GsProcess, see
GsSignalingSocket class >> newForAsyncExceptions: 
and GsSignalingSocket >> readNotification .
Otherwise,  GcFinalizeNotification >> _signalGcFinalize:
will be executed as needed by the VM .';
		immediateInvariant.
true.
%

removeallmethods GcFinalizeNotification
removeallclassmethods GcFinalizeNotification

doit
(Notification
	_newKernelSubclass:'InterSessionSignal'
	instVarNames: #(sendingSession signal)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 153089
)
		category: nil;
		comment: '
InterSessionSignal is a Notification generated by the virtual machine
when another VM sends a signal to the session.
For example
    InterSessionSignal addDefaultHandler: [:ex | ex halt] ;
              enableSignalling ;
              sendSignal: 0 to: System session withMessage: ''hello!''.
    (Delay forSeconds: 1) wait.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
	sendingSession: SmallInteger
	signal: SmallInteger
';
		immediateInvariant.
true.
%

doit
(Notification
	_newKernelSubclass:'ObjectsCommittedNotification'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 151553
)
		category: nil;
		comment: '
ObjectsCommittedNotification is signaled by the virtual machine when an
object in your notify set has been modified. For example:
	| assoc |
	UserGlobals at: #temp put: (assoc := Association new).
	System commitTransaction; enableSignaledObjectsError; addToNotifySet: assoc.
	ObjectsCommittedNotification addDefaultHandler: [:ex | ex halt].
	assoc key: 42.
	System commitTransaction.
	(Delay forSeconds: 1) wait.

  For notify set management see 
     System class >> addAllToNotifySet:
     System class >> addToNotifySet:
     System class >> clearNotifySet
     System class >> notifySet
     System class >> removeAllFromNotifySet:
     System class >> removeFromNotifySet:

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

doit
(Notification
	_newKernelSubclass:'TransactionBacklog'
	instVarNames: #(inTransaction)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 152065
)
		category: nil;
		comment: '
TransactionBacklog is a Notification that your session is holding an
old commit record and this is a request to do an abort or commit (as
appropriate). You will only get this Notification if you have enabled
it (see System class>>#enableSignaledAbortError and
#enableSignaledFinishTransactionError).
TransactionBacklog represents a ''sigAbort'' which was sent to the session.
RepositoryViewLost which represents a ''lostOt'' is a separate
subclass of Notification.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
	inTransaction: Boolean
';
		immediateInvariant.
true.
%

doit
(Notification
	_newKernelSubclass:'Warning'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 152321
)
		category: nil;
		comment: 'Instances of Warning implement the ANSI protocol <Warning>.

 Warning is used to represent exceptional conditions that
 might occur that are not considered errors but which should be
 reported to the user. Typically, the actual warning exceptions
 used by an application will be subclasses of this class.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object';
		immediateInvariant.
true.
%

doit
(AbstractException
	_newKernelSubclass:'RubyBreakException'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #'noInheritOptions'  #logCreation )
	reservedOop: 142849
)
		category: nil;
		comment: '
RubyBreakException is used in Ruby and is not used in Smalltalk.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
';
		immediateInvariant.
true.
%

removeallmethods RubyBreakException
removeallclassmethods RubyBreakException

doit
(AbstractException
	_newKernelSubclass:'RubyThrowException'
	instVarNames: #(value signalNum)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #'noInheritOptions'  #logCreation )
	reservedOop: 147457
)
		category: nil;
		comment: '
RubyThrowException is used in Ruby and is not used in Smalltalk.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
	value: Object
	signalNum: SmallInteger
';
		immediateInvariant.
true.
%

removeallmethods RubyThrowException
removeallclassmethods RubyThrowException

doit
(Object
	_newKernelSubclass:'AbstractSession'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 105217
)
		category: nil;
		comment: 'AbstractSession is an abstract class for describing within GemStone sessions
 that exist either in GemStone or in some other server software.  It is
 intended to provide support in GemStone for two-phase commit protocols between
 transactions in related sessions.

 For example, a session external to GemStone could be a session in an external
 database.  It could be spawned by the current GemStone session.  The GemStone
 session object permits access to its symbol list for name resolution within its
 name space, enables execution of Smalltalk code within the session, and allows
 control of its transaction state.';
		immediateInvariant.
true.
%

doit
(AbstractSession
	_newKernelSubclass:'GsSession'
	instVarNames: #(sessionSerialNum userProfile)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 103681
)
		category: nil;
		comment: 'A GsSession represents a user session on the GemStone server where the
 instance exists.  It is a transient object that is useful only as long
 as the user remains logged in to GemStone.

 A GsSession can access the UserProfile of the user who is logged in to
 GemStone, can provide some minimal control over session execution, and
 can send and receive signals with other sessions.

 The current session is represented by a GsCurrentSession, a special
 subclass of GsSession.  Instances of GsSession typically represent
 other concurrent GemStone sessions in the same server.

Constraints:
	sessionSerialNum: SmallInteger
	userProfile: UserProfile

instVar sessionSerialNum -- A SmallInteger that identifies the session uniquely within the GemStone
 server.

instVar userProfile -- The UserProfile of the user who is logged in to the session.';
		immediateInvariant.
true.
%

doit
(GsSession
	_newKernelSubclass:'GsCurrentSession'
	instVarNames: #(symbolList nativeLanguage transientSymbolList)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'subclassesDisallowed'  #logCreation )
	reservedOop: 103937
)
		category: nil;
		comment: 'GsCurrentSession provides a public interface to the current GemStone session.
 There is only one instance of GsCurrentSession in each GemStone session.
 The GemStone server creates it automatically when a user logs into GemStone.
 The instance is transient and cannot be accessed after the user logs out of
 GemStone.

Instance variable types:
	sessionSerialNum: SmallInteger
	userProfile: UserProfile
	symbolList: SymbolList
	nativeLanguage: String (obsolete)

 The instVar symbolList is initalized at session login to reference
 the symbolList of the current user''s UserProfile. 

 The instVar transientSymbolList, if non-nil, takes precedence over symbolList
 for use in resolving symbols.  transientSymbolList is nil unless one of
    GsCurrentSession >> transientSymbolList
    GsCurrentSession >> transientSymbolList:  
    System class >> refreshTransientSymbolList
 have been executed. Use GsCurrentSession >> _transientSymbolList for direct
 access to the instVar.';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelSubclass:'Activation'
	instVarNames: #(aStackSegment CSIndex)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #'subclassesDisallowed'  #logCreation )
	reservedOop: 83713
)
		category: nil;
		comment: 'The class Activation is obsolete as of GemStone version 5.0 and will be removed
in a future release.';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelSubclass:'Association'
	instVarNames: #(key value)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 67073
)
		category: nil;
		comment: 'An Association is a pair of associated objects: a key and a value.  A
 Dictionary is a collection of Associations; thus, much of the protocol that
 affects Associations is actually defined for instances of Dictionary.  See the
 description of Dictionary for details.
--- instVar key
An object, usually used as a reference to its value.
--- instVar value
Another object, referenced by its key.
';
		immediateInvariant.
true.
%

doit
(Association
	_newKernelSubclass:'ObsoleteSymbolAssociation'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #logCreation )
	reservedOop: 75265
)
		category: nil;
		comment: 'The class ObsoleteSymbolAssociation is obsolete as of GemStone version 5.0 and
will be removed in a future release.

Existing instances should be migrated to SymbolAssociation or otherwise
processed as required, and then should be removed.';
		immediateInvariant.
true.
%

doit
(Association
	_newKernelSubclass:'SymbolAssociation'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 111617
)
		category: nil;
		comment: 'A SymbolAssociation is an Association whose key is constrained to be a
 canonical symbol (Symbol, DoubleByteSymbol, or QuadByteSymbol).

Constraints:
	key: Symbol
	value: Object';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelSubclass:'Behavior'
	instVarNames: #(superClass format instVarsInfo instVarNames constraints classVars methDicts poolDictionaries categorys dbTransientMask)
	classVars: #(Class_numIvs_mask GC_NON_PERSISTENT_MASK GC_RubyModuleNP METH_lu_skipPersistentMd METH_lu_undef_ed METH_prot_override_private METH_prot_override_protected METH_prot_override_public METH_prot_private METH_prot_protected METH_prot_public)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'subclassesDisallowed'  #logCreation )
	reservedOop: 67585
)
		category: nil;
		comment: '
 Behavior is an abstract superclass with the concrete subclasses
 ObsoleteMetaclass and Module .
 You may not create any other subclasses of Behavior.

 Behavior describes the protocol common to all kinds of Module
 and instances of ObsoleteMetaclass.  In other words, you can send the messages listed
 here to any Class or metaclass.  In the method descriptions below,
 "superclass" refers to the superclass of instances of the receiver,
 not to the superclass of the receiver itself.

 instVars:
  superclass - The Behavior''s immediate superclass in the
		Smalltalk environment 0  class hierarchy

  format - A SmallInteger that encodes the following information in its bits:
      (format bitAnd: 3) = 0 if instances of the Behavior are pointer objects.
      (format bitAnd: 3) = 1 if instances of the Behavior are byte objects.
      (format bitAnd: 3) = 2 if instances of the Behavior are non-sequenceable
                collections (NSCs, such as Bags and Sets).
      (format bitAnd: 3) = 3 if instances of the Behavior are special objects.

      and single bit fields per the following masks:
        16r4  instances of the Behavior have varying instVars addressable by
		a SmallInteger offset, (such as Array, String)
              previously documented as "have indexable instVars"
        16r8  instances of the Behavior are invariant.
        16r10  the Behavior had constraints upon what can be
      	        stored in its instance variables (bit longer used)
        16r20  the Behavior does not allow subclass creation.
	16r40  Nsc duplicates allowed (1 for IdentityBag, 0 for IdentitySet)
        16r80  the Behavior does not allow structural access from GCI C interface
	16r100  obsolete bit
        16r200  no stores to instvars via structural access from GCI
        16r400  GCI traversal result via send of aClampSpecification.traversalCallBackSelector
        16r800  non-persistent bit, instances of the class may not be committed
        16r1000  dbTransient bit, instVar in instances of the class are always nil on disk.
        16r2000  self can be special , used by compiler and native code generator ,
		 set if instances of receiver or any subclass can be special objects,
                 absense of bit enables some self.class optimizations in code generator.
        16r4000  Ruby virtual class bit
        16r8000  Ruby singleton class bit
       16r10000  Ruby module-include-self bit
       16r20000  Ruby module-functions bit
      16r1000000 is a Metaclass3 
    16r180000000  byte swizzle kind bits (word size in a byte format object).
      C definitions for the bits are in $GEMSTONE/include/gcioc.ht

  instVarsInfo - A non-negative SmallInteger encoding the number of instance variables in
     instances of this class (including those inherited from superclasses)
     and additional information.   The additional information is regenerated each
     time the class is loaded into memory and is used only within the Virtual Machine.
     The mask to extract the number of instance variables is 16rFFF .
     Each instance of Behavior is limited to 2030 named instance variables.

  instVarNames - An invariant Array of Symbols giving the names of the Behavior''s
     instance variables, including those inherited from superclasses.  Each instance
     variable name is limited to 64 Characters, and must begin with an
     alphabetic character or an underscore ("_").  For more information, see
     the GemStone Programming Guide.

  constraints - An invariant Array of Classes, which may be present in classes
    created in GemStone prior to v3.4.
    Each element in the Array is the class kind of a corresponding instance
    variable defined in a class or inherited from a superclass.
    If constraints size is one larger than the size of instVarNames, the last element
    is the constraint on varying instVars.
    As of GemStone 64bit v3.4, constraints are no longer enforced.

  classVars - A SymbolDictionary used when compiling methods in this Behavior.  Each instance
     of a class has its own instance variables, which may differ in value.  Each
     class has its own class variables, which have the same value for all instances
     of the class.  For each SymbolAssociation in this dictionary, the key is a
     Symbol representing a class variable, and the corresponding value is the value
     of that class variable.  Each class variable name is limited to 64 Characters,
     and must begin with an alphabetic character or an underscore ("_").
     When resolving variable names, method compilation searches the classVars of
     the class in which a method is being compiled, and also the classVars of superclasses.

  methDicts -  A GsMethodDictionary that has all of the additional protocol
	(not inherited from superclasses) for instances of this Behavior.
    May also be an Array .
    If an Array, the array holds groups of 4 ,
        methodDict for envId is      methDicts at:(envId*4 + 1)
        rubyNameSpace for envId is   methDicts at:(envId*4 + 2)
        superclass for envId is      methDicts at:(envId*4 + 3)

      Examples
        methodDict for env 1  is     methDicts at: 5  (or _rubyAt:4)
        rubyNameSpace for env 1 is   methDicts at: 6  (or _rubyAt:5)
        superclass for env 1  is     methDicts at: 7  (or _rubyAt:6)

      Note image and primitives code for following the superClass
      link for envId == 0  always uses   self superClass ,i.e. the
      superClass instVar not   (methDicts at: 3)

      See also class comment for Module for transientMethDicts instVar.

  poolDictionaries -  An Array of SymbolDictionaries used when compiling methods in
     this Behavior.  The dictionaries contain objects that can be shared by multiple classes
     and multiple users.  When resolving variable names, method compilation searches
     the poolDictionaries of the class in which a method is being compiled, but
     does not search poolDictionaries of superclasses.

  categorys - A GsMethodDictionary that categorizes selectors in this Behavior.
     For each element in this dictionary, the key is a method category Symbol, and the
     corresponding value is a SymbolSet of the selectors for that method category.
     May also be an Array of GsMethodDictionarys if class contains
     methods with environmentId > 0.
     Support for categories for environmentId > 0 is mostly not implemented.

  dbTransientMask - nil or a SmallInteger whose bits specify dbTransient instance variables.

Constraints:
	superClass: Behavior
	format: SmallInteger
	instVarsInfo: SmallInteger
	instVarNames: Array
	constraints: Object
	classVars: SymbolDictionary
	methDicts: Object
	poolDictionaries: Array
	categorys: Object
	dbTransientMask: SmallInteger
';
		immediateInvariant.
true.
%

doit
(Behavior
	_newKernelSubclass:'Module'
	instVarNames: #(name classHistory transientMethDicts)
	classVars: #(OM_MODULE_INCLUDE_self OM_MODULE_INCL_moduFcts OM_RUBY_INCLUDE_Meta OM_RUBY_INCLUDE_Module)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'noInheritOptions'  #logCreation )
	reservedOop: 143105
)
		category: nil;
		comment: '
 Module represented the Ruby  class Module .
 In a Smalltalk repository, there are no instances of Module and
 creating instances of Module is not supported.

   InstVars            Values
      name             a Symbol
      classHistory     nil or a ClassHistory
      transientMethDicts   always nil on disk, in memory, nil or an Array .
        transient methodDict for envId is      transientMethDicts at:(envId*4 + 1)
        transient rubyNameSpace for envId is   transientMethDicts at:(envId*4 + 2)
        transient superclass for envId is      transientMethDicts at:(envId*4 + 3)
        spare element                          transientMethDicts at:(envId*4 + 4)

     Note that the persistent superclass link for envId==0 is always in
     the superClass instVar defined in behavior. (see class comment in Behavior)
     Image and primitives code for following the superClass link for
     envId == 0 ignores (transientMethodDicts at: (envId*4 + 3)).

Constraints:
	superClass: Behavior
	format: SmallInteger
	instVarsInfo: SmallInteger
	instVarNames: Array
	constraints: Object
	classVars: SymbolDictionary
	methDicts: Object
	poolDictionaries: Array
	categorys: Object
	dbTransientMask: SmallInteger
	name: Symbol
	classHistory: ClassHistory
	transientMethDicts: Object
 ';
		immediateInvariant.
true.
%

doit
(Module
	_newKernelSubclass:'Metaclass3'
	instVarNames: #(destClass)
	classVars: #(GC_ClassCreationRuby GC_Metaclass3_metaClass GEN_MAX_INSTANCE_VARS)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'disallowGciStore' #'traverseByCallback'  #logCreation )
	reservedOop: 146177
)
		category: nil;
		comment: '
In Smalltalk beginning with Gs64 v3.0, metaclasses of newly created Classes
will be instances of Metaclass3 rather than instances of ObsoleteMetaclass .

In Ruby kinds of Metaclass3 are used for classes, metaclasses, and singleton classes

InstVars
  destClass   in a metaclass,  is the "thisClass" reference.
              in a Smalltalk Class, is the "migrationDestination"

Constraints:
	superClass: Behavior
	format: SmallInteger
	instVarsInfo: SmallInteger
	instVarNames: Array
	constraints: Object
	classVars: SymbolDictionary
	methDicts: Object
	poolDictionaries: Array
	categorys: Object
	dbTransientMask: SmallInteger
	name: Symbol
	classHistory: ClassHistory
	transientMethDicts: Object
	destClass: Module
';
		immediateInvariant.
true.
%

doit
(Metaclass3
	_newKernelSubclass:'Class'
	instVarNames: #(timeStamp userId extraDict classCategory subclasses)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'noInheritOptions' #'subclassesDisallowed'  #logCreation )
	reservedOop: 68609
)
		category: nil;
		comment: 'Each of the classes in the GemStone kernel inherits some of its behavior from
 Class.

 You may send the messages described here to any of the kernel classes
 (class-defining objects) defined in this manual.  However, you may not send
 these messages to instances of the kernel classes (that is, unless the
 receiver is an instance of Class).

 Consider the following example.  The description of class SmallInteger
 contains two kinds of protocol: instance methods and class methods.  Instance
 methods are understood by SmallIntegers (instances of the class SmallInteger,
 which inherit their protocol from Integer, Number, Magnitude, and Object).
 Class methods are understood by the class-defining object SmallInteger itself
 (which is the single instance of the metaclass "SmallInteger class", and
 inherits its protocol from Class, Behavior, and Object).  The messages
 described here (for Class) are understood by SmallInteger; that is, they are
 class methods for the class-defining object), but are not understood by
 instances of SmallInteger.

Constraints:
	superClass: Behavior
	format: SmallInteger
	instVarsInfo: SmallInteger
	instVarNames: Array
	constraints: Object
	classVars: SymbolDictionary
	methDicts: Object
	poolDictionaries: Array
	categorys: Object
	dbTransientMask: SmallInteger
	name: Symbol
	classHistory: ClassHistory
	transientMethDicts: Object
	destClass: Module
	timeStamp: DateTime
	userId: CharacterCollection
	extraDict: SymbolDictionary
	classCategory: CharacterCollection
	subclasses: IdentitySet

--- instVar classCategory
A CharacterCollection that names the category of classes to which this class
 belongs.  Each subclass also belongs to this category, unless the subclass
 overrides it with its own category.  Class categorization can be used by
 browsers and schema design tools.

--- instVar classHistory
The ClassHistory to which the class belongs.  Every class belongs to exactly
 one class history, which tracks its ancestry and assists with changes to its
 structure (schema).  When a new class is created, it is considered to be either
 a new version of an existing class, or else it has no previous history.  A new
 class version becomes the most recent version in an existing ClassHistory.
 Otherwise, a new ClassHistory is created for the new class.

--- instVar destClass
A Class, generally considered to be the next later version of this class.  At
 an appropriate time, it may be desirable or necessary to migrate instances of
 this class to the newer version.  This variable remembers which class the
 instance should migrate to.

 You can mark a Class with a migration destination by sending it the message
 migrateTo:.  When so marked, instances of that Class can be migrated to the
 new Class while maintaining identity.  The destination Class should have the
 method migrateFrom: implemented to define the transformation.  A default
 implementation is provided in Object.

 Migration is triggered manually by sending the message migrate to an instance
 of the Class.  Other protocol for forcing migration is
 Class | migrateInstancesTo: and Repository | migrateInstancesOfClasses:.

--- instVar extraDict
Reserved for internal use by GemTalk Systems

--- instVar name
The class''s name for itself; a Symbol of up to 64 Characters.

--- instVar subclasses
An IdentitySet of the subclasses of this class.  This set is only present in
 modifiable classes, and is nil otherwise.

--- instVar timeStamp
A DateTime object that indicates when the class was created.

--- instVar userId
A CharacterCollection that gives the identity of the user that created the class.

--- Category:  Subclass Creation
Every new GemStone Smalltalk class must be a subclass of some other existing
 GemStone Smalltalk class.  To create the new class, you send a subclass
 creation message to its intended superclass.

 The following restrictions apply to creating classes:

 * The new class must be of the same implementation (storage format) as the
   receiver (its superclass), unless the receiver is a non-indexable pointer
   object.  In this case, there are no restrictions if the receiver has no
   instance variables.  If the receiver does have instance variables, the new
   class may not be of special or byte format.
 * The name of a class is a Symbol at most 1024 Characters long.
 * The name of an instance variable is a String at most 64 Characters long.
 * A class contains at most 2030 named instance variables.

 Implementation Format.

 Instance variables may be named or unnamed.  The class definition (often in
 the subclass creation method) explicitly declares the name and number of all
 named instance variables.  This definition must be fixed (class not
 modifiable) before instances of the class can be created.  The class
 definition also implicitly declares unnamed instance variables (if they
 exist), by the choice of implementation format.  Unnamed variables can vary in
 number independently for each instance.  Depending upon format, unnamed
 variables may be indexed (in which case they are accessed by index), or not
 (in which case they are unordered and are accessed associatively, by value).
 Classes in byte format have indexed instance variables that are stored by byte
 for efficiency of storage and access.

 You use different methods to create a byte class, an indexable class, or a
 class of another format.  For each of these possibilities there is a pair of
 standard methods.  Each of these methods provides a full (long) list of
 keywords that permit you to specify a new class fully.  One of them also
 allows you explicitly to specify the new class as a version of an existing
 class, while the other does not.  Additional methods provide selected shorter
 lists of keywords for convenience, and supply default values for some
 arguments.

 Pool dictionaries.

 If you want to add or remove pool dictionaries for the new class at some
 later time, the argument that supplies the Array of pool dictionaries must not
 be an Array literal.  The literal value produces an InvariantArray object,
 which cannot subsequently be modified.

 Dictionary.

 GemStone adds the new class to a dictionary.  The dictionary is typically
 already in the current user''s symbol list, but it can be added to the symbol
 list at a later time if it is not already there.  (The symbol list makes the
 class visible to the user.)  The specified dictionary is often UserGlobals,
 but may be Globals if the data curator has authorized the user to modify that
 dictionary.

 Constraints.

 Constraints are not supported as of GemStone/S 64bit v3.4. They may still be
 specified via the old method keywords, but the settings are ignored.

 Invariance.

 The invarBoolean argument of a subclass creation method deals with class-level
 invariance.  When that argument is true, GemStone thereafter forces all
 instances of the new class to become invariant as soon as they are committed
 to GemStone.  That is, invariance applies to all objects of that class.

 If instances of the new class''s superclass are invariant, then instances of
 the new class must also be invariant.  In this case, a subclass creation
 method generates an error if the invarBoolean argument is not true.

 Class Modification.

 The modifyBoolean argument of a subclass creation method deals with
 object-level invariance, the ability to modify the object that is the class
 itself.

 Classes are typically not modifiable.  As a result, this argument is generally
 given the value false.  The subclass creation method then makes the new class
 an invariant object, and instances of that class can be created at any time
 after.

 When the modifyBoolean argument is true, the new class is modifiable, not
 invariant.  Its instance variables can be modified.  However,
 no instances of it can yet be created.  Once all desired changes have been
 made, you must send the new class the message immediateInvariant.  That
 message then makes the new class an invariant object, and no further changes
 to it are possible.  However, instances of the class can then be created.

 For more information about invariance at all levels, see the GemStone
 Programming Guide.

 Classes and Schema.

 A class can be viewed as an implementation of a schema, or of part of a
 schema.  In order to define and develop a schema, you may create modifiable
 classes, which remain modifiable until the schema is stable.

 However, it is sometimes also necessary to change schema after classes are no
 longer modifiable, and after instances of them exist.  To accomplish this kind
 of change, you must create new classes to implement the new schema.  However,
 it may be desirable to consider a new class to be a new version of an existing
 class, so that a logical connection between them and their instances can be
 maintained.

 Speaking conceptually, a class history lists all the versions of a class.
 Speaking technically, the objects that are classes do not have versions.
 Versions are represented by the list of classes in a class history.  Every
 class (object) belongs to exactly one class history; therefore, all the
 classes that are listed in a class history share the same class history
 object.

 Subclass methods that have an oldClass argument return oldClass if the
 requested new class would be equivalent to oldClass .
 Otherwise the new class is created as a new version of oldClass,
 and the two classes share the same class history.
 If the oldClass argument is nil, then no equivalence checks are done and
 thew new class gets a new class history.

 When subclass methods that lack the oldClass argument create a new class with
 the same name an existing class in the specified dictionary, then
 the existing class is treated as an "oldClass" in the implementation and
 equivalence checks are performed per the above paragraph.

 An oldClass is equivalent to the subclass that would be created using
 the other arguments to a subclass creation method if
     instVar names match exactly ,
   and class instVar names match exactly ,
   and anArrayOfClassVars contains at least all of the classVars in oldClass
     (additional classVars will be added to oldClass if no subclass is created),
   and pool dictionaries match exactly.

  Many of the subclass creation methods have an options: keyword  which takes
  an Array of Symbols containing zero or more of
    #noInheritOptions,  #subclassesDisallowed, #disallowGciStore, #modifiable ,
    #traverseByCallback #selfCanBeSpecial #logCreation
  and at most one of
     #dbTransient, #instancesNonPersistent, #instancesInvariant .
  If present, #noInheritOptions must be the first element and it causes
  none of subclassesDisallowed, disallowGciStore, traverseByCallback,
         dbTransient, instancesNonPersistent, instancesInvariant
  to be inherited from the superclass, nor copied from the
  current version of the class.
  #selfCanBeSpecial is never inherited and is needed only when modifying
  superclass hierarchy above classes with special format.
  The option #logCreation, if present in the options array, causes logging
  with GsFile(C)>>gciLogSever:  of class creation / equivalence.

  With respect to options and format, oldClass is equivalent if
    The state of format bits dbTransient, and instancesInvariant match exactly ,
    and subclassesDisallowed cannot be set in the new subclass if it not set in oldClass ,
    and modifiable  cannot be set if it is not set in oldClass  ,
    and  (SELF_CAN_BE_SPECIAL, NSC_DUPLICATES, INDEXABLE, IMPLEMENTATION, NO_STRUCT_UPDATE bits)
        of the formats must match exactly.

  If all other equivalence tests pass, the following changes to oldClass may be
  made to match the arguments and avoid creating a new subclass
    instancesNonPersistent may be set in the format of oldClass
    subclassesDisallowed bit may be cleared in format of oldClass
    traverseByCallback bit may be set or cleared in format of oldClass
    oldClass may be changed from modifiable to not modifiable (by sending immediateInvariant)
    classVars may be added to oldClass.
';
		immediateInvariant.
true.
%

doit
(Behavior
	_newKernelSubclass:'ObsoleteMetaclass'
	instVarNames: #(thisClass)
	classVars: #(GEN_MAX_INSTANCE_VARS)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #'disallowGciStore' #'traverseByCallback'  #logCreation )
	reservedOop: 71425
)
		category: nil;
		comment: 'An instance of ObsoleteMetaclass is the meta class on disk
 of a Class created in a prior version (Gemstone 2.x) repository.
 Instances of ObsoleteMetaclass are mutated to instances of Metaclass3
 when they are faulted into the VM.
 Behavior in ObsoleteMetaclass is present for reference purposes and
 is not expected to be executed.

Constraints:
	superClass: Behavior
	format: SmallInteger
	instVarsInfo: SmallInteger
	instVarNames: Array
	constraints: Object
	classVars: SymbolDictionary
	methDicts: Object
	poolDictionaries: Array
	categorys: Object
	dbTransientMask: SmallInteger
	thisClass: Class';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelByteSubclass:'BitSet'
	classVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'4byteWords'  #logCreation )
	reservedOop: 137473
)
		category: nil;
		comment: 'A BitSet is an array of bits , with a maximum size of  130144 bits.
 BitSets will grow as needed up to the maximum size, to accomodate
 bits being set.
 Usage requiring a set bigger than 130144 elements should use
 an IdentitySet, or hidden sets in class System.
';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelSubclass:'BlockClosure'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'disallowGciStore' #'subclassesDisallowed' #'traverseByCallback'  #logCreation )
	reservedOop: 84481
)
		category: nil;
		comment: 'BlockClosure is an abstract superclass for all the different kinds of blocks
 of GemStone Smalltalk code.';
		immediateInvariant.
true.
%

doit
(BlockClosure
	_newKernelIndexableSubclass:'ExecBlock'
	instVarNames: #(_method iFields1 staticLink stkSerialNum ccallin)
	classVars: #(_rubyFrameLocalsNil)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 143361
)
		category: nil;
		comment: 'ExecBlock is the block class representing all kinds
 of executable blocks in the Gemstone64 virtual machine.
 ExecBlock was introduced in Gemstone64 version 3.0 .
 Instances of subclasses ExecBlock0..ExecBlockN exist in-memory
 only for use by the VM. In-memory copies of ExecBlocks have
 their class changed to one of ExecBlock0..ExecBlockN  after
 validating number of args, etc.  The varying instVars , if any,
 contain copies of the values of outer block(s) args or temps.

--- instVar _method
The instance of GsNMethod containing the code for this ExecBlock.
 In an in-memory ExecBlock, this instVar can contain a reference to
 a GsNativeCode object.

--- instVar iFields1
A SmallInteger which encodes the unsigned ints
    nArgs          mask             16rFF,
    lastRubyArgIsStar  mask        16r100
    rubyNoArgsDecl    mask         16r200
    nTemps mask                16rFFFF000,
    selfOffsetInVC  mask   16rFFFF0000000    (offset is zero-based)
    cost           mask  16r0300000000000
    isCopyingBlock mask  16r0400000000000
    spare                16r0800000000000
    selfOffsetInSelf    16r0F000000000000
    spare              16rFF0000000000000
    isRubyLambda mask 16r1000000000000000  (the sign bit)

--- instVar staticLink
Set to nil by the method compiler; for use by the VirtualMachine only.
 If non-nil in a stored or active block ,
 a reference to the VariableContext of the home method.

-- instVar stkSerialNum
Set to nil by the method compiler; for use by the VirtualMachine only,
 in the implementation of continuations.

Constraints:
	_method: GsNMethod
	iFields1: SmallInteger
	staticLink: VariableContext
	stkSerialNum: SmallInteger
	ccallin: CCallin';
		immediateInvariant.
true.
%

doit
(ExecBlock
	_newKernelSubclass:'ExecBlock0'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 127745
)
		category: nil;
		comment: 'An instance of ExecBlock0 is an in-memory instance of ExecBlock which
 the VM already knows should have zero args .
 ExecBlock0 was introduced in Gemstone64 version 3.0

Constraints:
	_method: GsNMethod
	iFields1: SmallInteger
	staticLink: VariableContext
	stkSerialNum: SmallInteger
	ccallin: CCallin';
		immediateInvariant.
true.
%

removeallmethods ExecBlock0
removeallclassmethods ExecBlock0

doit
(ExecBlock
	_newKernelSubclass:'ExecBlock1'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 128001
)
		category: nil;
		comment: 'An instance of ExecBlock1 is an in-memory instance of ExecBlock which
 the VM already knows should have one args .
 ExecBlock1 was introduced in Gemstone64 version 3.0

Constraints:
	_method: GsNMethod
	iFields1: SmallInteger
	staticLink: VariableContext
	stkSerialNum: SmallInteger
	ccallin: CCallin';
		immediateInvariant.
true.
%

removeallmethods ExecBlock1
removeallclassmethods ExecBlock1

doit
(ExecBlock
	_newKernelSubclass:'ExecBlock2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 128257
)
		category: nil;
		comment: 'An instance of ExecBlock2 is an in-memory instance of ExecBlock which
 the VM already knows should have two args .
 ExecBlock2 was introduced in Gemstone64 version 3.0

Constraints:
	_method: GsNMethod
	iFields1: SmallInteger
	staticLink: VariableContext
	stkSerialNum: SmallInteger
	ccallin: CCallin';
		immediateInvariant.
true.
%

removeallmethods ExecBlock2
removeallclassmethods ExecBlock2

doit
(ExecBlock
	_newKernelSubclass:'ExecBlock3'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 128513
)
		category: nil;
		comment: 'An instance of ExecBlock3 is an in-memory instance of ExecBlock which
 the VM already knows should have three args .
 ExecBlock3 was introduced in Gemstone64 version 3.0

Constraints:
	_method: GsNMethod
	iFields1: SmallInteger
	staticLink: VariableContext
	stkSerialNum: SmallInteger
	ccallin: CCallin';
		immediateInvariant.
true.
%

removeallmethods ExecBlock3
removeallclassmethods ExecBlock3

doit
(ExecBlock
	_newKernelSubclass:'ExecBlock4'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 128769
)
		category: nil;
		comment: 'An instance of ExecBlock4 is an in-memory instance of ExecBlock which
 the VM already knows should have four args .
 ExecBlock4 was introduced in Gemstone64 version 3.0

Constraints:
	_method: GsNMethod
	iFields1: SmallInteger
	staticLink: VariableContext
	stkSerialNum: SmallInteger
	ccallin: CCallin';
		immediateInvariant.
true.
%

removeallmethods ExecBlock4
removeallclassmethods ExecBlock4

doit
(ExecBlock
	_newKernelSubclass:'ExecBlock5'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 129025
)
		category: nil;
		comment: 'An instance of ExecBlock5 is an in-memory instance of ExecBlock which
 the VM already knows should have five args .
 ExecBlock5 was introduced in Gemstone64 version 3.0

Constraints:
	_method: GsNMethod
	iFields1: SmallInteger
	staticLink: VariableContext
	stkSerialNum: SmallInteger
	ccallin: CCallin';
		immediateInvariant.
true.
%

removeallmethods ExecBlock5
removeallclassmethods ExecBlock5

doit
(ExecBlock
	_newKernelSubclass:'ExecBlockN'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 129281
)
		category: nil;
		comment: 'An instance of ExecBlockN is an in-memory instance of ExecBlock which
 is ready to execute for a Ruby #call: .  At each send, excess args may
 need to be deleted or nils added to match number of args required by the
 block.  ExecBlockN was introduced in Gemstone64 version 3.0

Constraints:
	_method: GsNMethod
	iFields1: SmallInteger
	staticLink: VariableContext
	stkSerialNum: SmallInteger
	ccallin: CCallin';
		immediateInvariant.
true.
%

removeallmethods ExecBlockN
removeallclassmethods ExecBlockN

doit
(BlockClosure
	_newKernelSubclass:'ExecutableBlock'
	instVarNames: #(method firstPC spare1 numberArgs numberTemps firstSourceOffset lastSourceOffset argsAndTemps blockSelfUsed)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #logCreation )
	reservedOop: 84737
)
		category: nil;
		comment: 'ExecutableBlock and subclasses are obsolete in Gemstone64 v3.0 and above.';
		immediateInvariant.
true.
%

doit
(ExecutableBlock
	_newKernelSubclass:'ComplexBlock'
	instVarNames: #(selfValue originalInstance staticLink)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #logCreation )
	reservedOop: 85249
)
		category: nil;
		comment: 'ComplexBlock is obsolete in Gemstone64 v3.0 and above.
 A ComplexBlock references a variable context to access variables in enclosing
 scopes.';
		immediateInvariant.
true.
%

doit
(ComplexBlock
	_newKernelSubclass:'ComplexVCBlock'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #logCreation )
	reservedOop: 85505
)
		category: nil;
		comment: 'ComplexVCBlock is obsolete in Gemstone64 v3.0 and above.

 A ComplexVCBlock is a special kind of complex block that does require the
 creation of a variable context when it becomes active.  It contains a nested
 block that refers to its arguments or temporaries, which must be allocated in
 the variable context.
';
		immediateInvariant.
true.
%

doit
(ExecutableBlock
	_newKernelSubclass:'SimpleBlock'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #logCreation )
	reservedOop: 84993
)
		category: nil;
		comment: 'SimpleBlock is obsolete in Gemstone64 v3.0 and above. It is no longer used
 for execution.

 A SimpleBlock is an ExecutableBlock that does not refer to any enclosing scope
 variables.  Thus, unlike complex blocks, it needs no variable context at any
 time.

Constraints:
	method: GsMethod
	firstPC: SmallInteger
	spare1: Object
	numberArgs: SmallInteger
	numberTemps: SmallInteger
	firstSourceOffset: SmallInteger
	lastSourceOffset: SmallInteger
	argsAndTemps: Array
	blockSelfUsed: Boolean';
		immediateInvariant.
true.
%

doit
(BlockClosure
	_newKernelSubclass:'SelectBlock'
	instVarNames: #(queryBlock iterationBlock)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 85761
)
		category: nil;
		comment: 'SelectBlock is a concrete subclass of BlockClosure that supports selection
 blocks for associative access.

Constraints:
	queryBlock: ExecBlock
	iterationBlock: ExecBlock

--- instVar iterationBlock
An ExecBlock.  The firstPC instance variable of this block refers to the
 first bytecode to execute to begin execution of this block in GemStone
 Smalltalk (no associative access), and the lastPC instance variable refers
 to the last bytecode of the block''s GemStone Smalltalk execution.

--- instVar queryBlock
An ExecBlock.  The firstPC instance variable of this block refers to the
 first bytecode to execute to begin an associative access query, and the lastPC
 instance variable refers to the last bytecode of the associative access
 query.
';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelSubclass:'Boolean'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesInvariant' #'selfCanBeSpecial' #'subclassesDisallowed'  #logCreation )
	reservedOop: 68097
)
		category: nil;
		comment: 'The only two instances of Boolean represent the two logical truth values:
 true and false.

 You may not create new instances of Boolean.  You also may not create
 subclasses of Boolean.';
		immediateInvariant.
true.
%

doit
(Boolean
	_newKernelSubclass:'FalseClass'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'selfCanBeSpecial'  #logCreation )
	reservedOop: 137217
)
		category: nil;
		comment: '
 FalseClass is used during Ruby execution in the Maglev product.';
		immediateInvariant.
true.
%

doit
(Boolean
	_newKernelSubclass:'TrueClass'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'selfCanBeSpecial'  #logCreation )
	reservedOop: 136961
)
		category: nil;
		comment: '
 TrueClass is used during Ruby execution in the Maglev product.';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelSubclass:'CByteArray'
	instVarNames: #(info derivedFrom referencesTo typeSize)
	classVars: #(AppDeadMask AutoFree GcFreeMask NoFree)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'disallowGciStore'  #logCreation )
	reservedOop: 134401
)
		category: nil;
		comment: 'An instance of CByteArray encapsulates allocation of C memory or a reference to C memory.

  instVars
    info , a SmallInteger containing
        gcFree   , 3 bits, mask 16r7
           0 means no memory to free,
           bit 0x1 means call free() when in-memory instance is garbage collected.
           bit 0x2 means the memory has fence words
           bit 0x4 means VM owns the C memory  .
        dead     ,  1 bit, mask 16r8
           application has requested memory be freed .
        sizeBytes,  upper 57  bits

    derivedFrom -  nil or a CByteArray or a CPointer.  If non-nil,
         a CByteArray or CPointer from which this object was derived.
         This object represents a pointer into the body of derivedFrom,
         used to keep the referenced object alive.
         In Ruby, derivedFrom may be an Integer address in which case
         the instance has gcFree==0 and sizeBytes==0.

    referencesTo -  nil or an Array of CByteArrays .
       this object contains C pointers to the bodies of the
       elements of referencesTo.  used to keep referenced
       CByteArrays alive.

    typeSize - a SmallInteger , default value is 1 ,
        not used by Smalltalk code , used by Pointer class  in Ruby

  The methods in category ''Accessing elements'' use ZERO BASED offsets
  and support  unaligned accesses are supported.  They will check for
  and generate out-of-bounds errors based in the  sizeBytes of the receiver.

  The 8bit, 16bit, and 32bit accessing methods, when receiver is of size 8 ,
  and zeroBasedOffset == -1 , will  return the specified number of least signifigant
  bits of the receiver , as would have been stored by a function arg
  of type  char* , short*, int*   was used.
';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelSubclass:'CFunction'
	instVarNames: #(fName argTypes resultType cTypes argCounts argTypesDict)
	classVars: #(ArgCounts_fixedMask ArgCounts_varArgsMask ArgTypesDict CFunc_Arg_U64 CFUNC_max_params CFunc_Res_U64 ResTypesDict)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'disallowGciStore'  #logCreation )
	reservedOop: 133889
)
		category: nil;
		comment: 'CFunction is an abstract class representing the type signature of a C function.
Concrete subclasses are CCallout, CCalloutStructs, CCallin .

  instVars
     fName  , a String, the name of a callout function to be passed to dlsym() ,
          or the name of a callin function type.

     argTypes, an Array of zero or more Symbols describing the arguments .
        When native code generation is enabled by the gem config file,
          Functions using varArgs are limited to a maximum of
          20 variable arguments after the fixed arguments.
        When native code generation is disabled by the gem config file,
          Arguments and results of C type   float    are not supported.
          Functions which have one or more args of C type   double
          or whose result type is   double,
          are limited to a maximum of 4 fixed arguments.
          Functions using varArgs are limited to 4 fixed args and 10 total args.
          Otherwise functions are limited to 15 total arguments.
        See CCallout class >> library:name:result:args:  for more details .
        See comments in CCallout and CCalloutStructs for discussion of struct results and arguments.
        See comments in CCallout>>callWith: for details on varArgs .

     argTypesDict , if variable arguments supported by this function,
        references the class variable ArgTypesDict , otherwise nil.

     resultType, a Symbols describing the result of the C function.
       See method library:name:result:args:  for more details .

     cTypes , an Array for internal use
         translated representation of argTypes and resultType ,
         used by CCallout>>callWith:* primitives .

     argCounts , a SmallInteger generated from argTypes.

Constraints:
	fName: String
	argTypes: Array
	resultType: Symbol
	cTypes: ByteArray
	argCounts: SmallInteger
	argTypesDict: GsMethodDictionary
';
		immediateInvariant.
true.
%

doit
(CFunction
	_newKernelSubclass:'CCallin'
	instVarNames: #(envId)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 147201
)
		category: nil;
		comment: 'An instance of CCallin represents the type signature of a C function to be called
by C code .  Use of CCallin is not supported when native code is disabled.

  instVars
    envId -  message send environment in which to invoke a block .

  cData (hidden instVar) references native code in fixed code memory area which
    is the stable(not relocated by code_gen GC) C address to be called by C code .

  The block to be executed is referenced by cData.blockId

Constraints:
	fName: String
	argTypes: Array
	resultType: Symbol
	cTypes: ByteArray
	argCounts: SmallInteger
	argTypesDict: GsMethodDictionary
	envId: SmallInteger
';
		immediateInvariant.
true.
%

doit
(CFunction
	_newKernelSubclass:'CCallout'
	instVarNames: #(library lastError untaggedEnumsDict)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 146945
)
		category: nil;
		comment: 'An instance of CCallout represents the information needed to
call a C function using the FFI .

   instVars
     library , a CLibrary, nil, or 1 .  If nil, the function will be
         searched for in the current process using dlsym(RTLD_NEXT) ,
         searching any libraries which were loaded AFTER libgcilnk.so .
         If 1 , the function represents a call into a Ruby C extension,
         and cannot be re-resolved if this CCallout is faulted in.

         If a CLibrary, the specified shared library will be loaded on-demand
         using dlopen() and that library searched using dlsym().
         On some platforms where RTLD_FIRST not available, the whole process
         will be searched if function not found in specified library.

     lastError, normally nil, in an in-memory instance holds the last
        error from the callWith: primitive .

     version( dynamic instVar) nil or a String used as the third arg to dlvsym()

   cData (hidden instVar) , in an in-memory instance contains the result from dlsym().
      and pointers to one or more calloutStub''s emitted by the native code generator.

    To avoid repeated calls to dlsym() a committed instance of CFunction
    must be kept in memory (such as by a reference from session state)
    while it is being used.  At the time a dlsym() call is made,
    if library is non-nil that instVar will become a not-stubbable memory
    reference to the CLibrary.

   See comments in CCallout>>callWith: for details on varArgs .

Constraints:
	fName: String
	argTypes: Array
	resultType: Symbol
	cTypes: ByteArray
	argCounts: SmallInteger
	argTypesDict: GsMethodDictionary
	library: CLibrary
	lastError: String
  untaggedEnumsDict: (not used)';
		immediateInvariant.
true.
%

doit
(CCallout
	_newKernelSubclass:'CCalloutStructs'
	instVarNames: #(version structSizes)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 161025
)
		category: nil;
		comment: 'An instance of CCalloutStructs represents the information needed to
call a C function using the FFI .  Instances of CCalloutStructs are
used to make an FFI call when one or more of the result or arguments
to the called function are C structs (or C++ classes) passed by value.
Structs passed or returned by value have type #struct when creating
an instances of CCalloutStructs.  

   instVars

     version, nil or a String used as the third arg to dlvsym()

     structSizes  used by  callWith:structResult:errno:  primitive
        elements are SmallInteger sizes in bytes, or nil
        first element is size of a struct result (or nil if result not a struct)
        second element is size of first arg if that arg is a struct, or nil.
        The value of an argument or result that is a struct 
        must be a kind of CByteArray with matching size .
 
    See comments in CCallout for documentation of inherited instVars.

   An argument or resule of an ffi call that is address of a struct (i.e. type #ptr)
   is not a struct passed by value .
   
   struct results  
     This applies to structs returned by value .
     A struct returned by value is returned in a kind of CByteArray.
     The call must be made via CCalloutStructs>>callWith:structResult:errno: .
     and a sender of that method must allocate the result struct and
     pass it as argument to the structResult:  keyword.

   See comments in CCallout>>callWith: for details on varArgs .

Constraints:
	fName: String
	argTypes: Array
	resultType: Symbol
	cTypes: ByteArray
	argCounts: SmallInteger
	argTypesDict: GsMethodDictionary
	library: CLibrary
  untaggedEnumsDict:  (not used)
	lastError: String
	version: String
  structSizes: Array';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelSubclass:'CLibrary'
	instVarNames: #(name expandedName lastError loadAttempted onLoadBlock)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 133633
)
		category: nil;
		comment: 'An intances of CLibrary represents a shared library.

   instVars
      name  , a String, the name of the library .
      expandedName, a String,  name after expansion of environment variables
         and symbolic links , and adding .so or other suffix,
         as was passed to dlopen(). nil in a committed instance.
         The instVar is a cache to be accessed by the primitives only.

      lastError , a String, value from dlerror() after a failure of dlopen(),
               always nil in a committed instance .
      loadAttempted,  nil in a committed instance, true if load attempted
      onLoadBlock , nil, or an ExecBlock to be run each time the
          shared library is successfully loaded; was used by Ruby.

   cData (hidden instVar) , in an in-memory instance is a handle
       returned from a successful dlopen() , or nil if library is not loaded.
   If available, the RTLD_FIRST(Solaris, Mac) flag
   is specified when calling dlopen().

   Loading of shared libraries via CLibrary is disallowed if the session''''s
   UserProfile has the NoUserAction inverse privilege set .

Constraints:
	name: String
	expandedName: String
	lastError: String
	loadAttempted: Boolean
	onLoadBlock: ExecBlock
';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelSubclass:'ClusterBucket'
	instVarNames: #(_clusterId extentId keepClusteredOnModify description)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 82177
)
		category: nil;
		comment: 'A ClusterBucket describes clustering behavior.  A ClusterBucket represents
an abstract collection of pages within the repository; the collection
has no defined size and cannot be enumerated.

ClusterBuckets have the following instance variables:

_clusterId, a SmallInteger, assigned by system on instance creation

extentId, a SmallInteger, As of Gemstone64 v3.5+  NOT USED

keepClusteredOnModify, not used

description, may be any object, normally a String describing the bucket.
';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelIndexableSubclass:'Collection'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 68865
)
		category: nil;
		comment: 'Collection is an abstract superclass for all classes whose instances represent
 a collection of other objects that are known as their elements.  It defines
 methods for operating upon the elements as a whole.

 You should not add elements to or remove elements from a Collection at the same
 time as you are iterating over all or part of the Collection.  Doing so may
 have unpredictable consequences.  For example, avoid changing a Collection
 within the block argument for methods like do:, collect:, select:, reject:, and
 their variants or extensions.';
		immediateInvariant.
true.
%

doit
(Collection
	_newKernelSubclass:'AbstractDictionary'
	instVarNames: #()
	classVars: #(AbsDictSentinel)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'disallowGciStore'  #logCreation )
	reservedOop: 110593
)
		category: nil;
		comment: 'AbstractDictionary is an abstract class that provides the protocol for
 collections whose elements can be accessed by an associated lookup key.
 Concrete classes of AbstractDictionary store the key-value pairs either
 directly or as Associations.  See the documentation for the Dictionary and
 KeyValueDictionary classes for more information.';
		immediateInvariant.
true.
%

doit
(AbstractDictionary
	_newKernelSubclass:'KeyValueDictionary'
	instVarNames: #(numElements numCollisions collisionLimit tableSize)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 79361
)
		category: nil;
		comment: 'KeyValueDictionary is a concrete subclass of AbstractDictionary.  In a
 KeyValueDictionary, keys may be of mixed classes.

 A KeyValueDictionary stores key-value pairs under an index that is generated by
 applying a hash function to the key; it does not use Associations.  The hashing
 improves retrieval speed.  However, you must observe an important restriction:
 after a key/value pair has been added to a KeyValueDictionary, you must not
 modify the key.  Doing so renders the value inaccessible.

 A KeyValueDictionary is also an equality-based collection.  That is, two keys
 or two values are considered to be the same if they are equivalent; they need
 not be identical to be the same.  Thus, if you add two key-value pairs to a
 KeyValueDictionary but the keys are equivalent, even if they are not identical,
 then the result is that the second pair overwrites the first one, because the
 keys are the same.

 Some other kinds of dictionaries are identity-based rather than equality-based.
 These other kinds of dictionaries exhibit better performance than
 KeyValueDictionary and are to be preferred where they are appropriate.

 For multiuser applications that involve a lot of concurrent use of
 dictionaries, use RcKeyValueDictionary.

Constraints:
	numElements: SmallInteger
	numCollisions: SmallInteger
	collisionLimit: SmallInteger
	tableSize: SmallInteger

--- instVar collisionLimit
A SmallInteger that represents the number of collisions allowed before
 rebuilding the hash table.

--- instVar numCollisions
A SmallInteger that represents the cumulative number of collisions that have
 occurred during the addition of the elements to the dictionary since the last
 rebuild.

--- instVar numElements
A SmallInteger that represents the number of key/value pairs in the
 dictionary.

--- instVar tableSize
A SmallInteger that represents the size of the primary hash table.
';
		immediateInvariant.
true.
%

doit
(KeyValueDictionary
	_newKernelSubclass:'IdentityKeyValueDictionary'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 90881
)
		category: nil;
		comment: 'An IdentityKeyValueDictionary is a KeyValueDictionary that is an identity-based
 collection instead of equality-based.  That is, two keys or two values are
 considered to be the same only if they are identical; equivalent objects are
 not the same.  Thus, if you add two key-value pairs to an
 IdentityKeyValueDictionary and the keys are equivalent but not identical, then
 the result is that you have two pairs in the dictionary because the keys are
 not the same.

 An IdentityKeyValueDictionary sends #identityHash to keys to obtain the
 hash value, and sends #==  to compare two keys.
 It does not use  #hashFunction: and #compareKey:with:  methods.

 IdentityKeyValueDictionary exhibits better performance than KeyValueDictionary
 and is to be preferred where it is appropriate.

 For multiuser applications that involve a lot of concurrent use of
 dictionaries, use RcKeyValueDictionary.

Constraints:
	numElements: SmallInteger
	numCollisions: SmallInteger
	collisionLimit: SmallInteger
	tableSize: SmallInteger';
		immediateInvariant.
true.
%

doit
(IdentityKeyValueDictionary
	_newKernelSubclass:'GsMethodDictionary'
	instVarNames: #(valueConstraint keyConstraint)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'subclassesDisallowed'  #logCreation )
	reservedOop: 99073
)
		category: nil;
		comment: 'GsMethodDictionary optimizes IdentityKeyValueDictionary for use as method
 dictionaries in classes.  It employs a different internal structure that is
 well-suited for efficient execution in smaller dictionaries.  Changes to
 GsMethodDictionies are protected by the #CodeModification privilege, and
 therefore should not be used in customer applications.  For this purpose,
 you should use the subclass FastIdentityKeyValueDictionary.

 The keys of method dictionaries must be canonical symbols
 (Symbols, DoubleByteSymbols, or QuadByteSymbols).

 Implementation details:
 Within the hash table, entries are of size two and contain key/value pairs:
    aSymbol, aValue
    nil,     SmallInteger - one-based offset of start of collision chain
    nil,     nil          - empty hash slot

 Collisions chains are linked lists within the root object itself, and
 are stored in the area after the hash table.
 Collision list entries are triples (key, value, nextOffset):
    aSymbol, aValue, nextOffset - entry in chain, nextOffset is one-based
    aSymbol, aValue, nil        - end of chain
    nil,     nil,    nextOffset - empty element in collision chain, only
                                  removed by rebuildTable

Constraints:
	numElements: SmallInteger
	numCollisions: SmallInteger
	collisionLimit: SmallInteger
	tableSize: SmallInteger
	valueConstraint: Behavior
	keyConstraint: Behavior

instVar valueConstraint -- The Class that specifies a constraint on the GsMethodDictionary''s values.
 If nil, there is no constraint.

instVar keyConstraint -- The Class that specifies a constraint on the GsMethodDictionary''s keys.
 If nil, there is no constraint.';
		immediateInvariant.
true.
%

doit
(GsMethodDictionary
	_newKernelSubclass:'FastIdentityKeyValueDictionary'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'noInheritOptions' #'disallowGciStore'  #logCreation )
	reservedOop: 119809
)
		category: nil;
		comment: 'FastIdentityKeyValueDictionary is a subclass of GsMethodDictionary designed
 for customer applications.  FastIdentityKeyValueDictionary employs the same
 internal structure as GsMethodDictionary that is well-suited for efficient
 execution in smaller dictionaries.

Constraints:
	numElements: SmallInteger
	numCollisions: SmallInteger
	collisionLimit: SmallInteger
	tableSize: SmallInteger
	valueConstraint: Behavior
	keyConstraint: Behavior';
		immediateInvariant.
true.
%

doit
(GsMethodDictionary
	_newKernelSubclass:'GsSessionMethodDictionary'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'noInheritOptions' #'disallowGciStore'  #logCreation )
	reservedOop: 126209
)
		category: nil;
		comment: 'GsSessionMethodDictionary is a subclass of GsMethodDictionary to be used
 for storing session methods. The keys of this class are expected to be a
 Behavior and keys are GsMethodDictionaries.

Constraints:
	numElements: SmallInteger
	numCollisions: SmallInteger
	collisionLimit: SmallInteger
	tableSize: SmallInteger
	valueConstraint: Behavior
	keyConstraint: Behavior';
		immediateInvariant.
true.
%

doit
(IdentityKeyValueDictionary
	_newKernelSubclass:'GsMethodLookupCache'
	instVarNames: #(serialNum)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 247553
)
		category: nil;
		comment: '
 Instances of GsMethodLookupCache used internally by the method lookup
 caching in the VM.

 Smalltalk behavior (including inherited behavior) has no effect on the
 functionality of those internally created instances.

Constraints:
	numElements: SmallInteger
	numCollisions: SmallInteger
	collisionLimit: SmallInteger
	tableSize: SmallInteger
	serialNum: SmallInteger';
		immediateInvariant.
true.
%

removeallmethods GsMethodLookupCache
removeallclassmethods GsMethodLookupCache

doit
(IdentityKeyValueDictionary
	_newKernelSubclass:'IdentityDictionary'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 101633
)
		category: nil;
		comment: 'IdentityDictionary is a Dictionary that is identity-based rather than
 equality-based.

 IdentityDictionary implements key-value pairs by storing key-Association
 pairs.  Each Association contains a key-value pair, and the key is
 duplicated in the dictionary or collision bucket for implementation reasons.

 As with other identity-based collections, in an IdentityDictionary two keys or
 two values are considered to be the same only if they are identical; equivalent
 objects are not the same.  Thus, if you add two key-value pairs to an
 IdentityDictionary and the keys are equivalent but not identical, then the
 result is that you have two pairs in the dictionary because the keys are not
 the same.

 IdentityDictionary exhibits better performance than Dictionary and is to be
 preferred where it is appropriate.

Constraints:
	numElements: SmallInteger
	numCollisions: SmallInteger
	collisionLimit: SmallInteger
	tableSize: SmallInteger';
		immediateInvariant.
true.
%

doit
(IdentityDictionary
	_newKernelSubclass:'SymbolDictionary'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 111361
)
		category: nil;
		comment: 'A SymbolDictionary is an IdentityDictionary in which the keys are canonical
 symbols (Symbol, DoubleByteSymbol, or QuadByteSymbol) and the values are SymbolAssociations.
 The key of each SymbolAssociation is also the key used by the SymbolDictionary
 to access that SymbolAssociation.

 It is recommended that the symbol keys be valid identifiers in the ANSI sense,
 but it is not disallowed to use other kinds of symbols.  SymbolDictionary names
 that are identifiers can be used directly in compiled code, while names that are
 not identifiers require lookup.

 Only SymbolDictionaries can be used in symbol lists.
';
		immediateInvariant.
true.
%

doit
(SymbolDictionary
	_newKernelSubclass:'LanguageDictionary'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 101889
)
		category: nil;
		comment: 'A LanguageDictionary is a SymbolDictionary designed to hold language-dependent
 objects.  Language symbols are used as keys, so that a user''s language symbol
 (see UserProfile | nativeLanguage) can be used to find the appropriate object
 for the native language.

Constraints:
	numElements: SmallInteger
	numCollisions: SmallInteger
	collisionLimit: SmallInteger
	tableSize: SmallInteger';
		immediateInvariant.
true.
%

doit
(IdentityKeyValueDictionary
	_newKernelSubclass:'SymbolKeyValueDictionary'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 111105
)
		category: nil;
		comment: 'A SymbolKeyValueDictionary is an IdentityKeyValueDictionary in which the keys
 are canonical symbols (a Symbol, DoubleByteSymbol, or QuadByteSymbol).  The separate
 implementation is necessary in order to support canonicalization of the symbols
 that are used as keys.

 SymbolKeyValueDictionaries cannot be used in symbol lists.

Constraints:
	numElements: SmallInteger
	numCollisions: SmallInteger
	collisionLimit: SmallInteger
	tableSize: SmallInteger';
		immediateInvariant.
true.
%

doit
(KeyValueDictionary
	_newKernelSubclass:'IntegerKeyValueDictionary'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 79617
)
		category: nil;
		comment: 'An IntegerKeyValueDictionary is a KeyValueDictionary in which the keys are
 Integers.

 One useful application of IntegerKeyValueDictionary is as an implementation of
 a sparse Array.  If the keys to the dictionary are normal Array indexes and the
 Array indexes used are sparsely scattered over the range of the Array, then
 IntegerKeyValueDictionary can provide a fast implementation that has much lower
 storage costs.

Constraints:
	numElements: SmallInteger
	numCollisions: SmallInteger
	collisionLimit: SmallInteger
	tableSize: SmallInteger';
		immediateInvariant.
true.
%

doit
(KeyValueDictionary
	_newKernelSubclass:'ObsoleteSymbolListDictionary'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #logCreation )
	reservedOop: 94721
)
		category: nil;
		comment: 'The class ObsoleteSymbolListDictionary is obsolete as of GemStone version 5.0 and
will be removed in a future release.

Existing instances should be migrated to SymbolDictionary or otherwise
processed as required, and then should be removed.';
		immediateInvariant.
true.
%

doit
(KeyValueDictionary
	_newKernelSubclass:'StringKeyValueDictionary'
	instVarNames: #()
	classVars: #(StringKVDSentinel)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 79873
)
		category: nil;
		comment: 'A StringKeyValueDictionary is a KeyValueDictionary in which the keys are
 Strings or MultiByteStrings.  The hash function treats the strings as
 case-sensitive and is equivalent to String >> hash .
 Key comparisons always use code point comparison.

 Key arguments which are Symbols are converted to Strings prior
 to lookup in or addition to a StringKeyValueDictionary .

 The hashing algorithm is described in

 Pearson, Peter K.,
 "Fast Hashing of Variable-Length Text Strings,"
 Communications of the ACM, 33:6 (June 1990), 667-680.

 The implementation employs two modifications:

 * The hash function uses at most 2008 bytes of the string.  Strings that are
   identical within this range have the same hash value.

 * In his paper, Pearson describes a technique for producing a larger number of
   hash values by always computing the hash function to 24 bits.  The hash
   value is the result of this function modulo the table size.  Therefore,
   there is no value in specifying a table size greater than 2 to the 24th
   power.

Constraints:
	numElements: SmallInteger
	numCollisions: SmallInteger
	collisionLimit: SmallInteger
	tableSize: SmallInteger';
		immediateInvariant.
true.
%

doit
(StringKeyValueDictionary
	_newKernelSubclass:'CanonicalStringDictionary'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #logCreation )
	reservedOop: 109825
)
		category: nil;
		comment: 'A CanonicalStringDictionary is a StringKeyValueDictionary that provides
 protocol that is similar to Set in addition to its dictionary protocol.
 This is the old (32-bit GS/S) class of AllSymbols.

Constraints:
	numElements: SmallInteger
	numCollisions: SmallInteger
	collisionLimit: SmallInteger
	tableSize: SmallInteger';
		immediateInvariant.
true.
%

removeallmethods CanonicalStringDictionary
removeallclassmethods CanonicalStringDictionary

doit
(StringKeyValueDictionary
	_newKernelSubclass:'ObsoleteSymbolKeyValueDictionary'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #logCreation )
	reservedOop: 80129
)
		category: nil;
		comment: 'The class ObsoleteSymbolKeyValueDictionary is obsolete as of GemStone version 5.0
and will be removed in a future release.

Existing instances should be migrated to SymbolKeyValueDictionary or otherwise
processed as required, and then should be removed.';
		immediateInvariant.
true.
%

doit
(Collection
	_newKernelSubclass:'Repository'
	instVarNames: #(name dataDictionary)
	classVars: #(OP_ALL_INSTANCES OP_ALL_OBJS_IN_SEC_POLICY OP_ALL_OBJS_LARGER_THAN OP_ALL_REFERENCES OP_ALL_REFS_BY_PARENT_CLASS OP_ALL_REFS_TO_INSTANCES OP_COUNT_INSTANCES OP_FIND_REF_PATHS OP_INVENTORY_LIST_PAGE_ORDER OP_INVENTORY_MEMORY OP_INVENTORY_REPOSITORY OP_INVENTRY_TO_HIDDEN OP_LIST_INSTANCES OP_LIST_INST_PAGE_ORDER OP_LIST_INST_TO_FILES OP_LIST_INST_TO_HIDDEN OP_LIST_OBJS_IN_SEC_POLICY OP_LIST_OBJS_IN_SEC_POLICY_TO_FILES OP_LIST_OBJS_IN_SEC_POLICY_TO_HIDDEN OP_LIST_REFERENCES OP_LIST_REFERENCES_TO_INST OP_OBJECTS_LARGER OP_OBJECT_AUDIT OP_OT_CLEANUP OP_PRIVATE_REFERENCES)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'disallowGciStore' #'subclassesDisallowed'  #logCreation )
	reservedOop: 124417
)
		category: nil;
		comment: 'A Repository is an object that represents a virtual storage into which users
 can place their data.  Each Repository includes an Array of up to 65534
 GsObjectSecurityPolicies, which represent authorization regions for the data.
 Repositories are described in the GemStone Programming Guide.

Constraints:
	name: Symbol
	dataDictionary: AbstractDictionary
	[elements]: GsObjectSecurityPolicy.

instance variables
name -- The name of the Repository.
dataDictionary -- not used
';
		immediateInvariant.
true.
%

doit
(Collection
	_newKernelSubclass:'SequenceableCollection'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 73729
)
		category: nil;
		comment: 'SequenceableCollection is an abstract superclass for collections that define a
 consistent ordering on their elements.  You can think of the elements as
 forming a sequence of objects, numbered from 1 to n.  You can use the Integer i
 as an index to refer to the ith element in that sequence.  The elements are
 said to be indexable.

 The indexability of SequenceableCollections should not be confused with indexes
 that are specially built on UnorderedCollections to improve their performance
 when they search their elements (using associative access).

--- Category:  Adding
Methods in the Adding category modify their receivers.  They generally execute
 faster than methods in the Concatenating category, which do not modify their
 receivers.  Please see that category for more comparative information.

--- Category:  Concatenating
Methods in the Concatenating category do not modify their receivers.  They copy
 their receivers and then apply the concatenation to the copy.  Thus, they
 generally execute slower than methods in the Adding category, which do modify
 their receivers.

 Consider the following code example involving Strings:

    | n result |
    n := 1000.
    result := String new.
    n timesRepeat: [result := result , $x.].
    ^ result

 Each time through the loop, this code first generates a new instance of String,
 a copy of the previous result, to which it then adds one Character.  In n times
 through the loop then, n * (n - 1) / 2 Characters are copied, and n Characters
 are added.  Thus, the time complexity to execute such a loop is proportional to
 n * (n + 1) / 2.  Space and garbage collection overhead can be expensive, too.

 The following code example executes in time that is proportional to n, without
 any of the space and garbage collection overhead of the previous example:

    | n result |
    n := 1000.
    result := String new.
    n timesRepeat: [ result add: $x].
    ^ result

 The result is the same in both examples.
';
		immediateInvariant.
true.
%

doit
(SequenceableCollection
	_newKernelSubclass:'Array'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 66817
)
		category: nil;
		comment: 'Array is a concrete subclass of SequenceableCollection that capitalizes upon
 the indexability of its elements.  An Array permits its elements to be placed
 in any order, but once placed, it retains the order until changed explicitly.
 Integer indexes are often used to access elements directly, randomly, or in
 alternate or unpredictable orders not necessarily related to the sequence of
 the elements as placed in the collection.  Thus, an index is often used as
 the address for an element.

 Uninitialized Array elements are nil.';
		immediateInvariant.
true.
%

doit
(Array
	_newKernelSubclass:'AbstractCollisionBucket'
	instVarNames: #(numElements)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 79105
)
		category: nil;
		comment: 'An AbstractCollisionBucket is an Array that is used in a KeyValueDictionary to
 store a collection of key/value pairs for which the keys hash to the same
 value.

--- instVar numElements
A SmallInteger that gives the number of key/value pairs in the bucket.
';
		immediateInvariant.
true.
%

doit
(AbstractCollisionBucket
	_newKernelSubclass:'CollisionBucket'
	instVarNames: #(keyValueDictionary)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 114433
)
		category: nil;
		comment: 'A CollisionBucket is an Array that is used in a KeyValueDictionary to store
 a collection of key/value pairs for which the keys hash to the same value.

Constraints:
	numElements: SmallInteger
	keyValueDictionary: Object

instvar keyValueDictionary -- An AbstractDictionary.  For GemStone internal use.';
		immediateInvariant.
true.
%

doit
(CollisionBucket
	_newKernelSubclass:'EqualityCollisionBucket'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 146689
)
		category: nil;
		comment: 'An EqualityCollisionBucket is a CollisionBucket that is used in
 StringKeyValueDictionary, IntegerKeyValueDictionary, and other
 kinds of KeyValueDictionary using the default hash and key compare
 semantics for equality based dictionaries.

 Such dictionaries send #hash to keys to obtain the hash value, and
 send #=  to compare two keys.  They do not use  #hashFunction: and
 #compareKey:with:  methods.

Constraints:
	numElements: SmallInteger
	keyValueDictionary: Object';
		immediateInvariant.
true.
%

doit
(CollisionBucket
	_newKernelSubclass:'IdentityCollisionBucket'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 114177
)
		category: nil;
		comment: 'An IdentityCollisionBucket is a CollisionBucket that is used in an
 IdentityKeyValueDictionary to store a collection of key/value pairs for which
 the keys hash to the same value.  It provides support for the identity
 comparisons required by IdentityKeyValueDictionaries.  The bucket is
 sorted by the identity of the keys.

Constraints:
	numElements: SmallInteger
	keyValueDictionary: Object';
		immediateInvariant.
true.
%

doit
(AbstractCollisionBucket
	_newKernelSubclass:'ObsoleteIdentityCollisionBucket'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #logCreation )
	reservedOop: 91137
)
		category: nil;
		comment: 'The class ObsoleteIdentityCollisionBucket is obsolete; existing instances should be
migrated to IdentityCollisionBucket or otherwise processed as required.';
		immediateInvariant.
true.
%

doit
(AbstractCollisionBucket
	_newKernelSubclass:'ObsoleteRcCollisionBucket'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #logCreation )
	reservedOop: 87553
)
		category: nil;
		comment: 'The class ObsoleteRcCollisionBucket is obsolete as of GemStone version 5.0 and will be
removed in a future release.

This class implements GemStone internals. It is not intended for customer use,
by creating instances or by subclassing.

Existing instances should be migrated to RcCollisionBucket or otherwise
processed as required, and then should be removed.';
		immediateInvariant.
true.
%

removeallmethods ObsoleteRcCollisionBucket
removeallclassmethods ObsoleteRcCollisionBucket

doit
(Array
	_newKernelSubclass:'ClassHistory'
	instVarNames: #(description name)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'disallowGciStore' #'subclassesDisallowed'  #logCreation )
	reservedOop: 82689
)
		category: nil;
		comment: 'A ClassHistory is a sequence of Class objects that logically represent the
 historical revisions to a Class.

Constraints:
	description: Object
	name: Symbol
	[elements]: Class

instvar description -- A textual description of the function of the Class.

instvar name -- The class history''s name for itself; a Symbol of up to 64 Characters.
';
		immediateInvariant.
true.
%

doit
(Array
	_newKernelSubclass:'ClusterBucketArray'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 82433
)
		category: nil;
		comment: 'A ClusterBucketArray is an Array whose elements are instances of ClusterBucket.

 There is one instance of ClusterBucketArray in a fresh GemStone repository.  It
 can be accessed via the Globals dictionary using the following GemStone
 Smalltalk statement:

 Globals at: #AllClusterBuckets.

 GemStone uses AllClusterBuckets to translate clusterIds to cluster bucket
 objects:

 classmethod: ClusterBucket
 bucketWithId: aSmallPositiveInt
   ^ AllClusterBuckets at: aSmallPositiveInt
 %

 AllClusterBuckets has a reserved object identifier, to facilitate efficient
 access of the Array from within the object manager.  Therefore, a special C
 constant, OOP_ALL_CLUSTER_BUCKETS, is defined in the gcioop.ht header file to
 permit access to it from C.

Constraints:
	[elements]: ClusterBucket';
		immediateInvariant.
true.
%

doit
(Array
	_newKernelSubclass:'GsStackBuffer'
	instVarNames: #(next)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'disallowGciStore' #'subclassesDisallowed'  #logCreation )
	reservedOop: 100097
)
		category: nil;
		comment: 'The class GsStackBuffer implements GemStone internals. It is not intended for
customer use, by creating instances or by subclassing.

Constraints:
	next: GsStackBuffer';
		immediateInvariant.
true.
%

doit
(Array
	_newKernelSubclass:'InvariantArray'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesInvariant'  #logCreation )
	reservedOop: 70401
)
		category: nil;
		comment: 'An InvariantArray is an Array that is made to be invariant (immutable) when it
 is committed, if it is not already invariant before then.  Unless otherwise
 handled explicitly, an InvariantArray that has not yet been committed is still
 modifiable.  Array literals are always invariant; if you assign one to a
 variable, then the object to which the variable refers cannot be changed.

 Immutability implies that the Array''s size, ordering of elements, and
 element membership cannot be changed.  Thus, if an object is an element of the
 Array, that same object must remain an element of the Array, and it must remain
 located at its current index.  Immutability does not imply that the element
 object itself cannot be changed, but only that its relation to the Array is
 immutable.';
		immediateInvariant.
true.
%

removeallmethods InvariantArray
removeallclassmethods InvariantArray

doit
(Array
	_newKernelSubclass:'SymbolList'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'disallowGciStore' #'subclassesDisallowed'  #logCreation )
	reservedOop: 78593
)
		category: nil;
		comment: 'A SymbolList is an Array whose elements are instances of SymbolDictionary.

 It is used in compilation of GemStone Smalltalk code, in order to resolve
 references to objects by name.  Given a Symbol as a name, the SymbolList
 searches its dictionary elements in order, and the first key that matches the
 given Symbol then resolves to the object that is the value at that key in that
 dictionary.

 Constraints on indexable fields are enforced by behavior in this class.

Constraints:
	[elements]: SymbolDictionary';
		immediateInvariant.
true.
%

doit
(SequenceableCollection
	_newKernelByteSubclass:'ByteArray'
	classVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 103425
)
		category: nil;
		comment: 'A ByteArray is a SequenceableCollection whose elements are SmallIntegers with
 a value between zero and 255 inclusive.  Uninitialized ByteArray elements are
 zero.';
		immediateInvariant.
true.
%

doit
(ByteArray
	_newKernelSubclass:'TransientShortArray'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesNonPersistent'  #logCreation )
	reservedOop: 145921
)
		category: nil;
		comment: 'Instances of TransientShortArray may not be committed.
 Instances may have a contigous in-memory physical size
 of up to 65K bytes.  Elements are 16bit signed integers.
 Uninitialized elements are zero.';
		immediateInvariant.
true.
%

doit
(ByteArray
	_newKernelSubclass:'Utf16'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'2byteWords'  #logCreation )
	reservedOop: 158465
)
		category: nil;
		comment: 'An instance of Utf16 is a UTF-16 encoded string.
For every codePoint cp in a Utf16 the following
evaluates to true:
      cp >= 0 and:[ cp <= 16r10FFFF]
Codepoints in a Utf16 use a variable number of bytes
per codePoint, and thus only certain comparison
methods, directly supported by the libicu libraries,
are implemented.  All other string manipulation must
be done on the result of sending asUnicodeString to the
instance of Utf16, and then operating on the
equivalent Unicode7, Unicode16 or Unicode32 string.

Methods inherited from ByteArray operate on the raw bytes
of the UTF-16 encoded string, and have no support for accessing codePoints. ';
		immediateInvariant.
true.
%

doit
(ByteArray
	_newKernelSubclass:'Utf8'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 154113
)
		category: nil;
		comment: 'An instance of Utf8 is a UTF-8 encoded string.
For every codePoint cp in a Utf8 the following
evaluates to true:
      cp >= 0 and:[ cp <= 16r10FFFF]
Codepoints in a Utf8 use a variable number of bytes
per codePoint, and thus only certain comparison
methods, directly supported by the libicu libraries,
are implemented.  All other string manipulation must
be done on the result of sending asUnicodeString to the
instance of Utf8, and then operating on the
equivalent Unicode7, Unicode16 or Unicode32 string.

Methods inherited from ByteArray operate on the raw bytes
of the UTF-8 encoded string, and have no support for accessing codePoints. ';
		immediateInvariant.
true.
%

doit
(SequenceableCollection
	_newKernelSubclass:'CharacterCollection'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 80385
)
		category: nil;
		comment: 'CharacterCollection is an abstract superclass for behavior that is common
 to all indexed collections of Characters.

 Subclasses must reimplement the following selectors:

 size
 size:
 at:
 at:put:
 removeFrom:to:
 insertAll:at:

 However these selectors do not generate the subclass-responsibility error
 (error 2008) because to do so would break the Object | printString method.

--- Category:  Comparing
Some of these methods determine whether one String collates before another.
 In collation, the values of the receiver and aCharCollection are compared
 Character-by-Character, from left to right, in case-sensitive fashion.  If two
 CharacterCollections are of different length, and all Characters in the
 shorter collection are equal to their counterparts in the longer one, the
 shorter collection collates before the longer.

 Unlike the comparison methods for the superclass SequenceableCollection, these
 methods merely require that both the receiver and argument be kinds of
 CharacterCollection (rather than requiring both to be of the same class).
';
		immediateInvariant.
true.
%

doit
(CharacterCollection
	_newKernelByteSubclass:'JapaneseString'
	classVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #logCreation )
	reservedOop: 80641
)
		category: nil;
		comment: 'No longer functional.  
Use JapaneseString>>asUnicodeString to convert instances to a Unicode7 or Unicode16 . 

Deprecated in 3.0 and later, replaced by Extended Character Set support
 and DoubleByteStrings/QuadByteStings.

 This class represents behavior common to all JapaneseString classes.

 Subclasses must reimplement the following selectors:

 #size  #size: #at: #at:put:

 However these selectors do not generate the subclass-responsibility error
 (error 2008) because to do so would break Object | printString method.';
		immediateInvariant.
true.
%

doit
(JapaneseString
	_newKernelSubclass:'EUCString'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #logCreation )
	reservedOop: 80897
)
		category: nil;
		comment: 'No longer functional.  
Use JapaneseString>>asUnicodeString to convert instances to a Unicode7 or Unicode16 . 

Deprecated in 3.0 and later, replaced by Extended Character Set support
 and DoubleByteStrings/QuadByteStings.

 This class represents Japanese strings in Extended Unix Code format.';
		immediateInvariant.
true.
%

doit
(EUCString
	_newKernelSubclass:'InvariantEUCString'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #'instancesInvariant'  #logCreation )
	reservedOop: 81153
)
		category: nil;
		comment: 'Deprecated in 3.0 and later, replaced by Extended Character Set support
 and DoubleByteStrings/QuadByteStings.

 This class represents an invariant Japanese string in Extended Unix Code
 format.';
		immediateInvariant.
true.
%

doit
(InvariantEUCString
	_newKernelSubclass:'EUCSymbol'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #logCreation )
	reservedOop: 81409
)
		category: nil;
		comment: 'Deprecated in 3.0 and later, replaced by Extended Character Set support
 and DoubleByteSymbol/QuadByteSymbol.

 An EUCSymbol represents an invariant Japanese symbol in Extended Unix Code
 format.

 EUCSymbols are not canonicalized like Symbol and DoubleByteSymbol.

 An EUCSymbol may not be used as a message selector, and may not be stored
 into an instance variable constrained to hold Symbols.';
		immediateInvariant.
true.
%

removeallmethods EUCSymbol
removeallclassmethods EUCSymbol

doit
(JapaneseString
	_newKernelSubclass:'JISString'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #logCreation )
	reservedOop: 98305
)
		category: nil;
		comment: 'No longer functional.  
Use JapaneseString>>asUnicodeString to convert instances to a Unicode7 or Unicode16 . 

 JISString represents Japanese strings containing JISCharacters.  Each
 Character in a JISString occupies two bytes.';
		immediateInvariant.
true.
%

doit
(CharacterCollection
	_newKernelByteSubclass:'MultiByteString'
	classVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 136449
)
		category: nil;
		comment: 'MultiByteString is an abstract class for representing strings
 for which each Character occupies more than one byte.

 For historical reasons dealing with the now-deprecated constraints,
 MultiByteString is in the ClassHistory of String.

 Unless noted otherwise, comparisons between MultiByteStrings are
 case-sensitive.

 Some of these methods determine whether one strings collates before
 another.  In collation, the Characters of the receiver and aString are
 compared Character-by-Character, from left to right, in case-sensitive
 fashion.  If two strings are of different length, and all Characters in the
 shorter string are equal to their counterparts in the longer strings, the
 shorter string collates before the longer.

 These methods require that the argument be a kind of CharacterCollection, not
 necessarily a String.';
		immediateInvariant.
true.
%

doit
(MultiByteString
	_newKernelSubclass:'DoubleByteString'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'2byteWords'  #logCreation )
	reservedOop: 143873
)
		category: nil;
		comment: '
 A DoubleByteString is a string for which each Character occupies two bytes.
 Instances are in CPU-native byte order when in memory.

 For historical reasons dealing with the now-deprecated constraints,
 DoubleByteString is in the ClassHistory of String.

 Storing a codePoint > 16rFFFF into an instance of DoubleByteString
 will cause that object to change class to QuadByteString.

 Category: Comparision
   Unless noted otherwise, comparisons between DoubleByteStrings are
   case-sensitive.
   Some of these methods determine whether one strings collates before
   another.  In collation, the Characters of the receiver and aString are
   compared Character-by-Character, from left to right, in case-sensitive
   fashion.  If two strings are of different length, and all Characters in the
   shorter string are equal to their counterparts in the longer strings, the
   shorter string collates before the longer.

   These methods require that the argument be a kind of CharacterCollection,
   not necessarily a String.';
		immediateInvariant.
true.
%

doit
(DoubleByteString
	_newKernelSubclass:'DoubleByteSymbol'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'2byteWords' #'subclassesDisallowed'  #logCreation )
	reservedOop: 144129
)
		category: nil;
		comment: 'A DoubleByteSymbol is an invariant String for which all comparisons are
 case-sensitive.  DoubleByteSymbols are used internally to represent variable
 names and selectors.  DoubleByteSymbols are always invariant and cannot be
 modified at any time after they are created.  Hence, the new and new: methods
 are disallowed.

 All Symbols and DoubleByteSymbols are canonical, which means that it is not
 possible to create two of them that have the same value.  If two canonical
 symbols compare as equal, then they are the same (identical) object.  Every
 instance of DoubleByteSymbol will contain at least one Character whose value is
 greater than 255.  A Symbol whose Character values are all less than 256 is
 always an instance of Symbol.

 GemStone does permit you to commit a canonical Symbol.
 GemStone also gathers
 all canonical symbols into one collection (a CanonicalStringDictionary) called
 AllSymbols.

 Since canonical symbols are universally visible, it is not recommended that
 they be used for names that should remain private or secure.  Such objects
 should be instances of InvariantString instead.

 Since canonical symbols must be universally available, you cannot lock a
 Symbol or DoubleByteSymbol.

 Since each canonical symbol has a unique value, you cannot copy a Symbol or
 DoubleByteSymbol.  In addition, to guarantee canonicalization, you cannot send
 the become: or changeClassTo: messages to a Symbol or DoubleByteSymbol.

 For historical reasons dealing with the now-deprecated constraints,
 DoubleByteSymbol is in the ClassHistory of Symbol.

 EUCSymbols are not canonicalized and cannot be used interchangeably with
 canonical symbols.  They do not satisfy a constraint of Symbol, and are not
 accepted by the virtual machine as message selectors.';
		immediateInvariant.
true.
%

doit
(DoubleByteString
	_newKernelSubclass:'Unicode16'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'2byteWords'  #logCreation )
	reservedOop: 154625
)
		category: nil;
		comment: 'An instance of Unicode16 is a DoubleByteString in which all
Utf16 codePoints are representable using 16 bits.
For every codePoint cp in a Unicode16 the following evaluates to true:
   (cp >= 0 and:[ cp <= 16rD7FF ])
     or:[ cp >= 16rE000 and:[ cp <= 16rFFFF ]]
Storing a code point > 16rFFFF into a Unicode16 will cause that
object to change class to Unicode32.

String comparision controlled by (Globals at:#StringConfiguration)

  Some definitions
    Legacy strings are kinds of String or MultiByteString, but not
    kinds of Unicode7, Unicode16, nor Unicode32 .
    Unicode strings are kinds of Unicode7, Unicode16, or Unicode32

  The default is
     (Globals at: #StringConfiguration) == String
  In this mode String and MultiByteString have legacy comparison behavior.
  Comparison between legacy strings and Unicode strings will signal errors.
  Unicode strings will compare to Unicode strings using specified
  or default instances of IcuCollator.

  If at login the repository has
    (Globals at: #StringConfiguration) == Unicode16
  then legacy and Unicode strings will all compare using Unicode
  semantics using specified or default instances of IcuCollator.
  This is accomplished by installing different comparision methods
  in the transient method dictionaries for the string classes at
  session login.  See classmethods in Unicode16 for details
  of how the transient method dictionaries are initialized.
  You can observe what comparison methods are installed
  buy doing a method lookup.  For example using topaz:
   login
   obj StringConfiguration
   set class String
   look method =
   !observe String>>= implementation using primitive 27

   ! override the default StringConfiguration in this session only
   send Unicode16 _useUnicodeComparePrimitives: true

   look meth =
   !observe String>>_unicodeEqual: implementation
   logout
';
		immediateInvariant.
true.
%

doit
(MultiByteString
	_newKernelSubclass:'QuadByteString'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'4byteWords'  #logCreation )
	reservedOop: 144385
)
		category: nil;
		comment: '
A QuadByteString is a string for which each Character occupies four bytes.
Instances are in CPU-native byte order when in memory.

Most of the functionality of this class is inherited from the
superclass MultiByteString.  See the documentation there for more details';
		immediateInvariant.
true.
%

doit
(QuadByteString
	_newKernelSubclass:'QuadByteSymbol'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'4byteWords'  #logCreation )
	reservedOop: 144641
)
		category: nil;
		comment: 'A QuadByteSymbol is a Symbol based on QuadByteStrings using characters
 requiring 4 bytes to represent them.';
		immediateInvariant.
true.
%

doit
(QuadByteString
	_newKernelSubclass:'Unicode32'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'4byteWords'  #logCreation )
	reservedOop: 154881
)
		category: nil;
		comment: 'An instance of Unicode32 is a QuadByteString in which
all codePoints are legal Utf16 characters.
For every codePoint cp in a Unicode32 the following evaluates to true:
   (cp >= 0 and:[ cp <= 16rD7FF ])
     or:[ cp >= 16rE000 and:[ cp <= 16r10FFFF ]]';
		immediateInvariant.
true.
%

doit
(CharacterCollection
	_newKernelByteSubclass:'String'
	classVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 74753
)
		category: nil;
		comment: 'Instances of class String are indexed collections of Characters.

 Comparing strings:
 Unless noted otherwise, comparisons between Strings are case-sensitive.

 Some of these methods determine whether one String collates before
 another.  In collation, the ASCII values of the receiver and aString are
 compared Character-by-Character, from left to right, in case-sensitive
 fashion.  If two Strings are of different length, and all Characters in the
 shorter String are equal to their counterparts in the longer String, the
 shorter String collates before the longer.

 Converting Strings:
 Separator Characters in a String are used to define white space that separates
 words or substrings within the String from each other.  These separators are
 used in conversion to break the String into its logical substrings.  Separator
 Characters are defined as those Characters for which the
 Character>>isSeparator method returns true.

 Storing a codePoint > 16rFF into a String will cause that object to
 change class to Unicode16 if  (Unicode16 _unicodeCompareEnabled == true)
 or to change class to DoubleByteString if (Unicode16 _unicodeCompareEnabled == false).';
		immediateInvariant.
true.
%

doit
(String
	_newKernelSubclass:'InvariantString'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesInvariant'  #logCreation )
	reservedOop: 70657
)
		category: nil;
		comment: 'InvariantString is a subclass of String for which all instances are
 immutable after they are committed.';
		immediateInvariant.
true.
%

doit
(InvariantString
	_newKernelSubclass:'ObsoleteSymbol'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #logCreation )
	reservedOop: 75009
)
		category: nil;
		comment: 'The class ObsoleteSymbol is obsolete as of GemStone version 5.0 and will be
removed in a future release.

Existing instances should be migrated to String or Symbol or otherwise
processed as required, and then should be removed.';
		immediateInvariant.
true.
%

doit
(String
	_newKernelSubclass:'Symbol'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'subclassesDisallowed'  #logCreation )
	reservedOop: 110849
)
		category: nil;
		comment: 'A Symbol is an invariant String for which all comparisons are case-sensitive.
 Symbols are used internally to represent variable names and selectors.  Symbols
 are always invariant and cannot be modified at any time after they are created.
 Hence, the new and new: methods are disallowed.

 All Symbols and DoubleByteSymbols are canonical, which means that it is not
 possible to create two of them that have the same value.  If two canonical
 symbols compare as equal, then they are the same (identical) object.  Every
 instance of DoubleByteSymbol will contain at least one Character whose value is
 greater than 255.  A Symbol whose Character values are all less than 256 is
 always an instance of Symbol.

 GemStone places all canonical symbols in the DataCuratorObjectSecurityPolicy.  However,
 GemStone does permit you to commit a canonical Symbol, even if you have no
 explicit write authorization for the DataCuratorObjectSecurityPolicy.  GemStone also gathers
 all canonical symbols into one collection (a CanonicalStringDictionary) called
 AllSymbols, which it also places in the DataCuratorObjectSecurityPolicy.

 Since canonical symbols are universally visible, it is not recommended that
 they be used for names that should remain private or secure.  Such objects
 should be instances of InvariantString instead.

 Since canonical symbols must be universally available, you cannot lock a
 Symbol, DoubleByteSymbol, or QuadByteSymbol..

 Since each canonical symbol has a unique value, you cannot copy a Symbol or
 DoubleByteSymbol.  In addition, to guarantee canonicalization, you cannot send
 the become: or changeClassTo: messages to a Symbol, DoubleByteSymbol, or
 QuadByteSymbol..

 DoubleByteSymbol is in the ClassHistory of Symbol, so instances of
 DoubleByteSymbol may be stored into instance variables that are constrained to
 hold instances of Symbol.  The inverse is not true, so you should always
 express symbol constraints as Symbol.

 EUCSymbols are not canonicalized and cannot be used interchangeably with
 canonical symbols.  They do not satisfy a constraint of Symbol, and are not
 accepted by the virtual machine as message selectors.';
		immediateInvariant.
true.
%

doit
(String
	_newKernelSubclass:'Unicode7'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 154369
)
		category: nil;
		comment: 'An instance of Unicode7 is a String in which all codePoints
are 7 bit Ascii.  For every codePoint cp in a Unicode7
the following evaluates to true:
   cp >= 0 and:[ cp <= 16r7F ] 
Storing a code point > 16r7F into a Unicode7 will cause that object
to change class to a Unicode16 or a Unicode32.';
		immediateInvariant.
true.
%

doit
(SequenceableCollection
	_newKernelSubclass:'Interval'
	instVarNames: #(from to by)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 103169
)
		category: nil;
		comment: 'An Interval represents a finite arithmetic sequence.

instVar from -- Number, the initial number in the sequence.

instVar to -- Number, the last number in the sequence.

instVar by -- Number, the increment for determining the next number in the sequence.';
		immediateInvariant.
true.
%

doit
(Interval
	_newKernelSubclass:'Range'
	instVarNames: #(excludeEnd)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 129537
)
		category: nil;
		comment: '
 Range is a subclass of Interval used during Ruby execution in the
 Maglev product.

Constraints:
	from: Number
	to: Number
	by: Number
	excludeEnd: Boolean';
		immediateInvariant.
true.
%

removeallmethods Range
removeallclassmethods Range

doit
(SequenceableCollection
	_newKernelSubclass:'OrderedCollection'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 92673
)
		category: nil;
		comment: 'An OrderedCollection is a SequenceableCollection that maintains the order of
 objects it contains.  In GemStone, OrderedCollections are very similar to
 Arrays.  They differ from Arrays in that they understand all of the messages
 that Smalltalk OrderedCollections implement.';
		immediateInvariant.
true.
%

doit
(OrderedCollection
	_newKernelSubclass:'Semaphore'
	instVarNames: #(signalCount)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'disallowGciStore' #'instancesNonPersistent'  #logCreation )
	reservedOop: 115713
)
		category: nil;
		comment: 'Instances of Semaphore are used to define critical regions in
 Smalltalk processes.  Only one instance of a GsProcess will
 may execute within a critical region at a time.  Instances of
 Semaphore may not be committed to disk; they exist only for the
 life of a session, or until garbage collected.

Constraints:
	signalCount: SmallInteger';
		immediateInvariant.
true.
%

doit
(OrderedCollection
	_newKernelSubclass:'SortedCollection'
	instVarNames: #(sortBlock)
	classVars: #(DefaultSortBlock)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 92929
)
		category: nil;
		comment: 'A SortedCollection is an OrderedCollection that maintains the order of its
 elements based on a sort block.  In GemStone, SortedCollections are not fixed
 in length as in other Smalltalk systems.

 instvar sortBlock is an ExecBlock that defines the sorting criterion.  The
 block must take two arguments, and it should return true if the first
 argument should precede the second argument, and false if not.
';
		immediateInvariant.
true.
%

doit
(Collection
	_newKernelSubclass:'UnorderedCollection'
	instVarNames: #(_varyingSize _numEntries _indexedPaths _levels)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 96257
)
		category: nil;
		comment: 'UnorderedCollection is an abstract class for collections of objects whose
 elements are not logically arranged in any particular order.  The elements are
 also not physically stored in any fixed order.  Any implied ordering at any
 given time is independent of the order in which the elements were added to the
 collection and cannot be relied upon to persist.

 The elements of unordered collections are all of the same kind.  Unless
 restricted further by a subclass, the kind of elements in unordered collections
 is Object.  That is, the class of each element must simply be some kind of
 Object.

 You cannot add nil to any kind of unordered collection.  Attempts to do so have
 no effect.

 UnorderedCollection provides for fast associative access of collection elements
 in searches by means of the use of indexes with selection blocks.
 UnorderedCollection creates each index for an individual instance, where
 specified, and maintains that index thereafter unless it is removed
 explicitly.

 Indexing is done on instance variables, not on values returned by messages.
 When an index path is used as an argument to a method, it is specified by a
 String that consists of instance variable names separated by periods (such as
 the String ''instvar1.instvar2.instvar3'').  The ith name in the String
 corresponds to the ith position in the path.  A path String may include up to
 16 names and is limited to a total of 1024 Characters.

 If aPathString is an empty path (that is, a zero-length String), the method
 operates upon the elements of the receiver itself rather than upon the instance
 variables of those elements.

 For more information about index structures and path expressions, see the
 GemStone Programming Guide.

All instance variables start with an underscore and are for GemStone internal use.
';
		immediateInvariant.
true.
%

doit
(UnorderedCollection
	_newKernelSubclass:'IdentityBag'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 67329
)
		category: nil;
		comment: 'An IdentityBag is an UnorderedCollection in which any distinct object can occur
 any number of times.  Adding the same (identical) object to an IdentityBag
 multiple times simply causes it to occur multiple times in the IdentityBag.

 Since an IdentityBag is an identity-based collection, different (non-identical)
 but equivalent (equal) objects are treated as distinct from each other.  In
 Bags, they are not distinct.  Adding multiple equivalent objects to an
 IdentityBag yields an IdentityBag with multiple objects as elements, each
 occurring once.
';
		immediateInvariant.
true.
%

doit
(IdentityBag
	_newKernelSubclass:'IdentitySet'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 73985
)
		category: nil;
		comment: 'An IdentitySet is an IdentityBag in which any distinct object can occur only
 once.  Adding the same (identical) object to an IdentitySet multiple times is
 redundant.  The result is the same as adding it once.

 Since an IdentitySet is an identity-based collection, different (non-identical)
 but equivalent (equal) objects are treated as distinct from each other.  In
 Sets, they are not distinct.  Adding multiple equivalent objects to an
 IdentitySet yields an IdentitySet with as many elements as there are distinct
 equivalent objects.  In short, two different elements of an IdentitySet are
 never identical, but they may be equivalent.';
		immediateInvariant.
true.
%

doit
(IdentitySet
	_newKernelSubclass:'AbstractUserProfileSet'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'subclassesDisallowed'  #logCreation )
	reservedOop: 76801
)
		category: nil;
		comment: 'An AbstractUserProfileSet is an IdentitySet whose elements must be instances of
 class UserProfile.  You may not create subclasses or instances of
 AbstractUserProfileSet.  Only one instance of AbstractUserProfileSet is
 permitted in a GemStone repository that was upgraded from GemStone v4.1.

Constraints:
	_varyingSize: Object
	_numEntries: Object
	_indexedPaths: Object
	_levels: Object
	[elements]: UserProfile';
		immediateInvariant.
true.
%

doit
(AbstractUserProfileSet
	_newKernelSubclass:'UserProfileSet'
	instVarNames: #(userIdDictionary userSecurityData passwordAgeLimit passwordAgeWarning staleAccountAgeLimit securityBits disallowedPasswords maxPasswordSize minPasswordSize maxRepeatingChars maxConsecutiveChars maxCharsOfSameType)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 112129
)
		category: nil;
		comment: 'UserProfileSet is a concrete subclass of AbstractUserProfileSet that implements
 and enforces some account and password security features for all of its
 elements.

 Only one instance of UserProfileSet, called AllUsers, is allowed to exist,
 and is provided with a fresh GemStone server.  All UserProfiles in GemStone
 belong to this set.  AllUsers supports security features for all users.
 AllUsers also ensures uniqueness of userId Strings; no two UserProfiles can
 have the same ID.

 GemStone, as shipped from the factory, disables all the security features
 supported by AllUsers.  To activate any or all of those features, an
 administrator with the proper privileges must execute methods on AllUsers.
 Activated features can also be deactivated later by reapplying the settings
 that do not constrain GemStone''s behavior.

 Password format constraints are applied only after an administrator commits
 the changes in AllUsers.  They are then enforced only when users change their
 own passwords with the UserProfile>>oldPassword:newPassword: method, not when
 administrators or other users make changes with methods that require the
 OtherPassword privilege.  In addition, enforcement does not apply to existing
 passwords created before new constraints were committed.

Constraints:
	_varyingSize: Object
	_numEntries: Object
	_indexedPaths: Object
	_levels: Object
	userIdDictionary: StringKeyValueDictionary
	userSecurityData: StringKeyValueDictionary
	passwordAgeLimit: Number
	passwordAgeWarning: Number
	staleAccountAgeLimit: Number
	securityBits: SmallInteger
	disallowedPasswords: Set
	maxPasswordSize: SmallInteger
	minPasswordSize: SmallInteger
	maxRepeatingChars: SmallInteger
	maxConsecutiveChars: SmallInteger
	maxCharsOfSameType: SmallInteger
	[elements]: UserProfile

--- instVar disallowedPasswords
A Set of Strings that cannot be used as passwords.  The userId Strings of
 GemStone users also cannot be used as passwords, even if they do not appear in
 this Set.

--- instVar maxCharsOfSameType
A SmallInteger that gives maximum number of adjacent characters in a password
 that are permitted to have the same type (alphabetic, numeric, or special).
 Zero means there is no maximum.

--- instVar maxConsecutiveChars
A SmallInteger that gives maximum number of adjacent characters in a password
 that form an ascending or descending sequence of Character values, such as
 "123" or "fed".  Zero means there is no maximum.  Such sequences are determined
 by case-sensitive comparisons.

--- instVar maxPasswordSize
A SmallInteger that gives maximum size of new passwords.  Zero means there is
 no maximum.

--- instVar maxRepeatingChars
A SmallInteger that gives maximum number of adjacent characters in a password
 that can have the same value.  Zero means there is no maximum.  The value 1
 prevents passwords of the form aa, but not aba.

--- instVar minPasswordSize
A SmallInteger that gives minimum size of new passwords.

--- instVar passwordAgeLimit
The maximum Number of hours for which a user can retain a password.  When a
 password is set, it expires this Number of hours later.  The user must change
 the password before it expires, or else GemStone disables the account.  Once
 a password has expired, an administrator must reset the password from another
 account before the user can login again.

 Zero means there is no expiration time for passwords.  This setting may be
 overridden in indivdual UserProfiles.  Applies only to UserProfiles which use
 GemStone authentication.

--- instVar passwordAgeWarning
The maximum Number of hours prior to a password expiration time for which a
 user can login without a warning.  If the user logs in to GemStone within this
 Number of hours before the password is due to expire, GemStone issues a warning
 about the impending expiration.  This feature grants a user the opportunity to
 change the password conveniently and to prevent the account from being
 disabled.  This setting may be overridden in indivdual UserProfiles.
 Applies only to UserProfiles which use GemStone authentication.

--- instVar securityBits
A SmallInteger.  A number of bit fields encoded as a SmallInteger which
 control various security features.

--- instVar staleAccountAgeLimit
The maximum Number of hours for which a user account can remain enabled without
 a login.  Once the user logs in, he or she has up to this Number of hours to
 login again, or else GemStone disables the account.  Once the account has been
 disabled, an administrator must reset the password from another account before
 the user can login again.

 Zero means there is no expiration time for accounts.  This setting may be
 overridden in indivdual UserProfiles.  Applies only to UserProfiles which use
 GemStone authentication.

--- instVar userIdDictionary
A StringKeyValueDictionary whose keys are userId Strings and whose values are
 the UserProfiles of the instance.

--- instVar userSecurityData
The userSecurityData variable is used internally by GemStone.
';
		immediateInvariant.
true.
%

doit
(IdentitySet
	_newKernelSubclass:'ObsoleteDictionary'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #logCreation )
	reservedOop: 69633
)
		category: nil;
		comment: 'This class is obsolete. Existing instances should be migrated to Dictionary or
 otherwise processed as required, and then should be removed.';
		immediateInvariant.
true.
%

doit
(ObsoleteDictionary
	_newKernelSubclass:'ObsoleteIdentityDictionary'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #logCreation )
	reservedOop: 78337
)
		category: nil;
		comment: 'The class ObsoleteIdentityDictionary is obsolete; existing instances should
be migrated to IdentityDictionary or otherwise processed as required.';
		immediateInvariant.
true.
%

doit
(ObsoleteDictionary
	_newKernelSubclass:'ObsoleteSymbolDictionary'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #logCreation )
	reservedOop: 75521
)
		category: nil;
		comment: 'The class ObsoleteSymbolDictionary is obsolete as of GemStone version 5.0 and
will be removed in a future release.

Existing instances should be migrated to SymbolDictionary or otherwise
processed as required, and then should be removed.';
		immediateInvariant.
true.
%

doit
(ObsoleteSymbolDictionary
	_newKernelSubclass:'ObsoleteLanguageDictionary'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #logCreation )
	reservedOop: 70913
)
		category: nil;
		comment: 'Existing instances should be migrated to LanguageDictionary or otherwise
 processed as required, and then should be removed.';
		immediateInvariant.
true.
%

doit
(IdentitySet
	_newKernelSubclass:'ObsoleteSymbolSet'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #logCreation )
	reservedOop: 75777
)
		category: nil;
		comment: 'The class ObsoleteSymbolSet is obsolete as of GemStone version 5.0 and will be
removed in a future release.

Existing instances should be migrated to SymbolSet or otherwise processed as
required, and then should be removed.';
		immediateInvariant.
true.
%

doit
(IdentitySet
	_newKernelSubclass:'SymbolSet'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 113921
)
		category: nil;
		comment: 'A SymbolSet is an IdentitySet whose elements must be canonical symbols
 (Symbols or DoubleByteSymbols).

Constraints:
	_varyingSize: Object
	_numEntries: Object
	_indexedPaths: Object
	_levels: Object
	[elements]: Symbol';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelIndexableSubclass:'CompiledMethod'
	instVarNames: #(inClass byteCodes sourceString selectorPool methodType index nArgs stackBase stackSize selector ipSteps sourceOffsets argsAndTemps blockIps language requiresVC blockPool)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #'instancesInvariant' #'subclassesDisallowed'  #logCreation )
	reservedOop: 69121
)
		category: nil;
		comment: 'CompiledMethod is an obsolete class.  Instances are methods that
 were compiled and committed before Gemstone/S 32bit v5.x .
 Any such instances must be recompiled to create instances of GsNMethod
 before they can be executed.';
		immediateInvariant.
true.
%

removeallmethods CompiledMethod
removeallclassmethods CompiledMethod

doit
(Object
	_newKernelSubclass:'CPointer'
	instVarNames: #(derivedFrom)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'disallowGciStore'  #logCreation )
	reservedOop: 134145
)
		category: nil;
		comment: 'A CPointer encapsulates a C pointer  which does not have auto-free
semantics.  New instances are created by CFunction calls with result
type #ptr,  and are also used for certain arguments of CFunctions.

   instVars
      derivedFrom,    nil, or a CByteArray or a CPointer.  If non-nil,
         a CByteArray or CPointer from which this object was derived;
         this instVar keeps the referenced object alive while this
         object is alive.
';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelSubclass:'CZstream'
	instVarNames: #(buffer bufSize comprBuffer comprSize forWrite ioObj errorClass header comprOffset)
	classVars: #(ComprBufSize HalfComprBufSize)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'disallowGciStore'  #logCreation )
	reservedOop: 145153
)
		category: nil;
		comment: '
A CZstream encapsulates the state of a zstream from zlib.so ,
and associates that zstream with an IO object.

 InstVars
   buffer - a String < 16K bytes
   bufSize - a SmallInteger
   comprBuffer - a String or ByteArray < 16K bytes
   comprSize - a SmallInteger , only used for output streams
   forWrite  - a Boolean
   ioObj       - an instance of IO (a GsSocket or GsFile)
   errorClass  - a subclass of Exception used to signal errors
   header - gzip header of a file, when reading
   comprOffset a SmallInteger , only used for output streams

   hidden instVar cData is an instance of struct z_stream_s  per zlib.h ,
   which will be automatically freed when this object is GC''ed

Constraints:
	buffer: String
	bufSize: SmallInteger
	comprBuffer: ByteArray
	comprSize: SmallInteger
	forWrite: Boolean
	ioObj: IO
	errorClass: AbstractException
	header: Array
	comprOffset: SmallInteger
';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelSubclass:'Delay'
	instVarNames: #(interval signalTime target)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'disallowGciStore'  #logCreation )
	reservedOop: 115969
)
		category: nil;
		comment: 'Delay is used in conjunction with GsProcess and ProcessorScheduler
 to suspend processes for specified amounts of time, and to resume
 processes.
 The in-memory state of a committed Delay is not changed by a transaction abort.

Constraints:
	interval: Integer     (units milliseconds)
	signalTime: Integer   (units milliseconds)
	target: Object';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelIndexableSubclass:'ExceptionSet'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'subclassesDisallowed'  #logCreation )
	reservedOop: 130049
)
		category: nil;
		comment: 'This protocol describes the behavior of objects that may be
used to group a set of <exceptionSelector> objects into a
single <exceptionSelector>. This is useful for establishing
a single exception handler that may deal with several different
types of exceptions.

Subclasses are disallowed .

Instances conform to exceptionSelector and Object.';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelSubclass:'GsCompilerIRNode'
	instVarNames: #(kind srcOffset lineNumber)
	classVars: #(Bc_INVALID_0 Bc_IS_NIL Bc_NOT_NIL Bc_SEND_SPECIAL_bitAnd_u1_u32 Bc_SEND_SPECIAL_EQEQ Bc_SEND_SPECIAL_GTE_u1_u32 Bc_SEND_SPECIAL_ISKINDOF Bc_SEND_SPECIAL_IS_Array Bc_SEND_SPECIAL_IS_ExceptionClass Bc_SEND_SPECIAL_IS_ExecBlock Bc_SEND_SPECIAL_IS_FLOAT Bc_SEND_SPECIAL_IS_INTEGER Bc_SEND_SPECIAL_IS_NUMBER Bc_SEND_SPECIAL_IS_OneByteString Bc_SEND_SPECIAL_IS_Range Bc_SEND_SPECIAL_IS_ScaledDecimal Bc_SEND_SPECIAL_IS_SMALLINT Bc_SEND_SPECIAL_IS_SYMBOL Bc_SEND_SPECIAL_Lte_u1_u32 Bc_SEND_SPECIAL_LT_u1_u32 Bc_SEND_SPECIAL_MINUS_u1_u32 Bc_SEND_SPECIAL_MULTIPLY_u1_u32 Bc_SEND_SPECIAL_NENE Bc_SEND_SPECIAL_nonZeroGTE_u1_u32 Bc_SEND_SPECIAL_PLUS_u1_u32 Bc_SEND_SPECIAL_stringCharSize Bc_SEND_VALUE_u1_u32 Bc_SEND_yourself COMPAR_AND_SELECTOR COMPAR_ARRAY_BUILDER_NODE COMPAR_ARRAY_LIT COMPAR_ASSIGNMENT_NODE COMPAR_ASSOC_LIT COMPAR_BLOCK_ARG_VAR COMPAR_BLOCK_NODE COMPAR_BLOCK_TEMP_VAR COMPAR_CASCADE_NODE COMPAR_CHAR_LIT COMPAR_DECIMAL_FLT_LIT COMPAR_FixedPoint_LIT COMPAR_FLT_LIT COMPAR_FOREVER_repeat COMPAR_GOTO_NODE COMPAR_IF_FALSE_IF_TRUE COMPAR_IF_NIL COMPAR_IF_NIL_IF_NOTNIL COMPAR_IF_NOTNIL_IF_NIL COMPAR_IF_NOT_NIL COMPAR_IF_TRUE_IF_FALSE COMPAR_INT_LIT COMPAR_LABEL_NODE COMPAR_LIT_LEAF COMPAR_LIT_NODE COMPAR_LIT_VAR COMPAR_LOOP_NODE COMPAR_METHOD_ARG_VAR COMPAR_METHOD_LIT COMPAR_METHOD_NODE COMPAR_METHOD_TEMP_VAR COMPAR_METH_VC_GLOBAL COMPAR_NO_OPTIMIZATION COMPAR_OR_SELECTOR COMPAR_PATH_NODE COMPAR_RETURN_NODE COMPAR_RUBY_COPYING_STR_LIT COMPAR_SCALED_DEC_LIT COMPAR_SELECTOR_LEAF COMPAR_SELF_VAR COMPAR_SEND_NODE COMPAR_SPECIAL_LIT COMPAR_STATEMENTS_NODE COMPAR_STR_LIT COMPAR_SUPER_VAR COMPAR_SYM_LIT COMPAR_TERM_NODE COMPAR_TIMES_REPEAT COMPAR_TO_BY_DO COMPAR_TO_DO COMPAR_UNTIL_FALSE COMPAR_UNTIL_FALS_COLON COMPAR_UNTIL_TRUE COMPAR_UNTIL_TRU_COLON COMPAR_VAR_LEAF COMPAR_VAR_NODE COMPAR_WHILE_FALSE COMPAR_WHILE_TRUE COMPAR__DOWNTO_BY_DO COMPAR__DOWNTO_DO COMPAR__IF_FALSE COMPAR__IF_TRUE COMPAR__INST_VAR COM_GOTO_BREAK COM_GOTO_NEXT COM_GOTO_REDO COM_GOTO_RETRY COM_RTN_FROM_HOME COM_RTN_NORMAL COM_RTN_NORMAL_SELF COM_RUBY_COMPAT_LEVEL)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: GsCompilerClasses
	options: #( #logCreation )
	reservedOop: 240897
)
		category: nil;
		comment: '
 GsCompilerIRNode  is the abstract superclass of all classes used
 to implement nodes of the IR graph which is input to the
 code generator comgen.c  in Gemstone64 v3.0.   The instVars are:

  kind      , a SmallInteger, per ComIRNodeEType
  srcOffset, a SmallInteger , 1-based character position in the source , or nil .
  lineNumber, a SmallInteger, optional 1-based line number in the source,
                              or -1 or nil if unknown
         with Smalltalk parser lineNumber used for debugging compiler and slow filein
         with Ruby parser written in Ruby , lineNumber only used to hold
         starting line of a  GsComMethNode .

  See comments for GsComMethNode for more details on srcOffset and lineNumber.

 In the documentation of subclasses,
    a non-leaf GsCompilerIRNode
 means instance of any subclass
 except GsComLitLeaf, GsComSelectorLeaf, GsComVarLeaf

 The class variables for GsCompilerIRNode include symbolic names
 for the various COMPAR, COM_RTN, and Bc_ constants used in
 instance methods in subclasses.  The class variables are populated
 at server image build by the code in src/bom.c , from constants in
 src/comparse.ht and src/bytecode.ht .
';
		immediateInvariant.
true.
%

doit
(GsCompilerIRNode
	_newKernelSubclass:'GsComArrayBuilderNode'
	instVarNames: #(elements)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: GsCompilerClasses
	options: #( #logCreation )
	reservedOop: 241409
)
		category: nil;
		comment: 'A GsComArrayBuilderNode represents a non-literal array construction ,
 example:  { 1 , 2 , 3 }

 instVars
   elements, an Array ,
          each element is a non-leaf GsCompilerIRNode
           for an expression which produces an element of the array.

 The generator emits code to execute each element expression, pushing
 each element on the stack and then emits an array constructor bytecode.
';
		immediateInvariant.
true.
%

doit
(GsCompilerIRNode
	_newKernelSubclass:'GsComAssignmentNode'
	instVarNames: #(dest source assignKind destSrcOffset)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: GsCompilerClasses
	options: #( #logCreation )
	reservedOop: 241665
)
		category: nil;
		comment: 'A  GsComAssignmentNode represents an assignment operator , Smalltalk :=

    dest  ,  a GsComVarLeaf ,  the destination variable or temp
    source , a non-leaf GsCompilerIRNode , the source expression

    assignKind , a SmallInteger , 0 = normal, 1 = ruby method arg default value,
                    not accessed by the code generator for Smalltalk methods.
    destSrcOffset   source offset, typically position in source of the :=  token .
';
		immediateInvariant.
true.
%

doit
(GsCompilerIRNode
	_newKernelSubclass:'GsComBlockNode'
	instVarNames: #(lexLevel lastSrcOffset blkKind args lastArgInfo temps statements terms)
	classVars: #(HasBlockArg_mask LastArgInfo_mask LastArgStar_mask NoDeclaredArgs_mask)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: GsCompilerClasses
	options: #( #logCreation )
	reservedOop: 241921
)
		category: nil;
		comment: 'A GsComBlockNode represents a block within a method. It may be
 either a real block or a block that will be inlined by the parser.

   lexLevel, a SmallInteger > 0, lexical level of the block within the
                source of the home method, without regard to inlining.
   lastSrcOffset,  end of the source for the block within the method,
          a byteOffset if srcOffset is non-nil, otherwise a line number.
   blkKind, a SmallInteger,  a ComBlockEKind ,
     0 normal block, 1 Smalltalk select:{} block;  always 0 for Ruby .
   args, each element is a GsComVarLeaf
   lastArgInfo , a SmallInteger
   temps, an Array , each element is a GsComVarLeaf
   statements ,an Array or OrderedCollection ,  the body of the block
   terms  , an Array, used only with blkKind==1 .

';
		immediateInvariant.
true.
%

doit
(GsCompilerIRNode
	_newKernelSubclass:'GsComCascadeNode'
	instVarNames: #(rcvr sends)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: GsCompilerClasses
	options: #( #logCreation )
	reservedOop: 242177
)
		category: nil;
		comment: 'A GsComCascadeNode represents a Smalltalk style cascaded message send
 such as
   anObj m1 ; m2 ; m3 .

 instVars
    rcvr , a non-leaf GsCompilerIRNode
    sends, an Array , each element is a GsComSendNode
';
		immediateInvariant.
true.
%

doit
(GsCompilerIRNode
	_newKernelSubclass:'GsComGotoNode'
	instVarNames: #(target argNode argForValue targetKind)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: GsCompilerClasses
	options: #( #logCreation )
	reservedOop: 244993
)
		category: nil;
		comment: 'GsComGotoNode represents an unconditional jump within the current
 method, and may be used in the implementation of
 Ruby break/next/redo/retry where the affected loop is within the
 same method as the break/next/redo/retry .

 instVars are
   target -  a GsComLabelNode  for a goto within a method
             nil for a non-local goto
   argNode a GsCompilerIRNode, or nil
   argForValue, a Boolean, if true evaluate argNode for value, if false for effect
   targetKind , a ComParGotoKind
';
		immediateInvariant.
true.
%

doit
(GsCompilerIRNode
	_newKernelSubclass:'GsComLabelNode'
	instVarNames: #(argForValue lexLevel)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: GsCompilerClasses
	options: #( #logCreation )
	reservedOop: 244737
)
		category: nil;
		comment: 'GsComLabelNode represents the target of a Ruby goto,
  or of a Ruby break/next/redo/retry .  A break/next/redo/retry
  whose target is within the same method  is  the same as a goto .

 instVars are
   argForValue - a boolean , tells whether arg to a break/next
      should be evaluated for value or for effect.

   lexLevel , a SmallInteger , lexical level of this label
';
		immediateInvariant.
true.
%

doit
(GsCompilerIRNode
	_newKernelSubclass:'GsComLiteralNode'
	instVarNames: #(leaf)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: GsCompilerClasses
	options: #( #logCreation )
	reservedOop: 241153
)
		category: nil;
		comment: ' A GsComLiteralNode represents a push or load of the literal specified
  by the leaf instVar

    leaf , a GsComLitLeaf
';
		immediateInvariant.
true.
%

doit
(GsCompilerIRNode
	_newKernelSubclass:'GsComLitLeaf'
	instVarNames: #(stringForm litValue litKind)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: GsCompilerClasses
	options: #( #logCreation )
	reservedOop: 243969
)
		category: nil;
		comment: 'GsComLitLeaf  represents a literal leaf , and has these instVars:

  stringForm , a String  ,   the source form of the literal reference ,
                     stringForm is nil if literal is a GsNMethod (for Ruby)
  litValue   , an Object ,   the value of the literal
  litKind    , SmallInteger   , a ComParLitEtype

 A GsComLitLeaf is typically referenced by a GsComLiteralNode
 thus allowing canonicalization of literal references, if the
 Parser maintains a dictionary, keyed on string source form of a literal
 and with values being instances of GsComLitLeaf.

 stringForm and litValue are provided separately in case a parser wants
 to do conversions such as string to numeric during a second pass.  The
 generator only looks at litValue , and the stringForm is present in the IR
 graph for use in debugging the parser or generator.
 The generator may change litValue to a canonicalize zero sized
 literal arrays or strings, such as  Smalltalk  #() , ''''  .
 In 64bit Gemstone,  the float 0.0  is a SmallDouble and no longer needs
 canonicalization.

 The instance initializer methods assume the parser would like
 to pass the string form of numeric literal, and have the class library
 convert from String to numeric form immediately.  String to numeric
 conversion could generate errors if the parser does not catch all illegal
 floating point formats, etc.   So if the parser did not want to worry
 about errors during numeric conversion, it might want other methods
 to trigger numeric conversion later ...

 The following numeric literals are not supported yet by the initializer methods:
   COMPAR_SCALED_DEC_LIT ,   ScaledDecimal, assume not needed by Ruby
   COMPAR_DECIMAL_FLT_LIT ,  DecimalFloat, assume not needed by Ruby
   COMPAR_FixedPoint_LIT ,   FixedPoint  , assume not needed by Ruby

 The symbolic names of ComParLitEtype are available as
 class variables in GsCompilerIRNode .
 typedef enum {
  COMPAR_CHAR_LIT = 0,
  COMPAR_INT_LIT = 1,
  COMPAR_SYM_LIT = 2,
  COMPAR_SPECIAL_LIT = 3,
  COMPAR_FLT_LIT = 4,
  COMPAR_SCALED_DEC_LIT = 5,
  COMPAR_DECIMAL_FLT_LIT = 6,
  COMPAR_STR_LIT = 7,
  COMPAR_ARRAY_LIT = 8,
  COMPAR_METHOD_LIT = 9,   // generic object used as a literal, for Ruby
  COMPAR_RUBY_COPYING_STR_LIT = 10 ,
  COMPAR_ASSOC_LIT = 11,   // Assocation or RubyConstRef literal
  COMPAR_BYTEARRAY_LIT = 12,
  COMPAR_FixedPoint_LIT = 13
 }   ComParLitEtype;
';
		immediateInvariant.
true.
%

doit
(GsCompilerIRNode
	_newKernelSubclass:'GsComLoopNode'
	instVarNames: #(send breakLabel iterResult)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: GsCompilerClasses
	options: #( #logCreation )
	reservedOop: 246529
)
		category: nil;
		comment: 'A GsComLoopNode encapsulates a Ruby while or until loop.
 The Smalltalk parser does not create instances of GsComLoopNode.

 instVars are
    send         a GsComSendNode , the send of whileTrue: or whileFalse:
    breakLabel,  a GsComLabelNode , the target of a possible Ruby break or nil .
    iterResult, a GsCompilerIRNode, literal result of in-line for loop, or nil
';
		immediateInvariant.
true.
%

doit
(GsCompilerIRNode
	_newKernelSubclass:'GsComMethNode'
	instVarNames: #(fileName endSrcOffset nonBridgeSelector selector theClass arguments temps body methInfo rubyInfo source rubyOptArgsBits)
	classVars: #(DefaultReturnArgNum_mask DefaultReturnArgNum_shift Env_mask GEN_MAX_RubyFixedArgs IsBridge_mask IsPrivate_mask IsProtected_mask IsRubyEval_mask LineNumberBias_mask Ruby_mask)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: GsCompilerClasses
	options: #( #logCreation )
	reservedOop: 243457
)
		category: nil;
		comment: 'A GsComMethNode represents a single method in the Smalltalk sense.
 It can be an anonymous method, as for a  doit .  For each GsComMethNode,
 A GsComMethNode is the root node of the IR graph for each invocation of
 the code generator .
 The generator emits one or more instances of GsNMethod, one for the
 home method of this node, and one for any non-inlined blocks within the method.
 The instVars are

    selector, a Symbol , or nil for an anonymous method.
    theClass, a Behavior, class in which method is to be an instanceMethod,
                may be nil for an anonymous method.  Note generator does not
                install method in method dictionary.
    arguments, an Array , each element is a GsComVarLeaf
    temps    , an Array , each element is a GsComVarLeaf
    body     , an Array , each element is a GsCompilerIRNode for a statement
    methInfo , a SmallInteger , 0 for a ruby method .
        bit masks of the fields are
            requiresVc 16rFF (not used by smalltalk, 0=no, 1=yes,
              2=force all temps to be allocated in Vc, and copy all args to VC)
            protectedType 16rFF00 (Smalltalk base image code security)
            primNumber 16rFFFF0000 (short, a Smalltalk primitive number)
    rubyInfo , a SmallInteger
        bit masks of the fields are  (per comparse.ht)
		envId        16rFF default env for sends in this method
		isRuby      16r100 (1 in Ruby, 0 in smalltalk)
		isPrivate   16r200
		isProtected 16r400
		isEval      16r800
          lineNumBias 16rFFFFFF000
          isBridge   16r1000000000
                   16rFF0000000000  defaultReturnArgNumber (1-based)
        If isBridge bit is true, then a bridge method is generated,
        and except for sends of variants of #call within bridge methods for
        ExecBlock, all message sends other than to super will use SEND_CURRENT
        bytecode.
        If defaultReturnArgNumber is non zero, then default return value
        is that argument instead of value of the last statement.

    rubyOptArgsBits, a SmallInteger ,  used to hold sourceOffset of
        the primitive bytecode or start of non-primitive method .

    nonBridgeSelector,   a Symbol or nil,

    source, a String, the source code for the method, to be saved in the
          debug information for the generated method.

    fileName, a String, name of a Ruby source file , or nil.

    endSrcOffset,  1-based, if non-nil defines the end srcOffset within a Ruby
       source file for this method, and beginning source offset
       defined by this nodes" srcOffset maybe > 1 , and sourceString
       is expected to be for an entire file.

    lineNumber is one-based .
      For Smalltalk IR trees generated by comparse.c , lineNumber is
      for use in debugging the compiler, and debug info is generated from
      the srcOffset only.
      For Ruby IR trees ,
      lineNumber in a GsComMethNode is used to generate a comment
      in the source string for the method about where in the source file
      it came from.  The sourceString in the GsComMethNode may be a source
      string for an entire file, and the generator will carve out of that source
      string the bytes from MethNode.srcOffset to methNode.endSrcOffset ,
      and append a comment with  methNode.lineNumber and methNode.fileName
      to the end of the carved out string.
';
		immediateInvariant.
true.
%

doit
(GsCompilerIRNode
	_newKernelSubclass:'GsComPathNode'
	instVarNames: #(rcvr instVars)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: GsCompilerClasses
	options: #( #logCreation )
	reservedOop: 243713
)
		category: nil;
		comment: ' A GsComPathNode is used when compiling A Gemstone Smalltalk
  select block,  which is a Smalltalk block of the form {:x | ...  }

  Instances should not be generated by the Ruby parser.
';
		immediateInvariant.
true.
%

doit
(GsCompilerIRNode
	_newKernelSubclass:'GsComReturnNode'
	instVarNames: #(expr returnKind)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: GsCompilerClasses
	options: #( #logCreation )
	reservedOop: 242689
)
		category: nil;
		comment: ' A GsComReturnNode represents a return from a method or block

    expr,   a non-leaf GsCompilerIRNode

    returnKind, a SmallInteger
        0 means normal return from method or block
        1 means Smalltalk return-from-home (same as 0 if at lexLevel 0)
        2 means Ruby ''break'' in block; return to caller of caller

';
		immediateInvariant.
true.
%

doit
(GsCompilerIRNode
	_newKernelSubclass:'GsComSelectorLeaf'
	instVarNames: #(selector specialOpcode specialSendClass)
	classVars: #(SpecialISAselectors SpecialObjectSends SpecialSendsDict)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: GsCompilerClasses
	options: #( #logCreation )
	reservedOop: 244225
)
		category: nil;
		comment: ' A GsComSelectorLeaf represents the selector used in a message send.
  instVars are
    selector,  a Symbol
    specialOpcode , a SmallInteger
    specialSendClass , a Behavior

  If specialOpcode is non-zero the send may be optimizable
  to a special bytecode.  We could have the generator (comgen.c) make
  this determination; currently  the parser determines what is optimizable.
  example:    ==  sent to any Smalltalk object is a special bytecode ,
                not a normal send .

  The parser is disallowing redefinition of some methods in the base
  Smalltalk classes if you are not logged into the Repository as SystemUser .

  Some selector leafs may be initialized at start of parsing and kept
  in a dictionary of special sends, etc.
  These instances will have srcOffset == 1.

  For the optimizable sends,  specialSendClass
    can be Object  for a send such as     ==
    can be  ExecBlock  for sends like   value:
    can be SmallInteger for  sends like    +     , etc .
  otherwise specialSendClass is nil .

  The Smalltalk parser uses a dictionary with keys being
  special selectors, and values being instances of GsComSelectorLeaf
  for the special sends .

  A Smalltalk parser as a minimum should generate selector leafs with
  nonzero specialOpcode as follows
  selector  specialSendClass  specialOpcode
    ==       Object           Bc_SEND_SPECIAL_EQEQ
    ~~       Object           Bc_SEND_SPECIAL_NENE
    +        SmallInteger     Bc_SEND_SPECIAL_PLUS_u1_u32
    -        SmallInteger     Bc_SEND_SPECIAL_MINUS_u1_u32
    *        SmallInteger     Bc_SEND_SPECIAL_MULTIPLY_u1_u32
    bitAnd:  SmallInteger     Bc_SEND_SPECIAL_bitAnd_u1_u32
    bitXor:  SmallInteger     Bc_SEND_SPECIAL_bitXor_u1_u32

  Sends of 0 to 5 arg value(s) to ExecBlocks are optimizable as
    value
    ...
    value:value:value:value:value:
              ExecBlock       Bc_SEND_VALUE_u1_u32

   The following special selectors are also of interest to
   a Smalltalk parser
    isKindOf:        Object   Bc_SEND_SPECIAL_ISKINDOF
    _isSmallInteger  Object   Bc_SEND_SPECIAL_IS_SMALLINT
    _isSymbol  	     Object   Bc_SEND_SPECIAL_IS_SYMBOL
    _isInteger       Object   Bc_SEND_SPECIAL_IS_INTEGER
    _isNumber        Object   Bc_SEND_SPECIAL_IS_NUMBER
    _isFloat         Object   Bc_SEND_SPECIAL_IS_FLOAT
    _isScaledDecimal Object   Bc_SEND_SPECIAL_IS_ScaledDecimal
    _isExceptionClass Object  Bc_SEND_SPECIAL_IS_ExceptionClass
    _isExecBlock     Object   Bc_SEND_SPECIAL_IS_ExecBlock
    _isArray         Object   Bc_SEND_SPECIAL_IS_Array
    _isOneByteString Object   Bc_SEND_SPECIAL_IS_OneByteString
    _stringCharSize  Object   Bc_SEND_SPECIAL_stringCharSize

   The following special selectors should only be used in
   the base image .
   __inProtectedMode  Bc_SEND_SPECIAL_IN_PROTECTED
   _leaveProtectedMode  Bc_EXIT_PROTECTED_MODE
   _gsReturnNoResult  Bc_RETURN_NOTHING
   _gsReturnNothingEnableEvents Bc_RETURN_NOTHNG_ENABLE_EVENTS

   There are a few other special selectors of interest to a Ruby parser.
';
		immediateInvariant.
true.
%

doit
(GsCompilerIRNode
	_newKernelSubclass:'GsComSendNode'
	instVarNames: #(rcvr selLeaf arguments controlOp envFlags)
	classVars: #(ATRUBY_MASK BypassProtection_MASK ControlOpDict ENVID_MASK EvalLastArgFirst_MASK)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: GsCompilerClasses
	options: #( #logCreation )
	reservedOop: 242945
)
		category: nil;
		comment: ' A  GsComSendNode represents a message send, instVars are:

    rcvr,    a non-leaf GsCompilerIRNode , the receiver expression,
              can be nil if this GsComSendNode is part of a cascade .
    selLeaf,  a Symbol or a  GsComSelectorLeaf
    arguments, an Array , each element
                is the non-leaf GsCompilerIRNode for an argument expression
    controlOp, a SmallInteger , a ComParCtlOpEType
    envFlags,  a SmallInteger
       bits 16rFF  - message send environmentId 0..255 (0 for Smalltalk, 1 for Ruby)
           16r100  -  during args evaluation, evaluate last arg first (ruby block_pass)
          16r1000  -  bypass ruby method protection checks for this send
         16r10000  - environmentId is from an @rubyN:

    If envFlags specifies message send environment == 1 and
    the parent GsComMethNode.rubyInfo has isRuby == 1,
    then the GsComMethNode.environment is used as the actual environmentId
    for the send.

    controlOp is used to trigger the optimization of certain kinds of
    blocks as in-line code,  and to convert certain sends like ifTrue:
    to a special branch bytecode . It must be specified by the parser,
    or installed by executing GsComSendNode >> optimizeIfPossible
    after the GsComSendNode is fully initialized.

    The symbolic names of ComParCtlOpEType are available as
    class variables in GsCompilerIRNode .
    typedef enum { /* from comparse.ht*/
      COMPAR_NO_OPTIMIZATION = 0,
      COMPAR__IF_TRUE = 1,
      COMPAR__IF_FALSE = 2,
      COMPAR_IF_TRUE_IF_FALSE = 3,
      COMPAR_IF_FALSE_IF_TRUE = 4,
      COMPAR_underscOR_SELECTOR_unused = 5,
      COMPAR_underscAND_SELECTOR_unused = 6,
      COMPAR_OR_SELECTOR = 7,          // or:
      COMPAR_AND_SELECTOR = 8,         // and:
      COMPAR_WHILE_FALSE = 9,
      COMPAR_WHILE_TRUE = 10,
      COMPAR_UNTIL_FALSE = 11,
      COMPAR_UNTIL_TRUE = 12,
      COMPAR_TO_DO = 13,
      COMPAR_TO_BY_DO = 14,
      COMPAR_TIMES_REPEAT = 15,
      COMPAR__DOWNTO_DO = 16,
      COMPAR__DOWNTO_BY_DO = 17,
      COMPAR_FOREVER_repeat = 18,
      COMPAR_IF_NIL_IF_NOTNIL = 19,
      COMPAR_IF_NOTNIL_IF_NIL = 20,
      COMPAR_IF_NIL = 21,
      COMPAR_IF_NOT_NIL = 22,
      COMPAR_UNTIL_FALS_COLON = 23,
      COMPAR_UNTIL_TRU_COLON = 24
    }   ComParCtlOpEType;
';
		immediateInvariant.
true.
%

doit
(GsCompilerIRNode
	_newKernelSubclass:'GsComStatementsNode'
	instVarNames: #(list)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: GsCompilerClasses
	options: #( #logCreation )
	reservedOop: 246785
)
		category: nil;
		comment: 'A GsComStatementsNode encapsulates an array of IR nodes

 instVars are
    list       an Array of GsCompilerIRNode''s , of size >= 1
';
		immediateInvariant.
true.
%

doit
(GsCompilerIRNode
	_newKernelSubclass:'GsComTermNode'
	instVarNames: #(left right comparator)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: GsCompilerClasses
	options: #( #logCreation )
	reservedOop: 242433
)
		category: nil;
		comment: '
 GsComTermNode instances are referenced by a GsComPathNode .

  Instances should not be generated by the Ruby parser.
';
		immediateInvariant.
true.
%

doit
(GsCompilerIRNode
	_newKernelSubclass:'GsComVariableNode'
	instVarNames: #(leaf)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: GsCompilerClasses
	options: #( #logCreation )
	reservedOop: 243201
)
		category: nil;
		comment: ' A GsComVariableNode node represents a fetch from a
  an argument, temporary , or literal variable.

  instVars are
     leaf  , a GsComVarLeaf
';
		immediateInvariant.
true.
%

doit
(GsCompilerIRNode
	_newKernelSubclass:'GsComVarLeaf'
	instVarNames: #(varName litVarAssoc varKind lexLevel varOffset)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: GsCompilerClasses
	options: #( #logCreation )
	reservedOop: 244481
)
		category: nil;
		comment: 'a GsComVarLeaf   represents a method arg or temp, a block arg or temp,
                an instance variable , or a literal variable,
                or a reference to self or super

  varName ,  a Symbol  , the name of the variable
  litVarAssoc , an Association , non-nil only for a literal variable
  varKind    , a SmallInteger, a ComParVarEType
  lexLevel   , a SmallInteger,  the lexical level in terms of block scoping ,
         0 means the home method, 1 is first block level
         parser increments its lexLevel when entering both normal and in-lined blocks

  varOffset  is -1 for a dynamic instVar
                 0 for self or super
                 0 for a literal variable
                 zero-based offset into the instVars for an instance variable,
                 zero-based offset into the method or block args for an arg ,
                 0 for a method or block temp ( generator will assign an offset)

  for a Smalltalk literal variable,  varName is the key in the Association

  The parser is responsible for canonicalizing all references to a given
  arg, temp or instVar  within a method to be references to the same
  GsComVarLeaf.
  Thus multiple GsComVariableNode''s may reference a single GsComVarLeaf,
  within a single compilation.

  The symbolic names of ComParVarEType are available as
  class variables in GsCompilerIRNode .
  typedef enum {
    COMPAR_METHOD_TEMP_VAR = 0,
    COMPAR_BLOCK_TEMP_VAR = 1,
    COMPAR_METH_VC_GLOBAL_notUsed = 2,  /* ruby $_ or $~ , not used for Smalltalk */
    COMPAR__INST_VAR = 3,
    COMPAR_LIT_VAR = 4,
    /* COMPAR_LIT_VAR_SPECIAL_LITERAL = 5, obsolete, not supported by code generator*/
    COMPAR_BLOCK_ARG_VAR = 6,
    COMPAR_SELF_VAR = 7,
    COMPAR_SUPER_VAR = 8,
    COMPAR_METHOD_ARG_VAR = 9
  }   ComParVarEType;
';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelSubclass:'GsExceptionHandler'
	instVarNames: #(next exClass number theBlock subtype)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'subclassesDisallowed'  #logCreation )
	reservedOop: 130561
)
		category: nil;
		comment: 'Instances of GsExceptionHandler represent legacy Gemstone exception
 handlers or ANSI default (i.e. static) handlers.
 Legacy handlers are created by
   Exception(C)>>category:number:do:
   Exception(C)>>installStaticException:category:number:subtype:
   Exception(C)>>addDefaultHandler:
 ANSI default handlers are created by
   Exception(C)>>addDefaultHandler:
 Subclasses of GsExceptionHandler are disallowed.

Constraints:
	next: GsExceptionHandler
	exClass: AbstractException
	number: SmallInteger
	theBlock: ExecBlock
	subtype: Object';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelSubclass:'GsFileStat'
	instVarNames: #(atime blksize blocks ctime dev gid ino mode mtime nlink rdev size uid)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 137985
)
		category: nil;
		comment: '
An instance of GsFileStat contains the results of an operating system fstat()
call for an instance of GsFile.

The instance variables are as follows, all values should be SmallIntegers.
Values of type time_t are in seconds since 00:00:00 UTC, Jan. 1, 1970 .
     atime      time_t of last access
     blksize    perferred IO block size in bytes
     blocks     number of 512 byte blocks allocated for the file
     ctime      time_t of last file status change
     dev        ID of device containing directory entry for the file
     gid        Group ID of file''s group
     ino        Inode number
     mode       Filemode (see mknod(2)
     mtime      time_t of last data modification
     nlink      Number of links
     rdev       ID of device (only valid for char special or block special files)
     size       File size in bytes
     uid        User ID of the file''s owner

See class GsFile for methods which return instances of GsFileStat.
Instances of GsFileStat represent the state of a GsFile at the point
when the instance of GsFileStat  was created and do not reflect subsequent
changes to the underlying file.

Constraints:
	atime: SmallInteger
	blksize: SmallInteger
	blocks: SmallInteger
	ctime: SmallInteger
	dev: SmallInteger
	gid: SmallInteger
	ino: SmallInteger
	mode: SmallInteger
	mtime: SmallInteger
	nlink: SmallInteger
	rdev: SmallInteger
	size: SmallInteger
	uid: SmallInteger
';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelIndexableSubclass:'GsMethod'
	instVarNames: #(invocationCount numBreakpoints selector literalsOffset numArgs inClass numSends sourceString debugInfo)
	classVars: #(ObsoleteClassesDict)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #'subclassesDisallowed'  #logCreation )
	reservedOop: 98817
)
		category: nil;
		comment: 'A GsMethod is a compiled form of a GemStone Smalltalk method,
 generated by Gs64 v2.x or prior version.  It must be recompiled
 before it can be executed in a Gs64 v3.0 or later system.

Constraints:
	invocationCount: SmallInteger
	numBreakpoints: SmallInteger
	selector: Symbol
	literalsOffset: SmallInteger
	numArgs: SmallInteger
	inClass: Object
	numSends: SmallInteger
	sourceString: CharacterCollection
	debugInfo: Array


--- instVar debugInfo
An Array that captures information that is useful in debugging.

--- instVar inClass
The Behavior (a Class or metaclass) for which the method was compiled.

--- instVar invocationCount
A SmallInteger . least significant 8 bits are an 8 bit unsigned compiler
 version. remaining bits are the signed number of invocations of this method
 during this session since the last time invocation counts were reset
 by profiling methods.  Invocations counts are not maintained in
 all configurations of the system,
 and are subject to change in future releases.

--- instVar literalsOffset
A SmallInteger that gives the index where literals are stored in an
 instance.

--- instVar numArgs
A SmallInteger that defines the number of arguments that the method expects.

--- instVar numBreakpoints
A SmallInteger count of breakpoints defined on the method.

--- instVar numSends
For GemStone internal use.

--- instVar selector
A Symbol that defines the method''s selector.

--- instVar sourceString
A CharacterCollection containing the source code of the method.
';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelByteSubclass:'GsNativeCode'
	classVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesNonPersistent' #'subclassesDisallowed'  #logCreation )
	reservedOop: 143617
)
		category: nil;
		comment: 'GsNativeCode is a compiled form of the executable code for a GemStone
 Smalltalk method, compiled to execute on a specific processor.

 Instances exist only in memory, they are not committed to disk.';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelIndexableSubclass:'GsNMethod'
	instVarNames: #(iFields1 selector inClass debugInfo)
	classVars: #(CopyingBlockIdxSize_mask CopyingBlockIdxSize_shift DbgI1fileInfo_mask DbgI1fileInfo_shift debugI2_hasPragmas_shift DEBUGINFO_BLK_HDRSIZE DebugInfo_fields1_offset DebugInfo_Fields2_offset DebugInfo_fields2_offset DebugInfo_FirstLastSrcOffset_offset DEBUGINFO_MTH_HDRSIZE DEBUGINFO_packageInfo DEBUGINFO_pragmas DEBUGINFO_RowanMTH_HDRSIZE DebugInfo_source_offset GEN_MAX_ARGS GSNMETHOD_FIRST_INSTR_OFFSET GsNMethod_InstSize HighLiteralsOffset_mask HighLiteralsOffset_shift IsMethodForBlock_shift IsRubyBridgeMeth_shift LineNumberBias_bits LineNumberBias_mask LineNumberBias_shift LiteralsOffset_lrgBit LiteralsOffset_mask LiteralsOffset_shift LiteralsOffset_smallBits MethCompilerVers_mask MethCompilerVers_shift NArgs_mask NumArgDescrLits_mask NumArgDescrLits_shift NumArgsPlusTemps_mask NumArgsPlusTemps_shift NumArgs_mask NumBlockLiterals_mask NumIpSteps_mask NumIpSteps_shift NumSends_mask NumSends_shift OptimizedSelectors RubyPrivate_shift RubyProtected_shift SELECTORID_ENV_mask SI_SELECTORID_ENV_shift TraceIR)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'subclassesDisallowed'  #logCreation )
	reservedOop: 144897
)
		category: nil;
		comment: 'A GsNMethod is a compiled form of a GemStone Smalltalk method.
 Subclasses of GsNMethod are disallowed.

 For Gs64 v3.x, all "step points" are expressed in terms of
 a source offset within the method (or home method) source.
 Source offsets are 1-based in Smalltalk
 and zero-based in primitives C code.

Constraints:
	iFields1: SmallInteger
	selector: SmallInteger
	inClass: Object
	debugInfo: Array

--- instVar debugInfo
An Array that contains debugging info and reference to sourceString,
   see file opalcls.ht for details .

--- instVar iFields1
A SmallInteger encoding the various fields per opalcls.ht .

--- instVar inClass
The Behavior (a Class or Metaclass or Module) for which the method was compiled,
 or nil in an anonymous method ,
 or the home method if this method contains code for a block .

--- instVar selector
A SmallInteger that encodes the oopNumber of a Symbol plus a
 16 bit unsigned environment identifer.
';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelSubclass:'GsObjectSecurityPolicy'
	instVarNames: #(itsRepository itsOwner groupsRead groupsWrite ownerAuthorization worldAuthorization itsId trackReads)
	classVars: #(AuthorizationFactors AuthorizationMasks AuthorizationSymbols)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'disallowGciStore' #'subclassesDisallowed'  #logCreation )
	reservedOop: 73217
)
		category: nil;
		comment: 'Each Repository is composed of an integral number of ObjectSecurityPolicies.
 A GsObjectSecurityPolicy has the following properties:

 * Ownership.  This is the smallest unit of ownership for accounting and
   authorization purposes.  Each GsObjectSecurityPolicy is owned by one and
   only one user.

 * Authorization unit.  A user may control access to objects by placing them in
   a GsObjectSecurityPolicy with a known authorization.  Prior to reading or
   writing an object in a GsObjectSecurityPolicy, users must be authorized to
   perform the desired action.
   However, during a transaction, once a user is authorized to read one object
   in a GsObjectSecurityPolicy, that user can read any object in the same
   GsObjectSecurityPolicy.

 ObjectSecurityPolicies and Repositories are discussed in more detail in the
 GemStone Programming Guide.

  All objects have a objectSecurityPolicyId attribute, which is stored in the
  object header.
  References from an object to its GsObjectSecurityPolicy are indirect via the
  SystemRepository object.
  (See implementation of method Object >> objectSecurityPolicy )
  In a Repository that was converted from Gs64 v1.x , v2.0 or v2.1 ,
  all objects created prior to conversion will have objectSecurityPolicyId 0 .

  Read authorization is checked when an object is faulted or refreshed
  into memory , once in memory no further read authorization checks
  are performed. No checks are done for an object with objectSecurityPolicyId 0.

  Write authorization is checked the first time an object is written
  during each transaction.  No checks are done for an object
  with objectSecurityPolicyId 0 .

  Changes to GsObjectSecurityPolicy, UserProfile , or Group objects that affect
  read or write authorization checks are only guaranteed to be noticed
  after the next login.  This is different from Gemston/S 6.x , in which
  authorization changes are supposed to be noticed at the
  next transaction boundary.  Changes to the objectSecurityPolicyId of an
  object will take effect on the next transaction boundary.

  Creation of ObjectSecurityPolicies and changes to attributes of
  ObjectSecurityPolicies require write authorization permission to the
  DataCuratorObjectSecurityPolicy .

  If you are logged in as SystemUser , no authorization errors will occur .

  All instances of Symbol, DoubleByteSymbol must be in a objectSecurityPolicy
  with World read permission. By default they are on
  DataCuratorObjectSecurityPolicy .

  For logins other than SystemUser, the virtual machine requires read access
  to both DataCuratorObjectSecurityPolicy and SystemObjectSecurityPolicy
  in order to be able to bootstrap object memory
  as part of a session login.  Specifically , well known classes
  such as Class, Object, etc are expected to be in SystemObjectSecurityPolicy ,
  and instances of Symbol and objects such as SystemRepository are
  expected to be in DataCuratorObjectSecurityPolicy.
  To avoid infinite recursion in loading the authorization cache,
  the virtual machine preloads authorization for SystemObjectSecurityPolicy
  and DataCuratorObjectSecurityPolicy after validating the userId/password,
  and will generate a fatal error if it does not have read access to both
  DataCuratorObjectSecurityPolicy and DataCuratorObjectSecurityPolicy.

  All instances of UserProfile,  IdentitySets representing Groups,
  and ObjectSecurityPolicies must be in a objectSecurityPolicy with World
  read permission.  By default they are on DataCuratorObjectSecurityPolicy.

  During repository conversion from a prior release to Gs64 v2.2 ,
  if the previous size of SystemRepository was < 20 , and
  a  GsObjectSecurityPolicy will be created with objectSecurityPolicyId 20
  and world write, to handle the case where an older version of GBS clients
  may have created objects in a Gs64 v2.0 or v2.1 repository
  with objectSecurityPolicyId 20 .

Instance Variables:

itsRepository -- The Repository containing the GsObjectSecurityPolicy.

itsOwner -- A UserProfile indicating the owner of the GsObjectSecurityPolicy.

groupsRead -- An IdentitySet of UserProfileGroup objects.  Each group object
 must be an element of AllGroups, and represents a group of users who are
 authorized to access the GsObjectSecurityPolicy for reading.

groupsWrite -- An IdentitySet of UserProfileGroup objects.  Each group object
 must be an element of AllGroups, and represents a group of users who are
 authorized to access the GsObjectSecurityPolicy for writing.

ownerAuthorization -- A SmallInteger specifying authorization for the owner to access the GsObjectSecurityPolicy.
 0 = no access, 1 = read access, 2 = write access.

worldAuthorization -- A SmallInteger specifying world authorization to access the GsObjectSecurityPolicy.
 0 = no access, 1 = read access, 2 = write access.

objectSecurityPolicyId -- A SmallInteger > 0,
 the offset of this GsObjectSecurityPolicy in the object SystemRepository.

trackReads - A Boolean specifying whether reads of objects in this GsObjectSecurityPolicy
 are logged.  A value of nil is equivalent to false .
 Read tracking occurs when an object is faulted into temporary object memory of a session.
 See also DisableObjectReadLogging privilege in UserProfile,
 System class >> setObjectReadTracking: , System class >> objectReadTrackingEnabled, 
 Object >> trackRead, and stone config item STN_OBJECT_READ_LOG_DIRECTORIES.

Dynamic instanceVariables
  #name    -- nil or a String .  This is for application convenience and
   is not a key in any system maintained dictionary .
';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelSubclass:'GsProcess'
	instVarNames: #(stackId signalTime priority_use uaCount_depth interruptFlag_stEntryCount modeInfo topFpOffset arStack breakpointLevel block args blockResult clientData waitingOn group environment onQueue joiners msgEnvironmentId signalledException ioSelectResult stackSerialNum dbgFpsCache lastBreakpt debugActionBlock name startSeconds parentProcess ffiErrno)
	classVars: #(FP_codePtr_OFS FP_lastArg_OFS FP_markerNil_OFS FP_MarkerValue_OFS FP_rtnAddr_OFS FP_savedFP_OFS FP_stackTemp0_OFS FP_VC_OFS GC_GSPROCESS_cpuKind_interp MaxProcessStacks ModeInfo_anyTermination ModeInfo_breakptsIgnore_mask ModeInfo_breakptsIgnore_shift ModeInfo_continuationMask ModeInfo_continuationShift ModeInfo_debugEnabled ModeInfo_debuggingInProgress ModeInfo_forked ModeInfo_isContinuation ModeInfo_isPartialContinuation ModeInfo_isSuspended ModeInfo_partialContinuatLoaded ModeInfo_stackKind_mask ModeInfo_stackKind_shift ModeInfo_terminated ModeInfo_terminationStarted ModeInfo_threadEnvMask ModeInfo_v33 OC_GSNMETHOD_FIRST_INSTR_OFFSET OOP_ENSURE_Mark_NIL OOP_REENTER_Mark_NIL OOP_terminationBlockValue_Mark_NIL)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'disallowGciStore' #'subclassesDisallowed'  #logCreation )
	reservedOop: 134657
)
		category: nil;
		comment: '
 A GsProcess represents a suspended or active GemStone Smalltalk
 green-thread process.
 The in-memory state of a committed GsProcess is not changed by a transaction abort.

 instVars are:

  stackId - a SmallInteger
     zero-based stackId specifying the stack memory area holding
     the process, or -1 means not in a stack memory area.

  signalTime - used by the scheduler .

 priority_use - a SmallInteger used by the scheduler, bit masks
          16rFFFFFFFFFF    unsigned 40 bit use count, incremented each time
               the process is run or resumed by the scheduler.
      16rFFFF0000000000    unsigned priority in the range of a C ushort.

  uaCount_depth -  a SmallInteger,  with bit masks
            16rFFFFFFFF   stack depth , for a process not in stack memory
      16rFFFFFFF00000000 user action count
     Maybe nil if receiver is running.

  interruptFlag_stEntryCount - a SmallInteger,  with bit masks
          16rFFFFFFFF  stEntryCount
   16rFFFFFFF00000000   interruptFlags

  modeInfo - a SmallInteger, with bit masks (see symbolic definitions ModeInfo_)
                16rFF  envId
              16r0F00  nativeCpuKind, 0..15
              16rF000  nativeStackKind, 0..15
            16rFF0000  breakpointsToIgnore, 0..255
           16r1000000  debuggerEnabled, a boolean
           16r2000000  debuggingInProgress, a boolean
           16r4000000  terminated , a boolean
           16r8000000  terminationStarted , a boolean
          16r10000000  isRubyThread, a boolean
          16r60000000  continuationKind, 1 == continuation, 2 == partial continuation
          16r80000000  forked , a boolean
         16r100000000  partialContinuationLoaded, private boolean for VM
         16r200000000  Gs64 v3.3 version bit.
         16rC00000000  spareBits
       16rFF000000000  OM.reapEventsCount (in a saved stack)
      nativeStackKind  is one of STK_ values from om.hf .
          0 means interpreted , 1 mixed mode, 2 pure native code
      nativeCpuKind is the cpu that created the instance , see GC_GSPROCESS_cpuKind in gcioc.ht .
      debuggingInProgress == 0, debugging or single stepping is completed.
      debuggingInProgress == 1, debugging or single stepping is in progress ;
  breakpoints or single step exceptions are handled by the debugger
        and will not be seen by any user-installed Exception handlers.
      Breakpoints are not supported while executing in native code.
      A process'' stack can be converted from native to portable as part
      of a GciContinue or GciStep.

 topFpOffset - a SmallInteger, byte offset from StackLimit back to the topFP,
   for a process not in a stack memory area.

 arStack - a GsStackBuffer, the saved evaluation stack, for a process
   not in a stack memory area.

 breakpointLevel - a SmallInteger  >=0 
   0 = system process (debugged via GCI), 
   1 = application process (debugged via debugger implemented in Smalltalk)
   used by implementation of breakpoints
   When execution encounters a breakpoint bytecode,  if the level of the
   breakpoint is <=  breakpointLevel of the GsProcess, the breakpoint is
   signalled.  A breakpoint with level 0 is always signalled directly to the GCI.
   A breakpoint may optionally include a GsProcess reference; if that reference
   is non-nil,  it must match the current GsProcess otherwise the breakpoint
   is ignored.

   Signalling of single step breakpoints is controlled directly by the value
   of the breakpointLevel instVar .  Single step breakpoints do not have
   a level associated with the individual breakpoints.

 block - an ExecBlock or nil, the block that the GsProcess is to execute.

 args - an Array of arguments for the block, or nil.

 blockResult - result returned by the block of a Smalltalk process
   has value _remoteNil if process has not terminated normally

 clientData - For application use, such as for thread-specific data.

 environment - A Dictionary containing thread-specific values,
   for application usage  with environmentAt:, environmentAt:put: .
   If the process is a Smalltalk continuation and environment is nil,
   then the environment dictionary from the calling process
   is used as the environment dictionary for the resumed continuation.
   Not related to environmentId of message sends.
   For Ruby, the dictionary of thread-local values.

 waitingOn - used by the scheduler, a GsSocket, Semaphore, Delay, or SharedQueue
    which this process is waiting on.

 group - a SmallInteger or RubyThreadGroup representing a process group .

 joiners - nil, or an Array of Delays or Semaphores representing other threads
     waiting in GsProcess>>join:  for this thread to finish.

 msgEnvironmentId - message send environmentId , 0 for default Smalltalk,
                      1 for Ruby .

 signalledException - used in the implementation of Exceptions .

 ioSelectResult - counter representing  executing a GsProcess termination

 stackSerialNum - private, for use by the scheduler and VM only

 dbgFpsCache - for use by  GsProcess>>_frameDescrAt: only, cleared by the VM
        whenever arStack is cleared.

 lastBreakpt - for use by implementation of breakpoints and single step.

Constraints:
  stackId: SmallInteger
  signalTime: SmallInteger
  priority_use: SmallInteger
  uaCount_depth: SmallInteger
  interruptFlag_stEntryCount: SmallInteger
  modeInfo: SmallInteger
  topFpOffset: SmallInteger
  arStack: GsStackBuffer
  breakpointLevel: SmallInteger
  block: ExecBlock
  args: Array
  blockResult: Object
  clientData: Object
  waitingOn: Object
  group: SmallInteger
  environment: AbstractDictionary
  onQueue: Object
  joiners: Object
  msgEnvironmentId: SmallInteger
  signalledException: AbstractException
  ioSelectResult: SmallInteger
  stackSerialNum: SmallInteger
  dbgFpsCache: Array
  lastBreakpt: Array
';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelSubclass:'IcuCollator'
	instVarNames: #(locale strength)
	classVars: #(IDENTICAL LibraryVersion PRIMARY QUATERNARY SECONDARY StrengthArgs StrengthNames StrengthVals TERTIARY)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 153857
)
		category: nil;
		comment: 'An IcuCollator encapsulates an instance of the C++ class Collator
from the libicu libraries, documented at icu-project.org .
The C++ instance is automatically freed upon in-memory GC of the
instance and is automatically recreated when the instance is faulted in.

Beginning with Gs64 v3.3.1,
the class variable LibraryVersion contains the result of
IcuCollator libraryVersion from creation of the virgin repository,
or from the last upgrade of indexes depending on ICU sort keys .

Constraints:
	locale: IcuLocale
	strength: SmallInteger';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelSubclass:'IcuLocale'
	instVarNames: #(name)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 153601
)
		category: nil;
		comment: '  An IcuLocale encapsulates an instance of C++ Locale from
  the libicu libraries, documented at icu-project.org .
  C data is a Locale from locid.h, not freed on GC,
  auto-initialized when the instance is faulted into memory.

  Classes Unicode7, Unicode16 and Unicode32 are added to support
  Locale sensitive comparison of Strings, and fix bug 41964 .
  Comparison and conversion between instances of the different
  classes is provided by the libicu libraries, from icu-project.org .
  These libraries are shipped in $GEMSTONE/lib
  and automatically loaded during gem or  topaz -l  process initialization.
  Any libicu libraries installed as part of the operating system
  are ignored.

  Also added is class Utf8 representing Utf8 encoded
  strings, and IcuCollator representing a C++ Collator from libicu.

  These new classes appear in the hierarchy as follows.
  Object
    IcuLocale
    IcuCollator
    Collection
      SequenceableCollection
        ByteArray
          Utf8
        CharacterCollection
          String
            Unicode7
          MultiByteString
            DoubleByteString
              Unicode16
            QuadByteString
              Unicode32

  Class Utf8 supports comparison methods and conversion to
   one of Unicode7, Unicode16, Unicode32  .

  The classes Unicode7, Unicode16, Unicode32 support
  the full CharacterCollection API.

  If the source string of a method compilation is a Unicode32, Unicode16,
  or Unicode7, literal strings within the compiled method will be
  instances of Unicode32, Unicode16, or Unicode7 using the minimum
  bytes per codePoint required to represent each literal.

Constraints:
	name: String
';
		immediateInvariant.
true.
%

doit
(Object
	subclass: 'IndentingStream'
	instVarNames: #(indentLevel stream)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: GsCompilerClasses
	options: #( #logCreation )
)
		category: nil;
		comment: ' IndentingStream wraps another stream, but indents each line to its indent level.
        This is for pretty-printing nested structures such as ParseNodes.
        New protocol includes #indentMore and #indentLess
';
		immediateInvariant.
true.
%

removeallmethods IndentingStream
removeallclassmethods IndentingStream

doit
(Object
	_newKernelSubclass:'IO'
	instVarNames: #(fileDescriptor lineNumber)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 129793
)
		category: nil;
		comment: 'IO is the superclass of both GsFile and GsSocket.

 The fileDescriptor instVar represents a server file descriptor (of the gem process).
 It will be -1 in instances of GsFile which represent client files.

 The lineNumber instVar is obsolete , it was used by Ruby

Constraints:
	fileDescriptor: SmallInteger
	lineNumber: SmallInteger
';
		immediateInvariant.
true.
%

doit
(IO
	_newKernelSubclass:'GsFile'
	instVarNames: #(isClient pathName mode)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 135169
)
		category: nil;
		comment: 'GsFile provides the means for creating and accessing files. These
 files reside in the file system on either the machine that is running the
 current session''s Gem process (the server machine) or the machine that is
 running the client application (the client machine).  The files may be of any
 type, textual or binary, though separate protocol is provided for reading and
 writing these types of data.  File contents are in bytes and writing kinds of
 String that require multiple bytes per code pint, the contents must be
 explicitly encoded before write, or written using nextPutAllUtf8:.

 Beginning with Gs64 v3.0,  instances of GsFile automatically have
 their C state closed when the instance is garbage collected or
 when a persistent instance drops out of memory.

                              Warning:
    Do not retain an instance of GsFile from one session to another.
    Instances of GsFile are intended to exist only within a given GemStone
    session.  GsFiles that are used across sessions always generate an error.

  Path arguments specifying a directory or file to open or create
  will be converted to Utf8 if they contain code points above 255 ,
  or are implemented as a MultiByteString . On Windows clients, for
  compatibility with the OS operations, arguments are converted to Utf16.

  Access to files on the client machine are not supported if this session
  was created by an instance of GsTsExternalSession(or libgcits) in another machine.
  Sessions whose client is the libgcits have privilege NoGsFileOnClient always true.

Instance variables:

fileDescriptor -- SmallInteger

lineNumber -- SmallInteger

isClient -- a Boolean or SmallInteger,  with following stats and values
   committed pre-v2.1 instance   true or false
   temp , open                   true or false
   temp , closed                 0 or 1
   temp , closed, access error   2 or 3
   committed v2.1              any of   true/false, 0/1, 2/3

pathName -- A String that gives an absolute path name to the file.

mode -- A String that gives the file open mode for the file, as defined for the
 C-language open function.
';
		immediateInvariant.
true.
%

doit
(IO
	_newKernelSubclass:'GsSocket'
	instVarNames: #(readWaiters writeWaiters readyEvents pollArrayOfs interrupting)
	classVars: #(SocketErrorSymbols)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'disallowGciStore'  #logCreation )
	reservedOop: 135425
)
		category: nil;
		comment: 'GsSocket provides the means for creating and binding TCP sockets through the
 operating system of the machine that is running the session''s Gem process, and
 for communicating across those sockets.
 When the current GsProcess is suspended until a socket is ready to read or write,
 other GsProcess that are ready to run will be run by the process scheduler.
 Methods that suspend the current GsProcess until the socket operation completes
 are interruptable by a hard break.
 (You can get a hard break in Topaz by pressing the control-C key twice.  You can get
 a hard break in GemBuilder for C by calling the GciHardBreak function, and in
 GemBuilder for Smalltalk by calling the corresponding hard break method.)

 Beginning with Gs64 v3.0,  instances of GsSocket automatically have
 their C state (including their file descriptor) closed when
 the instance is garbage collected or when a persistent instance drops out of memory.

                              Warning:
    Do not retain an instance of GsSocket from one session to another.
    Instances of GsSocket are intended to exist only within a given GemStone
    session.  GsSockets that are used across sessions always generate an error.

 The interrupting instVar, if true, causes the VM to poll the socket
 asynchronously while executing bytecodes if a GsProcess is waiting
 for the socket to be ready for read or write.

 All instVars of GsSocket are private, for use by the implementation
 of socket methods, and for use by the ProcessorScheduler only.
 The in-memory state of a committed GsSocket is not changed by a transaction abort.

Constraints:
	fileDescriptor: SmallInteger
	lineNumber: SmallInteger
	readWaiters: Object
	writeWaiters: Object
	readyEvents: SmallInteger
	pollArrayOfs: SmallInteger
	interrupting: Boolean';
		immediateInvariant.
true.
%

doit
(GsSocket
	_newKernelSubclass:'GsSignalingSocket'
	instVarNames: #()
	classVars: #(OOB_SIGNAL_ABORT OOB_SIGNAL_COMMITTED_OBJS OOB_SIGNAL_FROM_GEM OOB_SIGNAL_GC_FINALIZE)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 249601
)
		category: nil;
		comment: 'GsSignalingSocket provides the means for creating and binding TCP sockets through the 
operating system of the machine that is running the session''s Gem process, and for 
communicating across those sockets. 

While GsSocket returns nil when a socket operation fails, GsSignalingSocket signals 
Errors, primarily instances of SocketError.

Methods that block GemStone Smalltalk until the socket operation completes are 
interruptable by a hard break.  (You can get a hard break in Topaz by pressing the 
control-C key twice.  You can get a hard break in GemBuilder for C by calling the 
GciHardBreak function, and in GemBuilder for Smalltalk by calling the corresponding 
hard break method.)

Instances of GsSignalingSocket automatically have their C state (including their file 
descriptor) closed when the instance is garbage collected or when a persistent instance 
drops out of memory.

                              Warning:
    Do not retain an instance of GsSignalingSocket from one session to another.
    Instances of GsSocket are intended to exist only within a given GemStone
    session.  GsSockets that are used across sessions always generate an error.

All instVars of GsSignalingSocket are private, for use by the implementation of socket 
methods, and for use by the ProcessorScheduler only.

Constraints:
	fileDescriptor: SmallInteger
	lineNumber: SmallInteger
	readWaiters: Object
	writeWaiters: Object
	readyEvents: SmallInteger
	pollArrayOfs: SmallInteger
	interrupting: Boolean';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelSubclass:'Magnitude'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'selfCanBeSpecial'  #logCreation )
	reservedOop: 71169
)
		category: nil;
		comment: 'Magnitude is an abstract superclass that defines methods for kinds of objects
 that are ordered.  Concrete subclasses of Magnitude include Character,
 DateTime, and Integer.

 A subclass of Magnitude must implement two comparison operators: equality (=)
 and less-than (<).  The remaining comparison operators are defined in terms
 of these two operations, so the subclass can inherit their definitions.  Each
 of these methods generates an error if the argument aMagnitude cannot be
 compared with the receiver.';
		immediateInvariant.
true.
%

doit
(Magnitude
	_newKernelByteSubclass:'AbstractCharacter'
	classVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #'instancesInvariant' #'selfCanBeSpecial' #'subclassesDisallowed'  #logCreation )
	reservedOop: 81665
)
		category: nil;
		comment: 'AbstractCharacter is an abstract superclass that defines behavior common to
 one-byte and two-byte character classes.  Its concrete subclasses include
 JISCharacter (no longer functional).';
		immediateInvariant.
true.
%

removeallmethods AbstractCharacter
removeallclassmethods AbstractCharacter

doit
(AbstractCharacter
	_newKernelSubclass:'JISCharacter'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #'selfCanBeSpecial' #'subclassesDisallowed'  #logCreation )
	reservedOop: 81921
)
		category: nil;
		comment: ' As Of Gemstone/S 64bit v3.7 ,  no longer supported. 
 JISCharacter class >> withValue:  is no longer supported.
 Use JISCharacter >> jisValue to retrieve the code point of
 an existing reference.';
		immediateInvariant.
true.
%

doit
(Magnitude
	_newKernelSubclass:'Character'
	instVarNames: #()
	classVars: #(Backspace Cr Esc Lf NewPage Tab)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesInvariant' #'selfCanBeSpecial' #'subclassesDisallowed'  #logCreation )
	reservedOop: 68353
)
		category: nil;
		comment: 'There are 16r110000 Characters (code points 0 to 16r10FFFF inclusive).
 You may not create new instances or subclasses of class Character.

 Characters that are equal (=) are also identical (==).

 The code points 16rD800 to 16rDFFF inclusive are not allowed in Unicode strings
 (see classes Unicode16 and Unicode32).';
		immediateInvariant.
true.
%

doit
(Magnitude
	_newKernelSubclass:'Date'
	instVarNames: #(year dayOfYear)
	classVars: #(MonthNames WeekDayNames)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'selfCanBeSpecial'  #logCreation )
	reservedOop: 100609
)
		category: nil;
		comment: 'An instance of Date describes a date after December 31, 1900.

 You can convert a Date to a String (using Formatting instance methods), and
 you can convert a String to a Date (using Instance Creation class methods).
 Such conversions require a specification to describe the format of the String.
 Some methods provide for the default format, DD/MM/YYYY, which expresses the
 day and month (in that order) as digits.

 Explicit string-formatting specifications take the form of an Array, described
 in the following table.  A specification is incorrect if it is missing an
 element or if an element value is not one of the acceptable values listed in
 the table.

 String-formatting Specification Array for Date.

 Element   Acceptable Value       Explanation

 1st,      Integers 1, 2,         Determines the position of the day (1),
 2nd, and  and 3, in any          month (2), and year (3).
 3rd       order

 4th       A Character literal    Separates year, month, and day.
           (such as a space, $ )

 5th       Integer                Determines the month format to be a number (1),
                                  three-letter abbreviation (2), or the entire
                                  name (3).

 6th       Integer                Determines the year format to be the entire
                                  number (1), or only the last two digits (2).

Constraints:
	year: SmallInteger
	dayOfYear: SmallInteger

instvar year -- A SmallInteger that represents the year. Years beyond 2147483647 are not
 allowed.

instvar dayOfYear -- A SmallInteger between 1 and 366 inclusive that represents the day
 of the year.

classVar WeekDayNames -- A LanguageDictionary.  Each key is a Symbol representing the native
 language, and each value is an Array of Strings, the names of the days of the week.

classVar MonthNames -- A LanguageDictionary.  Each key is a Symbol representing the native
 language, and each value is an Array of Strings, the names of the months of the year.
';
		immediateInvariant.
true.
%

doit
(Date
	_newKernelSubclass:'SmallDate'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesInvariant' #'selfCanBeSpecial' #'subclassesDisallowed'  #logCreation )
	reservedOop: 160001
)
		category: nil;
		comment: 'SmallDate represents instances of Date with year representable in 47 bits

The bit format of an instance is
   yyyyyyyy|yyyyyyyy|yyyyyyyy|yyyyyyyy|yyyyyyyy|yyyyyyyd|dddddddd|01001100
    bits d  9 bits unsigned integer dayOfYear
    bits y  47 bits signed, holding a 32 bit signed integer   year
';
		immediateInvariant.
true.
%

doit
(Magnitude
	_newKernelSubclass:'DateTime'
	instVarNames: #(year dayOfYear milliseconds timeZone)
	classVars: #(MonthNames WeekDayNames)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 118785
)
		category: nil;
		comment: 'An instance of DateTime describes a moment in time (with millisecond resolution)
 on a date after December 31, 1900. All instances of DateTime are invariant.

 The internal representation of a DateTime is based on Greenwich Mean Time.
 However, many methods express time in the local time zone.  ("Local" time is
 local to your Gem process.)  These methods automatically convert between
 time zones, but the internal representation remains in Greenwich Mean Time.
 Hence, you can interact with DateTime methods in a natural way, but DateTime
 objects can be safely compared to each other no matter what time zone is used
 to express them.

 You can convert a DateTime to a String (using Formatting instance methods), and
 you can convert a String to a DateTime (using Instance Creation class methods).
 Such conversions require a specification to describe the format of the String.
 Some methods provide for the default format, DD/MM/YYYY HH:MM:SS, which
 expresses the day and month (in that order) as digits and uses a 24-hour clock.

 Explicit string-formatting specifications take the form of an Array, described
 in the following table.  A specification is incorrect if it is missing an
 element or if an element value is not one of the acceptable values listed in
 the table.

 String-formatting Specification Array for DateTime.

 Element   Acceptable Value       Explanation

 1st,      Integers 1, 2,         Determines the position of the day (1),
 2nd, and  and 3, in any          month (2), and year (3).
 3rd       order

 4th       A Character literal    Separates year, month, and day.
           (such as a space, $ )

 5th       Integer                Determines the month format to be a number (1),
                                  three-letter abbreviation (2), or the entire
                                  name (3).

 6th       Integer                Determines the year format to be the entire
                                  number (1), or only the last two digits (2).

 7th       A Character literal    Separates hours, minutes, and seconds.
           (such as $: or $.)

 8th       true                   Include the time of day.

 8th       false                  Do not include the time of day.  Ignore elements
                                  7, 9, and 10.  Elements 9 and 10 are optional
                                  in the specification.

 9th       true                   Include seconds.

 9th       false                  Do not include seconds.

 10th      true                   Time is expressed in 12-hour format, with
                                  am or pm (such as 1:30:55 pm).  The space is
                                  required preceding the am or pm indicator.

 10th      false                  Time is expressed in 24-hour format
                                  (such as 13:30:55).

 11th      true                   Include the time zone information.

 12th      true                   Use the time zone information of the time zone
			          in which the DateTime was created rather than
                                  the local time zone.

Instance Variables

dayOfYear - A SmallInteger between 1 and 366 inclusive that represents the
  day of the year.
milliseconds - A SmallInteger that represents the number of milliseconds since
  midnight, Greenwich Mean Time.
timeZone -  The time zone in which the DateTime was created.
year -  A SmallInteger that represents the year. Must be in the range 1...1000000.

Class variables

MonthNames - A SymbolDictionary.  Each key is a Symbol representing one of the
  native languages supported by GemStone, and each value is an Array of Strings,
  the names of the months of the year in the corresponding language.

WeekDayNames - A SymbolDictionary.  Each key is a Symbol representing one of
 the native languages supported by GemStone, and each value is an Array of
 Strings, the names of the days of the week in the corresponding language.
';
		immediateInvariant.
true.
%

doit
(Magnitude
	_newKernelSubclass:'Number'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'selfCanBeSpecial'  #logCreation )
	reservedOop: 71937
)
		category: nil;
		comment: 'Number is an abstract superclass that establishes protocol for all GemStone
 Smalltalk numbers.  Concrete subclasses include Float, SmallInteger, and
 Fraction.

 You may not create new instances of Number.
';
		immediateInvariant.
true.
%

doit
(Number
	_newKernelSubclass:'AbstractFraction'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'selfCanBeSpecial'  #logCreation )
	reservedOop: 156417
)
		category: nil;
		comment: 'AbstractFraction is the superclass of Fraction and SmallFraction.';
		immediateInvariant.
true.
%

doit
(AbstractFraction
	_newKernelSubclass:'Fraction'
	instVarNames: #(numerator denominator)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 77825
)
		category: nil;
		comment: 'A Fraction is a Number represented as the ratio of two Integers.

 Constraints:
	numerator: Integer
	denominator: Integer

 Do not send class Fraction the message new.  Fractions created in that way are
 meaningless and cannot be handled properly by GemStone''s associative access
 mechanism.  To create a new Fraction, use one of the specific instance creation
 methods.';
		immediateInvariant.
true.
%

doit
(AbstractFraction
	_newKernelSubclass:'SmallFraction'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesInvariant' #'selfCanBeSpecial' #'subclassesDisallowed'  #logCreation )
	reservedOop: 156161
)
		category: nil;
		comment: 'SmallFractions are special objects that can represent Fractions
  with   -268435456 <= numerator   <= 268435455
  and             0 <  denominator <= 134217727 .

 A SmallFraction contains the bits
    snnnnnnn|nnnnnnnn|nnnnnnnn|nnnnnddd|dddddddd|dddddddd|dddddddd|tttttttt
 where bits are shown with least-significant on the right.
 The bits  sn...n  are a 29 bit signed twos-complement numerator ,
 The bits  d...d   are a 27 bit unsigned denominator .
 The 8 tag bits have the constant value  16r2C . ';
		immediateInvariant.
true.
%

doit
(Number
	_newKernelSubclass:'BinaryFloat'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'selfCanBeSpecial'  #logCreation )
	reservedOop: 96513
)
		category: nil;
		comment: 'BinaryFloat is an abstract class.  Various subclasses provide different
 implementations of Binary floating point.  Each subclass is expected
 to conform to IEEE Standard 754.

 Float status flags, exception handlers, and non-default rounding modes are
 maintained only for a single GemStone Smalltalk execution and are cleared
 when a new execution begins.';
		immediateInvariant.
true.
%

doit
(BinaryFloat
	_newKernelByteSubclass:'Float'
	classVars: #(MaximumFloat MinusInfinity MinusQuietNaN MinusSignalingNaN PlusInfinity PlusQuietNaN PlusSignalingNaN)
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'8byteWords' #'selfCanBeSpecial' #'subclassesDisallowed'  #logCreation )
	reservedOop: 135937
)
		category: nil;
		comment: ' This class represents 8-byte binary floating point numbers, as defined in IEEE
 standard 754.

 You may not create subclasses of Float.

 Literal numbers in evaluated code that include a decimal point by default create 
 a SmallDouble or Float. If the value is in the SmallDouble range, a SmallDouble 
 will be created, otherwise a Float will be created. Literal floats may be 
 specified using exponential notation.  e and E, and also the ANSI exponents d, D, 
 and q, are all legal exponent notation and produce the same results, either a 
 SmallDouble or Float depending on the range.

 The ANSI class names FloatE, FloatD, and FloatQ also resolve to Float class. 

 The mathematics package of the vendor of the machine where the Gem is running
 implements the numerical behavior of instances of Float.

 Each float contains a 64 bit value in IEEE format, in cpu-native byte order 
 when in memory, and the byte order of the extent when on disk.

 The following details are provided for application programmers who choose
 to access bytes of a float directly.

 Starting from the most significant bit of the byte (self _basicAt: 1), the
 bits of a Float on a big-endian machine are as follows:

 *  1 bit of sign (0 means positive, 1 means negative)
 * 11 bits of exponent
 * 52 bits of mantissa

 Here are the 8 byte patterns of the exceptional values:

                   byte 1                                           byte 8
 PlusQuietNaN       16#7f  16#ff  16#ff  16#ff  16#ff  16#ff  16#ff  16#ff
 MinusQuietNaN      16#ff  16#ff  16#ff  16#ff  16#ff  16#ff  16#ff  16#ff
 MinusInfinity      16#ff  16#f0      0      0      0      0      0      0
 MinusSignalingNaN  16#ff  16#f0      0      0      0      0      0      1
 PlusInfinity       16#7f  16#f0      0      0      0      0      0      0
 PlusSignalingNaN   16#7f  16#f0      0      0      0      0      0      1

 If the Float is an exceptional value (a NaN or an Infinity) then
 the exponent bits are all 1.  If in addition the mantissa is 0 then
 the float is an Infinity; if the mantissa is non-zero then the
 float is a NaN.  In a NaN, if the most significant bit of the
 Mantissa is 1 then the NaN is a quiet NaN.';
		immediateInvariant.
true.
%

doit
(Float
	_newKernelSubclass:'SmallDouble'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesInvariant' #'selfCanBeSpecial'  #logCreation )
	reservedOop: 121345
)
		category: nil;
		comment: ' This class represents 8-byte binary floating point numbers, as defined in IEEE
 standard 754, but with a reduced exponent.
 SmallDouble has 8 bits of exponent, compared to 11 bits of exponent in
 an IEEE-754 8-byte float.

 You may not create subclasses of SmallDouble.

 Literal numbers in evaluated code that include a decimal point by default create 
 a SmallDouble or Float. If the value is in the SmallDouble range, a SmallDouble 
 will be created, otherwise a Float will be created. Literal floats may be 
 specified using exponential notation.  e and E, and also the ANSI exponents d, D, 
 and q, are all legal exponent notation and produce the same results, either a 
 SmallDouble or Float depending on the range.

 Each SmallDouble contains a 61 bit value.  The floats are stored on Disk and
 in object memory in big-endian IEEE format.  GemStone Smalltalk primitives and
 GemBuilder for C (GCI) float conversion functions automatically convert
 the format of a float to or from the machine''s native format, as required.

 In big-endian layout,
  An IEEE 64 bit binary float (a C double) has this bit layout
   seeeeeee|eeeeffff|ffffffff|ffffffff|ffffffff|ffffffff|ffffffff|ffffffff
   If (e > 0) the double has value (-1 * s) * 2^^(e-0x3ff) * 1.f  .
   If (e == 0) and f != 0 ,
     the double has value (-1 * s) * 2^^(e-0x3fe) * 0.f  (i.e. subnormal) .
   zero is represented as s==0, e==0, f==0  . See Sparc V9 Arch Manual pg 28.

  An instance of SmallDouble has this OopType layout:
   eeeeeeee|ffffffff|ffffffff|ffffffff|ffffffff|ffffffff|ffffffff|ffffs110
  which is the same number of bits of mantissa as a C double, but
  only 8 bits of exponent as compared to 11 bits of exponent in C double.
  The bottom 3 bits are the tag bits of the OopType .

  If the C double has value zero , the SmallDouble has all e and f bits zero,
  otherwise the SmallDouble has non-zero exponent, and
  the value is (-1 * s) * 2^^(e - 0x7f ) * 1.f

  There are no subnormal, infinity, nor NaN SmallDoubles .
  Thus SmallDoubles can represent  C doubles that have value zero
  or that have exponent bits in range 0x381 to 0x3ff,
  which correspends to about 5.0e-39 to 6.0e+38 , which
  is also the exponent range of  C 4-byte float  .
 ';
		immediateInvariant.
true.
%

doit
(BinaryFloat
	_newKernelByteSubclass:'SmallFloat'
	classVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'4byteWords' #'subclassesDisallowed'  #logCreation )
	reservedOop: 136705
)
		category: nil;
		comment: 'This class represents 4 byte binary floating point numbers, as defined in IEEE
 standard 754.

 This class is deprecated.
 Most numeric operations will return instances of SmallDouble or Float .

 You may not create subclasses of SmallFloat.

 Float status flags, exception handlers, and non-default rounding modes are
 maintained only for a single execution of the virtual machine, and are cleared
 when a new invocation of the virtual machine begins.';
		immediateInvariant.
true.
%

doit
(BinaryFloat
	_newKernelSubclass:'UnimplementedFloat1'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #'subclassesDisallowed'  #logCreation )
	reservedOop: 97793
)
		category: 'Kernel';
		comment: 'UnimplementedFloat1 implements GemStone internals.
It is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

removeallmethods UnimplementedFloat1
removeallclassmethods UnimplementedFloat1

doit
(BinaryFloat
	_newKernelSubclass:'UnimplementedFloat2'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #'subclassesDisallowed'  #logCreation )
	reservedOop: 98049
)
		category: 'Kernel';
		comment: 'UnimplementedFloat2 implements GemStone internals.
It is not intended for customer use, by creating instances or by subclassing.';
		immediateInvariant.
true.
%

removeallmethods UnimplementedFloat2
removeallclassmethods UnimplementedFloat2

doit
(Number
	_newKernelByteSubclass:'DecimalFloat'
	classVars: #(DecimalMinusInfinity DecimalMinusQuietNaN DecimalMinusSignalingNaN DecimalPlusInfinity DecimalPlusQuietNaN DecimalPlusSignalingNaN MaximumFloat)
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesInvariant' #'subclassesDisallowed'  #logCreation )
	reservedOop: 69889
)
		category: nil;
		comment: ' This class represents base 10 floating point numbers, as defined in IEEE
 standard 854-1987.  This class is fully supported but not being updated
 for new features, and is expected to be deprecated when a replacement
 per IEEE754-2008 is developed.

 You may not create subclasses of DecimalFloat.

 Objects of class DecimalFloat have 20 digits of precision, with an exponent in
 the range -15000 to +15000.  The first byte has encoded in it the sign and kind
 of the floating-point number.  Bit 0 is the sign bit (0=positive, 1=negative).
 The values in bits 1 through 3 indicate the kind of DecimalFloat:

 * 001x = normal
 * 010x = subnormal
 * 011x = infinity
 * 100x = zero
 * 101x = quiet NaN
 * 110x = signaling NaN

 Bytes 2 and 3 encode the exponent as a biased 16-bit number (byte 2 is more
 significant).  The actual exponent is calculated by subtracting 15000.  Bytes
 4 through 13 form the mantissa of the number.  Each byte holds two BCD digits,
 with bits 4 through 7 of byte 4 containing the most significant digit.

 Literal DecimalFloats can be specified in exponential notation using the f or F 
 character; for example, 5.432F2 creates a DecimalFloat equivalent to 543.2.';
		immediateInvariant.
true.
%

doit
(Number
	_newKernelSubclass:'FixedPoint'
	instVarNames: #(numerator denominator scale)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 102913
)
		category: nil;
		comment: ' FixedPoint was named ScaledDecimal in Gemstone/64 v2.4 and prior versions;
 the name was changed to allow an improved ScaledDecimal implementation. In most 
 cases new development should use ScaledDecimal/SmallScaledDecimal classes, 
 rather than FixedPoint.

 FixedPoint stores numerical values as a rational number, represented by a
 numerator and denominator that are Integers.  Since the numerator and
 denominator can be carried to arbitrary precision, FixedPoint can represent
 any rational number without loss of precision.  It also calculates based upon
 fractional arithmetic, and thus produces numerical results without loss of
 precision.

 FixedPoint also provides for automatic rounding to a fixed precision after
 the decimal point when converting to and from other types, such as String.

 The literal form for a FixedPoint uses $p; for example, 1.23p2, where the
 final digit indicates the scale.

--- instVar denominator
 A positive Integer that represents the denominator of the rational value
 of the instance.

--- instVar numerator
 An Integer that represents the numerator of the rational value of the
 instance.

--- instVar scale
 A non-negative SmallInteger that represents the number of decimal places of
 precision to the right of the decimal point.
';
		immediateInvariant.
true.
%

doit
(Number
	_newKernelSubclass:'Integer'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'selfCanBeSpecial' #'subclassesDisallowed'  #logCreation )
	reservedOop: 70145
)
		category: nil;
		comment: 'This is an abstract superclass that establishes protocol for all GemStone
 Smalltalk integers.  Concrete subclasses include LargeInteger and SmallInteger.

 For purposes of bit manipulation, Integers are treated as two''s-complement,
 infinite-precision binary numbers.';
		immediateInvariant.
true.
%

doit
(Integer
	_newKernelByteSubclass:'LargeInteger'
	classVars: #(MaximumDecimalFloat MaximumDigits MaximumFloat MaximumValue)
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'4byteWords'  #logCreation )
	reservedOop: 136193
)
		category: nil;
		comment: 'Instances of LargeInteger represent Integers not representable as a SmallInteger.
 Each instance of LargeInteger is stored as an array of bytes, where every
 4 bytes represents a base 4294967296 digit.  The first 4 bytes are the sign
 digit (0 or 1) , the next 4 bytes in that
 array constitute the least significant base 4294967296 digit, and the last 4
 bytes are the most significant base 4294967296 digit.
 Instance have a maximum size of 4067 digits plus the sign .

 For a LargeInteger loaded into memory, the bytes in each digit are in
 machine native byte order for a C unsigned int.

 Coercion between LargeInteger and SmallInteger occurs automatically.';
		immediateInvariant.
true.
%

doit
(Integer
	_newKernelSubclass:'SmallInteger'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesInvariant' #'selfCanBeSpecial'  #logCreation )
	reservedOop: 74241
)
		category: nil;
		comment: 'Instances of SmallInteger are an optimization for commonly occurring integers
 (between -(2 to the 60 power) and ((2 to the 60 power) - 1) ).  You may not
 create subclasses of class SmallInteger.  You may not create any new
 SmallIntegers.  Note that all instances of a given SmallInteger refer to a
 single, unique GemStone object.  That is, they are all both equal (=) and
 identical (==).

 The following selectors are are special. 
 These are compiled to bytecodes that do not do a message send if receiver and 
 argument are both SmallIntegers, and the result is a SmallInteger:
   +  -  * bitAnd: bitXor: 

 These are compiled to bytecodes that not do a message send if receiver and
 argument are both SmallIntegers:
   <  >= <= 
';
		immediateInvariant.
true.
%

doit
(Number
	_newKernelSubclass:'ScaledDecimal'
	instVarNames: #(mantissa scale)
	classVars: #(MaxScale TenPowers)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'selfCanBeSpecial'  #logCreation )
	reservedOop: 146433
)
		category: nil;
		comment: 'ScaledDecimal represents a decimal number to a fixed number of fractional digits. This
avoids the rounding issues in flating point numbers. 

ScaledDecimal stores numerical values as a mantissa and scale.
 The scale defines the position of the decimal point.
 The mantissa is an Integer .
 The scale is a SmallInteger >= 0 and <= 30000.
 The represented value is
     mantissa / (10 raisedTo: scale)  .

Creating a ScaledDecimal in the SmallScaledDecimal range will return an instance
of SmallScaledDecimal.

Literal ScaledDecimals can be created using the s notation; for example, 1.53s2. 
The s argument is the scale, and the mantissa is resized appropriately.  

Arithmetic operations between ScaledDecimals result in a ScaledDecimal
with a scale equal to either the receiver or the argument, whichever has the
greater scale. If the answer cannot be exactly represented within the result
scale, the result is rounded to the ScaledDecimal of that scale that is closest
to the precise result. If the precise result is exactly halfway between two
adjacent representable values, the value with an even mantissa is answered.

Numbers with a very large number of decimal digits cannot be represented as
a ScaledDecimal. The total digits (scale plus the number of digits to the left of
the decimal point) may not be more than can be represented by a
LargeInteger. This limit is set by the current implementation to be slightly over
39177 decimal digits. Operations on ScaledDecimals that attempt to create
numbers with more than this many digits will fail with an error.  This includes
intermediate calculations as well as results. Multiplication of ScaledDecimals,
for instance, internally computes an intermediate result with a number of
digits roughly the sum of the receiver''s digits and the argument''s digits.

Constraints:
	mantissa: Integer
	scale: SmallInteger';
		immediateInvariant.
true.
%

doit
(ScaledDecimal
	_newKernelSubclass:'SmallScaledDecimal'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesInvariant' #'selfCanBeSpecial' #'subclassesDisallowed'  #logCreation )
	reservedOop: 159233
)
		category: nil;
		comment: 'SmallScaledDecimal is used to represent ScaledDecimals
 that have scale <= 31 and  mantissa in the range -1125899906842624..1125899906842623 .

 The bit format of an instances is
   mmmmmmmm|mmmmmmmm|mmmmmmmm|mmmmmmmm|mmmmmmmm|mmmmmmmm|mmmsssss|00110100
    bits m  51 bit signed integer mantissa
         s   5 bit unsigned scale.

 As scale increases, the maximum value representable by a SmallScaledDecimal decreases.
 The maximum value representable for a given scale is approxmately
 1125899906842623.0 / (10 raisedTo: scale) .';
		immediateInvariant.
true.
%

doit
(Magnitude
	_newKernelByteSubclass:'ObsoleteDateTime'
	classVars: #(MonthNames WeekDayNames)
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #'instancesInvariant'  #logCreation )
	reservedOop: 69377
)
		category: nil;
		comment: 'Existing instances should be migrated to DateTime or otherwise processed as
 required, and then should be removed.

 Each instance of ObsoleteDateTime describes a moment in time, expressed in the
 local time zone, with one-second resolution.  Only dates after 1 March 1583
 can be represented faithfully.

 Each instance of ObsoleteDateTime is represented by two four-byte values.  The
 first four bytes represent the Julian Day of the instance (that is, the number
 of days since January 1, 4713 BC).  The second four bytes represent the number
 of seconds since midnight.  In each of these values, the least significant byte
 is stored first.';
		immediateInvariant.
true.
%

doit
(Magnitude
	_newKernelSubclass:'Time'
	instVarNames: #(milliseconds)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'selfCanBeSpecial'  #logCreation )
	reservedOop: 100865
)
		category: nil;
		comment: 'An instance of Time describes a time of day with one-millisecond resolution.
 The class Time also provides methods for examining the system clock and for
 measuring the performance of a block.

 The internal representation of a Time is based on local time.

 From Gemstone64 v3.6 onwards, newly created instances are instances of 
 the subclass SmallTime .

 You can convert a Time to a String (using Formatting instance methods), and
 you can convert a String to a Time (using Instance Creation class methods).
 Such conversions require a specification to describe the format of the String.
 Some methods provide for the default format, HH:MM:SS, which uses a 24-hour
 clock.

 Explicit string-formatting specifications take the form of an Array, described
 in the following table.  A specification is incorrect if it is missing an
 element or if an element value is not one of the acceptable values listed in
 the table.

 String-formatting Specification Array for Time.

 Element   Acceptable Value     Explanation
 
 1st       A Character literal  Separates hours, minutes, and seconds.
           (such as $: or $.)

 2nd       true                 Include seconds.

 2nd       false                Do not include seconds.

 3rd       true                 Time is expressed in 12-hour format, with
                                am or pm (such as 1:30:55 pm).  The space is
                                required preceding the am or pm indicator.

 3rd       false                Time is expressed in 24-hour format
                                (such as 13:30:55).

Instance variables
  milliseconds - The number of milliseconds since midnight, local time.
';
		immediateInvariant.
true.
%

doit
(Time
	_newKernelSubclass:'SmallTime'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesInvariant' #'selfCanBeSpecial' #'subclassesDisallowed'  #logCreation )
	reservedOop: 159745
)
		category: nil;
		comment: 'SmallTime is used to represent instances of Time .

The bit format of an instance is
   tttttttt|tttttttt|tttttttt|tttttttt|tttttttt |tttttttt|tttttttt| 01000100
     bits t  56 bits unsigned integer , local time since midnight  , units microseconds
   The maximum value of local time is  86399999999 .

SmallTime has special implementation, it has no instance variables 
and does not inherit the instance variables from Time .
';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelIndexableSubclass:'MatchData'
	instVarNames: #(search_status inputString strPreceedingMatch strFollowingMatch groupsCache)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 127489
)
		category: nil;
		comment: '
 Instances of MatchData are used with the regular expression primitives.

 The Gs 64 v3.0 VM includes primitives for the Oniguruma
 regular expression library, used during Ruby execution in the Maglev
 product.

 Use of the regular expression library is not yet supported in the
 Smalltalk product.

Constraints:
	search_status: SmallInteger
	inputString: SmallInteger
	strPreceedingMatch: String
	strFollowingMatch: String
	groupsCache: Array';
		immediateInvariant.
true.
%

removeallmethods MatchData
removeallclassmethods MatchData

doit
(Object
	_newKernelIndexableSubclass:'MethodContext'
	instVarNames: #(sender method pc stackP byteCodes home receiver theException stackDepth)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #'subclassesDisallowed'  #logCreation )
	reservedOop: 71681
)
		category: nil;
		comment: 'The class MethodContext is obsolete as of GemStone version 5.0 and will be removed
in a future release.';
		immediateInvariant.
true.
%

removeallmethods MethodContext
removeallclassmethods MethodContext

doit
(MethodContext
	_newKernelSubclass:'Block'
	instVarNames: #(initialPC nargs)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #logCreation )
	reservedOop: 67841
)
		category: nil;
		comment: 'The class Block is obsolete as of GemStone version 5.0 and will be removed
in a future release.';
		immediateInvariant.
true.
%

doit
(Block
	_newKernelSubclass:'SelectionBlock'
	instVarNames: #(bindPc)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #logCreation )
	reservedOop: 73473
)
		category: nil;
		comment: 'The class SelectionBlock is obsolete as of GemStone version 5.0 and will be removed
in a future release.  ';
		immediateInvariant.
true.
%

doit
(MethodContext
	_newKernelSubclass:'ReenterBlock'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #'noInheritOptions'  #logCreation )
	reservedOop: 78849
)
		category: nil;
		comment: 'The class ReenterBlock is obsolete as of GemStone version 5.0 and will be
removed in a future release.';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelSubclass:'ObsoleteException'
	instVarNames: #(next category number theBlock subtype)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #logCreation )
	reservedOop: 230913
)
		category: nil;
		comment: '
 Instances of ObsoleteException are committed instances of the
 class which was named Exception in Gs64 v2.x .
 They are not usable by the Gs64 v3.0 VM .
 and would usually be referenced by committed instances of ObsoleteGsProcess.
 Instance creation is disallowed.

 The Gs64 v2.x class named ExceptionA, if present, has been
 renamed to ObsoleteExceptionA and is also not usable by the Gs64 v3.0 VM.
';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelSubclass:'ObsoleteGeode'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #'selfCanBeSpecial' #'subclassesDisallowed'  #logCreation )
	reservedOop: 92417
)
		category: 'Kernel';
		immediateInvariant.
true.
%

removeallmethods ObsoleteGeode
removeallclassmethods ObsoleteGeode

doit
(Object
	_newKernelSubclass:'ObsoleteGsProcess'
	instVarNames: #(stackDepth controlStack arStack inUserActionCount interruptFlag fltStatus recursionsToStCount protectedMode asyncEventsDisabled remoteProcess priority block args signalTime blockResult clientData location _lastGciProcess _debugMode isTerminated group environment)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #logCreation )
	reservedOop: 99841
)
		category: nil;
		comment: '
 Instances of ObsoleteGsProcess are the committed state of
 suspended Smalltalk processes or continuations from a Gs64 v2.x VM .
 Their execution cannot be resumed by the Gs64 v3.0 VM .
 Instance creation is disallowed.

Constraints:
	stackDepth: SmallInteger
	controlStack: GsStackBuffer
	arStack: GsStackBuffer
	inUserActionCount: SmallInteger
	interruptFlag: SmallInteger
	fltStatus: String
	recursionsToStCount: SmallInteger
	protectedMode: SmallInteger
	asyncEventsDisabled: Boolean
	remoteProcess: Object
	priority: SmallInteger
	block: ExecutableBlock
	args: Array
	signalTime: SmallInteger
	blockResult: Object
	clientData: Object
	location: Object
	_lastGciProcess: ObsoleteGsProcess
	_debugMode: Boolean
	isTerminated: Boolean
	group: Integer
	environment: AbstractDictionary';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelSubclass:'ObsoleteTimeZone'
	instVarNames: #(secondsFromGmt secondsForDst timeStartDst weekDayStartDst dayStartDst dayEndDst yearStartDst standardPrintString dstPrintString dstStartTimeList dstEndTimeList)
	classVars: #(Default TimeZones)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #logCreation )
	reservedOop: 118529
)
		category: nil;
		comment: 'A ObsoleteTimeZone represents the policy for converting Greenwich Mean Time to local
 time.

Constraints:
	secondsFromGmt: SmallInteger
	secondsForDst: SmallInteger
	timeStartDst: SmallInteger
	weekDayStartDst: Symbol
	dayStartDst: SmallInteger
	dayEndDst: SmallInteger
	yearStartDst: SmallInteger
	standardPrintString: String
	dstPrintString: String
	dstStartTimeList: IntegerKeyValueDictionary
	dstEndTimeList: IntegerKeyValueDictionary
--- instVar dayEndDst
The day of the year (SmallInteger) by which daylight savings should have
 ended. Daylight savings actually ends on the preceding weekDayStartDst
 (see above).
--- instVar dayStartDst
The day of the year (SmallInteger) by which daylight savings should have
 started. Daylight savings actually starts on the preceding weekDayStartDst
 (see above).
--- instVar dstPrintString
The string to be printed to identify the time zone when daylight savings
 program is in effect (String).
--- instVar secondsForDst
The number of seconds for daylight savings correction (SmallInteger).
 If this is zero, there is no daylight savings in the time zone represented by
 this instance of ObsoleteTimeZone.
--- instVar secondsFromGMT
The offset from Greenwich Mean Time in seconds (SmallInteger). Time zones
 east of the Greenwich meridian have positive values, those west of the
 meridian have negative values
--- instVar standardPrintString
The string to be printed to identify the time zone when daylight savings
 program is not in effect (String).
--- instVar timeStartDst
The number of seconds after midnight when daylight savings starts
 (SmallInteger).
--- instVar weekDayStartDst
The day of the week when daylight savings time starts (Symbol). Usually
 #Sunday.
--- instVar yearStartDst
The year in which daylight savings policy came into effect (SmallInteger).';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelIndexableSubclass:'ObsoleteVariableContext'
	instVarNames: #(unwindBlock)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #logCreation )
	reservedOop: 84225
)
		category: nil;
		comment: '
 ObsoleteVariableContext is a class used by the Gs64 v2.x VM .
 Committed instances would be part of committed state of an
 ObsoleteGsProcess, whose execution cannot be resumed by the
 Gs64 v3.0 VM .
 Instance creation is disallowed.';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelSubclass:'Process'
	instVarNames: #(aStackSegment continueState)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #'subclassesDisallowed'  #logCreation )
	reservedOop: 83969
)
		category: nil;
		comment: 'The class Process is obsolete as of GemStone version 5.0 and will be removed
in a future release.

Process has been replaced by GsProcess.
';
		immediateInvariant.
true.
%

removeallmethods Process
removeallclassmethods Process

doit
(Object
	_newKernelSubclass:'ProcessorScheduler'
	instVarNames: #(readyQueue activeProcess pollResults delayQueue lastGroup suspendedSet waitingSet socketsPolled timeoutThreadActive criticalMethods)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'disallowGciStore' #'instancesNonPersistent'  #logCreation )
	reservedOop: 116481
)
		category: nil;
		comment: '
 ProcessorScheduler implements a green-threads scheduler for instances of
 GsProcess.  The processes all share one native thread in the virtual
 machine.  There is exactly one instance of ProcessorScheduler in a session;
 this instance is initialized by the virtual machine and may not be
 committed to disk .

 InstVars:
   activeProcess - currently active process.
   readyQueue - a SortedCollection of processes ready to run.

   delayQueue - a SortedCollection of objects with signalTime not yet expired,
		  elements are instances of either Delay or GsProcess .
   lastGroup  -  a SmallInteger
   suspendedSet - IdentitySet of suspended processes
   waitingSet  -  IdentitySet of processes waiting for objects to be ready

   socketsPolled - an Array maintained/used by primitives,
		   the list of GsSockets upon which processes are waiting .
   pollResults - an Array used by the polling primitive.
   timeoutThreadActive - a Boolean
   criticalMethods  - used by in-vm debugging support

 A process can be in one of these states:
    active  		- the activeProcess
    ready to run 	  - in the readyQueue
    waiting on a GsSocket - in the waitingSet , and a socket in socketsPolled
    waiting on a Semaphore - in the waitingSet
    waiting on a Delay    - in delayQueue or referenced from a Delay in delayQueue
    suspended		- in the suspendedSet

  Process state               onQueue             waitingOn
    0 active                    nil		     nil
    1 ready to run              readyQueue           nil
    2 waiting on a GsSocket     waitingSet 	    a GsSocket
    3 waiting on a Semaphore    waitingSet 	    a Semaphore
    4 waiting on a Delay    -   waitingSet 	    Delay or nil
    5 ref from a waiting Delay  ??waitingSet 	    a Delay
    6 suspended         -       suspendedSet         any

 If a process waiting on a socket is suspended
 it will be woken up by activity on the socket.

 If a process waiting on a Semaphore is suspended,
 it will be woken up by signaling the semaphore .

 If a process is waiting on a Delay,
 it will be woken up when Delay expires.

 GsProcess>>suspend has no effect unless receiver is running or in the readyQueue .

 GsProcess>>terminate removes receiver from any thing it is waiting on.

 A Delay has one target, a GsProcess or a Semaphore .

 The method compiler omits check interrupt bytecodes that would otherwise be 
 generated when compiling an instance method in ProcessorScheduler.
 Interrupt check on backwards branches are generated in those instance methods.

Constraints:
	readyQueue: SortedCollection
	activeProcess: GsProcess
	pollResults: Array
	delayQueue: SortedCollection
	lastGroup: SmallInteger
	suspendedSet: Object
	waitingSet: Object
	socketsPolled: Array
	timeoutThreadActive: Boolean
	criticalMethods: IdentitySet
';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelSubclass:'Regexp'
	instVarNames: #(source options)
	classVars: #(CAPTURE_GROUP DONT_CAPTURE_GROUP EXTEND FIND_LONGEST FIND_NOT_EMPTY IGNORECASE KCODE_ASCII KCODE_EUC KCODE_NONE KCODE_shift KCODE_SJIS KCODE_UTF8 MULTILINE NEGATE_SINGLELINE NONE SINGLELINE)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #logCreation )
	reservedOop: 127233
)
		category: nil;
		immediateInvariant.
true.
%

removeallmethods Regexp
removeallclassmethods Regexp

doit
(Object
	_newKernelSubclass:'SoftReference'
	instVarNames: #(inUse useCount value)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'disallowGciStore' #'instancesNonPersistent' #'subclassesDisallowed'  #logCreation )
	reservedOop: 120065
)
		category: nil;
		comment: 'A SoftReference contains a reference to another object which may be
 cleared by the in-memory garbage collector.   Instances of SoftReference
 are non-persistent and may not be committed ot the repository .

 A SoftReference''s value instVar is only cleared if
 there are no strong references to the referenced value , and if
 the inUse instVar is not true .

 If a SoftReference to A is cleared, all other SoftReferences
 to objects B such that B->A is a strong reference, are also cleared .
 All SoftReferences that are legal to clear are cleared before
 generating AlmostOutOfMemory error .

 VM scavenge will never clear SoftReferences , and the normal stubbing of
 references from temporary to committed objects is not performed
 in SoftReferences .

 If percentMemUsed > GEM_SOFTREF_CLEANUP_PERCENT_MEM at start of markSweep,
 markSweep will will attempt to clear SoftReferences as follows:

 if percentMemUsed < 60%,
 markSweep will try to clear the least recently used 10% of SoftReferences.

 if percentMemUsed >= 60% and < 90% ,
 markSweep will try to clear the least recently used 20% of SoftReferences.

 if percentMemUsed >= 90%
 markSweep will try to clear all SoftReferences.

Constraints:
	inUse: Boolean
	useCount: SmallInteger
	value: Object

--- instVar inUse
A Boolean , if true prevents the garbage collector from clearing value.

--- instVar useCount
Private to the garbage collector and primitives, used to implement least
 recently used behavior for clearing of value.

--- instVar value
Reference to another object, may be cleared by the garbage collector.
';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelIndexableSubclass:'StackBuffer'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #'subclassesDisallowed'  #logCreation )
	reservedOop: 83457
)
		category: nil;
		comment: 'The class StackBuffer is obsolete as of GemStone version 5.0 and will be removed
in a future release.';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelSubclass:'StackSegment'
	instVarNames: #(activationStack controlStack next)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: ObsoleteClasses
	options: #( #'subclassesDisallowed'  #logCreation )
	reservedOop: 83201
)
		category: nil;
		comment: 'The class StackSegment is obsolete as of GemStone version 5.0 and will be removed
in a future release.  ';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelSubclass:'Stream'
	instVarNames: #()
	classVars: #(Lf Tab)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 74497
)
		category: nil;
		comment: 'Stream is an abstract superclass that represents the ability to maintain a
 position reference into a linear sequence of objects.  Concrete subclasses are
 ReadStream and WriteStream.';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelSubclass:'System'
	instVarNames: #()
	classVars: #(AllocatedGciOops_id CommitOrAbortReleaseLocksSet_id CommitReleaseLocksSet_id Conversion_id Customer1_id Customer2_id Customer3_id Customer4_id Customer5_id DepMapWriteSet_id ExportedDirtyObjs_id GcCandidates_id GciTrackedObjs_NotImplemented_id Indexing_id ListInstances_id NewDataPages_id NotifySet_id ObjectsRead_id ObjInventory_id PomWriteSet_id PreviousWsUnion_id PureExportSet_id RcReadSet_id ReadWriteConflicts_id ReferencedSet_id RemovedDepMapEntries_id SaveDepMapChangedUnion_id SaveNewPomObjs_id SaveWriteSetUnion_id StrongReadSet_id TrackedDirtyObjs_NotImplemented_id WeakReferences_id WriteDependencyConflicts_id WriteLockWriteSubset_id WriteReadLockConflicts_id WriteWriteConflicts_id WriteWriteLockConflicts_id)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'subclassesDisallowed'  #logCreation )
	reservedOop: 76033
)
		category: nil;
		comment: 'System is an abstract class that has no instances. It implements only
 class-side methods. 

 System class provides many repository management and system behaviors, 
 including transaction management, system control operations such as
 garbage collection and stopping sessions, object locking, programmatic 
 access to cache statistics and shared counters, and many others. 
 Many of these operations require privileges to execute. 

 Class System has class variables for internal use that provide optimized 
 access to GsBitmap hidden sets, which has numeric ids that are different 
 than legacy hidden set IDs. Use of System hidden sets by numeric id 
 should be replaced by GsBitmap access by symbolic name.

 For more information on the functions supported by System class, see 
 the System Administration Guide and the GemStone Programming Guide.';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelSubclass:'UndefinedObject'
	instVarNames: #()
	classVars: #(_ensureMarkNil _exceptionMarkNil _executeHandlerMarkNil _gsExcHandlerMarkNil _partialContinuaLoadMarkNil _reenterMarkNil _rfhGsExcHandlerMarkNil _rfhMarkNil _syncExceptionMarkNil _terminationBlockValueMarkNil _tosIsIpNil)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'instancesInvariant' #'selfCanBeSpecial' #'subclassesDisallowed'  #logCreation )
	reservedOop: 76289
)
		category: nil;
		comment: 'This class describes the behavior of nil, the `nonexistent'' object.  You may
 not create new instances of UndefinedObject.';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelSubclass:'UserProfile'
	instVarNames: #(encryptedPassword userId symbolList defaultObjectSecurityPolicy privileges groups kerberosPrincipal spare2 loginHook compilerLanguage)
	classVars: #(GSC_SET_USER_PROFILE_no_login_logging InversePrivileges LanguageNames OC_USER_SECUR_DATA_ACTIVE_USR_LIM OC_USER_SECUR_DATA_ALIAS_USERID OC_USER_SECUR_DATA_AUTH_SCHEME OC_USER_SECUR_DATA_BIT_FLAGS OC_USER_SECUR_DATA_LAST_LOGIN_TIM OC_USER_SECUR_DATA_LAST_PWD_CHNG OC_USER_SECUR_DATA_LDAP_BASE_DN OC_USER_SECUR_DATA_LDAP_FILTER OC_USER_SECUR_DATA_LOGINS_BEFORE_EXPIR OC_USER_SECUR_DATA_OLD_PASSWDS_ARRAY OC_USER_SECUR_DATA_ONETIME_PW_WL OC_USER_SECUR_DATA_PASSWD_AGE_LIMIT OC_USER_SECUR_DATA_PASSWD_AGE_WARNING OC_USER_SECUR_DATA_PASSWD_NEVER_EXPIRES OC_USER_SECUR_DATA_POS_WHITELIST OC_USER_SECUR_DATA_READ_ONLY OC_USER_SECUR_DATA_REASON_DISABLED OC_USER_SECUR_DATA_SALT OC_USER_SECUR_DATA_STALE_ACCOUNT_AGE_LIMIT OC_USER_SECUR_DATA_USED_SALTS OC_USER_SECUR_DATA_USED_VERIFIERS OC_USER_SECUR_DATA_VERIFIER OC_USER_SECUR_X509_STATUS PrivilegeNames)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'subclassesDisallowed'  #logCreation )
	reservedOop: 76545
)
		category: nil;
		comment: 'Each instance of UserProfile contains a number of characteristics associated
 with a given system user.  For more information, see the GemStone System
 Administration Guide and the GemStone Programming Guide.

Constraints:
	encryptedPassword: String
	userId: String
	symbolList: SymbolList
	defaultObjectSecurityPolicy: GsObjectSecurityPolicy
	privileges: SmallInteger
	groups: IdentitySet
	kerberosPrincipal: KerberosPrincipal
	spare2: Object
	loginHook: Object
	compilerLanguage: SmallInteger

--- instVar defaultObjectSecurityPolicy
The GsObjectSecurityPolicy in which new objects are stored after each login.

--- instVar groups
An IdentitySet; the groups to which the user belongs.

--- instVar privileges
A SmallInteger describing the level of access to certain privileged system
 functions that are ordinarily performed by the GemStone data curator.

--- instVar kerberosPrincipal
The KerberosPrincipal object that maps to this UserProfile, or nil.

--- instVar spare2
Reserved for future use.

--- instVar loginHook
Used to store the login Block.

--- instVar symbolList
An Array of SymbolDictionaries that are used for resolving compile-time
 Symbols.

--- instVar userId
A String that identifies the user to the system at login; limited to
 1024 Characters.  Methods in this class enforce uniqueness by the value of
 all user IDs of UserProfiles in AllUsers.

--- classVar PrivilegeNames
An Array of Symbols that identify the privileges (that is, the levels of
 access to certain privileged system functions) that may be assigned to a
 UserProfile.  See UserProfile | privileges for a list of privilege names and
 their associated privileged methods.
';
		immediateInvariant.
true.
%

doit
(Object
	_newKernelSubclass:'UserSecurityData'
	instVarNames: #(password lastLoginTime lastPasswordChange activeUserIdLimit loginsAllowedBeforeExpiration reasonForDisabledAccount oldPasswords readOnly authenticationScheme authenticationUserId ldapSearchFilter passwordNeverExpires ldapBaseDn passwordAgeLimit passwordAgeWarning staleAccountAgeLimit salt usedVerifiers usedSalts bitFlags performOnServerWhitelist onetimePasswordWhitelist)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'disallowGciStore'  #logCreation )
	reservedOop: 112385
)
		category: nil;
		comment: 'The class UserSecurityData implements only GemStone internals.  That is, it
provides only functionality required by GemStone itself.  It is not intended
for customer use, by creating instances or by subclassing.
Constraints:
	password: ByteArray
	lastLoginTime: DateTime
	lastPasswordChange: DateTime
	activeUserIdLimit: SmallInteger
	loginsAllowedBeforeExpiration: SmallInteger
	reasonForDisabledAccount: String
	oldPasswords: Array
	readOnly: Boolean
	authenticationScheme: SmallInteger
	authenticationUserId: String
	ldapSearchFilter: String
	passwordNeverExpires: Boolean
	ldapBaseDn: String
	passwordAgeLimit: SmallInteger
	passwordAgeWarning: SmallInteger
	staleAccountAgeLimit: SmallInteger
	salt: ByteArray
	usedVerifiers: Array
	usedSalts: Array
        onetimePasswordWhitelist: IdentitySet';
		immediateInvariant.
true.
%

removeallmethods UserSecurityData
removeallclassmethods UserSecurityData

doit
(Object
	_newKernelIndexableSubclass:'VariableContext'
	instVarNames: #(_copyForContinuation vcSerialNum parent)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'disallowGciStore' #'subclassesDisallowed'  #logCreation )
	reservedOop: 134913
)
		category: nil;
		comment: 'VariableContext implements GemStone internals. It is not intended for
customer use, by creating instances or by subclassing.

Constraints:
	_copyForContinuation: VariableContext
	vcSerialNum: SmallInteger';
		immediateInvariant.
true.
%

doit
(nil
	_newKernelSubclass:'PrivateObject'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
	reservedOop: 213761
)
		category: nil;
		comment: 'PrivateObject is the superclass of certain classes used in the implementation.
 Instances of subclasses of PrivateObject are normally not visible to Smaltalk,
 and if they are returned by a primitive, many of the methods defined in Object
 are not safe to send to these instances. ';
		immediateInvariant.
true.
%

doit
(nil
	_newKernelSubclass:'UnauthorizedObjectStub'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #'subclassesDisallowed'  #logCreation )
	reservedOop: 155905
)
		category: nil;
		comment: 'Instances of UnauthorizedObjectStub represent objects for which an object
fault would signal a SecurityError for no read authorization.
They are produced as the in-memory state of reading such an object when
GEM_READ_AUTH_ERR_STUBS=TRUE in the session''s gem configuration, or
in a session started with GciX509Login when the hostagent for that session
filters objects being transitted to remote cache used by the session.';
		immediateInvariant.
true.
%

! Class implementation for 'GsTsX509ExternalSession'

!		Class methods for 'GsTsX509ExternalSession'

category: 'Instance Creation'
classmethod: GsTsX509ExternalSession
gemNRS: gemNRS stoneNRS: stoneNRS username: aUsername password: aPassword

"Disallowed"

self shouldNotImplement: #gemNRS:stoneNRS:username:password:
%

category: 'Instance Creation'
classmethod: GsTsX509ExternalSession
gemNRS: gemNRS stoneNRS: stoneNRS username: gsUsername password: gsPassword hostUsername: hostUsername hostPassword: hostPassword

"Disallowed"

self shouldNotImplement: #gemNRS:stoneNRS:username:password:hostUsername:hostPassword:
%

category: 'Instance Creation'
classmethod: GsTsX509ExternalSession
newDefault

self shouldNotImplement: #newDefault
%

category: 'Instance Creation'
classmethod: GsTsX509ExternalSession
newWithX509Parameters: aGemStoneX509Parameters
  ^ self _basicNew _parameters: aGemStoneX509Parameters library: GciTsLibrary newDefault
%

category: 'Instance Creation'
classmethod: GsTsX509ExternalSession
newWithX509Parameters: aGemStoneX509Parameters library: aGciTsLibrary
  ^ self _basicNew _parameters: aGemStoneX509Parameters library: aGciTsLibrary 
%

!		Instance methods for 'GsTsX509ExternalSession'

category: 'Parameters'
method: GsTsX509ExternalSession
gemNRS: anNRS

  self shouldNotImplement: #gemNRS:
%

category: 'Parameters'
method: GsTsX509ExternalSession
hostPassword: aString

  self shouldNotImplement: #hostPassword:
%

category: 'Parameters'
method: GsTsX509ExternalSession
hostUsername: aString

  self shouldNotImplement: #hostUsername:
%

category: 'Parameters'
method: GsTsX509ExternalSession
initializeDefaultResources

  self shouldNotImplement: #initializeDefaultResources
%

category: 'Public'
method: GsTsX509ExternalSession
login
	| c args ptr |
	self isLoggedIn ifTrue: [
		ImproperOperation signal: 'Already logged in'.
	].
  c := self _calloutAt: 19 name: #'GciTsX509Login' .
  gciErr := GciErrSType new .
  args := { 
     parameters asGciX509LoginArg . 
     ( CByteArray gcMalloc: 4 "BoolType *executedSessionInit") .
     gciErr
  }.
  ptr := c callWith: args .
  ptr memoryAddress == 0 ifTrue:[
    self _signalError:'GciTsLogin failed'.
  ].
  tsSession := ptr .
  socket := GsSocket fromFileHandle: self _getSocketFd .
  self _allocateBuffers .
  gciErr number > 0 ifTrue:[
    self _signalError:'Warning from GciTsLogin'.
  ].
%

category: 'Parameters'
method: GsTsX509ExternalSession
password: aString
  self shouldNotImplement: #password:
%

category: 'Parameters'
method: GsTsX509ExternalSession
stoneNRS: anNRS
  self shouldNotImplement: #stoneNRS:
%

category: 'Parameters'
method: GsTsX509ExternalSession
username
  ^ username ifNil:[ 
     username := self executeString:'System myUserProfile userId'
  ]
%

category: 'Parameters'
method: GsTsX509ExternalSession
username: aString
 self shouldNotImplement: #username:
%

category: 'Private'
method: GsTsX509ExternalSession
_gemHost

^ parameters netldiHost
%

category: 'Private'
method: GsTsX509ExternalSession
_parameters: aGemStoneX509Parameters library: aGciTsLibrary
  parameters := aGemStoneX509Parameters .
  callouts := aGciTsLibrary callouts .
  lib := aGciTsLibrary .  
%

! Class implementation for 'SshSocketError'

!		Instance methods for 'SshSocketError'

category: 'Formatting'
method: SshSocketError
buildMessageText
| result |
result := (self buildMessageText: nil) trimTrailingBlanks .
(result last == $,) ifTrue:[ result size: (result size - 1) ].
messageText := result.
^ result
%

category: 'Instance initialization'
method: SshSocketError
initialize
  gsNumber := ERR_SshSocketError.
  gsResumable := true .
  gsTrappable := true .
%

! Class implementation for 'GcFinalizeNotification'

!		Instance methods for 'GcFinalizeNotification'

category: 'Private'
method: GcFinalizeNotification
_finalizeEphemerons
  | chunk chunkSize anEphemeron  |
  chunk := System __sessionStateAt: 2 . "head of finalization queue"
  [ chunk ~~ nil ] whileTrue:[
    chunkSize := chunk size .
    1 to: chunkSize - 1 do:[:n |
      anEphemeron := chunk at: n .
      [ anEphemeron mourn
      ] onException: Error do:[:ex |
        GsFile gciLogServer: ex asString , 'during mourn'
      ].
    ].
    chunk := chunk at: chunkSize . "last element is next chunk"
    System __sessionStateAt: 2 put: chunk. "deref chunk just processed"
  ]
%

category: 'Private'
method: GcFinalizeNotification
_signalGcFinalize: saveProtectedMode

  "To be sent only by the virtual machine.
   The receiver is an asynchronous Exception for error 6017 "
  [
    self _finalizeEphemerons .
  ] ensure:[
    self _enableEvents . "reenable interrupts if resume not successful"
  ].
  self _gsReturnNothingEnableEvents "special selector optimized by compiler"
%

! Class implementation for 'RubyBreakException'

!		Instance methods for 'RubyBreakException'

category: 'Instance initialization'
method: RubyBreakException
initialize
  gsNumber := ERR_RubyBreakException.
  gsResumable := true .
  gsTrappable := true .
%

! Class implementation for 'RubyThrowException'

!		Instance methods for 'RubyThrowException'

category: 'Instance initialization'
method: RubyThrowException
initialize
  gsNumber := ERR_RubyThrowException.
  gsResumable := true .
  gsTrappable := true .
%

! Class implementation for 'Behavior'

!		Instance methods for 'Behavior'

category: 'Updating the Method Dictionary'
method: Behavior
compileMethod: sourceString category: aCategoryString environmentId: environmentId
  ^ self compileMethod: sourceString 
     dictionaries: GsSession currentSession symbolList
     category: aCategoryString environmentId: environmentId
%

category: 'Updating the Method Dictionary'
method: Behavior
compileMethod: sourceString dictionaries: aSymbolList category: aCategoryString environmentId: environmentId
	"This compiles some source code for the receiver.  The first argument,
 sourceString, is the string of source code to be compiled.  The second
 argument is a SymbolList to be used in parsing, along with the list of all
 class variables and pool dictionaries for the receiver and all of its
 superclasses.  The third argument (a String) indicates the method's category.

 sourceString must be a kind of String or DoubleByteString.  Instances of
 JapaneseString are not supported as source strings.  String literals
 ('abc') are generated as instances of the class of sourceString,
 unless sourceString is a Symbol, in which case 'abc' produces a String.
 If sourceString is a DoubleByteSymbol, 'abc' produces a DoubleByteString.

 anEnvironmentId must be a SmallInteger >= 0 and <= 16rFFFF.
 0 denotes the base Smalltalk image.  1 was reserved for use by Ruby .

 If there are no errors, this adds the resulting compiled method to the
 receiver's method dictionary and returns that method,
 otherwise signals a CompileError .
 A CompileWarning may be signaled, after adding the new method
 to a receiver's method dictionary."

	| symList categ dictsArray mDict cDict meth policy |
	self _validatePrivilege
		ifFalse: [ ^ nil ].

	aSymbolList class == SymbolList
		ifTrue: [ symList := aSymbolList ]
		ifFalse: [ 
			aSymbolList _validateClass: Array.
			symList := SymbolList withAll: aSymbolList ].
	categ := aCategoryString asSymbol.
	dictsArray := (policy := GsPackagePolicy current)
		methodAndCategoryDictionaryFor: self
		source: sourceString
		dictionaries: aSymbolList
		category: categ.
	mDict := dictsArray at: 1.
	cDict := dictsArray at: 2.
	mDict
		ifNotNil: [ 
			meth := self
				compileMethod: sourceString
				dictionaries: symList
				category: categ
				intoMethodDict: mDict
				intoCategories: cDict
				environmentId: environmentId.
			policy updateMethodLookupCacheFor: meth in: self.
			environmentId == 0
				ifTrue: [ policy setStamp: self changeStamp forBehavior: self forMethod: meth selector ].
			^ meth ]
		ifNil: [ 
			^ self
				_rwCompileMethodForConditionalPackaging: sourceString
				symbolList: symList
				category: categ
				environmentId: environmentId
				ifUnpackagedDo: [ 
					GsObjectSecurityPolicy
						setCurrent: self objectSecurityPolicy
						while: [ 
							meth := self
								compileMethod: sourceString
								dictionaries: symList
								category: categ
								intoMethodDict: nil
								intoCategories: nil
								environmentId: environmentId.
							(environmentId == 0 and: [ policy enabled ])
								ifTrue: [ policy setStamp: self changeStamp forBehavior: self forMethod: meth selector ].
							^ meth ] ] ]
%

category: 'Updating the Method Dictionary'
method: Behavior
removeAllMethods: envId

"Removes all methods from the receiver.  This should not be done without
 considerable forethought!"
| baseCats baseMeths |
self _validatePrivilege ifFalse:[ ^ nil ].
baseCats := self _baseCategorys: envId .
baseMeths := self persistentMethodDictForEnv: envId .

baseMeths ifNotNil: [
  self _rwRemoveAllMethods: baseMeths environmentId: envId.
  baseMeths removeAll .
  baseMeths valueConstraint: GsNMethod . "to handle v2.3 to v3.0 image upgrade"
].
baseCats ifNotNil: [ baseCats removeAll ].
envId == 0 ifTrue:[
  GsPackagePolicy currentOrNil ifNotNil:[:pp| pp removeAllMethodsFor: self].
].
self _clearLookupCaches: envId .
%

! Class implementation for 'Class'

!		Instance methods for 'Class'

category: 'Subclass Creation'
method: Class
subclass: aString instVarNames: anArrayOfInstvarNames classVars: anArrayOfClassVars classInstVars: anArrayOfClassInstVars poolDictionaries: anArrayOfPoolDicts inDictionary: aDictionary newVersionOf: oldClass description: aDescription options: optionsArray
	"optionsArray is an Array of Symbols containing zero or more of
   #noInheritOptions,  #subclassesDisallowed, #disallowGciStore, #modifiable ,
   #traverseByCallback #selfCanBeSpecial #logCreation
 and at most one of
   #dbTransient, #instancesNonPersistent, #instancesInvariant
 If present, #noInheritOptions must be the first element and it causes
 none of subclassesDisallowed, disallowGciStore, traverseByCallback,
         dbTransient, instancesNonPersistent, instancesInvariant
 to be inherited from the superclass, nor copied from the
 current version of the class.
 #selfCanBeSpecial is never inherited and is needed only when modifying
 superclass hierarchy above classes with special format.
 The option #logCreation, if present in the options array, causes logging
 with GsFile(C)>>gciLogSever:  of class creation / equivalence.

 Preserve the Rowan packaging of the class if the class is already packaged.

 Returns oldClass if it would be equivalent to the requested new class.
 (See the class comment for Class)."

	^ self
		_rwCreateSubclass: aString
		instVarNames: anArrayOfInstvarNames
		classVars: anArrayOfClassVars
		classInstVars: anArrayOfClassInstVars
		poolDictionaries: anArrayOfPoolDicts
		inDictionary: aDictionary
		newVersionOf: oldClass
		description: aDescription
		options: optionsArray
		ifUnpackagedDo: [ 
			self
				_subclass: aString
				instVarNames: anArrayOfInstvarNames
				classVars: anArrayOfClassVars
				classInstVars: anArrayOfClassInstVars
				poolDictionaries: anArrayOfPoolDicts
				inDictionary: aDictionary
				newVersionOf: oldClass
				description: aDescription
				options: optionsArray ]
%

! Class implementation for 'CanonicalStringDictionary'

!		Instance methods for 'CanonicalStringDictionary'

category: 'Updating'
method: CanonicalStringDictionary
add: aString

"Adds aString if it is not already present in the receiver, and returns
 either aString or the canonical string already present."

| aValue |
(aString isKindOf: String) ifTrue:[
  aValue := self at: aString otherwise: nil .
  aValue == nil ifTrue:[
    aString immediateInvariant .
    self at: aString put: aString .
    ^ aString
    ].
  ^ aValue
  ].
"assume aString is an Association."
^ super add: aString
%

category: 'Updating'
method: CanonicalStringDictionary
addAll: aCollection

"Adds elements of aCollection to the receiver. Returns aCollection."

aCollection == self ifTrue:[ ^ aCollection ].
(aCollection isKindOf: AbstractDictionary)
  ifTrue:[ ^ super addAll: aCollection].
aCollection accompaniedBy: self do:[ :me :aString | me add: aString ].
^ aCollection
%

category: 'Updating'
method: CanonicalStringDictionary
addAssociation: anAssociation

"Add the argument anAssociation to the receiver."

^ super add: anAssociation
%

category: 'Private'
method: CanonicalStringDictionary
compareKey: key1 with: key2

"Returns whether key1 is equivalent to key2."

 key1 == key2 ifTrue:[ ^ true ].

 (key1 _isSymbol ~~ key2 _isSymbol)
    ifTrue:[ ^ key1 asString = key2 asString ]
   ifFalse:[ ^ key1 = key2 ].
%

category: 'Hashing'
method: CanonicalStringDictionary
hashFunction: aKey

"The hash function performs an operation on the value of the
 key (aKey) and returns a value in the range 1..tableSize."

^((self _hashOfKey: aKey) \\  self tableSize) + 1
%

category: 'Accessing'
method: CanonicalStringDictionary
includes: aString

"Returns true if the receiver contains aString as a key, false otherwise."

| aValue |
aValue := self at: aString otherwise: nil .
^ aValue ~~ nil
%

category: 'Accessing'
method: CanonicalStringDictionary
includesValue: aString

"Returns true if the receiver contains aString as a key, false otherwise."

| aValue |
aValue := self at: aString otherwise: nil .
^ aValue ~~ nil
%

category: 'Updating'
method: CanonicalStringDictionary
remove: aString

"Removes aString if present in the receiver and returns the removed value.  If
 aString is not present, generates an error."

^ self removeKey: aString
%

category: 'Updating'
method: CanonicalStringDictionary
remove: aString ifAbsent: aBlock

"Removes aString if present in the receiver and returns the removed value.  If
 aString is not present, returns the result of evaluating the zero
 argument Block aBlock."

^ self removeKey: aString ifAbsent: aBlock
%

category: 'Testing'
method: CanonicalStringDictionary
_isLarge

"Returns true if the object is implemented as a tree of private smaller objects"

^ true
%

category: 'Repository Conversion'
method: CanonicalStringDictionary
_migrateSymbolSet: aSymbolSet

"Using the receiver as the canonicalization dictionary, migrate aSymbolSet
 to an IdentitySet of canonical Strings, and return the IdentitySet."

| newSet |

((aSymbolSet isKindOf: SymbolSet) or:[
   aSymbolSet isKindOf: (Globals at:#ObsoleteSymbolSet
                                ifAbsent:[ ObsoleteClasses at: #ObsoleteSymbolSet ])])
  ifTrue:[
  newSet := IdentitySet new .
  aSymbolSet do:[ :aSym | | aStr groupStr |
    aStr := String withAll: aSym .
    groupStr := self add: aStr .
    newSet add: groupStr .
    ].
  newSet objectSecurityPolicy: aSymbolSet objectSecurityPolicy .
  ^ newSet
  ].

^ aSymbolSet
%

category: 'Accessing'
method: CanonicalStringDictionary
_validateGroupString: aString

| aValue |
aValue := self at: aString otherwise: nil .
aValue == nil ifTrue:[
  aString _error: #segErrBadGroup .
  ^ nil
].
^ aValue
%

! Class implementation for 'IndentingStream'

!		Class methods for 'IndentingStream'

category: 'Instance creation'
classmethod: IndentingStream
newPrinting

^ self new stream: (PrintStream on: String new )
%

category: 'Instance creation'
classmethod: IndentingStream
on: aStream
  ^self new stream: aStream
%

!		Instance methods for 'IndentingStream'

category: 'Instance creation'
method: IndentingStream
contents
^ stream contents
%

category: 'Instance creation'
method: IndentingStream
cr
        stream cr.
        indentLevel timesRepeat: [stream nextPutAll: '  ']
%

category: 'Instance creation'
method: IndentingStream
do: aCollection
| first idx |
first := true .
self indentMore ; nextPutAll: ' ( '.
idx := 1.
aCollection do:[:aNode|
  first ifFalse:[ self cr ].
  first := false .
  self nextPutAll: idx asString ; nextPut: $: .
  aNode printFormattedOn: self .
  idx := idx + 1 .
].
self indentLess; nextPutAll: ' )'; cr .
%

category: 'Instance creation'
method: IndentingStream
indentLess
        indentLevel := indentLevel - 1
%

category: 'Instance creation'
method: IndentingStream
indentMore
        indentLevel := indentLevel + 1
%

category: 'Instance creation'
method: IndentingStream
nextPut: aChar
  " assume aChar is not  CR "
  stream nextPut: aChar
%

category: 'Instance creation'
method: IndentingStream
nextPutAll: aCollection
        stream nextPutAll: aCollection
%

category: 'Instance creation'
method: IndentingStream
print: aLabel bool: aBoolean
  stream nextPutAll: aLabel ; nextPutAll: aBoolean asString
%

category: 'Instance creation'
method: IndentingStream
print: aLabel int: anInteger
  stream nextPutAll: aLabel ; nextPutAll: anInteger asString
%

category: 'Instance creation'
method: IndentingStream
print: aLabel symbol: aSymbol
  stream nextPutAll: aLabel ; nextPutAll: aSymbol printString
%

category: 'Instance creation'
method: IndentingStream
space
   stream space
%

category: 'Instance creation'
method: IndentingStream
stream: aStream
    indentLevel := 0.
    stream := aStream
%

! Class implementation for 'AbstractCharacter'

!		Class methods for 'AbstractCharacter'

category: 'other'
classmethod: AbstractCharacter
new

"(Subclass responsibility.)  Returns an instance of the receiver's class that
 has the specified internal value."

AbstractCharacter subclassResponsibility: #new
%

category: 'other'
classmethod: AbstractCharacter
new: aSize

"(Subclass responsibility.)  Returns an instance of the receiver's class that
 has the specified internal value."

AbstractCharacter subclassResponsibility: #new:
%

category: 'other'
classmethod: AbstractCharacter
withValue: anInteger

"(Subclass responsibility.)  Returns an instance of the receiver's class that
 has the specified internal value."

AbstractCharacter subclassResponsibility: #withValue:
%

!		Instance methods for 'AbstractCharacter'

category: 'other'
method: AbstractCharacter
hash

"(Subclass responsibility.)  Returns an instance of the receiver's class that
 has the specified internal value."

AbstractCharacter subclassResponsibility: #hash
%

