! Copyright (C) GemTalk Systems 1986-2026.  All Rights Reserved.
! Class Declarations
! Generated file, do not Edit

doit
(Error
	subclass: 'RwTonelParseError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Tonel-Core';
		comment: 'I''m a parsing error. 
I happen whenever the parsing of a tonel file is broken in someway.';
		immediateInvariant.
true.
%

removeallmethods RwTonelParseError
removeallclassmethods RwTonelParseError

doit
(Error
	subclass: 'STONReaderError'
	instVarNames: #(streamPosition)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'STON-Core';
		comment: 'STONReaderError is the error/exception signalled by STONReader when illegal/incorrect input is seen. 
';
		immediateInvariant.
true.
%

removeallmethods STONReaderError
removeallclassmethods STONReaderError

doit
(Error
	subclass: 'STONWriterError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'STON-Core';
		comment: 'STONWriterError is the error/exception signalled by STONWriter when illegal/incorrect input is seen. ';
		immediateInvariant.
true.
%

removeallmethods STONWriterError
removeallclassmethods STONWriterError

doit
(Notification
	subclass: 'RwTonelParseRequireMethodCategoryNotification'
	instVarNames: #(className isMeta selector)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Tonel-Core';
		comment: 'The receiver is signalled when the RwTonelParser is about to create a method definition with no method category defined.

If the caller wants to continue, #resume: the notification with the value of the category to be used.

If unhandled,  a RwTonelParseError is signalled.';
		immediateInvariant.
true.
%

removeallmethods RwTonelParseRequireMethodCategoryNotification
removeallclassmethods RwTonelParseRequireMethodCategoryNotification

doit
(Object
	subclass: 'RwTonelParser'
	instVarNames: #(packageReader stream lastSelectorParsed)
	classVars: #(Character_lf)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Tonel-Core';
		comment: 'I''m a parser for tonel files. 
I parse a class with the following format: 

Tonel spec
====

    [comment]
    type { typeDefinition }
    (
        [{ methodMetadata }]
        method [
            methodBody ] 
    )*


comment
---
"
comment string
"
is optional (but it should be there, in good design ;)

type
---
Class|Trait|Extension

typeDefinition
---
a STON file with class/trait/extension metadata

methodMetadata
---
a STON file with method metadata
is optional (but also, recommended)

method
---
method declaration as this: 

Class[ class] >> selector

methodBody 
---
the method body (we do not parse contents, that''s class builder task)';
		immediateInvariant.
true.
%

removeallmethods RwTonelParser
removeallclassmethods RwTonelParser

doit
(Object
	subclass: 'RwTopazTonelReader'
	instVarNames: #(environmentId theClassName)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'Rowan-Tonel-Core';
		comment: 'Support class for topaz `tfile` and `tmethod` commands.

`tmethod`
	Read and compile a single tonal format method from a given string

`tfile`
	Read a single tonel format class from a file and compile the methods within that file. Definition/redefinition of the class not implemented yet.';
		immediateInvariant.
true.
%

removeallmethods RwTopazTonelReader
removeallclassmethods RwTopazTonelReader

doit
(Object
	subclass: 'STON'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'STON-Core';
		comment: 'STON implements serialization and materialization using the Smalltalk Object Notation format.
 
S y n t a x

	value
	  primitive-value
	  object-value
	  reference
	  nil
	primitive-value
	  number
	  true
	  false
	  symbol
	  string
	object-value
	  object
	  map
	  list
	object
	  classname map
	  classname list
	reference
	  @ int-index-previous-object-value
	map
	  {}
	  { members }
	members
	  pair
	  pair , members
	pair
	  string : value
	  symbol : value
	  number : value
	list
	  []
	  [ elements ]
	elements
	  value 
	  value , elements
	string
	  ''''
	  '' chars ''
	chars
	  char
	  char chars
	char
	  any-printable-ASCII-character-
	    except-''-"-or-\
	  \''
	  \"
	  \\
	  \/
	  \b
	  \f
	  \n
	  \r
	  \t
	  \u four-hex-digits
	symbol
	  # chars-limited
	  # '' chars ''
	chars-limited
	  char-limited
	  char-limited chars-limited
	char-limited
	  a-z A-Z 0-9 - _ . /
	classname
	  uppercase-alpha-char alphanumeric-char
	number
	  int
	  int frac
	  int exp
	  int frac exp
	int
	  digit
	  digit1-9 digits 
	  - digit
	  - digit1-9 digits
	frac
	  . digits
	exp
	  e digits
	digits
	  digit
	  digit digits
	e
	  e
	  e+
	  e-
	  E
	  E+
	  E-
';
		immediateInvariant.
true.
%

removeallmethods STON
removeallclassmethods STON

doit
(Object
	subclass: 'STONReader'
	instVarNames: #(readStream objects classes unresolvedReferences stringStream allowComplexMapKeys stack)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'STON-Core';
		comment: 'STONReader materializes objects using the Smalltalk Object Notation format.

This parser is backwards compatible with standard JSON.';
		immediateInvariant.
true.
%

removeallmethods STONReader
removeallclassmethods STONReader

doit
(Object
	subclass: 'STONReference'
	instVarNames: #(index)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'STON-Core';
		comment: 'STONReference holds a forward reference to another object during materialization.
';
		immediateInvariant.
true.
%

removeallmethods STONReference
removeallclassmethods STONReference

doit
(Object
	subclass: 'STONStreamWriter'
	instVarNames: #(writer first)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'STON-Core';
		comment: 'STONStreamWriter helps in streaming writing STON representations.
This is an abstract class.';
		immediateInvariant.
true.
%

removeallmethods STONStreamWriter
removeallclassmethods STONStreamWriter

doit
(STONStreamWriter
	subclass: 'STONListWriter'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'STON-Core';
		comment: 'STONArrayWriter helps in writing array based STON representations.
';
		immediateInvariant.
true.
%

removeallmethods STONListWriter
removeallclassmethods STONListWriter

doit
(STONListWriter
	subclass: 'STONShortListWriter'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'STON-Core';
		comment: 'STONShortArrayWriter helps in writing short array based STON representations.
';
		immediateInvariant.
true.
%

removeallmethods STONShortListWriter
removeallclassmethods STONShortListWriter

doit
(STONStreamWriter
	subclass: 'STONMapWriter'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'STON-Core';
		comment: 'STONDictionaryWriter helps in writing dictionary based STON representations.';
		immediateInvariant.
true.
%

removeallmethods STONMapWriter
removeallclassmethods STONMapWriter

doit
(Object
	subclass: 'STONWriter'
	instVarNames: #(writeStream prettyPrint newLine jsonMode referencePolicy level objects)
	classVars: #(STONCharacters STONSimpleSymbolCharacters)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: RowanKernel
	options: #( #logCreation )
)
		category: 'STON-Core';
		comment: 'STONWriter serializes objects using the Smalltalk Object Notation format. 

Customization options are:

- prettyPrint <Boolean> default is false
	if true, produce pretty printed output
- jsonMode <Boolean> default is false
	if true, the follow changes occur
	- strings are delimited with double quotes
	- nil is encoded as null
	- symbols are treated as strings
	- only STON listClass and STON mapClass instances are allowed as composite objects
	it is wise to also use either #error or #ignore as referencePolicy to avoid references
- referencePolicy <#normal|#ignore|#error> default is #normal
	if #normal, track and count object references and use references to implement sharing and break cycles
	if #error, track object references and signal STONWriterError when a shared reference is encountered
	if #ignore, don''t track object references which might loop forever on cycles
 ';
		immediateInvariant.
true.
%

removeallmethods STONWriter
removeallclassmethods STONWriter

! Class implementation for 'STONReaderError'

!		Class methods for 'STONReaderError'

category: 'instance creation'
classmethod: STONReaderError
signal: aString streamPosition: streamPosition 
	^ self new
		streamPosition: streamPosition;
		signal: aString;
		yourself
%

!		Instance methods for 'STONReaderError'

category: 'accessing'
method: STONReaderError
buildMessageText
	streamPosition ifNotNil: [ :pos | 
    self details: 'Error at character position ', pos asString 
  ].
  super buildMessageText .
%

category: 'accessing'
method: STONReaderError
streamPosition
	^ streamPosition
%

category: 'accessing'
method: STONReaderError
streamPosition: aNumber
	streamPosition := aNumber
%

! Class implementation for 'RwTonelParseRequireMethodCategoryNotification'

!		Class methods for 'RwTonelParseRequireMethodCategoryNotification'

category: 'instance creation'
classmethod: RwTonelParseRequireMethodCategoryNotification
className: className isMeta: isMeta selector: selector
	^ self new
		className: className;
		isMeta: isMeta;
		selector: selector;
		yourself
%

!		Instance methods for 'RwTonelParseRequireMethodCategoryNotification'

category: 'accessing'
method: RwTonelParseRequireMethodCategoryNotification
className
	^className
%

category: 'accessing'
method: RwTonelParseRequireMethodCategoryNotification
className: object
	className := object
%

category: 'Handling'
method: RwTonelParseRequireMethodCategoryNotification
defaultAction
	"handle and resume: with the desired method category to be used to avoid error"

	RwTonelParseError
		signal:
			'Missing method category for ' , self className
				,
					(self isMeta
						ifTrue: [ ' class >> ' ]
						ifFalse: [ ' >> ' ]) , self selector
%

category: 'accessing'
method: RwTonelParseRequireMethodCategoryNotification
isMeta
	^isMeta
%

category: 'accessing'
method: RwTonelParseRequireMethodCategoryNotification
isMeta: object
	isMeta := object
%

category: 'accessing'
method: RwTonelParseRequireMethodCategoryNotification
selector
	^selector
%

category: 'accessing'
method: RwTonelParseRequireMethodCategoryNotification
selector: object
	selector := object
%

! Class implementation for 'RwTonelParser'

!		Class methods for 'RwTonelParser'

category: 'initialization'
classmethod: RwTonelParser
initialize
	self _addInvariantClassVar: #Character_lf value: Character lf
%

category: 'accessing'
classmethod: RwTonelParser
lineEnding
  "Answer the os-specific line endings.  See also #lineEndingSize if changing "

  ^ String with: Character_lf
%

category: 'instance creation'
classmethod: RwTonelParser
on: aStream forReader: aTonelReader
	^ self new 
		stream: aStream;
		packageReader: aTonelReader;
		yourself
%

category: 'instance creation'
classmethod: RwTonelParser
onString: aString forReader: aTonelReader
  ^ self on: (self readStreamClass on: aString) forReader: aTonelReader
%

category: 'parsing'
classmethod: RwTonelParser
parseStream: aStream forReader: aTonelReader
	^ (self on: aStream forReader: aTonelReader)
		 start
%

category: 'parsing'
classmethod: RwTonelParser
parseString: aString forReader: aTonelReader
	^ self parseStream: (self readStreamClass on: aString) forReader: aTonelReader
%

category: 'accessing'
classmethod: RwTonelParser
readStreamClass

	^ ReadStreamPortable
%

category: 'accessing'
classmethod: RwTonelParser
writeStreamClass

	^ WriteStreamPortable
%

!		Instance methods for 'RwTonelParser'

category: 'private'
method: RwTonelParser
cleanSelector: aString
	"BEWARE: I'm doing some heave assumptions here: I'm removing just ONE space (in case there 
	 is one) because I expect this to be a file generated by tonel, and tonel adds one space 
	 before start with the method body to make the format more readable. 
	 But of course this is not very good :("
  aString size == 0 ifTrue:[ RwTonelParseError signal:'empty selector string' ].
	^ (aString last = Character space
		ifTrue: [ aString allButLast ]
		ifFalse: [ aString ]) 
		trimLeft
%

category: 'parsing'
method: RwTonelParser
comment
	| result ch eatNext |
	
	result := String new writeStreamPortable.

	eatNext := false.
	stream next = $" ifFalse: [ RwTonelParseError signal: 'Can''t parse comment' ].	
	[ stream atEnd not 
		and: [ 
				(ch := stream next) ~= $" 
				or: [ eatNext := (stream peek = $") ] ] ]
	whileTrue: [ 
		result nextPut: ch.
		eatNext ifTrue: [ 
			stream skip: 1.
			eatNext := false ] ].
	
	^ self 
		removeFrom: '"',result contents,'"' 
		enclosingStart: $" 
		end: $"
%

category: 'private factory'
method: RwTonelParser
definitionForType: aString
  ^ self packageReader definitionForType: aString
%

category: 'parsing'
method: RwTonelParser
document
	^ { 
	self typeDef.
	self methodDefList.
	 } 
	select: [:each | each notNil ]
%

category: 'error handling'
method: RwTonelParser
error: messageText
	^ RwTonelParseError signal: messageText
%

category: 'private'
method: RwTonelParser
extractSelector: aString
	| separators selectorStream keywords |
	
	separators := { 
		Character space. 
		Character tab. 
		Character lf. 
		Character newPage. 
		Character cr. 
		$:}.

	keywords := Array new writeStreamPortable.
	selectorStream := aString readStream.
	[ selectorStream atEnd ]
	whileFalse: [ | word ch |
		word := String new writeStreamPortable.
		[ selectorStream atEnd not and: [ (separators includes: (ch := selectorStream next)) not ] ]
		whileTrue: [ word nextPut: ch ].
		ch = $: ifTrue: [ word nextPut: ch ]. 
		word contents trimBoth ifNotEmpty: [ :v | keywords nextPut: v ] ].
	keywords := keywords contents.

	^ (keywords size <= 2 
		ifTrue: [ keywords first]
		ifFalse: [ ('' join: (keywords pairsCollect: [ :keyword :argument | keyword ])) ])
		asSymbol
%

category: 'testing'
method: RwTonelParser
isEnter: aCharacter
	^ #(13 10) includes: aCharacter asciiValue
%

category: 'testing'
method: RwTonelParser
isSeparator: aCharacter 
	^ aCharacter isSeparator
%

category: 'parsing'
method: RwTonelParser
metadata
	| result ch count |
	
	result := String new writeStreamPortable.

	count := 0.
	stream peek = ${ ifFalse: [ RwTonelParseError signal: 'Can''t parse metadata' ].	
	[ stream atEnd not ]
	whileTrue: [ 
		ch := stream next.
		result nextPut: ch.
		ch = ${ ifTrue: [ count := count +1 ].
		ch = $} ifTrue: [ count := count -1 ].
		count = 0 ifTrue: [ ^ STON fromString: result contents ]].

	RwTonelParseError signal: 'Can''t parse metadata'
%

category: 'parsing'
method: RwTonelParser
method
	| type selector |
	
	type := self untilIncluding: '>>'.
	selector := self cleanSelector: (self untilExcluding: '[').
	type := type trimBoth substrings: ' '.
	type size = 1 ifTrue: [ type := type copyWith: nil ].
  lastSelectorParsed := selector .
	^ { 
		type.
		selector.
	}
%

category: 'parsing'
method: RwTonelParser
methodBody
	"I read a methodbody (what is inside [ ... ])
	 Since a method body can contain enclosing brackets we need to be sure we will skip them and
	 correctly read the method. For that, I have to take into account: 
		- I can mention [] in comments
		- I can mention [] in strings
		- I can use $[, $] 
		- I can have inner blocks
		- I can mention a comment of the form ""$"" or a comment of the form '$'
	 all that needs to be skipped "
	| result char prevChar comment string count startPos |
	
	result := self class writeStreamClass on: String new.

	comment := false.
	string := false.
	prevChar := nil.
	count := 0.
        startPos := stream position .
        "startBody := stream peek: 300 ." "uncomment for debugging parse problems"
	stream peek = $[ ifFalse: [ RwTonelParseError signal: 'Can''t parse method body' ].
	[ stream atEnd not ]
	whileTrue: [ 
		char := stream next.
		result nextPut: char.
		(char = $" and: [ string not and: [ prevChar ~= $$ or: [ comment ] ] ]) 
			ifTrue: [ comment := comment not ]. 
		(char = $' and: [ comment not and: [ prevChar ~= $$ or: [ string ] ] ]) 
			ifTrue: [ string := string not ]. 
		(comment or: [ string ]) ifFalse: [ 
			(char = $[ and: [  prevChar ~= $$ ]) ifTrue: [ count := count +1 ].
			(char = $] and: [ prevChar ~= $$ ]) ifTrue: [ count := count -1 ] ].
		count = 0 ifTrue: [ 
			^ self 
				removeFrom: result contents 
				enclosingStart: $[ 
				end: $]
				clean: #right ].
		prevChar := char ].

	RwTonelParseError signal: 'Can''t parse method body'
%

category: 'parsing'
method: RwTonelParser
methodDef

	| methodDef |
	self methodDef: [:isMeta :mDef |
		methodDef :=  mDef.
		"skip possible spaces at the end"
		self separator ].
	^methodDef
%

category: 'parsing'
method: RwTonelParser
methodDef: aBlock
  | ar def offset |
  ar := {
    self separator.
    self try: [ self metadata ].
    self separator.
    [ offset := stream position . self method ] value .
    self methodBody
  }.
  (def := self newMethodDefinitionFrom: ar )
    offset: offset
    inFile: stream wrappedStreamName .

  aBlock
    value: ar fourth first second notNil
    value: def
%

category: 'parsing'
method: RwTonelParser
methodDefList
	| result classStream instanceStream |
	self separator. "to arrive to the end of the file in case there are no methods"
	result := { {}. {} }.
	classStream := (result at: 1) writeStreamPortable.
	instanceStream := (result at: 2) writeStreamPortable.
	[
		[ stream atEnd ]
			whileFalse: [ 
				self methodDef: [:isMeta :mDef |
					isMeta
						ifTrue: [ classStream nextPut: mDef ]
						ifFalse: [ instanceStream nextPut: mDef ].
					"skip possible spaces at the end"
					self separator ]
			] 
  ] on: (RwTonelParseError,STONReaderError,STONWriterError) do:[:ex | 
    lastSelectorParsed ifNotNil:[ | str |
      str := ex details ifNil:[ '' ].
      ex details: str, ', last method parsed: ', lastSelectorParsed printString
    ].
    ex pass 
  ].
  ^ result
%

category: 'private factory'
method: RwTonelParser
newMethodDefinitionFrom: anArray
	| metadata className meta selector source categ |
	metadata := anArray second ifNil: [ Dictionary new ].
	className := anArray fourth first first.	"avoid asSymbol sent to className before error checks."
	[ Metaclass3 _validateNewClassName: className asSymbol ]
		on: Error
		do: [ :ex | self error: 'Invalid class name ' , className printString ].
	meta := anArray fourth first second notNil.
	selector := self extractSelector: anArray fourth second trimBoth.
	source := String
		streamContents: [ :s | 
			s << anArray fourth second.
			anArray fifth ifNotEmpty: [ :src | s << src ] ].

	categ := metadata
		at: #'category'
		ifAbsent: [ 
			"to avoid error, resume with default category string"
			(RwTonelParseRequireMethodCategoryNotification
				className: className
				isMeta: meta
				selector: selector) signal ].

	^ self packageReader
		newMethodDefinitionForClassNamed: className
		classIsMeta: meta
		selector: selector
		category: categ
		source: source
%

category: 'private factory'
method: RwTonelParser
newTypeDefinitionFrom: anArray
	^ self packageReader newTypeDefinitionFrom: anArray
%

category: 'accessing'
method: RwTonelParser
packageReader
	^ packageReader
%

category: 'accessing'
method: RwTonelParser
packageReader: aPackageReader 
	packageReader := aPackageReader
%

category: 'private'
method: RwTonelParser
removeFrom: aString enclosingStart: startChar end: endChar
	^ self 
		removeFrom: aString 
		enclosingStart: startChar 
		end: endChar
		clean: #both
%

category: 'private'
method: RwTonelParser
removeFrom: aString enclosingStart: startChar end: endChar clean: cleanSymbol
  "cleanSymbol can be #left, #rigth and #both"

  | result stop ch start end |
  result := self class readStreamClass on: aString trimBoth.
  result peek = startChar
    ifFalse: [ RwTonelParseError signal: 'I cannot remove enclosing start' ].
  result skip: 1.
  (#(#'both' #'left') includes: cleanSymbol)
    ifTrue: [ 
      stop := self class lineEnding size.
      [ stop > 0 and: [ self isSeparator: (ch := result peek) ] ]
        whileTrue: [ 
          (self isEnter: ch)
            ifTrue: [ stop := stop - 1 ].
          result skip: 1 ] ].
  start := result position.
  result setToEnd.
  result skip: -1.
  result peek = endChar
    ifFalse: [ RwTonelParseError signal: 'I cannot remove enclosing end' ].
  result skip: -1.
  (#(#'both' #'right') includes: cleanSymbol)
    ifTrue: [ 
      stop := self class lineEnding size.
      [ stop > 0 and: [ self isSeparator: (ch := result peek) ] ]
        whileTrue: [ 
          (self isEnter: ch)
            ifTrue: [ stop := stop - 1 ].
          result skip: -1 ] ].
  end := result position.
  ^ result contents copyFrom: start + 1 to: end + 1
%

category: 'parsing'
method: RwTonelParser
separator
	[ stream atEnd not and: [ self isSeparator: stream peek ] ]
	whileTrue: [ stream next ].
	^ nil
%

category: 'parsing'
method: RwTonelParser
shebang
	"look for a '#!' in first two character position and skip to next line if present"

	(stream peekFor: $#) ifFalse: [ ^ nil ].	
	(stream peekFor: $!) ifFalse: [ ^ nil ].
	^ stream  upTo: Character lf.
%

category: 'accessing'
method: RwTonelParser
start
	^ self document
%

category: 'accessing'
method: RwTonelParser
stream: aStream 
	stream := aStream
%

category: 'private parsing'
method: RwTonelParser
try: aBlock
	^ self 
		try: aBlock 
		onSuccess: [ :parsedValue | parsedValue ] 
		onFailure: [ nil ]
%

category: 'private parsing'
method: RwTonelParser
try: aBlock onSuccess: successBlock
	^ self 
		try: aBlock 
		onSuccess: successBlock 
		onFailure: [ nil ]
%

category: 'private parsing'
method: RwTonelParser
try: aBlock onSuccess: successBlock onFailure: failureBlock
	| pos |
	
	pos := stream position.
	[ ^ successBlock value: aBlock value ]
	on: RwTonelParseError 
	do: [ :e | 
		stream position: pos.
		^ failureBlock value ]. 
	
%

category: 'parsing'
method: RwTonelParser
type
	self try: [ self word: 'Class' ] onSuccess: [ :word | ^ word  ].
	self try: [ self word: 'Trait' ] onSuccess: [ :word | ^ word  ].
	self try: [ self word: 'Extension' ] onSuccess: [ :word | ^ word  ].
	
	"at end"
	RwTonelParseError signal: 'Can''t parse type.'	
%

category: 'parsing'
method: RwTonelParser
typeDef
	| shebang |
	shebang := self shebang. "ignore shebang on first line of file if present"
	^ self newTypeDefinitionFrom: { 
		self separator.
		self try: [ self comment ]. 
		self separator. 
		self type. 
		self separator. 
		self try: [ 
			| typeMetadata normalizedMetadata |
			typeMetadata := self metadata.
			normalizedMetadata := Dictionary new.
			typeMetadata keysAndValuesDo: [:key :value |
				normalizedMetadata at: key asLowercase asSymbol put: value ].
			normalizedMetadata at: #shebang put: shebang.
			normalizedMetadata ] 
	}
%

category: 'private parsing'
method: RwTonelParser
untilExcluding: aCollection
	| result |
	result := stream upToAll: aCollection.
	stream position: stream position - aCollection size.
	^ result
%

category: 'private parsing'
method: RwTonelParser
untilIncluding: aCollection
	^ stream upToAll: aCollection
%

category: 'private parsing'
method: RwTonelParser
word: aString
	| result |
	result := stream next: aString size.
	result = aString
		ifFalse: [ RwTonelParseError signal: 'Can''t parse ', aString ].
	^ result
%

! Class implementation for 'RwTopazTonelReader'

!		Class methods for 'RwTopazTonelReader'

category: 'instance creation'
classmethod: RwTopazTonelReader
forEnvironmentId: environmentId
	"Create a new instance of the receiver that will compile methods using environmentId"

	^ self new
		environmentId: environmentId;
		yourself
%

category: 'topaz support'
classmethod: RwTopazTonelReader
topazCompileTonelMethod: aString
	"Read and compile a single tonal format method from a given string.
		For topaz TMETHOD command"

	^ self topazCompileTonelMethod: aString envId: 0
%

category: 'topaz support'
classmethod: RwTopazTonelReader
topazCompileTonelMethod: aString envId: envId
	"Read and compile a single tonal format method (category plush method block) from a given string.
		For topaz TMETHOD command"

	| strm parser warnStr |
	strm := ReadStreamPortable on: aString.

	parser := RwTonelParser on: strm forReader: (self forEnvironmentId: envId).

	[ parser methodDef ]
		on: CompileWarning
		do: [ :ex | 
			warnStr := ex warningString.
			ex resume ].
	^ warnStr	"nil if no warnings"
%

category: 'topaz support'
classmethod: RwTopazTonelReader
topazReadTonelFile: filePath
	"Read a single tonel format class from a file and compile the methods within that file. 
		Definition/redefinition of the class not implemented yet.
		For topaz TFILE command"

	^ self topazReadTonelFile: filePath envId: 0
%

category: 'topaz support'
classmethod: RwTopazTonelReader
topazReadTonelFile: filePath envId: envId
	"Read a single tonel format class from a file and compile the methods within that file. 
		Definition/redefinition of the class not implemented yet.
		For topaz TFILE command"

	| warningsEnabled |
	warningsEnabled := Notification signallingEnabled.
	[ 
	| gsfile stream errBlk warnBlk |
	Notification enableSignalling.	"compile warnings can be logged"
	gsfile := GsFile openReadOnServer: filePath.
	gsfile ifNil: [ self error: 'file ' , filePath printString , ' not found' ].
	stream := ReadStreamPortable on: gsfile contents.
	gsfile close.
	errBlk := [ :ex | 
	(ex isKindOf: CompileError)
		ifTrue: [ 
			GsFile
				gciLogServer:
					'CompileError encountered '
						, (self _lineNumberStringForOffset: stream position fileName: filePath) ]
		ifFalse: [ 
			ex
				addText:
					(self _lineNumberStringForOffset: stream position fileName: filePath) ].
	ex pass ].
	warnBlk := [ :warn | 
	| str |
	str := warn asString.
	((str subStrings occurrencesOf: 'WARNING:') == 1
		and: [ str includesString: 'not optimized' ])
		ifFalse: [ GsFile gciLogServer: warn asString ].
	warn resume ].
	[ self topazReadTonelStream: stream envId: envId ]
		onException:
			{STONReaderError.
			RwTonelParseError.
			Error.
			Warning}
		do:
			{errBlk.
			errBlk.
			errBlk.
			warnBlk} ]
		ensure: [ 
			warningsEnabled
				ifFalse: [ Notification disableSignalling ] ]
%

category: 'topaz support'
classmethod: RwTopazTonelReader
topazReadTonelStream: tonelStream envId: envId
	"Used in implementation of the topaz TFILE command.
   Read a single tonel format class from a stream and compile the methods on that stream. 
   It file is  a class.st file, 
   creation of the class is attempted by RwTopazTonelReader >> createClassFrom:"

	RwTonelParser
		parseStream: tonelStream
		forReader: (self forEnvironmentId: envId)
%

category: 'private'
classmethod: RwTopazTonelReader
_lineNumberStringForOffset: offset fileName: fName
	| res |
	res := '  (Unable to determine line number)'.
	[ 
	| buf lNum |
	buf := fName asFileReference contents.
	buf size > offset
		ifTrue: [ buf size: offset ].
	lNum := 1 + (buf occurrencesOf: Character lf).
	res := ' near line ' , lNum asString , ' in file ' , fName ]
		on: Error
		do: [ :ex | 
			"ignore"
			 ].
	^ res
%

!		Instance methods for 'RwTopazTonelReader'

category: 'tonel parser interface'
method: RwTopazTonelReader
createClassFrom: anArray
  "Execute class creation.  
   The typical use cases are filein of tonel files from tests/ernie , 
   or slowfilein or patching of a base image using topaz.
   Signal an error if the creation creates a new version of the class .
   If the class is found in the symbolList , 
   argument to inDictionary: is the dictionary in which it was found. 
   If class not found in the symbolList and we are SystemUser and not in a solo session,
   the arg to inDictionary: will be Globals, 
   else the arg will be UserGlobals of the current session."

  | dict instVars classVars superN name categ knownKeys xKeys sess intoDict 
    oldClass theClass  options type keys superCls classInstVars comment resOop | 
  dict := anArray at: 6 .
  knownKeys := IdentitySet withAll:#( name superclass instvars classvars classinstvars 
                                           category gs_options type shebang gs_reservedoop ).
  keys := IdentitySet new .
  dict keys do:[:k|  keys add: k asSymbol ].
  (xKeys := keys - knownKeys) size > 0 
    ifTrue:[ Error signal:'unknown keys ', (Array withAll: xKeys) printString ].
  sess := GsCurrentSession currentSession .
  (superCls := (sess resolveSymbol: (superN := (dict at: #superclass ) asSymbol))) 
     ifNil:[ Error signal: superN , ' not found' ].
  superCls := superCls _value .
  superCls ifNil:[ Error signal: superN , ' not defined yet' ].  
  name := dict at: #name .
  self theClassName: name .
  categ := dict at: #category otherwise: nil .
  instVars := dict at: #instvars otherwise: #() .
  classVars := dict at: #classvars otherwise: #() .
  classInstVars := dict at: #classinstvars otherwise: #() .
  options := dict at: #gs_options otherwise: #() .
  1 to: options size do:[:j | | opt |
    (opt := Symbol _existingWithAll:( options at: j)) ifNil:[
      Error signal:'invalid option ', opt printString .
    ].
    options at: j put: opt.
  ].
  comment := anArray at: 2 .
  type := dict at: #type otherwise: nil .
  (sess symbolList dictionariesAndAssociationsOf: name asSymbol) ifNotNil:[:ary | | pair |
    ary size > 1 ifTrue:[ Error signal:'More than one definition in symbolList for ', name ].
    pair := ary at: 1 .
    oldClass := (pair at: 2) _value  .
    intoDict := (pair at: 1) 
  ].
  intoDict ifNil:[ 
    intoDict := ((System myUserProfile userId = 'SystemUser') and:[ sess isSolo not]) 
               ifTrue:[ Globals ] 
              ifFalse:[ (sess resolveSymbol: #UserGlobals) _value ].
  ].
  resOop := dict at: #gs_reservedoop otherwise: nil .
  theClass := superCls .
  type ifNil:[
    resOop ifNotNil:[
      theClass := superCls _newKernelSubclass: name 
         instVarNames: instVars classVars: classVars classInstVars: classInstVars
          poolDictionaries:#() inDictionary: intoDict options: options reservedOop: resOop
    ] ifNil:[
      theClass := superCls subclass: name 
         instVarNames: instVars classVars: classVars classInstVars: classInstVars
          poolDictionaries:#() inDictionary: intoDict options: options .
    ]
  ] ifNotNil:[
    type = 'variable' ifTrue:[
      resOop ifNotNil:[
        theClass := superCls _newKernelIndexableSubclass: name 
         instVarNames: instVars classVars: classVars classInstVars: classInstVars
          poolDictionaries:#() inDictionary: intoDict options: options reservedOop: resOop
      ] ifNil:[
        theClass := superCls indexableSubclass: name 
         instVarNames: instVars classVars: classVars classInstVars: classInstVars
          poolDictionaries:#() inDictionary: intoDict options: options .
      ]
    ].
    type = 'byteSubclass' ifTrue:[
      instVars size ~~ 0 ifTrue:[ Error signal:'instVars not allowed on a byte subclass'].
      resOop ifNotNil:[
        classInstVars size ~~ 0 ifTrue:[ Error signal:' classInstVars not allowed'].
        theClass := superCls _newKernelByteSubclass: name 
          classVars: classVars poolDictionaries:#() inDictionary: intoDict 
             options: options reservedOop: resOop
      ] ifNil:[
        theClass := superCls byteSubclass: name 
         classVars: classVars classInstVars: classInstVars
          poolDictionaries:#() inDictionary: intoDict options: options .
      ].
    ].
    theClass ifNil:[ Error signal:'unsupported type ', type printString ].
  ].
  (oldClass ~~ nil and:[ oldClass ~~ theClass]) ifTrue:[ 
    GsFile gciLogServer:'--- old class: ' , oldClass definition .
    GsFile gciLogServer:'--- new class: ' , theClass definition .
    Error signal:'new version of ', name, ' created'.
  ].
  comment ifNotNil:[ theClass comment: comment ].
%

category: 'accessing'
method: RwTopazTonelReader
environmentId
	^ environmentId ifNil: [ environmentId := 0 ]
%

category: 'accessing'
method: RwTopazTonelReader
environmentId: object
	environmentId := object
%

category: 'tonel parser interface'
method: RwTopazTonelReader
newMethodDefinitionForClassNamed: className classIsMeta: meta selector: selector category: category source: source
	"for topaz TFILE and TMETHOD commands, compile the method instead of creating a method definition"

	| behavior symbolList |
	symbolList := GsCurrentSession currentSession symbolList.
	(self theClassName notNil and: [ className ~= self theClassName ]) "tmethod command uses className to identify the target class" 
		ifTrue: [ 
			self
				error:
					'The name of the class (', className printString, ') specified for the method ' , selector printString
						, ' does not match the name of class (', self theClassName printString, ') declared in this tonel class file' ].
	behavior := symbolList objectNamed: className asSymbol.
	meta
		ifTrue: [ behavior := behavior class ].
	behavior
		compileMethod: source
		dictionaries: symbolList
		category: category
		environmentId: self environmentId
%

category: 'tonel parser interface'
method: RwTopazTonelReader
newTypeDefinitionFrom: anArray
  | knd |
  (knd := anArray at: 4) = 'Class' ifTrue:[
    self createClassFrom: anArray
  ] ifFalse:[
    knd = 'Extension' ifTrue:[ | name dict |
      dict := anArray at: 6 .
      name := dict at: #name .
      theClassName := name .
    ] ifFalse:[ Error signal: 'uknown tonel file kind ', knd printString ]
  ].
%

category: 'method definition'
method: RwTopazTonelReader
offset: anInteger inFile: aFileName
	"message sent to method definitions ... avoid MNU"
%

category: 'accessing'
method: RwTopazTonelReader
theClassName
	^theClassName
%

category: 'accessing'
method: RwTopazTonelReader
theClassName: object
	theClassName := object
%

! Class implementation for 'STON'

!		Class methods for 'STON'

category: 'convenience'
classmethod: STON
fromStream: readStream
	^ (self reader on: readStream) next
%

category: 'convenience'
classmethod: STON
fromString: string
  ^ self fromStream: string readStream
%

category: 'accessing'
classmethod: STON
jsonWriter
	^ STONWriter new
		  jsonMode: true;
		  yourself
%

category: 'accessing'
classmethod: STON
listClass
	^ Array
%

category: 'accessing'
classmethod: STON
mapClass
	^ Dictionary
%

category: 'convenience'
classmethod: STON
put: object asJsonOnStream: stream
	(self jsonWriter on: stream) nextPut: object
%

category: 'convenience'
classmethod: STON
put: object asJsonOnStreamPretty: stream
	(self jsonWriter on: stream)
		prettyPrint: true; 
		nextPut: object
%

category: 'convenience'
classmethod: STON
put: object onStream: stream
	(self writer on: stream) nextPut: object
%

category: 'convenience'
classmethod: STON
put: object onStreamPretty: stream
	(self writer on: stream)
		prettyPrint: true; 
		nextPut: object
%

category: 'accessing'
classmethod: STON
reader
	^ STONReader new
%

category: 'convenience'
classmethod: STON
toJsonString: object
  ^ String streamContents: [ :stream | self put: object asJsonOnStream: stream ]
%

category: 'convenience'
classmethod: STON
toJsonStringPretty: object
  ^ String
    streamContents: [ :stream | self put: object asJsonOnStreamPretty: stream ]
%

category: 'convenience'
classmethod: STON
toString: object
  ^ String streamContents: [ :stream | self put: object onStream: stream ]
%

category: 'convenience'
classmethod: STON
toStringPretty: object
  ^ String streamContents: [ :stream | self put: object onStreamPretty: stream ]
%

category: 'accessing'
classmethod: STON
writer
	^ STONWriter new
%

! Class implementation for 'STONReader'

!		Class methods for 'STONReader'

category: 'instance creation'
classmethod: STONReader
new
  ^ self basicNew
    initialize;
    yourself
%

category: 'instance creation'
classmethod: STONReader
on: readStream
	^ self new
		on: readStream;
		yourself
%

!		Instance methods for 'STONReader'

category: 'initialize-release'
method: STONReader
allowComplexMapKeys: boolean
	allowComplexMapKeys := boolean
%

category: 'testing'
method: STONReader
atEnd
	^ readStream atEnd
%

category: 'initialize-release'
method: STONReader
classes

	^ classes
%

category: 'initialize-release'
method: STONReader
close
	readStream ifNotNil: [
		readStream close.
		readStream := nil ]
%

category: 'private'
method: STONReader
consumeWhitespace
	"Strip whitespaces from the input stream."

	[ readStream atEnd not and: [ readStream peek isSeparator ] ]
		whileTrue: [ readStream next ]
%

category: 'error handling'
method: STONReader
error: aString
	| streamPosition |
	"Remain compatible with streams that don't understand #position"
	streamPosition := [ readStream position ]
		on: MessageNotUnderstood do: [ nil ].
	^ STONReaderError signal: aString streamPosition: streamPosition
%

category: 'private'
method: STONReader
expectChar: character
	"Expect character and consume input and optional whitespace at the end,
	 throw an error otherwise."

	(self matchChar: character)
		ifFalse: [ self error: character asString, ' expected' ]
%

category: 'initialize-release'
method: STONReader
initialize
  objects := IdentityDictionary new.
  classes := IdentityDictionary new.
  allowComplexMapKeys := false.
  stack := OrderedCollection new.
  unresolvedReferences := 0
%

category: 'private'
method: STONReader
isClassChar: char
	^ 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789' includes: char
%

category: 'private'
method: STONReader
isClassStartChar: char
	^ 'ABCDEFGHIJKLMNOPQRSTUVWXYZ' includes: char
%

category: 'private'
method: STONReader
isSimpleSymbolChar: char
	^ 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_./' includes: char
%

category: 'private'
method: STONReader
lookupClass: name
	^ (System myUserProfile objectNamed: name asSymbol)
		ifNil: [ 
			(((AllUsers userWithId: 'SystemUser') objectNamed: 'RowanTools')
				ifNotNil: [ :rowanSymbolDictionary | 
					(rowanSymbolDictionary at: name asSymbol ifAbsent: [  ])
						ifNotNil: [ :cls | ^ cls ] ])
				ifNil: [ 
					classes
						at: name
						ifAbsentPut: [ 
							(ClassOrganizer new allSubclassesOf: Object)
								detect: [ :cls | cls stonName == name ]
								ifNone: [ 
									(((AllUsers userWithId: 'SystemUser') objectNamed: 'Rowan')
										ifNotNil: [ :rowan | rowan platform serviceClassFor: name ])
										ifNil: [ self error: 'Cannot resolve class named ' , name printString ] ] ] ] ]
%

category: 'private'
method: STONReader
match: string do: block
	"Try to read and consume string and execute block if successful.
	Else do nothing (but do not back up)"

	(string allSatisfy: [ :each | readStream peekFor: each ])
		ifTrue: [ 
			self consumeWhitespace.
			block value ]
%

category: 'private'
method: STONReader
matchChar: character
	"Tries to match character, consume input and 
	answer true if successful and consumes whitespace at the end."

	^ (readStream peekFor: character)
		ifTrue: [ 
			self consumeWhitespace.
			true ]
		ifFalse: [ false ]
%

category: 'private'
method: STONReader
newReference
	| index reference |
	index := objects size + 1.
	reference := STONReference index: index.
	objects at: index put: reference.
	^ reference
%

category: 'public'
method: STONReader
next
	| object |
	self consumeWhitespace.
	object := self parseValue.
	unresolvedReferences > 0
		ifTrue: [ self processSubObjectsOf: object ].
	^ object
%

category: 'initialize-release'
method: STONReader
on: aReadStream
	readStream := aReadStream
%

category: 'private'
method: STONReader
optimizeForLargeStructures
  "nothing special for GemStone"

%

category: 'parsing-internal'
method: STONReader
parseCharacter
  | char |
  (char := readStream next) = $\
    ifFalse: [ ^ char ].
  (#($' $" $/ $\) includes: (char := readStream next))
    ifTrue: [ ^ char ].
  char = $b
    ifTrue: [ ^ Character backspace ].
  char = $f
    ifTrue: [ ^ Character newPage ].
  char = $n
    ifTrue: [ ^ Character lf ].
  char = $r
    ifTrue: [ ^ Character cr ].
  char = $t
    ifTrue: [ ^ Character tab ].
  char = $u
    ifTrue: [ ^ self parseCharacterHex ].
  self error: 'invalid escape character \' , (String with: char)
%

category: 'parsing-internal'
method: STONReader
parseCharacterHex
  | value |
  value := self parseCharacterHexDigit.
  3 timesRepeat: [ value := (value bitShift: 4) + self parseCharacterHexDigit ].
  ^ Character codePoint: value
%

category: 'parsing-internal'
method: STONReader
parseCharacterHexDigit
	| digit |
	readStream atEnd ifFalse: [ 
		digit := readStream next asInteger.
		(digit between: "$0" 48 and: "$9" 57)
			ifTrue: [ ^ digit - 48 ].
		(digit between: "$A" 65 and: "$F" 70)
			ifTrue: [ ^ digit - 55 ].
		(digit between: "$a" 97 and: "$f" 102)
			ifTrue: [ ^ digit - 87 ] ].
	self error: 'hex-digit expected'
%

category: 'parsing-internal'
method: STONReader
parseClass
	| className |
	className := self stringStreamContents: [ :stream |
		[ readStream atEnd not and: [ self isClassChar: readStream peek ] ] whileTrue: [ 
			stream nextPut: readStream next ] ].
	self consumeWhitespace.
	^ self lookupClass: className asSymbol
%

category: 'parsing-internal'
method: STONReader
parseConstantDo: block
	"Parse and consume either true|false|nil|null and execute block 
	or else do nothing (but do not back up).
	Hand written implementation to avoid the use of #position:"
	
	(readStream peek = $t)
		ifTrue: [
			^ self match: 'true' do: [ block value: true ] ].
	(readStream peek = $f)
		ifTrue: [
			^ self match: 'false' do: [ block value: false ] ].
	(readStream peek = $n)
		ifTrue: [
			readStream next.
			(readStream peek = $i)
				ifTrue: [
					self match: 'il' do: [ block value: nil ] ].
			(readStream peek = $u)
				ifTrue: [
					self match: 'ull' do: [ block value: nil ] ] ]
%

category: 'parsing'
method: STONReader
parseList
	| reference array |
	reference := self newReference.
	array := STON listClass streamContents: [ :stream |
		self parseListDo: [ :each | stream nextPut: each ] ].
	self setReference: reference to: array.
	^ array
%

category: 'parsing'
method: STONReader
parseListDo: block
	| index |
	self expectChar: $[.
	(self matchChar: $]) 
		ifTrue: [ ^ self ].
	index := 1.
	[ readStream atEnd ] whileFalse: [
		block cull: self parseValue cull: index.
		(self matchChar: $]) 
			ifTrue: [ ^ self ].
		index := index + 1.
		self expectChar: $, ].
	self error: 'end of list expected'
%

category: 'parsing'
method: STONReader
parseListSingleton
	| value |
	value := nil.
	self parseListDo: [ :each :index |
		index = 1 ifTrue: [ value := each ] ].
	^ value
%

category: 'parsing'
method: STONReader
parseMap
	| map |
	map := STON mapClass new.
	self storeReference: map.
	self parseMapDo: [ :key :value |
		map at: key put: value ].
	^ map
%

category: 'parsing'
method: STONReader
parseMapDo: block
  self expectChar: ${.
  (self matchChar: $})
    ifTrue: [ ^ self ].
  [ readStream atEnd ] whileFalse: [ | name value |
      name := self parseValue.
      (allowComplexMapKeys
        or: [ name isString or: [ name isNumber ] ])
        ifFalse: [ self error: 'unexpected property name type' ].
      self expectChar: $:.
      value := self parseValue.
      block value: name value: value.
      (self matchChar: $})
        ifTrue: [ ^ self ].
      self expectChar: $, ].
  self error: 'end of map expected'
%

category: 'parsing-internal'
method: STONReader
parseNumber
	| negated number |
	negated := readStream peekFor: $-.
	number := self parseNumberInteger.
	(readStream peekFor: $.)
		ifTrue: [ number := number + self parseNumberFraction ].
	((readStream peekFor: $e) or: [ readStream peekFor: $E ])
		ifTrue: [ number := number * self parseNumberExponent ].
	negated
		ifTrue: [ number := number negated ].
	self consumeWhitespace.
	^ number
%

category: 'parsing-internal'
method: STONReader
parseNumberExponent
	| number negated |
	number := 0.
	(negated := readStream peekFor: $-)
		ifFalse: [ readStream peekFor: $+ ].
	[ readStream atEnd not and: [ readStream peek isDigit ] ]
		whileTrue: [ number := 10 * number + readStream next digitValue ].
	negated
		ifTrue: [ number := number negated ].
	^ 10 raisedTo: number
%

category: 'parsing-internal'
method: STONReader
parseNumberFraction
	| number power |
	number := 0.
	power := 1.0.
	[ readStream atEnd not and: [ readStream peek isDigit ] ] whileTrue: [
		number := 10 * number + readStream next digitValue.
		power := power * 10.0 ].
	^ number / power
%

category: 'parsing-internal'
method: STONReader
parseNumberInteger
	| number |
	number := 0.
	[ readStream atEnd not and: [ readStream peek isDigit ] ] whileTrue: [ 
		number := 10 * number + readStream next digitValue ].
	^ number
%

category: 'parsing'
method: STONReader
parseObject
	| targetClass reference object |
	targetClass := self parseClass.
	reference := self newReference.
	object := targetClass fromSton: self.
	self setReference: reference to: object.
	^ object
%

category: 'parsing-internal'
method: STONReader
parseReference
	| index |
	self expectChar: $@.
	index := self parseNumberInteger.
	self consumeWhitespace.
	unresolvedReferences := unresolvedReferences + 1.
	^ STONReference index: index
%

category: 'parsing-internal'
method: STONReader
parseString
	^ self parseStringInternal
%

category: 'parsing-internal'
method: STONReader
parseStringInternal
  | result delimiter |
  delimiter := readStream next.
  (delimiter = $' or: [ delimiter = $" ])
    ifFalse: [ self error: ''' or " expected' ].
  result := self
    stringStreamContents: [ :stream | 
      [ readStream atEnd or: [ readStream peek = delimiter ] ]
        whileFalse: [ stream nextPut: self parseCharacter ] ].
  self expectChar: delimiter.
  ^ result
%

category: 'parsing-internal'
method: STONReader
parseSymbol
	| string |
	self expectChar: $#.
	readStream peek = $'
		ifTrue: [ ^ self parseStringInternal asSymbol ].
	string := self stringStreamContents: [ :stream |
		[ readStream atEnd not and: [ self isSimpleSymbolChar: readStream peek ] ] whileTrue: [
			stream nextPut: readStream next ] ].
	string isEmpty
		ifFalse: [ 
			self consumeWhitespace.
			^ string asSymbol ].
	self error: 'unexpected input'
%

category: 'parsing'
method: STONReader
parseValue
	| char |
	readStream atEnd ifFalse: [ 
		(self isClassStartChar: (char := readStream peek)) 
			ifTrue: [ ^ self parseObject ].
		char = ${
			ifTrue: [ ^ self parseMap ].
		char = $[
			ifTrue: [ ^ self parseList ].
		(char = $' or: [ char = $" ])
			ifTrue: [ ^ self parseString ].
		char = $#
			ifTrue: [ ^ self parseSymbol ].
		char = $@
			ifTrue: [ ^ self parseReference ].
		(char = $- or: [ char isDigit ])
			ifTrue: [ ^ self parseNumber ].
		self parseConstantDo: [ :value | ^ value ] ].
	self error: 'invalid input'
%

category: 'private'
method: STONReader
processSubObjectsOf: object
  stack addFirst: object.
  [ stack isEmpty ]
    whileFalse: [ stack removeFirst stonProcessSubObjects: [ :each | each isStonReference
            ifTrue: [ self resolveReference: each ]
            ifFalse: [ each stonContainSubObjects
                ifTrue: [ stack addFirst: each ]
                ifFalse: [ each ] ] ] ]
%

category: 'initialize-release'
method: STONReader
reset
	unresolvedReferences := 0.
	objects removeAll
%

category: 'private'
method: STONReader
resolveReference: reference
	^ self resolveReferenceIndex: reference index
%

category: 'private'
method: STONReader
resolveReferenceIndex: index
	^ objects at: index
%

category: 'private'
method: STONReader
setReference: reference to: object
	objects at: reference index put: object
%

category: 'private'
method: STONReader
storeReference: object
	| index |
	index := objects size + 1.
	objects at: index put: object.
	^ index
%

category: 'private'
method: STONReader
stringStreamContents: block
  stringStream ifNil: [ stringStream := WriteStream on: String new ].
  stringStream reset.
  block value: stringStream.
  ^ stringStream contents
%

! Class implementation for 'STONReference'

!		Class methods for 'STONReference'

category: 'instance creation'
classmethod: STONReference
index: integer
	^ self new
		index: integer;
		yourself
%

!		Instance methods for 'STONReference'

category: 'comparing'
method: STONReference
= anObject
	^ self class == anObject class and: [ self index = anObject index ]
%

category: 'comparing'
method: STONReference
hash
	^ index hash
%

category: 'accessing'
method: STONReference
index
	^ index
%

category: 'accessing'
method: STONReference
index: integer
	index := integer
%

category: 'testing'
method: STONReference
isStonReference
	^ true
%

category: 'printing'
method: STONReference
printOn: stream
	super printOn: stream.
	stream nextPut: $(; print: index; nextPut: $)
%

! Class implementation for 'STONStreamWriter'

!		Class methods for 'STONStreamWriter'

category: 'instance creation'
classmethod: STONStreamWriter
new
  ^ self basicNew
    initialize;
    yourself
%

category: 'instance creation'
classmethod: STONStreamWriter
on: stonWriter
	^ self new
		on: stonWriter;
		yourself
%

!		Instance methods for 'STONStreamWriter'

category: 'initialize-release'
method: STONStreamWriter
initialize
  first := true
%

category: 'initialize-release'
method: STONStreamWriter
on: stonWriter
	writer := stonWriter
%

! Class implementation for 'STONListWriter'

!		Instance methods for 'STONListWriter'

category: 'accessing'
method: STONListWriter
add: anObject
	first ifTrue: [ first := false ] ifFalse: [ writer listElementSeparator ].
	writer nextPut: anObject
%

! Class implementation for 'STONShortListWriter'

!		Instance methods for 'STONShortListWriter'

category: 'accessing'
method: STONShortListWriter
add: anObject
	first ifTrue: [ first := false ] ifFalse: [ writer shortListElementSeparator ].
	writer nextPut: anObject
%

! Class implementation for 'STONMapWriter'

!		Instance methods for 'STONMapWriter'

category: 'accessing'
method: STONMapWriter
at: key put: value
	first ifTrue: [ first := false ] ifFalse: [ writer mapElementSeparator ].
	writer encodeKey: key value: value
%

! Class implementation for 'STONWriter'

!		Class methods for 'STONWriter'

category: 'private'
classmethod: STONWriter
findFirstInString: aString inSet: inclusionMap startingAt: start
  "Trivial, non-primitive version"

  | i stringSize ascii |
  inclusionMap size ~= 256
    ifTrue: [ ^ 0 ].
  i := start.
  stringSize := aString size.
  [ i <= stringSize and: [ ascii := (aString at: i) asciiValue.
      ascii < 256
        ifTrue: [ (inclusionMap at: ascii + 1) = 0 ]
        ifFalse: [ true ] ] ] whileTrue: [ i := i + 1 ].
  i > stringSize
    ifTrue: [ ^ 0 ].
  ^ i
%

category: 'class initialization'
classmethod: STONWriter
initialize
	self initializeSTONCharacters.
	self initializeSTONSimpleSymbolCharacters
%

category: 'class initialization'
classmethod: STONWriter
initializeSTONCharacters
	| escapes |
	STONCharacters := Array new: 127.
	32 to: 126 do: [ :each | 
		STONCharacters at: each + 1 put: #pass ].
	escapes := #( 8 '\b' 9 '\t' 10 '\n' 12 '\f' 13 '\r' 34 '\"' 39 '\''' 92 '\\' ).
	1 to: escapes size - 1 by: 2 do: [ :index | 
		STONCharacters 
			at: (escapes at: index) + 1
			put: (escapes at: index + 1) ]
%

category: 'class initialization'
classmethod: STONWriter
initializeSTONSimpleSymbolCharacters
  "STONSimpleSymbolCharacters asArray collectWithIndex: [ :each :index |
		each isZero ifTrue: [ (index - 1) asCharacter ] ]."

  STONSimpleSymbolCharacters := (ByteArray new: 256)
    atAllPut: 1;
    yourself.
  1 to: 256 do: [ :each | | char |
    char := (each - 1) asCharacter.
    (self isSimpleSymbolChar: char)
      ifTrue: [ STONSimpleSymbolCharacters at: each put: 0 ] ]
%

category: 'private'
classmethod: STONWriter
isSimpleSymbolChar: char
	^ 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_./' includes: char
%

category: 'instance creation'
classmethod: STONWriter
new
  ^ self basicNew
    initialize;
    yourself
%

category: 'instance creation'
classmethod: STONWriter
on: writeStream
	^ self new
		on: writeStream;
		yourself
%

!		Instance methods for 'STONWriter'

category: 'initialize-release'
method: STONWriter
close
	writeStream ifNotNil: [
		writeStream close.
		writeStream := nil ]
%

category: 'writing'
method: STONWriter
encodeCharacter: char
  | code encoding |
  ((code := char codePoint) < 127
    and: [ (encoding := STONCharacters at: code + 1) notNil ])
    ifTrue: [ (encoding = #'pass' or: [ jsonMode and: [ char = $' ] ])
        ifTrue: [ writeStream nextPut: char ]
        ifFalse: [ writeStream nextPutAll: encoding ] ]
    ifFalse: [ | paddedStream padding digits |
      paddedStream := WriteStream on: String new.
      code printOn: paddedStream base: 16 showRadix: false.
      digits := paddedStream contents.
      padding := 4 - digits size.
      writeStream nextPutAll: '\u'.
      encoding := padding > 0
        ifTrue: [ ((String new: padding)
            atAllPut: $0;
            yourself) , digits ]
        ifFalse: [ digits ].
      writeStream nextPutAll: encoding ]
%

category: 'private'
method: STONWriter
encodeKey: key value: value
	self nextPut: key.
	self prettyPrintSpace.
	writeStream nextPut: $:.
	self prettyPrintSpace.
	self nextPut: value
%

category: 'writing'
method: STONWriter
encodeList: elements
	writeStream nextPut: $[.
	elements isEmpty
		ifTrue: [
			self prettyPrintSpace ]
		ifFalse: [
			self indentedDo: [
				self newlineIndent.
				elements 
					do: [ :each | self nextPut: each ]
					separatedBy: [ self listElementSeparator ] ].
			self newlineIndent ].
	writeStream nextPut: $]
%

category: 'writing'
method: STONWriter
encodeMap: pairs
	| first |
	first := true.
	writeStream nextPut: ${.
	pairs isEmpty
		ifTrue: [
			self prettyPrintSpace ]
		ifFalse: [
			self indentedDo: [
				self newlineIndent.
				pairs keysAndValuesDo: [ :key :value |
					first 
						ifTrue: [ first := false ] 
						ifFalse: [ self mapElementSeparator ].
					self encodeKey: key value: value ] ].
			self newlineIndent ].
	writeStream nextPut: $}
%

category: 'private'
method: STONWriter
encodeString: string
  | encodedString |
  encodedString := string.
  writeStream
    nextPut:
      (jsonMode
        ifTrue: [ $" ]
        ifFalse: [ $' ]).
  encodedString do: [ :each | self encodeCharacter: each ].
  writeStream
    nextPut:
      (jsonMode
        ifTrue: [ $" ]
        ifFalse: [ $' ])
%

category: 'private'
method: STONWriter
indentedDo: block
	level := level + 1.
	block value.
	level := level - 1
%

category: 'initialize-release'
method: STONWriter
initialize
  prettyPrint := false.
  newLine := String with: Character lf.
  level := 0.
  referencePolicy := #'normal'.
  jsonMode := false.
  objects := IdentityDictionary new
%

category: 'private'
method: STONWriter
isSimpleSymbol: symbol
  symbol isEmpty
    ifTrue: [ ^ false ].
  ^ (self class
    findFirstInString: symbol
    inSet: STONSimpleSymbolCharacters
    startingAt: 1) = 0
%

category: 'initialize-release'
method: STONWriter
jsonMode: boolean
	jsonMode := boolean
%

category: 'private'
method: STONWriter
listElementSeparator
	writeStream nextPut: $,.
	self newlineIndent
%

category: 'private'
method: STONWriter
mapElementSeparator
	writeStream nextPut: $,.
	self newlineIndent
%

category: 'initialize-release'
method: STONWriter
newLine: string
	newLine := string
%

category: 'private'
method: STONWriter
newlineIndent
	prettyPrint ifTrue: [ 
		writeStream nextPutAll: newLine.
		level timesRepeat: [ writeStream tab ] ]
%

category: 'public'
method: STONWriter
nextPut: anObject
	anObject stonOn: self
%

category: 'initialize-release'
method: STONWriter
on: aWriteStream
	writeStream := aWriteStream
%

category: 'private'
method: STONWriter
optimizeForLargeStructures
  "nothing special for GemStone"

%

category: 'initialize-release'
method: STONWriter
prettyPrint: boolean
	prettyPrint := boolean
%

category: 'private'
method: STONWriter
prettyPrintSpace
	prettyPrint ifTrue: [ writeStream space ]
%

category: 'initialize-release'
method: STONWriter
referencePolicy: policy
  (#(#'normal' #'ignore' #'error') includes: policy)
    ifFalse: [ self error: 'Unknown reference policy: ' , policy printString ].
  referencePolicy := policy
%

category: 'initialize-release'
method: STONWriter
reset
	objects removeAll
%

category: 'private'
method: STONWriter
shortListElementSeparator
	writeStream nextPut: $,.
	self prettyPrintSpace
%

category: 'private'
method: STONWriter
with: object do: block
	| index |
	referencePolicy = #ignore 
		ifTrue: [ ^ block value ].
	(index := objects at: object ifAbsent: [ nil ]) notNil
		ifTrue: [
			referencePolicy = #error
				ifTrue: [ ^ STONWriterError signal: 'Shared reference detected' ].
			self writeReference: index ]
		ifFalse: [
			index := objects size + 1.
			objects at: object put: index.
			block value ]
%

category: 'writing'
method: STONWriter
writeBoolean: boolean
	writeStream print: boolean
%

category: 'writing'
method: STONWriter
writeFloat: float
  writeStream nextPutAll: float asString
%

category: 'writing'
method: STONWriter
writeInteger: integer
	writeStream print: integer
%

category: 'writing'
method: STONWriter
writeList: collection
	self with: collection do: [ 
		self encodeList: collection ]
%

category: 'writing'
method: STONWriter
writeMap: hashedCollection
	self with: hashedCollection do: [ 
		self encodeMap: hashedCollection ]
%

category: 'writing'
method: STONWriter
writeNull
	jsonMode
		ifTrue: [ writeStream nextPutAll: 'null' ]
		ifFalse: [ writeStream print: nil ]
%

category: 'writing'
method: STONWriter
writeObject: anObject
  | instanceVariableNames |
  (instanceVariableNames := anObject class allInstVarNames) isEmpty
    ifTrue: [ self writeObject: anObject do: [ self encodeMap: #() ] ]
    ifFalse: [ self writeObject: anObject streamMap: [ :dictionary | instanceVariableNames
            do: [ :each | (anObject instVarAt: (instanceVariableNames indexOf: each asSymbol))
                ifNotNil: [ :value | dictionary at: each asSymbol put: value ]
                ifNil: [ anObject stonShouldWriteNilInstVars
                    ifTrue: [ dictionary at: each asSymbol put: nil ] ] ] ] ]
%

category: 'writing'
method: STONWriter
writeObject: anObject do: block
	(jsonMode and: [ anObject class ~= STON listClass and: [ anObject class ~= STON mapClass ] ])
		ifTrue: [ STONWriterError signal: 'Wrong object class for JSON mode' ].
	self with: anObject do: [
		writeStream nextPutAll: anObject class stonName.
		self prettyPrintSpace.
		block value ]
%

category: 'writing'
method: STONWriter
writeObject: object listSingleton: element
	self writeObject: object do: [
		writeStream nextPut: $[.
		self 
			prettyPrintSpace;
			nextPut: element;
			prettyPrintSpace.
		writeStream nextPut: $] ]
%

category: 'writing'
method: STONWriter
writeObject: object streamList: block
	self writeObject: object do: [ | listWriter |
		listWriter := STONListWriter on: self.
		writeStream nextPut: $[.
		self indentedDo: [
			self newlineIndent.
			block value: listWriter ].
		self newlineIndent.
		writeStream nextPut: $] ]
%

category: 'writing'
method: STONWriter
writeObject: object streamMap: block
	self writeObject: object do: [ | mapWriter |
		mapWriter := STONMapWriter on: self.
		writeStream nextPut: ${.
		self indentedDo: [
			self newlineIndent.
			block value: mapWriter ].
		self newlineIndent.
		writeStream nextPut: $} ]
%

category: 'writing'
method: STONWriter
writeObject: object streamShortList: block
	self writeObject: object do: [ | listWriter |
		listWriter := STONShortListWriter on: self.
		writeStream nextPut: $[.
		self indentedDo: [
			self prettyPrintSpace.
			block value: listWriter ].
		self prettyPrintSpace.
		writeStream nextPut: $] ]
%

category: 'writing'
method: STONWriter
writeReference: index
	writeStream
		nextPut: $@;
		print: index
%

category: 'writing'
method: STONWriter
writeString: string
	self encodeString: string
%

category: 'writing'
method: STONWriter
writeSymbol: symbol
	jsonMode
		ifTrue: [
			self writeString: symbol ]
		ifFalse: [
			writeStream nextPut: $#.
			(self isSimpleSymbol: symbol)
				ifTrue: [
					writeStream nextPutAll: symbol ]
				ifFalse: [
					self encodeString: symbol ] ]
%

! Class extensions for 'AbstractDictionary'

!		Class methods for 'AbstractDictionary'

category: '*ston-gemstonecommon'
classmethod: AbstractDictionary
fromSton: stonReader
	"Instances of STON mapClass will be read directly and won't arrive here.
	Other (sub)classes will use this method."
	
	| dictionary |
	dictionary := self new.
	stonReader parseMapDo: [ :key :value |
		dictionary at: key put: value ].
	^ dictionary
%

!		Instance methods for 'AbstractDictionary'

category: '*ston-gemstonecommon'
method: AbstractDictionary
stonOn: stonWriter
	"Instances of STON mapClass will be encoded directly, without a class tag.
	Other (sub)classes will be encoded with a class tag and will use a map representation. "
	
	self class == STON mapClass
		ifTrue: [ 
			stonWriter writeMap: self ]
		ifFalse: [ 
			stonWriter 
				writeObject: self 
				do: [ stonWriter encodeMap: self ] ]
%

category: '*ston-gemstonecommon'
method: AbstractDictionary
stonProcessSubObjects: block
	"Execute block to (potentially) change each of my subObjects.
	In general, all instance and indexable variables are processed.
	Overwrite when necessary. Not used when #stonContainSubObjects returns false."
	(self class isVariable and: [ self class isBytes not and: [self class isIndexable]])
		ifTrue: [
			1 to: self _basicSize do: [ :each | |val|			
									val:= (block value: (self basicAt: each)).
									self basicAt: each put: val ] ]"
							super stonProcessSubObjects: block"
%

! Class extensions for 'Boolean'

!		Instance methods for 'Boolean'

category: '*ston-gemstone-kernel'
method: Boolean
stonContainSubObjects 
	^ false
%

category: '*ston-gemstone-kernel'
method: Boolean
stonOn: stonWriter
	stonWriter writeBoolean: self
%

! Class extensions for 'ByteArray'

!		Class methods for 'ByteArray'

category: '*ston-gemstone-kernel'
classmethod: ByteArray
fromSton: stonReader
  | singletonString |
  singletonString := stonReader parseListSingleton.
  ^ (self new: singletonString size // 2)
    readHexFrom: singletonString readStream
%

!		Instance methods for 'ByteArray'

category: '*ston-gemstonebase'
method: ByteArray
readHexFrom: aStream
  "Initialize the receiver from a hexadecimal string representation"

  | map v ch value |
  map := '0123456789abcdefABCDEF'.
  1 to: self size do: [ :i | 
    ch := aStream next.
    v := (map indexOf: ch) - 1.
    ((v between: 0 and: 15) or: [ (v := v - 6) between: 0 and: 15 ])
      ifFalse: [ 
        ^ self
          error:
            'Hex digit 
expected' ].
    value := v bitShift: 4.
    ch := aStream next.
    v := (map indexOf: ch) - 1.
    ((v between: 0 and: 15) or: [ (v := v - 6) between: 0 and: 15 ])
      ifFalse: [ 
        ^ self
          error:
            'Hex digit 
expected' ].
    value := value + v.
    self at: i put: value ]
%

category: '*ston-gemstone-kernel'
method: ByteArray
stonContainSubObjects 
	^ false
%

category: '*ston-gemstonecommon'
method: ByteArray
stonOn: stonWriter
  "Use a hex representation"

  stonWriter writeObject: self listSingleton: self asHexString
%

! Class extensions for 'Character'

!		Class methods for 'Character'

category: '*ston-gemstone-kernel'
classmethod: Character
fromSton: stonReader
	^ stonReader parseListSingleton first
%

!		Instance methods for 'Character'

category: '*ston-gemstone-kernel'
method: Character
stonOn: stonWriter
	stonWriter writeObject: self listSingleton: self asString
%

! Class extensions for 'CharacterCollection'

!		Class methods for 'CharacterCollection'

category: '*ston-gemstonecommon'
classmethod: CharacterCollection
findFirstInString: aString inSet: inclusionMap startingAt: start

	"Trivial, non-primitive version"

	| i stringSize ascii |
	inclusionMap size ~= 256
		ifTrue: [ ^ 0 ].

	i := start.
	stringSize := aString size.
	[ 
	i <= stringSize
		and: [ 
			ascii := (aString at: i) asciiValue.
			ascii < 256
				ifTrue: [ (inclusionMap at: ascii + 1) = 0 ]
				ifFalse: [ true ] ] ]
		whileTrue: [ i := i + 1 ].

	i > stringSize
		ifTrue: [ ^ 0 ].
	^ i
%

!		Instance methods for 'CharacterCollection'

category: '*ston-gemstonebase'
method: CharacterCollection
isString
  ^ true
%

category: '*ston-gemstonecommon'
method: CharacterCollection
stonContainSubObjects
  ^ false
%

category: '*ston-gemstonecommon'
method: CharacterCollection
stonOn: stonWriter

        self isSymbol
                ifTrue: [stonWriter writeSymbol: self]
                ifFalse: [stonWriter writeString: self]
%

! Class extensions for 'Class'

!		Instance methods for 'Class'

category: '*ston-gemstone-kernel'
method: Class
stonName
	"Override to encode my instances using a different class name."
	
	^ self name
%

! Class extensions for 'Collection'

!		Class methods for 'Collection'

category: '*ston-gemstone-kernel'
classmethod: Collection
fromSton: stonReader
	| collection |
	collection := self new.
	stonReader parseListDo: [ :each |
		collection add: each ].
	^ collection
%

!		Instance methods for 'Collection'

category: '*ston-gemstone-kernel'
method: Collection
stonOn: stonWriter
	stonWriter writeObject: self do: [
		stonWriter encodeList: self ]
%

! Class extensions for 'CollisionBucket'

!		Instance methods for 'CollisionBucket'

category: '*ston-gemstonecommon'
method: CollisionBucket
stonContainSubObjects 
	^false
%

! Class extensions for 'Date'

!		Class methods for 'Date'

category: '*ston-gemstonecommon'
classmethod: Date
fromSton: stonReader

	^ self fromStream: stonReader parseListSingleton readStream usingFormat: #(3 2 1 $- 1 1)
%

!		Instance methods for 'Date'

category: '*ston-gemstone-kernel'
method: Date
stonContainSubObjects 
	^ false
%

category: '*ston-gemstonecommon'
method: Date
stonOn: stonWriter
  "Use an ISO style YYYYMMDD representation"

  stonWriter
    writeObject: self
    listSingleton: (self asStringUsingFormat: #(3 2 1 $- 1 1 $: false))
%

! Class extensions for 'DateAndTime'

!		Class methods for 'DateAndTime'

category: '*ston-gemstone-kernel'
classmethod: DateAndTime
fromSton: stonReader
  ^ DateAndTime fromString: stonReader parseListSingleton
%

!		Instance methods for 'DateAndTime'

category: '*ston-gemstone-kernel'
method: DateAndTime
stonContainSubObjects 
	^ false
%

category: '*ston-gemstonecommon'
method: DateAndTime
stonOn: stonWriter
	"Use an ISO representation with all details"
	
	stonWriter writeObject: self listSingleton: 
		(String streamContents: [ :stream |
			self printOn: stream ])
%

! Class extensions for 'Integer'

!		Instance methods for 'Integer'

category: '*ston-gemstone-kernel'
method: Integer
stonOn: stonWriter
	stonWriter writeInteger: self
%

! Class extensions for 'Number'

!		Instance methods for 'Number'

category: '*ston-gemstone-kernel'
method: Number
stonContainSubObjects 
	^ false
%

category: '*ston-gemstone-kernel'
method: Number
stonOn: stonWriter
	stonWriter writeFloat: self asFloat
%

! Class extensions for 'Object'

!		Class methods for 'Object'

category: '*ston-gemstone-kernel'
classmethod: Object
fromSton: stonReader
	"Create a new instance and delegate decoding to instance side.
	Override only when new instance should be created directly (see implementors). "
	
	^ self new
		fromSton: stonReader;
		yourself
%

!		Instance methods for 'Object'

category: '*ston-gemstone-kernel'
method: Object
fromSton: stonReader
  "Decode non-variable classes from a map of their instance variables and values.
	Override to customize and add a matching #toSton: (see implementors)."

  self class isVariable
    ifTrue: [ self subclassResponsibility ]
    ifFalse: [ | instanceVariableNames |
      instanceVariableNames := self class allInstVarNames.
      stonReader
        parseMapDo: [ :instVarName :value | self instVarAt: (instanceVariableNames indexOf: instVarName asSymbol) put: value ] ]
%

category: '*ston-gemstone-kernel'
method: Object
isStonReference
	^ false
%

category: '*ston-gemstonebase'
method: Object
isString
  ^ false
%

category: '*ston-gemstone-kernel'
method: Object
stonContainSubObjects
	"Return true if I contain subObjects that should be processed, false otherwise.
	Overwrite when necessary. See also #stonProcessSubObjects:"
	
	^ true
%

category: '*ston-gemstone-kernel'
method: Object
stonOn: stonWriter
	"Encode non-variable classes with a map of their instance variable and values.
	Override to customize and add a matching #fromSton: (see implementors)."

	self class isVariable 
		ifTrue: [
			self subclassResponsibility ]
		ifFalse: [
			stonWriter writeObject: self ]
%

category: '*ston-gemstonecommon'
method: Object
stonProcessSubObjects: block
  "Execute block to (potentially) change each of my subObjects.
	In general, all instance and indexable variables are processed.
	Overwrite when necessary. Not used when #stonContainSubObjects returns false."

  1 to: self class instSize do: [ :each | self instVarAt: each put: (block value: (self instVarAt: each)) ].
  (self class isVariable and: [ self class isBytes not ])
    ifTrue: [ 1 to: self _basicSize do: [ :each | self basicAt: each put: (block value: (self basicAt: each)) ] ]
%

category: '*ston-gemstone-kernel'
method: Object
stonShouldWriteNilInstVars
	"Return true if my instance variables that are nil should be written out, 
	false otherwise. Overwrite when necessary. By default, return false."
	
	^ false
%

! Class extensions for 'SequenceableCollection'

!		Class methods for 'SequenceableCollection'

category: '*ston-gemstone-kernel'
classmethod: SequenceableCollection
fromSton: stonReader
	^ self streamContents: [ :stream |
		stonReader parseListDo: [ :each |
			stream nextPut: each ] ]
%

category: '*STON-GemStoneBase'
classmethod: SequenceableCollection
new: newSize streamContents: blockWithArg
  | stream |
  stream := WriteStreamPortable on: (self new: newSize).
  blockWithArg value: stream.
  ^ stream contents
%

category: '*STON-GemStoneBase'
classmethod: SequenceableCollection
streamContents: blockWithArg
  ^ self new: 100 streamContents: blockWithArg
%

!		Instance methods for 'SequenceableCollection'

category: '*ston-gemstone-kernel'
method: SequenceableCollection
stonOn: stonWriter
	self class == STON listClass
		ifTrue: [ stonWriter writeList: self ]
		ifFalse: [ super stonOn: stonWriter ]
%

! Class extensions for 'SmallDate'

!		Class methods for 'SmallDate'

category: '*ston-gemstone-kernel36x'
classmethod: SmallDate
stonName
	"Need to use a well-known class name. Instances of Date converted to SmallDate if in range"
	
	^ 'Date'
%

! Class extensions for 'SmallDateAndTime'

!		Class methods for 'SmallDateAndTime'

category: '*ston-gemstone-kernel36x'
classmethod: SmallDateAndTime
stonName
	"Need to use a well-known class name. Instances of DateAndTime converted to SmallDateAndTime if in range"
	
	^ 'DateAndTime'
%

! Class extensions for 'SmallTime'

!		Class methods for 'SmallTime'

category: '*ston-gemstone-kernel36x'
classmethod: SmallTime
stonName
	"Need to use a well-known class name. Instances of Time converted to SmallTime if in range"
	
	^ 'Time'
%

! Class extensions for 'String'

!		Instance methods for 'String'

category: '*ston-gemstone-kernel'
method: String
stonContainSubObjects 
	^ false
%

category: '*ston-gemstone-kernel'
method: String
stonOn: stonWriter
	stonWriter writeString: self
%

! Class extensions for 'Symbol'

!		Instance methods for 'Symbol'

category: '*ston-gemstone-kernel'
method: Symbol
stonOn: stonWriter
	stonWriter writeSymbol: self
%

! Class extensions for 'Time'

!		Class methods for 'Time'

category: '*ston-gemstonecommon'
classmethod: Time
fromSton: stonReader
  ^ self fromString: stonReader parseListSingleton usingFormat: #($: true false)
%

!		Instance methods for 'Time'

category: '*ston-gemstone-kernel'
method: Time
stonContainSubObjects 
	^ false
%

category: '*ston-gemstonecommon'
method: Time
stonOn: stonWriter
  "Use an ISO style HH:MM:SS representation"

  stonWriter
    writeObject: self
    listSingleton: (self asStringUsingFormat: #($: true false))
%

! Class extensions for 'UndefinedObject'

!		Instance methods for 'UndefinedObject'

category: '*ston-gemstone-kernel'
method: UndefinedObject
stonContainSubObjects 
	^ false
%

category: '*ston-gemstone-kernel'
method: UndefinedObject
stonOn: stonWriter
	stonWriter writeNull
%

! Class extensions for 'UnorderedCollection'

!		Instance methods for 'UnorderedCollection'

category: '*ston-gemstonecommon'
method: UnorderedCollection
stonProcessSubObjects: block
	"Execute block to (potentially) change each of my subObjects.
	In general, all instance and indexable variables are processed.
	Overwrite when necessary. Not used when #stonContainSubObjects returns false."
"increase the starting index by 4 because of the private inst vars in UnorderedCollection"

	5 to: self class instSize do: [ :each |
		self instVarAt: each  put: (block value: (self instVarAt: each)) ].
	(self class isVariable and: [ self class isBytes not ])
		ifTrue: [
			1 to: self _basicSize do: [ :each |
				self basicAt: each put: (block value: (self basicAt: each)) ] ]
%

! Class Initialization

run
RwTonelParser initialize.
STONWriter initialize.
true
%
