! Copyright (C) GemTalk Systems 1986-2026.  All Rights Reserved.
! Class Declarations
! Generated file, do not Edit

doit
(Object
	subclass: 'Cidr'
	instVarNames: #(ipAddr maskComplement netmask)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'X509-Core';
		comment: 'Object
  Cidr( ipAddr netmask maskComplement)

a Cidr represents an IPv4 classless internet domain routing subnet.';
		immediateInvariant.
true.
%

removeallmethods Cidr
removeallclassmethods Cidr

doit
(Object
	subclass: 'IPv4Subnet'
	instVarNames: #(name cidr)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'X509-Core';
		comment: 'Object
   IPv4Subnet ( name cidr ) 

Associates a name with a subnet.

 The value of name is a String .
 The value of cidr is a Cidr';
		immediateInvariant.
true.
%

removeallmethods IPv4Subnet
removeallclassmethods IPv4Subnet

doit
(Object
	subclass: 'ObjectFilteringPolicy'
	instVarNames: #(name default policyZero allowed prohibited)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'X509-Core';
		comment: 'Object
   ObjectFilteringPolicy ( name default policyZero allowed prohibited   )

An ObjectFilteringPolicy specifies, for each possible objectSecurityPolicy,
whether objects having that policy should be filtered.
 
Used in object filtering for x509 sessions. An ObjectFilteringPolicy has no
effect unless it is applied by using it in an ObjectFilteringPolicyMap, and
installing that map.

 name       is a String  .
 default    is one of  #allow, #prohibit , and controls transmission
            of objects whose objectSecurityPolicy is not nil and
            is in neither of the allowed or prohibited instVars .
 policyZero is one of  #allow, #prohibit , and controls transmission
            of objects for which (anObject objectSecurityPolicy == nil)  .
 allowed    is an IdentitySet containing instances of GsObjectSecurityPolicy .
 prohibited is an IdentitySet containing instances of GsObjectSecurityPolicy .

 #allow  means objects in that policy may be transmitted to X509 remote caches.
 #prohibit  means objects in that policy will be converted to instances of
     UnAuthorizedObjectStub before transmission to X509 remote caches.

 A default instance allows policies  
   nil , SystemObjectSecurityPolicy, DataCuratorObjectSecurityPolicy ,
   HostAgentUserObjectSecurityPolicy , PublishedObjectSecurityPolicy ,
   GsIndexingObjectSecurityPolicy  
 and all other policies are prohibited by default.
 ObjectFiltersSecurityPolicy and  SecurityDataObjectSecurityPolicy are
 always prohibited in the result of asByteArray .';
		immediateInvariant.
true.
%

removeallmethods ObjectFilteringPolicy
removeallclassmethods ObjectFilteringPolicy

doit
(Object
	subclass: 'ObjectFilteringPolicyMap'
	instVarNames: #(maps)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'X509-Core';
		comment: 'Object
   ObjectFilteringPolicyMap( maps )

An ObjectFilteringPolicyMap specifies, for each possible IPv4 address,
which ObjectFilteringPolicy should be applied to x509 sessions on a
machine at that address.
 
An ObjectFilteringPolicy has no operational effect until it is installed 
by sending it #installObjectFilter.

  maps is a KeyValueDictionary , 
    keys are instances of IPv4Subnet , 
    values are instances of ObjectFilteringPolicy .

  Instances, the maps and the keys are all assigned to
  ObjectFiltersSecurityPolicy so by default they will
  not be transmitted to remote X509 caches.

  There is no API for removing entries. 
  Recommended practice is to build a new instance when 
  removals of subnets is needed.';
		immediateInvariant.
true.
%

removeallmethods ObjectFilteringPolicyMap
removeallclassmethods ObjectFilteringPolicyMap

doit
(PPCompositeParser
	subclass: 'CidrGrammar'
	instVarNames: #(cidr ipAddress maskNumber number octetNumber)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'X509-Core';
		comment: 'The grammar for IPv4 classless internet domain routing strings such as
10.0.0.0/8
or
192.168.0.0/16';
		immediateInvariant.
true.
%

removeallmethods CidrGrammar
removeallclassmethods CidrGrammar

doit
(CidrGrammar
	subclass: 'CidrParser'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #( #logCreation )
)
		category: 'X509-Core';
		comment: 'Parses strings conforming to CidrGrammar into instances of Cidr.';
		immediateInvariant.
true.
%

removeallmethods CidrParser
removeallclassmethods CidrParser

! Class implementation for 'Cidr'

!		Class methods for 'Cidr'

category: 'instance creation'
classmethod: Cidr
fromIP: ipAddrString
  ^ CidrParser parse: ipAddrString , '/32' .
%

category: 'instance creation'
classmethod: Cidr
fromString: aString
  "aString must include a /nn  suffix"
  ^ CidrParser parse: aString .
%

category: 'instance creation'
classmethod: Cidr
ip: ipInteger mask: maskInteger
  | res |
	(res := self new)
		initializeForIp: ipInteger mask: maskInteger.
  ^ res
%

!		Instance methods for 'Cidr'

category: 'comparing'
method: Cidr
<= aCidr
  ^ ipAddr <= aCidr ipAddr
%

category: 'comparing'
method: Cidr
= aCidr
  ^ ipAddr = aCidr ipAddr and:[ netmask = aCidr netmask ]
%

category: 'printing'
method: Cidr
asString
  ^ self printString
%

category: 'queries'
method: Cidr
containsCidr: aCidr
  ^ (self containsIp: aCidr ipAddr) and:[ maskComplement >= aCidr maskComplement ]
%

category: 'queries'
method: Cidr
containsIp: ipInteger
	"Answer true iff the given ipInteger falls within the subnet I represent."

	^(ipInteger bitAnd: netmask) = ipAddr
%

category: 'private'
method: Cidr
error: aMessage

	Error signal: aMessage
%

category: 'comparing'
method: Cidr
hash
  ^ (ipAddr + (netmask bitShift: 32)) hash 
%

category: 'initialization'
method: Cidr
initializeForIp: ipInteger mask: maskInteger

	ipAddr := ipInteger.
	maskComplement := self maskComplementFor: maskInteger.
	netmask := maskComplement bitXor: 16rFFFFFFFF.
	self validate
%

category: 'accessing'
method: Cidr
ipAddr
  ^ ipAddr
%

category: 'accessing'
method: Cidr
maskComplement
  ^ maskComplement
%

category: 'private'
method: Cidr
maskComplementFor: maskInteger

	(maskInteger between: 0 and: 32)
		ifFalse: 
			[self error: 'Netmask of ' , maskInteger asString
						, ' bits is not valid for IPv4'].
	^(2 raisedToInteger: 32 - maskInteger) - 1
%

category: 'accessing'
method: Cidr
netmask
  ^ netmask
%

category: 'printing'
method: Cidr
printString
  | str shiftCount byte |
  str := String new .
  shiftCount := -24 .
  [ shiftCount < 0 ] whileTrue:[ 
    byte := (ipAddr bitShift: shiftCount) bitAnd: 16rFF .
    str addAll: byte asString ; add: $. .
    shiftCount := shiftCount + 8 .
  ].
  byte := ipAddr bitAnd: 16rFF .
  str addAll: byte asString ; add: $/ .
  str addAll: (32 - (maskComplement == 0 ifTrue:[ 0 ] ifFalse:[ maskComplement highBit])) asString.
  ^ str
%

category: 'private'
method: Cidr
validate
  | bits |
  (bits := ipAddr bitAnd: maskComplement) == 0
     ifFalse: [self error: 'Local (low-order) bits should be zero']
%

! Class implementation for 'IPv4Subnet'

!		Class methods for 'IPv4Subnet'

category: 'instance creation'
classmethod: IPv4Subnet
named: nameString forSubnet: cidrString
  | cidr |
  cidr := CidrParser parse: cidrString .
  (cidr isKindOf: PPFailure) ifTrue:[
    Error new arg: cidr; signal:'CidrParser error: ',
       cidr message asString, ' at ', cidr position asString  .
  ].
  ^ self new named: nameString cidr: cidr .
%

!		Instance methods for 'IPv4Subnet'

category: 'comparing'
method: IPv4Subnet
<= aIPv4Subnet
  ^ cidr <= aIPv4Subnet cidr
%

category: 'comparing'
method: IPv4Subnet
= aIPv4Subnet
  ^ cidr = aIPv4Subnet cidr
%

category: 'printing'
method: IPv4Subnet
asString
  ^ self printString
%

category: 'accessing'
method: IPv4Subnet
cidr
  ^ cidr
%

category: 'queries'
method: IPv4Subnet
containsCidr: aCidr
  ^ cidr containsCidr: aCidr 
%

category: 'queries'
method: IPv4Subnet
containsIP: ipAddrString
  ^ cidr containsCidr: (Cidr fromIP: ipAddrString) 
%

category: 'queries'
method: IPv4Subnet
containsSubnet: anIPv4Subnet
  ^ cidr containsCidr: anIPv4Subnet cidr 
%

category: 'copying'
method: IPv4Subnet
copyForFilterMap
  "Returns a deep copy in ObjectFiltersSecurityPolicy"
  | res n c policy |
  res := self shallowCopy .
  res named: (n := name copy) cidr: (c := cidr copy) .
  policy := ObjectFiltersSecurityPolicy .
  res objectSecurityPolicy: policy.
  n objectSecurityPolicy: policy. 
  c objectSecurityPolicy: policy .
  ^ res
%

category: 'comparing'
method: IPv4Subnet
hash
  ^ cidr hash 
%

category: 'accessing'
method: IPv4Subnet
name
  ^ name
%

category: 'updating'
method: IPv4Subnet
named: aName cidr: aCidr
  name := aName .
  cidr := aCidr .
%

category: 'printing'
method: IPv4Subnet
printString
  | str |
  (str := name copy) addAll:' '; addAll: cidr printString .
  ^ str  
%

! Class implementation for 'ObjectFilteringPolicy'

!		Class methods for 'ObjectFilteringPolicy'

category: 'instance creation'
classmethod: ObjectFilteringPolicy
new
  "The default new instance has
     policies  nil , SystemObjectSecurityPolicy, DataCuratorObjectSecurityPolicy
     are allowed , and all others are prohibited by default."
  ^ super new initialize
%

!		Instance methods for 'ObjectFilteringPolicy'

category: 'updating'
method: ObjectFilteringPolicy
allow: aGsObjectSecurityPolicy

  "If aGsObjectSecurityPolicy == nil, it specifies that
   objects for which (anObject objectSecurityPolicy == nil) are allowed"

  aGsObjectSecurityPolicy ifNil:[
    policyZero := #allow . 
  ] ifNotNil:[
    aGsObjectSecurityPolicy class == GsObjectSecurityPolicy ifFalse:[
      ArgumentError new name: 'arg' expectedClass: GsObjectSecurityPolicy 
                actualArg: aGsObjectSecurityPolicy ; signal
    ].
    allowed add: aGsObjectSecurityPolicy .
    prohibited remove: aGsObjectSecurityPolicy otherwise: nil .
  ].
%

category: 'updating'
method: ObjectFilteringPolicy
allowAll: aCollection
  aCollection do:[:each | self allow: each ].
%

category: 'updating'
method: ObjectFilteringPolicy
allowByDefault
  "Changes the default value to #allow ."

  default := #allow .
%

category: 'accessing'
method: ObjectFilteringPolicy
asByteArray
  "Return a ByteArray to be used as argument to HostAgent>>_installObjectFilterArray: .
   Bit values of 1 in the result disallows transmitting objects in the corresponding
   GsObjectSecurityPolicy from stone to a remote cache. 
   Transmission of objects in SecurityDataObjectSecurityPolicy and
   ObjectFiltersSecurityPolicy are always disallowed."
   | ba |
   ba := ByteArray new: 8192 .
   self default == #prohibit ifTrue:[
      1 to: ba size by: 4 do:[:j | ba unsigned32At: j put: 16rFFFFFFFF ].
   ].
   self policyZero == #prohibit ifTrue:[ ba bitAtZ: 0 put: 1 ]
                               ifFalse:[ ba bitAtZ: 0 put: 0 ].
   ba bitAtZ: SecurityDataObjectSecurityPolicy objectSecurityPolicyId put: 1 .
   ba bitAtZ: ObjectFiltersSecurityPolicy objectSecurityPolicyId put: 1 .
   allowed do:[:policy | ba bitAtZ: policy objectSecurityPolicyId put: 0 ].
   prohibited do:[:policy | ba bitAtZ: policy objectSecurityPolicyId put: 1 ].
   ^ ba .
%

category: 'accessing'
method: ObjectFilteringPolicy
default
  (default == #allow or:[ default == #prohibit]) ifTrue:[ ^ default]. 
  Error signal:'invalid value for default ' , default asString .
%

category: 'initialization'
method: ObjectFilteringPolicy
initialize
  "The default in a new instances is that
     policies  nil , SystemObjectSecurityPolicy, DataCuratorObjectSecurityPolicy
     are allowed, and all others are prohibited by default."
  
  name := nil .
  allowed := IdentitySet new .
  prohibited := IdentitySet new .
  default := #prohibit .
  policyZero := #allow . "objects for which anObject objectSecurityPolicy == nil "
  self allow: SystemObjectSecurityPolicy "base classes like Object" ; 
    allow: DataCuratorObjectSecurityPolicy "Symbols in AllSymbols";
    allow: HostAgentUserObjectSecurityPolicy "HostAgent UserGlobals, for mid cache ha";
    allow: PublishedObjectSecurityPolicy "the Published dictionary in default symbolLists" ;
    allow: GsIndexingObjectSecurityPolicy "objs implementing indexes" ;
    prohibit: ObjectFiltersSecurityPolicy .
  self objectSecurityPolicy: ObjectFiltersSecurityPolicy .
  ^ self
%

category: 'printing'
method: ObjectFilteringPolicy
mappingReport
  | str repoSize ba repos res defaultBit |
  repoSize := (repos := SystemRepository) size .
  str := String new .
  ba := self asByteArray .
  self default == #allow ifTrue:[
    res := 'AllowingAll' copy .
    defaultBit := 0 .
  ] ifFalse:[
    res := 'ProhibitAll' copy .
    defaultBit := 1 .
  ].
  (ba bitAtZ: 0) ~~ defaultBit ifTrue:[ str add:' 0:NilPolicy' ].
  1 to: repoSize do:[:n | (ba bitAtZ: n) ~~ defaultBit ifTrue:[ 
      str add: ' ' ; addAll: n asString; add: $: ; addAll:(repos at: n) name 
    ].
  ].
  str size > 0 ifTrue:[ res addAll:' except:( ' ; addAll: str ; add: ' )' ].
  ^ res
%

category: 'accessing'
method: ObjectFilteringPolicy
name
  ^ name 
%

category: 'updating'
method: ObjectFilteringPolicy
name: aString
  name := aString .
%

category: 'accessing'
method: ObjectFilteringPolicy
policyZero
  "Return the value controlling transmission of objects 
    for which (anObject objectSecurityPolicy == nil). "

  (policyZero == #allow or:[ policyZero == #prohibit]) ifTrue:[ ^ policyZero]. 
  Error signal:'invalid value for policyZero ' , policyZero asString .
%

category: 'updating'
method: ObjectFilteringPolicy
prohibit: aGsObjectSecurityPolicy

  "If aGsObjectSecurityPolicy == nil, it specifies that
   objects for which (anObject objectSecurityPolicy == nil) are prohibited"

  aGsObjectSecurityPolicy ifNil:[
    policyZero := #prohibit .
  ] ifNotNil:[
    aGsObjectSecurityPolicy class == GsObjectSecurityPolicy ifFalse:[
      ArgumentError new name: 'arg' expectedClass: GsObjectSecurityPolicy 
                  actualArg: aGsObjectSecurityPolicy ; signal
    ].
    prohibited add: aGsObjectSecurityPolicy .
    allowed remove: aGsObjectSecurityPolicy otherwise: nil .
  ].
%

category: 'updating'
method: ObjectFilteringPolicy
prohibitAll: aCollection
  aCollection do:[:each | self prohibit: each ].
%

category: 'updating'
method: ObjectFilteringPolicy
prohibitByDefault
  "Changes the default value to #prohibit ."

  default := #prohibit .
%

! Class implementation for 'ObjectFilteringPolicyMap'

!		Class methods for 'ObjectFilteringPolicyMap'

category: 'accessing'
classmethod: ObjectFilteringPolicyMap
installedObjectFilter
  "Return the instance currently installed in HostAgentUser's  UserGlobals"
  ^ ((AllUsers userWithId:'HostAgentUser') resolveSymbol: #ObjectFilter) value
%

category: 'instance creation'
classmethod: ObjectFilteringPolicyMap
new
  |obj|
  (obj := super new) initialize ;
     objectSecurityPolicy: ObjectFiltersSecurityPolicy .
  ^ obj 
%

!		Instance methods for 'ObjectFilteringPolicyMap'

category: 'updating'
method: ObjectFilteringPolicyMap
atSubnet: anIPv4Subnet putPolicy: anObjectFilteringPolicy
  | mySecPolicy |
  mySecPolicy := self objectSecurityPolicy .
  anObjectFilteringPolicy objectSecurityPolicy == mySecPolicy ifFalse:[
    anObjectFilteringPolicy objectSecurityPolicy: mySecPolicy .
  ].
  (anIPv4Subnet isKindOf: IPv4Subnet) ifFalse:[
     ArgumentError new name: 'anIPv4Subnet' expectedClass: IPv4Subnet
                actualArg: anIPv4Subnet ; signal
  ].
  (anObjectFilteringPolicy isKindOf: ObjectFilteringPolicy) ifFalse:[
     ArgumentError new name: 'anObjectFilteringPolicy' expectedClass: ObjectFilteringPolicy
                actualArg: anObjectFilteringPolicy ; signal
  ].
  maps at: anIPv4Subnet copyForFilterMap put: anObjectFilteringPolicy .
%

category: 'accessing'
method: ObjectFilteringPolicyMap
byteArrayForIP: ipAddrString
  ^ (self policyForIP: ipAddrString) asByteArray 
%

category: 'initialization'
method: ObjectFilteringPolicyMap
initialize
  maps := KeyValueDictionary new .
  maps objectSecurityPolicy: ObjectFiltersSecurityPolicy .
  self atSubnet: (IPv4Subnet named: 'All' forSubnet: '0.0.0.0/0')
       putPolicy:  ObjectFilteringPolicy new .  
%

category: 'updating'
method: ObjectFilteringPolicyMap
installObjectFilter
  "Install the receiver as the value of UserGlobals at:#ObjectFilter
   In the HostAgentUser's  UserGlobals, so that any subsequent
   hostagent sessions will use the receiver.  "
  | assoc |
  assoc := (AllUsers userWithId:'HostAgentUser') resolveSymbol: #ObjectFilter .
  assoc value: self .
%

category: 'printing'
method: ObjectFilteringPolicyMap
mappingReport
  "Answers a string detailing the policies for all subnets."
  | fps str prevAssoc |
  fps := SortedCollection sortBlock:[:a :b | a key <= b key ] .
  maps keysAndValuesDo:[:k :v| fps add:(Association newWithKey: k value: v) ].
  str := String new .
  fps do:[:assoc |
    prevAssoc ifNotNil:[ str lf ].
    str addAll: assoc key asString ; addAll:' --> ' ; addAll: assoc value mappingReport .
    prevAssoc := assoc .
  ].
  ^ str .
%

category: 'accessing'
method: ObjectFilteringPolicyMap
policiesForSubnet: arg
  "arg may be either an IPv4Subnet or a Cidr string. "
  | res snet |
  (arg isKindOf: IPv4Subnet) ifTrue:[ snet := arg ]
          ifFalse:[ snet := IPv4Subnet named:'tmp' forSubnet: arg].
  res := SortedCollection sortBlock:[:a :b | a key <= b key ].
  maps keysAndValuesDo:[:k :v|
   (k containsSubnet: snet) ifTrue:[ res add:(Association newWithKey: k value: v)]
  ].
  ^ Array withAll: res .
%

category: 'accessing'
method: ObjectFilteringPolicyMap
policyForIP: ipAddrString
  "Returns an ObjectFilteringPolicy, the policy defined for
   the smallest subnet in the receiver which contains 
   the address specified by ipAddrString  "
  ^ (self _entryForIp: ipAddrString) at: 2 .
%

category: 'printing'
method: ObjectFilteringPolicyMap
reportForIP: ipAddrString
  "Returns an String, the mapping report for
   the smallest subnet in the receiver which contains 
   the address specified by ipAddrString  "
  | arr str |
  arr := self _entryForIp: ipAddrString . 
  (str := String new ) addAll: (arr at: 1) asString ; addAll: ' --> ';
     addAll: (arr at: 2) mappingReport .
  ^ str
%

category: 'printing'
method: ObjectFilteringPolicyMap
reportForSubnet: arg
  | arr str prev |
  arr := self policiesForSubnet: arg .
  str := String new .
  arr do:[:assoc |
     prev ifNotNil:[ str lf ].
     str addAll: assoc key asString ; addAll:' --> ';
        addAll: assoc value mappingReport .
     prev := assoc 
  ].
  ^ str
%

category: 'accessing'
method: ObjectFilteringPolicyMap
size
  ^ maps size
%

category: 'accessing'
method: ObjectFilteringPolicyMap
subnetForIP: ipAddrString
  "Returns an IPv4Subnet"
  ^ (self _entryForIp: ipAddrString) at: 1 .
%

category: 'private'
method: ObjectFilteringPolicyMap
_entryForIp: ipAddrString
  "Returns { anIPv4Subnet . anObjectFilteringPolicy }"
  | argCidr resNet resMask resPolicy |
  argCidr := Cidr fromString: ipAddrString , '/32' . 
  resMask := -1.
  maps keysAndValuesDo:[:k :v| | kCidr |
    kCidr := k cidr .
    (kCidr containsCidr: argCidr) ifTrue:[ | nm |
      (nm := kCidr netmask) > resMask ifTrue:[
        resMask := nm .
        resNet :=  k . 
        resPolicy := v .
      ].
    ].
  ].
  resPolicy ifNil:[ Error signal:'BUG: Failed to find any policy for ' , argCidr asString].
  ^ { resNet . resPolicy }
%

! Class implementation for 'CidrGrammar'

!		Instance methods for 'CidrGrammar'

category: 'productions'
method: CidrGrammar
cidr

	^ipAddress , $/ asParser , maskNumber
%

category: 'productions'
method: CidrGrammar
ipAddress

	| dot |
	dot := $. asParser.
	^octetNumber , dot , octetNumber , dot , octetNumber , dot , octetNumber
%

category: 'productions'
method: CidrGrammar
maskNumber

	^number
%

category: 'productions'
method: CidrGrammar
number

	| digit |
	digit := PPPredicateObjectParser between: $0 and: $9.
	^digit plus
%

category: 'productions'
method: CidrGrammar
octetNumber

	^number
%

category: 'productions'
method: CidrGrammar
start

	^cidr
%

! Class implementation for 'CidrParser'

!		Instance methods for 'CidrParser'

category: 'productions'
method: CidrParser
cidr

	^super cidr map: [:ip :slash :mask | Cidr ip: ip mask: mask]
%

category: 'productions'
method: CidrParser
ipAddress

	^super ipAddress map: 
			[:byte1 :dot1 :byte2 :dot2 :byte3 :dot3 :byte4 |
			(byte1 bitShift: 24) + (byte2 bitShift: 16) + (byte3 bitShift: 8) + byte4]
%

category: 'productions'
method: CidrParser
maskNumber

	^self number ==> 
			[:value |
			value <= 32
				ifTrue: [value]
				ifFalse: 
					[PPFailure message: value printString
								, ' is not a valid value for an mask. Legal values are 0 through 32.']]
%

category: 'productions'
method: CidrParser
number

	^super number flatten ==> [:string | string asNumber]
%

category: 'productions'
method: CidrParser
octetNumber

	^self number ==> 
			[:value |
			value <= 255
				ifTrue: [value]
				ifFalse: 
					[PPFailure message: value printString
								, ' is not a valid value for an octet. Legal values are 0 through 255.']]
%

