! Copyright (C) GemTalk Systems 1986-2026.  All Rights Reserved.
! Class Declarations
! Generated file, do not Edit

doit
(CByteArray
	subclass: 'StructSockaddrIn'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'X509-HostAgent';
		comment: '
	"/usr/include/netinet/in.h line 239
/* Structure describing an Internet socket address.  */
struct sockaddr_in
  {
    __SOCKADDR_COMMON (sin_);
    in_port_t sin_port;			/* Port number.  */
    struct in_addr sin_addr;		/* Internet address.  */

    /* Pad to size of `struct sockaddr''.  */
    unsigned char sin_zero[sizeof (struct sockaddr) -
			   __SOCKADDR_COMMON_SIZE -
			   sizeof (in_port_t) -
			   sizeof (struct in_addr)];
  };"
';
		immediateInvariant.
true.
%

removeallmethods StructSockaddrIn
removeallclassmethods StructSockaddrIn

doit
(CByteArray
	subclass: 'StructSockaddrIn6'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'X509-HostAgent';
		comment: '
	"/usr/include/netinet/in.h line 239
/* Structure describing an Internet socket address.  */
struct sockaddr_in
  {
    __SOCKADDR_COMMON (sin_);
    in_port_t sin_port;			/* Port number.  */
    struct in_addr sin_addr;		/* Internet address.  */

    /* Pad to size of `struct sockaddr''.  */
    unsigned char sin_zero[sizeof (struct sockaddr) -
			   __SOCKADDR_COMMON_SIZE -
			   sizeof (in_port_t) -
			   sizeof (struct in_addr)];
  };"
';
		immediateInvariant.
true.
%

removeallmethods StructSockaddrIn6
removeallclassmethods StructSockaddrIn6

doit
(Error
	subclass: 'LoginDeniedError'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'X509-HostAgent';
		comment: 'No class-specific documentation for LoginDeniedError, hierarchy is: 
Object
  AbstractException( gsResumable gsTrappable gsNumber currGsHandler gsStack gsReason gsDetails tag messageText gsArgs)
    Exception
      Error
        LoginDeniedError
';
		immediateInvariant.
true.
%

removeallmethods LoginDeniedError
removeallclassmethods LoginDeniedError

doit
(Object
	subclass: 'GemLogger'
	instVarNames: #(levelsToLog logLevel)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'X509-HostAgent';
		comment: 'A GemLogger provides various facilities, for writing to the gem log (standard out of the gem process).';
		immediateInvariant.
true.
%

removeallmethods GemLogger
removeallclassmethods GemLogger

doit
(Object
	subclass: 'HostAgent'
	instVarNames: #(configuration lastAbortGmt lastLckRefreshGmt listeningPortNum listeningSocket leafNetldiSocket logger remoteHostIp remoteHostIPString remoteHostName tlsActor versionString iAmMidCacheAgent iAmBigEndian logLevel cacheStatusCount legalCacheIps filterMap objFilterByteArray validatedMidCacheIps peerIsLocal peerIsMyLeafHost versionBuildStr pushPagesToMidCache warmerConfigDict acceptTimeoutMs repliedToStoneNetldi)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'X509-HostAgent';
		comment: 'Hierarchy is: 
Object
  HostAgent

The association named #ObjectFilter in HostAgentUser''s UserGlobals
is created if needed in $GEMSTONE/upgradeDir/HostAgent.gs.

  iAmMidCacheAgent is a Boolean, true in a hostagent on a midcache host

  legalCacheIps is an Array of Strings obtained from stone, 
    System _otherCacheAddresses   in a hostagent on a midcache host.

  validatedMidCacheIps is a dictionary , keys are  peerAddrString ,
     value is true  if we have validated that a peer address has
     exactly the same  objFilterByteArray contents as the one
     installed in this hostagent''s pgsvr threads.

  ';
		immediateInvariant.
true.
%

removeallmethods HostAgent
removeallclassmethods HostAgent

doit
(Object
	subclass: 'HostAgentConfig'
	instVarNames: #(inheritedFd inheritedSsl leafLdiFd leafLdiSsl localIpAddress portRange remoteHostId localHostId stoneIpString)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'X509-HostAgent';
		comment: 'No class-specific documentation for HostAgentConfig, hierarchy is: 
Object
  HostAgentConfig( portRange)
';
		immediateInvariant.
true.
%

removeallmethods HostAgentConfig
removeallclassmethods HostAgentConfig

doit
(Object
	subclass: 'LibcFcntl'
	instVarNames: #()
	classVars: #(Functioncreat Functionfcntl Functionlockf Functionopen Functionopenat Functionposix_fadvise Functionposix_fallocate Function__openat_2 Function__open_2)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'X509-HostAgent';
		comment: 'No class-specific documentation for LibcFcntl, hierarchy is: 
Object
  LibcFcntl
';
		immediateInvariant.
true.
%

removeallmethods LibcFcntl
removeallclassmethods LibcFcntl

doit
(Object
	subclass: 'LibCrypto'
	instVarNames: #()
	classVars: #(FunctionASN1_STRING_get0_data FunctionOBJ_txt2obj FunctionX509_free FunctionX509_get_subject_name FunctionX509_NAME_get_index_by_OBJ FunctionX509_NAME_get_entry FunctionX509_NAME_ENTRY_get_data)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'X509-HostAgent';
		comment: 'No class-specific documentation for LibCrypto, hierarchy is: 
Object
  LibCrypto
';
		immediateInvariant.
true.
%

removeallmethods LibCrypto
removeallclassmethods LibCrypto

doit
(Object
	subclass: 'LibcSocket'
	instVarNames: #()
	classVars: #(Functionaccept Functionbind Functionconnect Functiongetpeername Functiongetsockname Functiongetsockopt Functiongnu_dev_major Functiongnu_dev_makedev Functiongnu_dev_minor Functionisfdtype Functionlisten Functionpreadv Functionpselect Functionpwritev Functionreadv Functionrecv Functionrecvfrom Functionrecvmsg Functionselect Functionsend Functionsendmsg Functionsendto Functionsetsockopt Functionshutdown Functionsockatmark Functionsocket Functionsocketpair Functionwritev Function__cmsg_nxthdr Function__fdelt_chk Function__fdelt_warn Function__recvfrom_chk Function__recv_chk)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'X509-HostAgent';
		comment: 'No class-specific documentation for LibcSocket, hierarchy is: 
Object
  LibcSocket
';
		immediateInvariant.
true.
%

removeallmethods LibcSocket
removeallclassmethods LibcSocket

doit
(Object
	subclass: 'LibSsl'
	instVarNames: #()
	classVars: #(FunctionSSL_get_fd FunctionSSL_get_error FunctionSSL_get1_peer_certificate FunctionSSL_get_SSL_CTX FunctionTLS_server_method)
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'X509-HostAgent';
		comment: 'No class-specific documentation for LibSsl, hierarchy is: 
Object
  LibSsl
';
		immediateInvariant.
true.
%

removeallmethods LibSsl
removeallclassmethods LibSsl

doit
(Object
	subclass: 'PortRange'
	instVarNames: #(ports numPorts)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'X509-HostAgent';
		comment: 'No class-specific documentation for PortRange, hierarchy is: 
Object
  PortRange( ports numPorts )
';
		immediateInvariant.
true.
%

removeallmethods PortRange
removeallclassmethods PortRange

doit
(Object
	subclass: 'TlsActor'
	instVarNames: #(certificate libcFcntl libCrypto libSsl privateKey ssl sslCtx tcpSocket trustAnchor)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'X509-HostAgent';
		comment: 'A TLS 1.2 server, using libssl 1.1.
Currently expects mutual certificate authentication in all cases.
';
		immediateInvariant.
true.
%

removeallmethods TlsActor
removeallclassmethods TlsActor

doit
(TlsActor
	subclass: 'HostAgentTlsActor'
	instVarNames: #(logger)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: UserGlobals
	options: #( #logCreation )
)
		category: 'X509-HostAgent';
		comment: 'No class-specific documentation for HostAgentTlsActor, hierarchy is: 
Object
  TlsActor( trustAnchor certificate privateKey libSsl libCrypto sslCtx)
    HostAgentTlsActor
';
		immediateInvariant.
true.
%

removeallmethods HostAgentTlsActor
removeallclassmethods HostAgentTlsActor

! Class implementation for 'StructSockaddrIn'

!		Class methods for 'StructSockaddrIn'

category: 'Instance Creation'
classmethod: StructSockaddrIn
byteSize

	^ 16
%

category: 'Instance Creation'
classmethod: StructSockaddrIn
forIPv4Address: aByteArray port: portnum
	"aByteArray should be the four bytes of the address."

	^(self new)
		sin_family: LibcSocket af_inet;
		sin_addr: aByteArray;
		sin_port: (portnum \\ 256 * 256) + (portnum // 256); "Convert to big-endian"
		yourself
%

category: 'Instance Creation'
classmethod: StructSockaddrIn
fromCPointer: aCPointer

	^ self fromCPointer: aCPointer numBytes: self byteSize
%

category: 'Instance Creation'
classmethod: StructSockaddrIn
new

	^ self gcMalloc: self byteSize
%

category: 'Instance Creation'
classmethod: StructSockaddrIn
on: aCByteArray

	^self withAll: aCByteArray.
%

!		Instance methods for 'StructSockaddrIn'

category: 'Accessing'
method: StructSockaddrIn
address
	"Answer a 4-byte ByteArray containing the IPv4 address in human-readable order
	example: #[127 0 0 1]"

	^self sin_addr byteArrayFrom: 0 to: 3
%

category: 'Initialization'
method: StructSockaddrIn
initialize
%

category: 'Initialization'
method: StructSockaddrIn
initialize: aCByteArray

	1 to: (self size min: aCByteArray size) do: [:i | 
		self uint8At: i put: (aCByteArray uint8At: i).
	].
%

category: 'Accessing'
method: StructSockaddrIn
ipv6ddress
	"Answer a 16-byte ByteArray containing the IPv6 address in human-readable order
	example: #[0 0 0 0 0 0 0 0 255 255 0 0 127 0 0 1]"

	^self sin_addr byteArrayFrom: 0 to: 15
%

category: 'Accessing'
method: StructSockaddrIn
sin_addr

	^self newFrom: 4 numBytes: 4
%

category: 'Updating'
method: StructSockaddrIn
sin_addr: aByteArray

	self
		copyBytesFrom: aByteArray
		from: 1
		to: 4
		into: 4

	"self
		replaceFrom: 4
		to: 3 + (4 min: aByteArray size)
		with: aByteArray
		startingAt: 1."
%

category: 'Accessing'
method: StructSockaddrIn
sin_family

	^self uint16At: 0.
%

category: 'Updating'
method: StructSockaddrIn
sin_family: anObject

	self 
		uint16At: 0
		put: anObject.
%

category: 'Accessing'
method: StructSockaddrIn
sin_port

	^(self uint8At: 2) * 16r100 + (self uint8At: 3)
%

category: 'Updating'
method: StructSockaddrIn
sin_port: anObject

	self 
		uint16At: 2
		put: anObject.
%

category: 'Accessing'
method: StructSockaddrIn
sin_zero

	^self _stringFromBytes: (self 
		byteArrayFrom: 8
		to: 15).
%

category: 'Updating'
method: StructSockaddrIn
sin_zero: aByteArray

	self
		replaceFrom: 8
		to: 7 + (8 min: aByteArray size)
		with: aByteArray
		startingAt: 1.
%

category: 'Conversion'
method: StructSockaddrIn
_stringFromBytes: aByteArray

	| index |
	index := aByteArray indexOf: 0.
	^aByteArray
		at: 1 
		sizeBytes: 1 
		stringSize: (0 == index ifTrue: [aByteArray size] ifFalse: [index - 1]).
%

! Class implementation for 'StructSockaddrIn6'

!		Class methods for 'StructSockaddrIn6'

category: 'Instance Creation'
classmethod: StructSockaddrIn6
byteSize

	^28
%

category: 'Instance Creation'
classmethod: StructSockaddrIn6
new

	^self gcMalloc: self byteSize
%

category: 'Instance Creation'
classmethod: StructSockaddrIn6
on: aCByteArray

	^self withAll: aCByteArray.
%

!		Instance methods for 'StructSockaddrIn6'

category: 'Accessing'
method: StructSockaddrIn6
address
	"Answer a 16-byte ByteArray containing the IPv6 address in human-readable order
	example: #[0 0 0 0 0 0 0 0 255 255 0 0 127 0 0 1]"

	^self sin_addr byteArrayFrom: 0 to: 15
%

category: 'Initialization'
method: StructSockaddrIn6
initialize
%

category: 'Initialization'
method: StructSockaddrIn6
initialize: aCByteArray

	1 to: (self size min: aCByteArray size) do: [:i | 
		self uint8At: i put: (aCByteArray uint8At: i).
	].
%

category: 'Accessing'
method: StructSockaddrIn6
sin_addr

	^self
		newFrom: 8
		numBytes: 16.
%

category: 'Updating'
method: StructSockaddrIn6
sin_addr: aByteArray

	self
		copyBytesFrom: aByteArray
		from: 1
		to: 16
		into: 8

	"self
		replaceFrom: 4
		to: 3 + (4 min: aByteArray size)
		with: aByteArray
		startingAt: 1."
%

category: 'Accessing'
method: StructSockaddrIn6
sin_family

	^self uint16At: 0.
%

category: 'Updating'
method: StructSockaddrIn6
sin_family: anObject

	self 
		uint16At: 0
		put: anObject.
%

category: 'Accessing'
method: StructSockaddrIn6
sin_port

	^(self uint8At: 2) * 16r100 + (self uint8At: 3)
%

category: 'Updating'
method: StructSockaddrIn6
sin_port: anObject

	self 
		uint16At: 2
		put: anObject.
%

category: 'Accessing'
method: StructSockaddrIn6
sin_zero

	^self _stringFromBytes: (self 
		byteArrayFrom: 8
		to: 15).
%

category: 'Updating'
method: StructSockaddrIn6
sin_zero: aByteArray

	self
		replaceFrom: 8
		to: 7 + (8 min: aByteArray size)
		with: aByteArray
		startingAt: 1.
%

category: 'Conversion'
method: StructSockaddrIn6
_stringFromBytes: aByteArray

	| index |
	index := aByteArray indexOf: 0.
	^aByteArray
		at: 1 
		sizeBytes: 1 
		stringSize: (0 == index ifTrue: [aByteArray size] ifFalse: [index - 1]).
%

! Class implementation for 'GemLogger'

!		Class methods for 'GemLogger'

category: 'instance creation'
classmethod: GemLogger
logLevel: levelSymbol

	^self new initializeForlogLevel: levelSymbol
%

!		Instance methods for 'GemLogger'

category: 'initialization'
method: GemLogger
initializeForlogLevel: levelSymbol
	"Legal levels are #error, #routine, #debug."

	levelsToLog := KeyValueDictionary new.
	levelsToLog at: #error put: '***ERROR*** '.
	levelSymbol == #error ifTrue: [logLevel := levelSymbol. ^self].
	levelsToLog at: #routine put: ''.
	levelSymbol == #routine ifTrue: [logLevel := levelSymbol. ^self].
	levelsToLog at: #debug put: '...'.
	levelSymbol == #debug ifTrue: [logLevel := levelSymbol. ^self].
	self error: 'Unrecognized logging level: ' , levelSymbol
%

category: 'public'
method: GemLogger
log: message level: level
	"Only log messages if they're at a level that we are currently logging."

	| header |
	header := levelsToLog at: level ifAbsent: [nil].
	header ifNotNil: [self logHeader: header message: message]
%

category: 'private'
method: GemLogger
logHeader: headerString message: messageString

	| stream |
	stream := AppendStream on: String new.
	self printTimestampOn: stream.
	stream
		space;
		nextPutAll: headerString;
		nextPutAll: messageString.
	GsFile gciLogServer: stream contents
%

category: 'public'
method: GemLogger
logLevel
  ^ logLevel
%

category: 'private'
method: GemLogger
printTimestampOn: aStream
	"Print to nearest millisecond."

	DateAndTime now printLocalMsOn: aStream .
%

! Class implementation for 'HostAgent'

!		Class methods for 'HostAgent'

category: 'private'
classmethod: HostAgent
replyToStoneNetldi: arg
  "arg is true if a sucess reply is to be sent, or arg is an error String.
   Returns true if reply was sent (always returns true if arg is a String ).
   Returns false if reply should be deferred because remote cache still in startup."
  | res |
  res := self _replyToStoneNetldi: arg .
  res _isOneByteString ifTrue:[ Error signal: 'ERROR, replyToStoneNetldi failed, ', res].
  ^ res .
%

category: 'startup'
classmethod: HostAgent
start
	(self new)
		initialize: false ;
		startup
%

category: 'startup'
classmethod: HostAgent
startMidCacheAgent: warmerCfg
	(self new)
		initialize: true ;
                warmerConfig: warmerCfg;
		startup
%

category: 'primitives'
classmethod: HostAgent
_replyToStoneNetldi: status
   "Returns true , false or an error String.
    if status arg ==true, and remote cache is connected
      replys to the stone netldi with  'SUCCESS stoneCacheString' and returns true
    else returns false.

    otherwise status arg should be a String which is delivered to the netldi as 'ERROR ...'"

  <primitive: 1052>
  status == true ifFalse:[ status _validateKindOfClass: String ].
	self _primitiveFailed: #_replyToStoneNetldi: args: { status }.
%

!		Instance methods for 'HostAgent'

category: 'private'
method: HostAgent
abort
  "explicit abort"
  System abortTransaction.
	lastAbortGmt := System timeGmt.
  TransactionBacklog enableSignalling .
%

category: 'private'
method: HostAgent
abortIfNecessary

	| maxSecondsBetweenAborts now maxSecondsBetweenRefresh |
	maxSecondsBetweenAborts := 30. "We are enabling sigAbort also"
  maxSecondsBetweenRefresh := 30 .
	now := System timeGmt.
	now - lastAbortGmt > maxSecondsBetweenAborts ifTrue:[
    self abort .
  ].
  iAmMidCacheAgent ifTrue:[
    now - lastLckRefreshGmt > maxSecondsBetweenRefresh ifTrue:[
      self refreshLckFile .
      lastLckRefreshGmt := now .
    ].
  ].
%

category: 'private'
method: HostAgent
addrToString: aByteArray
  "Assume IPv4 form "
  | str sz |
  str := String new .
  1 to: (sz := aByteArray size) do:[:n | 
    str addAll: (aByteArray at: n) asString .
    n < sz ifTrue:[ str add: $. ].
  ].               
  ^ str
%

category: 'primitives'
method: HostAgent
allocateMidPgsvrThread: socketFdInteger sslState: aCPointer session: stoneSessionId
  "Used in a hostagent on mid cache to allocate thread to service a
   session accessing this cache.  Allocates a thread , installs
   the socket,sslState as command connection, does not start the thread.
   Returns  SmallInteger threadNum or a String with error details."

  <primitive: 1078>

  self validateFd: socketFdInteger.
  aCPointer _validateClass: CPointer .
  stoneSessionId _validateClass: SmallInteger.

  self _primitiveFailed: #allocateMidPgsvrThread:sslState:session:
     args: { socketFdInteger . aCPointer . stoneSessionId }
%

category: 'private'
method: HostAgent
bigEndianArgString
  ^ ':isBigEndian=' , (iAmBigEndian ifTrue:[ $1 ] ifFalse:[ $0 ])
%

category: 'private'
method: HostAgent
checkObjectFilterForMidCache: peerAddrString
  "Returns true or false"
  | ba val |
  validatedMidCacheIps ifNil:[
    validatedMidCacheIps := StringKeyValueDictionary new .
  ] ifNotNil:[
    val := validatedMidCacheIps at: peerAddrString otherwise: nil .
  ].
  val ifNil:[ 
    filterMap ifNil:[
      val := true .  "running with all default filters"
      validatedMidCacheIps at: peerAddrString put: val .
    ] ifNotNil:[
      ba := filterMap byteArrayForIP: peerAddrString .  
      val :=  ba = objFilterByteArray .
      validatedMidCacheIps at: peerAddrString put: val .
    ].
  ].
  ^ val 
%

category: 'private'
method: HostAgent
checkUserProfile: userName
  "Returns a boolean   isReadOnly  or denys the login.
   Check various restrictions on the UserProfile after authenticating the Certs."
  | userPro status |
  userPro := AllUsers userWithId: userName ifAbsent:[ nil ].
  userPro ifNil:[ 
      self abort . "might have been a newly created UserProfile"
      userPro := AllUsers userWithId: userName ifAbsent:[
        self denyLogin:'UserProfile does not exist for ' , userName ]
  ].

  status := userPro x509loginStatus .
  (status bitAnd: 16r1) ~~ 0 ifTrue:[
     self denyLogin:'UserProfile is disabled for ' , userName].

  ^ (status bitAnd: 16r2) ~~ 0  "isReadOnly "

  "TODO xxx  implement any of password age expiration , etc
    AllUsers.passwordAgeLimit vs userPro.securityData.lastPasswordChange ??
    expiration because too long since last successful login ?
    expire based on   loginsAllowedBeforeExpiration ?
    update lastLoginTime for the userPro ?
  "
%

category: 'private'
method: HostAgent
cleanup

	self log: 'Cleaning up and shutting down.'.
	listeningSocket ifNotNil:[ 
    listeningSocket close.
		listeningSocket := nil. 
  ].
  leafNetldiSocket ifNotNil:[
    leafNetldiSocket close .
    leafNetldiSocket := nil.
  ].
  self deleteLckFile .
	self stopAllPgsvrThreads
%

category: 'private'
method: HostAgent
createSessionInStoneForUser: userName
	"returns an Array  { sessionId . remoteShrpmonProcessId }  ,
   or denies the login. "
	| gemIp result printed sleptMs |
	gemIp := tlsActor peerIpString.
	sleptMs := 0.
	[sleptMs < 20000] whileTrue: 
			[result := self
						_createSessionInStone: configuration remoteHostId
						gemIp: gemIp
						userId: userName.
			result _isArray
				ifTrue: 
					[^result	" return { sessionId . remoteShrpmonProcessId. stnStartupId }  "].
			result _isOneByteString
				ifFalse: 
					[self denyLogin: 'createSessionInStone, invalid result: ' , result asString].
			"string constant also in hostAgentNewSession in stndocall.c"
			result = 'Remote cache is in startup'
				ifTrue: 
					[printed
						ifNil: 
							[self log: 'Waiting for remote cache to startup on ' , gemIp.
							printed := true].
					Delay waitForMilliseconds: 50.
					sleptMs := sleptMs + 50]
				ifFalse: [self denyLogin: 'createSessionInStone failed, ' , result]].
	self denyLogin: 'createSessionInStone remote cache startup timed out'
%

category: 'private'
method: HostAgent
deleteLckFile
  | status |
  status := self _refreshLckFile: true .
  (status == 1"NIRES_DOESNOTEXIST" or:[ status == 9"NIRES_OK"]) ifFalse:[
     self log: 'deleteLckFile failed, status ', status asString level: #error. 
  ].
%

category: 'error handling'
method: HostAgent
denyLogin: reasonString
	LoginDeniedError signal: reasonString
%

category: 'private'
method: HostAgent
doAdditionalValidation
	"Assumed already validated by the handshake: Chain of signing to our trust anchor, valid date.
	To be validated here: certificate type, stone name, IP address."

	self
		validatePeerType;
		validatePeerStoneName;
		validatePeerIpAddress
%

category: 'private'
method: HostAgent
doTlsAcceptAndValidateOn: tcpSocket
	"Do the TLS handshake and validate all parameters. 
	If successful, answer a CPointer to the SSL struct corresponding to the validated connection.
	If the validation fails at any point, signal a LoginDeniedError with what is known of the reason."
	tlsActor 
    tcpSocket: tcpSocket ;
		doTlsAccept: acceptTimeoutMs .
  [ self doAdditionalValidation  .
  ] onException: Error do:[:ex | tcpSocket secureClose . ex pass ]
%

category: 'private'
method: HostAgent
doTlsConnectAndValidateOn: tcpSocket
  "Do the TLS handshake and validate all parameters. 
	If successful, answer a CPointer to the SSL struct corresponding to the validated connection.
	If the validation fails at any point, signal a LoginDeniedError with what is known of the reason."

	tlsActor
		tcpSocket: tcpSocket;
		doTlsConnect: acceptTimeoutMs .
  [ self doAdditionalValidation  .
  ] onException: Error do:[:ex | tcpSocket secureClose . ex pass ]
%

category: 'error handling'
method: HostAgent
error: errorDescription
	Error signal: errorDescription
%

category: 'private'
method: HostAgent
getPreTlsLineFrom: tcpSocket timeoutMs: timeMs
	"Get characters from the given socket until a newline is received, and answer the characters 
	up to but not including the newline.  Limit the number of characters before newline to 
	something reasonable to prevent DOS attack by very long string without newline.
	Not for general use; the error reporting is specific to the situation during pre-TLS 
	phases of a login handshake."

	| cmd limit newline loopCount cmdSize |
	cmd := String new.
	limit := 512.
	newline := Character lf.
  loopCount := 0 .	
	[ 
    [  | numRead sz notDone lastCh |
       self waitForReadReadyOn: tcpSocket timeoutMs: timeMs .
			 numRead := tcpSocket _rawRead: limit - cmd size into: cmd startingAt: cmd size + 1 .
       numRead _isSmallInteger ifFalse:[ self denyLogin: 'peer not read-ready' ].
       numRead == 0 ifTrue:[ self denyLogin: 'EOF on socket to peer' ].
       loopCount := loopCount + 1 .
       sz := cmd size .
       notDone := sz < limit and: [ (lastCh:= cmd at: sz) ~~ newline and: [ loopCount <= 10 ]].
       notDone ifTrue:[
         self log:'waitForReadReady cmd size ', sz asString,
             ' lastCp:', lastCh codePoint asString, ' : ', cmd asString .
       ].
       notDone 
    ] whileTrue  .
  ] onException: Error do: [:ex | 
    tcpSocket close .
    self denyLogin: 'In getPreTlsLineFrom: ' , ex description
  ].
  cmdSize := cmd size .
	cmdSize == 0
		ifTrue: [self denyLogin: 'Peer disconnected or read timed out.'].
	cmdSize == limit
		ifTrue: 
			[self denyLogin: 'Unexpected long line received starting with: '
						, (cmd copyFrom: 1 to: 80)].
	(cmd at: cmdSize) ~~ newline
		ifTrue: 
			[| msg |
			msg := 'Incomplete line from peer after receiving '
						, cmdSize printString , ' characters: '.
			cmdSize > 80
				ifTrue: 
					[msg
						add: (cmd copyFrom: 1 to: 80);
						add: '...']
				ifFalse: [msg add: cmd].
			self denyLogin: msg].
	cmd removeLast.
  logLevel == #debug ifTrue:[
	  self logDebug: 'Received line ' , cmd printString.
  ].
	^ cmd .
%

category: 'startup'
method: HostAgent
getRemoteHostInformation
	"Get the IP address (and later perhaps hostname?) of the remote host I'm servicing."

  iAmMidCacheAgent ifTrue:[
	  remoteHostName := '<servicing mid cache>' .
    remoteHostIp := nil . "allow connections from any host for now. TODO xxx configurable?"
  ] ifFalse:[
	  remoteHostIp := tlsActor remoteIpOfSsl: configuration leafLdiSsl .
    remoteHostIPString := self remoteHostIpString .
    remoteHostName := (GsSocket getHostNameByAddress: remoteHostIPString) ifNil:[ 'unknownHost'].
  ].
%

category: 'startup'
method: HostAgent
getTlsParameters
	"For TLS connections, we use the ssl context used by the netldi to 
	make the initial connection."
  | ssl |
  ssl := configuration leafLdiSsl ifNil:[ configuration inheritedSsl ].
	tlsActor := HostAgentTlsActor forSsl: ssl .
	tlsActor logger: logger
%

category: 'error handling'
method: HostAgent
handleError: anError
	"Production error handler -- log it."

	logger
		ifNotNil: 
			[logger
				log: anError description level: #error;
				log: 'Stack:' copy lf , (GsProcess stackReportToLevel: 1000) level: #error]
%

category: 'initialization'
method: HostAgent
initialize: isMidCacheBool
  | onStoneHost |
  "save logLevel in an instVar,  so WE can make a simple decision in places."
  logLevel := #routine . "normal plus error ; omits debug."
  logger := GemLogger logLevel: logLevel .
  versionString := System gemVersionAt: 'gsRelease'.
  lastAbortGmt := System timeGmt .
  lastLckRefreshGmt := lastAbortGmt .
  iAmMidCacheAgent := isMidCacheBool .
  iAmBigEndian :=  System gemIsBigEndian .
  acceptTimeoutMs := UserGlobals at: #AcceptTimeoutMs otherwise: 5000 .
  cacheStatusCount := -1 .
  versionBuildStr := System _hostAgentVersionString .
  repliedToStoneNetldi := isMidCacheBool . "no reply needed if mid cache agent"
  self log: 'System _hostAgentVersionString = ', versionBuildStr .
  (onStoneHost := System sessionIsOnStoneHost) == iAmMidCacheAgent not ifFalse:[
    Error signal:'isMidCacheAgent=' , iAmMidCacheAgent asString ,
       ' disagrees with  sessionIsOnStoneHost=', onStoneHost asString .
  ].
%

category: 'initialization'
method: HostAgent
initializeConfigurationFromSessionState

	configuration := HostAgentConfig retrieveFromSessionState: iAmMidCacheAgent withDebugLevel: logger logLevel
%

category: 'startup'
method: HostAgent
installObjectFilter
  | fp |
  filterMap := UserGlobals at: #ObjectFilter otherwise: nil .
  (filterMap isKindOf: ObjectFilteringPolicyMap) ifFalse:[ 
    Error signal:'ObjectFilter is not a ObjectFilteringPolicyMap, got ' , filterMap asString .
  ].
  fp := filterMap policyForIP: remoteHostIPString .
  self log:'Installing ObjectFilteringPolicy for ' , remoteHostIPString .
  self log: fp mappingReport . 
  objFilterByteArray := fp asByteArray .

  "to disallow transmitting objects in a GsObjectSecurityPolicy to the remote cache
   ba bitAtZ: aGsObjectSecurityPolicy objectSecurityPolicyId) put: 1  .
   The primitive always sets bitAtZ:5 put:1  in the copy of the argument , 
   thus disallowing transmit of objects in the SecurityDataObjectSecurityPolicy .
  "
  self _installObjectFilterArray: objFilterByteArray . 
%

category: 'private'
method: HostAgent
listen
  | lckName lckStatus fd aPort pRange |
  lckName := self serverLckName .
  iAmMidCacheAgent ifTrue:[
    lckStatus := self _netInfoFind: lckName .
    lckStatus == 9"NIRES_OK" ifTrue:[ 
      self error: 'hostagent already running per /opt/gemstone/locks/', lckName ,'.LCK'].
    lckStatus == 8"NIRES_EXE_DEL" ifTrue:[
      self error: 'hostagent running from deleted executable per /opt/gemstone/locks/', lckName ,'.LCK'].
    lckStatus ~~ 1 ifTrue:[
      self log:'Found stale /opt/gemstone/locks/', lckName ,'.LCK' ].
	  pRange := configuration portRange .
    self log: 'Using PortRange: ',  pRange asString .
    self log: 'Using LCK Name: ',  lckName asString .

	  pRange detect: [:portnum |  aPort := portnum .
      fd := self _createNamedSocket: lckName port: portnum queueLength: 128.
      fd  ~~ nil 
    ] ifNone: [self error: 'All ports in range are in use.'].
	  listeningSocket := GsSecureSocket fromFileHandle: fd .
    listeningPortNum := aPort .
	  self log: 'Listening on port ' , listeningPortNum printString
  ] ifFalse:[ 
    "a hostagent on stone host has no listening socket, just a socket connection to
     the leaf netldi for life of the hostagent.
     Create LCK file with no listening socket."
    (self _createNamedSocket: lckName port: -1 queueLength: 1 ) ifNil:[
      self error: 'Unable to create LCK file'.
    ].
    "setup smalltalk state for the connection produced in C "
    leafNetldiSocket := GsSecureSocket fromFileHandle: (fd := configuration leafLdiFd) .
    leafNetldiSocket makeNonBlocking .
    leafNetldiSocket _installSsl: configuration leafLdiSsl .
	  self log: 'Reading from leaf netldi on fileDescriptor ' , fd asString .
  ]
%

category: 'logging'
method: HostAgent
log: aString

	logger log: aString level: #routine
%

category: 'logging'
method: HostAgent
logDebug: aString
  logger log: aString level: #debug 
%

category: 'logging'
method: HostAgent
logStartupInformation
  | str |
  str := 'Host Agent for Stone ' , System stoneName printString .
  iAmMidCacheAgent ifTrue:[
    str addAll: ' for mid cache on ' , GsSignalingSocket getLocalHostName ,
         ' with Id ' , configuration cacheHostId asString .
  ] ifFalse:[
		str addAll: ' remote host '  "TODO  remoteHostName printString , "
				, ' at IP address ' , remoteHostIPString
				, '  with ID ' , configuration remoteHostId printString
  ].
  self log: str .
%

category: 'private'
method: HostAgent
makeConnection
  | tcpSocket authKind |
  listeningSocket ifNotNil:[
	  "In mid cache host agent,
     Wait 5 seconds accept to complete on the ready socket.
	   Returns an aGsSecureSocket  
     or nil if the accept timed out, or failed.
    "
		tcpSocket := listeningSocket acceptTimeoutMs: acceptTimeoutMs
                                  errorOnTimeout: false.
		"tcpSocket is a GsSecureSocket with no SSL state nor context, non blocking."
		tcpSocket == false ifTrue: [ 
				^ nil "timed out" 
		].
    self validatePeerAddress: tcpSocket .
		"Leave the underlying fd non-blocking until we are ready to give it to the SSL library."
		 authKind := self preTlsAcceptHandshakeOn: tcpSocket .
     authKind == #MutualAuth ifTrue:[
			 self doTlsAcceptAndValidateOn: tcpSocket .
       ^ tcpSocket
     ].
     authKind == #ReverseAuth ifTrue:[
			 self doTlsConnectAndValidateOn: tcpSocket .
       ^ tcpSocket
     ].
     tcpSocket close . "gslist or other"
  ] ifNil:[
    "in a hostagent on stone host, handle requests to connect to an x509 gem"
    (leafNetldiSocket readWillNotBlockWithin: 1000"ms") ifTrue:[ 
      (leafNetldiSocket _readLine: 255 maxWaitMs: 2000"ms") ifNotNil:[:cmd |
        tcpSocket := self processRequestFromLeafLdi: cmd .
        ^ tcpSocket
      ].
    ]
  ].
  ^ nil
%

category: 'startup'
method: HostAgent
midLevelCacheWarmFrom: hostName threads: numThreads includeData: aBoolean
  "Connects to the 'source' cache on hostName and
   starts the specified number of threads to push pages already in the
   source cache to this mid cache .
   Starts a C starter thread which triggers startup of specified number of 
   pusher threads  in source mid hostagent; each pusher thread connects to
   us to start a page push receiver thread.
   Returns as soon as starter thread is started.
  
   The source shared cache (either stone's cache or a mid cache)
   must be configured with SHR_PUSH_TO_MIDCACHES_THREADS >= numThreads
   in the stone config file or in the startnetldi -E config file  .  "
   | arr |
   hostName ifNil:[ arr := { nil . nil } ]
      ifNotNil:[ 
        arr := System _getMidCachePort: hostName .  "get midCacheIp, midCachePort from stone"
        arr _isArray ifFalse:[
          Error signal:'mid cache connect failed, ' , arr asString
        ].
      ].
   ^ self _warmMidLevelCache: (arr atOrNil: 1) port: (arr atOrNil: 2)
           threads: numThreads includeData: aBoolean myPort: listeningPortNum 
%

category: 'private'
method: HostAgent
myStoneName

	^GsNetworkResourceString currentStoneName
%

category: 'private'
method: HostAgent
preTlsAcceptHandshakeOn: tcpSocket
  "return one of #MutualAuth #ReverseAuth #GsList"
	| request |
	request := self getPreTlsLineFrom: tcpSocket timeoutMs: acceptTimeoutMs .
  (request at: 1 equals: 'GsListPlainText:') ifTrue:[
    self sendGsListReply: tcpSocket .
    tcpSocket close .
    ^ #GsList 
  ].
	(request at: 1 equals: 'StartTls-MutualAuth:hostagent') ifTrue:[ | kind response |
    kind := #MutualAuth .
    response := kind , '=Ready' .
	  self sendPreTlsLine: response to: tcpSocket .
    ^ kind
  ].
	(request at: 1 equals: 'StartTls-ReverseAuth:hostagent') ifTrue:[
    "no response, we do sslConnect and other end does sslAccept"
    ^ #ReverseAuth
  ].
	self denyLogin: 'Request for unsupported communication method: ' , request  .
  ^ nil 
%

category: 'private'
method: HostAgent
preTlsConnectHandshakeOn: tcpSocket
  "return  true if ok, or signal a login denied error"
  self sendPreTlsLine: 'StartTls-ReverseAuth:x509gem' to: tcpSocket .
  "No reply expected , hostagent just does sslAccept"
  ^ true 
%

category: 'private'
method: HostAgent
processAuthenticatedLogin

	| loginRequest userNames userName sessionId reply sessArray remotePcmonPid 
    stnStartupid readOnlyBool kind pgsErr |
	loginRequest := tlsActor readLine.
	kind := self validateLoginRequest: loginRequest.
  (kind == #'Login:' and:[ peerIsMyLeafHost == true ]) ifFalse:[
    ^ self denyLogin: 'Invalid login request kind ' , kind asString , ' myLeafHost ', peerIsMyLeafHost asString.
  ].
	userNames := tlsActor peerUserNames.
	userNames size == 1
		ifFalse: 
			[self
				denyLogin: 'User certificate should contain exactly 1 user name, but contains '
						, userNames size printString].
	userName := userNames first.
  readOnlyBool := self checkUserProfile: userName .
	sessArray := self createSessionInStoneForUser: userName.
	sessionId := sessArray at: 1.
	remotePcmonPid := sessArray at: 2.
	stnStartupid := sessArray at: 3.
	sessionId _isSmallInteger
		ifFalse: [Error signal: 'invalid sessionId from createSession'].
	remotePcmonPid _isSmallInteger
		ifFalse: [Error signal: 'invalid remotePcmonPid from createSession'].
 
  "compose the reply which will be sent by the pgsvrThread"
	(reply := 'Login=OK:stoneHostId=' copy)  
		add: System hostId printString;
		add: ':sessionId=';
		add: sessionId printString;
		add: ':pcmonPid=';
		add: remotePcmonPid printString;
		add: self bigEndianArgString ;
		add: ':stnStartupId=';
		add: stnStartupid printString ;
    add: ':readOnly='; 
    add: ( readOnlyBool ifTrue:[ $1 ] ifFalse:[ $0 ]) ; lf .

  "startPgsvrThread prim will start a thread,  the ssl becomes owned by the thread
   or will be freed by the failure to start the thread."
	pgsErr := self startStonePgsvrThread: tlsActor tcpSocket sslState: tlsActor ssl
		           session: sessionId reply: reply .
  pgsErr ifNil:[ | msg |
    self log: 'processAuthenticatedLogin sent reply: ' , reply .
		 (msg := 'Logged in session ' copy) add: sessionId printString; 
              add: ' for user '; add: userName .
     self log: msg .
  ] ifNotNil:[ 
    "C code has closed the socket"
    self log: 'ERROR, startPgsvrThread failed, ' , pgsErr asString
  ].
%

category: 'private'
method: HostAgent
processAuthenticatedMidCacheRequest
  "executes in a hostagent on a mid cache host"
  | loginRequest ofs sessId reply getIntBlk sock kind errStr |
  loginRequest := tlsActor readLine.
  kind := self validatePgsvrThreadRequest: loginRequest.
  sock := tlsActor tcpSocket .

  getIntBlk := [:prefix | 
    ofs := loginRequest findString: prefix startingAt: ofs .
    ofs < 1 ifTrue:[ ^ self denyLogin: 'request has no ', prefix ].
    ofs := ofs + prefix size .
    Integer fromString: (loginRequest copyFrom: ofs to: loginRequest size) .
  ].
  ofs := 1 .
  kind == #'AllocateMidThread:' ifTrue:[ | thrNum |
    "sock is from accept of a connection from an x509 gem on a leaf host,
     the connection is from x509 gem to commandSocket of thread in mid hostagent."
    sessId :=  getIntBlk value: ':sessionId=' .
    sock makeBlocking .
    thrNum := self allocateMidPgsvrThread: sock fileDescriptor
                   sslState: tlsActor ssl session: sessId .
    thrNum _isSmallInteger ifTrue:[ 
      (reply := 'MidCache=OK' copy) 
         add: self bigEndianArgString ;
         add:':threadNum=' ; add: thrNum asString; lf .
      self sendLine: reply to: sock .
      sock _noFreeSslOnGc .  "C thread will close socket"
      ^ self
    ].
    errStr := thrNum
  ] ifFalse:[
  kind == #'StartMidThread:' ifTrue:[ | bigEnd res thrNum |
    "sock is from accept of connect from x509 gem's hostagent on stone host.
     The connection is from a thread in mid hostagent to secondCommand thread in
     session's hostagent on stone host."
    sessId :=  getIntBlk value: ':sessionId=' .
    thrNum := getIntBlk value: ':threadNum=' .
    bigEnd := getIntBlk value: ':isBigEndian=' .
    sock makeBlocking .
    res := self _startMidcachePgsvrThread: sessId threadNum: thrNum 
        socket: sock fileDescriptor sslState: tlsActor ssl bigEndian: bigEnd 
        pushRcvr: false .
    res ifNil:[
      (reply := 'MidCache=OK' copy) lf .
      self sendLine: reply to: sock .
      sock _noFreeSslOnGc .  "C thread will close socket"
      ^ self
    ].
    errStr := res .
  ] ifFalse:[
  kind == #'StartPagePushRcvr:' ifTrue:[ | res bigEnd |
    "also used for mid cache warmer receiver"
    bigEnd := (getIntBlk value: ':isBigEndian=') == 1 .
    bigEnd == iAmBigEndian ifTrue:[
    sock makeBlocking .
      res := self _startMidcachePgsvrThread: 0 threadNum: 0 
          socket: sock fileDescriptor sslState: tlsActor ssl 
          bigEndian: (bigEnd ifTrue:[ 1 ] ifFalse:[ 0 ]) 
          pushRcvr: true .
      res ifNil:[
        (reply := 'MidCache=OK' copy) lf .
        self sendLine: reply to: sock .
        sock _noFreeSslOnGc .  "C thread will close socket"
        ^ self
      ].
      errStr := res .
    ] ifFalse:[
      errStr := 'StartPagePushRcvr illegal mixed byteorder'.
    ].
  ] ifFalse:[
  kind == #'StartWarmerPusher:' ifTrue:[ | res extraArg bigEnd |
    bigEnd := (getIntBlk value: ':isBigEndian=') == 1 .
    bigEnd == iAmBigEndian ifTrue:[
      extraArg := getIntBlk value: ':Arg=' .
      res := self _startWarmerPusherThread:  tlsActor peerIpString arg: extraArg .
      res ifNil:[
        (reply := 'MidCache=OK' copy) lf .
        self sendLine: reply to: sock .
        sock _noFreeSslOnGc .  "C thread will close socket"
        ^ self
      ].
      errStr := res .
    ] ifFalse:[
      errStr := 'StartPagePushRcvr illegal mixed byteorder'.
    ].
  ] ifFalse:[ errStr := kind asString ]
  ]]].
  reply := 'MidCache=Fail,' , errStr asString .
  self sendLine: reply to: sock .
  sock close .
  self log: 'ERROR, startPgsvrThread ' , kind asString, 
            ' failed session:', sessId asString, ', ', errStr asString .
%

category: 'private'
method: HostAgent
processRequestFromLeafLdi: request
  "netldi on a leaf host is requesting that a hostagent on
   stone host to connect to a listening x509 gem that was forked by that netldi.
   Sends a reply to the netldi on leaf host.
   Returns a GsSecureSocket (a connection to the x509 gem) or nil ."
  | getIntBlk ofs pat sock portNum isShutdown | 
  pat := 'GemListening:' .
  (request at: 1 equals: pat) ifFalse:[
    pat := 'Shutdown:' . 
    (request at: 1 equals: pat) ifTrue:[
      isShutdown := true.
    ] ifFalse:[
      self log: 'netldi request has invalid start: ', request.
      ^ self sendFailureToLeafLdi 
    ].
  ].
  ofs := pat size + 1 .
  (request at: ofs equals: versionBuildStr) ifFalse:[ 
    self log: 'netldi request has invalid version: ', request.
    ^ self sendFailureToLeafLdi 
  ].
  isShutdown == true ifTrue:[
    Error signal:'Shutdown: lost connection to netldi on our leaf host'.
  ].
  getIntBlk := [:prefix | 
    ofs := request findString: prefix startingAt: ofs .
    ofs < 1 ifTrue:[ self log: 'netldi request has no ', prefix . 
                     ^ nil ].
    ofs := ofs + prefix size .
    Integer fromString: (request copyFrom: ofs to: request size) .
  ].
  portNum := getIntBlk value: 'port=' . 
  portNum == 0 ifTrue:[  
    "netldi testing connection ; do not do a connect."
    self sendLine: 'Gem=OK' to: leafNetldiSocket .
    ^ nil  
  ].
  sock := GsSecureSocket _newClientNoSslState  . 
  [ 
    self log: 'attempting connect to port ', portNum asString,
               ' on ', remoteHostIPString asString.
    sock connectTo: portNum on: remoteHostIPString timeoutMs: acceptTimeoutMs  .
  ] onException: Error do:[:ex |
    self log:'connect to x509 gem failed, ' , ex asString .
    sock close .
    ^ self sendFailureToLeafLdi
  ].
  [ 
    self validatePeerAddress: sock .
    self preTlsConnectHandshakeOn: sock .
	  self doTlsAcceptAndValidateOn: sock . "installs SSL into the socket"
  ] onException: Error do:[:ex |
    sock close .
    self log: 'rejected a x509 gem, ' , ex asString .
    ^ self sendFailureToLeafLdi .
  ].
  self sendLine: 'Gem=OK' to: leafNetldiSocket. "success"
  ^ sock
%

category: 'private'
method: HostAgent
refreshLckFile
  | status |
  status := self _refreshLckFile: false .
  (status == 9"NIRES_OK" or:[ status == 2"NIRES_EXISTS"]) ifFalse:[
     Error signal:'unable to refresh LCK file, status ' , status asString.
  ].
%

category: 'private'
method: HostAgent
registerHostAgentWithStone: cloudHostId
	"returns self or signals an Error."

	| res |
	res := self _registerHostAgentWithStone: cloudHostId isMidCache: iAmMidCacheAgent 
                 listeningPort: listeningPortNum 
                 hostIp: remoteHostIPString hostName: remoteHostName  .
  res class == Boolean ifFalse:[
		self error: 'registerHostAgentWithStone failed, ' , res asString
  ].
  pushPagesToMidCache := res .  "from stone's config"
  iAmMidCacheAgent ifTrue:[
	  self log: 'Registered as midcache hostagent on host ' , cloudHostId printString .
    pushPagesToMidCache ifTrue:[
       self startPagePusher
    ].
  ] ifFalse:[
	  self log: 'Registered as hostagent for host ' , cloudHostId printString
  ].
%

category: 'unknown'
method: HostAgent
remoteHostIpInteger
	"remoteHostIp is a byte array. Convert it to an integer."

	| ip |
	ip := 0.
	1 to: remoteHostIp size do: [:n | ip := ip * 16r100 + (remoteHostIp at: n)].
	^ip
%

category: 'logging'
method: HostAgent
remoteHostIpString

	| string size |
	string := String new.
	size := 4.
	1 to: size
		do: 
			[:i |
			string addAll: (remoteHostIp at: i) printString.
			i = size ifFalse: [string add: $. ] ].
	^string
%

category: 'startup'
method: HostAgent
runConfigured
	"I already have a configuration. Do everything else."
	| interactive listeningForDebug |
	interactive := GsFile stdin isTerminal.
  listeningForDebug := (System gemConfigurationAt:'GEM_LISTEN_FOR_DEBUG') == true.
	[ self
		  getTlsParameters;
		  getRemoteHostInformation;
		  logStartupInformation .
	  [ 
      self listen.  "Possibly set up a listening port."
		  self registerHostAgentWithStone: configuration cacheHostId  .
      iAmMidCacheAgent ifTrue:[ 
        self warmMidCache .
      ] ifFalse:[
        self startLeafCache . "before creating .LCK file"
        self installObjectFilter .
      ].
      self serviceLoginRequests .
    ] ensure: [
      self cleanup "cleanup inside of onException so errors are logged"
    ] 
  ] onException: { Error . Break } 
		do: { [:ex |
           (ex asString includesString:'Shutdown:') ifFalse:[
             listeningForDebug ifTrue:[ self waitForDebug ].
           ].
				   interactive ifFalse:[ self handleError: ex.  self cleanup].
				   ex pass	"let topaz give additional stack dump"
         ] .
          [:ex | | num |
            (num := ex gsNumber) == 6020 ifTrue:[ "request from Stone to logout"
              self log:'HostAgent shutdown request(Break oob) received from stone.'. "fix 47603"
              self cleanup .  
              ex return: nil .
            ].
            listeningForDebug ifTrue:[ self waitForDebug ].
            interactive ifTrue:[ self pause "topaz gets control for debugging"] .
            self log:'Ignoring Break ' , num asString .
            ex resume . 
          ]
        }
%

category: 'private'
method: HostAgent
sendFailureToLeafLdi
  "must return nil."

  self sendLine: 'Gem=Fail' to: leafNetldiSocket .
  ^ nil "no tcpSocket"
%

category: 'private'
method: HostAgent
sendGsListReply: aSocket
  | reply |
  "compose reply per netsocket.c  sendReplyToClient"
  reply := 'Text=Ready
'.  
  aSocket _rawNbWrite: reply size from: reply startingAt: 1 . "one attempt to write it." 
  "caller closes socket"
  ^ true .
%

category: 'private'
method: HostAgent
sendLine: aString to: tcpSocket
  "Sends data with ssl write."
	| data dataSize numWrote sleptMs |
	data := aString copy lf.
	sleptMs := 0.
	dataSize := data size.
	numWrote := tcpSocket nbwrite: dataSize from: data startingAt: 1 .
	numWrote ~~ dataSize ifTrue:[
    (tcpSocket writeWillNotBlockWithin: 2000) ifTrue:[
      numWrote := numWrote + tcpSocket nbwrite: dataSize - numWrote from: data startingAt: numWrote + 1.
    ].
    numWrote ~~ dataSize ifTrue:[ 
      self denyLogin: 'sendLine incomplete'
    ].
  ]
%

category: 'private'
method: HostAgent
sendPreTlsLine: aString to: tcpSocket
  "Sends data as clear text."
	| data dataSize numWrote sleptMs |
	data := aString copy lf.
	sleptMs := 0.
	dataSize := data size.
	numWrote := tcpSocket _rawNbWrite: dataSize from: data startingAt: 1 .
	numWrote ~~ dataSize ifTrue: [self denyLogin: 'sendPreTlsLine incomplete']
%

category: 'startup'
method: HostAgent
serverLckName

  | stnName str |
  "Returns a String, the name of the hostagent.LCK file minus the .LCK suffix.

   Format of result must agree with findRunningHostAgent() and
   mlcHaExists() in src/nldicmn.c. "

  stnName := GsNetworkResourceString currentStoneName . 
  str := 'hostagent-', stnName, '-' .
  iAmMidCacheAgent ifTrue:[ str add: 'midcache-', GsSignalingSocket getLocalHostName ]
                  ifFalse:[ str add: remoteHostIPString ].
  ^ str 
%

category: 'private'
method: HostAgent
serviceLoginRequests
	"For now, service them forever."
  | abortBlock |
  abortBlock := [:ex | 
    "self log: ex class name , ' starting abort at ' , System _timeMs asString, ' ms' ."
    self abort .
    ex resume .
  ].
  [	
    System transactionMode: #manualBegin .
    TransactionBacklog enableSignalling .
	  [ repliedToStoneNetldi ifFalse:[
        repliedToStoneNetldi := self class replyToStoneNetldi: true .
      ].  
		  self serviceOneLoginRequest .
		  self abortIfNecessary .
    ] repeat
  ] onException: { TransactionBacklog . RepositoryViewLost } 
    do: { abortBlock . abortBlock } .
  TransactionBacklog disableSignalling . 
%

category: 'private'
method: HostAgent
serviceOneLoginRequest
	"Waits for an incoming connection, and processes it if there is one."

	| tcpSocket validated |
 [ 
   tcpSocket := self makeConnection . 
   tcpSocket ifNotNil:[
       validated := true .
			 iAmMidCacheAgent ifTrue:[
				 self processAuthenticatedMidCacheRequest
			 ] ifFalse:[
			     self processAuthenticatedLogin
       ].
     ]. 
 ] onException: LoginDeniedError do: [:ex | 
   validated ifNotNil:[  
     "Avoid client ssl read hanging until TCP detects socket close."
     tcpSocket ifNotNil:[  
       [
         tcpSocket close .
       ] onException: SocketError do:[:sEx | "ignore"].
     ]. 
   ].
	 self log: 'Login denied, ' , ex description.
   "Do not execute expensive stackReportToLevel unless logLevel is #debug"
   logLevel == #debug ifTrue:[ 
	   self logDebug: 'Stack:' copy lf , (GsProcess stackReportToLevel: 1000).
   ].
	 tcpSocket ifNotNil: [tcpSocket close].
	 ^self
 ]
%

category: 'startup'
method: HostAgent
startLeafCache
  | relayTimeout res isMid leafIsBigEndian |
  relayTimeout := System stoneConfigurationAt: #StnRemoteCachePgsvrTimeout .
  res := self _startLeafCache: relayTimeout 
        startTimeout: 60"secs xxx configurable ?" .
  res _isArray ifFalse:[ "res is an error String."
    self class replyToStoneNetldi: res asString .
    Error signal:'start leaf cache failed, ' , res asString .
  ].
  isMid := res at: 1 .
  leafIsBigEndian := res at: 2 .
%

category: 'private'
method: HostAgent
startPagePusher
  "executes in a mid cache hostagent."
  | status |
  status := self _startPagePusher: listeningPortNum  .
  status == true ifFalse:[ 
    self error: 'startPagePusher failed, ', status asString
  ].
  self log:'begin page pusher startup, ok'.
%

category: 'private'
method: HostAgent
startStonePgsvrThread: aGsSocket sslState: aCPointer session: stoneSessionId reply: aString
	"To be called after createSessionInStone:gemIp:  
   stoneSessionId must be result of createSessionInStone:gemIp: in the hostagent on stone host .

   After this method returns, HostAgent Smalltalk main program
   must no longer reference  aGsSocket nor aCPointer.
   Returns nil or a String describing an error.
  "
  aGsSocket makeBlocking .
  aGsSocket _noFreeSslOnGc .
	^ self _startStonePgsvrThread: aGsSocket fileDescriptor
			sslState: aCPointer
			session: stoneSessionId  reply: aString 
%

category: 'startup'
method: HostAgent
startup

	self
		log: 'Host agent starting.';
		initializeConfigurationFromSessionState;
		runConfigured
%

category: 'private'
method: HostAgent
stopAllPgsvrThreads
 "Attempt to get all threads to cleanly detach from stone cache.
  Should be sent before exiting main program, prior to hostagent logout.
  Returns self."


 <primitive: 1059>
 self _primitiveFailed: #stopAllPgsvrThreads

%

category: 'validation'
method: HostAgent
validateBoolInt: anInt
	anInt _validateClass: SmallInteger.
  (anInt == 0 or:[ anInt == 1]) ifFalse:[
			(OutOfRange new)
				name: 'boolInt'
					min: 0
					max: 1
					actual: anInt;
				signal
  ]
%

category: 'validation'
method: HostAgent
validateFd: anInt
	| max |
	anInt _validateClass: SmallInteger.
	max := (1 bitShift: 31) - 1.
	(anInt between: 4 and: max)
		ifFalse: 
			[(OutOfRange new)
				name: 'fileDescriptor'
					min: 4
					max: max
					actual: anInt;
				signal]
%

category: 'validation'
method: HostAgent
validateHostId: hostId
	| max |
	hostId _validateClass: Integer.
	max := (1 bitShift: 64) - 1.
	(hostId between: 1 and: max)
		ifFalse: 
			[(OutOfRange new)
				name: 'hostId'
					min: 1
					max: max
					actual: hostId;
				signal]
%

category: 'private'
method: HostAgent
validateLoginRequest: loginRequest
  "Returns #'Login:' as the request type"
  | prefix ofs |
  prefix := #'Login:' .
  (loginRequest at: 1 equals: prefix) ifTrue:[ 
    ofs := prefix size + 1 .
    (loginRequest at: ofs equals: versionBuildStr) ifTrue:[
      ^ prefix
    ].
    ^ self denyLogin: 'Invalid version in Login request ', loginRequest printString.
  ].
  self denyLogin: 'Expected login request. Instead, received '
						, loginRequest printString
%

category: 'private'
method: HostAgent
validatePeerAddress: tcpSocket
  tcpSocket ifNotNil:[ | peerAddress peerStr |
		peerStr := tcpSocket peerAddress .
		(peerStr = '::1' or:[ peerStr = '127.0.0.1']) ifTrue:[
			^ tcpSocket .  "handle possible gslist"
		]. 
		peerAddress := tlsActor remoteIpOfFd: tcpSocket id.
		peerIsMyLeafHost := self validatePeerAddrForAccept: peerAddress .
		peerIsMyLeafHost class == Boolean ifTrue:[
			^ tcpSocket 
		].
		tcpSocket close.
		self denyLogin: 'Rejected connection from ', (self addrToString: peerAddress),
													'  ', peerIsMyLeafHost asString .
  ]
%

category: 'private'
method: HostAgent
validatePeerAddrForAccept:  peerAddress
 "Validate the peer address with respect to the address of the remote
  cache we are servicing, and with respect to known midlevel caches. 
  See also validatePeerIpAddress which validates peer against the certs presented.

  Returns isMyLeafHostBoolean or a String describing the failure ."
  | peerAddrString updateIpsBlk |
  iAmMidCacheAgent ifTrue:[ 
    updateIpsBlk := [  | res |
       res := System _otherCacheAddresses . 
       res add: configuration stoneIpString .
       res
    ].
  ] ifFalse:[
    remoteHostIp = peerAddress ifTrue:[
      ^ true "ok, the configured leaf host we are servicing"
    ].
  ].
  peerAddrString := self addrToString: peerAddress .
  1 to: 2 do: [:loopCount | | cnt |
    1 to: legalCacheIps size do:[:n |
      peerAddrString = (legalCacheIps at: n) ifTrue:[ 
        iAmMidCacheAgent ifTrue:[ ^ false "ok" ] .
        (self checkObjectFilterForMidCache: peerAddrString) ifTrue:[
          ^ false "ok, but not my leaf host"
        ].
        ^ 'different objectFilterByteArray'
      ]
    ].
    cnt := System cacheStatusCount .
    cnt == cacheStatusCount ifTrue:[
      ^ 'invalid peer address' 
    ] ifFalse:[
      legalCacheIps := updateIpsBlk value .
      cacheStatusCount := cnt .
      legalCacheIps do:[:str | GsFile gciLogServer:'legal peer ' , str asString ].
    ]
  ].
  ^ 'invalid peer address after list refresh from stone' 
%

category: 'private'
method: HostAgent
validatePeerIpAddress
  "validates the peer address against the certificates "
	| certSubnets certSubnet cidr cidrErr |
	certSubnets := tlsActor peerSubnets.
	certSubnets size == 1
		ifFalse: 
			[self
				denyLogin: 'User certificate should contain exactly one subnet specification, but contains '
						, certSubnets size printString].
	certSubnet := certSubnets first.
  [
	  cidr := CidrParser parse: certSubnet.
  ] onException: Error do:[:ex | cidrErr := ex ].
	(cidr == nil or:[ cidr isPetitFailure]) ifTrue:[ | eStr |
    eStr := cidr ifNil:[ cidrErr asString ] ifNotNil:[ cidr printString ]. 
    self
				denyLogin: 'Subnet specification has an invalid format, should be in IPv4 CIDR format, but parser says: ', eStr ].
	(remoteHostIp == nil or:[cidr containsIp: self remoteHostIpInteger])
		ifFalse: 
			[self
				denyLogin: 'Attempt to login from IP address not allowed by the user certificate, which is restricted to subnet '
						, certSubnet asString ]
%

category: 'private'
method: HostAgent
validatePeerStoneName

	| peerStoneNames peerStoneName |
	peerStoneNames := tlsActor peerStoneNames.
	peerStoneNames size == 1
		ifFalse: 
			[self
				denyLogin: 'User certificate should contain exactly 1 stone name, but contains '
						, peerStoneNames size printString].
	peerStoneName := peerStoneNames first.
	peerStoneName = self myStoneName
		ifFalse: 
			[self
				denyLogin: 'Peer should have presented a certificate for stone '
						, self myStoneName printString , ' but presented a certificate for stone '
						, peerStoneName printString]
%

category: 'private'
method: HostAgent
validatePeerType
	| certTypes certType expTypes |
	certTypes := tlsActor peerCertificateTypes.
	certTypes size == 1
		ifFalse: 
			[self
				denyLogin: 'User certificate should contain exactly 1 certificate types, but contains '
						, certTypes size printString].
	certType := certTypes first.
  expTypes := iAmMidCacheAgent ifTrue:[ #( 'host' 'user' ) ] ifFalse:[ #( 'user' ) ] .
  (expTypes includes: certType) ifFalse:[
      self
				denyLogin: 'Peer certificate of invalid type ', certType asString 
  ]
%

category: 'private'
method: HostAgent
validatePgsvrThreadRequest: loginRequest
  "executes in hostagent on mid cache.
   Returns request kind (a Symbol) or an error String. "
  | prefix ofs |
  prefix := #'AllocateMidThread:' .
	(loginRequest at: 1 equals: prefix) ifFalse:[
    prefix := #'StartMidThread:' .
	  (loginRequest at: 1 equals: prefix) ifFalse:[
      prefix := #'StartPagePushRcvr:' .
	    (loginRequest at: 1 equals: prefix) ifFalse:[
        prefix := #'StartWarmerPusher:' .
	      (loginRequest at: 1 equals: prefix) ifFalse:[
          ^ 'Invalid request kind'  
  ]]]].
  ofs := prefix size + 1 .
  (loginRequest at: ofs equals: versionBuildStr) ifTrue:[
    ^ prefix
  ].
  self log:'Invalid version: ' , loginRequest printString.
  ^ 'Invalid version'
%

category: 'validation'
method: HostAgent
validatePortNumber: anInt
	| max |
	anInt _validateClass: SmallInteger.
	max := (1 bitShift: 16) - 1.
	(anInt between: 0 and: max)
		ifFalse: 
			[(OutOfRange new)
				name: 'portNumber'
					min: 0
					max: max
					actual: anInt;
				signal]
%

category: 'validation'
method: HostAgent
validateQueueLength: anInt
	| max min |
	anInt _validateClass: SmallInteger.
	max := 256 . min := 5 .  "see limits in hostagent.c prim 1061"
	(anInt between: min and: max)
		ifFalse: 
			[(OutOfRange new)
				name: 'queueLength'
					min: min
					max: max
					actual: anInt;
				signal]
%

category: 'startup'
method: HostAgent
waitForDebug
  GsFile gciLogServer: (GsProcess stackReportToLevel: 200) .
  System waitForDebug
%

category: 'private'
method: HostAgent
waitForReadReadyOn: tcpSocket timeoutMs: timeMs
	"Wait for characters to be ready to read from the given socket.
	Deny login on timeout.
	Not for general use; the error reporting is specific to the situation during pre-TLS 
	phases of a login handshake."

	| result |
	[ result := tcpSocket _rawReadWillNotBlockWithin: timeMs .
  ] onException: Error do:[:ex | 
    tcpSocket close  .
    ^ self denyLogin: ex description .
  ].
	result ifNil:[
    tcpSocket close .
    self denyLogin: 'Unknown error waiting for handshake from remote gem.'
  ].
	result ifFalse: [
    tcpSocket close .
    self denyLogin: 'Timeout waiting for handshake from remote gem.'
  ]
%

category: 'private'
method: HostAgent
warmerConfig: aString
  aString ifNotNil:[ 
    self log:'Using NETLDI_WARMER_ARGS=''' , aString asString , '''' .
    warmerConfigDict := System parseWarmerConfig: aString . 
  ].
%

category: 'startup'
method: HostAgent
warmMidCache
  warmerConfigDict ifNotNil:[ | otherMidHost nThreads includeData |
    otherMidHost := warmerConfigDict at: #midHost otherwise: nil .  "nil means from stone host"
    otherMidHost ifNotNil:[ 
      (GsSocket hostIsLocalhost: otherMidHost) ifTrue:[ 
        self log:'In NETLDI_WARMER_ARGS , ''-M ', otherMidHost asString,
          '''  specifies localhost,  warming from stone cache.' .
        otherMidHost := nil "cannot warm from our leaf cache, warm from stone cache"
      ]. 
    ].
    nThreads := warmerConfigDict at: #n ifAbsent:[ 2 ].
    includeData := (warmerConfigDict at: #d otherwise: nil) ifNil:[ false ] ifNotNil:[ true ]. 
    
    self midLevelCacheWarmFrom: otherMidHost threads: nThreads 
              includeData: includeData .
  ]
%

category: 'primitives'
method: HostAgent
_createNamedSocket: serverName port:aPortNumber queueLength: queueLength
  "Returns a SmallInteger fileDescriptor, or nil .
   aPortNumber == -1 causes creation of LCK file only without a listening socket, 
      and returns 0 for success, nil for failure.
   serverName is String from HostAgent>>serverLckName.
   aPortNumber and queueLength are args to the bind and listen .
   Calls  NetSCreateNamedSocket in the VM C code, which creates the
   lock file  /opt/gemstone/locks/<self serverLckName>..LCK . "
  <primitive: 1065>
  serverName _validateKindOfClass: String.
  self validatePortNumber: aPortNumber .
  self validateQueueLength: queueLength .
  self _primitiveFailed: #_createNamedSocket:queueLength: args: { aPortNumber . queueLength }
%

category: 'primitives'
method: HostAgent
_createSessionInStone: cloudHostId gemIp: ipAddressString userId: userIdString
	"create a session in stone on behalf of a gem which has presented
 a valid login certificate.  Gem C code for X509Login will
 complete the login with GSC_FINISH_CLOUD_LOGIN to register its processId etc.
 Must call this before startPgsvrThread.
 Returns an Array of 3 integers
    { stoneSessionId . remoteShrpcMonProcessId. stnStartupId }  
   or an error String"
	<primitive: 1054>

	self validateHostId: cloudHostId.
	ipAddressString _validateKindOfClass: String.
	userIdString _validateKindOfClass: String.
	self _primitiveFailed: #_createSessionInStone:gemIp:userId:
		args: 
			{cloudHostId.
			ipAddressString.
			userIdString}
%

category: 'primitives'
method: HostAgent
_installObjectFilterArray: aByteArray
  "Install a copy of the argument to control filtering of objects exported
   to the remote host.
   The argument must be a ByteArray of size >= 8192 bytes, bytes beyond 8192 are ignored.
   For an object in a dataPage , zero based byte  (object.securityPolicyId bitShift:-3) ,
   and  zero based bit (object.securityPolicyId & 7)  within that byte is the bit.
   Bit zero is the least signifigant bit of a byte .
   See ByteArray >> bitAtZ:put:  for use in building   aByteArray .

   If the bit is 1 , an UnauthorizedObjectStub is substituted for the object
   before any data page containing a copy of the object is transmitted to a remote
   gem or to a hostagent on a mid level cache.

   The primitive always sets bitAtZ: 5 in the copy of the argument , thus disallowing 
   transmit of objects in the SecurityDataObjectSecurityPolicy .
"

   <primitive: 1067>
   aByteArray _validateClass: ByteArray .
   aByteArray size < 8192 ifTrue:[ Error signal:'ByteArray too small'].
   self _primitiveFailed: #_installObjectFilterArray: args: { aByteArray } .
%

category: 'primitives'
method: HostAgent
_netInfoFind: serverName

  "serverName is a String from HostAgent>>serverLckName. 
   Returns a SmallInteger 0..9 which is a NetInfoResultEnum per src/netinfo.ht "
 <primitive: 1064>
 serverName _validateKindOfClass: String.
 self _primitiveFailed: #_netInfoFind: args: { serverName }
 
%

category: 'primitives'
method: HostAgent
_refreshLckFile: deleteBoolean
  "Recreates or deletes the .LCK file that was created by _createNamedSocket... .
   Returns a SmallInteger, a NetInfoResultEnum value "
  <primitive: 1066>
  deleteBoolean _validateClass: Boolean .
  self _primitiveFailed: #_refreshLckFile: args: { deleteBoolean }.
%

category: 'primitives'
method: HostAgent
_registerHostAgentWithStone: cloudHostId isMidCache: midBoolean listeningPort: portNum hostIp: aHostIp hostName: aHostName
	"Returns a Boolean (pushToMidCaches) or an error String "
	<primitive: 1055>

	self validateHostId: cloudHostId.
  midBoolean _validateClass: Boolean .
  self validatePortNumber: portNum .
  aHostIp _validateKindOfClass: String .   " of the leaf host"
  aHostName _validateKindOfClass: String .
	self _primitiveFailed: #registerHostAgentWithStone:isMidCache:listeningPort:hostIp:hostName:
     args: {cloudHostId . midBoolean . portNum . aHostIp . aHostName }
%

category: 'private'
method: HostAgent
_startLeafCache: relayTimeout startTimeout: startTimeout
  "Timeout args are in seconds.
   Requests the leaf netldi to fork the leaf cache,
   Starts the cache control relay threads. When cloud side of
   relay receives GSC_CACHE_PGSVR_LOGIN, local side of relay connects to
   stone listening socket and forwards the GSC_CACHE_PGSVR_LOGIN. Then
   relay goes into relay mode.
   The primitive does not return until the cache page server is ready.

   returns an Array  { leafIsMidCacheBoolean . leafIsBigEndianBoolean }
   or an error String .
  "
  <primitive: 1070>

  self _primitiveFailed: #_startLeafCache:startTimeout: 
       args: { relayTimeout . startTimeout }
%

category: 'primitives'
method: HostAgent
_startMidcachePgsvrThread: stoneSessionId threadNum: thrNum socket: socketFdInteger sslState: aCPointer bigEndian: bigEndInt pushRcvr: pushReceiverBool
  "Used in hostagent on mid cache, after allocateMidPgsvrThread: executed,
   and after connection accepted from hostagent on stone host.
   Returns nil or a String with error details.  "

  <primitive: 1069>

  stoneSessionId _validateClass: SmallInteger.
  self validateFd: socketFdInteger.
  aCPointer _validateClass: CPointer .
  thrNum _validateClass: SmallInteger .
  self validateBoolInt: bigEndInt .
  pushReceiverBool _validateClass: Boolean .
  self _primitiveFailed: #_startMidcachePgsvrThread:threadNum:socket:sslState:bigEndian:pushRcvr: 
    args: { stoneSessionId . thrNum . socketFdInteger . aCPointer . bigEndInt . pushReceiverBool}
%

category: 'private'
method: HostAgent
_startPagePusher: myPort
  "Executes in a mid-cache hostagent on the mid host.
   Use midHa session's rdbf connection to hostagent on stone host to
   request a page pusher be started, that pusher will connect to me
   and I will start a page receiver thread.
   Returns true or an error String .
   Returns when page pusher start has been received by hostagent on stone host
   and before threads are started so this green thread in this mid cache hostagent
   can receive the request.
  "
  <primitive: 1091>
  self validatePortNumber: myPort .
  self _primitiveFailed: #_startPagePusher: args: { myPort }
%

category: 'primitives'
method: HostAgent
_startStonePgsvrThread: socketFdInteger sslState: aCPointer session: stoneSessionId reply: aString
   "Create and start a pgsvr thread which will attach to shared cache on localhost.
    Used in hostagent on stone host. 
    Returns nil or an Error String ."

  <primitive: 1053>
	self validateFd: socketFdInteger.
	stoneSessionId _validateClass: SmallInteger.
  aCPointer _validateClass: CPointer .
  aString _validateClass: String .
	self _primitiveFailed: #_startStonePgsvrThread:sslState:session:reply:
		args: { socketFdInteger.  aCPointer.  stoneSessionId  . aString }
%

category: 'private'
method: HostAgent
_startWarmerPusherThread: destIp arg: extraArg
  "Start a warmer pusher thread which will connect to destination mid cache at destIp,destPort.
   nThreads and thrIdx  let the new thread figure which part of this cache to scan.
   Returns nil or an error String .  "
  <primitive: 1105>
 
  destIp _validateInstanceOf: String .
  extraArg _validateClass: SmallInteger .
  self _primitiveFailed: #_startWarmerPusherThread:arg: 
       args: { destIp . extraArg }
%

category: 'private'
method: HostAgent
_warmMidLevelCache: fromHost port: aPort threads: numThreads includeData: aBoolean myPort: myPort

  "fromHost and port specify IP and port of the source mid cache hostagent .
   numThreads specifies number of threads.
   fromHost == nil means warm from the stone cache .
   aBoolean == true means include data pages .
   Starts a startup thread which will start specified number of threads.
   Returns as soon as the startup thread are started.
   numTheads must be a SmallInteger in the range of 1 to 20.
   Each thread does  PomConnectToHostagent  'StartWarmerPusher'  ."

  <primitive: 1092>
  fromHost _validateInstanceOf: String .
  numThreads _validateClass: SmallInteger .
  aBoolean _validateClass: Boolean .
  aPort _validateClass: SmallInteger .
  (aPort < 1 or:[ aPort > 65535])
    ifTrue:[ ^ aPort _error: #rtErrArgOutOfRange args:{ 1 . 65535 }] .
  myPort _validateClass: SmallInteger .
  (myPort < 1 or:[ myPort > 65535])
    ifTrue:[ ^ myPort _error: #rtErrArgOutOfRange args:{ 1 . 65535 }] .

  (numThreads < 1 or:[ numThreads > 20 ])
    ifTrue:[ ^ numThreads _error: #rtErrArgOutOfRange args:{ 1 . 20 }] .
  self _primitiveFailed: #_warmMidLevelCache:port:threads:includeData: args:
    { fromHost . aPort . numThreads . aBoolean }
%

! Class implementation for 'HostAgentConfig'

!		Class methods for 'HostAgentConfig'

category: 'instance creation'
classmethod: HostAgentConfig
retrieveFromSessionState: isMidCacheAgent withDebugLevel: aSymbol

	^(self new) initializeFromSessionState: isMidCacheAgent debugLevel: aSymbol
%

!		Instance methods for 'HostAgentConfig'

category: 'accessing'
method: HostAgentConfig
cacheHostId

	^ remoteHostId ~~ 0 ifTrue:[ remoteHostId ] ifFalse:[ localHostId ]
%

category: 'primitives'
method: HostAgentConfig
connectToLeafHost: isMidCacheAgent withDebugLevel: aSymbol
  "Connects to the leaf host netldi, gets leafHostId from that netldi .
   Fetches various values embedded in gem session state or hostagent commandline.

   Returns an Array { clientPort . lowPort. highPort. clientFd. clientHostId .
                      leafNetldiFd .
                      CPointer to the LgcSslState.ssl leafNetldi connection }
   or Returns a String with error details
  "
	<primitive: 1051>
	isMidCacheAgent _validateClass: Boolean .
	aSymbol _validateClass: Symbol .
	self _primitiveFailed: #connectToLeafHost: args: { isMidCacheAgent } .
%

category: 'initialization'
method: HostAgentConfig
getLocalIpAddress
	"inheritedFd is an open file descriptor. 
   Figure out what IP address is its local IP, and cache that value."

  inheritedFd > 0 ifTrue:[ | socket |
	  socket := GsSignalingSocket fromFileHandle: inheritedFd.
	  localIpAddress := socket address
  ] ifFalse:[
    "localIpAddress is nil in a hostagent on mid cache"
  ]
%

category: 'accessing'
method: HostAgentConfig
inheritedSsl
  "Returns the SSL inherited from the parent netldi that forked this hostagent "
  ^ inheritedSsl
%

category: 'initialization'
method: HostAgentConfig
initializeFromSessionState: isMidCacheAgent debugLevel: aSymbol

	| argsArray |
	argsArray := self connectToLeafHost: isMidCacheAgent withDebugLevel: aSymbol .
	argsArray _isArray ifFalse:[ | errStr |
    errStr := argsArray asString .
    HostAgent replyToStoneNetldi: errStr .
    Error signal: 'connectToLeafHost failed:', errStr .
  ].

	"Port range uses first three args."
	self initializePortRange: argsArray.
	inheritedFd :=   argsArray at: 4.  "0 in a hostagent on mid cache"
	remoteHostId := argsArray at: 5. "0 in a hostagent on mid cache"
	  inheritedSsl := argsArray at: 6.
	leafLdiFd :=    argsArray at: 7.   
	leafLdiSsl :=   argsArray at: 8 .
	localHostId :=  System hostId .
	stoneIpString := argsArray at: 9 . "non-nil only in hostagent on mid cache"
	self getLocalIpAddress
%

category: 'initialization'
method: HostAgentConfig
initializePortRange: argsArray

	| lowPort highPort netldiPort |
	netldiPort := argsArray at: 1.	"This port is known to be taken, do not listen even if in range."
	lowPort := argsArray at: 2.
	highPort := argsArray at: 3.
	portRange := PortRange
				lowPort: lowPort
				highPort: highPort
				avoidPort: netldiPort
%

category: 'accessing'
method: HostAgentConfig
leafLdiFd
  "Returns file descriptor of the persistent connection to the leaf host netldi"
	^ leafLdiFd
%

category: 'accessing'
method: HostAgentConfig
leafLdiSsl
  "Returns the SSL of the persistent connection to the leaf host netldi"
	^ leafLdiSsl
%

category: 'accessing'
method: HostAgentConfig
localIpAddress

	^localIpAddress
%

category: 'accessing'
method: HostAgentConfig
portRange

	^portRange
%

category: 'accessing'
method: HostAgentConfig
remoteHostId

	^remoteHostId
%

category: 'accessing'
method: HostAgentConfig
stoneIpString
	^ stoneIpString
%

category: 'validation'
method: HostAgentConfig
validateTimeout: aSeconds
	| max min |
	aSeconds _validateClass: SmallInteger.
	max := 36000 . min := 1 .
	(aSeconds  between: min and: max)
		ifFalse: 
			[(OutOfRange new)
				name: 'timeout'
					min: min
					max: max
					actual: aSeconds ;
				signal]
%

! Class implementation for 'LibcFcntl'

!		Class methods for 'LibcFcntl'

category: 'Initializing - private'
classmethod: LibcFcntl
initialize

	| library |
	library := nil. "dlsym in-process not CLibrary named: '/lib/libc.so.6'  "
	self
		initializeFunction_creat_inLibrary: library;
		initializeFunction_fcntl_inLibrary: library;
		initializeFunction_lockf_inLibrary: library;
		initializeFunction_open_inLibrary: library;
		initializeFunction_openat_inLibrary: library;
		initializeFunction_posix_fadvise_inLibrary: library;
		initializeFunction_posix_fallocate_inLibrary: library;
		initializeFunction___openat_2_inLibrary: library;
		initializeFunction___open_2_inLibrary: library;
		yourself.
%

category: 'Initializing - private'
classmethod: LibcFcntl
initializeFunction_creat_inLibrary: cLibrary

	Functioncreat := CCallout
		library: cLibrary
		name: 'creat'
		result: #'int32'
		args: #(#'const char*' #'uint32')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcFcntl
initializeFunction_fcntl_inLibrary: cLibrary

	Functionfcntl := CCallout
				library: cLibrary
				name: 'fcntl'
				result: #int32
				args: #(#int32 #int32 #int32)
				varArgsAfter: 2
%

category: 'Initializing - private'
classmethod: LibcFcntl
initializeFunction_lockf_inLibrary: cLibrary

	Functionlockf := CCallout
		library: cLibrary
		name: 'lockf'
		result: #'int32'
		args: #(#'int32' #'int32' #'int64')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcFcntl
initializeFunction_openat_inLibrary: cLibrary

	Functionopenat := CCallout
		library: cLibrary
		name: 'openat'
		result: #'int32'
		args: #(#'int32' #'const char*' #'int32')
		varArgsAfter: 3.
%

category: 'Initializing - private'
classmethod: LibcFcntl
initializeFunction_open_inLibrary: cLibrary

	Functionopen := CCallout
		library: cLibrary
		name: 'open'
		result: #'int32'
		args: #(#'const char*' #'int32')
		varArgsAfter: 2.
%

category: 'Initializing - private'
classmethod: LibcFcntl
initializeFunction_posix_fadvise_inLibrary: cLibrary

	Functionposix_fadvise := CCallout
		library: cLibrary
		name: 'posix_fadvise'
		result: #'int32'
		args: #(#'int32' #'int64' #'int64' #'int32')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcFcntl
initializeFunction_posix_fallocate_inLibrary: cLibrary

	Functionposix_fallocate := CCallout
		library: cLibrary
		name: 'posix_fallocate'
		result: #'int32'
		args: #(#'int32' #'int64' #'int64')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcFcntl
initializeFunction___openat_2_inLibrary: cLibrary

	Function__openat_2 := CCallout
		library: cLibrary
		name: '__openat_2'
		result: #'int32'
		args: #(#'int32' #'const char*' #'int32')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcFcntl
initializeFunction___open_2_inLibrary: cLibrary

	Function__open_2 := CCallout
		library: cLibrary
		name: '__open_2'
		result: #'int32'
		args: #(#'const char*' #'int32')
		varArgsAfter: -1.
%

!		Instance methods for 'LibcFcntl'

category: 'Functions'
method: LibcFcntl
creat_: __file _: __mode 
	"/usr/include/fcntl.h line 225
extern int creat (const char *__file, mode_t __mode) __nonnull ((1));"

	"Interpreted as #int32 from #( #'const char*' #'uint32' )"

	^Functioncreat callWith: { __file. __mode }
%

category: 'Functions'
method: LibcFcntl
fcntl_: __fd _: __cmd 
	"/usr/include/fcntl.h line 169
/* Do the file control operation described by CMD on FD.
   The remaining arguments are interpreted depending on CMD.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern int fcntl (int __fd, int __cmd, ...);"

	"Interpreted as #int32 from #( #'int32' #'int32' )"

	^Functionfcntl callWith: { __fd. __cmd"varArgs array should be appended to this array" }
%

category: 'Functions'
method: LibcFcntl
fcntl_: __fd _: __cmd _: arg
	"/usr/include/fcntl.h line 169
/* Do the file control operation described by CMD on FD.
   The remaining arguments are interpreted depending on CMD.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern int fcntl (int __fd, int __cmd, ...);"
	"Interpreted as #int32 from #( #'int32' #'int32' )"

	^Functionfcntl callWith: 
			{__fd.
			__cmd.
			#int32.
			arg}
%

category: 'constants'
method: LibcFcntl
F_GETFL
	"#define F_GETFL		3	/* Get file status flags.  */"

	^3
%

category: 'constants'
method: LibcFcntl
F_SETFL
	"#define F_SETFL		4	/* Set file status flags.  */"

	^4
%

category: 'Functions'
method: LibcFcntl
lockf_: __fd _: __cmd _: __len 
	"/usr/include/fcntl.h line 254
extern int lockf (int __fd, int __cmd, off_t __len);"

	"Interpreted as #int32 from #( #'int32' #'int32' #'int64' )"

	^Functionlockf callWith: { __fd. __cmd. __len }
%

category: 'Functions'
method: LibcFcntl
openat_: __fd _: __file _: __oflag 
	"/usr/include/fcntl.h line 203
extern int openat (int __fd, const char *__file, int __oflag, ...)
     __nonnull ((2));"

	"Interpreted as #int32 from #( #'int32' #'const char*' #'int32' )"

	^Functionopenat callWith: { __fd. __file. __oflag"varArgs array should be appended to this array" }
%

category: 'Functions'
method: LibcFcntl
open_: __file _: __oflag 
	"/usr/include/fcntl.h line 179
extern int open (const char *__file, int __oflag, ...) __nonnull ((1));"

	"Interpreted as #int32 from #( #'const char*' #'int32' )"

	^Functionopen callWith: { __file. __oflag"varArgs array should be appended to this array" }
%

category: 'constants'
method: LibcFcntl
O_NONBLOCK
	"# define O_NONBLOCK	  04000"

	^8r04000
%

category: 'Functions'
method: LibcFcntl
posix_fadvise_: __fd _: __offset _: __len _: __advise 
	"/usr/include/fcntl.h line 271
extern int posix_fadvise (int __fd, off_t __offset, off_t __len,
			  int __advise) __THROW;"

	"Interpreted as #int32 from #( #'int32' #'int64' #'int64' #'int32' )"

	^Functionposix_fadvise callWith: { __fd. __offset. __len. __advise }
%

category: 'Functions'
method: LibcFcntl
posix_fallocate_: __fd _: __offset _: __len 
	"/usr/include/fcntl.h line 293
extern int posix_fallocate (int __fd, off_t __offset, off_t __len);"

	"Interpreted as #int32 from #( #'int32' #'int64' #'int64' )"

	^Functionposix_fallocate callWith: { __fd. __offset. __len }
%

category: 'Functions'
method: LibcFcntl
__openat_2_: __fd _: __path _: __oflag 
	"/usr/include/bits/fcntl2.h line 95
extern int __openat_2 (int __fd, const char *__path, int __oflag)
     __nonnull ((2));"

	"Interpreted as #int32 from #( #'int32' #'const char*' #'int32' )"

	^Function__openat_2 callWith: { __fd. __path. __oflag }
%

category: 'Functions'
method: LibcFcntl
__open_2_: __path _: __oflag 
	"/usr/include/bits/fcntl2.h line 26
extern int __open_2 (const char *__path, int __oflag) __nonnull ((1));"

	"Interpreted as #int32 from #( #'const char*' #'int32' )"

	^Function__open_2 callWith: { __path. __oflag }
%

! Class implementation for 'LibCrypto'

!		Class methods for 'LibCrypto'

category: 'Initializing - private'
classmethod: LibCrypto
initialize

	| library |
	library := nil.
	"library := CLibrary named: '/daytank1/users/mmcclure/prefix/lib/libcrypto.so.1.1'."
	self
                initializeFunction_ASN1_STRING_get0_data_inLibrary: library;
                initializeFunction_OBJ_txt2obj_inLibrary: library;
                initializeFunction_X509_NAME_ENTRY_get_data_inLibrary: library;
                initializeFunction_X509_NAME_get_entry_inLibrary: library;
                initializeFunction_X509_NAME_get_index_by_OBJ_inLibrary: library;
                initializeFunction_X509_get_subject_name_inLibrary: library;
                initializeFunction_X509_free_inLibrary: library;
		yourself.
%

category: 'Initializing - private'
classmethod: LibCrypto
initializeFunction_ASN1_STRING_get0_data_inLibrary: cLibrary

        FunctionASN1_STRING_get0_data := CCallout
                library: cLibrary
                name: 'ASN1_STRING_get0_data'
                result: #'char*'
                args: #(#'ptr')
                varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibCrypto
initializeFunction_OBJ_txt2obj_inLibrary: cLibrary

        FunctionOBJ_txt2obj := CCallout
                library: cLibrary
                name: 'OBJ_txt2obj'
                result: #'ptr'
                args: #(#'const char*' #'int32')
                varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibCrypto
initializeFunction_X509_free_inLibrary: cLibrary

        FunctionX509_free := CCallout
                library: cLibrary
                name: 'X509_free'
                result: #'void'
                args: #(#'ptr')
                varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibCrypto
initializeFunction_X509_get_subject_name_inLibrary: cLibrary

        FunctionX509_get_subject_name := CCallout
                library: cLibrary
                name: 'X509_get_subject_name'
                result: #'ptr'
                args: #(#'ptr')
                varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibCrypto
initializeFunction_X509_NAME_ENTRY_get_data_inLibrary: cLibrary

        FunctionX509_NAME_ENTRY_get_data := CCallout
                library: cLibrary
                name: 'X509_NAME_ENTRY_get_data'
                result: #'ptr'
                args: #(#'ptr')
                varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibCrypto
initializeFunction_X509_NAME_get_entry_inLibrary: cLibrary

        FunctionX509_NAME_get_entry := CCallout
                library: cLibrary
                name: 'X509_NAME_get_entry'
                result: #'ptr'
                args: #(#'ptr' #'int32')
                varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibCrypto
initializeFunction_X509_NAME_get_index_by_OBJ_inLibrary: cLibrary

        FunctionX509_NAME_get_index_by_OBJ := CCallout
                library: cLibrary
                name: 'X509_NAME_get_index_by_OBJ'
                result: #'int32'
                args: #(#'ptr' #'ptr' #'int32')
                varArgsAfter: -1.
%

!		Instance methods for 'LibCrypto'

category: 'Functions'
method: LibCrypto
ASN1_STRING_get0_data_: x
        "/daytank1/users/mmcclure/prefix/include/openssl/asn1.h line 554
const unsigned char *ASN1_STRING_get0_data(const ASN1_STRING *x);"
        "Interpreted as #char* from #( #'ptr' )"

        ^FunctionASN1_STRING_get0_data callWith: {x}
%

category: 'Functions'
method: LibCrypto
OBJ_txt2obj_: s _: no_name
        "/daytank1/users/mmcclure/prefix/include/openssl/objects.h line 963
ASN1_OBJECT *OBJ_txt2obj(const char *s, int no_name);"

        "Interpreted as #ptr from #( #'const char*' #'int32' )"

        ^FunctionOBJ_txt2obj callWith: { s. no_name }
%

category: 'Functions'
method: LibCrypto
X509_free_: x

	^FunctionX509_free callWith: {x}
%

category: 'Functions'
method: LibCrypto
X509_get_subject_name_: a
        "/daytank1/users/mmcclure/prefix/include/openssl/x509.h line 623
X509_NAME *X509_get_subject_name(const X509 *a);"

        "Interpreted as #ptr from #( #'ptr' )"

        ^FunctionX509_get_subject_name callWith: { a }
%

category: 'Functions'
method: LibCrypto
X509_NAME_ENTRY_get_data_: ne
        "/daytank1/users/mmcclure/prefix/include/openssl/x509.h line 822
ASN1_STRING * X509_NAME_ENTRY_get_data(const X509_NAME_ENTRY *ne);"

        "Interpreted as #ptr from #( #'ptr' )"

        ^FunctionX509_NAME_ENTRY_get_data callWith: { ne }
%

category: 'Functions'
method: LibCrypto
X509_NAME_get_entry_: name _: loc
        "/daytank1/users/mmcclure/prefix/include/openssl/x509.h line 793
X509_NAME_ENTRY *X509_NAME_get_entry(const X509_NAME *name, int loc);"

        "Interpreted as #ptr from #( #'ptr' #'int32' )"

        ^FunctionX509_NAME_get_entry callWith: { name. loc }
%

category: 'Functions'
method: LibCrypto
X509_NAME_get_index_by_OBJ_: name _: obj _: lastpos
        "/daytank1/users/mmcclure/prefix/include/openssl/x509.h line 791
int X509_NAME_get_index_by_OBJ(X509_NAME *name, const ASN1_OBJECT *obj,
                               int lastpos);"

        "Interpreted as #int32 from #( #'ptr' #'ptr' #'int32' )"

        ^FunctionX509_NAME_get_index_by_OBJ callWith: { name. obj. lastpos }
%

! Class implementation for 'LibcSocket'

!		Class methods for 'LibcSocket'

category: 'Constants'
classmethod: LibcSocket
af_inet

	^2
%

category: 'Constants'
classmethod: LibcSocket
af_inet6
  | cpuOs |
  cpuOs := GsProcess cpuOsKind .
  cpuOs == 3 ifTrue:[ ^10 "x86_64 linux" ].
  (cpuOs == 2 or:[ cpuOs == 6 ]) ifTrue:[ ^ 26 "solaris" ].
  cpuOs == 4 ifTrue:[ ^ 24 "AIX" ].
  cpuOs == 5 ifTrue:[ ^ 30 "Darwin"].
  Error signal:'unknown cpuOs ' , cpuOs asString .
%

category: 'Initializing - private'
classmethod: LibcSocket
initialize

	self initializeFunctions
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunctions

	| library |
	library := nil.	"Libc should already be loaded."
	self
		initializeFunction_accept_inLibrary: library;
		initializeFunction_bind_inLibrary: library;
		initializeFunction_connect_inLibrary: library;
		initializeFunction_getpeername_inLibrary: library;
		initializeFunction_getsockname_inLibrary: library;
		initializeFunction_getsockopt_inLibrary: library;
		initializeFunction_gnu_dev_major_inLibrary: library;
		initializeFunction_gnu_dev_makedev_inLibrary: library;
		initializeFunction_gnu_dev_minor_inLibrary: library;
		initializeFunction_isfdtype_inLibrary: library;
		initializeFunction_listen_inLibrary: library;
		initializeFunction_preadv_inLibrary: library;
		initializeFunction_pselect_inLibrary: library;
		initializeFunction_pwritev_inLibrary: library;
		initializeFunction_readv_inLibrary: library;
		initializeFunction_recv_inLibrary: library;
		initializeFunction_recvfrom_inLibrary: library;
		initializeFunction_recvmsg_inLibrary: library;
		initializeFunction_select_inLibrary: library;
		initializeFunction_send_inLibrary: library;
		initializeFunction_sendmsg_inLibrary: library;
		initializeFunction_sendto_inLibrary: library;
		initializeFunction_setsockopt_inLibrary: library;
		initializeFunction_shutdown_inLibrary: library;
		initializeFunction_sockatmark_inLibrary: library;
		initializeFunction_socket_inLibrary: library;
		initializeFunction_socketpair_inLibrary: library;
		initializeFunction_writev_inLibrary: library;
		initializeFunction___cmsg_nxthdr_inLibrary: library;
		initializeFunction___fdelt_chk_inLibrary: library;
		initializeFunction___fdelt_warn_inLibrary: library;
		initializeFunction___recvfrom_chk_inLibrary: library;
		initializeFunction___recv_chk_inLibrary: library;
		yourself
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction_accept_inLibrary: cLibrary

	Functionaccept := CCallout
		library: cLibrary
		name: 'accept'
		result: #'int32'
		args: #(#'int32' #'ptr' #'ptr')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction_bind_inLibrary: cLibrary

	Functionbind := CCallout
		library: cLibrary
		name: 'bind'
		result: #'int32'
		args: #(#'int32' #'ptr' #'uint32')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction_connect_inLibrary: cLibrary

	Functionconnect := CCallout
		library: cLibrary
		name: 'connect'
		result: #'int32'
		args: #(#'int32' #'ptr' #'uint32')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction_getpeername_inLibrary: cLibrary

	Functiongetpeername := CCallout
		library: cLibrary
		name: 'getpeername'
		result: #'int32'
		args: #(#'int32' #'ptr' #'ptr')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction_getsockname_inLibrary: cLibrary

	Functiongetsockname := CCallout
		library: cLibrary
		name: 'getsockname'
		result: #'int32'
		args: #(#'int32' #'ptr' #'ptr')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction_getsockopt_inLibrary: cLibrary

	Functiongetsockopt := CCallout
		library: cLibrary
		name: 'getsockopt'
		result: #'int32'
		args: #(#'int32' #'int32' #'int32' #'ptr' #'ptr')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction_gnu_dev_major_inLibrary: cLibrary

	Functiongnu_dev_major := CCallout
		library: cLibrary
		name: 'gnu_dev_major'
		result: #'uint32'
		args: #(#'uint64')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction_gnu_dev_makedev_inLibrary: cLibrary

	Functiongnu_dev_makedev := CCallout
		library: cLibrary
		name: 'gnu_dev_makedev'
		result: #'uint64'
		args: #(#'uint32' #'uint32')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction_gnu_dev_minor_inLibrary: cLibrary

	Functiongnu_dev_minor := CCallout
		library: cLibrary
		name: 'gnu_dev_minor'
		result: #'uint32'
		args: #(#'uint64')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction_isfdtype_inLibrary: cLibrary

	Functionisfdtype := CCallout
		library: cLibrary
		name: 'isfdtype'
		result: #'int32'
		args: #(#'int32' #'int32')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction_listen_inLibrary: cLibrary

	Functionlisten := CCallout
		library: cLibrary
		name: 'listen'
		result: #'int32'
		args: #(#'int32' #'int32')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction_preadv_inLibrary: cLibrary

	Functionpreadv := CCallout
		library: cLibrary
		name: 'preadv'
		result: #'int64'
		args: #(#'int32' #'ptr' #'int32' #'int64')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction_pselect_inLibrary: cLibrary

	Functionpselect := CCallout
		library: cLibrary
		name: 'pselect'
		result: #'int32'
		args: #(#'int32' #'ptr' #'ptr' #'ptr' #'ptr' #'ptr')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction_pwritev_inLibrary: cLibrary

	Functionpwritev := CCallout
		library: cLibrary
		name: 'pwritev'
		result: #'int64'
		args: #(#'int32' #'ptr' #'int32' #'int64')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction_readv_inLibrary: cLibrary

	Functionreadv := CCallout
		library: cLibrary
		name: 'readv'
		result: #'int64'
		args: #(#'int32' #'ptr' #'int32')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction_recvfrom_inLibrary: cLibrary

	Functionrecvfrom := CCallout
		library: cLibrary
		name: 'recvfrom'
		result: #'int64'
		args: #(#'int32' #'ptr' #'uint64' #'int32' #'ptr' #'ptr')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction_recvmsg_inLibrary: cLibrary

	Functionrecvmsg := CCallout
		library: cLibrary
		name: 'recvmsg'
		result: #'int64'
		args: #(#'int32' #'ptr' #'int32')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction_recv_inLibrary: cLibrary

	Functionrecv := CCallout
		library: cLibrary
		name: 'recv'
		result: #'int64'
		args: #(#'int32' #'ptr' #'uint64' #'int32')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction_select_inLibrary: cLibrary

	Functionselect := CCallout
		library: cLibrary
		name: 'select'
		result: #'int32'
		args: #(#'int32' #'ptr' #'ptr' #'ptr' #'ptr')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction_sendmsg_inLibrary: cLibrary

	Functionsendmsg := CCallout
		library: cLibrary
		name: 'sendmsg'
		result: #'int64'
		args: #(#'int32' #'ptr' #'int32')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction_sendto_inLibrary: cLibrary

	Functionsendto := CCallout
		library: cLibrary
		name: 'sendto'
		result: #'int64'
		args: #(#'int32' #'ptr' #'uint64' #'int32' #'ptr' #'uint32')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction_send_inLibrary: cLibrary

	Functionsend := CCallout
		library: cLibrary
		name: 'send'
		result: #'int64'
		args: #(#'int32' #'ptr' #'uint64' #'int32')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction_setsockopt_inLibrary: cLibrary

	Functionsetsockopt := CCallout
		library: cLibrary
		name: 'setsockopt'
		result: #'int32'
		args: #(#'int32' #'int32' #'int32' #'ptr' #'uint32')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction_shutdown_inLibrary: cLibrary

	Functionshutdown := CCallout
		library: cLibrary
		name: 'shutdown'
		result: #'int32'
		args: #(#'int32' #'int32')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction_sockatmark_inLibrary: cLibrary

	Functionsockatmark := CCallout
		library: cLibrary
		name: 'sockatmark'
		result: #'int32'
		args: #(#'int32')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction_socketpair_inLibrary: cLibrary

	Functionsocketpair := CCallout
		library: cLibrary
		name: 'socketpair'
		result: #'int32'
		args: #(#'int32' #'int32' #'int32' #'ptr')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction_socket_inLibrary: cLibrary

	Functionsocket := CCallout
		library: cLibrary
		name: 'socket'
		result: #'int32'
		args: #(#'int32' #'int32' #'int32')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction_writev_inLibrary: cLibrary

	Functionwritev := CCallout
		library: cLibrary
		name: 'writev'
		result: #'int64'
		args: #(#'int32' #'ptr' #'int32')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction___cmsg_nxthdr_inLibrary: cLibrary

	Function__cmsg_nxthdr := CCallout
		library: cLibrary
		name: '__cmsg_nxthdr'
		result: #'ptr'
		args: #(#'ptr' #'ptr')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction___fdelt_chk_inLibrary: cLibrary

	Function__fdelt_chk := CCallout
		library: cLibrary
		name: '__fdelt_chk'
		result: #'int64'
		args: #(#'int64')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction___fdelt_warn_inLibrary: cLibrary

	Function__fdelt_warn := CCallout
		library: cLibrary
		name: '__fdelt_warn'
		result: #'int64'
		args: #(#'int64')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction___recvfrom_chk_inLibrary: cLibrary

	Function__recvfrom_chk := CCallout
		library: cLibrary
		name: '__recvfrom_chk'
		result: #'int64'
		args: #(#'int32' #'ptr' #'uint64' #'uint64' #'int32' #'ptr' #'ptr')
		varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibcSocket
initializeFunction___recv_chk_inLibrary: cLibrary

	Function__recv_chk := CCallout
		library: cLibrary
		name: '__recv_chk'
		result: #'int64'
		args: #(#'int32' #'ptr' #'uint64' #'uint64' #'int32')
		varArgsAfter: -1.
%

!		Instance methods for 'LibcSocket'

category: 'Functions'
method: LibcSocket
accept_: __fd _: __addr _: __addr_len 
	"/usr/include/sys/socket.h line 243
/* Await a connection on socket FD.
   When a connection arrives, open a new socket to communicate with it,
   set *ADDR (which is *ADDR_LEN bytes long) to the address of the connecting
   peer and *ADDR_LEN to the address's actual length, and return the
   new socket's descriptor, or -1 for errors.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern int accept (int __fd, __SOCKADDR_ARG __addr,
		   socklen_t *__restrict __addr_len);"

	"Interpreted as #int32 from #( #'int32' #'ptr' #'ptr' )"

	^Functionaccept callWith: { __fd. __addr. __addr_len }
%

category: 'Constants'
method: LibcSocket
af_inet

	^self class af_inet
%

category: 'Constants'
method: LibcSocket
af_inet6

	^self class af_inet6
%

category: 'Functions'
method: LibcSocket
bind_: __fd _: __addr _: __len 
	"/usr/include/sys/socket.h line 123
/* Give the socket FD the local address ADDR (which is LEN bytes long).  */
extern int bind (int __fd, __CONST_SOCKADDR_ARG __addr, socklen_t __len)
     __THROW;"

	"Interpreted as #int32 from #( #'int32' #'ptr' #'uint32' )"

	^Functionbind callWith: { __fd. __addr. __len }
%

category: 'Functions'
method: LibcSocket
connect_: __fd _: __addr _: __len 
	"/usr/include/sys/socket.h line 137
/* Open a connection on socket FD to peer at ADDR (which LEN bytes long).
   For connectionless socket types, just set the default address to send to
   and the only address from which to accept transmissions.
   Return 0 on success, -1 for errors.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern int connect (int __fd, __CONST_SOCKADDR_ARG __addr, socklen_t __len);"

	"Interpreted as #int32 from #( #'int32' #'ptr' #'uint32' )"

	^Functionconnect callWith: { __fd. __addr. __len }
%

category: 'Functions'
method: LibcSocket
getpeername_: __fd _: __addr _: __len 
	"/usr/include/sys/socket.h line 141
/* Put the address of the peer connected to socket FD into *ADDR
   (which is *LEN bytes long), and its actual length into *LEN.  */
extern int getpeername (int __fd, __SOCKADDR_ARG __addr,
			socklen_t *__restrict __len) __THROW;"

	"Interpreted as #int32 from #( #'int32' #'ptr' #'ptr' )"

	^Functiongetpeername callWith: { __fd. __addr. __len }
%

category: 'Functions'
method: LibcSocket
getsockname_: __fd _: __addr _: __len 
	"/usr/include/sys/socket.h line 127
/* Put the local address of FD into *ADDR and its length in *LEN.  */
extern int getsockname (int __fd, __SOCKADDR_ARG __addr,
			socklen_t *__restrict __len) __THROW;"

	"Interpreted as #int32 from #( #'int32' #'ptr' #'ptr' )"

	^Functiongetsockname callWith: { __fd. __addr. __len }
%

category: 'Functions'
method: LibcSocket
getsockopt_: __fd _: __level _: __optname _: __optval _: __optlen 
	"/usr/include/sys/socket.h line 219
/* Put the current value for socket FD's option OPTNAME at protocol level LEVEL
   into OPTVAL (which is *OPTLEN bytes long), and set *OPTLEN to the value's
   actual length.  Returns 0 on success, -1 for errors.  */
extern int getsockopt (int __fd, int __level, int __optname,
		       void *__restrict __optval,
		       socklen_t *__restrict __optlen) __THROW;"

	"Interpreted as #int32 from #( #'int32' #'int32' #'int32' #'ptr' #'ptr' )"

	^Functiongetsockopt callWith: { __fd. __level. __optname. __optval. __optlen }
%

category: 'Functions'
method: LibcSocket
gnu_dev_major_: __dev 
	"/usr/include/sys/sysmacros.h line 26
__extension__
extern unsigned int gnu_dev_major (unsigned long long int __dev)
     __THROW __attribute_const__;"

	"Interpreted as #uint32 from #( #'uint64' )"

	^Functiongnu_dev_major callWith: { __dev }
%

category: 'Functions'
method: LibcSocket
gnu_dev_makedev_: __major _: __minor 
	"/usr/include/sys/sysmacros.h line 32
__extension__
extern unsigned long long int gnu_dev_makedev (unsigned int __major,
					       unsigned int __minor)
     __THROW __attribute_const__;"

	"Interpreted as #uint64 from #( #'uint32' #'uint32' )"

	^Functiongnu_dev_makedev callWith: { __major. __minor }
%

category: 'Functions'
method: LibcSocket
gnu_dev_minor_: __dev 
	"/usr/include/sys/sysmacros.h line 29
__extension__
extern unsigned int gnu_dev_minor (unsigned long long int __dev)
     __THROW __attribute_const__;"

	"Interpreted as #uint32 from #( #'uint64' )"

	^Functiongnu_dev_minor callWith: { __dev }
%

category: 'Functions'
method: LibcSocket
isfdtype_: __fd _: __fdtype 
	"/usr/include/sys/socket.h line 274
/* FDTYPE is S_IFSOCK or another S_IF* macro defined in <sys/stat.h>;
   returns 1 if FD is open on an object of the indicated type, 0 if not,
   or -1 for errors (setting errno).  */
extern int isfdtype (int __fd, int __fdtype) __THROW;"

	"Interpreted as #int32 from #( #'int32' #'int32' )"

	^Functionisfdtype callWith: { __fd. __fdtype }
%

category: 'Functions'
method: LibcSocket
listen_: __fd _: __n 
	"/usr/include/sys/socket.h line 233
/* Prepare to accept connections on socket FD.
   N connection requests will be queued before further requests are refused.
   Returns 0 on success, -1 for errors.  */
extern int listen (int __fd, int __n) __THROW;"

	"Interpreted as #int32 from #( #'int32' #'int32' )"

	^Functionlisten callWith: { __fd. __n }
%

category: 'Functions'
method: LibcSocket
preadv_: __fd _: __iovec _: __count _: __offset 
	"/usr/include/sys/uio.h line 65
/* Read data from file descriptor FD at the given position OFFSET
   without change the file pointer, and put the result in the buffers
   described by IOVEC, which is a vector of COUNT 'struct iovec's.
   The buffers are filled in the order specified.  Operates just like
   'pread' (see <unistd.h>) except that data are put in IOVEC instead
   of a contiguous buffer.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern ssize_t preadv (int __fd, const struct iovec *__iovec, int __count,
		       __off_t __offset) __wur;"

	"Interpreted as #int64 from #( #'int32' #'ptr' #'int32' #'int64' )"

	^Functionpreadv callWith: { __fd. __iovec. __count. __offset }
%

category: 'Functions'
method: LibcSocket
pselect_: __nfds _: __readfds _: __writefds _: __exceptfds _: __timeout _: __sigmask 
	"/usr/include/sys/select.h line 118
/* Same as above only that the TIMEOUT value is given with higher
   resolution and a sigmask which is been set temporarily.  This version
   should be used.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern int pselect (int __nfds, fd_set *__restrict __readfds,
		    fd_set *__restrict __writefds,
		    fd_set *__restrict __exceptfds,
		    const struct timespec *__restrict __timeout,
		    const __sigset_t *__restrict __sigmask);"

	"Interpreted as #int32 from #( #'int32' #'ptr' #'ptr' #'ptr' #'ptr' #'ptr' )"

	^Functionpselect callWith: { __nfds. __readfds. __writefds. __exceptfds. __timeout. __sigmask }
%

category: 'Functions'
method: LibcSocket
pwritev_: __fd _: __iovec _: __count _: __offset 
	"/usr/include/sys/uio.h line 77
/* Write data pointed by the buffers described by IOVEC, which is a
   vector of COUNT 'struct iovec's, to file descriptor FD at the given
   position OFFSET without change the file pointer.  The data is
   written in the order specified.  Operates just like 'pwrite' (see
   <unistd.h>) except that the data are taken from IOVEC instead of a
   contiguous buffer.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern ssize_t pwritev (int __fd, const struct iovec *__iovec, int __count,
			__off_t __offset) __wur;"

	"Interpreted as #int64 from #( #'int32' #'ptr' #'int32' #'int64' )"

	^Functionpwritev callWith: { __fd. __iovec. __count. __offset }
%

category: 'Functions'
method: LibcSocket
readv_: __fd _: __iovec _: __count 
	"/usr/include/sys/uio.h line 39
/* Read data from file descriptor FD, and put the result in the
   buffers described by IOVEC, which is a vector of COUNT 'struct iovec's.
   The buffers are filled in the order specified.
   Operates just like 'read' (see <unistd.h>) except that data are
   put in IOVEC instead of a contiguous buffer.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern ssize_t readv (int __fd, const struct iovec *__iovec, int __count)
  __wur;"

	"Interpreted as #int64 from #( #'int32' #'ptr' #'int32' )"

	^Functionreadv callWith: { __fd. __iovec. __count }
%

category: 'Functions'
method: LibcSocket
recvfrom_: __fd _: __buf _: __n _: __flags _: __addr _: __addr_len 
	"/usr/include/sys/socket.h line 174
/* Read N bytes into BUF through socket FD.
   If ADDR is not NULL, fill in *ADDR_LEN bytes of it with tha address of
   the sender, and store the actual size of the address in *ADDR_LEN.
   Returns the number of bytes read or -1 for errors.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern ssize_t recvfrom (int __fd, void *__restrict __buf, size_t __n,
			 int __flags, __SOCKADDR_ARG __addr,
			 socklen_t *__restrict __addr_len);"

	"Interpreted as #int64 from #( #'int32' #'ptr' #'uint64' #'int32' #'ptr' #'ptr' )"

	^Functionrecvfrom callWith: { __fd. __buf. __n. __flags. __addr. __addr_len }
%

category: 'Functions'
method: LibcSocket
recvmsg_: __fd _: __message _: __flags 
	"/usr/include/sys/socket.h line 202
/* Receive a message as described by MESSAGE from socket FD.
   Returns the number of bytes read or -1 for errors.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern ssize_t recvmsg (int __fd, struct msghdr *__message, int __flags);"

	"Interpreted as #int64 from #( #'int32' #'ptr' #'int32' )"

	^Functionrecvmsg callWith: { __fd. __message. __flags }
%

category: 'Functions'
method: LibcSocket
recv_: __fd _: __buf _: __n _: __flags 
	"/usr/include/sys/socket.h line 156
/* Read N bytes into BUF from socket FD.
   Returns the number read or -1 for errors.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern ssize_t recv (int __fd, void *__buf, size_t __n, int __flags);"

	"Interpreted as #int64 from #( #'int32' #'ptr' #'uint64' #'int32' )"

	^Functionrecv callWith: { __fd. __buf. __n. __flags }
%

category: 'Functions'
method: LibcSocket
select_: __nfds _: __readfds _: __writefds _: __exceptfds _: __timeout 
	"/usr/include/sys/select.h line 106
/* Check the first NFDS descriptors each in READFDS (if not NULL) for read
   readiness, in WRITEFDS (if not NULL) for write readiness, and in EXCEPTFDS
   (if not NULL) for exceptional conditions.  If TIMEOUT is not NULL, time out
   after waiting the interval specified therein.  Returns the number of ready
   descriptors, or -1 for errors.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern int select (int __nfds, fd_set *__restrict __readfds,
		   fd_set *__restrict __writefds,
		   fd_set *__restrict __exceptfds,
		   struct timeval *__restrict __timeout);"

	"Interpreted as #int32 from #( #'int32' #'ptr' #'ptr' #'ptr' #'ptr' )"

	^Functionselect callWith: { __nfds. __readfds. __writefds. __exceptfds. __timeout }
%

category: 'Functions'
method: LibcSocket
sendmsg_: __fd _: __message _: __flags 
	"/usr/include/sys/socket.h line 184
/* Send a message described MESSAGE on socket FD.
   Returns the number of bytes sent, or -1 for errors.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern ssize_t sendmsg (int __fd, const struct msghdr *__message,
			int __flags);"

	"Interpreted as #int64 from #( #'int32' #'ptr' #'int32' )"

	^Functionsendmsg callWith: { __fd. __message. __flags }
%

category: 'Functions'
method: LibcSocket
sendto_: __fd _: __buf _: __n _: __flags _: __addr _: __addr_len 
	"/usr/include/sys/socket.h line 163
/* Send N bytes of BUF on socket FD to peer at address ADDR (which is
   ADDR_LEN bytes long).  Returns the number sent, or -1 for errors.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern ssize_t sendto (int __fd, const void *__buf, size_t __n,
		       int __flags, __CONST_SOCKADDR_ARG __addr,
		       socklen_t __addr_len);"

	"Interpreted as #int64 from #( #'int32' #'ptr' #'uint64' #'int32' #'ptr' #'uint32' )"

	^Functionsendto callWith: { __fd. __buf. __n. __flags. __addr. __addr_len }
%

category: 'Functions'
method: LibcSocket
send_: __fd _: __buf _: __n _: __flags 
	"/usr/include/sys/socket.h line 149
/* Send N bytes of BUF to socket FD.  Returns the number sent or -1.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern ssize_t send (int __fd, const void *__buf, size_t __n, int __flags);"

	"Interpreted as #int64 from #( #'int32' #'ptr' #'uint64' #'int32' )"

	^Functionsend callWith: { __fd. __buf. __n. __flags }
%

category: 'Functions'
method: LibcSocket
setsockopt_: __fd _: __level _: __optname _: __optval _: __optlen 
	"/usr/include/sys/socket.h line 226
/* Set socket FD's option OPTNAME at protocol level LEVEL
   to *OPTVAL (which is OPTLEN bytes long).
   Returns 0 on success, -1 for errors.  */
extern int setsockopt (int __fd, int __level, int __optname,
		       const void *__optval, socklen_t __optlen) __THROW;"

	"Interpreted as #int32 from #( #'int32' #'int32' #'int32' #'ptr' #'uint32' )"

	^Functionsetsockopt callWith: { __fd. __level. __optname. __optval. __optlen }
%

category: 'Functions'
method: LibcSocket
shutdown_: __fd _: __how 
	"/usr/include/sys/socket.h line 261
/* Shut down all or part of the connection open on socket FD.
   HOW determines what to shut down:
     SHUT_RD   = No more receptions;
     SHUT_WR   = No more transmissions;
     SHUT_RDWR = No more receptions or transmissions.
   Returns 0 on success, -1 for errors.  */
extern int shutdown (int __fd, int __how) __THROW;"

	"Interpreted as #int32 from #( #'int32' #'int32' )"

	^Functionshutdown callWith: { __fd. __how }
%

category: 'Functions'
method: LibcSocket
sockatmark_: __fd 
	"/usr/include/sys/socket.h line 266
/* Determine wheter socket is at a out-of-band mark.  */
extern int sockatmark (int __fd) __THROW;"

	"Interpreted as #int32 from #( #'int32' )"

	^Functionsockatmark callWith: { __fd }
%

category: 'Functions'
method: LibcSocket
socketpair_: __domain _: __type _: __protocol _: __fds 
	"/usr/include/sys/socket.h line 119
/* Create two new sockets, of type TYPE in domain DOMAIN and using
   protocol PROTOCOL, which are connected to each other, and put file
   descriptors for them in FDS[0] and FDS[1].  If PROTOCOL is zero,
   one will be chosen automatically.  Returns 0 on success, -1 for errors.  */
extern int socketpair (int __domain, int __type, int __protocol,
		       int __fds[2]) __THROW;"

	"Interpreted as #int32 from #( #'int32' #'int32' #'int32' #'ptr' )"

	^Functionsocketpair callWith: { __domain. __type. __protocol. __fds }
%

category: 'Functions'
method: LibcSocket
socket_: __domain _: __type _: __protocol 
	"/usr/include/sys/socket.h line 113
/* Create a new socket of type TYPE in domain DOMAIN, using
   protocol PROTOCOL.  If PROTOCOL is zero, one is chosen automatically.
   Returns a file descriptor for the new socket, or -1 for errors.  */
extern int socket (int __domain, int __type, int __protocol) __THROW;"

	"Interpreted as #int32 from #( #'int32' #'int32' #'int32' )"

	^Functionsocket callWith: { __domain. __type. __protocol }
%

category: 'Constants'
method: LibcSocket
sock_stream
	^ 1
%

category: 'Higher-level functions'
method: LibcSocket
tcpSocket

	^self
		socket_: self af_inet
		_: self sock_stream
		_: 0
%

category: 'Functions'
method: LibcSocket
writev_: __fd _: __iovec _: __count 
	"/usr/include/sys/uio.h line 50
/* Write data pointed by the buffers described by IOVEC, which
   is a vector of COUNT 'struct iovec's, to file descriptor FD.
   The data is written in the order specified.
   Operates just like 'write' (see <unistd.h>) except that the data
   are taken from IOVEC instead of a contiguous buffer.

   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern ssize_t writev (int __fd, const struct iovec *__iovec, int __count)
  __wur;"

	"Interpreted as #int64 from #( #'int32' #'ptr' #'int32' )"

	^Functionwritev callWith: { __fd. __iovec. __count }
%

category: 'Functions'
method: LibcSocket
__cmsg_nxthdr_: __mhdr _: __cmsg 
	"/usr/include/bits/socket.h line 276
extern struct cmsghdr *__cmsg_nxthdr (struct msghdr *__mhdr,
				      struct cmsghdr *__cmsg) __THROW;"

	"Interpreted as #ptr from #( #'ptr' #'ptr' )"

	^Function__cmsg_nxthdr callWith: { __mhdr. __cmsg }
%

category: 'Functions'
method: LibcSocket
__fdelt_chk_: __d 
	"/usr/include/bits/select2.h line 24
/* Helper functions to issue warnings and errors when needed.  */
extern long int __fdelt_chk (long int __d);"

	"Interpreted as #int64 from #( #'int64' )"

	^Function__fdelt_chk callWith: { __d }
%

category: 'Functions'
method: LibcSocket
__fdelt_warn_: __d 
	"/usr/include/bits/select2.h line 25
extern long int __fdelt_warn (long int __d)
  __warnattr (""bit outside of fd_set selected"");"

	"Interpreted as #int64 from #( #'int64' )"

	^Function__fdelt_warn callWith: { __d }
%

category: 'Functions'
method: LibcSocket
__recvfrom_chk_: __fd _: __buf _: __n _: __buflen _: __flags _: __addr _: __addr_len 
	"/usr/include/bits/socket2.h line 43
extern ssize_t __recvfrom_chk (int __fd, void *__restrict __buf, size_t __n,
			       size_t __buflen, int __flags,
			       __SOCKADDR_ARG __addr,
			       socklen_t *__restrict __addr_len);"

	"Interpreted as #int64 from #( #'int32' #'ptr' #'uint64' #'uint64' #'int32' #'ptr' #'ptr' )"

	^Function__recvfrom_chk callWith: { __fd. __buf. __n. __buflen. __flags. __addr. __addr_len }
%

category: 'Functions'
method: LibcSocket
__recv_chk_: __fd _: __buf _: __n _: __buflen _: __flags 
	"/usr/include/bits/socket2.h line 23
extern ssize_t __recv_chk (int __fd, void *__buf, size_t __n, size_t __buflen,
			   int __flags);"

	"Interpreted as #int64 from #( #'int32' #'ptr' #'uint64' #'uint64' #'int32' )"

	^Function__recv_chk callWith: { __fd. __buf. __n. __buflen. __flags }
%

! Class implementation for 'LibSsl'

!		Class methods for 'LibSsl'

category: 'Initializing - private'
classmethod: LibSsl
initialize
	| library |
	library := nil.
	"library := CLibrary named: '/daytank1/users/mmcclure/prefix/lib/libssl.so.1.1'."
	self
                initializeFunction_SSL_get_SSL_CTX_inLibrary: library;
                initializeFunction_SSL_get_error_inLibrary: library;
                initializeFunction_SSL_get_fd_inLibrary: library;
                initializeFunction_SSL_get1_peer_certificate_inLibrary: library;
                initializeFunction_TLS_server_method_inLibrary: library;
		yourself.
%

category: 'Initializing - private'
classmethod: LibSsl
initializeFunction_SSL_get1_peer_certificate_inLibrary: cLibrary

        FunctionSSL_get1_peer_certificate := CCallout
                library: cLibrary
                name: 'SSL_get1_peer_certificate'
                result: #'ptr'
                args: #(#'ptr')
                varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibSsl
initializeFunction_SSL_get_error_inLibrary: cLibrary

        FunctionSSL_get_error := CCallout
                library: cLibrary
                name: 'SSL_get_error'
                result: #'int32'
                args: #(#'ptr' #'int32')
                varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibSsl
initializeFunction_SSL_get_fd_inLibrary: cLibrary

        FunctionSSL_get_fd := CCallout
                library: cLibrary
                name: 'SSL_get_fd'
                result: #'int32'
                args: #(#'ptr')
                varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibSsl
initializeFunction_SSL_get_SSL_CTX_inLibrary: cLibrary

        FunctionSSL_get_SSL_CTX := CCallout
                library: cLibrary
                name: 'SSL_get_SSL_CTX'
                result: #'ptr'
                args: #(#'ptr')
                varArgsAfter: -1.
%

category: 'Initializing - private'
classmethod: LibSsl
initializeFunction_TLS_server_method_inLibrary: cLibrary

        FunctionTLS_server_method := CCallout
                library: cLibrary
                name: 'TLS_server_method'
                result: #'ptr'
                args: #()
                varArgsAfter: -1.
%

!		Instance methods for 'LibSsl'

category: 'Functions'
method: LibSsl
SSL_get1_peer_certificate_: s
        "/daytank1/users/mmcclure/prefix/include/openssl/ssl.h line 1457
__owur X509 *SSL_get1_peer_certificate(const SSL *s);"

        "Interpreted as #ptr from #( #'ptr' )"

        ^FunctionSSL_get1_peer_certificate callWith: { s }
%

category: 'Functions'
method: LibSsl
SSL_get_error_: s _: ret_code
        "/daytank1/users/mmcclure/prefix/include/openssl/ssl.h line 1590
__owur int SSL_get_error(const SSL *s, int ret_code);"

        "Interpreted as #int32 from #( #'ptr' #'int32' )"

        ^FunctionSSL_get_error callWith: { s. ret_code }
%

category: 'Functions'
method: LibSsl
SSL_get_fd_: s
        "/daytank1/users/mmcclure/prefix/include/openssl/ssl.h line 1342
__owur int SSL_get_fd(const SSL *s);"

        "Interpreted as #int32 from #( #'ptr' )"

        ^FunctionSSL_get_fd callWith: { s }
%

category: 'Functions'
method: LibSsl
SSL_get_SSL_CTX_: ssl
        "/daytank1/users/mmcclure/prefix/include/openssl/ssl.h line 1709
__owur SSL_CTX *SSL_get_SSL_CTX(const SSL *ssl);"

        "Interpreted as #ptr from #( #'ptr' )"

        ^FunctionSSL_get_SSL_CTX callWith: { ssl }
%

category: 'Functions'
method: LibSsl
TLS_server_method
        "/daytank1/users/mmcclure/prefix/include/openssl/ssl.h line 1608
__owur const SSL_METHOD *TLS_server_method(void);"

        "Interpreted as #ptr from #( )"

        ^FunctionTLS_server_method callWith: {  }
%

! Class implementation for 'PortRange'

!		Class methods for 'PortRange'

category: 'instance creation'
classmethod: PortRange
lowPort: lowPort highPort: highPort avoidPort: avoidPort

	highPort < lowPort
		ifTrue: [ArgumentError signal: 'highPort must be >= lowPort'].
	^self new
		initializeForLowPort: lowPort
		highPort: highPort
		avoidPort: avoidPort
%

!		Instance methods for 'PortRange'

category: 'printing'
method: PortRange
asString
  | str |
  str := String new .
  ports do:[:x | str addAll: x printString ; addAll:' . ' ].  
  ^ str
%

category: 'enumeration'
method: PortRange
detect: aBlock ifNone: noneBlock
	"Equivalent to OrderedCollection detect:ifNone: but starting at a 
   random point in the port numbers."

	| startOfs |
	startOfs := HostRandom new integerBetween: 1 and: numPorts - 1 .
  ports do:[ :aRange |
    startOfs to: aRange size do:[:ofs | | portNum |
      (aBlock value: (portNum := aRange at: ofs)) ifTrue:[ ^ portNum]
    ].
    startOfs := (startOfs - aRange size) min: 1 .
  ].
	"Tried them all, none worked."
	^noneBlock value
%

category: 'initialization'
method: PortRange
initializeForLowPort: lowPort highPort: highPort avoidPort: avoidPort
	| count |
  "initialize ports to an Array of 1 or 2 Intervals"
  GsFile gciLogServer: 'PortRange  low ', lowPort asString, ' high ', 
									highPort asString, ' avoid ' , avoidPort asString .
  numPorts := highPort - lowPort  .
  avoidPort == lowPort 
    ifTrue:[ ports := { lowPort + 1 to: highPort }. ] ifFalse:[
  avoidPort == highPort 
    ifTrue:[ ports := lowPort to: highPort - 1] ifFalse:[
  (avoidPort > lowPort and:[ avoidPort < highPort]) 
    ifTrue:[ ports := { lowPort to: avoidPort - 1 . avoidPort + 1 to: highPort }. 
  ] ifFalse:[
    ports := { lowPort to: highPort } .
    numPorts := highPort - lowPort + 1. "no port to avoid"
  ]]].
  count := 0 .
  ports do:[:aRange | count := count + aRange size ].
	^self
%

! Class implementation for 'TlsActor'

!		Class methods for 'TlsActor'

category: 'instance creation'
classmethod: TlsActor
new

	^super new initialize
%

!		Instance methods for 'TlsActor'

category: 'utility'
method: TlsActor
checkForNullReturn: retval from: funcName
	"For functions that return a pointer or null in case of error"

	retval memoryAddress = 0
		ifTrue: [self error: 'Error: ' , funcName , ' returned ' , retval printString]
%

category: 'utility'
method: TlsActor
checkReturn: retval from: funcName
	"For libssl functions that return >0 on success and 0 or -1 on failure."

	retval > 0
		ifFalse: 
			[self error: 'Error: ' , funcName , ' returned ' , retval printString]
%

category: 'utility'
method: TlsActor
checkSslReturn: retval from: funcName
	"For libssl functions that return >0 on success and 0 or -1 on failure."

	retval > 0
		ifFalse: 
			[| resultCode |
			resultCode := libSsl SSL_get_error_: ssl _: retval.
			self
				error: 'Error: ' , funcName , ' returned ' , retval printString
						, ' result code ' , resultCode printString]
%

category: 'error handling'
method: TlsActor
error: errorDescription

	Error signal: errorDescription
%

category: 'certificate info'
method: TlsActor
getAllValuesOf: oid from: subject

	| values index |
	values := Array new.
	index := -1.
	
	[index := libCrypto X509_NAME_get_index_by_OBJ_: subject _: oid _: index.
	index = -1]
			whileFalse: 
				[| entry string name |
				entry := libCrypto X509_NAME_get_entry_: subject _: index.
				self checkForNullReturn: entry from: 'X509_NAME_get_entry'.
				string := libCrypto X509_NAME_ENTRY_get_data_: entry.
				self checkForNullReturn: string from: 'X509_NAME_ENTRY_get_data'.
				name := libCrypto ASN1_STRING_get0_data_: string.
				values add: name].
	^values
%

category: 'initialization'
method: TlsActor
initialize

	libCrypto := LibCrypto new.
	libSsl := LibSsl new.
	libcFcntl := LibcFcntl new.
	^self
%

category: 'certificate info'
method: TlsActor
peerCertificate
	"This will only give expected results after a successful TLS handshake."

	| peer |
	peer := libSsl SSL_get1_peer_certificate_: ssl.
	self checkForNullReturn: peer from: 'SSL_get1_peer_certificate'.
	^peer
%

category: 'certificate info'
method: TlsActor
peerSubject
	"This will only give expected results after a successful TLS handshake is completed."

	| cert name |
	cert := self peerCertificate.
	name := libCrypto X509_get_subject_name_: cert.
	libCrypto X509_free_: cert . "Fix 49411"
	self checkForNullReturn: name from: 'X509_get_subject_name'.
	^name
%

category: 'read/write'
method: TlsActor
readLine
	"Reads one lf-terminated line, of no more than 255 characters, and returns the string *without* the terminating lf.
	It is expected that this line is all that is being sent in this TLS record, so if more characters are received beyond the lf,
	an error is signaled.
	We are currently using blocking sockets. This will get more complicated if we go to non-blocking.
	Also, this method may fail if renegotiation takes place during the read. This is improbable during the short
	interval of the initial login handshake, but should be coded for eventually."

	| maxSize res |
	maxSize := 255.
  res := tcpSocket _readLine: maxSize maxWaitMs: 500 .
  res ifNil:[
    self error: 'Socket failure during readLine' .
  ].
  (res codePointAt: res size ) == 10 ifFalse:[ 
    self error: 'Received line not lf-terminated: ', res .
  ].
  ^ res .
%

category: 'certificate info'
method: TlsActor
remoteIpOfFd: aFileDescriptor
	"Answer an IPv4 address as a ByteArray."

	| libcSocket addrInfo socklen retval family |
	libcSocket := LibcSocket new.
	addrInfo := StructSockaddrIn new.
	socklen := CByteArray gcMalloc: 4.
	socklen uint32At: 0 put: StructSockaddrIn byteSize.
	retval := libcSocket getpeername_: aFileDescriptor _: addrInfo _: socklen.
	retval = 0
		ifFalse: 
			[self error: 'Could not get peername for file descriptor '
						, aFileDescriptor printString].
	family := addrInfo sin_family.
	family = LibcSocket af_inet
		ifFalse: [self error: 'Socket is not IPv4. Only IPv4 is currently supported.'].
	^addrInfo address
%

category: 'certificate info'
method: TlsActor
remoteIpOfSsl: anSsl
	"Answer an IPv4 address as a ByteArray."

	| fd |
	fd := libSsl SSL_get_fd_: anSsl.
	"Strictly, a 0 return is valid, but we will not have a socket on stdin in this context."
	self checkReturn: fd from: 'SSL_get_fd'.
	^self remoteIpOfFd: fd
%

! Class implementation for 'HostAgentTlsActor'

!		Class methods for 'HostAgentTlsActor'

category: 'instance creation'
classmethod: HostAgentTlsActor
forSsl: anSsl
	"Return an instance initialized with the context from which anSsl was created.
	anSsl must be a CPointer to an SSL struct."

	^self new initializeFromSsl: anSsl
%

category: 'private-login'
classmethod: HostAgentTlsActor
makeSslWithCtx: aSslCtx fd: aFileDescriptor
  "Builds an ssl by calling SSL_new ; then calls SSL_set_fd.
   Returns a CPointer encapsulating an SSL* , or nil if malloc failed."

  <primitive: 1071>
  aSslCtx _validateInstanceOf: CPointer .
  aFileDescriptor _validateInstanceOf: SmallInteger .
  self _primitiveFailed: #makeSsl: args: { aSslCtx . aFileDescriptor }.
%

!		Instance methods for 'HostAgentTlsActor'

category: 'private-login'
method: HostAgentTlsActor
doTlsAccept: timeoutMs
	| errStr |
  ssl := self class makeSslWithCtx: sslCtx fd: tcpSocket id .
  ssl ifNil:[ self error: 'malloc failure in makeSslWithCtx' ].

  "establish auto-free of ssl on GC of tcpSocket, if we don't succeed in
   passing the ssl and file descriptor to a new pgsvr thread."
  tcpSocket _installSsl: ssl .  

  "use the primitive in GsSecureSocket."
  errStr := tcpSocket _secureAcceptTimeoutMs: timeoutMs .
  errStr == false ifTrue:[ errStr := 'SSL accept timeout' ].
  errStr _isOneByteString ifTrue:[ 
    LoginDeniedError signal: 'SSL accept failed, ', errStr
  ].
%

category: 'private-login'
method: HostAgentTlsActor
doTlsConnect: timeoutMs
	| errStr |
  ssl := self class makeSslWithCtx: sslCtx fd: tcpSocket id .
  ssl ifNil:[ self error: 'malloc failure in makeSslWithCtx' ].

  "establish auto-free of ssl on GC of tcpSocket, if we don't succeed in
   passing the ssl and file descriptor to a new pgsvr thread."
  tcpSocket _installSsl: ssl .  

  "use the primitive in GsSecureSocket."
  errStr := tcpSocket _secureConnectTimeoutMs: timeoutMs . 
  errStr == false ifTrue:[ errStr := 'SSL connect timeout' ].
  errStr _isOneByteString ifTrue:[ 
    LoginDeniedError signal: 'SSL connect failed, ', errStr
  ].
%

category: 'error handling'
method: HostAgentTlsActor
error: errorDescription
  | msg |
  msg := errorDescription asString copy .
  msg lf ; addAll: (GsProcess stackReportToLevel: 100) ; lf .
  logger log: msg level: #error .
	LoginDeniedError signal: errorDescription
%

category: 'initialization'
method: HostAgentTlsActor
initializeFromSsl: anSsl

	sslCtx := libSsl SSL_get_SSL_CTX_: anSsl.
	self checkForNullReturn: sslCtx from: 'SSL_get_SSL_CTX'
%

category: 'private'
method: HostAgentTlsActor
ipv4FromIpv6: aByteArray
	"Given a 16-byte array representing an IPv6 IPv4-mapped address, answer the 4-byte equivalent IPv4 address."

	(aByteArray copyFrom: 1 to: 12) = #[0 0 0 0 0 0 0 0 0 0 255 255]
		ifFalse: 
			[self error: 'Byte array ' , aByteArray printString
						, ' is not a valid IPv4-mapped address.'].
	^aByteArray copyFrom: 13 to: 16
%

category: 'accessing state'
method: HostAgentTlsActor
logger
	^logger
%

category: 'accessing state'
method: HostAgentTlsActor
logger: newValue
	logger := newValue
%

category: 'accessing state'
method: HostAgentTlsActor
peerCertificateTypes
	"Get the peer certificate and get the certificate types out of the cert."

	| subject oid |
	subject := self peerSubject.
	oid := libCrypto OBJ_txt2obj_: '1.3.6.1.4.1.47749.1.1' _: 1.
	self checkForNullReturn: oid from: 'OBJ_txt2obj'.
	^self getAllValuesOf: oid from: subject
%

category: 'accessing state'
method: HostAgentTlsActor
peerIpString

	^tcpSocket peerAddress
%

category: 'accessing state'
method: HostAgentTlsActor
peerStoneNames
	"Get the peer certificate and get the stone names out of the cert."

	| subject oid |
	subject := self peerSubject.
	oid := libCrypto OBJ_txt2obj_: '1.3.6.1.4.1.47749.1.3' _: 1.
	self checkForNullReturn: oid from: 'OBJ_txt2obj'.
	^self getAllValuesOf: oid from: subject
%

category: 'accessing state'
method: HostAgentTlsActor
peerSubnets
	"Get the peer certificate and get the subnet restrictions out of the cert."

	| subject oid |
	subject := self peerSubject.
	oid := libCrypto OBJ_txt2obj_: '1.3.6.1.4.1.47749.1.2' _: 1.
	self checkForNullReturn: oid from: 'OBJ_txt2obj'.
	^self getAllValuesOf: oid from: subject
%

category: 'accessing state'
method: HostAgentTlsActor
peerUserNames
	"Get the peer certificate and get the usernames out of the cert."

	| subject oid |
	subject := self peerSubject.
	oid := libCrypto OBJ_txt2obj_: '1.3.6.1.4.1.47749.1.4' _: 1.
	self checkForNullReturn: oid from: 'OBJ_txt2obj'.
	^self getAllValuesOf: oid from: subject
%

category: 'certificate info'
method: HostAgentTlsActor
remoteIpOfFd: aFileDescriptor
	"Answer an IPv4 address as a ByteArray.
	If the file descriptor is for an IPv6 connection, and has an IPv4-mapped address,
	answer the IPv4 equivalent. True IPv6 addresses are not yet supported."

	| addrClass libcSocket addrInfo socklen retval family |
	addrClass := StructSockaddrIn6.
	libcSocket := LibcSocket new.
	addrInfo := addrClass new.
	socklen := CByteArray gcMalloc: 4.
	socklen uint32At: 0 put: addrClass byteSize.
	retval := libcSocket getpeername_: aFileDescriptor _: addrInfo _: socklen.
	retval = 0
		ifFalse: 
			[self error: 'Could not get peername for file descriptor '
						, aFileDescriptor printString].
	family := addrInfo sin_family.
	family = LibcSocket af_inet
		ifTrue: 
			[addrInfo changeClassTo: StructSockaddrIn.
			^addrInfo address].
	family = LibcSocket af_inet6
		ifTrue: [^self ipv4FromIpv6: addrInfo address].
	self
		error: 'Socket is neither IPv4 nor IPv6. Family is ' , family printString
%

category: 'accessing state'
method: HostAgentTlsActor
ssl

	^ssl
%

category: 'accessing state'
method: HostAgentTlsActor
tcpSocket

	^ tcpSocket 
%

category: 'accessing state'
method: HostAgentTlsActor
tcpSocket: aGsSocket

	tcpSocket := aGsSocket
%

category: 'initialization'
method: HostAgentTlsActor
tlsMethod

	^libSsl TLS_server_method
%

! Class Initialization

run
LibcFcntl initialize.
LibCrypto initialize.
LibcSocket initialize.
LibSsl initialize.
true
%
