#!/bin/sh 
#! -*-  perl -*-
# try to find perl and reinvoke this script with it
eval 'if [ -x /opt/perl/bin/perl ]; then perl=/opt/perl/bin/perl; elif [ -x /usr/bin/perl ]; then perl=/usr/bin/perl; elif [ -x /usr/local/bin/perl ]; then perl=/usr/local/bin/perl; elif [ -x /bin/perl ]; then perl=/bin/perl; else exit 1; fi; exec $perl -x $0;'
  if 0; 
#=========================================================================
# Copyright (C) GemTalk Systems 1986-2024.  All Rights Reserved.
#
# Name - extents.pl
# 
# Purpose - parse a GemStone configuration file and print the extent names to
#           stdout (stripping quotes, NRS, etc.). Used by conversion scripts.
#           Not intended to be run stand-alone. Error handling (non-existent
#           or unreadable $GEMSTONE_SYS_CONF, etc.) is intentionally left to the
#           calling shell script.
# 
#=========================================================================

$GEMSTONE_SYS_CONF = $ENV{GEMSTONE_SYS_CONF};
# find out how many entries we're dealing with (only interested in the last):
open CONF, "$GEMSTONE_SYS_CONF" or die;
while (<CONF>) {
  next if /^#/;
  $numExtEntries++ if /DBF_EXTENT_NAMES.*=/;
}
close CONF;

# grab the last entry for DBF_EXTENT_NAMES:
$entryNum = 0;
open CONF, "$GEMSTONE_SYS_CONF" or die;
while (<CONF>) {
  next if /^#/;
  if (/DBF_EXTENT_NAMES.*=/) {
    $entryNum++;
    if ($entryNum == $numExtEntries) {
      $extentNames = $_;
      $extentNames =~ s/DBF_EXTENT_NAMES.*=//;
      # keep reading lines until we hit a semi-colon:
      until ($extentNames =~ /;/) { 
        $extentNames .= <CONF>;
      } 
      # we're done, exit while loop
      last;
    }
  }
}
close CONF;
@extents = split ',', $extentNames;
for $extent (@extents) {
  $extent =~ s/"//g;    # strip quotes
  $extent =~ s/!.*!//g; # strip NRS
  $extent =~ s/;//g;    # strip terminating semi-colon
  $extent =~ s/\s//g;   # strip whitespace (including newline)
}
print "@extents";
