expectvalue /String
run
| oldCls newCls |
oldCls := (System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #WordArray otherwise: nil.
oldCls == nil ifTrue: [
	Array subclass: 'WordArray'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := ((System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #'WordArray') .
	newCls category: 'Compression-Monticello-Streams'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods WordArray
removeallclassmethods WordArray

expectvalue /String
run
| oldCls newCls |
oldCls := (System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #ZipCrcTests otherwise: nil.
oldCls == nil ifTrue: [
	TestCase subclass: 'ZipCrcTests'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := ((System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #'ZipCrcTests') .
	newCls category: 'Tests-Compression'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods ZipCrcTests
removeallclassmethods ZipCrcTests

expectvalue /String
run
| oldCls newCls |
oldCls := (System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #ZipConstants otherwise: nil.
oldCls == nil ifTrue: [
	SharedPool subclass: 'ZipConstants'
	instVarNames: #(  )
	classVars: #( BaseDistance BaseLength BitLengthOrder DistanceCodes DynamicBlock EndBlock ExtraBitLengthBits ExtraDistanceBits ExtraLengthBits FixedBlock FixedDistanceTree FixedLiteralTree HashBits HashMask HashShift MatchLengthCodes MaxBitLengthBits MaxBitLengthCodes MaxBits MaxDistCodes MaxDistance MaxLengthCodes MaxLiteralCodes MaxMatch MinMatch NumLiterals Repeat11To138 Repeat3To10 Repeat3To6 StoredBlock WindowMask WindowSize )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	
	
	newCls := ((System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #'ZipConstants') .
	newCls category: 'Compression-Monticello-Streams'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods ZipConstants
removeallclassmethods ZipConstants

expectvalue /String
run
| oldCls newCls |
oldCls := (System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #DeflateStream otherwise: nil.
oldCls == nil ifTrue: [
	AnsiWriteStream subclass: 'DeflateStream'
	instVarNames: #( hashHead hashTail hashValue blockPosition blockStart )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: (WriteStream poolDictionariesForNames: #( 'ZipConstants' ))
	inDictionary: Gs_Package_Globals .
	newCls := ((System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #'DeflateStream') .
	newCls category: 'Compression-Monticello-Streams'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods DeflateStream
removeallclassmethods DeflateStream

expectvalue /String
run
| oldCls newCls |
oldCls := (System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #ZipWriteStream otherwise: nil.
oldCls == nil ifTrue: [
	DeflateStream subclass: 'ZipWriteStream'
	instVarNames: #( literals distances literalFreq distanceFreq litCount matchCount encoder crc crcPosition bytesWritten )
	classVars: #( CrcTable VerboseLevel )
	classInstVars: #(  )
	poolDictionaries: (DeflateStream poolDictionariesForNames: #( 'ZipConstants' ))
	inDictionary: Gs_Package_Globals .
	newCls := ((System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #'ZipWriteStream') .
	newCls category: 'Compression-Monticello-Streams'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods ZipWriteStream
removeallclassmethods ZipWriteStream

expectvalue /String
run
| oldCls newCls |
oldCls := (System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #ZipEncoder otherwise: nil.
oldCls == nil ifTrue: [
	AnsiWriteStream subclass: 'ZipEncoder'
	instVarNames: #( bitBuffer bitPosition encodedStream )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: (WriteStream poolDictionariesForNames: #( 'ZipConstants' ))
	inDictionary: Gs_Package_Globals .
	newCls := ((System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #'ZipEncoder') .
	newCls category: 'Compression-Monticello-Streams'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods ZipEncoder
removeallclassmethods ZipEncoder

expectvalue /String
run
| oldCls newCls |
oldCls := (System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #ZipWriteStream otherwise: nil.
oldCls == nil ifTrue: [
	DeflateStream subclass: 'ZipWriteStream'
	instVarNames: #( literals distances literalFreq distanceFreq litCount matchCount encoder crc crcPosition bytesWritten )
	classVars: #( CrcTable VerboseLevel )
	classInstVars: #(  )
	poolDictionaries: (DeflateStream poolDictionariesForNames: #( 'ZipConstants' ))
	inDictionary: Gs_Package_Globals .
	newCls := ((System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #'ZipWriteStream') .
	newCls category: 'Compression-Monticello-Streams'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods ZipWriteStream
removeallclassmethods ZipWriteStream

expectvalue /String
run
| oldCls newCls |
oldCls := (System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #ZipFileConstants otherwise: nil.
oldCls == nil ifTrue: [
	SharedPool subclass: 'ZipFileConstants'
	instVarNames: #(  )
	classVars: #( CentralDirectoryFileHeaderSignature CompressionDeflated CompressionLevelDefault CompressionLevelNone CompressionStored DataDescriptorLength DefaultDirectoryPermissions DefaultFilePermissions DeflatingCompressionFast DeflatingCompressionMaximum DeflatingCompressionNormal DeflatingCompressionSuperFast DirectoryAttrib EndOfCentralDirectorySignature FaMsdos FaUnix FileAttrib IfaBinaryFile IfaTextFile LocalFileHeaderSignature )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := ((System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #'ZipFileConstants') .
	newCls category: 'Compression-Monticello-Archives'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods ZipFileConstants
removeallclassmethods ZipFileConstants

expectvalue /String
run
| oldCls newCls |
oldCls := (System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #Archive otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'Archive'
	instVarNames: #( members )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := ((System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #'Archive') .
	newCls category: 'Compression-Monticello-Archives'.newCls classComment: 'This is the abstract superclass for file archives. Archives can be read from or written to files, and contain members that represent files and directories.' stamp: '<historical>'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods Archive
removeallclassmethods Archive

expectvalue /String
run
| oldCls newCls |
oldCls := (System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #ZipArchive otherwise: nil.
oldCls == nil ifTrue: [
	Archive subclass: 'ZipArchive'
	instVarNames: #( centralDirectorySize centralDirectoryOffsetWRTStartingDiskNumber zipFileComment writeCentralDirectoryOffset writeEOCDOffset )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: (Archive poolDictionariesForNames: #( 'ZipFileConstants' ))
	inDictionary: Gs_Package_Globals .
	newCls := ((System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #'ZipArchive') .
	newCls category: 'Compression-Monticello-Archives'.newCls classComment: 'A ZipArchive represents an archive that is read and/or written using the PKZIP file format.

ZipArchive instances know how to read and write such archives; their members are subinstances of ZipArchiveMember.' stamp: '<historical>'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods ZipArchive
removeallclassmethods ZipArchive

expectvalue /String
run
| oldCls newCls |
oldCls := (System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #ArchiveMember otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'ArchiveMember'
	instVarNames: #( fileName isCorrupt )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := ((System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #'ArchiveMember') .
	newCls category: 'Compression-Monticello-Archives'.newCls classComment: 'This is the abstract superclass for archive members, which are files or directories stored in archives.' stamp: '<historical>'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods ArchiveMember
removeallclassmethods ArchiveMember

expectvalue /String
run
| oldCls newCls |
oldCls := (System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #ZipArchiveMember otherwise: nil.
oldCls == nil ifTrue: [
	ArchiveMember subclass: 'ZipArchiveMember'
	instVarNames: #( lastModFileDateTime fileAttributeFormat versionMadeBy versionNeededToExtract bitFlag compressionMethod desiredCompressionMethod desiredCompressionLevel internalFileAttributes externalFileAttributes cdExtraField localExtraField fileComment crc32 compressedSize uncompressedSize writeLocalHeaderRelativeOffset readDataRemaining )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: (ArchiveMember poolDictionariesForNames: #( 'ZipFileConstants' ))
	inDictionary: Gs_Package_Globals .
	newCls := ((System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #'ZipArchiveMember') .
	newCls category: 'Compression-Monticello-Archives'.newCls classComment: 'Subinstances of me are members in a ZipArchive.
They represent different data sources:
	* ZipDirectoryMember -- a directory to be added to a zip file
	* ZipFileMember -- a file or directory that is already in a zip file
	* ZipNewFilemember -- a file that is to be added to a zip file
	* ZipStringMember -- a string that is to be added to a zip file

They can write their data to another stream either copying, compressing,
or decompressing as desired.' stamp: '<historical>'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods ZipArchiveMember
removeallclassmethods ZipArchiveMember

expectvalue /String
run
| oldCls newCls |
oldCls := (System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #ZipFileMember otherwise: nil.
oldCls == nil ifTrue: [
	ZipArchiveMember subclass: 'ZipFileMember'
	instVarNames: #( externalFileName stream localHeaderRelativeOffset dataOffset )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := ((System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #'ZipFileMember') .
	newCls category: 'Compression-Monticello-Archives'.newCls classComment: 'ZipNewFileMember instances are used to represent files that have been read from a ZipArchive.
Their data stays in the file on disk, so the original Zip file cannot be directly overwritten.' stamp: '<historical>'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods ZipFileMember
removeallclassmethods ZipFileMember

expectvalue /String
run
| oldCls newCls |
oldCls := (System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #ZipDirectoryMember otherwise: nil.
oldCls == nil ifTrue: [
	ZipFileMember subclass: 'ZipDirectoryMember'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := ((System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #'ZipDirectoryMember') .
	newCls category: 'Compression-Monticello-Archives'.newCls classComment: 'ZipFileMember instances represent directories inside ZipArchives.
They don''t do much other than hold names and permissions (and extra fields).

You can add files in subdirectories to a ZipArchive without using any ZipDirectoryMembers.' stamp: '<historical>'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods ZipDirectoryMember
removeallclassmethods ZipDirectoryMember

expectvalue /String
run
| oldCls newCls |
oldCls := (System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #ZipNewFileMember otherwise: nil.
oldCls == nil ifTrue: [
	ZipArchiveMember subclass: 'ZipNewFileMember'
	instVarNames: #( externalFileName stream )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := ((System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #'ZipNewFileMember') .
	newCls category: 'Compression-Monticello-Archives'.newCls classComment: 'ZipNewFileMember instances are used to represent files that are going to be written to a ZipArchive.
Their data comes from external file streams.' stamp: '<historical>'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods ZipNewFileMember
removeallclassmethods ZipNewFileMember

expectvalue /String
run
| oldCls newCls |
oldCls := (System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #ZipStringMember otherwise: nil.
oldCls == nil ifTrue: [
	ZipArchiveMember subclass: 'ZipStringMember'
	instVarNames: #( contents stream )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := ((System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #'ZipStringMember') .
	newCls category: 'Compression-Monticello-Archives'.newCls classComment: 'ZipStringMember instances are used to represent files that are going to be written to a ZipArchive.
Their data comes from in-image strings, though.' stamp: '<historical>'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods ZipStringMember
removeallclassmethods ZipStringMember

expectvalue /String
run
| oldCls newCls |
oldCls := (System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #ZipEncoderNode otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'ZipEncoderNode'
	instVarNames: #( value frequency height bitLength code parent left right )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := ((System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #'ZipEncoderNode') .
	newCls category: 'Compression-Monticello-Streams'.newCls classComment: 'ZipEncoderNode represents a node in a huffman tree for encoding ZipStreams.

Instance variables:
	value 		<Integer>	- Encoded value
	frequency	<Integer>	- Number of occurences of the encoded value
	height 		<Integer>	- Height of the node in the tree
	bitLength 	<Integer>	- bit length of the code
	code		<Integer>	- Assigned code for this node
	parent		<ZipEncoderNode>		- Parent of this node
	left			<ZipEncoderNode>		- First child of this node
	right		<ZipEncoderNode>		- Second child of this node
' stamp: '<historical>'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods ZipEncoderNode
removeallclassmethods ZipEncoderNode

expectvalue /String
run
| oldCls newCls |
oldCls := (System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #ZipEncoderTree otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'ZipEncoderTree'
	instVarNames: #( bitLengths codes maxCode )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := ((System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #'ZipEncoderTree') .
	newCls category: 'Compression-Monticello-Streams'.newCls classComment: 'ZipEncoderTree represents a huffman tree for encoding ZipStreams.

Instance variables:
	bitLengths	<WordArray>	 - Bit lengths of each generated code
	codes		<WordArray>	 - Codes for each value
	maxCode		<Integer>	- Maximum value with non-zero frequency' stamp: '<historical>'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods ZipEncoderTree
removeallclassmethods ZipEncoderTree

expectvalue /String
run
| oldCls newCls |
oldCls := (System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #InflateStream otherwise: nil.
oldCls == nil ifTrue: [
	AnsiReadStream subclass: 'InflateStream'
	instVarNames: #( readLimit state bitBuf bitPos source sourcePos sourceLimit litTable distTable sourceStream crc )
	classVars: #( BlockProceedBit BlockTypes FixedDistCodes FixedLitCodes MaxBits StateNewBlock StateNoMoreData )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := ((System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #'InflateStream') .
	newCls category: 'Compression-Monticello-Streams'.newCls classComment: 'This class implements the Inflate decompression algorithm as defined by RFC1951 and used in PKZip, GZip and ZLib (and many, many more). It is a variant of the LZ77 compression algorithm described in

[LZ77] Ziv J., Lempel A., "A Universal Algorithm for Sequential Data Compression", IEEE Transactions on Information Theory, Vol. 23, No. 3, pp. 337-343.

[RFC1951] Deutsch. P, "DEFLATE Compressed Data Format Specification version 1.3"

For more information see the above mentioned RFC 1951 which can for instance be found at

	http://www.leo.org/pub/comp/doc/standards/rfc/index.html

Huffman Tree Implementation Notes:
===========================================
The huffman tree used for decoding literal, distance and length codes in the inflate algorithm has been encoded in a single Array. The tree is made up of subsequent tables storing all entries at the current bit depth. Each entry in the table (e.g., a 32bit Integer value) is either a leaf or a non-leaf node. Leaf nodes store the immediate value in its low 16 bits whereas non-leaf nodes store the offset of the subtable in its low 16bits. The high 8 bits of non-leaf nodes contain the number of additional bits needed for the sub table (the high 8 bits of leaf-nodes are always zero). The first entry in each table is always a non-leaf node indicating how many bits we need to fetch initially. We can thus travel down the tree as follows (written in sort-of-pseudocode the actual implementation can be seen in InflateStream>>decodeValueFrom:):

	table := initialTable.
	bitsNeeded := high 8 bits of (table at: 1).		"Determine initial bits"
	table := initialTable + (low 16 bits of (table at: 1)). "Determine start of first real table"
	[bits := fetch next bitsNeeded bits.			"Grab the bits"
	value := table at: bits.						"Lookup the value"
	value has high 8 bit set] whileTrue:[		"Check if it''s leaf"
		table := initialTable + (low 16 bits of value).	"No - compute new sub table start"
		bitsNeeded := high 8 bit of value].		"Compute additional number of bits needed"
	^value
' stamp: '<historical>'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods InflateStream
removeallclassmethods InflateStream

expectvalue /String
run
| oldCls newCls |
oldCls := (System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #FastInflateStream otherwise: nil.
oldCls == nil ifTrue: [
	InflateStream subclass: 'FastInflateStream'
	instVarNames: #(  )
	classVars: #( DistanceMap FixedDistTable FixedLitTable LiteralLengthMap )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := ((System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #'FastInflateStream') .
	newCls category: 'Compression-Monticello-Streams'.newCls classComment: 'This class adds the following optimizations to the basic Inflate decompression:

a) Bit reversed access
If we want to fetch the bits efficiently then we have them in the wrong bit order (e.g., when we should fetch 2r100 we would get 2r001). But since the huffman tree lookup determines the efficiency of the decompression, reversing the bits before traversal is expensive. Therefore the entries in each table are stored in REVERSE BIT ORDER. This is achieved by a reverse increment of the current table index in the huffman table construction phase (see method increment:bits:). According to my measures this speeds up the implementation by about 30-40%.

b) Inplace storage of code meanings and extra bits
Rather than looking up the meaning for each code during decompression of blocks we store the appropriate values directly in the huffman tables, using a pre-defined mapping. Even though this does not make a big difference in speed, it cleans up the code and allows easier translation into primitive code (which is clearly one goal of this implementation).

c) Precomputed huffman tables for fixed blocks
So we don''t have to compute the huffman tables from scratch. The precomputed tables are not in our superclass to avoid double storage (and my superclass is more intended for documentation anyways).' stamp: '<historical>'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods FastInflateStream
removeallclassmethods FastInflateStream

expectvalue /String
run
| oldCls newCls |
oldCls := (System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #ZipReadStream otherwise: nil.
oldCls == nil ifTrue: [
	FastInflateStream subclass: 'ZipReadStream'
	instVarNames: #( expectedCrc )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := ((System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #'ZipReadStream') .
	newCls category: 'Compression-Monticello-Streams'.newCls classComment: 'ZipReadStream is intended for uncompressing the compressed contents of Zip archive members.

Since Zip archive members keep their expected CRC value separately in Zip headers, this class does not attempt to read the CRC from its input stream.

Instead, if you want the CRC verification to work you have to call #expectedCrc: with the expected CRC-32 value from the Zip member header.' stamp: 'nk 3/7/2004 18:54'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods ZipReadStream
removeallclassmethods ZipReadStream

expectvalue /String
run
| oldCls newCls |
oldCls := (System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #CRCError otherwise: nil.
oldCls == nil ifTrue: [
	Error subclass: 'CRCError'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := ((System myUserProfile symbolList objectNamed: #'Gs_Package_Globals') at: #'CRCError') .
	newCls category: 'Compression-Monticello-Streams'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods CRCError
removeallclassmethods CRCError


category: 'tests'
method: ZipCrcTests
testInvalidZipCrc
	"See that a wrong CRC raises an appropriate error"
	| reader writer bytes |
	writer := ZipWriteStream on: String new.
	writer nextPutAll: 'Hello World'.
	writer close.

	bytes := writer encodedStream contents.

	reader := ZipReadStream on: bytes.
	reader expectedCrc: writer crc - 1.
	self should:[reader upToEnd] raise: CRCError.

	reader := ZipReadStream on: bytes.
	reader expectedCrc: writer crc - 1.
	self should:[reader contents] raise: CRCError.

	reader := ZipReadStream on: bytes.
	reader expectedCrc: writer crc - 1.
	self should:[reader next: 100] raise: CRCError.

%
run
ZipCrcTests setStamp: 'nk 3/7/2004 18:37' forMethod: #testInvalidZipCrc.
true
%

category: 'tests'
method: ZipCrcTests
testMissingZipCrc
	"See that the lack of a CRC does not raise an error"
	| reader writer bytes readBytes |
	writer := ZipWriteStream on: String new.
	writer nextPutAll: 'Hello World'.
	writer close.

	bytes := writer encodedStream contents.

	reader := ZipReadStream on: bytes.
	self shouldnt:[readBytes := reader upToEnd] raise: CRCError.
	self assert: readBytes = 'Hello World'.

	reader := ZipReadStream on: bytes.
	self shouldnt:[reader contents] raise: CRCError.

	reader := ZipReadStream on: bytes.
	self shouldnt:[reader next: 100] raise: CRCError.

%
run
ZipCrcTests setStamp: 'nk 3/7/2004 18:49' forMethod: #testMissingZipCrc.
true
%

category: 'tests'
method: ZipCrcTests
testValidZipCrc
	"See that a correct CRC does not raise an error and that we can read what we wrote."
	| reader writer bytes readBytes |
	writer := ZipWriteStream on: String new.
	writer nextPutAll: 'Hello World'.
	writer close.

	bytes := writer encodedStream contents.

	reader := ZipReadStream on: bytes.
	reader expectedCrc: writer crc.
	self shouldnt:[ readBytes := reader upToEnd] raise: CRCError.
	self assert: readBytes = 'Hello World'.

	reader := ZipReadStream on: bytes.
	reader expectedCrc: writer crc.
	self shouldnt:[ readBytes := reader contents] raise: CRCError.
	self assert: readBytes = 'Hello World'.

	reader := ZipReadStream on: bytes.
	reader expectedCrc: writer crc.
	self shouldnt:[ readBytes := reader next: 11 ] raise: CRCError.
	self assert: readBytes = 'Hello World'.
	
	reader := ZipReadStream on: bytes.
	reader expectedCrc: writer crc.
	self shouldnt:[ readBytes := reader next: 100 ] raise: CRCError.
	self assert: readBytes = 'Hello World'.
%
run
ZipCrcTests setStamp: 'nk 3/7/2004 18:43' forMethod: #testValidZipCrc.
true
%

category: 'deflating'
method: DeflateStream
compare: here with: matchPos min: minLength
	"Compare the two strings and return the length of matching characters.
	minLength is a lower bound for match lengths that will be accepted.
	Note: here and matchPos are zero based."
	| length |
	"First test if we can actually get longer than minLength"
	(self _collection at: here+minLength+1) = (self _collection at: matchPos+minLength+1)
		ifFalse:[^0].
	(self _collection at: here+minLength) = (self _collection at: matchPos+minLength)
		ifFalse:[^0].
	"Then test if we have an initial match at all"
	(self _collection at: here+1) = (self _collection at: matchPos+1)
		ifFalse:[^0].
	(self _collection at: here+2) = (self _collection at: matchPos+2)
		ifFalse:[^1].
	"Finally do the real comparison"
	length := 3.
	[length <= MaxMatch and:[
		(self _collection at: here+length) = (self _collection at: matchPos+length)]]
			whileTrue:[length := length + 1].
	^length - 1
%
run
DeflateStream setStamp: 'DaleHenrichs 10/11/2010 14:59' forMethod: #compare:with:min:.
true
%

category: 'deflating'
method: DeflateStream
deflateBlock
	"Deflate the current contents of the stream"
	| flushNeeded lastIndex |
	(blockStart == nil) ifTrue:[
		"One time initialization for the first block"
		1 to: MinMatch-1 do:[:i| self updateHashAt: i].
		blockStart := 0].

	[blockPosition < self position] whileTrue:[
		(self position + MaxMatch > self _writeLimit)
			ifTrue:[lastIndex := self _writeLimit - MaxMatch]
			ifFalse:[lastIndex := self position].
		flushNeeded := self deflateBlock: lastIndex-1
							chainLength: self hashChainLength
							goodMatch: self goodMatchLength.
		flushNeeded ifTrue:[
			self flushBlock.
			blockStart := blockPosition].
		"Make room for more data"
		self moveContentsToFront].

%
run
DeflateStream setStamp: 'DaleHenrichs 10/11/2010 15:05' forMethod: #deflateBlock.
true
%

category: 'deflating'
method: DeflateStream
deflateBlock: lastIndex chainLength: chainLength goodMatch: goodMatch
	"Continue deflating the receiver's collection from blockPosition to lastIndex.
	Note that lastIndex must be at least MaxMatch away from the end of collection"
	| here matchResult flushNeeded hereMatch hereLength newMatch newLength hasMatch |
	blockPosition > lastIndex ifTrue:[^false]. "Nothing to deflate"
	hasMatch := false.
	here := blockPosition.
	[here <= lastIndex] whileTrue:[
		hasMatch ifFalse:[
			"Find the first match"
			matchResult := self findMatch: here
								lastLength: MinMatch-1
								lastMatch: here
								chainLength: chainLength
								goodMatch: goodMatch.
			self insertStringAt: here. "update hash table"
			hereMatch := matchResult bitAnd: 16rFFFF.
			hereLength := matchResult bitShift: -16].

		"Look ahead if there is a better match at the next position"
		matchResult := self findMatch: here+1
							lastLength: hereLength
							lastMatch: hereMatch
							chainLength: chainLength
							goodMatch: goodMatch.
		newMatch := matchResult bitAnd: 16rFFFF.
		newLength := matchResult bitShift: -16.

		"Now check if the next match is better than the current one.
		If not, output the current match (provided that the current match
		is at least MinMatch long)"
		(hereLength >= newLength and:[hereLength >= MinMatch]) ifTrue:[
			(self validateMatchAt: here
							from: hereMatch to: hereMatch + hereLength - 1) ifFalse: [ self error: 'Failed assertion' ].
			"Encode the current match"
			flushNeeded := self
				encodeMatch: hereLength
				distance: here - hereMatch.
			"Insert all strings up to the end of the current match.
			Note: The first string has already been inserted."
			1 to: hereLength-1 do:[:i| self insertStringAt: (here := here + 1)].
			hasMatch := false.
			here := here + 1.
		] ifFalse:[
			"Either the next match is better than the current one or we didn't
			have a good match after all (e.g., current match length < MinMatch).
			Output a single literal."
			flushNeeded := self encodeLiteral: (self _collection byteAt: (here + 1)).
			here := here + 1.
			(here <= lastIndex and:[flushNeeded not]) ifTrue:[
				"Cache the results for the next round"
				self insertStringAt: here.
				hasMatch := true.
				hereMatch := newMatch.
				hereLength := newLength].
		].
		flushNeeded ifTrue:[blockPosition := here. ^true].
	].
	blockPosition := here.
	^false
%
run
DeflateStream setStamp: 'DaleHenrichs 10/11/2010 14:58' forMethod: #deflateBlock:chainLength:goodMatch:.
true
%

category: 'encoding'
method: DeflateStream
encodeLiteral: literal
	"Encode the given literal.
	Return true if the current block needs to be flushed."
	^false
%
run
DeflateStream setStamp: 'ar 12/29/1999 18:04' forMethod: #encodeLiteral:.
true
%

category: 'encoding'
method: DeflateStream
encodeMatch: matchLength distance: matchDistance
	"Encode a match of the given length and distance.
	Return true if the current block should be flushed."
	^false
%
run
DeflateStream setStamp: 'ar 12/29/1999 18:04' forMethod: #encodeMatch:distance:.
true
%

category: 'deflating'
method: DeflateStream
findMatch: here lastLength: lastLength lastMatch: lastMatch chainLength: maxChainLength goodMatch: goodMatch
	"Find the longest match for the string starting at here.
	If there is no match longer than lastLength return lastMatch/lastLength.
	Traverse at most maxChainLength entries in the hash table.
	Stop if a match of at least goodMatch size has been found."
	| matchResult matchPos distance chainLength limit bestLength length |
	"Compute the default match result"
	matchResult := (lastLength bitShift: 16) bitOr: lastMatch.

	"There is no way to find a better match than MaxMatch"
	lastLength >= MaxMatch ifTrue:[^matchResult].

	"Start position for searches"
	matchPos := hashHead at: (self updateHashAt: here + MinMatch) + 1.

	"Compute the distance to the (possible) match"
	distance := here - matchPos.

	"Note: It is required that 0 < distance < MaxDistance"
	(distance > 0 and:[distance < MaxDistance]) ifFalse:[^matchResult].

	chainLength := maxChainLength.	"Max. nr of match chain to search"
	here > MaxDistance	"Limit for matches that are too old"
		ifTrue:[limit := here - MaxDistance]
		ifFalse:[limit := 0].

	"Best match length so far (current match must be larger to take effect)"
	bestLength := lastLength.

	["Compare the current string with the string at match position"
	length := self compare: here with: matchPos min: bestLength.
	"Truncate accidental matches beyound stream position"
	(here + length > self position) ifTrue:[length := self position - here].
	"Ignore very small matches if they are too far away"
	(length = MinMatch and:[(here - matchPos) > (MaxDistance // 4)])
		ifTrue:[length := MinMatch - 1].
	length > bestLength ifTrue:["We have a new (better) match than before"
		"Compute the new match result"
		matchResult := (length bitShift: 16) bitOr: matchPos.
		bestLength := length.
		"There is no way to find a better match than MaxMatch"
		bestLength >= MaxMatch ifTrue:[^matchResult].
		"But we may have a good, fast match"
		bestLength > goodMatch ifTrue:[^matchResult].
	].
	(chainLength := chainLength - 1) > 0] whileTrue:[
		"Compare with previous entry in hash chain"
		matchPos := hashTail at: (matchPos bitAnd: WindowMask) + 1.
		matchPos <= limit ifTrue:[^matchResult]. "Match position is too old"
	].
	^matchResult
%
run
DeflateStream setStamp: 'DaleHenrichs 10/11/2010 15:02' forMethod: #findMatch:lastLength:lastMatch:chainLength:goodMatch:.
true
%

category: 'initialization'
method: DeflateStream
flush
	"Force compression"
	self deflateBlock.
%
run
DeflateStream setStamp: 'ar 12/29/1999 17:30' forMethod: #flush.
true
%

category: 'deflating'
method: DeflateStream
flushBlock
	"Flush a deflated block"
%
run
DeflateStream setStamp: 'ar 12/28/1999 17:37' forMethod: #flushBlock.
true
%

category: 'accessing'
method: DeflateStream
goodMatchLength
	"Return the length that is considered to be a 'good' match.
	Higher values will result in better compression but take more time."
	^MaxMatch "Best compression"
%
run
DeflateStream setStamp: 'ar 12/29/1999 20:00' forMethod: #goodMatchLength.
true
%

category: 'accessing'
method: DeflateStream
hashChainLength
	"Return the max. number of hash chains to traverse.
	Higher values will result in better compression but take more time."
	^4096 "Best compression"
%
run
DeflateStream setStamp: 'ar 12/29/1999 20:00' forMethod: #hashChainLength.
true
%

category: 'initialization'
method: DeflateStream
initialize
	blockStart := nil.
	blockPosition := 0.
	hashValue := 0.
	self initializeHashTables.
%
run
DeflateStream setStamp: 'alain.plantec 5/28/2009 09:51' forMethod: #initialize.
true
%

category: 'initialization'
method: DeflateStream
initializeHashTables
	hashHead := WordArray new: (1 bitShift: HashBits).
	hashTail := WordArray new: WindowSize.

%
run
DeflateStream setStamp: 'ar 12/29/1999 17:32' forMethod: #initializeHashTables.
true
%

category: 'deflating'
method: DeflateStream
insertStringAt: here
	"Insert the string at the given start position into the hash table.
	Note: The hash value is updated starting at MinMatch-1 since
	all strings before have already been inserted into the hash table
	(and the hash value is updated as well)."
	| prevEntry |
	hashValue := self updateHashAt: (here + MinMatch).
	prevEntry := hashHead at: hashValue+1.
	hashHead at: hashValue+1 put: here.
	hashTail at: (here bitAnd: WindowMask)+1 put: prevEntry.
%
run
DeflateStream setStamp: 'ar 12/29/1999 17:46' forMethod: #insertStringAt:.
true
%

category: 'private'
method: DeflateStream
moveContentsToFront
	"Move the contents of the receiver to the front"
	| delta |
	delta := (blockPosition - WindowSize).
	delta <= 0 ifTrue:[^self].
	"Move collection"
	self _collection 
		squeakReplaceFrom: 1 
		to: self _collection size - delta 
		with: self _collection 
		startingAt: delta+1.
	self _position: self position - delta.
	"Move hash table entries"
	blockPosition := blockPosition - delta.
	blockStart := blockStart - delta.
	self updateHashTable: hashHead delta: delta.
	self updateHashTable: hashTail delta: delta.
%
run
DeflateStream setStamp: 'DaleHenrichs 10/11/2010 15:31' forMethod: #moveContentsToFront.
true
%

category: 'accessing'
method: DeflateStream
next: bytes putAll: aCollection startingAt: startPos
	(startPos = 1 and:[bytes = aCollection size]) 
		ifTrue:[^self nextPutAll: aCollection].
	^self nextPutAll: (aCollection copyFrom: startPos to: startPos + bytes - 1)
%
run
DeflateStream setStamp: 'ar 2/19/2004 00:34' forMethod: #next:putAll:startingAt:.
true
%

category: 'accessing'
method: DeflateStream
nextPutAll: aCollection
	| start count max |
	aCollection species = self _collection species
		ifFalse:[
			aCollection do:[:ch| self nextPut: ch].
			^aCollection].
	start := 1.
	count := aCollection size.
	[count = 0] whileFalse:[
		self position = self _writeLimit ifTrue:[self deflateBlock].
		max := self _writeLimit - self position.
		max > count ifTrue:[max := count].
		self _collection replaceFrom: self position+1
			to: self position+max
			with: aCollection
			startingAt: start.
		start := start + max.
		count := count - max.
		self _position: self position + max].
	^aCollection
%
run
DeflateStream setStamp: 'DaleHenrichs 10/11/2010 15:29' forMethod: #nextPutAll:.
true
%

category: 'initialization'
method: DeflateStream
on: aCollection
	self initialize.
	super on: (aCollection species new: WindowSize * 2).
%
run
DeflateStream setStamp: 'ar 12/29/1999 17:33' forMethod: #on:.
true
%

category: 'initialization'
method: DeflateStream
on: aCollection from: firstIndex to: lastIndex
	"Not for DeflateStreams please"
	^self shouldNotImplement
%
run
DeflateStream setStamp: 'ar 12/28/1999 17:34' forMethod: #on:from:to:.
true
%

category: 'deflating'
method: DeflateStream
updateHash: nextValue
	"Update the running hash value based on the next input byte.
	Return the new updated hash value."
	^((hashValue bitShift: HashShift) bitXor: nextValue) bitAnd: HashMask.
%
run
DeflateStream setStamp: 'ar 12/29/1999 17:48' forMethod: #updateHash:.
true
%

category: 'deflating'
method: DeflateStream
updateHashAt: here
	"Update the hash value at position here (one based)"
	^self updateHash: (self _collection byteAt: here)
%
run
DeflateStream setStamp: 'DaleHenrichs 10/11/2010 14:57' forMethod: #updateHashAt:.
true
%

category: 'private'
method: DeflateStream
updateHashTable: table delta: delta
	| pos |
	1 to: table size do:[:i|
		"Discard entries that are out of range"
		(pos := table at: i) >= delta
			ifTrue:[table at: i put: pos - delta]
			ifFalse:[table at: i put: 0]].
%
run
DeflateStream setStamp: 'ar 2/2/2001 15:47' forMethod: #updateHashTable:delta:.
true
%

category: 'deflating'
method: DeflateStream
validateMatchAt: pos from: startPos to: endPos
	| here |
	here := pos.
	startPos+1 to: endPos+1 do:[:i|
		(self _collection at: i) = (self _collection at: (here := here + 1))
			ifFalse:[^self error:'Not a match']].
	^true
%
run
DeflateStream setStamp: 'DaleHenrichs 10/11/2010 14:57' forMethod: #validateMatchAt:from:to:.
true
%

category: 'accessing'
classmethod: ZipWriteStream
baseDistance
	^BaseDistance
%
run
ZipWriteStream class setStamp: 'ar 12/30/1999 15:55' forMethod: #baseDistance.
true
%

category: 'accessing'
classmethod: ZipWriteStream
baseLength
	^BaseLength
%
run
ZipWriteStream class setStamp: 'ar 12/30/1999 15:55' forMethod: #baseLength.
true
%

category: 'accessing'
classmethod: ZipWriteStream
crcTable
	^CrcTable
%
run
ZipWriteStream class setStamp: 'ar 2/24/2001 19:42' forMethod: #crcTable.
true
%

category: 'accessing'
classmethod: ZipWriteStream
distanceCodes
	^DistanceCodes
%
run
ZipWriteStream class setStamp: 'ar 12/29/1999 20:42' forMethod: #distanceCodes.
true
%

category: 'accessing'
classmethod: ZipWriteStream
extraDistanceBits
	^ExtraDistanceBits
%
run
ZipWriteStream class setStamp: 'ar 12/30/1999 15:55' forMethod: #extraDistanceBits.
true
%

category: 'accessing'
classmethod: ZipWriteStream
extraLengthBits
	^ExtraLengthBits
%
run
ZipWriteStream class setStamp: 'ar 12/30/1999 15:55' forMethod: #extraLengthBits.
true
%

category: 'initialization'
classmethod: ZipWriteStream
initialize
	"ZipWriteStream initialize"
	VerboseLevel := 0.
	self initializeCrcTable.
%
run
ZipWriteStream class setStamp: 'ar 5/18/2003 19:10' forMethod: #initialize.
true
%

category: 'initialization'
classmethod: ZipWriteStream
initializeCrcTable
	"ZipWriteStream initialize"
	CrcTable := #(16r00000000 16r77073096 16rEE0E612C 16r990951BA 16r076DC419
  16r706AF48F 16rE963A535 16r9E6495A3 16r0EDB8832 16r79DCB8A4
  16rE0D5E91E 16r97D2D988 16r09B64C2B 16r7EB17CBD 16rE7B82D07
  16r90BF1D91 16r1DB71064 16r6AB020F2 16rF3B97148 16r84BE41DE
  16r1ADAD47D 16r6DDDE4EB 16rF4D4B551 16r83D385C7 16r136C9856
  16r646BA8C0 16rFD62F97A 16r8A65C9EC 16r14015C4F 16r63066CD9
  16rFA0F3D63 16r8D080DF5 16r3B6E20C8 16r4C69105E 16rD56041E4
  16rA2677172 16r3C03E4D1 16r4B04D447 16rD20D85FD 16rA50AB56B
  16r35B5A8FA 16r42B2986C 16rDBBBC9D6 16rACBCF940 16r32D86CE3
  16r45DF5C75 16rDCD60DCF 16rABD13D59 16r26D930AC 16r51DE003A
  16rC8D75180 16rBFD06116 16r21B4F4B5 16r56B3C423 16rCFBA9599
  16rB8BDA50F 16r2802B89E 16r5F058808 16rC60CD9B2 16rB10BE924
  16r2F6F7C87 16r58684C11 16rC1611DAB 16rB6662D3D 16r76DC4190
  16r01DB7106 16r98D220BC 16rEFD5102A 16r71B18589 16r06B6B51F
  16r9FBFE4A5 16rE8B8D433 16r7807C9A2 16r0F00F934 16r9609A88E
  16rE10E9818 16r7F6A0DBB 16r086D3D2D 16r91646C97 16rE6635C01
  16r6B6B51F4 16r1C6C6162 16r856530D8 16rF262004E 16r6C0695ED
  16r1B01A57B 16r8208F4C1 16rF50FC457 16r65B0D9C6 16r12B7E950
  16r8BBEB8EA 16rFCB9887C 16r62DD1DDF 16r15DA2D49 16r8CD37CF3
  16rFBD44C65 16r4DB26158 16r3AB551CE 16rA3BC0074 16rD4BB30E2
  16r4ADFA541 16r3DD895D7 16rA4D1C46D 16rD3D6F4FB 16r4369E96A
  16r346ED9FC 16rAD678846 16rDA60B8D0 16r44042D73 16r33031DE5
  16rAA0A4C5F 16rDD0D7CC9 16r5005713C 16r270241AA 16rBE0B1010
  16rC90C2086 16r5768B525 16r206F85B3 16rB966D409 16rCE61E49F
  16r5EDEF90E 16r29D9C998 16rB0D09822 16rC7D7A8B4 16r59B33D17
  16r2EB40D81 16rB7BD5C3B 16rC0BA6CAD 16rEDB88320 16r9ABFB3B6
  16r03B6E20C 16r74B1D29A 16rEAD54739 16r9DD277AF 16r04DB2615
  16r73DC1683 16rE3630B12 16r94643B84 16r0D6D6A3E 16r7A6A5AA8
  16rE40ECF0B 16r9309FF9D 16r0A00AE27 16r7D079EB1 16rF00F9344
  16r8708A3D2 16r1E01F268 16r6906C2FE 16rF762575D 16r806567CB
  16r196C3671 16r6E6B06E7 16rFED41B76 16r89D32BE0 16r10DA7A5A
  16r67DD4ACC 16rF9B9DF6F 16r8EBEEFF9 16r17B7BE43 16r60B08ED5
  16rD6D6A3E8 16rA1D1937E 16r38D8C2C4 16r4FDFF252 16rD1BB67F1
  16rA6BC5767 16r3FB506DD 16r48B2364B 16rD80D2BDA 16rAF0A1B4C
  16r36034AF6 16r41047A60 16rDF60EFC3 16rA867DF55 16r316E8EEF
  16r4669BE79 16rCB61B38C 16rBC66831A 16r256FD2A0 16r5268E236
  16rCC0C7795 16rBB0B4703 16r220216B9 16r5505262F 16rC5BA3BBE
  16rB2BD0B28 16r2BB45A92 16r5CB36A04 16rC2D7FFA7 16rB5D0CF31
  16r2CD99E8B 16r5BDEAE1D 16r9B64C2B0 16rEC63F226 16r756AA39C
  16r026D930A 16r9C0906A9 16rEB0E363F 16r72076785 16r05005713
  16r95BF4A82 16rE2B87A14 16r7BB12BAE 16r0CB61B38 16r92D28E9B
  16rE5D5BE0D 16r7CDCEFB7 16r0BDBDF21 16r86D3D2D4 16rF1D4E242
  16r68DDB3F8 16r1FDA836E 16r81BE16CD 16rF6B9265B 16r6FB077E1
  16r18B74777 16r88085AE6 16rFF0F6A70 16r66063BCA 16r11010B5C
  16r8F659EFF 16rF862AE69 16r616BFFD3 16r166CCF45 16rA00AE278
  16rD70DD2EE 16r4E048354 16r3903B3C2 16rA7672661 16rD06016F7
  16r4969474D 16r3E6E77DB 16rAED16A4A 16rD9D65ADC 16r40DF0B66
  16r37D83BF0 16rA9BCAE53 16rDEBB9EC5 16r47B2CF7F 16r30B5FFE9
  16rBDBDF21C 16rCABAC28A 16r53B39330 16r24B4A3A6 16rBAD03605
  16rCDD70693 16r54DE5729 16r23D967BF 16rB3667A2E 16rC4614AB8
  16r5D681B02 16r2A6F2B94 16rB40BBE37 16rC30C8EA1 16r5A05DF1B
  16r2D02EF8D
).
%
run
ZipWriteStream class setStamp: 'ar 2/24/2001 19:42' forMethod: #initializeCrcTable.
true
%

category: 'accessing'
classmethod: ZipWriteStream
matchLengthCodes
	^MatchLengthCodes
%
run
ZipWriteStream class setStamp: 'ar 12/29/1999 20:42' forMethod: #matchLengthCodes.
true
%

category: 'accessing'
classmethod: ZipWriteStream
maxDistanceCodes
	^MaxDistCodes
%
run
ZipWriteStream class setStamp: 'ar 12/29/1999 20:53' forMethod: #maxDistanceCodes.
true
%

category: 'accessing'
classmethod: ZipWriteStream
maxLiteralCodes
	^MaxLiteralCodes
%
run
ZipWriteStream class setStamp: 'ar 12/29/1999 20:53' forMethod: #maxLiteralCodes.
true
%

category: 'crc'
classmethod: ZipWriteStream
updateCrc: oldCrc from: start to: stop in: aCollection
	| newCrc |
	newCrc := oldCrc.
	start to: stop do:[:i|
		newCrc := (CrcTable at: ((newCrc bitXor: (aCollection byteAt: i)) 
				bitAnd: 255) + 1) bitXor: (newCrc bitShift: -8).
	].
	^newCrc
%
run
ZipWriteStream class setStamp: 'nk 2/17/2004 16:50' forMethod: #updateCrc:from:to:in:.
true
%

category: 'initialization'
method: ZipWriteStream
close
	self deflateBlock.
	self flushBlock: true.
	encoder close.
%
run
ZipWriteStream setStamp: 'ar 2/28/2001 13:39' forMethod: #close.
true
%

category: 'accessing'
method: ZipWriteStream
crc
	^crc
%
run
ZipWriteStream setStamp: 'ar 2/24/2001 19:46' forMethod: #crc.
true
%

category: 'deflating'
method: ZipWriteStream
deflateBlock: lastIndex chainLength: chainLength goodMatch: goodMatch
	"^DeflatePlugin doPrimitive:#primitiveDeflateBlock"
	^super deflateBlock: lastIndex chainLength: chainLength goodMatch: goodMatch
%
run
ZipWriteStream setStamp: 'ar 2/2/2001 15:47' forMethod: #deflateBlock:chainLength:goodMatch:.
true
%

category: 'dynamic blocks'
method: ZipWriteStream
dynamicBlockSizeFor: lTree and: dTree using: blTree and: blFreq
	"Compute the length for the current block using dynamic huffman trees"
	| bits index extra treeBits freq |
	bits := 3 "block type" + 5 "literal codes length" + 5 "distance codes length".

	"Compute the # of bits for sending the bit length tree"
	treeBits := 4. "Max index for bit length tree"
	index := MaxBitLengthCodes.
	[index >= 4] whileTrue:[
		(index = 4 or:[(blFreq at: (BitLengthOrder at: index)+1) > 0])
			ifTrue:[treeBits := treeBits + (index * 3).
					index := -1]
			ifFalse:[index := index - 1]].

	"Compute the # of bits for sending the literal/distance tree.
	Note: The frequency are already stored in the blTree"
	0 to: 15 do:[:i| "First, the non-repeating values"
		freq := blFreq at: i+1.
		freq > 0 ifTrue:[treeBits := treeBits + (freq * (blTree bitLengthAt: i))]].
	"Now the repeating values"
	(Repeat3To6 to: Repeat11To138) with: #(2 3 7) do:[:i :addl|
		freq := blFreq at: i+1.
		freq > 0 ifTrue:[
			treeBits := treeBits + (freq * ((blTree bitLengthAt: i) + addl "addl bits"))]].
	VerboseLevel > 1 ifTrue:[
		"Transcript show:'['; print: treeBits; show:' bits for dynamic tree]'"].
	bits := bits + treeBits.

	"Compute the size of the compressed block"
	0 to: NumLiterals do:[:i| "encoding of literals"
		freq := literalFreq at: i+1.
		freq > 0 ifTrue:[bits := bits + (freq * (lTree bitLengthAt: i))]].
	NumLiterals+1 to: lTree maxCode do:[:i| "encoding of match lengths"
		freq := literalFreq at: i+1.
		extra := ExtraLengthBits at: i-NumLiterals.
		freq > 0 ifTrue:[bits := bits + (freq * ((lTree bitLengthAt: i) + extra))]].
	0 to: dTree maxCode do:[:i| "encoding of distances"
		freq := distanceFreq at: i+1.
		extra := ExtraDistanceBits at: i+1.
		freq > 0 ifTrue:[bits := bits + (freq * ((dTree bitLengthAt: i) + extra))]].

	^bits
%
run
ZipWriteStream setStamp: 'ar 12/30/1999 01:55' forMethod: #dynamicBlockSizeFor:and:using:and:.
true
%

category: 'encoding'
method: ZipWriteStream
encodeLiteral: lit
	"Encode the given literal"
	litCount := litCount + 1.
	literals at: litCount put: lit.
	distances at: litCount put: 0.
	literalFreq at: lit+1 put: (literalFreq at: lit+1) + 1.
	^self shouldFlush
%
run
ZipWriteStream setStamp: 'ar 12/29/1999 18:05' forMethod: #encodeLiteral:.
true
%

category: 'encoding'
method: ZipWriteStream
encodeMatch: length distance: dist
	"Encode the given match of length length starting at dist bytes ahead"
	| literal distance |
	dist > 0 
		ifFalse:[^self error:'Distance must be positive'].
	length < MinMatch 
		ifTrue:[^self error:'Match length must be at least ', MinMatch printString].
	litCount := litCount + 1.
	matchCount := matchCount + 1.
	literals at: litCount put: length - MinMatch.
	distances at: litCount put: dist.
	literal := (MatchLengthCodes at: length - MinMatch + 1).
	literalFreq at: literal+1 put: (literalFreq at: literal+1) + 1.
	dist < 257
		ifTrue:[distance := DistanceCodes at: dist]
		ifFalse:[distance := DistanceCodes at: 257 + (dist - 1 bitShift: -7)].
	distanceFreq at: distance+1 put: (distanceFreq at: distance+1) + 1.
	^self shouldFlush
%
run
ZipWriteStream setStamp: 'ar 12/29/1999 18:05' forMethod: #encodeMatch:distance:.
true
%

category: 'accessing'
method: ZipWriteStream
encodedStream
	^encoder encodedStream
%
run
ZipWriteStream setStamp: 'ar 12/30/1999 00:37' forMethod: #encodedStream.
true
%

category: 'initialization'
method: ZipWriteStream
finish
	"Finish pending operation. Do not close output stream."
	self deflateBlock.
	self flushBlock: true.
	encoder flush.
%
run
ZipWriteStream setStamp: 'ar 2/27/2001 13:23' forMethod: #finish.
true
%

category: 'fixed blocks'
method: ZipWriteStream
fixedBlockSizeFor: lTree and: dTree
	"Compute the length for the current block using fixed huffman trees"
	| bits extra |
	bits := 3 "block type".
	"Compute the size of the compressed block"
	0 to: NumLiterals do:[:i| "encoding of literals"
		bits := bits + ((literalFreq at: i+1) * (FixedLiteralTree bitLengthAt: i))].
	NumLiterals+1 to: lTree maxCode+1 do:[:i| "Encoding of match lengths"
		extra := ExtraLengthBits at: i-NumLiterals.
		bits := bits + ((literalFreq at: i+1) * ((FixedLiteralTree bitLengthAt: i) + extra))].
	0 to: dTree maxCode do:[:i| "encoding of distances"
		extra := ExtraDistanceBits at: i+1.
		bits := bits + ((distanceFreq at: i+1) * ((FixedDistanceTree bitLengthAt: i) + extra))].

	^bits
%
run
ZipWriteStream setStamp: 'ar 12/29/1999 18:18' forMethod: #fixedBlockSizeFor:and:.
true
%

category: 'encoding'
method: ZipWriteStream
flushBlock
	^self flushBlock: false
%
run
ZipWriteStream setStamp: 'ar 12/29/1999 18:08' forMethod: #flushBlock.
true
%

category: 'encoding'
method: ZipWriteStream
flushBlock: lastBlock
	"Send the current block"
	| lastFlag bitsRequired method bitsSent
	storedLength fixedLength dynamicLength 
	blTree lTree dTree blBits blFreq x |

	lastFlag := lastBlock ifTrue:[1] ifFalse:[0].

	"Compute the literal/length and distance tree"
	lTree := ZipEncoderTree buildTreeFrom: literalFreq maxDepth: MaxBits.
	dTree := ZipEncoderTree buildTreeFrom: distanceFreq maxDepth: MaxBits.

	"Compute the bit length tree"
	blBits := lTree bitLengths, dTree bitLengths.
	blFreq := WordArray new: MaxBitLengthCodes.
	self scanBitLengths: blBits into: blFreq.
	blTree := ZipEncoderTree buildTreeFrom: blFreq maxDepth: MaxBitLengthBits.

	"Compute the bit length for the current block.
	Note: Most of this could be computed on the fly but it's getting
	really ugly in this case so we do it afterwards."
	storedLength := self storedBlockSize.
	fixedLength := self fixedBlockSizeFor: lTree and: dTree.
	dynamicLength := self dynamicBlockSizeFor: lTree and: dTree 
							using: blTree and: blFreq.
	VerboseLevel > 1 ifTrue:[
		"Transcript cr; show:'Block sizes (S/F/D):';
			space; print: storedLength // 8; 
			nextPut:$/; print: fixedLength // 8; 
			nextPut:$/; print: dynamicLength // 8; space; endEntry"].

	"Check which method to use"
	method := self forcedMethod.
	method ifNil:[
		method := (storedLength < fixedLength and:[storedLength < dynamicLength]) 
			ifTrue:[#stored]
			ifFalse:[fixedLength < dynamicLength ifTrue:[#fixed] ifFalse:[#dynamic]]].
	(method == #stored and:[blockStart < 0]) ifTrue:[
		"Cannot use #stored if the block is not available"
		method := fixedLength < dynamicLength ifTrue:[#fixed] ifFalse:[#dynamic]].

	bitsSent := encoder bitPosition. "# of bits sent before this block"
	bitsRequired := nil.

	(method == #stored) ifTrue:[
		VerboseLevel > 0 ifTrue:["Transcript show:'S'"].
		bitsRequired := storedLength.
		encoder nextBits: 3 put: ((StoredBlock bitShift: 1) + lastFlag).
		self sendStoredBlock].

	(method == #fixed) ifTrue:[
		VerboseLevel > 0 ifTrue:["Transcript show:'F'"].
		bitsRequired := fixedLength.
		encoder nextBits: 3 put: ((FixedBlock bitShift: 1) + lastFlag).
		self sendFixedBlock].

	(method == #dynamic) ifTrue:[
		VerboseLevel > 0 ifTrue:["Transcript show:'D'"].
		bitsRequired := dynamicLength.
		encoder nextBits: 3 put: ((DynamicBlock bitShift: 1) + lastFlag).
		self sendDynamicBlock: blTree 
			literalTree: lTree 
			distanceTree: dTree 
			bitLengths: blBits].

	bitsRequired = ((x := encoder bitPosition) - bitsSent)
		ifFalse:[self error:'Bits size mismatch'].

	lastBlock 
		ifTrue:[self release]
		ifFalse:[self initializeNewBlock].
%
run
ZipWriteStream setStamp: 'marcus.denker 9/14/2008 21:02' forMethod: #flushBlock:.
true
%

category: 'accessing'
method: ZipWriteStream
forcedMethod
	"Return a symbol describing an enforced method or nil if the method should
	be chosen adaptively. Valid symbols are
		#stored	- store blocks (do not compress)
		#fixed	- use fixed huffman trees
		#dynamic	- use dynamic huffman trees."
	^nil
%
run
ZipWriteStream setStamp: 'ar 12/29/1999 18:32' forMethod: #forcedMethod.
true
%

category: 'initialization'
method: ZipWriteStream
initialize
	super initialize.
	literals := ByteArray new: WindowSize.
	distances := WordArray new: WindowSize.
	literalFreq := WordArray new: MaxLiteralCodes.
	distanceFreq := WordArray new: MaxDistCodes.
	self initializeNewBlock.

%
run
ZipWriteStream setStamp: 'ar 12/30/1999 00:40' forMethod: #initialize.
true
%

category: 'initialization'
method: ZipWriteStream
initializeNewBlock
	"Initialize the encoder for a new block of data"
	literalFreq atAllPut: 0.
	distanceFreq atAllPut: 0.
	literalFreq at: EndBlock+1 put: 1.
	litCount := 0.
	matchCount := 0.
%
run
ZipWriteStream setStamp: 'ar 12/29/1999 18:29' forMethod: #initializeNewBlock.
true
%

category: 'private'
method: ZipWriteStream
moveContentsToFront
	"Need to update crc here"
	self updateCrc.
	super moveContentsToFront.
	crcPosition := self position + 1.
%
run
ZipWriteStream setStamp: 'DaleHenrichs 10/11/2010 15:03' forMethod: #moveContentsToFront.
true
%

category: 'initialization'
method: ZipWriteStream
on: aCollectionOrStream
	crc := 16rFFFFFFFF.
	crcPosition := 1.
	bytesWritten := 0.
	encoder := ZipEncoder on: aCollectionOrStream.
	encoder isBinary
		ifTrue:[super on: ByteArray new]
		ifFalse:[super on: String new].
	self writeHeader.

%
run
ZipWriteStream setStamp: 'ar 2/24/2001 19:43' forMethod: #on:.
true
%

category: 'initialization'
method: ZipWriteStream
release
	"We're done with compression. Do some cleanup."
	literals := distances := literalFreq := distanceFreq := nil.
	self updateCrc.
	encoder flushBits.
	self writeFooter.
%
run
ZipWriteStream setStamp: 'nk 2/17/2004 16:31' forMethod: #release.
true
%

category: 'dynamic blocks'
method: ZipWriteStream
scanBitLength: bitLength repeatCount: repeatCount into: anArray
	"Update the frequency for the aTree based on the given values"
	| count |
	count := repeatCount.
	bitLength = 0 ifTrue:[
		[count >= 11] whileTrue:[
			anArray at: Repeat11To138+1 put: (anArray at: Repeat11To138+1) + 1.
			count := (count - 138) max: 0].
		[count >= 3] whileTrue:[
			anArray at: Repeat3To10+1 put: (anArray at: Repeat3To10+1) + 1.
			count := (count - 10) max: 0].
		count > 0 ifTrue:[anArray at: bitLength+1 put: (anArray at: bitLength+1) + count].
	] ifFalse:[
		anArray at: bitLength+1 put: (anArray at: bitLength+1) + 1.
		count := count - 1.
		[count >= 3] whileTrue:[
			anArray at: Repeat3To6+1 put: (anArray at: Repeat3To6+1) + 1.
			count := (count - 6) max: 0].
		count > 0 ifTrue:[anArray at: bitLength+1 put: (anArray at: bitLength+1) + count].
	].
%
run
ZipWriteStream setStamp: 'ar 12/30/1999 11:55' forMethod: #scanBitLength:repeatCount:into:.
true
%

category: 'dynamic blocks'
method: ZipWriteStream
scanBitLengths: bits into: anArray
	"Scan the trees and determine the frequency of the bit lengths.
	For repeating codes, emit a repeat count."
	| lastValue lastCount value |
	bits size = 0 ifTrue:[^self].
	lastValue := bits at: 1.
	lastCount := 1.
	2 to: bits size do:[:i|
		value := bits at: i.
		value = lastValue 
			ifTrue:[lastCount := lastCount + 1]
			ifFalse:[self scanBitLength: lastValue repeatCount: lastCount into: anArray.
					lastValue := value.
					lastCount := 1]].
	self scanBitLength: lastValue repeatCount: lastCount into: anArray.
%
run
ZipWriteStream setStamp: 'ar 12/30/1999 11:55' forMethod: #scanBitLengths:into:.
true
%

category: 'dynamic blocks'
method: ZipWriteStream
sendBitLength: bitLength repeatCount: repeatCount tree: aTree
	"Send the given bitLength, repeating repeatCount times"
	| count |
	count := repeatCount.
	bitLength = 0 ifTrue:[
		[count >= 11] whileTrue:[
			self sendBitLength: Repeat11To138 tree: aTree.
			encoder nextBits: 7 put: (count min: 138) - 11.
			count := (count - 138) max: 0].
		[count >= 3] whileTrue:[
			self sendBitLength: Repeat3To10 tree: aTree.
			encoder nextBits: 3 put: (count min: 10) - 3.
			count := (count - 10) max: 0].
		count timesRepeat:[self sendBitLength: bitLength tree: aTree].
	] ifFalse:[
		self sendBitLength: bitLength tree: aTree.
		count := count - 1.
		[count >= 3] whileTrue:[
			self sendBitLength: Repeat3To6 tree: aTree.
			encoder nextBits: 2 put: (count min: 6) - 3.
			count := (count - 6) max: 0].
		count timesRepeat:[self sendBitLength: bitLength tree: aTree].
	].
%
run
ZipWriteStream setStamp: 'ar 12/30/1999 11:40' forMethod: #sendBitLength:repeatCount:tree:.
true
%

category: 'dynamic blocks'
method: ZipWriteStream
sendBitLength: bitLength tree: aTree
	"Send the given bitLength"
	encoder nextBits: (aTree bitLengthAt: bitLength) 
		put: (aTree codeAt: bitLength).
%
run
ZipWriteStream setStamp: 'ar 12/30/1999 11:40' forMethod: #sendBitLength:tree:.
true
%

category: 'dynamic blocks'
method: ZipWriteStream
sendBitLengthTree: blTree
	"Send the bit length tree"
	| blIndex bitLength |
	MaxBitLengthCodes to: 4 by: -1 do:[:maxIndex|
		blIndex := BitLengthOrder at: maxIndex.
		bitLength := blIndex <= blTree maxCode 
			ifTrue:[blTree bitLengthAt: blIndex] ifFalse:[0].
		(maxIndex = 4 or:[bitLength > 0]) ifTrue:[
			encoder nextBits: 4 put: maxIndex - 4.
			1 to: maxIndex do:[:j|
				blIndex := BitLengthOrder at: j.
				bitLength := blIndex <= blTree maxCode 
					ifTrue:[blTree bitLengthAt: blIndex] ifFalse:[0].
				encoder nextBits: 3 put: bitLength].
			^self]].
%
run
ZipWriteStream setStamp: 'ar 12/30/1999 11:40' forMethod: #sendBitLengthTree:.
true
%

category: 'dynamic blocks'
method: ZipWriteStream
sendCompressedBlock: litTree with: distTree
	"Send the current block using the encodings from the given literal/length and distance tree"
	| sum |
	sum := encoder
			sendBlock: (AnsiReadStream on: literals from: 1 to: litCount)
			with: (AnsiReadStream on: distances from: 1 to: litCount)
			with: litTree
			with: distTree.
	sum = (blockPosition - blockStart) ifFalse:[self error:'Wrong number of bytes'].
%
run
ZipWriteStream setStamp: 'ar 12/30/1999 00:48' forMethod: #sendCompressedBlock:with:.
true
%

category: 'dynamic blocks'
method: ZipWriteStream
sendDynamicBlock: blTree literalTree: lTree distanceTree: dTree bitLengths: bits
	"Send a block using dynamic huffman trees"
	self sendLiteralTree: lTree distanceTree: dTree using: blTree bitLengths: bits.
	self sendCompressedBlock: lTree with: dTree.
%
run
ZipWriteStream setStamp: 'ar 12/29/1999 18:19' forMethod: #sendDynamicBlock:literalTree:distanceTree:bitLengths:.
true
%

category: 'fixed blocks'
method: ZipWriteStream
sendFixedBlock
	"Send a block using fixed huffman trees"
	self sendCompressedBlock: FixedLiteralTree with: FixedDistanceTree.
%
run
ZipWriteStream setStamp: 'ar 12/29/1999 18:18' forMethod: #sendFixedBlock.
true
%

category: 'dynamic blocks'
method: ZipWriteStream
sendLiteralTree: lTree distanceTree: dTree using: blTree bitLengths: bits
	"Send all the trees needed for dynamic huffman tree encoding"
	| lastValue lastCount value |
	encoder nextBits: 5 put: (lTree maxCode - 256).
	encoder nextBits: 5 put: (dTree maxCode).
	self sendBitLengthTree: blTree.
	bits size = 0 ifTrue:[^self].
	lastValue := bits at: 1.
	lastCount := 1.
	2 to: bits size do:[:i|
		value := bits at: i.
		value = lastValue 
			ifTrue:[lastCount := lastCount + 1]
			ifFalse:[self sendBitLength: lastValue repeatCount: lastCount tree: blTree.
					lastValue := value.
					lastCount := 1]].
	self sendBitLength: lastValue repeatCount: lastCount tree: blTree.
%
run
ZipWriteStream setStamp: 'ar 12/30/1999 11:40' forMethod: #sendLiteralTree:distanceTree:using:bitLengths:.
true
%

category: 'stored blocks'
method: ZipWriteStream
sendStoredBlock
	"Send an uncompressed block"
	| inBytes |
	inBytes := blockPosition - blockStart.
	encoder flushBits. "Skip to byte boundary"
	encoder nextBits: 16 put: inBytes.
	encoder nextBits: 16 put: (inBytes bitXor: 16rFFFF).
	encoder flushBits.
	1 to: inBytes do:[:i|
		encoder nextBytePut: (self _collection byteAt: blockStart+i)].
%
run
ZipWriteStream setStamp: 'DaleHenrichs 10/11/2010 14:59' forMethod: #sendStoredBlock.
true
%

category: 'encoding'
method: ZipWriteStream
shouldFlush
	"Check if we should flush the current block.
	Flushing can be useful if the input characteristics change."
	| nLits |
	litCount = literals size ifTrue:[^true]. "We *must* flush"
	(litCount bitAnd: 16rFFF) = 0 ifFalse:[^false]. "Only check every N kbytes"
	matchCount * 10 <= litCount ifTrue:[
		"This is basically random data. 
		There is no need to flush early since the overhead
		for encoding the trees will add to the overall size"
		^false].
	"Try to adapt to the input data.
	We flush if the ratio between matches and literals
	changes beyound a certain threshold"
	nLits := litCount - matchCount.
	nLits <= matchCount ifTrue:[^false]. "whow! so many matches"
	^nLits * 4 <= matchCount
%
run
ZipWriteStream setStamp: 'ar 12/29/1999 18:08' forMethod: #shouldFlush.
true
%

category: 'stored blocks'
method: ZipWriteStream
storedBlockSize
	"Compute the length for the current block when stored as is"
	^3 "block type bits" 
		+ (8 - (encoder bitPosition + 3 bitAnd: 7) bitAnd: 7)"skipped bits to byte boundary"
			+ 32 "byte length + chksum" 
				+ (blockPosition - blockStart * 8) "actual data bits".
%
run
ZipWriteStream setStamp: 'ar 12/30/1999 00:42' forMethod: #storedBlockSize.
true
%

category: 'private'
method: ZipWriteStream
updateCrc
	crcPosition <= self position ifTrue:[
		bytesWritten := bytesWritten + self position - crcPosition + 1.
		crc := self updateCrc: crc from: crcPosition to: self position in: self _collection.
		crcPosition := self position + 1].
%
run
ZipWriteStream setStamp: 'DaleHenrichs 10/11/2010 15:03' forMethod: #updateCrc.
true
%

category: 'private'
method: ZipWriteStream
updateCrc: oldCrc from: start to: stop in: aCollection
	^self class updateCrc: oldCrc from: start to: stop in: aCollection
%
run
ZipWriteStream setStamp: 'nk 2/17/2004 16:51' forMethod: #updateCrc:from:to:in:.
true
%

category: 'initialization'
method: ZipWriteStream
writeFooter
	"Write footer information if necessary"
	crc := crc bitXor: 16rFFFFFFFF.
%
run
ZipWriteStream setStamp: 'nk 2/17/2004 16:30' forMethod: #writeFooter.
true
%

category: 'initialization'
method: ZipWriteStream
writeHeader
	"Write header information if necessary"
%
run
ZipWriteStream setStamp: 'ar 2/24/2001 19:44' forMethod: #writeHeader.
true
%

category: 'pool initialization'
classmethod: ZipConstants
initialize
	"ZipConstants initialize"
	self initializeDeflateConstants.
	self initializeWriteStreamConstants.
%
run
ZipConstants class setStamp: 'ar 5/18/2003 19:09' forMethod: #initialize.
true
%

category: 'pool initialization'
classmethod: ZipConstants
initializeDeflateConstants

	WindowSize := 16r8000.
	WindowMask := WindowSize - 1.
	MaxDistance := WindowSize.

	MinMatch := 3.
	MaxMatch := 258.

	HashBits := 15.
	HashMask := (1 bitShift: HashBits) - 1.
	HashShift := (HashBits + MinMatch - 1) // MinMatch.

%
run
ZipConstants class setStamp: 'ar 5/18/2003 19:06' forMethod: #initializeDeflateConstants.
true
%

category: 'pool initialization'
classmethod: ZipConstants
initializeDistanceCodes
	| dist |
	BaseDistance := WordArray new: MaxDistCodes.
	DistanceCodes := WordArray new: 512.
	dist := 0.
	1 to: 16 do:[:code|
		BaseDistance at: code put: dist.
		1 to: (1 bitShift: (ExtraDistanceBits at: code)) do:[:n|
			dist := dist + 1.
			DistanceCodes at: dist put: code-1]].
	dist = 256 ifFalse:[self error:'Whoops?!'].
	dist := dist bitShift: -7.
	17 to: MaxDistCodes do:[:code|
		BaseDistance at: code put: (dist bitShift: 7).
		1 to: (1 bitShift: (ExtraDistanceBits at: code)-7) do:[:n|
			dist := dist + 1.
			DistanceCodes at: 256 + dist put: code-1]].

%
run
ZipConstants class setStamp: 'ar 5/18/2003 19:08' forMethod: #initializeDistanceCodes.
true
%

category: 'pool initialization'
classmethod: ZipConstants
initializeExtraBits
	ExtraLengthBits := 
		WordArray withAll: #(0 0 0 0 0 0 0 0 1 1 1 1 2 2 2 2 3 3 3 3 4 4 4 4 5 5 5 5 0).
	ExtraDistanceBits := 
		WordArray withAll: #(0 0 0 0 1 1 2 2 3 3 4 4 5 5 6 6 7 7 8 8 9 9 10 10 11 11 12 12 13 13).
	ExtraBitLengthBits := 
		WordArray withAll: #(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 3 7).
	BitLengthOrder :=
		WordArray withAll: #(16 17 18 0 8 7 9 6 10 5 11 4 12 3 13 2 14 1 15).

%
run
ZipConstants class setStamp: 'ar 5/18/2003 19:07' forMethod: #initializeExtraBits.
true
%

category: 'pool initialization'
classmethod: ZipConstants
initializeFixedTrees
	"ZipWriteStream initializeFixedTrees"
	| counts nodes wa |
	FixedLiteralTree := ZipEncoderTree new.
	FixedLiteralTree maxCode: 287.
	counts := WordArray new: MaxBits+1.
	counts at: 7+1 put: 24.
	counts at: 8+1 put: 144+8.
	counts at: 9+1 put: 112.
	nodes := Array new: 288.
	1 to: 288 do:[:i| nodes at: i put: (ZipEncoderNode value: i-1 frequency: 0 height: 0)].
	0 to: 143 do:[:i| (nodes at: i+1) setBitLengthTo: 8].
	144 to: 255 do:[:i| (nodes at: i+1) setBitLengthTo: 9].
	256 to: 279 do:[:i| (nodes at: i+1) setBitLengthTo: 7].
	280 to: 287 do:[:i| (nodes at: i+1) setBitLengthTo: 8].
	FixedLiteralTree buildCodes: nodes counts: counts maxDepth: MaxBits.
	FixedLiteralTree setValuesFrom: nodes.

	FixedDistanceTree := ZipEncoderTree new.
	FixedDistanceTree maxCode: MaxDistCodes.
	wa := WordArray new: MaxDistCodes+1.
	wa atAllPut: 5.
	FixedDistanceTree
		bitLengths: wa
		codes: ((0 to: MaxDistCodes) collect:[:i| FixedDistanceTree reverseBits: i length: 5]).
%
run
ZipConstants class setStamp: 'ar 5/18/2003 19:08' forMethod: #initializeFixedTrees.
true
%

category: 'pool initialization'
classmethod: ZipConstants
initializeLengthCodes
	| length |
	BaseLength := WordArray new: MaxLengthCodes.
	MatchLengthCodes := WordArray new: MaxMatch - MinMatch + 1.
	length := 0.
	1 to: MaxLengthCodes - 1 do:[:code|
		BaseLength at: code put: length.
		1 to: (1 bitShift: (ExtraLengthBits at: code)) do:[:n|
			length := length + 1.
			MatchLengthCodes at: length put: NumLiterals + code]].

%
run
ZipConstants class setStamp: 'ar 5/18/2003 19:07' forMethod: #initializeLengthCodes.
true
%

category: 'pool initialization'
classmethod: ZipConstants
initializeWriteStreamConstants

	MaxBits := 15.
	MaxBitLengthBits := 7.
	EndBlock := 256.

	StoredBlock := 0.
	FixedBlock := 1.
	DynamicBlock := 2.

	NumLiterals := 256.
	MaxLengthCodes := 29.
	MaxDistCodes := 30.
	MaxBitLengthCodes := 19.
	MaxLiteralCodes := NumLiterals + MaxLengthCodes + 1. "+ End of Block"

	Repeat3To6 := 16. "Repeat previous bit length 3-6 times (2 bits repeat count)"
	Repeat3To10 := 17. "Repeat previous bit length 3-10 times (3 bits repeat count)"
	Repeat11To138 := 18. "Repeat previous bit length 11-138 times (7 bits repeat count)"

	self initializeExtraBits.
	self initializeLengthCodes.
	self initializeDistanceCodes.
	self initializeFixedTrees.

%
run
ZipConstants class setStamp: 'ar 5/18/2003 19:09' forMethod: #initializeWriteStreamConstants.
true
%

category: 'accessing'
method: ZipEncoder
bitPosition
	^encodedStream position + self position * 8 + bitPosition.
%
run
ZipEncoder setStamp: 'DaleHenrichs 10/11/2010 15:25' forMethod: #bitPosition.
true
%

category: 'initialization'
method: ZipEncoder
close
	self flush.
	encodedStream close.
%
run
ZipEncoder setStamp: 'sd 1/30/2004 15:24' forMethod: #close.
true
%

category: 'initialization'
method: ZipEncoder
commit
	encodedStream nextPutAll: (self _collection copyFrom: 1 to: self position).
	self _position: 0.
%
run
ZipEncoder setStamp: 'DaleHenrichs 10/11/2010 15:33' forMethod: #commit.
true
%

category: 'accessing'
method: ZipEncoder
encodedStream
	^encodedStream
%
run
ZipEncoder setStamp: 'ar 12/30/1999 00:37' forMethod: #encodedStream.
true
%

category: 'initialization'
method: ZipEncoder
flush
	self flushBits.
	self commit.
%
run
ZipEncoder setStamp: 'ar 12/30/1999 15:51' forMethod: #flush.
true
%

category: 'initialization'
method: ZipEncoder
flushBits
	"Flush currently unsent bits"
	[bitPosition > 0] whileTrue:[
		self nextBytePut: (bitBuffer bitAnd: 255).
		bitBuffer := bitBuffer bitShift: -8.
		bitPosition := bitPosition - 8].
	bitPosition := 0.
%
run
ZipEncoder setStamp: 'ar 1/2/2000 16:35' forMethod: #flushBits.
true
%

category: 'accessing'
method: ZipEncoder
nextBits: nBits put: value
	"Store a value of nBits"
	"self assert:[value >= 0 and:[(1 bitShift: nBits) > value]]."
	bitBuffer := bitBuffer bitOr: (value bitShift: bitPosition).
	bitPosition := bitPosition + nBits.
	[bitPosition >= 8] whileTrue:[
		self nextBytePut: (bitBuffer bitAnd: 255).
		bitBuffer := bitBuffer bitShift: -8.
		bitPosition := bitPosition - 8].
%
run
ZipEncoder setStamp: 'ar 1/2/2000 16:34' forMethod: #nextBits:put:.
true
%

category: 'accessing'
method: ZipEncoder
nextBytePut: anObject 
	| coll collSize |
	coll := self _collection.
	collSize := coll size.
	self position = collSize ifTrue: [coll size: collSize + 1].
	self _position: self position + 1.
	^coll byteAt: self position put: anObject
%
run
ZipEncoder setStamp: 'MartinMcClure 12/30/2011 17:31' forMethod: #nextBytePut:.
true
%

category: 'initialization'
method: ZipEncoder
on: aCollectionOrStream
	aCollectionOrStream isStream 
		ifTrue:[encodedStream := aCollectionOrStream]
		ifFalse:[encodedStream := AnsiWriteStream on: aCollectionOrStream].
	encodedStream isBinary
		ifTrue:[super on: (ByteArray new: 4096)]
		ifFalse:[super on: (String new: 4096)].
	bitPosition := bitBuffer := 0.
%
run
ZipEncoder setStamp: 'PeterHugossonMiller 9/3/2009 11:52' forMethod: #on:.
true
%

category: 'private'
method: ZipEncoder
privateSendBlock: literalStream with: distanceStream with: litTree with: distTree
	"Send the current block using the encodings from the given literal/length and distance tree"
	| lit dist code extra sum |
	sum := 0.
	[literalStream atEnd] whileFalse:[
		lit := literalStream next.
		dist := distanceStream next.
		dist = 0 ifTrue:["lit is a literal"
			sum := sum + 1.
			self nextBits: (litTree bitLengthAt: lit)
				put: (litTree codeAt: lit).
		] ifFalse:["lit is match length"
			sum := sum + lit + MinMatch.
			code := (MatchLengthCodes at: lit + 1).
			self nextBits: (litTree bitLengthAt: code)
				put: (litTree codeAt: code).
			extra := ExtraLengthBits at: code-NumLiterals.
			extra = 0 ifFalse:[
				lit := lit - (BaseLength at: code-NumLiterals).
				self nextBits: extra put: lit.
			].
			dist := dist - 1.
			dist < 256
				ifTrue:[code := DistanceCodes at: dist + 1]
				ifFalse:[code := DistanceCodes at: 257 + (dist bitShift: -7)].
			"self assert:[code < MaxDistCodes]."
			self nextBits: (distTree bitLengthAt: code)
				put: (distTree codeAt: code).
			extra := ExtraDistanceBits at: code+1.
			extra = 0 ifFalse:[
				dist := dist - (BaseDistance at: code+1).
				self nextBits: extra put: dist.
			].
		].
	].
	^sum
%
run
ZipEncoder setStamp: 'ar 2/2/2001 15:47' forMethod: #privateSendBlock:with:with:with:.
true
%

category: 'block encoding'
method: ZipEncoder
sendBlock: literalStream with: distanceStream with: litTree with: distTree
	"Send the current block using the encodings from the given literal/length and distance tree"
	| result |
	result := 0.
	[literalStream atEnd] whileFalse:[
		result := result + (self privateSendBlock: literalStream
						with: distanceStream with: litTree with: distTree).
		self commit.
	].
	self nextBits: (litTree bitLengthAt: EndBlock) put: (litTree codeAt: EndBlock).
	^result
%
run
ZipEncoder setStamp: 'ar 12/30/1999 18:39' forMethod: #sendBlock:with:with:with:.
true
%

category: 'pool initialization'
classmethod: ZipFileConstants
initialize
	"ZipFileConstants initialize"
	FaMsdos		:= 0.
	FaUnix 		:= 3.
	DeflatingCompressionNormal		:= 0.
	DeflatingCompressionMaximum	:= 2.
	DeflatingCompressionFast		:= 4.
	DeflatingCompressionSuperFast	:= 6.
	CompressionStored				:= 0.
	CompressionDeflated				:= 8.
	CompressionLevelNone			:= 0.
	CompressionLevelDefault			:= 6.
	IfaTextFile						:= 1.
	IfaBinaryFile					:= 0.
	DataDescriptorLength 				:= 12.

	"Unix permission bits"
	DefaultDirectoryPermissions		:= 8r040755.
	DefaultFilePermissions			:= 8r0100666.
	DirectoryAttrib 					:= 8r040000.
	FileAttrib 						:= 8r0100000.

	CentralDirectoryFileHeaderSignature := #[80 75 1 2]. "#(16r50 with: 16r4B with: 16r01 with: 16r02)"
	LocalFileHeaderSignature := #[80 75 3 4].
		"(ByteArray with: 16r50 with: 16r4B with: 16r03 with: 16r04)"
	EndOfCentralDirectorySignature := #[80 75 5 6].
		"(ByteArray with: 16r50 with: 16r4B with: 16r05 with: 16r06)"
%
run
ZipFileConstants class setStamp: 'StephaneDucasse 2/3/2010 22:24' forMethod: #initialize.
true
%

category: 'archive operations'
method: Archive
addDirectory: aFileName
	^self addDirectory: aFileName as: aFileName

%
run
Archive setStamp: 'nk 2/22/2001 19:09' forMethod: #addDirectory:.
true
%

category: 'archive operations'
method: Archive
addDirectory: aFileName as: anotherFileName
	| newMember |
	newMember := self memberClass newFromDirectory: aFileName.
	self addMember: newMember.
	newMember localFileName: anotherFileName.
	^newMember
%
run
Archive setStamp: 'nk 12/20/2002 14:57' forMethod: #addDirectory:as:.
true
%

category: 'archive operations'
method: Archive
addFile: aFileName
	^self addFile: aFileName as: aFileName
%
run
Archive setStamp: 'nk 2/21/2001 18:29' forMethod: #addFile:.
true
%

category: 'archive operations'
method: Archive
addFile: aFileName as: anotherFileName
	| newMember |
	newMember := self memberClass newFromFile: aFileName.
	self addMember: newMember.
	newMember localFileName: anotherFileName.
	^newMember
%
run
Archive setStamp: 'nk 12/20/2002 15:03' forMethod: #addFile:as:.
true
%

category: 'archive operations'
method: Archive
addMember: aMember
	^members addLast: aMember
%
run
Archive setStamp: 'nk 2/22/2001 19:09' forMethod: #addMember:.
true
%

category: 'archive operations'
method: Archive
addString: aString as: aFileName
	| newMember |
	newMember := self memberClass newFromString: aString named: aFileName.
	self addMember: newMember.
	newMember localFileName: aFileName.
	^newMember
%
run
Archive setStamp: 'nk 12/20/2002 15:03' forMethod: #addString:as:.
true
%

category: 'archive operations'
method: Archive
addTree: aFileNameOrDirectory match: aBlock 
	| nameSize |
	nameSize := aFileNameOrDirectory isString
				ifTrue: [aFileNameOrDirectory size]
				ifFalse: [aFileNameOrDirectory pathName size].
	^ self
		addTree: aFileNameOrDirectory
		removingFirstCharacters: nameSize + 1
		match: aBlock
%
run
Archive setStamp: 'tak 2/2/2005 13:22' forMethod: #addTree:match:.
true
%

category: 'archive operations'
method: Archive
addTree: aFileNameOrDirectory removingFirstCharacters: n 
	^ self
		addTree: aFileNameOrDirectory
		removingFirstCharacters: n
		match: [:e | true]
%
run
Archive setStamp: 'tak 2/2/2005 13:00' forMethod: #addTree:removingFirstCharacters:.
true
%

category: 'archive operations'
method: Archive
canWriteToFileNamed: aFileName
	"Catch attempts to overwrite existing zip file"
	^(members anySatisfy: [ :ea | ea usesFileNamed: aFileName ]) not.

%
run
Archive setStamp: 'nk 2/24/2001 14:12' forMethod: #canWriteToFileNamed:.
true
%

category: 'archive operations'
method: Archive
contentsOf: aMemberOrName
	| member |
	member := self member: aMemberOrName.
	member ifNil: [ ^nil ].
	^member contents
%
run
Archive setStamp: 'nk 2/22/2001 07:57' forMethod: #contentsOf:.
true
%


category: 'archive operations'
method: Archive
extractMember: aMemberOrName toFileNamed: aFileName
	| member |
	member := self member: aMemberOrName.
	member ifNil: [ ^nil ].
	member extractToFileNamed: aFileName
%
run
Archive setStamp: 'nk 2/22/2001 07:57' forMethod: #extractMember:toFileNamed:.
true
%

category: 'initialization'
method: Archive
initialize
	members := OrderedCollection new.
%
run
Archive setStamp: 'alain.plantec 5/28/2009 09:39' forMethod: #initialize.
true
%

category: 'private'
method: Archive
member: aMemberOrName
	^(members includes: aMemberOrName)
		ifTrue: [ aMemberOrName ]
		ifFalse: [ self memberNamed: aMemberOrName ].
%
run
Archive setStamp: 'nk 2/22/2001 07:56' forMethod: #member:.
true
%

category: 'private'
method: Archive
memberClass
	self subclassResponsibility
%
run
Archive setStamp: 'nk 2/21/2001 18:14' forMethod: #memberClass.
true
%

category: 'archive operations'
method: Archive
memberNamed: aString
	"Return the first member whose zip name or local file name matches aString, or nil"
	^members detect: [ :ea | ea fileName = aString or: [ ea localFileName = aString ]] ifNone: [ ]
%
run
Archive setStamp: 'nk 12/20/2002 14:50' forMethod: #memberNamed:.
true
%

category: 'archive operations'
method: Archive
memberNames
	^members collect: [ :ea | ea fileName ]
%
run
Archive setStamp: 'nk 2/21/2001 18:00' forMethod: #memberNames.
true
%

category: 'archive operations'
method: Archive
members
	^members
%
run
Archive setStamp: 'nk 2/21/2001 17:58' forMethod: #members.
true
%

category: 'archive operations'
method: Archive
membersMatching: aString
	^members select: [ :ea | (aString match: ea fileName) or: [ aString match: ea localFileName ] ]
%
run
Archive setStamp: 'nk 12/20/2002 14:50' forMethod: #membersMatching:.
true
%

category: 'archive operations'
method: Archive
numberOfMembers
	^members size
%
run
Archive setStamp: 'nk 2/21/2001 17:59' forMethod: #numberOfMembers.
true
%

category: 'archive operations'
method: Archive
removeMember: aMemberOrName
	| member |
	member := self member: aMemberOrName.
	member ifNotNil: [ members remove: member ].
	^member
%
run
Archive setStamp: 'nk 2/22/2001 07:57' forMethod: #removeMember:.
true
%

category: 'archive operations'
method: Archive
replaceMember: aMemberOrName with: newMember
	| member |
	member := self member: aMemberOrName.
	member ifNotNil: [ members replaceAll: member with: newMember ].
	^member
%
run
Archive setStamp: 'nk 2/22/2001 07:57' forMethod: #replaceMember:with:.
true
%

category: 'archive operations'
method: Archive
setContentsOf: aMemberOrName to: aString
	| newMember oldMember |
	oldMember := self member: aMemberOrName.
	newMember := (self memberClass newFromString: aString named: oldMember fileName)
		copyFrom: oldMember.
	self replaceMember: oldMember with: newMember.
%
run
Archive setStamp: 'nk 2/22/2001 17:24' forMethod: #setContentsOf:to:.
true
%

category: 'archive operations'
method: Archive
writeTo: aStream
	self subclassResponsibility
%
run
Archive setStamp: 'nk 2/21/2001 20:58' forMethod: #writeTo:.
true
%

category: 'constants'
classmethod: ZipArchive
compressionDeflated
	^CompressionDeflated
%
run
ZipArchive class setStamp: 'nk 2/22/2001 14:13' forMethod: #compressionDeflated.
true
%

category: 'constants'
classmethod: ZipArchive
compressionLevelDefault
	^CompressionLevelDefault
%
run
ZipArchive class setStamp: 'nk 2/22/2001 14:12' forMethod: #compressionLevelDefault.
true
%

category: 'constants'
classmethod: ZipArchive
compressionLevelNone
	^CompressionLevelNone 
%
run
ZipArchive class setStamp: 'nk 2/22/2001 14:12' forMethod: #compressionLevelNone.
true
%

category: 'constants'
classmethod: ZipArchive
compressionStored
	^CompressionStored
%
run
ZipArchive class setStamp: 'nk 2/22/2001 14:13' forMethod: #compressionStored.
true
%

category: 'constants'
classmethod: ZipArchive
findEndOfCentralDirectoryFrom: stream
	"Seek in the given stream to the end, then read backwards until we find the
	signature of the central directory record. Leave the file positioned right
	before the signature.

	Answers the file position of the EOCD, or 0 if not found."

	| data fileLength seekOffset pos maxOffset |
	stream setToEnd.
	fileLength := stream position.
	"If the file length is less than 18 for the EOCD length plus 4 for the signature, we have a problem"
	fileLength < 22 ifTrue: [^ self error: 'file is too short'].
	
	seekOffset := 0.
	pos := 0.
	data := ByteArray new: 4100.
	maxOffset := 40960 min: fileLength.	"limit search range to 40K"

	[
		seekOffset := (seekOffset + 4096) min: fileLength.
		stream position: fileLength - seekOffset.
		data := stream next: (4100 min: seekOffset) into: data startingAt: 1.
		pos := data lastIndexOfPKSignature: EndOfCentralDirectorySignature.
		pos = 0 and: [seekOffset < maxOffset]
	] whileTrue.

	^ pos > 0
		ifTrue: [ | newPos | stream position: (newPos := (stream position + pos - seekOffset - 1)). newPos]
		ifFalse: [0]
%
run
ZipArchive class setStamp: 'nk 8/21/2004 15:19' forMethod: #findEndOfCentralDirectoryFrom:.
true
%

category: 'constants'
classmethod: ZipArchive
validSignatures
	"Return the valid signatures for a zip file"
	^Array 
		with: LocalFileHeaderSignature
		with: CentralDirectoryFileHeaderSignature
		with: EndOfCentralDirectorySignature
%
run
ZipArchive class setStamp: 'ar 2/27/2001 13:38' forMethod: #validSignatures.
true
%

category: 'archive operations'
method: ZipArchive
addDeflateString: aString as: aFileName
	"Add a verbatim string under the given file name"
	| mbr |
	mbr := self addString: aString as: aFileName.
	mbr desiredCompressionMethod: CompressionDeflated.
	^mbr
%
run
ZipArchive setStamp: 'ar 3/1/2006 23:21' forMethod: #addDeflateString:as:.
true
%

category: 'initialization'
method: ZipArchive
close
	self members do:[:m| m close].
%
run
ZipArchive setStamp: 'ar 3/2/2001 18:47' forMethod: #close.
true
%

category: 'archive operations'
method: ZipArchive
extractAllTo: aDirectory 
	"Extract all elements to the given directory"
	"UIManager default informUserDuring: 
		[ :bar | "
		self 
			extractAllTo: aDirectory
			informing: nil "bar ]"
%
run
ZipArchive setStamp: 'sd 3/28/2008 11:03' forMethod: #extractAllTo:.
true
%

category: 'archive operations'
method: ZipArchive
extractAllTo: aDirectory informing: bar
	"Extract all elements to the given directory"
	^self extractAllTo: aDirectory informing: bar overwrite: false
%
run
ZipArchive setStamp: 'ar 2/6/2004 13:20' forMethod: #extractAllTo:informing:.
true
%

category: 'archive operations'
method: ZipArchive
extractAllTo: aDirectory informing: bar overwrite: allOverwrite
	"Extract all elements to the given directory"
	| overwriteAll |
	overwriteAll := allOverwrite.
	self members do:[:entry| | dir |
		entry isDirectory ifTrue:[
			bar ifNotNil:[bar value: 'Creating ', entry fileName].
			dir := (entry fileName findTokens:'/') 
					inject: aDirectory into:[:base :part| base directoryNamed: part].
			dir assureExistence.
		].
	].
	self members do:[:entry| | response |
		entry isDirectory ifFalse:[
			bar ifNotNil:[bar value: 'Extracting ', entry fileName].
			response := entry extractInDirectory: aDirectory overwrite: overwriteAll.
			response == #retryWithOverwrite ifTrue:[
				overwriteAll := true.
				response := entry extractInDirectory: aDirectory overwrite: overwriteAll.
			].
			response == #abort ifTrue:[^self].
			response == #failed ifTrue:[
				(self confirm: 'Failed to extract ', entry fileName, '. Proceed?') ifFalse:[^self].
			].
		].
	].

%
run
ZipArchive setStamp: 'nice 1/5/2010 15:59' forMethod: #extractAllTo:informing:overwrite:.
true
%

category: 'accessing'
method: ZipArchive
hasMemberSuchThat: aBlock
	"Answer whether we have a member satisfying the given condition"
	^self members anySatisfy: aBlock
%
run
ZipArchive setStamp: 'ar 3/1/2006 23:21' forMethod: #hasMemberSuchThat:.
true
%

category: 'initialization'
method: ZipArchive
initialize
	super initialize.
	writeEOCDOffset := writeCentralDirectoryOffset := 0.
	zipFileComment := ''.

%
run
ZipArchive setStamp: 'nk 2/22/2001 17:20' forMethod: #initialize.
true
%

category: 'private'
method: ZipArchive
memberClass
	^ZipArchiveMember
%
run
ZipArchive setStamp: 'nk 2/21/2001 18:26' forMethod: #memberClass.
true
%

category: 'accessing'
method: ZipArchive
prependedDataSize
	"Answer the size of whatever data exists before my first member.
	Assumes that I was read from a file or stream (i.e. the first member is a ZipFileMember)"
	^members isEmpty
		ifFalse: [ (members at: 1) localHeaderRelativeOffset ]
		ifTrue: [ centralDirectoryOffsetWRTStartingDiskNumber ]
%
run
ZipArchive setStamp: 'nk 3/27/2002 11:23' forMethod: #prependedDataSize.
true
%

category: 'private'
method: ZipArchive
readEndOfCentralDirectoryFrom: aStream
	"Read EOCD, starting from position before signature."
	| signature zipFileCommentLength |
	signature := self readSignatureFrom: aStream.
	signature = EndOfCentralDirectorySignature ifFalse: [ ^self error: 'bad signature at ', aStream position printString ].

	aStream nextLittleEndianNumber: 2. "# of this disk"
	aStream nextLittleEndianNumber: 2. "# of disk with central dir start"
	aStream nextLittleEndianNumber: 2. "# of entries in central dir on this disk"
	aStream nextLittleEndianNumber: 2. "total # of entries in central dir"
	centralDirectorySize := aStream nextLittleEndianNumber: 4. "size of central directory"
	centralDirectoryOffsetWRTStartingDiskNumber := aStream nextLittleEndianNumber: 4. "offset of start of central directory"
	zipFileCommentLength := aStream nextLittleEndianNumber: 2. "zip file comment"
	zipFileComment := aStream next: zipFileCommentLength.

%
run
ZipArchive setStamp: 'nk 2/22/2001 17:19' forMethod: #readEndOfCentralDirectoryFrom:.
true
%

category: 'reading'
method: ZipArchive
readFrom: aStreamOrFileName
	| stream name eocdPosition |
	stream := aStreamOrFileName isStream
		ifTrue: [name := aStreamOrFileName name. aStreamOrFileName]
		ifFalse: [self error: 'from fileName not implemented yet'].
	stream binary.
	eocdPosition := self class findEndOfCentralDirectoryFrom: stream.
	eocdPosition <= 0 ifTrue: [self error: 'can''t find EOCD position'].
	self readEndOfCentralDirectoryFrom: stream.
	stream position: eocdPosition - centralDirectorySize.
	self readMembersFrom: stream named: name
%
run
ZipArchive setStamp: 'nk 12/16/2002 17:09' forMethod: #readFrom:.
true
%

category: 'private'
method: ZipArchive
readMembersFrom: stream named: fileName
	
	[ | signature newMember |
		newMember := self memberClass newFromZipFile: stream named: fileName.
		signature := self readSignatureFrom: stream.
		signature = EndOfCentralDirectorySignature ifTrue: [ ^self ].
		signature = CentralDirectoryFileHeaderSignature
			ifFalse: [ self error: 'bad CD signature at ', (stream position - 4) printStringHex ].
		newMember readFrom: stream.
		newMember looksLikeDirectory ifTrue: [ newMember := newMember asDirectory ].
		self addMember: newMember.
	] repeat.
%
run
ZipArchive setStamp: 'nice 1/5/2010 15:59' forMethod: #readMembersFrom:named:.
true
%

category: 'private'
method: ZipArchive
readSignatureFrom: stream
	"Returns next signature from given stream, leaves stream positioned afterwards."

	| signatureData | 
	signatureData := ByteArray new: 4.
	stream next: 4 into: signatureData.
	({ CentralDirectoryFileHeaderSignature . LocalFileHeaderSignature . EndOfCentralDirectorySignature }
		includes: signatureData)
			ifFalse: [ ^self error: 'bad signature ', signatureData asString asHex, ' at position ', (stream position - 4) asString ].
	^signatureData

%
run
ZipArchive setStamp: 'nk 8/21/2004 15:22' forMethod: #readSignatureFrom:.
true
%

category: 'private'
method: ZipArchive
writeCentralDirectoryTo: aStream
	| offset |
	offset := writeCentralDirectoryOffset.
	members do: [ :member |
		member writeCentralDirectoryFileHeaderTo: aStream.
		offset := offset + member centralDirectoryHeaderSize.
	].
	writeEOCDOffset := offset.
	self writeEndOfCentralDirectoryTo: aStream.


%
run
ZipArchive setStamp: 'nk 2/21/2001 20:19' forMethod: #writeCentralDirectoryTo:.
true
%

category: 'private'
method: ZipArchive
writeEndOfCentralDirectoryTo: aStream

	aStream nextPutAll: EndOfCentralDirectorySignature.
	aStream nextLittleEndianNumber: 2 put: 0. "diskNumber"
	aStream nextLittleEndianNumber: 2 put: 0. "diskNumberWithStartOfCentralDirectory"
	aStream nextLittleEndianNumber: 2 put: members size. "numberOfCentralDirectoriesOnThisDisk"
	aStream nextLittleEndianNumber: 2 put: members size. "numberOfCentralDirectories"
	aStream nextLittleEndianNumber: 4 put: writeEOCDOffset - writeCentralDirectoryOffset. "size of central dir"
	aStream nextLittleEndianNumber: 4 put: writeCentralDirectoryOffset. "offset of central dir"
	aStream nextLittleEndianNumber: 2 put: zipFileComment size. "zip file comment"
	zipFileComment isEmpty ifFalse: [ aStream nextPutAll: zipFileComment ].


%
run
ZipArchive setStamp: 'nk 2/21/2001 21:02' forMethod: #writeEndOfCentralDirectoryTo:.
true
%

category: 'writing'
method: ZipArchive
writeTo: stream
	stream binary.
	members do: [ :member |
		member writeTo: stream.
		member endRead.
	].
	writeCentralDirectoryOffset := stream position.
	self writeCentralDirectoryTo: stream.
	
%
run
ZipArchive setStamp: 'nk 2/23/2001 10:29' forMethod: #writeTo:.
true
%

category: 'writing'
method: ZipArchive
writeTo: stream prepending: aString
	stream binary.
	stream nextPutAll: aString.
	members do: [ :member |
		member writeTo: stream.
		member endRead.
	].
	writeCentralDirectoryOffset := stream position.
	self writeCentralDirectoryTo: stream.
	
%
run
ZipArchive setStamp: 'nk 3/27/2002 10:42' forMethod: #writeTo:prepending:.
true
%

category: 'accessing'
method: ZipArchive
zipFileComment
	^zipFileComment asString
%
run
ZipArchive setStamp: 'nk 2/24/2001 13:44' forMethod: #zipFileComment.
true
%

category: 'accessing'
method: ZipArchive
zipFileComment: aString
	zipFileComment := aString
%
run
ZipArchive setStamp: 'nk 2/24/2001 13:43' forMethod: #zipFileComment:.
true
%

category: 'as yet unclassified'
classmethod: ArchiveMember
newDirectoryNamed: aString
	self subclassResponsibility
%
run
ArchiveMember class setStamp: 'nk 2/21/2001 18:33' forMethod: #newDirectoryNamed:.
true
%

category: 'as yet unclassified'
classmethod: ArchiveMember
newFromFile: aFileName
	self subclassResponsibility
%
run
ArchiveMember class setStamp: 'nk 2/21/2001 18:32' forMethod: #newFromFile:.
true
%

category: 'as yet unclassified'
classmethod: ArchiveMember
newFromString: aString
	self subclassResponsibility
%
run
ArchiveMember class setStamp: 'nk 2/21/2001 18:32' forMethod: #newFromString:.
true
%

category: 'initialization'
method: ArchiveMember
close

%
run
ArchiveMember setStamp: 'ar 3/2/2001 18:46' forMethod: #close.
true
%

category: 'accessing'
method: ArchiveMember
fileName
	^fileName
%
run
ArchiveMember setStamp: 'nk 2/22/2001 16:00' forMethod: #fileName.
true
%

category: 'accessing'
method: ArchiveMember
fileName: aName
	fileName := aName
%
run
ArchiveMember setStamp: 'nk 2/22/2001 16:00' forMethod: #fileName:.
true
%

category: 'initialization'
method: ArchiveMember
initialize
	fileName := ''.
	isCorrupt := false.
%
run
ArchiveMember setStamp: 'alain.plantec 5/28/2009 09:39' forMethod: #initialize.
true
%

category: 'accessing'
method: ArchiveMember
isCorrupt
	^isCorrupt ifNil: [ isCorrupt := false ]
%
run
ArchiveMember setStamp: 'nk 3/7/2004 16:16' forMethod: #isCorrupt.
true
%

category: 'accessing'
method: ArchiveMember
isCorrupt: aBoolean
	"Mark this member as being corrupt."
	isCorrupt := aBoolean
%
run
ArchiveMember setStamp: 'nk 3/7/2004 16:06' forMethod: #isCorrupt:.
true
%

category: 'accessing'
method: ArchiveMember
localFileName: aString
	"Set my internal filename.
	Returns the (possibly new) filename.
	aString will be translated from local FS format into Unix format."

	^fileName := aString
%
run
ArchiveMember setStamp: 'nk 12/20/2002 15:02' forMethod: #localFileName:.
true
%

category: 'printing'
method: ArchiveMember
printOn: aStream
	super printOn: aStream.
	aStream nextPut: $(;
		nextPutAll: self fileName;
		nextPut: $)
%
run
ArchiveMember setStamp: 'nk 12/20/2002 15:11' forMethod: #printOn:.
true
%

category: 'testing'
method: ArchiveMember
usesFileNamed: aFileName
	"Do I require aFileName? That is, do I care if it's clobbered?"
	^false
%
run
ArchiveMember setStamp: 'nk 2/21/2001 19:43' forMethod: #usesFileNamed:.
true
%

category: 'instance creation'
classmethod: ZipArchiveMember
newFromDirectory: aFileName
	^ZipDirectoryMember newNamed: aFileName
%
run
ZipArchiveMember class setStamp: 'nk 2/22/2001 17:27' forMethod: #newFromDirectory:.
true
%

category: 'instance creation'
classmethod: ZipArchiveMember
newFromFile: aFileName
	^ZipNewFileMember newNamed: aFileName
%
run
ZipArchiveMember class setStamp: 'nk 2/22/2001 17:27' forMethod: #newFromFile:.
true
%

category: 'instance creation'
classmethod: ZipArchiveMember
newFromString: aString named: aFileName
	^ZipStringMember newFrom: aString named: aFileName
%
run
ZipArchiveMember class setStamp: 'nk 2/22/2001 17:25' forMethod: #newFromString:named:.
true
%

category: 'instance creation'
classmethod: ZipArchiveMember
newFromZipFile: stream named: fileName
	^ZipFileMember newFrom: stream named: fileName
%
run
ZipArchiveMember class setStamp: 'nk 2/21/2001 20:40' forMethod: #newFromZipFile:named:.
true
%

category: 'private'
method: ZipArchiveMember
asDirectory
	^ZipDirectoryMember new copyFrom: self
%
run
ZipArchiveMember setStamp: 'nk 2/21/2001 21:55' forMethod: #asDirectory.
true
%

category: 'accessing'
method: ZipArchiveMember
centralDirectoryHeaderSize

	| systemFileName systemFileComment systemCdExtraField |
	systemFileName := fileName.
	systemFileComment := fileComment.
	systemCdExtraField := cdExtraField.
	^ 46 + systemFileName size + systemCdExtraField size + systemFileComment size

%
run
ZipArchiveMember setStamp: 'yo 2/24/2005 18:34' forMethod: #centralDirectoryHeaderSize.
true
%

category: 'accessing'
method: ZipArchiveMember
clearExtraFields
	cdExtraField := ''.
	localExtraField := ''.
%
run
ZipArchiveMember setStamp: 'nk 2/23/2001 08:00' forMethod: #clearExtraFields.
true
%

category: 'private-writing'
method: ZipArchiveMember
compressDataTo: aStream
	"Copy my deflated data to the given stream."
	| encoder startPos endPos |

	encoder := ZipWriteStream on: aStream.
	startPos := aStream position.

	[ readDataRemaining > 0 ] whileTrue: [ | data |
		data := self readRawChunk: (4096 min: readDataRemaining).
		encoder nextPutAll: data asByteArray.
		readDataRemaining := readDataRemaining - data size.
	].
	encoder finish. "not close!"
	endPos := aStream position.
	compressedSize := endPos - startPos.
	crc32 := encoder crc.

%
run
ZipArchiveMember setStamp: 'ar 2/28/2001 14:01' forMethod: #compressDataTo:.
true
%

category: 'accessing'
method: ZipArchiveMember
compressedSize
	"Return the compressed size for this member.
	This will not be set for members that were constructed from strings
	or external files until after the member has been written."
	^compressedSize
%
run
ZipArchiveMember setStamp: 'nk 2/22/2001 00:38' forMethod: #compressedSize.
true
%

category: 'accessing'
method: ZipArchiveMember
compressionMethod
	"Returns my compression method. This is the method that is
	currently being used to compress my data.

	This will be CompressionStored for added string or file members,
	or CompressionStored or CompressionDeflated (others are possible but not handled)"

	^compressionMethod
%
run
ZipArchiveMember setStamp: 'nk 2/21/2001 22:02' forMethod: #compressionMethod.
true
%

category: 'accessing'
method: ZipArchiveMember
contentStream
	"Answer my contents as a text stream.
	Default is no conversion, since we don't know what the bytes mean."

	| s |
	s := RWBinaryOrTextStream on: (String new: self uncompressedSize).
	self extractTo: s.
	s reset.
	^ s.
%
run
ZipArchiveMember setStamp: 'mir 8/5/2004 11:00' forMethod: #contentStream.
true
%

category: 'reading'
method: ZipArchiveMember
contents
	"Answer my contents as a string."
	| s |
	s := RWBinaryOrTextStream on: (String new: self uncompressedSize).
	self extractTo: s.
	s text.
	^s contents
%
run
ZipArchiveMember setStamp: 'nk 2/24/2001 22:28' forMethod: #contents.
true
%

category: 'reading'
method: ZipArchiveMember
contentsFrom: start to: finish
	"Answer my contents as a string."
	| s |
	s := RWBinaryOrTextStream on: (String new: finish - start + 1).
	self extractTo: s from: start to: finish.
	s text.
	^s contents
%
run
ZipArchiveMember setStamp: 'nk 2/24/2001 23:53' forMethod: #contentsFrom:to:.
true
%

category: 'private-writing'
method: ZipArchiveMember
copyDataTo: aStream

	compressionMethod = CompressionStored ifTrue: [ ^self copyDataWithCRCTo: aStream ].

	self copyRawDataTo: aStream.
%
run
ZipArchiveMember setStamp: 'nk 2/23/2001 11:04' forMethod: #copyDataTo:.
true
%

category: 'private-writing'
method: ZipArchiveMember
copyDataWithCRCTo: aStream
	"Copy my data to aStream. Also set the CRC-32.
	Only used when compressionMethod = desiredCompressionMethod = CompressionStored"

	uncompressedSize := compressedSize := readDataRemaining.

	crc32 := 16rFFFFFFFF.

	[ readDataRemaining > 0 ] whileTrue: [ | data |
		data := self readRawChunk: (4096 min: readDataRemaining).
		aStream nextPutAll: data.
		crc32 := ZipWriteStream updateCrc: crc32 from: 1 to: data size in: data.
		readDataRemaining := readDataRemaining - data size.
	].

	crc32 := crc32 bitXor: 16rFFFFFFFF.

%
run
ZipArchiveMember setStamp: 'nk 3/7/2004 15:42' forMethod: #copyDataWithCRCTo:.
true
%

category: 'private-writing'
method: ZipArchiveMember
copyRawDataTo: aStream

	[ readDataRemaining > 0 ] whileTrue: [ | data |
		data := self readRawChunk: (4096 min: readDataRemaining).
		aStream nextPutAll: data.
		readDataRemaining := readDataRemaining - data size.
	].

%
run
ZipArchiveMember setStamp: 'nk 2/23/2001 11:04' forMethod: #copyRawDataTo:.
true
%

category: 'private-writing'
method: ZipArchiveMember
copyRawDataTo: aStream from: start to: finish

	readDataRemaining := readDataRemaining min: finish - start + 1.

	self readRawChunk: start - 1.

	[ readDataRemaining > 0 ] whileTrue: [ | data |
		data := self readRawChunk: (32768 min: readDataRemaining).
		aStream nextPutAll: data.
		readDataRemaining := readDataRemaining - data size.
	].

%
run
ZipArchiveMember setStamp: 'nk 2/24/2001 17:57' forMethod: #copyRawDataTo:from:to:.
true
%

category: 'accessing'
method: ZipArchiveMember
crc32
	^crc32
%
run
ZipArchiveMember setStamp: 'nk 2/22/2001 00:28' forMethod: #crc32.
true
%

category: 'accessing'
method: ZipArchiveMember
crc32String
	| hexString |
	hexString := crc32 storeStringHex.
	^('00000000' copyFrom: 1 to: 11 - (hexString size)) , (hexString copyFrom: 4 to: hexString size)
%
run
ZipArchiveMember setStamp: 'BG 3/16/2005 08:19' forMethod: #crc32String.
true
%

category: 'accessing'
method: ZipArchiveMember
desiredCompressionLevel
	^desiredCompressionLevel
%
run
ZipArchiveMember setStamp: 'nk 2/21/2001 22:10' forMethod: #desiredCompressionLevel.
true
%

category: 'accessing'
method: ZipArchiveMember
desiredCompressionLevel: aNumber
	"Set my desiredCompressionLevel
	This is the method that will be used to write.
	Returns prior desiredCompressionLevel.

	Valid arguments are 0 (CompressionLevelNone) through 9,
	including 6 (CompressionLevelDefault).

	0 (CompressionLevelNone) will change the desiredCompressionMethod
	to CompressionStored. All other arguments will change the
	desiredCompressionMethod to CompressionDeflated."

	| old |
	old := desiredCompressionLevel.
	desiredCompressionLevel := aNumber.
	desiredCompressionMethod := (aNumber > 0)
		ifTrue: [ CompressionDeflated ]
		ifFalse: [ CompressionStored ].
	^old
%
run
ZipArchiveMember setStamp: 'nk 2/21/2001 22:14' forMethod: #desiredCompressionLevel:.
true
%

category: 'accessing'
method: ZipArchiveMember
desiredCompressionMethod
	"Get my desiredCompressionMethod.
	This is the method that will be used to write"

	^desiredCompressionMethod
%
run
ZipArchiveMember setStamp: 'nk 2/21/2001 22:03' forMethod: #desiredCompressionMethod.
true
%

category: 'accessing'
method: ZipArchiveMember
desiredCompressionMethod: aNumber
	"Set my desiredCompressionMethod
	This is the method that will be used to write.
	Answers prior desiredCompressionMethod.

	Only CompressionDeflated or CompressionStored are valid arguments.

	Changing to CompressionStored will change my desiredCompressionLevel
	to CompressionLevelNone; changing to CompressionDeflated will change my
	desiredCompressionLevel to CompressionLevelDefault."

	| old |
	old := desiredCompressionMethod.
	desiredCompressionMethod := aNumber.
	desiredCompressionLevel := (aNumber = CompressionDeflated)
			ifTrue: [ CompressionLevelDefault ]
			ifFalse: [ CompressionLevelNone ].
	compressionMethod = CompressionStored ifTrue: [ compressedSize := uncompressedSize ].
	^old.
%
run
ZipArchiveMember setStamp: 'nk 2/23/2001 11:25' forMethod: #desiredCompressionMethod:.
true
%

category: 'private'
method: ZipArchiveMember
dosToUnixTime: dt
	"DOS years start at 1980, Unix at 1970, and Smalltalk at 1901.
	So the Smalltalk seconds will be high by 69 years when used as Unix time:=t values.
	So shift 1980 back to 1911..."
	| year mon mday hour min sec date time |

	year := (( dt bitShift: -25 ) bitAnd: 16r7F ) + 1911.
	mon := (( dt bitShift: -21 ) bitAnd: 16r0F ).
	mday := (( dt bitShift: -16 ) bitAnd: 16r1F ).
	date := Date newDay: mday month: mon year: year.

	hour := (( dt bitShift: -11 ) bitAnd: 16r1F ).
	min := (( dt bitShift: -5 ) bitAnd: 16r3F ).
	sec := (( dt bitShift: 1 ) bitAnd: 16r3E ).
	time := ((( hour * 60 ) + min ) * 60 ) + sec.

	^date asSeconds + time

	
%
run
ZipArchiveMember setStamp: 'nk 2/21/2001 23:54' forMethod: #dosToUnixTime:.
true
%

category: 'private'
method: ZipArchiveMember
endRead
	readDataRemaining := 0.
%
run
ZipArchiveMember setStamp: 'nk 2/23/2001 08:24' forMethod: #endRead.
true
%

category: 'extraction'
method: ZipArchiveMember
extractInDirectory: dir
	self extractToFileNamed: self localFileName inDirectory: dir

%
run
ZipArchiveMember setStamp: 'nk 12/20/2002 14:49' forMethod: #extractInDirectory:.
true
%

category: 'extraction'
method: ZipArchiveMember
extractTo: aStream
	| oldCompression |
	self isEncrypted ifTrue: [ self error: 'encryption is unsupported' ].
	aStream binary.
	oldCompression := self desiredCompressionMethod: CompressionStored.
	self rewindData.
	self writeDataTo: aStream.
	self desiredCompressionMethod: oldCompression.
	self endRead.
%
run
ZipArchiveMember setStamp: 'nk 2/22/2001 18:03' forMethod: #extractTo:.
true
%

category: 'extraction'
method: ZipArchiveMember
extractTo: aStream from: start to: finish
	| oldCompression |
	self isEncrypted ifTrue: [ self error: 'encryption is unsupported' ].
	aStream binary.
	oldCompression := self desiredCompressionMethod: CompressionStored.
	self rewindData.
	self writeDataTo: aStream from: start to: finish.
	self desiredCompressionMethod: oldCompression.
	self endRead.
%
run
ZipArchiveMember setStamp: 'nk 2/24/2001 18:03' forMethod: #extractTo:from:to:.
true
%

category: 'accessing'
method: ZipArchiveMember
extractToFileNamed: aLocalFileName inDirectory: dir
	| localFile |
	self isEncrypted ifTrue: [ ^self error: 'encryption unsupported' ].
	localFile := dir / aLocalFileName.
	localFile parent ensureDirectory.
	self isDirectory 
		ifFalse: [ localFile writeStreamDo: [:stream | self extractTo: stream]]
%
run
ZipArchiveMember setStamp: 'StephaneDucasse 2/25/2010 18:08' forMethod: #extractToFileNamed:inDirectory:.
true
%

category: 'accessing'
method: ZipArchiveMember
fileComment
	^fileComment
%
run
ZipArchiveMember setStamp: 'nk 2/22/2001 00:25' forMethod: #fileComment.
true
%

category: 'accessing'
method: ZipArchiveMember
fileComment: aString
	fileComment := aString
%
run
ZipArchiveMember setStamp: 'nk 2/22/2001 00:25' forMethod: #fileComment:.
true
%

category: 'testing'
method: ZipArchiveMember
hasDataDescriptor
	^ (bitFlag bitAnd: 8)	~= 0 "GPBF:=HAS:=DATA:=DESCRIPTOR:=MASK"
%
run
ZipArchiveMember setStamp: 'nk 2/22/2001 00:40' forMethod: #hasDataDescriptor.
true
%

category: 'initialization'
method: ZipArchiveMember
initialize
	super initialize.
	lastModFileDateTime := 0.
	fileAttributeFormat := FaUnix.
	versionMadeBy := 20.
	versionNeededToExtract := 20.
	bitFlag := 0.
	compressionMethod := CompressionStored.
	desiredCompressionMethod := CompressionDeflated.
	desiredCompressionLevel := CompressionLevelDefault.
	internalFileAttributes := 0.
	externalFileAttributes := 0.
	fileName := ''.
	cdExtraField := ''.
	localExtraField := ''.
	fileComment := ''.
	crc32 := 0.
	compressedSize := 0.
	uncompressedSize := 0.
	self unixFileAttributes: DefaultFilePermissions.
%
run
ZipArchiveMember setStamp: 'nk 2/24/2001 16:16' forMethod: #initialize.
true
%

category: 'testing'
method: ZipArchiveMember
isDirectory
	^false
%
run
ZipArchiveMember setStamp: 'nk 2/22/2001 00:00' forMethod: #isDirectory.
true
%

category: 'testing'
method: ZipArchiveMember
isEncrypted
	"Return true if this member is encrypted (this is unsupported)"
	^ (bitFlag bitAnd: 1) ~= 0
%
run
ZipArchiveMember setStamp: 'nk 2/22/2001 00:39' forMethod: #isEncrypted.
true
%

category: 'testing'
method: ZipArchiveMember
isTextFile
	"Returns true if I am a text file.
	Note that this module does not currently do anything with this flag
	upon extraction or storage.
	That is, bytes are stored in native format whether or not they came
	from a text file."
	^ (internalFileAttributes bitAnd: 1) ~= 0

%
run
ZipArchiveMember setStamp: 'nk 2/22/2001 00:41' forMethod: #isTextFile.
true
%

category: 'testing'
method: ZipArchiveMember
isTextFile: aBoolean
	"Set whether I am a text file.
	Note that this module does not currently do anything with this flag
	upon extraction or storage.
	That is, bytes are stored in native format whether or not they came
	from a text file."
	internalFileAttributes := aBoolean
		ifTrue: [ internalFileAttributes bitOr: 1 ]
		ifFalse: [ internalFileAttributes bitAnd: 1 bitInvert ]

%
run
ZipArchiveMember setStamp: 'nk 2/22/2001 00:43' forMethod: #isTextFile:.
true
%

category: 'accessing'
method: ZipArchiveMember
lastModTime
	"Return my last modification date/time stamp,
	converted to Squeak seconds"

	^self unixToSqueakTime: (self dosToUnixTime: lastModFileDateTime)
%
run
ZipArchiveMember setStamp: 'nk 2/24/2001 14:34' forMethod: #lastModTime.
true
%

category: 'testing'
method: ZipArchiveMember
looksLikeDirectory
	^false
%
run
ZipArchiveMember setStamp: 'nk 2/21/2001 20:38' forMethod: #looksLikeDirectory.
true
%

category: 'private'
method: ZipArchiveMember
mapPermissionsFromUnix: unixPerms
	^ unixPerms bitShift: 16.
%
run
ZipArchiveMember setStamp: 'nk 2/21/2001 23:57' forMethod: #mapPermissionsFromUnix:.
true
%

category: 'private'
method: ZipArchiveMember
mapPermissionsToUnix: dosPerms
	^ dosPerms bitShift: -16.
%
run
ZipArchiveMember setStamp: 'nk 2/21/2001 23:58' forMethod: #mapPermissionsToUnix:.
true
%

category: 'private'
method: ZipArchiveMember
readRawChunk: n
	self subclassResponsibility
%
run
ZipArchiveMember setStamp: 'nk 2/22/2001 20:42' forMethod: #readRawChunk:.
true
%

category: 'private-writing'
method: ZipArchiveMember
refreshLocalFileHeaderTo: aStream
	"Re-writes my local header to the given stream.
	To be called after writing the data stream.
	Assumes that fileName and localExtraField sizes didn't change since last written."

	| here systemFileName |
	here := aStream position.
	systemFileName := fileName.
	aStream position: writeLocalHeaderRelativeOffset.

	aStream nextPutAll: LocalFileHeaderSignature.
	aStream nextLittleEndianNumber: 2 put: versionNeededToExtract.
	aStream nextLittleEndianNumber: 2 put: bitFlag.
	aStream nextLittleEndianNumber: 2 put: desiredCompressionMethod.
	aStream nextLittleEndianNumber: 4 put: lastModFileDateTime.
	aStream nextLittleEndianNumber: 4 put: crc32.
	aStream nextLittleEndianNumber: 4 put: (desiredCompressionMethod = CompressionStored
												ifTrue: [ uncompressedSize ] ifFalse: [ compressedSize ]).
	aStream nextLittleEndianNumber: 4 put: uncompressedSize.
	aStream nextLittleEndianNumber: 2 put: systemFileName size.
	aStream nextLittleEndianNumber: 2 put: localExtraField size.

	aStream position: here.

%
run
ZipArchiveMember setStamp: 'yo 2/24/2005 18:34' forMethod: #refreshLocalFileHeaderTo:.
true
%

category: 'private'
method: ZipArchiveMember
rewindData
	readDataRemaining :=  (desiredCompressionMethod = CompressionDeflated
		and: [ compressionMethod = CompressionDeflated ])
			ifTrue: [ compressedSize ]
			ifFalse: [ uncompressedSize ].

%
run
ZipArchiveMember setStamp: 'nk 4/28/2002 21:53' forMethod: #rewindData.
true
%

category: 'accessing'
method: ZipArchiveMember
setLastModFileDateTimeFrom: aSmalltalkTime
	| unixTime |
	unixTime := aSmalltalkTime -  2177424000.		"PST?"
	lastModFileDateTime := self unixToDosTime: unixTime
%
run
ZipArchiveMember setStamp: 'nk 2/21/2001 23:39' forMethod: #setLastModFileDateTimeFrom:.
true
%

category: 'accessing'
method: ZipArchiveMember
splitFileName
	"Answer my name split on slash boundaries. A directory will have a trailing empty string."
	^ fileName findTokens: '/'.
%
run
ZipArchiveMember setStamp: 'nk 11/11/2002 21:03' forMethod: #splitFileName.
true
%

category: 'accessing'
method: ZipArchiveMember
uncompressedSize
	"Return the uncompressed size for this member."
	^uncompressedSize
%
run
ZipArchiveMember setStamp: 'nk 2/22/2001 00:38' forMethod: #uncompressedSize.
true
%

category: 'accessing'
method: ZipArchiveMember
unixFileAttributes
	^self mapPermissionsToUnix: externalFileAttributes.
%
run
ZipArchiveMember setStamp: 'nk 2/22/2001 00:18' forMethod: #unixFileAttributes.
true
%

category: 'accessing'
method: ZipArchiveMember
unixFileAttributes: perms
	| oldPerms newPerms |
	oldPerms := self mapPermissionsToUnix: externalFileAttributes.
	newPerms :=  self isDirectory
			ifTrue: [ (perms bitAnd: FileAttrib bitInvert) bitOr: DirectoryAttrib ]
			ifFalse: [ (perms bitAnd: DirectoryAttrib bitInvert) bitOr: FileAttrib ].
	externalFileAttributes := self mapPermissionsFromUnix: newPerms.
	^oldPerms.
%
run
ZipArchiveMember setStamp: 'nk 2/22/2001 00:24' forMethod: #unixFileAttributes:.
true
%

category: 'private'
method: ZipArchiveMember
unixToDosTime: unixTime
	| dosTime dateTime secs date time |
	secs := self unixToSqueakTime: unixTime.	"Squeak time (PST?)"
	dateTime := Time dateAndTimeFromSeconds: secs.
	date := dateTime at: 1.
	time := dateTime at: 2.
	dosTime := (time seconds) bitShift: -1.
	dosTime := dosTime + ((time minutes) bitShift: 5).
	dosTime := dosTime + ((time hours) bitShift: 11).
	dosTime := dosTime + ((date dayOfMonth) bitShift: 16).
	dosTime := dosTime + ((date monthIndex) bitShift: 21).
	dosTime := dosTime + (((date year) - 1980) bitShift: 25).
	^dosTime

%
run
ZipArchiveMember setStamp: 'nk 2/22/2001 17:13' forMethod: #unixToDosTime:.
true
%

category: 'private'
method: ZipArchiveMember
unixToSqueakTime: unixTime
	^unixTime +  2177424000.		"Squeak time (PST?)"
%
run
ZipArchiveMember setStamp: 'nk 2/22/2001 13:22' forMethod: #unixToSqueakTime:.
true
%

category: 'private-writing'
method: ZipArchiveMember
writeCentralDirectoryFileHeaderTo: aStream
	"C2 v3 V4 v5 V2"

	| systemFileName systemFileComment systemCdExtraField |
	systemFileName := fileName.
	systemFileComment := fileComment.
	systemCdExtraField := cdExtraField.
	aStream nextPutAll: CentralDirectoryFileHeaderSignature.
	aStream nextLittleEndianNumber: 1 put: versionMadeBy.
	aStream nextLittleEndianNumber: 1 put: fileAttributeFormat.

	aStream nextLittleEndianNumber: 2 put: versionNeededToExtract.
	aStream nextLittleEndianNumber: 2 put: bitFlag.
	aStream nextLittleEndianNumber: 2 put: desiredCompressionMethod.

	aStream nextLittleEndianNumber: 4 put: lastModFileDateTime.

	"These next 3 should have been updated during the write of the data"
	aStream nextLittleEndianNumber: 4 put: crc32.
	aStream nextLittleEndianNumber: 4 put: (desiredCompressionMethod = CompressionStored
												ifTrue: [ uncompressedSize ] ifFalse: [ compressedSize ]).
	aStream nextLittleEndianNumber: 4 put: uncompressedSize.

	aStream nextLittleEndianNumber: 2 put: systemFileName size.
	aStream nextLittleEndianNumber: 2 put: systemCdExtraField size.
	aStream nextLittleEndianNumber: 2 put: systemFileComment size.
	aStream nextLittleEndianNumber: 2 put: 0.		"diskNumberStart"
	aStream nextLittleEndianNumber: 2 put: internalFileAttributes.

	aStream nextLittleEndianNumber: 4 put: externalFileAttributes.
	aStream nextLittleEndianNumber: 4 put: writeLocalHeaderRelativeOffset.

	aStream nextPutAll: systemFileName asByteArray.
	aStream nextPutAll: systemCdExtraField asByteArray.
	aStream nextPutAll: systemFileComment asByteArray.
%
run
ZipArchiveMember setStamp: 'yo 2/24/2005 18:34' forMethod: #writeCentralDirectoryFileHeaderTo:.
true
%

category: 'private-writing'
method: ZipArchiveMember
writeDataDescriptorTo: aStream
	"This writes a data descriptor to the given stream.
	Assumes that crc32, writeOffset, and uncompressedSize are
	set correctly (they should be after a write).
	Further, the local file header should have the
	GPBF:=HAS:=DATA:=DESCRIPTOR:=MASK (8) bit set."

	aStream nextLittleEndianNumber: 4 put: crc32.
	aStream nextLittleEndianNumber: 4 put: compressedSize.
	aStream nextLittleEndianNumber: 4 put: uncompressedSize.
%
run
ZipArchiveMember setStamp: 'nk 2/22/2001 21:53' forMethod: #writeDataDescriptorTo:.
true
%

category: 'private-writing'
method: ZipArchiveMember
writeDataTo: aStream
	"Copy my (possibly inflated or deflated) data to the given stream.
	This might do compression, decompression, or straight copying, depending
	on the values of compressionMethod and desiredCompressionMethod"

	uncompressedSize = 0 ifTrue: [ ^self ].	"nothing to do because no data"

	(compressionMethod = CompressionStored and: [ desiredCompressionMethod = CompressionDeflated ])
		ifTrue: [ ^self compressDataTo: aStream ].

	(compressionMethod = CompressionDeflated and: [ desiredCompressionMethod = CompressionStored ])
		ifTrue: [ ^self uncompressDataTo: aStream ].

	self copyDataTo: aStream.
%
run
ZipArchiveMember setStamp: 'nk 2/22/2001 20:41' forMethod: #writeDataTo:.
true
%

category: 'private-writing'
method: ZipArchiveMember
writeDataTo: aStream from: start to: finish
	"Copy my (possibly inflated or deflated) data to the given stream.
	But only the specified byte range.
	This might do decompression, or straight copying, depending
	on the values of compressionMethod and desiredCompressionMethod"

	uncompressedSize = 0 ifTrue: [ ^self ].	"nothing to do because no data"
	start > finish ifTrue: [ ^self ].
	start > uncompressedSize ifTrue: [ ^self ].

	(compressionMethod = CompressionStored and: [ desiredCompressionMethod = CompressionDeflated ])
		ifTrue: [ ^self error: 'only supports uncompression or copying right now' ].

	(compressionMethod = CompressionDeflated and: [ desiredCompressionMethod = CompressionStored ])
		ifTrue: [ ^self uncompressDataTo: aStream from: start to: finish ].

	self copyRawDataTo: aStream from: start to: finish.
%
run
ZipArchiveMember setStamp: 'nk 2/24/2001 18:01' forMethod: #writeDataTo:from:to:.
true
%

category: 'private-writing'
method: ZipArchiveMember
writeLocalFileHeaderTo: aStream
	"Write my local header to a file handle.
	Stores the offset to the start of the header in my
	writeLocalHeaderRelativeOffset member."

	| systemFileName |
	systemFileName := fileName.
	aStream nextPutAll: LocalFileHeaderSignature.
	aStream nextLittleEndianNumber: 2 put: versionNeededToExtract.
	aStream nextLittleEndianNumber: 2 put: bitFlag.
	aStream nextLittleEndianNumber: 2 put: desiredCompressionMethod.

	aStream nextLittleEndianNumber: 4 put: lastModFileDateTime.
	aStream nextLittleEndianNumber: 4 put: crc32.
	aStream nextLittleEndianNumber: 4 put: (desiredCompressionMethod = CompressionStored
												ifTrue: [ uncompressedSize ] ifFalse: [ compressedSize ]).
	aStream nextLittleEndianNumber: 4 put: uncompressedSize.

	aStream nextLittleEndianNumber: 2 put: systemFileName size.
	aStream nextLittleEndianNumber: 2 put: localExtraField size.

	aStream nextPutAll: systemFileName asByteArray.
	aStream nextPutAll: localExtraField asByteArray.

%
run
ZipArchiveMember setStamp: 'yo 2/24/2005 18:34' forMethod: #writeLocalFileHeaderTo:.
true
%

category: 'writing'
method: ZipArchiveMember
writeTo: aStream
	self rewindData.
	writeLocalHeaderRelativeOffset := aStream position.
	self writeLocalFileHeaderTo: aStream.
	self writeDataTo: aStream.
	self refreshLocalFileHeaderTo: aStream.
%
run
ZipArchiveMember setStamp: 'nk 2/23/2001 11:28' forMethod: #writeTo:.
true
%

category: 'as yet unclassified'
classmethod: ZipDirectoryMember
newNamed: aFileName
	^(self new) localFileName: aFileName; yourself
%
run
ZipDirectoryMember class setStamp: 'nk 12/20/2002 14:57' forMethod: #newNamed:.
true
%

category: 'private'
method: ZipDirectoryMember
asDirectory
	^self
%
run
ZipDirectoryMember setStamp: 'nk 2/21/2001 21:55' forMethod: #asDirectory.
true
%

category: 'accessing'
method: ZipDirectoryMember
desiredCompressionMethod: aNumber
%
run
ZipDirectoryMember setStamp: 'nk 2/23/2001 10:00' forMethod: #desiredCompressionMethod:.
true
%

category: 'initialization'
method: ZipDirectoryMember
initialize
	super initialize.
	super desiredCompressionMethod: CompressionStored.
%
run
ZipDirectoryMember setStamp: 'nk 2/23/2001 10:01' forMethod: #initialize.
true
%

category: 'testing'
method: ZipDirectoryMember
isDirectory
	^true
%
run
ZipDirectoryMember setStamp: 'nk 2/22/2001 00:00' forMethod: #isDirectory.
true
%

category: 'private'
method: ZipDirectoryMember
rewindData
%
run
ZipDirectoryMember setStamp: 'nk 3/27/2002 11:30' forMethod: #rewindData.
true
%

category: 'testing'
method: ZipDirectoryMember
usesFileNamed: aName
	^false
%
run
ZipDirectoryMember setStamp: 'nk 3/27/2002 11:29' forMethod: #usesFileNamed:.
true
%

category: 'as yet unclassified'
classmethod: ZipFileMember
newFrom: stream named: fileName
	^(self new) stream: stream externalFileName: fileName
%
run
ZipFileMember class setStamp: 'nk 2/22/2001 17:31' forMethod: #newFrom:named:.
true
%

category: 'private-reading'
method: ZipFileMember
canonicalizeFileName
	"For security reasons, make all paths relative and remove any ../ portions"

	[fileName beginsWith: '/'] whileTrue: [fileName := fileName allButFirst].
	fileName := fileName copyReplaceAll: '../' with: ''
%
run
ZipFileMember setStamp: 'nk 11/11/2002 21:46' forMethod: #canonicalizeFileName.
true
%

category: 'initialization'
method: ZipFileMember
close
	stream ifNotNil:[stream close].
%
run
ZipFileMember setStamp: 'ar 3/2/2001 18:46' forMethod: #close.
true
%

category: 'private-writing'
method: ZipFileMember
copyDataTo: aStream

	self copyRawDataTo: aStream.
%
run
ZipFileMember setStamp: 'nk 2/23/2001 11:04' forMethod: #copyDataTo:.
true
%

category: 'initialization'
method: ZipFileMember
initialize
	super initialize.
	crc32 := 0.
	localHeaderRelativeOffset := 0.
	dataOffset := 0.
%
run
ZipFileMember setStamp: 'nk 2/22/2001 16:52' forMethod: #initialize.
true
%

category: 'private-writing'
method: ZipFileMember
localHeaderRelativeOffset
	^localHeaderRelativeOffset
%
run
ZipFileMember setStamp: 'nk 3/27/2002 11:20' forMethod: #localHeaderRelativeOffset.
true
%

category: 'testing'
method: ZipFileMember
looksLikeDirectory
	^fileName last = $/
		and: [ uncompressedSize = 0 ]
%
run
ZipFileMember setStamp: 'nk 2/21/2001 21:52' forMethod: #looksLikeDirectory.
true
%

category: 'private-reading'
method: ZipFileMember
readCentralDirectoryFileHeaderFrom: aStream
	"Assumes aStream positioned after signature"

	| fileNameLength extraFieldLength fileCommentLength |

	versionMadeBy := aStream nextLittleEndianNumber: 1.
	fileAttributeFormat := aStream nextLittleEndianNumber: 1.

	versionNeededToExtract := aStream nextLittleEndianNumber: 2.
	bitFlag := aStream nextLittleEndianNumber: 2.
	compressionMethod := aStream nextLittleEndianNumber: 2.

	lastModFileDateTime := aStream nextLittleEndianNumber: 4.
	crc32 := aStream nextLittleEndianNumber: 4.
	compressedSize := aStream nextLittleEndianNumber: 4.
	uncompressedSize := aStream nextLittleEndianNumber: 4.

	fileNameLength := aStream nextLittleEndianNumber: 2.
	extraFieldLength := aStream nextLittleEndianNumber: 2.
	fileCommentLength := aStream nextLittleEndianNumber: 2.
	aStream nextLittleEndianNumber: 2. 	"disk number start"
	internalFileAttributes := aStream nextLittleEndianNumber: 2.

	externalFileAttributes := aStream nextLittleEndianNumber: 4.
	localHeaderRelativeOffset := aStream nextLittleEndianNumber: 4.

	fileName := (aStream next: fileNameLength) asString.
	cdExtraField := (aStream next: extraFieldLength) asByteArray asString.
	fileComment := (aStream next: fileCommentLength) asString.

	self desiredCompressionMethod: compressionMethod
%
run
ZipFileMember setStamp: 'yo 12/19/2003 21:15' forMethod: #readCentralDirectoryFileHeaderFrom:.
true
%

category: 'private-reading'
method: ZipFileMember
readFrom: aStream 
	"assumes aStream positioned after CD header; leaves stream positioned after my CD entry"

	self readCentralDirectoryFileHeaderFrom: aStream.
	self readLocalDirectoryFileHeaderFrom: aStream.
	self endRead.
	self canonicalizeFileName.

%
run
ZipFileMember setStamp: 'nk 11/11/2002 21:48' forMethod: #readFrom:.
true
%

category: 'private-reading'
method: ZipFileMember
readLocalDirectoryFileHeaderFrom: aStream 
	"Positions stream as necessary. Will return stream to its original position"

	| fileNameLength extraFieldLength xcrc32 xcompressedSize xuncompressedSize sig oldPos |

	oldPos := aStream position.

	aStream position: localHeaderRelativeOffset.

	sig := aStream next: 4.
	sig = LocalFileHeaderSignature asByteArray
		ifFalse: [ aStream position: oldPos.
				^self error: 'bad LH signature at ', localHeaderRelativeOffset printStringHex ].

	versionNeededToExtract := aStream nextLittleEndianNumber: 2.
	bitFlag := aStream nextLittleEndianNumber: 2.
	compressionMethod := aStream nextLittleEndianNumber: 2.

	lastModFileDateTime := aStream nextLittleEndianNumber: 4.
	xcrc32 := aStream nextLittleEndianNumber: 4.
	xcompressedSize := aStream nextLittleEndianNumber: 4.
	xuncompressedSize := aStream nextLittleEndianNumber: 4.

	fileNameLength := aStream nextLittleEndianNumber: 2.
	extraFieldLength := aStream nextLittleEndianNumber: 2.

	fileName := (aStream next: fileNameLength) asString.
	localExtraField := (aStream next: extraFieldLength) asByteArray.

	dataOffset := aStream position.

	"Don't trash these fields if we already got them from the central directory"
	self hasDataDescriptor ifFalse: [
		crc32 := xcrc32.
		compressedSize := xcompressedSize.
		uncompressedSize := xuncompressedSize.
	].

	aStream position: oldPos.
%
run
ZipFileMember setStamp: 'BG 3/16/2005 08:28' forMethod: #readLocalDirectoryFileHeaderFrom:.
true
%

category: 'private-reading'
method: ZipFileMember
readRawChunk: n
	^stream next: n
%
run
ZipFileMember setStamp: 'nk 2/22/2001 20:46' forMethod: #readRawChunk:.
true
%

category: 'private-reading'
method: ZipFileMember
rewindData
	super rewindData.
	(stream isNil or: [ stream closed ])
		ifTrue: [ self error: 'stream missing or closed' ].
	stream position: (localHeaderRelativeOffset + 4).
	self skipLocalDirectoryFileHeaderFrom: stream.
%
run
ZipFileMember setStamp: 'nk 2/23/2001 09:56' forMethod: #rewindData.
true
%

category: 'private-reading'
method: ZipFileMember
skipLocalDirectoryFileHeaderFrom: aStream 
	"Assumes that stream is positioned after signature."

	|  extraFieldLength fileNameLength |
	aStream next: 22.
	fileNameLength := aStream nextLittleEndianNumber: 2.
	extraFieldLength := aStream nextLittleEndianNumber: 2.
	aStream next: fileNameLength.
	aStream next: extraFieldLength.
	dataOffset := aStream position.

%
run
ZipFileMember setStamp: 'nk 2/23/2001 09:56' forMethod: #skipLocalDirectoryFileHeaderFrom:.
true
%

category: 'initialization'
method: ZipFileMember
stream: aStream externalFileName: aFileName
	stream := aStream.
	externalFileName := aFileName.
%
run
ZipFileMember setStamp: 'nk 2/22/2001 16:51' forMethod: #stream:externalFileName:.
true
%

category: 'private-writing'
method: ZipFileMember
uncompressDataTo: aStream

	| decoder buffer crcErrorMessage |
	decoder := ZipReadStream on: stream.
	decoder expectedCrc: self crc32.
	buffer := ByteArray new: (32768 min: readDataRemaining).
	crcErrorMessage := nil.

	[[ readDataRemaining > 0 ] whileTrue: [
		| chunkSize |
		chunkSize := 32768 min: readDataRemaining.
		buffer := decoder next: chunkSize into: buffer startingAt: 1.
		aStream next: chunkSize putAll: buffer startingAt: 1.
		readDataRemaining := readDataRemaining - chunkSize.
	]] on: CRCError do: [ :ex | crcErrorMessage := ex messageText. ex halt ].

	crcErrorMessage ifNotNil: [ self isCorrupt: true. CRCError signal: crcErrorMessage ]


%
run
ZipFileMember setStamp: 'nice 12/27/2009 20:46' forMethod: #uncompressDataTo:.
true
%

category: 'private-writing'
method: ZipFileMember
uncompressDataTo: aStream from: start to: finish

	| decoder buffer chunkSize |
	decoder := FastInflateStream on: stream.
	readDataRemaining := readDataRemaining min: finish - start + 1.
	buffer := ByteArray new: (32768 min: readDataRemaining).
	decoder next: start - 1.

	[ readDataRemaining > 0 ] whileTrue: [
		chunkSize := 32768 min: readDataRemaining.
		buffer := decoder next: chunkSize into: buffer startingAt: 1.
		aStream next: chunkSize putAll: buffer startingAt: 1.
		readDataRemaining := readDataRemaining - chunkSize.
	].

%
run
ZipFileMember setStamp: 'nk 2/24/2001 17:52' forMethod: #uncompressDataTo:from:to:.
true
%

category: 'instance creation'
classmethod: ZipNewFileMember
newNamed: aFileName
	^(self new) from: aFileName
%
run
ZipNewFileMember class setStamp: 'nk 2/22/2001 17:27' forMethod: #newNamed:.
true
%

category: 'initialization'
method: ZipNewFileMember
close
	stream ifNotNil:[stream close].
%
run
ZipNewFileMember setStamp: 'ar 3/2/2001 18:50' forMethod: #close.
true
%

category: 'initialization'
method: ZipNewFileMember
from: aFileName
	| entry |
	compressionMethod := CompressionStored.
	"Now get the size, attributes, and timestamps, and see if the file exists"
	"stream := StandardFileStream readOnlyFileNamed: aFileName."
	self localFileName: (externalFileName := stream name).
	entry := stream directoryEntry.
	compressedSize := uncompressedSize := entry fileSize.
	desiredCompressionMethod := compressedSize > 0 ifTrue: [ CompressionDeflated ] ifFalse: [ CompressionStored ].
	self setLastModFileDateTimeFrom: entry modificationTime

%
run
ZipNewFileMember setStamp: 'nk 12/20/2002 15:01' forMethod: #from:.
true
%

category: 'initialization'
method: ZipNewFileMember
initialize
	super initialize.
	externalFileName := ''.
%
run
ZipNewFileMember setStamp: 'nk 2/22/2001 16:56' forMethod: #initialize.
true
%

category: 'private'
method: ZipNewFileMember
readRawChunk: n
	^stream next: n
%
run
ZipNewFileMember setStamp: 'nk 2/22/2001 20:48' forMethod: #readRawChunk:.
true
%

category: 'private-writing'
method: ZipNewFileMember
rewindData
	super rewindData.
	readDataRemaining := stream size.
	stream position: 0.
%
run
ZipNewFileMember setStamp: 'nk 2/23/2001 09:58' forMethod: #rewindData.
true
%

category: 'as yet unclassified'
classmethod: ZipStringMember
newFrom: aString named: aFileName
	^(self new) contents: aString; localFileName: aFileName; yourself
%
run
ZipStringMember class setStamp: 'nk 12/20/2002 15:06' forMethod: #newFrom:named:.
true
%

category: 'initialization'
method: ZipStringMember
contents
	^contents
%
run
ZipStringMember setStamp: 'nk 2/22/2001 16:47' forMethod: #contents.
true
%

category: 'initialization'
method: ZipStringMember
contents: aString
	contents := aString.
	compressedSize := uncompressedSize := aString size.
	"set the file date to now"
	self setLastModFileDateTimeFrom: Time totalSeconds
%
run
ZipStringMember setStamp: 'nk 2/22/2001 20:50' forMethod: #contents:.
true
%

category: 'initialization'
method: ZipStringMember
initialize
	super initialize.
	self contents: ''.
	compressionMethod := desiredCompressionMethod := CompressionStored.

%
run
ZipStringMember setStamp: 'nk 2/22/2001 20:50' forMethod: #initialize.
true
%

category: 'private'
method: ZipStringMember
readRawChunk: n
	^stream next: n
%
run
ZipStringMember setStamp: 'nk 2/22/2001 20:51' forMethod: #readRawChunk:.
true
%

category: 'private-writing'
method: ZipStringMember
rewindData
	super rewindData.
	stream := AnsiReadStream on: contents.
	readDataRemaining := contents size
%
run
ZipStringMember setStamp: 'damiencassou 5/30/2008 16:16' forMethod: #rewindData.
true
%

category: 'instance creation'
classmethod: ZipEncoderNode
value: v frequency: f height: h
	^self new setValue: v frequency: f height: h
%
run
ZipEncoderNode class setStamp: 'ar 12/26/1999 10:47' forMethod: #value:frequency:height:.
true
%

category: 'accessing'
method: ZipEncoderNode
bitLength
	^bitLength ifNil:[0]
%
run
ZipEncoderNode setStamp: 'ar 12/25/1999 19:41' forMethod: #bitLength.
true
%

category: 'accessing'
method: ZipEncoderNode
code
	^code ifNil:[0]
%
run
ZipEncoderNode setStamp: 'ar 12/30/1999 14:28' forMethod: #code.
true
%

category: 'accessing'
method: ZipEncoderNode
code: aCode
	(aCode >= 0 and:[(1 bitShift: bitLength) > aCode]) ifFalse: [ self error: 'Failed assertion' ].
	code := aCode.
%
run
ZipEncoderNode setStamp: 'jannik.laval 5/1/2010 16:49' forMethod: #code:.
true
%

category: 'private'
method: ZipEncoderNode
computeHeight
	^self isLeaf
		ifTrue:[height := 0]
		ifFalse:[height := (left computeHeight max: right computeHeight) + 1].
%
run
ZipEncoderNode setStamp: 'ar 12/26/1999 10:45' forMethod: #computeHeight.
true
%

category: 'encoding'
method: ZipEncoderNode
encodeBitLength: blCounts from: aTree
	| index |
	"Note: If bitLength is not nil then the tree must be broken"
	bitLength isNil ifFalse:[self error:'Huffman tree is broken'].
	parent  
		ifNil: [bitLength := 0]
		ifNotNil:[bitLength := parent bitLength + 1].
	self isLeaf ifTrue:[
		index := bitLength + 1.
		blCounts at: index put: (blCounts at: index) + 1.
	] ifFalse:[
		left encodeBitLength: blCounts from: aTree.
		right encodeBitLength: blCounts from: aTree.
	].
%
run
ZipEncoderNode setStamp: 'marcus.denker 9/14/2008 19:01' forMethod: #encodeBitLength:from:.
true
%

category: 'accessing'
method: ZipEncoderNode
frequency
	^frequency
%
run
ZipEncoderNode setStamp: 'ar 12/24/1999 23:36' forMethod: #frequency.
true
%

category: 'accessing'
method: ZipEncoderNode
frequency: aNumber
	frequency := aNumber
%
run
ZipEncoderNode setStamp: 'ar 12/28/1999 00:56' forMethod: #frequency:.
true
%

category: 'accessing'
method: ZipEncoderNode
height
	^height
%
run
ZipEncoderNode setStamp: 'ar 12/26/1999 10:44' forMethod: #height.
true
%

category: 'testing'
method: ZipEncoderNode
isLeaf
	^left isNil
%
run
ZipEncoderNode setStamp: 'marcus.denker 9/14/2008 19:00' forMethod: #isLeaf.
true
%

category: 'private'
method: ZipEncoderNode
leafNodes
	self isLeaf
		ifTrue:[^Array with: self]
		ifFalse:[^left leafNodes, right leafNodes]
%
run
ZipEncoderNode setStamp: 'ar 12/25/1999 18:14' forMethod: #leafNodes.
true
%

category: 'accessing'
method: ZipEncoderNode
left
	^left
%
run
ZipEncoderNode setStamp: 'ar 12/24/1999 23:43' forMethod: #left.
true
%

category: 'accessing'
method: ZipEncoderNode
left: aNode
	aNode parent: self.
	left := aNode.
%
run
ZipEncoderNode setStamp: 'ar 12/25/1999 20:06' forMethod: #left:.
true
%

category: 'accessing'
method: ZipEncoderNode
parent
	^parent
%
run
ZipEncoderNode setStamp: 'ar 12/24/1999 23:43' forMethod: #parent.
true
%

category: 'accessing'
method: ZipEncoderNode
parent: aNode
	parent := aNode
%
run
ZipEncoderNode setStamp: 'ar 12/24/1999 23:43' forMethod: #parent:.
true
%

category: 'printing'
method: ZipEncoderNode
printOn: aStream
	super printOn: aStream.
	aStream nextPut:$(;
		nextPutAll:'value = '; print: value;
		nextPutAll:', freq = '; print: frequency;
		nextPutAll:', bitLength = '; print: bitLength;
		nextPutAll:', code = '; print: code;
		nextPutAll:', height = '; print: height; 
	nextPut:$).
%
run
ZipEncoderNode setStamp: 'ar 12/26/1999 10:46' forMethod: #printOn:.
true
%

category: 'accessing'
method: ZipEncoderNode
right
	^right
%
run
ZipEncoderNode setStamp: 'ar 12/24/1999 23:43' forMethod: #right.
true
%

category: 'accessing'
method: ZipEncoderNode
right: aNode
	aNode parent: self.
	right := aNode.
%
run
ZipEncoderNode setStamp: 'ar 12/25/1999 20:06' forMethod: #right:.
true
%

category: 'encoding'
method: ZipEncoderNode
rotateToHeight: maxHeight
	"Rotate the tree to achieve maxHeight depth"
	| newParent |
	height < 4 ifTrue:[^self].
	self left: (left rotateToHeight: maxHeight-1).
	self right: (right rotateToHeight: maxHeight-1).
	height := (left height max: right height) + 1.
	height <= maxHeight ifTrue:[^self].
	(left height - right height) abs <= 2 ifTrue:[^self].
	left height < right height ifTrue:[
		right right height >= right left height ifTrue:[
			newParent := right.
			self right: newParent left.
			newParent left: self.
		] ifFalse:[
			newParent := right left.
			right left: newParent right.
			newParent right: right.
			self right: newParent left.
			newParent left: self.
		].
	] ifFalse:[
		left left height >= left right height ifTrue:[
			newParent := left.
			self left: newParent right.
			newParent right: self.
		] ifFalse:[
			newParent := left right.
			left right: newParent left.
			newParent left: left.
			self left: newParent right.
			newParent right: self.
		].
	].
	parent computeHeight.
	^parent
%
run
ZipEncoderNode setStamp: 'ar 12/27/1999 14:27' forMethod: #rotateToHeight:.
true
%

category: 'private'
method: ZipEncoderNode
setBitLengthTo: bl
	bitLength := bl
%
run
ZipEncoderNode setStamp: 'ar 12/26/1999 12:05' forMethod: #setBitLengthTo:.
true
%

category: 'private'
method: ZipEncoderNode
setValue: v frequency: f height: h
	value := v.
	frequency := f.
	height := h.
%
run
ZipEncoderNode setStamp: 'ar 12/26/1999 10:46' forMethod: #setValue:frequency:height:.
true
%

category: 'accessing'
method: ZipEncoderNode
value
	^value
%
run
ZipEncoderNode setStamp: 'ar 12/24/1999 23:43' forMethod: #value.
true
%

category: 'instance creation'
classmethod: ZipEncoderTree
buildTreeFrom: frequencies maxDepth: depth
	^self new buildTreeFrom: frequencies maxDepth: depth
%
run
ZipEncoderTree class setStamp: 'ar 12/30/1999 01:25' forMethod: #buildTreeFrom:maxDepth:.
true
%

category: 'accessing'
method: ZipEncoderTree
bitLengthAt: index
	^bitLengths at: index+1
%
run
ZipEncoderTree setStamp: 'ar 12/30/1999 01:43' forMethod: #bitLengthAt:.
true
%

category: 'accessing'
method: ZipEncoderTree
bitLengths
	"Return an array of all bitLength values for valid codes"
	^bitLengths
%
run
ZipEncoderTree setStamp: 'ar 12/30/1999 01:32' forMethod: #bitLengths.
true
%

category: 'private'
method: ZipEncoderTree
bitLengths: blArray codes: codeArray
	bitLengths := blArray copy. "as: WordArray."
	codes := codeArray copy. "as: WordArray."
	((self bitLengthAt: maxCode) > 0) ifFalse: [ self error: 'Failed assertion' ].
%
run
ZipEncoderTree setStamp: 'jannik.laval 5/1/2010 16:50' forMethod: #bitLengths:codes:.
true
%

category: 'encoding'
method: ZipEncoderTree
buildCodes: nodeList counts: blCounts maxDepth: depth
	"Build the codes for all nodes"
	| nextCode code node length |
	nextCode := WordArray new: depth+1.
	code := 0.
	1 to: depth do:[:bits|
		code := (code + (blCounts at: bits)) bitShift: 1.
		nextCode at: bits+1 put: code].
	((code + (blCounts at: depth+1) - 1) = ((1 bitShift: depth) - 1)) ifFalse: [ self error: 'Failed assertion' ].
	0 to: maxCode do:[:n|
		node := nodeList at: n+1.
		length := node bitLength.
		length = 0 ifFalse:[
			code := nextCode at: length+1.
			node code: (self reverseBits: code length: length).
			nextCode at: length+1 put: code+1.
		].
	].
%
run
ZipEncoderTree setStamp: 'jannik.laval 5/1/2010 16:50' forMethod: #buildCodes:counts:maxDepth:.
true
%

category: 'encoding'
method: ZipEncoderTree
buildHierarchyFrom: aHeap
	"Build the node hierarchy based on the leafs in aHeap"
	| left right parent |
	[aHeap size > 1] whileTrue:[
		left := aHeap removeFirst.
		right := aHeap removeFirst.
		parent := ZipEncoderNode value: -1 
			frequency: (left frequency + right frequency)
			height: (left height max: right height) + 1.
		left parent: parent.
		right parent: parent.
		parent left: left.
		parent right: right.
		aHeap add: parent].
	^aHeap removeFirst

%
run
ZipEncoderTree setStamp: 'ar 12/26/1999 10:42' forMethod: #buildHierarchyFrom:.
true
%

category: 'encoding'
method: ZipEncoderTree
buildTree: nodeList maxDepth: depth
	"Build either the literal or the distance tree"
	| heap rootNode blCounts |
	heap := SortedCollection new: nodeList size // 3.
	heap sortBlock: self nodeSortBlock.
	"Find all nodes with non-zero frequency and add to heap"
	maxCode := 0.
	nodeList do:[:dNode|
		dNode frequency = 0 ifFalse:[
			maxCode := dNode value.
			heap add: dNode]].
	"The pkzip format requires that at least one distance code exists,
	and that at least one bit should be sent even if there is only one
	possible code. So to avoid special checks later on we force at least
	two codes of non zero frequency."
	heap size = 0 ifTrue:[
		(maxCode = 0) ifFalse: [ self error: 'Failed assertion' ].
		heap add: (nodeList at: 1).
		heap add: (nodeList at: 2).
		maxCode := 1].
	heap size = 1 ifTrue:[
		(nodeList at: 1) frequency = 0
			ifTrue:[heap add: (nodeList at: 1)]
			ifFalse:[heap add: (nodeList at: 2)].
		maxCode := maxCode max: 1].
	rootNode := self buildHierarchyFrom: heap.
	rootNode height > depth ifTrue:[
		rootNode := rootNode rotateToHeight: depth.
		rootNode height > depth ifTrue:[self error:'Cannot encode tree']].
	blCounts := WordArray new: depth+1.
	rootNode encodeBitLength: blCounts from: self.
	self buildCodes: nodeList counts: blCounts maxDepth: depth.
	self setValuesFrom: nodeList.
%
run
ZipEncoderTree setStamp: 'jannik.laval 5/1/2010 16:50' forMethod: #buildTree:maxDepth:.
true
%

category: 'encoding'
method: ZipEncoderTree
buildTreeFrom: frequencies maxDepth: depth
	"Build the receiver from the given frequency values"
	| nodeList |
	nodeList := Array new: frequencies size.
	1 to: frequencies size do:[:i|
		nodeList at: i put: (ZipEncoderNode value: i-1 frequency: (frequencies at: i) height: 0)
	].
	self buildTree: nodeList maxDepth: depth.
%
run
ZipEncoderTree setStamp: 'ar 12/30/1999 01:24' forMethod: #buildTreeFrom:maxDepth:.
true
%

category: 'accessing'
method: ZipEncoderTree
codeAt: index
	^codes at: index+1
%
run
ZipEncoderTree setStamp: 'ar 12/30/1999 01:04' forMethod: #codeAt:.
true
%

category: 'accessing'
method: ZipEncoderTree
codes
	"Return an array of all valid codes"
	^codes
%
run
ZipEncoderTree setStamp: 'ar 12/30/1999 01:24' forMethod: #codes.
true
%

category: 'accessing'
method: ZipEncoderTree
maxCode
	^maxCode
%
run
ZipEncoderTree setStamp: 'ar 12/25/1999 17:15' forMethod: #maxCode.
true
%

category: 'accessing'
method: ZipEncoderTree
maxCode: aNumber
	maxCode := aNumber.
%
run
ZipEncoderTree setStamp: 'ar 12/25/1999 21:45' forMethod: #maxCode:.
true
%

category: 'encoding'
method: ZipEncoderTree
nodeSortBlock
	^[:n1 :n2|
		n1 frequency = n2 frequency
			ifTrue:[n1 height <= n2 height]
			ifFalse:[n1 frequency <= n2 frequency]].
%
run
ZipEncoderTree setStamp: 'ar 12/26/1999 10:42' forMethod: #nodeSortBlock.
true
%

category: 'private'
method: ZipEncoderTree
reverseBits: code length: length
	"Bit reverse the given code"
	| result bit bits |
	result := 0.
	bits := code.
	1 to: length do:[:i|
		bit := bits bitAnd: 1.
		result := (result bitShift: 1) bitOr: bit.
		bits := bits bitShift: -1].
	^result
%
run
ZipEncoderTree setStamp: 'ar 12/26/1999 11:02' forMethod: #reverseBits:length:.
true
%

category: 'private'
method: ZipEncoderTree
setValuesFrom: nodeList
	self bitLengths: (nodeList
			collect: [:n | n bitLength]
			from: 1
			to: maxCode + 1)
		codes: (nodeList
				collect: [:n | n code]
				from: 1
				to: maxCode + 1)
%
run
ZipEncoderTree setStamp: 'sma 6/1/2000 11:52' forMethod: #setValuesFrom:.
true
%

category: 'initialization'
classmethod: FastInflateStream
initialize
	"FastInflateStream initialize"
	| low high |

	"Init literal/length map"
	low := #(3 4 5 6 7 8 9 10 11 13 15 17 19 23 27 31 35 43 51 59 67 83 99 115 131 163 195 227 258 ).
	high := #(0 0 0 0 0 0 0 0 1 1 1 1 2 2 2 2 3 3 3 3 4 4 4 4 5 5 5 5 0 0).
	LiteralLengthMap := WordArray new: 256 + 32.
	1 to: 257 do:[:i| LiteralLengthMap at: i put: i-1].
	1 to: 29 do:[:i| LiteralLengthMap at: 257+i put: (low at:i) + ( ((high at: i) + 1 )bitShift: 16)].

	"Init distance map"
	high := #(0 0 0 0 1 1 2 2 3 3 4 4 5 5 6 6 7 7 8 8 9 9 10 10 11 11 12 12 13 13).
	low := #(1 2 3 4 5 7 9 13 17 25 33 49 65 97 129 193 257 385 513 769
			1025 1537 2049 3073 4097 6145 8193 12289 16385 24577).
	DistanceMap := WordArray new: 32.
	1 to: 30 do:[:i| DistanceMap at: i put: (low at: i) + ( (high at: i) bitShift: 16)].

	"Init fixed block huffman tables"
	FixedLitTable := self basicNew
				huffmanTableFrom: FixedLitCodes
				mappedBy: LiteralLengthMap.
	FixedDistTable := self basicNew
				huffmanTableFrom: FixedDistCodes
				mappedBy: DistanceMap.
%
run
FastInflateStream class setStamp: 'ar 12/21/1999 23:00' forMethod: #initialize.
true
%

category: 'inflating'
method: FastInflateStream
decompressBlock: llTable with: dTable
	"Process the compressed data in the block.
	llTable is the huffman table for literal/length codes
	and dTable is the huffman table for distance codes."
	| value extra length distance oldPos oldBits oldBitPos |
	[self _readLimit < self _collection size and:[sourcePos <= sourceLimit]] whileTrue:[
		"Back up stuff if we're running out of space"
		oldBits := bitBuf.
		oldBitPos := bitPos.
		oldPos := sourcePos.
		value := self decodeValueFrom: llTable.
		value < 256 ifTrue:[ "A literal"
			self _collection byteAt: (self _readLimit: self _readLimit + 1) put: value.
		] ifFalse:["length/distance or end of block"
			value = 256 ifTrue:["End of block"
				state := state bitAnd: StateNoMoreData.
				^self].
			"Compute the actual length value (including possible extra bits)"
			extra := (value bitShift: -16) - 1.
			length := value bitAnd: 16rFFFF.
			extra > 0 ifTrue:[length := length + (self nextBits: extra)].
			"Compute the distance value"
			value := self decodeValueFrom: dTable.
			extra := (value bitShift: -16).
			distance := value bitAnd: 16rFFFF.
			extra > 0 ifTrue:[distance := distance + (self nextBits: extra)].
			(self _readLimit + length >= self _collection size) ifTrue:[
				bitBuf := oldBits.
				bitPos := oldBitPos.
				sourcePos := oldPos.
				^self].
			self _collection 
					squeakReplaceFrom: self _readLimit+1 
					to: self _readLimit + length + 1 
					with: self _collection 
					startingAt: self _readLimit - distance + 1.
			self _readLimit: self _readLimit + length.
		].
	].
%
run
FastInflateStream setStamp: 'DaleHenrichs 10/11/2010 15:23' forMethod: #decompressBlock:with:.
true
%

category: 'huffman trees'
method: FastInflateStream
distanceMap
	^DistanceMap
%
run
FastInflateStream setStamp: 'ar 12/4/1998 02:26' forMethod: #distanceMap.
true
%

category: 'huffman trees'
method: FastInflateStream
increment: value bits: nBits
	"Increment value in reverse bit order, e.g. 
	for a 3 bit value count as follows:
		000 / 100 / 010 / 110
		001 / 101 / 011 / 111
	See the class comment why we need this."
	| result bit |
	result := value.
	"Test the lowest bit first"
	bit := 1 bitShift: (nBits - 1).
	"If the currently tested bit is set then we need to
	turn this bit off and test the next bit right to it"
	[(result bitAnd: bit) = 0] whileFalse:[ 
		"Turn off current bit"
		result := result bitXor: bit.
		"And continue testing the next bit"
		bit := bit bitShift: -1].
	"Turn on the right-most bit that we haven't touched in the loop above"
	^result bitXor: bit
%
run
FastInflateStream setStamp: 'ar 12/4/1998 01:48' forMethod: #increment:bits:.
true
%

category: 'huffman trees'
method: FastInflateStream
literalLengthMap
	^LiteralLengthMap
%
run
FastInflateStream setStamp: 'ar 12/4/1998 02:26' forMethod: #literalLengthMap.
true
%

category: 'bit access'
method: FastInflateStream
nextSingleBits: n
	"Fetch the bits all at once"
	^self nextBits: n.
%
run
FastInflateStream setStamp: 'ar 12/4/1998 02:02' forMethod: #nextSingleBits:.
true
%

category: 'inflating'
method: FastInflateStream
processFixedBlock
	litTable := FixedLitTable.
	distTable := FixedDistTable.
	state := state bitOr: BlockProceedBit.
	self proceedFixedBlock.
%
run
FastInflateStream setStamp: 'ar 12/4/1998 19:15' forMethod: #processFixedBlock.
true
%

category: 'crc'
method: ZipReadStream
expectedCrc: aNumberOrNil
	"If expectedCrc is set, it will be compared against the calculated CRC32 in verifyCrc.
	This number should be the number read from the Zip header (which is the bitwise complement of my crc if all is working correctly)"
	expectedCrc := aNumberOrNil
%
run
ZipReadStream setStamp: 'nk 3/7/2004 18:55' forMethod: #expectedCrc:.
true
%

category: 'initialize'
method: ZipReadStream
on: aCollection from: firstIndex to: lastIndex
	super on: aCollection from: firstIndex to: lastIndex.
	crc := 16rFFFFFFFF.
	expectedCrc := nil.
%
run
ZipReadStream setStamp: 'nk 3/7/2004 15:31' forMethod: #on:from:to:.
true
%

category: 'crc'
method: ZipReadStream
updateCrc: oldCrc from: start to: stop in: aCollection
	^ZipWriteStream updateCrc: oldCrc from: start to: stop in: aCollection
%
run
ZipReadStream setStamp: 'nk 3/7/2004 15:32' forMethod: #updateCrc:from:to:in:.
true
%

category: 'crc'
method: ZipReadStream
verifyCrc
	"Verify the CRC-32 checksum calculated from the input against the expected CRC-32, if any.
	Answer the calculated CRC-32 in any case.
	Note that the CRC-32 used in Zip files is actually the bit inverse of the calculated value, so that is what is returned."

	| invertedCrc |
	invertedCrc := crc bitXor: 16rFFFFFFFF.
	(expectedCrc notNil and: [ expectedCrc ~= invertedCrc ])
		ifTrue: [ ^ self crcError: ('Wrong CRC-32 (expected ', expectedCrc asHexString printString, '  got ', invertedCrc asHexString printString , ' ) (proceed to ignore)' ) ].
	^invertedCrc
%
run
ZipReadStream setStamp: 'BG 3/16/2005 08:28' forMethod: #verifyCrc.
true
%

category: 'initialization'
classmethod: InflateStream
initialize
	"InflateStream initialize"
	MaxBits := 16.
	StateNewBlock := 0.
	StateNoMoreData := 1.
	BlockProceedBit := 8.
	BlockTypes := #(	processStoredBlock	"New block in stored format"
					processFixedBlock	"New block with fixed huffman tables"
					processDynamicBlock	"New block with dynamic huffman tables"
					errorBadBlock		"Bad block format"
					proceedStoredBlock	"Continue block in stored format"
					proceedFixedBlock	"Continue block in fixed format"
					proceedDynamicBlock	"Continue block in dynamic format"
					errorBadBlock		"Bad block format").
	"Initialize fixed block values"
	FixedLitCodes := 	((1 to: 144) collect:[:i| 8]),
					((145 to: 256) collect:[:i| 9]),
					((257 to: 280) collect:[:i| 7]),
					((281 to: 288) collect:[:i| 8]).
	FixedDistCodes := ((1 to: 32) collect:[:i| 5]).
%
run
InflateStream class setStamp: 'stephane.ducasse 6/14/2009 22:47' forMethod: #initialize.
true
%

category: 'testing'
method: InflateStream
atEnd
	"Note: It is possible that we have a few bits left,
	representing just the EOB marker. To check for
	this we must force decompression of the next
	block if at end of data."
	position < self _readLimit ifTrue:[^false]. "Primitive test"
	(self position >= self _readLimit and:[state = StateNoMoreData]) ifTrue:[^true].
	"Force decompression, by calling #next. Since #moveContentsToFront
	will never move data to the beginning of the buffer it is safe to
	skip back the read position afterwards"
	self next ifNil: [^true].
	self _position: self position - 1.
	^false
%
run
InflateStream setStamp: 'DaleHenrichs 10/11/2010 15:31' forMethod: #atEnd.
true
%

category: 'bit access'
method: InflateStream
bitPosition
	"Return the current bit position of the source"
	sourceStream == nil
		ifTrue:[^sourcePos * 8 + bitPos]
		ifFalse:[^sourceStream position + sourcePos * 8 + bitPos]
%
run
InflateStream setStamp: 'ar 12/27/1999 13:47' forMethod: #bitPosition.
true
%

category: 'accessing'
method: InflateStream
close
	sourceStream ifNotNil:[sourceStream close].
%
run
InflateStream setStamp: 'ar 12/23/1999 15:31' forMethod: #close.
true
%

category: 'huffman trees'
method: InflateStream
computeHuffmanValues: aCollection counts: counts from: minBits to: maxBits
	"Assign numerical values to all codes.
	Note: The values are stored according to the bit length"
	| offsets values baseOffset codeLength |
	offsets := Array new: maxBits.
	offsets atAllPut: 0.
	baseOffset := 1.
	minBits to: maxBits do:[:bits|
		offsets at: bits put: baseOffset.
		baseOffset := baseOffset + (counts at: bits+1)].
	values := WordArray new: aCollection size.
	1 to: aCollection size do:[:i|
		codeLength := aCollection at: i.
		codeLength > 0 ifTrue:[
			baseOffset := offsets at: codeLength.
			values at: baseOffset put: i-1.
			offsets at: codeLength put: baseOffset + 1]].
	^values
%
run
InflateStream setStamp: 'ar 12/21/1999 22:59' forMethod: #computeHuffmanValues:counts:from:to:.
true
%

category: 'accessing'
method: InflateStream
contents

	^ self upToEnd
%
run
InflateStream setStamp: 'tk 2/4/2000 10:26' forMethod: #contents.
true
%

category: 'crc'
method: InflateStream
crcError: aString
	^CRCError signal: aString
%
run
InflateStream setStamp: 'ar 2/29/2004 04:04' forMethod: #crcError:.
true
%

category: 'huffman trees'
method: InflateStream
createHuffmanTables: values counts: counts from: minBits to: maxBits
	"Create the actual tables"
	| table tableStart tableSize tableEnd 
	valueIndex tableStack numValues deltaBits maxEntries
	lastTable lastTableStart tableIndex lastTableIndex |

	table := WordArray new: ((4 bitShift: minBits) max: 16).

	"Create the first entry - this is a dummy.
	It gives us information about how many bits to fetch initially."
	table at: 1 put: (minBits bitShift: 24) + 2. "First actual table starts at index 2"

	"Create the first table from scratch."
	tableStart := 2. "See above"
	tableSize := 1 bitShift: minBits.
	tableEnd := tableStart + tableSize.
	"Store the terminal symbols"
	valueIndex := (counts at: minBits+1).
	tableIndex := 0.
	1 to: valueIndex do:[:i|
		table at: tableStart + tableIndex put: (values at: i).
		tableIndex := self increment: tableIndex bits: minBits].
	"Fill up remaining entries with invalid entries"
	tableStack := OrderedCollection new: 10. "Should be more than enough"
	tableStack addLast: 
		{minBits	"Number of bits (e.g., depth) for this table".
		 tableStart	"Start of table".
		 tableIndex "Next index in table".
		 minBits	"Number of delta bits encoded in table".
		 tableSize - valueIndex "Entries remaining in table".}.
	"Go to next value index"
	valueIndex := valueIndex + 1.
	"Walk over remaining bit lengths and create new subtables"
	minBits+1 to: maxBits do:[:bits|
		numValues := counts at: bits+1.
		[numValues > 0] whileTrue:["Create a new subtable"
			lastTable := tableStack last.
			lastTableStart := lastTable at: 2.
			lastTableIndex := lastTable at: 3.
			deltaBits := bits - (lastTable at: 1).
			"Make up a table of deltaBits size"
			tableSize := 1 bitShift: deltaBits.
			tableStart := tableEnd.
			tableEnd := tableEnd + tableSize.
			[tableEnd > table size ]
				whileTrue:[table := self growHuffmanTable: table].
			"Connect to last table"
			((table at: lastTableStart + lastTableIndex) = 0) ifFalse: [ self error: 'Failed assertion' ]."Entry must be unused"
			table at: lastTableStart + lastTableIndex put: (deltaBits bitShift: 24) + tableStart.
			lastTable at: 3 put: (self increment: lastTableIndex bits: (lastTable at: 4)).
			lastTable at: 5 put: (lastTable at: 5) - 1.
			((lastTable at: 5) >= 0) ifFalse: [ self error: 'Failed assertion' ]. "Don't exceed tableSize"
			"Store terminal values"
			maxEntries := numValues min: tableSize.
			tableIndex := 0.
			1 to: maxEntries do:[:i|
				table at: tableStart + tableIndex put: (values at: valueIndex).
				valueIndex := valueIndex + 1.
				numValues := numValues - 1.
				tableIndex := self increment: tableIndex bits: deltaBits].
			"Check if we have filled up the current table completely"
			maxEntries = tableSize ifTrue:[
				"Table has been filled. Back up to the last table with space left."
				[tableStack isEmpty not and:[(tableStack last at: 5) = 0]]
						whileTrue:[tableStack removeLast].
			] ifFalse:[
				"Table not yet filled. Put it back on the stack."
				tableStack addLast:
					{bits		"Nr. of bits in this table".
					 tableStart	"Start of table".
					 tableIndex "Index in table".
					 deltaBits	"delta bits of table".
					 tableSize - maxEntries "Unused entries in table".}.
			].
		].
	].
	 ^table copyFrom: 1 to: tableEnd-1
%
run
InflateStream setStamp: 'jannik.laval 5/1/2010 17:03' forMethod: #createHuffmanTables:counts:from:to:.
true
%

category: 'huffman trees'
method: InflateStream
decodeDynamicTable: nItems from: aHuffmanTable
	"Decode the code length of the literal/length and distance table
	in a block compressed with dynamic huffman trees"
	| values index value repCount theValue |
	values := Array new: nItems.
	index := 1.
	theValue := 0.
	[index <= nItems] whileTrue:[
		value := self decodeValueFrom: aHuffmanTable.
		value < 16 ifTrue:[
			"Immediate values"
			theValue := value.
			values at: index put: value.
			index := index+1.
		] ifFalse:[
			"Repeated values"
			value = 16 ifTrue:[
				"Repeat last value"
				repCount := (self nextBits: 2) + 3.
			] ifFalse:[
				"Repeat zero value"
				theValue := 0.
				value = 17 
					ifTrue:[repCount := (self nextBits: 3) + 3]
					ifFalse:[value = 18 
								ifTrue:[repCount := (self nextBits: 7) + 11]
								ifFalse:[^self error:'Invalid bits tree value']]].
			0 to: repCount-1 do:[:i| values at: index+i put: theValue].
			index := index + repCount].
	].
	^values
%
run
InflateStream setStamp: 'ar 12/4/1998 02:25' forMethod: #decodeDynamicTable:from:.
true
%

category: 'inflating'
method: InflateStream
decodeValueFrom: table
	"Decode the next value in the receiver using the given huffman table."
	| bits bitsNeeded tableIndex value |
	bitsNeeded := (table at: 1) bitShift: -24.	"Initial bits needed"
	tableIndex := 2.							"First real table"
	[bits := self nextSingleBits: bitsNeeded.	"Get bits"
	value := table at: (tableIndex + bits).		"Lookup entry in table"
	(value bitAnd: 16r3F000000) = 0] 			"Check if it is a non-leaf node"
		whileFalse:["Fetch sub table"
			tableIndex := value bitAnd: 16rFFFF.	"Table offset in low 16 bit"
			bitsNeeded := (value bitShift: -24) bitAnd: 255. "Additional bits in high 8 bit"
			bitsNeeded > MaxBits ifTrue:[^self error:'Invalid huffman table entry']].
	^value
%
run
InflateStream setStamp: 'ar 12/4/1998 02:24' forMethod: #decodeValueFrom:.
true
%

category: 'private'
method: InflateStream
decompressAll
	"Profile the decompression speed"
	[self atEnd] whileFalse:[
		self _position: self _readLimit.
		self next "Provokes decompression"
	].
%
run
InflateStream setStamp: 'DaleHenrichs 10/11/2010 15:32' forMethod: #decompressAll.
true
%

category: 'inflating'
method: InflateStream
decompressBlock: llTable with: dTable
	"Process the compressed data in the block.
	llTable is the huffman table for literal/length codes
	and dTable is the huffman table for distance codes."
	| value extra length distance oldPos oldBits oldBitPos |
	[self _readLimit < self _collection size and:[sourcePos <= sourceLimit]] whileTrue:[
		"Back up stuff if we're running out of space"
		oldBits := bitBuf.
		oldBitPos := bitPos.
		oldPos := sourcePos.
		value := self decodeValueFrom: llTable.
		value < 256 ifTrue:[ "A literal"
			self _collection byteAt: (self _readLimit: self _readLimit + 1) put: value.
		] ifFalse:["length/distance or end of block"
			value = 256 ifTrue:["End of block"
				state := state bitAnd: StateNoMoreData.
				^self].
			"Compute the actual length value (including possible extra bits)"
			extra := #(0 0 0 0 0 0 0 0 1 1 1 1 2 2 2 2 3 3 3 3 4 4 4 4 5 5 5 5 0) at: value - 256.
			length := #(3 4 5 6 7 8 9 10 11 13 15 17 19 23 27 31 35 43 51 59 67 83 99 115 131 163 195 227 258) at: value - 256.
			extra > 0 ifTrue:[length := length + (self nextBits: extra)].
			"Compute the distance value"
			value := self decodeValueFrom: dTable.
			extra := #(0 0 0 0 1 1 2 2 3 3 4 4 5 5 6 6 7 7 8 8 9 9 10 10 11 11 12 12 13 13) at: value+1.
			distance := #(1 2 3 4 5 7 9 13 17 25 33 49 65 97 129 193 257 385 513 769
						1025 1537 2049 3073 4097 6145 8193 12289 16385 24577) at: value+1.
			extra > 0 ifTrue:[distance := distance + (self nextBits: extra)].
			(self _readLimit + length >= self _collection size) ifTrue:[
				bitBuf := oldBits.
				bitPos := oldBitPos.
				sourcePos := oldPos.
				^self].
			self _collection 
					squeakReplaceFrom: self _readLimit+1 
					to: self _readLimit + length + 1 
					with: self _collection 
					startingAt: self _readLimit - distance + 1.
			self readLimit: self _readLimit + length.
		].
	].
%
run
InflateStream setStamp: 'DaleHenrichs 10/11/2010 15:22' forMethod: #decompressBlock:with:.
true
%

category: 'huffman trees'
method: InflateStream
distanceMap
	"This is used by the fast decompressor"
	^nil
%
run
InflateStream setStamp: 'ar 12/4/1998 01:51' forMethod: #distanceMap.
true
%

category: 'private'
method: InflateStream
getFirstBuffer
	"Get the first source buffer after initialization has been done"
	sourceStream == nil ifTrue:[^self].
	source := sourceStream next: (1 bitShift: 16). "This is more than enough..."
	sourceLimit := source size.
%
run
InflateStream setStamp: 'ar 12/23/1999 15:15' forMethod: #getFirstBuffer.
true
%

category: 'private'
method: InflateStream
getNextBlock
	^self nextBits: 3
%
run
InflateStream setStamp: 'ar 12/3/1998 17:32' forMethod: #getNextBlock.
true
%

category: 'huffman trees'
method: InflateStream
growHuffmanTable: table
	| newTable |
	newTable := table species new: table size * 2.
	newTable replaceFrom: 1 to: table size with: table startingAt: 1.
	^newTable
%
run
InflateStream setStamp: 'ar 12/3/1998 13:16' forMethod: #growHuffmanTable:.
true
%

category: 'huffman trees'
method: InflateStream
huffmanTableFrom: aCollection mappedBy: valueMap
	"Create a new huffman table from the given code lengths.
	Map the actual values by valueMap if it is given.
	See the class comment for a documentation of the huffman
	tables used in this decompressor."
	| counts  values table minBits maxBits |
	minBits := MaxBits + 1.
	maxBits := 0.
	"Count the occurences of each code length and compute minBits and maxBits"
	counts := Array new: MaxBits+1.
	counts atAllPut: 0.
	aCollection do:[:length| 
		length > 0 ifTrue:[
			length < minBits ifTrue:[minBits := length].
			length > maxBits ifTrue:[maxBits := length].
			counts at: length+1 put: (counts at: length+1)+1]].
	maxBits = 0 ifTrue:[^nil]. "Empty huffman table"

	"Assign numerical values to all codes."
	values := self computeHuffmanValues: aCollection counts: counts from: minBits to: maxBits.

	"Map the values if requested"
	self mapValues: values by: valueMap.

	"Create the actual tables"
	table := self createHuffmanTables: values counts: counts from: minBits to: maxBits.

	^table
%
run
InflateStream setStamp: 'ar 12/4/1998 02:27' forMethod: #huffmanTableFrom:mappedBy:.
true
%

category: 'huffman trees'
method: InflateStream
increment: value bits: nBits
	"Increment a value of nBits length.
	The fast decompressor will do this differently"
	^value+1
%
run
InflateStream setStamp: 'ar 12/4/1998 01:48' forMethod: #increment:bits:.
true
%

category: 'huffman trees'
method: InflateStream
literalLengthMap
	"This is used by the fast decompressor"
	^nil
%
run
InflateStream setStamp: 'ar 12/4/1998 01:50' forMethod: #literalLengthMap.
true
%

category: 'huffman trees'
method: InflateStream
mapValues: values by: valueMap
	| oldValue |
	valueMap ifNil:[^values].
	1 to: values size do:[:i|
		oldValue := values at: i.
		"Note: there may be nil values if not all values are used"
		oldValue isNil
			ifTrue:[^values]
			ifFalse:[values at: i put: (valueMap at: oldValue+1)]].

%
run
InflateStream setStamp: 'ar 12/4/1998 02:28' forMethod: #mapValues:by:.
true
%

category: 'private'
method: InflateStream
moveContentsToFront
	"Move the decoded contents of the receiver to the front so that we have enough space for decoding more data."
	| delta |
	self _readLimit > 32768 ifTrue:[
		delta := self _readLimit - 32767.
		self _collection 
			squeakReplaceFrom: 1 
			to: self _collection size - delta + 1 
			with: self _collection 
			startingAt: delta.
		self _position: self position - delta + 1.
		self _readLimit: self _readLimit - delta + 1].
%
run
InflateStream setStamp: 'DaleHenrichs 10/11/2010 15:32' forMethod: #moveContentsToFront.
true
%

category: 'private'
method: InflateStream
moveSourceToFront
	"Move the encoded contents of the receiver to the front so that we have enough space for decoding more data."
	(sourceStream == nil or:[sourceStream atEnd]) ifTrue:[^self].
	sourcePos > 10000 ifTrue:[
		source 
			squeakReplaceFrom: 1 
			to: source size - sourcePos
			with: source 
			startingAt: sourcePos + 1.
		source := sourceStream 
			next: sourcePos 
			into: source 
			startingAt: source size - sourcePos + 1.
		sourcePos := 0.
		sourceLimit := source size].
%
run
InflateStream setStamp: 'ar 12/23/1999 15:27' forMethod: #moveSourceToFront.
true
%

category: 'accessing'
method: InflateStream
next
	"Answer the next decompressed object in the Stream represented by the
	receiver."

	self position >= self _readLimit
		ifTrue: [^self pastEndRead]
		ifFalse: [^self _collection at: (self _position: self position + 1)]
%
run
InflateStream setStamp: 'DaleHenrichs 10/11/2010 15:31' forMethod: #next.
true
%

category: 'accessing'
method: InflateStream
next: anInteger 
	"Answer the next anInteger elements of my collection.  overriden for simplicity"
	| newArray |

	"try to do it the fast way"
	self position + anInteger < self _readLimit ifTrue: [
		newArray := self _collection copyFrom: self position + 1 to: self position + anInteger.
		self _position: self position + anInteger.
		^newArray
	].

	"oh, well..."
	newArray := self _collection species new: anInteger.
	1 to: anInteger do: [:index | newArray at: index put: (self next ifNil: [ ^newArray copyFrom: 1 to: index - 1]) ].
	^newArray
%
run
InflateStream setStamp: 'DaleHenrichs 10/11/2010 15:32' forMethod: #next:.
true
%

category: 'accessing'
method: InflateStream
next: n into: buffer startingAt: startIndex
	"Read n objects into the given collection. 
	Return aCollection or a partial copy if less than
	n elements have been read."
	| c numRead count |
	numRead := 0.
	["Force decompression if necessary"
	(c := self next) == nil 
		ifTrue:[^buffer copyFrom: 1 to: startIndex+numRead-1].
	"Store the first value which provoked decompression"
	buffer at: startIndex + numRead put: c.
	numRead := numRead + 1.
	"After collection has been filled copy as many objects as possible"
	count := (self _readLimit - self position) min: (n - numRead).
	buffer 
		squeakReplaceFrom: startIndex + numRead 
		to: startIndex + numRead + count - 1 
		with: self _collection 
		startingAt: self position+1.
	self _position: self position + count.
	numRead := numRead + count.
	numRead = n] whileFalse.
	^buffer
%
run
InflateStream setStamp: 'DaleHenrichs 10/11/2010 15:32' forMethod: #next:into:startingAt:.
true
%

category: 'bit access'
method: InflateStream
nextBits: n
	| bits |
	[bitPos < n] whileTrue:[
		bitBuf := bitBuf + (self nextByte bitShift: bitPos).
		bitPos := bitPos + 8].
	bits := bitBuf bitAnd: (1 bitShift: n)-1.
	bitBuf := bitBuf bitShift: 0 - n.
	bitPos := bitPos - n.
	^bits
%
run
InflateStream setStamp: 'ar 12/4/1998 02:00' forMethod: #nextBits:.
true
%

category: 'bit access'
method: InflateStream
nextByte
	^source byteAt: (sourcePos := sourcePos + 1)
%
run
InflateStream setStamp: 'ar 12/5/1998 14:54' forMethod: #nextByte.
true
%

category: 'bit access'
method: InflateStream
nextSingleBits: n
	| out |
	out := 0.
	1 to: n do:[:i| out := (out bitShift: 1) + (self nextBits: 1)].
	^out
%
run
InflateStream setStamp: 'ar 12/4/1998 02:01' forMethod: #nextSingleBits:.
true
%

category: 'initialize'
method: InflateStream
on: aCollectionOrStream
	aCollectionOrStream isStream 
		ifTrue:[	aCollectionOrStream binary.
				sourceStream := aCollectionOrStream.
				self getFirstBuffer]
		ifFalse:[source := aCollectionOrStream].
	^self on: source from: 1 to: source size.
%
run
InflateStream setStamp: 'ls 1/2/2001 11:44' forMethod: #on:.
true
%

category: 'initialize'
method: InflateStream
on: aCollection from: firstIndex to: lastIndex
	bitBuf := bitPos := 0.
	"The decompression buffer has a size of at 64k,
	since we may have distances up to 32k back and
	repetitions of at most 32k length forward"
	self _collection: (aCollection species new: (1 bitShift: 16)).
	self _readLimit: 0. "Not yet initialized"
	self _position: 0.
	source := aCollection.
	sourceLimit := lastIndex.
	sourcePos := firstIndex-1.
	state := StateNewBlock.
%
run
InflateStream setStamp: 'DaleHenrichs 10/11/2010 15:32' forMethod: #on:from:to:.
true
%

category: 'private'
method: InflateStream
pastEndRead
	"A client has attempted to read beyond the read limit.
	Check in what state we currently are and perform
	the appropriate action"
	| blockType bp oldLimit |
	state = StateNoMoreData ifTrue:[^nil]. "Get out early if possible"
	"Check if we can move decoded data to front"
	self moveContentsToFront.
	"Check if we can fetch more source data"
	self moveSourceToFront.
	state = StateNewBlock ifTrue:[state := self getNextBlock].
	blockType := state bitShift: -1.
	bp := self bitPosition.
	oldLimit := self _readLimit.
	self perform: (BlockTypes at: blockType+1).
	"Note: if bit position hasn't advanced then nothing has been decoded."
	bp = self bitPosition 
		ifTrue:[^self primitiveFailed].
	"Update crc for the decoded contents"
	self _readLimit > oldLimit 
		ifTrue:[crc := self updateCrc: crc from: oldLimit+1 to: self _readLimit in: self _collection].
	state = StateNoMoreData ifTrue:[self verifyCrc].
	^self next
%
run
InflateStream setStamp: 'DaleHenrichs 10/11/2010 15:19' forMethod: #pastEndRead.
true
%

category: 'inflating'
method: InflateStream
proceedDynamicBlock
	self decompressBlock: litTable with: distTable
%
run
InflateStream setStamp: 'ar 12/3/1998 20:49' forMethod: #proceedDynamicBlock.
true
%

category: 'inflating'
method: InflateStream
proceedFixedBlock
	self decompressBlock: litTable with: distTable
%
run
InflateStream setStamp: 'ar 12/3/1998 20:49' forMethod: #proceedFixedBlock.
true
%

category: 'inflating'
method: InflateStream
proceedStoredBlock
	"Proceed decompressing a stored (e.g., uncompressed) block"
	| length decoded |
	"Literal table must be nil for a stored block"
	litTable == nil ifFalse:[^self error:'Bad state'].
	length := distTable.
	[length > 0 and:[self _readLimit < self _collection size and:[sourcePos < sourceLimit]]] 
		whileTrue:[
			self _collection at: (self _readLimit: self _readLimit + 1) put: 
				(source at: (sourcePos := sourcePos + 1)).
			length := length - 1].
	length = 0 ifTrue:[state := state bitAnd: StateNoMoreData].
	decoded := length - distTable.
	distTable := length.
	^decoded
%
run
InflateStream setStamp: 'DaleHenrichs 10/11/2010 15:19' forMethod: #proceedStoredBlock.
true
%

category: 'inflating'
method: InflateStream
processDynamicBlock
	| nLit nDist nLen codeLength lengthTable bits |
	nLit := (self nextBits: 5) + 257.
	nDist := (self nextBits: 5) + 1.
	nLen := (self nextBits: 4) + 4.
	codeLength := Array new: 19.
	codeLength atAllPut: 0.
	1 to: nLen do:[:i|
		bits := #(16 17 18 0 8 7 9 6 10 5 11 4 12 3 13 2 14 1 15) at: i.
		codeLength at: bits+1 put: (self nextBits: 3).
	].
	lengthTable := self huffmanTableFrom: codeLength mappedBy: nil.
	"RFC 1951: In other words, all code lengths form a single sequence..."
	codeLength := self decodeDynamicTable: nLit+nDist from: lengthTable.
	litTable := self 
				huffmanTableFrom: (codeLength copyFrom: 1 to: nLit)
				mappedBy: self literalLengthMap.
	distTable := self 
				huffmanTableFrom: (codeLength copyFrom: nLit+1 to: codeLength size)
				mappedBy: self distanceMap.
	state := state bitOr: BlockProceedBit.
	self proceedDynamicBlock.
%
run
InflateStream setStamp: 'ar 12/4/1998 01:46' forMethod: #processDynamicBlock.
true
%

category: 'inflating'
method: InflateStream
processFixedBlock
	litTable := self 
				huffmanTableFrom: FixedLitCodes
				mappedBy: self literalLengthMap.
	distTable := self 
				huffmanTableFrom: FixedDistCodes
				mappedBy: self distanceMap.
	state := state bitOr: BlockProceedBit.
	self proceedFixedBlock.
%
run
InflateStream setStamp: 'ar 12/4/1998 19:13' forMethod: #processFixedBlock.
true
%

category: 'inflating'
method: InflateStream
processStoredBlock
	| chkSum length |
	"Skip to byte boundary"
	self nextBits: (bitPos bitAnd: 7).
	length := self nextBits: 16.
	chkSum := self nextBits: 16.
	(chkSum bitXor: 16rFFFF) = length
		ifFalse:[^self error:'Bad block length'].
	litTable := nil.
	distTable := length.
	state := state bitOr: BlockProceedBit.
	^self proceedStoredBlock
%
run
InflateStream setStamp: 'ar 12/27/1999 13:49' forMethod: #processStoredBlock.
true
%

category: 'initialize'
method: InflateStream
reset
	"Position zero - nothing decoded yet"
	self _position: 0.
	self _readLimit: 0.
	sourcePos := 0.
	bitBuf := bitPos := 0.
	state := 0.
%
run
InflateStream setStamp: 'DaleHenrichs 10/11/2010 15:32' forMethod: #reset.
true
%

category: 'accessing'
method: InflateStream
size
	"This is a compressed stream - we don't know the size beforehand"
	^self shouldNotImplement
%
run
InflateStream setStamp: 'ar 12/3/1998 16:19' forMethod: #size.
true
%

category: 'accessing'
method: InflateStream
sourceLimit
	^sourceLimit
%
run
InflateStream setStamp: 'ar 12/21/1999 23:54' forMethod: #sourceLimit.
true
%

category: 'accessing'
method: InflateStream
sourcePosition
	^sourcePos
%
run
InflateStream setStamp: 'ar 12/21/1999 23:52' forMethod: #sourcePosition.
true
%

category: 'accessing'
method: InflateStream
sourceStream
	^sourceStream
%
run
InflateStream setStamp: 'ar 12/23/1999 15:31' forMethod: #sourceStream.
true
%

category: 'accessing'
method: InflateStream
upTo: anObject 
	"Answer a subcollection from the current access position to the 
	occurrence (if any, but not inclusive) of anObject in the receiver. If 
	anObject is not in the collection, answer the entire rest of the receiver."
	| newStream element |
	newStream := AnsiWriteStream on: (self _collection species new).
	[self atEnd or: [(element := self next) = anObject]]
		whileFalse: [newStream nextPut: element].
	^newStream contents
%
run
InflateStream setStamp: 'DaleHenrichs 10/11/2010 15:06' forMethod: #upTo:.
true
%

category: 'accessing'
method: InflateStream
upToEnd
	"Answer a subcollection from the current access position through the last element of the receiver."

	| newStream buffer |
	buffer := self _collection species new: 1000.
	newStream := AnsiWriteStream on: (self _collection species new).
	[self atEnd] whileFalse: [newStream nextPutAll: (self next: buffer size into: buffer startingAt: 1)].
	^ newStream contents
%
run
InflateStream setStamp: 'DaleHenrichs 10/11/2010 15:35' forMethod: #upToEnd.
true
%

category: 'crc'
method: InflateStream
updateCrc: oldCrc from: start to: stop in: aCollection
	"Answer an updated CRC for the range of bytes in aCollection.
	Subclasses can implement the appropriate means for the check sum they wish to use."
	^oldCrc
%
run
InflateStream setStamp: 'ar 2/29/2004 03:49' forMethod: #updateCrc:from:to:in:.
true
%

category: 'crc'
method: InflateStream
verifyCrc
	"Verify the crc checksum in the input"
%
run
InflateStream setStamp: 'ar 2/29/2004 04:22' forMethod: #verifyCrc.
true
%

category: 'as yet unclassified'
method: CRCError
isResumable
	^true
%

category: 'instance creation'
classmethod: WordArray
new: aSize

	^(super new: aSize) atAllPut: 0; yourself
%

category: 'compression'
method: SequenceableCollection
collect: aBlock from: firstIndex to: lastIndex
	"Refer to the comment in Collection|collect:."

	| size result j |
	size := lastIndex - firstIndex + 1.
	result := self species new: size.
	j := firstIndex.
	1 to: size do: [:i | result at: i put: (aBlock value: (self at: j)). j := j + 1].
	^ result
%

category: 'instance creation'
classmethod: InflateStream
on: aCollection 
	"Answer an instance of me, streaming over the elements of aCollection."

	^self basicNew on: aCollection
%
category: 'instance creation'
classmethod: DeflateStream
on: aCollection 
	"Answer an instance of me, streaming over the elements of aCollection."

	^self basicNew on: aCollection
%
category: 'instance creation'
classmethod: ZipEncoder
on: aCollection 
	"Answer an instance of me, streaming over the elements of aCollection."

	^self basicNew on: aCollection
%

category: 'instance creation'
classmethod: InflateStream
on: aCollection from: firstIndex to: lastIndex 
	"Answer with a new instance streaming over a copy of aCollection from
	firstIndex to lastIndex."

	^self basicNew
		on: aCollection
		from: firstIndex
		to: lastIndex
%
category: 'instance creation'
classmethod: DeflateStream
on: aCollection from: firstIndex to: lastIndex 
	"Answer with a new instance streaming over a copy of aCollection from
	firstIndex to lastIndex."

	^self basicNew
		on: aCollection
		from: firstIndex
		to: lastIndex
%
category: 'instance creation'
classmethod: ZipEncoder
on: aCollection from: firstIndex to: lastIndex 
	"Answer with a new instance streaming over a copy of aCollection from
	firstIndex to lastIndex."

	^self basicNew
		on: aCollection
		from: firstIndex
		to: lastIndex
%

category: 'accessing'
method: InflateStream
_readLimit

	^readLimit
%
category: 'accessing'
method: InflateStream
_readLimit: anInteger

	readLimit := anInteger.
	^anInteger
%

category: 'instance creation'
classmethod: Archive
new

	^ self basicNew initialize
%

category: 'instance creation'
classmethod: ArchiveMember
new

	^ self basicNew initialize
%

run
CRCError setStamp: 'nk 3/7/2004 15:56' forMethod: #isResumable.
true
%
run
ZipWriteStream initialize.
true
%
run
ZipConstants initialize.
true
%
run
ZipFileConstants initialize.
true
%
run
InflateStream initialize.
true
%
run
FastInflateStream initialize.
true
%
