category: 'as yet unclassified'
classmethod: DataStream
initialize
	"TypeMap maps Smalltalk classes to type ID numbers which identify the data stream primitive formats.  nextPut: writes these IDs to the data stream.  NOTE: Changing these type ID numbers will invalidate all extant data stream files.  Adding new ones is OK.  
	Classes named here have special formats in the file.  If such a class has a subclass, it will use type 9 and write correctly.  It will just be slow.  (Later write the class name in the special format, then subclasses can use the type also.)
	 See nextPut:, next, typeIDFor:, & ReferenceStream>>isAReferenceType:"

	"DataStream initialize"

	| t |
	t := TypeMap := Dictionary new: 80.	"sparse for fast hashing"
	t at: UndefinedObject put: 1.
"	t at: True put: 2.
	t at: False put: 3.
"	t at: SmallInteger put: 4.
"	t at: ByteString put: 5.
"	t at: Symbol put: 6.
	t at: ByteArray put: 7.
	t at: Array put: 8.
"	t at: Bitmap put: 11.
	t at: Metaclass put: 12.
"	t at: Float put: 14.
"	t at: Rectangle put: 15.
"	t at: String put: 17.
"	t at: WordArray put: 18.
	t at: WordArrayForSegment put: 19.
	t at: CompiledMethod put: 21.
"
	self dataStreamStandardGlobals do: [ :cls | cls isBehavior ifTrue: [ 
							cls isPointers not & cls isVariable
								ifTrue: [ (t includesKey: cls)
										ifFalse: [ t at: cls put: 20 ] ] ] ]
%

category: 'private'
classmethod: DataStream
dataStreamStandardGlobals
	| symbolList |
	symbolList := System myUserProfile symbolList.
	^#(Object MCDefinition MCClassDefinition MCMethodDefinition MCOrganizationDefinition Array Symbol String MCVersion MCVersionInfo MCPackage UUID Date Time MCSnapshot Association Dictionary UndefinedObject Integer Character) collect: [:className | symbolList objectNamed: className asSymbol].
%

category: 'write and read'
method: DataStream
readMethod
	"PRIVATE -- Read the contents of an arbitrary instance.
	 ASSUMES: readDataFrom:size: sends me beginReference: after it
	   instantiates the new object but before reading nested objects.
	 NOTE: We must restore the current reference position after
	   recursive calls to next.
	Let the instance, not the class read the data.  "

	| instSize refPosn newClass className xxHeader nLits byteCodeSizePlusTrailer newMethod lits |
	instSize := (byteStream nextNumber: 4) - 1.
	refPosn := self getCurrentReference.
	className := self next.
	newClass := MCPlatform current monticelloGlobalNamed: className asSymbol.
	xxHeader := self next.	"nArgs := (xxHeader >> 24) bitAnd: 16rF."	"nTemps := (xxHeader >> 18) bitAnd: 16r3F."	"largeBit := (xxHeader >> 17) bitAnd: 1."
	nLits := xxHeader >> 9 bitAnd: 16rFF.	"primBits := ((xxHeader >> 19) bitAnd: 16r600) + (xxHeader bitAnd: 16r1FF)."
	byteCodeSizePlusTrailer := instSize - newClass instSize - ((nLits + 1) * 4).	"0"
	newMethod := newClass newMethod: byteCodeSizePlusTrailer header: xxHeader.
	self setCurrentReference: refPosn.	"before readDataFrom:size:"
	self beginReference: newMethod.
	lits := newMethod numLiterals + 1.	"counting header"
	2 to: lits do: [ :ii | newMethod objectAt: ii put: self next ].
	lits * 4 + 1 to: newMethod basicSize do: [ :ii | newMethod basicAt: ii put: byteStream next ].	"Get raw bytes directly from the file"
	self setCurrentReference: refPosn.	"before returning to next"
	^ newMethod
%

category: 'write and read'
method: DataStream
readShortInst
	"Read the contents of an arbitrary instance that has a short header.
	 ASSUMES: readDataFrom:size: sends me beginReference: after it
	   instantiates the new object but before reading nested objects.
	 NOTE: We must restore the current reference position after
	   recursive calls to next.
	Let the instance, not the class read the data.  "

	| instSize aSymbol refPosn anObject newClass |
	instSize := byteStream next - 1.	"one byte of size"
	refPosn := self getCurrentReference.
	aSymbol := self readShortRef.	"class symbol in two bytes of file pos"
	newClass := MCPlatform current monticelloGlobalNamed: aSymbol asSymbol.
	anObject := newClass isVariable
		ifFalse: [ newClass basicNew ]
		ifTrue: [ newClass basicNew: instSize - newClass instSize ].	"Create object here"
	self setCurrentReference: refPosn.	"before readDataFrom:size:"
	anObject := anObject readDataFrom: self size: instSize.
	self setCurrentReference: refPosn.	"before returning to next"
	^ anObject
%

category: 'write and read'
method: DataStream
readWordLike
	| refPosn aSymbol newClass anObject |
	"Can be used by any class that is bits and not bytes (WordArray, Bitmap, SoundBuffer, etc)."
	refPosn := self getCurrentReference.
	aSymbol := self next.
	newClass := MCPlatform current monticelloGlobalNamed: aSymbol asSymbol.
	anObject := newClass newFromStream: byteStream.	"Size is number of long words."
	self setCurrentReference: refPosn.	"before returning to next"
	^ anObject
%

category: 'write and read'
method: DataStream
readInstance
	"PRIVATE -- Read the contents of an arbitrary instance.
	 ASSUMES: readDataFrom:size: sends me beginReference: after it
	   instantiates the new object but before reading nested objects.
	 NOTE: We must restore the current reference position after
	   recursive calls to next.
	Let the instance, not the class read the data.  "

	| instSize aSymbol refPosn anObject newClass |
	instSize := (byteStream nextNumber: 4) - 1.
	refPosn := self getCurrentReference.
	aSymbol := self next.
	newClass := MCPlatform current monticelloGlobalNamed: aSymbol asSymbol.
	anObject := newClass isVariable
		ifFalse: [ newClass basicNew ]
		ifTrue: [ newClass basicNew: instSize - newClass instSize ].	"Create object here"
	self setCurrentReference: refPosn.	"before readDataFrom:size:"
	anObject := anObject readDataFrom: self size: instSize.
	self setCurrentReference: refPosn.	"before returning to next"
	^ anObject
%

run
DataStream initialize.
true
%

