category: '*gsmonticello'
method: PositionableStream
nextDelimited: terminator
	"Answer the contents of the receiver, up to the next terminator character. Doubled terminators indicate an embedded terminator character.  For example: 'this '' was a quote'. Start postioned before the initial terminator."

	| out ch |
	out := WriteStream on: String new.
	self atEnd ifTrue: [^ ''].
	self next == terminator ifFalse: [self skip: -1].	"absorb initial terminator"
	[(ch := self next) == nil] whileFalse: [
		(ch == terminator) ifTrue: [
			self peek == terminator ifTrue: [
				self next.  "skip doubled terminator"
			] ifFalse: [
				^ out contents  "terminator is not doubled; we're done!"
			].
		].
		out nextPut: ch.
	].
	^ out contents
%

category: '*gsmonticello'
method: PositionableStream
nextChunk
	"Answer the contents of the receiver, up to the next terminator character. Doubled terminators indicate an embedded terminator character."
	| terminator out ch |
	terminator := $!.
	out := WriteStream on: String new.
	self skipSeparators.
	[(ch := self next) == nil] whileFalse: [
		(ch == terminator) ifTrue: [
			self peek == terminator ifTrue: [
				self next.  "skip doubled terminator"
			] ifFalse: [
				^ out contents  "terminator is not doubled; we're done!"
			].
		].
		out nextPut: ch.
	].
	^ out contents.
%

category: '*gsmonticello'
method: PositionableStream
on: aCollection

    self _initStreamWith: aCollection
%

category: '*gsmonticello'
method: PositionableStream
isBinary

    ^itsCollection class == ByteArray
%

category: '*gsmonticello'
method: PositionableStream
_position: anInteger

    self position: anInteger.
    ^anInteger
%

category: '*gsmonticello'
method: PositionableStream
_collection

    ^itsCollection
%

category: '*gsmonticello'
method: PositionableStream
_collection: aCollection

    itsCollection := aCollection
%

category: '*gsmonticello'
classMethod: PositionableStream 
on: aCollection from: firstIndex to: lastIndex 
	"Answer an instance of me, streaming over the elements of aCollection 
	starting with the element at firstIndex and ending with the one at 
	lastIndex."

	^self on: (aCollection copyFrom: firstIndex to: lastIndex)
%

category: '*gsmonticello'
method: PositionableStream
nextLittleEndianNumber: n 
	"Answer the next n bytes as a positive Integer or LargePositiveInteger, where the bytes are ordered from least significant to most significant."

	| bytes s |
	bytes := self next: n.
	s := 0.
	n to: 1 by: -1 do: [:i | s := (s bitShift: 8) bitOr: (bytes at: i)].
	^ s
%

category: '*gsmonticello'
method: PositionableStream
binary
	"For compatibility"
	^self.
%

category: '*gsmonticello'
method: PositionableStream
closed
	"For compatibility"
	^false
%

category: '*gsmonticello'
method: PositionableStream
nextNumber: n 
	"Answer the next n bytes as a positive Integer or LargeInteger."
	| s |
	s := 0.
	1 to: n do: 
		[:i | s := (s bitShift: 8) bitOr: self next asInteger].
	^ s normalize
%

category: '*gsmonticello'
method: PositionableStream
nextString
	"Read a string from the receiver. The first byte is the length of the string, unless it is greater than 192, in which case the first four bytes encode the length.  I expect to be in ascii mode when called (caller puts back to binary)."

	| length aByteArray |

	"read the length in binary mode"
	self binary.
	length := self next.		"first byte."
	length >= 192 ifTrue: [length := length - 192.
		1 to: 3 do: [:ii | length := length * 256 + self next]].
	aByteArray := ByteArray new: length.

	self nextInto: aByteArray.
	^aByteArray asString.
%

category: '*gsmonticello'
method: PositionableStream
nextInt32
	"Read a 32-bit signed integer from the next 4 bytes"
	| s |
	s := 0.
	1 to: 4 do: [:i | s := (s bitShift: 8) + self next].
	(s bitAnd: 16r80000000) = 0
		ifTrue: [^ s]
		ifFalse: [^ -1 - s bitInvert32]
%

category: '*gsmonticello'
method: PositionableStream
nextLittleEndianNumber: n put: value
	"Answer the next n bytes as a positive Integer or LargePositiveInteger, where the bytes are ordered from least significant to most significant."
	| bytes |
	bytes := ByteArray new: n.
	1 to: n do: [:i | bytes at: i put: (value digitAt: i)].
	self nextPutAll: bytes
%

