category: '*gsmonticello'
method: SequenceableCollection
beginsWith: aSequenceableCollection
	"Answer true if the receiver starts with the argument collection"
	(aSequenceableCollection isEmpty or: [self size < aSequenceableCollection size]) ifTrue: [^false].
	1 to: aSequenceableCollection size do: [:index |
      (self at: index) ~= (aSequenceableCollection at: index) ifTrue: [^false]].
	^true
%

category: '*gsmonticello'
method: SequenceableCollection
endsWith: aSequenceableCollection
	"Answer true if the receiver ends with the argument collection"
	
	| start |
	(aSequenceableCollection isEmpty or: [self size < aSequenceableCollection size]) ifTrue: [^false].
	start := self size - aSequenceableCollection size.
	1 to: aSequenceableCollection size do: [:index | (self at: start + index) ~= (aSequenceableCollection at: index) ifTrue: [^false]].
	^true
%

category: '*gsmonticello'
classmethod: SequenceableCollection
streamContents: blockWithArg
	| stream |
	stream := WriteStream on: (self new).
	blockWithArg value: stream.
	^stream contents
%

category: '*gsmonticello'
method: SequenceableCollection
copyUpTo: anElement
	"Answer all elements up to but not including anObject. If there
	is no such object, answer a copy of the receiver."

    |index |
    index := self indexOf: anElement startingAt: 1.
    index == 0 ifTrue: [ ^self copy ].
    index == 1 ifTrue: [ ^self species new ].
    ^self copyFrom: 1 to: index -1
%

category: '*gsmonticello'
method: SequenceableCollection
copyAfter: anElement
	"Answer a copy of the receiver from after the first occurence
	of anElement up to the end. If no such element exists, answer 
	an empty copy."

    |index |
    index := self indexOf: anElement startingAt: 1.
    index == 0 ifTrue: [ ^self species new ].
    ^self copyFrom: index + 1 to: self size
%

category: '*gsmonticello'
method: SequenceableCollection
lastIndexOf: anElement startingAt: lastIndex ifAbsent: exceptionBlock
	"Answer the index of the last occurence of anElement within the  
	receiver. If the receiver does not contain anElement, answer the
	result of evaluating the argument, exceptionBlock."

	lastIndex to: 1 by: -1 do:
		[:index |
		(self at: index) = anElement ifTrue: [^ index]].
	^ exceptionBlock value
%

category: '*gsmonticello'
method: SequenceableCollection
copyAfterLast: anElement
	"Answer a copy of the receiver from after the last occurence
	of anElement up to the end. If no such element exists, answer 
	an empty copy."

	| index |
    index := self lastIndexOf: anElement ifAbsent: [^ self species new].
    ^self copyFrom: index + 1 to: self size
%

category: '*gsmonticello'
method: SequenceableCollection
lastIndexOf: anElement
	"Answer the index of the last occurence of anElement within the 
	receiver. If the receiver does not contain anElement, answer 0."

	^ self lastIndexOf: anElement startingAt: self size ifAbsent: [0]
%

category: '*gsmonticello'
method: SequenceableCollection
lastIndexOf: anElement ifAbsent: exceptionBlock
	"Answer the index of the last occurence of anElement within the  
	receiver. If the receiver does not contain anElement, answer the
	result of evaluating the argument, exceptionBlock."
	^self lastIndexOf: anElement startingAt: self size ifAbsent: exceptionBlock
%

category: '*gsmonticello'
method: SequenceableCollection
copyUpToLast: anElement
	"Answer a copy of the receiver from index 1 to the last occurrence of 
	anElement, not including anElement."

	| index |
    index := self lastIndexOf: anElement ifAbsent: [^ self copy].
    index == 1 ifTrue: [ ^self species new ].
    ^self copyFrom: 1 to: index - 1
%

category: '*gsmonticello'
method: SequenceableCollection
writeStream
	^ WriteStream on: self
%

category: '*gsmonticello'
method: SequenceableCollection
readStream
	^ ReadStream on: self
%

category: '*gsmonticello'
method: SequenceableCollection
squeakReplaceFrom: startIndex to: stopIndex with: aSeqCollection startingAt: repIndex

"Replaces the elements of the receiver between the indexes startIndex and 
 stopIndex inclusive with the elements of aSeqCollection starting at startIndex. 
 Returns the receiver....Vanilla algorithm is _required_"

| j |
j := repIndex.    
startIndex to: stopIndex do: [:i|
  self at: i put: (aSeqCollection at: j).
  j := j + 1.
  ].

^ self
%

category: '*gsmonticello'
method: SequenceableCollection
pairsDo: aBlock 
	"Evaluate aBlock with my elements taken two at a time.  If there's an odd number of items, ignore the last one.  Allows use of a flattened array for things that naturally group into pairs.  See also pairsCollect:"

	1 to: self size // 2 do:
		[:index | aBlock value: (self at: 2 * index - 1) value: (self at: 2 * index)]
"
#(1 'fred' 2 'charlie' 3 'elmer') pairsDo:
	[:a :b | Transcript cr; show: b, ' is number ', a printString]
"
%

category: '*gsmonticello'
method: SequenceableCollection
do: elementBlock separatedBy: separatorBlock
	"Evaluate the elementBlock for all elements in the receiver,
	and evaluate the separatorBlock between."

	1 to: self size do:
		[:index |
		index = 1 ifFalse: [separatorBlock value].
		elementBlock value: (self at: index)]
%
