expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #UUID otherwise: nil.
oldCls == nil ifTrue: [
    DateAndTime subclass: 'TimeStamp'
	instVarNames: #()
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'TimeStamp'.
	newCls category: 'TimeStamp'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].

%

! Remove existing behavior from TimeStamp
removeallmethods TimeStamp
removeallclassmethods TimeStamp
! ------------------- Class methods for TimeStamp
category: 'squeak protocol'
classmethod: TimeStamp
current

	^self now
%
category: 'squeak protocol'
classmethod: TimeStamp
now

	^super now beRounded
        
%
classmethod: TimeStamp
date: aDate time: aTime

	^ self 
		year: aDate year 
		day: aDate dayOfYear 
		hour: aTime hours
		minute: aTime minutes
		second: aTime seconds
%
category: instance creation'
classmethod: TimeStamp
fromMethodTimeStamp: aString
	| stream |
	stream := ReadStream on: aString.
	stream skipSeparators.
	stream skipTo: Character space.
	^self readFrom: stream.
%
category: 'instance creation'
classmethod: TimeStamp
fromString: aString
	"Answer a new instance for the value given by aString.

	 TimeStamp fromString: '1-10-2000 11:55:00 am'. 
	"

	^self readFrom: (ReadStream on: aString).
%
category: 'instance creation'
classmethod: TimeStamp
readFrom: stream
	| date time |
	stream skipSeparators.
	date := Date readFrom: stream.
	stream skipSeparators.
	time := Time readFrom: stream.
	^self 
		date: date
		time: time
%
! ------------------- Instance methods for TimeStamp
category: 'squeak protocol'
method: TimeStamp
asTimeStamp
	"Answer the receiver as an instance of TimeStamp."

	^ self
%
category: 'squeak protocol'
method: TimeStamp
date
	"Answer the date of the receiver."

	^ self asDate
%
category: 'squeak protocol'
method: TimeStamp
dateAndTime
	"Answer a two element Array containing the receiver's date and time."

	^ Array with: self date with: self time
%
category: 'squeak protocol'
method: TimeStamp
minusDays: anInteger
	"Answer a TimeStamp which is anInteger days before the receiver."

	^ self - (Duration days: anInteger hours: 0 minutes: 0 seconds: 0)
%
category: 'squeak protocol'
method: TimeStamp
minusSeconds: anInteger
	"Answer a TimeStamp which is anInteger number of seconds before the receiver."

	^ self - (Duration days: 0 hours: 0 minutes: 0 seconds: anInteger)
%
category: 'squeak protocol'
method: TimeStamp
plusDays: anInteger
	"Answer a TimeStamp which is anInteger days after the receiver."

	^ self + (Duration days: anInteger hours: 0 minutes: 0 seconds: 0)
%
category: 'squeak protocol'
method: TimeStamp
plusSeconds: anInteger
	"Answer a TimeStamp which is anInteger number of seconds after the receiver."

	^ self + (Duration days: 0 hours: 0 minutes: 0 seconds: anInteger)
%
category: 'squeak protocol'
method: TimeStamp
printOn: aStream 
	"Print receiver's date and time on aStream."
        | printSeconds |
        printSeconds := (self time seconds == 0) not.
	aStream 
		nextPutAll: (self date asStringUsingFormat: #(1 2 3 $  3 1));
		space;
		nextPutAll: (self time asStringUsingFormat: {$:. printSeconds. true. }) asLowercase.
%
category: 'squeak protocol'
method: TimeStamp
storeOn: aStream 

	aStream 
		nextPutAll: self printString printString;
		nextPutAll: ' asTimeStamp'
%
category: 'squeak protocol'
method: TimeStamp
time
	"Answer the time of the receiver."

	^ self asTime
%
