!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: btreecompforsort.gs,v 1.4 2008-01-09 22:50:08 stever Exp $
!
! Superclass Hierarchy:
!   BtreeComparisonForSort, BtreeComparisonForCompare, Object.
!
!=========================================================================

! class created in idxclasses.topaz

removeallmethods BtreeComparisonForSort
removeallclassmethods BtreeComparisonForSort

category: 'For Documentation Installation only'
classmethod: BtreeComparisonForSort
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'During btree sort and compare operations (for BtreeNode and subclasses) the exact method
 senf for doing comparison operations varies depending upon whether the comparison is for 
 a sort or a query (compare). The class translates the message into a variant for sorting.'.
doc documentClassWith: txt.

self description: doc.
%

! ------------------- Class methods for BtreeComparisonForSort
category: 'Comparison Operators'
classmethod: BtreeComparisonForSort
compareKey: aKey equalTo: aValue

^ aKey _idxForSortEqualTo: aValue
%
category: 'Comparison Operators'
classmethod: BtreeComparisonForSort
compareKey: aKey greaterThan: aValue

^ aKey _idxForSortGreaterThan: aValue
%
category: 'Comparison Operators'
classmethod: BtreeComparisonForSort
compareKey: aKey greaterThanOrEqualTo: aValue

^ aKey _idxForSortGreaterThanOrEqualTo: aValue
%
category: 'Comparison Operators'
classmethod: BtreeComparisonForSort
compareKey: aKey lessThan: aValue

^ aKey _idxForSortLessThan: aValue
%
category: 'Comparison Operators'
classmethod: BtreeComparisonForSort
compareKey: aKey lessThanOrEqualTo: aValue

^ aKey _idxForSortLessThanOrEqualTo: aValue
%
category: 'Testing'
classmethod: BtreeComparisonForSort
satisfiableQueryGreaterThan: val1 
andEquals: bool1
andLessThan: val2 
andEquals: bool2


  ^( (val1 _idxForCompareGreaterThan: val2) _or:
      [ (val1 _idxForSortEqualTo: val2) _and: [ (bool1 & bool2) not ] ] ) not
%
! ------------------- Instance methods for BtreeComparisonForSort
