!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: errordict.gs,v 1.44 2008-01-09 22:50:10 stever Exp $
!
! Description -  Create symbolic mnemonics for all GemStone errors
!
!=========================================================================

! Following are Compiler Errors
run
ErrorSymbols at: #compilerErrStDB put: 1001.
ErrorSymbols at: #StDBErrMaxPath put: 1002.
ErrorSymbols at: #StDBErrArrayTooLarge put: 1003.
ErrorSymbols at: #StDBErrEofInStrLit put: 1004.
ErrorSymbols at: #StDBErrEofInComment put: 1005.
ErrorSymbols at: #StDBErrEofInChrLit put: 1006.
ErrorSymbols at: #StDBErrUnexpectedColon put: 1007.
ErrorSymbols at: #StDBErrUnexpectedPound put: 1008.
ErrorSymbols at: #StDBErrBadChr put: 1009.
ErrorSymbols at: #StDBErrLitTooBig put: 1010.
ErrorSymbols at: #StDBErrBadRadix put: 1011.
ErrorSymbols at: #StDBErrBadChrInRadixNum put: 1012.
ErrorSymbols at: #StDBErrExpectedRightParen put: 1013.
ErrorSymbols at: #StDBErrExpectedPrimary put: 1014.
ErrorSymbols at: #StDBErrExpectedVar put: 1015.
ErrorSymbols at: #StDBErrExpectedSelector put: 1016.
ErrorSymbols at: #StDBErrMaxArg put: 1017.
ErrorSymbols at: #StDBErrExpectedEof put: 1018.
ErrorSymbols at: #StDBErrExpectedStatement put: 1019.
ErrorSymbols at: #StDBErrExpectedPrim put: 1020.
ErrorSymbols at: #StDBErrExpectedPrimNum put: 1021.
ErrorSymbols at: #StDBErrBadPrimNum put: 1022.
ErrorSymbols at: #StDBErrExpectedRightBrace put: 1023.
ErrorSymbols at: #StDBErrMaxArgsTemps put: 1024.
ErrorSymbols at: #StDBErrExpectedVerticalBar put: 1025.
ErrorSymbols at: #StDBErrExpectedMsgPattern put: 1026.
ErrorSymbols at: #StDBErrExpectedGt put: 1027.
ErrorSymbols at: #StDBErrBadFlt put: 1028.
ErrorSymbols at: #StDBErrExpectedAssignable put: 1029.
ErrorSymbols at: #StDBErrAlreadyDefined put: 1030.
ErrorSymbols at: #StDBErrNotDefined put: 1031.
ErrorSymbols at: #StDBErrPredicateTooBig put: 1032.
ErrorSymbols at: #StDBErrBlocksTooDeep put: 1033.
ErrorSymbols at: #StDBErrUnexpectedToken put: 1034.
ErrorSymbols at: #StDBErrExpectedRightBracket put: 1035.
ErrorSymbols at: #StDBErrStackTooBig put: 1036.
ErrorSymbols at: #StDBErrStmtNoEffect put: 1037 .
ErrorSymbols at: #StDBErrCodeTooBig put: 1038.
ErrorSymbols at: #StDBErrMaxLits put: 1039.
ErrorSymbols at: #StDBErrMaxSelectors put: 1040.
ErrorSymbols at: #StDBErrPrimNotAllowed put: 1041.
ErrorSymbols at: #StDBErrExpectedBoolOrExpr put: 1042.
ErrorSymbols at: #StDBErrExpectedBlockOrExpr put: 1043.
ErrorSymbols at: #StDBErrExpectedIntOrExpr put: 1044.
ErrorSymbols at: #StDBErrNotPosIntOrExpr put: 1045.
ErrorSymbols at: #StDBErrDisallowedSelector put: 1046.
ErrorSymbols at: #StDBErrBadNumOfArgs put: 1047.
ErrorSymbols at: #StDBErrLiteralInvariant put: 1048 .
ErrorSymbols at: #StDBErrExpectedOperand put: 1049.
ErrorSymbols at: #StDBErrBadSelectOperator put: 1050.
ErrorSymbols at: #StDBErrExpectedSelectTerm put: 1051.
ErrorSymbols at: #StDBErrTermsNotParen put: 1052.
ErrorSymbols at: #StDBErrBadNumOfSelectArgs put: 1053.
ErrorSymbols at: #StDBErrSourceNotEUCFormat put: 1054.
ErrorSymbols at: #StDBErrTooManyBlocks put: 1055.
ErrorSymbols at: #StDBErrMaxArgs put: 1056.
ErrorSymbols at: #StDBErrCodeGenLogic put: 1057.
ErrorSymbols at: #StDBErrFirstTermCannotBeSetValued put: 1058.
ErrorSymbols at: #StDBErrIllegalProtectedMethod put: 1059.
ErrorSymbols at: #StDBMissingProtectedToken put: 1060.
ErrorSymbols at: #StDBSuperNotAllowed put: 1061.
ErrorSymbols at: #StDBUnusedTemp put: 1062.
ErrorSymbols at: #StDBDbStrOddSize put: 1063.
ErrorSymbols at: #StDBPrimitiveInPragma put: 1064.
ErrorSymbols at: #StDBPragmaInPrim put: 1065.
^true
%

!  
! Following are Runtime Errors
run
ErrorSymbols at: #rtErrInvalidTransMode put: 2001.
ErrorSymbols at: #rtErrBadSymbolList put: 2002.
ErrorSymbols at: #objErrBadOffsetIncomplete put: 2003.
ErrorSymbols at: #rtErrBadSubscript put: 2004.
ErrorSymbols at: #gciErrBadNumMsgParts put: 2005.
ErrorSymbols at: #rtErrAuthArraySize put: 2006.
ErrorSymbols at: #rtErrShouldNotImplement put: 2007.
ErrorSymbols at: #rtErrSubclassResponsibility put: 2008.
ErrorSymbols at: #objErrClassVariant put: 2009.

  "Warning, following error number hard coded in methods for speed"
ErrorSymbols at: #rtErrDoesNotUnderstand put: 2010.

ErrorSymbols at: #objErrNotSegment put: 2011.
ErrorSymbols at: #objErrNotIndexable put: 2012.
ErrorSymbols at: #rtErrCantPerform put: 2013.
ErrorSymbols at: #classErrSubclassDisallowed put: 2014.

ErrorSymbols at: #objErrNotInColl put: 2015.

ErrorSymbols at: #repErrMaxExtents put: 2016.
ErrorSymbols at: #rtErrBadPattern put: 2017.
ErrorSymbols at: #rtErrBadBlockArgCount put: 2018.
ErrorSymbols at: #objErrCollectionEmpty put: 2019.
ErrorSymbols at: #rtErrArgNotChr put: 2020.
ErrorSymbols at: #rtErrKeyNotFound put: 2021.
ErrorSymbols at: #rtErrBadDateTimeArgs put: 2022.
ErrorSymbols at: #genericKernelError put: 2023 .
ErrorSymbols at: #rtErrNoSuchBp put: 2024.
ErrorSymbols at: #repErrCantCreateFile put: 2025.
ErrorSymbols at: #numErrIntDivisionByZero put: 2026.
ErrorSymbols at: #rtErrSpecialOrNotCommitted put: 2027.
ErrorSymbols at: #repErrPreGrowFailure put: 2028.
ErrorSymbols at: #rtErrBeginTrans put: 2029.
ErrorSymbols at: #rtErrPrimOutsideTrans put: 2030.
ErrorSymbols at: #objErrInvariant put: 2031.
ErrorSymbols at: #classErrMethCatExists put: 2032.
ErrorSymbols at: #classErrSelectorNotFound put: 2033.
ErrorSymbols at: #lockErrRemove put: 2034.
ErrorSymbols at: #classErrMethCatNotFound put: 2035.
ErrorSymbols at: #classErrByteObjInstVars put: 2036.
ErrorSymbols at: #classErrConstraintNotClass put: 2037.
ErrorSymbols at: #classErrInvariantSuperClass put: 2038.
ErrorSymbols at: #classErrNscNotIndexable put: 2039.
ErrorSymbols at: #repErrExtentNotMounted put: 2040.
ErrorSymbols at: #rtErrPagesNeedScavenging put: 2041.
ErrorSymbols at: #classErrNscInstVars put: 2042.
ErrorSymbols at: #classErrClassVarNameExists put: 2043.
ErrorSymbols at: #classErrPoolDictExists put: 2044.
ErrorSymbols at: #classErrPoolDictNotFound put: 2045.
ErrorSymbols at: #clampErrNoSuchInstvar put: 2046.
ErrorSymbols at: #clampErrNotAClass put: 2047.
ErrorSymbols at: #clampErrNotAClampspec put: 2048.
ErrorSymbols at: #clampErrBadArg put: 2049.
ErrorSymbols at: #repErrReplicateOnline put: 2050.
ErrorSymbols at: #repErrBadExtentSize put: 2051.
ErrorSymbols at: #repErrCantOpenFile put: 2052.
ErrorSymbols at: #rtErrNoSuchInstVar put: 2053.
ErrorSymbols at: #rtErrTagNotAllowed put: 2054.
ErrorSymbols at: #rtErrBadTagNum put: 2055.
ErrorSymbols at: #segErrMaxSegGroups put: 2056.
ErrorSymbols at: #segErrBadAuthKind put: 2057.
ErrorSymbols at: #rtUnresolvedFwdRefs put: 2058.
ErrorSymbols at: #rtErrStackLimit put: 2059.  "Not trappable with Exceptions"
ErrorSymbols at: #rtErrArgNotPositive put: 2060.
ErrorSymbols at: #rtErrArgOutOfRange put: 2061.
ErrorSymbols at: #rtErrCannotChgConstraint put: 2062.
^true
%
expectvalue 2001
run 
ErrorSymbols at: #rtErrInvalidTransMode
%
expectvalue 2061
run
ErrorSymbols at: #rtErrArgOutOfRange
%
!  more runtime errors
run
ErrorSymbols at: #rtErrNoMessage put: 2063.  
   "2063 hard coded in object.gs, to handle damaged error dictionary case"

ErrorSymbols at: #numErrArgNotChr put: 2064.
ErrorSymbols at: #numErrArgNotFltException put: 2065.
ErrorSymbols at: #numErrFltException put: 2066.
ErrorSymbols at: #numErrArgNotRoundingMode put: 2067.
ErrorSymbols at: #segErrCantMoveObj put: 2068.
ErrorSymbols at: #rtErrExceptionNotLinked put: 2069.
ErrorSymbols at: #numErrArgNotFltStatus put: 2070.
ErrorSymbols at: #lockErrUndefinedLock put: 2071.
ErrorSymbols at: #rtErrBadDictConstraint put: 2072.
ErrorSymbols at: #lockErrIncomplete put: 2073.
ErrorSymbols at: #lockErrObjHasChanged put: 2074.
ErrorSymbols at: #lockErrDenied put: 2075.
ErrorSymbols at: #rtErrMaxClusterId put: 2076.
ErrorSymbols at: #rtErrBadErr put: 2077.
ErrorSymbols at: #rtErrUserIdAlreadyExists put: 2078.
ErrorSymbols at: #rtErrCantReturn put: 2079.
ErrorSymbols at: #rtErrCantChangeClass put: 2080.
ErrorSymbols at: #rtErrCantBecomeSpecial put: 2081.
ErrorSymbols at: #rtErrGarbageCollect put: 2082.
ErrorSymbols at: #rtErrPrimNotFound put: 2083.
ErrorSymbols at: #rtErrNoInstVars put: 2084.
ErrorSymbols at: #rtErrExpectedBoolean put: 2085.
ErrorSymbols at: #rtErrDirtyObjsNeedsInit put: 2086.
ErrorSymbols at: #rtErrCantChangePassword put: 2087.
ErrorSymbols at: #rtErrNewStackLimit put:2088 .
ErrorSymbols at: #rtErrBadCopyFromTo put: 2089.
ErrorSymbols at: #rtErrNilKey put: 2090.
ErrorSymbols at: #rtErrCantBecomeBothIdx put: 2091 .
ErrorSymbols at: #rtErrNoProcessToContinue put: 2092.
ErrorSymbols at: #rtErrBadStreamPosition put: 2093.
ErrorSymbols at: #rtErrBadArgKind put: 2094.
ErrorSymbols at: #classErrClassVarNotFound put: 2095.
ErrorSymbols at: #assocErrNoElementsDetected put: 2096.
ErrorSymbols at: #classErrNotAVar put: 2097.
ErrorSymbols at: #segErrTooManyGroups put: 2098.
ErrorSymbols at: #rtErrExpectedByteValue put: 2099.
ErrorSymbols at: #classErrBadFormat put: 2100.
ErrorSymbols at: #objErrDoesNotExist put: 2101.
ErrorSymbols at: #objErrNotOopKind put: 2102.
ErrorSymbols at: #objErrNotByteKind put: 2103.
ErrorSymbols at: #objErrNotNscKind put: 2104.
ErrorSymbols at: #objErrAlreadyExists put: 2105.
ErrorSymbols at: #objErrOopNotAllocated put: 2106.
ErrorSymbols at: #objErrConstraintViolation put: 2107.
ErrorSymbols at: #rtErrExpectedClass put: 2108.
ErrorSymbols at: #objClassNotOopKind put: 2109.
ErrorSymbols at: #objErrBadOffset put: 2110.
ErrorSymbols at: #objErrCantCreateInstance put: 2111.
ErrorSymbols at: #objClassNotByteKind put: 2112.
ErrorSymbols at: #lockErrArgSize put: 2113 .
ErrorSymbols at: #objErrNotSpecialKind put: 2114.
ErrorSymbols at: #authErrSegRead put: 2115.
ErrorSymbols at: #authErrSegWrite put: 2116.
ErrorSymbols at: #objErrNotOopOrNsc put: 2117.
ErrorSymbols at: #rtErrObsolete put: 2118.
ErrorSymbols at: #rtErrCantBecomeOneIdx put: 2119 .
ErrorSymbols at: #objErrNotFlt put: 2120.
ErrorSymbols at: #rtErrCantBecomeClassKind put: 2121 .
ErrorSymbols at: #classErrByteSubclass put: 2122.
ErrorSymbols at: #repErrBadBkupSwizzle put: 2123 .
ErrorSymbols at: #repErrCantCreateRepos put: 2124.
ErrorSymbols at: #repErrBadFileSpec put: 2125.
^true
%
!  more runtime errors
run
ErrorSymbols at: #repErrFileAlreadyExists put: 2126.
ErrorSymbols at: #rtErrDuplicateKey put: 2127 .
ErrorSymbols at: #assocErrBadComparison put: 2128.
ErrorSymbols at: #repErrIncompatibleRepos put: 2129.
ErrorSymbols at: #assocErrClassModifiable put: 2130.
ErrorSymbols at: #classErrConstrInher put: 2131.
ErrorSymbols at: #classErrBadConstraint put: 2132.
ErrorSymbols at: #repErrBadBkupVersion put: 2133.
"2134 reserved for GBS backward compatibility with GS 6.1  DO NOT REUSE"

ErrorSymbols at: #rtErrCantBecomeIndexedNsc put: 2135.
ErrorSymbols at: #rtErrNoIndexForPath put: 2136.
ErrorSymbols at: #objClassNotOopOrNscKind put: 2137.
ErrorSymbols at: #rtMaxRecursion put: 2138.
ErrorSymbols at: #rtErrBadSession put: 2139.
ErrorSymbols at: #rtErrNotOnlyUser put: 2140.
ErrorSymbols at: #objErrMaxSize put: 2141.
ErrorSymbols at: #rtErrInvalidMethod put: 2142.
ErrorSymbols at: #repErrMaxOnlineRepos put: 2143.
ErrorSymbols at: #rtErrRcQueueEntriesFound put: 2144.
ErrorSymbols at: #rtErrFirstPathTermSetValued put: 2145.
ErrorSymbols at: #gciErrParentSession put: 2146.
ErrorSymbols at: #gciErrAlreadyLoggedIn put: 2147.
ErrorSymbols at: #rtErrInvalidConstraintForMigration put: 2148.
ErrorSymbols at: #classErrBadIdentifier put: 2149.
ErrorSymbols at: #classErrConstrPrivateIv put: 2150.
ErrorSymbols at: #rtErrNoPriv put: 2151.
ErrorSymbols at: #rtErrInvalidBtreeReadStream put: 2152.
ErrorSymbols at: #rtErrDecrNotAllowed put: 2153.
ErrorSymbols at: #repErrReposNotAttached put: 2154.
ErrorSymbols at: #repErrReposNeedsRecovery put: 2155.
ErrorSymbols at: #repErrReplicateNotMounted put: 2156.
ErrorSymbols at: #repErrReposRead put: 2157.
ErrorSymbols at: #repErrReposWrite put: 2158.
ErrorSymbols at: #rtErrInvalidElementConstraintForMigration put: 2159.
ErrorSymbols at: #rtErrSelectiveAbort put: 2160.
ErrorSymbols at: #objErrDateTimeOutOfRange put: 2161.
ErrorSymbols at: #objErrLongNotSmallInt put: 2162.
ErrorSymbols at: #objErrNotLong put: 2163.
ErrorSymbols at: #objErrNotChr put: 2164.
ErrorSymbols at: #lgcErrCompressFailure put: 2165.
ErrorSymbols at: #lgcErrUncompressFailure put: 2166.
ErrorSymbols at: #lgcErrTravswizzFailure put: 2167.
ErrorSymbols at: #errArgTooLarge put: 2168 .
ErrorSymbols at: #commitPromoteFailed put: 2169 .
"2170 not used"
ErrorSymbols at: #rtErrUalibLoadFailed put: 2171.
ErrorSymbols at: #lgcErrObjRepHdrSize put: 2172 .
ErrorSymbols at: #authErrSegLoad put: 2173.
ErrorSymbols at: #authErrSegRecursion put: 2174.
ErrorSymbols at: #assocErrPathTooLong put: 2175.
ErrorSymbols at: #repErrFileNameTooBig put: 2176.
ErrorSymbols at: #rtErrSemaphore put: 2177.
ErrorSymbols at: #rtErrPasswordTooBig put: 2178.
ErrorSymbols at: #errNotSameClassHist put: 2179.
ErrorSymbols at: #classErrMethDictLimit put: 2180.
ErrorSymbols at: #rtErrShrPcDetach put: 2181.
^true
%
!  more runtime errors
run
ErrorSymbols at: #repErrCantDispose put: 2182.
ErrorSymbols at: #rtErrInternal put: 2183.
ErrorSymbols at: #rtErrBadStreamColl put: 2184.
ErrorSymbols at: #rtErrBadFormat put: 2185.
ErrorSymbols at: #rtErrShrpcCompatibility put: 2186.
ErrorSymbols at: #segErrBadGroup put: 2187.
ErrorSymbols at: #rtErrBadPriv put: 2188.
ErrorSymbols at: #rtErrResolveSymFailed put: 2189.
ErrorSymbols at: #rtErrSymAlreadyDefined put: 2190.
ErrorSymbols at: #rtErrSymNotFound put: 2191.
ErrorSymbols at: #rtErrEofOnReadStream put: 2192.
ErrorSymbols at: #assocErrSortOddLengthArray put: 2193.
ErrorSymbols at: #assocErrBadDirection put: 2194.
ErrorSymbols at: #rtErrConfigReadOnly put: 2195 .
ErrorSymbols at: #rtErrBadFormatSpec put: 2196.
ErrorSymbols at: #hostErrFileExport put: 2197.
ErrorSymbols at: #hostErrFileImport put: 2198.
ErrorSymbols at: #hostErrFileDirectory put: 2199.
ErrorSymbols at: #hostErrFileDelete put: 2200.
ErrorSymbols at: #hostErrPerform put: 2201.
ErrorSymbols at: #rtErrSigMsgTooBig put: 2202.
ErrorSymbols at: #gciErrOpInProgress put: 2203.
ErrorSymbols at: #gciErrNoStartCmd put: 2204.
ErrorSymbols at: #objErrBadClusterBucket put: 2205.
ErrorSymbols at: #rtErrEpochGcArraySize put: 2206.
ErrorSymbols at: #objErrResultNscTooBig put: 2207.
ErrorSymbols at: #hostErrMemoryAlloc put: 2208.
ErrorSymbols at: #gciErrCatchBuffNotFound put: 2209.
ErrorSymbols at: #gciErrCatchBuffLimit put: 2210.
ErrorSymbols at: #objErrNotBoolean put: 2211.
ErrorSymbols at: #rtErrUncompiledMethod put: 2212.
ErrorSymbols at: #rtErrMustBeSystemUser put: 2213.
ErrorSymbols at: #rtErrBadPassword put: 2214.
ErrorSymbols at: #gciErrTravObjNotFound put: 2215.
ErrorSymbols at: #gciErrTravCompleted put: 2216.
ErrorSymbols at: #gciErrTravBuffTooSmall put: 2217.
ErrorSymbols at: #rtErrPathToStrIvname put: 2218.
ErrorSymbols at: #objErrNegativeCount put: 2219.
ErrorSymbols at: #gciErrResultPathTooLarge put: 2220.
ErrorSymbols at: #gciErrFetchPathFail put: 2221.
ErrorSymbols at: #rtErrStrToPathIvname put: 2222.
ErrorSymbols at: #rtErrStrToPathConstraint put: 2223.
ErrorSymbols at: #gciErrBreakCanceledMsg put: 2224.
ErrorSymbols at: #lgcErrSync1 put: 2225.
ErrorSymbols at: #lgcErrSync2 put: 2226.
ErrorSymbols at: #lgcErrBytePacketTooLong put: 2227.
ErrorSymbols at: #lgcErrArgSizeInconsistent put: 2228.
ErrorSymbols at: #lgcErrOopPacketTooLong put: 2229.
ErrorSymbols at: #lgcErrPacketKindBad put: 2230.
ErrorSymbols at: #lgcErrExpectedContinue put: 2231.
ErrorSymbols at: #lgcErrExpectedEnd put: 2232.
ErrorSymbols at: #lgcErrPacketKindUnknown put: 2233.
ErrorSymbols at: #lgcErrExpectedCmd put: 2234.
ErrorSymbols at: #hostErrLogFileNotOpened put: 2235.
ErrorSymbols at: #classErrMaxInstVars put: 2236.
ErrorSymbols at: #rtErrTooManyErrArgs put: 2237.
ErrorSymbols at: #objErrBadSize put: 2238.
ErrorSymbols at: #lgcErrInconsistentSize put: 2239.
ErrorSymbols at: #lgcErrInconsistentObjKind put: 2240.
^true
%
!  more runtime errors
run
ErrorSymbols at: #rtErrStartGc put: 2241.
ErrorSymbols at: #rtErrBadArgKind2 put: 2242.
ErrorSymbols at: #lgcErrSequenceMismatch put: 2243.
ErrorSymbols at: #rtErrExceptBlockNumArgs put: 2244 .
ErrorSymbols at: #rtErrGciStoreFloat put: 2245 .
ErrorSymbols at: #rtErrGciStoreClassMismatch put: 2246 .
ErrorSymbols at: #rtErrNscParticipatesInMultipleTerms put: 2247.

ErrorSymbols at: #rtErrCommitDbInRestore put: 2248 .
ErrorSymbols at: #rtErrCommitDisallowed put: 2249 .
ErrorSymbols at: #tranLogIoError put: 2250.
ErrorSymbols at: #lgcErrPacketKind put: 2251.
ErrorSymbols at: #rtErrLoadSaveStack put: 2252.
ErrorSymbols at: #rtErrUnknownBytecode put: 2253.
ErrorSymbols at: #errSesBlockedOnOutput put: 2254 .
ErrorSymbols at: #errPrimNotSupported put: 2255 .
ErrorSymbols at: #authErrSegCurrentSeg put: 2256.
ErrorSymbols at: #authErrSegSetCurrentSeg put: 2257.
ErrorSymbols at: #rtErrPrimFailed put: 2258 .
ErrorSymbols at: #gciErrExecClientUserAct put: 2259.
ErrorSymbols at: #gciErrActiveSessions put: 2260.
ErrorSymbols at: #objErrCorruptObj put: 2261.
ErrorSymbols at: #gciErrMaxActionArgs put: 2262.
ErrorSymbols at: #gciErrBadNumActionArgs put: 2263.
ErrorSymbols at: #gciErrUserActionPending put: 2264.
ErrorSymbols at: #gciErrBadNumLclActionArgs put: 2265.
ErrorSymbols at: #rtErrInstvarAddToNsc put: 2266.
ErrorSymbols at: #rtErrVaryingConstrBytes put: 2267.
ErrorSymbols at: #rtErrVaryingConstrNonidx put: 2268.
ErrorSymbols at: #rtErrInstvarAddToBytes put: 2269.
ErrorSymbols at: #rtErrClassNotModifiable put: 2270.
ErrorSymbols at: #rtErrAddDupInstvar put: 2271.
ErrorSymbols at: #rtErrNotASubclassOf put: 2272.
ErrorSymbols at: #rtErrConstrNotSubclassOf put: 2273.
ErrorSymbols at: #rtErrConstrNotAClass put: 2274.
ErrorSymbols at: #rtErrObjInvariant put: 2275.
ErrorSymbols at: #classErrDupVarConstr put: 2276.
ErrorSymbols at: #bkupErrLoginsEnabled put: 2277.
ErrorSymbols at: #classErrRemoveInherIv put: 2278.
ErrorSymbols at: #concurErrInvalidMode put: 2279.
ErrorSymbols at: #classErrSelectorLookup put: 2280.
ErrorSymbols at: #rtErrBadEUCFormat put: 2281.
ErrorSymbols at: #rtErrGaijiNotSupported put: 2282.
ErrorSymbols at: #rtErrInvalidArgClass put: 2283.
ErrorSymbols at: #rtErrSizeLimit put: 2284.
ErrorSymbols at: #rtErrNoEUCRep put: 2285.
ErrorSymbols at: #rtErrBadEUCValue put: 2286.
ErrorSymbols at: #rtErrInvalidLang put: 2287.
ErrorSymbols at: #rtErrInvalidIndexPathExpression put: 2288.
ErrorSymbols at: #rtErrDependencyListTooLarge put: 2289.
ErrorSymbols at: #rtErrMaxCommitRetry put: 2290.
ErrorSymbols at: #rtErrInvalidArgument put: 2291.
ErrorSymbols at: #rtErrPathNotTraversable put: 2292.
ErrorSymbols at: #rtErrBtreeReadStreamEndOfStream put: 2293.
ErrorSymbols at: #rtErrObjectPathTermNotInDependencyList put: 2294.
ErrorSymbols at: #rtErrObjectInvalidOffset put: 2295.
ErrorSymbols at: #rtErrObjectNoDependencyList put: 2296.
ErrorSymbols at: #rtErrIndexDictionaryEntryNotInDictionary put: 2297.
ErrorSymbols at: #rtErrPathTermObjectNotAnNsc put: 2298.
ErrorSymbols at: #rtErrIdentityIndexCannotInvokeRangeOperation put: 2299.
^ true
%

run
ErrorSymbols at: #rtErrRangeEqualityIndexInvalidClassKindForBtree put: 2300.
ErrorSymbols at: #rtErrRangeEqualityIndexObjectNotInBtree put: 2301.
ErrorSymbols at: #errNoBackupInProgress put: 2302.
ErrorSymbols at: #bkupErrOpenFailed put: 2303.
ErrorSymbols at: #bkupErrMbyteLimitBadRange put: 2304.
ErrorSymbols at: #bkupErrWriteFailed put: 2305.
ErrorSymbols at: #bkupErrInProgress put: 2306.
ErrorSymbols at: #bkupErrReadFailed put: 2307.
ErrorSymbols at: #rtErrBagNoConstraintAlongPath put: 2308.
ErrorSymbols at: #rtErrBagClassDoesNotSupportRangeOperators put: 2309.
ErrorSymbols at: #rtErrBagOnlySelectBlockAllowed put: 2310.
ErrorSymbols at: #rtErrBagOnlyOnePredicateAllowed put: 2311.
ErrorSymbols at: #rtErrBagNoRangeIndexOnPathExpression put: 2312.
ErrorSymbols at: #rtErrBagInvalidPredicateForStreamSelection put: 2313.
ErrorSymbols at: #rtErrBagOperationNotSupportedForStreamSelection put: 2314.
ErrorSymbols at: #rtErrBagInvalidSortSpecification put: 2315.
ErrorSymbols at: #rtErrIndexAuthErrSegRead put: 2316.
ErrorSymbols at: #objErrTime_tOutOfRange put: 2317.
ErrorSymbols at: #genericError put: 2318.
ErrorSymbols at: #rtErrMethodProtected put: 2319.
ErrorSymbols at: #rtErrBadConstraintForMigration put: 2320.
ErrorSymbols at: #rtErrPreventingCommit put: 2321.
ErrorSymbols at: #rtErrCantBecomeSelfOnStack put: 2322 .
ErrorSymbols at: #rtErrObjectProtected put: 2323 .
ErrorSymbols at: #rtErrNewTranlogDirFail put: 2324 .
ErrorSymbols at: #errCommitWhileBackupInProgress put: 2325 .
ErrorSymbols at: #errUnconvertedObject put: 2326 .
ErrorSymbols at: #rtErrLastConstraintNotBoolean put: 2327 .
ErrorSymbols at: #rtErrCommitProhibitingError put: 2328 .
ErrorSymbols at: #rtErrAttemptToPassivateInvalidObject put: 2329 .
ErrorSymbols at: #rtErrTimeToRestoreToArg put: 2330 .
ErrorSymbols at: #lockErrAllSymbols put: 2331.
ErrorSymbols at: #gciErrSymbolFwdRef put: 2332.
ErrorSymbols at: #rtErrChangeSymbol put: 2333.
ErrorSymbols at: #rtErrObjVariant put: 2334.
ErrorSymbols at: #rtErrAlreadyHasSubclasses put: 2335.
ErrorSymbols at: #clientForwarderSend put: 2336.
ErrorSymbols at: #rtErrBadSize put: 2337.
ErrorSymbols at: #objErrDictConstraintViolation put: 2338.
ErrorSymbols at: #rtErrFreeSpaceThreshold put: 2338.
ErrorSymbols at: #rtErrTranlogDirFull put: 2339.
ErrorSymbols at: #objErrDictConstraintViolation put: 2340.
ErrorSymbols at: #rtMaxPasswordSize put: 2341 .
ErrorSymbols at: #rtMinPasswordSize put: 2342 .
ErrorSymbols at: #rtMaxConsecutiveChars put: 2343 .
ErrorSymbols at: #rtMaxRepeatingChars put: 2344 .
ErrorSymbols at: #rtMaxCharsOfSameType put: 2345 .
ErrorSymbols at: #rtDisallowedPassword put: 2346 .
ErrorSymbols at: #rtErrWarningPasswordExpire put: 2347 .
ErrorSymbols at: #errLogDirNotExist put: 2348 .
ErrorSymbols at: #errArgTooSmall put: 2349 .
ErrorSymbols at: #errNoStructuralUpdate put: 2350 .
ErrorSymbols at: #rtObsoleteClass put: 2351 .
ErrorSymbols at: #rtErrLocalSessionFailedCommit put: 2352 .
ErrorSymbols at: #rtErrRemoteSessionFailedCommit put: 2353 .
ErrorSymbols at: #rtErrNoElemDetected put: 2354 .
ErrorSymbols at: #rtErrDateTimeOutOfRange put: 2355 .
ErrorSymbols at: #rtErrObjNotFound put: 2356 .
ErrorSymbols at: #rtErrFailedStnCfgWrite put: 2357 .
ErrorSymbols at: #gciErrNoUserAction put: 2358 .
ErrorSymbols at: #segErrMaxUserProfileGroups put: 2359.
ErrorSymbols at: #rtErrGsCommitListNBTimeout put: 2360.
ErrorSymbols at: #rtErrGcGemStartupFailures put: 2361.
ErrorSymbols at: #rtErrGsSocket put: 2362.
ErrorSymbols at: #rtErrGsSocketInvariant put: 2363.
ErrorSymbols at: #rtErrLostSessionState put: 2364.
ErrorSymbols at: #rtErrDelayInProgress put: 2365.
ErrorSymbols at: #rtErrSchedulerDeadlocked put: 2366.
ErrorSymbols at: #rtErrPrimitiveSysErr put: 2367.
ErrorSymbols at: #rtErrGsProcessTerminated put: 2368.
ErrorSymbols at: #rtErrNoMoreCBuffers put: 2369.
ErrorSymbols at: #rtErrRemoteError put: 2370.
ErrorSymbols at: #rtErrRemoteLoginFailed put: 2371.
ErrorSymbols at: #rtErrClientFwd put: 2372.
ErrorSymbols at: #rtErrBadGsProcessArgCount put: 2373.
ErrorSymbols at: #rtErrPasswordNotVariant put: 2374.
ErrorSymbols at: #rtErrNotEnoughCBuffers put: 2375.
ErrorSymbols at: #rtErrGsProcessNotDebuggable put: 2376.
ErrorSymbols at: #gciErrArgNotPairs put: 2377.
ErrorSymbols at: #rtErrClientActionDisallowed put: 2378.
ErrorSymbols at: #rtErrRemoveSpecialUser put: 2379.
"2380 changed to 4058"
ErrorSymbols at: #rtErrTrackedObjsNeedsInit put: 2381.

"2382 reserved for GBS backward compatibility with GS 6.1  DO NOT REUSE"
"2383 reserved for GBS backward compatibility with GS 6.1  DO NOT REUSE"
"2384 reserved for GBS backward compatibility with GS 6.1  DO NOT REUSE"
"2385 reserved for GBS backward compatibility with GS 6.1  DO NOT REUSE"
"2386 reserved for GBS backward compatibility with GS 6.1  DO NOT REUSE"
"2387 reserved for GBS backward compatibility with GS 6.1  DO NOT REUSE"


ErrorSymbols at: #rtErrCantReadFile put: 2388.
ErrorSymbols at: #rtErrFileCorrupt put: 2389.
ErrorSymbols at: #rtErrGcCommitFailure put: 2390.
ErrorSymbols at: #rtErrSymbolCreateErr put: 2391.
ErrorSymbols at: #repErrBkupNoStart put: 2392.
ErrorSymbols at: #rtErrDecodedObjDoesNotExist put: 2393.
ErrorSymbols at: #rtErrMaxSuperclassDepth put: 2394 .
ErrorSymbols at: #rtErrReclaimAllMissingGcGem put: 2395 .

ErrorSymbols at: #rtErrCantSuspendLogins put: 2400 .
ErrorSymbols at: #rtErrWeakDictNeedsInit put: 2401 .
ErrorSymbols at: #rtErrSymbolTooLarge put: 2402 .
ErrorSymbols at: #rtErrOmFlushFailed put: 2403 . 
ErrorSymbols at: #rtErrNoExistingSymbol put: 2404 .
ErrorSymbols at: #rtErrObjMustBeCommitted put: 2405 .
ErrorSymbols at: #rtErrCantWriteFile put: 2406 .
ErrorSymbols at: #rtErrClassIsNp put: 2407 .
ErrorSymbols at: #rtErrSuperclassIsNP put: 2408 .
ErrorSymbols at: #rtErrContinueTransFail put: 2409 .
ErrorSymbols at: #rtErrMethodSrcTooBig put: 2410 .
ErrorSymbols at: #lgcErrTravBuffSize put: 2411 .
ErrorSymbols at: #rtErrAbortWouldLoseData put: 2412 .
ErrorSymbols at: #bkupErrNotInProgress put: 2413.
ErrorSymbols at: #gciErrCallNotSupported put: 2414.
ErrorSymbols at: #rtErrRemoveAllIndexesFailed put: 2415.
ErrorSymbols at: #rtErrCollectionWithIncompleteIndex put: 2416.
ErrorSymbols at: #rtErrNoMoreSegments put: 2417.
ErrorSymbols at: #lockErrDeadlock put: 2418.
ErrorSymbols at: #lockErrTimeout put: 2419.
ErrorSymbols at: #lockErrInvalidObject put: 2420 .
ErrorSymbols at: #authErrProcessSwitch put: 2421 .
ErrorSymbols at: #rtErrNotInExportSet put: 2422.
ErrorSymbols at: #rtErrGciTravNotLicensed put: 2423.
ErrorSymbols at: #rtErrCommitDisallowedUntilAbort put: 2424.
ErrorSymbols at: #rtErrRollbackDlFail put: 2425.
ErrorSymbols at: #rtErrCantBecomeGeneric put: 2426.

ErrorSymbols at: #rtErrRcUpdateDisallowed put: 2500.
^true
%
! 
! Following are Aborting Errors
run
ErrorSymbols at: #rtErrAbortTrans put: 3001.
"3003 not used "
"3004 not used "
ErrorSymbols at: #abortErrGarbageCollection put: 3006.
ErrorSymbols at: #abortErrUndefPomObj put: 3007.
"3008 not used"
ErrorSymbols at: #bkupErrBackupNotComplete put: 3009.
ErrorSymbols at: #otErrRebuildSuccessful  put: 3010.
" 3011, 3012 not used"
ErrorSymbols at: #otErrCompactSuccessful  put: 3013.
"3014 not used" 

ErrorSymbols at: #bkupErrDisallowed put: 3015.
" 3016 not used"

ErrorSymbols at: #abortErrFinishedMark put: 3020.
" 3021 not used"
ErrorSymbols at: #abortErrObjAuditFail put: 3022.  "Not trappable with Exceptions"
ErrorSymbols at: #abortErrRecordDeadFail put: 3030 .
ErrorSymbols at: #abortErrLostOtRoot put: 3031.
^true
%
!
! Following are Fatal Errors
run
ErrorSymbols at: #gsErrBadRootPage put: 4001.
ErrorSymbols at: #repErrReposFull put: 4002.
ErrorSymbols at: #repErrNoFreePages put: 4003.
ErrorSymbols at: #hostFatalErrOutOfMem put: 4004.
ErrorSymbols at: #gsErrCorruptObjSize put: 4005 .
ErrorSymbols at: #repErrBadDbfSwizzle put: 4006 .
ErrorSymbols at: #gciErrActionDefined put: 4007.
ErrorSymbols at: #errUserProfileLost put: 4008.
ErrorSymbols at: #gsErrShrpcConnectionFailure put: 4009.
ErrorSymbols at: #gsErrShrpcUnexpectedNetEvent put: 4010.
ErrorSymbols at: #gsErrShrpcInvalidConfig put: 4011.

ErrorSymbols at: #errTranLogOpenFail  put: 4032.
ErrorSymbols at: #gsErrStnNetProtocol put: 4034.
ErrorSymbols at: #gsErrStnNetLost put: 4035.
ErrorSymbols at: #gsErrCopyProtection put: 4036.
ErrorSymbols at: #gsErrNoCapability put: 4037.
ErrorSymbols at: #gsErrDisconnectInLogin put: 4038.
ErrorSymbols at: #gsErrMaxSessionsLimit put: 4039.
ErrorSymbols at: #lgcErrIncompatGci put: 4040.
ErrorSymbols at: #hostErrCantSpawn put: 4042.
ErrorSymbols at: #gsErrBadGemStoneVersion put: 4044.
ErrorSymbols at: #gsErrBadGemDbfVersion put: 4045.
ErrorSymbols at: #bkupErrRestoreSuccessful put: 4046.  "Not trappable with Exceptions"
ErrorSymbols at: #gsErrShrpcLostOtTimeout put: 4047 .

ErrorSymbols at: #bkupErrRestoreLogSuccess put: 4048.
ErrorSymbols at: #bkupErrRestoreLogFail put: 4049.

ErrorSymbols at: #gsActiveUserLimitExceeded put: 4050 .
ErrorSymbols at: #gsErrLoginDenial put: 4051.
" 4052 not used "
ErrorSymbols at: #gsErrLoginsDisabled put: 4053.
ErrorSymbols at: #gsErrCacheTooBig put: 4054.
ErrorSymbols at: #gsErrStnShutdown put: 4057.
ErrorSymbols at: #errLostOtHandlingFailed put: 4058 .
ErrorSymbols at: #gsErrSessionShutdown put: 4059.
ErrorSymbols at: #gsErrGemNormalShutdown put: 4060.
^true
%
! more fatal errors
run
ErrorSymbols at: #gsErrGemFatalShutdown put: 4061.
ErrorSymbols at: #gsErrNoMoreOops put: 4062.
ErrorSymbols at: #netErrNoSuchStn put: 4065.
ErrorSymbols at: #gciErrBadSessionId put: 4100.
ErrorSymbols at: #gciErrUnexpectedLnkErr put: 4101 .
ErrorSymbols at: #gciErrInternalRpc put: 4102 .
ErrorSymbols at: #fatalErrInternal put: 4126.
ErrorSymbols at: #netErrConnectionRefused put: 4136.
ErrorSymbols at: #netErr put: 4137.
ErrorSymbols at: #repErrSystemRepNotAttached put: 4138.
ErrorSymbols at: #authErrSegLoginSeg put: 4140.

ErrorSymbols at: #rtErrPause put: 6001.
ErrorSymbols at: #rtErrStep  put: 6002 .
ErrorSymbols at: #rtErrSoftBreak put: 6003.
ErrorSymbols at: #rtErrHardBreak put: 6004.  "Not trappable with Exceptions"
ErrorSymbols at: #rtErrCodeBreakpoint put: 6005.
ErrorSymbols at: #rtErrStackBreakpoint put: 6006.

  "Warning, following error number hard coded in methods for speed"
ErrorSymbols at: #rtErrCommitAbortPending put: 6007.  "Not trappable with Exceptions"

ErrorSymbols at: #rtErrSignalCommit put: 6008.
ErrorSymbols at: #rtErrSignalAbort put: 6009.
ErrorSymbols at: #rtErrSignalGemStoneSession put: 6010.
ErrorSymbols at: #rtErrUncontinuable put: 6011.  "Not trappable with Exceptions"
ErrorSymbols at: #rtErrSignalFinishTransaction put: 6012.
ErrorSymbols at: #rtErrSignalAlmostOutOfMemory put: 6013.
^ true
%

expectvalue %Boolean
run
ErrorSymbols rebuildIfNeeded 
%


