!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: obsidentcollbkt.gs,v 1.5 2008-01-09 22:50:13 stever Exp $
!
! Superclass Hierarchy:
!   ObsoleteIdentityCollisionBucket, CollisionBucket, Array, SequenceableCollection,
!   Collection, Object.
!
!=========================================================================

! Create the class ObsoleteIdentityCollisionBucket, if it does not already exist

! created in bom.c

! remove existing behavior from ObsoleteIdentityCollisionBucket
removeallmethods ObsoleteIdentityCollisionBucket
removeallclassmethods ObsoleteIdentityCollisionBucket

category: 'For Documentation Installation only'
classmethod: ObsoleteIdentityCollisionBucket
installDocumentation

| doc txt |

doc := GsClassDocumentation _newForObsoleteGsClass: self asOfGsVersion: '5.0'.

txt := (GsDocText new) details:
'Existing instances should be migrated to IdentityCollisionBucket or otherwise
 processed as required, and then should be removed.' .
doc documentClassWith: txt.

txt := (GsDocText new) details:
'An IdentityKeyValueDictionary.  For GemStone internal use.' .
doc documentInstVar: #keyValueDictionary with: txt.

self description: doc.
%

! ------------------- Class methods for ObsoleteIdentityCollisionBucket
! ------------------- Instance methods for ObsoleteIdentityCollisionBucket

category: 'Private'
method: ObsoleteIdentityCollisionBucket
compareKey: key1 with: key2

"Returns true if key1 is identical to key2, and false otherwise."

^ key1 == key2
%

! deleted _canonicalizeSymbolAt: offset oldSymbol: oldSym newSymbol: newSym


!category: 'Updating'
!method: ObsoleteIdentityCollisionBucket
!at: aKey put: aValue keyValDict: theKeyValDict
!
!"Stores the aKey/aValue pair in the CollisionBucket.  Returns aValue."
!
!aKey _isSymbol
! ifTrue: [ | aDict |
!   aDict := IdentityKeyValueDictionary new.
!   self keysAndValuesDo: [ :aKey :aValue |
!     aDict at: aKey put: aValue.
!     theKeyValDict removeKey: aKey.
!     ].
!   aDict keysAndValuesDo: [ :aKey :aValue |
!     theKeyValDict at: aKey put: aValue 
!     ].
!   ].
!     
!super at: aKey put: aValue keyValDict: theKeyValDict.
!%
