!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: obslangdict.gs,v 1.7 2008-01-09 22:50:13 stever Exp $
!
! Superclass Hierarchy:
!   ObsoleteLanguageDictionary, ObsoleteSymbolDictionary, ObsoleteDictionary, 
!   IdentitySet, IdentityBag, UnorderedCollection, Collection, Object.
!
!=========================================================================

removeallmethods ObsoleteLanguageDictionary
removeallclassmethods ObsoleteLanguageDictionary

category: 'For Documentation Installation only'
classmethod: ObsoleteLanguageDictionary
installDocumentation

| doc txt |

doc := GsClassDocumentation _newForObsoleteGsClass: self asOfGsVersion: '5.0'.

txt := (GsDocText new) details:
'Existing instances should be migrated to LanguageDictionary or otherwise
 processed as required, and then should be removed.' .
doc documentClassWith: txt.

self description: doc.
%

category: 'Accessing'
method: ObsoleteLanguageDictionary
value

"Returns the value associated with the user's native language symbol.  The
 user's language symbol is taken from his UserProfile object.  If there is no
 entry for the given language, an error is generated."

|myLanguage "the Symbol representing the user's native language"|

myLanguage := System myUserProfile nativeLanguage.
^ self at: myLanguage
       ifAbsent: [^ self _errorKeyNotFound: myLanguage]
%

category: 'Evaluation'
method: ObsoleteLanguageDictionary
textForError: aNumber args: anArray

"Returns a String representing the given error."

|errList result anException |

anException:= Exception category: nil number: nil do:
   [:ex :cat :num :args | anException remove .
   "no recursive errors, please"
   ^ 'Error building error string for ' , cat asString , ':' + num asString
   ].

errList := self value at: aNumber.
result := String new.

errList do: [ :arg |
  (arg isKindOf: String)
    ifTrue: [
      result := result + arg]
    ifFalse: [
      (arg _isSmallInteger)
	ifTrue: [
	  result := result + (anArray at: arg) asString]
        ifFalse: [
	  result := result + '???'.  "peculiar error list"
	  ]
      ]
  ].
^ result
%
category: 'Storing and Loading'
classmethod: ObsoleteLanguageDictionary
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object with named instance
 variable format.  Converts the object to its active form by loading the
 information into a new instance of the receiver.  Returns the new instance."

^ self loadFrom: passiveObj mappingToClass: LanguageDictionary
%

category: 'Repository Conversion'
method: ObsoleteLanguageDictionary
rehashForConversion

"Private. Converts the receiver to an instance of Dictionary. Only done if
 the receiver is an instance of ObsoleteDictionary. Instances of subclasses
 of ObsoleteDictionary are not converted. Returns the receiver."

<primitive: 901> "enter protected mode"
| newDict anArray aSet |

self _class == ObsoleteLanguageDictionary ifFalse: [ 
  System _disableProtectedMode.
  ^ self 
].

anArray := Array new.
aSet := IdentitySet new.
self associationsDo: [ :anAssoc | 
  anArray add: anAssoc.
  aSet add: anAssoc _class 
  ].

"If all the ObsoleteSymbolAssociations  have not been converted to 
 SymbolAssociation, retain the receiver as an ObsoleteLanguageDictionary."
(aSet includes: ObsoleteSymbolAssociation)
  ifTrue: [ ^ self ].

newDict := LanguageDictionary new: (self size).
newDict assignToSegment: self segment.
newDict _primitiveBecome: self.
anArray do: [ :anAssoc | self add: anAssoc ].

System _disableProtectedMode.
^ self.
%

category: 'Repository Conversion'
classmethod: ObsoleteIdentityDictionary
_correspondingNewClass

"The class all instances of receiver are converted to during conversion."

(self == ObsoleteLanguageDictionary)
  ifTrue: [ ^ LanguageDictionary ].

^ self.
%
