!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: indexmgrpolicy.gs,v 1.9 2008-01-09 22:50:11 stever Exp $
!
! Superclass Hierarchy:
!  IndexManagerAutoCommitPolicy, Object.
!
!=========================================================================

! class created in idxclasses.topaz

removeallmethods IndexManagerAutoCommitPolicy
removeallclassmethods IndexManagerAutoCommitPolicy

category: 'For Documentation Installation only'
classmethod: IndexManagerAutoCommitPolicy
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'IndexManagerAutoCommitPolicy implements the behavior for determining when commits should be
 performed when the IndexManager autoCommit feature is enabled. Commits will be performed 
 whenever the number of persistent objects modified exceeds the dirtyObjectCommitThreshold or
 when the tempObjSpacePercentUsed crosses the percentTempObjSpaceCommitThreshold.'.
doc documentClassWith: txt.

self description: doc.
%

! ------------------- Class methods for IndexManagerAutoCommitPolicy
category: 'Instance Creation'
classmethod: IndexManagerAutoCommitPolicy
on: anIndexManager

^self new indexManager: anIndexManager
%
! ------------------- Instance methods for IndexManagerAutoCommitPolicy
category: 'Accessing'
method: IndexManagerAutoCommitPolicy
dirtyObjectCommitThreshold

^dirtyObjectCommitThreshold
%
category: 'Evaluation'
method: IndexManagerAutoCommitPolicy
evaluate: aBlock for: anIndexManager

self percentTempObjSpaceCommitThreshold == nil
  ifTrue: [
    "no % memory threshold protection"
    aBlock value.
  ]
  ifFalse: [
    "Install AlmostOutOfMemory handler"
    Exception 
      category: GemStoneError 
      number: (ErrorSymbols at: #rtErrSignalAlmostOutOfMemory) 
      do: [:ex :cat :num :args | | systm |
          "do a commit..."
          anIndexManager _doCommit.
          "run a markSweep, to see if we dropped below the threshold after the commit"
          systm := System .
          systm _vmMarkSweep.
          (systm _tempObjSpacePercentUsedLastMark <  self percentTempObjSpaceCommitThreshold)
             ifTrue: [ 
              "if we did drop below the threshold, then reenable the signal"
              systm enableAlmostOutOfMemoryError.
             ].
      "if we continue without reenabling the signal, then we likely started already above the threshold
       and commits won't necessarily help with out of memory problems"
      "continue execution"
    ].
    "Enable AlmostOutOfMemory signal"
    System signalAlmostOutOfMemoryThreshold: self percentTempObjSpaceCommitThreshold.
    aBlock ensure: [
        "disable AlmostOutOfMemory signal"
        System signalAlmostOutOfMemoryThreshold: -1.
    ].
  ].
%
category: 'Initialization'
method: IndexManagerAutoCommitPolicy
indexManager: anIndexManager

dirtyObjectCommitThreshold := anIndexManager dirtyObjectCommitThreshold.
percentTempObjSpaceCommitThreshold := anIndexManager percentTempObjSpaceCommitThreshold.
%
category: 'Accessing'
method: IndexManagerAutoCommitPolicy
percentTempObjSpaceCommitThreshold

^percentTempObjSpaceCommitThreshold
%
category: 'Testing'
method: IndexManagerAutoCommitPolicy
shouldCommit
  "Answer true if enough dirty objects have been modified."

^System _numPersistentObjsModified > self dirtyObjectCommitThreshold
%
