!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: segmentset.gs,v 1.4 2008-01-09 22:50:14 stever Exp $
!
! Superclass Hierarchy:
!   SegmentSet, IdentitySet, IdentityBag, UnorderedCollection, 
!      Collection, Object.
!
! class created in idxclasses.topaz
!=========================================================================

removeallmethods SegmentSet
removeallclassmethods SegmentSet
protectmethods

category: 'For Documentation Installation only'
classmethod: SegmentSet
installDocumentation

< unprotected >

| doc |
doc := GsClassDocumentation _newForPrivateGsClass: self.

doc documentClassWith: (GsDocText new).

self description: doc.
%

category: 'Removing'
method: SegmentSet
remove: anObject

"Protected version of Bag | remove:"
<protected>

^ super remove: anObject
%

category: 'Removing'
method: SegmentSet
remove: anObject ifAbsent: exceptionBlock

"Protected version of Bag | remove:ifAbsent:"
<protected>

^ super remove: anObject ifAbsent: exceptionBlock
%

category: 'Removing'
method: SegmentSet
removeIfPresent: anObject

"Protected version of Bag | removeIfPresent:"
<protected>

^ super removeIfPresent: anObject
%

category: 'Updating'
method: SegmentSet
_removeAll: aCollection errIfAbsent: aBool

"Protected version of Bag | _removeAll:errIfAbsent:"
<protected>

^ super _removeAll: aCollection errIfAbsent: aBool
%

unprotectmethods
