!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: undefin.gs,v 1.12 2008-01-09 22:50:20 stever Exp $
!
! Superclass Hierarchy:
!   UndefinedObject, Object.
!
!=========================================================================

removeallmethods UndefinedObject
removeallclassmethods UndefinedObject

category: 'For Documentation Installation only'
classmethod: UndefinedObject
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'This class describes the behavior of nil, the `nonexistent'' object.  You may
 not create new instances of UndefinedObject.'.
doc documentClassWith: txt.

self description: doc.
%

category: 'Instance Creation'
classmethod: UndefinedObject
fromStream: aStream

"If the next Characters in aStream are nil (case-insensitive), returns nil.
 Otherwise, generates an error."

| ch |

self _checkReadStream: aStream forClass: CharacterCollection.

ch := aStream next.
[ ch isEquivalent: $  ]
whileTrue:
  [ ch := aStream next ].
aStream position: (aStream position - 1).

(((aStream next isEquivalent: $N)
_and: [aStream next isEquivalent: $I ])
_and: [aStream next isEquivalent: $L ])
ifTrue:
  [ ^ nil ]
ifFalse:
  [ self _errIncorrectFormat: aStream ]
%

category: 'Instance Creation'
classmethod: UndefinedObject
fromString: aString

"If the first three Characters in aString are nil (case-insensitive), returns
 nil.  Otherwise, generates an error."

| s result |

s := ReadStream on: aString.
result := self fromStream: s.
[ s atEnd ]
whileFalse:
  [ (s next isEquivalent:  $ )
    ifFalse:
      [ self _errIncorrectFormat: aString ]
  ].
^ result
%

category: 'Instance Creation'
classmethod: UndefinedObject
new

"Disallowed.  You cannot create new instances of UndefinedObject."

self shouldNotImplement: #new
%

category: 'Storing and Loading'
classmethod: UndefinedObject
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object.  Converts the object to
 its active form by loading the information into a new instance of the receiver.
 Returns the new instance."

"This method supports activation of passive objects written by a GeODE
 version earlier than 2.0.1."

passiveObj hasRead: nil.
^nil
%

category: 'Formatting'
method: UndefinedObject
asString

"Returns the string 'nil'."

self == _remoteNil ifTrue:[ ^ String withAll: '_remoteNil' ].
^ String withAll: 'nil'
%

category: 'Clustering'
method: UndefinedObject
clusterDepthFirst

"Returns true.  (Because nil is a self-defining object, this method has no
 effect.)"

^ true
%

category: 'Copying'
method: UndefinedObject
copy

"Returns the receiver.  The pseudovariable nil is the only instance of
 UndefinedObject, and must preserve identity."

^self
%

category: 'Formatting'
method: UndefinedObject
describeClassName

"Returns a String to describe classes with nil names."

^ 'unnamed'
%

! deleted _idxCompareLessThan:v2.0

! deleted _idxCompareLessThanOrEqual: v2.0

! deleted _idxCompareGreaterThan: v2.0

! deleted _idxCompareGreaterThanOrEqual: v2.0

! deleted _isNaN v2.0

category: 'Decompiling without Sources'
method: UndefinedObject
_asSource

""

^ self asString
%

category: 'Indexing Support'
method: UndefinedObject
getDepListAndAddPathTerm: pathTerm withIVOffset: ivOffset logging: aBoolean

"Private."

^ self
%

category: 'Storing and Loading'
method: UndefinedObject
writeTo: passiveObj

"Converts the receiver to its passive form and writes that information on
 passiveObj."

| c |
self == _remoteNil ifTrue:[ c := $# ] ifFalse:[ c := $. ].
passiveObj nextPut: c
%

category: 'Filein Support'
method: UndefinedObject
_newKernelSubclass: clsName
instVarNames: ivArg
classVars: classVarArg
classInstVars: classInstVarArg
poolDictionaries: poolDicts
inDictionary: aDict
constraints: constrArray
instancesInvariant: aBool
isModifiable: modBool
reservedOop: reservedOopNum

"Creates a new class only if a class with the given name does not already exist
 in Globals.  Returns a String, either the definition of the new class or a
 message that the class already exists.

 If reservedOopNum is ~~ nil, reservedOopNum must be a positive Integer using
 GemStone 5.0 OOP numbering, and the method Object>>_unsafeSetOop: must be
 installed."

| result theClass superClassOffset |

result := Object
  _newKernelSubclass: clsName
  instVarNames: ivArg
  classVars: classVarArg
  classInstVars: classInstVarArg
  poolDictionaries: poolDicts
  inDictionary: aDict
  constraints: constrArray
  instancesInvariant: aBool
  isModifiable: modBool
  reservedOop: reservedOopNum .

(result at:1 equals:'class already exists') ifTrue:[ ^ result ].

"now fixup the superclass info to be nil"
theClass := Globals at: clsName asSymbol .
superClassOffset := (Behavior _ivOffsetOf: #superClass) .
theClass _unsafeAt: superClassOffset       put: nil .
theClass class _unsafeAt: superClassOffset put: Object class superclass  .
^ result + ' , final definition: ' + theClass definition .
%

category 'Subclass Creation'
method: UndefinedObject
subclass: aString
instVarNames: anArrayOfStrings
inDictionary: aDictionary
constraints: constraintSpec

"Private.  Creates and returns a new subclass of the receiver.

 For further documentation see the same selector in Class."

^ self subclass: aString
    instVarNames: anArrayOfStrings
    classVars: #()
    classInstVars: #()
    poolDictionaries: #()
    inDictionary: aDictionary
    constraints: constraintSpec
    instancesInvariant: false
    isModifiable: false
%

category 'Subclass Creation'
method: UndefinedObject
subclass: aString
instVarNames: anArrayOfStrings
classVars: anArrayOfClassVars
classInstVars: anArrayOfClassInstVars
poolDictionaries: anArrayOfPoolDicts
inDictionary: aDictionary
constraints: aConstraint
instancesInvariant: invarBoolean
isModifiable: modifyBoolean

"Private.  Creates and returns a new subclass of the receiver.

 For further documentation see the same selector in Class."

| theClass superClassOffset |
theClass := Object
  subclass: aString
  instVarNames: anArrayOfStrings
  classVars: anArrayOfClassVars
  classInstVars: anArrayOfClassInstVars
  poolDictionaries: anArrayOfPoolDicts
  inDictionary: aDictionary
  constraints: aConstraint
  instancesInvariant: invarBoolean
  isModifiable: modifyBoolean .

superClassOffset := (Behavior _ivOffsetOf: #superClass) .
theClass _unsafeAt: superClassOffset       put: nil .
theClass class _unsafeAt: superClassOffset put: Object class superclass  .
^ theClass
%

category: 'Storing and Loading'
method: UndefinedObject
containsIdentity

"Private."

^true
%
category: 'Testing'
method: UndefinedObject
isSpecial

"Returns true if the receiver is a special object."

^ true
%

category: 'New Indexing Comparison'
method: UndefinedObject
_classSortOrdinal

^ 0
%
category: 'New Indexing Comparison'
method: UndefinedObject
_idxForCompareGreaterThan: arg

""

^arg _idxForCompareUndefinedObjectGreaterThanSelf: self
%
category: 'New Indexing Comparison'
method: UndefinedObject
_idxForCompareGreaterThanOrEqualTo: arg

""

^arg _idxForCompareUndefinedObjectGreaterThanOrEqualToSelf: self
%
category: 'New Indexing Comparison'
method: UndefinedObject
_idxForCompareLessThan: arg

""

^arg _idxForCompareUndefinedObjectLessThanSelf: self
%
category: 'New Indexing Comparison'
method: UndefinedObject
_idxForCompareLessThanOrEqualTo: arg

""

^arg _idxForCompareUndefinedObjectLessThanOrEqualToSelf: self
%
category: 'New Indexing Comparison'
method: UndefinedObject
_idxForSortGreaterThan: arg

""

^arg _idxForSortUndefinedObjectGreaterThanSelf: self
%
category: 'New Indexing Comparison'
method: UndefinedObject
_idxForSortGreaterThanOrEqualTo: arg

""

^arg _idxForSortUndefinedObjectGreaterThanOrEqualToSelf: self
%
category: 'New Indexing Comparison'
method: UndefinedObject
_idxForSortLessThan: arg

""

^arg _idxForSortUndefinedObjectLessThanSelf: self
%
category: 'New Indexing Comparison'
method: UndefinedObject
_idxForSortLessThanOrEqualTo: arg

""

^arg _idxForSortUndefinedObjectLessThanOrEqualToSelf: self
%
category: 'New Indexing Comparison - for Sort'
method: UndefinedObject
_idxForSortUndefinedObjectLessThanOrEqualToSelf: anUndefinedObject

""

^true
%
category: 'New Indexing Comparison - for Sort'
method: UndefinedObject
_idxForSortUndefinedObjectGreaterThanOrEqualToSelf: anObject

""

^true
%
category: 'New Indexing Comparison - for Sort'
method: UndefinedObject
_idxForSortUndefinedObjectLessThanSelf: anObject

""

^false
%
category: 'New Indexing Comparison - for Sort'
method: UndefinedObject
_idxForSortUndefinedObjectGreaterThanSelf: anUndefinedObject

""

^false
%
category: 'New Indexing Comparison - for Compare'
method: UndefinedObject
_idxForCompareUndefinedObjectGreaterThanSelf: anUndefinedObject

""

^false
%
category: 'New Indexing Comparison - for Compare'
method: UndefinedObject
_idxForCompareUndefinedObjectGreaterThanOrEqualToSelf: anUndefinedObject

""

^true
%
category: 'New Indexing Comparison - for Compare'
method: UndefinedObject
_idxForCompareUndefinedObjectLessThanOrEqualToSelf: anUndefinedObject

""

^true
%
category: 'New Indexing Comparison - for Compare'
method: UndefinedObject
_idxForCompareUndefinedObjectLessThanSelf: anUndefinedObject

""

^false
%
