!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: bomlast.gs,v 1.16 2008-01-09 22:50:08 stever Exp $
!
! Description - 
!  Final changes to kernel classes and reserved objects during filein.
!
!  Not Used during repository conversion
!=========================================================================

!input all the changes that are used only during upgrades.
input $upgradeDir/bomlastconv.gs

! ===================================================================
! create instances of new class ClusterBucket
expectvalue 0
run
  "Expect SmallInteger 0"
^ AllClusterBuckets size
%

level 0
run
System currentSegment: DataCuratorSegment.
  "Cluster bucket 1"
  (ClusterBucket newForExtent: nil "extent is don't care") 
  description: 'Generic bucket 1. The default bucket after login.' ;
  immediateInvariant  "This bucket may not be changed".

  "Cluster bucket 2"
  (ClusterBucket newForExtent: nil "extent is don't care") 
  description: 'Generic bucket 2' .

  "Cluster bucket 3"
  (ClusterBucket newForExtent: nil "extent is don't care") 
  description: 'Generic bucket 3' .

  "Cluster bucket 4"
  (ClusterBucket newForExtent: 1 "primary extent") 
  description: 'Kernel classes behavior bucket' .

  "Cluster bucket 5"
  (ClusterBucket newForExtent: 1 "primary extent") 
  description: 'Kernel classes description bucket' .

  "Cluster bucket 6"
  (ClusterBucket newForExtent: 1 "primary extent")
  description: 'Kernel bucket for AllSymbols and other kernel objects' .

  "Cluster bucket 7"  
  "  provided so the maximum clusterId returns a generic bucket in the
     GemStone kernel for compatibility with prior releases"
  (ClusterBucket newForExtent: nil "extent is don't care")
  description: 'Generic bucket 7' .

^ AllClusterBuckets size == 7 "expect result == true "
%

commit

expectvalue false
run
"  now cluster AllClusterBuckets, which must be in the default cluster bucket"
AllClusterBuckets clusterInBucket: 1.
%

commit

run
System currentSegment: SystemSegment .
^ true
%

!------------------------------------------------------------
! set timestamp , userId, etc on classes that were created in bom.c
method: Class
instVar: aSymbol put: aValue
self _unsafeAt: (self class _ivOffsetOf: aSymbol) put: aValue
%

run
| classes epoch |
System currentSegment: SystemSegment .
epoch :=  DateTime now  .
classes := Array new .
Globals valuesDo:[ :aValue| 
  (aValue isKindOfClass: Class) ifTrue:[ classes add: aValue].
  ].

classes do:[ :aClass |
  aClass timeStamp == nil ifTrue:[
 	  				"do not alter description , fix 36429"
    aClass instVar: #timeStamp put: epoch .
    aClass instVar: #userId put: 'SystemUser'.
    aClass instVar: #extraDict put: (SymbolDictionary new) .
       "ClassHistory initialized by bom.c / repository conversion "
       "migrationDestination instance variable left as nil " 
    ].
  ].
^ true
%
run
Class removeSelector: #instVar:put: ifAbsent:[ nil ] .
^ true
%


!------------------------------------------------------------
! create security data dictionary and userId dictionary on AllUsers
run
AllUsers _initialize  .
^ true
%
commit

!------------------------------------------------------------
! Migrate users from old to new set - deleted
! build dictionary on new AllUsers - deleted

!------------------------------------------------------------
! Add the Published dictionary to all UserProfiles symbol lists
!  Add new groups to AllGroups
!------------------------------------------------------------
run
Segment setCurrent: (Globals at:#DataCuratorSegment) while:[
  | newDict published publishedSeg gbRef |

  "convert AllGroups to a dictionary."
  AllGroups class == CanonicalStringDictionary ifFalse:[
    newDict := CanonicalStringDictionary new .
    AllGroups do:[ :aSym | | aStr | 
      aStr := (String withAll: aSym ) immediateInvariant .
      newDict add: aStr .
      ].
    AllGroups := newDict .
    ].
  AllGroups add: 'System' ; add: 'Publishers'; add:'Subscribers' ;
		add: 'SymbolUser' .

  publishedSeg := (Globals at:#SystemRepository) at: 6 .  
  gbRef := Globals at:#PublishedSegment otherwise: nil .
  publishedSeg == gbRef ifFalse:[ nil error:'invalid PublishedSegment ref' ].

  publishedSeg group: 'Subscribers' authorization: #read  ;
    group: 'Publishers'  authorization: #write .

  Segment setCurrent: publishedSeg while:[
    published := SymbolDictionary new name: #Published ; yourself . 
  ].

  SystemRepository _migrateGroups .

  AllGroups add:'DataCuratorGroup' .      "added for Gs64 v2.2 to fix 36294"

  AllUsers do:[:aUserPro | 
    aUserPro _migrateGroups .
    aUserPro symbolList addLast: published .
    aUserPro addGroup: 'Subscribers' .
    ].

  (AllUsers userWithId: 'DataCurator') 
     addGroup: 'System' ;
     addGroup: 'Publishers'; addGroup:'DataCuratorGroup' .

  (AllUsers userWithId: 'SystemUser') 
     addGroup: 'System' ;
     addGroup: 'Publishers' .

   (Globals at:#DataCuratorSegment) group:'DataCuratorGroup' authorization: #write .
  
].
^ true
%

commit

!------------------------------------------------------------
! Deleted: Add the SharedDependencyLists so that they are treated as weak references 
!------------------------------------------------------------

!-------------
! removal of _unsafesetoop method done later in filein
 
! end of bomlast.gs
commit
