!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: bom.gs,v 1.17 2008-01-09 22:50:08 stever Exp $
!
! Description -  more initialization of the image
!   create UserGlobals dictionary for DataCurator, SystemUser, SymbolUser

!   create various things in Globals and initialize various  class variables.
!
! Repository conversion - this file is NOT used. bomconv.gs is input by
!   this file. bomconv.gs is the subset used by GemStone conversion also.
!
!========================================================================

run
| symList newDict sysUser symuser allSyms |

(Globals at:#DataCuratorSegment) setCurrentWhile:[

  symList:= (AllUsers detect: [:x | x userId = 'DataCurator']) symbolList.
  newDict := SymbolDictionary new .
  newDict name: #UserGlobals ;
	  at: #NativeLanguage put: #English.
  symList insertObject: newDict at: 1.

  sysUser := AllUsers detect: [:x | x userId = 'SystemUser'] .
  symList:= sysUser symbolList.
  newDict := SymbolDictionary new .
  newDict name: #UserGlobals ;
	  at: #NativeLanguage put: #English.
  symList insertObject: newDict at: 1.

  "SymbolUser does not exist yet, not created in bom.c "
].
^ true
%


run
(Segment segment) setCurrentWhile:[
  Segment _classVars at: #AuthorizationSymbols 
		put: #[ #none, #write, #read, #write ] .
].
^ true
%

!---------------------
!define month and day names for various classes
!  formerly in bomconv.gs, now in-line

run
(Date segment) setCurrentWhile:[
  |langDict englishArray temp|
  langDict := LanguageDictionary new.
  englishArray := Array new.
  langDict at: #English put: englishArray.

  englishArray at: 1 put: 'Sunday';
	       at: 2 put: 'Monday';
	       at: 3 put: 'Tuesday';
	       at: 4 put: 'Wednesday';
	       at: 5 put: 'Thursday';
	       at: 6 put: 'Friday';
	       at: 7 put: 'Saturday'.

  Date _classVars at: #WeekDayNames put: langDict.
  DateTime _classVars at: #WeekDayNames put: langDict copy.

  langDict := LanguageDictionary new.
  englishArray := Array new.
  langDict at: #English put: englishArray.

  englishArray at: 1 put: 'January';
	       at: 2 put: 'February';
	       at: 3 put: 'March';
	       at: 4 put: 'April';
	       at: 5 put: 'May';
	       at: 6 put: 'June';
	       at: 7 put: 'July';
	       at: 8 put: 'August';
	       at: 9 put: 'September';
	       at: 10 put: 'October';
	       at: 11 put: 'November';
	       at: 12 put: 'December'.

  Date _classVars at: #MonthNames put: langDict.
  DateTime _classVars at: #MonthNames put: langDict copy.
].
^ true
%
run

ObsoleteDateTime segment setCurrentWhile:[
  |langDict englishArray temp|
  langDict := LanguageDictionary new.
  englishArray := Array new.
  langDict at: #English put: englishArray.
  ObsoleteDateTime _classVars at: #WeekDayNames put: langDict.

  englishArray at: 1 put: 'Sunday';
	       at: 2 put: 'Monday';
	       at: 3 put: 'Tuesday';
	       at: 4 put: 'Wednesday';
	       at: 5 put: 'Thursday';
	       at: 6 put: 'Friday';
	       at: 7 put: 'Saturday'.

  langDict := LanguageDictionary new.
  englishArray := Array new.
  langDict at: #English put: englishArray.
  ObsoleteDateTime _classVars at: #MonthNames put: langDict.

  englishArray at: 1 put: 'January';
	       at: 2 put: 'February';
	       at: 3 put: 'March';
	       at: 4 put: 'April';
	       at: 5 put: 'May';
	       at: 6 put: 'June';
	       at: 7 put: 'July';
	       at: 8 put: 'August';
	       at: 9 put: 'September';
	       at: 10 put: 'October';
	       at: 11 put: 'November';
	       at: 12 put: 'December'.
].
^ true
%

! Create the default TimeZone object for filein. 
! The default is the US/Pacific Time.
! This will all be replaced by TimeZone2007.gs
!
run
| cache aTimeZone |
aTimeZone := TimeZone 
	timeDifferenceHrs: -8 
	dstHrs: 1 
	atTimeHrs: 2
	fromDayNum: 73
	toDayNum: 311
	on: #Sunday 
	beginning: 1967
	stdPrintString: 'PST'
	dstPrintString: 'PDT'.

aTimeZone installAsCurrentTimeZone.
cache := SymbolDictionary new.
cache at: #'America/Los_Angeles' put: aTimeZone.
TimeZone _classVars 
	at: #Default put: aTimeZone;
	at: #TimeZones put: cache;
	yourself.
^ true.
%
commit

! delete creation of ConversionDict used in 4.x to 5.x conversion

! fix 31162, moved PrivilegeNames creation to bomnew.gs, 
!  so it's available in conversion
run
UserProfile segment setCurrentWhile:[
  UserProfile _classVars at: #LanguageNames put: #(#ASCII #'JIS-EUC').
].
^ true
%

commit

expectvalue %Symbol
run
| oldLang |
oldLang := Globals at: #NativeLanguage otherwise: nil .
oldLang == nil 
  ifTrue:[ oldLang := #English ]
  ifFalse:[ oldLang := oldLang asSymbol ]. 
Globals at: #NativeLanguage put: oldLang .
^ oldLang
%

commit

! end in-line code from old bomconv.gs
!---------------------

! initialize method dictionaries to empty for private classes
removeallmethods NscNode
removeallclassmethods NscNode
removeallmethods NscInteriorNode
removeallclassmethods NscInteriorNode
removeallmethods NscSetLeaf
removeallclassmethods NscSetLeaf
removeallmethods NscBagLeaf
removeallclassmethods NscBagLeaf
removeallmethods LargeObjectNode
removeallclassmethods LargeObjectNode

run
  " remove Associations of private classes from Globals"
  "   DependencyList is user visible , do not remove"
Globals
  removeAssociation: (Globals associationAt: #NscNode);
  removeAssociation: (Globals associationAt: #NscInteriorNode);
  removeAssociation: (Globals associationAt: #NscSetLeaf);
  removeAssociation: (Globals associationAt: #NscBagLeaf);
  removeAssociation: (Globals associationAt: #LargeObjectNode) .

  " LargeByteLeafNode not used yet"
  " removeAssociation: (Globals associationAt: #LargeByteLeafNode).  "
^ true
%


! object 3625 (v4.1 OOP 906) (conversion status) already created in bom.c
! end bomnew32.opl stuff
!===============================================================
