! BUGFIX 31162
!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: fstidkvdict.gs,v 1.5 2008-01-09 22:50:10 stever Exp $
!
! Superclass Hierarchy:
!   FastIdentityKeyValueDictionary, GsMethodDictionary, 
!     IdentityKeyValueDictionary, KeyValueDictionary, AbstractDictionary
!       Collection, Object
!       
!
!=========================================================================

expectvalue false
run
"temporarily allow subclasses to handle repository upgrade"
| oldFmt |
GsMethodDictionary subclassesDisallowed ifTrue:[
  oldFmt := GsMethodDictionary format .
  GsMethodDictionary _unsafeAt: 2 "offset of format"
     put: (oldFmt bitXor:32"subclasses disallowed bit" ).
  ].
^ GsMethodDictionary subclassesDisallowed 
%

expectvalue %String
run
  GsMethodDictionary _newKernelSubclass: 'FastIdentityKeyValueDictionary'
    instVarNames: #()
    classVars: #()
    classInstVars: #()
    poolDictionaries: #[]
    inDictionary: Globals
    constraints: #[  ]
    instancesInvariant: false
    isModifiable: false
    reservedOop: 937
%

expectvalue true
run
" restore subclasses disallowed bit to 1 "
| oldFmt |
oldFmt := GsMethodDictionary format .
GsMethodDictionary _unsafeAt: 2 "offset of format"
   put: (oldFmt bitOr:32"subclasses disallowed bit" ) .
^ GsMethodDictionary subclassesDisallowed
%


removeallmethods FastIdentityKeyValueDictionary
removeallclassmethods FastIdentityKeyValueDictionary

category: 'For Documentation Installation only'
classmethod: FastIdentityKeyValueDictionary
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details: 
'FastIdentityKeyValueDictionary is a subclass of GsMethodDictionary designed
 for customer applications.  FastIdentityKeyValueDictionary employs the same
 internal structure as GsMethodDictionary that is well-suited for efficient 
 execution in smaller dictionaries.

 The keys of FastIdentityKeyValueDictionaries must be canonical symbols 
 (Symbols or DoubleByteSymbols).' .
doc documentClassWith: txt.
self description: doc.
%

! ------------------- Class methods for FastIdentityKeyValueDictionary
! ------------------- Instance methods for FastIdentityKeyValueDictionary

