!=========================================================================
! Copyright (C) VMware, Inc. 1986-2011.  All Rights Reserved.
!
! $Id: identityset.gs,v 1.5 2008-01-09 22:50:11 stever Exp $
!
! Superclass Hierarchy:
!   IdentitySet, IdentityBag, UnorderedCollection, Collection, Object.
!
!=========================================================================

removeallmethods IdentitySet
removeallclassmethods IdentitySet

category: 'For Documentation Installation only'
classmethod: IdentitySet
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
'An IdentitySet is an IdentityBag in which any distinct object can occur only
 once.  Adding the same (identical) object to an IdentitySet multiple times is
 redundant.  The result is the same as adding it once.

 Since an IdentitySet is an identity-based collection, different (non-identical)
 but equivalent (equal) objects are treated as distinct from each other.  In
 Sets, they are not distinct.  Adding multiple equivalent objects to an
 IdentitySet yields an IdentitySet with as many elements as there are distinct
 equivalent objects.  In short, two different elements of an IdentitySet are
 never identical, but they may be equivalent.

 You can create subclasses of IdentitySet to restrict the kind of elements it
 contains.  When creating a subclass of IdentitySet, you must specify a class as
 the aConstraint argument.  This class is called the element kind of the new
 subclass.  For each instance of the new subclass, the class of each element
 must be of the element kind.' .
doc documentClassWith: txt.

self description: doc.
%

category: 'Adding'
method: IdentitySet
addValue: anObject

"Adds anObject to the receiver only if it is not already an element of the
 receiver, and if the receiver does not contain an equivalent object.  Has no
 effect if anObject is nil.  Returns anObject."

(self includesValue: anObject) ifFalse:[ self add: anObject ].
^ anObject
%

! add: now inherited from IdentityBag

!-----------------------------
! following two methods not in customer's image
!    see duplicated code in   tests/gcitst/nsctestprivate.opl
! category: 'Private'
! method: IdentitySet
! _addToPrivateSet: anObject
! 
! "For use in testing the virtual machine ONLY.  This primitive does
!  not operate correctly on persistent instances or on instances of
! subclasses.  also Indexes are not maintained. "
!
! <primitive: 303>
! self _primitiveFailed: #add: .
! self _uncontinuableError
! %
! category: 'Private'
! method: IdentitySet
! _removeFromPrivateSet: anObject ifAbsent: exceptionBlock
! 
! "For use in testing the virtual machine only."
! 
! <primitive: 63>  "primitive fails if anObject not found"
! ^ exceptionBlock value
! %
!    see duplicated code in   tests/gcitst/nsctestprivate.opl
!-----------------------------


category: 'Adding'
method: IdentitySet
add: anObject withOccurrences: anInteger

"Disallowed.  Each element of an IdentitySet must be unique."

self shouldNotImplement: #add:withOccurrences:
%

category: 'Adding'
method: IdentitySet
addAll: aCollection

"Adds each element of aCollection to the receiver only if the element is not
 already present in the receiver.  Occurrences of nil in aCollection are not
 added to the receiver."

^ super addAll: aCollection
%

category: 'Converting'
method: IdentitySet
asIdentitySet

"(R) Returns an IdentitySet with the contents of the receiver."

^ self.
%

category: 'Converting'
method: IdentitySet
asSet

"(R) Disallowed.  IdentitySets cannot be converted to Sets because it could
 result in the loss of some of the constituent elements."

^ self shouldNotImplement: #asSet
%
