
array set vsdhelp {
{Context Switch} {
An operating system context switch occurs when a thread is moved from executing to non-executing status. If a thread needs a non-cpu resource (disk, lock, semaphore, and timer are examples) then its called an [voluntary context switch > VolCSW Statistic]. If a thread still wants to execute but the operating system scheduler decides to preempt it so some other thread can execute then its called a [involuntary context switch > IVolCSW Statistic].
}
{Chart Window Features} {
Multiple chart windows can exist.

!Chart Information
   * [General Interface Features]
   * [Creating Chart Windows > How to Create a New Chart]

!Chart Menus
   * [Chart > Chart Window Chart Menu]
   * [Line > Chart Window Line Menu]

!Chart Controls
   * optional [X: > Chart Window X: Display]
   * optional [Y: > Chart Window Y: Display]
   * optional [Min: > Chart Window Min: Display]
   * optional [Max: > Chart Window Max: Display]
   * [Statistic Selector > Chart Window Statistic ComboBox]
   * [Filter Selector > Chart Window Filter MenuButton]
   * [Operator Selector > Chart Window Operator MenuButton]
   * [Number Entry > Chart Window Number Entry]
   * [Graph > Chart Window Graph]
}

{Chart Window X: Display} {
This display shows the time coordinate of the data point currently under the mouse pointer. The format of the displayed information it determined by [Chart Menu <b>Time Format</b> SubMenu].
This display will only exist if [Chart Menu <b>Show Current Values</b> Item] is on. 
This display is on each [chart window > Chart Window Features].
}
{Chart Window Y: Display} {
This display shows the value coordinate of the data point currently under the mouse pointer.
This display will only exist if [Chart Menu <b>Show Current Values</b> Item] is on. 
This display is on each [chart window > Chart Window Features].
}
{Chart Window Min: Display} {
This display shows the minimum value of the currently selected line's data points. Only data points displayed on the graph are considered (see [trimming > File Trimming] and [zooming > How to Zoom] to learn how to control what data points are displayed).
This display will only exist if [Chart Menu <b>Show Min and Max</b> Item] is on.
This display is on each [chart window > Chart Window Features].
}
{Chart Window Max: Display} {
This display shows the maximum value of the currently selected line's data points. Only data points displayed on the graph are considered (see [trimming > File Trimming] and [zooming > How to Zoom] to learn how to control what data points are displayed).
This display will only exist if [Chart Menu <b>Show Min and Max</b> Item] is on.
This display is on each [chart window > Chart Window Features].
}
{Chart Window Statistic ComboBox} {
This control allows you to change the statistic of the currently selected line. It also display the statistic of the currently selected line. Changing the selection will also update the [Statistic Information Window].

!Bindings
   * Clicking on a name with the <em>mouse</em> both selects it and causes it to become the current line's statistic.
   * The <em>down</em> arrow key selects the next statistic.
   * The <em>up</em> arrow key selects the previous statistic.
   * The <em>letter keys</em> select the next statistic whose first letter matches the key.
   * <tt>control-s</tt> starts a [search > List Search Control] which results in selecting a statistic.
   * <em>Return</em> causes the selected statistic to become the current line's statistic.
   * <em>Esc</em> cancels the change leaving the current line's statistic unchanged.
This combobox is on each [chart window > Chart Window Features].
}
{Chart Window Filter MenuButton} {
Displays the current line's filter and allows the filter to be changed. Possible filters are:
   * No Filter (None)
   * PerSecond
   * PerSample
   * Smooth
   * Aggregate
See [How to Filter Statistics] for a description of what each filter does.
This menu button is on each [chart window > Chart Window Features].
}
{Chart Window Operator MenuButton} {
Displays and sets the tranforming operation that will be applied to the current line using the value in the [number entry > Chart Window Number Entry]. The supported operations are:
   * <b>S</b>: [scale > Display Scaling a Line]; uses the line's <em>display scale</em> constant
   * <b>/</b>: [divide > Value Scaling a Line]; uses the line's <em>value scale</em> constant
   * <b>*</b>: [multiply > Value Scaling a Line]; uses the line's <em>value scale</em> constant
   * <b>+</b>: [add > Offsetting a Line]; uses the line's <em>offset</em> constant
   * <b>-</b>: [subtract > Offsetting a Line]; uses the line's <em>offset</em> constant
This menu button is on each [chart window > Chart Window Features].
}
{Chart Window Number Entry} {
This entry displays and sets numeric constants associated with the current line. Which constant is displayed is controlled by which operator is selected by the [operator menu button > Chart Window Operator MenuButton]. Each line has three constants:
   * a <em>display scale</em> used by the <b>S</b> operator.
   * a <em>value scale</em> used by the <b>/</b> and <b>*</b> operators.
   * an <em>offset</em> used by the <b>+</b> and <b>-</b> operators.
For the scale constants the up spinner button doubles the constant and the down spinner button halves the constant.
For the offset constant the up spinner button adds one to the constant and the down spinner subtracts one from the constant.
Scale constants can not be set to zero.
This entry is on each [chart window > Chart Window Features].
}

{Chart Window Graph} {
!Graph Controls
   * [Graph Display]
   * [X Axis]
   * [Left Y Axis]
   * [Right Y Axis]
   * optional [Graph Legend]
A graph is on each [chart window > Chart Window Features].
}

{Graph Display} {
Contains a graphical display of each line on the chart. An effort is made to give each line a unique color or style. The selected line's color is determined by the [Main Chart Menu <b>Selected Line Color...</b> Item].

Information about the current line is shown in the upper left corner of the graph. This information can be [disabled > Chart Menu Show Line Stats Item]. Two small red triangles at the bottom of the graph display indicate the range of data points used to calculate the line statistics. During [auto updating > File Menu Auto Update Item] this range will not automatically expand. To get it to expand <em>right click</em> in the graph display.

If [cross hairs > Chart Menu Show CrossHairs Item] are enabled then a single vertical and horizontal black line will be drawn and they will always intersect where the mouse points in the graph. If the mouse leaves the graph the cross hairs disappear.

If [grid lines > Chart Menu Show Grid Lines Item] are enabled then faint dashed lines are drawn from every axis tick.

!Bindings
   * <em>Left clicking</em> on a line will select it.
   * <em>Middle clicking</em> will do a [time zoom > How to Zoom].
   * <em>Right clicking</em> [zooms out > How to Zoom] one level.
   * <em>Moving</em> the mouse over a data point temporarily selects the line and [displays > Chart Menu Show Current Values Item] the data point's coordinates.
   * The <em>left</em> arrow key move a [zoom level > How to Zoom] one sample to the left.
   * The <em>right</em> arrow key move a [zoom level > How to Zoom] one sample to the right.
   * The <em>control-left</em> arrow key move a [zoom level > How to Zoom] to the left by however many time samples are in the graph.
   * The <em>control-right</em> arrow key move a [zoom level > How to Zoom] to the right by however many time samples are in the graph.
 
This display is on each [graph > Chart Window Graph].
}
{X Axis} {
The ticks on this axis are labeled with the time in a format determined by [Chart Menu <b>Time Format</b> SubMenu]. The labels reflect the data plotted in the graph of this axis. Each line's time coordinates are plotted on this axis.
This axis's title, if not [disabled > Chart Menu Show Time Axis Title Item], will show a description of the file the current line's data came from.
This axis is on each [graph > Chart Window Graph].
}
{Left Y Axis} {
The ticks on this axis are labeled with numbers that reflect the data plotted in the graph on this axis. Each line's values are plotted on either this axis or the other Y axis. An axis only exists if at least one line is plotted on it.
This axis's title, if not [disabled > Chart Menu Show Left Axis Title Item], will show a description of the current line's units if it was [plotted > Line Menu Graph on Left Axis Item] on the left axis.
This axis is on each [graph > Chart Window Graph].
}
{Right Y Axis} {
The ticks on this axis are labeled with numbers that reflect the data plotted in the graph on this axis. Each line's values are plotted on either this axis or the other Y axis. An axis only exists if at least one line is plotted on it.
This axis's title, if not [disabled > Chart Menu Show Right Axis Title Item], will show a description of the current line's units if it was [plotted > Line Menu Graph on Left Axis Item] on the right axis.
This axis is on each [graph > Chart Window Graph].
}
{Graph Legend} {
A graph's legend has an entry for every line on a graph. For each line the legend shows:
   * the line's unselected color
   * a description of the instance and statistic the line represents
   * the line's [symbol > Line Menu Symbol SubMenu]
A graph's legend can be [hidden > Chart Menu Show Legend Item] to save space. If it is hidden then a description of the current's line instance will be written in the upper left corner of the [graph > Graph Display]. Legends are very helpful so are usually not disabled. The best reason for disabling a legend is if your graph contains a large number of lines.

!Bindings
   * <em>Left clicking</em> on a legend entry toggles selection of that line.
   * <em>Middle clicking</em> on a legend entry deletes the line.

A legend is on each [graph > Chart Window Graph].
}
{Chart Window Chart Menu} {
Operations on this menu apply to the entire chart.
Changes made with this menu will only effect its chart.\
For changes that you want to be global, use the [main chart menu > Main Window Chart Menu].

[Selection Key > Keyboard Selection Keys]: <tt>Alt-c</tt>

This menu can be [torn off > Tear Off Menus].

This menu is on each [chart window > Chart Window Features].

!Items
   * [Add From Template > Chart Menu Add From Template SubMenu]
   * [Save Template > Chart Menu Save Template Item]
   * [Paste > Chart Menu Paste Item]
   * [Print > Chart Menu Print Item]
   * [Snapshot > Chart Menu Snapshot Item]
   * [Help... > Chart Menu Help... Item]
   * [Zoom In > Chart Menu Zoom In Item]
   * [Zoom Out > Chart Menu Zoom Out Item]
   * [Compute Scale All > Chart Menu Compute Scale All Item]
   * [Unscale All > Chart Menu Unscale All Item]
   * [Show Legend > Chart Menu Show Legend Item]
   * [Time Format > Chart Menu Time Format SubMenu]
   * [Show Time Axis Title > Chart Menu Show Time Axis Title Item]
   * [Show Left Axis Title > Chart Menu Show Left Axis Title Item]
   * [Show Right Axis Title > Chart Menu Show Right Axis Title Item]
   * [Show Current Values > Chart Menu Show Current Values Item]
   * [Show Min and Max > Chart Menu Show Min and Max Item]
   * [Show Line Stats > Chart Menu Show Line Stats Item]
   * [Show CrossHairs > Chart Menu Show CrossHairs Item]
   * [Show Grid Lines > Chart Menu Show Grid Lines Item]
   * [Close > Chart Menu Close Item]
}

{vsdsh} {
vsdsh is the text version if vsd. It allows scripts to be written that will load and process statmonitor data.
When vsdsh is started it will first attempt to load and interpret [Tcl code > Tcl Language] from the file <tt>~/.vsdshrc</tt>.
Then if it was given a file on the command line it will load and interpret it as [Tcl code > Tcl Language] and exit. Otherwise it display a prompt at which [Tcl code > Tcl Language] can be interactively entered. To exit back to the environment that started vsdsh type <tt>exit</tt>.
}
{Tcl Language} {
Tcl stands for tool command language. Tcl is pronounced <em>tickle</em>.\
Learn more about it at <tt><u>www.scriptics.com</u></tt>. For a quick overview\
of the language see:
   * <tt><u>http://www.scriptics.com/scripting/primer.html</u></tt>
   * <tt><u>http://www.scriptics.com/scripting/syntax.html</u></tt>
In the context of VSD and [vsdsh] the following extension to standard Tcl are available. These extensions tend to be valuable when writing scripting code that VSD or [vsdsh] will load:
   * [RBC Vectors]
   * [sltcl]
In the context of VSD the following additional extensions to standard Tcl are available. These extensions are used for GUI features are probably not of interest to those writing scripting code:
   * Tk
   * Tix
   * RBC
}
{RBC Vectors} {
!Synopsis
   * <tt>vector create</tt> <em>vecName</em> <em>?switches?</em>
   * <tt>vector destroy</tt> <em>vecName</em>
   * <tt>vector expr</tt> <em>expression</em>
   * <tt>vector names</tt> <em>?pattern...?</em>

!Description
The <tt>vector</tt> command creates a vector of floating poing values. The vector's values can be manipulated through a Tcl array variable or with Tcl commands.

!Introduction
A vector is simply an ordered set of numbers. The components of a vector are real numbers, indexed by counting numbers. 
Vectors are common data structures for many applications. For example, a graph may use two vectors to represent the X-Y coordinates of the data plotted. The graph will automatically be redrawn when the vectors are updated or changed. By using vectors, you can separate data analysis from the graph widget. This makes it easier, for example, to add data transformations, such as splines. It's possible to plot the same data to in multiple graphs, where each graph presents a different view or scale of the data. 
You could try to use Tcl's associative arrays as vectors. Tcl arrays are easy to use. You can access individual elements randomly by specifying the index, or the set the entire array by providing a list of index and value pairs for each element. The disadvantages of associative arrays as vectors lie in the fact they are implemented as hash tables. 
   * There's no implied ordering to the associative arrays. If you used vectors for plotting, you would want to insure the second component comes after the first, an so on. This isn't possible since arrays are actually hash tables. For example, you can't get a range of values between two indices. Nor can you sort an array. ·
   * Arrays consume lots of memory when the number of elements becomes large (tens of thousands). This is because each element's index and value are stored as strings in the hash table· The C programming interface is unwieldy. Normally with vectors, you would like to view the Tcl array as you do a C array, as an array of floats or doubles. But with hash tables, you must convert both the index and value to and from decimal strings, just to access an element in the array. This makes it cumbersome to perform operations on the array as a whole. 

The <tt>vector</tt> command tries to overcome these disadvantages while still retaining the ease of use of Tcl arrays. The <tt>vector</tt> command creates both a new Tcl command and associate array which are linked to the vector components. You can randomly access vector components though the elements of array. Not have all indices are generated for the array, so printing the array (using the <tt>parray</tt> procedure) does not print out all the component values. You can use the Tcl command to access the array as a whole. You can copy, append, or sort vector using its command. If you need greater performance, or customized behavior, you can write your own C code to manage vectors. 

!Examples
   * When you create a new vector you give it a name. Both a Tcl command and an array variable with that name are created. You can use either the command or variable to query or modify components of the vector. The number of components in a vector can be given when its created. By default they are initialized to zero. This example creates a vector named y that contains fifty components:  <tt>vector create y(50)</tt>
   * Indexing vector components
      * Vector components are indexed from zero. The vector's array variable can be used to read or set individual components. This example sets y's first element:  <tt>set y(0) 9.25</tt>
      * The array index must be a number less than the number of components. For example, it's an error if you try to set the 51st element of y:  <tt>puts "y has &#91;y length] components"; set y(50) 0.02</tt>
      * You can also specify a range of indices using a colon <tt>:</tt> to separate the first and last indices of the range. This example sets the first six components in y to 25.2:  <tt>set y(0:5) 25.2</tt>
      * If you don't include an index, then it will default to the first and/or last component of the vector. This example leaves out both indexes so it will print out all the components of y:  <tt>puts "y = $y(:)"</tt>  
      * Non-numeric Indices
         * <tt>end</tt> The index end, specifies the last component of the vector. It's an error to use this index if the vector is empty (length is zero).
         * <tt>++end</tt> The index ++end can be used to extend the vector by one component and initialize it to a specific value. You can't read from the array using this index, though. For example <tt>set y(++end) 0.02</tt> extends the vector by one component.
         * <tt>min</tt> The index min returns the component with the smallest value.
         * <tt>max</tt> The index max returns the component with the largest value.
   * To delete components from a vector, simply unset the corresponding array element. In the following example, the first component of y is deleted. All the remaining components of y will be moved down by one index as the length of the vector is reduced by one. Example: <tt>unset y(0); puts "new first element is $y(0)"</tt>
   * In this example a vector x is created without an initial length specification. In this case, the length is zero. The <b>set</b> operation resets the vector, extending it and setting values for each new component. The name of the vector is used as a command to set its component values given a list of them: <tt>vector create x; x set { 0.02 0.04 0.06 0.08 0.10 0.12 0.14 0.16 0.18 0.20}</tt>
   * The <b>range</b> operation lists the components of a vector between two indices. This example lists all the components in vector x: <tt>puts "x = &#91;x range 0 end]"</tt>
   * You can search for a particular value using the <b>search</b> operation. It returns a list of indices of the components with the same value. If no component has the same value, it returns "". This example finds the index of the components with the largest value: <tt>x search $x(max)</tt>
   * You can append vectors or new values onto an existing vector with the <b>append</b> operation. This example appends assorted vectors and values to x: <tt>x append x2 x3 { 2.3 4.5 } x4</tt>
   * The <b>sort</b> operation sorts the vector. If any additional vectors are specified, they are rearranged in the same order as the vector. For example, you could use it to sort data points represented by x and y vectors. In this example the vector x is sorted while the components of y are rearranged so that the original x,y coordinate pairs are retained: <tt>x sort y</tt>
   * The <b>expr</b> operation lets you perform arithmetic on vectors. The result is stored in the vector. This example adds y to x and then multiplies x by 2: <tt>x expr { x + y }; x expr { x * 2 }</tt>
   * When a vector is modified, resized, or deleted, it may trigger call-backs to notify the clients of the vector. For example, when a vector used in the graph widget is updated, the vector automatically notifies the widget that it has changed. The graph can then redrawn itself at the next idle point. By default, the notification occurs when Tk is next idle. This way you can modify the vector many times without incurring the penalty of the graph redrawing itself for each change. You can change this behavior using the <b>notify</b> operation. To make vector x notify after every change: <tt>x notify always</tt>. To turn off notification on vector x: <tt>x notify never</tt>. To force a notification now: <tt>x notify now</tt>.
   * To delete a vector, use the vector <b>delete</b> command. Both the vector and its corresponding Tcl command are destroyed. For example to remove vector x: <tt>vector destroy x</tt>

!Syntax
Vectors are created using the vector <b>create</b> operation. The create operation can be invoked in one of three forms: 
   * <tt>vector create</tt> <em>vecName</em>:  This creates a new vector <em>vecName</em> which initially has no components. 
   * <tt>vector create</tt> <em>vecName</em> <tt>(</tt><em>size</em><tt>)</tt>:  This form creates a new vector which will contain <em>size</em> number of components. The components will be indexed starting from zero <tt>(0)</tt>. The default value for the components is zero.
   * <tt>vector create</tt> <em>vecName</em> <tt>(</tt><em>first</em><tt>:</tt><em>last</em><tt>)</tt>: This form creates a new vector with components indexed <em>first</em> through <em>last</em>. <em>First</em> and <em>last</em> can be any integer value so long as <em>first</em> is less than <em>last</em>.

Vector names must start with a letter and consist of letters, digits, or underscores. 

You can automatically generate vector names using the <tt>#auto</tt> vector name. The <b>create</b> operation will return the unique vector name.

!Vector Indices
Vectors are indexed by integers. You can access the individual vector components via its array variable or Tcl command. The string representing the index can be an integer, a numeric expression, a range, or a special keyword.
The index must lie within the current range of the vector, otherwise an an error message is returned. Normally the indices of a vector are start from 0. But you can use the <b>offset</b> operation to change a vector's indices on-the-fly. 
You can also use numeric expressions as indices. The result of the expression must be an integer value. 
The following special non-numeric indices are available: <b>min</b>, <b>max</b>, <b>end</b>, and <b>++end</b>.
The indices <b>min</b> and <b>max</b> will return the minimum and maximum values of the vector.
The index <b>end</b> returns the value of the last component in the vector.
The index <b>++end</b> is used to append new value onto the vector. It automatically extends the vector by one component and sets its value.
A range of indices can be indicated by a colon <tt>:</tt> seperating two indices. The colon seperated indices can be integers, keywords, or empty. If no index is supplied the first or last component is assumed. 

For more information on RBC vectors get the public domain RBC distribution and see the <b>vector</b> man page or html file.
}

{sltcl} {
The sltcl set of commands all start with the <tt>sl_</tt> prefix. These are the actual commands used to read statmon files and convert their data to [vectors > RBC Vectors].
!Builtin Commands
   * [sl_create]
   * [sl_stat]
   * [sl_kill]
}

{Instance List Data} {
For each instance a sublist of the following exists:
   1 instance name
   1 object name
   1 start time
   1 isActive
   1 sample count
   1 file id
   1 instanceId
}

{Data File Commands} {
Whenever a file is created with [sl_create -file > sl_create] a new Tcl data file command is created. File commands support the following options:
   * <b>-info</b>: return a list of information about the file. The list has the following items:
      1 name
      1 version
      1 platform
      1 productVersion
      1 machine
      1 time string
      1 estimated sampleInterval
      1 isEnabled
      1 list of object types
      1 first timestamp
      1 trimLeft timestamp
      1 trimRight timestamp
   * <b>-instancecount</b>: returns the number of instances the file has.
   * <b>-instances</b>: returns a list of all the files instances. See [Instance List Data] for a description of the result.
   * <b>-objinstances</b> <em>objName</em>: returns a list of all the files instances of the named object type. See [Instance List Data] for a description of the result.
   * <b>-free</b>: frees up all resources used by loading the file and deletes the command.
   * <b>-dump</b>: dump the internal data structures, that contain the files data, in a printable form, to stdout.
   * <b>-update</b>: rereads the file to so if it has more data that can be read. This can be used to continue an interrupted create or read more data from a file that has grown.
   * <b>-disable</b>: Act as if the file has not been loaded.
   * <b>-enable</b>: Act as if the file has been loaded.
   * <b>-trimleft</b> <em>timeStamp</em>: Trim all of the data collected before the timestamp from the file. See [File Trimming] for more information.
   * <b>-trimright</b> <em>timeStamp</em>: Trim all of the data collected after the timestamp from the file. See [File Trimming] for more information.
   * <b>-append</b> <em>fileName</em>: causes this file to start reading the new named file onto the end of the current data. The new files data needs to be newer than the current data. Also the current file needs to be fully loaded.
}

{Line Commands} {
Whenever a file is created with [sl_create -line > sl_create] or [sl_create -derivedline > sl_create] a new Tcl line command is created. Line commands support the following options:
   * <b>-info</b>: return a list of information about the line. The list has the following items:
      1 instance name
      1 statistic name
      1 x vector name
      1 y vector name
      1 scale
      1 filter
      1 object name
      1 fileId list
      1 source list
      1 combo operator
      1 instId
      1 isNormalized
      1 normalize offset
      1 divider
   * <b>-changectr</b> <em>statName</em>: changes the line's statistic.
   * <b>-refilter</b> <em>filter</em>: changes the line's filter.
   * <b>-scale</b> <em>number</em>: scales the y values by <em>number</em>.
   * <b>-adder</b> <em>number</em>: offset the y values by <em>number</em>.
   * <b>-divider</b> <em>number</em>: divides the y values by <em>number</em>.
   * <b>-normalize</b>: forces the min y value to always be zero by subtracting to raw y min value from every y data point.
   * <b>-unnormalize</b>: undoes any normalization.
   * <b>-stats</b> <em>ts1 ts2</em>: returns a list of stats for y data between the specified timestamps. This returned list is:
      1 total number of samples in the range
      1 minimum y value in the range
      1 maximum y value in the range
      1 average of all y values in the range
      1 standard deviation of all y values in the range
      1 first actual timestamp in the range
      1 last actual timestamp in the range
   * <b>-trimleft</b> <em>timeStamp</em>: Trim all of the data collected before the timestamp from all the files used to make the line. See [File Trimming] for more information.
   * <b>-trimright</b> <em>timeStamp</em>: Trim all of the data collected after the timestamp from all the files used to make the line. See [File Trimming] for more information.
   * <b>-copy</b>: copies a line and returns the name of the copies line command.
   * <b>-free</b>: frees up all the resources used by the line and deletes the command.
}

{sl_create} {
The sl_create command lets you create [Data File Commands] and [Line Commands].
!Usages
   * <b>sl_create -file</b> <em>filename</em> ?<em>progressCallback</em>?: Creates a [Data File Commands] by loading the named statmon file. Returns the name of the created [command > Data File Commands]. If a progress callback is specified then it must be a Tcl proc that takes a single argument which is an integer in the range 0..100. The callback will always be called with a value of 100 when reading is complete. The callback should return 1 if loading should continue and 0 if it should be interrupted.
   * <b>sl_create -line</b> <em>instIdList statName filter isAbsolute</em>: Creates a [line > Line Commands] for the given instances and statistic name, and using the given [filter > Statistic Definitions]. Returns the name of the created [command > Line Commands]. If more than one instance is given then their data is all [combined > Main Menu Combine Item] together. The <em>isAbsolute</em> boolean determines if the time data for the created line will be [absolute or relative > Main Menu Absolute TimeStamps Item].
   * <b>sl_create -derivedline</b> <em>lineList</em> <b>+|-|/</b> <em>filter copyChildren</em>: Creates a [line > Line Commands] for the given lines using the given operator,and [filter > Statistic Definitions]. Returns the name of the created [command > Line Commands].  The <em>copyChildren</em> boolean determines if the input lines will be [copied or referenced > Main Menu Copy Referenced Lines Item]. For more information see [Line Arithmetic].
}

{sl_stat} {
The sl_stat command is used to perform global operations that are not limited to a particular data file.
!Usages
   * <b>sl_stat -names</b>: Returns a list of all known statistic names.
   * <b>sl_stat -enabledinstances</b>: Returns a list of instances from all the enabled files. See [Instance List Data] for a description of the result.
   * <b>sl_stat -enabledobjinstances</b> <em>objTypeList</em>: Returns a list of instances from all the enabled files of the given obj types. See [Instance List Data] for a description of the result.
   * <b>sl_stat -ctrzero</b> <em>statName instIdList</em>: Returns boolean indicating if named statistic is zero for all the given instances.
   * <b>sl_stat -enabledfiles</b>: Returns a list of [files > Data File Commands] that are enabled.
   * <b>sl_stat -allfiles</b>: Returns a list of all the [files > Data File Commands] that are loaded.
   * <b>sl_stat -alias</b> <em>oldname newname</em>: Causes the statistic <em>newname</em> to be used whenever <em>oldname</em> is found in a loaded statmon file.
   * <b>sl_stat -info</b> <em>name</em> ?<em>infolist</em>?: Returns a list of information on the named statistic. If the optional <em>infolist</em> exists then it must have at most three elements. Empty elements will be ignored. Non-empty ones will modify that value in the statistic's definition:
      1 statistic's [kind > Statistic Definitions]
      1 statistic's [level > Statistic Definitions]
      1 statistic's [default filter > Statistic Definitions]
          The result list has the following elements:
      1 statistic's [kind > Statistic Definitions]
      1 statistic's [level > Statistic Definitions]
      1 statistic's [default filter > Statistic Definitions]
      1 possible empty list of object types that use the statistic
   * <b>sl_stat -level</b> ?<em>levelname</em>?: With no argument returns the current statistic level. Otherwise sets the statistic level. See [Main Menu Statistic Level SubMenu].
   * <b>sl_stat -getdate</b> <em>ts</em> ?<b>elapsed</b>|<b>date</b>|<b>time</b>?: Given a timestamp convert it to a formatted string and return it. In no format is specified it defaults to <tt>date</tt>.
   * <b>sl_stat -objctrs</b> <em>objList</em>: returns a list of statistic names for the given object types.
   * <b>sl_stat -instinfo</b> <em>instId</em>: returns data describing the given instance id. See [Instance List Data] for a description of the result.
}
{sl_kill} {
The sl_kill command can be usd to kill a process. Vsd uses it to stop a statmonitor it is managing.
!Usages
   * <b>sl_kill</b> <em>pid</em>: kills the process with the given pid.
}

{VSD Files} {
The following files are created by VSD:
   * <u><tt>~/.vsdrc</tt></u> The <em>memory file</em> is written each time VSD exits. Its read\
each time VSD starts. VSD uses it to remember its configuration. Deleting it\
will force VSD back to its factory settings.
   * <u><tt>~/.vsdconfig</tt></u> The <em>config file</em> is never written be VSD. Its read\
and interpreted each time VSD is started. It can be used to reconfigure VSD's\
defaults. Its syntax is [Tcl > Tcl Language].
   * <u><tt>~/.vsdtemplates</tt></u> The <em>template file</em> is read when VSD is started\
and any time the [Template Menu <b>Reload Template File</b> Item] is selected.\
Its written whenever the [Chart Menu <b>Save Template</b> Item] is selected.\
See [Template Syntax] for a description of its contents.
   * <u><tt>bin/vsd</tt></u> The <em>source file</em> is never written be VSD. Its read and interpreted each time VSD is started. It contains most of VSD's implementation. Its syntax is [Tcl > Tcl Language].
   * <u><tt>bin/vsdwish</tt><em>OS</em></u> The <em>binary file</em> is never written be VSD. Its used to start VSD. Its the virtual machine that interprets the [Tcl > Tcl Language] code. The <em>OS</em> part of the name is a platform dependent suffix that names the operating system the binary file will run on.

The <tt>~</tt> represents your home directory. If you are not sure what\
directory VSD is using as your home you can see the absolute paths to these files [here > About VSD].
}

{CacheTooSmall Template} {
The intent of this template is to give you the statistics that will allow you to determine if the shared page cache needs to be made larger.
   * [FreeFrameCount > FreeFrameCount Statistic] for each [shrpc > Shrpc Type] on the [Right Y Axis].
   * [FramesFromFindFree > FramesFromFindFree Statistic] for each [shrpc > Shrpc Type].
   * [FramesFromFreeList > FramesFromFreeList Statistic] for each [shrpc > Shrpc Type]

See [Shared Page Cache Health] for help on shared page cache sizing. 
}

{CommitInfo Template} {
The intent of this template is to give a picture of the overall transactional throughput.
   * [TotalCommits > TotalCommits Statistic] for each [stone > Stn Type].
   * [CommitRecordCount > CommitRecordCount Statistic] for each [stone > Stn Type] on the [Right Y Axis].
   * [CommitQueueSize > CommitQueueSize Statistic] for each [stone > Stn Type] on the [Right Y Axis].
}

{EpochSweeps Template} {
The intent of this template is to show statistics related to repository epoch garbage collection.
   * [EpochCount > EpochCount Statistic] by [combining > Main Menu Combine Item] all [stone > Stn Type].
   * [EpochScannedObjs > EpochScannedObjs Statistic] by [combining > Main Menu Combine Item] all [stone > Stn Type] on the [Right Y Axis].
   * [EpochNewObjsSize > EpochNewObjsSize Statistic] by [combining > Main Menu Combine Item] all [stone > Stn Type] on the [Right Y Axis].
   * [EpochPossibleDeadSize > EpochPossibleDeadSize Statistic] by [combining > Main Menu Combine Item] all [stone > Stn Type] on the [Right Y Axis].
   * [PossibleDeadSize > PossibleDeadSize Statistic] by [combining > Main Menu Combine Item] all [stone > Stn Type] on the [Right Y Axis].
}

{Garbage Template} {
The intent of this template is to give a picture of the overall repository garbager collection activity.
   * [PagesNeedReclaimSize > PagesNeedReclaimSize Statistic] by [combining > Main Menu Combine Item] all [stone > Stn Type] on the [Right Y Axis].
   * [ReclaimedPagesCount > ReclaimedPagesCount Statistic] by [combining > Main Menu Combine Item] all [stone > Stn Type] on the [Right Y Axis].
   * [EpochCount > EpochCount Statistic] by [combining > Main Menu Combine Item] all [stone > Stn Type].
   * [ReclaimCount > ReclaimCount Statistic] by [combining > Main Menu Combine Item] all [stone > Stn Type].
   * [CommitCount > CommitCount Statistic] by [combining > Main Menu Combine Item] all [sessions > Session Type] named <b>*Gc</b>.
}

{PageServer Template} {
This template gives a picture of the overall async-io done by page servers.
   * [AioDirtyCount > AioDirtyCount Statistic] by [combining > Main Menu Combine Item] all [page servers > Pgsvr Type].
   * [AioCkptCount > AioCkptCount Statistic] by [combining > Main Menu Combine Item] all [page servers > Pgsvr Type].
   * [LocalDirtyPageCount > LocalDirtyPageCount Statistic] for each [shrpc > Shrpc Type].

See [AIO page servers] for more information.
}

{SpaceFree Template} {
This template gives you the statistics that allow you to determine how much of a resource is available. Currently the only resources supported by this template are the shared page cache and the object repository.
   * [FreeFrameCount > FreeFrameCount Statistic] for each [shrpc > Shrpc Type].
   * [FreePages > FreePages Statistic] for each [stone > Stn Type] on the [Right Y Axis].

See [Shared Page Cache Health] for help on shared page cache sizing. 
}

{CPU Template} {
This template gives a picture of overall CPU usage. It shows one set of statistics for Solaris, and another for NT.
!Solaris
   * [UserTime > UserTime Statistic] by [combining > Main Menu Combine Item] all instances.
   * [PercentCpuActive > PercentCpuActive Statistic] for each [Solaris system > SolarisSystem Type] on the [Right Y Axis].
   * [PercentCpuWaiting > PercentCpuWaiting Statistic] for each [Solaris system > SolarisSystem Type] on the [Right Y Axis].
!Windows NT
   * [SysTime > SysTime Statistic] by [combining > Main Menu Combine Item] all instances.
   * [TotalProcessorTime > TotalProcessorTime Statistic] for each [NT system > NtSystem Type].
   * [ProcessorQueueLength > ProcessorQueueLength Statistic] for each [NT system > NtSystem Type] on the [Right Y Axis].
}

{CacheMix Template} {
The intent of this template is to give a picture of the overall [Shared Page Cache Health]. When you bring up this template, the following stats are displayed:
   * [FreeFrameCount > FreeFrameCount Statistic] for each [shrpc > Shrpc Type] on the [Right Y Axis].
   * [LocalDirtyPageCount > LocalDirtyPageCount Statistic] for each [shrpc > Shrpc Type]
   * [FreeFrameLimit > FreeFrameLimit Statistic] for each [shrpc > Shrpc Type]
   * [BitlistPagesWrittenByGem > BitlistPagesWrittenByGem Statistic] for each [shrpc > Shrpc Type]
   * [BitlistPagesWrittenByStone > BitlistPagesWrittenByStone Statistic] for each [shrpc > Shrpc Type]
   * [BmInternalPagesWrittenByGem > BmInternalPagesWrittenByGem Statistic] for each [shrpc > Shrpc Type]
   * [BmInternalPagesWrittenByStone > BmInternalPagesWrittenByStone Statistic] for each [shrpc > Shrpc Type]
   * [BmLeafPagesWrittenByGem > BmLeafPagesWrittenByGem Statistic] for each [shrpc > Shrpc Type]
   * [BmLeafPagesWrittenByStone > BmLeafPagesWrittenByStone Statistic] for each [shrpc > Shrpc Type]
   * [CommitRecordPagesWrittenByGem > CommitRecordPagesWrittenByGem Statistic] for each [shrpc > Shrpc Type]
   * [CommitRecordPagesWrittenByStone > CommitRecordPagesWrittenByStone Statistic] for each [shrpc > Shrpc Type]
   * [DataPagesWrittenByGem > DataPagesWrittenByGem Statistic] for each [shrpc > Shrpc Type]
   * [OtInternalPagesWrittenByGem > OtInternalPagesWrittenByGem Statistic] for each [shrpc > Shrpc Type]
   * [OtInternalPagesWrittenByStone > OtInternalPagesWrittenByStone Statistic] for each [shrpc > Shrpc Type]
   * [OtLeafPagesWrittenByGem > OtLeafPagesWrittenByGem Statistic] for each [shrpc > Shrpc Type]
   * [OtLeafPagesWrittenByStone > OtLeafPagesWrittenByStone Statistic] for each [shrpc > Shrpc Type]
}

{Shared Page Cache} {
The SPC serves three types of data to the processes attached to the cache:

   * data pages
      * [DataPagesWrittenByGem > DataPagesWrittenByGem Statistic]
   * object table pages
      * [OtInternalPagesWrittenByGem > OtInternalPagesWrittenByGem Statistic]
      * [OtLeafPagesWrittenByGem > OtLeafPagesWrittenByGem Statistic]
   * commit record pages
      * [BitlistPagesWrittenByGem > BitlistPagesWrittenByGem Statistic]
      * [BmInternalPagesWrittenByGem > BmInternalPagesWrittenByGem Statistic]
      * [BmLeafPagesWrittenByGem > BmLeafPagesWrittenByGem Statistic]
      * [CommitRecordPagesWrittenByGem > CommitRecordPagesWrittenByGem Statistic]

There is a smattering of other types of data in the cache, but the types listed above cover 99% of the cases.

If you create a VSD chart from the [CacheMix Template], you can see the mix of these different types of pages in the cache as it performs various operations.

In a healthy cache, [DataPagesWrittenByGem > DataPagesWrittenByGem Statistic] will dominate. If you have a large number of objects in the repository, then you will start to see a sizable number of object table pages ([OtInternalPagesWrittenByGem > OtInternalPagesWrittenByGem Statistic] and [OtLeafPagesWrittenByGem > OtLeafPagesWrittenByGem Statistic]). Other page types may rise and fall within cache while certain maintenance operations are being performed.

!How big should I make my shared page cache?

The optimal cache size should be able to handle the working set of data pages, object table pages and commit record pages during your most time critical system operating periods.

!If your shared page cache is too small:

Your sessions will be performing too many [LocalPageCacheMisses > LocalPageCacheMisses Statistic]. Before taking any action, compare the [LocalPageCacheMisses > LocalPageCacheMisses Statistic] for the session with the [ObjsReadCount > ObjsReadCount Statistic]. 

   * If they are equal, then every time your session references an object that has not been loaded into the vm's object memory, you are being forced to load the page that that object resides on from disk into the shared page cache. You can double check by comparing [LocalPageCacheMisses > LocalPageCacheMisses Statistic] to the [PagesPreempted > PagesPreempted Statistic] stat in the [shrpc > Shrpc Type] - these two stats should be roughly equivalent. You can probably benefit from a larger cache size.

   * If the [LocalPageCacheMisses > LocalPageCacheMisses Statistic] is a small percentage of your [ObjsReadCount > ObjsReadCount Statistic], then your cache is pretty close to the right size. 

   * If [ObjsReadCount > ObjsReadCount Statistic] is a very small percentage of the [LocalPageCacheMisses > LocalPageCacheMisses Statistic], yet the absolute number of [LocalPageCacheMisses > LocalPageCacheMisses Statistic] is very high, then you may be taking hits on object table page references or a commit record backlog. First check your stone's [CommitRecordCount > CommitRecordCount Statistic]. If it is in the 1000's, then you have a commit record backlog problem. Finally, take a look at [ObjTablePageReads > ObjTablePageReads Statistic]. If they are roughly equal then you'll need to increase the cache size. 

An alternative to increasing the size of the shared page cache is to increase the size of the POM Cache in the vm. If the cache misses are due to object reads, then this technique could reduce the need to increase the size of the shared page cache.

!If your shared page cache is too large:

See also: [Shared Page Cache Health], [Writing]
}

{AIO page servers} {
!How many AIO page servers do I need?
The system will not let you allocate more than one page server per extent. I have heard that two or three extents per aio page server is a good rule of thumb.

You can tell you need more if:
   * [LocalDirtyPageCount > LocalDirtyPageCount Statistic] is taking up close to a third or more of the frames in the cache.
AND
   * The [AioWakeupInterval > AioWakeupInterval Statistic] for page servers named <b>aioWriter</b> (the aio threads in the [SAP]) is spending noticeable time at 0. When [AioWakeupInterval > AioWakeupInterval Statistic] is at zero the thread is scanning the cache and writing pages as fast as it can.

Each page server thread has 4 thresholds of interest:
   *  [LocalDirtyPageCount > LocalDirtyPageCount Statistic] < 1% of cache
idle. [AioWakeupInterval > AioWakeupInterval Statistic] threshold equal to 1000 milliseconds.
   *  1% of cache < [LocalDirtyPageCount > LocalDirtyPageCount Statistic] < 50% of cache
1 cache scan per second. [AioWakeupInterval > AioWakeupInterval Statistic] threshold equal to 1000 milliseconds.
   *  50% of cache < [LocalDirtyPageCount > LocalDirtyPageCount Statistic] > 75% of cache
1 cache scan per 1/2 second. [AioWakeupInterval > AioWakeupInterval Statistic] threshold equal to 500 milliseconds.
   *  75% of cache < [LocalDirtyPageCount > LocalDirtyPageCount Statistic]
continuous cache scans. [AioWakeupInterval > AioWakeupInterval Statistic] threshold equal to 0 milliseconds.

See also: [Extents and Tranlogs], [Shared Page Cache Health]
}

{Extents and Tranlogs} {
!What's the skinny on Raw Partitions?
Put your tranlogs on raw partitions

   * Tranlog i/o is the number one limiting factor in commit performance.
   * If you don't put your tranlogs on a raw partition, then at least make sure that your tranlog directory is not on the same spindle as your extents.
   * Try to alternate tranlogs across two spindles and archive one while the other is active.

Put extents on raw partitions

   * Since GemStone does random access to the extents, it is not as important to put your extents on raw partitions. In fact, because of the disk i/o buffering done by the os, file-based extents may lead to better performance.

Always put separate extents on separate spindles
   * If/when you add more [AIO page servers], you will get the optimal i/o performance by having each extent on a separate spindle.

!How many extents should I have?

You can tell if you need more extents if:
   * Your [AIO page servers] are maxed out and dirty pages are dominating your [shared page cache > Shared Page Cache Health].
OR
   * You are running out of space on your current disk partition.

!How big should I allow my extents to be?

!Which allocation mode should I use?
   * [Extent Allocation Modes]
}

{Extent Allocation Modes} {
   * Sequential Allocation Mode
   * Weighted Allocation Mode
}

{Writing} {
!Scenario Description:

In this scenario we are imagining that you are loading your repository with initial data. There is minimal repository reading going on and the primary activity is the creation of new objects that are to be stored in the repository (The extent stat [ExtentReadKBytes > ExtentReadKBytes Statistic] will be very, very low, if not zero and the extent stat [ExtentWriteKBytes > ExtentWriteKBytes Statistic] will be very high).

!Principle
The goal is to mazimize the [ObjsCommitted > ObjsCommitted Statistic] per second as this will be your true measure of performance. 

!System Parameter Settings:

   * Reduce the size of the [shared page cache > Shared Page Cache]

With a minimum amount of reading going on the primary purpose of the cache is to provide a home for dirty pages until the [AIO page servers] are able to write the dirty pages to disk. The cache is also holding onto the active commit records. Use a large cache until you have maximized your commit rate and i/o rate, then reduce the size of the cache until The stone and/or sessions start getting [LocalPageCacheMisses > LocalPageCacheMisses Statistic]. 

Also keep an eye on the [WriteKBytes > WriteKBytes Statistic] stat for the disk volume where the tranlogs are being written. The stat should be fairly steady, so if you see swings in the write rate, take a look at the health of the stone.

!VM Parameter Settings:

   * Increase the [private page cache size > PrivatePageCacheSize Statistic] to eliminate any [FramesAddedToFreeList > FramesAddedToFreeList Statistic] activiy for the [sessions > Session Type] doing the writes.
   * Maximize the number of objects per commit. There is a fixed overhead per commit, so it is advantageous to commit as many objects per commit as possible. The primary limiting factor in this case is the amount of java heap ([ObjMemSize > ObjMemSize Statistic]) used by the session - the objects are kept in java object memory until the commit at which time the persistent objects can be gc'ed freeing up object memory for more new objects.

See also: [Extent Allocation Modes], [Shared Page Cache]
}

{Shared Page Cache Health} {
To check you shared page cache's heath bring up a chart using the [CacheMix Template] and take a look at the following three statistics:
   * [FreeFrameCount > FreeFrameCount Statistic]
   * [LocalDirtyPageCount > LocalDirtyPageCount Statistic]
   * [DataPagesWrittenByGem > DataPagesWrittenByGem Statistic]

[FreeFrameCount > FreeFrameCount Statistic] should be ratcheting along between 0 and 2000 frames. If [FreeFrameCount > FreeFrameCount Statistic] is flat-lined at zero, your working-set of pages may be larger than the cache. First check that the [sessions > Session Type] are not doing excessive [FramesAddedToFreeList > FramesAddedToFreeList Statistic], then consider increasing the size of the [Shared Page Cache].

[LocalDirtyPageCount > LocalDirtyPageCount Statistic] should be way less than a third of the cache. If there are lots of dirty pages in the cache, then take a look at adding more [AIO page servers].

The bulk of the pages in the cache should be [DataPagesWrittenByGem > DataPagesWrittenByGem Statistic]. 

If you see a large number of [CommitRecordPagesWrittenByGem > CommitRecordPagesWrittenByGem Statistic], [BitlistPagesWrittenByGem > BitlistPagesWrittenByGem Statistic], [BmInternalPagesWrittenByGem > BmInternalPagesWrittenByGem Statistic], or [BmLeafPagesWrittenByGem > BmLeafPagesWrittenByGem Statistic], you may be suffering from a high commit record backlog and you should take steps to alleviate that situation.

See also: [AIO page servers], [Shared Page Cache]
}

{Chart Menu Add From Template SubMenu} {
This submenu has an item for every template.\
Selecting one of these items causes that template to be [expanded > Template Expansion]\
and every line the expansion produces is added to this chart.

[Selection Key > Keyboard Selection Keys]: <tt>Alt-a</tt>

This menu can be [torn off > Tear Off Menus].

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Save Template Item} {
Selecting this menu item causes all of the lines on the chart to be\
saved as a template.
The saved template is written to the [template file > VSD Files].

The name of the template will be based upon the chart window's name.
You can rename the template by editing the [template file > VSD Files] and [reloading > Template Menu Reload Template File Item] it

Each line on the chart is used as a pattern when saving it to the template.\
Exact information on the instances is no recorded in the template.\
This is so when the template is used later, with another file, it should\
be able to match some of its instances. In some case the saved template\
can be made more useful by editing the [template file > VSD Files].\
Also some template features can only be used by directly editing the file.

[Selection Key > Keyboard Selection Keys]: <tt>Alt-s</tt>

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Paste Item} {
Selecting this menu item causes the last item that was cut or copied\
to be added to this chart as one or more lines. If it finds something\
on the clipboard to paste it will remove that item from the clipboard.\
A paste operation does nothing if the clipboard is empty.

A paste can also be done with a host dependent <em>Paste</em> key.

[Accelerator Key > Keyboard Accelerators]: <tt>control-v</tt>

See [How to Cut, Copy, and Paste] for more information.

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Print Item} {
Selecting this menu item causes the chart to be printed. This is only supported on Unix platforms. The command name stored in the <tt>vsd(exec:lpr)</tt> variable is executed with the contents of a postscript file. The default value of this variable is <tt>lpr</tt> and can be customized in the [config file > VSD Files].

The temporary postscript file is written to VSD's working directory. Use [Main Menu Change Directory... Item] to change this directory.

[Accelerator Key > Keyboard Accelerators]: <tt>control-p</tt>

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Snapshot Item} {
Selecting this menu item causes a picture of the chart to be taken and written to the file <tt>snapshot.gif</tt>. The file is always written to VSD's working directory and any existing file will be overwritten. Use [Main Menu Change Directory... Item] to change the working directory.

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Help... Item} {
Selecting this menu item causes a [help window > Help Window Features] to\
popup with a description of the [chart window > Chart Window Features].

[Selection Key > Keyboard Selection Keys]: <tt>Alt-h</tt>

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Zoom In Item} {
Selecting this menu item begins a zoom in operation on the chart's\
graph. A zoom in consists of the following steps:
   1 Click in the graph at the point you wish to be the upper left hand corner.
   1 Click in the graph at the point you wish to be the lower right hand corner.

Once the operation has begun it can be canceled at any time with\
a right click of the mouse.

See [How to Zoom] for more information.

[Accelerator Key > Keyboard Accelerators]: <tt>control-z</tt>

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Zoom Out Item} {
Selecting this menu item does a zoom out operation on the chart's\
graph. A zoom out will reverse the effects of the most recent zoom in.\
A zoom out does nothing unless the graph is zoomed in at least\
once.

A right click of the mouse over the graph will also do a zoom out.

See [How to Zoom] for more information.

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Data Statistics} {
The following statistics on sets of data values are supported by VSD:
   * <b>count</b>: the number of points in the data set.
   * <b>min</b>: the minimum Y value of the points in the data set.
   * <b>max</b>: the maximum Y value of the points in the data set.
   * <b>mean</b>: the average Y value of all the points in the data set.
   * <b>stddev</b>: the standard deviation of all the Y values in the data set.\
Larger standard deviation values mean that more values far away from the\
average exist.
}

{Selecting a Point for an Operation} {
Various chart operations require that you select one or more points on a\
chart's graph. In most of these cases the mouse cursor changes to cross hairs\
to tell you that the graph is in a special mode. Once the mouse cursor is\
over a valid point that can be selected the it changes to a target.\
If you click when its a target the point will be selected.

Note that during this process the mouse will automatically highlights the\
line its closest to and display the coordinates of the line point its\
closest to. See [How to Get Information About a Location] for more information.

In some cases the point must be on a certain line. If another line is\
nearby you may have trouble with its point always being selected instead\
the line you need. Move the line to its own chart or rescale it or change\
its Y axis to remedy this problem.
}

{Chart Menu Compute Scale All Item} {
Selecting this menu item causes every line on the chart to have an\
[optimal scale > Line Menu Compute Scale Item] computed for it.

[Accelerator Key > Keyboard Accelerators]: <tt>control-S</tt>

For more information on scaling see [Display Scaling a Line].

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Unscale All Item} {
Selecting this menu item causes every line on the chart to be\
[unscaled > Line Menu Compute Scale Item].

[Accelerator Key > Keyboard Accelerators]: <tt>control-N</tt>

For more information on scaling see [Display Scaling a Line].

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Show Legend Item} {
If this item is on then the [chart window > Chart Window Features] will have a [legend > Graph Legend] control.\
Screen space can be saved by turning it off. If it is turned off then\
a description of the selected line will be printed in the  upper left corner of\
the [graph > Graph Display].

Use [Main Chart Menu <b>Show Legend</b> Item] to control the initial state\
of this item.

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Time Format SubMenu} {
This submenu controls what format a timestamp will be displayed in.\
It allows any one, and only one, of the following formats to be selected:
   * [Elapsed Time in Seconds > Elapsed Time in Seconds Format] 
   * [Hour:Minute:Second > Hour:Minute:Second Format]
   * [Month/Day Hour:Minute:Second > Month/Day Hour:Minute:Second Format]

[Selection Key > Keyboard Selection Keys]: <tt>Alt-t</tt>

This menu can be [torn off > Tear Off Menus].

Use [Main Chart Menu <b>Time Format</b> SubMenu] to control the initial state\
of this item.

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Elapsed Time in Seconds Format} {
Use this format to get the least amount of information printed about the timestamp.

If the time stamp is [relative > Main Menu Absolute TimeStamps Item]\
then this is the number of seconds since the first sample in the file\
it is from. The exact format is <u><em>num</em><b>s</b></u> where:
   * <em>num</em> is a sequence of digits
   * <b>s</b> stands for seconds

If the time stamp is [absolute > Main Menu Absolute TimeStamps Item]\
then just the time of day in hours, minutes, and seconds is printed.\
This is exactly the same as the [Hour:Minute:Second Format].
}

{Hour:Minute:Second Format} {
If the time stamp is [relative > Main Menu Absolute TimeStamps Item]\
then this is the number of hours, minutes, and seconds\
since the first sample in the file it is from.\
Only non-zero counts are show.\
The exact format is\
<u><em>num</em><b>h</b><em>num</em><b>m</b><em>num</em><b>s</b></u> where:
   * <em>num</em> is a sequence of digits
   * <b>h</b> stands for hours
   * <b>m</b> stands for minutes
   * <b>s</b> stands for seconds

If the time stamp is [absolute > Main Menu Absolute TimeStamps Item]\
then just the time of day in hours, minutes, and seconds is printed.\
The exact format is <u><em>hours</em><b>:</b><em>minutes</em><b>:</b><em>seconds</em></u> where:
   * <em>hours</em> is a value in the range 0..23; two digits are always printed.
   * <em>minutes</em> is a value in the range 0..59.
   * <em>seconds</em> is a value in the range 0..61;\
the value 60 allows for the occasional leap second;\
the value 61 allows for the occasional double leap second.
}

{Month/Day Hour:Minute:Second Format} {
If the time stamp is [relative > Main Menu Absolute TimeStamps Item]\
then this is the elapsed number of days, hours, minutes, and seconds\
since the first sample in the file it is from.\
Only non-zero counts are show.\
The exact format is\
<u><em>num</em><b>d</b><em>num</em><b>h</b><em>num</em><b>m</b><em>num</em><b>s</b></u> where:
   * <em>num</em> is a sequence of digits
   * <b>h</b> stands for days
   * <b>h</b> stands for hours
   * <b>m</b> stands for minutes
   * <b>s</b> stands for seconds

If the time stamp is [absolute > Main Menu Absolute TimeStamps Item]\
then the month, day of the month, and  the time of day in hours, minutes, and seconds is printed.\
The exact format is <u><em>month</em><b>/</b><em>day</em> <em>hours</em><b>:</b><em>minutes</em><b>:</b><em>seconds</em></u> where:
   * <em>month</em> is a value in the range 1..12; two digits are always printed.
   * <em>day</em> is a value in the range 1..31; two digits are always printed.
   * <em>hours</em> is a value in the range 0..23; two digits are always printed.
   * <em>minutes</em> is a value in the range 0..59.
   * <em>seconds</em> is a value in the range 0..61;\
the value 60 allows for the occasional leap second;\
the value 61 allows for the occasional double leap second.
}

{Chart Menu Show Time Axis Title Item} {
If this item is on then the [chart window > Chart Window Features] will display a title under the graph's [X Axis].
Screen space can be saved by turning it off.

Use [Main Chart Menu <b>Show Time Axis Title</b> Item] to control the initial state\
of this item.

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Show Left Axis Title Item} {
If this item is on then the [chart window > Chart Window Features] will display a title next to the graph's [Left Y Axis].
Screen space can be saved by turning it off.

Use [Main Chart Menu <b>Show Left Axis Title</b> Item] to control the initial state\
of this item.

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Show Right Axis Title Item} {
If this item is on then the [chart window > Chart Window Features] will display a title next to the graph's [Right Y Axis].
Screen space can be saved by turning it off.

Use [Main Chart Menu <b>Show Right Axis Title</b> Item] to control the initial state\
of this item.

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Show Current Values Item} {
If this item is on then the [chart window > Chart Window Features] will have\
[X: > Chart Window X: Display] and [Y: > Chart Window Y: Display] controls
Screen space can be saved by turning it off.

Use [Main Chart Menu <b>Show Current Values</b> Item] to control the initial state\
of this item.

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Show Min and Max Item} {
If this item is on then the [chart window > Chart Window Features]\
will have [Min: > Chart Window Min: Display] and [Max: > Chart Window Max: Display] controls.
Screen space can be saved by turning it off.

Use [Main Chart Menu <b>Show Min and Max</b> Item] to control the initial state\
of this item.

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Show Line Stats Item} {
If this item is on then the [chart window > Chart Window Features]\
will display [line statistics > Data Statistics] in the upper left corner of its [graph > Graph Display].
Turning it off saves the cost of computing these statistics and can make it easier to view lines with points in the upper left corner.

Use [Main Chart Menu <b>Show Line Stats</b> Item] to control the initial state\
of this item.

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Show CrossHairs Item} {
If this item is on then the [chart window > Chart Window Features] will draw cross hair lines on its [graph > Graph Display].

Use [Main Chart Menu <b>Show CrossHairs</b> Item] to control the initial state\
of this item.

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Show Grid Lines Item} {
If this item is on then the [chart window > Chart Window Features] will draw dotted grid lines on its [graph > Graph Display].

Use [Main Chart Menu <b>Show Grid Lines</b> Item] to control the initial state\
of this item.

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Close Item} {
Selecting this item causes the chart window to no longer exist.\
This can also be done using the native window manager.

To close all your chart windows use the [Main Chart Menu <b>Close All Charts</b> Item].

This item is part of the [chart menu > Chart Window Chart Menu].
}


{Chart Window Line Menu} {
This menu is disable until a [line is selected > How to Select a Line].
Operations on this menu apply to the selected line.

[Selection Key > Keyboard Selection Keys]: <tt>Alt-l</tt>

This menu can be [torn off > Tear Off Menus].

This menu is on each [chart window > Chart Window Features].

!Items
   * [Log Info > Line Menu Log Info Item]
   * [Log Delta > Line Menu Log Delta Item]
   * [Compute Scale > Line Menu Compute Scale Item]
   * [Unscale > Line Menu Unscale Item]
   * [Graph on Left Axis > Line Menu Graph on Left Axis Item]
   * [Symbol > Line Menu Symbol SubMenu]
   * [Style > Line Menu Style SubMenu]
   * [Update > Line Menu Update Item]
   * [Add Lines > Line Menu Add Lines Item]
   * [Diff Lines > Line Menu Diff Lines Item]
   * [Divide Lines > Line Menu Divide Lines Item]
   * [Normalize > Line Menu Normalize Item]
   * [Trim Left > Line Menu Trim Left Item]
   * [Trim Right > Line Menu Trim Right Item]
   * [Untrim Left > Line Menu Untrim Left Item]
   * [Untrim Right > Line Menu Untrim Right Item]
   * [Copy > Line Menu Copy Item]
   * [Cut > Line Menu Cut Item]
   * [Delete > Line Menu Delete Item]
}

{Line Menu Log Info Item} {
Selecting this item causes information on the current line to be written to the [log window >Log Window]. The information includes:
   * A description of the line's instances and statistic
   * the line's [value scale > Value Scaling a Line] if any
   * the line's [offset > Offsetting a Line] if any
   * the line's filter. The prefix <tt>filter:</tt> is used.
   * the line's units. The prefix <tt>units:</tt> is used.
   * an indicator if the line was normalized. The keyword <tt>normalized</tt> is used.
   * the line's files. The prefix <tt>file:</tt> or <tt>files:</tt> is used.
   * if the line is a [combination > Main Menu Combine Item] of more than one instance then a list of each of the instances. The keyword <tt>dataSources:</tt> heads this section.
   * if the line was created using [arithmetic > Line Arithmetic] then full information, except for line statistics, is given on each of the derived lines. Also the operator used is show.
   * the line's statistics which include:
      * the statistic range. This consists of the times of the first and last sample used to compute the statistics
      * the minimum value in the statistic range
      * the maximum value in the statistic range
      * the average of all the values in the statistic range
      * the standard deviation of all the values in the statistic range

[Selection Key > Keyboard Selection Keys]: <tt>Alt-i</tt>

This item is part of the [line menu > Chart Window Line Menu].
}

{Line Menu Log Delta Item} {
This operation item allows you to [log > Log Window] information obtained\
by comparing two points.

[Accelerator Key > Keyboard Accelerators]: <tt>control-d</tt>

Once the operation has begun it can be canceled at any time with\
a right click of the mouse.

!Usage
   1 Select the line the two points are on.
   1 Select the item.
   1 [Select > Selecting a Point for an Operation] the first point.
   1 [Select > Selecting a Point for an Operation] the second point. A thin black line will be drawn between the\
first point and the mouse cursor to remind you of what you are comparing.
   1 View the [logged > Log Window] information.

!Logged Information
The following information is logged by this operation:
   * A description of the line the points were on.
   * The exact coordinates of the two points.
   * <b>time delta</b>: the absolute difference between the two point's X coordinates.
   * <b>value delta</b>: the difference between the two point's Y coordinates.\
This is done by subtracting the first point's Y value from the second point's\
Y value.
   * <b>value/time delta</b>: the result of dividing the <em>value delta</em>\
by the <em>time delta</em>.
   * <b>data statistics</b>: [statistics > Data Statistics] for all the data points\
on the line between the two selected points.

This item is part of the [line menu > Chart Window Line Menu].
}

{Line Menu Compute Scale Item} {
Selecting this item sets the current lines [display scale > Display Scaling a Line] to a value such that the lines maximum value will display at the top of the Y axis its plotted on.

[Accelerator Key > Keyboard Accelerators]: <tt>control-s</tt>

This item is part of the [line menu > Chart Window Line Menu].
}
{Line Menu Unscale Item} {
Selecting this item sets the current line's [display scale > Display Scaling a Line] to one.

[Accelerator Key > Keyboard Accelerators]: <tt>control-n</tt>

This item is part of the [line menu > Chart Window Line Menu].
}
{Line Menu Graph on Left Axis Item} {
If this item is checked then the current line is plotted on the [left axis > Left Y Axis]. Otherwise its plotted on the [right axis > Right Y Axis]. If you have two lines whose values differ greatly then plotting them on seperate axis can help in comparing the two lines visually.

[Accelerator Key > Keyboard Accelerators]: <tt>control-a</tt>

This item is part of the [line menu > Chart Window Line Menu].
}
{Line Menu Symbol SubMenu} {
This submenu lets you select the symbol that will be used to display the data points of the current line. By default no symbol is used to the data points blend in with the lines that connect them. Using a symbol lets you see the actual data points. Symbols tend to blend together if you have a large number of data points so only use this feature when you have [zoomed > How to Zoom] in to a smaller region. The symbols are:
   * <b>scross</b>: a simple X
   * <b>splus</b>: a simple +
   * <b>square</b>: a square
   * <b>triangle</b>: a triangle
   * <b>circle</b>: a circle
   * <b>diamond</b>: a diamond
   * <b>plus</b>: a fancy +
   * <b>cross</b>: a fancy X

[Selection Key > Keyboard Selection Keys]: <tt>Alt-s</tt>

This menu can be [torn off > Tear Off Menus].

This submenu is part of the [line menu > Chart Window Line Menu].
}
{Line Menu Style SubMenu} {
This submenu lets you select the style used to connect the data points when displaying the current line. The default style is <b>linear</b>. The style does not change the actual data points just the lines drawn between them. The available styles are:
   * <b>linear</b>: a simple line segment is drawn between each pair of data points.
   * <b>step</b>: two line segments are drawn between each pair of data points. The first is a horizontal line segment that steps to the next X-coordinate. The second is a vertical line that steps to the next Y-coordinate.
   * <b>natural</b>: multiple line segments, generated using a cubic spline, are drawn between each pair of data points.
   * <b>quadratic</b>: multiple line segments, generated using a quadratic spline, are drawn between each pair of data points.

[Selection Key > Keyboard Selection Keys]: <tt>Alt-t</tt>

This menu can be [torn off > Tear Off Menus].

This submenu is part of the [line menu > Chart Window Line Menu].
}
{Line Menu Update Item} {
Selecting this item will cause all the files used by the current line to be [updated > How to Update the View of a Data File] which may result in the line becoming longer.

[Accelerator Key > Keyboard Accelerators]: <tt>control-u</tt>

This item is part of the [line menu > Chart Window Line Menu].
}
{Line Menu Add Lines Item} {
Selecting this item starts the process of adding another line to the current line. Vsd will prompt you to select the other line. You can <em>left click</em> on either the line or its [legend > Graph Legend] entry to select it. You can <em>right click</em> to cancel the operation. If you do select another line then a new line is produced which is the result of adding the first two lines together. See [line arithmetic > Line Arithmetic] for more information.

[Accelerator Key > Keyboard Accelerators]: <tt>control-+</tt>

This item is part of the [line menu > Chart Window Line Menu].
}
{Line Menu Diff Lines Item} {
Selecting this item starts the process of subtracting another line from the current line. Vsd will prompt you to select the other line. You can <em>left click</em> on either the line or its [legend > Graph Legend] entry to select it. You can <em>right click</em> to cancel the operation. If you do select another line then a new line is produced which is the result of subtracting the first line from the second. See [line arithmetic > Line Arithmetic] for more information.

[Accelerator Key > Keyboard Accelerators]: <tt>control--</tt>

This item is part of the [line menu > Chart Window Line Menu].
}
{Line Menu Divide Lines Item} {
Selecting this item starts the process of dividing the current line by another line. Vsd will prompt you to select the other line. You can <em>left click</em> on either the line or its [legend > Graph Legend] entry to select it. You can <em>right click</em> to cancel the operation. If you do select another line then a new line is produced which is the result of dividing the first line by the second. See [line arithmetic > Line Arithmetic] for more information.

[Accelerator Key > Keyboard Accelerators]: <tt>control-/</tt>

This item is part of the [line menu > Chart Window Line Menu].
}
{Line Menu Normalize Item} {
If this item is checked then the line will be [normalized > Normalizing a Line]. Its renormalized any time its data points change.
If its not checked then you are free to set the line's [offset > Offsetting a Line] to any value.

This item is part of the [line menu > Chart Window Line Menu].
}
{Line Menu Trim Left Item} {
Selecting this item starts a trim left operation. You can either select a data point on the current line or <em>right click</em> to cancel the operation. To select a data point move the mouse over the line. The cursor will turn into a circle when its over a valid trim point. If you want to ignore all the data to the left of this trim point then <em>left click</em>.

See [File Trimming] for more information.

This item is part of the [line menu > Chart Window Line Menu].
}
{Line Menu Trim Right Item} {
Selecting this item start a trim right operation. You can either select a data point on the current line or <em>right click</em> to cancel the operation. To select a data point move the mouse over the line. The cursor will turn into a circle when its over a valid trim point. If you want to ignore all the data to the right of this trim point then <em>left click</em>.

See [File Trimming] for more information.

This item is part of the [line menu > Chart Window Line Menu].
}
{Line Menu Untrim Left Item} {
Selecting this item causes any left trims done to the current line's files to be undone. See [File Trimming] for more information.

This item is part of the [line menu > Chart Window Line Menu].
}
{Line Menu Untrim Right Item} {
Selecting this item causes any right trims done to the current line's files to be undone. See [File Trimming] for more information.

This item is part of the [line menu > Chart Window Line Menu].
}

{Line Menu Copy Item} {
Selecting this item makes a copy of the currently selected line and puts it on the paste clipboard. For more information see [How to Cut, Copy, and Paste].

[Accelerator Key > Keyboard Accelerators]: <tt>control-c</tt> or a host dependent <em>Copy</em> key.

This item is part of the [line menu > Chart Window Line Menu].
}
{Line Menu Cut Item} {
Selecting this item removes the currently selected line from the graph and puts it on the paste clipboard. For more information see [How to Cut, Copy, and Paste].

[Accelerator Key > Keyboard Accelerators]: <tt>control-x</tt> or a host dependent <em>Cut</em> key.

This item is part of the [line menu > Chart Window Line Menu].
}
{Line Menu Delete Item} {
Selecting this item deletes the currently selected line. Once its deleted it can not be undeleted.

You can also delete a line by middle clicking the mouse on its [legend > Graph Legend] entry.

[Accelerator Key > Keyboard Accelerators]: <tt>Del</tt>

This item is part of the [line menu > Chart Window Line Menu].
}

{Display Scaling a Line} {
You usually want to change the scale of a line because it looks like a\
flat line due to another line with very large values. The easiest thing\
you can do is graph the line on the other y axis. This will cause the\
line to be scaled independently of lines on the other axis.
The next easiest thing is to use the [Line Menu <b>Compute Scale</b> Item]. This will\
compute a scale value for the current line that make it visable on the\
current graph. You can quickly undo this with the [Line Menu <b>Unscale</b> Item].
You can also manually change the scale using the up or down arrow\
by the [number entry > Chart Window Number Entry] in the upper right corner of a chart. First click\
on the [button > Chart Window Operator MenuButton] next the the number entry and pick <b>S</b> from the dropdown.\
Each click doubles or halves the scale.
You can also enter any scale you want by clicking on the existing value and\
changing it using the keyboard.
The default scale is one. Changing the\
scale just causes the line to be drawn differently, it does not modify\
the actual values of the data points.
}

{Value Scaling a Line} {
The data points of a line can all be multiplied (or divided) by a constant. This is done\
by adding (or subtracting) a constant value from every data point on the line.
To specify a multiplier constant select a line and then click on the [button > Chart Window Operator MenuButton] next\
to the the number entry in the upper right corner of a chart window. Pick <b>*</b>\
or <b>/</b> from the dropdown and then enter the constant into the [number entry > Chart Window Number Entry].\
Each click of the up or down arrow doubles or halves the constant.
Multiplier constants are always done after the data is filtered and\
before an offset constant and scale constant are applied.
Note that unlike a scale, which is for display purposes only, a multiplier\
actually changes the y values of the line's data points. A common use\
is to change the units of a line. For example kilobytes can be changed to\
bytes by multiplying by 1024.
}

{Offsetting a Line} {
The data points of a line can all be offset by a constant. This is done\
by adding (or subtracting) a constant value from every data point on the line.
To specify an offset constant select a line and then click on the [button > Chart Window Operator MenuButton] next\
to the the number entry in the upper right corner of a chart window. Pick <b>+</b>\
or <b>-</b> from the dropdown and then enter the constant into the [number entry > Chart Window Number Entry].\
Each click of the up or down arrow change the offset constant by one.
Offset constants are always done after a multiplier constant is applied\
and before a scale constant is applied.
Note that the normalization feature automatically computes the offset so if\
a line is normalized then a user supplied constant is ignored.
}

{Normalizing a Line} {
If a line is normalized then an offset is computed so that its\
minimum data point will have a value of zero.\
The normalization offset is recomputed any time the data for the line changes.
If a line is normalized then it can not be offset by a constant value\
other than the one computed by the normalization code. 
Normalization is ignored unless the filter is "none".
}

{Tear Off Menus} {
If you find yourself constantly going back to the same menu item time\
after time you may find turning the menu into a button box helpful.\
If the menu has a dashed line at its top this indicates that the menu\
can be torn off. Once you do this it will be a box of buttons in its own\
window. Now you can just click on these buttons. For a nested menu you\
keep using this can be a real win.
The only way to get rid of a torn off menu is the use your window manager's\
window close or kill operation.
}

{List Multiple Selection} {
Some list items allow more than one item in the list to be selected.
   * A single item can be selected by clicking on it.
   * Multiple disjoint items can be selected by holding the <tt>Control</tt>\
key down when clicking on the items.
   * Multiple contiguous items can be selected by holding the <tt>Shift</tt> key down\
or by drag selecting.
   * A selected item can be deselected by holding the <tt>Control</tt>\
key down and clicking on it.
}

{String Entry Editing} {
When entering a string the following  special editing operations are available:
   * <tt>Control-a</tt> or the <em>Home</em> moves the cursor to the beginning of the string. If the shift modifier is used with the <em>Home</em> key then the selection is also extended to the beginning.
   * <tt>Control-e</tt> or the <em>End</em> key moves the cursor to the end of the string. If the shift modifier is used with the <em>End</em> key then the selection is also extended to the end.
   * <tt>Control-b</tt> moves the cursor back one character.
   * <tt>Control-f</tt> moves the cursor forward one character.
   * <tt>Control-t</tt> reverses the order of the two characters to the left of the cursor.
   * <tt>Control-k</tt> deletes all the characters to the right of the cursor.
   * <tt>Control-d</tt> or the <em>Delete</em> key deletes a single character to the right of the cursor.
   * <tt>Meta-d</tt> deletes a single word to the right of the cursor.
   * <tt>Control-/</tt> selects all the text.
   * <tt>Control-\</tt> clears any selection.
   * <tt>Control-h</tt> or the <em>Backspace</em> key deletes a single character to the left of the cursor if nothing is selected. Otherwise they delete the selection.
   * <tt>Meta-w</tt>, <tt>F16</tt>, or the <em>Copy</em> key copies the selection to the clipboard. Does nothing if no selection.
   * <tt>Control-w</tt>, <tt>F20</tt>, or the <em>Cut</em> key copies the selection to the clipboard and deletes the selection. Does nothing if no selection.
   * <tt>Control-y</tt>, <tt>F18</tt>, or the <em>Paste</em> key inserts the contents of the clipboard at the position of the cursor.
}

{Mouse Help} {
If you hold the mouse pointer over a widget explanatory text will appear\
in the [status box > Main Window Status Display].
}

{Bell Messages} {
If vsd ever beeps this indicates a warning or error.\
Look for the reason why in the [status box > Main Window Status Display].
Bell messages timeout after 10 seconds.
}

{Keyboard Selection Keys} {
Many menus, menu items, and buttons have a selection key. Selection keys are\
indicated by underlining a letter in the name of the control.\
Its used by holding down the <tt>Alt</tt> key and pressing the selection key.\
Using the selection key is equivalent to clicking the mouse on the control.
Keyboard selection keys are case-insensitive.
Keyboard selection keys only work if the control the selection key is bound\
to is visible on the screen and its window is selected.
}

{Keyboard Accelerators} {
Some menu items have keyboard accelerators.\
Accelerators allow you to quickly invoke a menu item.\
Accelerators are displayed next to the name of the menu item.\
Using the accelerator is equivalent to clicking the mouse on the item.
Keyboard accelerators are case-sensitive.
Keyboard accelerators work as long as the window the menu belongs to is selected.
}

{General Interface Features} {
   * [Tear Off Menus]
   * [List Multiple Selection]
   * [String Entry Editing]
   * [Mouse Help]
   * [Context Sensitive Help]
   * [Bell Messages]
   * [Keyboard Selection Keys]
   * [Keyboard Accelerators]
}

{Context Sensitive Help} {
A [help window > Help Window Features] containing context sensitive help can be created by pressing the <tt>F1</tt> key or your keyboard dependent <em>Help</em> key.
The help text will pertain to the window and widget that has keyboard focus.
}

{How to Load a Data File} {
[Type > String Entry Editing] in the full path in the [File: > Main Window File ComboBox] control and hit return.
The [Main Menu <b>Load Data File...</b> Item] can be used to browse for a file to load.
The command line can specify files to load when [vsd is started > How to Start VSD].
While a file is loading you can interrupt that load by clicking on\
the <b>Interrupt</b> button in the progress window. All the data already read\
will be available and the load can be continued later with the [File Menu <b>Update</b> Item].
You can also switch to a data file you already have loaded by dropping\
down the [File: > Main Window File ComboBox] control's list and selecting it.
You can get some information about a loaded data file with the [File Menu <b>Info...</b> Item].
For more information related to loaded files see [Controlling the Enabled Files].
}

{How to Update the View of a Data File} {
The [File Menu <b>Update</b> Item] will reread the current data file if it has\
changed since the last time vsd read it. It can also be used to continue\
the loading of a data file that was interrupted.\
Any charts displaying data from that file will also be updated.
If the [File Menu <b>Auto Update</b> Item] is turned on then vsd will keep doing the update\
operation everytime the file changes. The auto update interval is based\
on the sample interval of the data file.
}

{How to Create a Data File} {
Data files are created by a [statmonitor]. You can run the <tt>statmonitor</tt> command directly\
from the command line or you can use the [Main Menu <b>Monitor...</b> Item].
The [Monitor Window] will show you all the statistic sources on the local machine\
that you can monitor. Click on the sources you want stats for, adjust\
any of the startup parameters, and then click on Start.\
Vsd will automatically load the data file once it has some samples in it.
When you are done click on Stop. Vsd will shutdown any monitors it started\
when you exit vsd.
}

{How to Compare Files} {
In many cases vsd is used to compare multiple runs of the same load under\
different configurations or versions of the product.\
The following features facilitate comparsion of files:
   * Turn off the [Main Menu <b>Single File Mode</b> Item] so that more than one file can be loaded.
   * Turn on the [Main Menu <b>Combine</b> Item] and turn off the [Main Menu <b>Combine Across Files</b> Item]. This way\
you select a large group of object instances and get a line for each file\
being compared.
   * Turn off the [Main Menu <b>Absolute TimeStamps</b> Item] so that vsd will act as if each data\
run started at the same time.

Many data runs have a startup period at the beginning and a shutdown period at\
the end which are usually misleading for comparison purposes. To get rid\
of these do the following:
   * Chart a good representative line from each file.
   * Then for each line use the [Line Menu <b>Trim Left</b> Item] to get rid of all the data from the\
file's startup period and the [Line Menu <b>Trim Right</b> Item] to get rid of all the data from the\
file's shutdown period.
See [File Trimming] for more information.

If you want to compute the difference between two data runs then try this:
   * Chart a line from each data run's file.
   * Then select one of the lines and pick the [Line Menu <b>Diff Lines</b> Item] and\
then select the other line.
The result will be a third line whose values\
are the difference between the two original lines.\
See [Line Arithmetic] for more information.
}
 
{How to Merge Files} {
In some cases you may have multiple data files that you want to treat as\
a single file. If the files are in chronological order and have data for the same processes then you can simply concatenate them together into a single file. Just do it in the correct order. If they are compressed then you need to uncompress them before they can be concatenated.

A better way of concatenating a bunch of chronological files is to use vsd's append features. It can be done when vsd is started with the [-a > append load command line switch] switch. It can also be done interactively with the [Append Data File... > Main Menu Append Data File... Item] menu item.

Another way is to use the external <tt>statmerge</tt> tool which reads multiple files a writes all their data to a single new file. Its best to use <tt>statmerge</tt> when you have multiple files with samples that need to be woven together because they took place at the same time on different machines.

The following features facilitate merging of files without using any of the above techniques:
   * Turn off the [Main Menu <b>Single File Mode</b> Item] so that more than one file can be loaded.
   * Turn on the [Main Menu <b>Combine Across Files</b> Item] so that when a combined line is created\
it will combine all the selected instances into a single line.
   * Turn on the [Main Menu <b>Absolute TimeStamps</b> Item] so that vsd will show the actual times\
each data sample was taken in each file.
}
{Statmonitor Output Format} {
Files written by [statmonitor] have a simple text format. Vsd allows the files to be compressed using the standard gzip or lz4 format.
[statmonitor] support for writing file in lz4 format requires GemStone/64 version 3.4 or later.
Vsd also allows files to be concatenated. You should only concatenate files which do not overlap in time and they should be ordered by time when concatenated.

The first line of the file must be of the form:
   * <tt>STATMON "</tt><em>digits</em><tt>"</tt>
where <em>digits</em> is one or more digits. This number represents the format version used in writing the rest of the file. The following describes version <b>2</b> which is used by the current statmonitor and vsd.

A <em>propertyDefinition</em> has the form:
   * <em>propertyName</em><tt> = "</tt><em>propertyValue</em><tt>"</tt>
where <em>propertyName</em> is a name and <em>propertyValue</em> is a string.
The next four lines are <em>propertyDefinitions</em> with these names:
   1 <tt>Platform</tt>  the value describes the operating system that the file was generated on.
   1 <tt>GemStoneVersion</tt>  the value describes the version of statmonitor's product.
   1 <tt>Machine</tt>  the value describes specific details about the machine the file was generated on.
   1 <tt>Time</tt>  the value describes the time, including timezone, that the first sample was written.

The next item in the format is a definition of the instance types used. The form is:
   * <tt>StatTypes = &#91;</tt><em>typeList</em><tt>]</tt>
where a <em>typeList</em> is zero or more comma seperated <em>typeDefinitions</em>. A <em>typeDefinition</em> has the form:
   * <em>typeName</em><tt> ( </tt><em>statNames</em><tt> ) </tt><em>typeId</em>
where <em>typeName</em> is the name of the type, <em>typeId</em> is a number used to identity this type, and <em>statNames</em> is five or more names representing the type's statistics. These names define what the fields in each instance snapshot (see the following) is. The first five <em>statNames</em> must always be:
   1 <tt>StatTypeNum</tt>  the numeric id of the snapshot's type
   1 <tt>Time</tt>  the time the snapshot was taken
   1 <tt>ProcessName</tt>  a string describing the snapshot's instance
   1 <tt>ProcessId</tt>  a number describing the process associated with the snapshot's instance. Zero if no associated process.
   1 <tt>SessionId</tt>  a number uniquely identifying the snapshot's instance. Zero if not applicable.

The next line has the form:
   * <tt>%%%%Generated by the statistics monitor</tt>
The next line has the form:
   * <tt>ENDHEADER</tt>
The next line is a blank line.
After this each line is an instance snapshot. Each instance snapshot is a list of whitespace seperated strings. A string must be provided for each of the snapshot's type's statNames. Most of the strings are unsigned numbers.
}
{How to Start VSD} {
Vsd can be started with one or more command line arguments. Unless the argument is a switch its expected to be the name of a [statmonitor] output file to load.
!Switches
   * [-a       > append load command line switch]
   * [-b color > set master background color]
}

{append load command line switch} {
The <tt>-a</tt> command line switch causes all files loaded after this switch to be concatenated together. This is done by loading the first one after the <tt>-a</tt> normally and then [appending > Main Menu Append Data File... Item] the rest of the files to it. 
}
{set master background color} {
The <tt>-b color</tt> command line switch causes the master background color to be set to color.  The color may be specified by name (e.g.: white) or by RGB value (e.g.: #d3d3ff).  The master background color may also be set in the environment variable <tt>VSD_MASTER_BG_COLOR</tt>.  The following web page shows a complete list of colors accepted by VSD: <tt><u>http://www.tcl.tk/man/tcl8.4/TkCmd/colors.htm</u></tt>
}
{How to Select} {
Statistics are kept for a fixed number of [instances > Instance Definition]. The [types > Instance Type Definition] of the instances are defined by the data file but in most cases the well known types are used.

To graph a line you need to select the instances and statistic name of interest. The following links tell you how to control what instances and statistics will be available to select and how to do the actual selection.
   * [Controlling the Enabled Files]
   * [Controlling the Listed Object Instances]
   * [Controlling the Listed Statistic Names]
   * [How to Select Object Instances]
   * [How to Select Statistics]
}
 
{Controlling the Enabled Files} {
The main window will only let you see object instances from enabled files.\
Before a file can be enabled it first must be loaded.
If the [Main Menu <b>Single File Mode</b> Item] is checked then only one loaded file can be\
enabled at a time. In this mode each time a file is loaded it will enabled\
and the previous file disabled. If an already loaded file is picked from\
the [File: > Main Window File ComboBox] control then it becomes the enabled file.
If the [Main Menu <b>Single File Mode</b> Item] is unchecked then more than one loaded file can be\
enabled. Object instances for all the enabled files will be shown in the\
main window. The [File: > Main Window File ComboBox] control will show the current selected loaded file.\
The [Main Window File Menu] item's operate on this file. Each file can be\
explicitly enabled or disabled with the [File Menu <b>Enabled</b> Item].
}
 
{Controlling the Listed Object Instances} {
The order the instances are listed on can be controlled by clicking on\
the column header. The primary sort key will be the clicked on column which will include\
an up or down arrow.  Click on the same column again to reverse the order.  The secondary\
sort key may be selected by right-clicking on any column except the primary sort key\
column.  The secondary sort key is indicated by italic font in the column header.\
The secondary sort column is always sorted in the same order (ascending or descending) as\
the primary sort column.
If the [Main Menu <b>Single File Mode</b> Item] is checked then only instances from the\
most currently selected file will be listed. Otherwise the instances\
from every enabled file are listed. You can control which files are\
enabled by selecting the file with the [File: > Main Window File ComboBox] control and\
then using the [File Menu <b>Enabled</b> Item].
}
 
{Controlling the Listed Statistic Names} {
The statistics list will only contain the name of statistics that\
all of the selected instances have in common. If no instances are\
selected then all known statistics are listed.
If the [Main Menu <b>No Flatlines</b> Item] is unchecked then statistics whose values\
are all zero have names show in a light font.\
Otherwise these statistic names are not listed.
The [Main Menu <b>Statistic Level</b> SubMenu] lets you select what level of statistics\
are listed. Any statistics that belong to a level higher than the selected one\
will not be listed.
}
 
{How to Select Object Instances} {
If you are interested in just one instance select it by clicking on it.
If you are interested in all of the instances of a certain type then\
select them all. Only statistics the selected instances all have in common will be show.\
If the [Main Menu <b>Combine</b> Item] is checked then all the data for the selected instances\
will be added together when a line is created. Otherwise each instance\
will get its own line.\
If [Main Menu <b>Combine Across Files</b> Item] is checked then it will cause combine\
to ignore what file an instance is from. If its unchecked then only instances\
from the same file will be combined together.
To search for an instance enter <tt>control-s</tt>. A search window will popup\
in which you can type. Enter <tt>control-s</tt> or <tt>tab</tt> to find the next match.\
Enter <tt>return</tt> to get rid of the search window. If you enter a number then\
the search will be based on the process id field. Otherwise the name field\
is used.
Right clicking over the instance list gets a [popup menu > Instance List PopupMenu]. If you pick\
[Select > Instance List PopupMenu Select SubMenu] submenu you can then do one of the following:
   * The <b>Clear</b> item unselects all the instances.
   * The <b>All</b> item selects all the instances.
   * The <b>by Statistic</b> item will select all of the instances that support\
the currently selected statistics. This gives you an easy way to find\
what instances support a statistic you are interested in.
   * The <b>by Type</b> item will select instances whose type is the same as the\
type of a currently selected instance. So if you want all 'Sessions'\
selected just select one and then pick <b>by Type</b>.
}
 
{How to Select Statistics} {
Click on the statistic you want to select.
If you select [more than one > List Multiple Selection] statistic you get a line for each one.

To search for a statistic whose name starts with a known prefix simply\
type the letters of that prefix and the first statistic with that\
prefix will be shown.

To find a statistic whose name contains a known substring do a [search > List Search Control] by typing <tt>control-s</tt>.
}

{List Search Control} {
This control allows a list to be searched. The search always finds the next item in the list that has a substring containing the text being searched for. As text is typed in the search is done automatically. The control contains the text from the last search.

When doing an [instance > Main Window Instance Table] search if you just type in a number then only the <b>Pid</b> column is searched and vsd beeps when it finds a completely matching pid. Otherwise the search is done on the <b>Name</b> column. If you want to search for a number in the name column then you must also include a non-numeric prefix. For example to search for a session id prefix it with the <tt>-</tt> character.

!Bindings
   * [standard editing > String Entry Editing]
   * <tt>control-s</tt> or <tt>tab</tt> to find the next matching list element
   * <tt>control-r</tt> to find the previous matching list element
   * <tt>return</tt> or click somewhere else to terminate the search

The following controls support this control:
   * [Main Window Instance Table]
   * [Main Window Statistic List]
   * [Chart Window Statistic ComboBox]
   * [Statistic Window Name ComboBox]
}
 
{How to Get Statistic Information} {
If the [Main Menu <b>Show Statistic Info</b> Item] is checked then a\
[seperate window > Statistic Information Window]\
will be created that will be kept updated with information on the most\
currently selected statistic.
In the [statistic information window > Statistic Information Window] you can browse all the available statistics\
and modify the statistic's level and/or the statistic's default filter.\
Any modification will be saved when you exit vsd.
}
 
{How to Filter Statistics} {
The filters are: Default, None, PerSecond, PerSample, Smooth, and Aggregate.
<b>Default</b> gets you None if the statistic represents a snapshot of a value.\
It gets you PerSecond if the statistic represents a value that always increases.
<b>None</b> shows you the raw values for the statistic with no filtering at all.
<b>PerSample</b> shows you the difference between two consecutive samples\
of the statistic.
<b>PerSecond</b> is the same as PerSample except it divides the difference by the number\
of elapsed seconds between the two samples.
<b>Smooth</b> is like none except any values much larger or smaller than the average are smoothed out.
<b>Aggregate</b> shows you a running total of per sample deltas for the statistic.\
The running total is reset to zero when the current delta is zero or\
changes direction. For example if the last couple of delta where positive\
then a change in direction would be a delta with a negative value.
When a line is added to a chart the default filter is used.\
The default filter for a statistic can be redefined using the [Default Filter MenuButton].
Once the line is added you can change its filter using the [Chart Window Filter MenuButton].
}
 
{How to Create a New Chart} {
Select the [instances > How to Select Object Instances]\
and [statistics > How to Select Statistics]\
to display in the new chart and click on the\
[Main Window New Chart Button].
You can let VSD generate a name for the new chart or enter one yourself\
in the [Chart: > Main Window Chart ComboBox] control.
The new chart will be configured based on options found in the [Main Window Chart Menu].\
If you change these options they will be saved and used the next time\
you start vsd.

A chart window can be created with the following controls:
   * [Add Line > Main Window Add Line Button]
   * [New Chart > Main Window New Chart Button]
   * [Add To Chart > Main Chart Menu Add To Chart Item]
   * [New Template Chart > Template Menu New Template Chart SubMenu]

To learn more about what can be done with a chart see [Chart Window Features].
}
 
{How to Add a Line to an Existing Chart} {
Select the [instances > How to Select Object Instances]\
and [statistics > How to Select Statistics]\
to add and click on the [Main Window <b>Add Line</b> Button].\
The line will be added to the chart shown in the [Chart: > Main Window Chart ComboBox] control.
}
 
{How to Cut, Copy, and Paste} {
You can copy or cut the selected line from a chart.\
Once this is done it can be pasted once to a chart.\
This allows you to easily move lines from one chart to another and\
to create a copy of a line to modify without changing the orignal.
You can copy and paste the current object instance and statistic selection\
from the main window to a chart window. This allows for easier chart\
targeting in cases that you have a large number of charts.
A copy or cut puts an item on the clipboard and deletes any item that was\
already on the clipboard.
A paste causes the clipboard to be emptied.

!Keyboard Bindings
   * <b>Copy</b> is done with <tt>control-c</tt> or a host dependent <em>Copy</em> key.
   * <b>Cut</b> is done with <tt>control-x</tt> or a host dependent <em>Cut</em> key.
   * <b>Paste</b> is done with <tt>control-v</tt> or a host dependent <em>Paste</em> key.

!Related Menu Items
   * [copy selection > Main Menu Copy Selection Item]
   * [copy selected line > Line Menu Copy Item]
   * [cut selected line > Line Menu Cut Item]
   * [paste selection or line > Chart Menu Paste Item]
}
 
{How to Select a Line} {
Move the mouse onto the line you want to select. Once the line\
is highlighted click on it.
You can also select a line by clicking on it in the legend.
Deselect a line by clicking on it again.
}
 
{How to Get Information About a Location} {
Move the mouse in the graph itself.\
If the mouse gets close to a line it will be highlighted. Also if the\
mouse is close to an actual data point its X and Y values will be displayed.
}
 
{How to Delete a Line} {
Select the line and then use the [Line Menu <b>Delete</b> Item].
Or move the mouse over the line's [legend > Graph Legend] entry\
and click on the middle mouse button.
}
 
{How to Zoom} {
Zooming allows you see details in a particular area of a chart.\
It also removes some visual lossage that occurs when lots of samples\
are displayed on a finite sized chart. Multiple zoom levels are supported\
for each chart. Note that when a chart is zoomed data points that lie\
outside the zoom window will not be visible. Also the stats displayed for\
the selected line will exclude data points to the left or right of the zoom window.

A zoom in can be done in a number of ways.
<b>Time Zooms:</b> The easiest is to middle click the mouse in the area you want to\
see better. This only zooms the time (x) axis so it lets you easily focus\
on a point in time without any loss of value (y) axis in that time period.
<b>Box Zooms:</b> You can also zoom in using the [Chart Menu <b>Zoom In</b> Item].\
First start a zoom using the menu item.\
Then set the first point of the zoom by clicking on it with the left button.\
Now move the mouse to the other point and click again.\
A zoom can be cancelled by clicking the right mouse button.\
This zooms both the x and y axis so some data in the time period might\
not be visible on the graph.

You can adjust a zoom level by using the left or right arrow keys.\
This time shifts the zoom level by one sample. If you use the <tt>control</tt> key\
with the left or right arrow keys then the time shift is by however many\
time samples are in the zoom level.

To zoom out one level click the right mouse button over the graph or use
the [Chart Menu <b>Zoom Out</b> Item].
}
 
{How to Change a Line} {
First select the line. Then you can change its:
   * <b>statistic</b> using the [Chart Window Statistic ComboBox].
   * <b>filter</b> using the [Chart Window Filter MenuButton].
   * <b>data set</b> using [File Trimming].
   * <b>adder</b> using the [Chart Window Operator MenuButton] and the [Chart Window Number Entry]. See [Normalizing a Line] and [Offsetting a Line] for more information.
   * <b>muliplier</b> using the [Chart Window Operator MenuButton] and the [Chart Window Number Entry]. See [Value Scaling a Line] for more information.
   * <b>scale</b> using the [Chart Window Operator MenuButton] and the [Chart Window Number Entry]. See [Display Scaling a Line] for more information.
   * <b>display symbol</b> using the [Line Menu <b>Symbol</b> SubMenu].
   * <b>display axis</b> using the [Line Menu <b>Graph on Left Axis</b> Item].
}
 
{How to Compare Data} {
   * To see the difference between two points on the same line use the [Line Menu <b>Log Delta</b> Item].
   * To see the difference between all the points on two lines use the [Line Menu <b>Diff Lines</b> Item].
}

{How to Customize a Chart} {
Many menu items exist in the [Chart Window Chart Menu] that allow the chart display\
to be customized. Feel free to play with these; they will only change\
the current chart.
}

{Help Links} {
Help links are show in blue and underlined.\
If you click on a link then the link will be followed\
to the new help topic which will be displayed in the current window.\
If you <tt>control</tt> click or right click on a link then the new help\
topic will be shown in a new help window.
}

{Help Window Features} {
Any number of help windows can exist.

!How to Use A Help Window
   * [General Interface Features]
   * [Help Links]

!Keyboard Bindings
   * <tt>control-b</tt> goes back to the previous help view.
   * <tt>control-f</tt> goes forward after a back.
   * <tt>control-s</tt> pops up a [search window > Help Search Control].

!Help Controls
   * <b>Back</b> goes back to the previous help topic
   * <b>Forward</b> returns to a help topic left by going back.
   * <b>Search...</b> pops up a [search window > Help Search Control].
   * <b>Dismiss</b> closes the help window.
}

{Help Search Control} {
This control allows the text of help topics to be searched. Type in the text you are interested in finding. You will hear a beep if the text can not be found in the current help topic. By default the search is done on the help topic in the current window. You can search all topics by clicking on the <b>All Topics</b> button.
Searches are case-insensitive.

!Bindings
   * [standard editing > String Entry Editing]
   * <tt>control-s</tt>, <tt>tab</tt>, or the <b>Next</b> button to find the next match in the current help topic.
   * <tt>control-r</tt> or the <b>Prev</b> button to find the previous match in the curreent help topic.
   * the <b>All Topics</b> button causes a search to be done on all help topics. The help window's contents will change to a results topic which is a list of links to all the topics that contain the text.
   * <tt>return</tt> or click somewhere else to terminate the search
}

{Font Window} {
This dialog window lets you pick a font its used by the following:
   * [Choose Chart Font... > Main Chart Menu Choose Chart Font... Item]
   * [Choose Text Font... > Help Menu Choose Text Font... Item]
Its a modal dialog so it needs to be closed before the rest of vsd will respond to the mouse.
!Menus
This dialogs menu are used to pick the font. Any font you pick will be show immediately with some sample text in this dialog. If you want to see it in an actual window use the <b>Apply</b> button.
   * [File > Font File Menu]
   * [Font > Font Menu]
   * [Size > Font Size Menu]
   * [Format > Font Format Menu]
!Buttons
   * <b>Ok</b> causes any font picked to be used and the dialog to be closed.
   * <b>Apply</b> causes the font picked to be used temporarily. This allows you to see what it looks like in an actual window and then change it again, accept it with the <b>Ok</b> button, or reject it with the <b>Cancel</b> button.
   * <b>Cancel</b> causes any changes made to be rejected and the dialog to be closed.
}
{Font File Menu} {
!Items
   * <b>Reset</b>: causes the dialog's font to go back to the one it started with.
   * <b>Apply</b>: causes the font picked to be used temporarily. This allows you to see what it looks like in an actual window and then change it again, accept it with the <b>Ok</b> button, or reject it with the <b>Cancel</b> button.
   * <b>OK</b>: causes any font picked to be used and the dialog to be closed.
   * <b>Cancel</b>: causes any changes made to be rejected and the dialog to be closed.
This menu is part of the [font dialog > Font Window].
}
{Font Menu} {
This menu allows a single font to be selected. It has an item for every font that vsd could find on your system.

This menu can be [torn off > Tear Off Menus].

This menu is part of the [font dialog > Font Window].
}
{Font Size Menu} {
This menu allows the size of the font to be selected. A number of predefined sizes are offered. If no of those do what you want then select <b>Other...</b> which causes the font dialog window to have a numeric entry field.

This menu can be [torn off > Tear Off Menus].

This menu is part of the [font dialog > Font Window].
}
{Font Format Menu} {
This menu allows you to select any number of the following font modifiers:
   * <b>Bold</b>: makes the font look darker.
   * <b>Italic</b>: makes the font look slanted.
   * <b>Underline</b>: draws a line under the font.
   * <b>Overstrike</b>: draws a line through the font.

This menu can be [torn off > Tear Off Menus].

This menu is part of the [font dialog > Font Window].
}

{Log Window} {
Vsd has at most a single log window. Information is written to it and it can be cut and paste from it to your favorite text editor. If you close the log window then any information written to it is deleted. 
The operations that write to the log window are:
   * [Log... button > File Info Log... Button]
   * [Log Info menu item > Line Menu Log Info Item]
   * [Log Delta menu item > Line Menu Log Delta Item]
}
{File Information Window} {
This window is created/updated when the [file info... item > File Menu Info... Item] is selected. It shows the following information on the current file:
   * the product version of the [statmonitor] that generated the file
   * a description of the machine and operating system that [statmonitor] ran on when generating the file
   * the time that the first data sample in the file was taken and an estimate of the interval.

You can get even more information about the file by clicking on the [Log...button > File Info Log... Button].
You can get rid of this window by clicking on the <b>Dismiss</b> button.
}

{File Info Log... Button} {
Clicking on this button causes the following information to be [logged > Log Window]:
   * the absolute file name
   * the product version of the [statmonitor] that generated the file
   * a description of the machine and operating system that [statmonitor] ran on when generating the file
   * the time that the first data sample in the file was taken and an estimate of the interval.
   
This button is on the [File Information Window].
}

{Monitor Window} {
Vsd has at most one monitor window. It allows you to easily run a [statmonitor] whose output will be automatically loaded into vsd. Its created or brought to the front by selecting the [Monitor... > Main Menu Monitor... Item] item.
The main display in this window shows a list of valid statistic sources. You can select any one of these. For each source the following is shown:
   * <b>Cache Name</b>:  this is either the name of an existing cache on the local machine or <tt>none</tt> which allows you to collect operating system statistics only.
   * <b>StatMon</b>:  this will be <tt><none></tt> if this vsd does not have a [statmonitor] running on this source. Otherwise its the process id of the monitor. Each vsd can have at most one monitor per source.
   * <b>Version</b>:  if the source is a product's statistic cache then this is the version of that product. Otherwise its the version of the operating system.
   * <b>Creator</b>:  if the source is a product's statistic cache then this is the name of the user who started that product's servers. Otherwise its the host name of the machine.

![Controls > Statmonitor Option Controls]

!Buttons
   * <b>Refresh</b>:  updates the list of statistic sources
   * <b>Start</b>:  starts a [statmonitor] on the selected statistic source. This button is disabled until a valid statistic source is selected. The start will use the values of the [statmonitor options > Statmonitor Option Controls].
   * <b>Status</b>:  shows the status of a running [statmonitor]. This button is disabled until a statistic source with a running statmonitor is selected.
   * <b>Stop</b>:  stops a running [statmonitor]. This button is disabled until a statistic source with a running statmonitor is selected.
   * <b>Dismiss</b>:  closes the monitor window.
}
{Statmonitor Option Controls} {
The following controls both show how a running [statmonitor] is configured and how you want to configure one you are starting. When starting a statmonitor first set the options you desire then click on the <b>Start</b> button.
   * <b>StatMon Output:</b> shows the name of the running statmonitor's output file. If left blank when starting then vsd will generate a unique name. You can type in any file name you desire before starting.
   * <b>Sample Interval:</b> specifies the sampling interval in seconds.
   * <b>Write Interval:</b> tells statmonitor how long to buffer samples internally before flushing them to the output file. Setting this to zero causes the <b>Sample Interval</b> to be used.
   * <b>Level:</b>  tells statmonitor how many operating system statistics it should collect. If you look at the [operating system types > Instance Type Definition] each one documents what the level must be for it to get collected. The default level is one. If the level is zero then no operating system statistics will be collected. Increasing the level causes additional statistics and instance types to be collected. On Windows NT setting the level higher than two can causes an ever increasing number of [thread instances > NtThread Type] to be collected which vsd will not handle well so only collect at this level for short periods of time. On Solaris setting the level higher than three can cause statmonitor to consume a great deal more CPU so it should only be done if the [SystemPages Type] is really needed.
   * <b>AppStat Count:</b>  tells statmonitor how many shared counter statistics to collect from the shared cache. By default it doesn't collect any. If its told to collect one or more then you will see a single [AppStat Type] instance and it will have statistics named <tt>sharedCounter</tt><em>id</em> where <em>id</em> is a number starting at zero. The number of statistics it will have is determined by the <em>numAppStats</em> argument. By default the value of all shared counters is zero. You must instrument your code if you want change their values. The Java methods to use are <tt>initSharedCounter</tt> and <tt>incrementSharedCounter</tt> on the <tt>StatisticAccess</tt> interface in the <tt>gemstone.services</tt> package.
   * <b>Compression:</b>  if gzip or lz4 is checked, causes the output file to be compressed saving a significant amount of disk space.
   * <b>Sessions:</b> given a list of session ids causes statmonitor to only collect cache statistics for the specified [sessions > Session Type].
}

{Statistic Information Window} {
Vsd has at most one statistic information window. Its purpose is to display information on the most recently selected statistic. It can also be used to customize the default filter and the level of any statistic. Its created by checking the [Show Statistic Info > Main Menu Show Statistic Info Item] checkbox.

!Controls
   * [statistic name selector > Statistic Window Name ComboBox]
   * [Default Filter MenuButton]
   * [Level MenuButton]
   * [Statistic Help Button]
!Displays
   * <b>Kind:</b> shows what kind of statistic it is. It will be one of the following:
      * <b>counter</b>: a statistic whose value always increases
      * <b>counter64</b>: a statistic whose value is a signed 64 bit integer and always increases
      * <b>svalue</b>: a statistic whose value is a signed 32 bit integer.
      * <b>svalue64</b>: a statistic whose value is a signed 64 bit integer.
      * <b>uvalue</b>: a statistic whose value is an unsigned 32 bit integer.
      * <b>float</b>: a statistic whose value is a floating point number
   * <b>Types:</b> shows which [instance types > Instance Type Definition] are known to support this statistic. If none are known then <tt>unknown</tt> is shown. Until a file is loaded vsd has no idea of which types support a statistic.
   * <b>Statistic Description</b> show a textual description of the statistic.
   * <b>Units:</b> shows the units that the statistic's value represents. Some of the more common unit strings are:
      * <b>none</b>
      * <b>minutes</b>
      * <b>seconds</b>
      * <b>milliseconds</b>
      * <b>items</b>
      * <b>bytes</b>
      * <b>kilobytes</b>
      * <b>megabytes</b>
      * <b>pages</b>
      * <b>locks</b>
      * <b>frames</b>
      * <b>commit records</b>
      * <b>log records</b>
      * <b>objects</b>
      * <b>sessions</b>
      * <b>vms</b>
      * <b>messages</b>
      * <b>signals</b>
      * <b>symbols</b>
      * <b>methods</b>
      * <b>threads</b>
      * <b>packets</b>
      * <b>segments</b>
      * <b>connections</b>
      * <b>extents</b>
      * <b>processes</b>
      * <b>events</b>
      * <b>semaphores</b>
      * <b>mutexes</b>
      * <b>sections</b>
      * <b>%</b>:  the value is a percentage
      * <b>false</b> or <b>true</b>:  the value is 0 (false) or 1 (true). 
      * <b>priority</b>
      * <b>enumeration</b>:  the value is a fixed set of values each of which has a specific meaning.
      * <b>id</b>:  the value is just a numeric identifier.
      * <b>bits/sec</b>:  bits per second.
      * <b>ios/sec</b>:  input/output operations per second.
      * <b>operations</b>
      * <b>aborts</b>
      * <b>commits</b>
      * <b>reclaims</b>
      * <b>checkpoints</b>
      * <b>scavenges</b>
}
{Level MenuButton} {
Shows and sets the level of the current statistic. The level can be used to limit the number of statistics [shown > Main Menu Statistic Level SubMenu] by vsd. The level will be one of the following:
   * <b>common</b>  the most useful statistics.
   * <b>advanced</b>  statistic is only of interest to advanced users
   * <b>wizard</b>  statistic is meant for internal developers
If you change the level with this menu button then it will be remembered in [memory file > VSD Files].

This button is on the [statistic information window > Statistic Information Window].
}
{Statistic Help Button} {
Clicking on this button creates a [help window > Help Window Features] containing the topic that describes the current statistic.

This button is on the [statistic information window > Statistic Information Window].
}
{Default Filter MenuButton} {
Shows and sets the default filter of the current statistic. The default filter is the one that will be used when a line is created for this statistic. It can be any of the following:
   * <b>Default</b>
   * <b>None</b>
   * <b>PerSecond</b>
   * <b>PerSample</b>
   * <b>Smooth</b>
   * <b>Aggregate</b>
See [How to Filter Statistics] for a description of the various filters.

This button is on the [statistic information window > Statistic Information Window].
}
{Statistic Window Name ComboBox} {
This control displays the current statistic. It also will let you change it.
!Bindings
   * Clicking on a name with the <em>mouse</em> both selects it and causes it to become the current statistic.
   * The <em>down</em> arrow key selects the next statistic.
   * The <em>up</em> arrow key selects the previous statistic.
   * The <em>letter keys</em> select the next statistic whose first letter matches the key.
   * <tt>control-s</tt> starts a [search > List Search Control] which results in selecting a statistic.
   * <em>Return</em> causes the selected statistic to become the current statistic.
   * <em>Esc</em> cancels the change leaving the current statistic unchanged.

This control is on the [statistic information window > Statistic Information Window].
}
{Main Window Features} {
Vsd only has a single main window and it always exists. If this window\
is closed or killed then vsd will terminate.

!How to Use The Main Window
   * [General Interface Features]
   * [How to Load a Data File]
   * [How to Update the View of a Data File]
   * [How to Create a Data File]
   * [How to Compare Files]
   * [How to Merge Files]
   * [How to Select]
   * [Controlling the Enabled Files]
   * [Controlling the Listed Object Instances]
   * [Controlling the Listed Statistic Names]
   * [How to Select Object Instances]
   * [How to Select Statistics]
   * [How to Get Statistic Information]
   * [How to Create a New Chart]
   * [How to Add a Line to an Existing Chart]

!Main Menus
   * [Main > Main Window Main Menu]
   * [File > Main Window File Menu]
   * [Chart > Main Window Chart Menu]
   * [Template > Main Window Template Menu]
   * [Help > Main Window Help Menu]

!Main Controls
   * [File: > Main Window File ComboBox]
   * [Instance Table > Main Window Instance Table]
   * [Statistic List > Main Window Statistic List]
   * [Chart: > Main Window Chart ComboBox]
   * [Add Line > Main Window Add Line Button]
   * [New Chart > Main Window New Chart Button]
   * [Status Display > Main Window Status Display]
}

{Main Window Main Menu} {
!Items
   * [Load Data File... > Main Menu Load Data File... Item]
   * [Append Data File... > Main Menu Append Data File... Item]
   * [Monitor... > Main Menu Monitor... Item]
   * [Change Directory... > Main Menu Change Directory... Item]
   * [Change Time Offset... > Main Menu Change Time Offset... Item]
   * [Set Master Background Color... > Main Menu Set Master Background Color... Item]
   * [Copy Selection > Main Menu Copy Selection Item]
   * [Show Statistic Info > Main Menu Show Statistic Info Item]
   * [Combine > Main Menu Combine Item]
   * [Combine Across Files > Main Menu Combine Across Files Item]
   * [No Flatlines > Main Menu No Flatlines Item]
   * [Single File Mode > Main Menu Single File Mode Item]
   * [Absolute TimeStamps > Main Menu Absolute TimeStamps Item]
   * [Copy Referenced Lines > Main Menu Copy Referenced Lines Item]
   * [Statistic Level > Main Menu Statistic Level SubMenu]
   * [Dump Statistic Info > Main Menu Dump Statistic Info Item]
   * [Confirm Exit > Main Menu Confirm Exit Item]
   * [Exit > Main Menu Exit Item]
   * [Trace API Calls > Main Menu Trace API Calls Item]
   * [ForceError > Main Menu ForceError Item]
   * [Restart > Main Menu Restart Item]
   * [Debug > Main Menu Debug Item]

[Selection Key > Keyboard Selection Keys]: <tt>Alt-m</tt>

This menu is on the [main window > Main Window Features].
}

{Main Menu Load Data File... Item} {
Pops up file selection dialog which can be used to pick the data file to load.
See [How to Load a Data File] for more information.

[Selection Key > Keyboard Selection Keys]: <tt>Alt-l</tt>

This item is part of the [main menu > Main Window Main Menu].
}

{Main Menu Append Data File... Item} {
Pops up file selection dialog which can be used to pick one or more data files to append to the currently loaded file. This allows you to easily concatenate multiple physical files. Data will no longer be read from the current file location. Instead it will only be read from the new appended location. You should only append files that are newer than the current data.
This operation will fail if the current file load has been interrupted. You need to do an [update > File Menu Update Item] to finish the load before an append can be done.
See [How to Load a Data File] for more information.

This item is part of the [main menu > Main Window File Menu].
}

{Main Menu Monitor... Item} {
Pops up the [Monitor Window].
See [How to Create a Data File] for more information.

[Accelerator Key > Keyboard Accelerators]: <tt>control-m</tt>

This item is part of the [main menu > Main Window Main Menu].
}

{Main Menu Change Directory... Item} {
Pops up a dialog that asks for the directory VSD should use as its working directory. Initially this is the directory VSD was started from but it can be changed using this item.
The operations that use the VSD working directory are:
   * [Chart Menu Print Item]
   * [Chart Menu Snapshot Item]

This item is part of the [main menu > Main Window Main Menu].
}

{Main Menu Change Time Offset... Item} {
Pops up a spinbox that allows the time offset to be altered.  The time offset represents a value (in hours) that is added to all timestamps in all stat files loaded by VSD.  The default value is zero and the valid range runs from -23 to +23 hours.  Time Offset settings are not saved and the value will be reset to zero each time VSD is started.

This item is part of the [main menu > Main Window Main Menu].
}

{Main Menu Set Master Background Color... Item} {
Pops up a dialog that allows you to select a background color for all windows.  This allows you to run multiple instances of VSD and easily distiguish which charts are associated with which main window.
 
This item is part of the [main menu > Main Window Main Menu].
}

{Main Menu Copy Selection Item} {
Copies the currently selected [instances > How to Select Object Instances] and [statistics > How to Select Statistics] to the clipboard.
See [How to Cut, Copy, and Paste] for more information.

[Accelerator Key > Keyboard Accelerators]: <tt>control-c</tt>

This item is part of the [main menu > Main Window Main Menu].
}

{Main Menu Show Statistic Info Item} {
Controls whether the [statistic information window > Statistic Information Window] is displayed.
See [How to Get Statistic Information] for more information.

This item is part of the [main menu > Main Window Main Menu].
}

{Main Menu Combine Item} {
Controls what is done with a [multiple > List Multiple Selection] [instance > How to Select Object Instances] selection when a line is [created > How to Add a Line to an Existing Chart].
If this item is checked then all the data for the selected instances\
will be added together into a single line. Otherwise a line is created for each  instance.

The [Combine Across Files > Main Menu Combine Across Files Item] item modifies how many of the selected instances are combined. 

This can also be done using the [Instance List PopupMenu <b>Combine</b> Item].

This item is part of the [main menu > Main Window Main Menu].
}

{Main Menu Combine Across Files Item} {
Controls what is done with a [multiple > List Multiple Selection] [instance > How to Select Object Instances] selection when a line is [created > How to Add a Line to an Existing Chart].
If this item is checked then when a [combine > Main Menu Combine Item] is done all the instances are combined into a single line.\
Otherwise instances are only combined if they are from the same file. So you end up with a line for each selected file.

This can also be done using the [Instance List PopupMenu <b>Combine Across Files</b> Item].

This item is part of the [main menu > Main Window Main Menu].
}

{Main Menu No Flatlines Item} {
If checked then:
   * the names of statistics with all zero raw values for the selected instances will not be displayed.
   * lines will not be created if all their filtered values are zero. A [bell message > Bell Messages] will be displayed if this causes no lines to be created. Note that this option is ignored when creating a line using [line arithmetic > Line Arithmetic].

If unchecked then:
   * the names of statistics with all zero raw values for the selected instances will be displayed in a faint font.

See [Controlling the Listed Statistic Names] for more information.

This can also be done using the [Instance List PopupMenu <b>No Flatlines</b> Item].

This item is part of the [main menu > Main Window Main Menu].
}

{Main Menu Single File Mode Item} {
In general you want to check this item if you want to work with more than one file at a time. See the following for examples:
   * [How to Compare Files]
   * [How to Merge Files]

If checked then:
   * only one loaded file can be [enabled > Controlling the Enabled Files] at a time.

If unchecked then:
   * more than one loaded file can be [enabled > Controlling the Enabled Files].

See the following for more information:
   * [Controlling the Enabled Files]
   * [Controlling the Listed Object Instances]
   * [Main Window File ComboBox]

This can also be done using the [Instance List PopupMenu <b>Single File Mode</b> Item].

This item is part of the [main menu > Main Window Main Menu].
}

{Main Menu Absolute TimeStamps Item} {
If checked then:
   * Created lines will use absolute timestamps which can be useful when [merging > How to Merge Files] files.

If unchecked then:
   * Created lines will use relative timestamps which can be useful when [comparing > How to Compare Files] files.

Once a line is created its timestamps can not be changed. If you want to change them just set this item and recreate the line.

Absolute and relative timestamps have different display formats. For more on this see [Chart Menu Time Format SubMenu].

This can also be done using the [Instance List PopupMenu <b>Absolute TimeStamps</b> Item].

This item is part of the [main menu > Main Window Main Menu].
}

{Main Menu Copy Referenced Lines Item} {
If checked then:
   * copies of the source lines are made when [line arithmetic > Line Arithmetic] is done. This prevents subsequent changes to the sources lines effecting the result line.

If unchecked then:
   * references of the source lines are used when [line arithmetic > Line Arithmetic] is done. This allows subsequent changes to the sources lines to also change the result line.

This item is part of the [main menu > Main Window Main Menu].
}

{Main Menu Statistic Level SubMenu} {
This submenu lets you select what level of statistics\
are listed. Any statistics that belong to a level higher than the selected one\
will not be listed.

Each statistic name belongs to one of three levels. You can customize the level by using the [Level MenuButton] on the [Statistic Information Window].

!Items
   * [Common Statistics Only > Common Statistics Only Item]
   * [Advanced & Common Statistics > Advanced & Common Statistics Item]
   * [All Statistics > All Statistics Item]

See [Controlling the Listed Statistic Names] for more information.

This item is part of the [main menu > Main Window Main Menu].
}

{Common Statistics Only Item} {
Causes only those statistics whose level is <em>common</em> to be shown in statistic lists.

This item is part of the [statistic level submenu > Main Menu Statistic Level SubMenu].
}

{Advanced & Common Statistics Item} {
Causes only those statistics whose level is <em>common</em> or <em>advanced</em> to be shown in statistic lists.

This item is part of the [statistic level submenu > Main Menu Statistic Level SubMenu].
}

{All Statistics Item} {
Causes all statistics to be shown in statistic lists.

This item is part of the [statistic level submenu > Main Menu Statistic Level SubMenu].
}

{Main Menu Dump Statistic Info Item} {
Causes information on all known statistics to be dumped to a log window.

This item will only appear if vsd is run in [Wizard Mode].
This item is part of the [main menu > Main Window Main Menu].
}

{Main Menu Confirm Exit Item} {
If checked then:
   * vsd will ask for confirmation before it completes an [exit > Main Menu Exit Item] operation.

If unchecked then:
    * vsd will perform an [exit > Main Menu Exit Item] operation without asking the user for confirmation.

This item is part of the [main menu > Main Window Main Menu].
}

{Main Menu Exit Item} {
Causes vsd to terminate. Before terminating vsd will:
   * confirm with the user that the exit was intended if the [Main Menu Confirm Exit Item] is checked.
   * kill off any monitors left running. See [Monitor Window] for more information.
   * writes the <u><tt>~/.vsdrc</tt></u> <em>memory file</em>. See [VSD Files] for more information.

If the window manager closes the main window then these same actions are taken. If you want to exit vsd without performing any of these actions then kill the vsd process.

This item is part of the [main menu > Main Window Main Menu].
}

{Main Menu Trace API Calls Item} {
If checked then:
   * any call by vsd to its lower level C APIs will result in a trace message written to its stderr. This is intended to help debug crashes that are hard to reproduce.

If unchecked then:
   * API calls are not traced.

This item will only appear if vsd is run in [Wizard Mode].
This item is part of the [main menu > Main Window Main Menu].
}

{Main Menu ForceError Item} {
Picking this item forces an error. This allows vsd developers to make sure the error catching logic is functioning correctly.

This item will only appear if vsd is run in [Wizard Mode].
This item is part of the [main menu > Main Window Main Menu].
}

{Main Menu Restart Item} {
Picking this item causes vsd to reread its [Tcl > Tcl Language] [source file > VSD Files]. This allows vsd developers to make changes to vsd and then apply the changes without exiting and restarting vsd.

This item will only appear if vsd is run in [Wizard Mode].
This item is part of the [main menu > Main Window Main Menu].
}

{Main Menu Debug Item} {
Picking this item causes vsd to source "tkcon.tcl" from the same directory the ".vsdrc" is located in. In a vsd developers environment "tkcon.tcl" is a debugger that allows inspection of vsd's internal state.

This item will only appear if vsd is run in [Wizard Mode].
This item is part of the [main menu > Main Window Main Menu].
}

{Wizard Mode} {
Wizard mode enables certain advanced vsd features intended for vsd developers.

Wizard mode can be enabled either of the following:
   * Setting the <b>VSD_WIZARD</b> enviroment variable in the environment that starts vsd.
   * Setting the Tcl variable <b>vsd(wizard)</b> in <u><tt>~/.vsdconfig</tt></u>. See [VSD Files] for more information.
}

{Main Window File Menu} {
All of the items on this menu operate on the [<em>current file</em> > Main Window File ComboBox].
If no [<em>current file</em> > Main Window File ComboBox] exists then all the items will be disabled.

!Items
   * [Info... > File Menu Info... Item]
   * [Update > File Menu Update Item]
   * [Update All > File Menu Update All Item]
   * [Auto Update > File Menu Auto Update Item]
   * [Enabled > File Menu Enabled Item]
   * [Untrim Left > File Menu Untrim Left Item]
   * [Untrim Right > File Menu Untrim Right Item]
   * [Set Rolling Time Window > File Menu Set Rolling Time Window]
   * [Dump > File Menu Dump Item]

[Selection Key > Keyboard Selection Keys]: <tt>Alt-f</tt>

This menu is on the [main window > Main Window Features].
}

{File Menu Info... Item} {
Causes the [File Information Window] to be loaded with information on the [<em>current file</em> > Main Window File ComboBox].

This item is part of the [file menu > Main Window File Menu].
}

{File Menu Update All Item} {
Causes any data not already read from any [enabled > Controlling the Enabled Files] file to be read now. This can be used on files that [statmonitor] is still writing data to or on files whose load was interrupted.

[Accelerator Key > Keyboard Accelerators]: <tt>control-U</tt>

This item is part of the [file menu > Main Window File Menu].
}

{File Menu Update Item} {
Causes any data not already read from the [<em>current file</em> > Main Window File ComboBox] to be read now. This can be used on files that [statmonitor] is still writing data to or on files whose load was interrupted.

[Accelerator Key > Keyboard Accelerators]: <tt>control-u</tt>

This item is part of the [file menu > Main Window File Menu].
}

{File Menu Auto Update Item} {
If checked causes an automatic update to be done on the [<em>current file</em> > Main Window File ComboBox] whenever it should have changed. The interval of the first couple of timestamps in a file are used to estimate when a file should have changed.

This item is part of the [file menu > Main Window File Menu].
}

{File Menu Enabled Item} {
This item is only useful in [multi-file mode > Main Menu Single File Mode Item]. Checking this item causes the [<em>current file</em> > Main Window File ComboBox] to be one of those whose instances are [displayed > Main Window Instance Table]. Unchecking this item causes vsd to act as if the [<em>current file</em> > Main Window File ComboBox] was never loaded.

This item is part of the [file menu > Main Window File Menu].
}

{File Menu Untrim Left Item} {
This item is only enabled if the [<em>current file</em> > Main Window File ComboBox] was trimmed left. Selecting it undoes all left trims to the file.
See [File Trimming] for more information.

This item is part of the [file menu > Main Window File Menu].
}

{File Menu Untrim Right Item} {
This item is only enabled if the [<em>current file</em> > Main Window File ComboBox] was trimmed right. Selecting it undoes all right trims to the file.
See [File Trimming] for more information.

This item is part of the [file menu > Main Window File Menu].
}

{File Menu Set Rolling Time Window} {
Selecting this item opens a dialog box to enable or modify rolling time trimming for the current file.  When enabled, rolling time trimming tells VSD to disregard all data in the file except for the most recent data.  For example, setting the rolling time window to 5 minutes will cause VSD to disregard all samples older than 5 minutes. Because the time window is <em>rolling</em>, VSD adjusts the time window whenever new data is loaded so that only the most recent 5 minutes of data is shown. 

Other file trimming options are disabled when rolling time trimming is active.
To cancel rolling time trimming, set the time window to zero by clicking the Zero button and then clicking the Apply button.

This item is part of the [file menu > Main Window File Menu].
}

{File Menu Dump Item} {
Causes vsd to write to its stdout details in the internal data structures its using to contain the data read from the [<em>current file</em> > Main Window File ComboBox].

This item will only appear if vsd is run in [Wizard Mode].
This item is part of the [file menu > Main Window File Menu].
}

{Main Window Chart Menu} {
!Items
   * [Add To Chart > Main Chart Menu Add To Chart Item]
   * [New Chart... > Main Chart Menu New Chart... Item]
   * [Show Legend > Main Chart Menu Show Legend Item]
   * [Time Format > Main Chart Menu Time Format SubMenu]
   * [Default Line Style > Main Chart Menu Default Line Style SubMenu]
   * [Show Time Axis Title > Main Chart Menu Show Time Axis Title Item]
   * [Show Left Axis Title > Main Chart Menu Show Left Axis Title Item]
   * [Show Right Axis Title > Main Chart Menu Show Right Axis Title Item]
   * [Show Current Values > Main Chart Menu Show Current Values Item]
   * [Show Min and Max > Main Chart Menu Show Min and Max Item]
   * [Show Line Stats > Main Chart Menu Show Line Stats Item]
   * [Show CrossHairs > Main Chart Menu Show CrossHairs Item]
   * [Show Grid Lines > Main Chart Menu Show Grid Lines Item]
   * [Selected Line Color... > Main Chart Menu Selected Line Color... Item]
   * [Choose Chart Font... > Main Chart Menu Choose Chart Font... Item]
   * [Close All Charts > Main Chart Menu Close All Charts Item]

[Selection Key > Keyboard Selection Keys]: <tt>Alt-c</tt>

This menu can be [torn off > Tear Off Menus].

This menu is on the [main window > Main Window Features].
}

{Main Chart Menu Add To Chart Item} {
Does the same thing as the [Add Line > Main Window Add Line Button] button.
This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Chart Menu New Chart... Item} {
Does the same thing as the [New Chart > Main Window New Chart Button] button.
This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Chart Menu Show Legend Item} {
This item determines if a new [chart window > Chart Window Features] will have  a [legend > Graph Legend] control.

The value its set to will be remembered by vsd in its [memory file > VSD Files].

Use [Chart Menu <b>Show Legend</b> Item] to change this item for a particular chart.

This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Chart Menu Time Format SubMenu} {
This submenu determines the default time format for a new chart.

The value its set to will be remembered by vsd in its [memory file > VSD Files].

Use [Chart Menu <b>Time Format</b> SubMenu] to change this item for a particular chart.

[Selection Key > Keyboard Selection Keys]: <tt>Alt-t</tt>

This menu can be [torn off > Tear Off Menus].

This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Chart Menu Default Line Style SubMenu} {
This submenu determines the default line style used when creating lines.

The value its set to will be remembered by vsd in its [memory file > VSD Files].

See [line styles > Line Menu Style SubMenu] to learn more.

This menu can be [torn off > Tear Off Menus].

This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Chart Menu Show Time Axis Title Item} {
This item determines if a new [chart window > Chart Window Features] will display a title string under the graph's [X Axis].

The value its set to will be remembered by vsd in its [memory file > VSD Files].

Use [Chart Menu <b>Show Time Axis Title</b> Item] to change this item for a particular chart.

This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Chart Menu Show Left Axis Title Item} {
This item determines if a new [chart window > Chart Window Features] will display a title string next to the graph's [Left Y Axis].

The value its set to will be remembered by vsd in its [memory file > VSD Files].

Use [Chart Menu <b>Show Left Axis Title</b> Item] to change this item for a particular chart.

This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Chart Menu Show Right Axis Title Item} {
This item determines if a new [chart window > Chart Window Features] will display a title string next to the graph's [Right Y Axis].

The value its set to will be remembered by vsd in its [memory file > VSD Files].

Use [Chart Menu <b>Show Right Axis Title</b> Item] to change this item for a particular chart.

This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Chart Menu Show Current Values Item} {
This item determines if a new [chart window > Chart Window Features] will have  [X: > Chart Window X: Display] and [Y: > Chart Window Y: Display] controls.

The value its set to will be remembered by vsd in its [memory file > VSD Files].

Use [Chart Menu <b>Show Current Values</b> Item] to change this item for a particular chart.

This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Chart Menu Show Min and Max Item} {
This item determines if a new [chart window > Chart Window Features] will have  [Min: > Chart Window Min: Display] and [Max: > Chart Window Max: Display] controls.

The value its set to will be remembered by vsd in its [memory file > VSD Files].

Use [Chart Menu <b>Show Min and Max</b> Item] to change this item for a particular chart.

This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Chart Menu Show Line Stats Item} {
This item determines if a new [chart window > Chart Window Features] will display [line statistics > Data Statistics] in the upper left corner of its [graph > Graph Display].

The value its set to will be remembered by vsd in its [memory file > VSD Files].

Use [Chart Menu <b>Show Line Stats</b> Item] to change this item for a particular chart.

This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Chart Menu Show CrossHairs Item} {
This item determines if a new [chart window > Chart Window Features] will draw cross hair lines on its [graph > Graph Display].

The value its set to will be remembered by vsd in its [memory file > VSD Files].

Use [Chart Menu <b>Show CrossHairs</b> Item] to change this item for a particular chart.

This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Chart Menu Show Grid Lines Item} {
This item determines if a new [chart window > Chart Window Features] will draw dotted grid lines on its [graph > Graph Display].

The value its set to will be remembered by vsd in its [memory file > VSD Files].

Use [Chart Menu <b>Show Grid Lines</b> Item] to change this item for a particular chart.

This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Chart Menu Selected Line Color... Item} {
Selecting this item will cause a color chooser dialog window to popup.\
Use it to pick the color to use for the selected line.\
You will not be able to do anything else until you finish or cancel the color choice.\
Your choice will be recorded in the [memory file > VSD Files].

This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Chart Menu Choose Chart Font... Item} {
Selecting this item will cause the [font chooser > Font Window] to pop up.\
Use it to pick the chart font. You will not be able to do anything else until\
you finish or cancel the font choice.\
Your choice will be recorded in the [memory file > VSD Files].

The chart font is used for most everything that displays text in a font window. The only exception are the menus.

Font changes will appear immediately in any existing chart. In some cases you need to reselect the active line and [unshow/show > Chart Menu Show Legend Item] the [legend > Graph Legend] to get the new font to display.

This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Chart Menu Close All Charts Item} {
Selecting this item causes all the existing chart windows to no longer exist.

To close just a single chart window use the [Chart Menu <b>Close</b> Item].

This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Window Template Menu} {
!Items
   * [Reload Template File > Template Menu Reload Template File Item]
   * [New Template Chart > Template Menu New Template Chart SubMenu]
   * [Templates Use Selection > Template Menu Templates Use Selection Item]

[Selection Key > Keyboard Selection Keys]: <tt>Alt-t</tt>

This menu can be [torn off > Tear Off Menus].

This menu is on the [main window > Main Window Features].
}

{Template Menu Reload Template File Item} {
Causes the [template file > VSD Files] to be reloaded. Use this if you have edited the template file and want the changes to be used immediately.

[Selection Key > Keyboard Selection Keys]: <tt>Alt-r</tt>

This item is part of the [main template menu > Main Window Template Menu].
}

{Template Menu New Template Chart SubMenu} {
Each item on this submenu represents a template from the [template file > VSD Files]. Selecting an item from this submenu causes a [new chart > Chart Window Features] to be created. The [contents > Template Syntax] of the template [determines what lines > Template Expansion] will be added to the created chart.

Vsd has a set of [predefined templates > Predefined Templates]. Each one of these will show up as an item on this submenu. Also any [user defined templates > Chart Menu Save Template Item] will show up.

[Selection Key > Keyboard Selection Keys]: <tt>Alt-c</tt>

This menu can be [torn off > Tear Off Menus].

This item is part of the [main template menu > Main Window Template Menu].
}

{Predefined Templates} {
The following are template definitions that come with VSD. They are stored in the [template file > VSD Files] and can be used from the [New Template Chart > Template Menu New Template Chart SubMenu] menu or the [Add From Template > Chart Menu Add From Template SubMenu].
   * [CPU > CPU Template]
   * [CacheMix > CacheMix Template]
   * [CacheTooSmall > CacheTooSmall Template]
   * [CommitInfo > CommitInfo Template]
   * [EpochSweeps > EpochSweeps Template]
   * [Garbage > Garbage Template]
   * [PageServer > PageServer Template]
   * [SpaceFree > SpaceFree Template]

<b>NOTE:</b> If you get an updated VSD release the definitions of these templates may have changed and new definitions may exist. Your old [template file > VSD Files] will still contain the definitions from an older VSD release. The way to get the new definitions is to delete or rename you template file. This will cause VSD to write a new default template file. You can then edit it and copy any of your own template definitions to it.
}

{Template Menu Templates Use Selection Item} {
If unselected then the [selected instances > Main Window Instance Table] are ignored when a template is used.
If selected then the [selected instances > Main Window Instance Table] will be the only ones that match general patterns in the template.

This item is part of the [main template menu > Main Window Template Menu].
}

{Main Window Help Menu} {
!Items
   * [How to... > Help Menu How to... Item]
   * [Main Window... > Help Menu Main Window... Item]
   * [Chart Window... > Help Menu Chart Window... Item]
   * [All Topics... > Help Menu All Topics... Item]
   * [All Help Text... > Help Menu All Help Text... Item]
   * [Choose Text Font... > Help Menu Choose Text Font... Item]
   * [About VSD... > Help Menu About VSD... Item]

[Selection Key > Keyboard Selection Keys]: <tt>Alt-h</tt>

This menu is on the [main window > Main Window Features].
}

{Help Menu How to... Item} {
Selecting this item creates a [help window > Help Window Features] containing links to all the help topics that tell you how to do something.

This item is part of the [main chart menu > Main Window Help Menu].
}

{Help Menu Main Window... Item} {
Selecting this item creates a [help window > Help Window Features] containing the help topic that describes vsd's [main window > Main Window Features].

This item is part of the [main chart menu > Main Window Help Menu].
}

{Help Menu Chart Window... Item} {
Selecting this item creates a [help window > Help Window Features] containing the help topic that describes vsd's [chart windows > Chart Window Features].

This item is part of the [main chart menu > Main Window Help Menu].
}

{Help Menu All Topics... Item} {
Selecting this item creates a [help window > Help Window Features] containing links to all the help topics. The links are sorted alphabetically.

This item is part of the [main chart menu > Main Window Help Menu].
}

{Help Menu All Help Text... Item} {
Selecting this item creates a [help window > Help Window Features] containing the contents of all the help topics. The contents are sorted by topic name. Creation of this help window can take a long time.

This item is part of the [main chart menu > Main Window Help Menu].
}

{Help Menu Choose Text Font... Item} {
This item allows the font used by vsd to display help text to be customized.
Selecting it brings up a [font dialog > Font Window].

This item is part of the [main chart menu > Main Window Help Menu].
}

{Help Menu About VSD... Item} {
Selecting this item brings up a window that displays various information about vsd. This information includes:
   * version numbers
   * file locations
   * home page

This item is part of the [main chart menu > Main Window Help Menu].
}

{Main Window Add Line Button} {
Creates one or more lines from the selected [instances > How to Select Object Instances]\
and [statistics > How to Select Statistics] and then adds them to the current chart window. If a chart window does not exist then a new one will be created.

The current chart's name is displayed in the [Chart: > Main Window Chart ComboBox] control.

If a new chart window is created then its name can be entered in the [Chart: > Main Window Chart ComboBox] control before this operation is started. Otherwise a default name is used.

For details on how the selection is used to create lines see [Line Creation].

This operation can also be done by double clicking when selecting a\
[instance > How to Select Object Instances]\
or [statistic > How to Select Statistics].

[Accelerator Key > Keyboard Accelerators]: <tt>control-a</tt>
This control is on the [main window > Main Window Features].
}
{Line Creation} {
For a line to be created at least one [instance > How to Select Object Instances] and one [statistic > How to Select Statistics] must be selected.

If more than one instance is selected then vsd needs to decide how to combine them. See [combine > Main Menu Combine Item] and [combine across files > Main Menu Combine Across Files Item] for a description of how this is done.

If [no flatlines > Main Menu No Flatlines Item] is true, and you are not using [line arithmetic > Line Arithmetic], then the line will not be created if all its values are zero. 

The default filter for the statistic on the line is used when creating the line.

A unique color and dash style for the line is picked based on what lines the chart already contains.

!Operations That Create Lines
   * [New Chart > Main Window New Chart Button]
   * [Add Line > Main Window Add Line Button]
   * [copy & paste > How to Cut, Copy, and Paste]
   * [Add Lines > Line Menu Add Lines Item]
   * [Diff Lines > Line Menu Diff Lines Item]
   * [Divide Lines > Line Menu Divide Lines Item]
   * [New Template Chart > Template Menu New Template Chart SubMenu]
   * [Add From Template > Chart Menu Add From Template SubMenu]
}
{Main Window New Chart Button} {
Does the same thing as the [Add Line > Main Window Add Line Button] button with the following exceptions:
   * It will never use an existing chart.
   * An empty chart window is created if no lines are created. So this is the operation to use to get an empty chart that you plan to [paste > How to Cut, Copy, and Paste] a line to.

[Accelerator Key > Keyboard Accelerators]: <tt>control-n</tt>
This control is on the [main window > Main Window Features].
}

{Main Window File ComboBox} {
The file control has the following functions:
   * display name of current file
   * display names of all loaded files
   * display a history of files loaded in the past
   * change the current file
   * load a new file

!Drop Down List
The file control's drop down list contains three types of elements:
   * The first element is always <u><tt>Browse For File...</tt></u> which if selected will do the same thing as the [Main Menu <b>Load Data File...</b> Item].
   * The names of files loaded in the past are always at the bottom of the list. Vsd [remembers > VSD Files] the last ten loaded files. These entries are always displayed as full absolute path names. Selecting one will cause it to be loaded.
   * Currently loaded files are always in the middle of the list. They are displayed with the same [syntax > Loaded File Description Syntax] as that used for the <em>current file</em>. Selecting one causes it to become the <em>current file</em>.

!Current File
The <em>current file</em> is a loaded file whose [description > Loaded File Description Syntax] is displayed in the file control's string entry. It is the one that can be operated on by the [Main Window <b>File</b> Menu]. If [single file mode > Main Menu Single File Mode Item] is on then it is also the only one whose instances will be displayed.

!Loading a New File
See [How to Load a Data File].

This control is on the [main window > Main Window Features].
}

{Main Window Instance Table} {
This table lists all the [instances > Instance Definition] from each [enabled > Controlling the Enabled Files] [file > Main Window File ComboBox].

Its main purpose it to allow instances to be [selected > How to Select Object Instances] so that lines can be [created > Line Creation] for the selected instance's [statistics > Main Window Statistic List].

For each instance in the list the following items are displayed:
   * <b>Name</b>: a string of characters that somewhat uniquely identifies the instance.
   * <b>Type</b>: see [Instance Type Definition].
   * <b>Pid</b>: The id of the process associated with this instance. This item is optional.
   * <b>StartTime</b>: The time the very first sample was taken for this instance.
   * <b>EndTime</b>: The time the very last sample was taken for this instance.
   * <b>File</b>: the [id > Loaded File Description Syntax] of the file the instance's samples where read from.
   * <b>Samples</b>: The number of samples taken so far for this instance. This can change if data is still being collected the file is [updated > How to Update the View of a Data File]. A green font is used to show that more samples are still possible.

!Sorting
The instance list is sorted. You can tell which column is the primary sort key by looking at the column headers. The one with an extra decoration drawn around its name is the primary sort key. If the decoration is raised then the sort order is increasing. If the decoration is sunken then the sort order is descreasing.
Click on a header to make it the primary sort key. Click on the same header to toggle its sort order.

!Selecting Instances
See [How to Select Object Instances].

!Bindings
   * <tt>control-s</tt> starts an instance [search > List Search Control].
   * <tt>right mouse button</tt> accesses the [popup menu > Instance List PopupMenu].
   * [List Multiple Selection]
   * <tt>double click</tt> on an item does an [add line operation > Main Window Add Line Button].

This control is on the [main window > Main Window Features].
}

{Main Window Statistic List} {
This control lists all the statistics for the selected [instances > Main Window Instance Table]. If no instances are selected then all known statistics will be shown. The statistics are sorted in alphabetic order.

See [How to Select Statistics] for more information on how to use this control.

!Bindings
   * <tt>control-s</tt> starts a statistic [search > List Search Control].
   * [List Multiple Selection]
   * <tt>double click</tt> on an item does an [add line operation > Main Window Add Line Button].

This control is on the [main window > Main Window Features].
}

{Main Window Status Display} {
This control, located at the bottom of the main window, is used to display all [messages > Bell Messages] and [mouse help > Mouse Help].
}

{Instance List PopupMenu} {
Most of the items on this menu can also be found the [Main Window <b>Main</b> Menu]. The unique item is [Select > Instance List PopupMenu Select SubMenu]. They are duplicated here for easy use while working with instances.

!Items
   * [Search... > Instance List PopupMenu Search... Item]
   * [Select > Instance List PopupMenu Select SubMenu]
   * [Combine > Instance List PopupMenu Combine Item]
   * [Combine Across Files > Instance List PopupMenu Combine Across Files Item]
   * [No Flatlines > Instance List PopupMenu No Flatlines Item]
   * [Single File Mode > Instance List PopupMenu Single File Mode Item]
   * [Absolute TimeStamps > Instance List PopupMenu Absolute TimeStamps Item]

This menu can be [torn off > Tear Off Menus].

This popmenu is on the [Main Window Instance Table] control.
}

{Instance List PopupMenu Search... Item} {
Starts an instance [search > List Search Control] operation.

[Accelerator Key > Keyboard Accelerators]: <tt>control-s</tt>
This item is part of the [instance list popup menu > Instance List PopupMenu].
}

{Instance List PopupMenu Select SubMenu} {
See [How to Select Object Instances] for more information.

!Items
   * <b>Clear</b>: unselects every instance in the list.
   * <b>by Statistic</b>: select every instance that support the currently selected statistics.
   * <b>by Type</b>: for every currently selected instance; select all other instances of the same type.
   * <b>All</b>: select every instance in the list.

This menu can be [torn off > Tear Off Menus].

This menu is part of the [instance list popup menu > Instance List PopupMenu].
}

{Instance List PopupMenu Combine Item} {
Does the same thing as the [Main Menu Combine Item].

This item is part of the [instance list popup menu > Instance List PopupMenu].
}

{Instance List PopupMenu Combine Across Files Item} {
Does the same thing as the [Main Menu Combine Across Files Item].

This item is part of the [instance list popup menu > Instance List PopupMenu].
}

{Instance List PopupMenu No Flatlines Item} {
Does the same thing as the [Main Menu No Flatlines Item].

This item is part of the [instance list popup menu > Instance List PopupMenu].
}

{Instance List PopupMenu Single File Mode Item} {
Does the same thing as the [Main Menu Single File Mode Item].

This item is part of the [instance list popup menu > Instance List PopupMenu].
}

{Instance List PopupMenu Absolute TimeStamps Item} {
Does the same thing as the [Main Menu Absolute TimeStamps Item].

This item is part of the [instance list popup menu > Instance List PopupMenu].
}

{Instance Definition} {
The term <b>instance</b> is used to refer to a logical identifiable entity which has associated with it a set of statistics. A finite number of data samples exist for each instance. Each sample is a snapshot of all the instances statistic values at a particular point in time.

An instance's identity is determined by the following properties:
   * a name
   * a [type > Instance Type Definition]
   * an optional process id
   * the file the instance's samples where read from
}

{Instance Type Definition} {
Each [instance > Instance Definition] has a type. Each type has:
   * a name
   * a version number
   * a set of statistic names

The type is identified by its name and version number. Vsd automatically generates version numbers when it finds two types with the same name but different static names. This only happens when vsd loads more than one file. The first type loaded by vsd is always version one. Vsd shows other version numbers as a suffix on the type name.

!Well Known Instance Types
[statmonitor] is the standard generator of vsd data files and it defines the following well known types in its output. They fall into two main categories:
   * <b>Cache Instance Types</b>
      * [Vm Type]
      * [Shrpc Type]
      * [Pgsvr Type]
      * [Stn Type]
      * [Extent Type]
      * [Session Type]
      * [Statmon Type]
      * [AppStat Type]
   * <b>Operating System Instance Types</b>
      * [Process Type]
      * [TCP Type]
      * [SolarisSystem Type]
      * [Disk Type]
      * [SimpleNetwork Type]
      * [ComplexNetwork Type]
      * [Partition Type]
      * [SystemPages Type]
      * [NtSystem Type]
      * [NtMemory Type]
      * [NtObjects Type]
      * [NtPagingFile Type]
      * [NtNetwork Type]
      * [NtLogicalDisk Type]
      * [NtThread Type]

If data files are generated with other tools they are free to define their own types.
}

{SAP} {
SAP stands for system agent process. Physically its a Java VM. Each stone has a primary SAP and can have any number of optional remote SAPs. SAPs are started and stopped when the stone is started and stopped. The SAP manages all communication with the stone. In vsd its represented by:
   * a [Vm > Vm Type] and whose name ends with <tt>sap</tt>
   * a [shared page cache monitor > Shrpc Type]
   * a [pageService > Pgsvr Type]
   * one or more [aioWriters > Pgsvr Type]
}

{Vm Type} {
Represents a Java virtual machine. This type has a great number of statistics.
They include:
   * OS [Process Type] statistics
   * statistics for vm internals
   * statistics for Java code that may be executed in this VM. Examples of these are ORB, EJB, OTS, and Activator statistics.

!Vm Type Versions
}

{Session Type} {
Represents a single GemStone session. Sessions are always associated with a single VM process but a VM can have more than one session.

!Session Type Versions
}

{Pgsvr Type} {
Represents two different kinds of threads that run in the [SAP] VM.
   * Each SAP has a single pgsvr thread named <u><tt>pageService</tt></u>. Its services the pages in the shared page cache frames. It removes pages that are no longer needed and preempts pages when frames are in high demand.
   * Each SAP can have one or more threads named <u><tt>aioWriter</tt><em>x</em></u>. These threads scan the pages in the shared page cache and writing dirty ones as fast as they can to the extents.

!Pgsvr Type Versions
}

{Extent Type} {
Represents a single [stone > Stn Type] extent file. Stones can have one or more extents. The statistics measure how much the extent is being used and how much of it is in use.

!Extent Type Versions
}

{Shrpc Type} {
Represents the shared page cache manager. Each [SAP] VM has a single instance of this type. The statistics measure how the frames in the shared cache are being used.
!Shrpc Type Versions
}

{Stn Type} {
Represents the stone service. This is a single process that each GemStone system has. In addition to the standard [process > Process Type] statistics, its statistics measure extent and tranlog usage and transaction performance.

!Stn Type Versions
}

{Statmon Type} {
Represents the [statmonitor] process that collected the data. The only statistic this type has, other than the standard [process > Process Type] ones, is the [TimeWritingStats Statistic].

!Statmon Type Versions
}

{AppStat Type} {
Represents the application statistics collected by [statmonitor]. Statmonitor can be told when it starts to collection a certain number of appstats by using the <tt>-n</tt> command line switch. These shared counter statistics will always be zero unless application code has been written to change their values.

!AppStat Type Versions
}

{Process Type} {
Represents a single operating system process. Many of the other types include the process type's statistics. If [statmonitor] is started from vsd a instance of this type will be collected for vsd.
Also each <tt>-P</tt> [statmonitor] command line argument will result in an instance of this type.

Only collected by [statmonitor] if it started with a <tt>-s</tt> level greater than zero.

!Process Type Versions
}

{SolarisSystem Type} {
Represents a single Solaris machine. These statistics are the best ones to look at first to see overall resource usage on a machine.

Only collected by [statmonitor] if it started with a <tt>-s</tt> level greater than zero.

!SolarisSystem Type Versions
}

{Solaris_x86_System Type} {
Represents a single Solaris machine on the x86_64 architecture. These statistics are the best ones to look at first to see overall resource usage on a machine.

Only collected by [statmonitor] if it started with a <tt>-s</tt> level greater than zero.

!Solaris_x86_System Type Versions
}


{NtSystem Type} {
Represents a single Windows NT machine. These statistics are the best ones to look at first to see overall resource usage on a machine.

Only collected by [statmonitor] if it started with a <tt>-s</tt> level greater than zero.

!NtSystem Type Versions
}
{NtMemory Type} {
Represents the memory management subsystem of a Windows NT machine. These statistics let you determine how much paging your machine is doing.

Only collected by [statmonitor] if it started with a <tt>-s</tt> level greater than zero.

!NtMemory Type Versions
}
{NtObjects Type} {
Represents the resource tracking subsystem of a Windows NT machine. These statistics are just counts of a number of system objects.

Only collected by [statmonitor] if it started with a <tt>-s</tt> level greater than zero.

!NtObjects Type Versions
}
{NtPagingFile Type} {
Represents a single Windows NT paging file. Paging files are used to provide virtual memory swap space. If it fills up you will start to get out of memory errors.

Only collected by [statmonitor] if it started with a <tt>-s</tt> level greater than one.

!NtPagingFile Type Versions
}
{NtNetwork Type} {
Represents a Windows NT network subsystem.

Only collected by [statmonitor] if it started with a <tt>-s</tt> level greater than one.

!NtNetwork Type Versions
}
{NtLogicalDisk Type} {
Represents a single formatted Windows NT file system. More than one of these can exist.

Only collected by [statmonitor] if it started with a <tt>-s</tt> level greater than one.

!NtLogicalDisk Type Versions
}
{NtThread Type} {
Represents a single Windows NT native thread. Each process can have one or more native threads. This type lets you see process like statistics for each thread. However a huge number of thread instances can exist so collecting at this level should only be done for short periods of time.

Only collected by [statmonitor] if it started with a <tt>-s</tt> level greater than two.

!NtThread Type Versions
}

{Disk Type} {
Represents a single operating system disk. Disks represent the physical device. They can be partioned into one or more [partitions > Partition Type].

Only collected by [statmonitor] if it started with a <tt>-s</tt> level greater than one.

!Disk Type Versions
}

{TCP Type} {
Represents a machines TCP networking subsystem.

On Solaris only collected by [statmonitor] if it started with a <tt>-s</tt> level greater than one.
On Windows NT only collected by [statmonitor] if it started with a <tt>-s</tt> level greater than zero.

!TCP Type Versions
}

{SimpleNetwork Type} {
Represents a machines simple network adaptors. Typically this is the loopback adaptor. The loopback adapter is used when inter-process communication is done with sockets on the same machine.

Only collected by [statmonitor] if it started with a <tt>-s</tt> level greater than two.

!SimpleNetwork Type Versions
}

{ComplexNetwork Type} {
Represents a machines complex network adaptors. Typically this is any adaptor except for loopback.

Only collected by [statmonitor] if it started with a <tt>-s</tt> level greater than two.

!ComplexNetwork Type Versions
}

{Partition Type} {
Represents a single partition on an operating system disk. Each file system is usually on a single partition.

Only collected by [statmonitor] if it started with a <tt>-s</tt> level greater than two.

!Partition Type Versions
}

{SystemPages Type} {
Represents advanced Solaris memory management statistics. These statistics are expensive to collect and in most cases statistics on [SolarisSystem Type] are adequate.

Only collected by [statmonitor] if it started with a <tt>-s</tt> level greater than three.

!SystemPages Type Versions
}

{Loaded File Description Syntax} {
For loaded files vsd displays a short descriptive string to identify the file.
The exact syntax is <u><em>id</em><tt>. </tt><em>name os host version</em></u> where:
   * <em>id</em> is a unique number. Its used in the [instance table's > Main Window Instance Table] <b>File</b> column.
   * <em>name</em> is a trimmed form of the absolute file name. It will only be trimmed if the trimmed name differs from all other loaded file trimmed names.
   * <em>os</em> the operating system that the file's data was collected on.
   * <em>host</em> the host name of the machine the file's data was collected on.
   * <em>version</em> the version of the product the file's data was collected on.
}

{Main Window Chart ComboBox} {
The chart control has the following functions:
   * display name of current chart
   * display names of all existing charts
   * enter name for a new chart
   * pick the current chart

!Current Chart
The last [chart window > Chart Window Features] that was selected is the current chart. Its name is displayed in this control.
To change the current chart just click on that chart window or drop down the chart control's combobox and pick it from the list. The drop down list contains the names of all existing chart windows.

!Naming a New Chart
Any time a [chart window > Chart Window Features] is created it must be given an name. By default the name is <u><tt>Chart </tt><em>x</em></u> where <em>x</em> is a number. You can use the chart control to enter your own name by clicking on it and [typing > String Entry Editing] in the new name. After the name has been entered create the new chart and it should have the entered name.

This control is on the [main window > Main Window Features].
}

{Version History} {
Please visit the following web page for a history of VSD versions: http://gemtalksystems.com/products/vsd/history/

}

{File Trimming} {
Trimming data causes vsd to act as if that data does not exist.\
Each loaded file can have a two sequences of its data trimmed.
The <em>Left</em> sequence always starts with the file's first data sample.
The <em>Right</em> sequence always ends with the file's last data sample.
Trimming is always done with a single line even though it will cause the\
entire file to be trimmed. Using a line gives the trimmer a graphical\
display to pick the most meaningful trim point.
Trimming can be done more than once to a sequence making the sequence
larger each time.\
Untrimming totally reverses all trim operations on the sequence.

File and line trimming and untrimming may be disabled when rolling time \
trimming is active. See [rolling time trimming > File Menu Set Rolling Time Window].

The menu items that support file trimming are:
   * Line [Trim Left > Line Menu Trim Left Item]
   * Line [Trim Right > Line Menu Trim Right Item]
   * Line [Untrim Left > Line Menu Untrim Left Item]
   * Line [Untrim Right > Line Menu Untrim Right Item]
   * File [Untrim Left > File Menu Untrim Left Item]
   * File [Untrim Right > File Menu Untrim Right Item]
   * File [Set rolling time window > File Menu Set Rolling Time Window]
}

{Line Arithmetic} {
Two source lines on the same chart can be used to produce a new result line.\
The values in the result line are the result of adding, subtracting, or\
dividing the values of the source lines.\
The menu items that support line arithmetic are:
   * [Add Lines > Line Menu Add Lines Item]
   * [Diff Lines > Line Menu Diff Lines Item]
   * [Divide Lines > Line Menu Divide Lines Item]

The resulting line will only have data in the time period the two original lines had in common. Line arithmetic can not be done on disjoint lines. You can [combine > Main Menu Combine Item] disjoint statistics which is much like adding lines.

If a [copy > Main Menu Copy Referenced Lines Item] of the source lines\
is made then subsequent changes to the sources lines will have no effect\
on the result line.

If the result line has a [reference > Main Menu Copy Referenced Lines Item]\
to the source lines then subsequent changes in the source lines will be\
propogated the the result line.
}
{Multiple Files} {
Vsd now has much better support for working with multiple files:
   * The [instance table > Main Window Instance Table] shows the file id the instance was loaded from. You can [control > Controlling the Enabled Files] which files instances will be displayed.
   * [Template expansion > Template Expansion] will create a chart for each file making it easy to compare files.
   * Some other options have been added allowing files to be [compared > How to Compare Files] and [merged > How to Merge Files].
}
{statmonitor} {
The statistic monitor is a process that periodically samples statistics and writes their values to a file. The source of the statistics can be a shared cache created by a [stone > Stn Type] or the operating system. For both sources they must reside on the machine the statistic monitor is running on. By default statmonitor will be monitoring both a shared cache and the operating system.

The executable to run to create a statistic monitor is <tt>statmonitor</tt>. Its located in the <tt>bin</tt> subdirectory. Its important to use the statmonitor executable that was distributed with the product whose shared cache you wish to monitor. If you don't then its likely your statmonitor will fail to start with a version mismatch error.

Statmonitor will keep running until its interrupted or its reached the limit set by <tt>-h</tt> or <tt>-t</tt>.

Statmonitor requires a single argument when you start it. That is the name of the [stone > Stn Type] whose cache statistics will be monitored. If you only want to monitor operating system statistics then use the string <tt>none</tt> as the stone name.

For a description of the format of the files written by statmonitor see [Statmonitor Output Format].

Statmonitor accepts a large number of optional switches after the required stone name. They fall into one of the following categories.

!Input Control Switches
   * <tt>-i</tt> <em>interval</em>:  specifies the sampling interval in seconds. The default is twenty seconds. The minimum is one second. Overrides any previous <tt>-i</tt> or <tt>-I</tt> switches.
   * <tt>-I</tt> <em>msInterval</em>:  specifies the sampling interval in milliseconds (thousandths of a second). The default is twenty seconds. The current minimum is 100 milliseconds. Subsecond sampling intervals cause an actual timestamp to not be written to the output file for each sample. Instead a simple counter is written and the analyzer running vsd needs to remember the actual interval used. Overrides any previous <tt>-i</tt> or <tt>-I</tt> switches.
   * <tt>-m</tt> <em>stoneHost</em>:  if the cache you will monitor is remote from the stone then in addition to the required stone name you must also specify the host the stone is running on.
   * <tt>-n</tt> <em>numAppStats</em>:  tells statmonitor how many shared counter statistics to collect from the shared cache. By default it doesn't collect any. If its told to collect one or more then you will see a single [AppStat Type] instance and it will have statistics named <tt>sharedCounter</tt><em>id</em> where <em>id</em> is a number starting at zero. The number of statistics it will have is determined by the <em>numAppStats</em> argument. By default the value of all shared counters is zero. You must instrument your code if you want change their values. The Java methods to use are <tt>initSharedCounter</tt> and <tt>incrementSharedCounter</tt> on the <tt>StatisticAccess</tt> interface in the <tt>gemstone.services</tt> package.
   * <tt>-p</tt> <em>sessionId</em>:  causes statmonitor to only collect cache statistics for the specified [sessions > Session Type]. This switch can be repeated if you want to monitor more than one session. By default statmonitor will collect cache statistics on all sessions. This switch exists for historical reasons. Its not clear if it serves any useful purpose.
   * <tt>-P</tt> <em>processId</em>: This switch can be repeated if you want to monitor more than one additional [process > Process Type]. By default statmonitor collects statistics for all the processes that have cache statistics. This switch lets you collect process statistics for processes that don't have cache statistics. For example your web server.
   * <tt>-s</tt> <em>level</em>:  tells statmonitor how many operating system statistics it should collect. If you look at the [operating system types > Instance Type Definition] each one documents what the level must be for it to get collected. The default level is one. If the level is zero then no operating system statistics will be collected. Increasing the level causes additional statistics and instance types to be collected. On Windows NT setting the level higher than two can causes an ever increasing number of [thread instances > NtThread Type] to be collected which vsd will not handle well so only collect at this level for short periods of time. On Solaris setting the level higher than three can cause statmonitor to consume a great deal more CPU so it should only be done if the [SystemPages Type] is really needed.
   * <tt>-v</tt> <em>vsdPid</em>: Used by vsd when it is starting statmonitor. This causes statmonitor to collect [process > Process Type] statistics automatically on the vsd that started it.

!Output Control Switches
   * <tt>-f</tt> <em>fileName</em>:  specifies the name of the file statmonitor will write its output to. If not specified defaults to <u><tt>statmon</tt><em>id</em><tt>.out</tt></u>. If you want statmonitor to write to its standard output, instead of a file, then use the string <tt>stdout</tt> as the <em>fileName</em> argument.
   * <tt>-z</tt>:  causes statmonitor's output file to be compressed using gzip. Vsd is able to read these files transparently. If you want to uncompress use the gunzip executable.
   * <tt>-Z</tt>:  causes statmonitor's output file to be compressed using lz4. Vsd is able to read these files transparently. If you want to uncompress use the lz4 executable.
   * <tt>-r</tt>:  causes statmonitor to restart a new output file when the current one completes. The <tt>-h</tt> or <tt>-t</tt> switches control when a restart is done. The base name of each file is given a unique suffix. Note that the generated files can be concatenated together and treated by vsd as a single file.
   * <tt>-h</tt> <em>hours</em>: causes statmonitor to only write to its output file for the given number of hours. Once that time is up statmonitor exits or restarts a new file (see <tt>-r</tt>). By default statmonitor writes until its interrupted or killed.
   * <tt>-t</tt> <em>times</em>: causes statmonitor to only write to its output file the given number of samples. Once that limits has been reached statmonitor exits or restarts a new file (see <tt>-r</tt>). By default statmonitor writes until its interrupted or killed.
   * <tt>-u</tt> <em>seconds</em>: tells statmonitor how long to buffer samples internally before flushing them to the output file. By default it will buffer for 60 seconds. Setting this to zero causes the interval (<tt>-i</tt> or <tt>-I</tt>) value to be used.
}
{Template Expansion} {
A template is made up of a list of [<em>lineSpecs</em> > Template Syntax]. Each lineSpec can end up [creating > Line Creation] zero or more lines on a chart. If you want all the lines generated by the expansion to go to a single chart window then use [Add From Template > Chart Menu Add From Template SubMenu]. Otherwise a chart is created for each unique file in the selected instances.

!Operations that Expand Templates
   * [New Template Chart > Template Menu New Template Chart SubMenu]
   * [Add From Template > Chart Menu Add From Template SubMenu]
}
{Statistic Aliases} {
Statistic aliases can be added to the [config file > VSD Files].
A statistic alias causes vsd to always use an existing statistic definition when it sees an aliased name. Aliases can be used to map older non-existent names to an existing statistic.
For each alias you want to define add a line of the following form:
   * <tt>sl_stat -alias</tt> <em>oldname newname</em>
where <em>oldname</em> is the statistic name you want mapped to <em>newname</em>.
}
{Statistic Definitions} {
Statistic definitions can be added to the [config file > VSD Files].
Each statistic definition must have the following attributes defined:
   * <b>name:</b> Names the statistic. This attribute is required. Should be an alphanumeric string.
   * <b>kind:</b> See [Statistic Information Window]'s <b>Displays</b> section for a description. This attribute is optional and defaults to <tt>uvalue</tt>. Legal values are:
      * <tt>counter</tt>
      * <tt>counter64</tt>
      * <tt>uvalue</tt>
      * <tt>svalue</tt>
      * <tt>svalue64</tt>
      * <tt>float</tt>
   * <b>level:</b> See [Level MenuButton] for a description. This attribute is optional and defaults to <tt>common</tt>. Legal values are:
      * <tt>common</tt>
      * <tt>advanced</tt>
      * <tt>wizard</tt>
   * <b>units:</b> Describes the units that the statistic's value represents. This attribute is optional and defaults to <tt>none</tt>. Can be any string. See [Statistic Information Window]'s <b>Displays</b> section for list of common unit strings. 
   * <b>isOSStat:</b> Use a true value to indicate that the statistic value is generated by the operating system. This attribute is optional and defaults to <tt>false</tt>. Must be a boolean value.
   * <b>filter:</b> See [Default Filter MenuButton] for a description. This attribute is optional and defaults to <tt>default</tt>. Legal values are:
      * <tt>default</tt>
      * <tt>none</tt>
      * <tt>persecond</tt>
      * <tt>persample</tt>
      * <tt>smooth</tt>
      * <tt>aggregate</tt>
   * <b>description:</b> Documents the statistic. This attribute is optional and defaults to an empty string. Can be any string. To start a new paragraph in the description use an end of line. When refering to another statistic in the description text use this form to make it a hyper-link:
      * <tt> &#91;</tt><em>SN</em><tt> > </tt><em>SN</em><tt> Statistic]</tt> where <em>SN</em> is the name of the other statistic. Note that if your description string is enclosed in quotes <tt>""</tt> instead of curly brackets <tt>{}</tt> then you will need to escape the first square bracket with a backslash <tt>\</tt>.
Any user defined statistics will override definitions shipped with vsd.
For each statistic you want to define add a line of this form:
   * <tt>set statdef(</tt><em>name</em><tt>) {</tt><em>type level units isOSStat filter description</em><tt>}</tt>
To leave an optional attribute empty use an empty pair of curly brackets <tt>{}</tt>.
}
{Template Syntax} {
The contents of the [template file > VSD Files] must be [tcl code > Tcl Language]. The code in this file should define templates. Each template definition consists of a <em>name</em> and a <em>templateSpec</em>. To define a template an element must be added to the Tcl array named <b>vsdtemplates</b> and the index of the element must be the templates <em>name</em>.

The standard format of a template definition is: <tt>set vsdtemplates(</tt><em>name</em><tt>) </tt><em>templateSpec</em>.

What follows is the syntax for <em>templateSpecs</em>.
Square brackets <tt>[[]</tt> are used in the syntax descriptions to designate\
an optional element.

A <em>list</em> starts with an open curly brace <b>{</b> and is terminated\
by a matching close curly brace <b>}</b>. Whitespace is use to seperate\
elements in a <em>list</em>. The curly braces are not required for single element lists.

A <em>templateSpec</em> is a <em>list</em> of <em>lineSpec</em>.
A <em>lineSpec</em> is either a <em>namesLineSpec</em>, a <em>simpleLineSpec</em> or an <em>operatorLineSpec</em>.
A <em>namesLineSpec</em> is a <em>list</em> in the following format:
   * <b>@</b> <em>nameList</em>
The <em>nameList</em> is a <em>list</em> of zero or more template names. A <em>namesLineSpec</em> is treated as the collection of all the named templates.

A <em>simpleLineSpec</em> is a <em>list</em> in the following format: 
   * <b>{</b><em>typeList namePattern stat scale filter axis</em> <tt>[[</tt><em>divider offset normalize</em><tt>] [[</tt><em>statFilter</em><tt>]</tt><b>}</b>
An <em>operatorLineSpec</em> is a <em>list</em> in the following format: 
   * <b>{</b><em>operator lineSpec1 lineSpec2 scale filter axis</em> <tt>[[</tt><em>divider offset normalize</em><tt>] [[</tt><em>statFilter</em><tt>]</tt><b>}</b>

The <em>typeList</em>, <em>namePattern</em>, and <em>stat</em> are used to select the data that will be plotted.
The <em>typeList</em> is a <em>list</em> of zero or more object type strings and/or file numbers.\
Examples of object type strings are Stn, Shrpc, Vm, Session, Extent and Pgsvr.\
Each type in the list will be selected.
File numbers can be used to limit the spec to the numbered file.
If no types are specified then all the types that support <em>stat</em> will be selected.
If no file numbers are specified then all files enabled will be selected.
An optional plus character <b>+</b> can be appended to the last type in the\
list. This will cause all of the instances that match this <em>lineSpec</em>\
to be [combined > Main Menu Combine Item].

The <em>namePattern</em> can be used to restrict which instances of the\
 types should be selected. It can be a simple name or a [pattern > Glob Style Pattern Syntax]. Use the pattern <b>*</b> if you don't care about the name.

The <em>stat</em> must be a valid statistic name for the given <em>typeList</em>.

The <em>operator</em> field must be one of the following strings:
   * <b>plus</b>
   * <b>diff</b>
   * <b>divide</b>

Both <em>lineSpec1</em> and <em>lineSpec2</em> are a <em>lineSpec</em>.\
The lines produced by these specs are combined together using the <em>operator</em>\
to produce the visible line. If one spec produces more lines than the\
other than the final line from the lessor spec is used repeatedly.

The <em>scale</em> must be a number. See [Display Scaling a Line] to learn what this number will do.

The <em>filter</em> must be one of the following strings:
  <b>none</b>, <b>persecond</b>, <b>persample</b>, <b>smooth</b>, or <b>aggregate</b>.
See [How to Filter Statistics] to learn what this string will do.

The <em>axis</em> must be the string <b>y</b> or <b>y2</b>.\
This [controls what Y axis > Line Menu Graph on Left Axis Item] the line will be graphed on

The <em>divider</em> must be a number. See [Value Scaling a Line]\
to learn what this number will do.

The <em>offset</em> must be a number. See [Offsetting a Line]\
to learn what this number will do.
The <em>offset</em> number is ignored if <em>normalize</em> is not zero.

The <em>normalize</em> must be the number zero or one.\
See [Normalizing a Line] to learn what this number will do.

!Statistic Filters
The optional <em>statFilter</em> is a <em>list</em> that lets you exclude lines\
based on their stat values. Its format is:
   <b>{</b><em>count min max mean stddev</em><b>}</b>
Each line produced by a template's lineSpec is checked against this filter before its added to the chart. Each line's values must pass each of the constraints imposed by the non-empty items in the filter.
Any statFilter item can be an empty string <b>{}</b>,
a single number, or a list of two numbers.

If an item is the empty string <b>{}</b> it is ignored.

If an item is a list of two numbers (i.e. <b>{36 100}</b>) then\
the first number must be less than the second number and\
if the stat is less than the first or greater than the second\
then it is excluded.

If an item is a number then it is used as follows:
   * If <em>count</em> >= 0 then any line with less samples than the filter is excluded.
   * If <em>count</em> < 0 then any line with more samples than the absolute value\
of the filter is excluded.
   * If <em>min</em> >= 0 then any line whose min is less than the filter is excluded.
   * If <em>min</em> < 0 then any line whose min is greater than the filter is excluded.
   * If <em>max</em> >= 0 then any line whose max is less than the filter is excluded.
   * If <em>max</em> < 0 then any line whose max is greater than the absolute value of the filter is excluded.
   * If <em>mean</em> >= 0 then any line whose mean is less than the filter is excluded.
   * If <em>mean</em> < 0 then any line whose mean is greater than the absolute value of the filter is excluded.
   * If <em>stddev</em> >= 0 then any line whose stddev is less than the filter is excluded.
   * If <em>stddev</em> < 0 then any line whose stddev is greater than the absolute value of the filter is excluded.

!Filter examples:
   * <tt>{100}</tt> only includes stats who have at least 100 samples.
   * <tt>{{} {} 100}</tt> only includes stats whose max is >= 100.
   * <tt>{{} 20 {} {} -5}</tt> only includes stats whose min >= 20\
and whose standard deviation is less than 5.
   * <tt>{{100 200} {} {-500} {120 240}}</tt> only includes stats who have\
at least 100 samples but no more than 200 samples\
and whose maximum value is less than 500\
and whose average value is between 120 and 240.
}
{Glob Style Pattern Syntax} {
   * <b>*</b> Matches any sequence of characters including a null string.
   * <b>?</b> Matches any single character.
   * <b>[[</b><em>chars</em><b>]</b> Matches any character in the set given by\
<em>chars</em>. If a sequence of the form <em>x</em><b>-</b><em>y</em> appears\
in <em>chars</em>, then any character between <em>x</em> and <em>y</em>,\
inclusive, will match.
   * <b>\</b><em>x</em> Matches the single character <em>x</em>.\
This provides a way of avoiding the special\
interpretation of the characters <b>*?[[]\</b> in the pattern.
}
}

  
# The stathelp array contains extra information about statistics that
# needs to be added to the standard information from 'sl_stat -info'.
array set stathelp {
{FreeFrameCount} {
In the [shrpc > Shrpc Type], the FreeFrameCount displays the current number of free frames available in the [Shared Page Cache]. The cache is considered full as this count approaches zero.

See also: [FramesAddedToFreeList > FramesAddedToFreeList Statistic],\
[PagesPreempted > PagesPreempted Statistic],\
[PagesRemovedForStone > PagesRemovedForStone Statistic],\
and [Shared Page Cache Health].
}

{IVolCSW} {
A large number of [involuntary context switches > Context Switch] indicates contention for the cpu. 
}
{VolCSW} {
A large number of [voluntary context switches > Context Switch] indicates an increase in non-cpu resources.
}
{LocalPageCacheMisses} {
NOTE: prior to 4.6, the LocalPageCacheMisses statistic was grossly overstated. You can sum the extent stat [ExtentReadKBytes > ExtentReadKBytes Statistic] to approximate LocalPageCacheMisses.
}

{PrivatePageCacheSize} {
The private page cache is used by a session to cache freshly written temporary pages. If a session is writing a large number of objects, the number of temporary pages needed may exceed the default size of the private page cache. If the private page cache is large enough, you will see the stat [FramesAddedToFreeList > FramesAddedToFreeList Statistic] flat-lined at zero. 

!How big should I make the private page cache?
You can tell you need a larger private page cache if:
   * The session is doing [FramesAddedToFreeList > FramesAddedToFreeList Statistic]. Optimally a session's [FramesAddedToFreeList > FramesAddedToFreeList Statistic] will be flat-lined at zero.

<b>Problem:</b> you can't set the private page cache size on activated VM's that use session pools!
}

{FramesAddedToFreeList} {
In the [shrpc > Shrpc Type], the FramesAddedToFreeList stat is a summary of all such activity in the system.

There are two active sources of FramesAddedToFreeList in the system; either a [session > Session Type] or the [AIO page servers]. 

The page server named <b>pageService</b> is implemented with a thread in the [SAP] vm. This particular thread is removing pages from the shared page cache that are ready to be re-used by the stone. These [removed pages > PagesRemovedForStone Statistic] are the residue of commit record disposal and reclaim activity. The <b>pageService</b> thread also performs [page preemption > PagesPreempted Statistic], which adds frames to the free list.

Optimally, a [session > Session Type] will have no FramesAddedToFreeList activity. Excessive activity of this stat for a [session > Session Type] indicates that the [private page cache > PrivatePageCacheSize Statistic] for the [session > Session Type] is too small. Thousands of FramesAddedToFreeList per second for a session is a significant performance degradation. You will also notice that [FramesFromFindFree > FramesFromFindFree Statistic] will dramatically increase when a [session > Session Type] has non-zero FramesAddedToFreeList.

See also: [FreeFrameCount > FreeFrameCount Statistic]
}
}
