#set -x
#=========================================================================
# Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
#
# Name - misc.sh
#
# Purpose - set up various useful functions and defaults for scripts
#
# $Id$
#
#=========================================================================

EXEEXT=
if [ -d /opt/gemstone ]; then
  GEMSTONE_LOCKBASE=/opt/gemstone
elif [ -d /usr/gemstone ]; then
  GEMSTONE_LOCKBASE=/usr/gemstone
else
  GEMSTONE_LOCKBASE=/opt/gemstone
fi
GEMSTONE_LOCKEXT="..LCK"                 # lock dir file extention
GEMSTONE_LOCKDIR="$GEMSTONE_LOCKBASE/locks"
NULLDEV=/dev/null
RM=/bin/rm
LS=/bin/ls
GSTMP=/tmp

OPT_GEMSTONE_LOGDIR="$GEMSTONE_LOCKBASE/log"          #   required log directory

# first argument is the switch passed, second is string to print
giveHelp() {
  # Make sure user has decent pager...
  if [ "x$PAGER" = "x" ]; then
    PAGER=more
  fi
  # Preferred help command is "-h."  Support "-H" and "help" for compatibility.
  if [ "x$1" = "x-h" ] || [ "x$1" = "x-H" ] || [ "x$1" = "xhelp" ]; then
    echo "Usage: $2 "
    exit 0
  fi
}

# error control
defaultErrorControl() {
  trap 'echo "${comid}[Error]:   ^C termination."; exit 1' 2	# SIGINT
  trap 'echo "${comid}[Error]:   kill termination."; exit 1' 15	# SIGTERM
  trap '' 1 					# SIGHUP
}

# switch procesing
# echo "in misc.sh SCRIPTDIR = $SCRIPTDIR" # enable for debugging
getSwitches() {
  #  echo "in getSwitches SCRIPTDIR = $SCRIPTDIR"  # enable for debugging
  unset _POSIX_OPTION_ORDER # Disable queer getopt mode
  switches="`"$GEMSTONE/bin/ggetopt" $1 $2`"
  status=$?
  if [ $status -ne 0 ]; then
    # ggetopt error
    echo "${comid}[Error]:   ggetopt error"
    exit 1
  fi
}

# Put descriptor limit back!
returnDescriptors() {
  if [ $hasDescCmd = y ]; then
    ulimit -n $originalDescriptorLimit
  fi
}

requireDirs() {
  for directory in $*
  do
    if [ ! -d $directory ]; then
      echo "${comid}[Error]:   required directory $directory is missing."
      exit 1
    fi
  done
}

simpleNRS () {
  # we must have a name - i.e. !tcp!name
  if [ "x$nrbody" = "x" ]; then
    # no name given
    echo "${comid}[Error]:       can not determine name part of the gemStoneName NRSpec."
    exit 1
  fi 

  # name must not include spaces or tabs
  spaceindex=`expr "$nrbody" : '.* .*'`
  tabindex=`expr "$nrbody" : '.*	.*'`
  if [ $spaceindex -ne 0 ] || [ $tabindex -ne 0 ]; then
    echo "${comid}[Error]: name part of netLdiName $nrbody has white space."
    exit 1
  fi

  # name must NOT be a filespec or path 
  stoneName_first_char=`expr "$nrbody" : '^\(.\).*$'`
  if [ "x$stoneName_first_char" = "x/" ]; then
    echo "${comid}[Error]:    name part of gemStoneName $nrbody must not be a path."
    exit 1 
  fi

  # the task type must be "" or "server"
  if [ "$nrexplicit" = "y" ] && [ "x$nrtaskname" != "x" ]; then
    if [ "$nrtaskname" != "server" ]; then
      echo "${comid}[Error]:    $nrtaskname , invalid gemStoneName NRSpec modifier."
      exit 1 
    fi
  fi

  # tcp or TCP protocol only! for now
  if [ "x$nrprotocol" = "x" ]; then nrprotocol="$default_protocol"; fi
  if [ "$nrprotocol" != "tcp" ] && [ "$nrprotocol" != "TCP" ]; then
    echo "${comid}[Error]:    $nrprotocol network protocol is not recognized."
    exit 1
  fi
}

# initialize arguments used for setconfig...
initConfig() {
  systemConfig=""
  exeConfig="$1"
  netLdiSpec=""
  runpgsvrSpec=""
}

##############################################################################
# Platform specific stuff follows...
# This file is specific for RISC6000.AIX only!!
##############################################################################

HOSTTYPE=RISC6000
export HOSTTYPE
OSTYPE=AIX
export OSTYPE
vendor="IBM Corporation"
PING=/etc/ping
pingArgs="-s 64 -c 1"
pingPostArgs=""

# raise file descriptors, i.e., just before calling executable
# saves old descriptor limit in originalDescriptorLimit
# no effect on AIX!
raiseDescriptors() {
  hasDescCmd=n
  descriptorLimit=32
  originalDescriptorLimit=32
}

getSwapPgm() {
  swapPgm=/usr/sbin/pstat
  pstatPgmName=/usr/sbin/pstat
  if [ -x /usr/sbin/pstat ]; then
    echo "Good, found pstat command in $pstatPgmName"
  else
    echo "Warning!  Could not find pstat command on this host"
    echo "  This could cause problems later in the script."
    #
    #  If it isn't in there, the conditional in the next
    #  section will succeed (no such program pstat).  As a result, a message
    #  will be printed stating that $pgmName could not be executed - thus
    #  setting $pgmName to pstat will insure that the message says
    #  the right thing.  $pstatPgmName will be blank and future users had
    #  better check for its validity
    swapPgm=pstat
    pstatPgmName=""
  fi
}

getSwapSize() {
  # of course AIX does everything differently...
  $swapPgm -s | egrep -v '[A-Z]' | egrep -v '^$' > $tmpFile
  status=$?	
  if [ $status -eq 0 ]; then
    read f1 f2 <$tmpFile
    theSize=`expr $f2 \* 4 `
  else
    swapfound=0
  fi
  rm -f $tmpFile
}

getTabSize() {
  if [ "x$pstatPgmName" = "x" ]; then 
    echo "pstat not available"
    tabSize=skip
  else
    $pstatPgmName -T | grep files >$tmpFile
    status=$?
    if [ $status -ne 0 ]; then
      echo "Warning:  Unable to determine system file table limit."
      if [ $myEffectiveUid -ne 0 ]; then
        echo "          This failure is probably due to you not being superuser."
      fi
      tabSize=skip
    else
      read junk t1 <$tmpFile
      tabSize=$t1
    fi
  fi
}

getAioRequired() {
  aioRequired=n
}
