#!/bin/bash
#set -xv

my_name=`basename $0`
usage(){   
    echo "Usage: $my_name caName"
    echo "where:"
    echo "   caName is a unique name for the certificate authority."
    echo "      Usually this will be the name of the person or entity owning the CA."
}


if [ $# -ne 1 ]; then
    usage
    exit 1
fi

. sslcommon.sh
if [ $OK -ne 1 ]; then
    exit 1
fi

CN=$1

# CA file filenames are hard-coded.

echo "Creating CA private key with random password and self-signed certificate"
CAPASSWD=$SSL_BASE_DIR/private/ca_key_password.txt
ensureFileDoesNotExist $CAPASSWD

CAKEY=$SSL_BASE_DIR/private/cacertkey.pem
ensureFileDoesNotExist $CAKEY

CACERT=$SSL_BASE_DIR/certs/cacert.pem
ensureFileDoesNotExist $CACERT

CLEANUP_FILES="${CAPASSWD} ${CAKEY} ${CACERT}"


$OPENSSL rand -base64 40 >$CAPASSWD
checkForError $CLEANUP_FILES
ensureFileExists $CAPASSWD $CLEANUP_FILES

$OPENSSL req -x509 -newkey rsa:4096 -keyout $CAKEY \
-out $CACERT -days 3650 -passout file:${CAPASSWD} \
-subj "/C=US/ST=OR/L=Beaverton/O=GemTalk Systems/CN=${CN}"

checkForError $CLEANUP_FILES
echo "CA private key and certificate successfully created"
echo "Private key password located in ${CAPASSWD}"
exit 0

