fileformat utf8
set compile_env: 0
! ------------------- Class definition for GciErrSType
expectvalue /Class
doit
CByteArray subclass: 'GciErrSType'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #( disallowGciStore)

%
expectvalue /Class
doit
GciErrSType comment: 
'
	"$GEMSTONE/include/gci.ht line 222
class GciErrSType {public:  OopType       category;                         OopType       context;     OopType       exceptionObj;    OopType       args[GCI_MAX_ERR_ARGS];           int          number;                           int          argCount;                         unsigned char fatal;                            // Since Gs64 v3.2.0  message and reason are Utf8 .
  char          message[GCI_ERR_STR_SIZE + 1];    char          reason[GCI_ERR_reasonSize + 1];    // If you change this struct,  Smalltalk client FFI code may
  //  need smalltalk code changes.

  inline void init(void) {    category = ((OopType)0x14);    exceptionObj = ((OopType)0x14);    number = 0;    context = ((OopType)0x14);    argCount = 0;    fatal = 0;    message[0] = ''\0'';    reason[0] = ''\0'';    args[0] = ((OopType)0x01);  }  GciErrSType() { init(); }  ~GciErrSType() { }  GciErrSType(GciErrSType *src);  void setError(int errNum, const char* msg);  void setFatalError(int errNum, const char* msg);  void appendStr(const char* str); // appends str to message};"
'
%
! ------------------- Remove existing behavior from GciErrSType
expectvalue /Metaclass3       
doit
GciErrSType removeAllMethods.
GciErrSType class removeAllMethods.
%
set compile_env: 0
! ------------------- Class methods for GciErrSType
category: 'Instance Creation'
classmethod: GciErrSType
new

	^self gcMalloc: 2168.
%
category: 'Instance Creation'
classmethod: GciErrSType
on: aCByteArray

	^self withAll: aCByteArray.
%
! ------------------- Instance methods for GciErrSType
category: 'Accessing'
method: GciErrSType
argCount

	^self int32At: 108.
%
category: 'Updating'
method: GciErrSType
argCount: anObject

	self 
		int32At: 108
		put: anObject.
%
category: 'Accessing'
method: GciErrSType
args

	| array offset |
	array := Array new: 10.
	offset := 24.
	1 to: array size do: [:i | 
		array at: i put: (self uint64At: offset).
		offset := offset + 8.
	].
	^array.
%
category: 'Updating'
method: GciErrSType
args: aSequenceableCollection

	| offset |
	offset := 24.
	1 to: aSequenceableCollection size do: [:i | 
		self 
			uint64At: offset
			put: (aSequenceableCollection at: i).
		offset := offset + 8.
	].
%
category: 'Accessing'
method: GciErrSType
category

	^self uint64At: 0.
%
category: 'Updating'
method: GciErrSType
category: anObject

	self 
		uint64At: 0
		put: anObject.
%
category: 'Accessing'
method: GciErrSType
context

	^self uint64At: 8.
%
category: 'Updating'
method: GciErrSType
context: anObject

	self 
		uint64At: 8
		put: anObject.
%
category: 'Accessing'
method: GciErrSType
exceptionObj

	^self uint64At: 16.
%
category: 'Updating'
method: GciErrSType
exceptionObj: anObject

	self 
		uint64At: 16
		put: anObject.
%
category: 'Accessing'
method: GciErrSType
fatal

	^self uint8At: 112.
%
category: 'Updating'
method: GciErrSType
fatal: anObject

	self 
		uint8At: 112
		put: anObject.
%
category: 'Initialization'
method: GciErrSType
initialize
%
category: 'Initialization'
method: GciErrSType
initialize: aCByteArray

	1 to: (self size min: aCByteArray size) do: [:i | 
		self uint8At: i put: (aCByteArray uint8At: i).
	].
%
category: 'Accessing'
method: GciErrSType
message

	^self _stringFromBytes: (self 
		byteArrayFrom: 113
		to: 1137).
%
category: 'Updating'
method: GciErrSType
message: aByteArray

	self
		replaceFrom: 113
		to: 112 + (1025 min: aByteArray size)
		with: aByteArray
		startingAt: 1.
%
category: 'Accessing'
method: GciErrSType
number

	^self int32At: 104.
%
category: 'Updating'
method: GciErrSType
number: anObject

	self 
		int32At: 104
		put: anObject.
%
category: 'Accessing'
method: GciErrSType
reason

	^self _stringFromBytes: (self 
		byteArrayFrom: 1138
		to: 2162).
%
category: 'Updating'
method: GciErrSType
reason: aByteArray

	self
		replaceFrom: 1138
		to: 1137 + (1025 min: aByteArray size)
		with: aByteArray
		startingAt: 1.
%
category: 'Conversion'
method: GciErrSType
_stringFromBytes: aByteArray

	| index |
	index := aByteArray indexOf: 0.
	^aByteArray
		at: 1 
		sizeBytes: 1 
		stringSize: (0 == index ifTrue: [aByteArray size] ifFalse: [index - 1]).
%
