! ========================================================================
! GciLegacyError.gs
!
! Copyright (C) by GemTalk Systems 1991-2020.  All Rights Reserved
! ========================================================================

expectvalue %String
doit
(Error subclass: 'GciLegacyError'
	instVarNames: #( errorDescription externalSession originalNumber)
	classVars: #()
	classInstVars: #()
	poolDictionaries: #()
	inDictionary: Globals
	options: #()) definition
%

! ------------------- Class comment for GciLegacyError
doit
GciLegacyError comment: 
'This class is part of the External Sessions implementation and represents
an execution Error from the GCI interface to the legacy external session.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
	errorDescription: Object
	externalSession: Object
	originalNumber: Object
'.
true
%

doit
GciLegacyError category: 'External Sessions'.
true
%

! Remove existing behavior from GciLegacyError
doit
GciLegacyError removeAllMethods.
GciLegacyError class removeAllMethods.
true
%
! ------------------- Class methods for GciLegacyError
category: 'signalling'
set compile_env: 0
classmethod: GciLegacyError
signal: anErrorDescription in: aLegacyExternalSession

	self new
		signal: anErrorDescription 
		in: aLegacyExternalSession.
%
! ------------------- Instance methods for GciLegacyError
category: 'accessing'
set compile_env: 0
method: GciLegacyError
actualExceptionClassOr: aBlock
	"Answer the class of the actual exception if there is one,
	 or the result of evaluating aBlock if not."

	| actualCls |
	actualCls := (LegacyErrNumMap atOrNil: self number ) ifNotNil: [ :a | a atOrNil: 1].
	^actualCls ifNil: aBlock
%
category: 'accessing'
set compile_env: 0
method: GciLegacyError
category

	^errorDescription category.
%
category: 'accessing'
set compile_env: 0
method: GciLegacyError
context

	^errorDescription context.
%
category: 'other'
set compile_env: 0
method: GciLegacyError
continue
	"Continue code execution in GemStone after an error.
	See GciContinue() in the GemBuilder for C manual for details."

	^externalSession 
		continue: errorDescription context 
		replacingTopOfStackWithOop: nil.
%
category: 'other'
set compile_env: 0
method: GciLegacyError
continueWith: anObject
	"This function is a variant of the continue method, except 
	that it allows you to modify the call stack before attempting 
	to continue the suspended Smalltalk execution.
	See GciContinueWith() in the GemBuilder for C manual for details."

	^externalSession 
		continue: errorDescription context 
		replacingTopOfStackWithOop: anObject asOop.
%
category: 'other'
set compile_env: 0
method: GciLegacyError
clearStack

	externalSession clearStackFor: errorDescription.
%
category: 'accessing'
set compile_env: 0
method: GciLegacyError
externalErrorNumber

	^errorDescription number.
%
category: 'accessing'
set compile_env: 0
method: GciLegacyError
externalSession

	^externalSession.
%
category: 'testing'
set compile_env: 0
method: GciLegacyError
matchesClasses: expClass
	"expClass is either a Class or an Array of Classes"

	| actualCls |
	actualCls := self actualExceptionClassOr: [^false].
	expClass _isArray
		ifTrue: [^expClass anySatisfy: [:aCls | actualCls isSubclassOf: aCls]]
		ifFalse: [^actualCls isSubclassOf: expClass]
%
category: 'accessing'
set compile_env: 0
method: GciLegacyError
originalNumber
  ^ originalNumber
%
category: 'signalling'
set compile_env: 0
method: GciLegacyError
signal: anErrorDescription in: aLegacyExternalSession

	errorDescription := anErrorDescription.
	externalSession := aLegacyExternalSession.
	(originalNumber := errorDescription number) == 1001 ifTrue: [^self signalCompileError].
	messageText := errorDescription message.
	"avoid killing current session with fatal errors"
	(originalNumber between: 4000 and: 4999) ifTrue: [
		messageText add: ' original number: ' , originalNumber asString.
		"and self number is inherited value 2710"
	] ifFalse: [
		self _number: originalNumber.
	].
	"self stack ifNotNil: [:stack | messageText lf ; add: stack]."
	self details: messageText.
	self signal.
%
category: 'signalling'
set compile_env: 0
method: GciLegacyError
signalCompileError

	gsArgs := errorDescription asArray.
	"gsArgs size: gciErrSType argCount.
	gsArgs := gsArgs collect: [:each | 
		externalSession valueOfOop: each toLevel: 4.
	]."
	messageText := errorDescription message.
	self details: messageText.
	self signal.
%
