! ========================================================================
! Copyright (C) by GemTalk Systems 1991-2020.  All Rights Reserved
!
! $Id$
!
! ========================================================================

expectvalue %String
run
^ Object _newKernelSubclass: #GemStoneX509Parameters
  instVarNames: #(#netldiPort #netldiHost #certificate #caCertificate #privateKey #loginFlags #extraGemArgs #dirArg #logArg)
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
  options: #(#instancesNonPersistent)
  reservedOop: 1955
%


doit
GemStoneX509Parameters category: 'X509'.
true
%

! Remove existing behavior from GemStoneX509Parameters
removeallmethods GemStoneX509Parameters
removeallclassmethods GemStoneX509Parameters

! ------------------- Class methods for GemStoneX509Parameters
classmethod:
comment
^'GemStoneX509Parameters is used by the class GsX509ExternalSession.
Instances are used as arguments to the login methods in class
GsX509ExternalSession. Instnaces of this class contain transient
state and may not be committed to the database.

Instance variables:

netldiPort    - SmallInteger or String - listening port of the netldi
netldiHost    - String - hostname or IP address of the netldi
certificate   - GsX509Certificate or GsX509CertificateChain - certificate or
                chain of certificates to be used for login.
caCertificate - GsX509Certificate or GsX509CertificateChain - trust anchor
                certificate(s) used to verify certificates presented by the
		netldi.
privateKey    - GsTlsPrivateKey - private key which matches certificate.
loginFlags    - SmallInteger - bit flags for login. See gci.ht for latest
                bit field definitions.
extraGemArgs  - String - extra arguments to be passed to gem executable.
dirArg        - String - working directory for the gem
logArg        - String - name of the log file for the gem.

'
%

category: 'Instance Creation'
classmethod:
newWithNetldiPort: aPort netldiHost: aHostOrIp certificate: aCert caCertificate: aCaCert privateKey: aKey
| result |
result := self new initialize.
result netldiPort: aPort;
       netldiHost: aHostOrIp;
       certificate: aCert;
       caCertificate: aCaCert;
       privateKey: aKey .
^ result
%

category: 'Instance Creation'
classmethod: GemStoneX509Parameters
newFromPemFilesWithNetldiPort: aPort netldiHost: aHostOrIp certificate: aCertFn caCertificate: aCaCertFn privateKey: aKeyFn
| result |
result := self new initialize.
result netldiPort: aPort;
       netldiHost: aHostOrIp;
       certificate: (GsX509CertificateChain newFromPemFile: aCertFn);
       caCertificate: (GsX509CertificateChain newFromPemFile: aCaCertFn);
       privateKey: (GsTlsPrivateKey newFromPemFile: aKeyFn) .
^ result
%

category: 'Instance Creation'
classmethod: GemStoneX509Parameters
newFromPemStringsWithNetldiPort: aPort netldiHost: aHostOrIp certificate: aCertString caCertificate: aCaCertString privateKey: aKeyString
| result |
result := self new initialize.
result netldiPort: aPort;
       netldiHost: aHostOrIp;
       certificate: (GsX509CertificateChain newFromPemString: aCertString);
       caCertificate: (GsX509CertificateChain newFromPemString: aCaCertString);
       privateKey: (GsTlsPrivateKey newFromPemString: aKeyString) .
^ result
%


category: 'Accessing'
method:
netldiPort
^ netldiPort
%

category: 'Accessing'
method:
netldiHost
^ netldiHost
%

category: 'Accessing'
method:
certificate
^ certificate
%

category: 'Accessing'
method:
caCertificate
^ caCertificate
%

category: 'Accessing'
method:
privateKey
^ privateKey
%

category: 'Accessing'
method:
loginFlags
^ loginFlags
%

category: 'Accessing'
method:
extraGemArgs
^ extraGemArgs
%

category: 'Accessing'
method:
dirArg
^ dirArg
%

category: 'Accessing'
method:
logArg
^ logArg
%


category: 'Updating'
method:
netldiPort: anInt
netldiPort := anInt .
%

category: 'Updating'
method:
netldiHost: aHostOrIp
netldiHost := aHostOrIp .
%

category: 'Updating'
method:
certificate: aCert
certificate := aCert
%

category: 'Updating'
method:
caCertificate: aCaCert
caCertificate := aCaCert
%

category: 'Updating'
method:
privateKey: aPrivateKey
privateKey := aPrivateKey
%

category: 'Updating'
method:
loginFlags: anInt
loginFlags := anInt
%

category: 'Updating'
method:
extraGemArgs: aString
extraGemArgs := aString
%


category: 'Updating'
method:
dirArg: aString
dirArg := aString
%

category: 'Updating'
method:
logArg: aString
logArg := aString
%

category: 'Initialization'
method:
initialize
 loginFlags := 0 .
 ^ self
%

category: 'Converting'
method:
createCargFromInstVar: anObj
^ (anObj isNil or:[anObj size == 0])
    ifTrue:[ CPointer newNull ]
   ifFalse:[ CByteArray withAll: anObj ]
%

category: 'Converting'
method: GemStoneX509Parameters
asGciX509LoginArg

"Answer an instance of CPointer which represents a GciX509LoginArg derived
 from the receiver."
 
| cBytes |
cBytes := CByteArray gcMalloc: 80 .
cBytes
  pointerAt:  0 put: (CByteArray withAll: netldiHost asString) ;
  pointerAt:  8 put: (CByteArray withAll: netldiPort asString) ;
  pointerAt: 16 put: (CByteArray withAll: privateKey asPemString) ;
  pointerAt: 24 put: (CByteArray withAll: certificate asPemString) ;
  pointerAt: 32 put: (CByteArray withAll: caCertificate asPemString) ;
  pointerAt: 40 put: (self createCargFromInstVar: extraGemArgs) ;
  pointerAt: 48 put: (self createCargFromInstVar: dirArg) ;
  pointerAt: 56 put: (self createCargFromInstVar: logArg) ;
    int32At: 64 put: loginFlags ;
    int32At: 68 put: 1 "argsArePemStrings" ;
    int32At: 72 put: 0 "executedSessionInit" .

^ CPointer newFrom: cBytes
%
