!=========================================================================
! Copyright (C) GemTalk Systems 2016-2020.  All Rights Reserved.
!
! $Id Message.gs 38384 2016-01-08 18:22:36Z lalmarod $
!
!   Object
!     Message
!
!=========================================================================

! ------------------- Class definition for Message
expectvalue /Class
doit
Object subclass: 'Message'
  instVarNames: #( selector args)
  classVars: #()
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()
%

! ------------------- Remove existing behavior from Message
doit
Message removeAllMethods.
Message class removeAllMethods.
true
%

doit
Message comment: 'An instance of Message represents a message, consisting of a selector and zero or more arguments.

For efficiency reasons, the system does not use instances of Message to send messages. 
However, when a message is not understood by its receiver, the system will create an instance 
of me in order to capture the information involved in an actual message transmission. 
This instance is sent it as an argument with the message doesNotUnderstand: to the receiver 
of the original message.'.
true
%
set compile_env: 0
! ------------------- Class methods for Message
category: 'instance creation'
classmethod: Message
selector: aSymbol
	"Answer an instance of me with unary selector, aSymbol."

	^self new setSelector: aSymbol arguments: { } 
%
category: 'instance creation'
classmethod: Message
selector: aSymbol argument: anObject 
	"Answer an instance of me whose selector is aSymbol and single 
	argument is anObject."

	^self new setSelector: aSymbol arguments: { anObject }
%
category: 'instance creation'
classmethod: Message
selector: aSymbol arguments: anArray 
	"Answer an instance of me with selector, aSymbol, and arguments, 
	anArray."

	^self new setSelector: aSymbol arguments: anArray
%
! ------------------- Instance methods for Message
category: 'accessing'
method: Message
argument
	"Answer the first (presumably sole) argument"

	^args at: 1
%
category: 'accessing'
method: Message
argument: newValue
	"Change the first argument to newValue and answer self"

	args at: 1 put: newValue
%
category: 'accessing'
method: Message
arguments
	"Answer the arguments of the receiver."

	^args
%
category: 'compatibility'
method: Message
asArray
	"Versions of GemStone/S prior to 64-bit version 3.4, the argument to #doesNotUnderstand: 
	was a two-element Array, rather than a Message.
	The methods in the compatibility protocol allow old code that expects an Array to continue to work."

	^
	{selector.
	args}
%
category: 'compatibility'
method: Message
at: anIndex
	"Versions of GemStone/S prior to 64-bit version 3.4, the argument to #doesNotUnderstand: 
	was a two-element Array, rather than a Message.
	The methods in the compatibility protocol allow old code that expects an Array to continue to work."

	anIndex = 1 ifTrue: [^selector].
	anIndex = 2 ifTrue: [^args].
	anIndex _isInteger
		ifTrue: [^self _errorIndexOutOfRange: anIndex]
		ifFalse: [^self _errorNonIntegerIndex: anIndex]
%
category: 'testing'
method: Message
hasArguments
	^args size > 0
%
category: 'accessing'
method: Message
numArgs
	"Answer the number of arguments in this message"

	^args size
%
category: 'printing'
method: Message
printOn: stream
	|  argsSize count |
	args isEmpty ifTrue: [^ stream nextPutAll: selector].
	count := argsSize := args size.
	args with: selector keywords do: [:arg :word |
		stream nextPutAll: word.
		stream space.
		arg printOn: stream.
		count := count - 1.
		count > 0 ifTrue: [ stream space ].
	].
%
category: 'accessing'
method: Message
selector
	"Answer the selector of the receiver."

	^selector
%
category: 'accessing'
method: Message
sends: aSelector
	"answer whether this message's selector is aSelector"

	^selector == aSelector
%
category: 'sending'
method: Message
sendTo: receiver
	"answer the result of sending this message to receiver"

	^ receiver perform: selector withArguments: args
%
category: 'private'
method: Message
setSelector: aSymbol

	selector := aSymbol.
%
category: 'private'
method: Message
setSelector: aSymbol arguments: anArray

	selector := aSymbol.
	args := anArray
%
category: 'compatibility'
method: Message
size
	"Versions of GemStone/S prior to 64-bit version 3.4, the argument to #doesNotUnderstand: 
	was a two-element Array, rather than a Message.
	The methods in the compatibility protocol allow old code that expects an Array to continue to work."

	^2
%
