!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Definition of TimeZone (from TimeZone2007.gs)
!
! Methods that exist only in latest version
!
!=========================================================================

set class TimeZone

category: 'internal'
method: TimeZone
initializeCache

	dstStartTimeList := IntegerKeyValueDictionary new.
	dstEndTimeList := IntegerKeyValueDictionary new.
	self 
		populateCacheFor: (1950 to: 2050);
		_yearStartDst;
		_secondsForDst;
		_secondsFromGmt;
		yourself.
%
category: 'obsolete accessors'
method: TimeZone
secondsForDst

	^secondsForDst
%
category: 'obsolete accessors'
method: TimeZone
_secondsForDst
	"calculate and save in cache"
	
	| isDST isNotDST |
	isDST := self detectLastTransition: [:each | each isDST].
	isDST == nil ifTrue: [^secondsForDst := 0].
	isNotDST := self detectLastTransition: [:each | each isDST not].
	isNotDST == nil ifTrue: [^secondsForDst := 0].
	^secondsForDst := isDST offsetFromUTC - isNotDST offsetFromUTC.
%
category: 'obsolete accessors'
method: TimeZone
secondsFromGmt

	^secondsFromGmt
%
category: 'obsolete accessors'
method: TimeZone
_secondsFromGmt
	"calculate and save in cache"
	
	| transition |
	transition := self detectLastTransition: [:each | each isDST not].
	^secondsFromGmt := transition == nil
		ifTrue: [0]
		ifFalse: [transition offsetFromUTC].
%
category: 'obsolete accessors'
method: TimeZone
yearStartDst
	
	^yearStartDst
%
category: 'obsolete accessors'
method: TimeZone
_yearStartDst
	"calculate and save in cache"
	
	| transition |
	transition := transitions 
		detect: [:each | each isDST]
		ifNone: [nil].
	^yearStartDst := transition 
		ifNil: [SmallInteger maximumValue]
		ifNotNil: [transition asDateAndTimeUTC year].
%
category: 'Instance Migration'
method: TimeZone
migrateFrom: anotherObject instVarMap: otherivi

	super migrateFrom: anotherObject instVarMap: otherivi.
	self 
		_yearStartDst;
		_secondsForDst;
		_secondsFromGmt;
		yourself.
%
