!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   TransactionBoundaryDefaultPolicy, Object
!
!=========================================================================

expectvalue %String
doit
| oldCls newCls |
oldCls := Globals at:#TransactionBoundaryDefaultPolicy otherwise: nil .
oldCls == nil ifTrue:[
Object _newKernelSubclass: #TransactionBoundaryDefaultPolicy
  instVarNames: #()  
  classVars: #( Current)  
  classInstVars: #()  
  poolDictionaries: { }  
  inDictionary: Globals  
  options: #() 
  reservedOop: nil.
  (Globals at:#TransactionBoundaryDefaultPolicy) category: 'Transaction-Boundaries'.
  "move the association for Current into GsObjectSecurityPolicy 0"
  ((Globals at:#TransactionBoundaryDefaultPolicy) _classVars associationAt: #Current) objectSecurityPolicy: nil.
  newCls := (Globals at:#TransactionBoundaryDefaultPolicy) .
  ^ 'created new class: ' , newCls definition
] ifFalse:[
  ^ 'existing class: ' , oldCls definition
]
%

! Remove existing behavior from TransactionBoundaryDefaultPolicy
doit
TransactionBoundaryDefaultPolicy removeAllMethods.
TransactionBoundaryDefaultPolicy class removeAllMethods.
true
%
! ------------------- Class methods for TransactionBoundaryDefaultPolicy
category: 'accessing'
classmethod: TransactionBoundaryDefaultPolicy
current

	Current == nil ifTrue: [ Current := self basicNew initialize ].
	^Current
%
category: 'installation'
classmethod: TransactionBoundaryDefaultPolicy
installCurrent

    System _commitCoordinator: self current.
    ^self current
%
category: 'installation'
classmethod: TransactionBoundaryDefaultPolicy
install

    Current := nil.
    ^self installCurrent
%
category: 'installation'
classmethod: TransactionBoundaryDefaultPolicy
uninstall

    Current := nil.
%
category: 'testing'
classmethod: TransactionBoundaryDefaultPolicy
isActive

    ^(Current ~~ nil) and: [Current isActive]
%
! ------------------- Instance methods for TransactionBoundaryDefaultPolicy
category: 'testing'
method: TransactionBoundaryDefaultPolicy
isActive

    ^true
%
category: 'updating'
method: TransactionBoundaryDefaultPolicy
classChanged
	"by default do nothing"
%
category: 'updating'
method: TransactionBoundaryDefaultPolicy
sessionMethodChanged
	"by default do nothing"
%
category: 'initialization'
method: TransactionBoundaryDefaultPolicy
initialize
	"by default do nothing"
%
category: 'private-actions'
method: TransactionBoundaryDefaultPolicy
transactionBoundary: transactionSymbol
	"by default do nothing"
%
category: 'commit coordinator'
method: TransactionBoundaryDefaultPolicy
abort
    | res |
    res := System _localAbort.
    self transactionBoundary: #abort.
    ^res
%
category: 'commit coordinator'
method: TransactionBoundaryDefaultPolicy
beginTransaction
    | res |
    res := System _localBeginTransaction.
    self transactionBoundary: #beginTransaction.
    ^res
%
category: 'commit coordinator'
method: TransactionBoundaryDefaultPolicy
commit: commitMode
    | res |
    (res := System _localCommit: commitMode)
        ifTrue: [ self transactionBoundary: #commit ].
    ^res
%
category: 'commit coordinator'
method: TransactionBoundaryDefaultPolicy
transactionMode: newMode
    | res |
    res := System _localTransactionMode: newMode.
    self transactionBoundary: #transactionMode.
    ^res
%
